import subprocess
import threading
import time
from machetli import pddl, tools

# Assumes print timeouts in search are enabled

MAX_ELAPSED = 15
PROCESS_TIMEOUT = 30 
LOG_FILE = "tmp.log"
H_MAX_VAL = 2147483647

domain = "../../htg-domains/blocksworld-large-simple/goal-2/domain.pddl"
instance = "../../htg-domains/blocksworld-large-simple/goal-3/p-100-3.pddl"

# Define the command you want to run
def get_cmd(domain, instance, heur):
    return [
        "python3",
        "powerlifted.py",
        "-d",
        domain,
        "-i",
        instance,
        "-s",
        "gbfs",
        "-e", 
        heur,
        "-g",
        "yannakakis"
    ]

def call_cmd(domain, instance, heur, time_scale=1):
    with open(LOG_FILE, "w") as file:
        try:
            code = subprocess.call(get_cmd(domain, instance, heur), stdout=file, stderr=file, timeout=PROCESS_TIMEOUT*time_scale)
        except subprocess.TimeoutExpired:
            return -1
    return code

def check_times_out(domain, instance):
    # some value is infty
    ret_code = call_cmd(domain, instance, "add", 3)
    if ret_code != 0 and ret_code != -1:
        print("Ret code for hadd was", ret_code)
        with open(LOG_FILE, "r") as file:
            print("Log is", file.read())
        return False
    with open(LOG_FILE, "r") as file:
        for l in file:
            l = l.strip().strip('\x00')
            #print(l)
            if "h-val is: " in l:
                #print(l)
                l = l[len("h-val is: "):].strip()
                #print(l)
                #print(l.split(" "))
                if int(l.split(" ")[0]) == H_MAX_VAL:
                    print("Infty value spotted")
                    return False

    ret_code = call_cmd(domain, instance, "regr-add")
    if ret_code != -1:
        print("Ret code for lr-hadd was", ret_code)
        with open(LOG_FILE, "r") as file:
            print("Log is", file.read())
        return False
    times = []
    with open(LOG_FILE, "r") as file:
        for l in file:
            l = l.strip()
            if "- time: " in l:
                times.append(float(l.split("- time: ")[1]))

    print("Last time seen", times[-1], "Timeout", PROCESS_TIMEOUT)
    return PROCESS_TIMEOUT - times[-1] > MAX_ELAPSED


def evaluate(state):
    with pddl.temporary_files(state) as (domain_filename, problem_filename):
        ret = check_times_out(domain_filename, problem_filename)
        print("Times out result", ret)
        return ret

if __name__ == "__main__":
    print("Starting")
    print(check_times_out(domain, instance))
    print("End")