// -----------------------------------------------------------------------------
// This file was autogenerated by symforce from template:
//     function/FUNCTION.h.jinja
// Do NOT modify by hand.
// -----------------------------------------------------------------------------

#pragma once

#include <matrix/math.hpp>

namespace sym {

/**
 * This function was autogenerated from a symbolic function. Do not modify by hand.
 *
 * Symbolic function: yaw_est_predict_covariance
 *
 * Args:
 *     state: Matrix31
 *     P: Matrix33
 *     d_vel: Matrix21
 *     d_vel_var: Scalar
 *     d_ang: Scalar
 *     d_ang_var: Scalar
 *
 * Outputs:
 *     res: Matrix33
 */
template <typename Scalar>
matrix::Matrix<Scalar, 3, 3> YawEstPredictCovariance(const matrix::Matrix<Scalar, 3, 1>& state,
                                                    const matrix::Matrix<Scalar, 3, 3>& P,
                                                    const matrix::Matrix<Scalar, 2, 1>& d_vel,
                                                    const Scalar d_vel_var, const Scalar d_ang,
                                                    const Scalar d_ang_var) {
  // Total ops: 39

  // Input arrays

  // Intermediate terms (8)
  const Scalar _tmp0 = std::cos(state(2, 0));
  const Scalar _tmp1 = std::sin(state(2, 0));
  const Scalar _tmp2 = -_tmp0 * d_vel(1, 0) - _tmp1 * d_vel(0, 0);
  const Scalar _tmp3 = P(0, 2) + P(2, 2) * _tmp2;
  const Scalar _tmp4 =
      std::pow(_tmp0, Scalar(2)) * d_vel_var + std::pow(_tmp1, Scalar(2)) * d_vel_var;
  const Scalar _tmp5 = _tmp0 * d_vel(0, 0) - _tmp1 * d_vel(1, 0);
  const Scalar _tmp6 = P(1, 2) + P(2, 2) * _tmp5;
  const Scalar _tmp7 = std::pow(d_ang, Scalar(2)) + 1;

  // Output terms (1)
  matrix::Matrix<Scalar, 3, 3> _res;

  _res.setZero();

  _res(0, 0) = P(0, 0) + P(2, 0) * _tmp2 + _tmp2 * _tmp3 + _tmp4;
  _res(0, 1) = P(0, 1) + P(2, 1) * _tmp2 + _tmp3 * _tmp5;
  _res(1, 1) = P(1, 1) + P(2, 1) * _tmp5 + _tmp4 + _tmp5 * _tmp6;
  _res(0, 2) = _tmp3 * _tmp7;
  _res(1, 2) = _tmp6 * _tmp7;
  _res(2, 2) = P(2, 2) * std::pow(_tmp7, Scalar(2)) + d_ang_var;

  return _res;
}  // NOLINT(readability/fn_size)

// NOLINTNEXTLINE(readability/fn_size)
}  // namespace sym
