/****************************************************************************
 *
 *   Copyright (c) 2020-2023 PX4 Development Team. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name PX4 nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include <gtest/gtest.h>
#include <math.h>
#include <mathlib/mathlib.h>

#include "geo_mag_declination.h"


TEST(GeoLookupTest, declination)
{
	EXPECT_NEAR(get_mag_declination_degrees(-50, -180), 31.7, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -175), 31.8, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -170), 31.8, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -165), 31.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -160), 31.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -155), 31.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -150), 30.9, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -145), 30.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -140), 30.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -135), 30.3, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -130), 30.2, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -125), 30.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -120), 30.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -115), 29.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -110), 29.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -105), 28.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -100), 27.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -95), 25.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -90), 23.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -85), 20.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -80), 17.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -75), 14.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -70), 10.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -65), 6.4, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -60), 2.6, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -55), -1.0, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -50), -4.1, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -45), -6.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -40), -9.0, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -35), -10.7, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -30), -12.1, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -25), -13.2, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -20), -14.3, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -15), -15.4, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -10), -16.8, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, -5), -18.6, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 0), -20.9, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 5), -23.7, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 10), -26.9, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 15), -30.4, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 20), -34.2, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 25), -37.9, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 30), -41.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 35), -45.0, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 40), -48.1, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 45), -50.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 50), -53.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 55), -55.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 60), -56.6, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 65), -57.5, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 70), -57.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 75), -57.7, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 80), -56.7, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 85), -54.9, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 90), -52.3, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 95), -48.5, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 100), -43.5, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 105), -37.3, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 110), -29.9, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 115), -21.7, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 120), -13.3, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 125), -5.0, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 130), 2.5, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 135), 9.1, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 140), 14.6, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 145), 19.1, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 150), 22.8, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 155), 25.6, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 160), 27.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 165), 29.4, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 170), 30.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 175), 31.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-50, 180), 31.7, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -180), 26.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -175), 27.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -170), 27.1, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -165), 27.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -160), 27.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -155), 26.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -150), 26.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -145), 26.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -140), 26.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -135), 26.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -130), 26.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -125), 26.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -120), 26.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -115), 26.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -110), 25.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -105), 25.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -100), 24.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -95), 22.9, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -90), 20.9, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -85), 18.2, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -80), 15.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -75), 11.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -70), 7.1, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -65), 2.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -60), -1.2, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -55), -5.1, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -50), -8.4, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -45), -11.1, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -40), -13.3, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -35), -14.9, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -30), -16.0, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -25), -16.8, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -20), -17.4, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -15), -18.0, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -10), -18.7, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, -5), -19.8, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 0), -21.4, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 5), -23.7, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 10), -26.5, 0.56 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 15), -29.7, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 20), -33.2, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 25), -36.8, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 30), -40.2, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 35), -43.3, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 40), -46.0, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 45), -48.3, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 50), -50.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 55), -51.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 60), -52.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 65), -52.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 70), -51.3, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 75), -49.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 80), -47.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 85), -44.7, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 90), -40.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 95), -36.0, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 100), -30.5, 0.47 + 1.8);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 105), -24.5, 0.48 + 1.8);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 110), -18.3, 0.48 + 1.8);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 115), -12.2, 0.48 + 1.8);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 120), -6.4, 0.47 + 1.8);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 125), -1.0, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 130), 3.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 135), 8.2, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 140), 12.1, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 145), 15.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 150), 18.3, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 155), 20.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 160), 22.7, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 165), 24.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 170), 25.3, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 175), 26.1, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-45, 180), 26.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -180), 22.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -175), 23.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -170), 23.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -165), 23.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -160), 23.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -155), 23.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -150), 23.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -145), 22.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -140), 22.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -135), 22.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -130), 22.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -125), 22.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -120), 22.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -115), 22.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -110), 22.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -105), 22.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -100), 21.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -95), 20.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -90), 18.2, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -85), 15.6, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -80), 12.3, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -75), 8.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -70), 4.0, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -65), -0.6, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -60), -5.0, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -55), -9.0, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -50), -12.4, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -45), -15.1, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -40), -17.2, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -35), -18.6, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -30), -19.6, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -25), -20.2, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -20), -20.5, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -15), -20.7, 0.60 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -10), -20.8, 0.62 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, -5), -21.1, 0.63 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 0), -21.9, 0.63 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 5), -23.3, 0.62 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 10), -25.4, 0.61 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 15), -28.2, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 20), -31.3, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 25), -34.5, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 30), -37.6, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 35), -40.3, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 40), -42.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 45), -44.4, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 50), -45.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 55), -46.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 60), -46.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 65), -45.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 70), -43.8, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 75), -41.5, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 80), -38.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 85), -34.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 90), -30.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 95), -25.8, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 100), -20.8, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 105), -15.8, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 110), -11.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 115), -6.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 120), -2.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 125), 0.9, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 130), 4.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 135), 7.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 140), 10.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 145), 12.8, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 150), 15.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 155), 17.3, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 160), 19.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 165), 20.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 170), 21.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 175), 22.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-40, 180), 22.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -180), 19.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -175), 20.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -170), 20.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -165), 20.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -160), 20.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -155), 20.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -150), 20.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -145), 20.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -140), 19.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -135), 19.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -130), 19.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -125), 19.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -120), 19.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -115), 19.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -110), 19.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -105), 18.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -100), 18.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -95), 17.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -90), 15.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -85), 12.9, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -80), 9.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -75), 5.4, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -70), 0.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -65), -3.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -60), -8.4, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -55), -12.4, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -50), -15.8, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -45), -18.4, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -40), -20.3, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -35), -21.6, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -30), -22.5, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -25), -22.9, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -20), -23.1, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -15), -22.9, 0.60 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -10), -22.5, 0.63 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, -5), -22.1, 0.65 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 0), -21.8, 0.66 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 5), -22.2, 0.66 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 10), -23.3, 0.64 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 15), -25.2, 0.61 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 20), -27.7, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 25), -30.4, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 30), -33.1, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 35), -35.5, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 40), -37.4, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 45), -38.8, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 50), -39.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 55), -39.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 60), -39.1, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 65), -37.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 70), -35.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 75), -33.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 80), -29.9, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 85), -26.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 90), -22.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 95), -17.9, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 100), -13.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 105), -9.9, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 110), -6.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 115), -3.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 120), -0.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 125), 1.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 130), 4.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 135), 6.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 140), 8.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 145), 10.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 150), 12.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 155), 14.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 160), 16.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 165), 17.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 170), 18.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 175), 19.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-35, 180), 19.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -180), 17.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -175), 17.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -170), 17.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -165), 17.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -160), 17.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -155), 17.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -150), 17.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -145), 17.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -140), 17.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -135), 17.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -130), 16.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -125), 16.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -120), 16.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -115), 16.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -110), 16.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -105), 16.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -100), 15.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -95), 14.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -90), 12.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -85), 10.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -80), 6.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -75), 2.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -70), -2.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -65), -6.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -60), -11.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -55), -15.2, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -50), -18.3, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -45), -20.7, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -40), -22.4, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -35), -23.5, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -30), -24.2, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -25), -24.6, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -20), -24.5, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -15), -24.1, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -10), -23.2, 0.60 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, -5), -21.9, 0.63 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 0), -20.7, 0.64 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 5), -19.8, 0.65 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 10), -19.7, 0.64 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 15), -20.5, 0.61 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 20), -22.1, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 25), -24.3, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 30), -26.6, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 35), -28.7, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 40), -30.5, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 45), -31.8, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 50), -32.4, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 55), -32.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 60), -31.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 65), -30.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 70), -28.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 75), -25.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 80), -22.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 85), -19.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 90), -15.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 95), -12.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 100), -8.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 105), -5.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 110), -3.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 115), -1.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 120), 0.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 125), 2.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 130), 3.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 135), 5.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 140), 7.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 145), 9.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 150), 11.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 155), 12.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 160), 14.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 165), 15.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 170), 16.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 175), 16.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-30, 180), 17.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -180), 15.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -175), 15.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -170), 15.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -165), 15.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -160), 15.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -155), 15.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -150), 15.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -145), 15.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -140), 15.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -135), 15.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -130), 14.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -125), 14.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -120), 14.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -115), 14.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -110), 13.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -105), 13.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -100), 13.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -95), 12.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -90), 10.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -85), 7.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -80), 4.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -75), -0.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -70), -4.6, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -65), -9.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -60), -13.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -55), -17.2, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -50), -20.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -45), -22.2, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -40), -23.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -35), -24.5, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -30), -24.9, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -25), -24.9, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -20), -24.6, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -15), -23.7, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -10), -22.2, 0.55 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, -5), -20.3, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 0), -18.2, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 5), -16.2, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 10), -15.0, 0.58 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 15), -14.7, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 20), -15.4, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 25), -16.8, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 30), -18.7, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 35), -20.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 40), -22.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 45), -24.0, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 50), -24.7, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 55), -24.8, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 60), -24.1, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 65), -22.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 70), -21.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 75), -18.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 80), -16.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 85), -13.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 90), -10.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 95), -7.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 100), -5.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 105), -3.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 110), -1.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 115), -0.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 120), 1.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 125), 2.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 130), 3.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 135), 4.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 140), 6.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 145), 8.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 150), 9.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 155), 10.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 160), 12.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 165), 13.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 170), 14.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 175), 14.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-25, 180), 15.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -180), 13.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -175), 13.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -170), 13.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -165), 13.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -160), 13.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -155), 13.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -150), 13.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -145), 13.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -140), 13.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -135), 13.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -130), 12.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -125), 12.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -120), 12.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -115), 12.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -110), 11.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -105), 11.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -100), 11.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -95), 9.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -90), 8.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -85), 5.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -80), 1.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -75), -2.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -70), -6.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -65), -11.1, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -60), -15.1, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -55), -18.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -50), -21.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -45), -22.9, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -40), -23.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -35), -24.4, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -30), -24.4, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -25), -24.0, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -20), -23.1, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -15), -21.7, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -10), -19.7, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, -5), -17.4, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 0), -14.8, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 5), -12.3, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 10), -10.4, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 15), -9.3, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 20), -9.1, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 25), -9.9, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 30), -11.3, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 35), -13.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 40), -15.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 45), -16.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 50), -17.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 55), -18.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 60), -17.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 65), -16.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 70), -15.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 75), -13.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 80), -11.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 85), -9.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 90), -7.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 95), -4.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 100), -2.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 105), -1.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 110), -0.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 115), 0.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 120), 1.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 125), 2.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 130), 3.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 135), 4.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 140), 5.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 145), 6.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 150), 8.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 155), 9.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 160), 10.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 165), 11.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 170), 12.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 175), 13.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-20, 180), 13.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -180), 12.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -175), 12.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -170), 12.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -165), 12.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -160), 12.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -155), 12.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -150), 12.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -145), 12.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -140), 12.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -135), 11.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -130), 11.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -125), 11.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -120), 10.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -115), 10.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -110), 10.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -105), 9.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -100), 9.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -95), 8.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -90), 6.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -85), 3.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -80), 0.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -75), -4.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -70), -8.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -65), -12.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -60), -16.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -55), -19.2, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -50), -21.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -45), -22.8, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -40), -23.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -35), -23.5, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -30), -23.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -25), -22.0, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -20), -20.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -15), -18.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -10), -16.5, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, -5), -13.9, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 0), -11.3, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 5), -8.8, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 10), -6.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 15), -5.2, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 20), -4.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 25), -4.7, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 30), -5.7, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 35), -7.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 40), -9.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 45), -10.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 50), -11.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 55), -12.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 60), -12.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 65), -12.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 70), -11.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 75), -10.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 80), -8.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 85), -6.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 90), -4.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 95), -3.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 100), -1.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 105), -0.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 110), 0.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 115), 0.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 120), 1.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 125), 1.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 130), 2.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 135), 3.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 140), 4.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 145), 6.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 150), 7.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 155), 8.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 160), 9.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 165), 10.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 170), 11.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 175), 12.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-15, 180), 12.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -180), 11.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -175), 11.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -170), 11.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -165), 11.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -160), 11.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -155), 11.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -150), 11.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -145), 10.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -140), 10.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -135), 10.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -130), 10.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -125), 9.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -120), 9.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -115), 9.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -110), 9.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -105), 8.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -100), 8.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -95), 6.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -90), 4.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -85), 2.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -80), -1.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -75), -5.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -70), -9.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -65), -13.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -60), -16.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -55), -19.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -50), -21.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -45), -22.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -40), -22.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -35), -22.1, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -30), -21.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -25), -19.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -20), -17.6, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -15), -15.4, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -10), -13.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, -5), -10.6, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 0), -8.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 5), -6.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 10), -4.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 15), -2.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 20), -1.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 25), -1.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 30), -1.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 35), -3.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 40), -4.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 45), -6.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 50), -7.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 55), -8.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 60), -8.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 65), -8.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 70), -8.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 75), -7.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 80), -6.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 85), -4.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 90), -3.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 95), -1.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 100), -0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 105), 0.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 110), 0.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 115), 0.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 120), 0.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 125), 1.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 130), 1.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 135), 2.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 140), 3.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 145), 5.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 150), 6.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 155), 7.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 160), 8.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 165), 9.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 170), 10.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 175), 11.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-10, 180), 11.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -180), 10.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -175), 10.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -170), 10.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -165), 10.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -160), 10.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -155), 10.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -150), 10.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -145), 10.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -140), 9.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -135), 9.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -130), 9.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -125), 9.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -120), 8.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -115), 8.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -110), 8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -105), 7.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -100), 6.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -95), 5.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -90), 3.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -85), 0.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -80), -2.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -75), -6.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -70), -10.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -65), -13.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -60), -16.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -55), -19.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -50), -20.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -45), -21.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -40), -21.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -35), -20.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -30), -18.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -25), -16.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -20), -14.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -15), -12.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -10), -10.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, -5), -7.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 0), -5.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 5), -3.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 10), -2.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 15), -0.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 20), 0.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 25), 0.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 30), 0.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 35), -0.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 40), -1.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 45), -3.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 50), -4.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 55), -5.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 60), -5.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 65), -5.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 70), -5.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 75), -5.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 80), -4.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 85), -3.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 90), -2.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 95), -1.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 100), -0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 105), 0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 110), 0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 115), 0.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 120), 0.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 125), 0.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 130), 1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 135), 1.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 140), 3.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 145), 4.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 150), 5.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 155), 7.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 160), 8.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 165), 9.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 170), 9.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 175), 10.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(-5, 180), 10.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -180), 10.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -175), 10.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -170), 9.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -165), 9.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -160), 9.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -155), 9.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -150), 9.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -145), 9.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -140), 9.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -135), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -130), 8.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -125), 8.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -120), 8.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -115), 7.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -110), 7.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -105), 6.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -100), 6.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -95), 4.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -90), 2.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -85), -0.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -80), -3.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -75), -7.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -70), -10.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -65), -13.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -60), -16.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -55), -18.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -50), -19.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -45), -20.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -40), -19.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -35), -18.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -30), -16.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -25), -14.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -20), -12.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -15), -9.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -10), -7.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, -5), -5.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 0), -3.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 5), -2.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 10), -0.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 15), 0.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 20), 1.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 25), 1.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 30), 1.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 35), 1.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 40), 0.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 45), -1.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 50), -2.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 55), -3.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 60), -3.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 65), -3.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 70), -3.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 75), -3.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 80), -3.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 85), -2.7, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 90), -1.8, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 95), -1.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 100), -0.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 105), 0.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 110), 0.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 115), -0.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 120), -0.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 125), -0.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 130), 0.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 135), 1.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 140), 2.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 145), 3.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 150), 4.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 155), 6.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 160), 7.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 165), 8.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 170), 9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 175), 9.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(0, 180), 10.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -180), 9.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -175), 9.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -170), 9.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -165), 9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -160), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -155), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -150), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -145), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -140), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -135), 8.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -130), 8.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -125), 8.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -120), 8.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -115), 7.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -110), 7.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -105), 6.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -100), 5.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -95), 3.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -90), 1.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -85), -1.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -80), -4.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -75), -7.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -70), -11.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -65), -13.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -60), -16.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -55), -18.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -50), -18.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -45), -18.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -40), -18.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -35), -16.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -30), -14.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -25), -12.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -20), -10.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -15), -7.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -10), -5.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, -5), -4.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 0), -2.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 5), -1.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 10), -0.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 15), 1.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 20), 2.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 25), 2.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 30), 2.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 35), 2.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 40), 1.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 45), 0.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 50), -0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 55), -1.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 60), -2.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 65), -2.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 70), -2.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 75), -2.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 80), -2.4, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 85), -2.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 90), -1.5, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 95), -0.9, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 100), -0.4, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 105), -0.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 110), -0.3, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 115), -0.7, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 120), -1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 125), -1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 130), -0.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 135), 0.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 140), 1.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 145), 2.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 150), 3.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 155), 5.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 160), 6.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 165), 7.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 170), 8.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 175), 9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(5, 180), 9.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -180), 9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -175), 9.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -170), 9.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -165), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -160), 9.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -155), 9.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -150), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -145), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -140), 9.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -135), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -130), 8.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -125), 8.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -120), 8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -115), 7.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -110), 6.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -105), 6.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -100), 4.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -95), 3.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -90), 0.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -85), -2.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -80), -5.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -75), -8.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -70), -11.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -65), -13.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -60), -16.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -55), -17.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -50), -17.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -45), -17.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -40), -16.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -35), -14.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -30), -12.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -25), -10.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -20), -8.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -15), -6.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -10), -4.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, -5), -2.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 0), -1.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 5), -0.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 10), 0.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 15), 1.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 20), 2.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 25), 3.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 30), 3.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 35), 3.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 40), 2.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 45), 1.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 50), 0.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 55), -0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 60), -0.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 65), -1.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 70), -1.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 75), -1.6, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 80), -1.6, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 85), -1.5, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 90), -1.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 95), -0.9, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 100), -0.7, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 105), -0.7, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 110), -1.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 115), -1.4, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 120), -1.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 125), -2.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 130), -1.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 135), -1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 140), 0.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 145), 1.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 150), 2.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 155), 4.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 160), 5.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 165), 6.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 170), 8.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 175), 8.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(10, 180), 9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -180), 8.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -175), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -170), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -165), 9.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -160), 9.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -155), 9.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -150), 9.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -145), 9.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -140), 9.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -135), 9.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -130), 9.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -125), 9.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -120), 8.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -115), 7.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -110), 7.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -105), 5.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -100), 4.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -95), 2.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -90), -0.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -85), -2.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -80), -5.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -75), -8.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -70), -11.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -65), -13.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -60), -15.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -55), -16.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -50), -16.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -45), -16.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -40), -15.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -35), -13.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -30), -11.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -25), -9.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -20), -7.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -15), -5.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -10), -3.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, -5), -1.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 0), -0.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 5), 0.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 10), 1.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 15), 2.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 20), 2.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 25), 3.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 30), 3.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 35), 3.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 40), 3.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 45), 2.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 50), 1.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 55), 0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 60), 0.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 65), -0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 70), -0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 75), -0.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 80), -1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 85), -1.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 90), -1.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 95), -0.9, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 100), -1.0, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 105), -1.2, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 110), -1.7, 0.29 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 115), -2.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 120), -2.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 125), -3.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 130), -2.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 135), -2.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 140), -1.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 145), 0.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 150), 1.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 155), 2.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 160), 4.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 165), 5.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 170), 7.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 175), 8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(15, 180), 8.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -180), 8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -175), 8.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -170), 9.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -165), 9.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -160), 9.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -155), 9.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -150), 9.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -145), 10.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -140), 10.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -135), 10.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -130), 10.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -125), 9.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -120), 9.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -115), 8.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -110), 7.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -105), 6.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -100), 4.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -95), 2.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -90), -0.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -85), -3.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -80), -6.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -75), -9.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -70), -12.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -65), -14.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -60), -15.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -55), -15.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -50), -15.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -45), -15.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -40), -13.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -35), -12.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -30), -10.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -25), -8.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -20), -6.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -15), -4.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -10), -2.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, -5), -1.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 0), 0.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 5), 1.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 10), 1.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 15), 2.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 20), 3.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 25), 3.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 30), 4.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 35), 4.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 40), 3.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 45), 2.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 50), 2.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 55), 1.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 60), 1.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 65), 0.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 70), 0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 75), -0.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 80), -0.3, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 85), -0.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 90), -0.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 95), -0.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 100), -1.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 105), -1.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 110), -2.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 115), -3.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 120), -3.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 125), -4.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 130), -4.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 135), -3.6, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 140), -2.7, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 145), -1.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 150), -0.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 155), 1.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 160), 3.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 165), 4.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 170), 6.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 175), 7.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(20, 180), 8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -180), 7.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -175), 8.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -170), 8.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -165), 9.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -160), 9.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -155), 10.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -150), 10.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -145), 10.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -140), 11.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -135), 11.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -130), 11.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -125), 10.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -120), 10.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -115), 9.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -110), 7.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -105), 6.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -100), 4.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -95), 1.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -90), -1.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -85), -4.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -80), -7.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -75), -10.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -70), -12.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -65), -14.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -60), -15.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -55), -15.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -50), -15.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -45), -14.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -40), -12.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -35), -11.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -30), -9.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -25), -7.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -20), -5.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -15), -3.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -10), -2.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, -5), -0.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 0), 0.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 5), 1.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 10), 2.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 15), 3.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 20), 3.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 25), 4.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 30), 4.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 35), 4.4, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 40), 4.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 45), 3.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 50), 2.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 55), 2.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 60), 1.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 65), 1.5, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 70), 1.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 75), 0.8, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 80), 0.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 85), 0.0, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 90), -0.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 95), -0.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 100), -1.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 105), -2.2, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 110), -3.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 115), -4.1, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 120), -4.9, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 125), -5.4, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 130), -5.5, 0.30 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 135), -5.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 140), -4.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 145), -3.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 150), -1.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 155), -0.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 160), 1.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 165), 3.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 170), 4.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 175), 6.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(25, 180), 7.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -180), 6.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -175), 7.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -170), 8.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -165), 9.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -160), 9.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -155), 10.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -150), 11.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -145), 11.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -140), 12.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -135), 12.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -130), 12.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -125), 11.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -120), 11.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -115), 10.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -110), 8.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -105), 6.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -100), 4.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -95), 1.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -90), -1.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -85), -4.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -80), -7.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -75), -10.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -70), -12.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -65), -14.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -60), -15.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -55), -15.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -50), -14.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -45), -13.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -40), -12.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -35), -10.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -30), -8.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -25), -7.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -20), -5.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -15), -3.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -10), -1.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, -5), -0.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 0), 1.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 5), 1.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 10), 2.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 15), 3.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 20), 4.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 25), 4.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 30), 4.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 35), 4.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 40), 4.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 45), 4.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 50), 3.8, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 55), 3.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 60), 3.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 65), 2.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 70), 2.2, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 75), 1.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 80), 1.3, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 85), 0.6, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 90), -0.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 95), -0.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 100), -1.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 105), -2.8, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 110), -3.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 115), -5.1, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 120), -6.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 125), -6.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 130), -6.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 135), -6.7, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 140), -6.0, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 145), -4.9, 0.31 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 150), -3.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 155), -1.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 160), -0.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 165), 1.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 170), 3.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 175), 4.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(30, 180), 6.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -180), 5.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -175), 6.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -170), 8.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -165), 9.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -160), 10.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -155), 11.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -150), 11.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -145), 12.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -140), 13.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -135), 13.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -130), 13.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -125), 12.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -120), 12.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -115), 10.9, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -110), 9.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -105), 7.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -100), 4.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -95), 1.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -90), -1.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -85), -5.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -80), -8.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -75), -11.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -70), -13.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -65), -14.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -60), -15.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -55), -15.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -50), -14.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -45), -13.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -40), -12.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -35), -10.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -30), -8.7, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -25), -6.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -20), -5.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -15), -3.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -10), -1.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, -5), 0.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 0), 1.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 5), 2.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 10), 3.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 15), 3.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 20), 4.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 25), 5.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 30), 5.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 35), 5.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 40), 5.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 45), 5.3, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 50), 5.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 55), 4.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 60), 4.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 65), 3.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 70), 3.5, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 75), 3.0, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 80), 2.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 85), 1.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 90), 0.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 95), -0.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 100), -1.9, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 105), -3.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 110), -4.7, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 115), -6.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 120), -7.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 125), -8.1, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 130), -8.4, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 135), -8.3, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 140), -7.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 145), -6.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 150), -5.2, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 155), -3.6, 0.32 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 160), -1.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 165), 0.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 170), 1.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 175), 3.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(35, 180), 5.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -180), 4.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -175), 5.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -170), 7.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -165), 9.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -160), 10.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -155), 11.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -150), 12.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -145), 13.5, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -140), 14.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -135), 14.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -130), 14.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -125), 13.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -120), 13.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -115), 11.8, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -110), 10.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -105), 7.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -100), 4.8, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -95), 1.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -90), -2.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -85), -5.8, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -80), -9.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -75), -12.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -70), -14.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -65), -15.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -60), -15.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -55), -15.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -50), -14.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -45), -13.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -40), -12.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -35), -10.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -30), -8.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -25), -7.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -20), -5.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -15), -3.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -10), -1.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, -5), 0.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 0), 1.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 5), 2.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 10), 3.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 15), 4.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 20), 5.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 25), 5.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 30), 6.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 35), 6.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 40), 6.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 45), 6.6, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 50), 6.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 55), 6.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 60), 6.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 65), 5.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 70), 5.1, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 75), 4.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 80), 3.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 85), 2.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 90), 1.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 95), -0.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 100), -2.1, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 105), -3.9, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 110), -5.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 115), -7.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 120), -8.6, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 125), -9.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 130), -10.0, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 135), -9.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 140), -9.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 145), -8.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 150), -6.8, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 155), -5.2, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 160), -3.4, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 165), -1.5, 0.33 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 170), 0.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 175), 2.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(40, 180), 4.2, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -180), 3.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -175), 5.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -170), 7.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -165), 8.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -160), 10.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -155), 12.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -150), 13.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -145), 14.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -140), 15.0, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -135), 15.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -130), 15.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -125), 15.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -120), 14.1, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -115), 12.7, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -110), 10.7, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -105), 8.1, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -100), 5.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -95), 1.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -90), -2.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -85), -6.6, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -80), -10.1, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -75), -13.0, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -70), -15.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -65), -16.3, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -60), -16.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -55), -16.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -50), -15.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -45), -14.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -40), -13.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -35), -11.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -30), -9.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -25), -7.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -20), -5.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -15), -3.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -10), -1.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, -5), -0.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 0), 1.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 5), 2.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 10), 3.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 15), 4.7, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 20), 5.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 25), 6.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 30), 7.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 35), 7.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 40), 8.0, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 45), 8.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 50), 8.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 55), 8.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 60), 8.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 65), 7.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 70), 7.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 75), 6.3, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 80), 5.1, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 85), 3.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 90), 1.8, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 95), -0.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 100), -2.3, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 105), -4.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 110), -6.6, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 115), -8.4, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 120), -10.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 125), -11.0, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 130), -11.5, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 135), -11.4, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 140), -10.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 145), -9.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 150), -8.3, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 155), -6.7, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 160), -4.8, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 165), -2.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 170), -0.9, 0.34 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 175), 1.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(45, 180), 3.2, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -180), 2.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -175), 4.5, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -170), 6.6, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -165), 8.7, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -160), 10.6, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -155), 12.3, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -150), 13.8, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -145), 15.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -140), 15.9, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -135), 16.4, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -130), 16.5, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -125), 16.2, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -120), 15.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -115), 13.7, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -110), 11.5, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -105), 8.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -100), 5.1, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -95), 1.0, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -90), -3.4, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -85), -7.6, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -80), -11.4, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -75), -14.4, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -70), -16.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -65), -17.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -60), -18.1, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -55), -17.8, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -50), -17.0, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -45), -15.8, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -40), -14.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -35), -12.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -30), -10.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -25), -8.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -20), -6.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -15), -4.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -10), -2.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, -5), -0.6, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 0), 1.1, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 5), 2.6, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 10), 3.9, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 15), 5.2, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 20), 6.3, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 25), 7.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 30), 8.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 35), 9.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 40), 9.8, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 45), 10.4, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 50), 10.8, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 55), 10.9, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 60), 10.9, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 65), 10.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 70), 9.7, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 75), 8.6, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 80), 7.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 85), 5.1, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 90), 2.9, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 95), 0.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 100), -2.3, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 105), -5.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 110), -7.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 115), -9.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 120), -11.4, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 125), -12.5, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 130), -12.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 135), -12.8, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 140), -12.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 145), -11.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 150), -9.7, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 155), -8.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 160), -6.1, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 165), -4.0, 0.35 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 170), -1.9, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 175), 0.2, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(50, 180), 2.4, 0.36 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -180), 1.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -175), 4.0, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -170), 6.3, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -165), 8.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -160), 10.6, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -155), 12.5, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -150), 14.2, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -145), 15.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -140), 16.8, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -135), 17.5, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -130), 17.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -125), 17.4, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -120), 16.5, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -115), 14.8, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -110), 12.4, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -105), 9.1, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -100), 5.0, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -95), 0.4, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -90), -4.5, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -85), -9.2, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -80), -13.2, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -75), -16.4, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -70), -18.6, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -65), -19.8, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -60), -20.2, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -55), -19.8, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -50), -18.9, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -45), -17.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -40), -15.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -35), -14.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -30), -12.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -25), -9.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -20), -7.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -15), -5.5, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -10), -3.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, -5), -1.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 0), 0.6, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 5), 2.4, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 10), 4.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 15), 5.7, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 20), 7.2, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 25), 8.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 30), 9.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 35), 11.1, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 40), 12.2, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 45), 13.1, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 50), 13.7, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 55), 14.1, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 60), 14.1, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 65), 13.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 70), 12.9, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 75), 11.5, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 80), 9.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 85), 7.2, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 90), 4.3, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 95), 1.1, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 100), -2.2, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 105), -5.5, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 110), -8.5, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 115), -10.9, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 120), -12.8, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 125), -13.9, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 130), -14.4, 0.40 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 135), -14.2, 0.39 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 140), -13.5, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 145), -12.4, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 150), -10.9, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 155), -9.1, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 160), -7.2, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 165), -5.1, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 170), -2.9, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 175), -0.6, 0.37 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(55, 180), 1.7, 0.38 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -180), 1.1, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -175), 3.5, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -170), 5.9, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -165), 8.3, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -160), 10.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -155), 12.7, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -150), 14.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -145), 16.2, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -140), 17.5, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -135), 18.4, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -130), 18.8, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -125), 18.6, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -120), 17.7, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -115), 15.9, 0.57 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -110), 13.1, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -105), 9.4, 0.62 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -100), 4.7, 0.64 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -95), -0.7, 0.65 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -90), -6.3, 0.65 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -85), -11.5, 0.64 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -80), -16.0, 0.61 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -75), -19.3, 0.59 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -70), -21.5, 0.56 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -65), -22.7, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -60), -22.9, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -55), -22.5, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -50), -21.5, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -45), -20.0, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -40), -18.2, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -35), -16.2, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -30), -14.0, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -25), -11.6, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -20), -9.2, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -15), -6.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -10), -4.5, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, -5), -2.1, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 0), 0.1, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 5), 2.3, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 10), 4.4, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 15), 6.4, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 20), 8.4, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 25), 10.2, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 30), 11.9, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 35), 13.6, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 40), 15.0, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 45), 16.3, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 50), 17.2, 0.47 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 55), 17.9, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 60), 18.1, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 65), 17.8, 0.49 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 70), 16.9, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 75), 15.3, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 80), 13.1, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 85), 10.1, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 90), 6.5, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 95), 2.5, 0.54 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 100), -1.7, 0.53 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 105), -5.7, 0.52 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 110), -9.3, 0.51 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 115), -12.1, 0.50 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 120), -14.1, 0.48 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 125), -15.4, 0.46 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 130), -15.8, 0.45 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 135), -15.6, 0.44 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 140), -14.9, 0.43 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 145), -13.6, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 150), -12.1, 0.42 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 155), -10.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 160), -8.2, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 165), -6.0, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 170), -3.7, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 175), -1.3, 0.41 + 1.0);
	EXPECT_NEAR(get_mag_declination_degrees(60, 180), 1.1, 0.41 + 1.0);
}

TEST(GeoLookupTest, inclination)
{
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -180), -71.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -175), -70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -170), -69.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -165), -68.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -160), -67.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -155), -66.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -150), -65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -145), -64.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -140), -64.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -135), -63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -130), -62.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -125), -60.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -120), -59.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -115), -58.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -110), -57.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -105), -55.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -100), -54.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -95), -52.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -90), -51.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -85), -49.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -80), -48.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -75), -48.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -70), -48.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -65), -48.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -60), -49.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -55), -50.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -50), -52.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -45), -53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -40), -55.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -35), -56.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -30), -58.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -25), -59.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -20), -60.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -15), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -10), -61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, -5), -61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 0), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 5), -60.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 10), -59.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 15), -59.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 20), -59.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 25), -58.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 30), -59.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 35), -59.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 40), -60.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 45), -61.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 50), -62.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 55), -64.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 60), -66.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 65), -67.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 70), -69.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 75), -71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 80), -72.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 85), -74.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 90), -75.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 95), -77.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 100), -78.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 105), -79.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 110), -80.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 115), -80.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 120), -80.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 125), -80.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 130), -80.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 135), -79.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 140), -79.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 145), -78.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 150), -77.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 155), -76.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 160), -75.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 165), -74.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 170), -73.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 175), -72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-50, 180), -71.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -180), -68.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -175), -67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -170), -66.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -165), -65.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -160), -64.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -155), -63.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -150), -62.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -145), -61.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -140), -60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -135), -59.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -130), -58.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -125), -57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -120), -56.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -115), -55.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -110), -53.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -105), -52.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -100), -50.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -95), -49.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -90), -47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -85), -46.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -80), -45.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -75), -44.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -70), -45.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -65), -45.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -60), -47.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -55), -48.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -50), -50.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -45), -52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -40), -55.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -35), -57.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -30), -58.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -25), -60.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -20), -61.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -15), -62.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -10), -63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, -5), -63.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 0), -63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 5), -62.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 10), -62.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 15), -61.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 20), -60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 25), -60.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 30), -59.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 35), -60.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 40), -60.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 45), -61.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 50), -62.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 55), -64.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 60), -65.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 65), -67.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 70), -69.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 75), -70.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 80), -72.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 85), -73.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 90), -74.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 95), -75.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 100), -76.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 105), -76.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 110), -77.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 115), -77.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 120), -77.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 125), -76.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 130), -76.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 135), -75.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 140), -75.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 145), -74.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 150), -73.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 155), -73.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 160), -72.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 165), -71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 170), -70.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 175), -69.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-45, 180), -68.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -180), -64.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -175), -63.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -170), -62.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -165), -61.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -160), -60.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -155), -59.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -150), -58.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -145), -57.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -140), -56.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -135), -55.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -130), -54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -125), -53.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -120), -52.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -115), -51.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -110), -50.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -105), -48.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -100), -47.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -95), -45.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -90), -43.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -85), -42.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -80), -41.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -75), -41.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -70), -41.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -65), -42.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -60), -44.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -55), -46.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -50), -48.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -45), -51.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -40), -54.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -35), -56.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -30), -58.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -25), -60.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -20), -62.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -15), -63.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -10), -64.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, -5), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 0), -65.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 5), -65.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 10), -64.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 15), -63.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 20), -62.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 25), -61.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 30), -60.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 35), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 40), -61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 45), -61.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 50), -62.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 55), -64.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 60), -65.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 65), -66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 70), -68.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 75), -69.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 80), -70.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 85), -71.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 90), -72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 95), -73.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 100), -73.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 105), -73.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 110), -73.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 115), -73.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 120), -73.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 125), -72.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 130), -72.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 135), -71.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 140), -71.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 145), -70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 150), -69.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 155), -69.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 160), -68.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 165), -67.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 170), -66.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 175), -65.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-40, 180), -64.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -180), -60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -175), -59.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -170), -58.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -165), -56.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -160), -55.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -155), -54.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -150), -53.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -145), -52.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -140), -51.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -135), -50.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -130), -49.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -125), -48.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -120), -47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -115), -46.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -110), -45.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -105), -44.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -100), -42.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -95), -40.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -90), -39.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -85), -37.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -80), -36.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -75), -36.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -70), -36.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -65), -38.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -60), -40.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -55), -43.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -50), -46.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -45), -49.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -40), -52.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -35), -55.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -30), -58.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -25), -60.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -20), -62.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -15), -64.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -10), -65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, -5), -66.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 0), -67.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 5), -67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 10), -66.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 15), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 20), -64.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 25), -63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 30), -62.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 35), -61.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 40), -61.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 45), -61.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 50), -62.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 55), -63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 60), -64.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 65), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 70), -66.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 75), -67.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 80), -68.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 85), -69.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 90), -69.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 95), -70.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 100), -69.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 105), -69.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 110), -69.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 115), -69.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 120), -68.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 125), -68.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 130), -67.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 135), -67.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 140), -66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 145), -66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 150), -65.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 155), -64.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 160), -64.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 165), -63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 170), -62.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 175), -61.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-35, 180), -60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -180), -55.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -175), -53.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -170), -52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -165), -51.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -160), -50.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -155), -49.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -150), -48.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -145), -47.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -140), -46.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -135), -45.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -130), -44.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -125), -43.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -120), -42.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -115), -40.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -110), -39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -105), -38.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -100), -36.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -95), -35.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -90), -33.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -85), -31.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -80), -30.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -75), -30.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -70), -31.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -65), -33.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -60), -36.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -55), -39.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -50), -43.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -45), -46.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -40), -50.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -35), -53.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -30), -56.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -25), -59.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -20), -61.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -15), -63.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -10), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, -5), -66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 0), -67.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 5), -67.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 10), -67.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 15), -66.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 20), -65.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 25), -63.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 30), -62.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 35), -61.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 40), -60.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 45), -60.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 50), -60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 55), -61.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 60), -62.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 65), -63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 70), -63.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 75), -64.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 80), -65.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 85), -65.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 90), -65.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 95), -65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 100), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 105), -65.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 110), -64.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 115), -64.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 120), -63.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 125), -63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 130), -62.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 135), -62.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 140), -62.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 145), -61.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 150), -60.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 155), -60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 160), -59.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 165), -58.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 170), -57.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 175), -56.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-30, 180), -55.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -180), -49.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -175), -47.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -170), -46.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -165), -45.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -160), -44.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -155), -43.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -150), -42.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -145), -40.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -140), -39.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -135), -38.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -130), -37.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -125), -36.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -120), -35.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -115), -34.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -110), -33.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -105), -31.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -100), -30.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -95), -28.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -90), -26.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -85), -24.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -80), -23.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -75), -23.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -70), -25.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -65), -27.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -60), -30.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -55), -34.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -50), -38.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -45), -43.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -40), -46.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -35), -50.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -30), -53.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -25), -56.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -20), -59.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -15), -61.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -10), -63.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, -5), -65.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 0), -66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 5), -66.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 10), -66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 15), -65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 20), -64.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 25), -62.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 30), -60.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 35), -59.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 40), -58.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 45), -57.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 50), -57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 55), -57.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 60), -58.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 65), -59.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 70), -59.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 75), -60.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 80), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 85), -61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 90), -61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 95), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 100), -60.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 105), -59.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 110), -58.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 115), -58.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 120), -57.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 125), -57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 130), -57.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 135), -56.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 140), -56.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 145), -56.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 150), -55.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 155), -54.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 160), -53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 165), -52.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 170), -51.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 175), -50.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-25, 180), -49.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -180), -42.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -175), -40.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -170), -39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -165), -38.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -160), -37.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -155), -36.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -150), -34.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -145), -33.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -140), -32.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -135), -30.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -130), -29.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -125), -28.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -120), -27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -115), -26.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -110), -25.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -105), -23.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -100), -22.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -95), -20.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -90), -18.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -85), -16.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -80), -15.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -75), -15.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -70), -17.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -65), -20.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -60), -24.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -55), -28.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -50), -33.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -45), -38.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -40), -42.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -35), -46.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -30), -50.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -25), -53.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -20), -56.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -15), -58.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -10), -60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, -5), -62.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 0), -63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 5), -63.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 10), -63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 15), -62.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 20), -60.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 25), -59.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 30), -57.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 35), -55.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 40), -54.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 45), -53.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 50), -52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 55), -52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 60), -53.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 65), -53.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 70), -54.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 75), -54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 80), -54.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 85), -55.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 90), -54.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 95), -54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 100), -53.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 105), -53.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 110), -52.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 115), -51.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 120), -51.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 125), -51.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 130), -50.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 135), -50.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 140), -50.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 145), -49.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 150), -49.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 155), -48.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 160), -47.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 165), -46.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 170), -44.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 175), -43.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-20, 180), -42.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -180), -34.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -175), -32.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -170), -31.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -165), -30.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -160), -28.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -155), -27.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -150), -26.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -145), -25.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -140), -23.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -135), -22.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -130), -21.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -125), -20.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -120), -18.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -115), -17.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -110), -16.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -105), -14.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -100), -13.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -95), -11.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -90), -9.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -85), -7.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -80), -6.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -75), -7.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -70), -9.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -65), -12.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -60), -16.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -55), -21.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -50), -26.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -45), -32.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -40), -37.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -35), -41.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -30), -45.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -25), -49.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -20), -51.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -15), -54.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -10), -55.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, -5), -57.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 0), -57.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 5), -57.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 10), -57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 15), -56.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 20), -55.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 25), -53.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 30), -51.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 35), -49.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 40), -47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 45), -46.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 50), -46.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 55), -46.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 60), -46.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 65), -46.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 70), -46.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 75), -47.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 80), -47.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 85), -47.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 90), -47.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 95), -47.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 100), -46.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 105), -45.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 110), -44.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 115), -44.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 120), -43.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 125), -43.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 130), -43.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 135), -43.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 140), -43.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 145), -42.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 150), -42.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 155), -41.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 160), -40.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 165), -38.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 170), -37.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 175), -35.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-15, 180), -34.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -180), -25.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -175), -23.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -170), -22.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -165), -20.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -160), -19.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -155), -18.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -150), -16.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -145), -15.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -140), -14.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -135), -13.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -130), -11.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -125), -10.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -120), -9.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -115), -8.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -110), -6.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -105), -5.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -100), -3.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -95), -1.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -90), 0.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -85), 2.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -80), 2.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -75), 1.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -70), -0.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -65), -3.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -60), -8.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -55), -13.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -50), -19.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -45), -25.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -40), -30.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -35), -35.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -30), -39.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -25), -42.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -20), -45.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -15), -47.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -10), -49.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, -5), -50.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 0), -50.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 5), -50.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 10), -49.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 15), -48.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 20), -47.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 25), -45.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 30), -43.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 35), -41.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 40), -39.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 45), -38.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 50), -37.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 55), -37.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 60), -37.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 65), -37.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 70), -38.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 75), -38.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 80), -38.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 85), -38.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 90), -38.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 95), -38.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 100), -37.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 105), -36.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 110), -36.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 115), -35.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 120), -35.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 125), -35.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 130), -35.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 135), -35.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 140), -35.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 145), -34.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 150), -34.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 155), -33.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 160), -31.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 165), -30.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 170), -28.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 175), -27.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-10, 180), -25.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -180), -15.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -175), -13.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -170), -12.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -165), -10.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -160), -9.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -155), -8.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -150), -6.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -145), -5.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -140), -4.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -135), -3.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -130), -1.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -125), -0.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -120), 0.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -115), 1.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -110), 3.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -105), 4.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -100), 6.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -95), 8.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -90), 10.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -85), 11.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -80), 11.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -75), 10.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -70), 8.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -65), 5.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -60), 0.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -55), -4.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -50), -10.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -45), -16.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -40), -22.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -35), -27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -30), -31.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -25), -35.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -20), -37.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -15), -39.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -10), -40.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, -5), -41.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 0), -41.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 5), -41.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 10), -40.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 15), -39.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 20), -37.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 25), -35.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 30), -33.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 35), -31.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 40), -29.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 45), -28.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 50), -27.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 55), -27.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 60), -27.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 65), -27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 70), -27.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 75), -28.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 80), -28.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 85), -28.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 90), -28.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 95), -28.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 100), -27.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 105), -26.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 110), -26.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 115), -25.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 120), -25.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 125), -25.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 130), -26.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 135), -26.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 140), -26.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 145), -26.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 150), -25.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 155), -24.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 160), -22.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 165), -21.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 170), -19.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 175), -17.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(-5, 180), -15.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -180), -5.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -175), -3.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -170), -1.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -165), -0.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -160), 1.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -155), 2.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -150), 3.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -145), 4.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -140), 6.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -135), 7.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -130), 8.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -125), 9.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -120), 10.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -115), 11.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -110), 13.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -105), 14.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -100), 16.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -95), 18.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -90), 19.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -85), 20.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -80), 20.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -75), 19.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -70), 17.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -65), 14.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -60), 9.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -55), 4.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -50), -1.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -45), -7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -40), -13.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -35), -18.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -30), -22.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -25), -25.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -20), -27.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -15), -29.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -10), -30.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, -5), -30.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 0), -30.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 5), -29.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 10), -29.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 15), -28.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 20), -26.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 25), -24.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 30), -22.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 35), -20.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 40), -18.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 45), -17.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 50), -16.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 55), -16.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 60), -15.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 65), -16.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 70), -16.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 75), -16.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 80), -17.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 85), -17.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 90), -17.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 95), -17.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 100), -16.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 105), -15.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 110), -15.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 115), -15.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 120), -15.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 125), -15.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 130), -16.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 135), -16.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 140), -16.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 145), -16.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 150), -15.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 155), -14.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 160), -13.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 165), -11.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 170), -9.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 175), -7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(0, 180), -5.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -180), 5.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -175), 7.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -170), 8.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -165), 10.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -160), 11.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -155), 12.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -150), 13.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -145), 14.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -140), 15.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -135), 17.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -130), 18.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -125), 19.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -120), 20.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -115), 21.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -110), 22.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -105), 23.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -100), 25.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -95), 26.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -90), 28.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -85), 28.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -80), 28.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -75), 27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -70), 25.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -65), 22.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -60), 18.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -55), 13.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -50), 8.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -45), 2.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -40), -2.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -35), -7.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -30), -11.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -25), -14.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -20), -16.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -15), -17.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -10), -18.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, -5), -18.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 0), -18.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 5), -17.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 10), -16.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 15), -15.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 20), -14.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 25), -12.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 30), -10.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 35), -7.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 40), -6.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 45), -4.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 50), -4.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 55), -3.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 60), -3.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 65), -3.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 70), -4.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 75), -4.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 80), -4.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 85), -5.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 90), -5.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 95), -5.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 100), -4.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 105), -4.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 110), -3.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 115), -3.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 120), -3.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 125), -4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 130), -5.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 135), -5.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 140), -6.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 145), -6.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 150), -5.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 155), -4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 160), -3.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 165), -1.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 170), 0.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 175), 2.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(5, 180), 5.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -180), 14.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -175), 16.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -170), 18.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -165), 19.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -160), 20.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -155), 21.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -150), 22.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -145), 23.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -140), 24.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -135), 26.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -130), 27.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -125), 28.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -120), 29.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -115), 30.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -110), 31.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -105), 32.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -100), 33.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -95), 34.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -90), 35.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -85), 36.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -80), 35.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -75), 34.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -70), 32.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -65), 30.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -60), 26.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -55), 22.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -50), 17.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -45), 12.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -40), 7.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -35), 3.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -30), -0.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -25), -2.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -20), -4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -15), -5.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -10), -5.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, -5), -5.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 0), -5.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 5), -4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 10), -3.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 15), -2.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 20), -1.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 25), 0.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 30), 2.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 35), 4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 40), 6.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 45), 7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 50), 8.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 55), 8.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 60), 8.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 65), 8.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 70), 8.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 75), 8.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 80), 7.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 85), 7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 90), 7.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 95), 7.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 100), 7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 105), 7.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 110), 7.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 115), 7.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 120), 7.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 125), 6.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 130), 5.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 135), 5.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 140), 4.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 145), 4.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 150), 4.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 155), 5.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 160), 6.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 165), 8.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 170), 10.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 175), 12.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(10, 180), 14.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -180), 23.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -175), 25.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -170), 26.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -165), 28.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -160), 29.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -155), 30.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -150), 31.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -145), 32.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -140), 33.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -135), 34.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -130), 35.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -125), 35.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -120), 36.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -115), 37.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -110), 38.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -105), 39.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -100), 41.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -95), 41.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -90), 42.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -85), 42.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -80), 42.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -75), 41.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -70), 39.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -65), 36.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -60), 33.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -55), 30.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -50), 25.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -45), 21.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -40), 17.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -35), 14.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -30), 11.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -25), 9.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -20), 7.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -15), 7.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -10), 7.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, -5), 7.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 0), 7.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 5), 8.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 10), 9.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 15), 10.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 20), 11.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 25), 13.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 30), 14.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 35), 16.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 40), 18.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 45), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 50), 19.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 55), 20.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 60), 20.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 65), 20.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 70), 19.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 75), 19.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 80), 19.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 85), 19.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 90), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 95), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 100), 19.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 105), 19.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 110), 19.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 115), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 120), 18.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 125), 17.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 130), 16.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 135), 15.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 140), 14.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 145), 14.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 150), 14.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 155), 15.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 160), 16.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 165), 17.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 170), 19.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 175), 21.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(15, 180), 23.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -180), 31.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -175), 32.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -170), 34.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -165), 35.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -160), 36.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -155), 37.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -150), 38.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -145), 38.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -140), 39.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -135), 40.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -130), 41.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -125), 42.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -120), 43.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -115), 44.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -110), 45.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -105), 46.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -100), 47.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -95), 48.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -90), 48.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -85), 48.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -80), 48.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -75), 46.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -70), 45.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -65), 43.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -60), 40.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -55), 37.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -50), 33.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -45), 30.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -40), 27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -35), 24.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -30), 22.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -25), 20.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -20), 19.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -15), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -10), 19.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, -5), 19.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 0), 20.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 5), 20.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 10), 21.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 15), 22.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 20), 23.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 25), 24.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 30), 26.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 35), 27.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 40), 28.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 45), 29.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 50), 30.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 55), 30.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 60), 30.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 65), 30.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 70), 30.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 75), 30.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 80), 30.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 85), 30.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 90), 29.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 95), 29.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 100), 29.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 105), 29.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 110), 29.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 115), 29.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 120), 28.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 125), 27.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 130), 26.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 135), 25.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 140), 24.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 145), 24.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 150), 24.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 155), 24.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 160), 25.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 165), 26.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 170), 27.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 175), 29.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(20, 180), 31.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -180), 37.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -175), 39.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -170), 40.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -165), 41.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -160), 42.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -155), 43.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -150), 44.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -145), 44.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -140), 45.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -135), 46.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -130), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -125), 48.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -120), 49.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -115), 50.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -110), 51.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -105), 52.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -100), 53.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -95), 53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -90), 54.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -85), 53.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -80), 53.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -75), 52.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -70), 50.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -65), 48.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -60), 46.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -55), 43.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -50), 41.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -45), 38.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -40), 36.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -35), 34.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -30), 32.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -25), 31.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -20), 30.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -15), 29.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -10), 29.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, -5), 30.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 0), 30.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 5), 31.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 10), 32.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 15), 33.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 20), 33.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 25), 34.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 30), 36.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 35), 37.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 40), 38.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 45), 39.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 50), 39.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 55), 39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 60), 39.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 65), 39.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 70), 39.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 75), 39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 80), 39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 85), 39.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 90), 39.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 95), 39.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 100), 39.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 105), 39.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 110), 39.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 115), 38.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 120), 37.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 125), 36.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 130), 35.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 135), 34.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 140), 33.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 145), 33.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 150), 32.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 155), 32.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 160), 33.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 165), 33.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 170), 34.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 175), 36.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(25, 180), 37.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -180), 43.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -175), 44.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -170), 45.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -165), 46.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -160), 47.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -155), 48.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -150), 49.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -145), 49.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -140), 50.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -135), 51.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -130), 52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -125), 53.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -120), 54.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -115), 55.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -110), 56.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -105), 57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -100), 58.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -95), 58.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -90), 58.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -85), 58.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -80), 57.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -75), 56.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -70), 55.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -65), 53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -60), 51.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -55), 49.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -50), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -45), 45.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -40), 43.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -35), 42.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -30), 41.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -25), 40.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -20), 39.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -15), 39.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -10), 39.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, -5), 39.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 0), 40.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 5), 40.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 10), 41.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 15), 42.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 20), 42.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 25), 43.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 30), 44.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 35), 45.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 40), 46.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 45), 46.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 50), 47.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 55), 47.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 60), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 65), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 70), 47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 75), 47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 80), 47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 85), 47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 90), 47.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 95), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 100), 47.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 105), 47.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 110), 47.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 115), 46.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 120), 45.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 125), 44.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 130), 43.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 135), 42.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 140), 41.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 145), 40.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 150), 40.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 155), 40.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 160), 40.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 165), 40.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 170), 41.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 175), 42.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(30, 180), 43.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -180), 48.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -175), 49.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -170), 50.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -165), 51.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -160), 51.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -155), 52.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -150), 53.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -145), 54.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -140), 55.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -135), 56.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -130), 57.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -125), 58.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -120), 59.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -115), 60.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -110), 61.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -105), 62.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -100), 62.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -95), 63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -90), 63.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -85), 62.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -80), 62.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -75), 61.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -70), 60.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -65), 58.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -60), 56.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -55), 55.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -50), 53.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -45), 52.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -40), 50.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -35), 49.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -30), 48.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -25), 47.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -20), 47.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -15), 47.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -10), 47.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, -5), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 0), 48.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 5), 48.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 10), 49.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 15), 49.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 20), 50.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 25), 51.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 30), 51.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 35), 52.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 40), 53.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 45), 53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 50), 54.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 55), 54.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 60), 54.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 65), 54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 70), 54.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 75), 54.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 80), 54.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 85), 54.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 90), 54.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 95), 54.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 100), 54.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 105), 54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 110), 54.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 115), 53.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 120), 52.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 125), 51.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 130), 50.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 135), 49.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 140), 48.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 145), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 150), 47.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 155), 46.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 160), 46.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 165), 46.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 170), 47.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 175), 47.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(35, 180), 48.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -180), 53.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -175), 53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -170), 54.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -165), 55.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -160), 55.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -155), 56.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -150), 57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -145), 58.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -140), 59.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -135), 60.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -130), 61.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -125), 62.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -120), 63.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -115), 64.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -110), 65.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -105), 66.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -100), 66.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -95), 67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -90), 67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -85), 66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -80), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -75), 65.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -70), 64.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -65), 62.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -60), 61.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -55), 60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -50), 58.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -45), 57.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -40), 56.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -35), 55.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -30), 55.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -25), 54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -20), 54.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -15), 54.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -10), 54.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, -5), 54.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 0), 54.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 5), 55.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 10), 55.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 15), 56.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 20), 56.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 25), 57.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 30), 58.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 35), 58.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 40), 59.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 45), 59.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 50), 59.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 55), 59.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 60), 60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 65), 60.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 70), 60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 75), 60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 80), 60.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 85), 61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 90), 61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 95), 61.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 100), 60.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 105), 60.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 110), 60.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 115), 59.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 120), 58.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 125), 57.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 130), 56.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 135), 55.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 140), 54.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 145), 53.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 150), 53.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 155), 52.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 160), 52.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 165), 52.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 170), 52.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 175), 52.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(40, 180), 53.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -180), 57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -175), 57.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -170), 58.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -165), 59.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -160), 59.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -155), 60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -150), 61.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -145), 62.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -140), 63.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -135), 64.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -130), 65.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -125), 66.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -120), 67.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -115), 68.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -110), 69.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -105), 70.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -100), 70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -95), 70.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -90), 71.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -85), 70.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -80), 70.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -75), 69.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -70), 68.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -65), 67.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -60), 65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -55), 64.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -50), 63.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -45), 62.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -40), 61.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -35), 61.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -30), 60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -25), 60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -20), 59.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -15), 59.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -10), 60.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, -5), 60.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 0), 60.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 5), 60.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 10), 61.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 15), 61.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 20), 62.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 25), 62.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 30), 63.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 35), 63.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 40), 63.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 45), 64.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 50), 64.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 55), 64.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 60), 65.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 65), 65.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 70), 65.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 75), 65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 80), 66.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 85), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 90), 66.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 95), 66.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 100), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 105), 66.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 110), 65.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 115), 64.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 120), 64.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 125), 63.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 130), 62.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 135), 61.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 140), 60.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 145), 59.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 150), 58.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 155), 57.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 160), 57.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 165), 57.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 170), 57.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 175), 57.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(45, 180), 57.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -180), 61.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -175), 62.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -170), 62.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -165), 63.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -160), 63.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -155), 64.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -150), 65.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -145), 66.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -140), 67.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -135), 68.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -130), 69.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -125), 70.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -120), 71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -115), 72.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -110), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -105), 73.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -100), 74.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -95), 74.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -90), 74.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -85), 74.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -80), 73.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -75), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -70), 71.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -65), 70.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -60), 69.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -55), 68.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -50), 67.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -45), 67.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -40), 66.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -35), 65.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -30), 65.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -25), 65.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -20), 64.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -15), 64.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -10), 64.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, -5), 65.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 0), 65.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 5), 65.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 10), 65.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 15), 66.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 20), 66.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 25), 66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 30), 67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 35), 67.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 40), 67.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 45), 68.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 50), 68.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 55), 68.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 60), 69.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 65), 69.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 70), 70.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 75), 70.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 80), 70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 85), 70.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 90), 71.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 95), 71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 100), 71.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 105), 70.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 110), 70.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 115), 69.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 120), 68.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 125), 67.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 130), 66.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 135), 65.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 140), 64.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 145), 64.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 150), 63.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 155), 62.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 160), 62.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 165), 61.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 170), 61.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 175), 61.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(50, 180), 61.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -180), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -175), 66.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -170), 66.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -165), 67.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -160), 67.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -155), 68.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -150), 69.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -145), 70.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -140), 70.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -135), 71.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -130), 72.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -125), 73.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -120), 74.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -115), 75.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -110), 76.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -105), 77.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -100), 77.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -95), 77.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -90), 77.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -85), 77.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -80), 76.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -75), 76.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -70), 75.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -65), 74.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -60), 73.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -55), 72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -50), 71.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -45), 71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -40), 70.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -35), 69.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -30), 69.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -25), 69.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -20), 69.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -15), 69.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -10), 69.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, -5), 69.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 0), 69.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 5), 69.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 10), 69.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 15), 69.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 20), 70.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 25), 70.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 30), 70.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 35), 71.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 40), 71.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 45), 71.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 50), 72.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 55), 72.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 60), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 65), 73.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 70), 73.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 75), 74.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 80), 74.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 85), 74.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 90), 75.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 95), 75.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 100), 75.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 105), 74.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 110), 74.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 115), 73.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 120), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 125), 72.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 130), 71.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 135), 70.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 140), 69.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 145), 68.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 150), 67.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 155), 67.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 160), 66.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 165), 66.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 170), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 175), 66.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(55, 180), 66.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -180), 70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -175), 70.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -170), 71.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -165), 71.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -160), 71.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -155), 72.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -150), 73.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -145), 73.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -140), 74.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -135), 75.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -130), 76.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -125), 77.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -120), 78.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -115), 78.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -110), 79.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -105), 80.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -100), 80.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -95), 80.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -90), 80.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -85), 80.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -80), 79.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -75), 79.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -70), 78.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -65), 77.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -60), 76.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -55), 76.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -50), 75.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -45), 74.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -40), 74.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -35), 73.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -30), 73.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -25), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -20), 72.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -15), 72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -10), 72.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, -5), 72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 0), 72.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 5), 72.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 10), 72.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 15), 73.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 20), 73.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 25), 73.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 30), 73.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 35), 74.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 40), 74.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 45), 74.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 50), 75.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 55), 75.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 60), 76.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 65), 76.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 70), 77.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 75), 77.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 80), 78.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 85), 78.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 90), 78.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 95), 78.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 100), 78.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 105), 78.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 110), 78.0, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 115), 77.4, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 120), 76.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 125), 75.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 130), 75.1, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 135), 74.3, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 140), 73.5, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 145), 72.8, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 150), 72.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 155), 71.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 160), 71.2, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 165), 70.9, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 170), 70.7, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 175), 70.6, 0.21 + 1.2);
	EXPECT_NEAR(get_mag_inclination_degrees(60, 180), 70.6, 0.21 + 1.2);
}

TEST(GeoLookupTest, strength)
{
	EXPECT_NEAR(get_mag_strength_tesla(-50, -180) * 1e9, 58366, 145 + 584);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -175) * 1e9, 57212, 145 + 572);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -170) * 1e9, 56045, 145 + 560);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -165) * 1e9, 54873, 145 + 549);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -160) * 1e9, 53703, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -155) * 1e9, 52538, 145 + 525);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -150) * 1e9, 51377, 145 + 514);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -145) * 1e9, 50215, 145 + 502);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -140) * 1e9, 49039, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -135) * 1e9, 47834, 145 + 478);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -130) * 1e9, 46581, 145 + 466);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -125) * 1e9, 45263, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -120) * 1e9, 43868, 145 + 439);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -115) * 1e9, 42390, 145 + 424);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -110) * 1e9, 40832, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -105) * 1e9, 39210, 145 + 392);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -100) * 1e9, 37547, 145 + 375);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -95) * 1e9, 35876, 145 + 359);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -90) * 1e9, 34237, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -85) * 1e9, 32675, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -80) * 1e9, 31233, 145 + 312);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -75) * 1e9, 29950, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -70) * 1e9, 28854, 145 + 289);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -65) * 1e9, 27960, 145 + 280);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -60) * 1e9, 27263, 145 + 273);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -55) * 1e9, 26744, 145 + 267);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -50) * 1e9, 26368, 145 + 264);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -45) * 1e9, 26095, 145 + 261);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -40) * 1e9, 25885, 145 + 259);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -35) * 1e9, 25704, 145 + 257);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -30) * 1e9, 25530, 145 + 255);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -25) * 1e9, 25353, 145 + 254);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -20) * 1e9, 25176, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -15) * 1e9, 25017, 145 + 250);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -10) * 1e9, 24901, 145 + 249);
	EXPECT_NEAR(get_mag_strength_tesla(-50, -5) * 1e9, 24866, 145 + 249);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 0) * 1e9, 24956, 145 + 250);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 5) * 1e9, 25221, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 10) * 1e9, 25707, 145 + 257);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 15) * 1e9, 26455, 145 + 265);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 20) * 1e9, 27492, 145 + 275);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 25) * 1e9, 28827, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 30) * 1e9, 30453, 145 + 305);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 35) * 1e9, 32345, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 40) * 1e9, 34467, 145 + 345);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 45) * 1e9, 36775, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 50) * 1e9, 39216, 145 + 392);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 55) * 1e9, 41742, 145 + 417);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 60) * 1e9, 44303, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 65) * 1e9, 46856, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 70) * 1e9, 49362, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 75) * 1e9, 51788, 145 + 518);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 80) * 1e9, 54102, 145 + 541);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 85) * 1e9, 56274, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 90) * 1e9, 58275, 145 + 583);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 95) * 1e9, 60075, 145 + 601);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 100) * 1e9, 61649, 145 + 616);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 105) * 1e9, 62978, 145 + 630);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 110) * 1e9, 64047, 145 + 640);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 115) * 1e9, 64856, 145 + 649);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 120) * 1e9, 65408, 145 + 654);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 125) * 1e9, 65716, 145 + 657);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 130) * 1e9, 65796, 145 + 658);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 135) * 1e9, 65667, 145 + 657);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 140) * 1e9, 65350, 145 + 654);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 145) * 1e9, 64864, 145 + 649);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 150) * 1e9, 64229, 145 + 642);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 155) * 1e9, 63464, 145 + 635);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 160) * 1e9, 62590, 145 + 626);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 165) * 1e9, 61624, 145 + 616);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 170) * 1e9, 60587, 145 + 606);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 175) * 1e9, 59496, 145 + 595);
	EXPECT_NEAR(get_mag_strength_tesla(-50, 180) * 1e9, 58366, 145 + 584);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -180) * 1e9, 56216, 145 + 956);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -175) * 1e9, 55008, 145 + 935);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -170) * 1e9, 53791, 145 + 914);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -165) * 1e9, 52574, 145 + 894);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -160) * 1e9, 51364, 145 + 873);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -155) * 1e9, 50166, 145 + 853);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -150) * 1e9, 48980, 145 + 833);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -145) * 1e9, 47803, 145 + 813);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -140) * 1e9, 46624, 145 + 793);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -135) * 1e9, 45425, 145 + 772);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -130) * 1e9, 44189, 145 + 751);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -125) * 1e9, 42894, 145 + 729);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -120) * 1e9, 41524, 145 + 706);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -115) * 1e9, 40070, 145 + 681);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -110) * 1e9, 38532, 145 + 655);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -105) * 1e9, 36919, 145 + 628);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -100) * 1e9, 35253, 145 + 599);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -95) * 1e9, 33568, 145 + 571);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -90) * 1e9, 31908, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -85) * 1e9, 30323, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -80) * 1e9, 28870, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -75) * 1e9, 27598, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -70) * 1e9, 26546, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -65) * 1e9, 25735, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -60) * 1e9, 25160, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -55) * 1e9, 24794, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -50) * 1e9, 24590, 145 + 418);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -45) * 1e9, 24492, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -40) * 1e9, 24448, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -35) * 1e9, 24414, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -30) * 1e9, 24362, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -25) * 1e9, 24278, 145 + 413);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -20) * 1e9, 24163, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -15) * 1e9, 24029, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -10) * 1e9, 23900, 145 + 406);
	EXPECT_NEAR(get_mag_strength_tesla(-45, -5) * 1e9, 23814, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 0) * 1e9, 23820, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 5) * 1e9, 23978, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 10) * 1e9, 24354, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 15) * 1e9, 25008, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 20) * 1e9, 25984, 145 + 442);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 25) * 1e9, 27304, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 30) * 1e9, 28965, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 35) * 1e9, 30939, 145 + 526);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 40) * 1e9, 33179, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 45) * 1e9, 35626, 145 + 606);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 50) * 1e9, 38215, 145 + 650);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 55) * 1e9, 40879, 145 + 695);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 60) * 1e9, 43558, 145 + 740);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 65) * 1e9, 46199, 145 + 785);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 70) * 1e9, 48760, 145 + 829);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 75) * 1e9, 51209, 145 + 871);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 80) * 1e9, 53516, 145 + 910);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 85) * 1e9, 55655, 145 + 946);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 90) * 1e9, 57601, 145 + 979);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 95) * 1e9, 59327, 145 + 1009);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 100) * 1e9, 60810, 145 + 1034);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 105) * 1e9, 62034, 145 + 1055);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 110) * 1e9, 62992, 145 + 1071);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 115) * 1e9, 63686, 145 + 1083);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 120) * 1e9, 64127, 145 + 1090);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 125) * 1e9, 64332, 145 + 1094);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 130) * 1e9, 64319, 145 + 1093);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 135) * 1e9, 64106, 145 + 1090);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 140) * 1e9, 63714, 145 + 1083);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 145) * 1e9, 63158, 145 + 1074);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 150) * 1e9, 62457, 145 + 1062);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 155) * 1e9, 61628, 145 + 1048);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 160) * 1e9, 60688, 145 + 1032);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 165) * 1e9, 59658, 145 + 1014);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 170) * 1e9, 58557, 145 + 995);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 175) * 1e9, 57404, 145 + 976);
	EXPECT_NEAR(get_mag_strength_tesla(-45, 180) * 1e9, 56216, 145 + 956);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -180) * 1e9, 53880, 145 + 916);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -175) * 1e9, 52645, 145 + 895);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -170) * 1e9, 51403, 145 + 874);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -165) * 1e9, 50164, 145 + 853);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -160) * 1e9, 48933, 145 + 832);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -155) * 1e9, 47717, 145 + 811);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -150) * 1e9, 46519, 145 + 791);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -145) * 1e9, 45336, 145 + 771);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -140) * 1e9, 44163, 145 + 751);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -135) * 1e9, 42984, 145 + 731);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -130) * 1e9, 41781, 145 + 710);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -125) * 1e9, 40535, 145 + 689);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -120) * 1e9, 39228, 145 + 667);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -115) * 1e9, 37846, 145 + 643);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -110) * 1e9, 36383, 145 + 619);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -105) * 1e9, 34844, 145 + 592);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -100) * 1e9, 33243, 145 + 565);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -95) * 1e9, 31609, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -90) * 1e9, 29988, 145 + 510);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -85) * 1e9, 28435, 145 + 483);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -80) * 1e9, 27015, 145 + 459);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -75) * 1e9, 25792, 145 + 438);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -70) * 1e9, 24815, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -65) * 1e9, 24110, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -60) * 1e9, 23672, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -55) * 1e9, 23466, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -50) * 1e9, 23432, 145 + 398);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -45) * 1e9, 23504, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -40) * 1e9, 23620, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -35) * 1e9, 23732, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -30) * 1e9, 23812, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -25) * 1e9, 23846, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -20) * 1e9, 23831, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -15) * 1e9, 23771, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -10) * 1e9, 23682, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(-40, -5) * 1e9, 23591, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 0) * 1e9, 23542, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 5) * 1e9, 23602, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 10) * 1e9, 23849, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 15) * 1e9, 24364, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 20) * 1e9, 25215, 145 + 429);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 25) * 1e9, 26445, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 30) * 1e9, 28060, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 35) * 1e9, 30036, 145 + 511);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 40) * 1e9, 32319, 145 + 549);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 45) * 1e9, 34838, 145 + 592);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 50) * 1e9, 37511, 145 + 638);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 55) * 1e9, 40255, 145 + 684);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 60) * 1e9, 42993, 145 + 731);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 65) * 1e9, 45663, 145 + 776);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 70) * 1e9, 48218, 145 + 820);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 75) * 1e9, 50623, 145 + 861);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 80) * 1e9, 52855, 145 + 899);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 85) * 1e9, 54891, 145 + 933);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 90) * 1e9, 56710, 145 + 964);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 95) * 1e9, 58289, 145 + 991);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 100) * 1e9, 59613, 145 + 1013);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 105) * 1e9, 60674, 145 + 1031);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 110) * 1e9, 61473, 145 + 1045);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 115) * 1e9, 62022, 145 + 1054);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 120) * 1e9, 62339, 145 + 1060);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 125) * 1e9, 62442, 145 + 1062);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 130) * 1e9, 62350, 145 + 1060);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 135) * 1e9, 62078, 145 + 1055);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 140) * 1e9, 61638, 145 + 1048);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 145) * 1e9, 61046, 145 + 1038);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 150) * 1e9, 60312, 145 + 1025);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 155) * 1e9, 59452, 145 + 1011);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 160) * 1e9, 58482, 145 + 994);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 165) * 1e9, 57419, 145 + 976);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 170) * 1e9, 56285, 145 + 957);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 175) * 1e9, 55099, 145 + 937);
	EXPECT_NEAR(get_mag_strength_tesla(-40, 180) * 1e9, 53880, 145 + 916);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -180) * 1e9, 51386, 145 + 874);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -175) * 1e9, 50148, 145 + 853);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -170) * 1e9, 48908, 145 + 831);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -165) * 1e9, 47670, 145 + 810);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -160) * 1e9, 46441, 145 + 790);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -155) * 1e9, 45226, 145 + 769);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -150) * 1e9, 44030, 145 + 749);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -145) * 1e9, 42855, 145 + 729);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -140) * 1e9, 41698, 145 + 709);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -135) * 1e9, 40549, 145 + 689);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -130) * 1e9, 39394, 145 + 670);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -125) * 1e9, 38217, 145 + 650);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -120) * 1e9, 37000, 145 + 629);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -115) * 1e9, 35729, 145 + 607);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -110) * 1e9, 34390, 145 + 585);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -105) * 1e9, 32978, 145 + 561);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -100) * 1e9, 31499, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -95) * 1e9, 29975, 145 + 510);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -90) * 1e9, 28447, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -85) * 1e9, 26977, 145 + 459);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -80) * 1e9, 25635, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -75) * 1e9, 24495, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -70) * 1e9, 23615, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -65) * 1e9, 23026, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -60) * 1e9, 22722, 145 + 386);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -55) * 1e9, 22660, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -50) * 1e9, 22772, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -45) * 1e9, 22985, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -40) * 1e9, 23235, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -35) * 1e9, 23478, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -30) * 1e9, 23691, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -25) * 1e9, 23864, 145 + 406);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -20) * 1e9, 23992, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -15) * 1e9, 24068, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -10) * 1e9, 24092, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(-35, -5) * 1e9, 24071, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 0) * 1e9, 24036, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 5) * 1e9, 24046, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 10) * 1e9, 24185, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 15) * 1e9, 24550, 145 + 417);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 20) * 1e9, 25231, 145 + 429);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 25) * 1e9, 26295, 145 + 447);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 30) * 1e9, 27772, 145 + 472);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 35) * 1e9, 29648, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 40) * 1e9, 31876, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 45) * 1e9, 34375, 145 + 584);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 50) * 1e9, 37050, 145 + 630);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 55) * 1e9, 39801, 145 + 677);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 60) * 1e9, 42536, 145 + 723);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 65) * 1e9, 45178, 145 + 768);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 70) * 1e9, 47674, 145 + 810);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 75) * 1e9, 49987, 145 + 850);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 80) * 1e9, 52094, 145 + 886);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 85) * 1e9, 53976, 145 + 918);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 90) * 1e9, 55613, 145 + 945);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 95) * 1e9, 56990, 145 + 969);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 100) * 1e9, 58101, 145 + 988);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 105) * 1e9, 58949, 145 + 1002);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 110) * 1e9, 59552, 145 + 1012);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 115) * 1e9, 59934, 145 + 1019);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 120) * 1e9, 60119, 145 + 1022);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 125) * 1e9, 60127, 145 + 1022);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 130) * 1e9, 59972, 145 + 1020);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 135) * 1e9, 59660, 145 + 1014);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 140) * 1e9, 59198, 145 + 1006);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 145) * 1e9, 58593, 145 + 996);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 150) * 1e9, 57853, 145 + 983);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 155) * 1e9, 56988, 145 + 969);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 160) * 1e9, 56013, 145 + 952);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 165) * 1e9, 54945, 145 + 934);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 170) * 1e9, 53803, 145 + 915);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 175) * 1e9, 52610, 145 + 894);
	EXPECT_NEAR(get_mag_strength_tesla(-35, 180) * 1e9, 51386, 145 + 874);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -180) * 1e9, 48750, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -175) * 1e9, 47536, 145 + 475);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -170) * 1e9, 46322, 145 + 463);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -165) * 1e9, 45113, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -160) * 1e9, 43912, 145 + 439);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -155) * 1e9, 42723, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -150) * 1e9, 41552, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -145) * 1e9, 40404, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -140) * 1e9, 39280, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -135) * 1e9, 38176, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -130) * 1e9, 37085, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -125) * 1e9, 35995, 145 + 360);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -120) * 1e9, 34891, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -115) * 1e9, 33756, 145 + 338);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -110) * 1e9, 32574, 145 + 326);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -105) * 1e9, 31328, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -100) * 1e9, 30012, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -95) * 1e9, 28642, 145 + 286);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -90) * 1e9, 27255, 145 + 273);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -85) * 1e9, 25911, 145 + 259);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -80) * 1e9, 24686, 145 + 247);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -75) * 1e9, 23658, 145 + 237);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -70) * 1e9, 22890, 145 + 229);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -65) * 1e9, 22416, 145 + 224);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -60) * 1e9, 22227, 145 + 222);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -55) * 1e9, 22278, 145 + 223);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -50) * 1e9, 22498, 145 + 225);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -45) * 1e9, 22814, 145 + 228);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -40) * 1e9, 23167, 145 + 232);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -35) * 1e9, 23521, 145 + 235);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -30) * 1e9, 23864, 145 + 239);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -25) * 1e9, 24192, 145 + 242);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -20) * 1e9, 24496, 145 + 245);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -15) * 1e9, 24760, 145 + 248);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -10) * 1e9, 24962, 145 + 250);
	EXPECT_NEAR(get_mag_strength_tesla(-30, -5) * 1e9, 25085, 145 + 251);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 0) * 1e9, 25140, 145 + 251);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 5) * 1e9, 25169, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 10) * 1e9, 25250, 145 + 253);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 15) * 1e9, 25485, 145 + 255);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 20) * 1e9, 25978, 145 + 260);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 25) * 1e9, 26822, 145 + 268);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 30) * 1e9, 28072, 145 + 281);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 35) * 1e9, 29744, 145 + 297);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 40) * 1e9, 31802, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 45) * 1e9, 34173, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 50) * 1e9, 36752, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 55) * 1e9, 39425, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 60) * 1e9, 42084, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 65) * 1e9, 44640, 145 + 446);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 70) * 1e9, 47031, 145 + 470);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 75) * 1e9, 49216, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 80) * 1e9, 51166, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 85) * 1e9, 52862, 145 + 529);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 90) * 1e9, 54286, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 95) * 1e9, 55427, 145 + 554);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 100) * 1e9, 56288, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 105) * 1e9, 56892, 145 + 569);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 110) * 1e9, 57275, 145 + 573);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 115) * 1e9, 57477, 145 + 575);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 120) * 1e9, 57531, 145 + 575);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 125) * 1e9, 57454, 145 + 575);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 130) * 1e9, 57252, 145 + 573);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 135) * 1e9, 56917, 145 + 569);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 140) * 1e9, 56448, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 145) * 1e9, 55845, 145 + 558);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 150) * 1e9, 55114, 145 + 551);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 155) * 1e9, 54263, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 160) * 1e9, 53305, 145 + 533);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 165) * 1e9, 52253, 145 + 523);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 170) * 1e9, 51128, 145 + 511);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 175) * 1e9, 49953, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(-30, 180) * 1e9, 48750, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -180) * 1e9, 45998, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -175) * 1e9, 44836, 145 + 448);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -170) * 1e9, 43679, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -165) * 1e9, 42529, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -160) * 1e9, 41387, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -155) * 1e9, 40255, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -150) * 1e9, 39140, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -145) * 1e9, 38048, 145 + 380);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -140) * 1e9, 36984, 145 + 370);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -135) * 1e9, 35950, 145 + 359);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -130) * 1e9, 34943, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -125) * 1e9, 33957, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -120) * 1e9, 32983, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -115) * 1e9, 32003, 145 + 320);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -110) * 1e9, 30994, 145 + 310);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -105) * 1e9, 29935, 145 + 299);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -100) * 1e9, 28809, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -95) * 1e9, 27624, 145 + 276);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -90) * 1e9, 26412, 145 + 264);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -85) * 1e9, 25230, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -80) * 1e9, 24153, 145 + 242);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -75) * 1e9, 23257, 145 + 233);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -70) * 1e9, 22604, 145 + 226);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -65) * 1e9, 22229, 145 + 222);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -60) * 1e9, 22125, 145 + 221);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -55) * 1e9, 22250, 145 + 222);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -50) * 1e9, 22538, 145 + 225);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -45) * 1e9, 22923, 145 + 229);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -40) * 1e9, 23353, 145 + 234);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -35) * 1e9, 23803, 145 + 238);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -30) * 1e9, 24270, 145 + 243);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -25) * 1e9, 24753, 145 + 248);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -20) * 1e9, 25243, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -15) * 1e9, 25713, 145 + 257);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -10) * 1e9, 26120, 145 + 261);
	EXPECT_NEAR(get_mag_strength_tesla(-25, -5) * 1e9, 26428, 145 + 264);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 0) * 1e9, 26624, 145 + 266);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 5) * 1e9, 26729, 145 + 267);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 10) * 1e9, 26807, 145 + 268);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 15) * 1e9, 26950, 145 + 270);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 20) * 1e9, 27268, 145 + 273);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 25) * 1e9, 27868, 145 + 279);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 30) * 1e9, 28836, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 35) * 1e9, 30216, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 40) * 1e9, 32004, 145 + 320);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 45) * 1e9, 34140, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 50) * 1e9, 36520, 145 + 365);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 55) * 1e9, 39024, 145 + 390);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 60) * 1e9, 41531, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 65) * 1e9, 43941, 145 + 439);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 70) * 1e9, 46182, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 75) * 1e9, 48208, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 80) * 1e9, 49985, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 85) * 1e9, 51484, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 90) * 1e9, 52685, 145 + 527);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 95) * 1e9, 53579, 145 + 536);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 100) * 1e9, 54179, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 105) * 1e9, 54529, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 110) * 1e9, 54687, 145 + 547);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 115) * 1e9, 54713, 145 + 547);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 120) * 1e9, 54645, 145 + 546);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 125) * 1e9, 54497, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 130) * 1e9, 54260, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 135) * 1e9, 53914, 145 + 539);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 140) * 1e9, 53446, 145 + 534);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 145) * 1e9, 52851, 145 + 529);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 150) * 1e9, 52137, 145 + 521);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 155) * 1e9, 51311, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 160) * 1e9, 50385, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 165) * 1e9, 49372, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 170) * 1e9, 48287, 145 + 483);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 175) * 1e9, 47155, 145 + 472);
	EXPECT_NEAR(get_mag_strength_tesla(-25, 180) * 1e9, 45998, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -180) * 1e9, 43192, 145 + 432);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -175) * 1e9, 42112, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -170) * 1e9, 41042, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -165) * 1e9, 39983, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -160) * 1e9, 38935, 145 + 389);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -155) * 1e9, 37897, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -150) * 1e9, 36875, 145 + 369);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -145) * 1e9, 35877, 145 + 359);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -140) * 1e9, 34909, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -135) * 1e9, 33976, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -130) * 1e9, 33080, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -125) * 1e9, 32220, 145 + 322);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -120) * 1e9, 31390, 145 + 314);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -115) * 1e9, 30574, 145 + 306);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -110) * 1e9, 29747, 145 + 297);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -105) * 1e9, 28882, 145 + 289);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -100) * 1e9, 27959, 145 + 280);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -95) * 1e9, 26978, 145 + 270);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -90) * 1e9, 25964, 145 + 260);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -85) * 1e9, 24968, 145 + 250);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -80) * 1e9, 24057, 145 + 241);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -75) * 1e9, 23298, 145 + 233);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -70) * 1e9, 22748, 145 + 227);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -65) * 1e9, 22443, 145 + 224);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -60) * 1e9, 22384, 145 + 224);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -55) * 1e9, 22538, 145 + 225);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -50) * 1e9, 22855, 145 + 229);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -45) * 1e9, 23279, 145 + 233);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -40) * 1e9, 23766, 145 + 238);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -35) * 1e9, 24298, 145 + 243);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -30) * 1e9, 24873, 145 + 249);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -25) * 1e9, 25493, 145 + 255);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -20) * 1e9, 26145, 145 + 261);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -15) * 1e9, 26794, 145 + 268);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -10) * 1e9, 27386, 145 + 274);
	EXPECT_NEAR(get_mag_strength_tesla(-20, -5) * 1e9, 27870, 145 + 279);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 0) * 1e9, 28213, 145 + 282);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 5) * 1e9, 28420, 145 + 284);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 10) * 1e9, 28532, 145 + 285);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 15) * 1e9, 28626, 145 + 286);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 20) * 1e9, 28803, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 25) * 1e9, 29174, 145 + 292);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 30) * 1e9, 29846, 145 + 298);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 35) * 1e9, 30897, 145 + 309);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 40) * 1e9, 32352, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 45) * 1e9, 34175, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 50) * 1e9, 36274, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 55) * 1e9, 38526, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 60) * 1e9, 40807, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 65) * 1e9, 43010, 145 + 430);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 70) * 1e9, 45060, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 75) * 1e9, 46901, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 80) * 1e9, 48493, 145 + 485);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 85) * 1e9, 49798, 145 + 498);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 90) * 1e9, 50785, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 95) * 1e9, 51445, 145 + 514);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 100) * 1e9, 51802, 145 + 518);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 105) * 1e9, 51916, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 110) * 1e9, 51868, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 115) * 1e9, 51734, 145 + 517);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 120) * 1e9, 51561, 145 + 516);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 125) * 1e9, 51355, 145 + 514);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 130) * 1e9, 51092, 145 + 511);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 135) * 1e9, 50739, 145 + 507);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 140) * 1e9, 50273, 145 + 503);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 145) * 1e9, 49688, 145 + 497);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 150) * 1e9, 48992, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 155) * 1e9, 48199, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 160) * 1e9, 47318, 145 + 473);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 165) * 1e9, 46359, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 170) * 1e9, 45337, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 175) * 1e9, 44274, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(-20, 180) * 1e9, 43192, 145 + 432);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -180) * 1e9, 40439, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -175) * 1e9, 39471, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -170) * 1e9, 38520, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -165) * 1e9, 37585, 145 + 376);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -160) * 1e9, 36664, 145 + 367);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -155) * 1e9, 35756, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -150) * 1e9, 34866, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -145) * 1e9, 34002, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -140) * 1e9, 33169, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -135) * 1e9, 32374, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -130) * 1e9, 31620, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -125) * 1e9, 30910, 145 + 309);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -120) * 1e9, 30237, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -115) * 1e9, 29590, 145 + 296);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -110) * 1e9, 28946, 145 + 289);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -105) * 1e9, 28276, 145 + 283);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -100) * 1e9, 27559, 145 + 276);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -95) * 1e9, 26790, 145 + 268);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -90) * 1e9, 25985, 145 + 260);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -85) * 1e9, 25184, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -80) * 1e9, 24437, 145 + 244);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -75) * 1e9, 23802, 145 + 238);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -70) * 1e9, 23330, 145 + 233);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -65) * 1e9, 23055, 145 + 231);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -60) * 1e9, 22991, 145 + 230);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -55) * 1e9, 23126, 145 + 231);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -50) * 1e9, 23427, 145 + 234);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -45) * 1e9, 23856, 145 + 239);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -40) * 1e9, 24376, 145 + 244);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -35) * 1e9, 24967, 145 + 250);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -30) * 1e9, 25623, 145 + 256);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -25) * 1e9, 26339, 145 + 263);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -20) * 1e9, 27098, 145 + 271);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -15) * 1e9, 27863, 145 + 279);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -10) * 1e9, 28578, 145 + 286);
	EXPECT_NEAR(get_mag_strength_tesla(-15, -5) * 1e9, 29186, 145 + 292);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 0) * 1e9, 29645, 145 + 296);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 5) * 1e9, 29945, 145 + 299);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 10) * 1e9, 30108, 145 + 301);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 15) * 1e9, 30188, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 20) * 1e9, 30270, 145 + 303);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 25) * 1e9, 30460, 145 + 305);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 30) * 1e9, 30874, 145 + 309);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 35) * 1e9, 31612, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 40) * 1e9, 32728, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 45) * 1e9, 34208, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 50) * 1e9, 35978, 145 + 360);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 55) * 1e9, 37922, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 60) * 1e9, 39919, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 65) * 1e9, 41865, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 70) * 1e9, 43683, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 75) * 1e9, 45317, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 80) * 1e9, 46717, 145 + 467);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 85) * 1e9, 47835, 145 + 478);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 90) * 1e9, 48631, 145 + 486);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 95) * 1e9, 49092, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 100) * 1e9, 49247, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 105) * 1e9, 49168, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 110) * 1e9, 48954, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 115) * 1e9, 48693, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 120) * 1e9, 48434, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 125) * 1e9, 48179, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 130) * 1e9, 47892, 145 + 479);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 135) * 1e9, 47528, 145 + 475);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 140) * 1e9, 47058, 145 + 471);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 145) * 1e9, 46479, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 150) * 1e9, 45802, 145 + 458);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 155) * 1e9, 45042, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 160) * 1e9, 44214, 145 + 442);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 165) * 1e9, 43324, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 170) * 1e9, 42385, 145 + 424);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 175) * 1e9, 41416, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(-15, 180) * 1e9, 40439, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -180) * 1e9, 37892, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -175) * 1e9, 37066, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -170) * 1e9, 36263, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -165) * 1e9, 35480, 145 + 355);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -160) * 1e9, 34714, 145 + 347);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -155) * 1e9, 33967, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -150) * 1e9, 33241, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -145) * 1e9, 32545, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -140) * 1e9, 31883, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -135) * 1e9, 31261, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -130) * 1e9, 30679, 145 + 307);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -125) * 1e9, 30139, 145 + 301);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -120) * 1e9, 29639, 145 + 296);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -115) * 1e9, 29166, 145 + 292);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -110) * 1e9, 28704, 145 + 287);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -105) * 1e9, 28226, 145 + 282);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -100) * 1e9, 27711, 145 + 277);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -95) * 1e9, 27149, 145 + 271);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -90) * 1e9, 26546, 145 + 265);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -85) * 1e9, 25926, 145 + 259);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -80) * 1e9, 25324, 145 + 253);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -75) * 1e9, 24785, 145 + 248);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -70) * 1e9, 24352, 145 + 244);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -65) * 1e9, 24063, 145 + 241);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -60) * 1e9, 23944, 145 + 239);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -55) * 1e9, 24006, 145 + 240);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -50) * 1e9, 24242, 145 + 242);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -45) * 1e9, 24630, 145 + 246);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -40) * 1e9, 25144, 145 + 251);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -35) * 1e9, 25756, 145 + 258);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -30) * 1e9, 26447, 145 + 264);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -25) * 1e9, 27201, 145 + 272);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -20) * 1e9, 27997, 145 + 280);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -15) * 1e9, 28798, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -10) * 1e9, 29555, 145 + 296);
	EXPECT_NEAR(get_mag_strength_tesla(-10, -5) * 1e9, 30216, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 0) * 1e9, 30740, 145 + 307);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 5) * 1e9, 31106, 145 + 311);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 10) * 1e9, 31320, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 15) * 1e9, 31415, 145 + 314);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 20) * 1e9, 31454, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 25) * 1e9, 31531, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 30) * 1e9, 31762, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 35) * 1e9, 32254, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 40) * 1e9, 33077, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 45) * 1e9, 34236, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 50) * 1e9, 35673, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 55) * 1e9, 37288, 145 + 373);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 60) * 1e9, 38971, 145 + 390);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 65) * 1e9, 40628, 145 + 406);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 70) * 1e9, 42189, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 75) * 1e9, 43597, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 80) * 1e9, 44800, 145 + 448);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 85) * 1e9, 45743, 145 + 457);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 90) * 1e9, 46377, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 95) * 1e9, 46685, 145 + 467);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 100) * 1e9, 46695, 145 + 467);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 105) * 1e9, 46485, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 110) * 1e9, 46158, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 115) * 1e9, 45807, 145 + 458);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 120) * 1e9, 45482, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 125) * 1e9, 45178, 145 + 452);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 130) * 1e9, 44855, 145 + 449);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 135) * 1e9, 44466, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 140) * 1e9, 43982, 145 + 440);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 145) * 1e9, 43399, 145 + 434);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 150) * 1e9, 42735, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 155) * 1e9, 42009, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 160) * 1e9, 41237, 145 + 412);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 165) * 1e9, 40426, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 170) * 1e9, 39588, 145 + 396);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 175) * 1e9, 38737, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(-10, 180) * 1e9, 37892, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -180) * 1e9, 35732, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -175) * 1e9, 35070, 145 + 351);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -170) * 1e9, 34435, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -165) * 1e9, 33822, 145 + 338);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -160) * 1e9, 33230, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -155) * 1e9, 32660, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -150) * 1e9, 32119, 145 + 321);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -145) * 1e9, 31615, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -140) * 1e9, 31150, 145 + 312);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -135) * 1e9, 30726, 145 + 307);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -130) * 1e9, 30340, 145 + 303);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -125) * 1e9, 29990, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -120) * 1e9, 29672, 145 + 297);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -115) * 1e9, 29380, 145 + 294);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -110) * 1e9, 29098, 145 + 291);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -105) * 1e9, 28806, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -100) * 1e9, 28482, 145 + 285);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -95) * 1e9, 28109, 145 + 281);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -90) * 1e9, 27682, 145 + 277);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -85) * 1e9, 27211, 145 + 272);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -80) * 1e9, 26718, 145 + 267);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -75) * 1e9, 26236, 145 + 262);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -70) * 1e9, 25804, 145 + 258);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -65) * 1e9, 25461, 145 + 255);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -60) * 1e9, 25244, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -55) * 1e9, 25185, 145 + 252);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -50) * 1e9, 25302, 145 + 253);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -45) * 1e9, 25596, 145 + 256);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -40) * 1e9, 26045, 145 + 260);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -35) * 1e9, 26620, 145 + 266);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -30) * 1e9, 27287, 145 + 273);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -25) * 1e9, 28017, 145 + 280);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -20) * 1e9, 28781, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -15) * 1e9, 29546, 145 + 295);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -10) * 1e9, 30274, 145 + 303);
	EXPECT_NEAR(get_mag_strength_tesla(-5, -5) * 1e9, 30924, 145 + 309);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 0) * 1e9, 31462, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 5) * 1e9, 31865, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 10) * 1e9, 32125, 145 + 321);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 15) * 1e9, 32257, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 20) * 1e9, 32306, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 25) * 1e9, 32350, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 30) * 1e9, 32492, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 35) * 1e9, 32834, 145 + 328);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 40) * 1e9, 33448, 145 + 334);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 45) * 1e9, 34348, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 50) * 1e9, 35489, 145 + 355);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 55) * 1e9, 36790, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 60) * 1e9, 38162, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 65) * 1e9, 39526, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 70) * 1e9, 40822, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 75) * 1e9, 42000, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 80) * 1e9, 43007, 145 + 430);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 85) * 1e9, 43786, 145 + 438);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 90) * 1e9, 44287, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 95) * 1e9, 44489, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 100) * 1e9, 44416, 145 + 444);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 105) * 1e9, 44139, 145 + 441);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 110) * 1e9, 43755, 145 + 438);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 115) * 1e9, 43349, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 120) * 1e9, 42965, 145 + 430);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 125) * 1e9, 42600, 145 + 426);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 130) * 1e9, 42220, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 135) * 1e9, 41782, 145 + 418);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 140) * 1e9, 41261, 145 + 413);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 145) * 1e9, 40661, 145 + 407);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 150) * 1e9, 40000, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 155) * 1e9, 39303, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 160) * 1e9, 38586, 145 + 386);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 165) * 1e9, 37860, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 170) * 1e9, 37135, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 175) * 1e9, 36422, 145 + 364);
	EXPECT_NEAR(get_mag_strength_tesla(-5, 180) * 1e9, 35732, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(0, -180) * 1e9, 34116, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(0, -175) * 1e9, 33629, 145 + 336);
	EXPECT_NEAR(get_mag_strength_tesla(0, -170) * 1e9, 33171, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(0, -165) * 1e9, 32734, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(0, -160) * 1e9, 32317, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(0, -155) * 1e9, 31929, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(0, -150) * 1e9, 31579, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(0, -145) * 1e9, 31276, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(0, -140) * 1e9, 31021, 145 + 310);
	EXPECT_NEAR(get_mag_strength_tesla(0, -135) * 1e9, 30810, 145 + 308);
	EXPECT_NEAR(get_mag_strength_tesla(0, -130) * 1e9, 30634, 145 + 306);
	EXPECT_NEAR(get_mag_strength_tesla(0, -125) * 1e9, 30486, 145 + 305);
	EXPECT_NEAR(get_mag_strength_tesla(0, -120) * 1e9, 30361, 145 + 304);
	EXPECT_NEAR(get_mag_strength_tesla(0, -115) * 1e9, 30252, 145 + 303);
	EXPECT_NEAR(get_mag_strength_tesla(0, -110) * 1e9, 30148, 145 + 301);
	EXPECT_NEAR(get_mag_strength_tesla(0, -105) * 1e9, 30032, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(0, -100) * 1e9, 29880, 145 + 299);
	EXPECT_NEAR(get_mag_strength_tesla(0, -95) * 1e9, 29667, 145 + 297);
	EXPECT_NEAR(get_mag_strength_tesla(0, -90) * 1e9, 29380, 145 + 294);
	EXPECT_NEAR(get_mag_strength_tesla(0, -85) * 1e9, 29014, 145 + 290);
	EXPECT_NEAR(get_mag_strength_tesla(0, -80) * 1e9, 28585, 145 + 286);
	EXPECT_NEAR(get_mag_strength_tesla(0, -75) * 1e9, 28120, 145 + 281);
	EXPECT_NEAR(get_mag_strength_tesla(0, -70) * 1e9, 27653, 145 + 277);
	EXPECT_NEAR(get_mag_strength_tesla(0, -65) * 1e9, 27227, 145 + 272);
	EXPECT_NEAR(get_mag_strength_tesla(0, -60) * 1e9, 26885, 145 + 269);
	EXPECT_NEAR(get_mag_strength_tesla(0, -55) * 1e9, 26673, 145 + 267);
	EXPECT_NEAR(get_mag_strength_tesla(0, -50) * 1e9, 26631, 145 + 266);
	EXPECT_NEAR(get_mag_strength_tesla(0, -45) * 1e9, 26777, 145 + 268);
	EXPECT_NEAR(get_mag_strength_tesla(0, -40) * 1e9, 27103, 145 + 271);
	EXPECT_NEAR(get_mag_strength_tesla(0, -35) * 1e9, 27577, 145 + 276);
	EXPECT_NEAR(get_mag_strength_tesla(0, -30) * 1e9, 28158, 145 + 282);
	EXPECT_NEAR(get_mag_strength_tesla(0, -25) * 1e9, 28805, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(0, -20) * 1e9, 29484, 145 + 295);
	EXPECT_NEAR(get_mag_strength_tesla(0, -15) * 1e9, 30166, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(0, -10) * 1e9, 30821, 145 + 308);
	EXPECT_NEAR(get_mag_strength_tesla(0, -5) * 1e9, 31424, 145 + 314);
	EXPECT_NEAR(get_mag_strength_tesla(0, 0) * 1e9, 31945, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(0, 5) * 1e9, 32364, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(0, 10) * 1e9, 32667, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(0, 15) * 1e9, 32856, 145 + 329);
	EXPECT_NEAR(get_mag_strength_tesla(0, 20) * 1e9, 32962, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(0, 25) * 1e9, 33046, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(0, 30) * 1e9, 33193, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(0, 35) * 1e9, 33488, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(0, 40) * 1e9, 33990, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(0, 45) * 1e9, 34710, 145 + 347);
	EXPECT_NEAR(get_mag_strength_tesla(0, 50) * 1e9, 35616, 145 + 356);
	EXPECT_NEAR(get_mag_strength_tesla(0, 55) * 1e9, 36649, 145 + 366);
	EXPECT_NEAR(get_mag_strength_tesla(0, 60) * 1e9, 37741, 145 + 377);
	EXPECT_NEAR(get_mag_strength_tesla(0, 65) * 1e9, 38836, 145 + 388);
	EXPECT_NEAR(get_mag_strength_tesla(0, 70) * 1e9, 39886, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(0, 75) * 1e9, 40846, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(0, 80) * 1e9, 41668, 145 + 417);
	EXPECT_NEAR(get_mag_strength_tesla(0, 85) * 1e9, 42300, 145 + 423);
	EXPECT_NEAR(get_mag_strength_tesla(0, 90) * 1e9, 42694, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(0, 95) * 1e9, 42830, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(0, 100) * 1e9, 42725, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(0, 105) * 1e9, 42435, 145 + 424);
	EXPECT_NEAR(get_mag_strength_tesla(0, 110) * 1e9, 42036, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(0, 115) * 1e9, 41595, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(0, 120) * 1e9, 41151, 145 + 412);
	EXPECT_NEAR(get_mag_strength_tesla(0, 125) * 1e9, 40705, 145 + 407);
	EXPECT_NEAR(get_mag_strength_tesla(0, 130) * 1e9, 40234, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(0, 135) * 1e9, 39712, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(0, 140) * 1e9, 39126, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(0, 145) * 1e9, 38485, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(0, 150) * 1e9, 37812, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(0, 155) * 1e9, 37131, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(0, 160) * 1e9, 36462, 145 + 365);
	EXPECT_NEAR(get_mag_strength_tesla(0, 165) * 1e9, 35819, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(0, 170) * 1e9, 35209, 145 + 352);
	EXPECT_NEAR(get_mag_strength_tesla(0, 175) * 1e9, 34641, 145 + 346);
	EXPECT_NEAR(get_mag_strength_tesla(0, 180) * 1e9, 34116, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(5, -180) * 1e9, 33140, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(5, -175) * 1e9, 32820, 145 + 328);
	EXPECT_NEAR(get_mag_strength_tesla(5, -170) * 1e9, 32531, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(5, -165) * 1e9, 32261, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(5, -160) * 1e9, 32013, 145 + 320);
	EXPECT_NEAR(get_mag_strength_tesla(5, -155) * 1e9, 31798, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(5, -150) * 1e9, 31633, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(5, -145) * 1e9, 31528, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(5, -140) * 1e9, 31482, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(5, -135) * 1e9, 31487, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(5, -130) * 1e9, 31526, 145 + 315);
	EXPECT_NEAR(get_mag_strength_tesla(5, -125) * 1e9, 31586, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(5, -120) * 1e9, 31658, 145 + 317);
	EXPECT_NEAR(get_mag_strength_tesla(5, -115) * 1e9, 31736, 145 + 317);
	EXPECT_NEAR(get_mag_strength_tesla(5, -110) * 1e9, 31808, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(5, -105) * 1e9, 31856, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(5, -100) * 1e9, 31852, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(5, -95) * 1e9, 31767, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(5, -90) * 1e9, 31576, 145 + 316);
	EXPECT_NEAR(get_mag_strength_tesla(5, -85) * 1e9, 31272, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(5, -80) * 1e9, 30865, 145 + 309);
	EXPECT_NEAR(get_mag_strength_tesla(5, -75) * 1e9, 30380, 145 + 304);
	EXPECT_NEAR(get_mag_strength_tesla(5, -70) * 1e9, 29852, 145 + 299);
	EXPECT_NEAR(get_mag_strength_tesla(5, -65) * 1e9, 29325, 145 + 293);
	EXPECT_NEAR(get_mag_strength_tesla(5, -60) * 1e9, 28847, 145 + 288);
	EXPECT_NEAR(get_mag_strength_tesla(5, -55) * 1e9, 28475, 145 + 285);
	EXPECT_NEAR(get_mag_strength_tesla(5, -50) * 1e9, 28258, 145 + 283);
	EXPECT_NEAR(get_mag_strength_tesla(5, -45) * 1e9, 28229, 145 + 282);
	EXPECT_NEAR(get_mag_strength_tesla(5, -40) * 1e9, 28390, 145 + 284);
	EXPECT_NEAR(get_mag_strength_tesla(5, -35) * 1e9, 28715, 145 + 287);
	EXPECT_NEAR(get_mag_strength_tesla(5, -30) * 1e9, 29161, 145 + 292);
	EXPECT_NEAR(get_mag_strength_tesla(5, -25) * 1e9, 29683, 145 + 297);
	EXPECT_NEAR(get_mag_strength_tesla(5, -20) * 1e9, 30247, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(5, -15) * 1e9, 30827, 145 + 308);
	EXPECT_NEAR(get_mag_strength_tesla(5, -10) * 1e9, 31401, 145 + 314);
	EXPECT_NEAR(get_mag_strength_tesla(5, -5) * 1e9, 31949, 145 + 319);
	EXPECT_NEAR(get_mag_strength_tesla(5, 0) * 1e9, 32449, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(5, 5) * 1e9, 32879, 145 + 329);
	EXPECT_NEAR(get_mag_strength_tesla(5, 10) * 1e9, 33225, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(5, 15) * 1e9, 33485, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(5, 20) * 1e9, 33681, 145 + 337);
	EXPECT_NEAR(get_mag_strength_tesla(5, 25) * 1e9, 33859, 145 + 339);
	EXPECT_NEAR(get_mag_strength_tesla(5, 30) * 1e9, 34083, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(5, 35) * 1e9, 34414, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(5, 40) * 1e9, 34886, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(5, 45) * 1e9, 35505, 145 + 355);
	EXPECT_NEAR(get_mag_strength_tesla(5, 50) * 1e9, 36246, 145 + 362);
	EXPECT_NEAR(get_mag_strength_tesla(5, 55) * 1e9, 37069, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(5, 60) * 1e9, 37936, 145 + 379);
	EXPECT_NEAR(get_mag_strength_tesla(5, 65) * 1e9, 38808, 145 + 388);
	EXPECT_NEAR(get_mag_strength_tesla(5, 70) * 1e9, 39652, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(5, 75) * 1e9, 40428, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(5, 80) * 1e9, 41093, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(5, 85) * 1e9, 41602, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(5, 90) * 1e9, 41915, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(5, 95) * 1e9, 42015, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(5, 100) * 1e9, 41910, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(5, 105) * 1e9, 41636, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(5, 110) * 1e9, 41243, 145 + 412);
	EXPECT_NEAR(get_mag_strength_tesla(5, 115) * 1e9, 40774, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(5, 120) * 1e9, 40257, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(5, 125) * 1e9, 39702, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(5, 130) * 1e9, 39105, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(5, 135) * 1e9, 38460, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(5, 140) * 1e9, 37774, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(5, 145) * 1e9, 37063, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(5, 150) * 1e9, 36352, 145 + 364);
	EXPECT_NEAR(get_mag_strength_tesla(5, 155) * 1e9, 35666, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(5, 160) * 1e9, 35027, 145 + 350);
	EXPECT_NEAR(get_mag_strength_tesla(5, 165) * 1e9, 34449, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(5, 170) * 1e9, 33943, 145 + 339);
	EXPECT_NEAR(get_mag_strength_tesla(5, 175) * 1e9, 33509, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(5, 180) * 1e9, 33140, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(10, -180) * 1e9, 32822, 145 + 328);
	EXPECT_NEAR(get_mag_strength_tesla(10, -175) * 1e9, 32642, 145 + 326);
	EXPECT_NEAR(get_mag_strength_tesla(10, -170) * 1e9, 32498, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(10, -165) * 1e9, 32377, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(10, -160) * 1e9, 32280, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(10, -155) * 1e9, 32225, 145 + 322);
	EXPECT_NEAR(get_mag_strength_tesla(10, -150) * 1e9, 32231, 145 + 322);
	EXPECT_NEAR(get_mag_strength_tesla(10, -145) * 1e9, 32312, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(10, -140) * 1e9, 32466, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(10, -135) * 1e9, 32678, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(10, -130) * 1e9, 32928, 145 + 329);
	EXPECT_NEAR(get_mag_strength_tesla(10, -125) * 1e9, 33195, 145 + 332);
	EXPECT_NEAR(get_mag_strength_tesla(10, -120) * 1e9, 33466, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(10, -115) * 1e9, 33729, 145 + 337);
	EXPECT_NEAR(get_mag_strength_tesla(10, -110) * 1e9, 33971, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(10, -105) * 1e9, 34170, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(10, -100) * 1e9, 34294, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(10, -95) * 1e9, 34306, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(10, -90) * 1e9, 34179, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(10, -85) * 1e9, 33902, 145 + 339);
	EXPECT_NEAR(get_mag_strength_tesla(10, -80) * 1e9, 33485, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(10, -75) * 1e9, 32953, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(10, -70) * 1e9, 32346, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(10, -65) * 1e9, 31712, 145 + 317);
	EXPECT_NEAR(get_mag_strength_tesla(10, -60) * 1e9, 31104, 145 + 311);
	EXPECT_NEAR(get_mag_strength_tesla(10, -55) * 1e9, 30583, 145 + 306);
	EXPECT_NEAR(get_mag_strength_tesla(10, -50) * 1e9, 30204, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(10, -45) * 1e9, 30006, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(10, -40) * 1e9, 29996, 145 + 300);
	EXPECT_NEAR(get_mag_strength_tesla(10, -35) * 1e9, 30155, 145 + 302);
	EXPECT_NEAR(get_mag_strength_tesla(10, -30) * 1e9, 30445, 145 + 304);
	EXPECT_NEAR(get_mag_strength_tesla(10, -25) * 1e9, 30827, 145 + 308);
	EXPECT_NEAR(get_mag_strength_tesla(10, -20) * 1e9, 31269, 145 + 313);
	EXPECT_NEAR(get_mag_strength_tesla(10, -15) * 1e9, 31752, 145 + 318);
	EXPECT_NEAR(get_mag_strength_tesla(10, -10) * 1e9, 32256, 145 + 323);
	EXPECT_NEAR(get_mag_strength_tesla(10, -5) * 1e9, 32764, 145 + 328);
	EXPECT_NEAR(get_mag_strength_tesla(10, 0) * 1e9, 33254, 145 + 333);
	EXPECT_NEAR(get_mag_strength_tesla(10, 5) * 1e9, 33703, 145 + 337);
	EXPECT_NEAR(get_mag_strength_tesla(10, 10) * 1e9, 34096, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(10, 15) * 1e9, 34431, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(10, 20) * 1e9, 34728, 145 + 347);
	EXPECT_NEAR(get_mag_strength_tesla(10, 25) * 1e9, 35023, 145 + 350);
	EXPECT_NEAR(get_mag_strength_tesla(10, 30) * 1e9, 35360, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(10, 35) * 1e9, 35770, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(10, 40) * 1e9, 36267, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(10, 45) * 1e9, 36842, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(10, 50) * 1e9, 37478, 145 + 375);
	EXPECT_NEAR(get_mag_strength_tesla(10, 55) * 1e9, 38156, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(10, 60) * 1e9, 38858, 145 + 389);
	EXPECT_NEAR(get_mag_strength_tesla(10, 65) * 1e9, 39568, 145 + 396);
	EXPECT_NEAR(get_mag_strength_tesla(10, 70) * 1e9, 40260, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(10, 75) * 1e9, 40903, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(10, 80) * 1e9, 41455, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(10, 85) * 1e9, 41877, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(10, 90) * 1e9, 42139, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(10, 95) * 1e9, 42225, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(10, 100) * 1e9, 42136, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(10, 105) * 1e9, 41888, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(10, 110) * 1e9, 41501, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(10, 115) * 1e9, 40997, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(10, 120) * 1e9, 40393, 145 + 404);
	EXPECT_NEAR(get_mag_strength_tesla(10, 125) * 1e9, 39706, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(10, 130) * 1e9, 38953, 145 + 390);
	EXPECT_NEAR(get_mag_strength_tesla(10, 135) * 1e9, 38154, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(10, 140) * 1e9, 37333, 145 + 373);
	EXPECT_NEAR(get_mag_strength_tesla(10, 145) * 1e9, 36518, 145 + 365);
	EXPECT_NEAR(get_mag_strength_tesla(10, 150) * 1e9, 35736, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(10, 155) * 1e9, 35014, 145 + 350);
	EXPECT_NEAR(get_mag_strength_tesla(10, 160) * 1e9, 34373, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(10, 165) * 1e9, 33830, 145 + 338);
	EXPECT_NEAR(get_mag_strength_tesla(10, 170) * 1e9, 33395, 145 + 334);
	EXPECT_NEAR(get_mag_strength_tesla(10, 175) * 1e9, 33064, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(10, 180) * 1e9, 32822, 145 + 328);
	EXPECT_NEAR(get_mag_strength_tesla(15, -180) * 1e9, 33124, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(15, -175) * 1e9, 33042, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(15, -170) * 1e9, 33010, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(15, -165) * 1e9, 33010, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(15, -160) * 1e9, 33046, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(15, -155) * 1e9, 33134, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(15, -150) * 1e9, 33296, 145 + 333);
	EXPECT_NEAR(get_mag_strength_tesla(15, -145) * 1e9, 33547, 145 + 335);
	EXPECT_NEAR(get_mag_strength_tesla(15, -140) * 1e9, 33883, 145 + 339);
	EXPECT_NEAR(get_mag_strength_tesla(15, -135) * 1e9, 34288, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(15, -130) * 1e9, 34735, 145 + 347);
	EXPECT_NEAR(get_mag_strength_tesla(15, -125) * 1e9, 35198, 145 + 352);
	EXPECT_NEAR(get_mag_strength_tesla(15, -120) * 1e9, 35659, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(15, -115) * 1e9, 36100, 145 + 361);
	EXPECT_NEAR(get_mag_strength_tesla(15, -110) * 1e9, 36503, 145 + 365);
	EXPECT_NEAR(get_mag_strength_tesla(15, -105) * 1e9, 36840, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(15, -100) * 1e9, 37074, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(15, -95) * 1e9, 37164, 145 + 372);
	EXPECT_NEAR(get_mag_strength_tesla(15, -90) * 1e9, 37081, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(15, -85) * 1e9, 36812, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(15, -80) * 1e9, 36367, 145 + 364);
	EXPECT_NEAR(get_mag_strength_tesla(15, -75) * 1e9, 35776, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(15, -70) * 1e9, 35086, 145 + 351);
	EXPECT_NEAR(get_mag_strength_tesla(15, -65) * 1e9, 34348, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(15, -60) * 1e9, 33624, 145 + 336);
	EXPECT_NEAR(get_mag_strength_tesla(15, -55) * 1e9, 32979, 145 + 330);
	EXPECT_NEAR(get_mag_strength_tesla(15, -50) * 1e9, 32468, 145 + 325);
	EXPECT_NEAR(get_mag_strength_tesla(15, -45) * 1e9, 32130, 145 + 321);
	EXPECT_NEAR(get_mag_strength_tesla(15, -40) * 1e9, 31974, 145 + 320);
	EXPECT_NEAR(get_mag_strength_tesla(15, -35) * 1e9, 31983, 145 + 320);
	EXPECT_NEAR(get_mag_strength_tesla(15, -30) * 1e9, 32128, 145 + 321);
	EXPECT_NEAR(get_mag_strength_tesla(15, -25) * 1e9, 32377, 145 + 324);
	EXPECT_NEAR(get_mag_strength_tesla(15, -20) * 1e9, 32709, 145 + 327);
	EXPECT_NEAR(get_mag_strength_tesla(15, -15) * 1e9, 33109, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(15, -10) * 1e9, 33562, 145 + 336);
	EXPECT_NEAR(get_mag_strength_tesla(15, -5) * 1e9, 34050, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(15, 0) * 1e9, 34544, 145 + 345);
	EXPECT_NEAR(get_mag_strength_tesla(15, 5) * 1e9, 35019, 145 + 350);
	EXPECT_NEAR(get_mag_strength_tesla(15, 10) * 1e9, 35458, 145 + 355);
	EXPECT_NEAR(get_mag_strength_tesla(15, 15) * 1e9, 35862, 145 + 359);
	EXPECT_NEAR(get_mag_strength_tesla(15, 20) * 1e9, 36252, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(15, 25) * 1e9, 36655, 145 + 367);
	EXPECT_NEAR(get_mag_strength_tesla(15, 30) * 1e9, 37098, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(15, 35) * 1e9, 37593, 145 + 376);
	EXPECT_NEAR(get_mag_strength_tesla(15, 40) * 1e9, 38131, 145 + 381);
	EXPECT_NEAR(get_mag_strength_tesla(15, 45) * 1e9, 38696, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(15, 50) * 1e9, 39276, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(15, 55) * 1e9, 39864, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(15, 60) * 1e9, 40465, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(15, 65) * 1e9, 41074, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(15, 70) * 1e9, 41677, 145 + 417);
	EXPECT_NEAR(get_mag_strength_tesla(15, 75) * 1e9, 42243, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(15, 80) * 1e9, 42735, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(15, 85) * 1e9, 43117, 145 + 431);
	EXPECT_NEAR(get_mag_strength_tesla(15, 90) * 1e9, 43362, 145 + 434);
	EXPECT_NEAR(get_mag_strength_tesla(15, 95) * 1e9, 43456, 145 + 435);
	EXPECT_NEAR(get_mag_strength_tesla(15, 100) * 1e9, 43390, 145 + 434);
	EXPECT_NEAR(get_mag_strength_tesla(15, 105) * 1e9, 43163, 145 + 432);
	EXPECT_NEAR(get_mag_strength_tesla(15, 110) * 1e9, 42773, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(15, 115) * 1e9, 42224, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(15, 120) * 1e9, 41524, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(15, 125) * 1e9, 40697, 145 + 407);
	EXPECT_NEAR(get_mag_strength_tesla(15, 130) * 1e9, 39776, 145 + 398);
	EXPECT_NEAR(get_mag_strength_tesla(15, 135) * 1e9, 38804, 145 + 388);
	EXPECT_NEAR(get_mag_strength_tesla(15, 140) * 1e9, 37824, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(15, 145) * 1e9, 36874, 145 + 369);
	EXPECT_NEAR(get_mag_strength_tesla(15, 150) * 1e9, 35990, 145 + 360);
	EXPECT_NEAR(get_mag_strength_tesla(15, 155) * 1e9, 35197, 145 + 352);
	EXPECT_NEAR(get_mag_strength_tesla(15, 160) * 1e9, 34518, 145 + 345);
	EXPECT_NEAR(get_mag_strength_tesla(15, 165) * 1e9, 33970, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(15, 170) * 1e9, 33561, 145 + 336);
	EXPECT_NEAR(get_mag_strength_tesla(15, 175) * 1e9, 33286, 145 + 333);
	EXPECT_NEAR(get_mag_strength_tesla(15, 180) * 1e9, 33124, 145 + 331);
	EXPECT_NEAR(get_mag_strength_tesla(20, -180) * 1e9, 33988, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(20, -175) * 1e9, 33956, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(20, -170) * 1e9, 33997, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(20, -165) * 1e9, 34091, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(20, -160) * 1e9, 34239, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(20, -155) * 1e9, 34455, 145 + 345);
	EXPECT_NEAR(get_mag_strength_tesla(20, -150) * 1e9, 34759, 145 + 348);
	EXPECT_NEAR(get_mag_strength_tesla(20, -145) * 1e9, 35163, 145 + 352);
	EXPECT_NEAR(get_mag_strength_tesla(20, -140) * 1e9, 35662, 145 + 357);
	EXPECT_NEAR(get_mag_strength_tesla(20, -135) * 1e9, 36237, 145 + 362);
	EXPECT_NEAR(get_mag_strength_tesla(20, -130) * 1e9, 36857, 145 + 369);
	EXPECT_NEAR(get_mag_strength_tesla(20, -125) * 1e9, 37495, 145 + 375);
	EXPECT_NEAR(get_mag_strength_tesla(20, -120) * 1e9, 38125, 145 + 381);
	EXPECT_NEAR(get_mag_strength_tesla(20, -115) * 1e9, 38725, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(20, -110) * 1e9, 39271, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(20, -105) * 1e9, 39729, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(20, -100) * 1e9, 40058, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(20, -95) * 1e9, 40214, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(20, -90) * 1e9, 40166, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(20, -85) * 1e9, 39900, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(20, -80) * 1e9, 39429, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(20, -75) * 1e9, 38784, 145 + 388);
	EXPECT_NEAR(get_mag_strength_tesla(20, -70) * 1e9, 38017, 145 + 380);
	EXPECT_NEAR(get_mag_strength_tesla(20, -65) * 1e9, 37190, 145 + 372);
	EXPECT_NEAR(get_mag_strength_tesla(20, -60) * 1e9, 36372, 145 + 364);
	EXPECT_NEAR(get_mag_strength_tesla(20, -55) * 1e9, 35630, 145 + 356);
	EXPECT_NEAR(get_mag_strength_tesla(20, -50) * 1e9, 35021, 145 + 350);
	EXPECT_NEAR(get_mag_strength_tesla(20, -45) * 1e9, 34579, 145 + 346);
	EXPECT_NEAR(get_mag_strength_tesla(20, -40) * 1e9, 34311, 145 + 343);
	EXPECT_NEAR(get_mag_strength_tesla(20, -35) * 1e9, 34203, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(20, -30) * 1e9, 34229, 145 + 342);
	EXPECT_NEAR(get_mag_strength_tesla(20, -25) * 1e9, 34368, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(20, -20) * 1e9, 34607, 145 + 346);
	EXPECT_NEAR(get_mag_strength_tesla(20, -15) * 1e9, 34939, 145 + 349);
	EXPECT_NEAR(get_mag_strength_tesla(20, -10) * 1e9, 35353, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(20, -5) * 1e9, 35828, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(20, 0) * 1e9, 36330, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(20, 5) * 1e9, 36830, 145 + 368);
	EXPECT_NEAR(get_mag_strength_tesla(20, 10) * 1e9, 37308, 145 + 373);
	EXPECT_NEAR(get_mag_strength_tesla(20, 15) * 1e9, 37765, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(20, 20) * 1e9, 38221, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(20, 25) * 1e9, 38701, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(20, 30) * 1e9, 39219, 145 + 392);
	EXPECT_NEAR(get_mag_strength_tesla(20, 35) * 1e9, 39773, 145 + 398);
	EXPECT_NEAR(get_mag_strength_tesla(20, 40) * 1e9, 40345, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(20, 45) * 1e9, 40914, 145 + 409);
	EXPECT_NEAR(get_mag_strength_tesla(20, 50) * 1e9, 41472, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(20, 55) * 1e9, 42022, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(20, 60) * 1e9, 42578, 145 + 426);
	EXPECT_NEAR(get_mag_strength_tesla(20, 65) * 1e9, 43147, 145 + 431);
	EXPECT_NEAR(get_mag_strength_tesla(20, 70) * 1e9, 43718, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(20, 75) * 1e9, 44265, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(20, 80) * 1e9, 44750, 145 + 447);
	EXPECT_NEAR(get_mag_strength_tesla(20, 85) * 1e9, 45137, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(20, 90) * 1e9, 45400, 145 + 454);
	EXPECT_NEAR(get_mag_strength_tesla(20, 95) * 1e9, 45520, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(20, 100) * 1e9, 45482, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(20, 105) * 1e9, 45271, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(20, 110) * 1e9, 44871, 145 + 449);
	EXPECT_NEAR(get_mag_strength_tesla(20, 115) * 1e9, 44273, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(20, 120) * 1e9, 43481, 145 + 435);
	EXPECT_NEAR(get_mag_strength_tesla(20, 125) * 1e9, 42522, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(20, 130) * 1e9, 41444, 145 + 414);
	EXPECT_NEAR(get_mag_strength_tesla(20, 135) * 1e9, 40303, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(20, 140) * 1e9, 39159, 145 + 392);
	EXPECT_NEAR(get_mag_strength_tesla(20, 145) * 1e9, 38063, 145 + 381);
	EXPECT_NEAR(get_mag_strength_tesla(20, 150) * 1e9, 37056, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(20, 155) * 1e9, 36166, 145 + 362);
	EXPECT_NEAR(get_mag_strength_tesla(20, 160) * 1e9, 35416, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(20, 165) * 1e9, 34823, 145 + 348);
	EXPECT_NEAR(get_mag_strength_tesla(20, 170) * 1e9, 34394, 145 + 344);
	EXPECT_NEAR(get_mag_strength_tesla(20, 175) * 1e9, 34123, 145 + 341);
	EXPECT_NEAR(get_mag_strength_tesla(20, 180) * 1e9, 33988, 145 + 340);
	EXPECT_NEAR(get_mag_strength_tesla(25, -180) * 1e9, 35364, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(25, -175) * 1e9, 35340, 145 + 353);
	EXPECT_NEAR(get_mag_strength_tesla(25, -170) * 1e9, 35416, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(25, -165) * 1e9, 35577, 145 + 356);
	EXPECT_NEAR(get_mag_strength_tesla(25, -160) * 1e9, 35817, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(25, -155) * 1e9, 36148, 145 + 361);
	EXPECT_NEAR(get_mag_strength_tesla(25, -150) * 1e9, 36580, 145 + 366);
	EXPECT_NEAR(get_mag_strength_tesla(25, -145) * 1e9, 37120, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(25, -140) * 1e9, 37759, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(25, -135) * 1e9, 38475, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(25, -130) * 1e9, 39238, 145 + 392);
	EXPECT_NEAR(get_mag_strength_tesla(25, -125) * 1e9, 40016, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(25, -120) * 1e9, 40783, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(25, -115) * 1e9, 41510, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(25, -110) * 1e9, 42170, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(25, -105) * 1e9, 42724, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(25, -100) * 1e9, 43128, 145 + 431);
	EXPECT_NEAR(get_mag_strength_tesla(25, -95) * 1e9, 43339, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(25, -90) * 1e9, 43323, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(25, -85) * 1e9, 43066, 145 + 431);
	EXPECT_NEAR(get_mag_strength_tesla(25, -80) * 1e9, 42579, 145 + 426);
	EXPECT_NEAR(get_mag_strength_tesla(25, -75) * 1e9, 41897, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(25, -70) * 1e9, 41076, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(25, -65) * 1e9, 40183, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(25, -60) * 1e9, 39295, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(25, -55) * 1e9, 38482, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(25, -50) * 1e9, 37800, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(25, -45) * 1e9, 37281, 145 + 373);
	EXPECT_NEAR(get_mag_strength_tesla(25, -40) * 1e9, 36929, 145 + 369);
	EXPECT_NEAR(get_mag_strength_tesla(25, -35) * 1e9, 36730, 145 + 367);
	EXPECT_NEAR(get_mag_strength_tesla(25, -30) * 1e9, 36663, 145 + 367);
	EXPECT_NEAR(get_mag_strength_tesla(25, -25) * 1e9, 36713, 145 + 367);
	EXPECT_NEAR(get_mag_strength_tesla(25, -20) * 1e9, 36875, 145 + 369);
	EXPECT_NEAR(get_mag_strength_tesla(25, -15) * 1e9, 37148, 145 + 371);
	EXPECT_NEAR(get_mag_strength_tesla(25, -10) * 1e9, 37522, 145 + 375);
	EXPECT_NEAR(get_mag_strength_tesla(25, -5) * 1e9, 37976, 145 + 380);
	EXPECT_NEAR(get_mag_strength_tesla(25, 0) * 1e9, 38476, 145 + 385);
	EXPECT_NEAR(get_mag_strength_tesla(25, 5) * 1e9, 38986, 145 + 390);
	EXPECT_NEAR(get_mag_strength_tesla(25, 10) * 1e9, 39486, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(25, 15) * 1e9, 39974, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(25, 20) * 1e9, 40466, 145 + 405);
	EXPECT_NEAR(get_mag_strength_tesla(25, 25) * 1e9, 40983, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(25, 30) * 1e9, 41535, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(25, 35) * 1e9, 42115, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(25, 40) * 1e9, 42704, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(25, 45) * 1e9, 43282, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(25, 50) * 1e9, 43844, 145 + 438);
	EXPECT_NEAR(get_mag_strength_tesla(25, 55) * 1e9, 44399, 145 + 444);
	EXPECT_NEAR(get_mag_strength_tesla(25, 60) * 1e9, 44962, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(25, 65) * 1e9, 45544, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(25, 70) * 1e9, 46135, 145 + 461);
	EXPECT_NEAR(get_mag_strength_tesla(25, 75) * 1e9, 46710, 145 + 467);
	EXPECT_NEAR(get_mag_strength_tesla(25, 80) * 1e9, 47231, 145 + 472);
	EXPECT_NEAR(get_mag_strength_tesla(25, 85) * 1e9, 47660, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(25, 90) * 1e9, 47968, 145 + 480);
	EXPECT_NEAR(get_mag_strength_tesla(25, 95) * 1e9, 48130, 145 + 481);
	EXPECT_NEAR(get_mag_strength_tesla(25, 100) * 1e9, 48124, 145 + 481);
	EXPECT_NEAR(get_mag_strength_tesla(25, 105) * 1e9, 47926, 145 + 479);
	EXPECT_NEAR(get_mag_strength_tesla(25, 110) * 1e9, 47514, 145 + 475);
	EXPECT_NEAR(get_mag_strength_tesla(25, 115) * 1e9, 46873, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(25, 120) * 1e9, 46005, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(25, 125) * 1e9, 44942, 145 + 449);
	EXPECT_NEAR(get_mag_strength_tesla(25, 130) * 1e9, 43736, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(25, 135) * 1e9, 42455, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(25, 140) * 1e9, 41170, 145 + 412);
	EXPECT_NEAR(get_mag_strength_tesla(25, 145) * 1e9, 39940, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(25, 150) * 1e9, 38811, 145 + 388);
	EXPECT_NEAR(get_mag_strength_tesla(25, 155) * 1e9, 37817, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(25, 160) * 1e9, 36979, 145 + 370);
	EXPECT_NEAR(get_mag_strength_tesla(25, 165) * 1e9, 36314, 145 + 363);
	EXPECT_NEAR(get_mag_strength_tesla(25, 170) * 1e9, 35829, 145 + 358);
	EXPECT_NEAR(get_mag_strength_tesla(25, 175) * 1e9, 35518, 145 + 355);
	EXPECT_NEAR(get_mag_strength_tesla(25, 180) * 1e9, 35364, 145 + 354);
	EXPECT_NEAR(get_mag_strength_tesla(30, -180) * 1e9, 37218, 145 + 372);
	EXPECT_NEAR(get_mag_strength_tesla(30, -175) * 1e9, 37170, 145 + 372);
	EXPECT_NEAR(get_mag_strength_tesla(30, -170) * 1e9, 37254, 145 + 373);
	EXPECT_NEAR(get_mag_strength_tesla(30, -165) * 1e9, 37456, 145 + 375);
	EXPECT_NEAR(get_mag_strength_tesla(30, -160) * 1e9, 37770, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(30, -155) * 1e9, 38196, 145 + 382);
	EXPECT_NEAR(get_mag_strength_tesla(30, -150) * 1e9, 38739, 145 + 387);
	EXPECT_NEAR(get_mag_strength_tesla(30, -145) * 1e9, 39394, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(30, -140) * 1e9, 40146, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(30, -135) * 1e9, 40971, 145 + 410);
	EXPECT_NEAR(get_mag_strength_tesla(30, -130) * 1e9, 41838, 145 + 418);
	EXPECT_NEAR(get_mag_strength_tesla(30, -125) * 1e9, 42716, 145 + 427);
	EXPECT_NEAR(get_mag_strength_tesla(30, -120) * 1e9, 43575, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(30, -115) * 1e9, 44386, 145 + 444);
	EXPECT_NEAR(get_mag_strength_tesla(30, -110) * 1e9, 45119, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(30, -105) * 1e9, 45733, 145 + 457);
	EXPECT_NEAR(get_mag_strength_tesla(30, -100) * 1e9, 46186, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(30, -95) * 1e9, 46433, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(30, -90) * 1e9, 46443, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(30, -85) * 1e9, 46200, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(30, -80) * 1e9, 45713, 145 + 457);
	EXPECT_NEAR(get_mag_strength_tesla(30, -75) * 1e9, 45019, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(30, -70) * 1e9, 44172, 145 + 442);
	EXPECT_NEAR(get_mag_strength_tesla(30, -65) * 1e9, 43245, 145 + 432);
	EXPECT_NEAR(get_mag_strength_tesla(30, -60) * 1e9, 42314, 145 + 423);
	EXPECT_NEAR(get_mag_strength_tesla(30, -55) * 1e9, 41453, 145 + 415);
	EXPECT_NEAR(get_mag_strength_tesla(30, -50) * 1e9, 40715, 145 + 407);
	EXPECT_NEAR(get_mag_strength_tesla(30, -45) * 1e9, 40132, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(30, -40) * 1e9, 39708, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(30, -35) * 1e9, 39431, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(30, -30) * 1e9, 39284, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(30, -25) * 1e9, 39258, 145 + 393);
	EXPECT_NEAR(get_mag_strength_tesla(30, -20) * 1e9, 39351, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(30, -15) * 1e9, 39563, 145 + 396);
	EXPECT_NEAR(get_mag_strength_tesla(30, -10) * 1e9, 39888, 145 + 399);
	EXPECT_NEAR(get_mag_strength_tesla(30, -5) * 1e9, 40305, 145 + 403);
	EXPECT_NEAR(get_mag_strength_tesla(30, 0) * 1e9, 40780, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(30, 5) * 1e9, 41278, 145 + 413);
	EXPECT_NEAR(get_mag_strength_tesla(30, 10) * 1e9, 41775, 145 + 418);
	EXPECT_NEAR(get_mag_strength_tesla(30, 15) * 1e9, 42267, 145 + 423);
	EXPECT_NEAR(get_mag_strength_tesla(30, 20) * 1e9, 42765, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(30, 25) * 1e9, 43286, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(30, 30) * 1e9, 43838, 145 + 438);
	EXPECT_NEAR(get_mag_strength_tesla(30, 35) * 1e9, 44418, 145 + 444);
	EXPECT_NEAR(get_mag_strength_tesla(30, 40) * 1e9, 45010, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(30, 45) * 1e9, 45602, 145 + 456);
	EXPECT_NEAR(get_mag_strength_tesla(30, 50) * 1e9, 46190, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(30, 55) * 1e9, 46785, 145 + 468);
	EXPECT_NEAR(get_mag_strength_tesla(30, 60) * 1e9, 47398, 145 + 474);
	EXPECT_NEAR(get_mag_strength_tesla(30, 65) * 1e9, 48036, 145 + 480);
	EXPECT_NEAR(get_mag_strength_tesla(30, 70) * 1e9, 48687, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(30, 75) * 1e9, 49325, 145 + 493);
	EXPECT_NEAR(get_mag_strength_tesla(30, 80) * 1e9, 49910, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(30, 85) * 1e9, 50403, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(30, 90) * 1e9, 50769, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(30, 95) * 1e9, 50979, 145 + 510);
	EXPECT_NEAR(get_mag_strength_tesla(30, 100) * 1e9, 51005, 145 + 510);
	EXPECT_NEAR(get_mag_strength_tesla(30, 105) * 1e9, 50821, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(30, 110) * 1e9, 50400, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(30, 115) * 1e9, 49729, 145 + 497);
	EXPECT_NEAR(get_mag_strength_tesla(30, 120) * 1e9, 48813, 145 + 488);
	EXPECT_NEAR(get_mag_strength_tesla(30, 125) * 1e9, 47684, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(30, 130) * 1e9, 46398, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(30, 135) * 1e9, 45028, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(30, 140) * 1e9, 43646, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(30, 145) * 1e9, 42319, 145 + 423);
	EXPECT_NEAR(get_mag_strength_tesla(30, 150) * 1e9, 41096, 145 + 411);
	EXPECT_NEAR(get_mag_strength_tesla(30, 155) * 1e9, 40013, 145 + 400);
	EXPECT_NEAR(get_mag_strength_tesla(30, 160) * 1e9, 39093, 145 + 391);
	EXPECT_NEAR(get_mag_strength_tesla(30, 165) * 1e9, 38351, 145 + 384);
	EXPECT_NEAR(get_mag_strength_tesla(30, 170) * 1e9, 37794, 145 + 378);
	EXPECT_NEAR(get_mag_strength_tesla(30, 175) * 1e9, 37420, 145 + 374);
	EXPECT_NEAR(get_mag_strength_tesla(30, 180) * 1e9, 37218, 145 + 372);
	EXPECT_NEAR(get_mag_strength_tesla(35, -180) * 1e9, 39520, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(35, -175) * 1e9, 39434, 145 + 394);
	EXPECT_NEAR(get_mag_strength_tesla(35, -170) * 1e9, 39508, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(35, -165) * 1e9, 39731, 145 + 397);
	EXPECT_NEAR(get_mag_strength_tesla(35, -160) * 1e9, 40095, 145 + 401);
	EXPECT_NEAR(get_mag_strength_tesla(35, -155) * 1e9, 40594, 145 + 406);
	EXPECT_NEAR(get_mag_strength_tesla(35, -150) * 1e9, 41220, 145 + 412);
	EXPECT_NEAR(get_mag_strength_tesla(35, -145) * 1e9, 41959, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(35, -140) * 1e9, 42790, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(35, -135) * 1e9, 43684, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(35, -130) * 1e9, 44612, 145 + 446);
	EXPECT_NEAR(get_mag_strength_tesla(35, -125) * 1e9, 45540, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(35, -120) * 1e9, 46441, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(35, -115) * 1e9, 47286, 145 + 473);
	EXPECT_NEAR(get_mag_strength_tesla(35, -110) * 1e9, 48042, 145 + 480);
	EXPECT_NEAR(get_mag_strength_tesla(35, -105) * 1e9, 48674, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(35, -100) * 1e9, 49139, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(35, -95) * 1e9, 49398, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(35, -90) * 1e9, 49420, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(35, -85) * 1e9, 49191, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(35, -80) * 1e9, 48718, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(35, -75) * 1e9, 48034, 145 + 480);
	EXPECT_NEAR(get_mag_strength_tesla(35, -70) * 1e9, 47193, 145 + 472);
	EXPECT_NEAR(get_mag_strength_tesla(35, -65) * 1e9, 46262, 145 + 463);
	EXPECT_NEAR(get_mag_strength_tesla(35, -60) * 1e9, 45318, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(35, -55) * 1e9, 44429, 145 + 444);
	EXPECT_NEAR(get_mag_strength_tesla(35, -50) * 1e9, 43649, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(35, -45) * 1e9, 43008, 145 + 430);
	EXPECT_NEAR(get_mag_strength_tesla(35, -40) * 1e9, 42516, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(35, -35) * 1e9, 42164, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(35, -30) * 1e9, 41942, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(35, -25) * 1e9, 41842, 145 + 418);
	EXPECT_NEAR(get_mag_strength_tesla(35, -20) * 1e9, 41864, 145 + 419);
	EXPECT_NEAR(get_mag_strength_tesla(35, -15) * 1e9, 42009, 145 + 420);
	EXPECT_NEAR(get_mag_strength_tesla(35, -10) * 1e9, 42271, 145 + 423);
	EXPECT_NEAR(get_mag_strength_tesla(35, -5) * 1e9, 42629, 145 + 426);
	EXPECT_NEAR(get_mag_strength_tesla(35, 0) * 1e9, 43053, 145 + 431);
	EXPECT_NEAR(get_mag_strength_tesla(35, 5) * 1e9, 43512, 145 + 435);
	EXPECT_NEAR(get_mag_strength_tesla(35, 10) * 1e9, 43980, 145 + 440);
	EXPECT_NEAR(get_mag_strength_tesla(35, 15) * 1e9, 44451, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(35, 20) * 1e9, 44932, 145 + 449);
	EXPECT_NEAR(get_mag_strength_tesla(35, 25) * 1e9, 45434, 145 + 454);
	EXPECT_NEAR(get_mag_strength_tesla(35, 30) * 1e9, 45968, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(35, 35) * 1e9, 46534, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(35, 40) * 1e9, 47127, 145 + 471);
	EXPECT_NEAR(get_mag_strength_tesla(35, 45) * 1e9, 47741, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(35, 50) * 1e9, 48374, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(35, 55) * 1e9, 49034, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(35, 60) * 1e9, 49725, 145 + 497);
	EXPECT_NEAR(get_mag_strength_tesla(35, 65) * 1e9, 50447, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(35, 70) * 1e9, 51182, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(35, 75) * 1e9, 51900, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(35, 80) * 1e9, 52560, 145 + 526);
	EXPECT_NEAR(get_mag_strength_tesla(35, 85) * 1e9, 53122, 145 + 531);
	EXPECT_NEAR(get_mag_strength_tesla(35, 90) * 1e9, 53546, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(35, 95) * 1e9, 53800, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(35, 100) * 1e9, 53855, 145 + 539);
	EXPECT_NEAR(get_mag_strength_tesla(35, 105) * 1e9, 53681, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(35, 110) * 1e9, 53259, 145 + 533);
	EXPECT_NEAR(get_mag_strength_tesla(35, 115) * 1e9, 52577, 145 + 526);
	EXPECT_NEAR(get_mag_strength_tesla(35, 120) * 1e9, 51646, 145 + 516);
	EXPECT_NEAR(get_mag_strength_tesla(35, 125) * 1e9, 50498, 145 + 505);
	EXPECT_NEAR(get_mag_strength_tesla(35, 130) * 1e9, 49190, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(35, 135) * 1e9, 47791, 145 + 478);
	EXPECT_NEAR(get_mag_strength_tesla(35, 140) * 1e9, 46376, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(35, 145) * 1e9, 45008, 145 + 450);
	EXPECT_NEAR(get_mag_strength_tesla(35, 150) * 1e9, 43741, 145 + 437);
	EXPECT_NEAR(get_mag_strength_tesla(35, 155) * 1e9, 42608, 145 + 426);
	EXPECT_NEAR(get_mag_strength_tesla(35, 160) * 1e9, 41634, 145 + 416);
	EXPECT_NEAR(get_mag_strength_tesla(35, 165) * 1e9, 40832, 145 + 408);
	EXPECT_NEAR(get_mag_strength_tesla(35, 170) * 1e9, 40212, 145 + 402);
	EXPECT_NEAR(get_mag_strength_tesla(35, 175) * 1e9, 39776, 145 + 398);
	EXPECT_NEAR(get_mag_strength_tesla(35, 180) * 1e9, 39520, 145 + 395);
	EXPECT_NEAR(get_mag_strength_tesla(40, -180) * 1e9, 42217, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(40, -175) * 1e9, 42099, 145 + 421);
	EXPECT_NEAR(get_mag_strength_tesla(40, -170) * 1e9, 42155, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(40, -165) * 1e9, 42380, 145 + 424);
	EXPECT_NEAR(get_mag_strength_tesla(40, -160) * 1e9, 42766, 145 + 428);
	EXPECT_NEAR(get_mag_strength_tesla(40, -155) * 1e9, 43302, 145 + 433);
	EXPECT_NEAR(get_mag_strength_tesla(40, -150) * 1e9, 43970, 145 + 440);
	EXPECT_NEAR(get_mag_strength_tesla(40, -145) * 1e9, 44749, 145 + 447);
	EXPECT_NEAR(get_mag_strength_tesla(40, -140) * 1e9, 45613, 145 + 456);
	EXPECT_NEAR(get_mag_strength_tesla(40, -135) * 1e9, 46529, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(40, -130) * 1e9, 47466, 145 + 475);
	EXPECT_NEAR(get_mag_strength_tesla(40, -125) * 1e9, 48394, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(40, -120) * 1e9, 49285, 145 + 493);
	EXPECT_NEAR(get_mag_strength_tesla(40, -115) * 1e9, 50111, 145 + 501);
	EXPECT_NEAR(get_mag_strength_tesla(40, -110) * 1e9, 50842, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(40, -105) * 1e9, 51446, 145 + 514);
	EXPECT_NEAR(get_mag_strength_tesla(40, -100) * 1e9, 51886, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(40, -95) * 1e9, 52128, 145 + 521);
	EXPECT_NEAR(get_mag_strength_tesla(40, -90) * 1e9, 52144, 145 + 521);
	EXPECT_NEAR(get_mag_strength_tesla(40, -85) * 1e9, 51923, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(40, -80) * 1e9, 51471, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(40, -75) * 1e9, 50816, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(40, -70) * 1e9, 50006, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(40, -65) * 1e9, 49102, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(40, -60) * 1e9, 48171, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(40, -55) * 1e9, 47277, 145 + 473);
	EXPECT_NEAR(get_mag_strength_tesla(40, -50) * 1e9, 46471, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(40, -45) * 1e9, 45783, 145 + 458);
	EXPECT_NEAR(get_mag_strength_tesla(40, -40) * 1e9, 45227, 145 + 452);
	EXPECT_NEAR(get_mag_strength_tesla(40, -35) * 1e9, 44802, 145 + 448);
	EXPECT_NEAR(get_mag_strength_tesla(40, -30) * 1e9, 44504, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(40, -25) * 1e9, 44330, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(40, -20) * 1e9, 44277, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(40, -15) * 1e9, 44346, 145 + 443);
	EXPECT_NEAR(get_mag_strength_tesla(40, -10) * 1e9, 44529, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(40, -5) * 1e9, 44809, 145 + 448);
	EXPECT_NEAR(get_mag_strength_tesla(40, 0) * 1e9, 45160, 145 + 452);
	EXPECT_NEAR(get_mag_strength_tesla(40, 5) * 1e9, 45554, 145 + 456);
	EXPECT_NEAR(get_mag_strength_tesla(40, 10) * 1e9, 45972, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(40, 15) * 1e9, 46403, 145 + 464);
	EXPECT_NEAR(get_mag_strength_tesla(40, 20) * 1e9, 46851, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(40, 25) * 1e9, 47326, 145 + 473);
	EXPECT_NEAR(get_mag_strength_tesla(40, 30) * 1e9, 47838, 145 + 478);
	EXPECT_NEAR(get_mag_strength_tesla(40, 35) * 1e9, 48394, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(40, 40) * 1e9, 48994, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(40, 45) * 1e9, 49638, 145 + 496);
	EXPECT_NEAR(get_mag_strength_tesla(40, 50) * 1e9, 50329, 145 + 503);
	EXPECT_NEAR(get_mag_strength_tesla(40, 55) * 1e9, 51065, 145 + 511);
	EXPECT_NEAR(get_mag_strength_tesla(40, 60) * 1e9, 51846, 145 + 518);
	EXPECT_NEAR(get_mag_strength_tesla(40, 65) * 1e9, 52658, 145 + 527);
	EXPECT_NEAR(get_mag_strength_tesla(40, 70) * 1e9, 53480, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(40, 75) * 1e9, 54276, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(40, 80) * 1e9, 55004, 145 + 550);
	EXPECT_NEAR(get_mag_strength_tesla(40, 85) * 1e9, 55624, 145 + 556);
	EXPECT_NEAR(get_mag_strength_tesla(40, 90) * 1e9, 56094, 145 + 561);
	EXPECT_NEAR(get_mag_strength_tesla(40, 95) * 1e9, 56381, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(40, 100) * 1e9, 56456, 145 + 565);
	EXPECT_NEAR(get_mag_strength_tesla(40, 105) * 1e9, 56294, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(40, 110) * 1e9, 55880, 145 + 559);
	EXPECT_NEAR(get_mag_strength_tesla(40, 115) * 1e9, 55210, 145 + 552);
	EXPECT_NEAR(get_mag_strength_tesla(40, 120) * 1e9, 54298, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(40, 125) * 1e9, 53180, 145 + 532);
	EXPECT_NEAR(get_mag_strength_tesla(40, 130) * 1e9, 51909, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(40, 135) * 1e9, 50549, 145 + 505);
	EXPECT_NEAR(get_mag_strength_tesla(40, 140) * 1e9, 49169, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(40, 145) * 1e9, 47829, 145 + 478);
	EXPECT_NEAR(get_mag_strength_tesla(40, 150) * 1e9, 46578, 145 + 466);
	EXPECT_NEAR(get_mag_strength_tesla(40, 155) * 1e9, 45449, 145 + 454);
	EXPECT_NEAR(get_mag_strength_tesla(40, 160) * 1e9, 44466, 145 + 445);
	EXPECT_NEAR(get_mag_strength_tesla(40, 165) * 1e9, 43644, 145 + 436);
	EXPECT_NEAR(get_mag_strength_tesla(40, 170) * 1e9, 42991, 145 + 430);
	EXPECT_NEAR(get_mag_strength_tesla(40, 175) * 1e9, 42515, 145 + 425);
	EXPECT_NEAR(get_mag_strength_tesla(40, 180) * 1e9, 42217, 145 + 422);
	EXPECT_NEAR(get_mag_strength_tesla(45, -180) * 1e9, 45209, 145 + 452);
	EXPECT_NEAR(get_mag_strength_tesla(45, -175) * 1e9, 45071, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(45, -170) * 1e9, 45108, 145 + 451);
	EXPECT_NEAR(get_mag_strength_tesla(45, -165) * 1e9, 45318, 145 + 453);
	EXPECT_NEAR(get_mag_strength_tesla(45, -160) * 1e9, 45694, 145 + 457);
	EXPECT_NEAR(get_mag_strength_tesla(45, -155) * 1e9, 46220, 145 + 462);
	EXPECT_NEAR(get_mag_strength_tesla(45, -150) * 1e9, 46878, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(45, -145) * 1e9, 47641, 145 + 476);
	EXPECT_NEAR(get_mag_strength_tesla(45, -140) * 1e9, 48478, 145 + 485);
	EXPECT_NEAR(get_mag_strength_tesla(45, -135) * 1e9, 49359, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(45, -130) * 1e9, 50252, 145 + 503);
	EXPECT_NEAR(get_mag_strength_tesla(45, -125) * 1e9, 51126, 145 + 511);
	EXPECT_NEAR(get_mag_strength_tesla(45, -120) * 1e9, 51956, 145 + 520);
	EXPECT_NEAR(get_mag_strength_tesla(45, -115) * 1e9, 52716, 145 + 527);
	EXPECT_NEAR(get_mag_strength_tesla(45, -110) * 1e9, 53379, 145 + 534);
	EXPECT_NEAR(get_mag_strength_tesla(45, -105) * 1e9, 53916, 145 + 539);
	EXPECT_NEAR(get_mag_strength_tesla(45, -100) * 1e9, 54299, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(45, -95) * 1e9, 54498, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(45, -90) * 1e9, 54493, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(45, -85) * 1e9, 54274, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(45, -80) * 1e9, 53847, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(45, -75) * 1e9, 53234, 145 + 532);
	EXPECT_NEAR(get_mag_strength_tesla(45, -70) * 1e9, 52476, 145 + 525);
	EXPECT_NEAR(get_mag_strength_tesla(45, -65) * 1e9, 51624, 145 + 516);
	EXPECT_NEAR(get_mag_strength_tesla(45, -60) * 1e9, 50734, 145 + 507);
	EXPECT_NEAR(get_mag_strength_tesla(45, -55) * 1e9, 49862, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(45, -50) * 1e9, 49051, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(45, -45) * 1e9, 48334, 145 + 483);
	EXPECT_NEAR(get_mag_strength_tesla(45, -40) * 1e9, 47729, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(45, -35) * 1e9, 47242, 145 + 472);
	EXPECT_NEAR(get_mag_strength_tesla(45, -30) * 1e9, 46874, 145 + 469);
	EXPECT_NEAR(get_mag_strength_tesla(45, -25) * 1e9, 46625, 145 + 466);
	EXPECT_NEAR(get_mag_strength_tesla(45, -20) * 1e9, 46495, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(45, -15) * 1e9, 46480, 145 + 465);
	EXPECT_NEAR(get_mag_strength_tesla(45, -10) * 1e9, 46575, 145 + 466);
	EXPECT_NEAR(get_mag_strength_tesla(45, -5) * 1e9, 46763, 145 + 468);
	EXPECT_NEAR(get_mag_strength_tesla(45, 0) * 1e9, 47026, 145 + 470);
	EXPECT_NEAR(get_mag_strength_tesla(45, 5) * 1e9, 47342, 145 + 473);
	EXPECT_NEAR(get_mag_strength_tesla(45, 10) * 1e9, 47694, 145 + 477);
	EXPECT_NEAR(get_mag_strength_tesla(45, 15) * 1e9, 48076, 145 + 481);
	EXPECT_NEAR(get_mag_strength_tesla(45, 20) * 1e9, 48487, 145 + 485);
	EXPECT_NEAR(get_mag_strength_tesla(45, 25) * 1e9, 48936, 145 + 489);
	EXPECT_NEAR(get_mag_strength_tesla(45, 30) * 1e9, 49434, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(45, 35) * 1e9, 49988, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(45, 40) * 1e9, 50605, 145 + 506);
	EXPECT_NEAR(get_mag_strength_tesla(45, 45) * 1e9, 51287, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(45, 50) * 1e9, 52035, 145 + 520);
	EXPECT_NEAR(get_mag_strength_tesla(45, 55) * 1e9, 52843, 145 + 528);
	EXPECT_NEAR(get_mag_strength_tesla(45, 60) * 1e9, 53701, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(45, 65) * 1e9, 54590, 145 + 546);
	EXPECT_NEAR(get_mag_strength_tesla(45, 70) * 1e9, 55479, 145 + 555);
	EXPECT_NEAR(get_mag_strength_tesla(45, 75) * 1e9, 56332, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(45, 80) * 1e9, 57106, 145 + 571);
	EXPECT_NEAR(get_mag_strength_tesla(45, 85) * 1e9, 57760, 145 + 578);
	EXPECT_NEAR(get_mag_strength_tesla(45, 90) * 1e9, 58256, 145 + 583);
	EXPECT_NEAR(get_mag_strength_tesla(45, 95) * 1e9, 58561, 145 + 586);
	EXPECT_NEAR(get_mag_strength_tesla(45, 100) * 1e9, 58649, 145 + 586);
	EXPECT_NEAR(get_mag_strength_tesla(45, 105) * 1e9, 58502, 145 + 585);
	EXPECT_NEAR(get_mag_strength_tesla(45, 110) * 1e9, 58110, 145 + 581);
	EXPECT_NEAR(get_mag_strength_tesla(45, 115) * 1e9, 57478, 145 + 575);
	EXPECT_NEAR(get_mag_strength_tesla(45, 120) * 1e9, 56624, 145 + 566);
	EXPECT_NEAR(get_mag_strength_tesla(45, 125) * 1e9, 55584, 145 + 556);
	EXPECT_NEAR(get_mag_strength_tesla(45, 130) * 1e9, 54405, 145 + 544);
	EXPECT_NEAR(get_mag_strength_tesla(45, 135) * 1e9, 53147, 145 + 531);
	EXPECT_NEAR(get_mag_strength_tesla(45, 140) * 1e9, 51867, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(45, 145) * 1e9, 50619, 145 + 506);
	EXPECT_NEAR(get_mag_strength_tesla(45, 150) * 1e9, 49447, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(45, 155) * 1e9, 48380, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(45, 160) * 1e9, 47442, 145 + 474);
	EXPECT_NEAR(get_mag_strength_tesla(45, 165) * 1e9, 46646, 145 + 466);
	EXPECT_NEAR(get_mag_strength_tesla(45, 170) * 1e9, 46003, 145 + 460);
	EXPECT_NEAR(get_mag_strength_tesla(45, 175) * 1e9, 45522, 145 + 455);
	EXPECT_NEAR(get_mag_strength_tesla(45, 180) * 1e9, 45209, 145 + 452);
	EXPECT_NEAR(get_mag_strength_tesla(50, -180) * 1e9, 48321, 145 + 483);
	EXPECT_NEAR(get_mag_strength_tesla(50, -175) * 1e9, 48177, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(50, -170) * 1e9, 48194, 145 + 482);
	EXPECT_NEAR(get_mag_strength_tesla(50, -165) * 1e9, 48370, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(50, -160) * 1e9, 48701, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(50, -155) * 1e9, 49171, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(50, -150) * 1e9, 49762, 145 + 498);
	EXPECT_NEAR(get_mag_strength_tesla(50, -145) * 1e9, 50447, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(50, -140) * 1e9, 51198, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(50, -135) * 1e9, 51984, 145 + 520);
	EXPECT_NEAR(get_mag_strength_tesla(50, -130) * 1e9, 52776, 145 + 528);
	EXPECT_NEAR(get_mag_strength_tesla(50, -125) * 1e9, 53547, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(50, -120) * 1e9, 54272, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(50, -115) * 1e9, 54926, 145 + 549);
	EXPECT_NEAR(get_mag_strength_tesla(50, -110) * 1e9, 55487, 145 + 555);
	EXPECT_NEAR(get_mag_strength_tesla(50, -105) * 1e9, 55931, 145 + 559);
	EXPECT_NEAR(get_mag_strength_tesla(50, -100) * 1e9, 56234, 145 + 562);
	EXPECT_NEAR(get_mag_strength_tesla(50, -95) * 1e9, 56376, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(50, -90) * 1e9, 56341, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(50, -85) * 1e9, 56122, 145 + 561);
	EXPECT_NEAR(get_mag_strength_tesla(50, -80) * 1e9, 55724, 145 + 557);
	EXPECT_NEAR(get_mag_strength_tesla(50, -75) * 1e9, 55166, 145 + 552);
	EXPECT_NEAR(get_mag_strength_tesla(50, -70) * 1e9, 54478, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(50, -65) * 1e9, 53701, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(50, -60) * 1e9, 52879, 145 + 529);
	EXPECT_NEAR(get_mag_strength_tesla(50, -55) * 1e9, 52056, 145 + 521);
	EXPECT_NEAR(get_mag_strength_tesla(50, -50) * 1e9, 51272, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(50, -45) * 1e9, 50555, 145 + 506);
	EXPECT_NEAR(get_mag_strength_tesla(50, -40) * 1e9, 49926, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(50, -35) * 1e9, 49398, 145 + 494);
	EXPECT_NEAR(get_mag_strength_tesla(50, -30) * 1e9, 48975, 145 + 490);
	EXPECT_NEAR(get_mag_strength_tesla(50, -25) * 1e9, 48662, 145 + 487);
	EXPECT_NEAR(get_mag_strength_tesla(50, -20) * 1e9, 48458, 145 + 485);
	EXPECT_NEAR(get_mag_strength_tesla(50, -15) * 1e9, 48362, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(50, -10) * 1e9, 48367, 145 + 484);
	EXPECT_NEAR(get_mag_strength_tesla(50, -5) * 1e9, 48463, 145 + 485);
	EXPECT_NEAR(get_mag_strength_tesla(50, 0) * 1e9, 48634, 145 + 486);
	EXPECT_NEAR(get_mag_strength_tesla(50, 5) * 1e9, 48868, 145 + 489);
	EXPECT_NEAR(get_mag_strength_tesla(50, 10) * 1e9, 49154, 145 + 492);
	EXPECT_NEAR(get_mag_strength_tesla(50, 15) * 1e9, 49484, 145 + 495);
	EXPECT_NEAR(get_mag_strength_tesla(50, 20) * 1e9, 49862, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(50, 25) * 1e9, 50292, 145 + 503);
	EXPECT_NEAR(get_mag_strength_tesla(50, 30) * 1e9, 50783, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(50, 35) * 1e9, 51345, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(50, 40) * 1e9, 51983, 145 + 520);
	EXPECT_NEAR(get_mag_strength_tesla(50, 45) * 1e9, 52699, 145 + 527);
	EXPECT_NEAR(get_mag_strength_tesla(50, 50) * 1e9, 53490, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(50, 55) * 1e9, 54346, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(50, 60) * 1e9, 55251, 145 + 553);
	EXPECT_NEAR(get_mag_strength_tesla(50, 65) * 1e9, 56179, 145 + 562);
	EXPECT_NEAR(get_mag_strength_tesla(50, 70) * 1e9, 57098, 145 + 571);
	EXPECT_NEAR(get_mag_strength_tesla(50, 75) * 1e9, 57970, 145 + 580);
	EXPECT_NEAR(get_mag_strength_tesla(50, 80) * 1e9, 58755, 145 + 588);
	EXPECT_NEAR(get_mag_strength_tesla(50, 85) * 1e9, 59414, 145 + 594);
	EXPECT_NEAR(get_mag_strength_tesla(50, 90) * 1e9, 59913, 145 + 599);
	EXPECT_NEAR(get_mag_strength_tesla(50, 95) * 1e9, 60222, 145 + 602);
	EXPECT_NEAR(get_mag_strength_tesla(50, 100) * 1e9, 60320, 145 + 603);
	EXPECT_NEAR(get_mag_strength_tesla(50, 105) * 1e9, 60196, 145 + 602);
	EXPECT_NEAR(get_mag_strength_tesla(50, 110) * 1e9, 59846, 145 + 598);
	EXPECT_NEAR(get_mag_strength_tesla(50, 115) * 1e9, 59281, 145 + 593);
	EXPECT_NEAR(get_mag_strength_tesla(50, 120) * 1e9, 58522, 145 + 585);
	EXPECT_NEAR(get_mag_strength_tesla(50, 125) * 1e9, 57602, 145 + 576);
	EXPECT_NEAR(get_mag_strength_tesla(50, 130) * 1e9, 56565, 145 + 566);
	EXPECT_NEAR(get_mag_strength_tesla(50, 135) * 1e9, 55459, 145 + 555);
	EXPECT_NEAR(get_mag_strength_tesla(50, 140) * 1e9, 54334, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(50, 145) * 1e9, 53232, 145 + 532);
	EXPECT_NEAR(get_mag_strength_tesla(50, 150) * 1e9, 52191, 145 + 522);
	EXPECT_NEAR(get_mag_strength_tesla(50, 155) * 1e9, 51238, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(50, 160) * 1e9, 50392, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(50, 165) * 1e9, 49667, 145 + 497);
	EXPECT_NEAR(get_mag_strength_tesla(50, 170) * 1e9, 49074, 145 + 491);
	EXPECT_NEAR(get_mag_strength_tesla(50, 175) * 1e9, 48622, 145 + 486);
	EXPECT_NEAR(get_mag_strength_tesla(50, 180) * 1e9, 48321, 145 + 483);
	EXPECT_NEAR(get_mag_strength_tesla(55, -180) * 1e9, 51314, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(55, -175) * 1e9, 51171, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(55, -170) * 1e9, 51163, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(55, -165) * 1e9, 51290, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(55, -160) * 1e9, 51546, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(55, -155) * 1e9, 51920, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(55, -150) * 1e9, 52396, 145 + 524);
	EXPECT_NEAR(get_mag_strength_tesla(55, -145) * 1e9, 52951, 145 + 530);
	EXPECT_NEAR(get_mag_strength_tesla(55, -140) * 1e9, 53562, 145 + 536);
	EXPECT_NEAR(get_mag_strength_tesla(55, -135) * 1e9, 54203, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(55, -130) * 1e9, 54848, 145 + 548);
	EXPECT_NEAR(get_mag_strength_tesla(55, -125) * 1e9, 55474, 145 + 555);
	EXPECT_NEAR(get_mag_strength_tesla(55, -120) * 1e9, 56058, 145 + 561);
	EXPECT_NEAR(get_mag_strength_tesla(55, -115) * 1e9, 56578, 145 + 566);
	EXPECT_NEAR(get_mag_strength_tesla(55, -110) * 1e9, 57016, 145 + 570);
	EXPECT_NEAR(get_mag_strength_tesla(55, -105) * 1e9, 57352, 145 + 574);
	EXPECT_NEAR(get_mag_strength_tesla(55, -100) * 1e9, 57568, 145 + 576);
	EXPECT_NEAR(get_mag_strength_tesla(55, -95) * 1e9, 57648, 145 + 576);
	EXPECT_NEAR(get_mag_strength_tesla(55, -90) * 1e9, 57583, 145 + 576);
	EXPECT_NEAR(get_mag_strength_tesla(55, -85) * 1e9, 57368, 145 + 574);
	EXPECT_NEAR(get_mag_strength_tesla(55, -80) * 1e9, 57008, 145 + 570);
	EXPECT_NEAR(get_mag_strength_tesla(55, -75) * 1e9, 56515, 145 + 565);
	EXPECT_NEAR(get_mag_strength_tesla(55, -70) * 1e9, 55914, 145 + 559);
	EXPECT_NEAR(get_mag_strength_tesla(55, -65) * 1e9, 55232, 145 + 552);
	EXPECT_NEAR(get_mag_strength_tesla(55, -60) * 1e9, 54503, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(55, -55) * 1e9, 53761, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(55, -50) * 1e9, 53037, 145 + 530);
	EXPECT_NEAR(get_mag_strength_tesla(55, -45) * 1e9, 52357, 145 + 524);
	EXPECT_NEAR(get_mag_strength_tesla(55, -40) * 1e9, 51741, 145 + 517);
	EXPECT_NEAR(get_mag_strength_tesla(55, -35) * 1e9, 51204, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(55, -30) * 1e9, 50754, 145 + 508);
	EXPECT_NEAR(get_mag_strength_tesla(55, -25) * 1e9, 50399, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(55, -20) * 1e9, 50139, 145 + 501);
	EXPECT_NEAR(get_mag_strength_tesla(55, -15) * 1e9, 49976, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(55, -10) * 1e9, 49904, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(55, -5) * 1e9, 49918, 145 + 499);
	EXPECT_NEAR(get_mag_strength_tesla(55, 0) * 1e9, 50011, 145 + 500);
	EXPECT_NEAR(get_mag_strength_tesla(55, 5) * 1e9, 50172, 145 + 502);
	EXPECT_NEAR(get_mag_strength_tesla(55, 10) * 1e9, 50398, 145 + 504);
	EXPECT_NEAR(get_mag_strength_tesla(55, 15) * 1e9, 50685, 145 + 507);
	EXPECT_NEAR(get_mag_strength_tesla(55, 20) * 1e9, 51034, 145 + 510);
	EXPECT_NEAR(get_mag_strength_tesla(55, 25) * 1e9, 51450, 145 + 514);
	EXPECT_NEAR(get_mag_strength_tesla(55, 30) * 1e9, 51939, 145 + 519);
	EXPECT_NEAR(get_mag_strength_tesla(55, 35) * 1e9, 52506, 145 + 525);
	EXPECT_NEAR(get_mag_strength_tesla(55, 40) * 1e9, 53155, 145 + 532);
	EXPECT_NEAR(get_mag_strength_tesla(55, 45) * 1e9, 53885, 145 + 539);
	EXPECT_NEAR(get_mag_strength_tesla(55, 50) * 1e9, 54688, 145 + 547);
	EXPECT_NEAR(get_mag_strength_tesla(55, 55) * 1e9, 55552, 145 + 556);
	EXPECT_NEAR(get_mag_strength_tesla(55, 60) * 1e9, 56456, 145 + 565);
	EXPECT_NEAR(get_mag_strength_tesla(55, 65) * 1e9, 57373, 145 + 574);
	EXPECT_NEAR(get_mag_strength_tesla(55, 70) * 1e9, 58272, 145 + 583);
	EXPECT_NEAR(get_mag_strength_tesla(55, 75) * 1e9, 59117, 145 + 591);
	EXPECT_NEAR(get_mag_strength_tesla(55, 80) * 1e9, 59872, 145 + 599);
	EXPECT_NEAR(get_mag_strength_tesla(55, 85) * 1e9, 60504, 145 + 605);
	EXPECT_NEAR(get_mag_strength_tesla(55, 90) * 1e9, 60983, 145 + 610);
	EXPECT_NEAR(get_mag_strength_tesla(55, 95) * 1e9, 61285, 145 + 613);
	EXPECT_NEAR(get_mag_strength_tesla(55, 100) * 1e9, 61395, 145 + 614);
	EXPECT_NEAR(get_mag_strength_tesla(55, 105) * 1e9, 61306, 145 + 613);
	EXPECT_NEAR(get_mag_strength_tesla(55, 110) * 1e9, 61022, 145 + 610);
	EXPECT_NEAR(get_mag_strength_tesla(55, 115) * 1e9, 60553, 145 + 606);
	EXPECT_NEAR(get_mag_strength_tesla(55, 120) * 1e9, 59921, 145 + 599);
	EXPECT_NEAR(get_mag_strength_tesla(55, 125) * 1e9, 59158, 145 + 592);
	EXPECT_NEAR(get_mag_strength_tesla(55, 130) * 1e9, 58298, 145 + 583);
	EXPECT_NEAR(get_mag_strength_tesla(55, 135) * 1e9, 57380, 145 + 574);
	EXPECT_NEAR(get_mag_strength_tesla(55, 140) * 1e9, 56444, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(55, 145) * 1e9, 55525, 145 + 555);
	EXPECT_NEAR(get_mag_strength_tesla(55, 150) * 1e9, 54651, 145 + 547);
	EXPECT_NEAR(get_mag_strength_tesla(55, 155) * 1e9, 53845, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(55, 160) * 1e9, 53124, 145 + 531);
	EXPECT_NEAR(get_mag_strength_tesla(55, 165) * 1e9, 52501, 145 + 525);
	EXPECT_NEAR(get_mag_strength_tesla(55, 170) * 1e9, 51986, 145 + 520);
	EXPECT_NEAR(get_mag_strength_tesla(55, 175) * 1e9, 51588, 145 + 516);
	EXPECT_NEAR(get_mag_strength_tesla(55, 180) * 1e9, 51314, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(60, -180) * 1e9, 53929, 145 + 539);
	EXPECT_NEAR(get_mag_strength_tesla(60, -175) * 1e9, 53787, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(60, -170) * 1e9, 53749, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(60, -165) * 1e9, 53814, 145 + 538);
	EXPECT_NEAR(get_mag_strength_tesla(60, -160) * 1e9, 53978, 145 + 540);
	EXPECT_NEAR(get_mag_strength_tesla(60, -155) * 1e9, 54232, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(60, -150) * 1e9, 54564, 145 + 546);
	EXPECT_NEAR(get_mag_strength_tesla(60, -145) * 1e9, 54959, 145 + 550);
	EXPECT_NEAR(get_mag_strength_tesla(60, -140) * 1e9, 55398, 145 + 554);
	EXPECT_NEAR(get_mag_strength_tesla(60, -135) * 1e9, 55863, 145 + 559);
	EXPECT_NEAR(get_mag_strength_tesla(60, -130) * 1e9, 56332, 145 + 563);
	EXPECT_NEAR(get_mag_strength_tesla(60, -125) * 1e9, 56788, 145 + 568);
	EXPECT_NEAR(get_mag_strength_tesla(60, -120) * 1e9, 57210, 145 + 572);
	EXPECT_NEAR(get_mag_strength_tesla(60, -115) * 1e9, 57582, 145 + 576);
	EXPECT_NEAR(get_mag_strength_tesla(60, -110) * 1e9, 57888, 145 + 579);
	EXPECT_NEAR(get_mag_strength_tesla(60, -105) * 1e9, 58112, 145 + 581);
	EXPECT_NEAR(get_mag_strength_tesla(60, -100) * 1e9, 58242, 145 + 582);
	EXPECT_NEAR(get_mag_strength_tesla(60, -95) * 1e9, 58266, 145 + 583);
	EXPECT_NEAR(get_mag_strength_tesla(60, -90) * 1e9, 58178, 145 + 582);
	EXPECT_NEAR(get_mag_strength_tesla(60, -85) * 1e9, 57975, 145 + 580);
	EXPECT_NEAR(get_mag_strength_tesla(60, -80) * 1e9, 57660, 145 + 577);
	EXPECT_NEAR(get_mag_strength_tesla(60, -75) * 1e9, 57244, 145 + 572);
	EXPECT_NEAR(get_mag_strength_tesla(60, -70) * 1e9, 56741, 145 + 567);
	EXPECT_NEAR(get_mag_strength_tesla(60, -65) * 1e9, 56171, 145 + 562);
	EXPECT_NEAR(get_mag_strength_tesla(60, -60) * 1e9, 55557, 145 + 556);
	EXPECT_NEAR(get_mag_strength_tesla(60, -55) * 1e9, 54923, 145 + 549);
	EXPECT_NEAR(get_mag_strength_tesla(60, -50) * 1e9, 54293, 145 + 543);
	EXPECT_NEAR(get_mag_strength_tesla(60, -45) * 1e9, 53688, 145 + 537);
	EXPECT_NEAR(get_mag_strength_tesla(60, -40) * 1e9, 53125, 145 + 531);
	EXPECT_NEAR(get_mag_strength_tesla(60, -35) * 1e9, 52620, 145 + 526);
	EXPECT_NEAR(get_mag_strength_tesla(60, -30) * 1e9, 52181, 145 + 522);
	EXPECT_NEAR(get_mag_strength_tesla(60, -25) * 1e9, 51818, 145 + 518);
	EXPECT_NEAR(get_mag_strength_tesla(60, -20) * 1e9, 51534, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(60, -15) * 1e9, 51332, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(60, -10) * 1e9, 51211, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(60, -5) * 1e9, 51170, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(60, 0) * 1e9, 51206, 145 + 512);
	EXPECT_NEAR(get_mag_strength_tesla(60, 5) * 1e9, 51316, 145 + 513);
	EXPECT_NEAR(get_mag_strength_tesla(60, 10) * 1e9, 51496, 145 + 515);
	EXPECT_NEAR(get_mag_strength_tesla(60, 15) * 1e9, 51748, 145 + 517);
	EXPECT_NEAR(get_mag_strength_tesla(60, 20) * 1e9, 52073, 145 + 521);
	EXPECT_NEAR(get_mag_strength_tesla(60, 25) * 1e9, 52472, 145 + 525);
	EXPECT_NEAR(get_mag_strength_tesla(60, 30) * 1e9, 52949, 145 + 529);
	EXPECT_NEAR(get_mag_strength_tesla(60, 35) * 1e9, 53505, 145 + 535);
	EXPECT_NEAR(get_mag_strength_tesla(60, 40) * 1e9, 54139, 145 + 541);
	EXPECT_NEAR(get_mag_strength_tesla(60, 45) * 1e9, 54846, 145 + 548);
	EXPECT_NEAR(get_mag_strength_tesla(60, 50) * 1e9, 55617, 145 + 556);
	EXPECT_NEAR(get_mag_strength_tesla(60, 55) * 1e9, 56437, 145 + 564);
	EXPECT_NEAR(get_mag_strength_tesla(60, 60) * 1e9, 57284, 145 + 573);
	EXPECT_NEAR(get_mag_strength_tesla(60, 65) * 1e9, 58136, 145 + 581);
	EXPECT_NEAR(get_mag_strength_tesla(60, 70) * 1e9, 58961, 145 + 590);
	EXPECT_NEAR(get_mag_strength_tesla(60, 75) * 1e9, 59732, 145 + 597);
	EXPECT_NEAR(get_mag_strength_tesla(60, 80) * 1e9, 60419, 145 + 604);
	EXPECT_NEAR(get_mag_strength_tesla(60, 85) * 1e9, 60993, 145 + 610);
	EXPECT_NEAR(get_mag_strength_tesla(60, 90) * 1e9, 61433, 145 + 614);
	EXPECT_NEAR(get_mag_strength_tesla(60, 95) * 1e9, 61720, 145 + 617);
	EXPECT_NEAR(get_mag_strength_tesla(60, 100) * 1e9, 61846, 145 + 618);
	EXPECT_NEAR(get_mag_strength_tesla(60, 105) * 1e9, 61805, 145 + 618);
	EXPECT_NEAR(get_mag_strength_tesla(60, 110) * 1e9, 61603, 145 + 616);
	EXPECT_NEAR(get_mag_strength_tesla(60, 115) * 1e9, 61253, 145 + 613);
	EXPECT_NEAR(get_mag_strength_tesla(60, 120) * 1e9, 60772, 145 + 608);
	EXPECT_NEAR(get_mag_strength_tesla(60, 125) * 1e9, 60186, 145 + 602);
	EXPECT_NEAR(get_mag_strength_tesla(60, 130) * 1e9, 59523, 145 + 595);
	EXPECT_NEAR(get_mag_strength_tesla(60, 135) * 1e9, 58812, 145 + 588);
	EXPECT_NEAR(get_mag_strength_tesla(60, 140) * 1e9, 58082, 145 + 581);
	EXPECT_NEAR(get_mag_strength_tesla(60, 145) * 1e9, 57360, 145 + 574);
	EXPECT_NEAR(get_mag_strength_tesla(60, 150) * 1e9, 56668, 145 + 567);
	EXPECT_NEAR(get_mag_strength_tesla(60, 155) * 1e9, 56024, 145 + 560);
	EXPECT_NEAR(get_mag_strength_tesla(60, 160) * 1e9, 55442, 145 + 554);
	EXPECT_NEAR(get_mag_strength_tesla(60, 165) * 1e9, 54934, 145 + 549);
	EXPECT_NEAR(get_mag_strength_tesla(60, 170) * 1e9, 54507, 145 + 545);
	EXPECT_NEAR(get_mag_strength_tesla(60, 175) * 1e9, 54170, 145 + 542);
	EXPECT_NEAR(get_mag_strength_tesla(60, 180) * 1e9, 53929, 145 + 539);
}
