/****************************************************************************
 *
 *   Copyright (C) 2021 PX4 Development Team. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name PX4 nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/**
 * Test data for the system identification unit test
 *
 * The data comes from a real flight of a 1.5m wingspan foamy standard VTOL plane
 * in hovering conditions doing the first 1.8 seconds of the roll auto-tuning procedure:
 * a positive roll control step added to the angular rate setpoint
 *
 * Sampling frequency: ~285Hz, y_data is aligned with the closest next u_data
 *
 * u_data: vehicle_torque_setpoint[0] (roll control signal, used as the input)
 * y_data: vehicle_angular_velocity.xyz[0] (filtered roll angular rate, used as the output)
 * t_data: vehicle_torque_setpoint.timestamp
 */

#pragma once

static constexpr float u_data[500] = {-0.03771772235631943f, -0.04363096505403519f, -0.044016025960445404f, -0.04248081520199776f, -0.04273363947868347f, -0.04362409934401512f, -0.04600096493959427f, -0.0432172529399395f, -0.04147350788116455f, -0.041637204587459564f, -0.04147911071777344f, -0.03967246040701866f, -0.041561227291822433f, -0.04488750174641609f, -0.04170073941349983f, -0.04093272238969803f, -0.04712672904133797f, -0.05242692679166794f, -0.049901530146598816f, -0.05592795088887215f, -0.047633301466703415f, -0.05352514609694481f, -0.05443012714385986f, -0.039438579231500626f, -0.041634853929281235f, -0.04167766124010086f, -0.04292318597435951f, -0.044798221439123154f, -0.039857909083366394f, -0.0424133762717247f, -0.041870664805173874f, -0.034719083458185196f, -0.039218343794345856f, -0.040497809648513794f, -0.028218943625688553f, -0.03163045272231102f, -0.03127031400799751f, -0.02609068714082241f, -0.02679312974214554f, -0.03090275637805462f, -0.03593120723962784f, -0.03725297749042511f, -0.04165089502930641f, -0.03925032168626785f, -0.03824140504002571f, -0.04013359174132347f, -0.030006635934114456f, -0.028943272307515144f, -0.027270551770925522f, -0.030436139553785324f, -0.030364735051989555f, -0.016768217086791992f, -0.024358293041586876f, -0.0231632087379694f, -0.012759895995259285f, -0.02228967472910881f, -0.014312122948467731f, -0.02047768421471119f, -0.028967728838324547f, -0.02779092825949192f, -0.02607249654829502f, -0.0307249054312706f, -0.0298822820186615f, -0.021743090823292732f, -0.021786144003272057f, -0.022179551422595978f, -0.02221832238137722f, -0.018909413367509842f, -0.021070081740617752f, -0.02757149003446102f, -0.023895470425486565f, -0.0258298572152853f, -0.03201228752732277f, -0.028902221471071243f, -0.021201616153120995f, -0.024652985855937004f, -0.023533331230282784f, -0.01897919550538063f, -0.022023368626832962f, -0.02255731076002121f, -0.028902536258101463f, -0.03170562535524368f, -0.031153490766882896f, -0.029033740982413292f, -0.03179826959967613f, -0.03364403918385506f, -0.036677516996860504f, -0.035464584827423096f, -0.03522024676203728f, -0.042011454701423645f, -0.03496232256293297f, -0.03409611061215401f, -0.02982914447784424f, -0.021574849262833595f, -0.02950427681207657f, -0.029928136616945267f, -0.024402666836977005f, -0.03768949583172798f, -0.038536183536052704f, -0.04222578927874565f, -0.04519199952483177f, -0.03918737918138504f, -0.04225652292370796f, -0.0513484925031662f, -0.04476246237754822f, -0.050837382674217224f, -0.053395260125398636f, -0.046416789293289185f, -0.05014247074723244f, -0.04501807689666748f, -0.044037654995918274f, -0.045461151748895645f, -0.044904615730047226f, -0.04179742932319641f, -0.04589785262942314f, -0.04951722174882889f, -0.050755515694618225f, -0.046725835651159286f, -0.04708737134933472f, -0.042862530797719955f, -0.04420928657054901f, -0.04158312827348709f, -0.04799911752343178f, -0.047341540455818176f, -0.04306238517165184f, -0.04877322539687157f, -0.04252918064594269f, -0.03263223171234131f, -0.04036560282111168f, -0.034148380160331726f, -0.035169150680303574f, -0.03996643051505089f, -0.04209320247173309f, -0.04127660021185875f, -0.038189664483070374f, -0.03895478695631027f, -0.039779115468263626f, -0.02500910498201847f, -0.02886298857629299f, -0.02848386950790882f, -0.02185843139886856f, -0.02424856647849083f, -0.028188491240143776f, -0.03387325257062912f, -0.04054441675543785f, -0.04086560383439064f, -0.03676959499716759f, -0.034880366176366806f, -0.03852663189172745f, -0.0197187140583992f, -0.020535869523882866f, -0.025599097833037376f, -0.022083282470703125f, -0.022417673841118813f, -0.02533665858209133f, -0.024594828486442566f, -0.02579856477677822f, -0.02636844292283058f, -0.026661431416869164f, -0.03088044933974743f, -0.02411068044602871f, -0.024732759222388268f, -0.031044555827975273f, -0.023907091468572617f, -0.025809086859226227f, -0.029811140149831772f, -0.02663278393447399f, -0.03445614501833916f, -0.03377041965723038f, -0.030629213899374008f, -0.03303903341293335f, -0.03259199857711792f, -0.0305242370814085f, 0.17923147976398468f, 0.17982494831085205f, 0.18216842412948608f, 0.1850474774837494f, 0.19079704582691193f, 0.18867900967597961f, 0.1852702498435974f, 0.1865389198064804f, 0.1834465116262436f, 0.1797771155834198f, 0.16925279796123505f, 0.16511553525924683f, 0.15812312066555023f, 0.15178632736206055f, 0.14378736913204193f, 0.14144723117351532f, 0.12828287482261658f, 0.11802930384874344f, 0.1168195828795433f, 0.09712617099285126f, 0.08875076472759247f, 0.08985620737075806f, 0.057064592838287354f, 0.04313550516963005f, 0.036789171397686005f, 0.02207120694220066f, 0.009124248288571835f, 0.010786646977066994f, -0.0022137195337563753f, -0.009971844963729382f, -0.021421054378151894f, -0.04060700163245201f, -0.04711705446243286f, -0.0751396045088768f, -0.10381407290697098f, -0.09660574048757553f, -0.1008099913597107f, -0.13403679430484772f, -0.1340368688106537f, -0.14395171403884888f, -0.16636790335178375f, -0.1657264232635498f, -0.1639031171798706f, -0.17911477386951447f, -0.1701098382472992f, -0.1737910807132721f, -0.18760697543621063f, -0.18425925076007843f, -0.18863019347190857f, -0.19541428983211517f, -0.20501238107681274f, -0.20788390934467316f, -0.20900732278823853f, -0.20790186524391174f, -0.2152676284313202f, -0.21460507810115814f, -0.22589540481567383f, -0.23208804428577423f, -0.23079341650009155f, -0.22180069983005524f, -0.2112293541431427f, -0.21460488438606262f, -0.21229076385498047f, -0.22010506689548492f, -0.2225232571363449f, -0.21743547916412354f, -0.21418732404708862f, -0.2235453873872757f, -0.20804619789123535f, -0.2010120153427124f, -0.20774860680103302f, -0.19228242337703705f, -0.18799804151058197f, -0.17533008754253387f, -0.16074565052986145f, -0.14340119063854218f, -0.14374230802059174f, -0.12010569125413895f, -0.11457912623882294f, -0.1524852216243744f, -0.1288495808839798f, -0.12459074705839157f, -0.11769759654998779f, -0.10226821154356003f, -0.10276376456022263f, -0.08550557494163513f, -0.0725359320640564f, -0.058234237134456635f, -0.05502248555421829f, -0.03740905597805977f, -0.0523800291121006f, -0.05544793978333473f, -0.03693380206823349f, -0.03868121653795242f, -0.0380210280418396f, -0.02172115631401539f, -0.018042871728539467f, -0.008144027553498745f, -0.004934155847877264f, 0.00208000629208982f, 0.003929379861801863f, 0.013308283872902393f, 0.005610332358628511f, 0.007608598563820124f, 0.01531576830893755f, 0.01970689557492733f, 0.019594119861721992f, 0.03213746100664139f, 0.026421448215842247f, 0.028097020462155342f, 0.03276988863945007f, 0.030493922531604767f, 0.038780488073825836f, 0.04039580002427101f, 0.038896240293979645f, 0.048750609159469604f, 0.04804617911577225f, 0.05572747811675072f, 0.05705828219652176f, 0.05563395097851753f, 0.056614950299263f, 0.052891913801431656f, 0.04869312420487404f, 0.05336717143654823f, 0.04650356248021126f, 0.04439087584614754f, 0.05221407860517502f, 0.04230578988790512f, 0.04363113269209862f, 0.049200065433979034f, 0.03348854184150696f, 0.03448118269443512f, 0.03507397323846817f, 0.03137674182653427f, 0.028684264048933983f, 0.024242639541625977f, 0.011638127267360687f, 0.0026602328289300203f, -0.003043482545763254f, 0.006447846069931984f, -0.010696575045585632f, -0.011501887813210487f, -0.009440403431653976f, -0.024726230651140213f, -0.026290465146303177f, -0.022496065124869347f, -0.028853856027126312f, -0.027294542640447617f, -0.036550506949424744f, -0.043759074062108994f, -0.04913948476314545f, -0.05328313261270523f, -0.05432286113500595f, -0.0440312996506691f, -0.0450093150138855f, -0.043431174010038376f, -0.04585736617445946f, -0.04998655244708061f, -0.04771659895777702f, -0.053465619683265686f, -0.05220475420355797f, -0.04737268015742302f, -0.0491698794066906f, -0.05230486020445824f, -0.052092794328927994f, -0.05713815242052078f, -0.050890859216451645f, -0.04739305004477501f, -0.05104001984000206f, -0.04362674057483673f, -0.05182946100831032f, -0.05216771364212036f, -0.4646624028682709f, -0.4715963900089264f, -0.4736482501029968f, -0.47389787435531616f, -0.48591509461402893f, -0.48714545369148254f, -0.48473966121673584f, -0.48491206765174866f, -0.47811028361320496f, -0.47703659534454346f, -0.49443233013153076f, -0.4830854833126068f, -0.48474574089050293f, -0.47198471426963806f, -0.4619588255882263f, -0.46091577410697937f, -0.4264490604400635f, -0.41894522309303284f, -0.40989264845848083f, -0.3990454375743866f, -0.3891897201538086f, -0.38313624262809753f, -0.36872589588165283f, -0.347644567489624f, -0.3249470293521881f, -0.3190852701663971f, -0.3014083802700043f, -0.27114081382751465f, -0.23972618579864502f, -0.23219184577465057f, -0.2099604457616806f, -0.18616655468940735f, -0.1697394698858261f, -0.14837731420993805f, -0.127055823802948f, -0.11278527975082397f, -0.08448401093482971f, -0.05972221493721008f, -0.015709754079580307f, -0.009536083787679672f, 0.015328267589211464f, 0.04142036661505699f, 0.04460487887263298f, 0.07821216434240341f, 0.08640047162771225f, 0.08850641548633575f, 0.12584753334522247f, 0.13864468038082123f, 0.1382104456424713f, 0.17079049348831177f, 0.20737585425376892f, 0.22634674608707428f, 0.23461869359016418f, 0.259536474943161f, 0.26003462076187134f, 0.2710002660751343f, 0.2787891626358032f, 0.2809363305568695f, 0.2874182164669037f, 0.29456716775894165f, 0.3005492687225342f, 0.33455684781074524f, 0.32570695877075195f, 0.3261112570762634f, 0.3411860167980194f, 0.33353421092033386f, 0.32798343896865845f, 0.35457098484039307f, 0.3428889811038971f, 0.33929431438446045f, 0.3492589294910431f, 0.3321149945259094f, 0.330841600894928f, 0.36449527740478516f, 0.34701696038246155f, 0.3451715111732483f, 0.33094629645347595f, 0.33154213428497314f, 0.3287714421749115f, 0.34709012508392334f, 0.3521999418735504f, 0.32549425959587097f, 0.31934472918510437f, 0.3250214159488678f, 0.32508066296577454f, 0.3237053453922272f, 0.3027705252170563f, 0.2912222743034363f, 0.28966397047042847f, 0.26062822341918945f, 0.2465233951807022f, 0.23601020872592926f, 0.21797052025794983f, 0.21135525405406952f, 0.18693552911281586f, 0.1777946501970291f, 0.16382575035095215f, 0.14497274160385132f, 0.13717013597488403f, 0.12089242786169052f, 0.1044539362192154f, 0.09550463408231735f, 0.08305078744888306f, 0.06506048142910004f, 0.06458533555269241f, 0.05201011151075363f, 0.03329979255795479f, 0.031713563948869705f, 0.022740036249160767f, 0.002631715964525938f, -0.005427621304988861f, -0.03678606078028679f, -0.045459818094968796f, -0.03191819414496422f, -0.056055329740047455f, -0.06508590281009674f, -0.07407639920711517f, -0.09410527348518372f, -0.10140663385391235f, -0.1256025731563568f, -0.13778330385684967f, -0.162579745054245f, -0.15161018073558807f, -0.16525505483150482f, -0.18845394253730774f, -0.1885942667722702f, -0.20453405380249023f, -0.219392791390419f, -0.216008722782135f, -0.22172291576862335f, -0.23446854948997498f, -0.23441515862941742f, -0.2490224540233612f, -0.2634178698062897f, -0.26552248001098633f, -0.26878708600997925f, -0.2781926393508911f, -0.27824822068214417f, -0.28160232305526733f, -0.2867981195449829f, -0.2925095856189728f, -0.2972431778907776f, -0.29496458172798157f, -0.2996930778026581f, -0.2975030243396759f, -0.29693591594696045f, -0.2999267578125f, -0.3028717041015625f, -0.3012535572052002f, -0.2854321599006653f, -0.2900688648223877f, -0.2844820022583008f, -0.272030234336853f, -0.2664077579975128f, -0.2666652500629425f};


static constexpr float y_data[500] = {0.10778485238552094f, 0.1282612532377243f, 0.12957170605659485f, 0.11890549957752228f, 0.1152559146285057f, 0.11900368332862854f, 0.12607760727405548f, 0.10987812280654907f, 0.10120520740747452f, 0.09760161489248276f, 0.09392441809177399f, 0.08654818683862686f, 0.09510881453752518f, 0.10499494522809982f, 0.08641449362039566f, 0.08241824805736542f, 0.10671604424715042f, 0.07201717793941498f, 0.059452541172504425f, 0.08305733650922775f, 0.0446457676589489f, 0.06664621084928513f, 0.07018305361270905f, 0.04292180761694908f, 0.04918484389781952f, 0.04902397468686104f, 0.0536152645945549f, 0.05772333964705467f, 0.03394615650177002f, 0.051075831055641174f, 0.0433570072054863f, 0.012673712335526943f, 0.03381713107228279f, 0.034679584205150604f, 0.002516327891498804f, 0.018712470307946205f, 0.012409798800945282f, -0.008358274586498737f, -0.00487540103495121f, 0.012025163508951664f, -0.014337132684886456f, -0.008721776306629181f, 0.011829536408185959f, -0.002213158644735813f, -0.00516332546249032f, 0.0035496908240020275f, -0.03133036196231842f, -0.03274618834257126f, -0.04055853188037872f, -0.022873301059007645f, -0.024798601865768433f, -0.04113689810037613f, -0.004897639621049166f, -0.01632555201649666f, -0.05681956559419632f, -0.011270794086158276f, -0.05575660616159439f, -0.05962592363357544f, -0.019207127392292023f, -0.03149624168872833f, -0.03240431472659111f, -0.012366796843707561f, -0.016380416229367256f, -0.013565256260335445f, -0.013934805989265442f, -0.0118296779692173f, -0.012113997712731361f, -0.025575364008545876f, -0.015033146366477013f, 0.005468800198286772f, -0.008417770266532898f, -0.008417770266532898f, 0.027106594294309616f, 0.013023331761360168f, 0.011315112002193928f, 0.027867568656802177f, 0.027867568656802177f, 0.0012737506767734885f, 0.015972020104527473f, 0.01570400409400463f, 0.0029517740476876497f, 0.01622440479695797f, 0.009305577725172043f, 0.0018625392112880945f, 0.011793848127126694f, 0.02042265608906746f, 0.03523793816566467f, 0.02861269935965538f, 0.027302708476781845f, 0.057075485587120056f, 0.02468241937458515f, 0.02468241937458515f, 0.05412639304995537f, 0.017868604511022568f, 0.05078388750553131f, 0.05274609848856926f, 0.027570800855755806f, 0.05030572786927223f, 0.05404476448893547f, 0.0702584907412529f, 0.07792990654706955f, 0.04911920428276062f, 0.06724709272384644f, 0.06855228543281555f, 0.03999841585755348f, 0.06829426437616348f, 0.07267549633979797f, 0.041890308260917664f, 0.059065401554107666f, 0.03615446016192436f, 0.03224765509366989f, 0.038617201149463654f, 0.03234482556581497f, 0.017766941338777542f, 0.032383088022470474f, 0.04902573302388191f, 0.05145127326250076f, 0.032081395387649536f, 0.03339686617255211f, 0.01048729196190834f, 0.002824312075972557f, -0.009887024760246277f, 0.021435579285025597f, 0.016515525057911873f, -0.0017803009832277894f, 0.024902116507291794f, 0.006244348362088203f, -0.03506693243980408f, 0.0015063718892633915f, -0.0348522812128067f, -0.024541735649108887f, -0.0019495364977046847f, -0.02070934884250164f, -0.020486021414399147f, -0.033591266721487045f, -0.030095811933279037f, -0.026719078421592712f, -0.04494621604681015f, -0.026495136320590973f, -0.03165223449468613f, -0.057774800807237625f, -0.0461026132106781f, -0.030347170308232307f, -0.04726850241422653f, -0.017017429694533348f, -0.015752417966723442f, -0.03243391960859299f, -0.038715291768312454f, -0.02152794413268566f, -0.06410263478755951f, -0.055756136775016785f, -0.03147415444254875f, -0.0498921200633049f, -0.04449716582894325f, -0.04449716582894325f, -0.04646133631467819f, -0.03734945133328438f, -0.03395947441458702f, -0.032393693923950195f, -0.032393693923950195f, -0.05387726053595543f, -0.0506267286837101f, -0.022941356524825096f, -0.05193105712532997f, -0.042671624571084976f, -0.0267360657453537f, -0.049629949033260345f, -0.01572277955710888f, -0.019060947000980377f, -0.030602099373936653f, -0.01906544342637062f, -0.021201567724347115f, -0.014849411323666573f, -0.006496885791420937f, -0.0033682698849588633f, -0.0021436845418065786f, -0.009865316562354565f, -0.008796077221632004f, 0.007264801766723394f, 0.026778453961014748f, 0.03210831806063652f, 0.05251259729266167f, 0.07571227848529816f, 0.09455641359090805f, 0.11929099261760712f, 0.15602350234985352f, 0.1851750612258911f, 0.22350956499576569f, 0.2389059215784073f, 0.27787071466445923f, 0.3209264576435089f, 0.33017781376838684f, 0.41786670684814453f, 0.44139066338539124f, 0.43876713514328003f, 0.5414790511131287f, 0.5825119018554688f, 0.6003867983818054f, 0.6710090041160583f, 0.7006315588951111f, 0.6937897801399231f, 0.7555810809135437f, 0.7577295303344727f, 0.7925936579704285f, 0.8825979828834534f, 0.8694281578063965f, 0.8719422221183777f, 0.9599242806434631f, 0.9229995012283325f, 0.9177740812301636f, 1.0270602703094482f, 1.023259162902832f, 1.0325480699539185f, 1.0931661128997803f, 1.0855631828308105f, 1.0394806861877441f, 1.0673214197158813f, 1.0044199228286743f, 1.0174418687820435f, 1.0373988151550293f, 0.9841800332069397f, 1.0001177787780762f, 0.9830155372619629f, 0.9521812796592712f, 0.9606189131736755f, 0.9186588525772095f, 0.884588897228241f, 0.8768684267997742f, 0.8684123158454895f, 0.8439735770225525f, 0.8367747664451599f, 0.8249845504760742f, 0.8249845504760742f, 0.6737371683120728f, 0.6848055720329285f, 0.5598716139793396f, 0.5773125290870667f, 0.5773125290870667f, 0.5304960608482361f, 0.49618667364120483f, 0.47174254059791565f, 0.39357683062553406f, 0.35304462909698486f, 0.3577931523323059f, 0.280241996049881f, 0.25525733828544617f, 0.22756747901439667f, 0.1551922857761383f, 0.07180948555469513f, 0.06826236099004745f, -0.044457100331783295f, -0.07229260355234146f, -0.0500946007668972f, -0.15670397877693176f, -0.17876335978507996f, -0.2131834179162979f, -0.27101752161979675f, -0.269809752702713f, -0.31791070103645325f, -0.36406567692756653f, -0.4155707061290741f, -0.43063488602638245f, -0.4975373148918152f, -0.5335588455200195f, -0.5188636779785156f, -0.5893391370773315f, -0.5614160895347595f, -0.5639641880989075f, -0.6173381805419922f, -0.6243423223495483f, -0.6476962566375732f, -0.6613530516624451f, -0.6705925464630127f, -0.6571470499038696f, -0.6996741890907288f, -0.7048571705818176f, -0.6939950585365295f, -0.7285842299461365f, -0.7137982845306396f, -0.6938349604606628f, -0.7279770970344543f, -0.6984801292419434f, -0.6876277923583984f, -0.6802968978881836f, -0.6671134233474731f, -0.6802416443824768f, -0.656715989112854f, -0.647034764289856f, -0.6659656763076782f, -0.6381825804710388f, -0.6477119326591492f, -0.6510283350944519f, -0.6186266541481018f, -0.5987714529037476f, -0.5783234238624573f, -0.5378702282905579f, -0.5370008945465088f, -0.5018228888511658f, -0.47689762711524963f, -0.4902171194553375f, -0.4285840094089508f, -0.432532399892807f, -0.4378019869327545f, -0.37199223041534424f, -0.37467941641807556f, -0.35715699195861816f, -0.32958051562309265f, -0.31497085094451904f, -0.27958962321281433f, -0.27166756987571716f, -0.27166756987571716f, -0.1982419788837433f, -0.22842854261398315f, -0.14591258764266968f, -0.14152519404888153f, -0.14152519404888153f, -0.10337574034929276f, -0.09582759439945221f, -0.10617536306381226f, -0.07654038816690445f, -0.07654038816690445f, -0.07525698095560074f, -0.04427637159824371f, -0.017067478969693184f, 0.001979588530957699f, 0.004743673838675022f, -0.015286034904420376f, -0.010916177183389664f, -0.02018103376030922f, -0.008144356310367584f, 0.010963440872728825f, -0.003166929353028536f, 0.0033494795206934214f, -0.004883454646915197f, -0.028208591043949127f, -0.016916263848543167f, -0.0046745711006224155f, -0.006235667038708925f, 0.012488908134400845f, -0.01618538610637188f, -0.033124279230833054f, -0.01572389341890812f, -0.049171362072229385f, -0.002155264373868704f, -0.0011339609045535326f, -0.04870608448982239f, -0.03908258303999901f, -0.040739431977272034f, -0.05820341780781746f, -0.05358113348484039f, -0.05923810973763466f, -0.08996095508337021f, -0.0979621559381485f, -0.14351068437099457f, -0.159526526927948f, -0.19772125780582428f, -0.26101893186569214f, -0.2640276551246643f, -0.3381454646587372f, -0.38152506947517395f, -0.39646732807159424f, -0.5159382224082947f, -0.5361672043800354f, -0.5787376761436462f, -0.6389452219009399f, -0.6653127074241638f, -0.7771410346031189f, -0.8528937697410583f, -0.9356986880302429f, -1.0109752416610718f, -1.0447282791137695f, -1.1072709560394287f, -1.1269370317459106f, -1.2366459369659424f, -1.2758030891418457f, -1.340391755104065f, -1.4130935668945312f, -1.4926718473434448f, -1.5320299863815308f, -1.5862699747085571f, -1.6539918184280396f, -1.7259788513183594f, -1.7790179252624512f, -1.8622634410858154f, -1.8885612487792969f, -1.9399861097335815f, -1.9876031875610352f, -1.9983242750167847f, -2.079735279083252f, -2.0842106342315674f, -2.08866286277771f, -2.1832005977630615f, -2.1666176319122314f, -2.1666176319122314f, -2.2255804538726807f, -2.209465980529785f, -2.210158586502075f, -2.2404680252075195f, -2.2404680252075195f, -2.1896259784698486f, -2.2321417331695557f, -2.1797854900360107f, -2.1190216541290283f, -2.1190216541290283f, -2.072567939758301f, -2.0363738536834717f, -2.0359926223754883f, -1.9834764003753662f, -1.9834764003753662f, -1.9012778997421265f, -1.8544811010360718f, -1.7539221048355103f, -1.7241230010986328f, -1.6582175493240356f, -1.5734013319015503f, -1.556471824645996f, -1.4168999195098877f, -1.4010179042816162f, -1.346904993057251f, -1.2118840217590332f, -1.1931283473968506f, -1.0651763677597046f, -1.0303599834442139f, -1.00775945186615f, -0.8661133050918579f, -0.8559463620185852f, -0.6915240287780762f, -0.6535102128982544f, -0.6447690725326538f, -0.46166476607322693f, -0.44635725021362305f, -0.3087080419063568f, -0.24779856204986572f, -0.23262913525104523f, -0.07551632076501846f, -0.0020454961340874434f, 0.06055934354662895f, 0.15196646749973297f, 0.1888277679681778f, 0.3148288428783417f, 0.36267319321632385f, 0.4374842345714569f, 0.5305216312408447f, 0.5707302093505859f, 0.6538670063018799f, 0.7341977953910828f, 0.7805911302566528f, 0.8413987159729004f, 0.9279409646987915f, 0.9320752620697021f, 0.9925825595855713f, 1.080605387687683f, 1.0892879962921143f, 1.1317813396453857f, 1.1944185495376587f, 1.193190336227417f, 1.2937653064727783f, 1.3327670097351074f, 1.3353084325790405f, 1.399747610092163f, 1.4399909973144531f, 1.4283101558685303f, 1.4697149991989136f, 1.5007925033569336f, 1.5153337717056274f, 1.5198386907577515f, 1.5684007406234741f, 1.5114414691925049f, 1.5308254957199097f, 1.6054775714874268f, 1.600298285484314f, 1.6142804622650146f, 1.6203359365463257f, 1.597905158996582f, 1.5636849403381348f, 1.5705530643463135f, 1.5705530643463135f, 1.568790078163147f, 1.579393744468689f, 1.5266374349594116f, 1.5348210334777832f, 1.5348210334777832f, 1.4263215065002441f, 1.4347293376922607f, 1.393513560295105f, 1.375203013420105f, 1.389883041381836f, 1.2877789735794067f, 1.2655446529388428f, 1.203544020652771f, 1.1933188438415527f, 1.1595219373703003f, 1.1195058822631836f, 1.1042965650558472f, 0.9786297678947449f, 0.967745840549469f, 0.9343695044517517f, 0.8354629874229431f, 0.8169513940811157f, 0.7793483734130859f};


static constexpr float t_data[500] = {133.81430899999998f, 133.819331f, 133.82182f, 133.824329f, 133.829351f, 133.831837f, 133.836843f, 133.839357f, 133.841857f, 133.84686299999998f, 133.84937499999998f, 133.854392f, 133.85689f, 133.859396f, 133.86440199999998f, 133.866899f, 133.871916f, 133.87442f, 133.876922f, 133.881984f, 133.88445099999998f, 133.889454f, 133.891946f, 133.894461f, 133.899462f, 133.901964f, 133.906974f, 133.909494f, 133.91198f, 133.916993f, 133.919505f, 133.924512f, 133.927029f, 133.92952f, 133.93453599999998f, 133.93703499999998f, 133.942037f, 133.944545f, 133.94704099999998f, 133.95205099999998f, 133.95456f, 133.959574f, 133.962067f, 133.964575f, 133.969592f, 133.97208899999998f, 133.977096f, 133.979603f, 133.982112f, 133.987125f, 133.98962699999998f, 133.994652f, 133.997134f, 133.999643f, 134.00465499999999f, 134.007165f, 134.012167f, 134.01466399999998f, 134.01716399999998f, 134.02218f, 134.024689f, 134.029724f, 134.0322f, 134.034705f, 134.03970999999999f, 134.042212f, 134.04723199999998f, 134.049734f, 134.052254f, 134.057245f, 134.059743f, 134.062244f, 134.067262f, 134.06976699999998f, 134.074771f, 134.07727f, 134.07978f, 134.08479f, 134.087292f, 134.092308f, 134.094811f, 134.09731299999999f, 134.10233f, 134.104824f, 134.109839f, 134.11236f, 134.114846f, 134.119856f, 134.122358f, 134.127358f, 134.129872f, 134.13238099999998f, 134.137375f, 134.13988799999998f, 134.144894f, 134.147399f, 134.14990699999998f, 134.154913f, 134.157413f, 134.162424f, 134.16493499999999f, 134.16743499999998f, 134.17244499999998f, 134.174948f, 134.17996f, 134.18246299999998f, 134.184969f, 134.18999f, 134.192499f, 134.197501f, 134.200023f, 134.2025f, 134.207504f, 134.210015f, 134.215026f, 134.21754099999998f, 134.22007399999998f, 134.225067f, 134.227542f, 134.23255699999999f, 134.235056f, 134.237558f, 134.242574f, 134.245073f, 134.25008599999998f, 134.252589f, 134.2551f, 134.2601f, 134.262606f, 134.26761f, 134.270121f, 134.27263299999998f, 134.277629f, 134.280135f, 134.28515199999998f, 134.287646f, 134.29017f, 134.295172f, 134.297666f, 134.302681f, 134.30518f, 134.307692f, 134.312695f, 134.31519799999998f, 134.320215f, 134.322708f, 134.32521599999998f, 134.330227f, 134.332727f, 134.337739f, 134.340247f, 134.342748f, 134.347747f, 134.350262f, 134.352769f, 134.357768f, 134.36029f, 134.36530399999998f, 134.367804f, 134.370309f, 134.37530999999998f, 134.377803f, 134.38281999999998f, 134.385325f, 134.387824f, 134.39288399999998f, 134.395362f, 134.400351f, 134.40284599999998f, 134.405359f, 134.41036599999998f, 134.41286399999998f, 134.417876f, 134.420392f, 134.422882f, 134.427909f, 134.430407f, 134.43541199999999f, 134.437909f, 134.440428f, 134.445429f, 134.447925f, 134.452938f, 134.45544999999998f, 134.457947f, 134.462967f, 134.465472f, 134.470474f, 134.47298f, 134.475491f, 134.48049799999998f, 134.483002f, 134.488005f, 134.490535f, 134.493014f, 134.498033f, 134.500534f, 134.50554599999998f, 134.508041f, 134.510551f, 134.515566f, 134.51805299999998f, 134.523066f, 134.52557299999998f, 134.528073f, 134.533105f, 134.53559199999998f, 134.540599f, 134.543095f, 134.545604f, 134.55063099999998f, 134.553131f, 134.558176f, 134.56068299999998f, 134.563164f, 134.56813599999998f, 134.57066f, 134.575663f, 134.578167f, 134.580671f, 134.58567299999999f, 134.588183f, 134.59320499999998f, 134.595698f, 134.59820399999998f, 134.603207f, 134.60571299999998f, 134.61073f, 134.613222f, 134.615729f, 134.620758f, 134.62323899999998f, 134.625745f, 134.63075899999998f, 134.633257f, 134.638271f, 134.64077699999999f, 134.64328f, 134.648289f, 134.65079799999998f, 134.655797f, 134.658301f, 134.66081f, 134.66581499999998f, 134.668318f, 134.673328f, 134.675837f, 134.678341f, 134.683344f, 134.685861f, 134.690878f, 134.693369f, 134.695875f, 134.700888f, 134.70340199999998f, 134.708399f, 134.710908f, 134.713396f, 134.71841799999999f, 134.720915f, 134.725926f, 134.728455f, 134.73099299999998f, 134.735943f, 134.73845f, 134.743448f, 134.745973f, 134.748466f, 134.753465f, 134.755979f, 134.760987f, 134.763488f, 134.766007f, 134.77101299999998f, 134.77351099999998f, 134.778524f, 134.781025f, 134.783538f, 134.788544f, 134.79105099999998f, 134.79604999999998f, 134.798553f, 134.801066f, 134.80606799999998f, 134.80857699999999f, 134.813572f, 134.816091f, 134.81858499999998f, 134.823592f, 134.826102f, 134.83111599999998f, 134.833621f, 134.836117f, 134.841129f, 134.843631f, 134.84865399999998f, 134.851179f, 134.85365199999998f, 134.85866f, 134.861165f, 134.866186f, 134.86868099999998f, 134.871205f, 134.876218f, 134.87869f, 134.883704f, 134.886211f, 134.88870699999998f, 134.893724f, 134.896277f, 134.898753f, 134.90374f, 134.90624f, 134.911259f, 134.913757f, 134.91626f, 134.92127499999998f, 134.923768f, 134.928778f, 134.931288f, 134.933786f, 134.938804f, 134.941306f, 134.946317f, 134.948816f, 134.951327f, 134.956332f, 134.958838f, 134.963844f, 134.96634799999998f, 134.968854f, 134.973859f, 134.97636599999998f, 134.981378f, 134.983884f, 134.986388f, 134.991405f, 134.993897f, 134.998906f, 135.001412f, 135.00392f, 135.00893299999998f, 135.011459f, 135.01644199999998f, 135.018943f, 135.02145199999998f, 135.02646f, 135.02897f, 135.033977f, 135.036489f, 135.038983f, 135.044009f, 135.046502f, 135.051516f, 135.054012f, 135.05651f, 135.06152699999998f, 135.064022f, 135.069073f, 135.07156f, 135.07404599999998f, 135.079049f, 135.081569f, 135.086647f, 135.08914199999998f, 135.091645f, 135.096652f, 135.099136f, 135.10414699999998f, 135.106644f, 135.10913f, 135.11413299999998f, 135.116644f, 135.121656f, 135.124136f, 135.126641f, 135.131642f, 135.134135f, 135.139159f, 135.14167f, 135.14415599999998f, 135.149167f, 135.15167599999998f, 135.156694f, 135.159186f, 135.16169499999998f, 135.166699f, 135.169206f, 135.17422299999998f, 135.176716f, 135.179217f, 135.184239f, 135.186735f, 135.189238f, 135.19425099999998f, 135.196756f, 135.201765f, 135.204283f, 135.206781f, 135.211783f, 135.214304f, 135.219289f, 135.221798f, 135.224301f, 135.229312f, 135.231822f, 135.236831f, 135.239355f, 135.24183399999998f, 135.246839f, 135.24935299999999f, 135.25435f, 135.256859f, 135.259365f, 135.264368f, 135.26689199999998f, 135.271897f, 135.274394f, 135.276893f, 135.281907f, 135.284404f, 135.28942f, 135.291942f, 135.29442699999998f, 135.299429f, 135.301939f, 135.306947f, 135.309448f, 135.311961f, 135.316968f, 135.319467f, 135.324479f, 135.32698299999998f, 135.32949499999998f, 135.334501f, 135.337016f, 135.34201f, 135.344514f, 135.347023f, 135.35203199999998f, 135.354532f, 135.359545f, 135.362045f, 135.36454899999998f, 135.36956999999998f, 135.372067f, 135.37707799999998f, 135.379602f, 135.38211099999998f, 135.387091f, 135.38959499999999f, 135.394598f, 135.397113f, 135.399622f, 135.40464699999998f, 135.40717f, 135.41214499999998f, 135.414636f, 135.417147f, 135.422162f, 135.424654f, 135.429667f, 135.43218f, 135.434673f, 135.439678f, 135.44218899999998f, 135.447206f, 135.449697f, 135.45220899999998f, 135.457215f, 135.459714f, 135.464723f, 135.46723699999998f, 135.46974699999998f, 135.47474f, 135.47725f, 135.479749f, 135.484761f, 135.487271f, 135.492282f, 135.494782f, 135.49729399999998f, 135.502298f, 135.504801f, 135.509804f, 135.512324f, 135.514824f, 135.519821f, 135.522334f, 135.52733999999998f, 135.52983799999998f, 135.532354f, 135.53735899999998f, 135.539856f, 135.54487799999998f, 135.547396f, 135.54987599999998f, 135.55489699999998f, 135.55739f, 135.562401f};
