/****************************************************************************
 *
 * Copyright (C) 2022-2023 ModalAI, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name PX4 nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
#pragma once

#include <stdarg.h>
#include <stdio.h>
#include <stdint.h>
#include <px4_platform_common/defines.h>

#define BASE_BUFFER_SIZE 256
#define MAX_MODULE_NAME_SIZE 32
#define MODULE_BUFFER_SIZE (BASE_BUFFER_SIZE + MAX_MODULE_NAME_SIZE)

__BEGIN_DECLS

extern void qurt_log_to_apps(int level, const char *message);

// Defining hap_debug
void HAP_debug(const char *msg, int level, const char *filename, int line);

static __inline void qurt_log_module(int level, const char *module, const char *file, int line,
				     const char *format, ...)
{
	char buf[BASE_BUFFER_SIZE];
	va_list args;
	va_start(args, format);
	vsnprintf(buf, sizeof(buf), format, args);
	va_end(args);

	char module_buf[MODULE_BUFFER_SIZE];
	snprintf(module_buf, MAX_MODULE_NAME_SIZE, "[%s] ", module);
	strcat(module_buf, buf);

	HAP_debug(module_buf, level, file, line);

	qurt_log_to_apps(level, module_buf);
}

static __inline void qurt_log_raw(const char *format, ...)
{
	char buf[BASE_BUFFER_SIZE];
	va_list args;
	va_start(args, format);
	vsnprintf(buf, sizeof(buf), format, args);
	va_end(args);
	qurt_log_to_apps(1, buf);
}

__END_DECLS
