# 高级配置

本章节罗列的相关配置并不针对特定的载具，其特性很少被修改，或仅针对制造商/OEMs。

## 参数

- [Finding/Updating Parameters](../advanced_config/parameters.md)
- [完整参数参考](../advanced_config/parameter_reference.md)

## 功能配置

- [使用 PX4 的导航滤波器 (EKF2)](../advanced_config/tuning_the_ecl_ekf.md)
- [飞行终止配置](../advanced_config/flight_termination.md)
- [着陆探测器配置](../advanced_config/land_detector.md)
- [解锁前/解锁/加锁 配置](../advanced_config/prearm_arm_disarm.md)

## OEM/出厂校准

- [IMU 出厂校准](../advanced_config/imu_factory_calibration.md)
- [传感器热补偿](../advanced_config/sensor_thermal_calibration.md)
- [Compass Power Compensation](../advanced_config/compass_power_compensation.md)
- [飞控方向高级配置](../advanced_config/advanced_flight_controller_orientation_leveling.md)
- [静态压力构建](../advanced_config/static_pressure_buildup.md)

## 串口/以太网配置

- [Serial Port Configuration](../peripherals/serial_configuration.md)
- [MAVLink Telemetry (OSD/GCS)](../peripherals/mavlink_peripherals.md)
- [PX4 Ethernet Setup](../advanced_config/ethernet_setup.md)

## 其它选项

- [Bootloader 更新](../advanced_config/bootloader_update.md)
  - [通过 USB 更新 FMUv6X-RT bootloader](../advanced_config/bootloader_update_v6xrt.md)

## See Also

- [标准配置](../config/index.md) - 大多数 PX4 机体所需要的基本传感器/功能配置。
- [飞控外设](../peripherals/index.md) - 设置特定传感器、可选传感器、执行器等。
- 机体配置/调参：
  - [多旋翼配置/调参](../config_mc/index.md)
  - [直升机配置/调参](../config_heli/index.md)
  - [固定翼配置/调参](../config_fw/index.md)
  - [VTOL 配置/调参](../config_vtol/index.md)
