# Battery-Chemistry Overview

This section provides a comparative overview of several different battery types (in particular LiPo and Li-Ion) and some useful battery glossary terms.

## LiPo vs Li-Ion

- Акумулятори Li-Ion мають вищу щільність енергії, ніж пакети акумуляторів Lipo, але це відбувається за рахунок нижчих швидкостей розряду та збільшення вартості акумулятора.
- Акумулятори LiPo легко доступні і можуть витримати вищі розрядні струми, які є типовими для мультироторних літальних апаратів.
- Вибір потрібно здійснювати на основі транспортного засобу та місії, яку виконують.
  Якщо абсолютна витривалість є метою, то є більше користі від переходу на літій-іонний акумулятор, але, так само, потрібно бути обережним.
  Отже, рішення повинно бути прийняте на підставі факторів, що оточують польот.

### LiPo

Advantages:

- Дуже поширене
- Широкий асортимент розмірів, ємностей та напруг
- Недорогий
- Високі розрядні ставки відносно ємності (високі рейтинги C)
- Вищі показники заряду

Недоліки:

- Низька (відносна) щільність енергії
- Якість може відрізнятися від великої кількості постачальників

### Li-Ion

Advantages:

- Набагато вища енергетична щільність (до 60% вище)

Недоліки:

- Не так часто
- Набагато дорожче
- Не доступно для великих розмірів та конфігурацій
- Усі клітини відносно малі, тому більші пакети складаються з багатьох клітин, зв'язаних послідовно і паралельно, щоб створити необхідне напругу та ємність
- Нижчі рівні розряду відносно розміру батареї (рейтинг C)
- Складніше адаптуватися до транспортних засобів, які потребують великих струмів
- Нижчі тарифи зарядки (відносно потужності)
- Вимагає більш суворого моніторингу температури під час заряджання та розряджання
- Вимагає змін налаштувань на ESC для використання максимальної ємності ("стандартні" налаштування низької напруги ESC занадто високі).
- При майже порожньому акумуляторі напруга така, що можлива різниця близько 3 В між Lipo та Li-ion (при використанні акумулятора 6S).
  Це може мати наслідки для очікувань з тяги.

## C Рейтинги

- Рейтинг C - це просто кратне заявленої ємності будь-якого типу батареї.
- Оцінка C є важливою (і відрізняється) як для швидкості заряду, так і для швидкості розряду.
  - Наприклад, батарея на 2000 мАг (незалежно від напруги) з розрядом 10C може безпечно і безперервно витікати 20 амперів струму (2000/1000=2Аг x 10C = 20 амперів).
- C рейтинги завжди надаються виробником (часто на зовнішній частині батарейного блоку).
  Хоча їх можна фактично обчислити, вам потрібно кілька частин інформації, і виміряти внутрішній опір клітинок.
- Акумулятори LiPo завжди матимуть вищий рейтинг C, ніж акумулятор Li-Ion.
  Це пов'язано з типом хімії, а також з внутрішнім опором на кожну клітину (що пов'язано з типом хімії), що призводить до вищих рівнів розряду для акумуляторів LiPo.
- Дотримання виробників рекомендацій щодо обох рейтингів C для заряду та розряду є дуже важливим для здоров'я вашого акумулятора та безпечної експлуатації вашого транспортного засобу (тобто запобігання пожеж, "надування" пакетів та інших неоптимальних станів під час зарядки та розрядки).

## Енергетична щільність

- Енергетична щільність - це скільки енергії може бути збережено відносно ваги батареї.
  Зазвичай вимірюється і порівнюється у ват-годинах на кілограм (Вт•год/кг).
  - Ват-години просто розраховуються шляхом множення номінальної (тобто не повністю зарядної напруги) на ємність, наприклад, 3,7 В х 5 Аг = 18,5 Вт-г.
    Якби у вас був акумулятор на 3 клітки, ваш пакет був би 18,5 Вт·год X 3 = 55 Вт збереженої енергії.
- Коли ви враховуєте вагу батареї, ви розраховуєте енергетичну щільність, взявши ват-години і поділивши їх на вагу.
  - Наприклад, 55 Вт годин поділено на (вага батареї в грамах поділена на 1000).
    Припускаючи, що ця батарея важить 300 грам, тоді 55/(300/1000)=185 Вт·г/кг.
- Це число 185 Вт/кг було б на дуже високому рівні для акумулятора LiPo.
  Літій-іонна батарея, з іншого боку, може досягти 260 Вт·год/кг, що означає, що на кожний кілограм батареї на борту ви можете переносити на 75 Вт·год більше.
  - Якщо ви знаєте, скільки ватт потрібно вашому транспортному засобу для польоту (що може показати модуль поточного батареї), ви можете віднести це збільшене зберігання без додаткової ваги до збільшеного часу польоту.
