# TBS Caipiroshka

The Caipiroshka VTOL is a slightly modified _TBS Caipirinha_.

:::info
The _TBS Caipirinha_ has been superseded and is no longer available.
These instructions _should_ work with the updated vehicle: [TBS Caipirinha 2](https://team-blacksheep.com/products/prod:tbs_caipi2_pnp).
Кілька інших компонентів також було оновлено в списку деталей.
:::

<lite-youtube videoid="acG0aTuf3f8" title="PX4 VTOL - Call for Testpilots"/>

## Список деталей

- TBS Caipirinha Wing (no longer available - try [TBS Caipirinha 2](https://team-blacksheep.com/products/prod:tbs_caipi2_pnp))
- Left and right 3D-printed motor mount (<a href="https://github.com/PX4/PX4-user_guide/raw/main/assets/airframes/vtol/caipiroshka/motor_mounts.zip" target="_blank">design files</a>)
- CW 8045 propeller ([Eflight store](https://www.banggood.com/GEMFAN-Carbon-Nylon-8045-CWCCW-Propeller-For-Quadcopters-1-Pair-p-950874.html))
- CCW 8045 propeller ([Eflight store](https://www.banggood.com/GEMFAN-Carbon-Nylon-8045-CWCCW-Propeller-For-Quadcopters-1-Pair-p-950874.html))
- 2x 1800 kV 120-180W двигуни
  - [ePower 2208](https://www.galaxus.ch/en/s5/product/epower-22081400-fuer-2-3-lipo-imax-rc-motors-8355913)
  - [Armattan 2208 1800kV Multirotor Motor](https://www.amazon.com/Armattan-2208-1800kV-Multirotor-Motor/dp/B00UWLW0C8)
    <!-- equivalent replacement must match: kV (1800), motor size (2208) and number of LiPo cells (3S). -->
- 2x 20-30S ESC
  - [GetFPV](https://www.getfpv.com/lumenier-30a-blheli-s-esc-opto-2-4s.html)
- BEC (3А, 5-5.3В) (потрібно лише у випадку, якщо використовуєте ESC, які не можуть діяти як джерело живлення 5В для вихідної рейки)
- 3S 2200 mA LiPo акумулятор
  - Team Orion 3S 11.1V 50 C ([Hobbyshop store](https://www.hobbyshop.ch/modellbau-elektronik/akku/team-orion-lipo-2200-3s-11-1v-50c-xt60-ori60163.html))
- [Pixracer autopilot board + power module](../flight_controller/pixracer.md)
- [Digital airspeed sensor](https://hobbyking.com/en_us/hkpilot-32-digital-air-speed-sensor-and-pitot-tube-set.html)

## Збірка

Нижче наведено, як може виглядати повністю складена Caipiroshka.

![Caipiroshka](../../assets/airframes/vtol/caipiroshka/caipiroshka.jpg)

У наступному наведено деякі загальні поради щодо того, як зібрати дрон.

### Автопілот

Встановіть автопілот у середині близько до центра тяжіння корпусу повітряного судна.

### Кронштейни для мотора

Роздрукуйте кріплення мотору (2 рази), до якого посилання на файл STL було вказано у списку частин.
Прикріпіть одне кріплення двигуна на кожному боці крила так, щоб вісь двигуна приблизно проходила через центр елеронів (див. малюнок).
У верхньому зображенні горизонтальна відстань між двома кріпленнями двигуна становить 56 см.
Як тільки ви відзначите правильне положення на крилі, ви можете вкрити область, яка буде знаходитися в контакті з кріпленням, стандартною прозорою стрічкою на обох сторонах верхнього і нижнього крила.
Потім нанесіть шар гарячого клею на цю область та приклейте кріплення двигуна на крило.
Причина наявності стрічки між поверхнею крила та розплавленим клеєм полягає в тому, що ви можете дуже легко видалити кріплення двигуна, розриваючи стрічку з крила без будь-яких пошкоджень.
Це корисно, коли намагаєтесь замінити пошкоджений кронштейн мотору.

### Контролери двигуна

Регулятори обертання можуть бути прямо закріплені на пласкій поверхні кріплення двигуна за допомогою клею або кабельного стяжника.
Вам потрібно буде прокласти кабелі живлення до батарейного відсіку. Ви можете використовувати старий паяльник, щоб розтопити канали в піну.
Підключіть живильні кабелі обох контролерів двигуна в батарейному відділенні та припаяйте роз'єм в кінець.
Це дозволить вам підключити обидва контролери двигуна до модуля живлення.
Якщо у вас немає регуляторів швидкості, які можуть постачати 5 В для вихідної рейки автопілота, вам доведеться використовувати зовнішнє джерело живлення (BEC).

### GPS

GPS може бути встановлений у середині, ззаду повітряної конструкції. Це допомагає переносити вагу літака назад, оскільки два двигуни, камера та, можливо, більша батарея можуть зробити його досить важким у носу.
Також велику відстань до 12В кабелів живлення корисно для зменшення магнітних перешкод зовнішнього магнітометра.

### Датчик швидкості

Прикріпіть трубу Піто близько до зовнішнього краю одного з бічних крил.
Переконайтеся, що пітот-труба не постраждала від впливу повітря пропелера.
Все має бути в порядку, якщо горизонтальна відстань від трубки до вісі моторів більша, ніж радіус пропелера.
Використовуйте, наприклад, старий паяльник, щоб створити виступ для пітотрубки, трубки та фактичного сенсора (див. малюнок).
Створіть канал для прокладання кабелю через крило до інших компонентів.

### Підключення сенсора до шини I2C

Як датчик швидкості повітря, так і зовнішній магнітометр (розташований у корпусі Gps), необхідно підключити до шини I2C автопілота.
Отже, вам доведеться використовувати розгалужувач I2C, подібний до вказаного в переліку деталей.
Підключіть плату розподільника до шини I2C автопілота.
Потім підключіть і зовнішній магнітометр, і датчик швидкості повітря до плати-розділювача за допомогою стандартного кабелю I2C.
На верхньому зображенні плата роздільника знаходиться зліва від блоку GPS.

### Елевони

Елерони можуть бути прикріплені до задньої сторони крила за допомогою прозорої стрічки. Ви можете дотримуватися інструкцій, наданих командою Blacksheep у будівельному посібнику для корпусу повітряного судна TBS Caiprinha.

### Загальні правила збірки

Перед установкою всіх компонентів на крило використовуйте клейку стрічку, щоб утримувати їх у одному положенні та перевірте, чи центр тяжіння крила знаходиться в рекомендованому діапазоні, зазначеному в керівництві зі збірки для TBS Caipirinha.
Залежно від додаткових компонентів, які ви хочете мати на борту (наприклад, GoPro впереду або більший акумулятор), вам знадобиться змінити місце розташування компонентів.

## Конфігурація планера

Switch to the configuration section in [QGroundControl](../config/airframe.md) and select the airframe tab.
Scroll down the list to find the _VTOL Duo Tailsitter_ icon. Select the _Caipiroshka Duo Tailsitter_ from the drop-down list.

![caipiroshka](../../assets/airframes/vtol/caipiroshka/airframe_px4_vtol_caipiroshka_duo_tailsitter.jpg)

## Підключення серводвигунів

Описи у таблиці нижче стосуються користувача, який стикається з передньою частиною транспортного засобу, коли він лежить рівно на столі на животі.

| Output | Rate   | Actuator                                                     |
| ------ | ------ | ------------------------------------------------------------ |
| MAIN1  | 400 Hz | Правий (правий борт) контролер двигуна    |
| MAIN2  | 400 Hz | Контролер лівого (лівий борт) двигуна     |
| MAIN3  | 400 Hz | Пусто                                                        |
| MAIN4  | 400 Hz | Пусто                                                        |
| MAIN5  | 50 Hz  | Правий (правий борт) серводвигун ейлерона |
| MAIN6  | 50 Hz  | Лівий (лівий борт) сервопривід елерона    |
