# Ізоляція Вібрацій

Ця тема показує, як визначити, чи рівні вібрацій занадто високі, і пропонує деякі прості кроки для покращення характеристик вібрацій.

## Загальний огляд

Плати управління польотом з вбудованими акселерометрами або гіроскопами чутливі до вібрацій.
Високі рівні вібрацій можуть викликати ряд проблем, включаючи зниження ефективності/продуктивності польоту, скорочення часу польоту та збільшення зносу транспортного засобу. У крайніх випадках вібрація може призвести до обрізання сигналу датчиків/відмов, що може спричинити за собою збої у вимірах та неконтрольовані польоти.

Добре спроектовані повітряні рами гасять/зменшують амплітуду певних структурних резонансів у місці кріплення автопілота.
Додаткова ізоляція може знадобитися для зниження вібрацій до рівня, який чутливі компоненти можуть витримати (наприклад, деякі польотні контролери мають бути прикріплені до повітряної рами за допомогою якоїсь форми противібраційної піни/кріплення, тоді як інші ізольовані внутрішньо).

## Аналіз Вібрацій

[Log Analysis using Flight Review > Vibration](../log/flight_review.md#vibration) explains how to use logs to confirm whether vibration is a probable cause of flight problems.

## Основні Способи Усунення Вібрацій

Декілька простих кроків, які можуть знизити вібрації:

- Переконайтеся, що все міцно прикріплено до транспортного засобу (шасі, мачта GPS тощо).
- Використовуйте збалансовані пропелери.
- Переконайтеся, що для пропелерів, моторів, регуляторів швидкості (ESC) та повітряної рами використовуються високоякісні компоненти.
  Кожен з цих компонентів може зробити значний вплив.
- Використовуйте метод ізоляції вібрацій для монтажу автопілота.
  Many flight controllers come with _mounting foam_ that you can use for this purpose, while others have inbuilt vibration-isolation mechanisms.
- As a _last_ measure, adjust the [software filters](../config_mc/filter_tuning.md).
  Краще зменшити джерело вібрацій, аніж фільтрувати їх за допомогою програмного забезпечення.

## Джерела

Деякі посилання, які ви можете знайти корисними:

- [An Introduction to Shock & Vibration Response Spectra, Tom Irvine](http://www.vibrationdata.com/tutorials2/srs_intr.pdf) (free paper)
- Structural Dynamics and Vibration in Practice - An Engineering Handbook, Douglas Thorby (preview).
