# Battery-Chemistry Overview

This section provides a comparative overview of several different battery types (in particular LiPo and Li-Ion) and some useful battery glossary terms.

## LiPo vs Li-Ion

- Li-Ion 배터리는 LiPo 배터리 팩보다 에너지 밀도가 높지만, 방전율이 낮고 가격이 비쌉니다.
- LiPo 배터리는 구매가 편리하며, 멀티콥터에서 자주 발생하는 높은 방전율을 견딜수 있습니다.
- 비행기의 종류와 임무에 따라 적절한 것을 선택하여야 합니다.
  리튬이온 배터리가 내구성에 이점이 많지만, 조심하여 사용하여야 합니다.
  따라서, 비행 목적과 상황에 따라 결정하여야 합니다.

### LiPo

Advantages:

- 보편적으로 사용됨.
- 다양한 크기, 용량 및 전압
- 저렴한 가격
- 용량 대비 높은 방전율 (높은 C 등급)
- 높은 충전율

단점:

- 낮은 에너지 밀도(상대적임)
- 공급 업체가 많아지면 품질이 높아질 것 입니다.

### Li-Ion

Advantages:

- 높은 에너지 밀도 (최대 60 % 더 높음)

단점:

- 일반적으로 사용되지 않음.
- 가격이 비쌈.
- 대형 기체에서는 널리 사용되지 않음
- 모든 셀은 상대적으로 작기 때문에 더 큰 팩은 필요한 전압과 용량을 생성하기 위해 직렬 및 병렬로 연결된 많은 셀로 구성됩니다.
- 배터리 크기에 비해 낮은 방전율 (C 등급)
- 고전류가 필요한 차량에 적용하기 어렵습니다.
- 낮은 충전 속도 (용량 대비)
- 충전과 방전시에 면밀한 온도 모니터링이 필요합니다.
- 최대 용량을 사용하려면 ESC에서 설정을 변경하여야합니다 ( "표준"ESC 저전압 설정이 너무 높음).
- 거의 비었을 때 배터리의 전압은 Lipo와 Li-ion 사이에 약 3V 차이가 발생할 수 있습니다 (6S 배터리 사용시).
  추력 기대치에 영향을 미칠 수 있습니다.

## C 등급

- C 등급은 단순히 모든 배터리 유형의 명시된 용량의 배수입니다.
- C 등급은 충전 및 방전 속도에 모두 관련이 있습니다(그리고 다릅니다).
  - 예를 들어, 방전율이 10C 인 2000mAh 배터리 (전압에 관계없이)는 20A의 전류 (2000 / 1000 = 2Ah x 10C = 20A)를 안전하고 지속적으로 방전할 수 있습니다.
- C 등급은 항상 제조업체에서 제공합니다 (종종 배터리 팩 외부에 있음).
  정확한 값을 계산할 수 있지만 추가 정보가 필요하고 베터리 셀의 내부 저항을 측정하여야 합니다.
- LiPo 배터리는 항상 리튬이온 배터리보다 높은 C 등급을 갖습니다.
  이는 화학적 성질과 셀당 내부 저항으로 인하여 LiPo 배터리의 방전 속도가 더 높습니다.
- C 등급의 충전 및 방전에 대한 제조업체 지침을 준수하는 것은 배터리의 상태와 기체를 안전하게 작동하는 데 매우 중요합니다 (예 : 충전 및 방전 중 화재, "퍼핑"팩 및 기타 차선 상태).

## 에너지 밀도

- 에너지 밀도는 배터리 중량당 저장하는 에너지 양입니다.
  일반적으로 킬로그램 당 와트시(Wh/Kg)로 측정/비교 됩니다.
  - 와트시는 공칭(완전 충전 된 전압이 아님)에 용량을 곱한 값으로 간단히 계산됩니다. 3.7v X 5 Ah = 18.5Wh.
    3 셀 배터리 팩이있는 경우 팩은 18.5Wh X 3 = 55Wh의 저장 에너지가 됩니다.
- 배터리 무게를 고려하면 와트시를 무게로 나누어 에너지 밀도를 계산합니다.
  - 예: 55 Wh divided by (battery weight in grams divided by 1000).
    이 배터리의 무게가 300g이고 55/(300/1000)=185 Wh/Kg라고 가정합니다.
- 이 숫자 185 Wh/Kg는 최고급 LiPo 배터리의 수치입니다.
  반면에 리튬 이온 배터리는 260Wh/Kg에 달할 수 있습니다. 즉, 온보드 배터리 1kg 당 75 와트시를 더 사용할 수 있습니다.
  - 차량이 비행하는 데 걸리는 와트(배터리 전류 모듈이 표시 할 수 있음)를 알고 있다면, 이 증가된 저장 용량을 추가 중량없이 비행 시간 증가와 동일시 할 수 있습니다.
