# 매개변수 정의서

::: info This documentation was auto-generated from the source code for this PX4 version (using `make parameters_metadata`).
:::

::: tip
If a listed parameter is missing from the Firmware see: [Finding/Updating Parameters](../advanced_config/parameters.md#parameter-not-in-firmware).
:::

<!-- markdown generator: src/lib/parameters/px4params/markdownout.py -->

<style>
tr > * {
    vertical-align : top;
}
td:nth-child(1),td:nth-child(2) {
  text-align : left;
  }
table {
  width: fit-content;
}
</style>

## UAVCAN 모터 매개변수

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ctl_bw">ctl_bw</strong> (INT32)</td>
 <td>속도 조종 장치 대역폭 <p><strong>설명:</strong> 속도 컨트롤러 대역폭 (Hz). 값이 높을수록 속도와 전류 상승 시간이 빨라지지만, 오버 슈트와 전류 소비가 많이 발생할 수 있습니다. 고정익의 값은 50Hz 미만이어야합니다. 멀티콥터는 100Hz까지는 응답성을 향상시킬 수 있습니다.</p>   </td>
 <td>[10, 250] </td>
 <td>75</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="ctl_dir">ctl_dir</strong> (INT32)</td>
 <td>역방향 <p><strong>설명:</strong> 초기 열거자중에서 감지된 모터 회전 방향. 방향을 바꾸려면 0 또는 1을 사용합니다.</p>   </td>
 <td>[0, 1] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ctl_gain">ctl_gain</strong> (FLOAT)</td>
 <td>속도 (RPM) 컨트롤러 게인 <p><strong>설명:</strong> 속도 (RPM) 컨트롤러 게인. 컨트롤러 공격성을 결정합니다. 단위는 amp-초/라다인당 입니다. 회전 관성이 높은 시스템 (대형 소품)은 게인 증가가 필요합니다. 회전 관성이 낮은 시스템 (작은 소품)은 게인 감소가 필요할 수 있습니다. 값이 높을수록 응답 속도가 빨라지지만 진동과 과도한 오버 슈트가 발생할 수 있습니다. 값이 낮을수록 반응이 느려지고 부드러워집니다.</p>   </td>
 <td>[0.00, 1.00] </td>
 <td>1</td>
 <td>C/rad</td>
</tr>
<tr>
 <td><strong id="ctl_hz_idle">ctl_hz_idle</strong> (FLOAT)</td>
 <td>유휴 속도 (e Hz) <p><strong>설명:</strong> 유휴 속도 (e Hz)</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>3.5</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="ctl_start_rate">ctl_start_rate</strong> (INT32)</td>
 <td>스핀업 속도 (e Hz / s) <p><strong>설명:</strong> 스핀업 속도 (e Hz / s)</p>   </td>
 <td>[5, 1000] </td>
 <td>25</td>
 <td>1/s^2</td>
</tr>
<tr>
 <td><strong id="esc_index">esc_index</strong> (INT32)</td>
 <td>스로틀 명령 메시지의 ESC 색인입니다. <p><strong>설명:</strong> 스로틀 명령 메시지의 ESC 색인.</p>   </td>
 <td>[0, 15] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="id_ext_status">id_ext_status</strong> (INT32)</td>
 <td>확장 상태 ID <p><strong>설명:</strong> 확장 상태 ID</p>   </td>
 <td>[1, 1000000] </td>
 <td>20034</td>
 <td></td>
</tr>
<tr>
 <td><strong id="int_ext_status">int_ext_status</strong> (INT32)</td>
 <td>확장 상태 간격 (µs) <p><strong>설명:</strong> 확장 상태 간격 (µs)</p>   </td>
 <td>[0, 1000000] </td>
 <td>50000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="int_status">int_status</strong> (INT32)</td>
 <td>ESC 상태 간격 (µs) <p><strong>설명:</strong> ESC 상태 간격 (µs)</p>   </td>
 <td>[?, 1000000] </td>
 <td>50000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="mot_i_max">mot_i_max</strong> (FLOAT)</td>
 <td>모터 전류 제한(암페어 단위) <p><strong>설명:</strong> 모터 전류 제한 (암페어 단위). 최대 전류 컨트롤러 설정값과 최대 허용 전류 설정값 슬루율을 결정합니다. 이 값은 일반적으로 모터 사양서에 나열된 연속 전류 정격으로 설정하거나, 모터의 지정된 연속 전력을 모터 전압 제한으로 나눈 값과 동일하게 설정하여야 합니다.</p>   </td>
 <td>[1, 80] </td>
 <td>12</td>
 <td>A</td>
</tr>
<tr>
 <td><strong id="mot_kv">mot_kv</strong> (INT32)</td>
 <td>모터 Kv (볼트당 RPM) <p><strong>설명:</strong> 모터 Kv (볼트당 RPM). 이것은 모터의 사양 시트에서 가져올 수 있습니다. 정확도는 성능 제어에 도움이 되지만 지정된 값에서 약간의 편차는 허용됩니다.</p>   </td>
 <td>[0, 4000] </td>
 <td>2300</td>
 <td>rpm/V</td>
</tr>
<tr>
 <td><strong id="mot_ls">mot_ls</strong> (FLOAT)</td>
 <td>읽기 전용 : 모터 인덕턴스(단위 헨리). <p><strong>설명:</strong> 읽기 전용 : 모터 인덕턴스(단위 헨리). 시작시 측정됩니다.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>H</td>
</tr>
<tr>
 <td><strong id="mot_num_poles">mot_num_poles</strong> (INT32)</td>
 <td>모터 극 수. <p><strong>설명:</strong> 모터 극 수. 기계적 속도를 전기 속도로 변환에 사용됩니다. 이 번호는 모터 사양서를 참조하여야 합니다.</p>   </td>
 <td>[2, 40] </td>
 <td>14</td>
 <td></td>
</tr>
<tr>
 <td><strong id="mot_rs">mot_rs</strong> (FLOAT)</td>
 <td>읽기 전용 : 모터 저항(단위 옴) <p><strong>설명:</strong> 읽기 전용 : 모터 저항(단위 옴). 시작시 측정됩니다. 새 모터 튜닝시 모터 사양서에 표시된 값과 같은지 확인하십시오.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>Ohm</td>
</tr>
<tr>
 <td><strong id="mot_v_accel">mot_v_accel</strong> (FLOAT)</td>
 <td>가속 한계 (V) <p><strong>설명:</strong> 가속 한계 (V)</p>   </td>
 <td>[0.01, 1.00] </td>
 <td>0.5</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="mot_v_max">mot_v_max</strong> (FLOAT)</td>
 <td>모터 전압 제한 (단위 볼트) <p><strong>설명:</strong> 모터 전압 제한 (볼트). 전류 컨트롤러의 명령 전압은 이 값을 초과하지 않습니다. 이것은 모터의 공칭 전압 이상일 수 있습니다. 실제 모터 전압 한계를 결정하려면 모터의 정격 전력을 모터 전류 한계로 나눕니다.</p>   </td>
 <td>[0, ?] </td>
 <td>14.8</td>
 <td>V</td>
</tr>
</tbody></table>

## UAVCAN GNSS

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="gnss.dyn_model">gnss.dyn_model</strong> (INT32)</td>
 <td>GNSS 동적 모델 <p><strong>설명:</strong> GNSS 위치 엔진에서 사용되는 동적 모델. 0 – 자동차, 1 – 바다, 2 – 항공.
      </p> <strong>값:</strong><ul>
<li><strong>0:</strong> 자동차</li>
<li><strong>1:</strong> 바다</li>
<li><strong>2:</strong> 항공</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="gnss.old_fix_msg">gnss.old_fix_msg</strong> (INT32)</td>
 <td>이전 GNSS 수정 메시지 브로드 캐스트 <p><strong>설명:</strong> 새로운 대체 uavcan.equipment.gnss.Fix2와 함께 이전 (더 이상 사용되지 않는) GNSS 수정 메시지 uavcan.equipment.gnss.Fix를 브로드 캐스트합니다. CAN 버스 트래픽을 줄이려면 이 기능을 비활성화하는 것이 좋습니다.
      </p> <strong>값:</strong><ul>
<li><strong>0:</strong> Fix2</li>
<li><strong>1:</strong> Fix and Fix2</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="gnss.warn_dimens">gnss.warn_dimens</strong> (INT32)</td>
 <td>장치 상태 경고 <p><strong>설명:</strong> GNSS 솔루션의 차원이 이 값보다 작은 경우 장치 상태를 경고로 설정합니다. 전체 (3D) 솔루션의 경우 3, 평면 (2D) 솔루션의 경우 2, 시간 전용 솔루션의 경우 1, 0은 기능을 비활성화합니다.
      </p> <strong>값:</strong><ul>
<li><strong>0:</strong> 기능을 비활성화합니다.</li>
<li><strong>1:</strong> 시간 전용 솔루션</li>
<li><strong>2:</strong> 평면 (2D) 솔루션</li>
<li><strong>3:</strong> 전체 (3D) 솔루션</li>
</ul>  </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="gnss.warn_sats">gnss.warn_sats</strong> (INT32)</td>
 <td> <p><strong>설명:</strong> GNSS 솔루션에 사용되는 위성 수가 임계 값 미만인 경우 장치 상태를 경고로 설정합니다. 0은 기능을 비활성화합니다.
      </p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="uavcan.pubp-pres">uavcan.pubp-pres</strong> (INT32)</td>
 <td> <p><strong>설명:</strong> GNSS 솔루션에 사용되는 위성 수가 임계 값 미만인 경우 장치 상태를 경고로 설정합니다. 0은 기능을 비활성화합니다.
      </p>   </td>
 <td>[0, 1000000] </td>
 <td>0</td>
 <td>us</td>
</tr>
</tbody></table>

## ADSB

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ADSB_CALLSIGN_1">ADSB_CALLSIGN_1</strong> (INT32)</td>
 <td>First 4 characters of CALLSIGN <p><strong>Comment:</strong> Sets first 4 characters of a total of 8. Valid characters are A-Z, 0-9, &quot; &quot;. Example &quot;PX4 &quot; -&gt; 1347957792 For CALLSIGN shorter than 8 characters use the null terminator at the end &#x27;\0&#x27;.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_CALLSIGN_2">ADSB_CALLSIGN_2</strong> (INT32)</td>
 <td>Second 4 characters of CALLSIGN <p><strong>Comment:</strong> Sets second 4 characters of a total of 8. Valid characters are A-Z, 0-9, &quot; &quot; only. Example &quot;TEST&quot; -&gt; 1413829460 For CALLSIGN shorter than 8 characters use the null terminator at the end &#x27;\0&#x27;.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_EMERGC">ADSB_EMERGC</strong> (INT32)</td>
 <td>ADSB-Out Emergency State <p><strong>Comment:</strong> Sets the vehicle emergency state</p> <strong>값:</strong><ul>
<li><strong>0:</strong> NoEmergency</li>
<li><strong>1:</strong> General</li>
<li><strong>2:</strong> Medical</li>
<li><strong>3:</strong> LowFuel</li>
<li><strong>4:</strong> NoCommunications</li>
<li><strong>5:</strong> Interference</li>
<li><strong>6:</strong> Downed</li>
</ul>  <p><b>Reboot required:</b> false</p>
</td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_EMIT_TYPE">ADSB_EMIT_TYPE</strong> (INT32)</td>
 <td>ADSB-Out Vehicle Emitter Type <p><strong>Comment:</strong> Configure the emitter type of the vehicle.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unknown</li>
<li><strong>1:</strong> Light</li>
<li><strong>2:</strong> Small</li>
<li><strong>3:</strong> Large</li>
<li><strong>4:</strong> HighVortex</li>
<li><strong>5:</strong> Heavy</li>
<li><strong>6:</strong> Performance</li>
<li><strong>7:</strong> Rotorcraft</li>
<li><strong>8:</strong> RESERVED</li>
<li><strong>9:</strong> Glider</li>
<li><strong>10:</strong> LightAir</li>
<li><strong>11:</strong> Parachute</li>
<li><strong>12:</strong> UltraLight</li>
<li><strong>13:</strong> RESERVED</li>
<li><strong>14:</strong> UAV</li>
<li><strong>15:</strong> Space</li>
<li><strong>16:</strong> RESERVED</li>
<li><strong>17:</strong> EmergencySurf</li>
<li><strong>18:</strong> ServiceSurf</li>
<li><strong>19:</strong> PointObstacle</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 15] </td>
 <td>14</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_GPS_OFF_LAT">ADSB_GPS_OFF_LAT</strong> (INT32)</td>
 <td>ADSB-Out GPS Offset lat <p><strong>Comment:</strong> Sets GPS lataral offset encoding</p> <strong>값:</strong><ul>
<li><strong>0:</strong> NoData</li>
<li><strong>1:</strong> LatLeft2M</li>
<li><strong>2:</strong> LatLeft4M</li>
<li><strong>3:</strong> LatLeft6M</li>
<li><strong>4:</strong> LatRight0M</li>
<li><strong>5:</strong> LatRight2M</li>
<li><strong>6:</strong> LatRight4M</li>
<li><strong>7:</strong> LatRight6M</li>
</ul>  <p><b>Reboot required:</b> false</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_GPS_OFF_LON">ADSB_GPS_OFF_LON</strong> (INT32)</td>
 <td>ADSB-Out GPS Offset lon <p><strong>Comment:</strong> Sets GPS longitudinal offset encoding</p> <strong>값:</strong><ul>
<li><strong>0:</strong> NoData</li>
<li><strong>1:</strong> AppliedBySensor</li>
</ul>  <p><b>Reboot required:</b> false</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_ICAO_ID">ADSB_ICAO_ID</strong> (INT32)</td>
 <td>ADSB-Out ICAO configuration <p><strong>Comment:</strong> Defines the ICAO ID of the vehicle</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[-1, 16777215] </td>
 <td>1194684</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_ICAO_SPECL">ADSB_ICAO_SPECL</strong> (INT32)</td>
 <td>ADSB-In Special ICAO configuration <p><strong>Comment:</strong> This vehicle is always tracked. Use 0 to disable.</p>   <p><b>Reboot required:</b> false</p>
</td>
 <td>[0, 16777215] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_IDENT">ADSB_IDENT</strong> (INT32)</td>
 <td>ADSB-Out Ident Configuration <p><strong>Comment:</strong> Enable Identification of Position feature</p>   <p><b>Reboot required:</b> false</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_LEN_WIDTH">ADSB_LEN_WIDTH</strong> (INT32)</td>
 <td>ADSB-Out Vehicle Size Configuration <p><strong>Comment:</strong> Report the length and width of the vehicle in meters. In most cases, use &#x27;1&#x27; for the smallest vehicle size.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> SizeUnknown</li>
<li><strong>1:</strong> Len15_Wid23</li>
<li><strong>2:</strong> Len25_Wid28</li>
<li><strong>3:</strong> Len25_Wid34</li>
<li><strong>4:</strong> Len35_Wid33</li>
<li><strong>5:</strong> Len35_Wid38</li>
<li><strong>6:</strong> Len45_Wid39</li>
<li><strong>7:</strong> Len45_Wid45</li>
<li><strong>8:</strong> Len55_Wid45</li>
<li><strong>9:</strong> Len55_Wid52</li>
<li><strong>10:</strong> Len65_Wid59</li>
<li><strong>11:</strong> Len65_Wid67</li>
<li><strong>12:</strong> Len75_Wid72</li>
<li><strong>13:</strong> Len75_Wid80</li>
<li><strong>14:</strong> Len85_Wid80</li>
<li><strong>15:</strong> Len85_Wid90</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 15] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_LIST_MAX">ADSB_LIST_MAX</strong> (INT32)</td>
 <td>ADSB-In Vehicle List Size <p><strong>Comment:</strong> Change number of targets to track</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 50] </td>
 <td>25</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_MAX_SPEED">ADSB_MAX_SPEED</strong> (INT32)</td>
 <td>ADSB-Out Vehicle Max Speed <p><strong>Comment:</strong> Informs ADSB vehicles of this vehicle&#x27;s max speed capability</p> <strong>값:</strong><ul>
<li><strong>0:</strong> UnknownMaxSpeed</li>
<li><strong>1:</strong> 75Kts</li>
<li><strong>2:</strong> 150Kts</li>
<li><strong>3:</strong> 300Kts</li>
<li><strong>4:</strong> 600Kts</li>
<li><strong>5:</strong> 1200Kts</li>
<li><strong>6:</strong> Over1200Kts</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ADSB_SQUAWK">ADSB_SQUAWK</strong> (INT32)</td>
 <td>ADSB-Out squawk code configuration <p><strong>Comment:</strong> This parameter defines the squawk code. Value should be between 0000 and 7777.</p>   <p><b>Reboot required:</b> false</p>
</td>
 <td>[0, 7777] </td>
 <td>1200</td>
 <td></td>
</tr>
</tbody></table>

## Actuator Outputs

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="PCA9685_DIS1">PCA9685_DIS1</strong> (INT32)</td>
 <td>PCA9685 Output Channel 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS10">PCA9685_DIS10</strong> (INT32)</td>
 <td>PCA9685 Output Channel 10 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS11">PCA9685_DIS11</strong> (INT32)</td>
 <td>PCA9685 Output Channel 11 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS12">PCA9685_DIS12</strong> (INT32)</td>
 <td>PCA9685 Output Channel 12 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS13">PCA9685_DIS13</strong> (INT32)</td>
 <td>PCA9685 Output Channel 13 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS14">PCA9685_DIS14</strong> (INT32)</td>
 <td>PCA9685 Output Channel 14 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS15">PCA9685_DIS15</strong> (INT32)</td>
 <td>PCA9685 Output Channel 15 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS16">PCA9685_DIS16</strong> (INT32)</td>
 <td>PCA9685 Output Channel 16 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS2">PCA9685_DIS2</strong> (INT32)</td>
 <td>PCA9685 Output Channel 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS3">PCA9685_DIS3</strong> (INT32)</td>
 <td>PCA9685 Output Channel 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS4">PCA9685_DIS4</strong> (INT32)</td>
 <td>PCA9685 Output Channel 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS5">PCA9685_DIS5</strong> (INT32)</td>
 <td>PCA9685 Output Channel 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS6">PCA9685_DIS6</strong> (INT32)</td>
 <td>PCA9685 Output Channel 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS7">PCA9685_DIS7</strong> (INT32)</td>
 <td>PCA9685 Output Channel 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS8">PCA9685_DIS8</strong> (INT32)</td>
 <td>PCA9685 Output Channel 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DIS9">PCA9685_DIS9</strong> (INT32)</td>
 <td>PCA9685 Output Channel 9 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_DUTY_EN">PCA9685_DUTY_EN</strong> (INT32)</td>
 <td>Put the selected channels into Duty-Cycle output mode <p><strong>Comment:</strong> The driver will output standard pulse-width encoded signal without this bit set. To make PCA9685 output in duty-cycle fashion, please enable the corresponding channel bit here and adjusting standard params to suit your need. The driver will have 12bits resolution for duty-cycle output. That means to achieve 0% to 100% output range on one channel, the corresponding params MIN and MAX for the channel should be set to 0 and 4096. Other standard params follows the same rule.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Put CH1 to Duty-Cycle mode</li>
  <li><strong>1:</strong> Put CH2 to Duty-Cycle mode</li>
  <li><strong>2:</strong> Put CH3 to Duty-Cycle mode</li>
  <li><strong>3:</strong> Put CH4 to Duty-Cycle mode</li>
  <li><strong>4:</strong> Put CH5 to Duty-Cycle mode</li>
  <li><strong>5:</strong> Put CH6 to Duty-Cycle mode</li>
  <li><strong>6:</strong> Put CH7 to Duty-Cycle mode</li>
  <li><strong>7:</strong> Put CH8 to Duty-Cycle mode</li>
  <li><strong>8:</strong> Put CH9 to Duty-Cycle mode</li>
  <li><strong>9:</strong> Put CH10 to Duty-Cycle mode</li>
  <li><strong>10:</strong> Put CH11 to Duty-Cycle mode</li>
  <li><strong>11:</strong> Put CH12 to Duty-Cycle mode</li>
  <li><strong>12:</strong> Put CH13 to Duty-Cycle mode</li>
  <li><strong>13:</strong> Put CH14 to Duty-Cycle mode</li>
  <li><strong>14:</strong> Put CH15 to Duty-Cycle mode</li>
  <li><strong>15:</strong> Put CH16 to Duty-Cycle mode</li>
</ul>
 </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL1">PCA9685_FAIL1</strong> (INT32)</td>
 <td>PCA9685 Output Channel 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC1).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL10">PCA9685_FAIL10</strong> (INT32)</td>
 <td>PCA9685 Output Channel 10 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC10).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL11">PCA9685_FAIL11</strong> (INT32)</td>
 <td>PCA9685 Output Channel 11 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC11).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL12">PCA9685_FAIL12</strong> (INT32)</td>
 <td>PCA9685 Output Channel 12 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC12).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL13">PCA9685_FAIL13</strong> (INT32)</td>
 <td>PCA9685 Output Channel 13 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC13).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL14">PCA9685_FAIL14</strong> (INT32)</td>
 <td>PCA9685 Output Channel 14 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC14).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL15">PCA9685_FAIL15</strong> (INT32)</td>
 <td>PCA9685 Output Channel 15 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC15).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL16">PCA9685_FAIL16</strong> (INT32)</td>
 <td>PCA9685 Output Channel 16 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC16).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL2">PCA9685_FAIL2</strong> (INT32)</td>
 <td>PCA9685 Output Channel 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC2).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL3">PCA9685_FAIL3</strong> (INT32)</td>
 <td>PCA9685 Output Channel 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC3).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL4">PCA9685_FAIL4</strong> (INT32)</td>
 <td>PCA9685 Output Channel 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC4).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL5">PCA9685_FAIL5</strong> (INT32)</td>
 <td>PCA9685 Output Channel 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC5).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL6">PCA9685_FAIL6</strong> (INT32)</td>
 <td>PCA9685 Output Channel 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC6).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL7">PCA9685_FAIL7</strong> (INT32)</td>
 <td>PCA9685 Output Channel 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC7).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL8">PCA9685_FAIL8</strong> (INT32)</td>
 <td>PCA9685 Output Channel 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC8).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FAIL9">PCA9685_FAIL9</strong> (INT32)</td>
 <td>PCA9685 Output Channel 9 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC9).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC1">PCA9685_FUNC1</strong> (INT32)</td>
 <td>PCA9685 Output Channel 1 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC10">PCA9685_FUNC10</strong> (INT32)</td>
 <td>PCA9685 Output Channel 10 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 10. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC11">PCA9685_FUNC11</strong> (INT32)</td>
 <td>PCA9685 Output Channel 11 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 11. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC12">PCA9685_FUNC12</strong> (INT32)</td>
 <td>PCA9685 Output Channel 12 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 12. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC13">PCA9685_FUNC13</strong> (INT32)</td>
 <td>PCA9685 Output Channel 13 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 13. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC14">PCA9685_FUNC14</strong> (INT32)</td>
 <td>PCA9685 Output Channel 14 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 14. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC15">PCA9685_FUNC15</strong> (INT32)</td>
 <td>PCA9685 Output Channel 15 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 15. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC16">PCA9685_FUNC16</strong> (INT32)</td>
 <td>PCA9685 Output Channel 16 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 16. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC2">PCA9685_FUNC2</strong> (INT32)</td>
 <td>PCA9685 Output Channel 2 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC3">PCA9685_FUNC3</strong> (INT32)</td>
 <td>PCA9685 Output Channel 3 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC4">PCA9685_FUNC4</strong> (INT32)</td>
 <td>PCA9685 Output Channel 4 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC5">PCA9685_FUNC5</strong> (INT32)</td>
 <td>PCA9685 Output Channel 5 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC6">PCA9685_FUNC6</strong> (INT32)</td>
 <td>PCA9685 Output Channel 6 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC7">PCA9685_FUNC7</strong> (INT32)</td>
 <td>PCA9685 Output Channel 7 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC8">PCA9685_FUNC8</strong> (INT32)</td>
 <td>PCA9685 Output Channel 8 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_FUNC9">PCA9685_FUNC9</strong> (INT32)</td>
 <td>PCA9685 Output Channel 9 Output Function <p><strong>Comment:</strong> Select what should be output on PCA9685 Output Channel 9. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX1">PCA9685_MAX1</strong> (INT32)</td>
 <td>PCA9685 Output Channel 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX10">PCA9685_MAX10</strong> (INT32)</td>
 <td>PCA9685 Output Channel 10 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX11">PCA9685_MAX11</strong> (INT32)</td>
 <td>PCA9685 Output Channel 11 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX12">PCA9685_MAX12</strong> (INT32)</td>
 <td>PCA9685 Output Channel 12 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX13">PCA9685_MAX13</strong> (INT32)</td>
 <td>PCA9685 Output Channel 13 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX14">PCA9685_MAX14</strong> (INT32)</td>
 <td>PCA9685 Output Channel 14 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX15">PCA9685_MAX15</strong> (INT32)</td>
 <td>PCA9685 Output Channel 15 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX16">PCA9685_MAX16</strong> (INT32)</td>
 <td>PCA9685 Output Channel 16 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX2">PCA9685_MAX2</strong> (INT32)</td>
 <td>PCA9685 Output Channel 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX3">PCA9685_MAX3</strong> (INT32)</td>
 <td>PCA9685 Output Channel 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX4">PCA9685_MAX4</strong> (INT32)</td>
 <td>PCA9685 Output Channel 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX5">PCA9685_MAX5</strong> (INT32)</td>
 <td>PCA9685 Output Channel 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX6">PCA9685_MAX6</strong> (INT32)</td>
 <td>PCA9685 Output Channel 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX7">PCA9685_MAX7</strong> (INT32)</td>
 <td>PCA9685 Output Channel 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX8">PCA9685_MAX8</strong> (INT32)</td>
 <td>PCA9685 Output Channel 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MAX9">PCA9685_MAX9</strong> (INT32)</td>
 <td>PCA9685 Output Channel 9 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>1900</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN1">PCA9685_MIN1</strong> (INT32)</td>
 <td>PCA9685 Output Channel 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN10">PCA9685_MIN10</strong> (INT32)</td>
 <td>PCA9685 Output Channel 10 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN11">PCA9685_MIN11</strong> (INT32)</td>
 <td>PCA9685 Output Channel 11 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN12">PCA9685_MIN12</strong> (INT32)</td>
 <td>PCA9685 Output Channel 12 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN13">PCA9685_MIN13</strong> (INT32)</td>
 <td>PCA9685 Output Channel 13 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN14">PCA9685_MIN14</strong> (INT32)</td>
 <td>PCA9685 Output Channel 14 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN15">PCA9685_MIN15</strong> (INT32)</td>
 <td>PCA9685 Output Channel 15 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN16">PCA9685_MIN16</strong> (INT32)</td>
 <td>PCA9685 Output Channel 16 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN2">PCA9685_MIN2</strong> (INT32)</td>
 <td>PCA9685 Output Channel 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN3">PCA9685_MIN3</strong> (INT32)</td>
 <td>PCA9685 Output Channel 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN4">PCA9685_MIN4</strong> (INT32)</td>
 <td>PCA9685 Output Channel 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN5">PCA9685_MIN5</strong> (INT32)</td>
 <td>PCA9685 Output Channel 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN6">PCA9685_MIN6</strong> (INT32)</td>
 <td>PCA9685 Output Channel 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN7">PCA9685_MIN7</strong> (INT32)</td>
 <td>PCA9685 Output Channel 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN8">PCA9685_MIN8</strong> (INT32)</td>
 <td>PCA9685 Output Channel 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_MIN9">PCA9685_MIN9</strong> (INT32)</td>
 <td>PCA9685 Output Channel 9 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_PWM_FREQ">PCA9685_PWM_FREQ</strong> (FLOAT)</td>
 <td>PWM cycle frequency <p><strong>Comment:</strong> Controls the PWM frequency at timing perspective. This is independent from PWM update frequency, as PCA9685 is capable to output without being continuously commanded by FC. Higher frequency leads to more accurate pulse width, but some ESCs and servos may not support it. This parameter should be set to the same value as PWM update rate in most case. This parameter MUST NOT exceed upper limit of 400.0, if any outputs as generic 1000~2000us pulse width is desired. Frequency higher than 400 only makes sense in duty-cycle mode.</p>   </td>
 <td>[23.8, 1525.87] </td>
 <td>50.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_REV">PCA9685_REV</strong> (INT32)</td>
 <td>Reverse Output Range for PCA9685 Output <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> PCA9685 Output Channel 1</li>
  <li><strong>1:</strong> PCA9685 Output Channel 2</li>
  <li><strong>2:</strong> PCA9685 Output Channel 3</li>
  <li><strong>3:</strong> PCA9685 Output Channel 4</li>
  <li><strong>4:</strong> PCA9685 Output Channel 5</li>
  <li><strong>5:</strong> PCA9685 Output Channel 6</li>
  <li><strong>6:</strong> PCA9685 Output Channel 7</li>
  <li><strong>7:</strong> PCA9685 Output Channel 8</li>
  <li><strong>8:</strong> PCA9685 Output Channel 9</li>
  <li><strong>9:</strong> PCA9685 Output Channel 10</li>
  <li><strong>10:</strong> PCA9685 Output Channel 11</li>
  <li><strong>11:</strong> PCA9685 Output Channel 12</li>
  <li><strong>12:</strong> PCA9685 Output Channel 13</li>
  <li><strong>13:</strong> PCA9685 Output Channel 14</li>
  <li><strong>14:</strong> PCA9685 Output Channel 15</li>
  <li><strong>15:</strong> PCA9685 Output Channel 16</li>
</ul>
 </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCA9685_SCHD_HZ">PCA9685_SCHD_HZ</strong> (FLOAT)</td>
 <td>PWM update rate <p><strong>Comment:</strong> Controls the update rate of PWM output. Flight Controller will inform those numbers of update events in a second, to PCA9685. Higher update rate will consume more I2C bandwidth, which may even lead to worse output latency, or completely block I2C bus.</p>   </td>
 <td>[50.0, 400.0] </td>
 <td>50.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS1">PWM_AUX_DIS1</strong> (INT32)</td>
 <td>PWM Aux 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS10">PWM_AUX_DIS10</strong> (INT32)</td>
 <td>PWM Capture 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS11">PWM_AUX_DIS11</strong> (INT32)</td>
 <td>PWM Capture 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS2">PWM_AUX_DIS2</strong> (INT32)</td>
 <td>PWM Aux 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS3">PWM_AUX_DIS3</strong> (INT32)</td>
 <td>PWM Aux 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS4">PWM_AUX_DIS4</strong> (INT32)</td>
 <td>PWM Aux 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS5">PWM_AUX_DIS5</strong> (INT32)</td>
 <td>PWM Aux 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS6">PWM_AUX_DIS6</strong> (INT32)</td>
 <td>PWM Aux 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS7">PWM_AUX_DIS7</strong> (INT32)</td>
 <td>PWM Aux 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS8">PWM_AUX_DIS8</strong> (INT32)</td>
 <td>PWM Aux 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_DIS9">PWM_AUX_DIS9</strong> (INT32)</td>
 <td>PWM Capture 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL1">PWM_AUX_FAIL1</strong> (INT32)</td>
 <td>PWM Aux 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC1).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL10">PWM_AUX_FAIL10</strong> (INT32)</td>
 <td>PWM Capture 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC2).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL11">PWM_AUX_FAIL11</strong> (INT32)</td>
 <td>PWM Capture 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC3).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL2">PWM_AUX_FAIL2</strong> (INT32)</td>
 <td>PWM Aux 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC2).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL3">PWM_AUX_FAIL3</strong> (INT32)</td>
 <td>PWM Aux 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC3).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL4">PWM_AUX_FAIL4</strong> (INT32)</td>
 <td>PWM Aux 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC4).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL5">PWM_AUX_FAIL5</strong> (INT32)</td>
 <td>PWM Aux 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC5).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL6">PWM_AUX_FAIL6</strong> (INT32)</td>
 <td>PWM Aux 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC6).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL7">PWM_AUX_FAIL7</strong> (INT32)</td>
 <td>PWM Aux 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC7).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL8">PWM_AUX_FAIL8</strong> (INT32)</td>
 <td>PWM Aux 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC8).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FAIL9">PWM_AUX_FAIL9</strong> (INT32)</td>
 <td>PWM Capture 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC1).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC1">PWM_AUX_FUNC1</strong> (INT32)</td>
 <td>PWM Aux 1 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC10">PWM_AUX_FUNC10</strong> (INT32)</td>
 <td>PWM Capture 2 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Capture 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC11">PWM_AUX_FUNC11</strong> (INT32)</td>
 <td>PWM Capture 3 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Capture 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC2">PWM_AUX_FUNC2</strong> (INT32)</td>
 <td>PWM Aux 2 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC3">PWM_AUX_FUNC3</strong> (INT32)</td>
 <td>PWM Aux 3 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC4">PWM_AUX_FUNC4</strong> (INT32)</td>
 <td>PWM Aux 4 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC5">PWM_AUX_FUNC5</strong> (INT32)</td>
 <td>PWM Aux 5 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC6">PWM_AUX_FUNC6</strong> (INT32)</td>
 <td>PWM Aux 6 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC7">PWM_AUX_FUNC7</strong> (INT32)</td>
 <td>PWM Aux 7 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC8">PWM_AUX_FUNC8</strong> (INT32)</td>
 <td>PWM Aux 8 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Aux 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_FUNC9">PWM_AUX_FUNC9</strong> (INT32)</td>
 <td>PWM Capture 1 Output Function <p><strong>Comment:</strong> Select what should be output on PWM Capture 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
<li><strong>2000:</strong> Camera Trigger</li>
<li><strong>2032:</strong> Camera Capture</li>
<li><strong>2064:</strong> PPS Input</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX1">PWM_AUX_MAX1</strong> (INT32)</td>
 <td>PWM Aux 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX10">PWM_AUX_MAX10</strong> (INT32)</td>
 <td>PWM Capture 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX11">PWM_AUX_MAX11</strong> (INT32)</td>
 <td>PWM Capture 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX2">PWM_AUX_MAX2</strong> (INT32)</td>
 <td>PWM Aux 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX3">PWM_AUX_MAX3</strong> (INT32)</td>
 <td>PWM Aux 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX4">PWM_AUX_MAX4</strong> (INT32)</td>
 <td>PWM Aux 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX5">PWM_AUX_MAX5</strong> (INT32)</td>
 <td>PWM Aux 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX6">PWM_AUX_MAX6</strong> (INT32)</td>
 <td>PWM Aux 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX7">PWM_AUX_MAX7</strong> (INT32)</td>
 <td>PWM Aux 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX8">PWM_AUX_MAX8</strong> (INT32)</td>
 <td>PWM Aux 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MAX9">PWM_AUX_MAX9</strong> (INT32)</td>
 <td>PWM Capture 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN1">PWM_AUX_MIN1</strong> (INT32)</td>
 <td>PWM Aux 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN10">PWM_AUX_MIN10</strong> (INT32)</td>
 <td>PWM Capture 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN11">PWM_AUX_MIN11</strong> (INT32)</td>
 <td>PWM Capture 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN2">PWM_AUX_MIN2</strong> (INT32)</td>
 <td>PWM Aux 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN3">PWM_AUX_MIN3</strong> (INT32)</td>
 <td>PWM Aux 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN4">PWM_AUX_MIN4</strong> (INT32)</td>
 <td>PWM Aux 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN5">PWM_AUX_MIN5</strong> (INT32)</td>
 <td>PWM Aux 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN6">PWM_AUX_MIN6</strong> (INT32)</td>
 <td>PWM Aux 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN7">PWM_AUX_MIN7</strong> (INT32)</td>
 <td>PWM Aux 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN8">PWM_AUX_MIN8</strong> (INT32)</td>
 <td>PWM Aux 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_MIN9">PWM_AUX_MIN9</strong> (INT32)</td>
 <td>PWM Capture 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_REV">PWM_AUX_REV</strong> (INT32)</td>
 <td>Reverse Output Range for PWM AUX <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> PWM Aux 1</li>
  <li><strong>1:</strong> PWM Aux 2</li>
  <li><strong>2:</strong> PWM Aux 3</li>
  <li><strong>3:</strong> PWM Aux 4</li>
  <li><strong>4:</strong> PWM Aux 5</li>
  <li><strong>5:</strong> PWM Aux 6</li>
  <li><strong>6:</strong> PWM Aux 7</li>
  <li><strong>7:</strong> PWM Aux 8</li>
  <li><strong>8:</strong> PWM Capture 1</li>
  <li><strong>9:</strong> PWM Capture 2</li>
  <li><strong>10:</strong> PWM Capture 3</li>
</ul>
 </td>
 <td>[0, 2047] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_TIM0">PWM_AUX_TIM0</strong> (INT32)</td>
 <td>Output Protocol Configuration for PWM Aux 1-4 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs PWM Aux 1-4. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-5:</strong> DShot150</li>
<li><strong>-4:</strong> DShot300</li>
<li><strong>-3:</strong> DShot600</li>
<li><strong>-2:</strong> DShot1200</li>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_TIM1">PWM_AUX_TIM1</strong> (INT32)</td>
 <td>Output Protocol Configuration for PWM Aux 5-6 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs PWM Aux 5-6. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_TIM2">PWM_AUX_TIM2</strong> (INT32)</td>
 <td>Output Protocol Configuration for PWM Aux 7-8 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs PWM Aux 7-8. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_AUX_TIM3">PWM_AUX_TIM3</strong> (INT32)</td>
 <td>Output Protocol Configuration for PWM Capture 1-3 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs PWM Capture 1-3. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS1">PWM_MAIN_DIS1</strong> (INT32)</td>
 <td>MAIN 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS2">PWM_MAIN_DIS2</strong> (INT32)</td>
 <td>MAIN 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS3">PWM_MAIN_DIS3</strong> (INT32)</td>
 <td>MAIN 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS4">PWM_MAIN_DIS4</strong> (INT32)</td>
 <td>MAIN 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS5">PWM_MAIN_DIS5</strong> (INT32)</td>
 <td>MAIN 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS6">PWM_MAIN_DIS6</strong> (INT32)</td>
 <td>MAIN 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS7">PWM_MAIN_DIS7</strong> (INT32)</td>
 <td>MAIN 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_DIS8">PWM_MAIN_DIS8</strong> (INT32)</td>
 <td>MAIN 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[800, 2200] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL1">PWM_MAIN_FAIL1</strong> (INT32)</td>
 <td>MAIN 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC1).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL2">PWM_MAIN_FAIL2</strong> (INT32)</td>
 <td>MAIN 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC2).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL3">PWM_MAIN_FAIL3</strong> (INT32)</td>
 <td>MAIN 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC3).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL4">PWM_MAIN_FAIL4</strong> (INT32)</td>
 <td>MAIN 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC4).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL5">PWM_MAIN_FAIL5</strong> (INT32)</td>
 <td>MAIN 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC5).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL6">PWM_MAIN_FAIL6</strong> (INT32)</td>
 <td>MAIN 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC6).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL7">PWM_MAIN_FAIL7</strong> (INT32)</td>
 <td>MAIN 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC7).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FAIL8">PWM_MAIN_FAIL8</strong> (INT32)</td>
 <td>MAIN 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC8).</p>   </td>
 <td>[-1, 2200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC1">PWM_MAIN_FUNC1</strong> (INT32)</td>
 <td>MAIN 1 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC2">PWM_MAIN_FUNC2</strong> (INT32)</td>
 <td>MAIN 2 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC3">PWM_MAIN_FUNC3</strong> (INT32)</td>
 <td>MAIN 3 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC4">PWM_MAIN_FUNC4</strong> (INT32)</td>
 <td>MAIN 4 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC5">PWM_MAIN_FUNC5</strong> (INT32)</td>
 <td>MAIN 5 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC6">PWM_MAIN_FUNC6</strong> (INT32)</td>
 <td>MAIN 6 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC7">PWM_MAIN_FUNC7</strong> (INT32)</td>
 <td>MAIN 7 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_FUNC8">PWM_MAIN_FUNC8</strong> (INT32)</td>
 <td>MAIN 8 Output Function <p><strong>Comment:</strong> Select what should be output on MAIN 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX1">PWM_MAIN_MAX1</strong> (INT32)</td>
 <td>MAIN 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX2">PWM_MAIN_MAX2</strong> (INT32)</td>
 <td>MAIN 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX3">PWM_MAIN_MAX3</strong> (INT32)</td>
 <td>MAIN 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX4">PWM_MAIN_MAX4</strong> (INT32)</td>
 <td>MAIN 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX5">PWM_MAIN_MAX5</strong> (INT32)</td>
 <td>MAIN 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX6">PWM_MAIN_MAX6</strong> (INT32)</td>
 <td>MAIN 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX7">PWM_MAIN_MAX7</strong> (INT32)</td>
 <td>MAIN 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MAX8">PWM_MAIN_MAX8</strong> (INT32)</td>
 <td>MAIN 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[1600, 2200] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN1">PWM_MAIN_MIN1</strong> (INT32)</td>
 <td>MAIN 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN2">PWM_MAIN_MIN2</strong> (INT32)</td>
 <td>MAIN 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN3">PWM_MAIN_MIN3</strong> (INT32)</td>
 <td>MAIN 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN4">PWM_MAIN_MIN4</strong> (INT32)</td>
 <td>MAIN 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN5">PWM_MAIN_MIN5</strong> (INT32)</td>
 <td>MAIN 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN6">PWM_MAIN_MIN6</strong> (INT32)</td>
 <td>MAIN 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN7">PWM_MAIN_MIN7</strong> (INT32)</td>
 <td>MAIN 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_MIN8">PWM_MAIN_MIN8</strong> (INT32)</td>
 <td>MAIN 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[800, 1400] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_REV">PWM_MAIN_REV</strong> (INT32)</td>
 <td>Reverse Output Range for PWM MAIN <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> MAIN 1</li>
  <li><strong>1:</strong> MAIN 2</li>
  <li><strong>2:</strong> MAIN 3</li>
  <li><strong>3:</strong> MAIN 4</li>
  <li><strong>4:</strong> MAIN 5</li>
  <li><strong>5:</strong> MAIN 6</li>
  <li><strong>6:</strong> MAIN 7</li>
  <li><strong>7:</strong> MAIN 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_TIM0">PWM_MAIN_TIM0</strong> (INT32)</td>
 <td>Output Protocol Configuration for MAIN 1-2 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs MAIN 1-2. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_TIM1">PWM_MAIN_TIM1</strong> (INT32)</td>
 <td>Output Protocol Configuration for MAIN 3-4 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs MAIN 3-4. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PWM_MAIN_TIM2">PWM_MAIN_TIM2</strong> (INT32)</td>
 <td>Output Protocol Configuration for MAIN 5-8 <p><strong>Comment:</strong> Select which Output Protocol to use for outputs MAIN 5-8. Custom PWM rates can be used by directly setting any value &gt;0.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> OneShot</li>
<li><strong>50:</strong> PWM 50 Hz</li>
<li><strong>100:</strong> PWM 100 Hz</li>
<li><strong>200:</strong> PWM 200 Hz</li>
<li><strong>400:</strong> PWM 400 Hz</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>400</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_DIS1">RBCLW_DIS1</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[128, 128] </td>
 <td>128</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_DIS2">RBCLW_DIS2</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[128, 128] </td>
 <td>128</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_FAIL1">RBCLW_FAIL1</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see RBCLW_FUNC1).</p>   </td>
 <td>[-1, 257] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_FAIL2">RBCLW_FAIL2</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see RBCLW_FUNC2).</p>   </td>
 <td>[-1, 257] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_FUNC1">RBCLW_FUNC1</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 1 Output Function <p><strong>Comment:</strong> Select what should be output on Roboclaw Driver Channel 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_FUNC2">RBCLW_FUNC2</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 2 Output Function <p><strong>Comment:</strong> Select what should be output on Roboclaw Driver Channel 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_MAX1">RBCLW_MAX1</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[128, 256] </td>
 <td>256</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_MAX2">RBCLW_MAX2</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[128, 256] </td>
 <td>256</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_MIN1">RBCLW_MIN1</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[1, 128] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_MIN2">RBCLW_MIN2</strong> (INT32)</td>
 <td>Roboclaw Driver Channel 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[1, 128] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_REV">RBCLW_REV</strong> (INT32)</td>
 <td>Reverse Output Range for Roboclaw Driver <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Roboclaw Driver Channel 1</li>
  <li><strong>1:</strong> Roboclaw Driver Channel 2</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS1">SIM_GZ_EC_DIS1</strong> (INT32)</td>
 <td>SIM_GZ ESC 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS2">SIM_GZ_EC_DIS2</strong> (INT32)</td>
 <td>SIM_GZ ESC 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS3">SIM_GZ_EC_DIS3</strong> (INT32)</td>
 <td>SIM_GZ ESC 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS4">SIM_GZ_EC_DIS4</strong> (INT32)</td>
 <td>SIM_GZ ESC 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS5">SIM_GZ_EC_DIS5</strong> (INT32)</td>
 <td>SIM_GZ ESC 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS6">SIM_GZ_EC_DIS6</strong> (INT32)</td>
 <td>SIM_GZ ESC 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS7">SIM_GZ_EC_DIS7</strong> (INT32)</td>
 <td>SIM_GZ ESC 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_DIS8">SIM_GZ_EC_DIS8</strong> (INT32)</td>
 <td>SIM_GZ ESC 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL1">SIM_GZ_EC_FAIL1</strong> (INT32)</td>
 <td>SIM_GZ ESC 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC1).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL2">SIM_GZ_EC_FAIL2</strong> (INT32)</td>
 <td>SIM_GZ ESC 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC2).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL3">SIM_GZ_EC_FAIL3</strong> (INT32)</td>
 <td>SIM_GZ ESC 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC3).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL4">SIM_GZ_EC_FAIL4</strong> (INT32)</td>
 <td>SIM_GZ ESC 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC4).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL5">SIM_GZ_EC_FAIL5</strong> (INT32)</td>
 <td>SIM_GZ ESC 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC5).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL6">SIM_GZ_EC_FAIL6</strong> (INT32)</td>
 <td>SIM_GZ ESC 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC6).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL7">SIM_GZ_EC_FAIL7</strong> (INT32)</td>
 <td>SIM_GZ ESC 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC7).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FAIL8">SIM_GZ_EC_FAIL8</strong> (INT32)</td>
 <td>SIM_GZ ESC 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC8).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC1">SIM_GZ_EC_FUNC1</strong> (INT32)</td>
 <td>SIM_GZ ESC 1 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC2">SIM_GZ_EC_FUNC2</strong> (INT32)</td>
 <td>SIM_GZ ESC 2 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC3">SIM_GZ_EC_FUNC3</strong> (INT32)</td>
 <td>SIM_GZ ESC 3 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC4">SIM_GZ_EC_FUNC4</strong> (INT32)</td>
 <td>SIM_GZ ESC 4 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC5">SIM_GZ_EC_FUNC5</strong> (INT32)</td>
 <td>SIM_GZ ESC 5 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC6">SIM_GZ_EC_FUNC6</strong> (INT32)</td>
 <td>SIM_GZ ESC 6 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC7">SIM_GZ_EC_FUNC7</strong> (INT32)</td>
 <td>SIM_GZ ESC 7 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_FUNC8">SIM_GZ_EC_FUNC8</strong> (INT32)</td>
 <td>SIM_GZ ESC 8 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ ESC 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX1">SIM_GZ_EC_MAX1</strong> (INT32)</td>
 <td>SIM_GZ ESC 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX2">SIM_GZ_EC_MAX2</strong> (INT32)</td>
 <td>SIM_GZ ESC 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX3">SIM_GZ_EC_MAX3</strong> (INT32)</td>
 <td>SIM_GZ ESC 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX4">SIM_GZ_EC_MAX4</strong> (INT32)</td>
 <td>SIM_GZ ESC 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX5">SIM_GZ_EC_MAX5</strong> (INT32)</td>
 <td>SIM_GZ ESC 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX6">SIM_GZ_EC_MAX6</strong> (INT32)</td>
 <td>SIM_GZ ESC 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX7">SIM_GZ_EC_MAX7</strong> (INT32)</td>
 <td>SIM_GZ ESC 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MAX8">SIM_GZ_EC_MAX8</strong> (INT32)</td>
 <td>SIM_GZ ESC 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN1">SIM_GZ_EC_MIN1</strong> (INT32)</td>
 <td>SIM_GZ ESC 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN2">SIM_GZ_EC_MIN2</strong> (INT32)</td>
 <td>SIM_GZ ESC 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN3">SIM_GZ_EC_MIN3</strong> (INT32)</td>
 <td>SIM_GZ ESC 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN4">SIM_GZ_EC_MIN4</strong> (INT32)</td>
 <td>SIM_GZ ESC 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN5">SIM_GZ_EC_MIN5</strong> (INT32)</td>
 <td>SIM_GZ ESC 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN6">SIM_GZ_EC_MIN6</strong> (INT32)</td>
 <td>SIM_GZ ESC 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN7">SIM_GZ_EC_MIN7</strong> (INT32)</td>
 <td>SIM_GZ ESC 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_MIN8">SIM_GZ_EC_MIN8</strong> (INT32)</td>
 <td>SIM_GZ ESC 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_EC_REV">SIM_GZ_EC_REV</strong> (INT32)</td>
 <td>Reverse Output Range for SIM_GZ <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> SIM_GZ ESC 1</li>
  <li><strong>1:</strong> SIM_GZ ESC 2</li>
  <li><strong>2:</strong> SIM_GZ ESC 3</li>
  <li><strong>3:</strong> SIM_GZ ESC 4</li>
  <li><strong>4:</strong> SIM_GZ ESC 5</li>
  <li><strong>5:</strong> SIM_GZ ESC 6</li>
  <li><strong>6:</strong> SIM_GZ ESC 7</li>
  <li><strong>7:</strong> SIM_GZ ESC 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS1">SIM_GZ_SV_DIS1</strong> (INT32)</td>
 <td>SIM_GZ Servo 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS2">SIM_GZ_SV_DIS2</strong> (INT32)</td>
 <td>SIM_GZ Servo 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS3">SIM_GZ_SV_DIS3</strong> (INT32)</td>
 <td>SIM_GZ Servo 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS4">SIM_GZ_SV_DIS4</strong> (INT32)</td>
 <td>SIM_GZ Servo 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS5">SIM_GZ_SV_DIS5</strong> (INT32)</td>
 <td>SIM_GZ Servo 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS6">SIM_GZ_SV_DIS6</strong> (INT32)</td>
 <td>SIM_GZ Servo 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS7">SIM_GZ_SV_DIS7</strong> (INT32)</td>
 <td>SIM_GZ Servo 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_DIS8">SIM_GZ_SV_DIS8</strong> (INT32)</td>
 <td>SIM_GZ Servo 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL1">SIM_GZ_SV_FAIL1</strong> (INT32)</td>
 <td>SIM_GZ Servo 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC1).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL2">SIM_GZ_SV_FAIL2</strong> (INT32)</td>
 <td>SIM_GZ Servo 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC2).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL3">SIM_GZ_SV_FAIL3</strong> (INT32)</td>
 <td>SIM_GZ Servo 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC3).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL4">SIM_GZ_SV_FAIL4</strong> (INT32)</td>
 <td>SIM_GZ Servo 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC4).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL5">SIM_GZ_SV_FAIL5</strong> (INT32)</td>
 <td>SIM_GZ Servo 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC5).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL6">SIM_GZ_SV_FAIL6</strong> (INT32)</td>
 <td>SIM_GZ Servo 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC6).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL7">SIM_GZ_SV_FAIL7</strong> (INT32)</td>
 <td>SIM_GZ Servo 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC7).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FAIL8">SIM_GZ_SV_FAIL8</strong> (INT32)</td>
 <td>SIM_GZ Servo 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC8).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC1">SIM_GZ_SV_FUNC1</strong> (INT32)</td>
 <td>SIM_GZ Servo 1 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC2">SIM_GZ_SV_FUNC2</strong> (INT32)</td>
 <td>SIM_GZ Servo 2 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC3">SIM_GZ_SV_FUNC3</strong> (INT32)</td>
 <td>SIM_GZ Servo 3 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC4">SIM_GZ_SV_FUNC4</strong> (INT32)</td>
 <td>SIM_GZ Servo 4 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC5">SIM_GZ_SV_FUNC5</strong> (INT32)</td>
 <td>SIM_GZ Servo 5 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC6">SIM_GZ_SV_FUNC6</strong> (INT32)</td>
 <td>SIM_GZ Servo 6 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC7">SIM_GZ_SV_FUNC7</strong> (INT32)</td>
 <td>SIM_GZ Servo 7 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_FUNC8">SIM_GZ_SV_FUNC8</strong> (INT32)</td>
 <td>SIM_GZ Servo 8 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Servo 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX1">SIM_GZ_SV_MAX1</strong> (INT32)</td>
 <td>SIM_GZ Servo 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX2">SIM_GZ_SV_MAX2</strong> (INT32)</td>
 <td>SIM_GZ Servo 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX3">SIM_GZ_SV_MAX3</strong> (INT32)</td>
 <td>SIM_GZ Servo 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX4">SIM_GZ_SV_MAX4</strong> (INT32)</td>
 <td>SIM_GZ Servo 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX5">SIM_GZ_SV_MAX5</strong> (INT32)</td>
 <td>SIM_GZ Servo 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX6">SIM_GZ_SV_MAX6</strong> (INT32)</td>
 <td>SIM_GZ Servo 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX7">SIM_GZ_SV_MAX7</strong> (INT32)</td>
 <td>SIM_GZ Servo 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MAX8">SIM_GZ_SV_MAX8</strong> (INT32)</td>
 <td>SIM_GZ Servo 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN1">SIM_GZ_SV_MIN1</strong> (INT32)</td>
 <td>SIM_GZ Servo 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN2">SIM_GZ_SV_MIN2</strong> (INT32)</td>
 <td>SIM_GZ Servo 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN3">SIM_GZ_SV_MIN3</strong> (INT32)</td>
 <td>SIM_GZ Servo 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN4">SIM_GZ_SV_MIN4</strong> (INT32)</td>
 <td>SIM_GZ Servo 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN5">SIM_GZ_SV_MIN5</strong> (INT32)</td>
 <td>SIM_GZ Servo 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN6">SIM_GZ_SV_MIN6</strong> (INT32)</td>
 <td>SIM_GZ Servo 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN7">SIM_GZ_SV_MIN7</strong> (INT32)</td>
 <td>SIM_GZ Servo 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_MIN8">SIM_GZ_SV_MIN8</strong> (INT32)</td>
 <td>SIM_GZ Servo 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_SV_REV">SIM_GZ_SV_REV</strong> (INT32)</td>
 <td>Reverse Output Range for SIM_GZ <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> SIM_GZ Servo 1</li>
  <li><strong>1:</strong> SIM_GZ Servo 2</li>
  <li><strong>2:</strong> SIM_GZ Servo 3</li>
  <li><strong>3:</strong> SIM_GZ Servo 4</li>
  <li><strong>4:</strong> SIM_GZ Servo 5</li>
  <li><strong>5:</strong> SIM_GZ Servo 6</li>
  <li><strong>6:</strong> SIM_GZ Servo 7</li>
  <li><strong>7:</strong> SIM_GZ Servo 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_DIS1">SIM_GZ_WH_DIS1</strong> (INT32)</td>
 <td>SIM_GZ Wheels 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 200] </td>
 <td>100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_DIS2">SIM_GZ_WH_DIS2</strong> (INT32)</td>
 <td>SIM_GZ Wheels 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 200] </td>
 <td>100</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_FAIL1">SIM_GZ_WH_FAIL1</strong> (INT32)</td>
 <td>SIM_GZ Wheels 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC1).</p>   </td>
 <td>[-1, 200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_FAIL2">SIM_GZ_WH_FAIL2</strong> (INT32)</td>
 <td>SIM_GZ Wheels 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC2).</p>   </td>
 <td>[-1, 200] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_FUNC1">SIM_GZ_WH_FUNC1</strong> (INT32)</td>
 <td>SIM_GZ Wheels 1 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Wheels 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_FUNC2">SIM_GZ_WH_FUNC2</strong> (INT32)</td>
 <td>SIM_GZ Wheels 2 Output Function <p><strong>Comment:</strong> Select what should be output on SIM_GZ Wheels 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_MAX1">SIM_GZ_WH_MAX1</strong> (INT32)</td>
 <td>SIM_GZ Wheels 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 200] </td>
 <td>200</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_MAX2">SIM_GZ_WH_MAX2</strong> (INT32)</td>
 <td>SIM_GZ Wheels 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 200] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_MIN1">SIM_GZ_WH_MIN1</strong> (INT32)</td>
 <td>SIM_GZ Wheels 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 200] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_MIN2">SIM_GZ_WH_MIN2</strong> (INT32)</td>
 <td>SIM_GZ Wheels 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 200] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_GZ_WH_REV">SIM_GZ_WH_REV</strong> (INT32)</td>
 <td>Reverse Output Range for SIM_GZ <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> SIM_GZ Wheels 1</li>
  <li><strong>1:</strong> SIM_GZ Wheels 2</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC1">TAP_ESC_FUNC1</strong> (INT32)</td>
 <td>TAP ESC Output ESC 1 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC2">TAP_ESC_FUNC2</strong> (INT32)</td>
 <td>TAP ESC Output ESC 2 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC3">TAP_ESC_FUNC3</strong> (INT32)</td>
 <td>TAP ESC Output ESC 3 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC4">TAP_ESC_FUNC4</strong> (INT32)</td>
 <td>TAP ESC Output ESC 4 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC5">TAP_ESC_FUNC5</strong> (INT32)</td>
 <td>TAP ESC Output ESC 5 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC6">TAP_ESC_FUNC6</strong> (INT32)</td>
 <td>TAP ESC Output ESC 6 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC7">TAP_ESC_FUNC7</strong> (INT32)</td>
 <td>TAP ESC Output ESC 7 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_FUNC8">TAP_ESC_FUNC8</strong> (INT32)</td>
 <td>TAP ESC Output ESC 8 Output Function <p><strong>Comment:</strong> Select what should be output on TAP ESC Output ESC 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TAP_ESC_REV">TAP_ESC_REV</strong> (INT32)</td>
 <td>Reverse Output Range for TAP ESC Output <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> TAP ESC Output ESC 1</li>
  <li><strong>1:</strong> TAP ESC Output ESC 2</li>
  <li><strong>2:</strong> TAP ESC Output ESC 3</li>
  <li><strong>3:</strong> TAP ESC Output ESC 4</li>
  <li><strong>4:</strong> TAP ESC Output ESC 5</li>
  <li><strong>5:</strong> TAP ESC Output ESC 6</li>
  <li><strong>6:</strong> TAP ESC Output ESC 7</li>
  <li><strong>7:</strong> TAP ESC Output ESC 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL1">UAVCAN_EC_FAIL1</strong> (INT32)</td>
 <td>UAVCAN ESC 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC1).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL2">UAVCAN_EC_FAIL2</strong> (INT32)</td>
 <td>UAVCAN ESC 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC2).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL3">UAVCAN_EC_FAIL3</strong> (INT32)</td>
 <td>UAVCAN ESC 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC3).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL4">UAVCAN_EC_FAIL4</strong> (INT32)</td>
 <td>UAVCAN ESC 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC4).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL5">UAVCAN_EC_FAIL5</strong> (INT32)</td>
 <td>UAVCAN ESC 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC5).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL6">UAVCAN_EC_FAIL6</strong> (INT32)</td>
 <td>UAVCAN ESC 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC6).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL7">UAVCAN_EC_FAIL7</strong> (INT32)</td>
 <td>UAVCAN ESC 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC7).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FAIL8">UAVCAN_EC_FAIL8</strong> (INT32)</td>
 <td>UAVCAN ESC 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC8).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC1">UAVCAN_EC_FUNC1</strong> (INT32)</td>
 <td>UAVCAN ESC 1 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC2">UAVCAN_EC_FUNC2</strong> (INT32)</td>
 <td>UAVCAN ESC 2 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC3">UAVCAN_EC_FUNC3</strong> (INT32)</td>
 <td>UAVCAN ESC 3 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC4">UAVCAN_EC_FUNC4</strong> (INT32)</td>
 <td>UAVCAN ESC 4 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC5">UAVCAN_EC_FUNC5</strong> (INT32)</td>
 <td>UAVCAN ESC 5 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC6">UAVCAN_EC_FUNC6</strong> (INT32)</td>
 <td>UAVCAN ESC 6 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC7">UAVCAN_EC_FUNC7</strong> (INT32)</td>
 <td>UAVCAN ESC 7 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_FUNC8">UAVCAN_EC_FUNC8</strong> (INT32)</td>
 <td>UAVCAN ESC 8 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN ESC 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX1">UAVCAN_EC_MAX1</strong> (INT32)</td>
 <td>UAVCAN ESC 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX2">UAVCAN_EC_MAX2</strong> (INT32)</td>
 <td>UAVCAN ESC 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX3">UAVCAN_EC_MAX3</strong> (INT32)</td>
 <td>UAVCAN ESC 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX4">UAVCAN_EC_MAX4</strong> (INT32)</td>
 <td>UAVCAN ESC 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX5">UAVCAN_EC_MAX5</strong> (INT32)</td>
 <td>UAVCAN ESC 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX6">UAVCAN_EC_MAX6</strong> (INT32)</td>
 <td>UAVCAN ESC 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX7">UAVCAN_EC_MAX7</strong> (INT32)</td>
 <td>UAVCAN ESC 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MAX8">UAVCAN_EC_MAX8</strong> (INT32)</td>
 <td>UAVCAN ESC 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN1">UAVCAN_EC_MIN1</strong> (INT32)</td>
 <td>UAVCAN ESC 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN2">UAVCAN_EC_MIN2</strong> (INT32)</td>
 <td>UAVCAN ESC 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN3">UAVCAN_EC_MIN3</strong> (INT32)</td>
 <td>UAVCAN ESC 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN4">UAVCAN_EC_MIN4</strong> (INT32)</td>
 <td>UAVCAN ESC 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN5">UAVCAN_EC_MIN5</strong> (INT32)</td>
 <td>UAVCAN ESC 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN6">UAVCAN_EC_MIN6</strong> (INT32)</td>
 <td>UAVCAN ESC 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN7">UAVCAN_EC_MIN7</strong> (INT32)</td>
 <td>UAVCAN ESC 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_MIN8">UAVCAN_EC_MIN8</strong> (INT32)</td>
 <td>UAVCAN ESC 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_EC_REV">UAVCAN_EC_REV</strong> (INT32)</td>
 <td>Reverse Output Range for UAVCAN <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> UAVCAN ESC 1</li>
  <li><strong>1:</strong> UAVCAN ESC 2</li>
  <li><strong>2:</strong> UAVCAN ESC 3</li>
  <li><strong>3:</strong> UAVCAN ESC 4</li>
  <li><strong>4:</strong> UAVCAN ESC 5</li>
  <li><strong>5:</strong> UAVCAN ESC 6</li>
  <li><strong>6:</strong> UAVCAN ESC 7</li>
  <li><strong>7:</strong> UAVCAN ESC 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS1">UAVCAN_SV_DIS1</strong> (INT32)</td>
 <td>UAVCAN Servo 1 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS2">UAVCAN_SV_DIS2</strong> (INT32)</td>
 <td>UAVCAN Servo 2 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS3">UAVCAN_SV_DIS3</strong> (INT32)</td>
 <td>UAVCAN Servo 3 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS4">UAVCAN_SV_DIS4</strong> (INT32)</td>
 <td>UAVCAN Servo 4 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS5">UAVCAN_SV_DIS5</strong> (INT32)</td>
 <td>UAVCAN Servo 5 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS6">UAVCAN_SV_DIS6</strong> (INT32)</td>
 <td>UAVCAN Servo 6 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS7">UAVCAN_SV_DIS7</strong> (INT32)</td>
 <td>UAVCAN Servo 7 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_DIS8">UAVCAN_SV_DIS8</strong> (INT32)</td>
 <td>UAVCAN Servo 8 Disarmed Value <p><strong>Comment:</strong> This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.</p>   </td>
 <td>[0, 1000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL1">UAVCAN_SV_FAIL1</strong> (INT32)</td>
 <td>UAVCAN Servo 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC1).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL2">UAVCAN_SV_FAIL2</strong> (INT32)</td>
 <td>UAVCAN Servo 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC2).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL3">UAVCAN_SV_FAIL3</strong> (INT32)</td>
 <td>UAVCAN Servo 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC3).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL4">UAVCAN_SV_FAIL4</strong> (INT32)</td>
 <td>UAVCAN Servo 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC4).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL5">UAVCAN_SV_FAIL5</strong> (INT32)</td>
 <td>UAVCAN Servo 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC5).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL6">UAVCAN_SV_FAIL6</strong> (INT32)</td>
 <td>UAVCAN Servo 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC6).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL7">UAVCAN_SV_FAIL7</strong> (INT32)</td>
 <td>UAVCAN Servo 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC7).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FAIL8">UAVCAN_SV_FAIL8</strong> (INT32)</td>
 <td>UAVCAN Servo 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC8).</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC1">UAVCAN_SV_FUNC1</strong> (INT32)</td>
 <td>UAVCAN Servo 1 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC2">UAVCAN_SV_FUNC2</strong> (INT32)</td>
 <td>UAVCAN Servo 2 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC3">UAVCAN_SV_FUNC3</strong> (INT32)</td>
 <td>UAVCAN Servo 3 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC4">UAVCAN_SV_FUNC4</strong> (INT32)</td>
 <td>UAVCAN Servo 4 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC5">UAVCAN_SV_FUNC5</strong> (INT32)</td>
 <td>UAVCAN Servo 5 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC6">UAVCAN_SV_FUNC6</strong> (INT32)</td>
 <td>UAVCAN Servo 6 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC7">UAVCAN_SV_FUNC7</strong> (INT32)</td>
 <td>UAVCAN Servo 7 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_FUNC8">UAVCAN_SV_FUNC8</strong> (INT32)</td>
 <td>UAVCAN Servo 8 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCAN Servo 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX1">UAVCAN_SV_MAX1</strong> (INT32)</td>
 <td>UAVCAN Servo 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX2">UAVCAN_SV_MAX2</strong> (INT32)</td>
 <td>UAVCAN Servo 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX3">UAVCAN_SV_MAX3</strong> (INT32)</td>
 <td>UAVCAN Servo 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX4">UAVCAN_SV_MAX4</strong> (INT32)</td>
 <td>UAVCAN Servo 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX5">UAVCAN_SV_MAX5</strong> (INT32)</td>
 <td>UAVCAN Servo 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX6">UAVCAN_SV_MAX6</strong> (INT32)</td>
 <td>UAVCAN Servo 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX7">UAVCAN_SV_MAX7</strong> (INT32)</td>
 <td>UAVCAN Servo 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MAX8">UAVCAN_SV_MAX8</strong> (INT32)</td>
 <td>UAVCAN Servo 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN1">UAVCAN_SV_MIN1</strong> (INT32)</td>
 <td>UAVCAN Servo 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN2">UAVCAN_SV_MIN2</strong> (INT32)</td>
 <td>UAVCAN Servo 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN3">UAVCAN_SV_MIN3</strong> (INT32)</td>
 <td>UAVCAN Servo 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN4">UAVCAN_SV_MIN4</strong> (INT32)</td>
 <td>UAVCAN Servo 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN5">UAVCAN_SV_MIN5</strong> (INT32)</td>
 <td>UAVCAN Servo 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN6">UAVCAN_SV_MIN6</strong> (INT32)</td>
 <td>UAVCAN Servo 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN7">UAVCAN_SV_MIN7</strong> (INT32)</td>
 <td>UAVCAN Servo 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_MIN8">UAVCAN_SV_MIN8</strong> (INT32)</td>
 <td>UAVCAN Servo 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UAVCAN_SV_REV">UAVCAN_SV_REV</strong> (INT32)</td>
 <td>Reverse Output Range for UAVCAN <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> UAVCAN Servo 1</li>
  <li><strong>1:</strong> UAVCAN Servo 2</li>
  <li><strong>2:</strong> UAVCAN Servo 3</li>
  <li><strong>3:</strong> UAVCAN Servo 4</li>
  <li><strong>4:</strong> UAVCAN Servo 5</li>
  <li><strong>5:</strong> UAVCAN Servo 6</li>
  <li><strong>6:</strong> UAVCAN Servo 7</li>
  <li><strong>7:</strong> UAVCAN Servo 8</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL1">UCAN1_ESC_FAIL1</strong> (INT32)</td>
 <td>UAVCANv1 ESC 1 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC1).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL10">UCAN1_ESC_FAIL10</strong> (INT32)</td>
 <td>UAVCANv1 ESC 10 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC10).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL11">UCAN1_ESC_FAIL11</strong> (INT32)</td>
 <td>UAVCANv1 ESC 11 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC11).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL12">UCAN1_ESC_FAIL12</strong> (INT32)</td>
 <td>UAVCANv1 ESC 12 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC12).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL13">UCAN1_ESC_FAIL13</strong> (INT32)</td>
 <td>UAVCANv1 ESC 13 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC13).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL14">UCAN1_ESC_FAIL14</strong> (INT32)</td>
 <td>UAVCANv1 ESC 14 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC14).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL15">UCAN1_ESC_FAIL15</strong> (INT32)</td>
 <td>UAVCANv1 ESC 15 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC15).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL16">UCAN1_ESC_FAIL16</strong> (INT32)</td>
 <td>UAVCANv1 ESC 16 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC16).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL2">UCAN1_ESC_FAIL2</strong> (INT32)</td>
 <td>UAVCANv1 ESC 2 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC2).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL3">UCAN1_ESC_FAIL3</strong> (INT32)</td>
 <td>UAVCANv1 ESC 3 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC3).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL4">UCAN1_ESC_FAIL4</strong> (INT32)</td>
 <td>UAVCANv1 ESC 4 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC4).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL5">UCAN1_ESC_FAIL5</strong> (INT32)</td>
 <td>UAVCANv1 ESC 5 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC5).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL6">UCAN1_ESC_FAIL6</strong> (INT32)</td>
 <td>UAVCANv1 ESC 6 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC6).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL7">UCAN1_ESC_FAIL7</strong> (INT32)</td>
 <td>UAVCANv1 ESC 7 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC7).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL8">UCAN1_ESC_FAIL8</strong> (INT32)</td>
 <td>UAVCANv1 ESC 8 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC8).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FAIL9">UCAN1_ESC_FAIL9</strong> (INT32)</td>
 <td>UAVCANv1 ESC 9 Failsafe Value <p><strong>Comment:</strong> This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC9).</p>   </td>
 <td>[-1, 8191] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC1">UCAN1_ESC_FUNC1</strong> (INT32)</td>
 <td>UAVCANv1 ESC 1 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC10">UCAN1_ESC_FUNC10</strong> (INT32)</td>
 <td>UAVCANv1 ESC 10 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 10. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC11">UCAN1_ESC_FUNC11</strong> (INT32)</td>
 <td>UAVCANv1 ESC 11 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 11. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC12">UCAN1_ESC_FUNC12</strong> (INT32)</td>
 <td>UAVCANv1 ESC 12 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 12. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC13">UCAN1_ESC_FUNC13</strong> (INT32)</td>
 <td>UAVCANv1 ESC 13 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 13. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC14">UCAN1_ESC_FUNC14</strong> (INT32)</td>
 <td>UAVCANv1 ESC 14 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 14. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC15">UCAN1_ESC_FUNC15</strong> (INT32)</td>
 <td>UAVCANv1 ESC 15 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 15. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC16">UCAN1_ESC_FUNC16</strong> (INT32)</td>
 <td>UAVCANv1 ESC 16 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 16. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC2">UCAN1_ESC_FUNC2</strong> (INT32)</td>
 <td>UAVCANv1 ESC 2 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC3">UCAN1_ESC_FUNC3</strong> (INT32)</td>
 <td>UAVCANv1 ESC 3 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC4">UCAN1_ESC_FUNC4</strong> (INT32)</td>
 <td>UAVCANv1 ESC 4 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC5">UCAN1_ESC_FUNC5</strong> (INT32)</td>
 <td>UAVCANv1 ESC 5 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 5. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC6">UCAN1_ESC_FUNC6</strong> (INT32)</td>
 <td>UAVCANv1 ESC 6 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 6. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC7">UCAN1_ESC_FUNC7</strong> (INT32)</td>
 <td>UAVCANv1 ESC 7 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 7. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC8">UCAN1_ESC_FUNC8</strong> (INT32)</td>
 <td>UAVCANv1 ESC 8 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 8. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_FUNC9">UCAN1_ESC_FUNC9</strong> (INT32)</td>
 <td>UAVCANv1 ESC 9 Output Function <p><strong>Comment:</strong> Select what should be output on UAVCANv1 ESC 9. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX1">UCAN1_ESC_MAX1</strong> (INT32)</td>
 <td>UAVCANv1 ESC 1 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX10">UCAN1_ESC_MAX10</strong> (INT32)</td>
 <td>UAVCANv1 ESC 10 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX11">UCAN1_ESC_MAX11</strong> (INT32)</td>
 <td>UAVCANv1 ESC 11 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX12">UCAN1_ESC_MAX12</strong> (INT32)</td>
 <td>UAVCANv1 ESC 12 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX13">UCAN1_ESC_MAX13</strong> (INT32)</td>
 <td>UAVCANv1 ESC 13 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX14">UCAN1_ESC_MAX14</strong> (INT32)</td>
 <td>UAVCANv1 ESC 14 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX15">UCAN1_ESC_MAX15</strong> (INT32)</td>
 <td>UAVCANv1 ESC 15 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX16">UCAN1_ESC_MAX16</strong> (INT32)</td>
 <td>UAVCANv1 ESC 16 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX2">UCAN1_ESC_MAX2</strong> (INT32)</td>
 <td>UAVCANv1 ESC 2 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX3">UCAN1_ESC_MAX3</strong> (INT32)</td>
 <td>UAVCANv1 ESC 3 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX4">UCAN1_ESC_MAX4</strong> (INT32)</td>
 <td>UAVCANv1 ESC 4 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX5">UCAN1_ESC_MAX5</strong> (INT32)</td>
 <td>UAVCANv1 ESC 5 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX6">UCAN1_ESC_MAX6</strong> (INT32)</td>
 <td>UAVCANv1 ESC 6 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX7">UCAN1_ESC_MAX7</strong> (INT32)</td>
 <td>UAVCANv1 ESC 7 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX8">UCAN1_ESC_MAX8</strong> (INT32)</td>
 <td>UAVCANv1 ESC 8 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MAX9">UCAN1_ESC_MAX9</strong> (INT32)</td>
 <td>UAVCANv1 ESC 9 Maximum Value <p><strong>Comment:</strong> Maxmimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>8191</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN1">UCAN1_ESC_MIN1</strong> (INT32)</td>
 <td>UAVCANv1 ESC 1 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN10">UCAN1_ESC_MIN10</strong> (INT32)</td>
 <td>UAVCANv1 ESC 10 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN11">UCAN1_ESC_MIN11</strong> (INT32)</td>
 <td>UAVCANv1 ESC 11 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN12">UCAN1_ESC_MIN12</strong> (INT32)</td>
 <td>UAVCANv1 ESC 12 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN13">UCAN1_ESC_MIN13</strong> (INT32)</td>
 <td>UAVCANv1 ESC 13 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN14">UCAN1_ESC_MIN14</strong> (INT32)</td>
 <td>UAVCANv1 ESC 14 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN15">UCAN1_ESC_MIN15</strong> (INT32)</td>
 <td>UAVCANv1 ESC 15 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN16">UCAN1_ESC_MIN16</strong> (INT32)</td>
 <td>UAVCANv1 ESC 16 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN2">UCAN1_ESC_MIN2</strong> (INT32)</td>
 <td>UAVCANv1 ESC 2 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN3">UCAN1_ESC_MIN3</strong> (INT32)</td>
 <td>UAVCANv1 ESC 3 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN4">UCAN1_ESC_MIN4</strong> (INT32)</td>
 <td>UAVCANv1 ESC 4 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN5">UCAN1_ESC_MIN5</strong> (INT32)</td>
 <td>UAVCANv1 ESC 5 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN6">UCAN1_ESC_MIN6</strong> (INT32)</td>
 <td>UAVCANv1 ESC 6 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN7">UCAN1_ESC_MIN7</strong> (INT32)</td>
 <td>UAVCANv1 ESC 7 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN8">UCAN1_ESC_MIN8</strong> (INT32)</td>
 <td>UAVCANv1 ESC 8 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_MIN9">UCAN1_ESC_MIN9</strong> (INT32)</td>
 <td>UAVCANv1 ESC 9 Minimum Value <p><strong>Comment:</strong> Minimum output value (when not disarmed).</p>   </td>
 <td>[0, 8191] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_REV">UCAN1_ESC_REV</strong> (INT32)</td>
 <td>Reverse Output Range for UAVCANv1 <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> UAVCANv1 ESC 1</li>
  <li><strong>1:</strong> UAVCANv1 ESC 2</li>
  <li><strong>2:</strong> UAVCANv1 ESC 3</li>
  <li><strong>3:</strong> UAVCANv1 ESC 4</li>
  <li><strong>4:</strong> UAVCANv1 ESC 5</li>
  <li><strong>5:</strong> UAVCANv1 ESC 6</li>
  <li><strong>6:</strong> UAVCANv1 ESC 7</li>
  <li><strong>7:</strong> UAVCANv1 ESC 8</li>
  <li><strong>8:</strong> UAVCANv1 ESC 9</li>
  <li><strong>9:</strong> UAVCANv1 ESC 10</li>
  <li><strong>10:</strong> UAVCANv1 ESC 11</li>
  <li><strong>11:</strong> UAVCANv1 ESC 12</li>
  <li><strong>12:</strong> UAVCANv1 ESC 13</li>
  <li><strong>13:</strong> UAVCANv1 ESC 14</li>
  <li><strong>14:</strong> UAVCANv1 ESC 15</li>
  <li><strong>15:</strong> UAVCANv1 ESC 16</li>
</ul>
 </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL2_IO_FUNC1">VOXL2_IO_FUNC1</strong> (INT32)</td>
 <td>VOXL2 IO Output PWM Channel 1 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL2 IO Output PWM Channel 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL2_IO_FUNC2">VOXL2_IO_FUNC2</strong> (INT32)</td>
 <td>VOXL2 IO Output PWM Channel 2 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL2 IO Output PWM Channel 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL2_IO_FUNC3">VOXL2_IO_FUNC3</strong> (INT32)</td>
 <td>VOXL2 IO Output PWM Channel 3 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL2 IO Output PWM Channel 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL2_IO_FUNC4">VOXL2_IO_FUNC4</strong> (INT32)</td>
 <td>VOXL2 IO Output PWM Channel 4 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL2 IO Output PWM Channel 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL2_IO_REV">VOXL2_IO_REV</strong> (INT32)</td>
 <td>Reverse Output Range for VOXL2 IO Output <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> VOXL2 IO Output PWM Channel 1</li>
  <li><strong>1:</strong> VOXL2 IO Output PWM Channel 2</li>
  <li><strong>2:</strong> VOXL2 IO Output PWM Channel 3</li>
  <li><strong>3:</strong> VOXL2 IO Output PWM Channel 4</li>
</ul>
 </td>
 <td>[0, 15] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL_ESC_FUNC1">VOXL_ESC_FUNC1</strong> (INT32)</td>
 <td>VOXL ESC Output ESC 1 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL ESC Output ESC 1. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL_ESC_FUNC2">VOXL_ESC_FUNC2</strong> (INT32)</td>
 <td>VOXL ESC Output ESC 2 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL ESC Output ESC 2. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL_ESC_FUNC3">VOXL_ESC_FUNC3</strong> (INT32)</td>
 <td>VOXL ESC Output ESC 3 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL ESC Output ESC 3. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL_ESC_FUNC4">VOXL_ESC_FUNC4</strong> (INT32)</td>
 <td>VOXL ESC Output ESC 4 Output Function <p><strong>Comment:</strong> Select what should be output on VOXL ESC Output ESC 4. The default failsafe value is set according to the selected function: - &#x27;Min&#x27; for ConstantMin - &#x27;Max&#x27; for ConstantMax - &#x27;Max&#x27; for Parachute - (&#x27;Max&#x27;+&#x27;Min&#x27;)/2 for Servos - &#x27;Disarmed&#x27; for the rest</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Constant Min</li>
<li><strong>2:</strong> Constant Max</li>
<li><strong>101:</strong> Motor 1</li>
<li><strong>102:</strong> Motor 2</li>
<li><strong>103:</strong> Motor 3</li>
<li><strong>104:</strong> Motor 4</li>
<li><strong>105:</strong> Motor 5</li>
<li><strong>106:</strong> Motor 6</li>
<li><strong>107:</strong> Motor 7</li>
<li><strong>108:</strong> Motor 8</li>
<li><strong>109:</strong> Motor 9</li>
<li><strong>110:</strong> Motor 10</li>
<li><strong>111:</strong> Motor 11</li>
<li><strong>112:</strong> Motor 12</li>
<li><strong>201:</strong> Servo 1</li>
<li><strong>202:</strong> Servo 2</li>
<li><strong>203:</strong> Servo 3</li>
<li><strong>204:</strong> Servo 4</li>
<li><strong>205:</strong> Servo 5</li>
<li><strong>206:</strong> Servo 6</li>
<li><strong>207:</strong> Servo 7</li>
<li><strong>208:</strong> Servo 8</li>
<li><strong>301:</strong> Peripheral via Actuator Set 1</li>
<li><strong>302:</strong> Peripheral via Actuator Set 2</li>
<li><strong>303:</strong> Peripheral via Actuator Set 3</li>
<li><strong>304:</strong> Peripheral via Actuator Set 4</li>
<li><strong>305:</strong> Peripheral via Actuator Set 5</li>
<li><strong>306:</strong> Peripheral via Actuator Set 6</li>
<li><strong>400:</strong> Landing Gear</li>
<li><strong>401:</strong> Parachute</li>
<li><strong>402:</strong> RC Roll</li>
<li><strong>403:</strong> RC Pitch</li>
<li><strong>404:</strong> RC Throttle</li>
<li><strong>405:</strong> RC Yaw</li>
<li><strong>406:</strong> RC Flaps</li>
<li><strong>407:</strong> RC AUX 1</li>
<li><strong>408:</strong> RC AUX 2</li>
<li><strong>409:</strong> RC AUX 3</li>
<li><strong>410:</strong> RC AUX 4</li>
<li><strong>411:</strong> RC AUX 5</li>
<li><strong>412:</strong> RC AUX 6</li>
<li><strong>420:</strong> Gimbal Roll</li>
<li><strong>421:</strong> Gimbal Pitch</li>
<li><strong>422:</strong> Gimbal Yaw</li>
<li><strong>430:</strong> Gripper</li>
<li><strong>440:</strong> Landing Gear Wheel</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="VOXL_ESC_REV">VOXL_ESC_REV</strong> (INT32)</td>
 <td>Reverse Output Range for VOXL ESC Output <p><strong>Comment:</strong> Allows to reverse the output range for each channel. Note: this is only useful for servos.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> VOXL ESC Output ESC 1</li>
  <li><strong>1:</strong> VOXL ESC Output ESC 2</li>
  <li><strong>2:</strong> VOXL ESC Output ESC 3</li>
  <li><strong>3:</strong> VOXL ESC Output ESC 4</li>
</ul>
 </td>
 <td>[0, 15] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Airspeed Validator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ASPD_BETA_GATE">ASPD_BETA_GATE</strong> (INT32)</td>
 <td>Gate size for sideslip angle fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1, 5] </td>
 <td>1</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="ASPD_BETA_NOISE">ASPD_BETA_NOISE</strong> (FLOAT)</td>
 <td>Wind estimator sideslip measurement noise <p><strong>Comment:</strong> Sideslip measurement noise of the internal wind estimator(s) of the airspeed selector.</p>   </td>
 <td>[0, 1] </td>
 <td>0.15</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="ASPD_DO_CHECKS">ASPD_DO_CHECKS</strong> (INT32)</td>
 <td>Enable checks on airspeed sensors <p><strong>Comment:</strong> Controls which checks are run to check airspeed data for validity. Only applied if ASPD_PRIMARY &gt; 0.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Only data missing check (triggers if more than 1s no data)</li>
  <li><strong>1:</strong> Data stuck (triggers if data is exactly constant for 2s in FW mode)</li>
  <li><strong>2:</strong> Innovation check (see ASPD_FS_INNOV)</li>
  <li><strong>3:</strong> Load factor check (triggers if measurement is below stall speed)</li>
  <li><strong>4:</strong> First principle check (airspeed change vs. throttle and pitch)</li>
</ul>
 </td>
 <td>[0, 31] </td>
 <td>7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_FALLBACK_GW">ASPD_FALLBACK_GW</strong> (INT32)</td>
 <td>Enable fallback to sensor-less airspeed estimation <p><strong>Comment:</strong> If set to true and airspeed checks are enabled, it will use a sensor-less airspeed estimation based on groundspeed minus windspeed if no other airspeed sensor available to fall back to.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable fallback to sensor-less estimation</li>
<li><strong>1:</strong> Enable fallback to sensor-less estimation</li>
</ul>  </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_FP_T_WINDOW">ASPD_FP_T_WINDOW</strong> (FLOAT)</td>
 <td>First principle airspeed check time window <p><strong>Comment:</strong> Window for comparing airspeed change to throttle and pitch change. Triggers when the airspeed change within this window is negative while throttle increases and the vehicle pitches down. Is meant to catch degrading airspeed blockages as can happen when flying through icing conditions. Relies on  FW_THR_TRIM being set accurately.</p>   </td>
 <td>[0, ?] </td>
 <td>2.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="ASPD_FS_INNOV">ASPD_FS_INNOV</strong> (FLOAT)</td>
 <td>Airspeed failure innovation threshold <p><strong>Comment:</strong> This specifies the minimum airspeed innovation required to trigger a failsafe. Larger values make the check less sensitive, smaller values make it more sensitive. Large innovations indicate an inconsistency between predicted (groundspeed - windspeeed) and measured airspeed. The time required to detect a fault when the threshold is exceeded depends on the size of the exceedance and is controlled by the ASPD_FS_INTEG parameter.</p>   </td>
 <td>[0.5, 10.0] </td>
 <td>5.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="ASPD_FS_INTEG">ASPD_FS_INTEG</strong> (FLOAT)</td>
 <td>Airspeed failure innovation integral threshold <p><strong>Comment:</strong> This sets the time integral of airspeed innovation exceedance above ASPD_FS_INNOV required to trigger a failsafe. Larger values make the check less sensitive, smaller positive values make it more sensitive.</p>   </td>
 <td>[0.0, 50.0] </td>
 <td>10.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="ASPD_FS_T_START">ASPD_FS_T_START</strong> (FLOAT)</td>
 <td>Airspeed failsafe start delay <p><strong>Comment:</strong> Delay before switching back to using airspeed sensor if checks indicate sensor is good. Set to a negative value to disable the re-enabling in flight.</p>   </td>
 <td>[-1.0, ?] </td>
 <td>-1.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="ASPD_FS_T_STOP">ASPD_FS_T_STOP</strong> (FLOAT)</td>
 <td>Airspeed failsafe stop delay <p><strong>Comment:</strong> Delay before stopping use of airspeed sensor if checks indicate sensor is bad.</p>   </td>
 <td>[0.0, ?] </td>
 <td>1.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="ASPD_PRIMARY">ASPD_PRIMARY</strong> (INT32)</td>
 <td>Index or primary airspeed measurement source  <strong>Values:</strong><ul>
<li><strong>0:</strong> Groundspeed minus windspeed</li>
<li><strong>1:</strong> First airspeed sensor</li>
<li><strong>2:</strong> Second airspeed sensor</li>
<li><strong>3:</strong> Third airspeed sensor</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_SCALE_1">ASPD_SCALE_1</strong> (FLOAT)</td>
 <td>Scale of airspeed sensor 1 <p><strong>Comment:</strong> This is the scale IAS --&gt; CAS of the first airspeed sensor instance</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0.5, 2.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_SCALE_2">ASPD_SCALE_2</strong> (FLOAT)</td>
 <td>Scale of airspeed sensor 2 <p><strong>Comment:</strong> This is the scale IAS --&gt; CAS of the second airspeed sensor instance</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0.5, 2.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_SCALE_3">ASPD_SCALE_3</strong> (FLOAT)</td>
 <td>Scale of airspeed sensor 3 <p><strong>Comment:</strong> This is the scale IAS --&gt; CAS of the third airspeed sensor instance</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0.5, 2.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_SCALE_APPLY">ASPD_SCALE_APPLY</strong> (INT32)</td>
 <td>Controls when to apply the new estimated airspeed scale(s)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Do not automatically apply the estimated scale</li>
<li><strong>1:</strong> Apply the estimated scale after disarm</li>
<li><strong>2:</strong> Apply the estimated scale in air</li>
</ul>  </td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ASPD_SCALE_NSD">ASPD_SCALE_NSD</strong> (FLOAT)</td>
 <td>Wind estimator true airspeed scale process noise spectral density <p><strong>Comment:</strong> Airspeed scale process noise of the internal wind estimator(s) of the airspeed selector. When unaided, the scale uncertainty (1-sigma, unitless) increases by this amount every second.</p>   </td>
 <td>[0, 0.1] </td>
 <td>1.e-4</td>
 <td>1/s/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="ASPD_TAS_GATE">ASPD_TAS_GATE</strong> (INT32)</td>
 <td>Gate size for true airspeed fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1, 5] </td>
 <td>4</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="ASPD_TAS_NOISE">ASPD_TAS_NOISE</strong> (FLOAT)</td>
 <td>Wind estimator true airspeed measurement noise <p><strong>Comment:</strong> True airspeed measurement noise of the internal wind estimator(s) of the airspeed selector.</p>   </td>
 <td>[0, 4] </td>
 <td>1.4</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="ASPD_WERR_THR">ASPD_WERR_THR</strong> (FLOAT)</td>
 <td>Horizontal wind uncertainty threshold for synthetic airspeed <p><strong>Comment:</strong> The synthetic airspeed estimate (from groundspeed and heading) will be declared valid as soon and as long the horizontal wind uncertainty is below this value.</p>   </td>
 <td>[0.001, 5] </td>
 <td>0.55</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="ASPD_WIND_NSD">ASPD_WIND_NSD</strong> (FLOAT)</td>
 <td>Wind estimator wind process noise spectral density <p><strong>Comment:</strong> Wind process noise of the internal wind estimator(s) of the airspeed selector. When unaided, the wind estimate uncertainty (1-sigma, in m/s) increases by this amount every second.</p>   </td>
 <td>[0, 1] </td>
 <td>1.e-1</td>
 <td>m/s^2/sqrt(Hz)</td>
</tr>
</tbody></table>

## Attitude Q estimator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ATT_ACC_COMP">ATT_ACC_COMP</strong> (INT32)</td>
 <td>Acceleration compensation based on GPS velocity    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_BIAS_MAX">ATT_BIAS_MAX</strong> (FLOAT)</td>
 <td>Gyro bias limit    </td>
 <td>[0, 2] </td>
 <td>0.05</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="ATT_EN">ATT_EN</strong> (INT32)</td>
 <td>standalone attitude estimator enable (unsupported) <p><strong>Comment:</strong> Enable standalone quaternion based attitude estimator.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_EXT_HDG_M">ATT_EXT_HDG_M</strong> (INT32)</td>
 <td>External heading usage mode (from Motion capture/Vision) <p><strong>Comment:</strong> Set to 1 to use heading estimate from vision. Set to 2 to use heading from motion capture.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Vision</li>
<li><strong>2:</strong> Motion Capture</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_MAG_DECL">ATT_MAG_DECL</strong> (FLOAT)</td>
 <td>Magnetic declination, in degrees <p><strong>Comment:</strong> This parameter is not used in normal operation, as the declination is looked up based on the GPS coordinates of the vehicle.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="ATT_MAG_DECL_A">ATT_MAG_DECL_A</strong> (INT32)</td>
 <td>Automatic GPS based declination compensation    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_W_ACC">ATT_W_ACC</strong> (FLOAT)</td>
 <td>Complimentary filter accelerometer weight    </td>
 <td>[0, 1] </td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_W_EXT_HDG">ATT_W_EXT_HDG</strong> (FLOAT)</td>
 <td>Complimentary filter external heading weight    </td>
 <td>[0, 1] </td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_W_GYRO_BIAS">ATT_W_GYRO_BIAS</strong> (FLOAT)</td>
 <td>Complimentary filter gyroscope bias weight    </td>
 <td>[0, 1] </td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ATT_W_MAG">ATT_W_MAG</strong> (FLOAT)</td>
 <td>Complimentary filter magnetometer weight <p><strong>Comment:</strong> Set to 0 to avoid using the magnetometer.</p>   </td>
 <td>[0, 1] </td>
 <td>0.1</td>
 <td></td>
</tr>
</tbody></table>

## Autotune

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_AT_APPLY">FW_AT_APPLY</strong> (INT32)</td>
 <td>Controls when to apply the new gains <p><strong>Comment:</strong> After the auto-tuning sequence is completed, a new set of gains is available and can be applied immediately or after landing.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Do not apply the new gains (logging only)</li>
<li><strong>1:</strong> Apply the new gains after disarm</li>
<li><strong>2:</strong> Apply the new gains in air</li>
</ul>  </td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_AT_AXES">FW_AT_AXES</strong> (INT32)</td>
 <td>Tuning axes selection <p><strong>Comment:</strong> Defines which axes will be tuned during the auto-tuning sequence Set bits in the following positions to enable: 0 : Roll 1 : Pitch 2 : Yaw</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> roll</li>
  <li><strong>1:</strong> pitch</li>
  <li><strong>2:</strong> yaw</li>
</ul>
 </td>
 <td>[1, 7] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_AT_MAN_AUX">FW_AT_MAN_AUX</strong> (INT32)</td>
 <td>Enable/disable auto tuning using an RC AUX input <p><strong>Comment:</strong> Defines which RC_MAP_AUXn parameter maps the RC channel used to enable/disable auto tuning.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> Aux1</li>
<li><strong>2:</strong> Aux2</li>
<li><strong>3:</strong> Aux3</li>
<li><strong>4:</strong> Aux4</li>
<li><strong>5:</strong> Aux5</li>
<li><strong>6:</strong> Aux6</li>
</ul>  </td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_AT_START">FW_AT_START</strong> (INT32)</td>
 <td>Start the autotuning sequence <p><strong>Comment:</strong> WARNING: this will inject steps to the rate controller and can be dangerous. Only activate if you know what you are doing, and in a safe environment. Any motion of the remote stick will abort the signal injection and reset this parameter Best is to perform the identification in position or hold mode. Increase the amplitude of the injected signal using FW_AT_SYSID_AMP for more signal/noise ratio</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_AT_SYSID_AMP">FW_AT_SYSID_AMP</strong> (FLOAT)</td>
 <td>Amplitude of the injected signal <p><strong>Comment:</strong> This parameter scales the signal sent to the rate controller during system identification.</p>   </td>
 <td>[0.1, 6.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_AT_SYSID_F0">FW_AT_SYSID_F0</strong> (FLOAT)</td>
 <td>Start frequency of the injected signal <p><strong>Comment:</strong> Can be set lower or higher than the end frequency</p>   </td>
 <td>[0.1, 30.0] </td>
 <td>1.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="FW_AT_SYSID_F1">FW_AT_SYSID_F1</strong> (FLOAT)</td>
 <td>End frequency of the injected signal <p><strong>Comment:</strong> Can be set lower or higher than the start frequency</p>   </td>
 <td>[0.1, 30.0] </td>
 <td>20.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="FW_AT_SYSID_TIME">FW_AT_SYSID_TIME</strong> (FLOAT)</td>
 <td>Maneuver time for each axis <p><strong>Comment:</strong> Duration of the input signal sent on each axis during system identification</p>   </td>
 <td>[5, 120] </td>
 <td>10.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_AT_SYSID_TYPE">FW_AT_SYSID_TYPE</strong> (INT32)</td>
 <td>Input signal type <p><strong>Comment:</strong> Type of signal used during system identification to excite the system.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Step</li>
<li><strong>1:</strong> Linear sine sweep</li>
<li><strong>2:</strong> Logarithmic sine sweep</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_AT_APPLY">MC_AT_APPLY</strong> (INT32)</td>
 <td>Controls when to apply the new gains <p><strong>Comment:</strong> After the auto-tuning sequence is completed, a new set of gains is available and can be applied immediately or after landing. WARNING Applying the gains in air is dangerous as there is no guarantee that those new gains will be able to stabilize the drone properly.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Do not apply the new gains (logging only)</li>
<li><strong>1:</strong> Apply the new gains after disarm</li>
<li><strong>2:</strong> WARNING Apply the new gains in air</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_AT_EN">MC_AT_EN</strong> (INT32)</td>
 <td>Multicopter autotune module enable    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_AT_RISE_TIME">MC_AT_RISE_TIME</strong> (FLOAT)</td>
 <td>Desired angular rate closed-loop rise time    </td>
 <td>[0.01, 0.5] </td>
 <td>0.14</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MC_AT_START">MC_AT_START</strong> (INT32)</td>
 <td>Start the autotuning sequence <p><strong>Comment:</strong> WARNING: this will inject steps to the rate controller and can be dangerous. Only activate if you know what you are doing, and in a safe environment. Any motion of the remote stick will abort the signal injection and reset this parameter Best is to perform the identification in position or hold mode. Increase the amplitude of the injected signal using MC_AT_SYSID_AMP for more signal/noise ratio</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_AT_SYSID_AMP">MC_AT_SYSID_AMP</strong> (FLOAT)</td>
 <td>Amplitude of the injected signal    </td>
 <td>[0.1, 6.0] </td>
 <td>0.7</td>
 <td></td>
</tr>
</tbody></table>

## Battery Calibration

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="BAT1_A_PER_V">BAT1_A_PER_V</strong> (FLOAT)</td>
 <td>Battery 1 current per volt (A/V) <p><strong>Comment:</strong> The voltage seen by the ADC multiplied by this factor will determine the battery current. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_CAPACITY">BAT1_CAPACITY</strong> (FLOAT)</td>
 <td>Battery 1 capacity <p><strong>Comment:</strong> Defines the capacity of battery 1 in mAh.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 100000] (50)</td>
 <td>-1.0</td>
 <td>mAh</td>
</tr>
<tr>
 <td><strong id="BAT1_I_CHANNEL">BAT1_I_CHANNEL</strong> (INT32)</td>
 <td>Battery 1 Current ADC Channel <p><strong>Comment:</strong> This parameter specifies the ADC channel used to monitor current of main power battery. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_N_CELLS">BAT1_N_CELLS</strong> (INT32)</td>
 <td>Number of cells for battery 1 <p><strong>Comment:</strong> Defines the number of cells the attached battery consists of.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unknown</li>
<li><strong>1:</strong> 1S Battery</li>
<li><strong>2:</strong> 2S Battery</li>
<li><strong>3:</strong> 3S Battery</li>
<li><strong>4:</strong> 4S Battery</li>
<li><strong>5:</strong> 5S Battery</li>
<li><strong>6:</strong> 6S Battery</li>
<li><strong>7:</strong> 7S Battery</li>
<li><strong>8:</strong> 8S Battery</li>
<li><strong>9:</strong> 9S Battery</li>
<li><strong>10:</strong> 10S Battery</li>
<li><strong>11:</strong> 11S Battery</li>
<li><strong>12:</strong> 12S Battery</li>
<li><strong>13:</strong> 13S Battery</li>
<li><strong>14:</strong> 14S Battery</li>
<li><strong>15:</strong> 15S Battery</li>
<li><strong>16:</strong> 16S Battery</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_R_INTERNAL">BAT1_R_INTERNAL</strong> (FLOAT)</td>
 <td>Explicitly defines the per cell internal resistance for battery 1 <p><strong>Comment:</strong> If non-negative, then this will be used instead of the online estimated internal resistance.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 0.2] (0.0005)</td>
 <td>-1.0</td>
 <td>Ohm</td>
</tr>
<tr>
 <td><strong id="BAT1_SOURCE">BAT1_SOURCE</strong> (INT32)</td>
 <td>Battery 1 monitoring source <p><strong>Comment:</strong> This parameter controls the source of battery data. The value &#x27;Power Module&#x27; means that measurements are expected to come from a power module. If the value is set to &#x27;External&#x27; then the system expects to receive mavlink battery status messages. If the value is set to &#x27;ESCs&#x27;, the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Disabled</li>
<li><strong>0:</strong> Power Module</li>
<li><strong>1:</strong> External</li>
<li><strong>2:</strong> ESCs</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_V_CHANNEL">BAT1_V_CHANNEL</strong> (INT32)</td>
 <td>Battery 1 Voltage ADC Channel <p><strong>Comment:</strong> This parameter specifies the ADC channel used to monitor voltage of main power battery. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_V_CHARGED">BAT1_V_CHARGED</strong> (FLOAT)</td>
 <td>Full cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>4.05</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT1_V_DIV">BAT1_V_DIV</strong> (FLOAT)</td>
 <td>Battery 1 voltage divider (V divider) <p><strong>Comment:</strong> This is the divider from battery 1 voltage to ADC voltage. If using e.g. Mauch power modules the value from the datasheet can be applied straight here. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_V_EMPTY">BAT1_V_EMPTY</strong> (FLOAT)</td>
 <td>Empty cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>3.6</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT2_A_PER_V">BAT2_A_PER_V</strong> (FLOAT)</td>
 <td>Battery 2 current per volt (A/V) <p><strong>Comment:</strong> The voltage seen by the ADC multiplied by this factor will determine the battery current. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_CAPACITY">BAT2_CAPACITY</strong> (FLOAT)</td>
 <td>Battery 2 capacity <p><strong>Comment:</strong> Defines the capacity of battery 2 in mAh.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 100000] (50)</td>
 <td>-1.0</td>
 <td>mAh</td>
</tr>
<tr>
 <td><strong id="BAT2_I_CHANNEL">BAT2_I_CHANNEL</strong> (INT32)</td>
 <td>Battery 2 Current ADC Channel <p><strong>Comment:</strong> This parameter specifies the ADC channel used to monitor current of main power battery. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_N_CELLS">BAT2_N_CELLS</strong> (INT32)</td>
 <td>Number of cells for battery 2 <p><strong>Comment:</strong> Defines the number of cells the attached battery consists of.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unknown</li>
<li><strong>1:</strong> 1S Battery</li>
<li><strong>2:</strong> 2S Battery</li>
<li><strong>3:</strong> 3S Battery</li>
<li><strong>4:</strong> 4S Battery</li>
<li><strong>5:</strong> 5S Battery</li>
<li><strong>6:</strong> 6S Battery</li>
<li><strong>7:</strong> 7S Battery</li>
<li><strong>8:</strong> 8S Battery</li>
<li><strong>9:</strong> 9S Battery</li>
<li><strong>10:</strong> 10S Battery</li>
<li><strong>11:</strong> 11S Battery</li>
<li><strong>12:</strong> 12S Battery</li>
<li><strong>13:</strong> 13S Battery</li>
<li><strong>14:</strong> 14S Battery</li>
<li><strong>15:</strong> 15S Battery</li>
<li><strong>16:</strong> 16S Battery</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_R_INTERNAL">BAT2_R_INTERNAL</strong> (FLOAT)</td>
 <td>Explicitly defines the per cell internal resistance for battery 2 <p><strong>Comment:</strong> If non-negative, then this will be used instead of the online estimated internal resistance.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 0.2] (0.0005)</td>
 <td>-1.0</td>
 <td>Ohm</td>
</tr>
<tr>
 <td><strong id="BAT2_SOURCE">BAT2_SOURCE</strong> (INT32)</td>
 <td>Battery 2 monitoring source <p><strong>Comment:</strong> This parameter controls the source of battery data. The value &#x27;Power Module&#x27; means that measurements are expected to come from a power module. If the value is set to &#x27;External&#x27; then the system expects to receive mavlink battery status messages. If the value is set to &#x27;ESCs&#x27;, the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Disabled</li>
<li><strong>0:</strong> Power Module</li>
<li><strong>1:</strong> External</li>
<li><strong>2:</strong> ESCs</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_V_CHANNEL">BAT2_V_CHANNEL</strong> (INT32)</td>
 <td>Battery 2 Voltage ADC Channel <p><strong>Comment:</strong> This parameter specifies the ADC channel used to monitor voltage of main power battery. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_V_CHARGED">BAT2_V_CHARGED</strong> (FLOAT)</td>
 <td>Full cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>4.05</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT2_V_DIV">BAT2_V_DIV</strong> (FLOAT)</td>
 <td>Battery 2 voltage divider (V divider) <p><strong>Comment:</strong> This is the divider from battery 2 voltage to ADC voltage. If using e.g. Mauch power modules the value from the datasheet can be applied straight here. A value of -1 means to use the board default.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT2_V_EMPTY">BAT2_V_EMPTY</strong> (FLOAT)</td>
 <td>Empty cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>3.6</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT3_CAPACITY">BAT3_CAPACITY</strong> (FLOAT)</td>
 <td>Battery 3 capacity <p><strong>Comment:</strong> Defines the capacity of battery 3 in mAh.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 100000] (50)</td>
 <td>-1.0</td>
 <td>mAh</td>
</tr>
<tr>
 <td><strong id="BAT3_N_CELLS">BAT3_N_CELLS</strong> (INT32)</td>
 <td>Number of cells for battery 3 <p><strong>Comment:</strong> Defines the number of cells the attached battery consists of.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unknown</li>
<li><strong>1:</strong> 1S Battery</li>
<li><strong>2:</strong> 2S Battery</li>
<li><strong>3:</strong> 3S Battery</li>
<li><strong>4:</strong> 4S Battery</li>
<li><strong>5:</strong> 5S Battery</li>
<li><strong>6:</strong> 6S Battery</li>
<li><strong>7:</strong> 7S Battery</li>
<li><strong>8:</strong> 8S Battery</li>
<li><strong>9:</strong> 9S Battery</li>
<li><strong>10:</strong> 10S Battery</li>
<li><strong>11:</strong> 11S Battery</li>
<li><strong>12:</strong> 12S Battery</li>
<li><strong>13:</strong> 13S Battery</li>
<li><strong>14:</strong> 14S Battery</li>
<li><strong>15:</strong> 15S Battery</li>
<li><strong>16:</strong> 16S Battery</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT3_R_INTERNAL">BAT3_R_INTERNAL</strong> (FLOAT)</td>
 <td>Explicitly defines the per cell internal resistance for battery 3 <p><strong>Comment:</strong> If non-negative, then this will be used instead of the online estimated internal resistance.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[-1.0, 0.2] (0.0005)</td>
 <td>-1.0</td>
 <td>Ohm</td>
</tr>
<tr>
 <td><strong id="BAT3_SOURCE">BAT3_SOURCE</strong> (INT32)</td>
 <td>Battery 3 monitoring source <p><strong>Comment:</strong> This parameter controls the source of battery data. The value &#x27;Power Module&#x27; means that measurements are expected to come from a power module. If the value is set to &#x27;External&#x27; then the system expects to receive mavlink battery status messages. If the value is set to &#x27;ESCs&#x27;, the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.</p> <strong>Values:</strong><ul>
<li><strong>-1:</strong> Disabled</li>
<li><strong>0:</strong> Power Module</li>
<li><strong>1:</strong> External</li>
<li><strong>2:</strong> ESCs</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT3_V_CHARGED">BAT3_V_CHARGED</strong> (FLOAT)</td>
 <td>Full cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>4.05</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT3_V_EMPTY">BAT3_V_EMPTY</strong> (FLOAT)</td>
 <td>Empty cell voltage <p><strong>Comment:</strong> Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>(0.01)</td>
 <td>3.6</td>
 <td>V</td>
</tr>
<tr>
 <td><strong id="BAT_ADC_CHANNEL">BAT_ADC_CHANNEL</strong> (INT32)</td>
 <td>This parameter is deprecated. Please use BAT1_I_CHANNEL    </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT_AVRG_CURRENT">BAT_AVRG_CURRENT</strong> (FLOAT)</td>
 <td>Expected battery current in flight <p><strong>Comment:</strong> This value is used to initialize the in-flight average current estimation, which in turn is used for estimating remaining flight time and RTL triggering.</p>   </td>
 <td>[0, 500] (0.1)</td>
 <td>15</td>
 <td>A</td>
</tr>
<tr>
 <td><strong id="BAT_CRIT_THR">BAT_CRIT_THR</strong> (FLOAT)</td>
 <td>Critical threshold <p><strong>Comment:</strong> Sets the threshold when the battery will be reported as critically low. This has to be lower than the low threshold. This threshold commonly will trigger RTL.</p>   </td>
 <td>[0.05, 0.5] (0.01)</td>
 <td>0.07</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="BAT_EMERGEN_THR">BAT_EMERGEN_THR</strong> (FLOAT)</td>
 <td>Emergency threshold <p><strong>Comment:</strong> Sets the threshold when the battery will be reported as dangerously low. This has to be lower than the critical threshold. This threshold commonly will trigger landing.</p>   </td>
 <td>[0.03, 0.5] (0.01)</td>
 <td>0.05</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="BAT_LOW_THR">BAT_LOW_THR</strong> (FLOAT)</td>
 <td>Low threshold <p><strong>Comment:</strong> Sets the threshold when the battery will be reported as low. This has to be higher than the critical threshold.</p>   </td>
 <td>[0.12, 0.5] (0.01)</td>
 <td>0.15</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="BAT_V_OFFS_CURR">BAT_V_OFFS_CURR</strong> (FLOAT)</td>
 <td>Offset in volt as seen by the ADC input of the current sensor <p><strong>Comment:</strong> This offset will be subtracted before calculating the battery current based on the voltage.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
</tbody></table>

## CDCACM

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="SYS_USB_AUTO">SYS_USB_AUTO</strong> (INT32)</td>
 <td>Enable USB autostart  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Auto-detect</li>
<li><strong>2:</strong> MAVLink</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="USB_MAV_MODE">USB_MAV_MODE</strong> (INT32)</td>
 <td>Specify USB MAVLink mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> normal</li>
<li><strong>1:</strong> custom</li>
<li><strong>2:</strong> onboard</li>
<li><strong>3:</strong> osd</li>
<li><strong>4:</strong> magic</li>
<li><strong>5:</strong> config</li>
<li><strong>6:</strong> iridium</li>
<li><strong>7:</strong> minimal</li>
<li><strong>8:</strong> extvision</li>
<li><strong>9:</strong> extvisionmin</li>
<li><strong>10:</strong> gimbal</li>
<li><strong>11:</strong> onboard_low_bandwidth</li>
<li><strong>12:</strong> uavionix</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
</tbody></table>

## Camera Capture

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CAM_CAP_DELAY">CAM_CAP_DELAY</strong> (FLOAT)</td>
 <td>Camera strobe delay <p><strong>Comment:</strong> This parameter sets the delay between image integration start and strobe firing</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td>ms</td>
</tr>
</tbody></table>

## Camera Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CAM_CAP_EDGE">CAM_CAP_EDGE</strong> (INT32)</td>
 <td>Camera capture edge  <strong>Values:</strong><ul>
<li><strong>0:</strong> Falling edge</li>
<li><strong>1:</strong> Rising edge</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAM_CAP_FBACK">CAM_CAP_FBACK</strong> (INT32)</td>
 <td>Camera capture feedback <p><strong>Comment:</strong> Enables camera capture feedback</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAM_CAP_MODE">CAM_CAP_MODE</strong> (INT32)</td>
 <td>Camera capture timestamping mode <p><strong>Comment:</strong> Change time measurement</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Get absolute timestamp</li>
<li><strong>1:</strong> Get timestamp of mid exposure (active high)</li>
<li><strong>2:</strong> Get timestamp of mid exposure (active low)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Camera trigger

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="TRIG_ACT_TIME">TRIG_ACT_TIME</strong> (FLOAT)</td>
 <td>Camera trigger activation time <p><strong>Comment:</strong> This parameter sets the time the trigger needs to pulled high or low.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0.1, 3000] </td>
 <td>40.0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="TRIG_DISTANCE">TRIG_DISTANCE</strong> (FLOAT)</td>
 <td>Camera trigger distance <p><strong>Comment:</strong> Sets the distance at which to trigger the camera.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, ?] (1)</td>
 <td>25.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="TRIG_INTERFACE">TRIG_INTERFACE</strong> (INT32)</td>
 <td>Camera trigger Interface <p><strong>Comment:</strong> Selects the trigger interface</p> <strong>값:</strong><ul>
<li><strong>1:</strong> GPIO</li>
<li><strong>2:</strong> Seagull MAP2 (over PWM)</li>
<li><strong>3:</strong> MAVLink (forward via MAV_CMD_IMAGE_START_CAPTURE)</li>
<li><strong>4:</strong> Generic PWM (IR trigger, servo)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIG_INTERVAL">TRIG_INTERVAL</strong> (FLOAT)</td>
 <td>Camera trigger interval <p><strong>Comment:</strong> This parameter sets the time between two consecutive trigger events</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[4.0, 10000.0] </td>
 <td>40.0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="TRIG_MIN_INTERVA">TRIG_MIN_INTERVA</strong> (FLOAT)</td>
 <td>Minimum camera trigger interval <p><strong>Comment:</strong> This parameter sets the minimum time between two consecutive trigger events the specific camera setup is supporting.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[1.0, 10000.0] </td>
 <td>1.0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="TRIG_MODE">TRIG_MODE</strong> (INT32)</td>
 <td>Camera trigger mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> Time based, on command</li>
<li><strong>2:</strong> Time based, always on</li>
<li><strong>3:</strong> Distance based, always on</li>
<li><strong>4:</strong> Distance based, on command (Survey mode)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 4] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIG_POLARITY">TRIG_POLARITY</strong> (INT32)</td>
 <td>Camera trigger polarity <p><strong>Comment:</strong> This parameter sets the polarity of the trigger (0 = active low, 1 = active high )</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Active low</li>
<li><strong>1:</strong> Active high</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIG_PWM_NEUTRAL">TRIG_PWM_NEUTRAL</strong> (INT32)</td>
 <td>PWM neutral output on trigger pin    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1000, 2000] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="TRIG_PWM_SHOOT">TRIG_PWM_SHOOT</strong> (INT32)</td>
 <td>PWM output to trigger shot    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1000, 2000] </td>
 <td>1900</td>
 <td>us</td>
</tr>
</tbody></table>

## Circuit Breaker

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CBRK_BUZZER">CBRK_BUZZER</strong> (INT32)</td>
 <td>Circuit breaker for disabling buzzer <p><strong>Comment:</strong> Setting this parameter to 782097 will disable the buzzer audio notification. Setting this parameter to 782090 will disable the startup tune, while keeping all others enabled.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 782097] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CBRK_FLIGHTTERM">CBRK_FLIGHTTERM</strong> (INT32)</td>
 <td>Circuit breaker for flight termination <p><strong>Comment:</strong> Setting this parameter to 121212 will disable the flight termination action if triggered by the FailureDetector logic or if FMU is lost. This circuit breaker does not affect the RC loss, data link loss, geofence, and takeoff failure detection safety logic.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 121212] </td>
 <td>121212</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CBRK_IO_SAFETY">CBRK_IO_SAFETY</strong> (INT32)</td>
 <td>Circuit breaker for IO safety <p><strong>Comment:</strong> Setting this parameter to 22027 will disable IO safety. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK</p>   </td>
 <td>[0, 22027] </td>
 <td>22027</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CBRK_SUPPLY_CHK">CBRK_SUPPLY_CHK</strong> (INT32)</td>
 <td>Circuit breaker for power supply check <p><strong>Comment:</strong> Setting this parameter to 894281 will disable the power valid checks in the commander. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK</p>   </td>
 <td>[0, 894281] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CBRK_USB_CHK">CBRK_USB_CHK</strong> (INT32)</td>
 <td>Circuit breaker for USB link check <p><strong>Comment:</strong> Setting this parameter to 197848 will disable the USB connected checks in the commander, setting it to 0 keeps them enabled (recommended). We are generally recommending to not fly with the USB link connected and production vehicles should set this parameter to zero to prevent users from flying USB powered. However, for R&amp;D purposes it has proven over the years to work just fine.</p>   </td>
 <td>[0, 197848] </td>
 <td>197848</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CBRK_VTOLARMING">CBRK_VTOLARMING</strong> (INT32)</td>
 <td>Circuit breaker for arming in fixed-wing mode check <p><strong>Comment:</strong> Setting this parameter to 159753 will enable arming in fixed-wing mode for VTOLs. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK</p>   </td>
 <td>[0, 159753] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Commander

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="COM_ACT_FAIL_ACT">COM_ACT_FAIL_ACT</strong> (INT32)</td>
 <td>Set the actuator failure failsafe mode <p><strong>Comment:</strong> Note: actuator failure needs to be enabled and configured via FD_ACT_* parameters.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Warning only</li>
<li><strong>1:</strong> Hold mode</li>
<li><strong>2:</strong> Land mode</li>
<li><strong>3:</strong> Return mode</li>
<li><strong>4:</strong> Terminate</li>
</ul>  </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARMABLE">COM_ARMABLE</strong> (INT32)</td>
 <td>Flag to allow arming <p><strong>Comment:</strong> Set 0 to prevent accidental use of the vehicle e.g. for safety or maintenance reasons.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disallow arming</li>
<li><strong>1:</strong> Allow arming</li>
</ul>  </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_AUTH_ID">COM_ARM_AUTH_ID</strong> (INT32)</td>
 <td>Arm authorizer system id <p><strong>Comment:</strong> Used if arm authorization is requested by COM_ARM_AUTH_REQ.</p>   </td>
 <td></td>
 <td>10</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_AUTH_MET">COM_ARM_AUTH_MET</strong> (INT32)</td>
 <td>Arm authorization method <p><strong>Comment:</strong> Methods: - one arm: request authorization and arm when authorization is received - two step arm: 1st arm command request an authorization and 2nd arm command arm the drone if authorized Used if arm authorization is requested by COM_ARM_AUTH_REQ.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> one arm</li>
<li><strong>1:</strong> two step arm</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_AUTH_REQ">COM_ARM_AUTH_REQ</strong> (INT32)</td>
 <td>Require arm authorization to arm <p><strong>Comment:</strong> By default off. The default allows to arm the vehicle without a arm authorization.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_AUTH_TO">COM_ARM_AUTH_TO</strong> (FLOAT)</td>
 <td>Arm authorization timeout <p><strong>Comment:</strong> Timeout for authorizer answer. Used if arm authorization is requested by COM_ARM_AUTH_REQ.</p>   </td>
 <td>(0.1)</td>
 <td>1</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_ARM_BAT_MIN">COM_ARM_BAT_MIN</strong> (FLOAT)</td>
 <td>Minimum battery level for arming <p><strong>Comment:</strong> Additional battery level check that only allows arming if the state of charge of the emptiest connected battery is above this value. A value of 0 disables the check.</p>   </td>
 <td>[0, 0.9] (0.01)</td>
 <td>0.</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="COM_ARM_CHK_ESCS">COM_ARM_CHK_ESCS</strong> (INT32)</td>
 <td>Enable checks on ESCs that report telemetry <p><strong>Comment:</strong> If this parameter is set, the system will check ESC&#x27;s online status and failures. This param is specific for ESCs reporting status. It shall be used only if ESCs support telemetry.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_HFLT_CHK">COM_ARM_HFLT_CHK</strong> (INT32)</td>
 <td>Enable FMU SD card hardfault detection check <p><strong>Comment:</strong> This check detects if there are hardfault files present on the SD card. If so, and the parameter is enabled, arming is prevented.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_IMU_ACC">COM_ARM_IMU_ACC</strong> (FLOAT)</td>
 <td>Maximum accelerometer inconsistency between IMU units that will allow arming    </td>
 <td>[0.1, 1.0] (0.05)</td>
 <td>0.7</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="COM_ARM_IMU_GYR">COM_ARM_IMU_GYR</strong> (FLOAT)</td>
 <td>Maximum rate gyro inconsistency between IMU units that will allow arming    </td>
 <td>[0.02, 0.3] (0.01)</td>
 <td>0.25</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="COM_ARM_MAG_ANG">COM_ARM_MAG_ANG</strong> (INT32)</td>
 <td>Maximum magnetic field inconsistency between units that will allow arming <p><strong>Comment:</strong> Set -1 to disable the check.</p>   </td>
 <td>[3, 180] </td>
 <td>60</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="COM_ARM_MAG_STR">COM_ARM_MAG_STR</strong> (INT32)</td>
 <td>Enable mag strength preflight check <p><strong>Comment:</strong> Check if the estimator detects a strong magnetic disturbance (check enabled by EKF2_MAG_CHECK)</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Deny arming</li>
<li><strong>2:</strong> Warning only</li>
</ul>  </td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_MIS_REQ">COM_ARM_MIS_REQ</strong> (INT32)</td>
 <td>Require valid mission to arm <p><strong>Comment:</strong> The default allows to arm the vehicle without a valid mission.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_ODID">COM_ARM_ODID</strong> (INT32)</td>
 <td>Enable Drone ID system detection and health check <p><strong>Comment:</strong> This check detects if the Open Drone ID system is missing. Depending on the value of the parameter, the check can be disabled, warn only or deny arming.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Warning only</li>
<li><strong>2:</strong> Enforce Open Drone ID system presence</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_SDCARD">COM_ARM_SDCARD</strong> (INT32)</td>
 <td>Enable FMU SD card detection check <p><strong>Comment:</strong> This check detects if the FMU SD card is missing. Depending on the value of the parameter, the check can be disabled, warn only or deny arming.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Warning only</li>
<li><strong>2:</strong> Enforce SD card presence</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_SWISBTN">COM_ARM_SWISBTN</strong> (INT32)</td>
 <td>Arm switch is a momentary button <p><strong>Comment:</strong> 0: Arming/disarming triggers on switch transition. 1: Arming/disarming triggers when holding the momentary button down for COM_RC_ARM_HYST like the stick gesture.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_ARM_WO_GPS">COM_ARM_WO_GPS</strong> (INT32)</td>
 <td>Allow arming without GPS  <strong>Values:</strong><ul>
<li><strong>0:</strong> Require GPS lock to arm</li>
<li><strong>1:</strong> Allow arming without GPS</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_CPU_MAX">COM_CPU_MAX</strong> (FLOAT)</td>
 <td>Maximum allowed CPU load to still arm <p><strong>Comment:</strong> The check fails if the CPU load is above this threshold for 2s. A negative value disables the check.</p>   </td>
 <td>[-1, 100] (1)</td>
 <td>95.0</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="COM_DISARM_LAND">COM_DISARM_LAND</strong> (FLOAT)</td>
 <td>Time-out for auto disarm after landing <p><strong>Comment:</strong> A non-zero, positive value specifies the time-out period in seconds after which the vehicle will be automatically disarmed in case a landing situation has been detected during this period. A zero or negative value means that automatic disarming triggered by landing detection is disabled.</p>   </td>
 <td>(0.1)</td>
 <td>2.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_DISARM_MAN">COM_DISARM_MAN</strong> (INT32)</td>
 <td>Allow disarming via switch/stick/button on multicopters in manual thrust modes <p><strong>Comment:</strong> 0: Disallow disarming when not landed 1: Allow disarming in multicopter flight in modes where the thrust is directly controlled by thr throttle stick e.g. Stabilized, Acro</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_DISARM_PRFLT">COM_DISARM_PRFLT</strong> (FLOAT)</td>
 <td>Time-out for auto disarm if not taking off <p><strong>Comment:</strong> A non-zero, positive value specifies the time in seconds, within which the vehicle is expected to take off after arming. In case the vehicle didn&#x27;t takeoff within the timeout it disarms again. A negative value disables autmoatic disarming triggered by a pre-takeoff timeout.</p>   </td>
 <td>(0.1)</td>
 <td>10.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_DL_LOSS_T">COM_DL_LOSS_T</strong> (INT32)</td>
 <td>GCS connection loss time threshold <p><strong>Comment:</strong> After this amount of seconds without datalink, the GCS connection lost mode triggers</p>   </td>
 <td>[5, 300] (1)</td>
 <td>10</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_FAIL_ACT_T">COM_FAIL_ACT_T</strong> (FLOAT)</td>
 <td>Delay between failsafe condition triggered and failsafe reaction <p><strong>Comment:</strong> Before entering failsafe (RTL, Land, Hold), wait COM_FAIL_ACT_T seconds in Hold mode for the user to realize. During that time the user cannot take over control via the stick override feature (see COM_RC_OVERRIDE). Afterwards the configured failsafe action is triggered and the user may use stick override. A zero value disables the delay and the user cannot take over via stick movements (switching modes is still allowed).</p>   </td>
 <td>[0.0, 25.0] </td>
 <td>5.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_FLIGHT_UUID">COM_FLIGHT_UUID</strong> (INT32)</td>
 <td>Next flight UUID <p><strong>Comment:</strong> This number is incremented automatically after every flight on disarming in order to remember the next flight UUID. The first flight is 0.</p>   </td>
 <td>[0, ?] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE1">COM_FLTMODE1</strong> (INT32)</td>
 <td>Mode slot 1 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE2">COM_FLTMODE2</strong> (INT32)</td>
 <td>Mode slot 2 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE3">COM_FLTMODE3</strong> (INT32)</td>
 <td>Mode slot 3 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE4">COM_FLTMODE4</strong> (INT32)</td>
 <td>Mode slot 4 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE5">COM_FLTMODE5</strong> (INT32)</td>
 <td>Mode slot 5 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>Values:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTMODE6">COM_FLTMODE6</strong> (INT32)</td>
 <td>Mode slot 6 <p><strong>Comment:</strong> If the main switch channel is in this range the selected flight mode will be applied.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Unassigned</li>
<li><strong>0:</strong> Manual</li>
<li><strong>1:</strong> Altitude</li>
<li><strong>2:</strong> Position</li>
<li><strong>3:</strong> Mission</li>
<li><strong>4:</strong> Hold</li>
<li><strong>5:</strong> Return</li>
<li><strong>6:</strong> Acro</li>
<li><strong>7:</strong> Offboard</li>
<li><strong>8:</strong> Stabilized</li>
<li><strong>9:</strong> Position Slow</li>
<li><strong>10:</strong> Takeoff</li>
<li><strong>11:</strong> Land</li>
<li><strong>12:</strong> Follow Me</li>
<li><strong>13:</strong> Precision Land</li>
<li><strong>100:</strong> External Mode 1</li>
<li><strong>101:</strong> External Mode 2</li>
<li><strong>102:</strong> External Mode 3</li>
<li><strong>103:</strong> External Mode 4</li>
<li><strong>104:</strong> External Mode 5</li>
<li><strong>105:</strong> External Mode 6</li>
<li><strong>106:</strong> External Mode 7</li>
<li><strong>107:</strong> External Mode 8</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLTT_LOW_ACT">COM_FLTT_LOW_ACT</strong> (INT32)</td>
 <td>Remaining flight time low failsafe <p><strong>Comment:</strong> Action the system takes when the remaining flight time is below the estimated time it takes to reach the RTL destination.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Warning</li>
<li><strong>3:</strong> Return</li>
</ul>  </td>
 <td>(1)</td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLT_PROFILE">COM_FLT_PROFILE</strong> (INT32)</td>
 <td>User Flight Profile <p><strong>Comment:</strong> Describes the intended use of the vehicle. Can be used by ground control software or log post processing. This param does not influence the behavior within the firmware. This means for example the control logic is independent of the setting of this param (but depends on other params).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Default</li>
<li><strong>100:</strong> Pro User</li>
<li><strong>200:</strong> Flight Tester</li>
<li><strong>300:</strong> Developer</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_FLT_TIME_MAX">COM_FLT_TIME_MAX</strong> (INT32)</td>
 <td>Maximum allowed flight time <p><strong>Comment:</strong> The vehicle aborts the current operation and returns to launch when the time since takeoff is above this value. It is not possible to resume the mission or switch to any auto mode other than RTL or Land. Taking over in any manual mode is still possible. Starting from 90% of the maximum flight time, a warning message will be sent every 1 minute with the remaining time until automatic RTL. Set to -1 to disable.</p>   </td>
 <td>[-1, ?] </td>
 <td>-1</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_FORCE_SAFETY">COM_FORCE_SAFETY</strong> (INT32)</td>
 <td>Enable force safety <p><strong>Comment:</strong> Force safety when the vehicle disarms</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_HLDL_LOSS_T">COM_HLDL_LOSS_T</strong> (INT32)</td>
 <td>High Latency Datalink loss time threshold <p><strong>Comment:</strong> After this amount of seconds without datalink the data link lost mode triggers</p>   </td>
 <td>[60, 3600] </td>
 <td>120</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_HLDL_REG_T">COM_HLDL_REG_T</strong> (INT32)</td>
 <td>High Latency Datalink regain time threshold <p><strong>Comment:</strong> After a data link loss: after this number of seconds with a healthy datalink the &#x27;datalink loss&#x27; flag is set back to false</p>   </td>
 <td>[0, 60] </td>
 <td>0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_HOME_EN">COM_HOME_EN</strong> (INT32)</td>
 <td>Home position enabled <p><strong>Comment:</strong> Set home position automatically if possible.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_HOME_IN_AIR">COM_HOME_IN_AIR</strong> (INT32)</td>
 <td>Allows setting the home position after takeoff <p><strong>Comment:</strong> If set to true, the autopilot is allowed to set its home position after takeoff The true home position is back-computed if a local position is estimate if available. If no local position is available, home is set to the current position.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_IMB_PROP_ACT">COM_IMB_PROP_ACT</strong> (INT32)</td>
 <td>Imbalanced propeller failsafe mode <p><strong>Comment:</strong> Action the system takes when an imbalanced propeller is detected by the failure detector. See also FD_IMB_PROP_THR to set the failure threshold.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Disabled</li>
<li><strong>0:</strong> Warning</li>
<li><strong>1:</strong> Return</li>
<li><strong>2:</strong> Land</li>
</ul>  </td>
 <td>(1)</td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_KILL_DISARM">COM_KILL_DISARM</strong> (FLOAT)</td>
 <td>Timeout value for disarming when kill switch is engaged    </td>
 <td>[0.0, 30.0] (0.1)</td>
 <td>5.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_LKDOWN_TKO">COM_LKDOWN_TKO</strong> (FLOAT)</td>
 <td>Timeout for detecting a failure after takeoff <p><strong>Comment:</strong> A non-zero, positive value specifies the timeframe in seconds within failure detector is allowed to disarm the vehicle if attitude exceeds the limits defined in FD_FAIL_P and FD_FAIL_R. The check is not executed for flight modes that do support acrobatic maneuvers, e.g: Acro (MC/FW) and Manual (FW). A zero or negative value means that the check is disabled.</p>   </td>
 <td>[-1.0, 5.0] </td>
 <td>3.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_LOW_BAT_ACT">COM_LOW_BAT_ACT</strong> (INT32)</td>
 <td>Battery failsafe mode <p><strong>Comment:</strong> Action the system takes at critical battery. See also BAT_CRIT_THR and BAT_EMERGEN_THR for definition of battery states.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Warning</li>
<li><strong>2:</strong> Land mode</li>
<li><strong>3:</strong> Return at critical level, land at emergency level</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE0_HASH">COM_MODE0_HASH</strong> (INT32)</td>
 <td>External mode identifier 0 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE1_HASH">COM_MODE1_HASH</strong> (INT32)</td>
 <td>External mode identifier 1 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE2_HASH">COM_MODE2_HASH</strong> (INT32)</td>
 <td>External mode identifier 2 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE3_HASH">COM_MODE3_HASH</strong> (INT32)</td>
 <td>External mode identifier 3 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE4_HASH">COM_MODE4_HASH</strong> (INT32)</td>
 <td>External mode identifier 4 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE5_HASH">COM_MODE5_HASH</strong> (INT32)</td>
 <td>External mode identifier 5 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE6_HASH">COM_MODE6_HASH</strong> (INT32)</td>
 <td>External mode identifier 6 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MODE7_HASH">COM_MODE7_HASH</strong> (INT32)</td>
 <td>External mode identifier 7 <p><strong>Comment:</strong> This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_MOT_TEST_EN">COM_MOT_TEST_EN</strong> (INT32)</td>
 <td>Enable Actuator Testing <p><strong>Comment:</strong> If set, enables the actuator test interface via MAVLink (ACTUATOR_TEST), that allows spinning the motors and moving the servos for testing purposes.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_OBC_LOSS_T">COM_OBC_LOSS_T</strong> (FLOAT)</td>
 <td>Time-out to wait when onboard computer connection is lost before warning about loss connection    </td>
 <td>[0, 60] (0.01)</td>
 <td>5.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_OBL_RC_ACT">COM_OBL_RC_ACT</strong> (INT32)</td>
 <td>Set offboard loss failsafe mode <p><strong>Comment:</strong> The offboard loss failsafe will only be entered after a timeout, set by COM_OF_LOSS_T in seconds.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Position mode</li>
<li><strong>1:</strong> Altitude mode</li>
<li><strong>2:</strong> Manual</li>
<li><strong>3:</strong> Return mode</li>
<li><strong>4:</strong> Land mode</li>
<li><strong>5:</strong> Hold mode</li>
<li><strong>6:</strong> Terminate</li>
<li><strong>7:</strong> Disarm</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_OBS_AVOID">COM_OBS_AVOID</strong> (INT32)</td>
 <td>Flag to enable obstacle avoidance    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_OF_LOSS_T">COM_OF_LOSS_T</strong> (FLOAT)</td>
 <td>Time-out to wait when offboard connection is lost before triggering offboard lost action <p><strong>Comment:</strong> See COM_OBL_RC_ACT to configure action.</p>   </td>
 <td>[0, 60] (0.01)</td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_PARACHUTE">COM_PARACHUTE</strong> (INT32)</td>
 <td>Expect and require a healthy MAVLink parachute system    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_POSCTL_NAVL">COM_POSCTL_NAVL</strong> (INT32)</td>
 <td>Position control navigation loss response <p><strong>Comment:</strong> This sets the flight mode that will be used if navigation accuracy is no longer adequate for position control. If Altitude/Manual is selected: assume use of remote control after fallback. Switch to Altitude mode if a height estimate is available, else switch to MANUAL. If Land/Descend is selected: assume no use of remote control after fallback. Switch to Land mode if a height estimate is available, else switch to Descend.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Altitude/Manual</li>
<li><strong>1:</strong> Land/Descend</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_POS_FS_DELAY">COM_POS_FS_DELAY</strong> (INT32)</td>
 <td>Loss of position failsafe activation delay <p><strong>Comment:</strong> This sets number of seconds that the position checks need to be failed before the failsafe will activate. The default value has been optimised for rotary wing applications. For fixed wing applications, a larger value between 5 and 10 should be used.</p>   </td>
 <td>[1, 100] </td>
 <td>1</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_POS_FS_EPH">COM_POS_FS_EPH</strong> (FLOAT)</td>
 <td>Horizontal position error threshold <p><strong>Comment:</strong> This is the horizontal position error (EPH) threshold that will trigger a failsafe. The default is appropriate for a multicopter. Can be increased for a fixed-wing. If the previous position error was below this threshold, there is an additional factor of 2.5 applied (threshold for invalidation 2.5 times the one for validation). Set to -1 to disable.</p>   </td>
 <td>[-1, 400] </td>
 <td>5.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="COM_POS_LOW_EPH">COM_POS_LOW_EPH</strong> (FLOAT)</td>
 <td>EPH threshold for RTL <p><strong>Comment:</strong> Specify the threshold for triggering a warning for low local position accuracy. Additionally triggers a RTL if currently in Mission or Loiter mode. Local position has to be still declared valid, which is most of all depending on COM_POS_FS_EPH. Use this feature on systems with dead-reckoning capabilites (e.g. fixed-wing vehicles with airspeed sensor) to improve the user notification and failure mitigation when flying in GNSS-denied areas. Set to -1 to disable.</p>   </td>
 <td>[-1, 1000] </td>
 <td>-1.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="COM_POWER_COUNT">COM_POWER_COUNT</strong> (INT32)</td>
 <td>Required number of redundant power modules <p><strong>Comment:</strong> This configures a check to verify the expected number of 5V rail power supplies are present. By default only one is expected. Note: CBRK_SUPPLY_CHK disables all power checks including this one.</p>   </td>
 <td>[0, 4] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_PREARM_MODE">COM_PREARM_MODE</strong> (INT32)</td>
 <td>Condition to enter prearmed mode <p><strong>Comment:</strong> Condition to enter the prearmed state, an intermediate state between disarmed and armed in which non-throttling actuators are active.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Safety button</li>
<li><strong>2:</strong> Always</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_QC_ACT">COM_QC_ACT</strong> (INT32)</td>
 <td>Set command after a quadchute  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Warning only</li>
<li><strong>0:</strong> Return mode</li>
<li><strong>1:</strong> Land mode</li>
<li><strong>2:</strong> Hold mode</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_RAM_MAX">COM_RAM_MAX</strong> (FLOAT)</td>
 <td>Maximum allowed RAM usage to pass checks <p><strong>Comment:</strong> The check fails if the RAM usage is above this threshold. A negative value disables the check.</p>   </td>
 <td>[-1, 100] (1)</td>
 <td>95.0</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="COM_RCL_EXCEPT">COM_RCL_EXCEPT</strong> (INT32)</td>
 <td>RC loss exceptions <p><strong>Comment:</strong> Specify modes in which RC loss is ignored and the failsafe action not triggered.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Mission</li>
  <li><strong>1:</strong> Hold</li>
  <li><strong>2:</strong> Offboard</li>
</ul>
 </td>
 <td>[0, 31] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_RC_ARM_HYST">COM_RC_ARM_HYST</strong> (INT32)</td>
 <td>RC input arm/disarm command duration <p><strong>Comment:</strong> The default value of 1000 requires the stick to be held in the arm or disarm position for 1 second.</p>   </td>
 <td>[100, 1500] </td>
 <td>1000</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="COM_RC_IN_MODE">COM_RC_IN_MODE</strong> (INT32)</td>
 <td>RC control input mode <p><strong>Comment:</strong> A value of 0 enables RC transmitter control (only). A valid RC transmitter calibration is required. A value of 1 allows joystick control only. RC input handling and the associated checks are disabled. A value of 2 allows either RC Transmitter or Joystick input. The first valid input is used, will fallback to other sources if the input stream becomes invalid. A value of 3 allows either input from RC or joystick. The first available source is selected and used until reboot. A value of 4 ignores any stick input.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> RC Transmitter only</li>
<li><strong>1:</strong> Joystick only</li>
<li><strong>2:</strong> RC and Joystick with fallback</li>
<li><strong>3:</strong> RC or Joystick keep first</li>
<li><strong>4:</strong> Stick input disabled</li>
</ul>  </td>
 <td>[0, 4] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_RC_LOSS_T">COM_RC_LOSS_T</strong> (FLOAT)</td>
 <td>Manual control loss timeout <p><strong>Comment:</strong> The time in seconds without a new setpoint from RC or Joystick, after which the connection is considered lost. This must be kept short as the vehicle will use the last supplied setpoint until the timeout triggers.</p>   </td>
 <td>[0, 35] (0.1)</td>
 <td>0.5</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_RC_OVERRIDE">COM_RC_OVERRIDE</strong> (INT32)</td>
 <td>Enable RC stick override of auto and/or offboard modes <p><strong>Comment:</strong> When RC stick override is enabled, moving the RC sticks more than COM_RC_STICK_OV immediately gives control back to the pilot by switching to Position mode and if position is unavailable Altitude mode. Note: Only has an effect on multicopters, and VTOLs in multicopter mode.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Enable override during auto modes (except for in critical battery reaction)</li>
  <li><strong>1:</strong> Enable override during offboard mode</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_RC_STICK_OV">COM_RC_STICK_OV</strong> (FLOAT)</td>
 <td>RC stick override threshold <p><strong>Comment:</strong> If COM_RC_OVERRIDE is enabled and the joystick input is moved more than this threshold the autopilot the pilot takes over control.</p>   </td>
 <td>[5, 80] (0.05)</td>
 <td>30.0</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="COM_SPOOLUP_TIME">COM_SPOOLUP_TIME</strong> (FLOAT)</td>
 <td>Enforced delay between arming and further navigation <p><strong>Comment:</strong> The minimal time from arming the motors until moving the vehicle is possible is COM_SPOOLUP_TIME seconds. Goal: - Motors and propellers spool up to idle speed before getting commanded to spin faster - Timeout for ESCs and smart batteries to successfulyy do failure checks e.g. for stuck rotors before the vehicle is off the ground</p>   </td>
 <td>[0, 30] (0.1)</td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="COM_TAKEOFF_ACT">COM_TAKEOFF_ACT</strong> (INT32)</td>
 <td>Action after TAKEOFF has been accepted <p><strong>Comment:</strong> The mode transition after TAKEOFF has completed successfully.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Hold</li>
<li><strong>1:</strong> Mission (if valid)</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_THROW_EN">COM_THROW_EN</strong> (INT32)</td>
 <td>Enable throw-start <p><strong>Comment:</strong> Allows to start the vehicle by throwing it into the air.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_THROW_SPEED">COM_THROW_SPEED</strong> (FLOAT)</td>
 <td>Minimum speed for the throw start <p><strong>Comment:</strong> When the throw launch is enabled, the drone will only arm after this speed is exceeded before detecting the freefall. This is a safety feature to ensure the drone does not turn on after accidental drop or a rapid movement before the throw. Set to 0 to disable.</p>   </td>
 <td>[0, ?] (0.1)</td>
 <td>5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="COM_VEL_FS_EVH">COM_VEL_FS_EVH</strong> (FLOAT)</td>
 <td>Horizontal velocity error threshold <p><strong>Comment:</strong> This is the horizontal velocity error (EVH) threshold that will trigger a failsafe. The default is appropriate for a multicopter. Can be increased for a fixed-wing. If the previous velocity error was below this threshold, there is an additional factor of 2.5 applied (threshold for invalidation 2.5 times the one for validation).</p>   </td>
 <td>[0, ?] </td>
 <td>1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="COM_WIND_MAX">COM_WIND_MAX</strong> (FLOAT)</td>
 <td>High wind speed failsafe threshold <p><strong>Comment:</strong> Wind speed threshold above which an automatic failsafe action is triggered. Failsafe action can be specified with COM_WIND_MAX_ACT.</p>   </td>
 <td>[-1, ?] (0.1)</td>
 <td>-1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="COM_WIND_MAX_ACT">COM_WIND_MAX_ACT</strong> (INT32)</td>
 <td>High wind failsafe mode <p><strong>Comment:</strong> Action the system takes when a wind speed above the specified threshold is detected. See COM_WIND_MAX to set the failsafe threshold. If enabled, it is not possible to resume the mission or switch to any auto mode other than RTL or Land if this threshold is exceeded. Taking over in any manual mode is still possible.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Warning</li>
<li><strong>2:</strong> Hold</li>
<li><strong>3:</strong> Return</li>
<li><strong>4:</strong> Terminate</li>
<li><strong>5:</strong> Land</li>
</ul>  </td>
 <td>(1)</td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="COM_WIND_WARN">COM_WIND_WARN</strong> (FLOAT)</td>
 <td>Wind speed warning threshold <p><strong>Comment:</strong> A warning is triggered if the currently estimated wind speed is above this value. Warning is sent periodically (every 1 minute). Set to -1 to disable.</p>   </td>
 <td>[-1, ?] (0.1)</td>
 <td>-1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="NAV_DLL_ACT">NAV_DLL_ACT</strong> (INT32)</td>
 <td>Set GCS connection loss failsafe mode <p><strong>Comment:</strong> The GCS connection loss failsafe will only be entered after a timeout, set by COM_DL_LOSS_T in seconds. Once the timeout occurs the selected action will be executed.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Hold mode</li>
<li><strong>2:</strong> Return mode</li>
<li><strong>3:</strong> Land mode</li>
<li><strong>5:</strong> Terminate</li>
<li><strong>6:</strong> Disarm</li>
</ul>  </td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NAV_RCL_ACT">NAV_RCL_ACT</strong> (INT32)</td>
 <td>Set RC loss failsafe mode <p><strong>Comment:</strong> The RC loss failsafe will only be entered after a timeout, set by COM_RC_LOSS_T in seconds. If RC input checks have been disabled by setting the COM_RC_IN_MODE param it will not be triggered.</p> <strong>값:</strong><ul>
<li><strong>1:</strong> Hold mode</li>
<li><strong>2:</strong> Return mode</li>
<li><strong>3:</strong> Land mode</li>
<li><strong>5:</strong> Terminate</li>
<li><strong>6:</strong> Disarm</li>
</ul>  </td>
 <td>[1, 6] </td>
 <td>2</td>
 <td></td>
</tr>
</tbody></table>

## Cyphal

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CYPHAL_BAUD">CYPHAL_BAUD</strong> (INT32)</td>
 <td>UAVCAN/CAN v1 bus bitrate    <p><b>Reboot required:</b> true</p>
</td>
 <td>[20000, 1000000] </td>
 <td>1000000</td>
 <td>bit/s</td>
</tr>
<tr>
 <td><strong id="CYPHAL_ENABLE">CYPHAL_ENABLE</strong> (INT32)</td>
 <td>Cyphal <p><strong>Comment:</strong> 0 - Cyphal disabled. 1 - Enables Cyphal</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CYPHAL_ID">CYPHAL_ID</strong> (INT32)</td>
 <td>Cyphal Node ID <p><strong>Comment:</strong> Read the specs at http://uavcan.org to learn more about Node ID.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[-1, 125] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ACTR_PUB">UCAN1_ACTR_PUB</strong> (INT32)</td>
 <td>actuator_outputs uORB over Cyphal publication port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_BMS_BP_SUB">UCAN1_BMS_BP_SUB</strong> (INT32)</td>
 <td>UDRAL battery parameters subscription  port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_BMS_BS_SUB">UCAN1_BMS_BS_SUB</strong> (INT32)</td>
 <td>UDRAL battery status subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_BMS_ES_SUB">UCAN1_BMS_ES_SUB</strong> (INT32)</td>
 <td>UDRAL battery energy source subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC0_SUB">UCAN1_ESC0_SUB</strong> (INT32)</td>
 <td>ESC 0 subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_ESC_PUB">UCAN1_ESC_PUB</strong> (INT32)</td>
 <td>Cyphal ESC publication port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB0_SUB">UCAN1_FB0_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 0 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB1_SUB">UCAN1_FB1_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 1 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB2_SUB">UCAN1_FB2_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 2 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB3_SUB">UCAN1_FB3_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 3 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB4_SUB">UCAN1_FB4_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 4 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB5_SUB">UCAN1_FB5_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 5 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB6_SUB">UCAN1_FB6_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 6 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_FB7_SUB">UCAN1_FB7_SUB</strong> (INT32)</td>
 <td>Cyphal ESC 7 zubax feedback port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_GPS0_SUB">UCAN1_GPS0_SUB</strong> (INT32)</td>
 <td>GPS 0 subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_GPS1_SUB">UCAN1_GPS1_SUB</strong> (INT32)</td>
 <td>GPS 1 subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_GPS_PUB">UCAN1_GPS_PUB</strong> (INT32)</td>
 <td>Cyphal GPS publication port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_LG_BMS_SUB">UCAN1_LG_BMS_SUB</strong> (INT32)</td>
 <td>Cyphal legacy battery port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_READ_PUB">UCAN1_READ_PUB</strong> (INT32)</td>
 <td>Cyphal ESC readiness port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_SERVO_PUB">UCAN1_SERVO_PUB</strong> (INT32)</td>
 <td>Cyphal Servo publication port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_UORB_GPS">UCAN1_UORB_GPS</strong> (INT32)</td>
 <td>sensor_gps uORB over Cyphal subscription port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="UCAN1_UORB_GPS_P">UCAN1_UORB_GPS_P</strong> (INT32)</td>
 <td>sensor_gps uORB over Cyphal publication port ID    </td>
 <td>[-1, 6143] </td>
 <td>-1</td>
 <td></td>
</tr>
</tbody></table>

## DShot

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="DSHOT_3D_DEAD_H">DSHOT_3D_DEAD_H</strong> (INT32)</td>
 <td>DSHOT 3D deadband high <p><strong>Comment:</strong> When the actuator_output is between DSHOT_3D_DEAD_L and DSHOT_3D_DEAD_H, motor will not spin. This value is with respect to the mixer_module range (0-1999), not the DSHOT values.</p>   </td>
 <td>[1000, 1999] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="DSHOT_3D_DEAD_L">DSHOT_3D_DEAD_L</strong> (INT32)</td>
 <td>DSHOT 3D deadband low <p><strong>Comment:</strong> When the actuator_output is between DSHOT_3D_DEAD_L and DSHOT_3D_DEAD_H, motor will not spin. This value is with respect to the mixer_module range (0-1999), not the DSHOT values.</p>   </td>
 <td>[0, 1000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="DSHOT_3D_ENABLE">DSHOT_3D_ENABLE</strong> (INT32)</td>
 <td>Allows for 3d mode when using DShot and suitable mixer <p><strong>Comment:</strong> WARNING: ESC must be configured for 3D mode, and DSHOT_MIN set to 0. This splits the throttle ranges in two. Direction 1) 48 is the slowest, 1047 is the fastest. Direction 2) 1049 is the slowest, 2047 is the fastest. When mixer outputs 1000 or value inside DSHOT 3D deadband, DShot 0 is sent.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="DSHOT_BIDIR_EN">DSHOT_BIDIR_EN</strong> (INT32)</td>
 <td>Enable bidirectional DShot <p><strong>Comment:</strong> This parameter enables bidirectional DShot which provides RPM feedback. Note that this requires ESCs that support bidirectional DSHot, e.g. BlHeli32. This is not the same as DShot telemetry which requires an additional serial connection.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="DSHOT_MIN">DSHOT_MIN</strong> (FLOAT)</td>
 <td>Minimum DShot Motor Output <p><strong>Comment:</strong> Minimum Output Value for DShot in percent. The value depends on the ESC. Make sure to set this high enough so that the motors are always spinning while armed.</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.055</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="DSHOT_TEL_CFG">DSHOT_TEL_CFG</strong> (INT32)</td>
 <td>Serial Configuration for DShot Driver <p><strong>Comment:</strong> Configure on which serial port to run DShot Driver.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MOT_POLE_COUNT">MOT_POLE_COUNT</strong> (INT32)</td>
 <td>Number of magnetic poles of the motors <p><strong>Comment:</strong> Specify the number of magnetic poles of the motors. It is required to compute the RPM value from the eRPM returned with the ESC telemetry. Either get the number from the motor spec sheet or count the magnets on the bell of the motor (not the stator magnets). Typical motors for 5 inch props have 14 poles.</p>   </td>
 <td></td>
 <td>14</td>
 <td></td>
</tr>
</tbody></table>

## EKF2

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="EKF2_ABIAS_INIT">EKF2_ABIAS_INIT</strong> (FLOAT)</td>
 <td>1-sigma IMU accelerometer switch-on bias    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 0.5] </td>
 <td>0.2</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_ABL_ACCLIM">EKF2_ABL_ACCLIM</strong> (FLOAT)</td>
 <td>Maximum IMU accel magnitude that allows IMU bias learning <p><strong>Comment:</strong> If the magnitude of the IMU accelerometer vector exceeds this value, the EKF accel bias state estimation will be inhibited. This reduces the adverse effect of high manoeuvre accelerations and IMU nonlinerity and scale factor errors on the accel bias estimates.</p>   </td>
 <td>[20.0, 200.0] </td>
 <td>25.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_ABL_GYRLIM">EKF2_ABL_GYRLIM</strong> (FLOAT)</td>
 <td>Maximum IMU gyro angular rate magnitude that allows IMU bias learning <p><strong>Comment:</strong> If the magnitude of the IMU angular rate vector exceeds this value, the EKF accel bias state estimation will be inhibited. This reduces the adverse effect of rapid rotation rates and associated errors on the accel bias estimates.</p>   </td>
 <td>[2.0, 20.0] </td>
 <td>3.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_ABL_LIM">EKF2_ABL_LIM</strong> (FLOAT)</td>
 <td>Accelerometer bias learning limit <p><strong>Comment:</strong> The ekf accel bias states will be limited to within a range equivalent to +- of this value.</p>   </td>
 <td>[0.0, 0.8] </td>
 <td>0.4</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_ABL_TAU">EKF2_ABL_TAU</strong> (FLOAT)</td>
 <td>Accel bias learning inhibit time constant <p><strong>Comment:</strong> The vector magnitude of angular rate and acceleration used to check if learning should be inhibited has a peak hold filter applied to it with an exponential decay. This parameter controls the time constant of the decay.</p>   </td>
 <td>[0.1, 1.0] </td>
 <td>0.5</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="EKF2_ACC_B_NOISE">EKF2_ACC_B_NOISE</strong> (FLOAT)</td>
 <td>Process noise for IMU accelerometer bias prediction    </td>
 <td>[0.0, 0.01] </td>
 <td>0.003</td>
 <td>m/s^3</td>
</tr>
<tr>
 <td><strong id="EKF2_ACC_NOISE">EKF2_ACC_NOISE</strong> (FLOAT)</td>
 <td>Accelerometer noise for covariance prediction    </td>
 <td>[0.01, 1.0] </td>
 <td>0.35</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_AGP_CTRL">EKF2_AGP_CTRL</strong> (INT32)</td>
 <td>Aux global position (AGP) sensor aiding <p><strong>Comment:</strong> Set bits in the following positions to enable: 0 : Horizontal position fusion 1 : Vertical position fusion</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Horizontal position</li>
  <li><strong>1:</strong> Vertical position</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_AGP_DELAY">EKF2_AGP_DELAY</strong> (FLOAT)</td>
 <td>Aux global position estimator delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_AGP_GATE">EKF2_AGP_GATE</strong> (FLOAT)</td>
 <td>Gate size for aux global position fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>3.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_AGP_NOISE">EKF2_AGP_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for aux global position measurements <p><strong>Comment:</strong> Used to lower bound or replace the uncertainty included in the message</p>   </td>
 <td>[0.01, ?] </td>
 <td>0.9</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_ANGERR_INIT">EKF2_ANGERR_INIT</strong> (FLOAT)</td>
 <td>1-sigma tilt angle uncertainty after gravity vector alignment    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 0.5] </td>
 <td>0.1</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="EKF2_ARSP_THR">EKF2_ARSP_THR</strong> (FLOAT)</td>
 <td>Airspeed fusion threshold <p><strong>Comment:</strong> Airspeed data is fused for wind estimation if above this threshold. Set to 0 to disable airspeed fusion. For reliable wind estimation both sideslip (see EKF2_FUSE_BETA) and airspeed fusion should be enabled. Only applies to fixed-wing vehicles (or VTOLs in fixed-wing mode).</p>   </td>
 <td>[0.0, ?] </td>
 <td>0.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_ASPD_MAX">EKF2_ASPD_MAX</strong> (FLOAT)</td>
 <td>Maximum airspeed used for baro static pressure compensation    </td>
 <td>[5.0, 50.0] </td>
 <td>20.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_ASP_DELAY">EKF2_ASP_DELAY</strong> (FLOAT)</td>
 <td>Airspeed measurement delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>100</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_AVEL_DELAY">EKF2_AVEL_DELAY</strong> (FLOAT)</td>
 <td>Auxiliary Velocity Estimate delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>5</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_BARO_CTRL">EKF2_BARO_CTRL</strong> (INT32)</td>
 <td>Barometric sensor height aiding <p><strong>Comment:</strong> If this parameter is enabled then the estimator will make use of the barometric height measurements to estimate its height in addition to other height sources (if activated).</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_BARO_DELAY">EKF2_BARO_DELAY</strong> (FLOAT)</td>
 <td>Barometer measurement delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_BARO_GATE">EKF2_BARO_GATE</strong> (FLOAT)</td>
 <td>Gate size for barometric and GPS height fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_BARO_NOISE">EKF2_BARO_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for barometric altitude    </td>
 <td>[0.01, 15.0] </td>
 <td>3.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_BCOEF_X">EKF2_BCOEF_X</strong> (FLOAT)</td>
 <td>X-axis ballistic coefficient used for multi-rotor wind estimation <p><strong>Comment:</strong> This parameter controls the prediction of drag produced by bluff body drag along the forward/reverse axis when flying a multi-copter which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed squared. The predicted drag from the rotors is specified separately by the EKF2_MCOEF parameter. Set this parameter to zero to turn off the bluff body drag model for this axis.</p>   </td>
 <td>[0.0, 200.0] </td>
 <td>100.0</td>
 <td>kg/m^2</td>
</tr>
<tr>
 <td><strong id="EKF2_BCOEF_Y">EKF2_BCOEF_Y</strong> (FLOAT)</td>
 <td>Y-axis ballistic coefficient used for multi-rotor wind estimation <p><strong>Comment:</strong> This parameter controls the prediction of drag produced by bluff body drag along the right/left axis when flying a multi-copter, which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed squared. The predicted drag from the rotors is specified separately by the EKF2_MCOEF parameter. Set this parameter to zero to turn off the bluff body drag model for this axis.</p>   </td>
 <td>[0.0, 200.0] </td>
 <td>100.0</td>
 <td>kg/m^2</td>
</tr>
<tr>
 <td><strong id="EKF2_BETA_GATE">EKF2_BETA_GATE</strong> (FLOAT)</td>
 <td>Gate size for synthetic sideslip fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_BETA_NOISE">EKF2_BETA_NOISE</strong> (FLOAT)</td>
 <td>Noise for synthetic sideslip fusion    </td>
 <td>[0.1, 1.0] </td>
 <td>0.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_DECL_TYPE">EKF2_DECL_TYPE</strong> (INT32)</td>
 <td>Integer bitmask controlling handling of magnetic declination <p><strong>Comment:</strong> Set bits in the following positions to enable functions. 0 : Set to true to use the declination from the geo_lookup library when the GPS position becomes available, set to false to always use the EKF2_MAG_DECL value. 1 : Set to true to save the EKF2_MAG_DECL parameter to the value returned by the EKF when the vehicle disarms.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> use geo_lookup declination</li>
  <li><strong>1:</strong> save EKF2_MAG_DECL on disarm</li>
</ul>
 <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 3] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_DELAY_MAX">EKF2_DELAY_MAX</strong> (FLOAT)</td>
 <td>Maximum delay of all the aiding sensors <p><strong>Comment:</strong> Defines the delay between the current time and the delayed-time horizon. This value should be at least as large as the largest EKF2_XXX_DELAY parameter.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 1000] </td>
 <td>200</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_DRAG_CTRL">EKF2_DRAG_CTRL</strong> (INT32)</td>
 <td>Multirotor wind estimation selection <p><strong>Comment:</strong> Activate wind speed estimation using specific-force measurements and a drag model defined by EKF2_BCOEF_[XY] and EKF2_MCOEF. Only use on vehicles that have their thrust aligned with the Z axis and no thrust in the XY plane.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_DRAG_NOISE">EKF2_DRAG_NOISE</strong> (FLOAT)</td>
 <td>Specific drag force observation noise variance <p><strong>Comment:</strong> Used by the multi-rotor specific drag force model. Increasing this makes the multi-rotor wind estimates adjust more slowly.</p>   </td>
 <td>[0.5, 10.0] </td>
 <td>2.5</td>
 <td>(m/s^2)^2</td>
</tr>
<tr>
 <td><strong id="EKF2_EAS_NOISE">EKF2_EAS_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for airspeed fusion    </td>
 <td>[0.5, 5.0] </td>
 <td>1.4</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_EN">EKF2_EN</strong> (INT32)</td>
 <td>EKF2 enable    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_EVA_NOISE">EKF2_EVA_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for vision angle measurements <p><strong>Comment:</strong> Used to lower bound or replace the uncertainty included in the message</p>   </td>
 <td>[0.05, ?] </td>
 <td>0.1</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="EKF2_EVP_GATE">EKF2_EVP_GATE</strong> (FLOAT)</td>
 <td>Gate size for vision position fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_EVP_NOISE">EKF2_EVP_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for vision position measurements <p><strong>Comment:</strong> Used to lower bound or replace the uncertainty included in the message</p>   </td>
 <td>[0.01, ?] </td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_EVV_GATE">EKF2_EVV_GATE</strong> (FLOAT)</td>
 <td>Gate size for vision velocity estimate fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>3.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_EVV_NOISE">EKF2_EVV_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for vision velocity measurements <p><strong>Comment:</strong> Used to lower bound or replace the uncertainty included in the message</p>   </td>
 <td>[0.01, ?] </td>
 <td>0.1</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_EV_CTRL">EKF2_EV_CTRL</strong> (INT32)</td>
 <td>External vision (EV) sensor aiding <p><strong>Comment:</strong> Set bits in the following positions to enable: 0 : Horizontal position fusion 1 : Vertical position fusion 2 : 3D velocity fusion 3 : Yaw</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Horizontal position</li>
  <li><strong>1:</strong> Vertical position</li>
  <li><strong>2:</strong> 3D velocity</li>
  <li><strong>3:</strong> Yaw</li>
</ul>
 </td>
 <td>[0, 15] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_EV_DELAY">EKF2_EV_DELAY</strong> (FLOAT)</td>
 <td>Vision Position Estimator delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_EV_NOISE_MD">EKF2_EV_NOISE_MD</strong> (INT32)</td>
 <td>External vision (EV) noise mode <p><strong>Comment:</strong> If set to 0 (default) the measurement noise is taken from the vision message and the EV noise parameters are used as a lower bound. If set to 1 the observation noise is set from the parameters directly,</p> <strong>값:</strong><ul>
<li><strong>0:</strong> EV reported variance (parameter lower bound)</li>
<li><strong>1:</strong> EV noise parameters</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_EV_POS_X">EKF2_EV_POS_X</strong> (FLOAT)</td>
 <td>X position of VI sensor focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_EV_POS_Y">EKF2_EV_POS_Y</strong> (FLOAT)</td>
 <td>Y position of VI sensor focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_EV_POS_Z">EKF2_EV_POS_Z</strong> (FLOAT)</td>
 <td>Z position of VI sensor focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_EV_QMIN">EKF2_EV_QMIN</strong> (INT32)</td>
 <td>External vision (EV) minimum quality (optional) <p><strong>Comment:</strong> External vision will only be started and fused if the quality metric is above this threshold. The quality metric is a completely optional field provided by some VIO systems.</p>   </td>
 <td>[0, 100] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_FUSE_BETA">EKF2_FUSE_BETA</strong> (INT32)</td>
 <td>Enable synthetic sideslip fusion <p><strong>Comment:</strong> For reliable wind estimation both sideslip and airspeed fusion (see EKF2_ARSP_THR) should be enabled. Only applies to fixed-wing vehicles (or VTOLs in fixed-wing mode). Note: side slip fusion is currently not supported for tailsitters.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_GBIAS_INIT">EKF2_GBIAS_INIT</strong> (FLOAT)</td>
 <td>1-sigma IMU gyro switch-on bias    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 0.2] </td>
 <td>0.1</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_GND_EFF_DZ">EKF2_GND_EFF_DZ</strong> (FLOAT)</td>
 <td>Baro deadzone range for height fusion <p><strong>Comment:</strong> Sets the value of deadzone applied to negative baro innovations. Deadzone is enabled when EKF2_GND_EFF_DZ &gt; 0.</p>   </td>
 <td>[0.0, 10.0] </td>
 <td>4.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GND_MAX_HGT">EKF2_GND_MAX_HGT</strong> (FLOAT)</td>
 <td>Height above ground level for ground effect zone <p><strong>Comment:</strong> Sets the maximum distance to the ground level where negative baro innovations are expected.</p>   </td>
 <td>[0.0, 5.0] </td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_CHECK">EKF2_GPS_CHECK</strong> (INT32)</td>
 <td>Integer bitmask controlling GPS checks <p><strong>Comment:</strong> Each threshold value is defined by the parameter indicated next to the check. Drift and offset checks only run when the vehicle is on ground and stationary.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Sat count (EKF2_REQ_NSATS)</li>
  <li><strong>1:</strong> PDOP (EKF2_REQ_PDOP)</li>
  <li><strong>2:</strong> EPH (EKF2_REQ_EPH)</li>
  <li><strong>3:</strong> EPV (EKF2_REQ_EPV)</li>
  <li><strong>4:</strong> Speed accuracy (EKF2_REQ_SACC)</li>
  <li><strong>5:</strong> Horizontal position drift (EKF2_REQ_HDRIFT)</li>
  <li><strong>6:</strong> Vertical position drift (EKF2_REQ_VDRIFT)</li>
  <li><strong>7:</strong> Horizontal speed offset (EKF2_REQ_HDRIFT)</li>
  <li><strong>8:</strong> Vertical speed offset (EKF2_REQ_VDRIFT)</li>
  <li><strong>9:</strong> Spoofing</li>
</ul>
 </td>
 <td>[0, 1023] </td>
 <td>1023</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_CTRL">EKF2_GPS_CTRL</strong> (INT32)</td>
 <td>GNSS sensor aiding <p><strong>Comment:</strong> Set bits in the following positions to enable: 0 : Longitude and latitude fusion 1 : Altitude fusion 2 : 3D velocity fusion 3 : Dual antenna heading fusion</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Lon/lat</li>
  <li><strong>1:</strong> Altitude</li>
  <li><strong>2:</strong> 3D velocity</li>
  <li><strong>3:</strong> Dual antenna heading</li>
</ul>
 </td>
 <td>[0, 15] </td>
 <td>7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_DELAY">EKF2_GPS_DELAY</strong> (FLOAT)</td>
 <td>GPS measurement delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>110</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_POS_X">EKF2_GPS_POS_X</strong> (FLOAT)</td>
 <td>X position of GPS antenna in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_POS_Y">EKF2_GPS_POS_Y</strong> (FLOAT)</td>
 <td>Y position of GPS antenna in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_POS_Z">EKF2_GPS_POS_Z</strong> (FLOAT)</td>
 <td>Z position of GPS antenna in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_P_GATE">EKF2_GPS_P_GATE</strong> (FLOAT)</td>
 <td>Gate size for GNSS position fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_P_NOISE">EKF2_GPS_P_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for GNSS position    </td>
 <td>[0.01, 10.0] </td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_V_GATE">EKF2_GPS_V_GATE</strong> (FLOAT)</td>
 <td>Gate size for GNSS velocity fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_GPS_V_NOISE">EKF2_GPS_V_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for GNSS velocity    </td>
 <td>[0.01, 5.0] </td>
 <td>0.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_GRAV_NOISE">EKF2_GRAV_NOISE</strong> (FLOAT)</td>
 <td>Accelerometer measurement noise for gravity based observations    </td>
 <td>[0.1, 10.0] </td>
 <td>1.0</td>
 <td>g0</td>
</tr>
<tr>
 <td><strong id="EKF2_GSF_TAS">EKF2_GSF_TAS</strong> (FLOAT)</td>
 <td>Default value of true airspeed used in EKF-GSF AHRS calculation <p><strong>Comment:</strong> If no airspeed measurements are available, the EKF-GSF AHRS calculation will assume this value of true airspeed when compensating for centripetal acceleration during turns. Set to zero to disable centripetal acceleration compensation during fixed wing flight modes.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>15.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_GYR_B_LIM">EKF2_GYR_B_LIM</strong> (FLOAT)</td>
 <td>Gyro bias learning limit <p><strong>Comment:</strong> The ekf gyro bias states will be limited to within a range equivalent to +- of this value.</p>   </td>
 <td>[0.0, 0.4] </td>
 <td>0.15</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_GYR_B_NOISE">EKF2_GYR_B_NOISE</strong> (FLOAT)</td>
 <td>Process noise for IMU rate gyro bias prediction    </td>
 <td>[0.0, 0.01] </td>
 <td>0.001</td>
 <td>rad/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_GYR_NOISE">EKF2_GYR_NOISE</strong> (FLOAT)</td>
 <td>Rate gyro noise for covariance prediction    </td>
 <td>[0.0001, 0.1] </td>
 <td>0.015</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_HDG_GATE">EKF2_HDG_GATE</strong> (FLOAT)</td>
 <td>Gate size for heading fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>2.6</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_HEAD_NOISE">EKF2_HEAD_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for magnetic heading fusion    </td>
 <td>[0.01, 1.0] </td>
 <td>0.3</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="EKF2_HGT_REF">EKF2_HGT_REF</strong> (INT32)</td>
 <td>Determines the reference source of height data used by the EKF <p><strong>Comment:</strong> When multiple height sources are enabled at the same time, the height estimate will always converge towards the reference height source selected by this parameter. The range sensor and vision options should only be used when for operation over a flat surface as the local NED origin will move up and down with ground level.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Barometric pressure</li>
<li><strong>1:</strong> GPS</li>
<li><strong>2:</strong> Range sensor</li>
<li><strong>3:</strong> Vision</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_IMU_CTRL">EKF2_IMU_CTRL</strong> (INT32)</td>
 <td>IMU control   <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Gyro Bias</li>
  <li><strong>1:</strong> Accel Bias</li>
  <li><strong>2:</strong> Gravity vector fusion</li>
</ul>
 </td>
 <td>[0, 7] </td>
 <td>7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_IMU_POS_X">EKF2_IMU_POS_X</strong> (FLOAT)</td>
 <td>X position of IMU in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_IMU_POS_Y">EKF2_IMU_POS_Y</strong> (FLOAT)</td>
 <td>Y position of IMU in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_IMU_POS_Z">EKF2_IMU_POS_Z</strong> (FLOAT)</td>
 <td>Z position of IMU in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_LOG_VERBOSE">EKF2_LOG_VERBOSE</strong> (INT32)</td>
 <td>Verbose logging    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_ACCLIM">EKF2_MAG_ACCLIM</strong> (FLOAT)</td>
 <td>Horizontal acceleration threshold used for heading observability check <p><strong>Comment:</strong> The heading is assumed to be observable when the body acceleration is greater than this parameter when a global position/velocity aiding source is active.</p>   </td>
 <td>[0.0, 5.0] </td>
 <td>0.5</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_B_NOISE">EKF2_MAG_B_NOISE</strong> (FLOAT)</td>
 <td>Process noise for body magnetic field prediction    </td>
 <td>[0.0, 0.1] </td>
 <td>0.0001</td>
 <td>gauss/s</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_CHECK">EKF2_MAG_CHECK</strong> (INT32)</td>
 <td>Magnetic field strength test selection <p><strong>Comment:</strong> Bitmask to set which check is used to decide whether the magnetometer data is valid. If GNSS data is received, the magnetic field is compared to a World Magnetic Model (WMM), otherwise an average value is used. This check is useful to reject occasional hard iron disturbance. Set bits to 1 to enable checks. Checks enabled by the following bit positions 0 : Magnetic field strength. Set tolerance using EKF2_MAG_CHK_STR 1 : Magnetic field inclination. Set tolerance using EKF2_MAG_CHK_INC 2 : Wait for GNSS to find the theoretical strength and inclination using the WMM</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Strength (EKF2_MAG_CHK_STR)</li>
  <li><strong>1:</strong> Inclination (EKF2_MAG_CHK_INC)</li>
  <li><strong>2:</strong> Wait for WMM</li>
</ul>
 </td>
 <td>[0, 7] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_CHK_INC">EKF2_MAG_CHK_INC</strong> (FLOAT)</td>
 <td>Magnetic field inclination check tolerance <p><strong>Comment:</strong> Maximum allowed deviation from the expected magnetic field inclination to pass the check.</p>   </td>
 <td>[0.0, 90.0] </td>
 <td>20.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_CHK_STR">EKF2_MAG_CHK_STR</strong> (FLOAT)</td>
 <td>Magnetic field strength check tolerance <p><strong>Comment:</strong> Maximum allowed deviation from the expected magnetic field strength to pass the check.</p>   </td>
 <td>[0.0, 1.0] </td>
 <td>0.2</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_DECL">EKF2_MAG_DECL</strong> (FLOAT)</td>
 <td>Magnetic declination    </td>
 <td></td>
 <td>0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_DELAY">EKF2_MAG_DELAY</strong> (FLOAT)</td>
 <td>Magnetometer measurement delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>0</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_E_NOISE">EKF2_MAG_E_NOISE</strong> (FLOAT)</td>
 <td>Process noise for earth magnetic field prediction    </td>
 <td>[0.0, 0.1] </td>
 <td>0.001</td>
 <td>gauss/s</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_GATE">EKF2_MAG_GATE</strong> (FLOAT)</td>
 <td>Gate size for magnetometer XYZ component fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>3.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_NOISE">EKF2_MAG_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for magnetometer 3-axis fusion    </td>
 <td>[0.001, 1.0] </td>
 <td>0.05</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="EKF2_MAG_TYPE">EKF2_MAG_TYPE</strong> (INT32)</td>
 <td>Type of magnetometer fusion <p><strong>Comment:</strong> Integer controlling the type of magnetometer fusion used - magnetic heading or 3-component vector. The fusion of magnetometer data as a three component vector enables vehicle body fixed hard iron errors to be learned, but requires a stable earth field. If set to &#x27;Automatic&#x27; magnetic heading fusion is used when on-ground and 3-axis magnetic field fusion in-flight. If set to &#x27;Magnetic heading&#x27; magnetic heading fusion is used at all times. If set to &#x27;None&#x27; the magnetometer will not be used under any circumstance. If no external source of yaw is available, it is possible to use post-takeoff horizontal movement combined with GNSS velocity measurements to align the yaw angle. If set to &#x27;Init&#x27; the magnetometer is only used to initalize the heading.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Automatic</li>
<li><strong>1:</strong> Magnetic heading</li>
<li><strong>5:</strong> None</li>
<li><strong>6:</strong> Init</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_MCOEF">EKF2_MCOEF</strong> (FLOAT)</td>
 <td>Propeller momentum drag coefficient for multi-rotor wind estimation <p><strong>Comment:</strong> This parameter controls the prediction of drag produced by the propellers when flying a multi-copter, which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed not speed squared and is produced because some of the air velocity normal to the propeller axis of rotation is lost when passing through the rotor disc. This  changes the momentum of the flow which creates a drag reaction force. When comparing un-ducted propellers of the same diameter, the effect is roughly proportional to the area of the propeller blades when viewed side on and changes with propeller selection. Momentum drag is significantly higher for ducted rotors. To account for the drag produced by the body which scales with speed squared, see documentation for the EKF2_BCOEF_X and EKF2_BCOEF_Y parameters. Set this parameter to zero to turn off the momentum drag model for both axis.</p>   </td>
 <td>[0, 1.0] </td>
 <td>0.15</td>
 <td>1/s</td>
</tr>
<tr>
 <td><strong id="EKF2_MIN_RNG">EKF2_MIN_RNG</strong> (FLOAT)</td>
 <td>Expected range finder reading when on ground <p><strong>Comment:</strong> If the vehicle is on ground, is not moving as determined by the motion test and the range finder is returning invalid or no data, then an assumed range value of EKF2_MIN_RNG will be used by the terrain estimator so that a terrain height estimate is available at the start of flight in situations where the range finder may be inside its minimum measurements distance when on ground.</p>   </td>
 <td>[0.01, ?] </td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_MULTI_IMU">EKF2_MULTI_IMU</strong> (INT32)</td>
 <td>Multi-EKF IMUs <p><strong>Comment:</strong> Maximum number of IMUs to use for Multi-EKF. Set 0 to disable. Requires SENS_IMU_MODE 0.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 4] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_MULTI_MAG">EKF2_MULTI_MAG</strong> (INT32)</td>
 <td>Multi-EKF Magnetometers <p><strong>Comment:</strong> Maximum number of magnetometers to use for Multi-EKF. Set 0 to disable. Requires SENS_MAG_MODE 0.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 4] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_NOAID_NOISE">EKF2_NOAID_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for non-aiding position hold    </td>
 <td>[0.5, 50.0] </td>
 <td>10.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_NOAID_TOUT">EKF2_NOAID_TOUT</strong> (INT32)</td>
 <td>Maximum inertial dead-reckoning time <p><strong>Comment:</strong> Maximum lapsed time from last fusion of measurements that constrain velocity drift before the EKF will report the horizontal nav solution as invalid</p>   </td>
 <td>[500000, 10000000] </td>
 <td>5000000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_CTRL">EKF2_OF_CTRL</strong> (INT32)</td>
 <td>Optical flow aiding <p><strong>Comment:</strong> Enable optical flow fusion.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_OF_DELAY">EKF2_OF_DELAY</strong> (FLOAT)</td>
 <td>Optical flow measurement delay relative to IMU measurements <p><strong>Comment:</strong> Assumes measurement is timestamped at trailing edge of integration period</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>20</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_GATE">EKF2_OF_GATE</strong> (FLOAT)</td>
 <td>Gate size for optical flow fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>3.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_N_MAX">EKF2_OF_N_MAX</strong> (FLOAT)</td>
 <td>Optical flow maximum noise <p><strong>Comment:</strong> Measurement noise for the optical flow sensor when it&#x27;s reported quality metric is at the minimum</p>   </td>
 <td>[0.05, ?] </td>
 <td>0.5</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_N_MIN">EKF2_OF_N_MIN</strong> (FLOAT)</td>
 <td>Optical flow minimum noise <p><strong>Comment:</strong> Measurement noise for the optical flow sensor when it&#x27;s reported quality metric is at the maximum</p>   </td>
 <td>[0.05, ?] </td>
 <td>0.15</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_POS_X">EKF2_OF_POS_X</strong> (FLOAT)</td>
 <td>X position of optical flow focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_POS_Y">EKF2_OF_POS_Y</strong> (FLOAT)</td>
 <td>Y position of optical flow focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_POS_Z">EKF2_OF_POS_Z</strong> (FLOAT)</td>
 <td>Z position of optical flow focal point in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_OF_QMIN">EKF2_OF_QMIN</strong> (INT32)</td>
 <td>In air optical flow minimum quality <p><strong>Comment:</strong> Optical Flow data will only be used in air if the sensor reports a quality metric &gt;= EKF2_OF_QMIN</p>   </td>
 <td>[0, 255] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_OF_QMIN_GND">EKF2_OF_QMIN_GND</strong> (INT32)</td>
 <td>On ground optical flow minimum quality <p><strong>Comment:</strong> Optical Flow data will only be used on the ground if the sensor reports a quality metric &gt;= EKF2_OF_QMIN_GND</p>   </td>
 <td>[0, 255] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PCOEF_XN">EKF2_PCOEF_XN</strong> (FLOAT)</td>
 <td>Static pressure position error coefficient for the negative X axis <p><strong>Comment:</strong> This is the ratio of static pressure error to dynamic pressure generated by a negative wind relative velocity along the X body axis. If the baro height estimate rises during backwards flight, then this will be a negative number.</p>   </td>
 <td>[-0.5, 0.5] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PCOEF_XP">EKF2_PCOEF_XP</strong> (FLOAT)</td>
 <td>Static pressure position error coefficient for the positive X axis <p><strong>Comment:</strong> This is the ratio of static pressure error to dynamic pressure generated by a positive wind relative velocity along the X body axis. If the baro height estimate rises during forward flight, then this will be a negative number.</p>   </td>
 <td>[-0.5, 0.5] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PCOEF_YN">EKF2_PCOEF_YN</strong> (FLOAT)</td>
 <td>Pressure position error coefficient for the negative Y axis <p><strong>Comment:</strong> This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the negative Y (LH) body axis. If the baro height estimate rises during sideways flight to the left, then this will be a negative number.</p>   </td>
 <td>[-0.5, 0.5] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PCOEF_YP">EKF2_PCOEF_YP</strong> (FLOAT)</td>
 <td>Pressure position error coefficient for the positive Y axis <p><strong>Comment:</strong> This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the positive Y (RH) body axis. If the baro height estimate rises during sideways flight to the right, then this will be a negative number.</p>   </td>
 <td>[-0.5, 0.5] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PCOEF_Z">EKF2_PCOEF_Z</strong> (FLOAT)</td>
 <td>Static pressure position error coefficient for the Z axis <p><strong>Comment:</strong> This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the Z body axis.</p>   </td>
 <td>[-0.5, 0.5] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_PREDICT_US">EKF2_PREDICT_US</strong> (INT32)</td>
 <td>EKF prediction period <p><strong>Comment:</strong> EKF prediction period in microseconds. This should ideally be an integer multiple of the IMU time delta. Actual filter update will be an integer multiple of IMU update.</p>   </td>
 <td>[1000, 20000] </td>
 <td>10000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_EPH">EKF2_REQ_EPH</strong> (FLOAT)</td>
 <td>Required EPH to use GPS    </td>
 <td>[2, 100] </td>
 <td>3.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_EPV">EKF2_REQ_EPV</strong> (FLOAT)</td>
 <td>Required EPV to use GPS    </td>
 <td>[2, 100] </td>
 <td>5.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_GPS_H">EKF2_REQ_GPS_H</strong> (FLOAT)</td>
 <td>Required GPS health time on startup <p><strong>Comment:</strong> Minimum continuous period without GPS failure required to mark a healthy GPS status. It can be reduced to speed up initialization, but it&#x27;s recommended to keep this unchanged for a vehicle.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.1, ?] </td>
 <td>10.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_HDRIFT">EKF2_REQ_HDRIFT</strong> (FLOAT)</td>
 <td>Maximum horizontal drift speed to use GPS    </td>
 <td>[0.1, 1.0] </td>
 <td>0.1</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_NSATS">EKF2_REQ_NSATS</strong> (INT32)</td>
 <td>Required satellite count to use GPS    </td>
 <td>[4, 12] </td>
 <td>6</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_PDOP">EKF2_REQ_PDOP</strong> (FLOAT)</td>
 <td>Maximum PDOP to use GPS    </td>
 <td>[1.5, 5.0] </td>
 <td>2.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_SACC">EKF2_REQ_SACC</strong> (FLOAT)</td>
 <td>Required speed accuracy to use GPS    </td>
 <td>[0.5, 5.0] </td>
 <td>0.5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_REQ_VDRIFT">EKF2_REQ_VDRIFT</strong> (FLOAT)</td>
 <td>Maximum vertical drift speed to use GPS    </td>
 <td>[0.1, 1.5] </td>
 <td>0.2</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_A_HMAX">EKF2_RNG_A_HMAX</strong> (FLOAT)</td>
 <td>Maximum height above ground allowed for conditional range aid mode <p><strong>Comment:</strong> If the vehicle absolute altitude exceeds this value then the estimator will not fuse range measurements to estimate its height. This only applies when conditional range aid mode is activated (EKF2_RNG_CTRL = 1).</p>   </td>
 <td>[1.0, 10.0] </td>
 <td>5.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_A_IGATE">EKF2_RNG_A_IGATE</strong> (FLOAT)</td>
 <td>Gate size used for innovation consistency checks for range aid fusion <p><strong>Comment:</strong> A lower value means HAGL needs to be more stable in order to use range finder for height estimation in range aid mode</p>   </td>
 <td>[0.1, 5.0] </td>
 <td>1.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_A_VMAX">EKF2_RNG_A_VMAX</strong> (FLOAT)</td>
 <td>Maximum horizontal velocity allowed for conditional range aid mode <p><strong>Comment:</strong> If the vehicle horizontal speed exceeds this value then the estimator will not fuse range measurements to estimate its height. This only applies when conditional range aid mode is activated (EKF2_RNG_CTRL = 1).</p>   </td>
 <td>[0.1, 2] </td>
 <td>1.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_CTRL">EKF2_RNG_CTRL</strong> (INT32)</td>
 <td>Range sensor height aiding <p><strong>Comment:</strong> WARNING: Range finder measurements are less reliable and can experience unexpected errors. For these reasons, if accurate control of height relative to ground is required, it is recommended to use the MPC_ALT_MODE parameter instead, unless baro errors are severe enough to cause problems with landing and takeoff. If this parameter is enabled then the estimator will make use of the range finder measurements to estimate its height in addition to other height sources (if activated). Range sensor aiding can be enabled (i.e.: always use) or set in &quot;conditional&quot; mode. Conditional mode: This enables the range finder to be used during low speed (&lt; EKF2_RNG_A_VMAX) and low altitude (&lt; EKF2_RNG_A_HMAX) operation, eg takeoff and landing, where baro interference from rotor wash is excessive and can corrupt EKF state estimates. It is intended to be used where a vertical takeoff and landing is performed, and horizontal flight does not occur until above EKF2_RNG_A_HMAX.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable range fusion</li>
<li><strong>1:</strong> Enabled (conditional mode)</li>
<li><strong>2:</strong> Enabled</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_DELAY">EKF2_RNG_DELAY</strong> (FLOAT)</td>
 <td>Range finder measurement delay relative to IMU measurements    <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, 300] </td>
 <td>5</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_GATE">EKF2_RNG_GATE</strong> (FLOAT)</td>
 <td>Gate size for range finder fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_K_GATE">EKF2_RNG_K_GATE</strong> (FLOAT)</td>
 <td>Gate size used for range finder kinematic consistency check <p><strong>Comment:</strong> To be used, the time derivative of the distance sensor measurements projected on the vertical axis needs to be statistically consistent with the estimated vertical velocity of the drone. Decrease this value to make the filter more robust against range finder faulty data (stuck, reflections, ...). Note: tune the range finder noise parameters (EKF2_RNG_NOISE and EKF2_RNG_SFE) before tuning this gate.</p>   </td>
 <td>[0.1, 5.0] </td>
 <td>1.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_NOISE">EKF2_RNG_NOISE</strong> (FLOAT)</td>
 <td>Measurement noise for range finder fusion    </td>
 <td>[0.01, ?] </td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_PITCH">EKF2_RNG_PITCH</strong> (FLOAT)</td>
 <td>Range sensor pitch offset    </td>
 <td>[-0.75, 0.75] </td>
 <td>0.0</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_POS_X">EKF2_RNG_POS_X</strong> (FLOAT)</td>
 <td>X position of range finder origin in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_POS_Y">EKF2_RNG_POS_Y</strong> (FLOAT)</td>
 <td>Y position of range finder origin in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_POS_Z">EKF2_RNG_POS_Z</strong> (FLOAT)</td>
 <td>Z position of range finder origin in body frame <p><strong>Comment:</strong> Forward axis with origin relative to vehicle centre of gravity</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_QLTY_T">EKF2_RNG_QLTY_T</strong> (FLOAT)</td>
 <td>Minumum range validity period <p><strong>Comment:</strong> Minimum duration during which the reported range finder signal quality needs to be non-zero in order to be declared valid (s)</p>   </td>
 <td>[0.1, 5] </td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="EKF2_RNG_SFE">EKF2_RNG_SFE</strong> (FLOAT)</td>
 <td>Range finder range dependent noise scaler <p><strong>Comment:</strong> Specifies the increase in range finder noise with range.</p>   </td>
 <td>[0.0, 0.2] </td>
 <td>0.05</td>
 <td>m/m</td>
</tr>
<tr>
 <td><strong id="EKF2_SEL_ERR_RED">EKF2_SEL_ERR_RED</strong> (FLOAT)</td>
 <td>Selector error reduce threshold <p><strong>Comment:</strong> EKF2 instances have to be better than the selected by at least this amount before their relative score can be reduced.</p>   </td>
 <td></td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_SEL_IMU_ACC">EKF2_SEL_IMU_ACC</strong> (FLOAT)</td>
 <td>Selector acceleration threshold <p><strong>Comment:</strong> EKF2 selector acceleration error threshold for comparing accelerometers. Acceleration vector differences larger than this will result in accumulated velocity error.</p>   </td>
 <td></td>
 <td>1.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="EKF2_SEL_IMU_ANG">EKF2_SEL_IMU_ANG</strong> (FLOAT)</td>
 <td>Selector angular threshold <p><strong>Comment:</strong> EKF2 selector maximum accumulated angular error threshold for comparing gyros. Accumulated angular error larger than this will result in the sensor being declared faulty.</p>   </td>
 <td></td>
 <td>15.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="EKF2_SEL_IMU_RAT">EKF2_SEL_IMU_RAT</strong> (FLOAT)</td>
 <td>Selector angular rate threshold <p><strong>Comment:</strong> EKF2 selector angular rate error threshold for comparing gyros. Angular rate vector differences larger than this will result in accumulated angular error.</p>   </td>
 <td></td>
 <td>7.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="EKF2_SEL_IMU_VEL">EKF2_SEL_IMU_VEL</strong> (FLOAT)</td>
 <td>Selector angular threshold <p><strong>Comment:</strong> EKF2 selector maximum accumulated velocity threshold for comparing accelerometers. Accumulated velocity error larger than this will result in the sensor being declared faulty.</p>   </td>
 <td></td>
 <td>2.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_SYNT_MAG_Z">EKF2_SYNT_MAG_Z</strong> (INT32)</td>
 <td>Enable synthetic magnetometer Z component measurement <p><strong>Comment:</strong> Use for vehicles where the measured body Z magnetic field is subject to strong magnetic interference. For magnetic heading fusion the magnetometer Z measurement will be replaced by a synthetic value calculated using the knowledge of the 3D magnetic field vector at the location of the drone. Therefore, this parameter will only have an effect if the global position of the drone is known. For 3D mag fusion the magnetometer Z measurement will simply be ignored instead of fusing the synthetic value.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EKF2_TAS_GATE">EKF2_TAS_GATE</strong> (FLOAT)</td>
 <td>Gate size for TAS fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, ?] </td>
 <td>5.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="EKF2_TAU_POS">EKF2_TAU_POS</strong> (FLOAT)</td>
 <td>Output predictor position time constant <p><strong>Comment:</strong> Controls how tightly the output track the EKF states</p>   </td>
 <td>[0.1, 1.0] </td>
 <td>0.25</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="EKF2_TAU_VEL">EKF2_TAU_VEL</strong> (FLOAT)</td>
 <td>Time constant of the velocity output prediction and smoothing filter    </td>
 <td>[?, 1.0] </td>
 <td>0.25</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="EKF2_TERR_GRAD">EKF2_TERR_GRAD</strong> (FLOAT)</td>
 <td>Magnitude of terrain gradient    </td>
 <td>[0.0, ?] </td>
 <td>0.5</td>
 <td>m/m</td>
</tr>
<tr>
 <td><strong id="EKF2_TERR_NOISE">EKF2_TERR_NOISE</strong> (FLOAT)</td>
 <td>Terrain altitude process noise    </td>
 <td>[0.5, ?] </td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="EKF2_WIND_NSD">EKF2_WIND_NSD</strong> (FLOAT)</td>
 <td>Process noise spectral density for wind velocity prediction <p><strong>Comment:</strong> When unaided, the wind estimate uncertainty (1-sigma, in m/s) increases by this amount every second.</p>   </td>
 <td>[0.0, 1.0] </td>
 <td>0.05</td>
 <td>m/s^2/sqrt(Hz)</td>
</tr>
</tbody></table>

## ESC

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ESC_BL_VER">ESC_BL_VER</strong> (INT32)</td>
 <td>Required esc bootloader version    </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ESC_FW_VER">ESC_FW_VER</strong> (INT32)</td>
 <td>Required esc firmware version    </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ESC_HW_VER">ESC_HW_VER</strong> (INT32)</td>
 <td>Required esc hardware version    </td>
 <td>[0, 65535] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Events

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="EV_TSK_RC_LOSS">EV_TSK_RC_LOSS</strong> (INT32)</td>
 <td>RC Loss Alarm <p><strong>Comment:</strong> Enable/disable event task for RC Loss. When enabled, an alarm tune will be played via buzzer or ESCs, if supported. The alarm will sound after a disarm, if the vehicle was previously armed and only if the vehicle had RC signal at some point. Particularly useful for locating crashed drones without a GPS sensor.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="EV_TSK_STAT_DIS">EV_TSK_STAT_DIS</strong> (INT32)</td>
 <td>Status Display <p><strong>Comment:</strong> Enable/disable event task for displaying the vehicle status using arm-mounted LEDs. When enabled and if the vehicle supports it, LEDs will flash indicating various vehicle status changes. Currently PX4 has not implemented any specific status events. -</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
</tbody></table>

## FW Attitude Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_MAN_P_MAX">FW_MAN_P_MAX</strong> (FLOAT)</td>
 <td>Maximum manual pitch angle <p><strong>Comment:</strong> Applies to both directions in all manual modes with attitude stabilization but without altitude control</p>   </td>
 <td>[0.0, 90.0] (0.5)</td>
 <td>30.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_MAN_R_MAX">FW_MAN_R_MAX</strong> (FLOAT)</td>
 <td>Maximum manual roll angle <p><strong>Comment:</strong> Applies to both directions in all manual modes with attitude stabilization</p>   </td>
 <td>[0.0, 90.0] (0.5)</td>
 <td>45.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_MAN_YR_MAX">FW_MAN_YR_MAX</strong> (FLOAT)</td>
 <td>Maximum manually added yaw rate <p><strong>Comment:</strong> This is the maximally added yaw rate setpoint from the yaw stick in any attitude controlled flight mode. It is added to the yaw rate setpoint generated by the controller for turn coordination.</p>   </td>
 <td>[0, ?] (0.5)</td>
 <td>30.</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_PSP_OFF">FW_PSP_OFF</strong> (FLOAT)</td>
 <td>Pitch setpoint offset (pitch at level flight) <p><strong>Comment:</strong> An airframe specific offset of the pitch setpoint in degrees, the value is added to the pitch setpoint and should correspond to the pitch at typical cruise speed of the airframe.</p>   </td>
 <td>[-90.0, 90.0] (0.5)</td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_P_RMAX_NEG">FW_P_RMAX_NEG</strong> (FLOAT)</td>
 <td>Maximum negative / down pitch rate setpoint    </td>
 <td>[0.0, 180] (0.5)</td>
 <td>60.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_P_RMAX_POS">FW_P_RMAX_POS</strong> (FLOAT)</td>
 <td>Maximum positive / up pitch rate setpoint    </td>
 <td>[0.0, 180] (0.5)</td>
 <td>60.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_P_TC">FW_P_TC</strong> (FLOAT)</td>
 <td>Attitude pitch time constant <p><strong>Comment:</strong> This defines the latency between a pitch step input and the achieved setpoint (inverse to a P gain). Smaller systems may require smaller values.</p>   </td>
 <td>[0.2, 1.0] (0.05)</td>
 <td>0.4</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_R_RMAX">FW_R_RMAX</strong> (FLOAT)</td>
 <td>Maximum roll rate setpoint    </td>
 <td>[0.0, 180] (0.5)</td>
 <td>70.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_R_TC">FW_R_TC</strong> (FLOAT)</td>
 <td>Attitude Roll Time Constant <p><strong>Comment:</strong> This defines the latency between a roll step input and the achieved setpoint (inverse to a P gain). Smaller systems may require smaller values.</p>   </td>
 <td>[0.2, 1.0] (0.05)</td>
 <td>0.4</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_SPOILERS_LND">FW_SPOILERS_LND</strong> (FLOAT)</td>
 <td>Spoiler landing setting    </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_WR_FF">FW_WR_FF</strong> (FLOAT)</td>
 <td>Wheel steering rate feed forward    </td>
 <td>[0.0, 10] (0.05)</td>
 <td>0.2</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_WR_I">FW_WR_I</strong> (FLOAT)</td>
 <td>Wheel steering rate integrator gain <p><strong>Comment:</strong> This gain defines how much control response will result out of a steady state error. It trims any constant error.</p>   </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.1</td>
 <td>%/rad</td>
</tr>
<tr>
 <td><strong id="FW_WR_IMAX">FW_WR_IMAX</strong> (FLOAT)</td>
 <td>Wheel steering rate integrator limit    </td>
 <td>[0.0, 1.0] (0.05)</td>
 <td>0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_WR_P">FW_WR_P</strong> (FLOAT)</td>
 <td>Wheel steering rate proportional gain <p><strong>Comment:</strong> This defines how much the wheel steering input will be commanded depending on the current body angular rate error.</p>   </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.5</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_W_EN">FW_W_EN</strong> (INT32)</td>
 <td>Enable wheel steering controller <p><strong>Comment:</strong> Only enabled during automatic runway takeoff and landing. In all manual modes the wheel is directly controlled with yaw stick.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_W_RMAX">FW_W_RMAX</strong> (FLOAT)</td>
 <td>Maximum wheel steering rate <p><strong>Comment:</strong> This limits the maximum wheel steering rate the controller will output (in degrees per second).</p>   </td>
 <td>[0.0, 90.0] (0.5)</td>
 <td>30.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_Y_RMAX">FW_Y_RMAX</strong> (FLOAT)</td>
 <td>Maximum yaw rate setpoint    </td>
 <td>[0.0, 180] (0.5)</td>
 <td>50.0</td>
 <td>deg/s</td>
</tr>
</tbody></table>

## FW Auto Landing

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_LND_ABORT">FW_LND_ABORT</strong> (INT32)</td>
 <td>Bit mask to set the automatic landing abort conditions <p><strong>Comment:</strong> Terrain estimation: bit 0: Abort if terrain is not found bit 1: Abort if terrain times out (after a first successful measurement) The last estimate is always used as ground, whether the last valid measurement or the land waypoint, depending on the selected abort criteria, until an abort condition is entered. If FW_LND_USETER == 0, these bits are ignored. TODO: Extend automatic abort conditions e.g. glide slope tracking error (horizontal and vertical)</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Abort if terrain is not found (only applies to mission landings)</li>
  <li><strong>1:</strong> Abort if terrain times out (after a first successful measurement)</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_LND_AIRSPD">FW_LND_AIRSPD</strong> (FLOAT)</td>
 <td>Landing airspeed <p><strong>Comment:</strong> The calibrated airspeed setpoint during landing. If set &lt;= 0, landing airspeed = FW_AIRSPD_MIN by default.</p>   </td>
 <td>[-1.0, ?] (0.1)</td>
 <td>-1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_LND_ANG">FW_LND_ANG</strong> (FLOAT)</td>
 <td>Maximum landing slope angle <p><strong>Comment:</strong> Typically the desired landing slope angle when landing configuration (flaps, airspeed) is enabled. Set this value within the vehicle&#x27;s performance limits.</p>   </td>
 <td>[1.0, 15.0] (0.5)</td>
 <td>5.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_LND_EARLYCFG">FW_LND_EARLYCFG</strong> (INT32)</td>
 <td>Early landing configuration deployment <p><strong>Comment:</strong> Allows to deploy the landing configuration (flaps, landing airspeed, etc.) already in the loiter-down waypoint before the final approach. Otherwise is enabled only in the final approach.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_LND_FLALT">FW_LND_FLALT</strong> (FLOAT)</td>
 <td>Landing flare altitude (relative to landing altitude) <p><strong>Comment:</strong> NOTE: max(FW_LND_FLALT, FW_LND_FL_TIME * |z-velocity|) is taken as the flare altitude</p>   </td>
 <td>[0.0, ?] (0.5)</td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FW_LND_FL_PMAX">FW_LND_FL_PMAX</strong> (FLOAT)</td>
 <td>Flare, maximum pitch <p><strong>Comment:</strong> Maximum pitch during landing flare.</p>   </td>
 <td>[0, 45.0] (0.5)</td>
 <td>15.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_LND_FL_PMIN">FW_LND_FL_PMIN</strong> (FLOAT)</td>
 <td>Flare, minimum pitch <p><strong>Comment:</strong> Minimum pitch during landing flare.</p>   </td>
 <td>[-5, 15.0] (0.5)</td>
 <td>2.5</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_LND_FL_SINK">FW_LND_FL_SINK</strong> (FLOAT)</td>
 <td>Landing flare sink rate <p><strong>Comment:</strong> TECS will attempt to control the aircraft to this sink rate via pitch angle (throttle killed during flare)</p>   </td>
 <td>[0.0, 2] (0.1)</td>
 <td>0.25</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_LND_FL_TIME">FW_LND_FL_TIME</strong> (FLOAT)</td>
 <td>Landing flare time <p><strong>Comment:</strong> Multiplied by the descent rate to calculate a dynamic altitude at which to trigger the flare. NOTE: max(FW_LND_FLALT, FW_LND_FL_TIME * descent rate) is taken as the flare altitude</p>   </td>
 <td>[0.1, 5.0] (0.1)</td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_LND_NUDGE">FW_LND_NUDGE</strong> (INT32)</td>
 <td>Landing touchdown nudging option <p><strong>Comment:</strong> Approach angle nudging: shifts the touchdown point laterally while keeping the approach entrance point constant Approach path nudging: shifts the touchdown point laterally along with the entire approach path This is useful for manually adjusting the landing point in real time when map or GNSS errors cause an offset from the desired landing vector. Nudging is done with yaw stick, constrained to FW_LND_TD_OFF (in meters) and the direction is relative to the vehicle heading (stick deflection to the right = land point moves to the right as seen by the vehicle).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable nudging</li>
<li><strong>1:</strong> Nudge approach angle</li>
<li><strong>2:</strong> Nudge approach path</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_LND_TD_OFF">FW_LND_TD_OFF</strong> (FLOAT)</td>
 <td>Maximum lateral position offset for the touchdown point    </td>
 <td>[0.0, 10.0] (1)</td>
 <td>3.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FW_LND_TD_TIME">FW_LND_TD_TIME</strong> (FLOAT)</td>
 <td>Landing touchdown time (since flare start) <p><strong>Comment:</strong> This is the time after the start of flaring that we expect the vehicle to touch the runway. At this time, a 0.5s clamp down ramp will engage, constraining the pitch setpoint to RWTO_PSP. If enabled, ensure that RWTO_PSP is configured appropriately for full gear contact on ground roll. Set to -1.0 to disable touchdown clamping. E.g. it may not be desirable to clamp on belly landings. The touchdown time will be constrained to be greater than or equal to the flare time (FW_LND_FL_TIME).</p>   </td>
 <td>[-1.0, 5.0] (0.1)</td>
 <td>-1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_LND_THRTC_SC">FW_LND_THRTC_SC</strong> (FLOAT)</td>
 <td>Altitude time constant factor for landing <p><strong>Comment:</strong> During landing, the TECS altitude time constant (FW_T_ALT_TC) is multiplied by this value.</p>   </td>
 <td>[0.2, 1.0] (0.1)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_LND_USETER">FW_LND_USETER</strong> (INT32)</td>
 <td>Use terrain estimation during landing <p><strong>Comment:</strong> This is critical for detecting when to flare, and should be enabled if possible. NOTE: terrain estimate is currently solely derived from a distance sensor. If enabled and no measurement is found within a given timeout, the landing waypoint altitude will be used OR the landing will be aborted, depending on the criteria set in FW_LND_ABORT. If disabled, FW_LND_ABORT terrain based criteria are ignored.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable the terrain estimate</li>
<li><strong>1:</strong> Use the terrain estimate to trigger the flare (only)</li>
<li><strong>2:</strong> Calculate landing glide slope relative to the terrain estimate</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>1</td>
 <td></td>
</tr>
</tbody></table>

## FW Geometry

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_WING_HEIGHT">FW_WING_HEIGHT</strong> (FLOAT)</td>
 <td>Height (AGL) of the wings when the aircraft is on the ground <p><strong>Comment:</strong> This is used to constrain a minimum altitude below which we keep wings level to avoid wing tip strike. It&#x27;s safer to give a slight margin here (&gt; 0m)</p>   </td>
 <td>[0.0, ?] (1)</td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FW_WING_SPAN">FW_WING_SPAN</strong> (FLOAT)</td>
 <td>The aircraft&#x27;s wing span (length from tip to tip) <p><strong>Comment:</strong> This is used for limiting the roll setpoint near the ground. (if multiple wings, take the longest span)</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>3.0</td>
 <td>m</td>
</tr>
</tbody></table>

## FW Launch detection

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_LAUN_AC_T">FW_LAUN_AC_T</strong> (FLOAT)</td>
 <td>Trigger time <p><strong>Comment:</strong> Launch is detected when acceleration in body forward direction is above FW_LAUN_AC_THLD for FW_LAUN_AC_T seconds.</p>   </td>
 <td>[0.0, 5.0] (0.05)</td>
 <td>0.05</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_LAUN_AC_THLD">FW_LAUN_AC_THLD</strong> (FLOAT)</td>
 <td>Trigger acceleration threshold <p><strong>Comment:</strong> Launch is detected when acceleration in body forward direction is above FW_LAUN_AC_THLD for FW_LAUN_AC_T seconds.</p>   </td>
 <td>[0, ?] (0.5)</td>
 <td>30.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="FW_LAUN_DETCN_ON">FW_LAUN_DETCN_ON</strong> (INT32)</td>
 <td>Fixed-wing launch detection <p><strong>Comment:</strong> Enables automatic launch detection based on measured acceleration. Use for hand- or catapult-launched vehicles. Not compatible with runway takeoff.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_LAUN_MOT_DEL">FW_LAUN_MOT_DEL</strong> (FLOAT)</td>
 <td>Motor delay <p><strong>Comment:</strong> Start the motor(s) this amount of seconds after launch is detected.</p>   </td>
 <td>[0.0, 10.0] (0.5)</td>
 <td>0.0</td>
 <td>s</td>
</tr>
</tbody></table>

## FW NPFG Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="NPFG_DAMPING">NPFG_DAMPING</strong> (FLOAT)</td>
 <td>NPFG damping ratio <p><strong>Comment:</strong> Damping ratio of the NPFG control law.</p>   </td>
 <td>[0.10, 1.00] (0.01)</td>
 <td>0.7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_EN_MIN_GSP">NPFG_EN_MIN_GSP</strong> (INT32)</td>
 <td>Enable minimum forward ground speed maintaining excess wind handling logic    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_GSP_MAX_TK">NPFG_GSP_MAX_TK</strong> (FLOAT)</td>
 <td>Maximum, minimum forward ground speed for track keeping in excess wind <p><strong>Comment:</strong> The maximum value of the minimum forward ground speed that may be commanded by the track keeping excess wind handling logic. Commanded in full at the normalized track error fraction of the track error boundary and reduced to zero on track.</p>   </td>
 <td>[0.0, 10.0] (0.5)</td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="NPFG_LB_PERIOD">NPFG_LB_PERIOD</strong> (INT32)</td>
 <td>Enable automatic lower bound on the NPFG period <p><strong>Comment:</strong> Avoids limit cycling from a too aggressively tuned period/damping combination. If set to false, also disables the upper bound NPFG_PERIOD_UB.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_PERIOD">NPFG_PERIOD</strong> (FLOAT)</td>
 <td>NPFG period <p><strong>Comment:</strong> Period of the NPFG control law.</p>   </td>
 <td>[1.0, 100.0] (0.1)</td>
 <td>10.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="NPFG_PERIOD_SF">NPFG_PERIOD_SF</strong> (FLOAT)</td>
 <td>Period safety factor <p><strong>Comment:</strong> Multiplied by period for conservative minimum period bounding (when period lower bounding is enabled). 1.0 bounds at marginal stability.</p>   </td>
 <td>[1.0, 10.0] (0.1)</td>
 <td>1.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_ROLL_TC">NPFG_ROLL_TC</strong> (FLOAT)</td>
 <td>Roll time constant <p><strong>Comment:</strong> Time constant of roll controller command / response, modeled as first order delay. Used to determine lower period bound. Setting zero disables automatic period bounding.</p>   </td>
 <td>[0.00, 2.00] (0.05)</td>
 <td>0.5</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="NPFG_SW_DST_MLT">NPFG_SW_DST_MLT</strong> (FLOAT)</td>
 <td>NPFG switch distance multiplier <p><strong>Comment:</strong> Multiplied by the track error boundary to determine when the aircraft switches to the next waypoint and/or path segment. Should be less than 1.</p>   </td>
 <td>[0.1, 1.0] (0.01)</td>
 <td>0.32</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_TRACK_KEEP">NPFG_TRACK_KEEP</strong> (INT32)</td>
 <td>Enable track keeping excess wind handling logic    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_UB_PERIOD">NPFG_UB_PERIOD</strong> (INT32)</td>
 <td>Enable automatic upper bound on the NPFG period <p><strong>Comment:</strong> Adapts period to maintain track keeping in variable winds and path curvature.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NPFG_WIND_REG">NPFG_WIND_REG</strong> (INT32)</td>
 <td>Enable wind excess regulation <p><strong>Comment:</strong> Disabling this parameter further disables all other airspeed incrementation options.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
</tbody></table>

## FW Path Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_PN_R_SLEW_MAX">FW_PN_R_SLEW_MAX</strong> (FLOAT)</td>
 <td>Path navigation roll slew rate limit <p><strong>Comment:</strong> The maximum change in roll angle setpoint per second. This limit is applied in all Auto modes, plus manual Position and Altitude modes.</p>   </td>
 <td>[0, ?] (1)</td>
 <td>90.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="FW_POS_STK_CONF">FW_POS_STK_CONF</strong> (INT32)</td>
 <td>Custom stick configuration <p><strong>Comment:</strong> Applies in manual Position and Altitude flight modes.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Alternative stick configuration (height rate on throttle stick, airspeed on pitch stick)</li>
  <li><strong>1:</strong> Enable airspeed setpoint via sticks in altitude and position flight mode</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_R_LIM">FW_R_LIM</strong> (FLOAT)</td>
 <td>Maximum roll angle setpoint <p><strong>Comment:</strong> Applies in any altitude controlled flight mode.</p>   </td>
 <td>[35.0, 65.0] (0.5)</td>
 <td>50.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_TKO_PITCH_MIN">FW_TKO_PITCH_MIN</strong> (FLOAT)</td>
 <td>Minimum pitch during takeoff    </td>
 <td>[-5.0, 30.0] (0.5)</td>
 <td>10.0</td>
 <td>deg</td>
</tr>
</tbody></table>

## FW Performance

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_AIRSPD_MAX">FW_AIRSPD_MAX</strong> (FLOAT)</td>
 <td>Maximum Airspeed (CAS) <p><strong>Comment:</strong> The maximal airspeed (calibrated airspeed) the user is able to command.</p>   </td>
 <td>[0.5, ?] (0.5)</td>
 <td>20.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_AIRSPD_MIN">FW_AIRSPD_MIN</strong> (FLOAT)</td>
 <td>Minimum Airspeed (CAS) <p><strong>Comment:</strong> The minimal airspeed (calibrated airspeed) the user is able to command. Further, if the airspeed falls below this value, the TECS controller will try to increase airspeed more aggressively. Has to be set according to the vehicle&#x27;s stall speed (which should be set in FW_AIRSPD_STALL), with some margin between the stall speed and minimum airspeed. This value corresponds to the desired minimum speed with the default load factor (level flight, default weight), and is automatically adpated to the current load factor (calculated from roll setpoint and WEIGHT_GROSS/WEIGHT_BASE).</p>   </td>
 <td>[0.5, ?] (0.5)</td>
 <td>10.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_AIRSPD_STALL">FW_AIRSPD_STALL</strong> (FLOAT)</td>
 <td>Stall Airspeed (CAS) <p><strong>Comment:</strong> The stall airspeed (calibrated airspeed) of the vehicle. It is used for airspeed sensor failure detection and for the control surface scaling airspeed limits.</p>   </td>
 <td>[0.5, ?] (0.5)</td>
 <td>7.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_AIRSPD_TRIM">FW_AIRSPD_TRIM</strong> (FLOAT)</td>
 <td>Trim (Cruise) Airspeed <p><strong>Comment:</strong> The trim CAS (calibrated airspeed) of the vehicle. If an airspeed controller is active, this is the default airspeed setpoint that the controller will try to achieve. This value corresponds to the trim airspeed with the default load factor (level flight, default weight).</p>   </td>
 <td>[0.5, ?] (0.5)</td>
 <td>15.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_SERVICE_CEIL">FW_SERVICE_CEIL</strong> (FLOAT)</td>
 <td>Service ceiling <p><strong>Comment:</strong> Altitude in standard atmosphere at which the vehicle in normal configuration (WEIGHT_BASE) is still able to achieve a maximum climb rate of 0.5m/s at maximum throttle (FW_THR_MAX). Used to compensate for air density in FW_T_CLMB_MAX. Set negative to disable.</p>   </td>
 <td>[-1.0, ?] (1.0)</td>
 <td>-1.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FW_THR_ASPD_MAX">FW_THR_ASPD_MAX</strong> (FLOAT)</td>
 <td>Throttle at max airspeed <p><strong>Comment:</strong> Required throttle (at sea level, standard atmosphere) for level flight at maximum airspeed FW_AIRSPD_MAX Set to 0 to disable mapping of airspeed to trim throttle.</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_THR_ASPD_MIN">FW_THR_ASPD_MIN</strong> (FLOAT)</td>
 <td>Throttle at min airspeed <p><strong>Comment:</strong> Required throttle (at sea level, standard atmosphere) for level flight at minimum airspeed FW_AIRSPD_MIN Set to 0 to disable mapping of airspeed to trim throttle below FW_AIRSPD_TRIM.</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_THR_TRIM">FW_THR_TRIM</strong> (FLOAT)</td>
 <td>Trim throttle <p><strong>Comment:</strong> Required throttle (at sea level, standard atmosphere) for level flight at FW_AIRSPD_TRIM</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.6</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_T_CLMB_MAX">FW_T_CLMB_MAX</strong> (FLOAT)</td>
 <td>Maximum climb rate <p><strong>Comment:</strong> This is the maximum calibrated climb rate that the aircraft can achieve with the throttle set to FW_THR_MAX and the airspeed set to the trim value. For electric aircraft make sure this number can be achieved towards the end of flight when the battery voltage has reduced.</p>   </td>
 <td>[1.0, 15.0] (0.5)</td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_SINK_MIN">FW_T_SINK_MIN</strong> (FLOAT)</td>
 <td>Minimum descent rate <p><strong>Comment:</strong> This is the minimum calibrated sink rate of the aircraft with the throttle set to THR_MIN and flown at the same airspeed as used to measure FW_T_CLMB_MAX.</p>   </td>
 <td>[1.0, 5.0] (0.5)</td>
 <td>2.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="WEIGHT_BASE">WEIGHT_BASE</strong> (FLOAT)</td>
 <td>Vehicle base weight <p><strong>Comment:</strong> This is the weight of the vehicle at which it&#x27;s performance limits were derived. A zero or negative value disables trim throttle and minimum airspeed compensation based on weight.</p>   </td>
 <td>(0.5)</td>
 <td>-1.0</td>
 <td>kg</td>
</tr>
<tr>
 <td><strong id="WEIGHT_GROSS">WEIGHT_GROSS</strong> (FLOAT)</td>
 <td>Vehicle gross weight <p><strong>Comment:</strong> This is the actual weight of the vehicle at any time. This value will differ from WEIGHT_BASE in case weight was added or removed from the base weight. Examples are the addition of payloads or larger batteries. A zero or negative value disables trim throttle and minimum airspeed compensation based on weight.</p>   </td>
 <td>(0.1)</td>
 <td>-1.0</td>
 <td>kg</td>
</tr>
</tbody></table>

## FW Rate Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_ACRO_X_MAX">FW_ACRO_X_MAX</strong> (FLOAT)</td>
 <td>Acro body roll max rate setpoint    </td>
 <td>[10, 720] </td>
 <td>90</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_ACRO_YAW_EN">FW_ACRO_YAW_EN</strong> (INT32)</td>
 <td>Enable yaw rate controller in Acro <p><strong>Comment:</strong> If this parameter is set to 1, the yaw rate controller is enabled in Fixed-wing Acro mode. Otherwise the pilot commands directly the yaw actuator. It is disabled by default because an active yaw rate controller will fight against the natural turn coordination of the plane.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_ACRO_Y_MAX">FW_ACRO_Y_MAX</strong> (FLOAT)</td>
 <td>Acro body pitch max rate setpoint    </td>
 <td>[10, 720] </td>
 <td>90</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_ACRO_Z_MAX">FW_ACRO_Z_MAX</strong> (FLOAT)</td>
 <td>Acro body yaw max rate setpoint    </td>
 <td>[10, 720] </td>
 <td>45</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_ARSP_SCALE_EN">FW_ARSP_SCALE_EN</strong> (INT32)</td>
 <td>Enable airspeed scaling <p><strong>Comment:</strong> This enables a logic that automatically adjusts the output of the rate controller to take into account the real torque produced by an aerodynamic control surface given the current deviation from the trim airspeed (FW_AIRSPD_TRIM). Enable when using aerodynamic control surfaces (e.g.: plane) Disable when using rotor wings (e.g.: autogyro)</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_BAT_SCALE_EN">FW_BAT_SCALE_EN</strong> (INT32)</td>
 <td>Enable throttle scale by battery level <p><strong>Comment:</strong> This compensates for voltage drop of the battery over time by attempting to normalize performance across the operating range of the battery.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_P_VMAX">FW_DTRIM_P_VMAX</strong> (FLOAT)</td>
 <td>Pitch trim increment at maximum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_PITCH when airspeed is FW_AIRSPD_MAX.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_P_VMIN">FW_DTRIM_P_VMIN</strong> (FLOAT)</td>
 <td>Pitch trim increment at minimum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_PITCH when airspeed is FW_AIRSPD_MIN.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_R_VMAX">FW_DTRIM_R_VMAX</strong> (FLOAT)</td>
 <td>Roll trim increment at maximum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_ROLL when airspeed is FW_AIRSPD_MAX.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_R_VMIN">FW_DTRIM_R_VMIN</strong> (FLOAT)</td>
 <td>Roll trim increment at minimum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_ROLL when airspeed is FW_AIRSPD_MIN.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_Y_VMAX">FW_DTRIM_Y_VMAX</strong> (FLOAT)</td>
 <td>Yaw trim increment at maximum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_YAW when airspeed is FW_AIRSPD_MAX.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_DTRIM_Y_VMIN">FW_DTRIM_Y_VMIN</strong> (FLOAT)</td>
 <td>Yaw trim increment at minimum airspeed <p><strong>Comment:</strong> This increment is added to TRIM_YAW when airspeed is FW_AIRSPD_MIN.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_FLAPS_LND_SCL">FW_FLAPS_LND_SCL</strong> (FLOAT)</td>
 <td>Flaps setting during landing <p><strong>Comment:</strong> Sets a fraction of full flaps during landing. Also applies to flaperons if enabled in the mixer/allocation.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_FLAPS_TO_SCL">FW_FLAPS_TO_SCL</strong> (FLOAT)</td>
 <td>Flaps setting during take-off <p><strong>Comment:</strong> Sets a fraction of full flaps during take-off. Also applies to flaperons if enabled in the mixer/allocation.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_MAN_P_SC">FW_MAN_P_SC</strong> (FLOAT)</td>
 <td>Manual pitch scale <p><strong>Comment:</strong> Scale factor applied to the desired pitch actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_MAN_R_SC">FW_MAN_R_SC</strong> (FLOAT)</td>
 <td>Manual roll scale <p><strong>Comment:</strong> Scale factor applied to the desired roll actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_MAN_Y_SC">FW_MAN_Y_SC</strong> (FLOAT)</td>
 <td>Manual yaw scale <p><strong>Comment:</strong> Scale factor applied to the desired yaw actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_PR_D">FW_PR_D</strong> (FLOAT)</td>
 <td>Pitch rate derivative gain <p><strong>Comment:</strong> Pitch rate differential gain.</p>   </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_PR_FF">FW_PR_FF</strong> (FLOAT)</td>
 <td>Pitch rate feed forward <p><strong>Comment:</strong> Direct feed forward from rate setpoint to control surface output</p>   </td>
 <td>[0.0, 10.0] (0.05)</td>
 <td>0.5</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_PR_I">FW_PR_I</strong> (FLOAT)</td>
 <td>Pitch rate integrator gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.1</td>
 <td>%/rad</td>
</tr>
<tr>
 <td><strong id="FW_PR_IMAX">FW_PR_IMAX</strong> (FLOAT)</td>
 <td>Pitch rate integrator limit    </td>
 <td>[0.0, 1.0] (0.05)</td>
 <td>0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_PR_P">FW_PR_P</strong> (FLOAT)</td>
 <td>Pitch rate proportional gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.08</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_RLL_TO_YAW_FF">FW_RLL_TO_YAW_FF</strong> (FLOAT)</td>
 <td>Roll control to yaw control feedforward gain <p><strong>Comment:</strong> This gain can be used to counteract the &quot;adverse yaw&quot; effect for fixed wings. When the plane enters a roll it will tend to yaw the nose out of the turn. This gain enables the use of a yaw actuator to counteract this effect.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_RR_D">FW_RR_D</strong> (FLOAT)</td>
 <td>Roll rate derivative gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.0</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_RR_FF">FW_RR_FF</strong> (FLOAT)</td>
 <td>Roll rate feed forward <p><strong>Comment:</strong> Direct feed forward from rate setpoint to control surface output.</p>   </td>
 <td>[0.0, 10.0] (0.05)</td>
 <td>0.5</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_RR_I">FW_RR_I</strong> (FLOAT)</td>
 <td>Roll rate integrator gain    </td>
 <td>[0.0, 10] (0.01)</td>
 <td>0.1</td>
 <td>%/rad</td>
</tr>
<tr>
 <td><strong id="FW_RR_IMAX">FW_RR_IMAX</strong> (FLOAT)</td>
 <td>Roll integrator limit    </td>
 <td>[0.0, 1.0] (0.05)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_RR_P">FW_RR_P</strong> (FLOAT)</td>
 <td>Roll rate proportional gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.05</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_SPOILERS_MAN">FW_SPOILERS_MAN</strong> (INT32)</td>
 <td>Spoiler input in manual flight <p><strong>Comment:</strong> Chose source for manual setting of spoilers in manual flight modes.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Flaps channel</li>
<li><strong>2:</strong> Aux1</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_USE_AIRSPD">FW_USE_AIRSPD</strong> (INT32)</td>
 <td>Use airspeed for control <p><strong>Comment:</strong> If set to 1, the airspeed measurement data, if valid, is used in the following controllers: - Rate controller: output scaling - Attitude controller: coordinated turn controller - Position controller: airspeed setpoint tracking, takeoff logic - VTOL: transition logic</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_YR_D">FW_YR_D</strong> (FLOAT)</td>
 <td>Yaw rate derivative gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.0</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_YR_FF">FW_YR_FF</strong> (FLOAT)</td>
 <td>Yaw rate feed forward <p><strong>Comment:</strong> Direct feed forward from rate setpoint to control surface output</p>   </td>
 <td>[0.0, 10.0] (0.05)</td>
 <td>0.3</td>
 <td>%/rad/s</td>
</tr>
<tr>
 <td><strong id="FW_YR_I">FW_YR_I</strong> (FLOAT)</td>
 <td>Yaw rate integrator gain    </td>
 <td>[0.0, 10] (0.5)</td>
 <td>0.1</td>
 <td>%/rad</td>
</tr>
<tr>
 <td><strong id="FW_YR_IMAX">FW_YR_IMAX</strong> (FLOAT)</td>
 <td>Yaw rate integrator limit    </td>
 <td>[0.0, 1.0] (0.05)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_YR_P">FW_YR_P</strong> (FLOAT)</td>
 <td>Yaw rate proportional gain    </td>
 <td>[0.0, 10] (0.005)</td>
 <td>0.05</td>
 <td>%/rad/s</td>
</tr>
</tbody></table>

## FW TECS

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_GND_SPD_MIN">FW_GND_SPD_MIN</strong> (FLOAT)</td>
 <td>Minimum groundspeed <p><strong>Comment:</strong> The controller will increase the commanded airspeed to maintain this minimum groundspeed to the next waypoint.</p>   </td>
 <td>[0.0, 40] (0.5)</td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_P_LIM_MAX">FW_P_LIM_MAX</strong> (FLOAT)</td>
 <td>Maximum pitch angle setpoint <p><strong>Comment:</strong> Applies in any altitude controlled flight mode.</p>   </td>
 <td>[0.0, 60.0] (0.5)</td>
 <td>30.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_P_LIM_MIN">FW_P_LIM_MIN</strong> (FLOAT)</td>
 <td>Minimum pitch angle setpoint <p><strong>Comment:</strong> Applies in any altitude controlled flight mode.</p>   </td>
 <td>[-60.0, 0.0] (0.5)</td>
 <td>-30.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FW_THR_IDLE">FW_THR_IDLE</strong> (FLOAT)</td>
 <td>Idle throttle <p><strong>Comment:</strong> This is the minimum throttle while on the ground (&quot;landed&quot;) in auto modes.</p>   </td>
 <td>[0.0, 0.4] (0.01)</td>
 <td>0.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_THR_MAX">FW_THR_MAX</strong> (FLOAT)</td>
 <td>Throttle limit max <p><strong>Comment:</strong> Applies in any altitude controlled flight mode. Should be set accordingly to achieve FW_T_CLMB_MAX.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_THR_MIN">FW_THR_MIN</strong> (FLOAT)</td>
 <td>Throttle limit min <p><strong>Comment:</strong> Applies in any altitude controlled flight mode. Usually set to 0 but can be increased to prevent the motor from stopping when descending, which can increase achievable descent rates.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FW_THR_SLEW_MAX">FW_THR_SLEW_MAX</strong> (FLOAT)</td>
 <td>Throttle max slew rate <p><strong>Comment:</strong> Maximum slew rate for the commanded throttle</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_TKO_AIRSPD">FW_TKO_AIRSPD</strong> (FLOAT)</td>
 <td>Takeoff Airspeed <p><strong>Comment:</strong> The calibrated airspeed setpoint during the takeoff climbout. If set &lt;= 0, FW_AIRSPD_MIN will be set by default.</p>   </td>
 <td>[-1.0, ?] (0.1)</td>
 <td>-1.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_ALT_TC">FW_T_ALT_TC</strong> (FLOAT)</td>
 <td>Altitude error time constant    </td>
 <td>[2.0, ?] (0.5)</td>
 <td>5.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_CLMB_R_SP">FW_T_CLMB_R_SP</strong> (FLOAT)</td>
 <td>Default target climbrate <p><strong>Comment:</strong> In auto modes: default climb rate output by controller to achieve altitude setpoints. In manual modes: maximum climb rate setpoint.</p>   </td>
 <td>[0.5, 15] (0.01)</td>
 <td>3.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_F_ALT_ERR">FW_T_F_ALT_ERR</strong> (FLOAT)</td>
 <td>Fast descend: minimum altitude error <p><strong>Comment:</strong> Minimum altitude error needed to descend with max airspeed and minimal throttle. A negative value disables fast descend.</p>   </td>
 <td>[-1.0, ?] </td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_HRATE_FF">FW_T_HRATE_FF</strong> (FLOAT)</td>
 <td>Height rate feed forward    </td>
 <td>[0.0, 1.0] (0.05)</td>
 <td>0.3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_I_GAIN_PIT">FW_T_I_GAIN_PIT</strong> (FLOAT)</td>
 <td>Integrator gain pitch <p><strong>Comment:</strong> Increase it to trim out speed and height offsets faster, with the downside of possible overshoots and oscillations.</p>   </td>
 <td>[0.0, 2.0] (0.05)</td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_PTCH_DAMP">FW_T_PTCH_DAMP</strong> (FLOAT)</td>
 <td>Pitch damping gain    </td>
 <td>[0.0, 2.0] (0.1)</td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_RLL2THR">FW_T_RLL2THR</strong> (FLOAT)</td>
 <td>Roll -&gt; Throttle feedforward <p><strong>Comment:</strong> Is used to compensate for the additional drag created by turning. Increase this gain if the aircraft initially loses energy in turns and reduce if the aircraft initially gains energy in turns.</p>   </td>
 <td>[0.0, 20.0] (0.5)</td>
 <td>15.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_SEB_R_FF">FW_T_SEB_R_FF</strong> (FLOAT)</td>
 <td>Specific total energy balance rate feedforward gain    </td>
 <td>[0.5, 3] (0.01)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_SINK_MAX">FW_T_SINK_MAX</strong> (FLOAT)</td>
 <td>Maximum descent rate <p><strong>Comment:</strong> This sets the maximum descent rate that the controller will use.</p>   </td>
 <td>[1.0, 15.0] (0.5)</td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_SINK_R_SP">FW_T_SINK_R_SP</strong> (FLOAT)</td>
 <td>Default target sinkrate <p><strong>Comment:</strong> In auto modes: default sink rate output by controller to achieve altitude setpoints. In manual modes: maximum sink rate setpoint.</p>   </td>
 <td>[0.5, 15] (0.01)</td>
 <td>2.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_SPDWEIGHT">FW_T_SPDWEIGHT</strong> (FLOAT)</td>
 <td>Speed &lt;--&gt; Altitude priority <p><strong>Comment:</strong> Adjusts the amount of weighting that the pitch control applies to speed vs height errors. Setting it to 0.0 will cause the pitch control to control height and ignore speed errors. Setting it to 2.0 will cause the pitch control loop to control speed and ignore height errors. The default value of 1.0 allows the pitch control to simultaneously control height and speed. Set to 2 for gliders.</p>   </td>
 <td>[0.0, 2.0] (1.0)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_SPD_DEV_STD">FW_T_SPD_DEV_STD</strong> (FLOAT)</td>
 <td>Airspeed rate measurement standard deviation <p><strong>Comment:</strong> For the airspeed filter in TECS.</p>   </td>
 <td>[0.01, 10.0] (0.1)</td>
 <td>0.2</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="FW_T_SPD_PRC_STD">FW_T_SPD_PRC_STD</strong> (FLOAT)</td>
 <td>Process noise standard deviation for the airspeed rate <p><strong>Comment:</strong> This is defining the noise in the airspeed rate for the constant airspeed rate model of the TECS airspeed filter.</p>   </td>
 <td>[0.01, 10.0] (0.1)</td>
 <td>0.2</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="FW_T_SPD_STD">FW_T_SPD_STD</strong> (FLOAT)</td>
 <td>Airspeed measurement standard deviation <p><strong>Comment:</strong> For the airspeed filter in TECS.</p>   </td>
 <td>[0.01, 10.0] (0.1)</td>
 <td>0.2</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="FW_T_STE_R_TC">FW_T_STE_R_TC</strong> (FLOAT)</td>
 <td>Specific total energy rate first order filter time constant <p><strong>Comment:</strong> This filter is applied to the specific total energy rate used for throttle damping.</p>   </td>
 <td>[0.0, 2] (0.01)</td>
 <td>0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_TAS_TC">FW_T_TAS_TC</strong> (FLOAT)</td>
 <td>True airspeed error time constant    </td>
 <td>[2.0, ?] (0.5)</td>
 <td>5.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_THR_DAMPING">FW_T_THR_DAMPING</strong> (FLOAT)</td>
 <td>Throttle damping factor <p><strong>Comment:</strong> This is the damping gain for the throttle demand loop.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_THR_INTEG">FW_T_THR_INTEG</strong> (FLOAT)</td>
 <td>Integrator gain throttle <p><strong>Comment:</strong> Increase it to trim out speed and height offsets faster, with the downside of possible overshoots and oscillations.</p>   </td>
 <td>[0.0, 1.0] (0.005)</td>
 <td>0.02</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FW_T_VERT_ACC">FW_T_VERT_ACC</strong> (FLOAT)</td>
 <td>Maximum vertical acceleration <p><strong>Comment:</strong> This is the maximum vertical acceleration either up or down that the controller will use to correct speed or height errors.</p>   </td>
 <td>[1.0, 10.0] (0.5)</td>
 <td>7.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="FW_WIND_ARSP_SC">FW_WIND_ARSP_SC</strong> (FLOAT)</td>
 <td>Wind-based airspeed scaling factor <p><strong>Comment:</strong> Multiplying this factor with the current absolute wind estimate gives the airspeed offset added to the minimum airspeed setpoint limit. This helps to make the system more robust against disturbances (turbulence) in high wind.</p>   </td>
 <td>[0, ?] (0.01)</td>
 <td>0.</td>
 <td></td>
</tr>
</tbody></table>

## Failure Detector

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FD_ACT_EN">FD_ACT_EN</strong> (INT32)</td>
 <td>Enable Actuator Failure check <p><strong>Comment:</strong> If enabled, failure detector will verify that for motors, a minimum amount of ESC current per throttle level is being consumed. Otherwise this indicates an motor failure.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FD_ACT_MOT_C2T">FD_ACT_MOT_C2T</strong> (FLOAT)</td>
 <td>Motor Failure Current/Throttle Threshold <p><strong>Comment:</strong> Motor failure triggers only below this current value</p>   </td>
 <td>[0.0, 50.0] (1)</td>
 <td>2.0</td>
 <td>A/%</td>
</tr>
<tr>
 <td><strong id="FD_ACT_MOT_THR">FD_ACT_MOT_THR</strong> (FLOAT)</td>
 <td>Motor Failure Throttle Threshold <p><strong>Comment:</strong> Motor failure triggers only above this throttle value.</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.2</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="FD_ACT_MOT_TOUT">FD_ACT_MOT_TOUT</strong> (INT32)</td>
 <td>Motor Failure Time Threshold <p><strong>Comment:</strong> Motor failure triggers only if the throttle threshold and the current to throttle threshold are violated for this time.</p>   </td>
 <td>[10, 10000] (100)</td>
 <td>100</td>
 <td>ms</td>
</tr>
<tr>
 <td><strong id="FD_ESCS_EN">FD_ESCS_EN</strong> (INT32)</td>
 <td>Enable checks on ESCs that report their arming state <p><strong>Comment:</strong> If enabled, failure detector will verify that all the ESCs have successfully armed when the vehicle has transitioned to the armed state. Timeout for receiving an acknowledgement from the ESCs is 0.3s, if no feedback is received the failure detector will auto disarm the vehicle.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FD_EXT_ATS_EN">FD_EXT_ATS_EN</strong> (INT32)</td>
 <td>Enable PWM input on for engaging failsafe from an external automatic trigger system (ATS) <p><strong>Comment:</strong> Enabled on either AUX5 or MAIN5 depending on board. External ATS is required by ASTM F3322-18.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FD_EXT_ATS_TRIG">FD_EXT_ATS_TRIG</strong> (INT32)</td>
 <td>The PWM threshold from external automatic trigger system for engaging failsafe <p><strong>Comment:</strong> External ATS is required by ASTM F3322-18.</p>   </td>
 <td></td>
 <td>1900</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="FD_FAIL_P">FD_FAIL_P</strong> (INT32)</td>
 <td>FailureDetector Max Pitch <p><strong>Comment:</strong> Maximum pitch angle before FailureDetector triggers the attitude_failure flag. The flag triggers flight termination (if @CBRK_FLIGHTTERM = 0), which sets outputs to their failsafe values. On takeoff the flag triggers lockdown (irrespective of @CBRK_FLIGHTTERM), which disarms motors but does not set outputs to failsafe values. Setting this parameter to 0 disables the check</p>   </td>
 <td>[0, 180] </td>
 <td>60</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FD_FAIL_P_TTRI">FD_FAIL_P_TTRI</strong> (FLOAT)</td>
 <td>Pitch failure trigger time <p><strong>Comment:</strong> Seconds (decimal) that pitch has to exceed FD_FAIL_P before being considered as a failure.</p>   </td>
 <td>[0.02, 5] </td>
 <td>0.3</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FD_FAIL_R">FD_FAIL_R</strong> (INT32)</td>
 <td>FailureDetector Max Roll <p><strong>Comment:</strong> Maximum roll angle before FailureDetector triggers the attitude_failure flag. The flag triggers flight termination (if @CBRK_FLIGHTTERM = 0), which sets outputs to their failsafe values. On takeoff the flag triggers lockdown (irrespective of @CBRK_FLIGHTTERM), which disarms motors but does not set outputs to failsafe values. Setting this parameter to 0 disables the check</p>   </td>
 <td>[0, 180] </td>
 <td>60</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="FD_FAIL_R_TTRI">FD_FAIL_R_TTRI</strong> (FLOAT)</td>
 <td>Roll failure trigger time <p><strong>Comment:</strong> Seconds (decimal) that roll has to exceed FD_FAIL_R before being considered as a failure.</p>   </td>
 <td>[0.02, 5] </td>
 <td>0.3</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FD_IMB_PROP_THR">FD_IMB_PROP_THR</strong> (INT32)</td>
 <td>Imbalanced propeller check threshold <p><strong>Comment:</strong> Value at which the imbalanced propeller metric (based on horizontal and vertical acceleration variance) triggers a failure Setting this value to 0 disables the feature.</p>   </td>
 <td>[0, 1000] (1)</td>
 <td>30</td>
 <td></td>
</tr>
</tbody></table>

## FlightTaskOrbit

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_ORBIT_RAD_MAX">MC_ORBIT_RAD_MAX</strong> (FLOAT)</td>
 <td>Maximum radius of orbit    </td>
 <td>[1.0, 10000.0] (0.5)</td>
 <td>1000.0</td>
 <td>m</td>
</tr>
</tbody></table>

## Follow target

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FLW_TGT_ALT_M">FLW_TGT_ALT_M</strong> (INT32)</td>
 <td>Altitude control mode <p><strong>Comment:</strong> Maintain altitude or track target&#x27;s altitude. When maintaining the altitude, the drone can crash into terrain when the target moves uphill. When tracking the target&#x27;s altitude, the follow altitude FLW_TGT_HT should be high enough to prevent terrain collisions due to GPS inaccuracies of the target.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> 2D Tracking: Maintain constant altitude relative to home and track XY position only</li>
<li><strong>1:</strong> 2D + Terrain: Maintain constant altitude relative to terrain below and track XY position</li>
<li><strong>2:</strong> 3D Tracking: Track target&#x27;s altitude (be aware that GPS altitude bias usually makes this useless)</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FLW_TGT_DST">FLW_TGT_DST</strong> (FLOAT)</td>
 <td>Distance to follow target from <p><strong>Comment:</strong> The distance in meters to follow the target at</p>   </td>
 <td>[1.0, ?] </td>
 <td>8.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FLW_TGT_FA">FLW_TGT_FA</strong> (FLOAT)</td>
 <td>Follow Angle setting in degrees <p><strong>Comment:</strong> Angle to follow the target from. 0.0 Equals straight in front of the target&#x27;s course (direction of motion) and the angle increases in clockwise direction, meaning Right-side would be 90.0 degrees while Left-side is -90.0 degrees Note: When the user force sets the angle out of the min/max range, it will be wrapped (e.g. 480 -&gt; 120) in the range to gracefully handle the out of range.</p>   </td>
 <td>[-180.0, 180.0] </td>
 <td>180.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FLW_TGT_HT">FLW_TGT_HT</strong> (FLOAT)</td>
 <td>Follow target height <p><strong>Comment:</strong> Following height above the target</p>   </td>
 <td>[8.0, ?] </td>
 <td>8.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="FLW_TGT_MAX_VEL">FLW_TGT_MAX_VEL</strong> (FLOAT)</td>
 <td>Maximum tangential velocity setting for generating the follow orbit trajectory <p><strong>Comment:</strong> This is the maximum tangential velocity the drone will circle around the target whenever an orbit angle setpoint changes. Higher value means more aggressive follow behavior.</p>   </td>
 <td>[0.0, 20.0] </td>
 <td>5.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="FLW_TGT_RS">FLW_TGT_RS</strong> (FLOAT)</td>
 <td>Responsiveness to target movement in Target Estimator <p><strong>Comment:</strong> lower values increase the responsiveness to changing position, but also ignore less noise</p>   </td>
 <td>[0.0, 1.0] </td>
 <td>0.1</td>
 <td></td>
</tr>
</tbody></table>

## GPS

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="GPS_1_CONFIG">GPS_1_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for Main GPS <p><strong>Comment:</strong> Configure on which serial port to run Main GPS.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>201</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_1_GNSS">GPS_1_GNSS</strong> (INT32)</td>
 <td>GNSS Systems for Primary GPS (integer bitmask) <p><strong>Comment:</strong> This integer bitmask controls the set of GNSS systems used by the receiver. Check your receiver&#x27;s documentation on how many systems are supported to be used in parallel. Currently this functionality is just implemented for u-blox receivers. When no bits are set, the receiver&#x27;s default configuration should be used. Set bits true to enable: 0 : Use GPS (with QZSS) 1 : Use SBAS (multiple GPS augmentation systems) 2 : Use Galileo 3 : Use BeiDou 4 : Use GLONASS 5 : Use NAVIC</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> GPS (with QZSS)</li>
  <li><strong>1:</strong> SBAS</li>
  <li><strong>2:</strong> Galileo</li>
  <li><strong>3:</strong> BeiDou</li>
  <li><strong>4:</strong> GLONASS</li>
  <li><strong>5:</strong> NAVIC</li>
</ul>
 <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 63] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_1_PROTOCOL">GPS_1_PROTOCOL</strong> (INT32)</td>
 <td>Protocol for Main GPS <p><strong>Comment:</strong> Select the GPS protocol over serial. Auto-detection will probe all protocols, and thus is a bit slower.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Auto detect</li>
<li><strong>1:</strong> u-blox</li>
<li><strong>2:</strong> MTK</li>
<li><strong>3:</strong> Ashtech / Trimble</li>
<li><strong>4:</strong> Emlid Reach</li>
<li><strong>5:</strong> Femtomes</li>
<li><strong>6:</strong> NMEA (generic)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_2_CONFIG">GPS_2_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for Secondary GPS <p><strong>Comment:</strong> Configure on which serial port to run Secondary GPS.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_2_GNSS">GPS_2_GNSS</strong> (INT32)</td>
 <td>GNSS Systems for Secondary GPS (integer bitmask) <p><strong>Comment:</strong> This integer bitmask controls the set of GNSS systems used by the receiver. Check your receiver&#x27;s documentation on how many systems are supported to be used in parallel. Currently this functionality is just implemented for u-blox receivers. When no bits are set, the receiver&#x27;s default configuration should be used. Set bits true to enable: 0 : Use GPS (with QZSS) 1 : Use SBAS (multiple GPS augmentation systems) 2 : Use Galileo 3 : Use BeiDou 4 : Use GLONASS 5 : Use NAVIC</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> GPS (with QZSS)</li>
  <li><strong>1:</strong> SBAS</li>
  <li><strong>2:</strong> Galileo</li>
  <li><strong>3:</strong> BeiDou</li>
  <li><strong>4:</strong> GLONASS</li>
  <li><strong>5:</strong> NAVIC</li>
</ul>
 <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 63] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_2_PROTOCOL">GPS_2_PROTOCOL</strong> (INT32)</td>
 <td>Protocol for Secondary GPS <p><strong>Comment:</strong> Select the GPS protocol over serial. Auto-detection will probe all protocols, and thus is a bit slower.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Auto detect</li>
<li><strong>1:</strong> u-blox</li>
<li><strong>2:</strong> MTK</li>
<li><strong>3:</strong> Ashtech / Trimble</li>
<li><strong>4:</strong> Emlid Reach</li>
<li><strong>5:</strong> Femtomes</li>
<li><strong>6:</strong> NMEA (generic)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 6] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_DUMP_COMM">GPS_DUMP_COMM</strong> (INT32)</td>
 <td>Log GPS communication data <p><strong>Comment:</strong> If this is set to 1, all GPS communication data will be published via uORB, and written to the log file as gps_dump message. If this is set to 2, the main GPS is configured to output RTCM data, which is then logged as gps_dump and can be used for PPK.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> Full communication</li>
<li><strong>2:</strong> RTCM output (PPK)</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_SAT_INFO">GPS_SAT_INFO</strong> (INT32)</td>
 <td>Enable sat info (if available) <p><strong>Comment:</strong> Enable publication of satellite info (ORB_ID(satellite_info)) if possible. Not available on MTK.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_UBX_BAUD2">GPS_UBX_BAUD2</strong> (INT32)</td>
 <td>u-blox F9P UART2 Baudrate <p><strong>Comment:</strong> Select a baudrate for the F9P&#x27;s UART2 port. In GPS_UBX_MODE 1, 2, and 3, the F9P&#x27;s UART2 port is configured to send/receive RTCM corrections. Set this to 57600 if you want to attach a telemetry radio on UART2.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, ?] </td>
 <td>230400</td>
 <td>B/s</td>
</tr>
<tr>
 <td><strong id="GPS_UBX_CFG_INTF">GPS_UBX_CFG_INTF</strong> (INT32)</td>
 <td>u-blox protocol configuration for interfaces   <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Enable I2C input protocol UBX</li>
  <li><strong>1:</strong> Enable I2C input protocol NMEA</li>
  <li><strong>2:</strong> Enable I2C input protocol RTCM3X</li>
  <li><strong>3:</strong> Enable I2C output protocol UBX</li>
  <li><strong>4:</strong> Enable I2C output protocol NMEA</li>
  <li><strong>5:</strong> Enable I2C output protocol RTCM3X</li>
</ul>
 <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 32] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_UBX_DYNMODEL">GPS_UBX_DYNMODEL</strong> (INT32)</td>
 <td>u-blox GPS dynamic platform model <p><strong>Comment:</strong> u-blox receivers support different dynamic platform models to adjust the navigation engine to the expected application environment.</p> <strong>값:</strong><ul>
<li><strong>2:</strong> stationary</li>
<li><strong>4:</strong> automotive</li>
<li><strong>6:</strong> airborne with &lt;1g acceleration</li>
<li><strong>7:</strong> airborne with &lt;2g acceleration</li>
<li><strong>8:</strong> airborne with &lt;4g acceleration</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 9] </td>
 <td>7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_UBX_MODE">GPS_UBX_MODE</strong> (INT32)</td>
 <td>u-blox GPS Mode <p><strong>Comment:</strong> Select the u-blox configuration setup. Most setups will use the default, including RTK and dual GPS without heading. If rover has RTCM corrections from a static base (or other static correction source) coming in on UART2, then select Mode 5. The Heading mode requires 2 F9P devices to be attached. The main GPS will act as rover and output heading information, whereas the secondary will act as moving base. Modes 1 and 2 require each F9P UART1 to be connected to the Autopilot. In addition, UART2 on the F9P units are connected to each other. Modes 3 and 4 only require UART1 on each F9P connected to the Autopilot or Can Node. UART RX DMA is required. RTK is still possible with this setup.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Default</li>
<li><strong>1:</strong> Heading (Rover With Moving Base UART1 Connected To Autopilot, UART2 Connected To Moving Base)</li>
<li><strong>2:</strong> Moving Base (UART1 Connected To Autopilot, UART2 Connected To Rover)</li>
<li><strong>3:</strong> Heading (Rover With Moving Base UART1 Connected to Autopilot Or Can Node At 921600)</li>
<li><strong>4:</strong> Moving Base (Moving Base UART1 Connected to Autopilot Or Can Node At 921600)</li>
<li><strong>5:</strong> Rover with Static Base on UART2 (similar to Default, except coming in on UART2)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GPS_YAW_OFFSET">GPS_YAW_OFFSET</strong> (FLOAT)</td>
 <td>Heading/Yaw offset for dual antenna GPS <p><strong>Comment:</strong> Heading offset angle for dual antenna GPS setups that support heading estimation. Set this to 0 if the antennas are parallel to the forward-facing direction of the vehicle and the rover (or Unicore primary) antenna is in front. The offset angle increases clockwise. Set this to 90 if the rover (or Unicore primary, or Septentrio Mosaic Aux) antenna is placed on the right side of the vehicle and the moving base antenna is on the left side. (Note: the Unicore primary antenna is the one connected on the right as seen from the top).</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 360] </td>
 <td>0.</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="PPS_CAP_ENABLE">PPS_CAP_ENABLE</strong> (INT32)</td>
 <td>PPS Capture Enable <p><strong>Comment:</strong> Enables the PPS capture module. This switches mode of FMU channel 7 to be the PPS input channel.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
</tbody></table>

## Geofence

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="GF_ACTION">GF_ACTION</strong> (INT32)</td>
 <td>Geofence violation action <p><strong>Comment:</strong> Note: Setting this value to 4 enables flight termination, which will kill the vehicle on violation of the fence.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Warning</li>
<li><strong>2:</strong> Hold mode</li>
<li><strong>3:</strong> Return mode</li>
<li><strong>4:</strong> Terminate</li>
<li><strong>5:</strong> Land mode</li>
</ul>  </td>
 <td>[0, 5] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GF_MAX_HOR_DIST">GF_MAX_HOR_DIST</strong> (FLOAT)</td>
 <td>Max horizontal distance from Home <p><strong>Comment:</strong> Maximum horizontal distance in meters the vehicle can be from Home before triggering a geofence action. Disabled if 0.</p>   </td>
 <td>[0, 10000] (1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="GF_MAX_VER_DIST">GF_MAX_VER_DIST</strong> (FLOAT)</td>
 <td>Max vertical distance from Home <p><strong>Comment:</strong> Maximum vertical distance in meters the vehicle can be from Home before triggering a geofence action. Disabled if 0.</p>   </td>
 <td>[0, 10000] (1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="GF_PREDICT">GF_PREDICT</strong> (INT32)</td>
 <td>[EXPERIMENTAL] Use Pre-emptive geofence triggering <p><strong>Comment:</strong> WARNING: This experimental feature may cause flyaways. Use at your own risk. Predict the motion of the vehicle and trigger the breach if it is determined that the current trajectory would result in a breach happening before the vehicle can make evasive maneuvers. The vehicle is then re-routed to a safe hold position (stop for multirotor, loiter for fixed wing).</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GF_SOURCE">GF_SOURCE</strong> (INT32)</td>
 <td>Geofence source <p><strong>Comment:</strong> Select which position source should be used. Selecting GPS instead of global position makes sure that there is no dependence on the position estimator 0 = global position, 1 = GPS</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> GPOS</li>
<li><strong>1:</strong> GPS</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Geometry

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CA_AIRFRAME">CA_AIRFRAME</strong> (INT32)</td>
 <td>Airframe selection <p><strong>Comment:</strong> Defines which mixer implementation to use. Some are generic, while others are specifically fit to a certain vehicle with a fixed set of actuators. &#x27;Custom&#x27; should only be used if noting else can be used.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Multirotor</li>
<li><strong>1:</strong> Fixed-wing</li>
<li><strong>2:</strong> Standard VTOL</li>
<li><strong>3:</strong> Tiltrotor VTOL</li>
<li><strong>4:</strong> Tailsitter VTOL</li>
<li><strong>5:</strong> Rover (Ackermann)</li>
<li><strong>6:</strong> Rover (Differential)</li>
<li><strong>7:</strong> Motors (6DOF)</li>
<li><strong>8:</strong> Multirotor with Tilt</li>
<li><strong>9:</strong> Custom</li>
<li><strong>10:</strong> Helicopter (tail ESC)</li>
<li><strong>11:</strong> Helicopter (tail Servo)</li>
<li><strong>12:</strong> Helicopter (Coaxial)</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_FAILURE_MODE">CA_FAILURE_MODE</strong> (INT32)</td>
 <td>Motor failure handling mode <p><strong>Comment:</strong> This is used to specify how to handle motor failures reported by failure detector.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Ignore</li>
<li><strong>1:</strong> Remove first failed motor from effectiveness</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_PITCH_C0">CA_HELI_PITCH_C0</strong> (FLOAT)</td>
 <td>Collective pitch curve at position 0 <p><strong>Comment:</strong> Defines the collective pitch at the interval position 0 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.</p>   </td>
 <td>[-1, 1] (0.1)</td>
 <td>-0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_PITCH_C1">CA_HELI_PITCH_C1</strong> (FLOAT)</td>
 <td>Collective pitch curve at position 1 <p><strong>Comment:</strong> Defines the collective pitch at the interval position 1 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.</p>   </td>
 <td>[-1, 1] (0.1)</td>
 <td>0.0725</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_PITCH_C2">CA_HELI_PITCH_C2</strong> (FLOAT)</td>
 <td>Collective pitch curve at position 2 <p><strong>Comment:</strong> Defines the collective pitch at the interval position 2 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.</p>   </td>
 <td>[-1, 1] (0.1)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_PITCH_C3">CA_HELI_PITCH_C3</strong> (FLOAT)</td>
 <td>Collective pitch curve at position 3 <p><strong>Comment:</strong> Defines the collective pitch at the interval position 3 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.</p>   </td>
 <td>[-1, 1] (0.1)</td>
 <td>0.325</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_PITCH_C4">CA_HELI_PITCH_C4</strong> (FLOAT)</td>
 <td>Collective pitch curve at position 4 <p><strong>Comment:</strong> Defines the collective pitch at the interval position 4 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.</p>   </td>
 <td>[-1, 1] (0.1)</td>
 <td>0.45</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_THR_C0">CA_HELI_THR_C0</strong> (FLOAT)</td>
 <td>Throttle curve at position 0 <p><strong>Comment:</strong> Defines the output throttle at the interval position 0.</p>   </td>
 <td>[0, 1] (0.1)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_THR_C1">CA_HELI_THR_C1</strong> (FLOAT)</td>
 <td>Throttle curve at position 1 <p><strong>Comment:</strong> Defines the output throttle at the interval position 1.</p>   </td>
 <td>[0, 1] (0.1)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_THR_C2">CA_HELI_THR_C2</strong> (FLOAT)</td>
 <td>Throttle curve at position 2 <p><strong>Comment:</strong> Defines the output throttle at the interval position 2.</p>   </td>
 <td>[0, 1] (0.1)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_THR_C3">CA_HELI_THR_C3</strong> (FLOAT)</td>
 <td>Throttle curve at position 3 <p><strong>Comment:</strong> Defines the output throttle at the interval position 3.</p>   </td>
 <td>[0, 1] (0.1)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_THR_C4">CA_HELI_THR_C4</strong> (FLOAT)</td>
 <td>Throttle curve at position 4 <p><strong>Comment:</strong> Defines the output throttle at the interval position 4.</p>   </td>
 <td>[0, 1] (0.1)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_YAW_CCW">CA_HELI_YAW_CCW</strong> (INT32)</td>
 <td>Main rotor turns counter-clockwise <p><strong>Comment:</strong> Default configuration is for a clockwise turning main rotor and positive thrust of the tail rotor is expected to rotate the vehicle clockwise. Set this parameter to true if the tail rotor provides thrust in counter-clockwise direction which is mostly the case when the main rotor turns counter-clockwise.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_YAW_CP_O">CA_HELI_YAW_CP_O</strong> (FLOAT)</td>
 <td>Offset for yaw compensation based on collective pitch <p><strong>Comment:</strong> This allows to specify which collective pitch command results in the least amount of rotor drag. This is used to increase the accuracy of the yaw drag torque compensation based on collective pitch by aligning the lowest rotor drag with zero compensation. For symmetric profile blades this is the command that results in exactly 0° collective blade angle. For lift profile blades this is typically a command resulting in slightly negative collective blade angle. tail_output += CA_HELI_YAW_CP_S * abs(collective_pitch - CA_HELI_YAW_CP_O)</p>   </td>
 <td>[-2, 2] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_YAW_CP_S">CA_HELI_YAW_CP_S</strong> (FLOAT)</td>
 <td>Scale for yaw compensation based on collective pitch <p><strong>Comment:</strong> This allows to add a proportional factor of the collective pitch command to the yaw command. A negative value is needed when positive thrust of the tail rotor rotates the vehicle opposite to the main rotor turn direction. tail_output += CA_HELI_YAW_CP_S * abs(collective_pitch - CA_HELI_YAW_CP_O)</p>   </td>
 <td>[-2, 2] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_HELI_YAW_TH_S">CA_HELI_YAW_TH_S</strong> (FLOAT)</td>
 <td>Scale for yaw compensation based on throttle <p><strong>Comment:</strong> This allows to add a proportional factor of the throttle command to the yaw command. A negative value is needed when positive thrust of the tail rotor rotates the vehicle opposite to the main rotor turn direction. tail_output += CA_HELI_YAW_TH_S * throttle</p>   </td>
 <td>[-2, 2] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_METHOD">CA_METHOD</strong> (INT32)</td>
 <td>Control allocation method <p><strong>Comment:</strong> Selects the algorithm and desaturation method. If set to Automtic, the selection is based on the airframe (CA_AIRFRAME).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Pseudo-inverse with output clipping</li>
<li><strong>1:</strong> Pseudo-inverse with sequential desaturation technique</li>
<li><strong>2:</strong> Automatic</li>
</ul>  </td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R0_SLEW">CA_R0_SLEW</strong> (FLOAT)</td>
 <td>Motor 0 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R10_SLEW">CA_R10_SLEW</strong> (FLOAT)</td>
 <td>Motor 10 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R11_SLEW">CA_R11_SLEW</strong> (FLOAT)</td>
 <td>Motor 11 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R1_SLEW">CA_R1_SLEW</strong> (FLOAT)</td>
 <td>Motor 1 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R2_SLEW">CA_R2_SLEW</strong> (FLOAT)</td>
 <td>Motor 2 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R3_SLEW">CA_R3_SLEW</strong> (FLOAT)</td>
 <td>Motor 3 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R4_SLEW">CA_R4_SLEW</strong> (FLOAT)</td>
 <td>Motor 4 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R5_SLEW">CA_R5_SLEW</strong> (FLOAT)</td>
 <td>Motor 5 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R6_SLEW">CA_R6_SLEW</strong> (FLOAT)</td>
 <td>Motor 6 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R7_SLEW">CA_R7_SLEW</strong> (FLOAT)</td>
 <td>Motor 7 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R8_SLEW">CA_R8_SLEW</strong> (FLOAT)</td>
 <td>Motor 8 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R9_SLEW">CA_R9_SLEW</strong> (FLOAT)</td>
 <td>Motor 9 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through the full output range. A value x means that the motor signal can only go from 0 to 1 in minimum x seconds (in case of reversible motors, the range is -1 to 1). Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_AX">CA_ROTOR0_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 0 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_AY">CA_ROTOR0_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 0 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_AZ">CA_ROTOR0_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 0 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_CT">CA_ROTOR0_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 0 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_KM">CA_ROTOR0_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 0 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_PX">CA_ROTOR0_PX</strong> (FLOAT)</td>
 <td>Position of rotor 0 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_PY">CA_ROTOR0_PY</strong> (FLOAT)</td>
 <td>Position of rotor 0 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_PZ">CA_ROTOR0_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 0 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR0_TILT">CA_ROTOR0_TILT</strong> (INT32)</td>
 <td>Rotor 0 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_AX">CA_ROTOR10_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 10 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_AY">CA_ROTOR10_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 10 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_AZ">CA_ROTOR10_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 10 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_CT">CA_ROTOR10_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 10 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_KM">CA_ROTOR10_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 10 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_PX">CA_ROTOR10_PX</strong> (FLOAT)</td>
 <td>Position of rotor 10 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_PY">CA_ROTOR10_PY</strong> (FLOAT)</td>
 <td>Position of rotor 10 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_PZ">CA_ROTOR10_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 10 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR10_TILT">CA_ROTOR10_TILT</strong> (INT32)</td>
 <td>Rotor 10 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_AX">CA_ROTOR11_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 11 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_AY">CA_ROTOR11_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 11 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_AZ">CA_ROTOR11_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 11 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_CT">CA_ROTOR11_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 11 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_KM">CA_ROTOR11_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 11 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_PX">CA_ROTOR11_PX</strong> (FLOAT)</td>
 <td>Position of rotor 11 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_PY">CA_ROTOR11_PY</strong> (FLOAT)</td>
 <td>Position of rotor 11 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_PZ">CA_ROTOR11_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 11 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR11_TILT">CA_ROTOR11_TILT</strong> (INT32)</td>
 <td>Rotor 11 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_AX">CA_ROTOR1_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 1 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_AY">CA_ROTOR1_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 1 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_AZ">CA_ROTOR1_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 1 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_CT">CA_ROTOR1_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 1 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_KM">CA_ROTOR1_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 1 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_PX">CA_ROTOR1_PX</strong> (FLOAT)</td>
 <td>Position of rotor 1 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_PY">CA_ROTOR1_PY</strong> (FLOAT)</td>
 <td>Position of rotor 1 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_PZ">CA_ROTOR1_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 1 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR1_TILT">CA_ROTOR1_TILT</strong> (INT32)</td>
 <td>Rotor 1 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_AX">CA_ROTOR2_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 2 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_AY">CA_ROTOR2_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 2 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_AZ">CA_ROTOR2_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 2 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_CT">CA_ROTOR2_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 2 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_KM">CA_ROTOR2_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 2 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_PX">CA_ROTOR2_PX</strong> (FLOAT)</td>
 <td>Position of rotor 2 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_PY">CA_ROTOR2_PY</strong> (FLOAT)</td>
 <td>Position of rotor 2 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_PZ">CA_ROTOR2_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 2 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR2_TILT">CA_ROTOR2_TILT</strong> (INT32)</td>
 <td>Rotor 2 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_AX">CA_ROTOR3_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 3 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_AY">CA_ROTOR3_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 3 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_AZ">CA_ROTOR3_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 3 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_CT">CA_ROTOR3_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 3 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_KM">CA_ROTOR3_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 3 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_PX">CA_ROTOR3_PX</strong> (FLOAT)</td>
 <td>Position of rotor 3 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_PY">CA_ROTOR3_PY</strong> (FLOAT)</td>
 <td>Position of rotor 3 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_PZ">CA_ROTOR3_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 3 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR3_TILT">CA_ROTOR3_TILT</strong> (INT32)</td>
 <td>Rotor 3 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_AX">CA_ROTOR4_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 4 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_AY">CA_ROTOR4_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 4 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_AZ">CA_ROTOR4_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 4 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_CT">CA_ROTOR4_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 4 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_KM">CA_ROTOR4_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 4 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_PX">CA_ROTOR4_PX</strong> (FLOAT)</td>
 <td>Position of rotor 4 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_PY">CA_ROTOR4_PY</strong> (FLOAT)</td>
 <td>Position of rotor 4 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_PZ">CA_ROTOR4_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 4 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR4_TILT">CA_ROTOR4_TILT</strong> (INT32)</td>
 <td>Rotor 4 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_AX">CA_ROTOR5_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 5 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_AY">CA_ROTOR5_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 5 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_AZ">CA_ROTOR5_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 5 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_CT">CA_ROTOR5_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 5 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_KM">CA_ROTOR5_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 5 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_PX">CA_ROTOR5_PX</strong> (FLOAT)</td>
 <td>Position of rotor 5 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_PY">CA_ROTOR5_PY</strong> (FLOAT)</td>
 <td>Position of rotor 5 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_PZ">CA_ROTOR5_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 5 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR5_TILT">CA_ROTOR5_TILT</strong> (INT32)</td>
 <td>Rotor 5 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_AX">CA_ROTOR6_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 6 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_AY">CA_ROTOR6_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 6 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_AZ">CA_ROTOR6_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 6 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_CT">CA_ROTOR6_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 6 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_KM">CA_ROTOR6_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 6 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_PX">CA_ROTOR6_PX</strong> (FLOAT)</td>
 <td>Position of rotor 6 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_PY">CA_ROTOR6_PY</strong> (FLOAT)</td>
 <td>Position of rotor 6 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_PZ">CA_ROTOR6_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 6 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR6_TILT">CA_ROTOR6_TILT</strong> (INT32)</td>
 <td>Rotor 6 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_AX">CA_ROTOR7_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 7 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_AY">CA_ROTOR7_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 7 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_AZ">CA_ROTOR7_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 7 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_CT">CA_ROTOR7_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 7 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_KM">CA_ROTOR7_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 7 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_PX">CA_ROTOR7_PX</strong> (FLOAT)</td>
 <td>Position of rotor 7 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_PY">CA_ROTOR7_PY</strong> (FLOAT)</td>
 <td>Position of rotor 7 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_PZ">CA_ROTOR7_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 7 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR7_TILT">CA_ROTOR7_TILT</strong> (INT32)</td>
 <td>Rotor 7 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_AX">CA_ROTOR8_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 8 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_AY">CA_ROTOR8_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 8 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_AZ">CA_ROTOR8_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 8 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_CT">CA_ROTOR8_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 8 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_KM">CA_ROTOR8_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 8 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_PX">CA_ROTOR8_PX</strong> (FLOAT)</td>
 <td>Position of rotor 8 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_PY">CA_ROTOR8_PY</strong> (FLOAT)</td>
 <td>Position of rotor 8 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_PZ">CA_ROTOR8_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 8 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR8_TILT">CA_ROTOR8_TILT</strong> (INT32)</td>
 <td>Rotor 8 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_AX">CA_ROTOR9_AX</strong> (FLOAT)</td>
 <td>Axis of rotor 9 thrust vector, X body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_AY">CA_ROTOR9_AY</strong> (FLOAT)</td>
 <td>Axis of rotor 9 thrust vector, Y body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_AZ">CA_ROTOR9_AZ</strong> (FLOAT)</td>
 <td>Axis of rotor 9 thrust vector, Z body axis component <p><strong>Comment:</strong> Only the direction is considered (the vector is normalized).</p>   </td>
 <td>[-100, 100] (0.1)</td>
 <td>-1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_CT">CA_ROTOR9_CT</strong> (FLOAT)</td>
 <td>Thrust coefficient of rotor 9 <p><strong>Comment:</strong> The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.</p>   </td>
 <td>[0, 100] (1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_KM">CA_ROTOR9_KM</strong> (FLOAT)</td>
 <td>Moment coefficient of rotor 9 <p><strong>Comment:</strong> The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.</p>   </td>
 <td>[-1, 1] (0.01)</td>
 <td>0.05</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_PX">CA_ROTOR9_PX</strong> (FLOAT)</td>
 <td>Position of rotor 9 along X body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_PY">CA_ROTOR9_PY</strong> (FLOAT)</td>
 <td>Position of rotor 9 along Y body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_PZ">CA_ROTOR9_PZ</strong> (FLOAT)</td>
 <td>Position of rotor 9 along Z body axis relative to center of gravity    </td>
 <td>[-100, 100] (0.1)</td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CA_ROTOR9_TILT">CA_ROTOR9_TILT</strong> (INT32)</td>
 <td>Rotor 9 tilt assignment <p><strong>Comment:</strong> If not set to None, this motor is tilted by the configured tilt servo.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Tilt 1</li>
<li><strong>2:</strong> Tilt 2</li>
<li><strong>3:</strong> Tilt 3</li>
<li><strong>4:</strong> Tilt 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_ROTOR_COUNT">CA_ROTOR_COUNT</strong> (INT32)</td>
 <td>Total number of rotors  <strong>Values:</strong><ul>
<li><strong>0:</strong> 0</li>
<li><strong>1:</strong> 1</li>
<li><strong>2:</strong> 2</li>
<li><strong>3:</strong> 3</li>
<li><strong>4:</strong> 4</li>
<li><strong>5:</strong> 5</li>
<li><strong>6:</strong> 6</li>
<li><strong>7:</strong> 7</li>
<li><strong>8:</strong> 8</li>
<li><strong>9:</strong> 9</li>
<li><strong>10:</strong> 10</li>
<li><strong>11:</strong> 11</li>
<li><strong>12:</strong> 12</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_R_REV">CA_R_REV</strong> (INT32)</td>
 <td>Bidirectional/Reversible motors <p><strong>Comment:</strong> Configure motors to be bidirectional/reversible. Note that the output driver needs to support this as well.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Motor 1</li>
  <li><strong>1:</strong> Motor 2</li>
  <li><strong>2:</strong> Motor 3</li>
  <li><strong>3:</strong> Motor 4</li>
  <li><strong>4:</strong> Motor 5</li>
  <li><strong>5:</strong> Motor 6</li>
  <li><strong>6:</strong> Motor 7</li>
  <li><strong>7:</strong> Motor 8</li>
  <li><strong>8:</strong> Motor 9</li>
  <li><strong>9:</strong> Motor 10</li>
  <li><strong>10:</strong> Motor 11</li>
  <li><strong>11:</strong> Motor 12</li>
</ul>
 </td>
 <td>[0, 4095] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SP0_ANG0">CA_SP0_ANG0</strong> (FLOAT)</td>
 <td>Angle for swash plate servo 0 <p><strong>Comment:</strong> The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).</p>   </td>
 <td>[0, 360] (10)</td>
 <td>0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SP0_ANG1">CA_SP0_ANG1</strong> (FLOAT)</td>
 <td>Angle for swash plate servo 1 <p><strong>Comment:</strong> The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).</p>   </td>
 <td>[0, 360] (10)</td>
 <td>140</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SP0_ANG2">CA_SP0_ANG2</strong> (FLOAT)</td>
 <td>Angle for swash plate servo 2 <p><strong>Comment:</strong> The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).</p>   </td>
 <td>[0, 360] (10)</td>
 <td>220</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SP0_ANG3">CA_SP0_ANG3</strong> (FLOAT)</td>
 <td>Angle for swash plate servo 3 <p><strong>Comment:</strong> The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).</p>   </td>
 <td>[0, 360] (10)</td>
 <td>0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SP0_ARM_L0">CA_SP0_ARM_L0</strong> (FLOAT)</td>
 <td>Arm length for swash plate servo 0 <p><strong>Comment:</strong> This is relative to the other arm lengths.</p>   </td>
 <td>[0, 10] (0.1)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SP0_ARM_L1">CA_SP0_ARM_L1</strong> (FLOAT)</td>
 <td>Arm length for swash plate servo 1 <p><strong>Comment:</strong> This is relative to the other arm lengths.</p>   </td>
 <td>[0, 10] (0.1)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SP0_ARM_L2">CA_SP0_ARM_L2</strong> (FLOAT)</td>
 <td>Arm length for swash plate servo 2 <p><strong>Comment:</strong> This is relative to the other arm lengths.</p>   </td>
 <td>[0, 10] (0.1)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SP0_ARM_L3">CA_SP0_ARM_L3</strong> (FLOAT)</td>
 <td>Arm length for swash plate servo 3 <p><strong>Comment:</strong> This is relative to the other arm lengths.</p>   </td>
 <td>[0, 10] (0.1)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SP0_COUNT">CA_SP0_COUNT</strong> (INT32)</td>
 <td>Number of swash plates servos  <strong>Values:</strong><ul>
<li><strong>2:</strong> 2</li>
<li><strong>3:</strong> 3</li>
<li><strong>4:</strong> 4</li>
</ul>  </td>
 <td></td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV0_SLEW">CA_SV0_SLEW</strong> (FLOAT)</td>
 <td>Servo 0 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV1_SLEW">CA_SV1_SLEW</strong> (FLOAT)</td>
 <td>Servo 1 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV2_SLEW">CA_SV2_SLEW</strong> (FLOAT)</td>
 <td>Servo 2 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV3_SLEW">CA_SV3_SLEW</strong> (FLOAT)</td>
 <td>Servo 3 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV4_SLEW">CA_SV4_SLEW</strong> (FLOAT)</td>
 <td>Servo 4 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV5_SLEW">CA_SV5_SLEW</strong> (FLOAT)</td>
 <td>Servo 5 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV6_SLEW">CA_SV6_SLEW</strong> (FLOAT)</td>
 <td>Servo 6 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV7_SLEW">CA_SV7_SLEW</strong> (FLOAT)</td>
 <td>Servo 7 slew rate limit <p><strong>Comment:</strong> Minimum time allowed for the servo input signal to pass through the full output range. A value x means that the servo signal can only go from -1 to 1 in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0, 10] (0.05)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_FLAP">CA_SV_CS0_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 0 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_SPOIL">CA_SV_CS0_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 0 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_TRIM">CA_SV_CS0_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 0 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_TRQ_P">CA_SV_CS0_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 0 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_TRQ_R">CA_SV_CS0_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 0 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_TRQ_Y">CA_SV_CS0_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 0 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS0_TYPE">CA_SV_CS0_TYPE</strong> (INT32)</td>
 <td>Control Surface 0 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_FLAP">CA_SV_CS1_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 1 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_SPOIL">CA_SV_CS1_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 1 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_TRIM">CA_SV_CS1_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 1 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_TRQ_P">CA_SV_CS1_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 1 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_TRQ_R">CA_SV_CS1_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 1 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_TRQ_Y">CA_SV_CS1_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 1 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS1_TYPE">CA_SV_CS1_TYPE</strong> (INT32)</td>
 <td>Control Surface 1 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_FLAP">CA_SV_CS2_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 2 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_SPOIL">CA_SV_CS2_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 2 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_TRIM">CA_SV_CS2_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 2 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_TRQ_P">CA_SV_CS2_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 2 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_TRQ_R">CA_SV_CS2_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 2 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_TRQ_Y">CA_SV_CS2_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 2 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS2_TYPE">CA_SV_CS2_TYPE</strong> (INT32)</td>
 <td>Control Surface 2 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_FLAP">CA_SV_CS3_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 3 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_SPOIL">CA_SV_CS3_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 3 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_TRIM">CA_SV_CS3_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 3 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_TRQ_P">CA_SV_CS3_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 3 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_TRQ_R">CA_SV_CS3_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 3 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_TRQ_Y">CA_SV_CS3_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 3 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS3_TYPE">CA_SV_CS3_TYPE</strong> (INT32)</td>
 <td>Control Surface 3 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_FLAP">CA_SV_CS4_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 4 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_SPOIL">CA_SV_CS4_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 4 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_TRIM">CA_SV_CS4_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 4 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_TRQ_P">CA_SV_CS4_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 4 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_TRQ_R">CA_SV_CS4_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 4 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_TRQ_Y">CA_SV_CS4_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 4 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS4_TYPE">CA_SV_CS4_TYPE</strong> (INT32)</td>
 <td>Control Surface 4 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_FLAP">CA_SV_CS5_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 5 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_SPOIL">CA_SV_CS5_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 5 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_TRIM">CA_SV_CS5_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 5 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_TRQ_P">CA_SV_CS5_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 5 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_TRQ_R">CA_SV_CS5_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 5 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_TRQ_Y">CA_SV_CS5_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 5 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS5_TYPE">CA_SV_CS5_TYPE</strong> (INT32)</td>
 <td>Control Surface 5 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_FLAP">CA_SV_CS6_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 6 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_SPOIL">CA_SV_CS6_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 6 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_TRIM">CA_SV_CS6_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 6 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_TRQ_P">CA_SV_CS6_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 6 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_TRQ_R">CA_SV_CS6_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 6 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_TRQ_Y">CA_SV_CS6_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 6 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS6_TYPE">CA_SV_CS6_TYPE</strong> (INT32)</td>
 <td>Control Surface 6 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_FLAP">CA_SV_CS7_FLAP</strong> (FLOAT)</td>
 <td>Control Surface 7 configuration as flap    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_SPOIL">CA_SV_CS7_SPOIL</strong> (FLOAT)</td>
 <td>Control Surface 7 configuration as spoiler    </td>
 <td>[-1.0, 1.0] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_TRIM">CA_SV_CS7_TRIM</strong> (FLOAT)</td>
 <td>Control Surface 7 trim <p><strong>Comment:</strong> Can be used to add an offset to the servo control.</p>   </td>
 <td>[-1.0, 1.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_TRQ_P">CA_SV_CS7_TRQ_P</strong> (FLOAT)</td>
 <td>Control Surface 7 pitch torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_TRQ_R">CA_SV_CS7_TRQ_R</strong> (FLOAT)</td>
 <td>Control Surface 7 roll torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_TRQ_Y">CA_SV_CS7_TRQ_Y</strong> (FLOAT)</td>
 <td>Control Surface 7 yaw torque scaling    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS7_TYPE">CA_SV_CS7_TYPE</strong> (INT32)</td>
 <td>Control Surface 7 type  <strong>Values:</strong><ul>
<li><strong>0:</strong> (Not set)</li>
<li><strong>1:</strong> Left Aileron</li>
<li><strong>2:</strong> Right Aileron</li>
<li><strong>3:</strong> Elevator</li>
<li><strong>4:</strong> Rudder</li>
<li><strong>5:</strong> Left Elevon</li>
<li><strong>6:</strong> Right Elevon</li>
<li><strong>7:</strong> Left V-Tail</li>
<li><strong>8:</strong> Right V-Tail</li>
<li><strong>9:</strong> Left Flap</li>
<li><strong>10:</strong> Right Flap</li>
<li><strong>11:</strong> Airbrake</li>
<li><strong>12:</strong> Custom</li>
<li><strong>13:</strong> Left A-tail</li>
<li><strong>14:</strong> Right A-tail</li>
<li><strong>15:</strong> Single Channel Aileron</li>
<li><strong>16:</strong> Steering Wheel</li>
<li><strong>17:</strong> Left Spoiler</li>
<li><strong>18:</strong> Right Spoiler</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_CS_COUNT">CA_SV_CS_COUNT</strong> (INT32)</td>
 <td>Total number of Control Surfaces  <strong>Values:</strong><ul>
<li><strong>0:</strong> 0</li>
<li><strong>1:</strong> 1</li>
<li><strong>2:</strong> 2</li>
<li><strong>3:</strong> 3</li>
<li><strong>4:</strong> 4</li>
<li><strong>5:</strong> 5</li>
<li><strong>6:</strong> 6</li>
<li><strong>7:</strong> 7</li>
<li><strong>8:</strong> 8</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL0_CT">CA_SV_TL0_CT</strong> (INT32)</td>
 <td>Tilt 0 is used for control <p><strong>Comment:</strong> Define if this servo is used for additional control.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Yaw</li>
<li><strong>2:</strong> Pitch</li>
<li><strong>3:</strong> Yaw and Pitch</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL0_MAXA">CA_SV_TL0_MAXA</strong> (FLOAT)</td>
 <td>Tilt Servo 0 Tilt Angle at Maximum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL0_MINA">CA_SV_TL0_MINA</strong> (FLOAT)</td>
 <td>Tilt Servo 0 Tilt Angle at Minimum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL0_TD">CA_SV_TL0_TD</strong> (INT32)</td>
 <td>Tilt Servo 0 Tilt Direction <p><strong>Comment:</strong> Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction &#x27;Towards Front&#x27;, the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Towards Front</li>
<li><strong>90:</strong> Towards Right</li>
</ul>  </td>
 <td>[0, 359] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL1_CT">CA_SV_TL1_CT</strong> (INT32)</td>
 <td>Tilt 1 is used for control <p><strong>Comment:</strong> Define if this servo is used for additional control.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Yaw</li>
<li><strong>2:</strong> Pitch</li>
<li><strong>3:</strong> Yaw and Pitch</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL1_MAXA">CA_SV_TL1_MAXA</strong> (FLOAT)</td>
 <td>Tilt Servo 1 Tilt Angle at Maximum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL1_MINA">CA_SV_TL1_MINA</strong> (FLOAT)</td>
 <td>Tilt Servo 1 Tilt Angle at Minimum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL1_TD">CA_SV_TL1_TD</strong> (INT32)</td>
 <td>Tilt Servo 1 Tilt Direction <p><strong>Comment:</strong> Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction &#x27;Towards Front&#x27;, the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Towards Front</li>
<li><strong>90:</strong> Towards Right</li>
</ul>  </td>
 <td>[0, 359] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL2_CT">CA_SV_TL2_CT</strong> (INT32)</td>
 <td>Tilt 2 is used for control <p><strong>Comment:</strong> Define if this servo is used for additional control.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Yaw</li>
<li><strong>2:</strong> Pitch</li>
<li><strong>3:</strong> Yaw and Pitch</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL2_MAXA">CA_SV_TL2_MAXA</strong> (FLOAT)</td>
 <td>Tilt Servo 2 Tilt Angle at Maximum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL2_MINA">CA_SV_TL2_MINA</strong> (FLOAT)</td>
 <td>Tilt Servo 2 Tilt Angle at Minimum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL2_TD">CA_SV_TL2_TD</strong> (INT32)</td>
 <td>Tilt Servo 2 Tilt Direction <p><strong>Comment:</strong> Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction &#x27;Towards Front&#x27;, the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Towards Front</li>
<li><strong>90:</strong> Towards Right</li>
</ul>  </td>
 <td>[0, 359] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL3_CT">CA_SV_TL3_CT</strong> (INT32)</td>
 <td>Tilt 3 is used for control <p><strong>Comment:</strong> Define if this servo is used for additional control.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> Yaw</li>
<li><strong>2:</strong> Pitch</li>
<li><strong>3:</strong> Yaw and Pitch</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL3_MAXA">CA_SV_TL3_MAXA</strong> (FLOAT)</td>
 <td>Tilt Servo 3 Tilt Angle at Maximum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL3_MINA">CA_SV_TL3_MINA</strong> (FLOAT)</td>
 <td>Tilt Servo 3 Tilt Angle at Minimum <p><strong>Comment:</strong> Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.</p>   </td>
 <td>[-90.0, 90.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CA_SV_TL3_TD">CA_SV_TL3_TD</strong> (INT32)</td>
 <td>Tilt Servo 3 Tilt Direction <p><strong>Comment:</strong> Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction &#x27;Towards Front&#x27;, the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Towards Front</li>
<li><strong>90:</strong> Towards Right</li>
</ul>  </td>
 <td>[0, 359] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CA_SV_TL_COUNT">CA_SV_TL_COUNT</strong> (INT32)</td>
 <td>Total number of Tilt Servos  <strong>Values:</strong><ul>
<li><strong>0:</strong> 0</li>
<li><strong>1:</strong> 1</li>
<li><strong>2:</strong> 2</li>
<li><strong>3:</strong> 3</li>
<li><strong>4:</strong> 4</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Hover Thrust Estimator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="HTE_ACC_GATE">HTE_ACC_GATE</strong> (FLOAT)</td>
 <td>Gate size for acceleration fusion <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[1.0, 10.0] </td>
 <td>3.0</td>
 <td>SD</td>
</tr>
<tr>
 <td><strong id="HTE_HT_ERR_INIT">HTE_HT_ERR_INIT</strong> (FLOAT)</td>
 <td>1-sigma initial hover thrust uncertainty <p><strong>Comment:</strong> Sets the number of standard deviations used by the innovation consistency test.</p>   </td>
 <td>[0.0, 1.0] </td>
 <td>0.1</td>
 <td>normalized_thrust</td>
</tr>
<tr>
 <td><strong id="HTE_HT_NOISE">HTE_HT_NOISE</strong> (FLOAT)</td>
 <td>Hover thrust process noise <p><strong>Comment:</strong> Reduce to make the hover thrust estimate more stable, increase if the real hover thrust is expected to change quickly over time.</p>   </td>
 <td>[0.0001, 1.0] </td>
 <td>0.0036</td>
 <td>normalized_thrust/s</td>
</tr>
<tr>
 <td><strong id="HTE_THR_RANGE">HTE_THR_RANGE</strong> (FLOAT)</td>
 <td>Max deviation from MPC_THR_HOVER <p><strong>Comment:</strong> Defines the range of the hover thrust estimate around MPC_THR_HOVER. A value of 0.2 with MPC_THR_HOVER at 0.5 results in a range of [0.3, 0.7]. Set to a large value if the vehicle operates in varying physical conditions that affect the required hover thrust strongly (e.g. differently sized payloads).</p>   </td>
 <td>[0.01, 0.4] </td>
 <td>0.2</td>
 <td>normalized_thrust</td>
</tr>
<tr>
 <td><strong id="HTE_VXY_THR">HTE_VXY_THR</strong> (FLOAT)</td>
 <td>Horizontal velocity threshold for sensitivity reduction <p><strong>Comment:</strong> Above this speed, the measurement noise is linearly increased to reduce the sensitivity of the estimator from biased measurement. Set to a low value on vehicles with large lifting surfaces.</p>   </td>
 <td>[1.0, 20.0] </td>
 <td>10.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="HTE_VZ_THR">HTE_VZ_THR</strong> (FLOAT)</td>
 <td>Vertical velocity threshold for sensitivity reduction <p><strong>Comment:</strong> Above this speed, the measurement noise is linearly increased to reduce the sensitivity of the estimator from biased measurement. Set to a low value on vehicles affected by air drag when climbing or descending.</p>   </td>
 <td>[1.0, 10.0] </td>
 <td>2.0</td>
 <td>m/s</td>
</tr>
</tbody></table>

## Iridium SBD

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ISBD_CONFIG">ISBD_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for Iridium (with MAVLink) <p><strong>Comment:</strong> Configure on which serial port to run Iridium (with MAVLink).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="ISBD_READ_INT">ISBD_READ_INT</strong> (INT32)</td>
 <td>Satellite radio read interval. Only required to be nonzero if data is not sent using a ring call    </td>
 <td>[0, 5000] </td>
 <td>0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="ISBD_SBD_TIMEOUT">ISBD_SBD_TIMEOUT</strong> (INT32)</td>
 <td>Iridium SBD session timeout    </td>
 <td>[0, 300] </td>
 <td>60</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="ISBD_STACK_TIME">ISBD_STACK_TIME</strong> (INT32)</td>
 <td>Time the Iridium driver will wait for additional mavlink messages to combine them into one SBD message <p><strong>Comment:</strong> Value 0 turns the functionality off</p>   </td>
 <td>[0, 500] </td>
 <td>0</td>
 <td>ms</td>
</tr>
</tbody></table>

## Land Detector

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="LNDFW_AIRSPD_MAX">LNDFW_AIRSPD_MAX</strong> (FLOAT)</td>
 <td>Fixed-wing land detector: Max airspeed <p><strong>Comment:</strong> Maximum airspeed allowed in the landed state</p>   </td>
 <td>[2, 20] </td>
 <td>6.00</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LNDFW_TRIG_TIME">LNDFW_TRIG_TIME</strong> (FLOAT)</td>
 <td>Fixed-wing land detection trigger time <p><strong>Comment:</strong> Time the land conditions (speeds and acceleration) have to be satisfied to detect a landing.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0.1, ?] </td>
 <td>2.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="LNDFW_VEL_XY_MAX">LNDFW_VEL_XY_MAX</strong> (FLOAT)</td>
 <td>Fixed-wing land detector: Max horizontal velocity threshold <p><strong>Comment:</strong> Maximum horizontal velocity allowed in the landed state. A factor of 0.7 is applied in case of airspeed-less flying (either because no sensor is present or sensor data got invalid in flight).</p>   </td>
 <td>[0.5, 10] </td>
 <td>5.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LNDFW_VEL_Z_MAX">LNDFW_VEL_Z_MAX</strong> (FLOAT)</td>
 <td>Fixed-wing land detector: Max vertiacal velocity threshold <p><strong>Comment:</strong> Maximum vertical velocity allowed in the landed state.</p>   </td>
 <td>[0.1, 20] </td>
 <td>1.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LNDFW_XYACC_MAX">LNDFW_XYACC_MAX</strong> (FLOAT)</td>
 <td>Fixed-wing land detector: Max horizontal acceleration <p><strong>Comment:</strong> Maximum horizontal (x,y body axes) acceleration allowed in the landed state</p>   </td>
 <td>[2, 15] </td>
 <td>8.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="LNDMC_ALT_GND">LNDMC_ALT_GND</strong> (FLOAT)</td>
 <td>Ground effect altitude for multicopters <p><strong>Comment:</strong> The height above ground below which ground effect creates barometric altitude errors. A negative value indicates no ground effect.</p>   </td>
 <td>[-1, ?] </td>
 <td>2.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LNDMC_ROT_MAX">LNDMC_ROT_MAX</strong> (FLOAT)</td>
 <td>Multicopter max rotation <p><strong>Comment:</strong> Maximum allowed angular velocity around each axis allowed in the landed state.</p>   </td>
 <td></td>
 <td>20.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="LNDMC_TRIG_TIME">LNDMC_TRIG_TIME</strong> (FLOAT)</td>
 <td>Multicopter land detection trigger time <p><strong>Comment:</strong> Total time it takes to go through all three land detection stages: ground contact, maybe landed, landed when all necessary conditions are constantly met.</p>   </td>
 <td>[0.1, 10.0] </td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="LNDMC_XY_VEL_MAX">LNDMC_XY_VEL_MAX</strong> (FLOAT)</td>
 <td>Multicopter max horizontal velocity <p><strong>Comment:</strong> Maximum horizontal velocity allowed in the landed state</p>   </td>
 <td></td>
 <td>1.5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LNDMC_Z_VEL_MAX">LNDMC_Z_VEL_MAX</strong> (FLOAT)</td>
 <td>Multicopter vertical velocity threshold <p><strong>Comment:</strong> Vertical velocity threshold to detect landing. Has to be set lower than the expected minimal speed for landing, which is either MPC_LAND_SPEED or MPC_LAND_CRWL. This is enforced by an automatic check.</p>   </td>
 <td>[0, ?] </td>
 <td>0.25</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LND_FLIGHT_T_HI">LND_FLIGHT_T_HI</strong> (INT32)</td>
 <td>Total flight time in microseconds <p><strong>Comment:</strong> Total flight time of this autopilot. Higher 32 bits of the value. Flight time in microseconds = (LND_FLIGHT_T_HI &lt;&lt; 32) | LND_FLIGHT_T_LO.</p>   </td>
 <td>[0, ?] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LND_FLIGHT_T_LO">LND_FLIGHT_T_LO</strong> (INT32)</td>
 <td>Total flight time in microseconds <p><strong>Comment:</strong> Total flight time of this autopilot. Lower 32 bits of the value. Flight time in microseconds = (LND_FLIGHT_T_HI &lt;&lt; 32) | LND_FLIGHT_T_LO.</p>   </td>
 <td>[0, ?] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Landing Target Estimator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="LTEST_ACC_UNC">LTEST_ACC_UNC</strong> (FLOAT)</td>
 <td>Acceleration uncertainty <p><strong>Comment:</strong> Variance of acceleration measurement used for landing target position prediction. Higher values results in tighter following of the measurements and more lenient outlier rejection</p>   </td>
 <td>[0.01, ?] </td>
 <td>10.0</td>
 <td>(m/s^2)^2</td>
</tr>
<tr>
 <td><strong id="LTEST_MEAS_UNC">LTEST_MEAS_UNC</strong> (FLOAT)</td>
 <td>Landing target measurement uncertainty <p><strong>Comment:</strong> Variance of the landing target measurement from the driver. Higher values result in less aggressive following of the measurement and a smoother output as well as fewer rejected measurements.</p>   </td>
 <td></td>
 <td>0.005</td>
 <td>tan(rad)^2</td>
</tr>
<tr>
 <td><strong id="LTEST_MODE">LTEST_MODE</strong> (INT32)</td>
 <td>Landing target mode <p><strong>Comment:</strong> Configure the mode of the landing target. Depending on the mode, the landing target observations are used differently to aid position estimation. Mode Moving:     The landing target may be moving around while in the field of view of the vehicle. Landing target measurements are not used to aid positioning. Mode Stationary: The landing target is stationary. Measured velocity w.r.t. the landing target is used to aid velocity estimation.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Moving</li>
<li><strong>1:</strong> Stationary</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LTEST_POS_UNC_IN">LTEST_POS_UNC_IN</strong> (FLOAT)</td>
 <td>Initial landing target position uncertainty <p><strong>Comment:</strong> Initial variance of the relative landing target position in x and y direction</p>   </td>
 <td>[0.001, ?] </td>
 <td>0.1</td>
 <td>m^2</td>
</tr>
<tr>
 <td><strong id="LTEST_SCALE_X">LTEST_SCALE_X</strong> (FLOAT)</td>
 <td>Scale factor for sensor measurements in sensor x axis <p><strong>Comment:</strong> Landing target x measurements are scaled by this factor before being used</p>   </td>
 <td>[0.01, ?] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LTEST_SCALE_Y">LTEST_SCALE_Y</strong> (FLOAT)</td>
 <td>Scale factor for sensor measurements in sensor y axis <p><strong>Comment:</strong> Landing target y measurements are scaled by this factor before being used</p>   </td>
 <td>[0.01, ?] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LTEST_SENS_POS_X">LTEST_SENS_POS_X</strong> (FLOAT)</td>
 <td>X Position of IRLOCK in body frame (forward)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LTEST_SENS_POS_Y">LTEST_SENS_POS_Y</strong> (FLOAT)</td>
 <td>Y Position of IRLOCK in body frame (right)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LTEST_SENS_POS_Z">LTEST_SENS_POS_Z</strong> (FLOAT)</td>
 <td>Z Position of IRLOCK in body frame (downward)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LTEST_SENS_ROT">LTEST_SENS_ROT</strong> (INT32)</td>
 <td>Rotation of IRLOCK sensor relative to airframe <p><strong>Comment:</strong> Default orientation of Yaw 90°</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[-1, 40] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LTEST_VEL_UNC_IN">LTEST_VEL_UNC_IN</strong> (FLOAT)</td>
 <td>Initial landing target velocity uncertainty <p><strong>Comment:</strong> Initial variance of the relative landing target velocity in x and y directions</p>   </td>
 <td>[0.001, ?] </td>
 <td>0.1</td>
 <td>(m/s)^2</td>
</tr>
</tbody></table>

## Local Position Estimator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="LPE_ACC_XY">LPE_ACC_XY</strong> (FLOAT)</td>
 <td>Accelerometer xy noise density <p><strong>Comment:</strong> Data sheet noise density = 150ug/sqrt(Hz) = 0.0015 m/s^2/sqrt(Hz) Larger than data sheet to account for tilt error.</p>   </td>
 <td>[0.00001, 2] </td>
 <td>0.012</td>
 <td>m/s^2/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_ACC_Z">LPE_ACC_Z</strong> (FLOAT)</td>
 <td>Accelerometer z noise density <p><strong>Comment:</strong> Data sheet noise density = 150ug/sqrt(Hz) = 0.0015 m/s^2/sqrt(Hz)</p>   </td>
 <td>[0.00001, 2] </td>
 <td>0.02</td>
 <td>m/s^2/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_BAR_Z">LPE_BAR_Z</strong> (FLOAT)</td>
 <td>Barometric presssure altitude z standard deviation    </td>
 <td>[0.01, 100] </td>
 <td>3.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_EN">LPE_EN</strong> (INT32)</td>
 <td>Local position estimator enable (unsupported)    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LPE_EPH_MAX">LPE_EPH_MAX</strong> (FLOAT)</td>
 <td>Max EPH allowed for GPS initialization    </td>
 <td>[1.0, 5.0] </td>
 <td>3.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_EPV_MAX">LPE_EPV_MAX</strong> (FLOAT)</td>
 <td>Max EPV allowed for GPS initialization    </td>
 <td>[1.0, 5.0] </td>
 <td>5.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_FAKE_ORIGIN">LPE_FAKE_ORIGIN</strong> (INT32)</td>
 <td>Enable publishing of a fake global position (e.g for AUTO missions using Optical Flow) <p><strong>Comment:</strong> By initializing the estimator to the LPE_LAT/LON parameters when global information is unavailable</p>   </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LPE_FGYRO_HP">LPE_FGYRO_HP</strong> (FLOAT)</td>
 <td>Flow gyro high pass filter cut off frequency    </td>
 <td>[0, 2] </td>
 <td>0.001</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="LPE_FLW_OFF_Z">LPE_FLW_OFF_Z</strong> (FLOAT)</td>
 <td>Optical flow z offset from center    </td>
 <td>[-1, 1] </td>
 <td>0.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_FLW_QMIN">LPE_FLW_QMIN</strong> (INT32)</td>
 <td>Optical flow minimum quality threshold    </td>
 <td>[0, 255] </td>
 <td>150</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LPE_FLW_R">LPE_FLW_R</strong> (FLOAT)</td>
 <td>Optical flow rotation (roll/pitch) noise gain    </td>
 <td>[0.1, 10.0] </td>
 <td>7.0</td>
 <td>m/s/rad</td>
</tr>
<tr>
 <td><strong id="LPE_FLW_RR">LPE_FLW_RR</strong> (FLOAT)</td>
 <td>Optical flow angular velocity noise gain    </td>
 <td>[0.0, 10.0] </td>
 <td>7.0</td>
 <td>m/rad</td>
</tr>
<tr>
 <td><strong id="LPE_FLW_SCALE">LPE_FLW_SCALE</strong> (FLOAT)</td>
 <td>Optical flow scale    </td>
 <td>[0.1, 10.0] </td>
 <td>1.3</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_FUSION">LPE_FUSION</strong> (INT32)</td>
 <td>Integer bitmask controlling data fusion <p><strong>Comment:</strong> Set bits in the following positions to enable: 0 : Set to true to fuse GPS data if available, also requires GPS for altitude init 1 : Set to true to fuse optical flow data if available 2 : Set to true to fuse vision position 3 : Set to true to enable landing target 4 : Set to true to fuse land detector 5 : Set to true to publish AGL as local position down component 6 : Set to true to enable flow gyro compensation 7 : Set to true to enable baro fusion default (145 - GPS, baro, land detector)</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> fuse GPS, requires GPS for alt. init</li>
  <li><strong>1:</strong> fuse optical flow</li>
  <li><strong>2:</strong> fuse vision position</li>
  <li><strong>3:</strong> fuse landing target</li>
  <li><strong>4:</strong> fuse land detector</li>
  <li><strong>5:</strong> pub agl as lpos down</li>
  <li><strong>6:</strong> flow gyro compensation</li>
  <li><strong>7:</strong> fuse baro</li>
</ul>
 </td>
 <td>[0, 255] </td>
 <td>145</td>
 <td></td>
</tr>
<tr>
 <td><strong id="LPE_GPS_DELAY">LPE_GPS_DELAY</strong> (FLOAT)</td>
 <td>GPS delay compensaton    </td>
 <td>[0, 0.4] </td>
 <td>0.29</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="LPE_GPS_VXY">LPE_GPS_VXY</strong> (FLOAT)</td>
 <td>GPS xy velocity standard deviation <p><strong>Comment:</strong> EPV used if greater than this value.</p>   </td>
 <td>[0.01, 2] </td>
 <td>0.25</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LPE_GPS_VZ">LPE_GPS_VZ</strong> (FLOAT)</td>
 <td>GPS z velocity standard deviation    </td>
 <td>[0.01, 2] </td>
 <td>0.25</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LPE_GPS_XY">LPE_GPS_XY</strong> (FLOAT)</td>
 <td>Minimum GPS xy standard deviation, uses reported EPH if greater    </td>
 <td>[0.01, 5] </td>
 <td>1.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_GPS_Z">LPE_GPS_Z</strong> (FLOAT)</td>
 <td>Minimum GPS z standard deviation, uses reported EPV if greater    </td>
 <td>[0.01, 200] </td>
 <td>3.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_LAND_VXY">LPE_LAND_VXY</strong> (FLOAT)</td>
 <td>Land detector xy velocity standard deviation    </td>
 <td>[0.01, 10.0] </td>
 <td>0.05</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LPE_LAND_Z">LPE_LAND_Z</strong> (FLOAT)</td>
 <td>Land detector z standard deviation    </td>
 <td>[0.001, 10.0] </td>
 <td>0.03</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_LAT">LPE_LAT</strong> (FLOAT)</td>
 <td>Local origin latitude for nav w/o GPS    </td>
 <td>[-90, 90] </td>
 <td>47.397742</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="LPE_LDR_OFF_Z">LPE_LDR_OFF_Z</strong> (FLOAT)</td>
 <td>Lidar z offset from center of vehicle +down    </td>
 <td>[-1, 1] </td>
 <td>0.00</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_LDR_Z">LPE_LDR_Z</strong> (FLOAT)</td>
 <td>Lidar z standard deviation    </td>
 <td>[0.01, 1] </td>
 <td>0.03</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_LON">LPE_LON</strong> (FLOAT)</td>
 <td>Local origin longitude for nav w/o GPS    </td>
 <td>[-180, 180] </td>
 <td>8.545594</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="LPE_LT_COV">LPE_LT_COV</strong> (FLOAT)</td>
 <td>Minimum landing target standard covariance, uses reported covariance if greater    </td>
 <td>[0.0, 10] </td>
 <td>0.0001</td>
 <td>m^2</td>
</tr>
<tr>
 <td><strong id="LPE_PN_B">LPE_PN_B</strong> (FLOAT)</td>
 <td>Accel bias propagation noise density    </td>
 <td>[0, 1] </td>
 <td>1e-3</td>
 <td>m/s^3/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_PN_P">LPE_PN_P</strong> (FLOAT)</td>
 <td>Position propagation noise density <p><strong>Comment:</strong> Increase to trust measurements more. Decrease to trust model more.</p>   </td>
 <td>[0, 1] </td>
 <td>0.1</td>
 <td>m/s/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_PN_T">LPE_PN_T</strong> (FLOAT)</td>
 <td>Terrain random walk noise density, hilly/outdoor (0.1), flat/Indoor (0.001)    </td>
 <td>[0, 1] </td>
 <td>0.001</td>
 <td>m/s/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_PN_V">LPE_PN_V</strong> (FLOAT)</td>
 <td>Velocity propagation noise density <p><strong>Comment:</strong> Increase to trust measurements more. Decrease to trust model more.</p>   </td>
 <td>[0, 1] </td>
 <td>0.1</td>
 <td>m/s^2/sqrt(Hz)</td>
</tr>
<tr>
 <td><strong id="LPE_SNR_OFF_Z">LPE_SNR_OFF_Z</strong> (FLOAT)</td>
 <td>Sonar z offset from center of vehicle +down    </td>
 <td>[-1, 1] </td>
 <td>0.00</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_SNR_Z">LPE_SNR_Z</strong> (FLOAT)</td>
 <td>Sonar z standard deviation    </td>
 <td>[0.01, 1] </td>
 <td>0.05</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_T_MAX_GRADE">LPE_T_MAX_GRADE</strong> (FLOAT)</td>
 <td>Terrain maximum percent grade, hilly/outdoor (100 = 45 deg), flat/Indoor (0 = 0 deg) <p><strong>Comment:</strong> Used to calculate increased terrain random walk nosie due to movement.</p>   </td>
 <td>[0, 100] </td>
 <td>1.0</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="LPE_VIC_P">LPE_VIC_P</strong> (FLOAT)</td>
 <td>Vicon position standard deviation    </td>
 <td>[0.0001, 1] </td>
 <td>0.001</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_VIS_DELAY">LPE_VIS_DELAY</strong> (FLOAT)</td>
 <td>Vision delay compensation <p><strong>Comment:</strong> Set to zero to enable automatic compensation from measurement timestamps</p>   </td>
 <td>[0, 0.1] </td>
 <td>0.1</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="LPE_VIS_XY">LPE_VIS_XY</strong> (FLOAT)</td>
 <td>Vision xy standard deviation    </td>
 <td>[0.01, 1] </td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_VIS_Z">LPE_VIS_Z</strong> (FLOAT)</td>
 <td>Vision z standard deviation    </td>
 <td>[0.01, 100] </td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="LPE_VXY_PUB">LPE_VXY_PUB</strong> (FLOAT)</td>
 <td>Required velocity xy standard deviation to publish position    </td>
 <td>[0.01, 1.0] </td>
 <td>0.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="LPE_X_LP">LPE_X_LP</strong> (FLOAT)</td>
 <td>Cut frequency for state publication    </td>
 <td>[5, 1000] </td>
 <td>5.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="LPE_Z_PUB">LPE_Z_PUB</strong> (FLOAT)</td>
 <td>Required z standard deviation to publish altitude/ terrain    </td>
 <td>[0.3, 5.0] </td>
 <td>1.0</td>
 <td>m</td>
</tr>
</tbody></table>

## MAVLink

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MAV_0_BROADCAST">MAV_0_BROADCAST</strong> (INT32)</td>
 <td>Broadcast heartbeats on local network for MAVLink instance 0 <p><strong>Comment:</strong> This allows a ground control station to automatically find the drone on the local network.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Never broadcast</li>
<li><strong>1:</strong> Always broadcast</li>
<li><strong>2:</strong> Only multicast</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_CONFIG">MAV_0_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for MAVLink (instance 0) <p><strong>Comment:</strong> Configure on which serial port to run MAVLink.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
<li><strong>1000:</strong> Ethernet</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>101</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_FLOW_CTRL">MAV_0_FLOW_CTRL</strong> (INT32)</td>
 <td>Enable serial flow control for instance 0 <p><strong>Comment:</strong> This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Force off</li>
<li><strong>1:</strong> Force on</li>
<li><strong>2:</strong> Auto-detected</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_FORWARD">MAV_0_FORWARD</strong> (INT32)</td>
 <td>Enable MAVLink Message forwarding for instance 0 <p><strong>Comment:</strong> If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_HL_FREQ">MAV_0_HL_FREQ</strong> (FLOAT)</td>
 <td>Configures the frequency of HIGH_LATENCY2 stream for instance 0 <p><strong>Comment:</strong> Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 0, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 50.0] (0.001)</td>
 <td>0.015</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MAV_0_MODE">MAV_0_MODE</strong> (INT32)</td>
 <td>MAVLink Mode for instance 0 <p><strong>Comment:</strong> The MAVLink Mode defines the set of streamed messages (for example the vehicle&#x27;s attitude) and their sending rates.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Normal</li>
<li><strong>1:</strong> Custom</li>
<li><strong>2:</strong> Onboard</li>
<li><strong>3:</strong> OSD</li>
<li><strong>4:</strong> Magic</li>
<li><strong>5:</strong> Config</li>
<li><strong>7:</strong> Minimal</li>
<li><strong>8:</strong> External Vision</li>
<li><strong>10:</strong> Gimbal</li>
<li><strong>11:</strong> Onboard Low Bandwidth</li>
<li><strong>12:</strong> uAvionix</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_RADIO_CTL">MAV_0_RADIO_CTL</strong> (INT32)</td>
 <td>Enable software throttling of mavlink on instance 0 <p><strong>Comment:</strong> If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_RATE">MAV_0_RATE</strong> (INT32)</td>
 <td>Maximum MAVLink sending rate for instance 0 <p><strong>Comment:</strong> Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, ?] </td>
 <td>1200</td>
 <td>B/s</td>
</tr>
<tr>
 <td><strong id="MAV_0_REMOTE_PRT">MAV_0_REMOTE_PRT</strong> (INT32)</td>
 <td>MAVLink Remote Port for instance 0 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 0, selected remote port will be set and used in MAVLink instance 0.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>14550</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_0_UDP_PRT">MAV_0_UDP_PRT</strong> (INT32)</td>
 <td>MAVLink Network Port for instance 0 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 0, selected udp port will be set and used in MAVLink instance 0.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>14556</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_BROADCAST">MAV_1_BROADCAST</strong> (INT32)</td>
 <td>Broadcast heartbeats on local network for MAVLink instance 1 <p><strong>Comment:</strong> This allows a ground control station to automatically find the drone on the local network.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Never broadcast</li>
<li><strong>1:</strong> Always broadcast</li>
<li><strong>2:</strong> Only multicast</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_CONFIG">MAV_1_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for MAVLink (instance 1) <p><strong>Comment:</strong> Configure on which serial port to run MAVLink.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
<li><strong>1000:</strong> Ethernet</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_FLOW_CTRL">MAV_1_FLOW_CTRL</strong> (INT32)</td>
 <td>Enable serial flow control for instance 1 <p><strong>Comment:</strong> This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Force off</li>
<li><strong>1:</strong> Force on</li>
<li><strong>2:</strong> Auto-detected</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_FORWARD">MAV_1_FORWARD</strong> (INT32)</td>
 <td>Enable MAVLink Message forwarding for instance 1 <p><strong>Comment:</strong> If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_HL_FREQ">MAV_1_HL_FREQ</strong> (FLOAT)</td>
 <td>Configures the frequency of HIGH_LATENCY2 stream for instance 1 <p><strong>Comment:</strong> Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 1, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 50.0] (0.001)</td>
 <td>0.015</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MAV_1_MODE">MAV_1_MODE</strong> (INT32)</td>
 <td>MAVLink Mode for instance 1 <p><strong>Comment:</strong> The MAVLink Mode defines the set of streamed messages (for example the vehicle&#x27;s attitude) and their sending rates.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Normal</li>
<li><strong>1:</strong> Custom</li>
<li><strong>2:</strong> Onboard</li>
<li><strong>3:</strong> OSD</li>
<li><strong>4:</strong> Magic</li>
<li><strong>5:</strong> Config</li>
<li><strong>7:</strong> Minimal</li>
<li><strong>8:</strong> External Vision</li>
<li><strong>10:</strong> Gimbal</li>
<li><strong>11:</strong> Onboard Low Bandwidth</li>
<li><strong>12:</strong> uAvionix</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_RADIO_CTL">MAV_1_RADIO_CTL</strong> (INT32)</td>
 <td>Enable software throttling of mavlink on instance 1 <p><strong>Comment:</strong> If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_RATE">MAV_1_RATE</strong> (INT32)</td>
 <td>Maximum MAVLink sending rate for instance 1 <p><strong>Comment:</strong> Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, ?] </td>
 <td>0</td>
 <td>B/s</td>
</tr>
<tr>
 <td><strong id="MAV_1_REMOTE_PRT">MAV_1_REMOTE_PRT</strong> (INT32)</td>
 <td>MAVLink Remote Port for instance 1 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 1, selected remote port will be set and used in MAVLink instance 1.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_1_UDP_PRT">MAV_1_UDP_PRT</strong> (INT32)</td>
 <td>MAVLink Network Port for instance 1 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 1, selected udp port will be set and used in MAVLink instance 1.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_BROADCAST">MAV_2_BROADCAST</strong> (INT32)</td>
 <td>Broadcast heartbeats on local network for MAVLink instance 2 <p><strong>Comment:</strong> This allows a ground control station to automatically find the drone on the local network.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Never broadcast</li>
<li><strong>1:</strong> Always broadcast</li>
<li><strong>2:</strong> Only multicast</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_CONFIG">MAV_2_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for MAVLink (instance 2) <p><strong>Comment:</strong> Configure on which serial port to run MAVLink.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
<li><strong>1000:</strong> Ethernet</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_FLOW_CTRL">MAV_2_FLOW_CTRL</strong> (INT32)</td>
 <td>Enable serial flow control for instance 2 <p><strong>Comment:</strong> This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Force off</li>
<li><strong>1:</strong> Force on</li>
<li><strong>2:</strong> Auto-detected</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_FORWARD">MAV_2_FORWARD</strong> (INT32)</td>
 <td>Enable MAVLink Message forwarding for instance 2 <p><strong>Comment:</strong> If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_HL_FREQ">MAV_2_HL_FREQ</strong> (FLOAT)</td>
 <td>Configures the frequency of HIGH_LATENCY2 stream for instance 2 <p><strong>Comment:</strong> Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 2, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0.0, 50.0] (0.001)</td>
 <td>0.015</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MAV_2_MODE">MAV_2_MODE</strong> (INT32)</td>
 <td>MAVLink Mode for instance 2 <p><strong>Comment:</strong> The MAVLink Mode defines the set of streamed messages (for example the vehicle&#x27;s attitude) and their sending rates.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Normal</li>
<li><strong>1:</strong> Custom</li>
<li><strong>2:</strong> Onboard</li>
<li><strong>3:</strong> OSD</li>
<li><strong>4:</strong> Magic</li>
<li><strong>5:</strong> Config</li>
<li><strong>7:</strong> Minimal</li>
<li><strong>8:</strong> External Vision</li>
<li><strong>10:</strong> Gimbal</li>
<li><strong>11:</strong> Onboard Low Bandwidth</li>
<li><strong>12:</strong> uAvionix</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_RADIO_CTL">MAV_2_RADIO_CTL</strong> (INT32)</td>
 <td>Enable software throttling of mavlink on instance 2 <p><strong>Comment:</strong> If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_RATE">MAV_2_RATE</strong> (INT32)</td>
 <td>Maximum MAVLink sending rate for instance 2 <p><strong>Comment:</strong> Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td>[0, ?] </td>
 <td>0</td>
 <td>B/s</td>
</tr>
<tr>
 <td><strong id="MAV_2_REMOTE_PRT">MAV_2_REMOTE_PRT</strong> (INT32)</td>
 <td>MAVLink Remote Port for instance 2 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 2, selected remote port will be set and used in MAVLink instance 2.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_2_UDP_PRT">MAV_2_UDP_PRT</strong> (INT32)</td>
 <td>MAVLink Network Port for instance 2 <p><strong>Comment:</strong> If ethernet enabled and selected as configuration for MAVLink instance 2, selected udp port will be set and used in MAVLink instance 2.</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_COMP_ID">MAV_COMP_ID</strong> (INT32)</td>
 <td>MAVLink component ID    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 250] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_FWDEXTSP">MAV_FWDEXTSP</strong> (INT32)</td>
 <td>Forward external setpoint messages <p><strong>Comment:</strong> If set to 1 incoming external setpoint messages will be directly forwarded to the controllers if in offboard control mode</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_HASH_CHK_EN">MAV_HASH_CHK_EN</strong> (INT32)</td>
 <td>Parameter hash check <p><strong>Comment:</strong> Disabling the parameter hash check functionality will make the mavlink instance stream parameters continuously.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_HB_FORW_EN">MAV_HB_FORW_EN</strong> (INT32)</td>
 <td>Heartbeat message forwarding <p><strong>Comment:</strong> The mavlink heartbeat message will not be forwarded if this parameter is set to &#x27;disabled&#x27;. The main reason for disabling heartbeats to be forwarded is because they confuse dronekit.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_PROTO_VER">MAV_PROTO_VER</strong> (INT32)</td>
 <td>MAVLink protocol version  <strong>Values:</strong><ul>
<li><strong>0:</strong> Default to 1, switch to 2 if GCS sends version 2</li>
<li><strong>1:</strong> Always use version 1</li>
<li><strong>2:</strong> Always use version 2</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_RADIO_TOUT">MAV_RADIO_TOUT</strong> (INT32)</td>
 <td>Timeout in seconds for the RADIO_STATUS reports coming in <p><strong>Comment:</strong> If the connected radio stops reporting RADIO_STATUS for a certain time, a warning is triggered and, if MAV_X_RADIO_CTL is enabled, the software-flow control is reset.</p>   </td>
 <td>[1, 250] </td>
 <td>5</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MAV_SIK_RADIO_ID">MAV_SIK_RADIO_ID</strong> (INT32)</td>
 <td>MAVLink SiK Radio ID <p><strong>Comment:</strong> When non-zero the MAVLink app will attempt to configure the SiK radio to this ID and re-set the parameter to 0. If the value is negative it will reset the complete radio config to factory defaults. Only applies if this mavlink instance is going through a SiK radio</p>   </td>
 <td>[-1, 240] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_SYS_ID">MAV_SYS_ID</strong> (INT32)</td>
 <td>MAVLink system ID    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 250] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_TYPE">MAV_TYPE</strong> (INT32)</td>
 <td>MAVLink airframe type  <strong>Values:</strong><ul>
<li><strong>0:</strong> Generic micro air vehicle</li>
<li><strong>1:</strong> Fixed wing aircraft</li>
<li><strong>2:</strong> Quadrotor</li>
<li><strong>3:</strong> Coaxial helicopter</li>
<li><strong>4:</strong> Normal helicopter with tail rotor</li>
<li><strong>7:</strong> Airship, controlled</li>
<li><strong>8:</strong> Free balloon, uncontrolled</li>
<li><strong>10:</strong> Ground rover</li>
<li><strong>11:</strong> Surface vessel, boat, ship</li>
<li><strong>12:</strong> Submarine</li>
<li><strong>13:</strong> Hexarotor</li>
<li><strong>14:</strong> Octorotor</li>
<li><strong>15:</strong> Tricopter</li>
<li><strong>19:</strong> VTOL Two-rotor Tailsitter</li>
<li><strong>20:</strong> VTOL Quad-rotor Tailsitter</li>
<li><strong>21:</strong> VTOL Tiltrotor</li>
<li><strong>22:</strong> VTOL Standard (separate fixed rotors for hover and cruise flight)</li>
<li><strong>23:</strong> VTOL Tailsitter</li>
</ul>  </td>
 <td>[0, 22] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAV_USEHILGPS">MAV_USEHILGPS</strong> (INT32)</td>
 <td>Use/Accept HIL GPS message even if not in HIL mode <p><strong>Comment:</strong> If set to 1 incoming HIL GPS messages are parsed.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
</tbody></table>

## Magnetometer Bias Estimator

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MBE_ENABLE">MBE_ENABLE</strong> (INT32)</td>
 <td>Enable online mag bias calibration <p><strong>Comment:</strong> This enables continuous calibration of the magnetometers before takeoff using gyro data.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MBE_LEARN_GAIN">MBE_LEARN_GAIN</strong> (FLOAT)</td>
 <td>Mag bias estimator learning gain <p><strong>Comment:</strong> Increase to make the estimator more responsive Decrease to make the estimator more robust to noise</p>   </td>
 <td>[0.1, 100] (0.1)</td>
 <td>18.</td>
 <td></td>
</tr>
</tbody></table>

## Manual Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MAN_ARM_GESTURE">MAN_ARM_GESTURE</strong> (INT32)</td>
 <td>Enable arm/disarm stick gesture <p><strong>Comment:</strong> This determines if moving the left stick to the lower right arms and to the lower left disarms the vehicle.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MAN_KILL_GEST_T">MAN_KILL_GEST_T</strong> (FLOAT)</td>
 <td>Trigger time for kill stick gesture <p><strong>Comment:</strong> The timeout for holding the left stick to the lower left and the right stick to the lower right at the same time until the gesture kills the actuators one-way. A negative value disables the feature.</p>   </td>
 <td>[-1, 15] </td>
 <td>-1.</td>
 <td>s</td>
</tr>
</tbody></table>

## Mission

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="FW_GPSF_LT">FW_GPSF_LT</strong> (INT32)</td>
 <td>GPS failure loiter time <p><strong>Comment:</strong> The time the system should do open loop loiter and wait for GPS recovery before it starts descending. Set to 0 to disable. Roll angle is set to FW_GPSF_R. Does only apply for fixed-wing vehicles or VTOLs with NAV_FORCE_VT set to 0.</p>   </td>
 <td>[0, 3600] </td>
 <td>30</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="FW_GPSF_R">FW_GPSF_R</strong> (FLOAT)</td>
 <td>GPS failure fixed roll angle <p><strong>Comment:</strong> Roll angle in GPS failure loiter mode.</p>   </td>
 <td>[0.0, 30.0] (0.5)</td>
 <td>15.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MIS_DIST_1WP">MIS_DIST_1WP</strong> (FLOAT)</td>
 <td>Maximal horizontal distance from current position to first waypoint <p><strong>Comment:</strong> Failsafe check to prevent running mission stored from previous flight at a new takeoff location. Set a value of zero or less to disable. The mission will not be started if the current waypoint is more distant than MIS_DIST_1WP from the current position.</p>   </td>
 <td>[-1, 10000] (100)</td>
 <td>10000</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MIS_LND_ABRT_ALT">MIS_LND_ABRT_ALT</strong> (INT32)</td>
 <td>Landing abort min altitude <p><strong>Comment:</strong> Minimum altitude above landing point that the vehicle will climb to after an aborted landing. Then vehicle will loiter in this altitude until further command is received. Only applies to fixed-wing vehicles.</p>   </td>
 <td>[0, ?] </td>
 <td>30</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MIS_MNT_YAW_CTL">MIS_MNT_YAW_CTL</strong> (INT32)</td>
 <td>Enable yaw control of the mount. (Only affects multicopters and ROI mission items) <p><strong>Comment:</strong> If enabled, yaw commands will be sent to the mount and the vehicle will follow its heading towards the flight direction. If disabled, the vehicle will yaw towards the ROI.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> Enable</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MIS_PD_TO">MIS_PD_TO</strong> (FLOAT)</td>
 <td>Timeout for a successful payload deployment acknowledgement    </td>
 <td>[0, ?] (1)</td>
 <td>5.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MIS_TAKEOFF_ALT">MIS_TAKEOFF_ALT</strong> (FLOAT)</td>
 <td>Default take-off altitude <p><strong>Comment:</strong> This is the relative altitude the system will take off to if not otherwise specified.</p>   </td>
 <td>[0, ?] (0.5)</td>
 <td>2.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MIS_TKO_LAND_REQ">MIS_TKO_LAND_REQ</strong> (INT32)</td>
 <td>Mission takeoff/landing required <p><strong>Comment:</strong> Specifies if a mission has to contain a takeoff and/or mission landing. Validity of configured takeoffs/landings is checked independently of the setting here.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No requirements</li>
<li><strong>1:</strong> Require a takeoff</li>
<li><strong>2:</strong> Require a landing</li>
<li><strong>3:</strong> Require a takeoff and a landing</li>
<li><strong>4:</strong> Require both a takeoff and a landing, or neither</li>
<li><strong>5:</strong> Same as previous when landed, in-air require landing only if no valid VTOL approach is present</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MIS_YAW_ERR">MIS_YAW_ERR</strong> (FLOAT)</td>
 <td>Max yaw error in degrees needed for waypoint heading acceptance    </td>
 <td>[0, 90] (1)</td>
 <td>12.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MIS_YAW_TMT">MIS_YAW_TMT</strong> (FLOAT)</td>
 <td>Time in seconds we wait on reaching target heading at a waypoint if it is forced <p><strong>Comment:</strong> If set &gt; 0 it will ignore the target heading for normal waypoint acceptance. If the waypoint forces the heading the timeout will matter. For example on VTOL forwards transition. Mainly useful for VTOLs that have less yaw authority and might not reach target yaw in wind. Disabled by default.</p>   </td>
 <td>[-1, 20] (1)</td>
 <td>-1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MPC_YAW_MODE">MPC_YAW_MODE</strong> (INT32)</td>
 <td>Heading behavior in autonomous modes  <strong>Values:</strong><ul>
<li><strong>0:</strong> towards waypoint</li>
<li><strong>1:</strong> towards home</li>
<li><strong>2:</strong> away from home</li>
<li><strong>3:</strong> along trajectory</li>
<li><strong>4:</strong> towards waypoint (yaw first)</li>
<li><strong>5:</strong> yaw fixed</li>
</ul>  </td>
 <td>[0, 4] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NAV_ACC_RAD">NAV_ACC_RAD</strong> (FLOAT)</td>
 <td>Acceptance Radius <p><strong>Comment:</strong> Default acceptance radius, overridden by acceptance radius of waypoint if set. For fixed wing the npfg switch distance is used for horizontal acceptance.</p>   </td>
 <td>[0.05, 200.0] (0.5)</td>
 <td>10.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_FORCE_VT">NAV_FORCE_VT</strong> (INT32)</td>
 <td>Force VTOL mode takeoff and land    </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NAV_FW_ALTL_RAD">NAV_FW_ALTL_RAD</strong> (FLOAT)</td>
 <td>FW Altitude Acceptance Radius before a landing <p><strong>Comment:</strong> Altitude acceptance used for the last waypoint before a fixed-wing landing. This is usually smaller than the standard vertical acceptance because close to the ground higher accuracy is required.</p>   </td>
 <td>[0.05, 200.0] </td>
 <td>5.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_FW_ALT_RAD">NAV_FW_ALT_RAD</strong> (FLOAT)</td>
 <td>FW Altitude Acceptance Radius <p><strong>Comment:</strong> Acceptance radius for fixedwing altitude.</p>   </td>
 <td>[0.05, 200.0] (0.5)</td>
 <td>10.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_LOITER_RAD">NAV_LOITER_RAD</strong> (FLOAT)</td>
 <td>Loiter radius (FW only) <p><strong>Comment:</strong> Default value of loiter radius in FW mode (e.g. for Loiter mode).</p>   </td>
 <td>[25, 1000] (0.5)</td>
 <td>80.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_MC_ALT_RAD">NAV_MC_ALT_RAD</strong> (FLOAT)</td>
 <td>MC Altitude Acceptance Radius <p><strong>Comment:</strong> Acceptance radius for multicopter altitude.</p>   </td>
 <td>[0.05, 200.0] (0.5)</td>
 <td>0.8</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_MIN_LTR_ALT">NAV_MIN_LTR_ALT</strong> (FLOAT)</td>
 <td>Minimum Loiter altitude <p><strong>Comment:</strong> This is the minimum altitude above Home the system will always obey in Loiter (Hold) mode if switched into this mode without specifying an altitude (e.g. through Loiter switch on RC). Doesn&#x27;t affect Loiters that are part of Missions or that are entered through a reposition setpoint (&quot;Go to&quot;). Set to a negative value to disable.</p>   </td>
 <td>[-1, ?] (0.5)</td>
 <td>-1.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_TRAFF_AVOID">NAV_TRAFF_AVOID</strong> (INT32)</td>
 <td>Set traffic avoidance mode <p><strong>Comment:</strong> Enabling this will allow the system to respond to transponder data from e.g. ADSB transponders</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Warn only</li>
<li><strong>2:</strong> Return mode</li>
<li><strong>3:</strong> Land mode</li>
<li><strong>4:</strong> Position Hold mode</li>
</ul>  </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="NAV_TRAFF_A_HOR">NAV_TRAFF_A_HOR</strong> (FLOAT)</td>
 <td>Set NAV TRAFFIC AVOID horizontal distance <p><strong>Comment:</strong> Defines a crosstrack horizontal distance</p>   </td>
 <td>[500, ?] </td>
 <td>500</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_TRAFF_A_VER">NAV_TRAFF_A_VER</strong> (FLOAT)</td>
 <td>Set NAV TRAFFIC AVOID vertical distance    </td>
 <td>[10, 500] </td>
 <td>500</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="NAV_TRAFF_COLL_T">NAV_TRAFF_COLL_T</strong> (INT32)</td>
 <td>Estimated time until collision <p><strong>Comment:</strong> Minimum acceptable time until collsion. Assumes constant speed over 3d distance.</p>   </td>
 <td>[1, 900000000] </td>
 <td>60</td>
 <td>s</td>
</tr>
</tbody></table>

## Mixer Output

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_AIRMODE">MC_AIRMODE</strong> (INT32)</td>
 <td>Multicopter air-mode <p><strong>Comment:</strong> The air-mode enables the mixer to increase the total thrust of the multirotor in order to keep attitude and rate control even at low and high throttle. This function should be disabled during tuning as it will help the controller to diverge if the closed-loop is unstable (i.e. the vehicle is not tuned yet). Enabling air-mode for yaw requires the use of an arming switch.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Roll/Pitch</li>
<li><strong>2:</strong> Roll/Pitch/Yaw</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## ModalAI Custom Configuration

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MODALAI_CONFIG">MODALAI_CONFIG</strong> (INT32)</td>
 <td>Custom configuration for ModalAI drones <p><strong>Comment:</strong> This can be set to indicate that drone behavior needs to be changed to match a custom setting</p>   <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Mount

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MNT_DO_STAB">MNT_DO_STAB</strong> (INT32)</td>
 <td>Stabilize the mount <p><strong>Comment:</strong> Set to true for servo gimbal, false for passthrough. This is required for a gimbal which is not capable of stabilizing itself and relies on the IMU&#x27;s attitude estimation.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> Stabilize all axis</li>
<li><strong>2:</strong> Stabilize yaw for absolute/lock mode.</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_LND_P_MAX">MNT_LND_P_MAX</strong> (FLOAT)</td>
 <td>Pitch maximum when landed    </td>
 <td>[-90.0, 90.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_LND_P_MIN">MNT_LND_P_MIN</strong> (FLOAT)</td>
 <td>Pitch minimum when landed    </td>
 <td>[-90.0, 90.0] </td>
 <td>-90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_MAN_PITCH">MNT_MAN_PITCH</strong> (INT32)</td>
 <td>Auxiliary channel to control pitch (in AUX input or manual mode)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MAN_ROLL">MNT_MAN_ROLL</strong> (INT32)</td>
 <td>Auxiliary channel to control roll (in AUX input or manual mode)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MAN_YAW">MNT_MAN_YAW</strong> (INT32)</td>
 <td>Auxiliary channel to control yaw (in AUX input or manual mode)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disable</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MAV_COMPID">MNT_MAV_COMPID</strong> (INT32)</td>
 <td>Mavlink Component ID of the mount <p><strong>Comment:</strong> If MNT_MODE_OUT is MAVLink protocol v2, mount configure/control commands will be sent with this component ID.</p>   </td>
 <td></td>
 <td>154</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MAV_SYSID">MNT_MAV_SYSID</strong> (INT32)</td>
 <td>Mavlink System ID of the mount <p><strong>Comment:</strong> If MNT_MODE_OUT is MAVLink gimbal protocol v1, mount configure/control commands will be sent with this target ID.</p>   </td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MODE_IN">MNT_MODE_IN</strong> (INT32)</td>
 <td>Mount input mode <p><strong>Comment:</strong> This is the protocol used between the ground station and the autopilot. Recommended is Auto, RC only or MAVLink gimbal protocol v2. The rest will be deprecated.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> DISABLED</li>
<li><strong>0:</strong> Auto (RC and MAVLink gimbal protocol v2)</li>
<li><strong>1:</strong> RC</li>
<li><strong>2:</strong> MAVLINK_ROI (protocol v1, to be deprecated)</li>
<li><strong>3:</strong> MAVLINK_DO_MOUNT (protocol v1, to be deprecated)</li>
<li><strong>4:</strong> MAVlink gimbal protocol v2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[-1, 4] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_MODE_OUT">MNT_MODE_OUT</strong> (INT32)</td>
 <td>Mount output mode <p><strong>Comment:</strong> This is the protocol used between the autopilot and a connected gimbal. Recommended is the MAVLink gimbal protocol v2 if the gimbal supports it.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> AUX</li>
<li><strong>1:</strong> MAVLink gimbal protocol v1</li>
<li><strong>2:</strong> MAVLink gimbal protocol v2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MNT_OFF_PITCH">MNT_OFF_PITCH</strong> (FLOAT)</td>
 <td>Offset for pitch channel output in degrees    </td>
 <td>[-360.0, 360.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_OFF_ROLL">MNT_OFF_ROLL</strong> (FLOAT)</td>
 <td>Offset for roll channel output in degrees    </td>
 <td>[-360.0, 360.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_OFF_YAW">MNT_OFF_YAW</strong> (FLOAT)</td>
 <td>Offset for yaw channel output in degrees    </td>
 <td>[-360.0, 360.0] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_RANGE_PITCH">MNT_RANGE_PITCH</strong> (FLOAT)</td>
 <td>Range of pitch channel output in degrees (only in AUX output mode)    </td>
 <td>[1.0, 720.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_RANGE_ROLL">MNT_RANGE_ROLL</strong> (FLOAT)</td>
 <td>Range of roll channel output in degrees (only in AUX output mode)    </td>
 <td>[1.0, 720.0] </td>
 <td>90.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_RANGE_YAW">MNT_RANGE_YAW</strong> (FLOAT)</td>
 <td>Range of yaw channel output in degrees (only in AUX output mode)    </td>
 <td>[1.0, 720.0] </td>
 <td>360.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MNT_RATE_PITCH">MNT_RATE_PITCH</strong> (FLOAT)</td>
 <td>Angular pitch rate for manual input in degrees/second <p><strong>Comment:</strong> Full stick input [-1..1] translats to [-pitch rate..pitch rate].</p>   </td>
 <td>[1.0, 90.0] </td>
 <td>30.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MNT_RATE_YAW">MNT_RATE_YAW</strong> (FLOAT)</td>
 <td>Angular yaw rate for manual input in degrees/second <p><strong>Comment:</strong> Full stick input [-1..1] translats to [-yaw rate..yaw rate].</p>   </td>
 <td>[1.0, 90.0] </td>
 <td>30.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MNT_RC_IN_MODE">MNT_RC_IN_MODE</strong> (INT32)</td>
 <td>Input mode for RC gimbal input  <strong>Values:</strong><ul>
<li><strong>0:</strong> Angle</li>
<li><strong>1:</strong> Angular rate</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>1</td>
 <td></td>
</tr>
</tbody></table>

## Multicopter Acro Mode

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_ACRO_EXPO">MC_ACRO_EXPO</strong> (FLOAT)</td>
 <td>Acro mode roll, pitch expo factor <p><strong>Comment:</strong> Exponential factor for tuning the input curve shape. 0 Purely linear input curve 1 Purely cubic input curve</p>   </td>
 <td>[0, 1] </td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ACRO_EXPO_Y">MC_ACRO_EXPO_Y</strong> (FLOAT)</td>
 <td>Acro mode yaw expo factor <p><strong>Comment:</strong> Exponential factor for tuning the input curve shape. 0 Purely linear input curve 1 Purely cubic input curve</p>   </td>
 <td>[0, 1] </td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ACRO_P_MAX">MC_ACRO_P_MAX</strong> (FLOAT)</td>
 <td>Acro mode maximum pitch rate <p><strong>Comment:</strong> Full stick deflection leads to this rate.</p>   </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>100.</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_ACRO_R_MAX">MC_ACRO_R_MAX</strong> (FLOAT)</td>
 <td>Acro mode maximum roll rate <p><strong>Comment:</strong> Full stick deflection leads to this rate.</p>   </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>100.</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_ACRO_SUPEXPO">MC_ACRO_SUPEXPO</strong> (FLOAT)</td>
 <td>Acro mode roll, pitch super expo factor <p><strong>Comment:</strong> &quot;Superexponential&quot; factor for refining the input curve shape tuned using MC_ACRO_EXPO. 0 Pure Expo function 0.7 reasonable shape enhancement for intuitive stick feel 0.95 very strong bent input curve only near maxima have effect</p>   </td>
 <td>[0, 0.95] </td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ACRO_SUPEXPOY">MC_ACRO_SUPEXPOY</strong> (FLOAT)</td>
 <td>Acro mode yaw super expo factor <p><strong>Comment:</strong> &quot;Superexponential&quot; factor for refining the input curve shape tuned using MC_ACRO_EXPO_Y. 0 Pure Expo function 0.7 reasonable shape enhancement for intuitive stick feel 0.95 very strong bent input curve only near maxima have effect</p>   </td>
 <td>[0, 0.95] </td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ACRO_Y_MAX">MC_ACRO_Y_MAX</strong> (FLOAT)</td>
 <td>Acro mode maximum yaw rate <p><strong>Comment:</strong> Full stick deflection leads to this rate.</p>   </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>100.</td>
 <td>deg/s</td>
</tr>
</tbody></table>

## Multicopter Attitude Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_PITCHRATE_MAX">MC_PITCHRATE_MAX</strong> (FLOAT)</td>
 <td>Max pitch rate <p><strong>Comment:</strong> Limit for pitch rate in manual and auto modes (except acro). Has effect for large rotations in autonomous mode, to avoid large control output and mixer saturation. This is not only limited by the vehicle&#x27;s properties, but also by the maximum measurement rate of the gyro.</p>   </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>220.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_PITCH_P">MC_PITCH_P</strong> (FLOAT)</td>
 <td>Pitch P gain <p><strong>Comment:</strong> Pitch proportional gain, i.e. desired angular speed in rad/s for error 1 rad.</p>   </td>
 <td>[0.0, 12] (0.1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_MAX">MC_ROLLRATE_MAX</strong> (FLOAT)</td>
 <td>Max roll rate <p><strong>Comment:</strong> Limit for roll rate in manual and auto modes (except acro). Has effect for large rotations in autonomous mode, to avoid large control output and mixer saturation. This is not only limited by the vehicle&#x27;s properties, but also by the maximum measurement rate of the gyro.</p>   </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>220.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_ROLL_P">MC_ROLL_P</strong> (FLOAT)</td>
 <td>Roll P gain <p><strong>Comment:</strong> Roll proportional gain, i.e. desired angular speed in rad/s for error 1 rad.</p>   </td>
 <td>[0.0, 12] (0.1)</td>
 <td>6.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_MAX">MC_YAWRATE_MAX</strong> (FLOAT)</td>
 <td>Max yaw rate    </td>
 <td>[0.0, 1800.0] (5)</td>
 <td>200.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_YAW_P">MC_YAW_P</strong> (FLOAT)</td>
 <td>Yaw P gain <p><strong>Comment:</strong> Yaw proportional gain, i.e. desired angular speed in rad/s for error 1 rad.</p>   </td>
 <td>[0.0, 5] (0.1)</td>
 <td>2.8</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAW_WEIGHT">MC_YAW_WEIGHT</strong> (FLOAT)</td>
 <td>Yaw weight <p><strong>Comment:</strong> A fraction [0,1] deprioritizing yaw compared to roll and pitch in non-linear attitude control. Deprioritizing yaw is necessary because multicopters have much less control authority in yaw compared to the other axes and it makes sense because yaw is not critical for stable hovering or 3D navigation. For yaw control tuning use MC_YAW_P. This ratio has no impact on the yaw gain.</p>   </td>
 <td>[0.0, 1.0] (0.1)</td>
 <td>0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_YAWRAUTO_ACC">MPC_YAWRAUTO_ACC</strong> (FLOAT)</td>
 <td>Maximum yaw acceleration in autonomous modes <p><strong>Comment:</strong> Limits the acceleration of the yaw setpoint to avoid large control output and mixer saturation.</p>   </td>
 <td>[5, 360] (5)</td>
 <td>60.</td>
 <td>deg/s^2</td>
</tr>
<tr>
 <td><strong id="MPC_YAWRAUTO_MAX">MPC_YAWRAUTO_MAX</strong> (FLOAT)</td>
 <td>Maximum yaw rate in autonomous modes <p><strong>Comment:</strong> Limits the rate of change of the yaw setpoint to avoid large control output and mixer saturation.</p>   </td>
 <td>[5, 360] (5)</td>
 <td>45.</td>
 <td>deg/s</td>
</tr>
</tbody></table>

## Multicopter Position Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CP_DELAY">CP_DELAY</strong> (FLOAT)</td>
 <td>Average delay of the range sensor message plus the tracking delay of the position controller in seconds <p><strong>Comment:</strong> Only used in Position mode.</p>   </td>
 <td>[0, 1] </td>
 <td>0.4</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="CP_DIST">CP_DIST</strong> (FLOAT)</td>
 <td>Minimum distance the vehicle should keep to all obstacles <p><strong>Comment:</strong> Only used in Position mode. Collision avoidance is disabled by setting this parameter to a negative value</p>   </td>
 <td>[-1, 15] </td>
 <td>-1.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CP_GO_NO_DATA">CP_GO_NO_DATA</strong> (INT32)</td>
 <td>Boolean to allow moving into directions where there is no sensor data (outside FOV) <p><strong>Comment:</strong> Only used in Position mode.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CP_GUIDE_ANG">CP_GUIDE_ANG</strong> (FLOAT)</td>
 <td>Angle left/right from the commanded setpoint by which the collision prevention algorithm can choose to change the setpoint direction <p><strong>Comment:</strong> Only used in Position mode.</p>   </td>
 <td>[0, 90] </td>
 <td>30.</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MC_MAN_TILT_TAU">MC_MAN_TILT_TAU</strong> (FLOAT)</td>
 <td>Manual tilt input filter time constant <p><strong>Comment:</strong> Setting this parameter to 0 disables the filter</p>   </td>
 <td>[0.0, 2.0] </td>
 <td>0.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MPC_ACC_DECOUPLE">MPC_ACC_DECOUPLE</strong> (INT32)</td>
 <td>Acceleration to tilt coupling <p><strong>Comment:</strong> Set to decouple tilt from vertical acceleration.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_ACC_DOWN_MAX">MPC_ACC_DOWN_MAX</strong> (FLOAT)</td>
 <td>Maximum downwards acceleration in climb rate controlled modes    </td>
 <td>[2, 15] (1)</td>
 <td>3.</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="MPC_ACC_HOR">MPC_ACC_HOR</strong> (FLOAT)</td>
 <td>Acceleration for autonomous and for manual modes <p><strong>Comment:</strong> When piloting manually, this parameter is only used in MPC_POS_MODE 4.</p>   </td>
 <td>[2, 15] (1)</td>
 <td>3.</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="MPC_ACC_HOR_MAX">MPC_ACC_HOR_MAX</strong> (FLOAT)</td>
 <td>Maximum horizontal acceleration <p><strong>Comment:</strong> MPC_POS_MODE 1 just deceleration 3 acceleration and deceleration 4 not used, use MPC_ACC_HOR instead</p>   </td>
 <td>[2, 15] (1)</td>
 <td>5.</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="MPC_ACC_UP_MAX">MPC_ACC_UP_MAX</strong> (FLOAT)</td>
 <td>Maximum upwards acceleration in climb rate controlled modes    </td>
 <td>[2, 15] (1)</td>
 <td>4.</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="MPC_ALT_MODE">MPC_ALT_MODE</strong> (INT32)</td>
 <td>Altitude reference mode <p><strong>Comment:</strong> Set to 0 to control height relative to the earth frame origin. This origin may move up and down in flight due to sensor drift. Set to 1 to control height relative to estimated distance to ground. The vehicle will move up and down with terrain height variation. Requires a distance to ground sensor. The height controller will revert to using height above origin if the distance to ground estimate becomes invalid as indicated by the local_position.distance_bottom_valid message being false. Set to 2 to control height relative to ground (requires a distance sensor) when stationary and relative to earth frame origin when moving horizontally. The speed threshold is controlled by the MPC_HOLD_MAX_XY parameter.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Altitude following</li>
<li><strong>1:</strong> Terrain following</li>
<li><strong>2:</strong> Terrain hold</li>
</ul>  </td>
 <td>[0, 2] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_HOLD_DZ">MPC_HOLD_DZ</strong> (FLOAT)</td>
 <td>Deadzone for sticks in manual piloted modes <p><strong>Comment:</strong> Does not apply to manual throttle and direct attitude piloting by stick.</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_HOLD_MAX_XY">MPC_HOLD_MAX_XY</strong> (FLOAT)</td>
 <td>Maximum horizontal velocity for which position hold is enabled (use 0 to disable check) <p><strong>Comment:</strong> Only used with MPC_POS_MODE 0 or MPC_ALT_MODE 2</p>   </td>
 <td>[0, 3] </td>
 <td>0.8</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_HOLD_MAX_Z">MPC_HOLD_MAX_Z</strong> (FLOAT)</td>
 <td>Maximum vertical velocity for which position hold is enabled (use 0 to disable check) <p><strong>Comment:</strong> Only used with MPC_ALT_MODE 1</p>   </td>
 <td>[0, 3] </td>
 <td>0.6</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_JERK_AUTO">MPC_JERK_AUTO</strong> (FLOAT)</td>
 <td>Jerk limit in autonomous modes <p><strong>Comment:</strong> Limit the maximum jerk of the vehicle (how fast the acceleration can change). A lower value leads to smoother vehicle motions but also limited agility.</p>   </td>
 <td>[1, 80] (1)</td>
 <td>4.</td>
 <td>m/s^3</td>
</tr>
<tr>
 <td><strong id="MPC_JERK_MAX">MPC_JERK_MAX</strong> (FLOAT)</td>
 <td>Maximum horizontal and vertical jerk in Position/Altitude mode <p><strong>Comment:</strong> Limit the maximum jerk of the vehicle (how fast the acceleration can change). A lower value leads to smoother motions but limits agility (how fast it can change directions or break). Setting this to the maximum value essentially disables the limit. Only used with smooth MPC_POS_MODE 3 and 4.</p>   </td>
 <td>[0.5, 500] (1)</td>
 <td>8.</td>
 <td>m/s^3</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_ALT1">MPC_LAND_ALT1</strong> (FLOAT)</td>
 <td>Altitude for 1. step of slow landing (descend) <p><strong>Comment:</strong> Below this altitude descending velocity gets limited to a value between &quot;MPC_Z_VEL_MAX_DN&quot; (or &quot;MPC_Z_V_AUTO_DN&quot;) and &quot;MPC_LAND_SPEED&quot; Value needs to be higher than &quot;MPC_LAND_ALT2&quot;</p>   </td>
 <td>[0, 122] </td>
 <td>10.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_ALT2">MPC_LAND_ALT2</strong> (FLOAT)</td>
 <td>Altitude for 2. step of slow landing (landing) <p><strong>Comment:</strong> Below this altitude descending velocity gets limited to &quot;MPC_LAND_SPEED&quot; Value needs to be lower than &quot;MPC_LAND_ALT1&quot;</p>   </td>
 <td>[0, 122] </td>
 <td>5.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_ALT3">MPC_LAND_ALT3</strong> (FLOAT)</td>
 <td>Altitude for 3. step of slow landing <p><strong>Comment:</strong> Below this altitude descending velocity gets limited to &quot;MPC_LAND_CRWL&quot;, if LIDAR available. No effect if LIDAR not available</p>   </td>
 <td>[0, 122] </td>
 <td>1.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_CRWL">MPC_LAND_CRWL</strong> (FLOAT)</td>
 <td>Land crawl descend rate <p><strong>Comment:</strong> Used below MPC_LAND_ALT3 if distance sensor data is availabe.</p>   </td>
 <td>[0.1, ?] </td>
 <td>0.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_RADIUS">MPC_LAND_RADIUS</strong> (FLOAT)</td>
 <td>User assisted landing radius <p><strong>Comment:</strong> When nudging is enabled (see MPC_LAND_RC_HELP), this controls the maximum allowed horizontal displacement from the original landing point.</p>   </td>
 <td>[0, ?] (1)</td>
 <td>1000.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="MPC_LAND_RC_HELP">MPC_LAND_RC_HELP</strong> (INT32)</td>
 <td>Enable nudging based on user input during autonomous land routine <p><strong>Comment:</strong> Using stick input the vehicle can be moved horizontally and yawed. The descend speed is amended: stick full up - 0 stick centered - MPC_LAND_SPEED stick full down - 2 * MPC_LAND_SPEED Manual override during auto modes has to be disabled to use this feature (see COM_RC_OVERRIDE).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Nudging disabled</li>
<li><strong>1:</strong> Nudging enabled</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_LAND_SPEED">MPC_LAND_SPEED</strong> (FLOAT)</td>
 <td>Landing descend rate    </td>
 <td>[0.6, ?] </td>
 <td>0.7</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_MANTHR_MIN">MPC_MANTHR_MIN</strong> (FLOAT)</td>
 <td>Minimum collective thrust in Stabilized mode <p><strong>Comment:</strong> The value is mapped to the lowest throttle stick position in Stabilized mode. Too low collective thrust leads to loss of roll/pitch/yaw torque control authority. Airmode is used to keep torque authority with zero thrust (see MC_AIRMODE).</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.08</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="MPC_MAN_TILT_MAX">MPC_MAN_TILT_MAX</strong> (FLOAT)</td>
 <td>Maximal tilt angle in Stabilized or Altitude mode    </td>
 <td>[1, 70] (1)</td>
 <td>35.</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MPC_MAN_Y_MAX">MPC_MAN_Y_MAX</strong> (FLOAT)</td>
 <td>Max manual yaw rate for Stabilized, Altitude, Position mode    </td>
 <td>[0, 400] (10)</td>
 <td>150.</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MPC_MAN_Y_TAU">MPC_MAN_Y_TAU</strong> (FLOAT)</td>
 <td>Manual yaw rate input filter time constant <p><strong>Comment:</strong> Not used in Stabilized mode Setting this parameter to 0 disables the filter</p>   </td>
 <td>[0, 5] (0.01)</td>
 <td>0.08</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MPC_POS_MODE">MPC_POS_MODE</strong> (INT32)</td>
 <td>Position/Altitude mode variant <p><strong>Comment:</strong> The supported sub-modes are: 0 Sticks directly map to velocity setpoints without smoothing. Also applies to vertical direction and Altitude mode. Useful for velocity control tuning. 3 Sticks map to velocity but with maximum acceleration and jerk limits based on jerk optimized trajectory generator (different algorithm than 1). 4 Sticks map to acceleration and there&#x27;s a virtual brake drag</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Direct velocity</li>
<li><strong>3:</strong> Smoothed velocity</li>
<li><strong>4:</strong> Acceleration based</li>
</ul>  </td>
 <td></td>
 <td>4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_THR_CURVE">MPC_THR_CURVE</strong> (INT32)</td>
 <td>Thrust curve mapping in Stabilized Mode <p><strong>Comment:</strong> This parameter defines how the throttle stick input is mapped to collective thrust in Stabilized mode. In case the default is used (&#x27;Rescale to hover thrust&#x27;), the stick input is linearly rescaled, such that a centered stick corresponds to the hover throttle (see MPC_THR_HOVER). Select &#x27;No Rescale&#x27; to directly map the stick 1:1 to the output. This can be useful in case the hover thrust is very low and the default would lead to too much distortion (e.g. if hover thrust is set to 20%, then 80% of the upper thrust range is squeezed into the upper half of the stick range). Note: In case MPC_THR_HOVER is set to 50%, the modes 0 and 1 are the same.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Rescale to hover thrust</li>
<li><strong>1:</strong> No Rescale</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_THR_HOVER">MPC_THR_HOVER</strong> (FLOAT)</td>
 <td>Vertical thrust required to hover <p><strong>Comment:</strong> Mapped to center throttle stick in Stabilized mode (see MPC_THR_CURVE). Used for initialization of the hover thrust estimator (see MPC_USE_HTE). The estimated hover thrust is used as base for zero vertical acceleration in altitude control. The hover thrust is important for land detection to work correctly.</p>   </td>
 <td>[0.1, 0.8] (0.01)</td>
 <td>0.5</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="MPC_THR_MAX">MPC_THR_MAX</strong> (FLOAT)</td>
 <td>Maximum collective thrust in climb rate controlled modes <p><strong>Comment:</strong> Limit allowed thrust e.g. for indoor test of overpowered vehicle.</p>   </td>
 <td>[0, 1] (0.05)</td>
 <td>1.</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="MPC_THR_MIN">MPC_THR_MIN</strong> (FLOAT)</td>
 <td>Minimum collective thrust in climb rate controlled modes <p><strong>Comment:</strong> Too low thrust leads to loss of roll/pitch/yaw torque control authority. With airmode enabled this parameters can be set to 0 while still keeping torque authority (see MC_AIRMODE).</p>   </td>
 <td>[0.05, 0.5] (0.01)</td>
 <td>0.12</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="MPC_THR_XY_MARG">MPC_THR_XY_MARG</strong> (FLOAT)</td>
 <td>Horizontal thrust margin <p><strong>Comment:</strong> Margin that is kept for horizontal control when higher priority vertical thrust is saturated. To avoid completely starving horizontal control with high vertical error.</p>   </td>
 <td>[0, 0.5] (0.01)</td>
 <td>0.3</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="MPC_TILTMAX_AIR">MPC_TILTMAX_AIR</strong> (FLOAT)</td>
 <td>Maximum tilt angle in air <p><strong>Comment:</strong> Absolute maximum for all velocity or acceleration controlled modes. Any higher value is truncated.</p>   </td>
 <td>[20, 89] (1)</td>
 <td>45.</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MPC_TILTMAX_LND">MPC_TILTMAX_LND</strong> (FLOAT)</td>
 <td>Maximum tilt during inital takeoff ramp <p><strong>Comment:</strong> Tighter tilt limit during takeoff to avoid tip over.</p>   </td>
 <td>[5, 89] (1)</td>
 <td>12.</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="MPC_TKO_RAMP_T">MPC_TKO_RAMP_T</strong> (FLOAT)</td>
 <td>Smooth takeoff ramp time constant <p><strong>Comment:</strong> Increasing this value will make climb rate controlled takeoff slower. If it&#x27;s too slow the drone might scratch the ground and tip over. A time constant of 0 disables the ramp</p>   </td>
 <td>[0, 5] </td>
 <td>3.</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="MPC_TKO_SPEED">MPC_TKO_SPEED</strong> (FLOAT)</td>
 <td>Takeoff climb rate    </td>
 <td>[1, 5] </td>
 <td>1.5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_USE_HTE">MPC_USE_HTE</strong> (INT32)</td>
 <td>Hover thrust estimator <p><strong>Comment:</strong> Disable to use the fixed parameter MPC_THR_HOVER Enable to use the hover thrust estimator</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_VELD_LP">MPC_VELD_LP</strong> (FLOAT)</td>
 <td>Velocity derivative low pass cutoff frequency <p><strong>Comment:</strong> A value of 0 disables the filter.</p>   </td>
 <td>[0, 50] (0.5)</td>
 <td>5.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_LP">MPC_VEL_LP</strong> (FLOAT)</td>
 <td>Velocity low pass cutoff frequency <p><strong>Comment:</strong> A value of 0 disables the filter.</p>   </td>
 <td>[0, 50] (0.5)</td>
 <td>0.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_MANUAL">MPC_VEL_MANUAL</strong> (FLOAT)</td>
 <td>Maximum horizontal velocity setpoint in Position mode <p><strong>Comment:</strong> Must be smaller than MPC_XY_VEL_MAX. The maximum sideways and backward speed can be set differently using MPC_VEL_MAN_SIDE and MPC_VEL_MAN_BACK, respectively.</p>   </td>
 <td>[3, 20] (1)</td>
 <td>10.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_MAN_BACK">MPC_VEL_MAN_BACK</strong> (FLOAT)</td>
 <td>Maximum backward velocity in Position mode <p><strong>Comment:</strong> If set to a negative value or larger than MPC_VEL_MANUAL then MPC_VEL_MANUAL is used.</p>   </td>
 <td>[-1, 20] (1)</td>
 <td>-1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_MAN_SIDE">MPC_VEL_MAN_SIDE</strong> (FLOAT)</td>
 <td>Maximum sideways velocity in Position mode <p><strong>Comment:</strong> If set to a negative value or larger than MPC_VEL_MANUAL then MPC_VEL_MANUAL is used.</p>   </td>
 <td>[-1, 20] (1)</td>
 <td>-1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_NF_BW">MPC_VEL_NF_BW</strong> (FLOAT)</td>
 <td>Velocity notch filter bandwidth <p><strong>Comment:</strong> A value of 0 disables the filter.</p>   </td>
 <td>[0, 50] (0.5)</td>
 <td>5.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MPC_VEL_NF_FRQ">MPC_VEL_NF_FRQ</strong> (FLOAT)</td>
 <td>Velocity notch filter frequency <p><strong>Comment:</strong> The center frequency for the 2nd order notch filter on the velocity. A value of 0 disables the filter.</p>   </td>
 <td>[0, 50] (0.5)</td>
 <td>0.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="MPC_XY_CRUISE">MPC_XY_CRUISE</strong> (FLOAT)</td>
 <td>Default horizontal velocity in autonomous modes <p><strong>Comment:</strong> e.g. in Missions, RTL, Goto if the waypoint does not specify differently</p>   </td>
 <td>[3, 20] (1)</td>
 <td>5.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_XY_ERR_MAX">MPC_XY_ERR_MAX</strong> (FLOAT)</td>
 <td>Maximum horizontal error allowed by the trajectory generator <p><strong>Comment:</strong> The integration speed of the trajectory setpoint is linearly reduced with the horizontal position tracking error. When the error is above this parameter, the integration of the trajectory is stopped to wait for the drone. This value can be adjusted depending on the tracking capabilities of the vehicle.</p>   </td>
 <td>[0.1, 10] (1)</td>
 <td>2.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_MAN_EXPO">MPC_XY_MAN_EXPO</strong> (FLOAT)</td>
 <td>Manual position control stick exponential curve sensitivity <p><strong>Comment:</strong> The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.6</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_P">MPC_XY_P</strong> (FLOAT)</td>
 <td>Proportional gain for horizontal position error <p><strong>Comment:</strong> Defined as corrective velocity in m/s per m position error</p>   </td>
 <td>[0, 2] (0.1)</td>
 <td>0.95</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_TRAJ_P">MPC_XY_TRAJ_P</strong> (FLOAT)</td>
 <td>Proportional gain for horizontal trajectory position error    </td>
 <td>[0.1, 1] (0.1)</td>
 <td>0.5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_VEL_ALL">MPC_XY_VEL_ALL</strong> (FLOAT)</td>
 <td>Overall Horizontal Velocity Limit <p><strong>Comment:</strong> If set to a value greater than zero, other parameters are automatically set (such as MPC_XY_VEL_MAX or MPC_VEL_MANUAL). If set to a negative value, the existing individual parameters are used.</p>   </td>
 <td>[-20, 20] (1)</td>
 <td>-10.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_VEL_D_ACC">MPC_XY_VEL_D_ACC</strong> (FLOAT)</td>
 <td>Differential gain for horizontal velocity error <p><strong>Comment:</strong> Defined as corrective acceleration in m/s^2 per m/s^2 velocity derivative</p>   </td>
 <td>[0.1, 2] (0.02)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_VEL_I_ACC">MPC_XY_VEL_I_ACC</strong> (FLOAT)</td>
 <td>Integral gain for horizontal velocity error <p><strong>Comment:</strong> Defined as correction acceleration in m/s^2 per m velocity integral Allows to eliminate steady state errors in disturbances like wind.</p>   </td>
 <td>[0, 60] (0.02)</td>
 <td>0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_XY_VEL_MAX">MPC_XY_VEL_MAX</strong> (FLOAT)</td>
 <td>Maximum horizontal velocity <p><strong>Comment:</strong> Absolute maximum for all velocity controlled modes. Any higher value is truncated.</p>   </td>
 <td>[0, 20] (1)</td>
 <td>12.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_XY_VEL_P_ACC">MPC_XY_VEL_P_ACC</strong> (FLOAT)</td>
 <td>Proportional gain for horizontal velocity error <p><strong>Comment:</strong> Defined as corrective acceleration in m/s^2 per m/s velocity error</p>   </td>
 <td>[1.2, 5] (0.1)</td>
 <td>1.8</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_YAW_EXPO">MPC_YAW_EXPO</strong> (FLOAT)</td>
 <td>Manual control stick yaw rotation exponential curve <p><strong>Comment:</strong> The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.6</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_MAN_EXPO">MPC_Z_MAN_EXPO</strong> (FLOAT)</td>
 <td>Manual control stick vertical exponential curve <p><strong>Comment:</strong> The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve</p>   </td>
 <td>[0, 1] (0.01)</td>
 <td>0.6</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_P">MPC_Z_P</strong> (FLOAT)</td>
 <td>Proportional gain for vertical position error <p><strong>Comment:</strong> Defined as corrective velocity in m/s per m position error</p>   </td>
 <td>[0.1, 1.5] (0.1)</td>
 <td>1.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_ALL">MPC_Z_VEL_ALL</strong> (FLOAT)</td>
 <td>Overall Vertical Velocity Limit <p><strong>Comment:</strong> If set to a value greater than zero, other parameters are automatically set (such as MPC_Z_VEL_MAX_UP or MPC_LAND_SPEED). If set to a negative value, the existing individual parameters are used.</p>   </td>
 <td>[-3, 8] (0.5)</td>
 <td>-3.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_D_ACC">MPC_Z_VEL_D_ACC</strong> (FLOAT)</td>
 <td>Differential gain for vertical velocity error <p><strong>Comment:</strong> Defined as corrective acceleration in m/s^2 per m/s^2 velocity derivative</p>   </td>
 <td>[0, 2] (0.02)</td>
 <td>0.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_I_ACC">MPC_Z_VEL_I_ACC</strong> (FLOAT)</td>
 <td>Integral gain for vertical velocity error <p><strong>Comment:</strong> Defined as corrective acceleration in m/s^2 per m velocity integral</p>   </td>
 <td>[0.2, 3] (0.1)</td>
 <td>2.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_MAX_DN">MPC_Z_VEL_MAX_DN</strong> (FLOAT)</td>
 <td>Maximum descent velocity <p><strong>Comment:</strong> Absolute maximum for all climb rate controlled modes. In manually piloted modes full stick deflection commands this velocity. For default autonomous velocity see MPC_Z_V_AUTO_UP</p>   </td>
 <td>[0.5, 4] (0.1)</td>
 <td>1.5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_MAX_UP">MPC_Z_VEL_MAX_UP</strong> (FLOAT)</td>
 <td>Maximum ascent velocity <p><strong>Comment:</strong> Absolute maximum for all climb rate controlled modes. In manually piloted modes full stick deflection commands this velocity. For default autonomous velocity see MPC_Z_V_AUTO_UP</p>   </td>
 <td>[0.5, 8] (0.1)</td>
 <td>3.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_Z_VEL_P_ACC">MPC_Z_VEL_P_ACC</strong> (FLOAT)</td>
 <td>Proportional gain for vertical velocity error <p><strong>Comment:</strong> Defined as corrective acceleration in m/s^2 per m/s velocity error</p>   </td>
 <td>[2, 15] (0.1)</td>
 <td>4.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MPC_Z_V_AUTO_DN">MPC_Z_V_AUTO_DN</strong> (FLOAT)</td>
 <td>Descent velocity in autonomous modes <p><strong>Comment:</strong> For manual modes and offboard, see MPC_Z_VEL_MAX_DN</p>   </td>
 <td>[0.5, 4] (0.5)</td>
 <td>1.5</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MPC_Z_V_AUTO_UP">MPC_Z_V_AUTO_UP</strong> (FLOAT)</td>
 <td>Ascent velocity in autonomous modes <p><strong>Comment:</strong> For manually controlled modes and offboard see MPC_Z_VEL_MAX_UP</p>   </td>
 <td>[0.5, 8] (0.5)</td>
 <td>3.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="SYS_VEHICLE_RESP">SYS_VEHICLE_RESP</strong> (FLOAT)</td>
 <td>Responsiveness <p><strong>Comment:</strong> Changes the overall responsiveness of the vehicle. The higher the value, the faster the vehicle will react. If set to a value greater than zero, other parameters are automatically set (such as the acceleration or jerk limits). If set to a negative value, the existing individual parameters are used.</p>   </td>
 <td>[-1, 1] (0.05)</td>
 <td>-0.4</td>
 <td></td>
</tr>
<tr>
 <td><strong id="WV_EN">WV_EN</strong> (INT32)</td>
 <td>Enable weathervane    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="WV_ROLL_MIN">WV_ROLL_MIN</strong> (FLOAT)</td>
 <td>Minimum roll angle setpoint for weathervane controller to demand a yaw-rate    </td>
 <td>[0, 5] </td>
 <td>1.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="WV_YRATE_MAX">WV_YRATE_MAX</strong> (FLOAT)</td>
 <td>Maximum yawrate the weathervane controller is allowed to demand    </td>
 <td>[0, 120] </td>
 <td>90.0</td>
 <td>deg/s</td>
</tr>
</tbody></table>

## Multicopter Position Slow Mode

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_SLOW_DEF_HVEL">MC_SLOW_DEF_HVEL</strong> (FLOAT)</td>
 <td>Default horizontal velocity limit <p><strong>Comment:</strong> This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>3.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MC_SLOW_DEF_VVEL">MC_SLOW_DEF_VVEL</strong> (FLOAT)</td>
 <td>Default vertical velocity limit <p><strong>Comment:</strong> This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>1.</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MC_SLOW_DEF_YAWR">MC_SLOW_DEF_YAWR</strong> (FLOAT)</td>
 <td>Default yaw rate limit <p><strong>Comment:</strong> This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.</p>   </td>
 <td>[1, ?] (0.1)</td>
 <td>45.</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MAP_HVEL">MC_SLOW_MAP_HVEL</strong> (INT32)</td>
 <td>Manual input mapped to scale horizontal velocity in position slow mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> No rescaling</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MAP_VVEL">MC_SLOW_MAP_VVEL</strong> (INT32)</td>
 <td>Manual input mapped to scale vertical velocity in position slow mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> No rescaling</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MAP_YAWR">MC_SLOW_MAP_YAWR</strong> (INT32)</td>
 <td>Manual input mapped to scale yaw rate in position slow mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> No rescaling</li>
<li><strong>1:</strong> AUX1</li>
<li><strong>2:</strong> AUX2</li>
<li><strong>3:</strong> AUX3</li>
<li><strong>4:</strong> AUX4</li>
<li><strong>5:</strong> AUX5</li>
<li><strong>6:</strong> AUX6</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MIN_HVEL">MC_SLOW_MIN_HVEL</strong> (FLOAT)</td>
 <td>Horizontal velocity lower limit <p><strong>Comment:</strong> The lowest input maps and is clamped to this velocity.</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MIN_VVEL">MC_SLOW_MIN_VVEL</strong> (FLOAT)</td>
 <td>Vertical velocity lower limit <p><strong>Comment:</strong> The lowest input maps and is clamped to this velocity.</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>.3</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="MC_SLOW_MIN_YAWR">MC_SLOW_MIN_YAWR</strong> (FLOAT)</td>
 <td>Yaw rate lower limit <p><strong>Comment:</strong> The lowest input maps and is clamped to this rate.</p>   </td>
 <td>[1, ?] (0.1)</td>
 <td>3.</td>
 <td>deg/s</td>
</tr>
</tbody></table>

## Multicopter Rate Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MC_BAT_SCALE_EN">MC_BAT_SCALE_EN</strong> (INT32)</td>
 <td>Battery power level scaler <p><strong>Comment:</strong> This compensates for voltage drop of the battery over time by attempting to normalize performance across the operating range of the battery. The copter should constantly behave as if it was fully charged with reduced max acceleration at lower battery percentages. i.e. if hover is at 0.5 throttle at 100% battery, it will still be 0.5 at 60% battery.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PITCHRATE_D">MC_PITCHRATE_D</strong> (FLOAT)</td>
 <td>Pitch rate D gain <p><strong>Comment:</strong> Pitch rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.</p>   </td>
 <td>[0.0, ?] (0.0005)</td>
 <td>0.003</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PITCHRATE_FF">MC_PITCHRATE_FF</strong> (FLOAT)</td>
 <td>Pitch rate feedforward <p><strong>Comment:</strong> Improves tracking performance.</p>   </td>
 <td>[0.0, ?] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PITCHRATE_I">MC_PITCHRATE_I</strong> (FLOAT)</td>
 <td>Pitch rate I gain <p><strong>Comment:</strong> Pitch rate integral gain. Can be set to compensate static thrust difference or gravity center offset.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PITCHRATE_K">MC_PITCHRATE_K</strong> (FLOAT)</td>
 <td>Pitch rate controller gain <p><strong>Comment:</strong> Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_PITCHRATE_K * (MC_PITCHRATE_P * error + MC_PITCHRATE_I * error_integral + MC_PITCHRATE_D * error_derivative) Set MC_PITCHRATE_P=1 to implement a PID in the ideal form. Set MC_PITCHRATE_K=1 to implement a PID in the parallel form.</p>   </td>
 <td>[0.01, 5.0] (0.0005)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PITCHRATE_P">MC_PITCHRATE_P</strong> (FLOAT)</td>
 <td>Pitch rate P gain <p><strong>Comment:</strong> Pitch rate proportional gain, i.e. control output for angular speed error 1 rad/s.</p>   </td>
 <td>[0.01, 0.6] (0.01)</td>
 <td>0.15</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_PR_INT_LIM">MC_PR_INT_LIM</strong> (FLOAT)</td>
 <td>Pitch rate integrator limit <p><strong>Comment:</strong> Pitch rate integrator limit. Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large pitch moment trim changes.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.30</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_D">MC_ROLLRATE_D</strong> (FLOAT)</td>
 <td>Roll rate D gain <p><strong>Comment:</strong> Roll rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.</p>   </td>
 <td>[0.0, 0.01] (0.0005)</td>
 <td>0.003</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_FF">MC_ROLLRATE_FF</strong> (FLOAT)</td>
 <td>Roll rate feedforward <p><strong>Comment:</strong> Improves tracking performance.</p>   </td>
 <td>[0.0, ?] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_I">MC_ROLLRATE_I</strong> (FLOAT)</td>
 <td>Roll rate I gain <p><strong>Comment:</strong> Roll rate integral gain. Can be set to compensate static thrust difference or gravity center offset.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_K">MC_ROLLRATE_K</strong> (FLOAT)</td>
 <td>Roll rate controller gain <p><strong>Comment:</strong> Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_ROLLRATE_K * (MC_ROLLRATE_P * error + MC_ROLLRATE_I * error_integral + MC_ROLLRATE_D * error_derivative) Set MC_ROLLRATE_P=1 to implement a PID in the ideal form. Set MC_ROLLRATE_K=1 to implement a PID in the parallel form.</p>   </td>
 <td>[0.01, 5.0] (0.0005)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_ROLLRATE_P">MC_ROLLRATE_P</strong> (FLOAT)</td>
 <td>Roll rate P gain <p><strong>Comment:</strong> Roll rate proportional gain, i.e. control output for angular speed error 1 rad/s.</p>   </td>
 <td>[0.01, 0.5] (0.01)</td>
 <td>0.15</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_RR_INT_LIM">MC_RR_INT_LIM</strong> (FLOAT)</td>
 <td>Roll rate integrator limit <p><strong>Comment:</strong> Roll rate integrator limit. Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large roll moment trim changes.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.30</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_D">MC_YAWRATE_D</strong> (FLOAT)</td>
 <td>Yaw rate D gain <p><strong>Comment:</strong> Yaw rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_FF">MC_YAWRATE_FF</strong> (FLOAT)</td>
 <td>Yaw rate feedforward <p><strong>Comment:</strong> Improves tracking performance.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_I">MC_YAWRATE_I</strong> (FLOAT)</td>
 <td>Yaw rate I gain <p><strong>Comment:</strong> Yaw rate integral gain. Can be set to compensate static thrust difference or gravity center offset.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_K">MC_YAWRATE_K</strong> (FLOAT)</td>
 <td>Yaw rate controller gain <p><strong>Comment:</strong> Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_YAWRATE_K * (MC_YAWRATE_P * error + MC_YAWRATE_I * error_integral + MC_YAWRATE_D * error_derivative) Set MC_YAWRATE_P=1 to implement a PID in the ideal form. Set MC_YAWRATE_K=1 to implement a PID in the parallel form.</p>   </td>
 <td>[0.0, 5.0] (0.0005)</td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YAWRATE_P">MC_YAWRATE_P</strong> (FLOAT)</td>
 <td>Yaw rate P gain <p><strong>Comment:</strong> Yaw rate proportional gain, i.e. control output for angular speed error 1 rad/s.</p>   </td>
 <td>[0.0, 0.6] (0.01)</td>
 <td>0.2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="MC_YR_INT_LIM">MC_YR_INT_LIM</strong> (FLOAT)</td>
 <td>Yaw rate integrator limit <p><strong>Comment:</strong> Yaw rate integrator limit. Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large yaw moment trim changes.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.30</td>
 <td></td>
</tr>
</tbody></table>

## OSD

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MSP_OSD_CONFIG">MSP_OSD_CONFIG</strong> (INT32)</td>
 <td>Serial Configuration for MSP OSD <p><strong>Comment:</strong> Configure on which serial port to run MSP OSD.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_ATXXXX_CFG">OSD_ATXXXX_CFG</strong> (INT32)</td>
 <td>Enable/Disable the ATXXX OSD Chip <p><strong>Comment:</strong> Configure the ATXXXX OSD Chip (mounted on the OmnibusF4SD board) and select the transmission standard.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> NTSC</li>
<li><strong>2:</strong> PAL</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_CH_HEIGHT">OSD_CH_HEIGHT</strong> (INT32)</td>
 <td>OSD Crosshairs Height <p><strong>Comment:</strong> Controls the vertical position of the crosshair display. Resolution is limited by OSD to 15 discrete values. Negative values will display the crosshairs below the horizon</p>   </td>
 <td>[-8, 8] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_DWELL_TIME">OSD_DWELL_TIME</strong> (INT32)</td>
 <td>OSD Dwell Time (ms) <p><strong>Comment:</strong> Amount of time in milliseconds to dwell at the beginning of the display, when scrolling.</p>   </td>
 <td>[100, 10000] </td>
 <td>500</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_LOG_LEVEL">OSD_LOG_LEVEL</strong> (INT32)</td>
 <td>OSD Warning Level <p><strong>Comment:</strong> Minimum security of log level to display on the OSD.</p>   </td>
 <td></td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_SCROLL_RATE">OSD_SCROLL_RATE</strong> (INT32)</td>
 <td>OSD Scroll Rate (ms) <p><strong>Comment:</strong> Scroll rate in milliseconds for OSD messages longer than available character width. This is lower-bounded by the nominal loop rate of this module.</p>   </td>
 <td>[100, 1000] </td>
 <td>125</td>
 <td></td>
</tr>
<tr>
 <td><strong id="OSD_SYMBOLS">OSD_SYMBOLS</strong> (INT32)</td>
 <td>OSD Symbol Selection <p><strong>Comment:</strong> Configure / toggle support display options.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> CRAFT_NAME</li>
  <li><strong>1:</strong> DISARMED</li>
  <li><strong>2:</strong> GPS_LAT</li>
  <li><strong>3:</strong> GPS_LON</li>
  <li><strong>4:</strong> GPS_SATS</li>
  <li><strong>5:</strong> GPS_SPEED</li>
  <li><strong>6:</strong> HOME_DIST</li>
  <li><strong>7:</strong> HOME_DIR</li>
  <li><strong>8:</strong> MAIN_BATT_VOLTAGE</li>
  <li><strong>9:</strong> CURRENT_DRAW</li>
  <li><strong>10:</strong> MAH_DRAWN</li>
  <li><strong>11:</strong> RSSI_VALUE</li>
  <li><strong>12:</strong> ALTITUDE</li>
  <li><strong>13:</strong> NUMERICAL_VARIO</li>
  <li><strong>14:</strong> (unused) FLYMODE</li>
  <li><strong>15:</strong> (unused) ESC_TMP</li>
  <li><strong>16:</strong> (unused) PITCH_ANGLE</li>
  <li><strong>17:</strong> (unused) ROLL_ANGLE</li>
  <li><strong>18:</strong> CROSSHAIRS</li>
  <li><strong>19:</strong> AVG_CELL_VOLTAGE</li>
  <li><strong>20:</strong> (unused) HORIZON_SIDEBARS</li>
  <li><strong>21:</strong> POWER</li>
</ul>
 </td>
 <td>[0, 4194303] </td>
 <td>16383</td>
 <td></td>
</tr>
</tbody></table>

## PWM Outputs

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="MOT_SLEW_MAX">MOT_SLEW_MAX</strong> (FLOAT)</td>
 <td>Minimum motor rise time (slew rate limit) <p><strong>Comment:</strong> Minimum time allowed for the motor input signal to pass through a range of 1000 PWM units. A value x means that the motor signal can only go from 1000 to 2000 PWM in minimum x seconds. Zero means that slew rate limiting is disabled.</p>   </td>
 <td>[0.0, ?] </td>
 <td>0.0</td>
 <td>s/(1000*PWM)</td>
</tr>
<tr>
 <td><strong id="PWM_SBUS_MODE">PWM_SBUS_MODE</strong> (INT32)</td>
 <td>S.BUS out <p><strong>Comment:</strong> Set to 1 to enable S.BUS version 1 output instead of RSSI.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="THR_MDL_FAC">THR_MDL_FAC</strong> (FLOAT)</td>
 <td>Thrust to motor control signal model parameter <p><strong>Comment:</strong> Parameter used to model the nonlinear relationship between motor control signal (e.g. PWM) and static thrust. The model is: rel_thrust = factor * rel_signal^2 + (1-factor) * rel_signal, where rel_thrust is the normalized thrust between 0 and 1, and rel_signal is the relative motor control signal between 0 and 1.</p>   </td>
 <td>[0.0, 1.0] (0.1)</td>
 <td>0.0</td>
 <td></td>
</tr>
</tbody></table>

## Payload Deliverer

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="PD_GRIPPER_EN">PD_GRIPPER_EN</strong> (INT32)</td>
 <td>Enable Gripper actuation in Payload Deliverer    <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PD_GRIPPER_TO">PD_GRIPPER_TO</strong> (FLOAT)</td>
 <td>Timeout for successful gripper actuation acknowledgement <p><strong>Comment:</strong> Maximum time Gripper will wait while the successful griper actuation isn&#x27;t recognised. If the gripper has no feedback sensor, it will simply wait for this time before considering gripper actuation successful and publish a &#x27;VehicleCommandAck&#x27; signaling successful gripper action</p>   </td>
 <td>[0, ?] </td>
 <td>3</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="PD_GRIPPER_TYPE">PD_GRIPPER_TYPE</strong> (INT32)</td>
 <td>Type of Gripper (Servo, etc.)  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Undefined</li>
<li><strong>0:</strong> Servo</li>
</ul>  </td>
 <td>[-1, 0] </td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Precision Land

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="PLD_BTOUT">PLD_BTOUT</strong> (FLOAT)</td>
 <td>Landing Target Timeout <p><strong>Comment:</strong> Time after which the landing target is considered lost without any new measurements.</p>   </td>
 <td>[0.0, 50] (0.5)</td>
 <td>5.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="PLD_FAPPR_ALT">PLD_FAPPR_ALT</strong> (FLOAT)</td>
 <td>Final approach altitude <p><strong>Comment:</strong> Allow final approach (without horizontal positioning) if losing landing target closer than this to the ground.</p>   </td>
 <td>[0.0, 10] (0.1)</td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="PLD_HACC_RAD">PLD_HACC_RAD</strong> (FLOAT)</td>
 <td>Horizontal acceptance radius <p><strong>Comment:</strong> Start descending if closer above landing target than this.</p>   </td>
 <td>[0.0, 10] (0.1)</td>
 <td>0.2</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="PLD_MAX_SRCH">PLD_MAX_SRCH</strong> (INT32)</td>
 <td>Maximum number of search attempts <p><strong>Comment:</strong> Maximum number of times to search for the landing target if it is lost during the precision landing.</p>   </td>
 <td>[0, 100] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PLD_SRCH_ALT">PLD_SRCH_ALT</strong> (FLOAT)</td>
 <td>Search altitude <p><strong>Comment:</strong> Altitude above home to which to climb when searching for the landing target.</p>   </td>
 <td>[0.0, 100] (0.1)</td>
 <td>10.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="PLD_SRCH_TOUT">PLD_SRCH_TOUT</strong> (FLOAT)</td>
 <td>Search timeout <p><strong>Comment:</strong> Time allowed to search for the landing target before falling back to normal landing.</p>   </td>
 <td>[0.0, 100] (0.1)</td>
 <td>10.0</td>
 <td>s</td>
</tr>
</tbody></table>

## RC

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RC_CRSF_TEL_EN">RC_CRSF_TEL_EN</strong> (INT32)</td>
 <td>Crossfire RC telemetry enable <p><strong>Comment:</strong> Crossfire telemetry enable</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_GHST_TEL_EN">RC_GHST_TEL_EN</strong> (INT32)</td>
 <td>Ghost RC telemetry enable <p><strong>Comment:</strong> Ghost telemetry enable</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
</tbody></table>

## RC Input

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RC_INPUT_PROTO">RC_INPUT_PROTO</strong> (INT32)</td>
 <td>RC input protocol <p><strong>Comment:</strong> Select your RC input protocol or auto to scan.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Auto</li>
<li><strong>0:</strong> None</li>
<li><strong>1:</strong> PPM</li>
<li><strong>2:</strong> SBUS</li>
<li><strong>3:</strong> DSM</li>
<li><strong>4:</strong> ST24</li>
<li><strong>5:</strong> SUMD</li>
<li><strong>6:</strong> CRSF</li>
<li><strong>7:</strong> GHST</li>
</ul>  </td>
 <td>[-1, 7] </td>
 <td>-1</td>
 <td></td>
</tr>
</tbody></table>

## Radio Calibration

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RC10_DZ">RC10_DZ</strong> (FLOAT)</td>
 <td>RC channel 10 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC10_MAX">RC10_MAX</strong> (FLOAT)</td>
 <td>RC channel 10 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC10_MIN">RC10_MIN</strong> (FLOAT)</td>
 <td>RC channel 10 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC10_REV">RC10_REV</strong> (FLOAT)</td>
 <td>RC channel 10 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC10_TRIM">RC10_TRIM</strong> (FLOAT)</td>
 <td>RC channel 10 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC11_DZ">RC11_DZ</strong> (FLOAT)</td>
 <td>RC channel 11 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC11_MAX">RC11_MAX</strong> (FLOAT)</td>
 <td>RC channel 11 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC11_MIN">RC11_MIN</strong> (FLOAT)</td>
 <td>RC channel 11 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC11_REV">RC11_REV</strong> (FLOAT)</td>
 <td>RC channel 11 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC11_TRIM">RC11_TRIM</strong> (FLOAT)</td>
 <td>RC channel 11 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC12_DZ">RC12_DZ</strong> (FLOAT)</td>
 <td>RC channel 12 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC12_MAX">RC12_MAX</strong> (FLOAT)</td>
 <td>RC channel 12 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC12_MIN">RC12_MIN</strong> (FLOAT)</td>
 <td>RC channel 12 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC12_REV">RC12_REV</strong> (FLOAT)</td>
 <td>RC channel 12 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC12_TRIM">RC12_TRIM</strong> (FLOAT)</td>
 <td>RC channel 12 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC13_DZ">RC13_DZ</strong> (FLOAT)</td>
 <td>RC channel 13 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC13_MAX">RC13_MAX</strong> (FLOAT)</td>
 <td>RC channel 13 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC13_MIN">RC13_MIN</strong> (FLOAT)</td>
 <td>RC channel 13 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC13_REV">RC13_REV</strong> (FLOAT)</td>
 <td>RC channel 13 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC13_TRIM">RC13_TRIM</strong> (FLOAT)</td>
 <td>RC channel 13 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC14_DZ">RC14_DZ</strong> (FLOAT)</td>
 <td>RC channel 14 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC14_MAX">RC14_MAX</strong> (FLOAT)</td>
 <td>RC channel 14 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC14_MIN">RC14_MIN</strong> (FLOAT)</td>
 <td>RC channel 14 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC14_REV">RC14_REV</strong> (FLOAT)</td>
 <td>RC channel 14 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC14_TRIM">RC14_TRIM</strong> (FLOAT)</td>
 <td>RC channel 14 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC15_DZ">RC15_DZ</strong> (FLOAT)</td>
 <td>RC channel 15 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC15_MAX">RC15_MAX</strong> (FLOAT)</td>
 <td>RC channel 15 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC15_MIN">RC15_MIN</strong> (FLOAT)</td>
 <td>RC channel 15 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC15_REV">RC15_REV</strong> (FLOAT)</td>
 <td>RC channel 15 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC15_TRIM">RC15_TRIM</strong> (FLOAT)</td>
 <td>RC channel 15 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC16_DZ">RC16_DZ</strong> (FLOAT)</td>
 <td>RC channel 16 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC16_MAX">RC16_MAX</strong> (FLOAT)</td>
 <td>RC channel 16 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC16_MIN">RC16_MIN</strong> (FLOAT)</td>
 <td>RC channel 16 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC16_REV">RC16_REV</strong> (FLOAT)</td>
 <td>RC channel 16 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC16_TRIM">RC16_TRIM</strong> (FLOAT)</td>
 <td>RC channel 16 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC17_DZ">RC17_DZ</strong> (FLOAT)</td>
 <td>RC channel 17 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC17_MAX">RC17_MAX</strong> (FLOAT)</td>
 <td>RC channel 17 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC17_MIN">RC17_MIN</strong> (FLOAT)</td>
 <td>RC channel 17 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC17_REV">RC17_REV</strong> (FLOAT)</td>
 <td>RC channel 17 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC17_TRIM">RC17_TRIM</strong> (FLOAT)</td>
 <td>RC channel 17 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC18_DZ">RC18_DZ</strong> (FLOAT)</td>
 <td>RC channel 18 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC18_MAX">RC18_MAX</strong> (FLOAT)</td>
 <td>RC channel 18 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC18_MIN">RC18_MIN</strong> (FLOAT)</td>
 <td>RC channel 18 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC18_REV">RC18_REV</strong> (FLOAT)</td>
 <td>RC channel 18 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC18_TRIM">RC18_TRIM</strong> (FLOAT)</td>
 <td>RC channel 18 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC1_DZ">RC1_DZ</strong> (FLOAT)</td>
 <td>RC channel 1 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC1_MAX">RC1_MAX</strong> (FLOAT)</td>
 <td>RC channel 1 maximum <p><strong>Comment:</strong> Maximum value for RC channel 1</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC1_MIN">RC1_MIN</strong> (FLOAT)</td>
 <td>RC channel 1 minimum <p><strong>Comment:</strong> Minimum value for RC channel 1</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC1_REV">RC1_REV</strong> (FLOAT)</td>
 <td>RC channel 1 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC1_TRIM">RC1_TRIM</strong> (FLOAT)</td>
 <td>RC channel 1 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC2_DZ">RC2_DZ</strong> (FLOAT)</td>
 <td>RC channel 2 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC2_MAX">RC2_MAX</strong> (FLOAT)</td>
 <td>RC channel 2 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC2_MIN">RC2_MIN</strong> (FLOAT)</td>
 <td>RC channel 2 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC2_REV">RC2_REV</strong> (FLOAT)</td>
 <td>RC channel 2 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC2_TRIM">RC2_TRIM</strong> (FLOAT)</td>
 <td>RC channel 2 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC3_DZ">RC3_DZ</strong> (FLOAT)</td>
 <td>RC channel 3 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC3_MAX">RC3_MAX</strong> (FLOAT)</td>
 <td>RC channel 3 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC3_MIN">RC3_MIN</strong> (FLOAT)</td>
 <td>RC channel 3 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC3_REV">RC3_REV</strong> (FLOAT)</td>
 <td>RC channel 3 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC3_TRIM">RC3_TRIM</strong> (FLOAT)</td>
 <td>RC channel 3 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC4_DZ">RC4_DZ</strong> (FLOAT)</td>
 <td>RC channel 4 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC4_MAX">RC4_MAX</strong> (FLOAT)</td>
 <td>RC channel 4 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC4_MIN">RC4_MIN</strong> (FLOAT)</td>
 <td>RC channel 4 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC4_REV">RC4_REV</strong> (FLOAT)</td>
 <td>RC channel 4 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC4_TRIM">RC4_TRIM</strong> (FLOAT)</td>
 <td>RC channel 4 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC5_DZ">RC5_DZ</strong> (FLOAT)</td>
 <td>RC channel 5 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC5_MAX">RC5_MAX</strong> (FLOAT)</td>
 <td>RC channel 5 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC5_MIN">RC5_MIN</strong> (FLOAT)</td>
 <td>RC channel 5 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC5_REV">RC5_REV</strong> (FLOAT)</td>
 <td>RC channel 5 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC5_TRIM">RC5_TRIM</strong> (FLOAT)</td>
 <td>RC channel 5 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC6_DZ">RC6_DZ</strong> (FLOAT)</td>
 <td>RC channel 6 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC6_MAX">RC6_MAX</strong> (FLOAT)</td>
 <td>RC channel 6 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC6_MIN">RC6_MIN</strong> (FLOAT)</td>
 <td>RC channel 6 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC6_REV">RC6_REV</strong> (FLOAT)</td>
 <td>RC channel 6 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC6_TRIM">RC6_TRIM</strong> (FLOAT)</td>
 <td>RC channel 6 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC7_DZ">RC7_DZ</strong> (FLOAT)</td>
 <td>RC channel 7 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC7_MAX">RC7_MAX</strong> (FLOAT)</td>
 <td>RC channel 7 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC7_MIN">RC7_MIN</strong> (FLOAT)</td>
 <td>RC channel 7 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC7_REV">RC7_REV</strong> (FLOAT)</td>
 <td>RC channel 7 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>Values:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC7_TRIM">RC7_TRIM</strong> (FLOAT)</td>
 <td>RC channel 7 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC8_DZ">RC8_DZ</strong> (FLOAT)</td>
 <td>RC channel 8 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>10.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC8_MAX">RC8_MAX</strong> (FLOAT)</td>
 <td>RC channel 8 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC8_MIN">RC8_MIN</strong> (FLOAT)</td>
 <td>RC channel 8 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC8_REV">RC8_REV</strong> (FLOAT)</td>
 <td>RC channel 8 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC8_TRIM">RC8_TRIM</strong> (FLOAT)</td>
 <td>RC channel 8 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC9_DZ">RC9_DZ</strong> (FLOAT)</td>
 <td>RC channel 9 dead zone <p><strong>Comment:</strong> The +- range of this value around the trim value will be considered as zero.</p>   </td>
 <td>[0.0, 100.0] </td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC9_MAX">RC9_MAX</strong> (FLOAT)</td>
 <td>RC channel 9 maximum <p><strong>Comment:</strong> Maximum value for this channel.</p>   </td>
 <td>[1500.0, 2200.0] </td>
 <td>2000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC9_MIN">RC9_MIN</strong> (FLOAT)</td>
 <td>RC channel 9 minimum <p><strong>Comment:</strong> Minimum value for this channel.</p>   </td>
 <td>[800.0, 1500.0] </td>
 <td>1000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC9_REV">RC9_REV</strong> (FLOAT)</td>
 <td>RC channel 9 reverse <p><strong>Comment:</strong> Set to -1 to reverse channel.</p> <strong>값:</strong><ul>
<li><strong>-1.0:</strong> Reverse</li>
<li><strong>1.0:</strong> Normal</li>
</ul>  </td>
 <td>[-1.0, 1.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC9_TRIM">RC9_TRIM</strong> (FLOAT)</td>
 <td>RC channel 9 trim <p><strong>Comment:</strong> Mid point value</p>   </td>
 <td>[800.0, 2200.0] </td>
 <td>1500</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC_CHAN_CNT">RC_CHAN_CNT</strong> (INT32)</td>
 <td>RC channel count <p><strong>Comment:</strong> This parameter is used by Ground Station software to save the number of channels which were used during RC calibration. It is only meant for ground station use.</p>   </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_FAILS_THR">RC_FAILS_THR</strong> (INT32)</td>
 <td>Failsafe channel PWM threshold <p><strong>Comment:</strong> Use RC_MAP_FAILSAFE to specify which channel is used to indicate RC loss via this threshold. By default this is the throttle channel. Set to a PWM value slightly above the PWM value for the channel (e.g. throttle) in a failsafe event, but below the minimum PWM value for the channel during normal operation. Note: The default value of 0 disables the feature (it is below the expected range).</p>   </td>
 <td>[0, 2200] </td>
 <td>0</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX1">RC_MAP_AUX1</strong> (INT32)</td>
 <td>AUX1 Passthrough RC channel <p><strong>Comment:</strong> Default function: Camera pitch</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX2">RC_MAP_AUX2</strong> (INT32)</td>
 <td>AUX2 Passthrough RC channel <p><strong>Comment:</strong> Default function: Camera roll</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX3">RC_MAP_AUX3</strong> (INT32)</td>
 <td>AUX3 Passthrough RC channel <p><strong>Comment:</strong> Default function: Camera azimuth / yaw</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX4">RC_MAP_AUX4</strong> (INT32)</td>
 <td>AUX4 Passthrough RC channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX5">RC_MAP_AUX5</strong> (INT32)</td>
 <td>AUX5 Passthrough RC channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_AUX6">RC_MAP_AUX6</strong> (INT32)</td>
 <td>AUX6 Passthrough RC channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_ENG_MOT">RC_MAP_ENG_MOT</strong> (INT32)</td>
 <td>RC channel to engage the main motor (for helicopters)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_FAILSAFE">RC_MAP_FAILSAFE</strong> (INT32)</td>
 <td>Failsafe channel mapping <p><strong>Comment:</strong> Configures which RC channel is used by the receiver to indicate the signal was lost (on receivers that use output a fixed signal value to report lost signal). If set to 0, the channel mapped to throttle is used. Use RC_FAILS_THR to set the threshold indicating lost signal. By default it&#x27;s below the expected range and hence disabled.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_PARAM1">RC_MAP_PARAM1</strong> (INT32)</td>
 <td>PARAM1 tuning channel <p><strong>Comment:</strong> Can be used for parameter tuning with the RC. This one is further referenced as the 1st parameter channel. Set to 0 to deactivate *</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_PARAM2">RC_MAP_PARAM2</strong> (INT32)</td>
 <td>PARAM2 tuning channel <p><strong>Comment:</strong> Can be used for parameter tuning with the RC. This one is further referenced as the 2nd parameter channel. Set to 0 to deactivate *</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_PARAM3">RC_MAP_PARAM3</strong> (INT32)</td>
 <td>PARAM3 tuning channel <p><strong>Comment:</strong> Can be used for parameter tuning with the RC. This one is further referenced as the 3th parameter channel. Set to 0 to deactivate *</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_PITCH">RC_MAP_PITCH</strong> (INT32)</td>
 <td>Pitch control channel mapping <p><strong>Comment:</strong> The channel index (starting from 1 for channel 1) indicates which channel should be used for reading pitch inputs from. A value of zero indicates the switch is not assigned.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_ROLL">RC_MAP_ROLL</strong> (INT32)</td>
 <td>Roll control channel mapping <p><strong>Comment:</strong> The channel index (starting from 1 for channel 1) indicates which channel should be used for reading roll inputs from. A value of zero indicates the switch is not assigned.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_THROTTLE">RC_MAP_THROTTLE</strong> (INT32)</td>
 <td>Throttle control channel mapping <p><strong>Comment:</strong> The channel index (starting from 1 for channel 1) indicates which channel should be used for reading throttle inputs from. A value of zero indicates the switch is not assigned.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_YAW">RC_MAP_YAW</strong> (INT32)</td>
 <td>Yaw control channel mapping <p><strong>Comment:</strong> The channel index (starting from 1 for channel 1) indicates which channel should be used for reading yaw inputs from. A value of zero indicates the switch is not assigned.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_RSSI_PWM_CHAN">RC_RSSI_PWM_CHAN</strong> (INT32)</td>
 <td>PWM input channel that provides RSSI <p><strong>Comment:</strong> 0: do not read RSSI from input channel 1-18: read RSSI from specified input channel Specify the range for RSSI input with RC_RSSI_PWM_MIN and RC_RSSI_PWM_MAX parameters.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_RSSI_PWM_MAX">RC_RSSI_PWM_MAX</strong> (INT32)</td>
 <td>Max input value for RSSI reading <p><strong>Comment:</strong> Only used if RC_RSSI_PWM_CHAN &gt; 0</p>   </td>
 <td>[0, 2000] </td>
 <td>2000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_RSSI_PWM_MIN">RC_RSSI_PWM_MIN</strong> (INT32)</td>
 <td>Min input value for RSSI reading <p><strong>Comment:</strong> Only used if RC_RSSI_PWM_CHAN &gt; 0</p>   </td>
 <td>[0, 2000] </td>
 <td>1000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIM_PITCH">TRIM_PITCH</strong> (FLOAT)</td>
 <td>Pitch trim <p><strong>Comment:</strong> The trim value is the actuator control value the system needs for straight and level flight.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIM_ROLL">TRIM_ROLL</strong> (FLOAT)</td>
 <td>Roll trim <p><strong>Comment:</strong> The trim value is the actuator control value the system needs for straight and level flight.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="TRIM_YAW">TRIM_YAW</strong> (FLOAT)</td>
 <td>Yaw trim <p><strong>Comment:</strong> The trim value is the actuator control value the system needs for straight and level flight.</p>   </td>
 <td>[-0.5, 0.5] (0.01)</td>
 <td>0.0</td>
 <td></td>
</tr>
</tbody></table>

## Radio Switches

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RC_ARMSWITCH_TH">RC_ARMSWITCH_TH</strong> (FLOAT)</td>
 <td>Threshold for the arm switch <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_ENG_MOT_TH">RC_ENG_MOT_TH</strong> (FLOAT)</td>
 <td>Threshold for selecting main motor engage <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_GEAR_TH">RC_GEAR_TH</strong> (FLOAT)</td>
 <td>Threshold for the landing gear switch <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_KILLSWITCH_TH">RC_KILLSWITCH_TH</strong> (FLOAT)</td>
 <td>Threshold for the kill switch <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_LOITER_TH">RC_LOITER_TH</strong> (FLOAT)</td>
 <td>Threshold for selecting loiter mode <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_ARM_SW">RC_MAP_ARM_SW</strong> (INT32)</td>
 <td>Arm switch channel <p><strong>Comment:</strong> Use it to arm/disarm via switch instead of default throttle stick. If this is assigned, arming and disarming via stick is disabled.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_FLAPS">RC_MAP_FLAPS</strong> (INT32)</td>
 <td>Flaps channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_FLTMODE">RC_MAP_FLTMODE</strong> (INT32)</td>
 <td>Single channel flight mode selection <p><strong>Comment:</strong> If this parameter is non-zero, flight modes are only selected by this channel and are assigned to six slots.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_FLTM_BTN">RC_MAP_FLTM_BTN</strong> (INT32)</td>
 <td>Button flight mode selection <p><strong>Comment:</strong> This bitmask allows to specify multiple channels for changing flight modes using momentary buttons. Each channel is assigned to a mode slot ((lowest channel = slot 1). The resulting modes for each slot X is defined by the COM_FLTMODEX parameters. The functionality can be used only if RC_MAP_FLTMODE is disabled. The maximum number of available slots and hence bits set in the mask is 6.</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Mask Channel 1 as a mode button</li>
  <li><strong>1:</strong> Mask Channel 2 as a mode button</li>
  <li><strong>2:</strong> Mask Channel 3 as a mode button</li>
  <li><strong>3:</strong> Mask Channel 4 as a mode button</li>
  <li><strong>4:</strong> Mask Channel 5 as a mode button</li>
  <li><strong>5:</strong> Mask Channel 6 as a mode button</li>
  <li><strong>6:</strong> Mask Channel 7 as a mode button</li>
  <li><strong>7:</strong> Mask Channel 8 as a mode button</li>
  <li><strong>8:</strong> Mask Channel 9 as a mode button</li>
  <li><strong>9:</strong> Mask Channel 10 as a mode button</li>
  <li><strong>10:</strong> Mask Channel 11 as a mode button</li>
  <li><strong>11:</strong> Mask Channel 12 as a mode button</li>
  <li><strong>12:</strong> Mask Channel 13 as a mode button</li>
  <li><strong>13:</strong> Mask Channel 14 as a mode button</li>
  <li><strong>14:</strong> Mask Channel 15 as a mode button</li>
  <li><strong>15:</strong> Mask Channel 16 as a mode button</li>
  <li><strong>16:</strong> Mask Channel 17 as a mode button</li>
  <li><strong>17:</strong> Mask Channel 18 as a mode button</li>
</ul>
 </td>
 <td>[0, 258048] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_GEAR_SW">RC_MAP_GEAR_SW</strong> (INT32)</td>
 <td>Landing gear switch channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_KILL_SW">RC_MAP_KILL_SW</strong> (INT32)</td>
 <td>Emergency Kill switch channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_LOITER_SW">RC_MAP_LOITER_SW</strong> (INT32)</td>
 <td>Loiter switch channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_MODE_SW">RC_MAP_MODE_SW</strong> (INT32)</td>
 <td>Mode switch channel mapping (deprecated) <p><strong>Comment:</strong> This is the main flight mode selector. The channel index (starting from 1 for channel 1) indicates which channel should be used for deciding about the main mode. A value of zero indicates the switch is not assigned.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_OFFB_SW">RC_MAP_OFFB_SW</strong> (INT32)</td>
 <td>Offboard switch channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_RETURN_SW">RC_MAP_RETURN_SW</strong> (INT32)</td>
 <td>Return switch channel  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_MAP_TRANS_SW">RC_MAP_TRANS_SW</strong> (INT32)</td>
 <td>VTOL transition switch channel mapping  <strong>Values:</strong><ul>
<li><strong>0:</strong> Unassigned</li>
<li><strong>1:</strong> Channel 1</li>
<li><strong>2:</strong> Channel 2</li>
<li><strong>3:</strong> Channel 3</li>
<li><strong>4:</strong> Channel 4</li>
<li><strong>5:</strong> Channel 5</li>
<li><strong>6:</strong> Channel 6</li>
<li><strong>7:</strong> Channel 7</li>
<li><strong>8:</strong> Channel 8</li>
<li><strong>9:</strong> Channel 9</li>
<li><strong>10:</strong> Channel 10</li>
<li><strong>11:</strong> Channel 11</li>
<li><strong>12:</strong> Channel 12</li>
<li><strong>13:</strong> Channel 13</li>
<li><strong>14:</strong> Channel 14</li>
<li><strong>15:</strong> Channel 15</li>
<li><strong>16:</strong> Channel 16</li>
<li><strong>17:</strong> Channel 17</li>
<li><strong>18:</strong> Channel 18</li>
</ul>  </td>
 <td>[0, 18] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_OFFB_TH">RC_OFFB_TH</strong> (FLOAT)</td>
 <td>Threshold for selecting offboard mode <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_RETURN_TH">RC_RETURN_TH</strong> (FLOAT)</td>
 <td>Threshold for selecting return to launch mode <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RC_TRANS_TH">RC_TRANS_TH</strong> (FLOAT)</td>
 <td>Threshold for the VTOL transition switch <p><strong>Comment:</strong> 0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel&gt;th negative : true when channel&lt;th</p>   </td>
 <td>[-1, 1] </td>
 <td>0.75</td>
 <td></td>
</tr>
</tbody></table>

## Return Mode

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RTL_CONE_ANG">RTL_CONE_ANG</strong> (INT32)</td>
 <td>Half-angle of the return mode altitude cone <p><strong>Comment:</strong> Defines the half-angle of a cone centered around the destination position that affects the altitude at which the vehicle returns.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No cone, always climb to RTL_RETURN_ALT above destination.</li>
<li><strong>25:</strong> 25 degrees half cone angle.</li>
<li><strong>45:</strong> 45 degrees half cone angle.</li>
<li><strong>65:</strong> 65 degrees half cone angle.</li>
<li><strong>80:</strong> 80 degrees half cone angle.</li>
<li><strong>90:</strong> Only climb to at least RTL_DESCEND_ALT above destination.</li>
</ul>  </td>
 <td>[0, 90] </td>
 <td>45</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="RTL_DESCEND_ALT">RTL_DESCEND_ALT</strong> (FLOAT)</td>
 <td>Return mode loiter altitude <p><strong>Comment:</strong> Descend to this altitude (above destination position) after return, and wait for time defined in RTL_LAND_DELAY. Land (i.e. slowly descend) from this altitude if autolanding allowed. VTOLs do transition to hover in this altitdue above the landing point.</p>   </td>
 <td>[0, ?] (0.5)</td>
 <td>30.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RTL_LAND_DELAY">RTL_LAND_DELAY</strong> (FLOAT)</td>
 <td>Return mode delay <p><strong>Comment:</strong> Delay before landing (after initial descent) in Return mode. If set to -1 the system will not land but loiter at RTL_DESCEND_ALT.</p>   </td>
 <td>[-1, ?] (0.5)</td>
 <td>0.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="RTL_LOITER_RAD">RTL_LOITER_RAD</strong> (FLOAT)</td>
 <td>Loiter radius for rtl descend <p><strong>Comment:</strong> Set the radius for loitering to a safe altitude for VTOL transition.</p>   </td>
 <td>[25, ?] (0.5)</td>
 <td>80.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RTL_MIN_DIST">RTL_MIN_DIST</strong> (FLOAT)</td>
 <td>Horizontal radius from return point within which special rules for return mode apply <p><strong>Comment:</strong> The return altitude will be calculated based on RTL_CONE_ANG parameter. The yaw setpoint will switch to the one defined by corresponding waypoint.</p>   </td>
 <td>[0.5, ?] (0.5)</td>
 <td>10.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RTL_PLD_MD">RTL_PLD_MD</strong> (INT32)</td>
 <td>RTL precision land mode <p><strong>Comment:</strong> Use precision landing when doing an RTL landing phase.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No precision landing</li>
<li><strong>1:</strong> Opportunistic precision landing</li>
<li><strong>2:</strong> Required precision landing</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RTL_RETURN_ALT">RTL_RETURN_ALT</strong> (FLOAT)</td>
 <td>Return mode return altitude <p><strong>Comment:</strong> Default minimum altitude above destination (e.g. home, safe point, landing pattern) for return flight. The vehicle will climb to this altitude when Return mode is enganged, unless it currently is flying higher already. This is affected by RTL_MIN_DIST and RTL_CONE_ANG.</p>   </td>
 <td>[0, ?] (0.5)</td>
 <td>60.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RTL_TYPE">RTL_TYPE</strong> (INT32)</td>
 <td>Return type <p><strong>Comment:</strong> Return mode destination and flight path (home location, rally point, mission landing pattern, reverse mission)</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Return to closest safe point (home or rally point) via direct path.</li>
<li><strong>1:</strong> Return to closest safe point other than home (mission landing pattern or rally point), via direct path. If no mission landing or rally points are defined return home via direct path. Always chose closest safe landing point if vehicle is a VTOL in hover mode.</li>
<li><strong>2:</strong> Return to a planned mission landing, if available, using the mission path, else return to home via the reverse mission path. Do not consider rally points.</li>
<li><strong>3:</strong> Return via direct path to closest destination: home, start of mission landing pattern or safe point. If the destination is a mission landing pattern, follow the pattern to land.</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Return To Land

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RTL_APPR_FORCE">RTL_APPR_FORCE</strong> (INT32)</td>
 <td>RTL force approach landing <p><strong>Comment:</strong> Only consider RTL point, if it has an approach defined.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RTL_TIME_FACTOR">RTL_TIME_FACTOR</strong> (FLOAT)</td>
 <td>RTL time estimate safety margin factor <p><strong>Comment:</strong> Safety factor that is used to scale the actual RTL time estimate. Time with margin = RTL_TIME_FACTOR * time + RTL_TIME_MARGIN</p>   </td>
 <td>[1.0, 2.0] (0.1)</td>
 <td>1.1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RTL_TIME_MARGIN">RTL_TIME_MARGIN</strong> (INT32)</td>
 <td>RTL time estimate safety margin offset <p><strong>Comment:</strong> Margin that is added to the time estimate, after it has already been scaled Time with margin = RTL_TIME_FACTOR * time + RTL_TIME_MARGIN</p>   </td>
 <td>[0, 3600] (1)</td>
 <td>100</td>
 <td>s</td>
</tr>
</tbody></table>

## Roboclaw

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RBCLW_SER_CFG">RBCLW_SER_CFG</strong> (INT32)</td>
 <td>Serial Configuration for Roboclaw Driver <p><strong>Comment:</strong> Configure on which serial port to run Roboclaw Driver.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
</tbody></table>

## Roboclaw Driver

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>Name</th><th>Description</th><th>[Min, Max] (Incr.)</th><th>Default</th><th>Units</th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RBCLW_ADDRESS">RBCLW_ADDRESS</strong> (INT32)</td>
 <td>Address of the ESC on the bus <p><strong>Comment:</strong> The ESC has to be configured to have an address from 0x80 to 0x87. This parameter needs to match the configured value.</p> <strong>값:</strong><ul>
<li><strong>128:</strong> 0x80</li>
<li><strong>129:</strong> 0x81</li>
<li><strong>130:</strong> 0x82</li>
<li><strong>131:</strong> 0x83</li>
<li><strong>132:</strong> 0x84</li>
<li><strong>133:</strong> 0x85</li>
<li><strong>134:</strong> 0x86</li>
<li><strong>135:</strong> 0x87</li>
</ul>  </td>
 <td>[128, 135] </td>
 <td>128</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RBCLW_COUNTS_REV">RBCLW_COUNTS_REV</strong> (INT32)</td>
 <td>Number of encoder counts for one wheel revolution <p><strong>Comment:</strong> The default value of 1200 corresponds to the default configuration of the Aion R1 rover.</p>   </td>
 <td>[1, ?] </td>
 <td>1200</td>
 <td></td>
</tr>
</tbody></table>

## Rover Ackermann

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RA_ACC_RAD_GAIN">RA_ACC_RAD_GAIN</strong> (FLOAT)</td>
 <td>Tuning parameter for corner cutting <p><strong>Comment:</strong> The geometric ideal acceptance radius is multiplied by this factor to account for kinematic and dynamic effects. Higher value -&gt; The rover starts to cut the corner earlier.</p>   </td>
 <td>[1, 100] (0.01)</td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RA_ACC_RAD_MAX">RA_ACC_RAD_MAX</strong> (FLOAT)</td>
 <td>Maximum acceptance radius for the waypoints <p><strong>Comment:</strong> The controller scales the acceptance radius based on the angle between the previous, current and next waypoint. Higher value -&gt; smoother trajectory at the cost of how close the rover gets to the waypoint (Set to -1 to disable corner cutting).</p>   </td>
 <td>[-1, 100] (0.01)</td>
 <td>3</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RA_LOOKAHD_GAIN">RA_LOOKAHD_GAIN</strong> (FLOAT)</td>
 <td>Tuning parameter for the pure pursuit controller <p><strong>Comment:</strong> Lower value -&gt; More aggressive controller (beware overshoot/oscillations)</p>   </td>
 <td>[0.1, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RA_LOOKAHD_MAX">RA_LOOKAHD_MAX</strong> (FLOAT)</td>
 <td>Maximum lookahead distance for the pure pursuit controller <p><strong>Comment:</strong> This is the maximum crosstrack error before the controller starts targeting the current waypoint rather then the path between the previous and next waypoint.</p>   </td>
 <td>[0.1, 100] (0.01)</td>
 <td>10</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RA_LOOKAHD_MIN">RA_LOOKAHD_MIN</strong> (FLOAT)</td>
 <td>Minimum lookahead distance for the pure pursuit controller    </td>
 <td>[0.1, 100] (0.01)</td>
 <td>1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RA_MAX_ACCEL">RA_MAX_ACCEL</strong> (FLOAT)</td>
 <td>Maximum acceleration for the rover <p><strong>Comment:</strong> This is used for the acceleration slew rate, the feed-forward term for the speed controller during missions and the corner slow down effect. Note: For the corner slow down effect RA_MAX_JERK, RA_MISS_VEL_GAIN and RA_MISS_VEL_MIN also have to be set.</p>   </td>
 <td>[-1, 100] (0.01)</td>
 <td>-1</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="RA_MAX_JERK">RA_MAX_JERK</strong> (FLOAT)</td>
 <td>Maximum jerk <p><strong>Comment:</strong> Limit for forwards acc/deceleration change. This is used for the corner slow down effect. Note: RA_MAX_ACCEL, RA_MISS_VEL_GAIN and RA_MISS_VEL_MIN also have to be set for this to be enabled.</p>   </td>
 <td>[-1, 100] (0.01)</td>
 <td>-1</td>
 <td>m/s^3</td>
</tr>
<tr>
 <td><strong id="RA_MAX_SPEED">RA_MAX_SPEED</strong> (FLOAT)</td>
 <td>Speed the rover drives at maximum throttle <p><strong>Comment:</strong> This is used for the feed-forward term of the speed controller. A value of -1 disables the feed-forward term in which case the Integrator (RA_SPEED_I) becomes necessary to track speed setpoints.</p>   </td>
 <td>[-1, 100] (0.01)</td>
 <td>-1</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="RA_MAX_STR_ANG">RA_MAX_STR_ANG</strong> (FLOAT)</td>
 <td>Maximum steering angle <p><strong>Comment:</strong> The maximum angle that the rover can steer</p>   </td>
 <td>[0.1, 1.5708] (0.01)</td>
 <td>0.5236</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="RA_MAX_STR_RATE">RA_MAX_STR_RATE</strong> (FLOAT)</td>
 <td>Maximum steering rate for the rover    </td>
 <td>[-1, 1000] (0.01)</td>
 <td>-1</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="RA_MISS_VEL_DEF">RA_MISS_VEL_DEF</strong> (FLOAT)</td>
 <td>Default rover velocity during a mission    </td>
 <td>[0, 100] (0.01)</td>
 <td>2</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="RA_MISS_VEL_GAIN">RA_MISS_VEL_GAIN</strong> (FLOAT)</td>
 <td>Tuning parameter for the velocity reduction during cornering <p><strong>Comment:</strong> The cornering speed is equal to the inverse of the acceptance radius of the WP multiplied with this factor. Lower value -&gt; More velocity reduction during cornering.</p>   </td>
 <td>[0.05, 100] (0.01)</td>
 <td>5</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RA_MISS_VEL_MIN">RA_MISS_VEL_MIN</strong> (FLOAT)</td>
 <td>Minimum rover velocity during a mission <p><strong>Comment:</strong> The velocity off the rover is reduced based on the corner it has to take to smooth the trajectory (Set to -1 to disable)</p>   </td>
 <td>[-1, 100] (0.01)</td>
 <td>1</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="RA_SPEED_I">RA_SPEED_I</strong> (FLOAT)</td>
 <td>Integral gain for ground speed controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RA_SPEED_P">RA_SPEED_P</strong> (FLOAT)</td>
 <td>Proportional gain for ground speed controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RA_WHEEL_BASE">RA_WHEEL_BASE</strong> (FLOAT)</td>
 <td>Wheel base <p><strong>Comment:</strong> Distance from the front to the rear axle</p>   </td>
 <td>[0.001, 100] (0.001)</td>
 <td>0.5</td>
 <td>m</td>
</tr>
</tbody></table>

## Rover Differential Drive

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RDD_ANG_SCALE">RDD_ANG_SCALE</strong> (FLOAT)</td>
 <td>Manual angular velocity scale    </td>
 <td>[0, 1] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_I_ANG_VEL">RDD_I_ANG_VEL</strong> (FLOAT)</td>
 <td>Integral gain for angular velocity controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_I_SPEED">RDD_I_SPEED</strong> (FLOAT)</td>
 <td>Integral gain for ground speed controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_MAX_ACCEL">RDD_MAX_ACCEL</strong> (FLOAT)</td>
 <td>Maximum acceleration <p><strong>Comment:</strong> Maximum acceleration is used to limit the acceleration of the rover</p>   </td>
 <td>[0, 100] (0.01)</td>
 <td>0.5</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="RDD_MAX_JERK">RDD_MAX_JERK</strong> (FLOAT)</td>
 <td>Maximum jerk <p><strong>Comment:</strong> Limit for forwards acc/deceleration change.</p>   </td>
 <td>[0, 100] (0.01)</td>
 <td>0.5</td>
 <td>m/s^3</td>
</tr>
<tr>
 <td><strong id="RDD_P_ANG_VEL">RDD_P_ANG_VEL</strong> (FLOAT)</td>
 <td>Proportional gain for angular velocity controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_P_HEADING">RDD_P_HEADING</strong> (FLOAT)</td>
 <td>Proportional gain for heading controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_P_SPEED">RDD_P_SPEED</strong> (FLOAT)</td>
 <td>Proportional gain for speed controller    </td>
 <td>[0, 100] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_SPEED_SCALE">RDD_SPEED_SCALE</strong> (FLOAT)</td>
 <td>Manual speed scale    </td>
 <td>[0, 1] (0.01)</td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RDD_WHEEL_BASE">RDD_WHEEL_BASE</strong> (FLOAT)</td>
 <td>Wheel base <p><strong>Comment:</strong> Distance from the center of the right wheel to the center of the left wheel</p>   </td>
 <td>[0.001, 100] (0.001)</td>
 <td>0.5</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RDD_WHEEL_RADIUS">RDD_WHEEL_RADIUS</strong> (FLOAT)</td>
 <td>Wheel radius <p><strong>Comment:</strong> Size of the wheel, half the diameter of the wheel</p>   </td>
 <td>[0.001, 100] (0.001)</td>
 <td>0.1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="RDD_WHEEL_SPEED">RDD_WHEEL_SPEED</strong> (FLOAT)</td>
 <td>Maximum wheel speed    </td>
 <td>[0, 100] (0.01)</td>
 <td>0.3</td>
 <td>rad/s</td>
</tr>
</tbody></table>

## Rover Position Control

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="GND_L1_DAMPING">GND_L1_DAMPING</strong> (FLOAT)</td>
 <td>L1 damping <p><strong>Comment:</strong> Damping factor for L1 control.</p>   </td>
 <td>[0.6, 0.9] (0.05)</td>
 <td>0.75</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GND_L1_DIST">GND_L1_DIST</strong> (FLOAT)</td>
 <td>L1 distance <p><strong>Comment:</strong> This is the distance at which the next waypoint is activated. This should be set to about 2-4x of GND_WHEEL_BASE and not smaller than one meter (due to GPS accuracy).</p>   </td>
 <td>[1.0, 50.0] (0.1)</td>
 <td>1.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="GND_L1_PERIOD">GND_L1_PERIOD</strong> (FLOAT)</td>
 <td>L1 period <p><strong>Comment:</strong> This is the L1 distance and defines the tracking point ahead of the rover it&#x27;s following. Use values around 2-5m for a 0.3m wheel base. Tuning instructions: Shorten slowly during tuning until response is sharp without oscillation.</p>   </td>
 <td>[0.5, 50.0] (0.5)</td>
 <td>5.0</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="GND_MAN_Y_MAX">GND_MAN_Y_MAX</strong> (FLOAT)</td>
 <td>Max manual yaw rate    </td>
 <td>[0.0, 400] </td>
 <td>150.0</td>
 <td>deg/s</td>
</tr>
<tr>
 <td><strong id="GND_MAX_ANG">GND_MAX_ANG</strong> (FLOAT)</td>
 <td>Maximum turn angle for Ackerman steering <p><strong>Comment:</strong> At a control output of 0, the steering wheels are at 0 radians. At a control output of 1, the steering wheels are at GND_MAX_ANG radians.</p>   </td>
 <td>[0.0, 3.14159] (0.01)</td>
 <td>0.7854</td>
 <td>rad</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_D">GND_SPEED_D</strong> (FLOAT)</td>
 <td>Speed proportional gain <p><strong>Comment:</strong> This is the derivative gain for the speed closed loop controller</p>   </td>
 <td>[0.00, 50.0] (0.005)</td>
 <td>0.001</td>
 <td>%m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_I">GND_SPEED_I</strong> (FLOAT)</td>
 <td>Speed Integral gain <p><strong>Comment:</strong> This is the integral gain for the speed closed loop controller</p>   </td>
 <td>[0.00, 50.0] (0.005)</td>
 <td>3.0</td>
 <td>%m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_IMAX">GND_SPEED_IMAX</strong> (FLOAT)</td>
 <td>Speed integral maximum value <p><strong>Comment:</strong> This is the maxim value the integral can reach to prevent wind-up.</p>   </td>
 <td>[0.005, 50.0] (0.005)</td>
 <td>1.0</td>
 <td>%m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_MAX">GND_SPEED_MAX</strong> (FLOAT)</td>
 <td>Maximum ground speed    </td>
 <td>[0.0, 40] (0.5)</td>
 <td>10.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_P">GND_SPEED_P</strong> (FLOAT)</td>
 <td>Speed proportional gain <p><strong>Comment:</strong> This is the proportional gain for the speed closed loop controller</p>   </td>
 <td>[0.005, 50.0] (0.005)</td>
 <td>2.0</td>
 <td>%m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_THR_SC">GND_SPEED_THR_SC</strong> (FLOAT)</td>
 <td>Speed to throttle scaler <p><strong>Comment:</strong> This is a gain to map the speed control output to the throttle linearly.</p>   </td>
 <td>[0.005, 50.0] (0.005)</td>
 <td>1.0</td>
 <td>%m/s</td>
</tr>
<tr>
 <td><strong id="GND_SPEED_TRIM">GND_SPEED_TRIM</strong> (FLOAT)</td>
 <td>Trim ground speed    </td>
 <td>[0.0, 40] (0.5)</td>
 <td>3.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="GND_SP_CTRL_MODE">GND_SP_CTRL_MODE</strong> (INT32)</td>
 <td>Control mode for speed <p><strong>Comment:</strong> This allows the user to choose between closed loop gps speed or open loop cruise throttle speed</p> <strong>값:</strong><ul>
<li><strong>0:</strong> open loop control</li>
<li><strong>1:</strong> close the loop with gps speed</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="GND_THR_CRUISE">GND_THR_CRUISE</strong> (FLOAT)</td>
 <td>Cruise throttle <p><strong>Comment:</strong> This is the throttle setting required to achieve the desired cruise speed. 10% is ok for a traxxas stampede vxl with ESC set to training mode</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.1</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="GND_THR_MAX">GND_THR_MAX</strong> (FLOAT)</td>
 <td>Throttle limit max <p><strong>Comment:</strong> This is the maximum throttle % that can be used by the controller. For a Traxxas stampede vxl with the ESC set to training, 30 % is enough</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.3</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="GND_THR_MIN">GND_THR_MIN</strong> (FLOAT)</td>
 <td>Throttle limit min <p><strong>Comment:</strong> This is the minimum throttle % that can be used by the controller. Set to 0 for rover</p>   </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>0.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="GND_WHEEL_BASE">GND_WHEEL_BASE</strong> (FLOAT)</td>
 <td>Distance from front axle to rear axle <p><strong>Comment:</strong> A value of 0.31 is typical for 1/10 RC cars.</p>   </td>
 <td>[0.0, ?] (0.01)</td>
 <td>0.31</td>
 <td>m</td>
</tr>
</tbody></table>

## Runway Takeoff

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="RWTO_HDG">RWTO_HDG</strong> (INT32)</td>
 <td>Specifies which heading should be held during the runway takeoff ground roll <p><strong>Comment:</strong> 0: airframe heading when takeoff is initiated 1: position control along runway direction (bearing defined from vehicle position on takeoff initiation to MAV_CMD_TAKEOFF position defined by operator)</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Airframe</li>
<li><strong>1:</strong> Runway</li>
</ul>  </td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RWTO_MAX_THR">RWTO_MAX_THR</strong> (FLOAT)</td>
 <td>Max throttle during runway takeoff    </td>
 <td>[0.0, 1.0] (0.01)</td>
 <td>1.0</td>
 <td>norm</td>
</tr>
<tr>
 <td><strong id="RWTO_NPFG_PERIOD">RWTO_NPFG_PERIOD</strong> (FLOAT)</td>
 <td>NPFG period while steering on runway    </td>
 <td>[1.0, 100.0] (0.1)</td>
 <td>5.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="RWTO_NUDGE">RWTO_NUDGE</strong> (INT32)</td>
 <td>Enable use of yaw stick for nudging the wheel during runway ground roll <p><strong>Comment:</strong> This is useful when map, GNSS, or yaw errors on ground are misaligned with what the operator intends for takeoff course. Particularly useful for skinny runways or if the wheel servo is a bit off trim.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="RWTO_PSP">RWTO_PSP</strong> (FLOAT)</td>
 <td>Pitch setpoint during taxi / before takeoff rotation airspeed is reached <p><strong>Comment:</strong> A taildragger with steerable wheel might need to pitch up a little to keep its wheel on the ground before airspeed to takeoff is reached.</p>   </td>
 <td>[-10.0, 20.0] (0.5)</td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="RWTO_RAMP_TIME">RWTO_RAMP_TIME</strong> (FLOAT)</td>
 <td>Throttle ramp up time for runway takeoff    </td>
 <td>[1.0, 15.0] (0.1)</td>
 <td>2.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="RWTO_ROT_AIRSPD">RWTO_ROT_AIRSPD</strong> (FLOAT)</td>
 <td>Takeoff rotation airspeed <p><strong>Comment:</strong> The calibrated airspeed threshold during the takeoff ground roll when the plane should start rotating (pitching up). Must be less than the takeoff airspeed, will otherwise be capped at the takeoff airpeed (see FW_TKO_AIRSPD). If set &lt;= 0.0, defaults to 0.9 * takeoff airspeed (see FW_TKO_AIRSPD)</p>   </td>
 <td>[-1.0, ?] (0.1)</td>
 <td>-1.0</td>
 <td>m/s</td>
</tr>
<tr>
 <td><strong id="RWTO_ROT_TIME">RWTO_ROT_TIME</strong> (FLOAT)</td>
 <td>Takeoff rotation time <p><strong>Comment:</strong> This is the time desired to linearly ramp in takeoff pitch constraints during the takeoff rotation</p>   </td>
 <td>[0.1, ?] (0.1)</td>
 <td>1.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="RWTO_TKOFF">RWTO_TKOFF</strong> (INT32)</td>
 <td>Runway takeoff with landing gear    </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
</tbody></table>

## SD Logging

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="SDLOG_ALGORITHM">SDLOG_ALGORITHM</strong> (INT32)</td>
 <td>Logfile Encryption algorithm <p><strong>Comment:</strong> Selects the algorithm used for logfile encryption</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>2:</strong> XChaCha20</li>
<li><strong>3:</strong> AES</li>
</ul>  </td>
 <td></td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_BOOT_BAT">SDLOG_BOOT_BAT</strong> (INT32)</td>
 <td>Battery-only Logging <p><strong>Comment:</strong> When enabled, logging will not start from boot if battery power is not detected (e.g. powered via USB on a test bench). This prevents extraneous flight logs from being created during bench testing. Note that this only applies to log-from-boot modes. This has no effect on arm-based modes.</p>   </td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_DIRS_MAX">SDLOG_DIRS_MAX</strong> (INT32)</td>
 <td>Maximum number of log directories to keep <p><strong>Comment:</strong> If there are more log directories than this value, the system will delete the oldest directories during startup. In addition, the system will delete old logs if there is not enough free space left. The minimum amount is 300 MB. If this is set to 0, old directories will only be removed if the free space falls below the minimum. Note: this does not apply to mission log files.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_EXCH_KEY">SDLOG_EXCH_KEY</strong> (INT32)</td>
 <td>Logfile Encryption key exchange key <p><strong>Comment:</strong> If the logfile is encrypted using a symmetric key algorithm, the used encryption key is generated at logging start and stored on the sdcard RSA2048 encrypted using this key.</p>   </td>
 <td>[0, 255] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_KEY">SDLOG_KEY</strong> (INT32)</td>
 <td>Logfile Encryption key index <p><strong>Comment:</strong> Selects the key in keystore, used for encrypting the log. When using a symmetric encryption algorithm, the key is generated at logging start and kept stored in this index. For symmetric algorithms, the key is volatile and valid only for the duration of logging. The key is stored in encrypted format on the sdcard alongside the logfile, using an RSA2048 key defined by the SDLOG_EXCHANGE_KEY</p>   </td>
 <td>[0, 255] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_MISSION">SDLOG_MISSION</strong> (INT32)</td>
 <td>Mission Log <p><strong>Comment:</strong> If enabled, a small additional &quot;mission&quot; log file will be written to the SD card. The log contains just those messages that are useful for tasks like generating flight statistics and geotagging. The different modes can be used to further reduce the logged data (and thus the log file size). For example, choose geotagging mode to only log data required for geotagging. Note that the normal/full log is still created, and contains all the data in the mission log (and more).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> All mission messages</li>
<li><strong>2:</strong> Geotagging messages</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_MODE">SDLOG_MODE</strong> (INT32)</td>
 <td>Logging Mode <p><strong>Comment:</strong> Determines when to start and stop logging. By default, logging is started when arming the system, and stopped when disarming.</p> <strong>Values:</strong><ul>
<li><strong>-1:</strong> disabled</li>
<li><strong>0:</strong> when armed until disarm (default)</li>
<li><strong>1:</strong> from boot until disarm</li>
<li><strong>2:</strong> from boot until shutdown</li>
<li><strong>3:</strong> depending on AUX1 RC channel</li>
<li><strong>4:</strong> from 1st armed until shutdown</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_PROFILE">SDLOG_PROFILE</strong> (INT32)</td>
 <td>Logging topic profile (integer bitmask) <p><strong>Comment:</strong> This integer bitmask controls the set and rates of logged topics. The default allows for general log analysis while keeping the log file size reasonably small. Enabling multiple sets leads to higher bandwidth requirements and larger log files. Set bits true to enable: 0 : Default set (used for general log analysis) 1 : Full rate estimator (EKF2) replay topics 2 : Topics for thermal calibration (high rate raw IMU and Baro sensor data) 3 : Topics for system identification (high rate actuator control and IMU data) 4 : Full rates for analysis of fast maneuvers (RC, attitude, rates and actuators) 5 : Debugging topics (debug_*.msg topics, for custom code) 6 : Topics for sensor comparison (low rate raw IMU, Baro and magnetometer data) 7 : Topics for computer vision and collision avoidance 8 : Raw FIFO high-rate IMU (Gyro) 9 : Raw FIFO high-rate IMU (Accel) 10: Logging of mavlink tunnel message (useful for payload communication debugging)</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> Default set (general log analysis)</li>
  <li><strong>1:</strong> Estimator replay (EKF2)</li>
  <li><strong>2:</strong> Thermal calibration</li>
  <li><strong>3:</strong> System identification</li>
  <li><strong>4:</strong> High rate</li>
  <li><strong>5:</strong> Debug</li>
  <li><strong>6:</strong> Sensor comparison</li>
  <li><strong>7:</strong> Computer Vision and Avoidance</li>
  <li><strong>8:</strong> Raw FIFO high-rate IMU (Gyro)</li>
  <li><strong>9:</strong> Raw FIFO high-rate IMU (Accel)</li>
  <li><strong>10:</strong> Mavlink tunnel message logging</li>
</ul>
 <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 2047] </td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SDLOG_UTC_OFFSET">SDLOG_UTC_OFFSET</strong> (INT32)</td>
 <td>UTC offset (unit: min) <p><strong>Comment:</strong> the difference in hours and minutes from Coordinated Universal Time (UTC) for a your place and date. for example, In case of South Korea(UTC+09:00), UTC offset is 540 min (9*60) refer to https://en.wikipedia.org/wiki/List_of_UTC_time_offsets</p>   </td>
 <td>[-1000, 1000] </td>
 <td>0</td>
 <td>min</td>
</tr>
<tr>
 <td><strong id="SDLOG_UUID">SDLOG_UUID</strong> (INT32)</td>
 <td>Log UUID <p><strong>Comment:</strong> If set to 1, add an ID to the log, which uniquely identifies the vehicle</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
</tbody></table>

## SITL

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="SIM_BAT_DRAIN">SIM_BAT_DRAIN</strong> (FLOAT)</td>
 <td>Simulator Battery drain interval    </td>
 <td>[1, 86400] (1)</td>
 <td>60</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="SIM_BAT_ENABLE">SIM_BAT_ENABLE</strong> (INT32)</td>
 <td>Simulator Battery enabled <p><strong>Comment:</strong> Enable or disable the internal battery simulation. This is useful when the battery is simulated externally and interfaced with PX4 through MAVLink for example.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SIM_BAT_MIN_PCT">SIM_BAT_MIN_PCT</strong> (FLOAT)</td>
 <td>Simulator Battery minimal percentage <p><strong>Comment:</strong> Can be used to alter the battery level during SITL- or HITL-simulation on the fly. Particularly useful for testing different low-battery behaviour.</p>   </td>
 <td>[0, 100] (0.1)</td>
 <td>50.0</td>
 <td>%</td>
</tr>
</tbody></table>

## Sensor Calibration

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="CAL_ACC0_ID">CAL_ACC0_ID</strong> (INT32)</td>
 <td>Accelerometer 0 calibration device ID <p><strong>Comment:</strong> Device ID of the accelerometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_PRIO">CAL_ACC0_PRIO</strong> (INT32)</td>
 <td>Accelerometer 0 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_ROT">CAL_ACC0_ROT</strong> (INT32)</td>
 <td>Accelerometer 0 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_XOFF">CAL_ACC0_XOFF</strong> (FLOAT)</td>
 <td>Accelerometer 0 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_XSCALE">CAL_ACC0_XSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 0 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_YOFF">CAL_ACC0_YOFF</strong> (FLOAT)</td>
 <td>Accelerometer 0 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_YSCALE">CAL_ACC0_YSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 0 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_ZOFF">CAL_ACC0_ZOFF</strong> (FLOAT)</td>
 <td>Accelerometer 0 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC0_ZSCALE">CAL_ACC0_ZSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 0 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_ID">CAL_ACC1_ID</strong> (INT32)</td>
 <td>Accelerometer 1 calibration device ID <p><strong>Comment:</strong> Device ID of the accelerometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_PRIO">CAL_ACC1_PRIO</strong> (INT32)</td>
 <td>Accelerometer 1 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_ROT">CAL_ACC1_ROT</strong> (INT32)</td>
 <td>Accelerometer 1 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_XOFF">CAL_ACC1_XOFF</strong> (FLOAT)</td>
 <td>Accelerometer 1 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_XSCALE">CAL_ACC1_XSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 1 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_YOFF">CAL_ACC1_YOFF</strong> (FLOAT)</td>
 <td>Accelerometer 1 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_YSCALE">CAL_ACC1_YSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 1 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_ZOFF">CAL_ACC1_ZOFF</strong> (FLOAT)</td>
 <td>Accelerometer 1 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC1_ZSCALE">CAL_ACC1_ZSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 1 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_ID">CAL_ACC2_ID</strong> (INT32)</td>
 <td>Accelerometer 2 calibration device ID <p><strong>Comment:</strong> Device ID of the accelerometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_PRIO">CAL_ACC2_PRIO</strong> (INT32)</td>
 <td>Accelerometer 2 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_ROT">CAL_ACC2_ROT</strong> (INT32)</td>
 <td>Accelerometer 2 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_XOFF">CAL_ACC2_XOFF</strong> (FLOAT)</td>
 <td>Accelerometer 2 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_XSCALE">CAL_ACC2_XSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 2 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_YOFF">CAL_ACC2_YOFF</strong> (FLOAT)</td>
 <td>Accelerometer 2 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_YSCALE">CAL_ACC2_YSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 2 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_ZOFF">CAL_ACC2_ZOFF</strong> (FLOAT)</td>
 <td>Accelerometer 2 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC2_ZSCALE">CAL_ACC2_ZSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 2 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_ID">CAL_ACC3_ID</strong> (INT32)</td>
 <td>Accelerometer 3 calibration device ID <p><strong>Comment:</strong> Device ID of the accelerometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_PRIO">CAL_ACC3_PRIO</strong> (INT32)</td>
 <td>Accelerometer 3 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_ROT">CAL_ACC3_ROT</strong> (INT32)</td>
 <td>Accelerometer 3 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_XOFF">CAL_ACC3_XOFF</strong> (FLOAT)</td>
 <td>Accelerometer 3 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_XSCALE">CAL_ACC3_XSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 3 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_YOFF">CAL_ACC3_YOFF</strong> (FLOAT)</td>
 <td>Accelerometer 3 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_YSCALE">CAL_ACC3_YSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 3 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_ZOFF">CAL_ACC3_ZOFF</strong> (FLOAT)</td>
 <td>Accelerometer 3 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>m/s^2</td>
</tr>
<tr>
 <td><strong id="CAL_ACC3_ZSCALE">CAL_ACC3_ZSCALE</strong> (FLOAT)</td>
 <td>Accelerometer 3 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO0_ID">CAL_BARO0_ID</strong> (INT32)</td>
 <td>Barometer 0 calibration device ID <p><strong>Comment:</strong> Device ID of the barometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO0_OFF">CAL_BARO0_OFF</strong> (FLOAT)</td>
 <td>Barometer 0 offset    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO0_PRIO">CAL_BARO0_PRIO</strong> (INT32)</td>
 <td>Barometer 0 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO1_ID">CAL_BARO1_ID</strong> (INT32)</td>
 <td>Barometer 1 calibration device ID <p><strong>Comment:</strong> Device ID of the barometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO1_OFF">CAL_BARO1_OFF</strong> (FLOAT)</td>
 <td>Barometer 1 offset    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO1_PRIO">CAL_BARO1_PRIO</strong> (INT32)</td>
 <td>Barometer 1 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO2_ID">CAL_BARO2_ID</strong> (INT32)</td>
 <td>Barometer 2 calibration device ID <p><strong>Comment:</strong> Device ID of the barometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO2_OFF">CAL_BARO2_OFF</strong> (FLOAT)</td>
 <td>Barometer 2 offset    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO2_PRIO">CAL_BARO2_PRIO</strong> (INT32)</td>
 <td>Barometer 2 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO3_ID">CAL_BARO3_ID</strong> (INT32)</td>
 <td>Barometer 3 calibration device ID <p><strong>Comment:</strong> Device ID of the barometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO3_OFF">CAL_BARO3_OFF</strong> (FLOAT)</td>
 <td>Barometer 3 offset    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_BARO3_PRIO">CAL_BARO3_PRIO</strong> (INT32)</td>
 <td>Barometer 3 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_ID">CAL_GYRO0_ID</strong> (INT32)</td>
 <td>Gyroscope 0 calibration device ID <p><strong>Comment:</strong> Device ID of the gyroscope this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_PRIO">CAL_GYRO0_PRIO</strong> (INT32)</td>
 <td>Gyroscope 0 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_ROT">CAL_GYRO0_ROT</strong> (INT32)</td>
 <td>Gyroscope 0 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_XOFF">CAL_GYRO0_XOFF</strong> (FLOAT)</td>
 <td>Gyroscope 0 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_YOFF">CAL_GYRO0_YOFF</strong> (FLOAT)</td>
 <td>Gyroscope 0 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO0_ZOFF">CAL_GYRO0_ZOFF</strong> (FLOAT)</td>
 <td>Gyroscope 0 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_ID">CAL_GYRO1_ID</strong> (INT32)</td>
 <td>Gyroscope 1 calibration device ID <p><strong>Comment:</strong> Device ID of the gyroscope this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_PRIO">CAL_GYRO1_PRIO</strong> (INT32)</td>
 <td>Gyroscope 1 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_ROT">CAL_GYRO1_ROT</strong> (INT32)</td>
 <td>Gyroscope 1 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_XOFF">CAL_GYRO1_XOFF</strong> (FLOAT)</td>
 <td>Gyroscope 1 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_YOFF">CAL_GYRO1_YOFF</strong> (FLOAT)</td>
 <td>Gyroscope 1 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO1_ZOFF">CAL_GYRO1_ZOFF</strong> (FLOAT)</td>
 <td>Gyroscope 1 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_ID">CAL_GYRO2_ID</strong> (INT32)</td>
 <td>Gyroscope 2 calibration device ID <p><strong>Comment:</strong> Device ID of the gyroscope this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_PRIO">CAL_GYRO2_PRIO</strong> (INT32)</td>
 <td>Gyroscope 2 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_ROT">CAL_GYRO2_ROT</strong> (INT32)</td>
 <td>Gyroscope 2 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_XOFF">CAL_GYRO2_XOFF</strong> (FLOAT)</td>
 <td>Gyroscope 2 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_YOFF">CAL_GYRO2_YOFF</strong> (FLOAT)</td>
 <td>Gyroscope 2 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO2_ZOFF">CAL_GYRO2_ZOFF</strong> (FLOAT)</td>
 <td>Gyroscope 2 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_ID">CAL_GYRO3_ID</strong> (INT32)</td>
 <td>Gyroscope 3 calibration device ID <p><strong>Comment:</strong> Device ID of the gyroscope this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_PRIO">CAL_GYRO3_PRIO</strong> (INT32)</td>
 <td>Gyroscope 3 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_ROT">CAL_GYRO3_ROT</strong> (INT32)</td>
 <td>Gyroscope 3 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.</p> <strong>Values:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  </td>
 <td>[-1, 40] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_XOFF">CAL_GYRO3_XOFF</strong> (FLOAT)</td>
 <td>Gyroscope 3 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_YOFF">CAL_GYRO3_YOFF</strong> (FLOAT)</td>
 <td>Gyroscope 3 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_GYRO3_ZOFF">CAL_GYRO3_ZOFF</strong> (FLOAT)</td>
 <td>Gyroscope 3 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ID">CAL_MAG0_ID</strong> (INT32)</td>
 <td>Magnetometer 0 calibration device ID <p><strong>Comment:</strong> Device ID of the magnetometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_PITCH">CAL_MAG0_PITCH</strong> (FLOAT)</td>
 <td>Magnetometer 0 Custom Euler Pitch Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG0_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_PRIO">CAL_MAG0_PRIO</strong> (INT32)</td>
 <td>Magnetometer 0 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ROLL">CAL_MAG0_ROLL</strong> (FLOAT)</td>
 <td>Magnetometer 0 Custom Euler Roll Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG0_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ROT">CAL_MAG0_ROT</strong> (INT32)</td>
 <td>Magnetometer 0 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to &quot;Custom Euler Angle&quot; to define the rotation using CAL_MAG0_ROLL, CAL_MAG0_PITCH and CAL_MAG0_YAW.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
<li><strong>100:</strong> Custom Euler Angle</li>
</ul>  </td>
 <td>[-1, 100] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_XCOMP">CAL_MAG0_XCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 0 X Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_XODIAG">CAL_MAG0_XODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 0 X-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_XOFF">CAL_MAG0_XOFF</strong> (FLOAT)</td>
 <td>Magnetometer 0 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_XSCALE">CAL_MAG0_XSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 0 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_YAW">CAL_MAG0_YAW</strong> (FLOAT)</td>
 <td>Magnetometer 0 Custom Euler Yaw Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG0_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_YCOMP">CAL_MAG0_YCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 0 Y Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_YODIAG">CAL_MAG0_YODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 0 Y-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_YOFF">CAL_MAG0_YOFF</strong> (FLOAT)</td>
 <td>Magnetometer 0 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_YSCALE">CAL_MAG0_YSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 0 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ZCOMP">CAL_MAG0_ZCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 0 Z Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ZODIAG">CAL_MAG0_ZODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 0 Z-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ZOFF">CAL_MAG0_ZOFF</strong> (FLOAT)</td>
 <td>Magnetometer 0 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG0_ZSCALE">CAL_MAG0_ZSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 0 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ID">CAL_MAG1_ID</strong> (INT32)</td>
 <td>Magnetometer 1 calibration device ID <p><strong>Comment:</strong> Device ID of the magnetometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_PITCH">CAL_MAG1_PITCH</strong> (FLOAT)</td>
 <td>Magnetometer 1 Custom Euler Pitch Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG1_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_PRIO">CAL_MAG1_PRIO</strong> (INT32)</td>
 <td>Magnetometer 1 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ROLL">CAL_MAG1_ROLL</strong> (FLOAT)</td>
 <td>Magnetometer 1 Custom Euler Roll Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG1_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ROT">CAL_MAG1_ROT</strong> (INT32)</td>
 <td>Magnetometer 1 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to &quot;Custom Euler Angle&quot; to define the rotation using CAL_MAG1_ROLL, CAL_MAG1_PITCH and CAL_MAG1_YAW.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
<li><strong>100:</strong> Custom Euler Angle</li>
</ul>  </td>
 <td>[-1, 100] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_XCOMP">CAL_MAG1_XCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 1 X Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_XODIAG">CAL_MAG1_XODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 1 X-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_XOFF">CAL_MAG1_XOFF</strong> (FLOAT)</td>
 <td>Magnetometer 1 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_XSCALE">CAL_MAG1_XSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 1 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_YAW">CAL_MAG1_YAW</strong> (FLOAT)</td>
 <td>Magnetometer 1 Custom Euler Yaw Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG1_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_YCOMP">CAL_MAG1_YCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 1 Y Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_YODIAG">CAL_MAG1_YODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 1 Y-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_YOFF">CAL_MAG1_YOFF</strong> (FLOAT)</td>
 <td>Magnetometer 1 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_YSCALE">CAL_MAG1_YSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 1 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ZCOMP">CAL_MAG1_ZCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 1 Z Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ZODIAG">CAL_MAG1_ZODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 1 Z-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ZOFF">CAL_MAG1_ZOFF</strong> (FLOAT)</td>
 <td>Magnetometer 1 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG1_ZSCALE">CAL_MAG1_ZSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 1 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ID">CAL_MAG2_ID</strong> (INT32)</td>
 <td>Magnetometer 2 calibration device ID <p><strong>Comment:</strong> Device ID of the magnetometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_PITCH">CAL_MAG2_PITCH</strong> (FLOAT)</td>
 <td>Magnetometer 2 Custom Euler Pitch Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG2_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_PRIO">CAL_MAG2_PRIO</strong> (INT32)</td>
 <td>Magnetometer 2 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ROLL">CAL_MAG2_ROLL</strong> (FLOAT)</td>
 <td>Magnetometer 2 Custom Euler Roll Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG2_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ROT">CAL_MAG2_ROT</strong> (INT32)</td>
 <td>Magnetometer 2 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to &quot;Custom Euler Angle&quot; to define the rotation using CAL_MAG2_ROLL, CAL_MAG2_PITCH and CAL_MAG2_YAW.</p> <strong>Values:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
<li><strong>100:</strong> Custom Euler Angle</li>
</ul>  </td>
 <td>[-1, 100] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_XCOMP">CAL_MAG2_XCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 2 X Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_XODIAG">CAL_MAG2_XODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 2 X-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_XOFF">CAL_MAG2_XOFF</strong> (FLOAT)</td>
 <td>Magnetometer 2 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_XSCALE">CAL_MAG2_XSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 2 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_YAW">CAL_MAG2_YAW</strong> (FLOAT)</td>
 <td>Magnetometer 2 Custom Euler Yaw Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG2_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_YCOMP">CAL_MAG2_YCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 2 Y Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_YODIAG">CAL_MAG2_YODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 2 Y-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_YOFF">CAL_MAG2_YOFF</strong> (FLOAT)</td>
 <td>Magnetometer 2 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_YSCALE">CAL_MAG2_YSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 2 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ZCOMP">CAL_MAG2_ZCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 2 Z Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ZODIAG">CAL_MAG2_ZODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 2 Z-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ZOFF">CAL_MAG2_ZOFF</strong> (FLOAT)</td>
 <td>Magnetometer 2 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG2_ZSCALE">CAL_MAG2_ZSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 2 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ID">CAL_MAG3_ID</strong> (INT32)</td>
 <td>Magnetometer 3 calibration device ID <p><strong>Comment:</strong> Device ID of the magnetometer this calibration applies to.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_PITCH">CAL_MAG3_PITCH</strong> (FLOAT)</td>
 <td>Magnetometer 3 Custom Euler Pitch Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG3_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_PRIO">CAL_MAG3_PRIO</strong> (INT32)</td>
 <td>Magnetometer 3 priority  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Uninitialized</li>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Min</li>
<li><strong>25:</strong> Low</li>
<li><strong>50:</strong> Medium (Default)</li>
<li><strong>75:</strong> High</li>
<li><strong>100:</strong> Max</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ROLL">CAL_MAG3_ROLL</strong> (FLOAT)</td>
 <td>Magnetometer 3 Custom Euler Roll Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG3_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ROT">CAL_MAG3_ROT</strong> (INT32)</td>
 <td>Magnetometer 3 rotation relative to airframe <p><strong>Comment:</strong> An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to &quot;Custom Euler Angle&quot; to define the rotation using CAL_MAG3_ROLL, CAL_MAG3_PITCH and CAL_MAG3_YAW.</p> <strong>값:</strong><ul>
<li><strong>-1:</strong> Internal</li>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
<li><strong>100:</strong> Custom Euler Angle</li>
</ul>  </td>
 <td>[-1, 100] </td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_XCOMP">CAL_MAG3_XCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 3 X Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_XODIAG">CAL_MAG3_XODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 3 X-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_XOFF">CAL_MAG3_XOFF</strong> (FLOAT)</td>
 <td>Magnetometer 3 X-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_XSCALE">CAL_MAG3_XSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 3 X-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_YAW">CAL_MAG3_YAW</strong> (FLOAT)</td>
 <td>Magnetometer 3 Custom Euler Yaw Angle <p><strong>Comment:</strong> Setting this parameter changes CAL_MAG3_ROT to &quot;Custom Euler Angle&quot;</p>   </td>
 <td>[-180, 180] </td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_YCOMP">CAL_MAG3_YCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 3 Y Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_YODIAG">CAL_MAG3_YODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 3 Y-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_YOFF">CAL_MAG3_YOFF</strong> (FLOAT)</td>
 <td>Magnetometer 3 Y-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_YSCALE">CAL_MAG3_YSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 3 Y-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ZCOMP">CAL_MAG3_ZCOMP</strong> (FLOAT)</td>
 <td>Magnetometer 3 Z Axis throttle compensation <p><strong>Comment:</strong> Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ZODIAG">CAL_MAG3_ZODIAG</strong> (FLOAT)</td>
 <td>Magnetometer 3 Z-axis off diagonal scale factor    </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ZOFF">CAL_MAG3_ZOFF</strong> (FLOAT)</td>
 <td>Magnetometer 3 Z-axis offset    </td>
 <td></td>
 <td>0.0</td>
 <td>gauss</td>
</tr>
<tr>
 <td><strong id="CAL_MAG3_ZSCALE">CAL_MAG3_ZSCALE</strong> (FLOAT)</td>
 <td>Magnetometer 3 Z-axis scaling factor    </td>
 <td>[0.1, 3.0] </td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_MAG_COMP_TYP">CAL_MAG_COMP_TYP</strong> (INT32)</td>
 <td>Type of magnetometer compensation  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Throttle-based compensation</li>
<li><strong>2:</strong> Current-based compensation (battery_status instance 0)</li>
<li><strong>3:</strong> Current-based compensation (battery_status instance 1)</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_DPRES_ANSC">SENS_DPRES_ANSC</strong> (FLOAT)</td>
 <td>Differential pressure sensor analog scaling <p><strong>Comment:</strong> Pick the appropriate scaling from the datasheet. this number defines the (linear) conversion from voltage to Pascal (pa). For the MPXV7002DP this is 1000. NOTE: If the sensor always registers zero, try switching the static and dynamic tubes.</p>   </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_DPRES_OFF">SENS_DPRES_OFF</strong> (FLOAT)</td>
 <td>Differential pressure sensor offset <p><strong>Comment:</strong> The offset (zero-reading) in Pascal</p>   </td>
 <td></td>
 <td>0.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_FLOW_MAXHGT">SENS_FLOW_MAXHGT</strong> (FLOAT)</td>
 <td>Maximum height above ground when reliant on optical flow <p><strong>Comment:</strong> This parameter defines the maximum distance from ground at which the optical flow sensor operates reliably. The height setpoint will be limited to be no greater than this value when the navigation system is completely reliant on optical flow data and the height above ground estimate is valid. The sensor may be usable above this height, but accuracy will progressively degrade.</p>   </td>
 <td>[1.0, 100.0] (0.1)</td>
 <td>100.</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="SENS_FLOW_MAXR">SENS_FLOW_MAXR</strong> (FLOAT)</td>
 <td>Magnitude of maximum angular flow rate reliably measurable by the optical flow sensor <p><strong>Comment:</strong> Optical flow data will not fused by the estimators if the magnitude of the flow rate exceeds this value and control loops will be instructed to limit ground speed such that the flow rate produced by movement over ground is less than 50% of this value.</p>   </td>
 <td>[1.0, ?] </td>
 <td>8.</td>
 <td>rad/s</td>
</tr>
<tr>
 <td><strong id="SENS_FLOW_MINHGT">SENS_FLOW_MINHGT</strong> (FLOAT)</td>
 <td>Minimum height above ground when reliant on optical flow <p><strong>Comment:</strong> This parameter defines the minimum distance from ground at which the optical flow sensor operates reliably. The sensor may be usable below this height, but accuracy will progressively reduce to loss of focus.</p>   </td>
 <td>[0.0, 1.0] (0.1)</td>
 <td>0.08</td>
 <td>m</td>
</tr>
</tbody></table>

## Sensors

<table>
 <colgroup><col style="width: 23%"><col style="width: 46%"><col style="width: 11%"><col style="width: 11%"><col style="width: 9%"></colgroup>
 <thead>
   <tr><th>이름</th><th>설명 </th><th>[Min, Max] (Incr.)</th><th>기본값</th><th>단위 </th></tr>
 </thead>
<tbody>
<tr>
 <td><strong id="ADC_ADS1115_EN">ADC_ADS1115_EN</strong> (INT32)</td>
 <td>Enable external ADS1115 ADC <p><strong>Comment:</strong> If enabled, the internal ADC is not used.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_C_MULT">BAT1_C_MULT</strong> (FLOAT)</td>
 <td>Capacity/current multiplier for high-current capable SMBUS battery    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BAT1_SMBUS_MODEL">BAT1_SMBUS_MODEL</strong> (INT32)</td>
 <td>Battery device model  <strong>Values:</strong><ul>
<li><strong>0:</strong> AutoDetect</li>
<li><strong>1:</strong> BQ40Z50 based</li>
<li><strong>2:</strong> BQ40Z80 based</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BATMON_ADDR_DFLT">BATMON_ADDR_DFLT</strong> (INT32)</td>
 <td>I2C address for BatMon battery 1    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>11</td>
 <td></td>
</tr>
<tr>
 <td><strong id="BATMON_DRIVER_EN">BATMON_DRIVER_EN</strong> (INT32)</td>
 <td>Parameter to enable BatMon module  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Start on default I2C addr(BATMON_ADDR_DFLT)</li>
<li><strong>2:</strong> Autodetect I2C address (TODO)</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_AIR_CMODEL">CAL_AIR_CMODEL</strong> (INT32)</td>
 <td>Airspeed sensor compensation model for the SDP3x <p><strong>Comment:</strong> Model with Pitot CAL_AIR_TUBED_MM: Not used, 1.5 mm tubes assumed. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor. Model without Pitot (1.5 mm tubes) CAL_AIR_TUBED_MM: Not used, 1.5 mm tubes assumed. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor. Tube Pressure Drop CAL_AIR_TUBED_MM: Diameter in mm of the pitot and tubes, must have the same diameter. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor and the static + dynamic port length of the pitot.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Model with Pitot</li>
<li><strong>1:</strong> Model without Pitot (1.5 mm tubes)</li>
<li><strong>2:</strong> Tube Pressure Drop</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="CAL_AIR_TUBED_MM">CAL_AIR_TUBED_MM</strong> (FLOAT)</td>
 <td>Airspeed sensor tube diameter. Only used for the Tube Pressure Drop Compensation    </td>
 <td>[1.5, 100] </td>
 <td>1.5</td>
 <td>mm</td>
</tr>
<tr>
 <td><strong id="CAL_AIR_TUBELEN">CAL_AIR_TUBELEN</strong> (FLOAT)</td>
 <td>Airspeed sensor tube length <p><strong>Comment:</strong> See the CAL_AIR_CMODEL explanation on how this parameter should be set.</p>   </td>
 <td>[0.01, 2.00] </td>
 <td>0.2</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="CAL_MAG_SIDES">CAL_MAG_SIDES</strong> (INT32)</td>
 <td>For legacy QGC support only <p><strong>Comment:</strong> Use SENS_MAG_SIDES instead</p>   </td>
 <td></td>
 <td>63</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_ACCEL_CUTOFF">IMU_ACCEL_CUTOFF</strong> (FLOAT)</td>
 <td>Low pass filter cutoff frequency for accel <p><strong>Comment:</strong> The cutoff frequency for the 2nd order butterworth filter on the primary accelerometer. This only affects the signal sent to the controllers, not the estimators. 0 disables the filter.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>30.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_DGYRO_CUTOFF">IMU_DGYRO_CUTOFF</strong> (FLOAT)</td>
 <td>Cutoff frequency for angular acceleration (D-Term filter) <p><strong>Comment:</strong> The cutoff frequency for the 2nd order butterworth filter used on the time derivative of the measured angular velocity, also known as the D-term filter in the rate controller. The D-term uses the derivative of the rate and thus is the most susceptible to noise. Therefore, using a D-term filter allows to increase IMU_GYRO_CUTOFF, which leads to reduced control latency and permits to increase the P gains. A value of 0 disables the filter.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>30.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_CAL_EN">IMU_GYRO_CAL_EN</strong> (INT32)</td>
 <td>IMU gyro auto calibration enable    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_CUTOFF">IMU_GYRO_CUTOFF</strong> (FLOAT)</td>
 <td>Low pass filter cutoff frequency for gyro <p><strong>Comment:</strong> The cutoff frequency for the 2nd order butterworth filter on the primary gyro. This only affects the angular velocity sent to the controllers, not the estimators. It applies also to the angular acceleration (D-Term filter), see IMU_DGYRO_CUTOFF. A value of 0 disables the filter.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>40.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_DNF_BW">IMU_GYRO_DNF_BW</strong> (FLOAT)</td>
 <td>IMU gyro ESC notch filter bandwidth <p><strong>Comment:</strong> Bandwidth per notch filter when using dynamic notch filtering with ESC RPM.</p>   </td>
 <td>[5, 30] </td>
 <td>15.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_DNF_EN">IMU_GYRO_DNF_EN</strong> (INT32)</td>
 <td>IMU gyro dynamic notch filtering <p><strong>Comment:</strong> Enable bank of dynamically updating notch filters. Requires ESC RPM feedback or onboard FFT (IMU_GYRO_FFT_EN).</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> ESC RPM</li>
  <li><strong>1:</strong> FFT</li>
</ul>
 </td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_DNF_HMC">IMU_GYRO_DNF_HMC</strong> (INT32)</td>
 <td>IMU gyro dynamic notch filter harmonics <p><strong>Comment:</strong> ESC RPM number of harmonics (multiples of RPM) for ESC RPM dynamic notch filtering.</p>   </td>
 <td>[1, 7] </td>
 <td>3</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_DNF_MIN">IMU_GYRO_DNF_MIN</strong> (FLOAT)</td>
 <td>IMU gyro dynamic notch filter minimum frequency <p><strong>Comment:</strong> Minimum notch filter frequency in Hz.</p>   </td>
 <td></td>
 <td>25.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_FFT_EN">IMU_GYRO_FFT_EN</strong> (INT32)</td>
 <td>IMU gyro FFT enable    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_FFT_LEN">IMU_GYRO_FFT_LEN</strong> (INT32)</td>
 <td>IMU gyro FFT length  <strong>Values:</strong><ul>
<li><strong>256:</strong> 256</li>
<li><strong>512:</strong> 512</li>
<li><strong>1024:</strong> 1024</li>
<li><strong>4096:</strong> 4096</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>512</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_FFT_MAX">IMU_GYRO_FFT_MAX</strong> (FLOAT)</td>
 <td>IMU gyro FFT maximum frequency    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 1000] </td>
 <td>150.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_FFT_MIN">IMU_GYRO_FFT_MIN</strong> (FLOAT)</td>
 <td>IMU gyro FFT minimum frequency    <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 1000] </td>
 <td>30.</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_FFT_SNR">IMU_GYRO_FFT_SNR</strong> (FLOAT)</td>
 <td>IMU gyro FFT SNR    </td>
 <td>[1, 30] </td>
 <td>10.</td>
 <td></td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_NF0_BW">IMU_GYRO_NF0_BW</strong> (FLOAT)</td>
 <td>Notch filter bandwidth for gyro <p><strong>Comment:</strong> The frequency width of the stop band for the 2nd order notch filter on the primary gyro. See &quot;IMU_GYRO_NF0_FRQ&quot; to activate the filter and to set the notch frequency. Applies to both angular velocity and angular acceleration sent to the controllers.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 100] </td>
 <td>20.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_NF0_FRQ">IMU_GYRO_NF0_FRQ</strong> (FLOAT)</td>
 <td>Notch filter frequency for gyro <p><strong>Comment:</strong> The center frequency for the 2nd order notch filter on the primary gyro. This filter can be enabled to avoid feedback amplification of structural resonances at a specific frequency. This only affects the signal sent to the controllers, not the estimators. Applies to both angular velocity and angular acceleration sent to the controllers. See &quot;IMU_GYRO_NF0_BW&quot; to set the bandwidth of the filter. A value of 0 disables the filter.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>0.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_NF1_BW">IMU_GYRO_NF1_BW</strong> (FLOAT)</td>
 <td>Notch filter 1 bandwidth for gyro <p><strong>Comment:</strong> The frequency width of the stop band for the 2nd order notch filter on the primary gyro. See &quot;IMU_GYRO_NF1_FRQ&quot; to activate the filter and to set the notch frequency. Applies to both angular velocity and angular acceleration sent to the controllers.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 100] </td>
 <td>20.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_NF1_FRQ">IMU_GYRO_NF1_FRQ</strong> (FLOAT)</td>
 <td>Notch filter 2 frequency for gyro <p><strong>Comment:</strong> The center frequency for the 2nd order notch filter on the primary gyro. This filter can be enabled to avoid feedback amplification of structural resonances at a specific frequency. This only affects the signal sent to the controllers, not the estimators. Applies to both angular velocity and angular acceleration sent to the controllers. See &quot;IMU_GYRO_NF1_BW&quot; to set the bandwidth of the filter. A value of 0 disables the filter.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1000] </td>
 <td>0.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_GYRO_RATEMAX">IMU_GYRO_RATEMAX</strong> (INT32)</td>
 <td>Gyro control data maximum publication rate (inner loop rate) <p><strong>Comment:</strong> The maximum rate the gyro control data (vehicle_angular_velocity) will be allowed to publish at. This is the loop rate for the rate controller and outputs. Note: sensor data is always read and filtered at the full raw rate (eg commonly 8 kHz) regardless of this setting.</p> <strong>값:</strong><ul>
<li><strong>100:</strong> 100 Hz</li>
<li><strong>250:</strong> 250 Hz</li>
<li><strong>400:</strong> 400 Hz</li>
<li><strong>800:</strong> 800 Hz</li>
<li><strong>1000:</strong> 1000 Hz</li>
<li><strong>2000:</strong> 2000 Hz</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[100, 2000] </td>
 <td>400</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="IMU_INTEG_RATE">IMU_INTEG_RATE</strong> (INT32)</td>
 <td>IMU integration rate <p><strong>Comment:</strong> The rate at which raw IMU data is integrated to produce delta angles and delta velocities. Recommended to set this to a multiple of the estimator update period (currently 10 ms for ekf2).</p> <strong>Values:</strong><ul>
<li><strong>100:</strong> 100 Hz</li>
<li><strong>200:</strong> 200 Hz</li>
<li><strong>250:</strong> 250 Hz</li>
<li><strong>400:</strong> 400 Hz</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[100, 1000] </td>
 <td>200</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="INA220_CONFIG">INA220_CONFIG</strong> (INT32)</td>
 <td>INA220 Power Monitor Config    </td>
 <td>[0, 65535] (1)</td>
 <td>8607</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA220_CUR_BAT">INA220_CUR_BAT</strong> (FLOAT)</td>
 <td>INA220 Power Monitor Battery Max Current    </td>
 <td>[0.1, 500.0] (0.1)</td>
 <td>164.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA220_CUR_REG">INA220_CUR_REG</strong> (FLOAT)</td>
 <td>INA220 Power Monitor Regulator Max Current    </td>
 <td>[0.1, 500.0] (0.1)</td>
 <td>164.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA220_SHUNT_BAT">INA220_SHUNT_BAT</strong> (FLOAT)</td>
 <td>INA220 Power Monitor Battery Shunt    </td>
 <td>[0.000000001, 0.1] (.000000001)</td>
 <td>0.0005</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA220_SHUNT_REG">INA220_SHUNT_REG</strong> (FLOAT)</td>
 <td>INA220 Power Monitor Regulator Shunt    </td>
 <td>[0.000000001, 0.1] (.000000001)</td>
 <td>0.0005</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA226_CONFIG">INA226_CONFIG</strong> (INT32)</td>
 <td>INA226 Power Monitor Config    </td>
 <td>[0, 65535] (1)</td>
 <td>18139</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA226_CURRENT">INA226_CURRENT</strong> (FLOAT)</td>
 <td>INA226 Power Monitor Max Current    </td>
 <td>[0.1, 200.0] (0.1)</td>
 <td>164.0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA226_SHUNT">INA226_SHUNT</strong> (FLOAT)</td>
 <td>INA226 Power Monitor Shunt    </td>
 <td>[0.000000001, 0.1] (.000000001)</td>
 <td>0.0005</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA228_CONFIG">INA228_CONFIG</strong> (INT32)</td>
 <td>INA228 Power Monitor Config    </td>
 <td>[0, 65535] (1)</td>
 <td>63779</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA228_CURRENT">INA228_CURRENT</strong> (FLOAT)</td>
 <td>INA228 Power Monitor Max Current    </td>
 <td>[0.1, 327.68] (0.1)</td>
 <td>327.68</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA228_SHUNT">INA228_SHUNT</strong> (FLOAT)</td>
 <td>INA228 Power Monitor Shunt    </td>
 <td>[0.000000001, 0.1] (.000000001)</td>
 <td>0.0005</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA238_CURRENT">INA238_CURRENT</strong> (FLOAT)</td>
 <td>INA238 Power Monitor Max Current    </td>
 <td>[0.1, 327.68] (0.1)</td>
 <td>327.68</td>
 <td></td>
</tr>
<tr>
 <td><strong id="INA238_SHUNT">INA238_SHUNT</strong> (FLOAT)</td>
 <td>INA238 Power Monitor Shunt    </td>
 <td>[0.000000001, 0.1] (.000000001)</td>
 <td>0.0003</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCF8583_MAGNET">PCF8583_MAGNET</strong> (INT32)</td>
 <td>PCF8583 rotorfreq (i2c) pulse count <p><strong>Comment:</strong> Nmumber of signals per rotation of actuator</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, ?] </td>
 <td>2</td>
 <td></td>
</tr>
<tr>
 <td><strong id="PCF8583_POOL">PCF8583_POOL</strong> (INT32)</td>
 <td>PCF8583 rotorfreq (i2c) pool interval <p><strong>Comment:</strong> Determines how often the sensor is read out.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1000000</td>
 <td>us</td>
</tr>
<tr>
 <td><strong id="PCF8583_RESET">PCF8583_RESET</strong> (INT32)</td>
 <td>PCF8583 rotorfreq (i2c) pulse reset value <p><strong>Comment:</strong> Internal device counter is reset to 0 when overrun this value, counter is able to store up to 6 digits reset of counter takes some time - measurement with reset has worse accuracy. 0 means reset counter after every measurement.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>500000</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_AFBR_HYSTER">SENS_AFBR_HYSTER</strong> (INT32)</td>
 <td>AFBR Rangefinder Short/Long Range Threshold Hysteresis <p><strong>Comment:</strong> This parameter defines the hysteresis for switching between short and long range mode.</p>   </td>
 <td>[1, 10] </td>
 <td>1</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="SENS_AFBR_L_RATE">SENS_AFBR_L_RATE</strong> (INT32)</td>
 <td>AFBR Rangefinder Long Range Rate <p><strong>Comment:</strong> This parameter defines measurement rate of the AFBR Rangefinder in long range mode.</p>   </td>
 <td>[1, 100] </td>
 <td>25</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_AFBR_MODE">SENS_AFBR_MODE</strong> (INT32)</td>
 <td>AFBR Rangefinder Mode <p><strong>Comment:</strong> This parameter defines the mode of the AFBR Rangefinder.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Short Range Mode</li>
<li><strong>1:</strong> Long Range Mode</li>
<li><strong>2:</strong> High Speed Short Range Mode</li>
<li><strong>3:</strong> High Speed Long Range Mode</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_AFBR_S_RATE">SENS_AFBR_S_RATE</strong> (INT32)</td>
 <td>AFBR Rangefinder Short Range Rate <p><strong>Comment:</strong> This parameter defines measurement rate of the AFBR Rangefinder in short range mode.</p>   </td>
 <td>[1, 100] </td>
 <td>50</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_AFBR_THRESH">SENS_AFBR_THRESH</strong> (INT32)</td>
 <td>AFBR Rangefinder Short/Long Range Threshold <p><strong>Comment:</strong> This parameter defines the threshold for switching between short and long range mode. The mode will switch from short to long range when the distance is greater than the threshold plus the hysteresis. The mode will switch from long to short range when the distance is less than the threshold minus the hysteresis.</p>   </td>
 <td>[1, 50] </td>
 <td>4</td>
 <td>m</td>
</tr>
<tr>
 <td><strong id="SENS_BARO_QNH">SENS_BARO_QNH</strong> (FLOAT)</td>
 <td>QNH for barometer    </td>
 <td>[500, 1500] </td>
 <td>1013.25</td>
 <td>hPa</td>
</tr>
<tr>
 <td><strong id="SENS_BARO_RATE">SENS_BARO_RATE</strong> (FLOAT)</td>
 <td>Baro max rate <p><strong>Comment:</strong> Barometric air data maximum publication rate. This is an upper bound, actual barometric data rate is still dependent on the sensor.</p>   </td>
 <td>[1, 200] </td>
 <td>20.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="SENS_BOARD_ROT">SENS_BOARD_ROT</strong> (INT32)</td>
 <td>Board rotation <p><strong>Comment:</strong> This parameter defines the rotation of the FMU board relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
<li><strong>8:</strong> Roll 180°</li>
<li><strong>9:</strong> Roll 180°, Yaw 45°</li>
<li><strong>10:</strong> Roll 180°, Yaw 90°</li>
<li><strong>11:</strong> Roll 180°, Yaw 135°</li>
<li><strong>12:</strong> Pitch 180°</li>
<li><strong>13:</strong> Roll 180°, Yaw 225°</li>
<li><strong>14:</strong> Roll 180°, Yaw 270°</li>
<li><strong>15:</strong> Roll 180°, Yaw 315°</li>
<li><strong>16:</strong> Roll 90°</li>
<li><strong>17:</strong> Roll 90°, Yaw 45°</li>
<li><strong>18:</strong> Roll 90°, Yaw 90°</li>
<li><strong>19:</strong> Roll 90°, Yaw 135°</li>
<li><strong>20:</strong> Roll 270°</li>
<li><strong>21:</strong> Roll 270°, Yaw 45°</li>
<li><strong>22:</strong> Roll 270°, Yaw 90°</li>
<li><strong>23:</strong> Roll 270°, Yaw 135°</li>
<li><strong>24:</strong> Pitch 90°</li>
<li><strong>25:</strong> Pitch 270°</li>
<li><strong>26:</strong> Pitch 180°, Yaw 90°</li>
<li><strong>27:</strong> Pitch 180°, Yaw 270°</li>
<li><strong>28:</strong> Roll 90°, Pitch 90°</li>
<li><strong>29:</strong> Roll 180°, Pitch 90°</li>
<li><strong>30:</strong> Roll 270°, Pitch 90°</li>
<li><strong>31:</strong> Roll 90°, Pitch 180°</li>
<li><strong>32:</strong> Roll 270°, Pitch 180°</li>
<li><strong>33:</strong> Roll 90°, Pitch 270°</li>
<li><strong>34:</strong> Roll 180°, Pitch 270°</li>
<li><strong>35:</strong> Roll 270°, Pitch 270°</li>
<li><strong>36:</strong> Roll 90°, Pitch 180°, Yaw 90°</li>
<li><strong>37:</strong> Roll 90°, Yaw 270°</li>
<li><strong>38:</strong> Roll 90°, Pitch 68°, Yaw 293°</li>
<li><strong>39:</strong> Pitch 315°</li>
<li><strong>40:</strong> Roll 90°, Pitch 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[-1, 40] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_BOARD_X_OFF">SENS_BOARD_X_OFF</strong> (FLOAT)</td>
 <td>Board rotation X (Roll) offset <p><strong>Comment:</strong> This parameter defines a rotational offset in degrees around the X (Roll) axis It allows the user to fine tune the board offset in the event of misalignment.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="SENS_BOARD_Y_OFF">SENS_BOARD_Y_OFF</strong> (FLOAT)</td>
 <td>Board rotation Y (Pitch) offset <p><strong>Comment:</strong> This parameter defines a rotational offset in degrees around the Y (Pitch) axis. It allows the user to fine tune the board offset in the event of misalignment.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="SENS_BOARD_Z_OFF">SENS_BOARD_Z_OFF</strong> (FLOAT)</td>
 <td>Board rotation Z (YAW) offset <p><strong>Comment:</strong> This parameter defines a rotational offset in degrees around the Z (Yaw) axis. It allows the user to fine tune the board offset in the event of misalignment.</p>   </td>
 <td></td>
 <td>0.0</td>
 <td>deg</td>
</tr>
<tr>
 <td><strong id="SENS_CM8JL65_CFG">SENS_CM8JL65_CFG</strong> (INT32)</td>
 <td>Serial Configuration for Lanbao PSK-CM8JL65-CC5 <p><strong>Comment:</strong> Configure on which serial port to run Lanbao PSK-CM8JL65-CC5.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_CM8JL65_R_0">SENS_CM8JL65_R_0</strong> (INT32)</td>
 <td>Distance Sensor Rotation <p><strong>Comment:</strong> Distance Sensor Rotation as MAV_SENSOR_ORIENTATION enum</p> <strong>값:</strong><ul>
<li><strong>0:</strong> ROTATION_FORWARD_FACING</li>
<li><strong>2:</strong> ROTATION_RIGHT_FACING</li>
<li><strong>6:</strong> ROTATION_LEFT_FACING</li>
<li><strong>12:</strong> ROTATION_BACKWARD_FACING</li>
<li><strong>24:</strong> ROTATION_UPWARD_FACING</li>
<li><strong>25:</strong> ROTATION_DOWNWARD_FACING</li>
</ul>  <p><b>Reboot required:</b> True</p>
</td>
 <td></td>
 <td>25</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_ADIS164X">SENS_EN_ADIS164X</strong> (INT32)</td>
 <td>Analog Devices ADIS16448 IMU (external SPI)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_ADIS165X">SENS_EN_ADIS165X</strong> (INT32)</td>
 <td>Analog Devices ADIS16507 IMU (external SPI)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_ARSPDSIM">SENS_EN_ARSPDSIM</strong> (INT32)</td>
 <td>Enable simulated airspeed sensor instance  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_ASP5033">SENS_EN_ASP5033</strong> (INT32)</td>
 <td>ASP5033 differential pressure sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_BAROSIM">SENS_EN_BAROSIM</strong> (INT32)</td>
 <td>Enable simulated barometer sensor instance  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_BATT">SENS_EN_BATT</strong> (INT32)</td>
 <td>SMBUS Smart battery driver BQ40Z50 and BQ40Z80    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_ETSASPD">SENS_EN_ETSASPD</strong> (INT32)</td>
 <td>Eagle Tree airspeed sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_GPSSIM">SENS_EN_GPSSIM</strong> (INT32)</td>
 <td>Enable simulated GPS sinstance  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_INA220">SENS_EN_INA220</strong> (INT32)</td>
 <td>Enable INA220 Power Monitor <p><strong>Comment:</strong> For systems a INA220 Power Monitor, this should be set to true</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_INA226">SENS_EN_INA226</strong> (INT32)</td>
 <td>Enable INA226 Power Monitor <p><strong>Comment:</strong> For systems a INA226 Power Monitor, this should be set to true</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_INA228">SENS_EN_INA228</strong> (INT32)</td>
 <td>Enable INA228 Power Monitor <p><strong>Comment:</strong> For systems a INA228 Power Monitor, this should be set to true</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_INA238">SENS_EN_INA238</strong> (INT32)</td>
 <td>Enable INA238 Power Monitor <p><strong>Comment:</strong> For systems a INA238 Power Monitor, this should be set to true</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_IRLOCK">SENS_EN_IRLOCK</strong> (INT32)</td>
 <td>IR-LOCK Sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_LL40LS">SENS_EN_LL40LS</strong> (INT32)</td>
 <td>Lidar-Lite (LL40LS)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> PWM</li>
<li><strong>2:</strong> I2C</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 2] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MAGSIM">SENS_EN_MAGSIM</strong> (INT32)</td>
 <td>Enable simulated magnetometer sensor instance  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MB12XX">SENS_EN_MB12XX</strong> (INT32)</td>
 <td>Maxbotix Sonar (mb12xx)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MPDT">SENS_EN_MPDT</strong> (INT32)</td>
 <td>Enable Mappydot rangefinder (i2c)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Autodetect</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MS4515">SENS_EN_MS4515</strong> (INT32)</td>
 <td>TE MS4515 differential pressure sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MS4525DO">SENS_EN_MS4525DO</strong> (INT32)</td>
 <td>TE MS4525DO differential pressure sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_MS5525DS">SENS_EN_MS5525DS</strong> (INT32)</td>
 <td>TE MS5525DSO differential pressure sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PAA3905">SENS_EN_PAA3905</strong> (INT32)</td>
 <td>PAA3905 Optical Flow    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PAW3902">SENS_EN_PAW3902</strong> (INT32)</td>
 <td>PAW3902/PAW3903 Optical Flow    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PCF8583">SENS_EN_PCF8583</strong> (INT32)</td>
 <td>PCF8583 eneable driver <p><strong>Comment:</strong> Run PCF8583 driver automatically</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Eneabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PGA460">SENS_EN_PGA460</strong> (INT32)</td>
 <td>PGA460 Ultrasonic driver (PGA460)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PMW3901">SENS_EN_PMW3901</strong> (INT32)</td>
 <td>PMW3901 Optical Flow    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_PX4FLOW">SENS_EN_PX4FLOW</strong> (INT32)</td>
 <td>PX4 Flow Optical Flow    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SCH16T">SENS_EN_SCH16T</strong> (INT32)</td>
 <td>Murata SCH16T IMU (external SPI)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Enabled</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SDP3X">SENS_EN_SDP3X</strong> (INT32)</td>
 <td>Sensirion SDP3X differential pressure sensor (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SF0X">SENS_EN_SF0X</strong> (INT32)</td>
 <td>Lightware Laser Rangefinder hardware model (serial)  <strong>Values:</strong><ul>
<li><strong>1:</strong> SF02</li>
<li><strong>2:</strong> SF10/a</li>
<li><strong>3:</strong> SF10/b</li>
<li><strong>4:</strong> SF10/c</li>
<li><strong>5:</strong> SF11/c</li>
<li><strong>6:</strong> SF30/b</li>
<li><strong>7:</strong> SF30/c</li>
<li><strong>8:</strong> LW20/c</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SF1XX">SENS_EN_SF1XX</strong> (INT32)</td>
 <td>Lightware SF1xx/SF20/LW20 laser rangefinder (i2c)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> SF10/a</li>
<li><strong>2:</strong> SF10/b</li>
<li><strong>3:</strong> SF10/c</li>
<li><strong>4:</strong> SF11/c</li>
<li><strong>5:</strong> SF/LW20/b</li>
<li><strong>6:</strong> SF/LW20/c</li>
<li><strong>7:</strong> SF/LW30/d</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 6] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SF45_CFG">SENS_EN_SF45_CFG</strong> (INT32)</td>
 <td>Serial Configuration for Lightware SF45 Rangefinder (serial) <p><strong>Comment:</strong> Configure on which serial port to run Lightware SF45 Rangefinder (serial).</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>102</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SHT3X">SENS_EN_SHT3X</strong> (INT32)</td>
 <td>SHT3x temperature and hygrometer    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SPL06">SENS_EN_SPL06</strong> (INT32)</td>
 <td>Goertek SPL06 Barometer (external I2C)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_SR05">SENS_EN_SR05</strong> (INT32)</td>
 <td>HY-SRF05 / HC-SR05    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_TF02PRO">SENS_EN_TF02PRO</strong> (INT32)</td>
 <td>TF02 Pro Distance Sensor (i2c)    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_THERMAL">SENS_EN_THERMAL</strong> (INT32)</td>
 <td>Thermal control of sensor temperature  <strong>Values:</strong><ul>
<li><strong>-1:</strong> Thermal control unavailable</li>
<li><strong>0:</strong> Thermal control off</li>
<li><strong>1:</strong> Thermal control enabled</li>
</ul>  </td>
 <td></td>
 <td>-1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_TRANGER">SENS_EN_TRANGER</strong> (INT32)</td>
 <td>TeraRanger Rangefinder (i2c)  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Autodetect</li>
<li><strong>2:</strong> TROne</li>
<li><strong>3:</strong> TREvo60m</li>
<li><strong>4:</strong> TREvo600Hz</li>
<li><strong>5:</strong> TREvo3m</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 3] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_VL53L0X">SENS_EN_VL53L0X</strong> (INT32)</td>
 <td>VL53L0X Distance Sensor    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EN_VL53L1X">SENS_EN_VL53L1X</strong> (INT32)</td>
 <td>VL53L1X Distance Sensor    <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Disabled (0)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_EXT_I2C_PRB">SENS_EXT_I2C_PRB</strong> (INT32)</td>
 <td>External I2C probe <p><strong>Comment:</strong> Probe for optional external I2C devices.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_FLOW_RATE">SENS_FLOW_RATE</strong> (FLOAT)</td>
 <td>Optical flow max rate <p><strong>Comment:</strong> Optical flow data maximum publication rate. This is an upper bound, actual optical flow data rate is still dependent on the sensor.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 200] </td>
 <td>70.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="SENS_FLOW_ROT">SENS_FLOW_ROT</strong> (INT32)</td>
 <td>Optical flow rotation <p><strong>Comment:</strong> This parameter defines the yaw rotation of the optical flow relative to the vehicle body frame. Zero rotation is defined as X on flow board pointing towards front of vehicle.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_FTX_CFG">SENS_FTX_CFG</strong> (INT32)</td>
 <td>Serial Configuration for FT Technologies Digital Wind Sensor (serial) <p><strong>Comment:</strong> Configure on which serial port to run FT Technologies Digital Wind Sensor (serial).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_GPS_MASK">SENS_GPS_MASK</strong> (INT32)</td>
 <td>Multi GPS Blending Control Mask <p><strong>Comment:</strong> Set bits in the following positions to set which GPS accuracy metrics will be used to calculate the blending weight. Set to zero to disable and always used first GPS instance. 0 : Set to true to use speed accuracy 1 : Set to true to use horizontal position accuracy 2 : Set to true to use vertical position accuracy</p>  <strong>Bitmask:</strong><ul>  <li><strong>0:</strong> use speed accuracy</li>
  <li><strong>1:</strong> use hpos accuracy</li>
  <li><strong>2:</strong> use vpos accuracy</li>
</ul>
 </td>
 <td>[0, 7] </td>
 <td>7</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_GPS_PRIME">SENS_GPS_PRIME</strong> (INT32)</td>
 <td>Multi GPS primary instance <p><strong>Comment:</strong> When no blending is active, this defines the preferred GPS receiver instance. The GPS selection logic waits until the primary receiver is available to send data to the EKF even if a secondary instance is already available. The secondary instance is then only used if the primary one times out. To have an equal priority of all the instances, set this parameter to -1 and the best receiver will be used. This parameter has no effect if blending is active.</p>   </td>
 <td>[-1, 1] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_GPS_TAU">SENS_GPS_TAU</strong> (FLOAT)</td>
 <td>Multi GPS Blending Time Constant <p><strong>Comment:</strong> Sets the longest time constant that will be applied to the calculation of GPS position and height offsets used to correct data from multiple GPS data for steady state position differences.</p>   </td>
 <td>[1.0, 100.0] </td>
 <td>10.0</td>
 <td>s</td>
</tr>
<tr>
 <td><strong id="SENS_IMU_AUTOCAL">SENS_IMU_AUTOCAL</strong> (INT32)</td>
 <td>IMU auto calibration <p><strong>Comment:</strong> Automatically initialize IMU (accel/gyro) calibration from bias estimates if available.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_IMU_CLPNOTI">SENS_IMU_CLPNOTI</strong> (INT32)</td>
 <td>IMU notify clipping <p><strong>Comment:</strong> Notify the user if the IMU is clipping</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_IMU_MODE">SENS_IMU_MODE</strong> (INT32)</td>
 <td>Sensors hub IMU mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>1:</strong> Publish primary IMU selection</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_IMU_TEMP">SENS_IMU_TEMP</strong> (FLOAT)</td>
 <td>Target IMU temperature    </td>
 <td>[0, 85.0] </td>
 <td>55.0</td>
 <td>celcius</td>
</tr>
<tr>
 <td><strong id="SENS_IMU_TEMP_FF">SENS_IMU_TEMP_FF</strong> (FLOAT)</td>
 <td>IMU heater controller feedforward value    </td>
 <td>[0, 1.0] </td>
 <td>0.05</td>
 <td>%</td>
</tr>
<tr>
 <td><strong id="SENS_IMU_TEMP_I">SENS_IMU_TEMP_I</strong> (FLOAT)</td>
 <td>IMU heater controller integrator gain value    </td>
 <td>[0, 1.0] </td>
 <td>0.025</td>
 <td>us/C</td>
</tr>
<tr>
 <td><strong id="SENS_IMU_TEMP_P">SENS_IMU_TEMP_P</strong> (FLOAT)</td>
 <td>IMU heater controller proportional gain value    </td>
 <td>[0, 2.0] </td>
 <td>1.0</td>
 <td>us/C</td>
</tr>
<tr>
 <td><strong id="SENS_INT_BARO_EN">SENS_INT_BARO_EN</strong> (INT32)</td>
 <td>Enable internal barometers <p><strong>Comment:</strong> For systems with an external barometer, this should be set to false to make sure that the external is used.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_LEDDAR1_CFG">SENS_LEDDAR1_CFG</strong> (INT32)</td>
 <td>Serial Configuration for LeddarOne Rangefinder <p><strong>Comment:</strong> Configure on which serial port to run LeddarOne Rangefinder.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MAG_AUTOCAL">SENS_MAG_AUTOCAL</strong> (INT32)</td>
 <td>Magnetometer auto calibration <p><strong>Comment:</strong> Automatically initialize magnetometer calibration from bias estimate if available.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MAG_AUTOROT">SENS_MAG_AUTOROT</strong> (INT32)</td>
 <td>Automatically set external rotations <p><strong>Comment:</strong> During calibration attempt to automatically determine the rotation of external magnetometers.</p>   </td>
 <td></td>
 <td>Enabled (1)</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MAG_MODE">SENS_MAG_MODE</strong> (INT32)</td>
 <td>Sensors hub mag mode  <strong>Values:</strong><ul>
<li><strong>0:</strong> Publish all magnetometers</li>
<li><strong>1:</strong> Publish primary magnetometer</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>1</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MAG_RATE">SENS_MAG_RATE</strong> (FLOAT)</td>
 <td>Magnetometer max rate <p><strong>Comment:</strong> Magnetometer data maximum publication rate. This is an upper bound, actual magnetometer data rate is still dependent on the sensor.</p>   <p><b>Reboot required:</b> true</p>
</td>
 <td>[1, 200] </td>
 <td>15.0</td>
 <td>Hz</td>
</tr>
<tr>
 <td><strong id="SENS_MAG_SIDES">SENS_MAG_SIDES</strong> (INT32)</td>
 <td>Bitfield selecting mag sides for calibration <p><strong>Comment:</strong> If set to two side calibration, only the offsets are estimated, the scale calibration is left unchanged. Thus an initial six side calibration is recommended. Bits: ORIENTATION_TAIL_DOWN = 1 ORIENTATION_NOSE_DOWN = 2 ORIENTATION_LEFT = 4 ORIENTATION_RIGHT = 8 ORIENTATION_UPSIDE_DOWN = 16 ORIENTATION_RIGHTSIDE_UP = 32</p> <strong>Values:</strong><ul>
<li><strong>34:</strong> Two side calibration</li>
<li><strong>38:</strong> Three side calibration</li>
<li><strong>63:</strong> Six side calibration</li>
</ul>  </td>
 <td>[34, 63] </td>
 <td>63</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_0_ROT">SENS_MB12_0_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 0 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_10_ROT">SENS_MB12_10_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 10 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_11_ROT">SENS_MB12_11_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 12 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_1_ROT">SENS_MB12_1_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 1 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_2_ROT">SENS_MB12_2_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 2 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_3_ROT">SENS_MB12_3_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 3 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_4_ROT">SENS_MB12_4_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 4 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_5_ROT">SENS_MB12_5_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 5 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_6_ROT">SENS_MB12_6_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 6 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_7_ROT">SENS_MB12_7_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 7 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_8_ROT">SENS_MB12_8_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 8 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MB12_9_ROT">SENS_MB12_9_ROT</strong> (INT32)</td>
 <td>MaxBotix MB12XX Sensor 9 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT0_ROT">SENS_MPDT0_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 0 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT10_ROT">SENS_MPDT10_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 10 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT11_ROT">SENS_MPDT11_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 12 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT1_ROT">SENS_MPDT1_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 1 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT2_ROT">SENS_MPDT2_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 2 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT3_ROT">SENS_MPDT3_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 3 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT4_ROT">SENS_MPDT4_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 4 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT5_ROT">SENS_MPDT5_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 5 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT6_ROT">SENS_MPDT6_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 6 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT7_ROT">SENS_MPDT7_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 7 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT8_ROT">SENS_MPDT8_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 8 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_MPDT9_ROT">SENS_MPDT9_ROT</strong> (INT32)</td>
 <td>MappyDot Sensor 9 Rotation <p><strong>Comment:</strong> This parameter defines the rotation of the Mappydot sensor relative to the platform.</p> <strong>Values:</strong><ul>
<li><strong>0:</strong> No rotation</li>
<li><strong>1:</strong> Yaw 45°</li>
<li><strong>2:</strong> Yaw 90°</li>
<li><strong>3:</strong> Yaw 135°</li>
<li><strong>4:</strong> Yaw 180°</li>
<li><strong>5:</strong> Yaw 225°</li>
<li><strong>6:</strong> Yaw 270°</li>
<li><strong>7:</strong> Yaw 315°</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 7] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_OR_ADIS164X">SENS_OR_ADIS164X</strong> (INT32)</td>
 <td>Analog Devices ADIS16448 IMU Orientation(external SPI)  <strong>Values:</strong><ul>
<li><strong>0:</strong> ROTATION_NONE</li>
<li><strong>4:</strong> ROTATION_YAW_180</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td>[0, 101] </td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_SF0X_CFG">SENS_SF0X_CFG</strong> (INT32)</td>
 <td>Serial Configuration for Lightware Laser Rangefinder (serial) <p><strong>Comment:</strong> Configure on which serial port to run Lightware Laser Rangefinder (serial).</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_TEMP_ID">SENS_TEMP_ID</strong> (INT32)</td>
 <td>Target IMU device ID to regulate temperature    </td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_TFLOW_CFG">SENS_TFLOW_CFG</strong> (INT32)</td>
 <td>Serial Configuration for ThoneFlow-3901U optical flow sensor <p><strong>Comment:</strong> Configure on which serial port to run ThoneFlow-3901U optical flow sensor.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_TFMINI_CFG">SENS_TFMINI_CFG</strong> (INT32)</td>
 <td>Serial Configuration for Benewake TFmini Rangefinder <p><strong>Comment:</strong> Configure on which serial port to run Benewake TFmini Rangefinder.</p> <strong>값:</strong><ul>
<li><strong>0:</strong> Disabled</li>
<li><strong>6:</strong> UART 6</li>
<li><strong>101:</strong> TELEM 1</li>
<li><strong>102:</strong> TELEM 2</li>
<li><strong>103:</strong> TELEM 3</li>
<li><strong>104:</strong> TELEM/SERIAL 4</li>
<li><strong>201:</strong> GPS 1</li>
<li><strong>202:</strong> GPS 2</li>
<li><strong>203:</strong> GPS 3</li>
<li><strong>300:</strong> Radio Controller</li>
<li><strong>301:</strong> Wifi Port</li>
<li><strong>401:</strong> EXT2</li>
</ul>  <p><b>Reboot required:</b> true</p>
</td>
 <td></td>
 <td>0</td>
 <td></td>
</tr>
<tr>
 <td><strong id="SENS_ULAND_CFG">SENS_ULAND_CFG</strong> (INT32)</td>
 <td>Serial Configuration for uLanding Radar <p><strong>Comment:</strong> Configure on which serial port to run uLanding Radar.</p> <strong>값:</s