# Manufacturer-Supported Autopilots

Manufacturer-supported autopilots are maintained and supported by a board manufacturer (manufacturers commit to delivering compatibility with the current stable PX4 release within 4 months of the official release announcement).

:::tip
For more information about PX4 project autopilot board support levels see: [px4.io/autopilots/](https://px4.io/autopilots/).
:::

::: info
This category includes boards that are not fully compliant with the pixhawk standard; manufacturers support and maintain the board for any areas of incompatibility.
:::

The boards in this category are:

- [AirMind MindPX](../flight_controller/mindpx.md)
- [AirMind MindRacer](../flight_controller/mindracer.md)
- [ARK Electronics ARKV6X](../flight_controller/ark_v6x.md) (and [ARK Electronics Pixhawk Autopilot Bus Carrier](../flight_controller/ark_pab.md))
- [ARK FPV Flight Controller](../flight_controller/ark_fpv.md) 
- [ARK Pi6X Flow Flight Controller](../flight_controller/ark_pi6x.md) 
- [CUAV X7](../flight_controller/cuav_x7.md)
- [CUAV Nora](../flight_controller/cuav_nora.md)（CUAV X7 variant)
- [CUAV V5+](../flight_controller/cuav_v5_plus.md) (FMUv5)
- [CUAV V5 nano](../flight_controller/cuav_v5_nano.md) (FMUv5)
- [CUAV Pixhack v3](../flight_controller/pixhack_v3.md) (FMUv3)
- [CubePilot Cube Orange+](../flight_controller/cubepilot_cube_orangeplus.md)
- [CubePilot Cube Orange](../flight_controller/cubepilot_cube_orange.md)
- [CubePilot Cube Yellow](../flight_controller/cubepilot_cube_yellow.md)
- [Holybro Kakute H7v2](../flight_controller/kakuteh7v2.md)
- [Holybro Kakute H7mini](../flight_controller/kakuteh7mini.md)
- [Holybro Kakute F7](../flight_controller/kakutef7.md) - Discontinued
- [Holybro Kakute H7](../flight_controller/kakuteh7.md)
- [Holybro Durandal](../flight_controller/durandal.md)
- [Holybro Pix32 v5](../flight_controller/holybro_pix32_v5.md)
- [ModalAI Flight Core v1](../flight_controller/modalai_fc_v1.md)
- [ModalAI VOXL Flight](../flight_controller/modalai_voxl_flight.md)
- [ModalAI VOXL 2](../flight_controller/modalai_voxl_2.md)
- [mRobotics-X2.1](../flight_controller/mro_x2.1.md) (FMUv2)
- [mRo Control Zero](../flight_controller/mro_control_zero_f7.md)
- [Sky-Drones AIRLink](../flight_controller/airlink.md)
- [SPRacing SPRacingH7EXTREME](../flight_controller/spracingh7extreme.md)
- [ThePeach FCC-K1](../flight_controller/thepeach_k1.md)
- [ThePeach FCC-R1](../flight_controller/thepeach_r1.md)
