# Parameter Reference

::: info
This documentation was auto-generated from the source code for this PX4 version (using `make parameters_metadata`).
:::

::: tip
If a listed parameter is missing from the Firmware see: [Finding/Updating Parameters](../advanced_config/parameters.md#parameter-not-in-firmware).
:::

<!-- markdown generator: src/lib/parameters/px4params/markdownout.py -->

## UAVCAN Motor Parameters

### ctl_bw (`INT32`) {#ctl_bw}

Speed controller bandwidth.

Speed controller bandwidth, in Hz. Higher values result in faster speed and current rise times, but may result in overshoot and higher current consumption. For fixed-wing aircraft, this value should be less than 50 Hz; for multirotors, values up to 100 Hz may provide improvements in responsiveness.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 250 |  | 75 | Hz 

### ctl_dir (`INT32`) {#ctl_dir}

Reverse direction.

Motor spin direction as detected during initial enumeration. Use 0 or 1 to reverse direction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1 |  

### ctl_gain (`FLOAT`) {#ctl_gain}

Speed (RPM) controller gain.

Determines controller
            aggressiveness; units are amp-seconds per radian. Systems with
            higher rotational inertia (large props) will need gain increased;
            systems with low rotational inertia (small props) may need gain
            decreased. Higher values result in faster response, but may result
            in oscillation and excessive overshoot. Lower values result in a
            slower, smoother response.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00 | 1.00 |  | 1 | C/rad 

### ctl_hz_idle (`FLOAT`) {#ctl_hz_idle}

Idle speed (e Hz).

Idle speed (e Hz)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 3.5 | Hz 

### ctl_start_rate (`INT32`) {#ctl_start_rate}

Spin-up rate (e Hz/s).

Spin-up rate (e Hz/s)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 1000 |  | 25 | 1/s^2 

### esc_index (`INT32`) {#esc_index}

Index of this ESC in throttle command messages.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 15 |  | 0 |  

### id_ext_status (`INT32`) {#id_ext_status}

Extended status ID.

Extended status ID

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 1000000 |  | 20034 |  

### int_ext_status (`INT32`) {#int_ext_status}

Extended status interval (µs).

Extended status interval (µs)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000000 |  | 50000 | us 

### int_status (`INT32`) {#int_status}

ESC status interval (µs).

ESC status interval (µs)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  | 1000000 |  | 50000 | us 

### mot_i_max (`FLOAT`) {#mot_i_max}

Motor current limit in amps.

This determines the maximum
            current controller setpoint, as well as the maximum allowable
            current setpoint slew rate. This value should generally be set to
            the continuous current rating listed in the motor’s specification
            sheet, or set equal to the motor’s specified continuous power
            divided by the motor voltage limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 80 |  | 12 | A 

### mot_kv (`INT32`) {#mot_kv}

Motor Kv in RPM per volt.

This can be taken from the motor’s
            specification sheet; accuracy will help control performance but
            some deviation from the specified value is acceptable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4000 |  | 2300 | rpm/V 

### mot_ls (`FLOAT`) {#mot_ls}

READ ONLY: Motor inductance in henries.

This is measured on start-up.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | H 

### mot_num_poles (`INT32`) {#mot_num_poles}

Number of motor poles.

Used to convert mechanical speeds to
            electrical speeds. This number should be taken from the motor’s
            specification sheet.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 40 |  | 14 |  

### mot_rs (`FLOAT`) {#mot_rs}

READ ONLY: Motor resistance in ohms.

This is measured on start-up. When
            tuning a new motor, check that this value is approximately equal
            to the value shown in the motor’s specification sheet.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | Ohm 

### mot_v_accel (`FLOAT`) {#mot_v_accel}

Acceleration limit (V).

Acceleration limit (V)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1.00 |  | 0.5 | V 

### mot_v_max (`FLOAT`) {#mot_v_max}

Motor voltage limit in volts.

The current controller’s
            commanded voltage will never exceed this value. Note that this may
            safely be above the nominal voltage of the motor; to determine the
            actual motor voltage limit, divide the motor’s rated power by the
            motor current limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 14.8 | V 

## UAVCAN GNSS

### gnss.dyn_model (`INT32`) {#gnss.dyn_model}

GNSS dynamic model.

Dynamic model used in the GNSS positioning engine. 0 –
        Automotive, 1 – Sea, 2 – Airborne.
      

**Values:**

- `0`: Automotive
- `1`: Sea
- `2`: Airborne


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 2 |  

### gnss.old_fix_msg (`INT32`) {#gnss.old_fix_msg}

Broadcast old GNSS fix message.

Broadcast the old (deprecated) GNSS fix message
        uavcan.equipment.gnss.Fix alongside the new alternative
        uavcan.equipment.gnss.Fix2. It is recommended to
        disable this feature to reduce the CAN bus traffic.
      

**Values:**

- `0`: Fix2
- `1`: Fix and Fix2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1 |  

### gnss.warn_dimens (`INT32`) {#gnss.warn_dimens}

device health warning.

Set the device health to Warning if the dimensionality of
              the GNSS solution is less than this value. 3 for the full (3D)
              solution, 2 for planar (2D) solution, 1 for time-only solution,
              0 disables the feature.
      

**Values:**

- `0`: disables the feature
- `1`: time-only solution
- `2`: planar (2D) solution
- `3`: full (3D) solution


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### gnss.warn_sats (`INT32`) {#gnss.warn_sats}

Set the device health to Warning if the number of satellites
        used in the GNSS solution is below this threshold. Zero
        disables the feature
      

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### uavcan.pubp-pres (`INT32`) {#uavcan.pubp-pres}

Set the device health to Warning if the number of satellites
        used in the GNSS solution is below this threshold. Zero
        disables the feature
      

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000000 |  | 0 | us 

## ADSB

### ADSB_CALLSIGN_1 (`INT32`) {#ADSB_CALLSIGN_1}

First 4 characters of CALLSIGN.

Sets first 4 characters of a total of 8. Valid characters are A-Z, 0-9, " ". Example "PX4 " -> 1347957792 For CALLSIGN shorter than 8 characters use the null terminator at the end '\0'.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### ADSB_CALLSIGN_2 (`INT32`) {#ADSB_CALLSIGN_2}

Second 4 characters of CALLSIGN.

Sets second 4 characters of a total of 8. Valid characters are A-Z, 0-9, " " only. Example "TEST" -> 1413829460 For CALLSIGN shorter than 8 characters use the null terminator at the end '\0'.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### ADSB_EMERGC (`INT32`) {#ADSB_EMERGC}

ADSB-Out Emergency State.

Sets the vehicle emergency state

**Values:**

- `0`: NoEmergency
- `1`: General
- `2`: Medical
- `3`: LowFuel
- `4`: NoCommunications
- `5`: Interference
- `6`: Downed


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 6 |  | 0 |  

### ADSB_EMIT_TYPE (`INT32`) {#ADSB_EMIT_TYPE}

ADSB-Out Vehicle Emitter Type.

Configure the emitter type of the vehicle.

**Values:**

- `0`: Unknown
- `1`: Light
- `2`: Small
- `3`: Large
- `4`: HighVortex
- `5`: Heavy
- `6`: Performance
- `7`: Rotorcraft
- `8`: RESERVED
- `9`: Glider
- `10`: LightAir
- `11`: Parachute
- `12`: UltraLight
- `13`: RESERVED
- `14`: UAV
- `15`: Space
- `16`: RESERVED
- `17`: EmergencySurf
- `18`: ServiceSurf
- `19`: PointObstacle


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 15 |  | 14 |  

### ADSB_GPS_OFF_LAT (`INT32`) {#ADSB_GPS_OFF_LAT}

ADSB-Out GPS Offset lat.

Sets GPS lataral offset encoding

**Values:**

- `0`: NoData
- `1`: LatLeft2M
- `2`: LatLeft4M
- `3`: LatLeft6M
- `4`: LatRight0M
- `5`: LatRight2M
- `6`: LatRight4M
- `7`: LatRight6M


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### ADSB_GPS_OFF_LON (`INT32`) {#ADSB_GPS_OFF_LON}

ADSB-Out GPS Offset lon.

Sets GPS longitudinal offset encoding

**Values:**

- `0`: NoData
- `1`: AppliedBySensor


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### ADSB_ICAO_ID (`INT32`) {#ADSB_ICAO_ID}

ADSB-Out ICAO configuration.

Defines the ICAO ID of the vehicle

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1 | 16777215 |  | 1194684 |  

### ADSB_ICAO_SPECL (`INT32`) {#ADSB_ICAO_SPECL}

ADSB-In Special ICAO configuration.

This vehicle is always tracked. Use 0 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 16777215 |  | 0 |  

### ADSB_IDENT (`INT32`) {#ADSB_IDENT}

ADSB-Out Ident Configuration.

Enable Identification of Position feature

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### ADSB_LEN_WIDTH (`INT32`) {#ADSB_LEN_WIDTH}

ADSB-Out Vehicle Size Configuration.

Report the length and width of the vehicle in meters. In most cases, use '1' for the smallest vehicle size.

**Values:**

- `0`: SizeUnknown
- `1`: Len15_Wid23
- `2`: Len25_Wid28
- `3`: Len25_Wid34
- `4`: Len35_Wid33
- `5`: Len35_Wid38
- `6`: Len45_Wid39
- `7`: Len45_Wid45
- `8`: Len55_Wid45
- `9`: Len55_Wid52
- `10`: Len65_Wid59
- `11`: Len65_Wid67
- `12`: Len75_Wid72
- `13`: Len75_Wid80
- `14`: Len85_Wid80
- `15`: Len85_Wid90


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 15 |  | 1 |  

### ADSB_LIST_MAX (`INT32`) {#ADSB_LIST_MAX}

ADSB-In Vehicle List Size.

Change number of targets to track

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 50 |  | 25 |  

### ADSB_MAX_SPEED (`INT32`) {#ADSB_MAX_SPEED}

ADSB-Out Vehicle Max Speed.

Informs ADSB vehicles of this vehicle's max speed capability

**Values:**

- `0`: UnknownMaxSpeed
- `1`: 75Kts
- `2`: 150Kts
- `3`: 300Kts
- `4`: 600Kts
- `5`: 1200Kts
- `6`: Over1200Kts


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 6 |  | 0 |  

### ADSB_SQUAWK (`INT32`) {#ADSB_SQUAWK}

ADSB-Out squawk code configuration.

This parameter defines the squawk code. Value should be between 0000 and 7777.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7777 |  | 1200 |  

## Actuator Outputs

### PCA9685_DIS1 (`INT32`) {#PCA9685_DIS1}

PCA9685 Output Channel 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS10 (`INT32`) {#PCA9685_DIS10}

PCA9685 Output Channel 10 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS11 (`INT32`) {#PCA9685_DIS11}

PCA9685 Output Channel 11 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS12 (`INT32`) {#PCA9685_DIS12}

PCA9685 Output Channel 12 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS13 (`INT32`) {#PCA9685_DIS13}

PCA9685 Output Channel 13 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS14 (`INT32`) {#PCA9685_DIS14}

PCA9685 Output Channel 14 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS15 (`INT32`) {#PCA9685_DIS15}

PCA9685 Output Channel 15 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS16 (`INT32`) {#PCA9685_DIS16}

PCA9685 Output Channel 16 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS2 (`INT32`) {#PCA9685_DIS2}

PCA9685 Output Channel 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS3 (`INT32`) {#PCA9685_DIS3}

PCA9685 Output Channel 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS4 (`INT32`) {#PCA9685_DIS4}

PCA9685 Output Channel 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS5 (`INT32`) {#PCA9685_DIS5}

PCA9685 Output Channel 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS6 (`INT32`) {#PCA9685_DIS6}

PCA9685 Output Channel 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS7 (`INT32`) {#PCA9685_DIS7}

PCA9685 Output Channel 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS8 (`INT32`) {#PCA9685_DIS8}

PCA9685 Output Channel 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DIS9 (`INT32`) {#PCA9685_DIS9}

PCA9685 Output Channel 9 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PCA9685_DUTY_EN (`INT32`) {#PCA9685_DUTY_EN}

Put the selected channels into Duty-Cycle output mode.

The driver will output standard pulse-width encoded signal without this bit set. To make PCA9685 output in duty-cycle fashion, please enable the corresponding channel bit here and adjusting standard params to suit your need. The driver will have 12bits resolution for duty-cycle output. That means to achieve 0% to 100% output range on one channel, the corresponding params MIN and MAX for the channel should be set to 0 and 4096. Other standard params follows the same rule.

**Bitmask:**

- `0`: Put CH1 to Duty-Cycle mode
- `1`: Put CH2 to Duty-Cycle mode
- `2`: Put CH3 to Duty-Cycle mode
- `3`: Put CH4 to Duty-Cycle mode
- `4`: Put CH5 to Duty-Cycle mode
- `5`: Put CH6 to Duty-Cycle mode
- `6`: Put CH7 to Duty-Cycle mode
- `7`: Put CH8 to Duty-Cycle mode
- `8`: Put CH9 to Duty-Cycle mode
- `9`: Put CH10 to Duty-Cycle mode
- `10`: Put CH11 to Duty-Cycle mode
- `11`: Put CH12 to Duty-Cycle mode
- `12`: Put CH13 to Duty-Cycle mode
- `13`: Put CH14 to Duty-Cycle mode
- `14`: Put CH15 to Duty-Cycle mode
- `15`: Put CH16 to Duty-Cycle mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### PCA9685_FAIL1 (`INT32`) {#PCA9685_FAIL1}

PCA9685 Output Channel 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL10 (`INT32`) {#PCA9685_FAIL10}

PCA9685 Output Channel 10 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC10).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL11 (`INT32`) {#PCA9685_FAIL11}

PCA9685 Output Channel 11 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC11).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL12 (`INT32`) {#PCA9685_FAIL12}

PCA9685 Output Channel 12 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC12).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL13 (`INT32`) {#PCA9685_FAIL13}

PCA9685 Output Channel 13 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC13).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL14 (`INT32`) {#PCA9685_FAIL14}

PCA9685 Output Channel 14 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC14).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL15 (`INT32`) {#PCA9685_FAIL15}

PCA9685 Output Channel 15 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC15).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL16 (`INT32`) {#PCA9685_FAIL16}

PCA9685 Output Channel 16 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC16).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL2 (`INT32`) {#PCA9685_FAIL2}

PCA9685 Output Channel 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL3 (`INT32`) {#PCA9685_FAIL3}

PCA9685 Output Channel 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL4 (`INT32`) {#PCA9685_FAIL4}

PCA9685 Output Channel 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL5 (`INT32`) {#PCA9685_FAIL5}

PCA9685 Output Channel 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL6 (`INT32`) {#PCA9685_FAIL6}

PCA9685 Output Channel 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL7 (`INT32`) {#PCA9685_FAIL7}

PCA9685 Output Channel 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL8 (`INT32`) {#PCA9685_FAIL8}

PCA9685 Output Channel 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FAIL9 (`INT32`) {#PCA9685_FAIL9}

PCA9685 Output Channel 9 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PCA9685_FUNC9).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PCA9685_FUNC1 (`INT32`) {#PCA9685_FUNC1}

PCA9685 Output Channel 1 Output Function.

Select what should be output on PCA9685 Output Channel 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC10 (`INT32`) {#PCA9685_FUNC10}

PCA9685 Output Channel 10 Output Function.

Select what should be output on PCA9685 Output Channel 10. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC11 (`INT32`) {#PCA9685_FUNC11}

PCA9685 Output Channel 11 Output Function.

Select what should be output on PCA9685 Output Channel 11. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC12 (`INT32`) {#PCA9685_FUNC12}

PCA9685 Output Channel 12 Output Function.

Select what should be output on PCA9685 Output Channel 12. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC13 (`INT32`) {#PCA9685_FUNC13}

PCA9685 Output Channel 13 Output Function.

Select what should be output on PCA9685 Output Channel 13. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC14 (`INT32`) {#PCA9685_FUNC14}

PCA9685 Output Channel 14 Output Function.

Select what should be output on PCA9685 Output Channel 14. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC15 (`INT32`) {#PCA9685_FUNC15}

PCA9685 Output Channel 15 Output Function.

Select what should be output on PCA9685 Output Channel 15. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC16 (`INT32`) {#PCA9685_FUNC16}

PCA9685 Output Channel 16 Output Function.

Select what should be output on PCA9685 Output Channel 16. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC2 (`INT32`) {#PCA9685_FUNC2}

PCA9685 Output Channel 2 Output Function.

Select what should be output on PCA9685 Output Channel 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC3 (`INT32`) {#PCA9685_FUNC3}

PCA9685 Output Channel 3 Output Function.

Select what should be output on PCA9685 Output Channel 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC4 (`INT32`) {#PCA9685_FUNC4}

PCA9685 Output Channel 4 Output Function.

Select what should be output on PCA9685 Output Channel 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC5 (`INT32`) {#PCA9685_FUNC5}

PCA9685 Output Channel 5 Output Function.

Select what should be output on PCA9685 Output Channel 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC6 (`INT32`) {#PCA9685_FUNC6}

PCA9685 Output Channel 6 Output Function.

Select what should be output on PCA9685 Output Channel 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC7 (`INT32`) {#PCA9685_FUNC7}

PCA9685 Output Channel 7 Output Function.

Select what should be output on PCA9685 Output Channel 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC8 (`INT32`) {#PCA9685_FUNC8}

PCA9685 Output Channel 8 Output Function.

Select what should be output on PCA9685 Output Channel 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_FUNC9 (`INT32`) {#PCA9685_FUNC9}

PCA9685 Output Channel 9 Output Function.

Select what should be output on PCA9685 Output Channel 9. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PCA9685_MAX1 (`INT32`) {#PCA9685_MAX1}

PCA9685 Output Channel 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX10 (`INT32`) {#PCA9685_MAX10}

PCA9685 Output Channel 10 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX11 (`INT32`) {#PCA9685_MAX11}

PCA9685 Output Channel 11 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX12 (`INT32`) {#PCA9685_MAX12}

PCA9685 Output Channel 12 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX13 (`INT32`) {#PCA9685_MAX13}

PCA9685 Output Channel 13 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX14 (`INT32`) {#PCA9685_MAX14}

PCA9685 Output Channel 14 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX15 (`INT32`) {#PCA9685_MAX15}

PCA9685 Output Channel 15 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX16 (`INT32`) {#PCA9685_MAX16}

PCA9685 Output Channel 16 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX2 (`INT32`) {#PCA9685_MAX2}

PCA9685 Output Channel 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX3 (`INT32`) {#PCA9685_MAX3}

PCA9685 Output Channel 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX4 (`INT32`) {#PCA9685_MAX4}

PCA9685 Output Channel 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX5 (`INT32`) {#PCA9685_MAX5}

PCA9685 Output Channel 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX6 (`INT32`) {#PCA9685_MAX6}

PCA9685 Output Channel 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX7 (`INT32`) {#PCA9685_MAX7}

PCA9685 Output Channel 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX8 (`INT32`) {#PCA9685_MAX8}

PCA9685 Output Channel 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MAX9 (`INT32`) {#PCA9685_MAX9}

PCA9685 Output Channel 9 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 1900 |  

### PCA9685_MIN1 (`INT32`) {#PCA9685_MIN1}

PCA9685 Output Channel 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN10 (`INT32`) {#PCA9685_MIN10}

PCA9685 Output Channel 10 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN11 (`INT32`) {#PCA9685_MIN11}

PCA9685 Output Channel 11 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN12 (`INT32`) {#PCA9685_MIN12}

PCA9685 Output Channel 12 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN13 (`INT32`) {#PCA9685_MIN13}

PCA9685 Output Channel 13 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN14 (`INT32`) {#PCA9685_MIN14}

PCA9685 Output Channel 14 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN15 (`INT32`) {#PCA9685_MIN15}

PCA9685 Output Channel 15 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN16 (`INT32`) {#PCA9685_MIN16}

PCA9685 Output Channel 16 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN2 (`INT32`) {#PCA9685_MIN2}

PCA9685 Output Channel 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN3 (`INT32`) {#PCA9685_MIN3}

PCA9685 Output Channel 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN4 (`INT32`) {#PCA9685_MIN4}

PCA9685 Output Channel 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN5 (`INT32`) {#PCA9685_MIN5}

PCA9685 Output Channel 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN6 (`INT32`) {#PCA9685_MIN6}

PCA9685 Output Channel 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN7 (`INT32`) {#PCA9685_MIN7}

PCA9685 Output Channel 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN8 (`INT32`) {#PCA9685_MIN8}

PCA9685 Output Channel 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_MIN9 (`INT32`) {#PCA9685_MIN9}

PCA9685 Output Channel 9 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1100 |  

### PCA9685_PWM_FREQ (`FLOAT`) {#PCA9685_PWM_FREQ}

PWM cycle frequency.

Controls the PWM frequency at timing perspective. This is independent from PWM update frequency, as PCA9685 is capable to output without being continuously commanded by FC. Higher frequency leads to more accurate pulse width, but some ESCs and servos may not support it. This parameter should be set to the same value as PWM update rate in most case. This parameter MUST NOT exceed upper limit of 400.0, if any outputs as generic 1000~2000us pulse width is desired. Frequency higher than 400 only makes sense in duty-cycle mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 23.8 | 1525.87 |  | 50.0 |  

### PCA9685_REV (`INT32`) {#PCA9685_REV}

Reverse Output Range for PCA9685 Output.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: PCA9685 Output Channel 1
- `1`: PCA9685 Output Channel 2
- `2`: PCA9685 Output Channel 3
- `3`: PCA9685 Output Channel 4
- `4`: PCA9685 Output Channel 5
- `5`: PCA9685 Output Channel 6
- `6`: PCA9685 Output Channel 7
- `7`: PCA9685 Output Channel 8
- `8`: PCA9685 Output Channel 9
- `9`: PCA9685 Output Channel 10
- `10`: PCA9685 Output Channel 11
- `11`: PCA9685 Output Channel 12
- `12`: PCA9685 Output Channel 13
- `13`: PCA9685 Output Channel 14
- `14`: PCA9685 Output Channel 15
- `15`: PCA9685 Output Channel 16


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### PCA9685_SCHD_HZ (`FLOAT`) {#PCA9685_SCHD_HZ}

PWM update rate.

Controls the update rate of PWM output. Flight Controller will inform those numbers of update events in a second, to PCA9685. Higher update rate will consume more I2C bandwidth, which may even lead to worse output latency, or completely block I2C bus.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 50.0 | 400.0 |  | 50.0 |  

### PWM_AUX_DIS1 (`INT32`) {#PWM_AUX_DIS1}

PWM Aux 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS10 (`INT32`) {#PWM_AUX_DIS10}

PWM Capture 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS11 (`INT32`) {#PWM_AUX_DIS11}

PWM Capture 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS2 (`INT32`) {#PWM_AUX_DIS2}

PWM Aux 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS3 (`INT32`) {#PWM_AUX_DIS3}

PWM Aux 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS4 (`INT32`) {#PWM_AUX_DIS4}

PWM Aux 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS5 (`INT32`) {#PWM_AUX_DIS5}

PWM Aux 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS6 (`INT32`) {#PWM_AUX_DIS6}

PWM Aux 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS7 (`INT32`) {#PWM_AUX_DIS7}

PWM Aux 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS8 (`INT32`) {#PWM_AUX_DIS8}

PWM Aux 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_DIS9 (`INT32`) {#PWM_AUX_DIS9}

PWM Capture 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_AUX_FAIL1 (`INT32`) {#PWM_AUX_FAIL1}

PWM Aux 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL10 (`INT32`) {#PWM_AUX_FAIL10}

PWM Capture 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL11 (`INT32`) {#PWM_AUX_FAIL11}

PWM Capture 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL2 (`INT32`) {#PWM_AUX_FAIL2}

PWM Aux 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL3 (`INT32`) {#PWM_AUX_FAIL3}

PWM Aux 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL4 (`INT32`) {#PWM_AUX_FAIL4}

PWM Aux 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL5 (`INT32`) {#PWM_AUX_FAIL5}

PWM Aux 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL6 (`INT32`) {#PWM_AUX_FAIL6}

PWM Aux 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL7 (`INT32`) {#PWM_AUX_FAIL7}

PWM Aux 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL8 (`INT32`) {#PWM_AUX_FAIL8}

PWM Aux 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FAIL9 (`INT32`) {#PWM_AUX_FAIL9}

PWM Capture 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_AUX_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_AUX_FUNC1 (`INT32`) {#PWM_AUX_FUNC1}

PWM Aux 1 Output Function.

Select what should be output on PWM Aux 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC10 (`INT32`) {#PWM_AUX_FUNC10}

PWM Capture 2 Output Function.

Select what should be output on PWM Capture 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC11 (`INT32`) {#PWM_AUX_FUNC11}

PWM Capture 3 Output Function.

Select what should be output on PWM Capture 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC2 (`INT32`) {#PWM_AUX_FUNC2}

PWM Aux 2 Output Function.

Select what should be output on PWM Aux 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC3 (`INT32`) {#PWM_AUX_FUNC3}

PWM Aux 3 Output Function.

Select what should be output on PWM Aux 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC4 (`INT32`) {#PWM_AUX_FUNC4}

PWM Aux 4 Output Function.

Select what should be output on PWM Aux 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC5 (`INT32`) {#PWM_AUX_FUNC5}

PWM Aux 5 Output Function.

Select what should be output on PWM Aux 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC6 (`INT32`) {#PWM_AUX_FUNC6}

PWM Aux 6 Output Function.

Select what should be output on PWM Aux 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC7 (`INT32`) {#PWM_AUX_FUNC7}

PWM Aux 7 Output Function.

Select what should be output on PWM Aux 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC8 (`INT32`) {#PWM_AUX_FUNC8}

PWM Aux 8 Output Function.

Select what should be output on PWM Aux 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_FUNC9 (`INT32`) {#PWM_AUX_FUNC9}

PWM Capture 1 Output Function.

Select what should be output on PWM Capture 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter
- `2000`: Camera Trigger
- `2032`: Camera Capture
- `2064`: PPS Input
- `2070`: RPM Input


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_AUX_MAX1 (`INT32`) {#PWM_AUX_MAX1}

PWM Aux 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX10 (`INT32`) {#PWM_AUX_MAX10}

PWM Capture 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX11 (`INT32`) {#PWM_AUX_MAX11}

PWM Capture 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX2 (`INT32`) {#PWM_AUX_MAX2}

PWM Aux 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX3 (`INT32`) {#PWM_AUX_MAX3}

PWM Aux 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX4 (`INT32`) {#PWM_AUX_MAX4}

PWM Aux 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX5 (`INT32`) {#PWM_AUX_MAX5}

PWM Aux 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX6 (`INT32`) {#PWM_AUX_MAX6}

PWM Aux 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX7 (`INT32`) {#PWM_AUX_MAX7}

PWM Aux 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX8 (`INT32`) {#PWM_AUX_MAX8}

PWM Aux 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MAX9 (`INT32`) {#PWM_AUX_MAX9}

PWM Capture 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_AUX_MIN1 (`INT32`) {#PWM_AUX_MIN1}

PWM Aux 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN10 (`INT32`) {#PWM_AUX_MIN10}

PWM Capture 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN11 (`INT32`) {#PWM_AUX_MIN11}

PWM Capture 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN2 (`INT32`) {#PWM_AUX_MIN2}

PWM Aux 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN3 (`INT32`) {#PWM_AUX_MIN3}

PWM Aux 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN4 (`INT32`) {#PWM_AUX_MIN4}

PWM Aux 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN5 (`INT32`) {#PWM_AUX_MIN5}

PWM Aux 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN6 (`INT32`) {#PWM_AUX_MIN6}

PWM Aux 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN7 (`INT32`) {#PWM_AUX_MIN7}

PWM Aux 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN8 (`INT32`) {#PWM_AUX_MIN8}

PWM Aux 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_MIN9 (`INT32`) {#PWM_AUX_MIN9}

PWM Capture 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_AUX_REV (`INT32`) {#PWM_AUX_REV}

Reverse Output Range for PWM AUX.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: PWM Aux 1
- `1`: PWM Aux 2
- `2`: PWM Aux 3
- `3`: PWM Aux 4
- `4`: PWM Aux 5
- `5`: PWM Aux 6
- `6`: PWM Aux 7
- `7`: PWM Aux 8
- `8`: PWM Capture 1
- `9`: PWM Capture 2
- `10`: PWM Capture 3


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2047 |  | 0 |  

### PWM_AUX_TIM0 (`INT32`) {#PWM_AUX_TIM0}

Output Protocol Configuration for PWM Aux 1-4.

Select which Output Protocol to use for outputs PWM Aux 1-4. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-5`: DShot150
- `-4`: DShot300
- `-3`: DShot600
- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_AUX_TIM1 (`INT32`) {#PWM_AUX_TIM1}

Output Protocol Configuration for PWM Aux 5-6.

Select which Output Protocol to use for outputs PWM Aux 5-6. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_AUX_TIM2 (`INT32`) {#PWM_AUX_TIM2}

Output Protocol Configuration for PWM Aux 7-8.

Select which Output Protocol to use for outputs PWM Aux 7-8. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_AUX_TIM3 (`INT32`) {#PWM_AUX_TIM3}

Output Protocol Configuration for PWM Capture 1-3.

Select which Output Protocol to use for outputs PWM Capture 1-3. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_MAIN_DIS1 (`INT32`) {#PWM_MAIN_DIS1}

MAIN 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS2 (`INT32`) {#PWM_MAIN_DIS2}

MAIN 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS3 (`INT32`) {#PWM_MAIN_DIS3}

MAIN 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS4 (`INT32`) {#PWM_MAIN_DIS4}

MAIN 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS5 (`INT32`) {#PWM_MAIN_DIS5}

MAIN 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS6 (`INT32`) {#PWM_MAIN_DIS6}

MAIN 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS7 (`INT32`) {#PWM_MAIN_DIS7}

MAIN 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_DIS8 (`INT32`) {#PWM_MAIN_DIS8}

MAIN 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 2200 |  | 1000 |  

### PWM_MAIN_FAIL1 (`INT32`) {#PWM_MAIN_FAIL1}

MAIN 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL2 (`INT32`) {#PWM_MAIN_FAIL2}

MAIN 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL3 (`INT32`) {#PWM_MAIN_FAIL3}

MAIN 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL4 (`INT32`) {#PWM_MAIN_FAIL4}

MAIN 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL5 (`INT32`) {#PWM_MAIN_FAIL5}

MAIN 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL6 (`INT32`) {#PWM_MAIN_FAIL6}

MAIN 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL7 (`INT32`) {#PWM_MAIN_FAIL7}

MAIN 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FAIL8 (`INT32`) {#PWM_MAIN_FAIL8}

MAIN 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see PWM_MAIN_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 2200 |  | -1 |  

### PWM_MAIN_FUNC1 (`INT32`) {#PWM_MAIN_FUNC1}

MAIN 1 Output Function.

Select what should be output on MAIN 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC2 (`INT32`) {#PWM_MAIN_FUNC2}

MAIN 2 Output Function.

Select what should be output on MAIN 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC3 (`INT32`) {#PWM_MAIN_FUNC3}

MAIN 3 Output Function.

Select what should be output on MAIN 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC4 (`INT32`) {#PWM_MAIN_FUNC4}

MAIN 4 Output Function.

Select what should be output on MAIN 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC5 (`INT32`) {#PWM_MAIN_FUNC5}

MAIN 5 Output Function.

Select what should be output on MAIN 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC6 (`INT32`) {#PWM_MAIN_FUNC6}

MAIN 6 Output Function.

Select what should be output on MAIN 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC7 (`INT32`) {#PWM_MAIN_FUNC7}

MAIN 7 Output Function.

Select what should be output on MAIN 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_FUNC8 (`INT32`) {#PWM_MAIN_FUNC8}

MAIN 8 Output Function.

Select what should be output on MAIN 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### PWM_MAIN_MAX1 (`INT32`) {#PWM_MAIN_MAX1}

MAIN 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX2 (`INT32`) {#PWM_MAIN_MAX2}

MAIN 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX3 (`INT32`) {#PWM_MAIN_MAX3}

MAIN 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX4 (`INT32`) {#PWM_MAIN_MAX4}

MAIN 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX5 (`INT32`) {#PWM_MAIN_MAX5}

MAIN 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX6 (`INT32`) {#PWM_MAIN_MAX6}

MAIN 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX7 (`INT32`) {#PWM_MAIN_MAX7}

MAIN 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MAX8 (`INT32`) {#PWM_MAIN_MAX8}

MAIN 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1600 | 2200 |  | 2000 |  

### PWM_MAIN_MIN1 (`INT32`) {#PWM_MAIN_MIN1}

MAIN 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN2 (`INT32`) {#PWM_MAIN_MIN2}

MAIN 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN3 (`INT32`) {#PWM_MAIN_MIN3}

MAIN 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN4 (`INT32`) {#PWM_MAIN_MIN4}

MAIN 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN5 (`INT32`) {#PWM_MAIN_MIN5}

MAIN 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN6 (`INT32`) {#PWM_MAIN_MIN6}

MAIN 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN7 (`INT32`) {#PWM_MAIN_MIN7}

MAIN 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_MIN8 (`INT32`) {#PWM_MAIN_MIN8}

MAIN 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800 | 1400 |  | 1000 |  

### PWM_MAIN_REV (`INT32`) {#PWM_MAIN_REV}

Reverse Output Range for PWM MAIN.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: MAIN 1
- `1`: MAIN 2
- `2`: MAIN 3
- `3`: MAIN 4
- `4`: MAIN 5
- `5`: MAIN 6
- `6`: MAIN 7
- `7`: MAIN 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### PWM_MAIN_TIM0 (`INT32`) {#PWM_MAIN_TIM0}

Output Protocol Configuration for MAIN 1-2.

Select which Output Protocol to use for outputs MAIN 1-2. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_MAIN_TIM1 (`INT32`) {#PWM_MAIN_TIM1}

Output Protocol Configuration for MAIN 3-4.

Select which Output Protocol to use for outputs MAIN 3-4. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### PWM_MAIN_TIM2 (`INT32`) {#PWM_MAIN_TIM2}

Output Protocol Configuration for MAIN 5-8.

Select which Output Protocol to use for outputs MAIN 5-8. Custom PWM rates can be used by directly setting any value >0.

**Values:**

- `-1`: OneShot
- `50`: PWM 50 Hz
- `100`: PWM 100 Hz
- `200`: PWM 200 Hz
- `400`: PWM 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 400 |  

### RBCLW_DIS1 (`INT32`) {#RBCLW_DIS1}

Roboclaw Driver Channel 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 128 | 128 |  | 128 |  

### RBCLW_DIS2 (`INT32`) {#RBCLW_DIS2}

Roboclaw Driver Channel 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 128 | 128 |  | 128 |  

### RBCLW_FAIL1 (`INT32`) {#RBCLW_FAIL1}

Roboclaw Driver Channel 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see RBCLW_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 257 |  | -1 |  

### RBCLW_FAIL2 (`INT32`) {#RBCLW_FAIL2}

Roboclaw Driver Channel 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see RBCLW_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 257 |  | -1 |  

### RBCLW_FUNC1 (`INT32`) {#RBCLW_FUNC1}

Roboclaw Driver Channel 1 Output Function.

Select what should be output on Roboclaw Driver Channel 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### RBCLW_FUNC2 (`INT32`) {#RBCLW_FUNC2}

Roboclaw Driver Channel 2 Output Function.

Select what should be output on Roboclaw Driver Channel 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### RBCLW_MAX1 (`INT32`) {#RBCLW_MAX1}

Roboclaw Driver Channel 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 128 | 256 |  | 256 |  

### RBCLW_MAX2 (`INT32`) {#RBCLW_MAX2}

Roboclaw Driver Channel 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 128 | 256 |  | 256 |  

### RBCLW_MIN1 (`INT32`) {#RBCLW_MIN1}

Roboclaw Driver Channel 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 128 |  | 1 |  

### RBCLW_MIN2 (`INT32`) {#RBCLW_MIN2}

Roboclaw Driver Channel 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 128 |  | 1 |  

### RBCLW_REV (`INT32`) {#RBCLW_REV}

Reverse Output Range for Roboclaw Driver.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: Roboclaw Driver Channel 1
- `1`: Roboclaw Driver Channel 2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### SIM_GZ_EC_DIS1 (`INT32`) {#SIM_GZ_EC_DIS1}

SIM_GZ ESC 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS2 (`INT32`) {#SIM_GZ_EC_DIS2}

SIM_GZ ESC 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS3 (`INT32`) {#SIM_GZ_EC_DIS3}

SIM_GZ ESC 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS4 (`INT32`) {#SIM_GZ_EC_DIS4}

SIM_GZ ESC 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS5 (`INT32`) {#SIM_GZ_EC_DIS5}

SIM_GZ ESC 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS6 (`INT32`) {#SIM_GZ_EC_DIS6}

SIM_GZ ESC 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS7 (`INT32`) {#SIM_GZ_EC_DIS7}

SIM_GZ ESC 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_DIS8 (`INT32`) {#SIM_GZ_EC_DIS8}

SIM_GZ ESC 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_FAIL1 (`INT32`) {#SIM_GZ_EC_FAIL1}

SIM_GZ ESC 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL2 (`INT32`) {#SIM_GZ_EC_FAIL2}

SIM_GZ ESC 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL3 (`INT32`) {#SIM_GZ_EC_FAIL3}

SIM_GZ ESC 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL4 (`INT32`) {#SIM_GZ_EC_FAIL4}

SIM_GZ ESC 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL5 (`INT32`) {#SIM_GZ_EC_FAIL5}

SIM_GZ ESC 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL6 (`INT32`) {#SIM_GZ_EC_FAIL6}

SIM_GZ ESC 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL7 (`INT32`) {#SIM_GZ_EC_FAIL7}

SIM_GZ ESC 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FAIL8 (`INT32`) {#SIM_GZ_EC_FAIL8}

SIM_GZ ESC 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_EC_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_EC_FUNC1 (`INT32`) {#SIM_GZ_EC_FUNC1}

SIM_GZ ESC 1 Output Function.

Select what should be output on SIM_GZ ESC 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC2 (`INT32`) {#SIM_GZ_EC_FUNC2}

SIM_GZ ESC 2 Output Function.

Select what should be output on SIM_GZ ESC 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC3 (`INT32`) {#SIM_GZ_EC_FUNC3}

SIM_GZ ESC 3 Output Function.

Select what should be output on SIM_GZ ESC 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC4 (`INT32`) {#SIM_GZ_EC_FUNC4}

SIM_GZ ESC 4 Output Function.

Select what should be output on SIM_GZ ESC 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC5 (`INT32`) {#SIM_GZ_EC_FUNC5}

SIM_GZ ESC 5 Output Function.

Select what should be output on SIM_GZ ESC 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC6 (`INT32`) {#SIM_GZ_EC_FUNC6}

SIM_GZ ESC 6 Output Function.

Select what should be output on SIM_GZ ESC 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC7 (`INT32`) {#SIM_GZ_EC_FUNC7}

SIM_GZ ESC 7 Output Function.

Select what should be output on SIM_GZ ESC 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_FUNC8 (`INT32`) {#SIM_GZ_EC_FUNC8}

SIM_GZ ESC 8 Output Function.

Select what should be output on SIM_GZ ESC 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_EC_MAX1 (`INT32`) {#SIM_GZ_EC_MAX1}

SIM_GZ ESC 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX2 (`INT32`) {#SIM_GZ_EC_MAX2}

SIM_GZ ESC 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX3 (`INT32`) {#SIM_GZ_EC_MAX3}

SIM_GZ ESC 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX4 (`INT32`) {#SIM_GZ_EC_MAX4}

SIM_GZ ESC 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX5 (`INT32`) {#SIM_GZ_EC_MAX5}

SIM_GZ ESC 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX6 (`INT32`) {#SIM_GZ_EC_MAX6}

SIM_GZ ESC 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX7 (`INT32`) {#SIM_GZ_EC_MAX7}

SIM_GZ ESC 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MAX8 (`INT32`) {#SIM_GZ_EC_MAX8}

SIM_GZ ESC 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_EC_MIN1 (`INT32`) {#SIM_GZ_EC_MIN1}

SIM_GZ ESC 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN2 (`INT32`) {#SIM_GZ_EC_MIN2}

SIM_GZ ESC 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN3 (`INT32`) {#SIM_GZ_EC_MIN3}

SIM_GZ ESC 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN4 (`INT32`) {#SIM_GZ_EC_MIN4}

SIM_GZ ESC 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN5 (`INT32`) {#SIM_GZ_EC_MIN5}

SIM_GZ ESC 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN6 (`INT32`) {#SIM_GZ_EC_MIN6}

SIM_GZ ESC 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN7 (`INT32`) {#SIM_GZ_EC_MIN7}

SIM_GZ ESC 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_MIN8 (`INT32`) {#SIM_GZ_EC_MIN8}

SIM_GZ ESC 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_EC_REV (`INT32`) {#SIM_GZ_EC_REV}

Reverse Output Range for SIM_GZ.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: SIM_GZ ESC 1
- `1`: SIM_GZ ESC 2
- `2`: SIM_GZ ESC 3
- `3`: SIM_GZ ESC 4
- `4`: SIM_GZ ESC 5
- `5`: SIM_GZ ESC 6
- `6`: SIM_GZ ESC 7
- `7`: SIM_GZ ESC 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### SIM_GZ_SV_DIS1 (`INT32`) {#SIM_GZ_SV_DIS1}

SIM_GZ Servo 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS2 (`INT32`) {#SIM_GZ_SV_DIS2}

SIM_GZ Servo 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS3 (`INT32`) {#SIM_GZ_SV_DIS3}

SIM_GZ Servo 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS4 (`INT32`) {#SIM_GZ_SV_DIS4}

SIM_GZ Servo 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS5 (`INT32`) {#SIM_GZ_SV_DIS5}

SIM_GZ Servo 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS6 (`INT32`) {#SIM_GZ_SV_DIS6}

SIM_GZ Servo 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS7 (`INT32`) {#SIM_GZ_SV_DIS7}

SIM_GZ Servo 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_DIS8 (`INT32`) {#SIM_GZ_SV_DIS8}

SIM_GZ Servo 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### SIM_GZ_SV_FAIL1 (`INT32`) {#SIM_GZ_SV_FAIL1}

SIM_GZ Servo 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL2 (`INT32`) {#SIM_GZ_SV_FAIL2}

SIM_GZ Servo 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL3 (`INT32`) {#SIM_GZ_SV_FAIL3}

SIM_GZ Servo 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL4 (`INT32`) {#SIM_GZ_SV_FAIL4}

SIM_GZ Servo 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL5 (`INT32`) {#SIM_GZ_SV_FAIL5}

SIM_GZ Servo 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL6 (`INT32`) {#SIM_GZ_SV_FAIL6}

SIM_GZ Servo 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL7 (`INT32`) {#SIM_GZ_SV_FAIL7}

SIM_GZ Servo 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FAIL8 (`INT32`) {#SIM_GZ_SV_FAIL8}

SIM_GZ Servo 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_SV_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### SIM_GZ_SV_FUNC1 (`INT32`) {#SIM_GZ_SV_FUNC1}

SIM_GZ Servo 1 Output Function.

Select what should be output on SIM_GZ Servo 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC2 (`INT32`) {#SIM_GZ_SV_FUNC2}

SIM_GZ Servo 2 Output Function.

Select what should be output on SIM_GZ Servo 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC3 (`INT32`) {#SIM_GZ_SV_FUNC3}

SIM_GZ Servo 3 Output Function.

Select what should be output on SIM_GZ Servo 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC4 (`INT32`) {#SIM_GZ_SV_FUNC4}

SIM_GZ Servo 4 Output Function.

Select what should be output on SIM_GZ Servo 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC5 (`INT32`) {#SIM_GZ_SV_FUNC5}

SIM_GZ Servo 5 Output Function.

Select what should be output on SIM_GZ Servo 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC6 (`INT32`) {#SIM_GZ_SV_FUNC6}

SIM_GZ Servo 6 Output Function.

Select what should be output on SIM_GZ Servo 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC7 (`INT32`) {#SIM_GZ_SV_FUNC7}

SIM_GZ Servo 7 Output Function.

Select what should be output on SIM_GZ Servo 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_FUNC8 (`INT32`) {#SIM_GZ_SV_FUNC8}

SIM_GZ Servo 8 Output Function.

Select what should be output on SIM_GZ Servo 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_MAX1 (`INT32`) {#SIM_GZ_SV_MAX1}

SIM_GZ Servo 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX2 (`INT32`) {#SIM_GZ_SV_MAX2}

SIM_GZ Servo 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX3 (`INT32`) {#SIM_GZ_SV_MAX3}

SIM_GZ Servo 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX4 (`INT32`) {#SIM_GZ_SV_MAX4}

SIM_GZ Servo 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX5 (`INT32`) {#SIM_GZ_SV_MAX5}

SIM_GZ Servo 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX6 (`INT32`) {#SIM_GZ_SV_MAX6}

SIM_GZ Servo 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX7 (`INT32`) {#SIM_GZ_SV_MAX7}

SIM_GZ Servo 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MAX8 (`INT32`) {#SIM_GZ_SV_MAX8}

SIM_GZ Servo 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### SIM_GZ_SV_MIN1 (`INT32`) {#SIM_GZ_SV_MIN1}

SIM_GZ Servo 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN2 (`INT32`) {#SIM_GZ_SV_MIN2}

SIM_GZ Servo 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN3 (`INT32`) {#SIM_GZ_SV_MIN3}

SIM_GZ Servo 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN4 (`INT32`) {#SIM_GZ_SV_MIN4}

SIM_GZ Servo 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN5 (`INT32`) {#SIM_GZ_SV_MIN5}

SIM_GZ Servo 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN6 (`INT32`) {#SIM_GZ_SV_MIN6}

SIM_GZ Servo 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN7 (`INT32`) {#SIM_GZ_SV_MIN7}

SIM_GZ Servo 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_MIN8 (`INT32`) {#SIM_GZ_SV_MIN8}

SIM_GZ Servo 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### SIM_GZ_SV_REV (`INT32`) {#SIM_GZ_SV_REV}

Reverse Output Range for SIM_GZ.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: SIM_GZ Servo 1
- `1`: SIM_GZ Servo 2
- `2`: SIM_GZ Servo 3
- `3`: SIM_GZ Servo 4
- `4`: SIM_GZ Servo 5
- `5`: SIM_GZ Servo 6
- `6`: SIM_GZ Servo 7
- `7`: SIM_GZ Servo 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### SIM_GZ_WH_DIS1 (`INT32`) {#SIM_GZ_WH_DIS1}

SIM_GZ Wheels 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 100 |  

### SIM_GZ_WH_DIS2 (`INT32`) {#SIM_GZ_WH_DIS2}

SIM_GZ Wheels 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 100 |  

### SIM_GZ_WH_DIS3 (`INT32`) {#SIM_GZ_WH_DIS3}

SIM_GZ Wheels 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 100 |  

### SIM_GZ_WH_DIS4 (`INT32`) {#SIM_GZ_WH_DIS4}

SIM_GZ Wheels 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 100 |  

### SIM_GZ_WH_FAIL1 (`INT32`) {#SIM_GZ_WH_FAIL1}

SIM_GZ Wheels 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 200 |  | -1 |  

### SIM_GZ_WH_FAIL2 (`INT32`) {#SIM_GZ_WH_FAIL2}

SIM_GZ Wheels 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 200 |  | -1 |  

### SIM_GZ_WH_FAIL3 (`INT32`) {#SIM_GZ_WH_FAIL3}

SIM_GZ Wheels 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 200 |  | -1 |  

### SIM_GZ_WH_FAIL4 (`INT32`) {#SIM_GZ_WH_FAIL4}

SIM_GZ Wheels 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see SIM_GZ_WH_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 200 |  | -1 |  

### SIM_GZ_WH_FUNC1 (`INT32`) {#SIM_GZ_WH_FUNC1}

SIM_GZ Wheels 1 Output Function.

Select what should be output on SIM_GZ Wheels 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_WH_FUNC2 (`INT32`) {#SIM_GZ_WH_FUNC2}

SIM_GZ Wheels 2 Output Function.

Select what should be output on SIM_GZ Wheels 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_WH_FUNC3 (`INT32`) {#SIM_GZ_WH_FUNC3}

SIM_GZ Wheels 3 Output Function.

Select what should be output on SIM_GZ Wheels 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_WH_FUNC4 (`INT32`) {#SIM_GZ_WH_FUNC4}

SIM_GZ Wheels 4 Output Function.

Select what should be output on SIM_GZ Wheels 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_WH_MAX1 (`INT32`) {#SIM_GZ_WH_MAX1}

SIM_GZ Wheels 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 200 |  

### SIM_GZ_WH_MAX2 (`INT32`) {#SIM_GZ_WH_MAX2}

SIM_GZ Wheels 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 200 |  

### SIM_GZ_WH_MAX3 (`INT32`) {#SIM_GZ_WH_MAX3}

SIM_GZ Wheels 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 200 |  

### SIM_GZ_WH_MAX4 (`INT32`) {#SIM_GZ_WH_MAX4}

SIM_GZ Wheels 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 200 |  

### SIM_GZ_WH_MIN1 (`INT32`) {#SIM_GZ_WH_MIN1}

SIM_GZ Wheels 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 0 |  

### SIM_GZ_WH_MIN2 (`INT32`) {#SIM_GZ_WH_MIN2}

SIM_GZ Wheels 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 0 |  

### SIM_GZ_WH_MIN3 (`INT32`) {#SIM_GZ_WH_MIN3}

SIM_GZ Wheels 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 0 |  

### SIM_GZ_WH_MIN4 (`INT32`) {#SIM_GZ_WH_MIN4}

SIM_GZ Wheels 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 200 |  | 0 |  

### SIM_GZ_WH_REV (`INT32`) {#SIM_GZ_WH_REV}

Reverse Output Range for SIM_GZ.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: SIM_GZ Wheels 1
- `1`: SIM_GZ Wheels 2
- `2`: SIM_GZ Wheels 3
- `3`: SIM_GZ Wheels 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 15 |  | 0 |  

### TAP_ESC_FUNC1 (`INT32`) {#TAP_ESC_FUNC1}

TAP ESC Output ESC 1 Output Function.

Select what should be output on TAP ESC Output ESC 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC2 (`INT32`) {#TAP_ESC_FUNC2}

TAP ESC Output ESC 2 Output Function.

Select what should be output on TAP ESC Output ESC 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC3 (`INT32`) {#TAP_ESC_FUNC3}

TAP ESC Output ESC 3 Output Function.

Select what should be output on TAP ESC Output ESC 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC4 (`INT32`) {#TAP_ESC_FUNC4}

TAP ESC Output ESC 4 Output Function.

Select what should be output on TAP ESC Output ESC 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC5 (`INT32`) {#TAP_ESC_FUNC5}

TAP ESC Output ESC 5 Output Function.

Select what should be output on TAP ESC Output ESC 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC6 (`INT32`) {#TAP_ESC_FUNC6}

TAP ESC Output ESC 6 Output Function.

Select what should be output on TAP ESC Output ESC 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC7 (`INT32`) {#TAP_ESC_FUNC7}

TAP ESC Output ESC 7 Output Function.

Select what should be output on TAP ESC Output ESC 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_FUNC8 (`INT32`) {#TAP_ESC_FUNC8}

TAP ESC Output ESC 8 Output Function.

Select what should be output on TAP ESC Output ESC 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TAP_ESC_REV (`INT32`) {#TAP_ESC_REV}

Reverse Output Range for TAP ESC Output.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: TAP ESC Output ESC 1
- `1`: TAP ESC Output ESC 2
- `2`: TAP ESC Output ESC 3
- `3`: TAP ESC Output ESC 4
- `4`: TAP ESC Output ESC 5
- `5`: TAP ESC Output ESC 6
- `6`: TAP ESC Output ESC 7
- `7`: TAP ESC Output ESC 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### UAVCAN_EC_FAIL1 (`INT32`) {#UAVCAN_EC_FAIL1}

UAVCAN ESC 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL2 (`INT32`) {#UAVCAN_EC_FAIL2}

UAVCAN ESC 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL3 (`INT32`) {#UAVCAN_EC_FAIL3}

UAVCAN ESC 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL4 (`INT32`) {#UAVCAN_EC_FAIL4}

UAVCAN ESC 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL5 (`INT32`) {#UAVCAN_EC_FAIL5}

UAVCAN ESC 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL6 (`INT32`) {#UAVCAN_EC_FAIL6}

UAVCAN ESC 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL7 (`INT32`) {#UAVCAN_EC_FAIL7}

UAVCAN ESC 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FAIL8 (`INT32`) {#UAVCAN_EC_FAIL8}

UAVCAN ESC 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_EC_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UAVCAN_EC_FUNC1 (`INT32`) {#UAVCAN_EC_FUNC1}

UAVCAN ESC 1 Output Function.

Select what should be output on UAVCAN ESC 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC2 (`INT32`) {#UAVCAN_EC_FUNC2}

UAVCAN ESC 2 Output Function.

Select what should be output on UAVCAN ESC 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC3 (`INT32`) {#UAVCAN_EC_FUNC3}

UAVCAN ESC 3 Output Function.

Select what should be output on UAVCAN ESC 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC4 (`INT32`) {#UAVCAN_EC_FUNC4}

UAVCAN ESC 4 Output Function.

Select what should be output on UAVCAN ESC 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC5 (`INT32`) {#UAVCAN_EC_FUNC5}

UAVCAN ESC 5 Output Function.

Select what should be output on UAVCAN ESC 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC6 (`INT32`) {#UAVCAN_EC_FUNC6}

UAVCAN ESC 6 Output Function.

Select what should be output on UAVCAN ESC 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC7 (`INT32`) {#UAVCAN_EC_FUNC7}

UAVCAN ESC 7 Output Function.

Select what should be output on UAVCAN ESC 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_FUNC8 (`INT32`) {#UAVCAN_EC_FUNC8}

UAVCAN ESC 8 Output Function.

Select what should be output on UAVCAN ESC 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_EC_MAX1 (`INT32`) {#UAVCAN_EC_MAX1}

UAVCAN ESC 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX2 (`INT32`) {#UAVCAN_EC_MAX2}

UAVCAN ESC 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX3 (`INT32`) {#UAVCAN_EC_MAX3}

UAVCAN ESC 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX4 (`INT32`) {#UAVCAN_EC_MAX4}

UAVCAN ESC 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX5 (`INT32`) {#UAVCAN_EC_MAX5}

UAVCAN ESC 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX6 (`INT32`) {#UAVCAN_EC_MAX6}

UAVCAN ESC 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX7 (`INT32`) {#UAVCAN_EC_MAX7}

UAVCAN ESC 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MAX8 (`INT32`) {#UAVCAN_EC_MAX8}

UAVCAN ESC 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UAVCAN_EC_MIN1 (`INT32`) {#UAVCAN_EC_MIN1}

UAVCAN ESC 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN2 (`INT32`) {#UAVCAN_EC_MIN2}

UAVCAN ESC 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN3 (`INT32`) {#UAVCAN_EC_MIN3}

UAVCAN ESC 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN4 (`INT32`) {#UAVCAN_EC_MIN4}

UAVCAN ESC 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN5 (`INT32`) {#UAVCAN_EC_MIN5}

UAVCAN ESC 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN6 (`INT32`) {#UAVCAN_EC_MIN6}

UAVCAN ESC 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN7 (`INT32`) {#UAVCAN_EC_MIN7}

UAVCAN ESC 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_MIN8 (`INT32`) {#UAVCAN_EC_MIN8}

UAVCAN ESC 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UAVCAN_EC_REV (`INT32`) {#UAVCAN_EC_REV}

Reverse Output Range for UAVCAN.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: UAVCAN ESC 1
- `1`: UAVCAN ESC 2
- `2`: UAVCAN ESC 3
- `3`: UAVCAN ESC 4
- `4`: UAVCAN ESC 5
- `5`: UAVCAN ESC 6
- `6`: UAVCAN ESC 7
- `7`: UAVCAN ESC 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### UAVCAN_SV_DIS1 (`INT32`) {#UAVCAN_SV_DIS1}

UAVCAN Servo 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS2 (`INT32`) {#UAVCAN_SV_DIS2}

UAVCAN Servo 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS3 (`INT32`) {#UAVCAN_SV_DIS3}

UAVCAN Servo 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS4 (`INT32`) {#UAVCAN_SV_DIS4}

UAVCAN Servo 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS5 (`INT32`) {#UAVCAN_SV_DIS5}

UAVCAN Servo 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS6 (`INT32`) {#UAVCAN_SV_DIS6}

UAVCAN Servo 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS7 (`INT32`) {#UAVCAN_SV_DIS7}

UAVCAN Servo 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_DIS8 (`INT32`) {#UAVCAN_SV_DIS8}

UAVCAN Servo 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 500 |  

### UAVCAN_SV_FAIL1 (`INT32`) {#UAVCAN_SV_FAIL1}

UAVCAN Servo 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL2 (`INT32`) {#UAVCAN_SV_FAIL2}

UAVCAN Servo 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL3 (`INT32`) {#UAVCAN_SV_FAIL3}

UAVCAN Servo 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL4 (`INT32`) {#UAVCAN_SV_FAIL4}

UAVCAN Servo 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL5 (`INT32`) {#UAVCAN_SV_FAIL5}

UAVCAN Servo 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL6 (`INT32`) {#UAVCAN_SV_FAIL6}

UAVCAN Servo 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL7 (`INT32`) {#UAVCAN_SV_FAIL7}

UAVCAN Servo 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FAIL8 (`INT32`) {#UAVCAN_SV_FAIL8}

UAVCAN Servo 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UAVCAN_SV_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1 |  

### UAVCAN_SV_FUNC1 (`INT32`) {#UAVCAN_SV_FUNC1}

UAVCAN Servo 1 Output Function.

Select what should be output on UAVCAN Servo 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC2 (`INT32`) {#UAVCAN_SV_FUNC2}

UAVCAN Servo 2 Output Function.

Select what should be output on UAVCAN Servo 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC3 (`INT32`) {#UAVCAN_SV_FUNC3}

UAVCAN Servo 3 Output Function.

Select what should be output on UAVCAN Servo 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC4 (`INT32`) {#UAVCAN_SV_FUNC4}

UAVCAN Servo 4 Output Function.

Select what should be output on UAVCAN Servo 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC5 (`INT32`) {#UAVCAN_SV_FUNC5}

UAVCAN Servo 5 Output Function.

Select what should be output on UAVCAN Servo 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC6 (`INT32`) {#UAVCAN_SV_FUNC6}

UAVCAN Servo 6 Output Function.

Select what should be output on UAVCAN Servo 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC7 (`INT32`) {#UAVCAN_SV_FUNC7}

UAVCAN Servo 7 Output Function.

Select what should be output on UAVCAN Servo 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_FUNC8 (`INT32`) {#UAVCAN_SV_FUNC8}

UAVCAN Servo 8 Output Function.

Select what should be output on UAVCAN Servo 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UAVCAN_SV_MAX1 (`INT32`) {#UAVCAN_SV_MAX1}

UAVCAN Servo 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX2 (`INT32`) {#UAVCAN_SV_MAX2}

UAVCAN Servo 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX3 (`INT32`) {#UAVCAN_SV_MAX3}

UAVCAN Servo 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX4 (`INT32`) {#UAVCAN_SV_MAX4}

UAVCAN Servo 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX5 (`INT32`) {#UAVCAN_SV_MAX5}

UAVCAN Servo 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX6 (`INT32`) {#UAVCAN_SV_MAX6}

UAVCAN Servo 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX7 (`INT32`) {#UAVCAN_SV_MAX7}

UAVCAN Servo 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MAX8 (`INT32`) {#UAVCAN_SV_MAX8}

UAVCAN Servo 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### UAVCAN_SV_MIN1 (`INT32`) {#UAVCAN_SV_MIN1}

UAVCAN Servo 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN2 (`INT32`) {#UAVCAN_SV_MIN2}

UAVCAN Servo 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN3 (`INT32`) {#UAVCAN_SV_MIN3}

UAVCAN Servo 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN4 (`INT32`) {#UAVCAN_SV_MIN4}

UAVCAN Servo 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN5 (`INT32`) {#UAVCAN_SV_MIN5}

UAVCAN Servo 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN6 (`INT32`) {#UAVCAN_SV_MIN6}

UAVCAN Servo 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN7 (`INT32`) {#UAVCAN_SV_MIN7}

UAVCAN Servo 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_MIN8 (`INT32`) {#UAVCAN_SV_MIN8}

UAVCAN Servo 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 0 |  

### UAVCAN_SV_REV (`INT32`) {#UAVCAN_SV_REV}

Reverse Output Range for UAVCAN.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: UAVCAN Servo 1
- `1`: UAVCAN Servo 2
- `2`: UAVCAN Servo 3
- `3`: UAVCAN Servo 4
- `4`: UAVCAN Servo 5
- `5`: UAVCAN Servo 6
- `6`: UAVCAN Servo 7
- `7`: UAVCAN Servo 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### UCAN1_ESC_FAIL1 (`INT32`) {#UCAN1_ESC_FAIL1}

UAVCANv1 ESC 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL10 (`INT32`) {#UCAN1_ESC_FAIL10}

UAVCANv1 ESC 10 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC10).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL11 (`INT32`) {#UCAN1_ESC_FAIL11}

UAVCANv1 ESC 11 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC11).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL12 (`INT32`) {#UCAN1_ESC_FAIL12}

UAVCANv1 ESC 12 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC12).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL13 (`INT32`) {#UCAN1_ESC_FAIL13}

UAVCANv1 ESC 13 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC13).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL14 (`INT32`) {#UCAN1_ESC_FAIL14}

UAVCANv1 ESC 14 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC14).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL15 (`INT32`) {#UCAN1_ESC_FAIL15}

UAVCANv1 ESC 15 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC15).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL16 (`INT32`) {#UCAN1_ESC_FAIL16}

UAVCANv1 ESC 16 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC16).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL2 (`INT32`) {#UCAN1_ESC_FAIL2}

UAVCANv1 ESC 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL3 (`INT32`) {#UCAN1_ESC_FAIL3}

UAVCANv1 ESC 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL4 (`INT32`) {#UCAN1_ESC_FAIL4}

UAVCANv1 ESC 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL5 (`INT32`) {#UCAN1_ESC_FAIL5}

UAVCANv1 ESC 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL6 (`INT32`) {#UCAN1_ESC_FAIL6}

UAVCANv1 ESC 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL7 (`INT32`) {#UCAN1_ESC_FAIL7}

UAVCANv1 ESC 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL8 (`INT32`) {#UCAN1_ESC_FAIL8}

UAVCANv1 ESC 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FAIL9 (`INT32`) {#UCAN1_ESC_FAIL9}

UAVCANv1 ESC 9 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see UCAN1_ESC_FUNC9).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 8191 |  | -1 |  

### UCAN1_ESC_FUNC1 (`INT32`) {#UCAN1_ESC_FUNC1}

UAVCANv1 ESC 1 Output Function.

Select what should be output on UAVCANv1 ESC 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC10 (`INT32`) {#UCAN1_ESC_FUNC10}

UAVCANv1 ESC 10 Output Function.

Select what should be output on UAVCANv1 ESC 10. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC11 (`INT32`) {#UCAN1_ESC_FUNC11}

UAVCANv1 ESC 11 Output Function.

Select what should be output on UAVCANv1 ESC 11. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC12 (`INT32`) {#UCAN1_ESC_FUNC12}

UAVCANv1 ESC 12 Output Function.

Select what should be output on UAVCANv1 ESC 12. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC13 (`INT32`) {#UCAN1_ESC_FUNC13}

UAVCANv1 ESC 13 Output Function.

Select what should be output on UAVCANv1 ESC 13. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC14 (`INT32`) {#UCAN1_ESC_FUNC14}

UAVCANv1 ESC 14 Output Function.

Select what should be output on UAVCANv1 ESC 14. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC15 (`INT32`) {#UCAN1_ESC_FUNC15}

UAVCANv1 ESC 15 Output Function.

Select what should be output on UAVCANv1 ESC 15. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC16 (`INT32`) {#UCAN1_ESC_FUNC16}

UAVCANv1 ESC 16 Output Function.

Select what should be output on UAVCANv1 ESC 16. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC2 (`INT32`) {#UCAN1_ESC_FUNC2}

UAVCANv1 ESC 2 Output Function.

Select what should be output on UAVCANv1 ESC 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC3 (`INT32`) {#UCAN1_ESC_FUNC3}

UAVCANv1 ESC 3 Output Function.

Select what should be output on UAVCANv1 ESC 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC4 (`INT32`) {#UCAN1_ESC_FUNC4}

UAVCANv1 ESC 4 Output Function.

Select what should be output on UAVCANv1 ESC 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC5 (`INT32`) {#UCAN1_ESC_FUNC5}

UAVCANv1 ESC 5 Output Function.

Select what should be output on UAVCANv1 ESC 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC6 (`INT32`) {#UCAN1_ESC_FUNC6}

UAVCANv1 ESC 6 Output Function.

Select what should be output on UAVCANv1 ESC 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC7 (`INT32`) {#UCAN1_ESC_FUNC7}

UAVCANv1 ESC 7 Output Function.

Select what should be output on UAVCANv1 ESC 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC8 (`INT32`) {#UCAN1_ESC_FUNC8}

UAVCANv1 ESC 8 Output Function.

Select what should be output on UAVCANv1 ESC 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_FUNC9 (`INT32`) {#UCAN1_ESC_FUNC9}

UAVCANv1 ESC 9 Output Function.

Select what should be output on UAVCANv1 ESC 9. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### UCAN1_ESC_MAX1 (`INT32`) {#UCAN1_ESC_MAX1}

UAVCANv1 ESC 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX10 (`INT32`) {#UCAN1_ESC_MAX10}

UAVCANv1 ESC 10 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX11 (`INT32`) {#UCAN1_ESC_MAX11}

UAVCANv1 ESC 11 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX12 (`INT32`) {#UCAN1_ESC_MAX12}

UAVCANv1 ESC 12 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX13 (`INT32`) {#UCAN1_ESC_MAX13}

UAVCANv1 ESC 13 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX14 (`INT32`) {#UCAN1_ESC_MAX14}

UAVCANv1 ESC 14 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX15 (`INT32`) {#UCAN1_ESC_MAX15}

UAVCANv1 ESC 15 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX16 (`INT32`) {#UCAN1_ESC_MAX16}

UAVCANv1 ESC 16 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX2 (`INT32`) {#UCAN1_ESC_MAX2}

UAVCANv1 ESC 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX3 (`INT32`) {#UCAN1_ESC_MAX3}

UAVCANv1 ESC 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX4 (`INT32`) {#UCAN1_ESC_MAX4}

UAVCANv1 ESC 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX5 (`INT32`) {#UCAN1_ESC_MAX5}

UAVCANv1 ESC 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX6 (`INT32`) {#UCAN1_ESC_MAX6}

UAVCANv1 ESC 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX7 (`INT32`) {#UCAN1_ESC_MAX7}

UAVCANv1 ESC 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX8 (`INT32`) {#UCAN1_ESC_MAX8}

UAVCANv1 ESC 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MAX9 (`INT32`) {#UCAN1_ESC_MAX9}

UAVCANv1 ESC 9 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 8191 |  

### UCAN1_ESC_MIN1 (`INT32`) {#UCAN1_ESC_MIN1}

UAVCANv1 ESC 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN10 (`INT32`) {#UCAN1_ESC_MIN10}

UAVCANv1 ESC 10 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN11 (`INT32`) {#UCAN1_ESC_MIN11}

UAVCANv1 ESC 11 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN12 (`INT32`) {#UCAN1_ESC_MIN12}

UAVCANv1 ESC 12 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN13 (`INT32`) {#UCAN1_ESC_MIN13}

UAVCANv1 ESC 13 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN14 (`INT32`) {#UCAN1_ESC_MIN14}

UAVCANv1 ESC 14 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN15 (`INT32`) {#UCAN1_ESC_MIN15}

UAVCANv1 ESC 15 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN16 (`INT32`) {#UCAN1_ESC_MIN16}

UAVCANv1 ESC 16 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN2 (`INT32`) {#UCAN1_ESC_MIN2}

UAVCANv1 ESC 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN3 (`INT32`) {#UCAN1_ESC_MIN3}

UAVCANv1 ESC 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN4 (`INT32`) {#UCAN1_ESC_MIN4}

UAVCANv1 ESC 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN5 (`INT32`) {#UCAN1_ESC_MIN5}

UAVCANv1 ESC 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN6 (`INT32`) {#UCAN1_ESC_MIN6}

UAVCANv1 ESC 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN7 (`INT32`) {#UCAN1_ESC_MIN7}

UAVCANv1 ESC 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN8 (`INT32`) {#UCAN1_ESC_MIN8}

UAVCANv1 ESC 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_MIN9 (`INT32`) {#UCAN1_ESC_MIN9}

UAVCANv1 ESC 9 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 8191 |  | 1 |  

### UCAN1_ESC_REV (`INT32`) {#UCAN1_ESC_REV}

Reverse Output Range for UAVCANv1.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: UAVCANv1 ESC 1
- `1`: UAVCANv1 ESC 2
- `2`: UAVCANv1 ESC 3
- `3`: UAVCANv1 ESC 4
- `4`: UAVCANv1 ESC 5
- `5`: UAVCANv1 ESC 6
- `6`: UAVCANv1 ESC 7
- `7`: UAVCANv1 ESC 8
- `8`: UAVCANv1 ESC 9
- `9`: UAVCANv1 ESC 10
- `10`: UAVCANv1 ESC 11
- `11`: UAVCANv1 ESC 12
- `12`: UAVCANv1 ESC 13
- `13`: UAVCANv1 ESC 14
- `14`: UAVCANv1 ESC 15
- `15`: UAVCANv1 ESC 16


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VOXL2_IO_FUNC1 (`INT32`) {#VOXL2_IO_FUNC1}

VOXL2 IO Output PWM Channel 1 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC2 (`INT32`) {#VOXL2_IO_FUNC2}

VOXL2 IO Output PWM Channel 2 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC3 (`INT32`) {#VOXL2_IO_FUNC3}

VOXL2 IO Output PWM Channel 3 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC4 (`INT32`) {#VOXL2_IO_FUNC4}

VOXL2 IO Output PWM Channel 4 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC5 (`INT32`) {#VOXL2_IO_FUNC5}

VOXL2 IO Output PWM Channel 5 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC6 (`INT32`) {#VOXL2_IO_FUNC6}

VOXL2 IO Output PWM Channel 6 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC7 (`INT32`) {#VOXL2_IO_FUNC7}

VOXL2 IO Output PWM Channel 7 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_FUNC8 (`INT32`) {#VOXL2_IO_FUNC8}

VOXL2 IO Output PWM Channel 8 Output Function.

Select what should be output on VOXL2 IO Output PWM Channel 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL2_IO_REV (`INT32`) {#VOXL2_IO_REV}

Reverse Output Range for VOXL2 IO Output.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: VOXL2 IO Output PWM Channel 1
- `1`: VOXL2 IO Output PWM Channel 2
- `2`: VOXL2 IO Output PWM Channel 3
- `3`: VOXL2 IO Output PWM Channel 4
- `4`: VOXL2 IO Output PWM Channel 5
- `5`: VOXL2 IO Output PWM Channel 6
- `6`: VOXL2 IO Output PWM Channel 7
- `7`: VOXL2 IO Output PWM Channel 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### VOXL_ESC_FUNC1 (`INT32`) {#VOXL_ESC_FUNC1}

VOXL ESC Output ESC 1 Output Function.

Select what should be output on VOXL ESC Output ESC 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL_ESC_FUNC2 (`INT32`) {#VOXL_ESC_FUNC2}

VOXL ESC Output ESC 2 Output Function.

Select what should be output on VOXL ESC Output ESC 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL_ESC_FUNC3 (`INT32`) {#VOXL_ESC_FUNC3}

VOXL ESC Output ESC 3 Output Function.

Select what should be output on VOXL ESC Output ESC 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL_ESC_FUNC4 (`INT32`) {#VOXL_ESC_FUNC4}

VOXL ESC Output ESC 4 Output Function.

Select what should be output on VOXL ESC Output ESC 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXL_ESC_REV (`INT32`) {#VOXL_ESC_REV}

Reverse Output Range for VOXL ESC Output.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `0`: VOXL ESC Output ESC 1
- `1`: VOXL ESC Output ESC 2
- `2`: VOXL ESC Output ESC 3
- `3`: VOXL ESC Output ESC 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 15 |  | 0 |  

### VTQ_IO_DIS0 (`INT32`) {#VTQ_IO_DIS0}

Vertiq IO CVI 0 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS1 (`INT32`) {#VTQ_IO_DIS1}

Vertiq IO CVI 1 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS10 (`INT32`) {#VTQ_IO_DIS10}

Vertiq IO CVI 10 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS11 (`INT32`) {#VTQ_IO_DIS11}

Vertiq IO CVI 11 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS12 (`INT32`) {#VTQ_IO_DIS12}

Vertiq IO CVI 12 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS13 (`INT32`) {#VTQ_IO_DIS13}

Vertiq IO CVI 13 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS14 (`INT32`) {#VTQ_IO_DIS14}

Vertiq IO CVI 14 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS15 (`INT32`) {#VTQ_IO_DIS15}

Vertiq IO CVI 15 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS2 (`INT32`) {#VTQ_IO_DIS2}

Vertiq IO CVI 2 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS3 (`INT32`) {#VTQ_IO_DIS3}

Vertiq IO CVI 3 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS4 (`INT32`) {#VTQ_IO_DIS4}

Vertiq IO CVI 4 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS5 (`INT32`) {#VTQ_IO_DIS5}

Vertiq IO CVI 5 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS6 (`INT32`) {#VTQ_IO_DIS6}

Vertiq IO CVI 6 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS7 (`INT32`) {#VTQ_IO_DIS7}

Vertiq IO CVI 7 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS8 (`INT32`) {#VTQ_IO_DIS8}

Vertiq IO CVI 8 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_DIS9 (`INT32`) {#VTQ_IO_DIS9}

Vertiq IO CVI 9 Disarmed Value.

This is the output value that is set when not armed. Note that non-motor outputs might already be active in prearm state if COM_PREARM_MODE is set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_FAIL0 (`INT32`) {#VTQ_IO_FAIL0}

Vertiq IO CVI 0 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC0).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL1 (`INT32`) {#VTQ_IO_FAIL1}

Vertiq IO CVI 1 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL10 (`INT32`) {#VTQ_IO_FAIL10}

Vertiq IO CVI 10 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC10).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL11 (`INT32`) {#VTQ_IO_FAIL11}

Vertiq IO CVI 11 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC11).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL12 (`INT32`) {#VTQ_IO_FAIL12}

Vertiq IO CVI 12 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC12).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL13 (`INT32`) {#VTQ_IO_FAIL13}

Vertiq IO CVI 13 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC13).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL14 (`INT32`) {#VTQ_IO_FAIL14}

Vertiq IO CVI 14 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC14).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL15 (`INT32`) {#VTQ_IO_FAIL15}

Vertiq IO CVI 15 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC15).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL2 (`INT32`) {#VTQ_IO_FAIL2}

Vertiq IO CVI 2 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC2).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL3 (`INT32`) {#VTQ_IO_FAIL3}

Vertiq IO CVI 3 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC3).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL4 (`INT32`) {#VTQ_IO_FAIL4}

Vertiq IO CVI 4 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC4).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL5 (`INT32`) {#VTQ_IO_FAIL5}

Vertiq IO CVI 5 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC5).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL6 (`INT32`) {#VTQ_IO_FAIL6}

Vertiq IO CVI 6 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC6).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL7 (`INT32`) {#VTQ_IO_FAIL7}

Vertiq IO CVI 7 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC7).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL8 (`INT32`) {#VTQ_IO_FAIL8}

Vertiq IO CVI 8 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC8).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FAIL9 (`INT32`) {#VTQ_IO_FAIL9}

Vertiq IO CVI 9 Failsafe Value.

This is the output value that is set when in failsafe mode. When set to -1 (default), the value depends on the function (see VTQ_IO_FUNC9).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 500 |  | -1 |  

### VTQ_IO_FUNC0 (`INT32`) {#VTQ_IO_FUNC0}

Vertiq IO CVI 0 Output Function.

Select what should be output on Vertiq IO CVI 0. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC1 (`INT32`) {#VTQ_IO_FUNC1}

Vertiq IO CVI 1 Output Function.

Select what should be output on Vertiq IO CVI 1. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC10 (`INT32`) {#VTQ_IO_FUNC10}

Vertiq IO CVI 10 Output Function.

Select what should be output on Vertiq IO CVI 10. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC11 (`INT32`) {#VTQ_IO_FUNC11}

Vertiq IO CVI 11 Output Function.

Select what should be output on Vertiq IO CVI 11. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC12 (`INT32`) {#VTQ_IO_FUNC12}

Vertiq IO CVI 12 Output Function.

Select what should be output on Vertiq IO CVI 12. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC13 (`INT32`) {#VTQ_IO_FUNC13}

Vertiq IO CVI 13 Output Function.

Select what should be output on Vertiq IO CVI 13. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC14 (`INT32`) {#VTQ_IO_FUNC14}

Vertiq IO CVI 14 Output Function.

Select what should be output on Vertiq IO CVI 14. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC15 (`INT32`) {#VTQ_IO_FUNC15}

Vertiq IO CVI 15 Output Function.

Select what should be output on Vertiq IO CVI 15. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC2 (`INT32`) {#VTQ_IO_FUNC2}

Vertiq IO CVI 2 Output Function.

Select what should be output on Vertiq IO CVI 2. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC3 (`INT32`) {#VTQ_IO_FUNC3}

Vertiq IO CVI 3 Output Function.

Select what should be output on Vertiq IO CVI 3. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC4 (`INT32`) {#VTQ_IO_FUNC4}

Vertiq IO CVI 4 Output Function.

Select what should be output on Vertiq IO CVI 4. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC5 (`INT32`) {#VTQ_IO_FUNC5}

Vertiq IO CVI 5 Output Function.

Select what should be output on Vertiq IO CVI 5. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC6 (`INT32`) {#VTQ_IO_FUNC6}

Vertiq IO CVI 6 Output Function.

Select what should be output on Vertiq IO CVI 6. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC7 (`INT32`) {#VTQ_IO_FUNC7}

Vertiq IO CVI 7 Output Function.

Select what should be output on Vertiq IO CVI 7. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC8 (`INT32`) {#VTQ_IO_FUNC8}

Vertiq IO CVI 8 Output Function.

Select what should be output on Vertiq IO CVI 8. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_FUNC9 (`INT32`) {#VTQ_IO_FUNC9}

Vertiq IO CVI 9 Output Function.

Select what should be output on Vertiq IO CVI 9. The default failsafe value is set according to the selected function: - 'Min' for ConstantMin - 'Max' for ConstantMax - 'Max' for Parachute - ('Max'+'Min')/2 for Servos - 'Disarmed' for the rest

**Values:**

- `0`: Disabled
- `1`: Constant Min
- `2`: Constant Max
- `101`: Motor 1
- `102`: Motor 2
- `103`: Motor 3
- `104`: Motor 4
- `105`: Motor 5
- `106`: Motor 6
- `107`: Motor 7
- `108`: Motor 8
- `109`: Motor 9
- `110`: Motor 10
- `111`: Motor 11
- `112`: Motor 12
- `201`: Servo 1
- `202`: Servo 2
- `203`: Servo 3
- `204`: Servo 4
- `205`: Servo 5
- `206`: Servo 6
- `207`: Servo 7
- `208`: Servo 8
- `301`: Peripheral via Actuator Set 1
- `302`: Peripheral via Actuator Set 2
- `303`: Peripheral via Actuator Set 3
- `304`: Peripheral via Actuator Set 4
- `305`: Peripheral via Actuator Set 5
- `306`: Peripheral via Actuator Set 6
- `400`: Landing Gear
- `401`: Parachute
- `402`: RC Roll
- `403`: RC Pitch
- `404`: RC Throttle
- `405`: RC Yaw
- `406`: RC Flaps
- `407`: RC AUX 1
- `408`: RC AUX 2
- `409`: RC AUX 3
- `410`: RC AUX 4
- `411`: RC AUX 5
- `412`: RC AUX 6
- `420`: Gimbal Roll
- `421`: Gimbal Pitch
- `422`: Gimbal Yaw
- `430`: Gripper
- `440`: Landing Gear Wheel
- `450`: IC Engine Ignition
- `451`: IC Engine Throttle
- `452`: IC Engine Choke
- `453`: IC Engine Starter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VTQ_IO_MAX0 (`INT32`) {#VTQ_IO_MAX0}

Vertiq IO CVI 0 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX1 (`INT32`) {#VTQ_IO_MAX1}

Vertiq IO CVI 1 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX10 (`INT32`) {#VTQ_IO_MAX10}

Vertiq IO CVI 10 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX11 (`INT32`) {#VTQ_IO_MAX11}

Vertiq IO CVI 11 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX12 (`INT32`) {#VTQ_IO_MAX12}

Vertiq IO CVI 12 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX13 (`INT32`) {#VTQ_IO_MAX13}

Vertiq IO CVI 13 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX14 (`INT32`) {#VTQ_IO_MAX14}

Vertiq IO CVI 14 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX15 (`INT32`) {#VTQ_IO_MAX15}

Vertiq IO CVI 15 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX2 (`INT32`) {#VTQ_IO_MAX2}

Vertiq IO CVI 2 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX3 (`INT32`) {#VTQ_IO_MAX3}

Vertiq IO CVI 3 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX4 (`INT32`) {#VTQ_IO_MAX4}

Vertiq IO CVI 4 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX5 (`INT32`) {#VTQ_IO_MAX5}

Vertiq IO CVI 5 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX6 (`INT32`) {#VTQ_IO_MAX6}

Vertiq IO CVI 6 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX7 (`INT32`) {#VTQ_IO_MAX7}

Vertiq IO CVI 7 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX8 (`INT32`) {#VTQ_IO_MAX8}

Vertiq IO CVI 8 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MAX9 (`INT32`) {#VTQ_IO_MAX9}

Vertiq IO CVI 9 Maximum Value.

Maxmimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 65535 |  

### VTQ_IO_MIN0 (`INT32`) {#VTQ_IO_MIN0}

Vertiq IO CVI 0 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN1 (`INT32`) {#VTQ_IO_MIN1}

Vertiq IO CVI 1 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN10 (`INT32`) {#VTQ_IO_MIN10}

Vertiq IO CVI 10 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN11 (`INT32`) {#VTQ_IO_MIN11}

Vertiq IO CVI 11 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN12 (`INT32`) {#VTQ_IO_MIN12}

Vertiq IO CVI 12 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN13 (`INT32`) {#VTQ_IO_MIN13}

Vertiq IO CVI 13 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN14 (`INT32`) {#VTQ_IO_MIN14}

Vertiq IO CVI 14 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN15 (`INT32`) {#VTQ_IO_MIN15}

Vertiq IO CVI 15 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN2 (`INT32`) {#VTQ_IO_MIN2}

Vertiq IO CVI 2 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN3 (`INT32`) {#VTQ_IO_MIN3}

Vertiq IO CVI 3 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN4 (`INT32`) {#VTQ_IO_MIN4}

Vertiq IO CVI 4 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN5 (`INT32`) {#VTQ_IO_MIN5}

Vertiq IO CVI 5 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN6 (`INT32`) {#VTQ_IO_MIN6}

Vertiq IO CVI 6 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN7 (`INT32`) {#VTQ_IO_MIN7}

Vertiq IO CVI 7 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN8 (`INT32`) {#VTQ_IO_MIN8}

Vertiq IO CVI 8 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_MIN9 (`INT32`) {#VTQ_IO_MIN9}

Vertiq IO CVI 9 Minimum Value.

Minimum output value (when not disarmed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### VTQ_IO_REV (`INT32`) {#VTQ_IO_REV}

Reverse Output Range for Vertiq IO.

Allows to reverse the output range for each channel. Note: this is only useful for servos.

**Bitmask:**

- `-1`: Vertiq IO CVI 0
- `0`: Vertiq IO CVI 1
- `1`: Vertiq IO CVI 2
- `2`: Vertiq IO CVI 3
- `3`: Vertiq IO CVI 4
- `4`: Vertiq IO CVI 5
- `5`: Vertiq IO CVI 6
- `6`: Vertiq IO CVI 7
- `7`: Vertiq IO CVI 8
- `8`: Vertiq IO CVI 9
- `9`: Vertiq IO CVI 10
- `10`: Vertiq IO CVI 11
- `11`: Vertiq IO CVI 12
- `12`: Vertiq IO CVI 13
- `13`: Vertiq IO CVI 14
- `14`: Vertiq IO CVI 15


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 32767 |  | 0 |  

## Airspeed Validator

### ASPD_BETA_GATE (`INT32`) {#ASPD_BETA_GATE}

Gate size for sideslip angle fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 5 |  | 1 | SD 

### ASPD_BETA_NOISE (`FLOAT`) {#ASPD_BETA_NOISE}

Wind estimator sideslip measurement noise.

Sideslip measurement noise of the internal wind estimator(s) of the airspeed selector.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.15 | rad 

### ASPD_DO_CHECKS (`INT32`) {#ASPD_DO_CHECKS}

Enable checks on airspeed sensors.

Controls which checks are run to check airspeed data for validity. Only applied if ASPD_PRIMARY > 0.

**Bitmask:**

- `0`: Only data missing check (triggers if more than 1s no data)
- `1`: Data stuck (triggers if data is exactly constant for 2s in FW mode)
- `2`: Innovation check (see ASPD_FS_INNOV)
- `3`: Load factor check (triggers if measurement is below stall speed)
- `4`: First principle check (airspeed change vs. throttle and pitch)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 31 |  | 7 |  

### ASPD_FALLBACK_GW (`INT32`) {#ASPD_FALLBACK_GW}

Enable fallback to sensor-less airspeed estimation.

If set to true and airspeed checks are enabled, it will use a sensor-less airspeed estimation based on groundspeed minus windspeed if no other airspeed sensor available to fall back to.

**Values:**

- `0`: Disable fallback to sensor-less estimation
- `1`: Enable fallback to sensor-less estimation


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### ASPD_FP_T_WINDOW (`FLOAT`) {#ASPD_FP_T_WINDOW}

First principle airspeed check time window.

Window for comparing airspeed change to throttle and pitch change. Triggers when the airspeed change within this window is negative while throttle increases and the vehicle pitches down. Is meant to catch degrading airspeed blockages as can happen when flying through icing conditions. Relies on  FW_THR_TRIM being set accurately.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 2.0 | s 

### ASPD_FS_INNOV (`FLOAT`) {#ASPD_FS_INNOV}

Airspeed failure innovation threshold.

This specifies the minimum airspeed innovation required to trigger a failsafe. Larger values make the check less sensitive, smaller values make it more sensitive. Large innovations indicate an inconsistency between predicted (groundspeed - windspeeed) and measured airspeed. The time required to detect a fault when the threshold is exceeded depends on the size of the exceedance and is controlled by the ASPD_FS_INTEG parameter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 10.0 |  | 5. | m/s 

### ASPD_FS_INTEG (`FLOAT`) {#ASPD_FS_INTEG}

Airspeed failure innovation integral threshold.

This sets the time integral of airspeed innovation exceedance above ASPD_FS_INNOV required to trigger a failsafe. Larger values make the check less sensitive, smaller positive values make it more sensitive.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 50.0 |  | 10. | m 

### ASPD_FS_T_START (`FLOAT`) {#ASPD_FS_T_START}

Airspeed failsafe start delay.

Delay before switching back to using airspeed sensor if checks indicate sensor is good. Set to a negative value to disable the re-enabling in flight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  |  | -1. | s 

### ASPD_FS_T_STOP (`FLOAT`) {#ASPD_FS_T_STOP}

Airspeed failsafe stop delay.

Delay before stopping use of airspeed sensor if checks indicate sensor is bad.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  |  | 1. | s 

### ASPD_PRIMARY (`INT32`) {#ASPD_PRIMARY}

Index or primary airspeed measurement source.

**Values:**

- `0`: Groundspeed minus windspeed
- `1`: First airspeed sensor
- `2`: Second airspeed sensor
- `3`: Third airspeed sensor


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### ASPD_SCALE_1 (`FLOAT`) {#ASPD_SCALE_1}

Scale of airspeed sensor 1.

This is the scale IAS --> CAS of the first airspeed sensor instance

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.5 | 2.0 |  | 1.0 |  

### ASPD_SCALE_2 (`FLOAT`) {#ASPD_SCALE_2}

Scale of airspeed sensor 2.

This is the scale IAS --> CAS of the second airspeed sensor instance

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.5 | 2.0 |  | 1.0 |  

### ASPD_SCALE_3 (`FLOAT`) {#ASPD_SCALE_3}

Scale of airspeed sensor 3.

This is the scale IAS --> CAS of the third airspeed sensor instance

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.5 | 2.0 |  | 1.0 |  

### ASPD_SCALE_APPLY (`INT32`) {#ASPD_SCALE_APPLY}

Controls when to apply the new estimated airspeed scale(s).

**Values:**

- `0`: Do not automatically apply the estimated scale
- `1`: Apply the estimated scale after disarm
- `2`: Apply the estimated scale in air


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### ASPD_SCALE_NSD (`FLOAT`) {#ASPD_SCALE_NSD}

Wind estimator true airspeed scale process noise spectral density.

Airspeed scale process noise of the internal wind estimator(s) of the airspeed selector. When unaided, the scale uncertainty (1-sigma, unitless) increases by this amount every second.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.1 |  | 1.e-4 | 1/s/sqrt(Hz) 

### ASPD_TAS_GATE (`INT32`) {#ASPD_TAS_GATE}

Gate size for true airspeed fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 5 |  | 4 | SD 

### ASPD_TAS_NOISE (`FLOAT`) {#ASPD_TAS_NOISE}

Wind estimator true airspeed measurement noise.

True airspeed measurement noise of the internal wind estimator(s) of the airspeed selector.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4 |  | 1.4 | m/s 

### ASPD_WERR_THR (`FLOAT`) {#ASPD_WERR_THR}

Horizontal wind uncertainty threshold for synthetic airspeed.

The synthetic airspeed estimate (from groundspeed and heading) will be declared valid as soon and as long the horizontal wind uncertainty is below this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 | 5 |  | 0.55 | m/s 

### ASPD_WIND_NSD (`FLOAT`) {#ASPD_WIND_NSD}

Wind estimator wind process noise spectral density.

Wind process noise of the internal wind estimator(s) of the airspeed selector. When unaided, the wind estimate uncertainty (1-sigma, in m/s) increases by this amount every second.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1.e-1 | m/s^2/sqrt(Hz) 

## Attitude Q estimator

### ATT_ACC_COMP (`INT32`) {#ATT_ACC_COMP}

Acceleration compensation based on GPS velocity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### ATT_BIAS_MAX (`FLOAT`) {#ATT_BIAS_MAX}

Gyro bias limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 0.05 | rad/s 

### ATT_EN (`INT32`) {#ATT_EN}

standalone attitude estimator enable (unsupported).

Enable standalone quaternion based attitude estimator.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### ATT_EXT_HDG_M (`INT32`) {#ATT_EXT_HDG_M}

External heading usage mode (from Motion capture/Vision).

Set to 1 to use heading estimate from vision. Set to 2 to use heading from motion capture.

**Values:**

- `0`: None
- `1`: Vision
- `2`: Motion Capture


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 0 |  

### ATT_MAG_DECL (`FLOAT`) {#ATT_MAG_DECL}

Magnetic declination, in degrees.

This parameter is not used in normal operation, as the declination is looked up based on the GPS coordinates of the vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | deg 

### ATT_MAG_DECL_A (`INT32`) {#ATT_MAG_DECL_A}

Automatic GPS based declination compensation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### ATT_W_ACC (`FLOAT`) {#ATT_W_ACC}

Complimentary filter accelerometer weight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.2 |  

### ATT_W_EXT_HDG (`FLOAT`) {#ATT_W_EXT_HDG}

Complimentary filter external heading weight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.1 |  

### ATT_W_GYRO_BIAS (`FLOAT`) {#ATT_W_GYRO_BIAS}

Complimentary filter gyroscope bias weight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.1 |  

### ATT_W_MAG (`FLOAT`) {#ATT_W_MAG}

Complimentary filter magnetometer weight.

Set to 0 to avoid using the magnetometer.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.1 |  

## Autotune

### FW_AT_APPLY (`INT32`) {#FW_AT_APPLY}

Controls when to apply the new gains.

After the auto-tuning sequence is completed, a new set of gains is available and can be applied immediately or after landing.

**Values:**

- `0`: Do not apply the new gains (logging only)
- `1`: Apply the new gains after disarm
- `2`: Apply the new gains in air


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### FW_AT_AXES (`INT32`) {#FW_AT_AXES}

Tuning axes selection.

Defines which axes will be tuned during the auto-tuning sequence Set bits in the following positions to enable: 0 : Roll 1 : Pitch 2 : Yaw

**Bitmask:**

- `0`: roll
- `1`: pitch
- `2`: yaw


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 7 |  | 3 |  

### FW_AT_MAN_AUX (`INT32`) {#FW_AT_MAN_AUX}

Enable/disable auto tuning using an RC AUX input.

Defines which RC_MAP_AUXn parameter maps the RC channel used to enable/disable auto tuning.

**Values:**

- `0`: Disable
- `1`: Aux1
- `2`: Aux2
- `3`: Aux3
- `4`: Aux4
- `5`: Aux5
- `6`: Aux6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 6 |  | 0 |  

### FW_AT_START (`INT32`) {#FW_AT_START}

Start the autotuning sequence.

WARNING: this will inject steps to the rate controller and can be dangerous. Only activate if you know what you are doing, and in a safe environment. Any motion of the remote stick will abort the signal injection and reset this parameter Best is to perform the identification in position or hold mode. Increase the amplitude of the injected signal using FW_AT_SYSID_AMP for more signal/noise ratio

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_AT_SYSID_AMP (`FLOAT`) {#FW_AT_SYSID_AMP}

Amplitude of the injected signal.

This parameter scales the signal sent to the rate controller during system identification.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 6.0 |  | 1.0 |  

### FW_AT_SYSID_F0 (`FLOAT`) {#FW_AT_SYSID_F0}

Start frequency of the injected signal.

Can be set lower or higher than the end frequency

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 30.0 |  | 1. | Hz 

### FW_AT_SYSID_F1 (`FLOAT`) {#FW_AT_SYSID_F1}

End frequency of the injected signal.

Can be set lower or higher than the start frequency

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 30.0 |  | 20. | Hz 

### FW_AT_SYSID_TIME (`FLOAT`) {#FW_AT_SYSID_TIME}

Maneuver time for each axis.

Duration of the input signal sent on each axis during system identification

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 120 |  | 10. | s 

### FW_AT_SYSID_TYPE (`INT32`) {#FW_AT_SYSID_TYPE}

Input signal type.

Type of signal used during system identification to excite the system.

**Values:**

- `0`: Step
- `1`: Linear sine sweep
- `2`: Logarithmic sine sweep


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MC_AT_APPLY (`INT32`) {#MC_AT_APPLY}

Controls when to apply the new gains.

After the auto-tuning sequence is completed, a new set of gains is available and can be applied immediately or after landing. WARNING Applying the gains in air is dangerous as there is no guarantee that those new gains will be able to stabilize the drone properly.

**Values:**

- `0`: Do not apply the new gains (logging only)
- `1`: Apply the new gains after disarm
- `2`: WARNING Apply the new gains in air


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### MC_AT_EN (`INT32`) {#MC_AT_EN}

Multicopter autotune module enable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### MC_AT_RISE_TIME (`FLOAT`) {#MC_AT_RISE_TIME}

Desired angular rate closed-loop rise time.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 0.5 |  | 0.14 | s 

### MC_AT_START (`INT32`) {#MC_AT_START}

Start the autotuning sequence.

WARNING: this will inject steps to the rate controller and can be dangerous. Only activate if you know what you are doing, and in a safe environment. Any motion of the remote stick will abort the signal injection and reset this parameter Best is to perform the identification in position or hold mode. Increase the amplitude of the injected signal using MC_AT_SYSID_AMP for more signal/noise ratio

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### MC_AT_SYSID_AMP (`FLOAT`) {#MC_AT_SYSID_AMP}

Amplitude of the injected signal.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 6.0 |  | 0.7 |  

## Battery Calibration

### BAT1_A_PER_V (`FLOAT`) {#BAT1_A_PER_V}

Battery 1 current per volt (A/V).

The voltage seen by the ADC multiplied by this factor will determine the battery current. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1.0 |  

### BAT1_CAPACITY (`FLOAT`) {#BAT1_CAPACITY}

Battery 1 capacity.

Defines the capacity of battery 1 in mAh.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 100000 | 50 | -1.0 | mAh 

### BAT1_I_CHANNEL (`INT32`) {#BAT1_I_CHANNEL}

Battery 1 Current ADC Channel.

This parameter specifies the ADC channel used to monitor current of main power battery. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT1_I_OVERWRITE (`FLOAT`) {#BAT1_I_OVERWRITE}

Battery 1 idle current overwrite.

This parameter allows to overwrite the current measured during idle (unarmed) state with a user-defined constant value (expressed in amperes). When the system is armed, the measured current is used. This is useful because on certain ESCs current measurements are inaccurate in case of no load. Negative values are ignored and will cause the measured current to be used. The default value of 0 disables the overwrite, in which case the measured value is always used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### BAT1_N_CELLS (`INT32`) {#BAT1_N_CELLS}

Number of cells for battery 1.

Defines the number of cells the attached battery consists of.

**Values:**

- `0`: Unknown
- `1`: 1S Battery
- `2`: 2S Battery
- `3`: 3S Battery
- `4`: 4S Battery
- `5`: 5S Battery
- `6`: 6S Battery
- `7`: 7S Battery
- `8`: 8S Battery
- `9`: 9S Battery
- `10`: 10S Battery
- `11`: 11S Battery
- `12`: 12S Battery
- `13`: 13S Battery
- `14`: 14S Battery
- `15`: 15S Battery
- `16`: 16S Battery


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### BAT1_R_INTERNAL (`FLOAT`) {#BAT1_R_INTERNAL}

Explicitly defines the per cell internal resistance for battery 1.

If non-negative, then this will be used instead of the online estimated internal resistance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 0.2 | 0.0005 | -1.0 | Ohm 

### BAT1_SOURCE (`INT32`) {#BAT1_SOURCE}

Battery 1 monitoring source.

This parameter controls the source of battery data. The value 'Power Module' means that measurements are expected to come from a power module. If the value is set to 'External' then the system expects to receive mavlink battery status messages. If the value is set to 'ESCs', the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.

**Values:**

- `-1`: Disabled
- `0`: Power Module
- `1`: External
- `2`: ESCs


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### BAT1_V_CHANNEL (`INT32`) {#BAT1_V_CHANNEL}

Battery 1 Voltage ADC Channel.

This parameter specifies the ADC channel used to monitor voltage of main power battery. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT1_V_CHARGED (`FLOAT`) {#BAT1_V_CHARGED}

Full cell voltage.

Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 4.05 | V 

### BAT1_V_DIV (`FLOAT`) {#BAT1_V_DIV}

Battery 1 voltage divider (V divider).

This is the divider from battery 1 voltage to ADC voltage. If using e.g. Mauch power modules the value from the datasheet can be applied straight here. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1.0 |  

### BAT1_V_EMPTY (`FLOAT`) {#BAT1_V_EMPTY}

Empty cell voltage.

Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 3.6 | V 

### BAT2_A_PER_V (`FLOAT`) {#BAT2_A_PER_V}

Battery 2 current per volt (A/V).

The voltage seen by the ADC multiplied by this factor will determine the battery current. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1.0 |  

### BAT2_CAPACITY (`FLOAT`) {#BAT2_CAPACITY}

Battery 2 capacity.

Defines the capacity of battery 2 in mAh.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 100000 | 50 | -1.0 | mAh 

### BAT2_I_CHANNEL (`INT32`) {#BAT2_I_CHANNEL}

Battery 2 Current ADC Channel.

This parameter specifies the ADC channel used to monitor current of main power battery. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT2_I_OVERWRITE (`FLOAT`) {#BAT2_I_OVERWRITE}

Battery 2 idle current overwrite.

This parameter allows to overwrite the current measured during idle (unarmed) state with a user-defined constant value (expressed in amperes). When the system is armed, the measured current is used. This is useful because on certain ESCs current measurements are inaccurate in case of no load. Negative values are ignored and will cause the measured current to be used. The default value of 0 disables the overwrite, in which case the measured value is always used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### BAT2_N_CELLS (`INT32`) {#BAT2_N_CELLS}

Number of cells for battery 2.

Defines the number of cells the attached battery consists of.

**Values:**

- `0`: Unknown
- `1`: 1S Battery
- `2`: 2S Battery
- `3`: 3S Battery
- `4`: 4S Battery
- `5`: 5S Battery
- `6`: 6S Battery
- `7`: 7S Battery
- `8`: 8S Battery
- `9`: 9S Battery
- `10`: 10S Battery
- `11`: 11S Battery
- `12`: 12S Battery
- `13`: 13S Battery
- `14`: 14S Battery
- `15`: 15S Battery
- `16`: 16S Battery


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### BAT2_R_INTERNAL (`FLOAT`) {#BAT2_R_INTERNAL}

Explicitly defines the per cell internal resistance for battery 2.

If non-negative, then this will be used instead of the online estimated internal resistance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 0.2 | 0.0005 | -1.0 | Ohm 

### BAT2_SOURCE (`INT32`) {#BAT2_SOURCE}

Battery 2 monitoring source.

This parameter controls the source of battery data. The value 'Power Module' means that measurements are expected to come from a power module. If the value is set to 'External' then the system expects to receive mavlink battery status messages. If the value is set to 'ESCs', the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.

**Values:**

- `-1`: Disabled
- `0`: Power Module
- `1`: External
- `2`: ESCs


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT2_V_CHANNEL (`INT32`) {#BAT2_V_CHANNEL}

Battery 2 Voltage ADC Channel.

This parameter specifies the ADC channel used to monitor voltage of main power battery. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT2_V_CHARGED (`FLOAT`) {#BAT2_V_CHARGED}

Full cell voltage.

Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 4.05 | V 

### BAT2_V_DIV (`FLOAT`) {#BAT2_V_DIV}

Battery 2 voltage divider (V divider).

This is the divider from battery 2 voltage to ADC voltage. If using e.g. Mauch power modules the value from the datasheet can be applied straight here. A value of -1 means to use the board default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1.0 |  

### BAT2_V_EMPTY (`FLOAT`) {#BAT2_V_EMPTY}

Empty cell voltage.

Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 3.6 | V 

### BAT3_CAPACITY (`FLOAT`) {#BAT3_CAPACITY}

Battery 3 capacity.

Defines the capacity of battery 3 in mAh.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 100000 | 50 | -1.0 | mAh 

### BAT3_N_CELLS (`INT32`) {#BAT3_N_CELLS}

Number of cells for battery 3.

Defines the number of cells the attached battery consists of.

**Values:**

- `0`: Unknown
- `1`: 1S Battery
- `2`: 2S Battery
- `3`: 3S Battery
- `4`: 4S Battery
- `5`: 5S Battery
- `6`: 6S Battery
- `7`: 7S Battery
- `8`: 8S Battery
- `9`: 9S Battery
- `10`: 10S Battery
- `11`: 11S Battery
- `12`: 12S Battery
- `13`: 13S Battery
- `14`: 14S Battery
- `15`: 15S Battery
- `16`: 16S Battery


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### BAT3_R_INTERNAL (`FLOAT`) {#BAT3_R_INTERNAL}

Explicitly defines the per cell internal resistance for battery 3.

If non-negative, then this will be used instead of the online estimated internal resistance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1.0 | 0.2 | 0.0005 | -1.0 | Ohm 

### BAT3_SOURCE (`INT32`) {#BAT3_SOURCE}

Battery 3 monitoring source.

This parameter controls the source of battery data. The value 'Power Module' means that measurements are expected to come from a power module. If the value is set to 'External' then the system expects to receive mavlink battery status messages. If the value is set to 'ESCs', the battery information are taken from the esc_status message. This requires the ESC to provide both voltage as well as current.

**Values:**

- `-1`: Disabled
- `0`: Power Module
- `1`: External
- `2`: ESCs


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | -1 |  

### BAT3_V_CHARGED (`FLOAT`) {#BAT3_V_CHARGED}

Full cell voltage.

Defines the voltage where a single cell of the battery is considered full. For a more accurate estimate set this below the nominal voltage of e.g. 4.2V

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 4.05 | V 

### BAT3_V_EMPTY (`FLOAT`) {#BAT3_V_EMPTY}

Empty cell voltage.

Defines the voltage where a single cell of the battery is considered empty. The voltage should be chosen above the steep dropoff at 3.5V. A typical lithium battery can only be discharged under high load down to 10% before it drops off to a voltage level damaging the cells.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  | 0.01 | 3.6 | V 

### BAT_ADC_CHANNEL (`INT32`) {#BAT_ADC_CHANNEL}

This parameter is deprecated. Please use BAT1_I_CHANNEL.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### BAT_AVRG_CURRENT (`FLOAT`) {#BAT_AVRG_CURRENT}

Expected battery current in flight.

This value is used to initialize the in-flight average current estimation, which in turn is used for estimating remaining flight time and RTL triggering.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 500 | 0.1 | 15 | A 

### BAT_CRIT_THR (`FLOAT`) {#BAT_CRIT_THR}

Critical threshold.

Sets the threshold when the battery will be reported as critically low. This has to be lower than the low threshold. This threshold commonly will trigger RTL.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 0.5 | 0.01 | 0.07 | norm 

### BAT_EMERGEN_THR (`FLOAT`) {#BAT_EMERGEN_THR}

Emergency threshold.

Sets the threshold when the battery will be reported as dangerously low. This has to be lower than the critical threshold. This threshold commonly will trigger landing.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.03 | 0.5 | 0.01 | 0.05 | norm 

### BAT_LOW_THR (`FLOAT`) {#BAT_LOW_THR}

Low threshold.

Sets the threshold when the battery will be reported as low. This has to be higher than the critical threshold.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.12 | 0.5 | 0.01 | 0.15 | norm 

### BAT_V_OFFS_CURR (`FLOAT`) {#BAT_V_OFFS_CURR}

Offset in volt as seen by the ADC input of the current sensor.

This offset will be subtracted before calculating the battery current based on the voltage.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

## CDCACM

### SYS_USB_AUTO (`INT32`) {#SYS_USB_AUTO}

Enable USB autostart.

**Values:**

- `0`: Disabled
- `1`: Auto-detect
- `2`: MAVLink


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

### USB_MAV_MODE (`INT32`) {#USB_MAV_MODE}

Specify USB MAVLink mode.

**Values:**

- `0`: normal
- `1`: custom
- `2`: onboard
- `3`: osd
- `4`: magic
- `5`: config
- `6`: iridium
- `7`: minimal
- `8`: extvision
- `9`: extvisionmin
- `10`: gimbal
- `11`: onboard_low_bandwidth
- `12`: uavionix


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

## Camera Capture

### CAM_CAP_DELAY (`FLOAT`) {#CAM_CAP_DELAY}

Camera strobe delay.

This parameter sets the delay between image integration start and strobe firing

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 | ms 

## Camera Control

### CAM_CAP_EDGE (`INT32`) {#CAM_CAP_EDGE}

Camera capture edge.

**Values:**

- `0`: Falling edge
- `1`: Rising edge


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### CAM_CAP_FBACK (`INT32`) {#CAM_CAP_FBACK}

Camera capture feedback.

Enables camera capture feedback

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### CAM_CAP_MODE (`INT32`) {#CAM_CAP_MODE}

Camera capture timestamping mode.

Change time measurement

**Values:**

- `0`: Get absolute timestamp
- `1`: Get timestamp of mid exposure (active high)
- `2`: Get timestamp of mid exposure (active low)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

## Camera trigger

### TRIG_ACT_TIME (`FLOAT`) {#TRIG_ACT_TIME}

Camera trigger activation time.

This parameter sets the time the trigger needs to pulled high or low.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.1 | 3000 |  | 40.0 | ms 

### TRIG_DISTANCE (`FLOAT`) {#TRIG_DISTANCE}

Camera trigger distance.

Sets the distance at which to trigger the camera.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 |  | 1 | 25.0 | m 

### TRIG_INTERFACE (`INT32`) {#TRIG_INTERFACE}

Camera trigger Interface.

Selects the trigger interface

**Values:**

- `1`: GPIO
- `2`: Seagull MAP2 (over PWM)
- `3`: MAVLink (Camera Protocol v1)
- `4`: Generic PWM (IR trigger, servo)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 4 |  

### TRIG_INTERVAL (`FLOAT`) {#TRIG_INTERVAL}

Camera trigger interval.

This parameter sets the time between two consecutive trigger events

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 4.0 | 10000.0 |  | 40.0 | ms 

### TRIG_MIN_INTERVA (`FLOAT`) {#TRIG_MIN_INTERVA}

Minimum camera trigger interval.

This parameter sets the minimum time between two consecutive trigger events the specific camera setup is supporting.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1.0 | 10000.0 |  | 1.0 | ms 

### TRIG_MODE (`INT32`) {#TRIG_MODE}

Camera trigger mode.

**Values:**

- `0`: Disable
- `1`: Time based, on command
- `2`: Time based, always on
- `3`: Distance based, always on
- `4`: Distance based, on command (Survey mode)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 4 |  | 0 |  

### TRIG_POLARITY (`INT32`) {#TRIG_POLARITY}

Camera trigger polarity.

This parameter sets the polarity of the trigger (0 = active low, 1 = active high )

**Values:**

- `0`: Active low
- `1`: Active high


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### TRIG_PWM_NEUTRAL (`INT32`) {#TRIG_PWM_NEUTRAL}

PWM neutral output on trigger pin.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1000 | 2000 |  | 1500 | us 

### TRIG_PWM_SHOOT (`INT32`) {#TRIG_PWM_SHOOT}

PWM output to trigger shot.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1000 | 2000 |  | 1900 | us 

## Circuit Breaker

### CBRK_BUZZER (`INT32`) {#CBRK_BUZZER}

Circuit breaker for disabling buzzer.

Setting this parameter to 782097 will disable the buzzer audio notification. Setting this parameter to 782090 will disable the startup tune, while keeping all others enabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 782097 |  | 0 |  

### CBRK_FLIGHTTERM (`INT32`) {#CBRK_FLIGHTTERM}

Circuit breaker for flight termination.

Setting this parameter to 121212 will disable the flight termination action if triggered by the FailureDetector logic or if FMU is lost. This circuit breaker does not affect the RC loss, data link loss, geofence, and takeoff failure detection safety logic.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 121212 |  | 121212 |  

### CBRK_IO_SAFETY (`INT32`) {#CBRK_IO_SAFETY}

Circuit breaker for IO safety.

Setting this parameter to 22027 will disable IO safety. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 22027 |  | 22027 |  

### CBRK_SUPPLY_CHK (`INT32`) {#CBRK_SUPPLY_CHK}

Circuit breaker for power supply check.

Setting this parameter to 894281 will disable the power valid checks in the commander. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 894281 |  | 0 |  

### CBRK_USB_CHK (`INT32`) {#CBRK_USB_CHK}

Circuit breaker for USB link check.

Setting this parameter to 197848 will disable the USB connected checks in the commander, setting it to 0 keeps them enabled (recommended). We are generally recommending to not fly with the USB link connected and production vehicles should set this parameter to zero to prevent users from flying USB powered. However, for R&D purposes it has proven over the years to work just fine.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 197848 |  | 197848 |  

### CBRK_VTOLARMING (`INT32`) {#CBRK_VTOLARMING}

Circuit breaker for arming in fixed-wing mode check.

Setting this parameter to 159753 will enable arming in fixed-wing mode for VTOLs. WARNING: ENABLING THIS CIRCUIT BREAKER IS AT OWN RISK

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 159753 |  | 0 |  

## Commander

### COM_ACT_FAIL_ACT (`INT32`) {#COM_ACT_FAIL_ACT}

Set the actuator failure failsafe mode.

Note: actuator failure needs to be enabled and configured via FD_ACT_* parameters.

**Values:**

- `0`: Warning only
- `1`: Hold mode
- `2`: Land mode
- `3`: Return mode
- `4`: Terminate


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### COM_ARMABLE (`INT32`) {#COM_ARMABLE}

Flag to allow arming.

Set 0 to prevent accidental use of the vehicle e.g. for safety or maintenance reasons.

**Values:**

- `0`: Disallow arming
- `1`: Allow arming


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### COM_ARM_AUTH_ID (`INT32`) {#COM_ARM_AUTH_ID}

Arm authorizer system id.

Used if arm authorization is requested by COM_ARM_AUTH_REQ.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 10 |  

### COM_ARM_AUTH_MET (`INT32`) {#COM_ARM_AUTH_MET}

Arm authorization method.

Methods: - one arm: request authorization and arm when authorization is received - two step arm: 1st arm command request an authorization and 2nd arm command arm the drone if authorized Used if arm authorization is requested by COM_ARM_AUTH_REQ.

**Values:**

- `0`: one arm
- `1`: two step arm


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_ARM_AUTH_REQ (`INT32`) {#COM_ARM_AUTH_REQ}

Require arm authorization to arm.

By default off. The default allows to arm the vehicle without a arm authorization.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_ARM_AUTH_TO (`FLOAT`) {#COM_ARM_AUTH_TO}

Arm authorization timeout.

Timeout for authorizer answer. Used if arm authorization is requested by COM_ARM_AUTH_REQ.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.1 | 1 | s 

### COM_ARM_BAT_MIN (`FLOAT`) {#COM_ARM_BAT_MIN}

Minimum battery level for arming.

Threshold for battery percentage below arming is prohibited. A negative value means BAT_CRIT_THR is the threshold.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 0.9 | 0.01 | -1. | norm 

### COM_ARM_CHK_ESCS (`INT32`) {#COM_ARM_CHK_ESCS}

Enable checks on ESCs that report telemetry.

If this parameter is set, the system will check ESC's online status and failures. This param is specific for ESCs reporting status. It shall be used only if ESCs support telemetry.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_ARM_HFLT_CHK (`INT32`) {#COM_ARM_HFLT_CHK}

Enable FMU SD card hardfault detection check.

This check detects if there are hardfault files present on the SD card. If so, and the parameter is enabled, arming is prevented.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### COM_ARM_IMU_ACC (`FLOAT`) {#COM_ARM_IMU_ACC}

Maximum accelerometer inconsistency between IMU units that will allow arming.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 | 0.05 | 0.7 | m/s^2 

### COM_ARM_IMU_GYR (`FLOAT`) {#COM_ARM_IMU_GYR}

Maximum rate gyro inconsistency between IMU units that will allow arming.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.02 | 0.3 | 0.01 | 0.25 | rad/s 

### COM_ARM_MAG_ANG (`INT32`) {#COM_ARM_MAG_ANG}

Maximum magnetic field inconsistency between units that will allow arming.

Set -1 to disable the check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 3 | 180 |  | 60 | deg 

### COM_ARM_MAG_STR (`INT32`) {#COM_ARM_MAG_STR}

Enable mag strength preflight check.

Check if the estimator detects a strong magnetic disturbance (check enabled by EKF2_MAG_CHECK)

**Values:**

- `0`: Disabled
- `1`: Deny arming
- `2`: Warning only


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### COM_ARM_MIS_REQ (`INT32`) {#COM_ARM_MIS_REQ}

Require valid mission to arm.

The default allows to arm the vehicle without a valid mission.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_ARM_ODID (`INT32`) {#COM_ARM_ODID}

Enable Drone ID system detection and health check.

This check detects if the Open Drone ID system is missing. Depending on the value of the parameter, the check can be disabled, warn only or deny arming.

**Values:**

- `0`: Disabled
- `1`: Warning only
- `2`: Enforce Open Drone ID system presence


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_ARM_SDCARD (`INT32`) {#COM_ARM_SDCARD}

Enable FMU SD card detection check.

This check detects if the FMU SD card is missing. Depending on the value of the parameter, the check can be disabled, warn only or deny arming.

**Values:**

- `0`: Disabled
- `1`: Warning only
- `2`: Enforce SD card presence


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### COM_ARM_SWISBTN (`INT32`) {#COM_ARM_SWISBTN}

Arm switch is a momentary button.

0: Arming/disarming triggers on switch transition. 1: Arming/disarming triggers when holding the momentary button down for COM_RC_ARM_HYST like the stick gesture.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_ARM_WO_GPS (`INT32`) {#COM_ARM_WO_GPS}

GPS preflight check.

Measures taken when a check defined by EKF2_GPS_CHECK is failing.

**Values:**

- `0`: Deny arming
- `1`: Warning only
- `2`: Disabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### COM_CPU_MAX (`FLOAT`) {#COM_CPU_MAX}

Maximum allowed CPU load to still arm.

The check fails if the CPU load is above this threshold for 2s. A negative value disables the check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 1 | 95.0 | % 

### COM_DISARM_LAND (`FLOAT`) {#COM_DISARM_LAND}

Time-out for auto disarm after landing.

A non-zero, positive value specifies the time-out period in seconds after which the vehicle will be automatically disarmed in case a landing situation has been detected during this period. A zero or negative value means that automatic disarming triggered by landing detection is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.1 | 2.0 | s 

### COM_DISARM_MAN (`INT32`) {#COM_DISARM_MAN}

Allow disarming via switch/stick/button on multicopters in manual thrust modes.

0: Disallow disarming when not landed 1: Allow disarming in multicopter flight in modes where the thrust is directly controlled by thr throttle stick e.g. Stabilized, Acro

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### COM_DISARM_PRFLT (`FLOAT`) {#COM_DISARM_PRFLT}

Time-out for auto disarm if not taking off.

A non-zero, positive value specifies the time in seconds, within which the vehicle is expected to take off after arming. In case the vehicle didn't takeoff within the timeout it disarms again. A negative value disables autmoatic disarming triggered by a pre-takeoff timeout.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.1 | 10.0 | s 

### COM_DL_LOSS_T (`INT32`) {#COM_DL_LOSS_T}

GCS connection loss time threshold.

After this amount of seconds without datalink, the GCS connection lost mode triggers

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 300 | 1 | 10 | s 

### COM_FAIL_ACT_T (`FLOAT`) {#COM_FAIL_ACT_T}

Delay between failsafe condition triggered and failsafe reaction.

Before entering failsafe (RTL, Land, Hold), wait COM_FAIL_ACT_T seconds in Hold mode for the user to realize. During that time the user cannot take over control via the stick override feature (see COM_RC_OVERRIDE). Afterwards the configured failsafe action is triggered and the user may use stick override. A zero value disables the delay and the user cannot take over via stick movements (switching modes is still allowed).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 25.0 |  | 5. | s 

### COM_FLIGHT_UUID (`INT32`) {#COM_FLIGHT_UUID}

Next flight UUID.

This number is incremented automatically after every flight on disarming in order to remember the next flight UUID. The first flight is 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 0 |  

### COM_FLTMODE1 (`INT32`) {#COM_FLTMODE1}

Mode slot 1.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTMODE2 (`INT32`) {#COM_FLTMODE2}

Mode slot 2.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTMODE3 (`INT32`) {#COM_FLTMODE3}

Mode slot 3.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTMODE4 (`INT32`) {#COM_FLTMODE4}

Mode slot 4.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTMODE5 (`INT32`) {#COM_FLTMODE5}

Mode slot 5.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTMODE6 (`INT32`) {#COM_FLTMODE6}

Mode slot 6.

If the main switch channel is in this range the selected flight mode will be applied.

**Values:**

- `-1`: Unassigned
- `0`: Manual
- `1`: Altitude
- `2`: Position
- `3`: Mission
- `4`: Hold
- `5`: Return
- `6`: Acro
- `7`: Offboard
- `8`: Stabilized
- `9`: Position Slow
- `10`: Takeoff
- `11`: Land
- `12`: Follow Me
- `13`: Precision Land
- `100`: External Mode 1
- `101`: External Mode 2
- `102`: External Mode 3
- `103`: External Mode 4
- `104`: External Mode 5
- `105`: External Mode 6
- `106`: External Mode 7
- `107`: External Mode 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### COM_FLTT_LOW_ACT (`INT32`) {#COM_FLTT_LOW_ACT}

Remaining flight time low failsafe.

Action the system takes when the remaining flight time is below the estimated time it takes to reach the RTL destination.

**Values:**

- `0`: None
- `1`: Warning
- `3`: Return


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 1 | 3 |  

### COM_FLT_PROFILE (`INT32`) {#COM_FLT_PROFILE}

User Flight Profile.

Describes the intended use of the vehicle. Can be used by ground control software or log post processing. This param does not influence the behavior within the firmware. This means for example the control logic is independent of the setting of this param (but depends on other params).

**Values:**

- `0`: Default
- `100`: Pro User
- `200`: Flight Tester
- `300`: Developer


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_FLT_TIME_MAX (`INT32`) {#COM_FLT_TIME_MAX}

Maximum allowed flight time.

The vehicle aborts the current operation and returns to launch when the time since takeoff is above this value. It is not possible to resume the mission or switch to any auto mode other than RTL or Land. Taking over in any manual mode is still possible. Starting from 90% of the maximum flight time, a warning message will be sent every 1 minute with the remaining time until automatic RTL. Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  |  | -1 | s 

### COM_FORCE_SAFETY (`INT32`) {#COM_FORCE_SAFETY}

Enable force safety.

Force safety when the vehicle disarms

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_HLDL_LOSS_T (`INT32`) {#COM_HLDL_LOSS_T}

High Latency Datalink loss time threshold.

After this amount of seconds without datalink the data link lost mode triggers

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 60 | 3600 |  | 120 | s 

### COM_HLDL_REG_T (`INT32`) {#COM_HLDL_REG_T}

High Latency Datalink regain time threshold.

After a data link loss: after this number of seconds with a healthy datalink the 'datalink loss' flag is set back to false

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 60 |  | 0 | s 

### COM_HOME_EN (`INT32`) {#COM_HOME_EN}

Home position enabled.

Set home position automatically if possible.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### COM_HOME_IN_AIR (`INT32`) {#COM_HOME_IN_AIR}

Allows setting the home position after takeoff.

If set to true, the autopilot is allowed to set its home position after takeoff The true home position is back-computed if a local position is estimate if available. If no local position is available, home is set to the current position.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_IMB_PROP_ACT (`INT32`) {#COM_IMB_PROP_ACT}

Imbalanced propeller failsafe mode.

Action the system takes when an imbalanced propeller is detected by the failure detector. See also FD_IMB_PROP_THR to set the failure threshold.

**Values:**

- `-1`: Disabled
- `0`: Warning
- `1`: Return
- `2`: Land


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 1 | 0 |  

### COM_KILL_DISARM (`FLOAT`) {#COM_KILL_DISARM}

Timeout value for disarming when kill switch is engaged.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 30.0 | 0.1 | 5.0 | s 

### COM_LKDOWN_TKO (`FLOAT`) {#COM_LKDOWN_TKO}

Timeout for detecting a failure after takeoff.

A non-zero, positive value specifies the timeframe in seconds within failure detector is allowed to disarm the vehicle if attitude exceeds the limits defined in FD_FAIL_P and FD_FAIL_R. The check is not executed for flight modes that do support acrobatic maneuvers, e.g: Acro (MC/FW) and Manual (FW). A zero or negative value means that the check is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 5.0 |  | 3.0 | s 

### COM_LOW_BAT_ACT (`INT32`) {#COM_LOW_BAT_ACT}

Battery failsafe mode.

Action the system takes at critical battery. See also BAT_CRIT_THR and BAT_EMERGEN_THR for definition of battery states.

**Values:**

- `0`: Warning
- `2`: Land mode
- `3`: Return at critical level, land at emergency level


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE0_HASH (`INT32`) {#COM_MODE0_HASH}

External mode identifier 0.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE1_HASH (`INT32`) {#COM_MODE1_HASH}

External mode identifier 1.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE2_HASH (`INT32`) {#COM_MODE2_HASH}

External mode identifier 2.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE3_HASH (`INT32`) {#COM_MODE3_HASH}

External mode identifier 3.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE4_HASH (`INT32`) {#COM_MODE4_HASH}

External mode identifier 4.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE5_HASH (`INT32`) {#COM_MODE5_HASH}

External mode identifier 5.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE6_HASH (`INT32`) {#COM_MODE6_HASH}

External mode identifier 6.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE7_HASH (`INT32`) {#COM_MODE7_HASH}

External mode identifier 7.

This parameter is automatically set to identify external modes. It ensures that modes get assigned to the same index independent from their startup order, which is required when mapping an external mode to an RC switch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_MODE_ARM_CHK (`INT32`) {#COM_MODE_ARM_CHK}

Allow external mode registration while armed.

By default disabled for safety reasons

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_MOT_TEST_EN (`INT32`) {#COM_MOT_TEST_EN}

Enable Actuator Testing.

If set, enables the actuator test interface via MAVLink (ACTUATOR_TEST), that allows spinning the motors and moving the servos for testing purposes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### COM_OBC_LOSS_T (`FLOAT`) {#COM_OBC_LOSS_T}

Time-out to wait when onboard computer connection is lost before warning about loss connection.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 60 | 0.01 | 5.0 | s 

### COM_OBL_RC_ACT (`INT32`) {#COM_OBL_RC_ACT}

Set offboard loss failsafe mode.

The offboard loss failsafe will only be entered after a timeout, set by COM_OF_LOSS_T in seconds.

**Values:**

- `0`: Position mode
- `1`: Altitude mode
- `2`: Stabilized
- `3`: Return mode
- `4`: Land mode
- `5`: Hold mode
- `6`: Terminate
- `7`: Disarm


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_OF_LOSS_T (`FLOAT`) {#COM_OF_LOSS_T}

Time-out to wait when offboard connection is lost before triggering offboard lost action.

See COM_OBL_RC_ACT to configure action.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 60 | 0.01 | 1.0 | s 

### COM_PARACHUTE (`INT32`) {#COM_PARACHUTE}

Expect and require a healthy MAVLink parachute system.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_POSCTL_NAVL (`INT32`) {#COM_POSCTL_NAVL}

Position mode navigation loss response.

This sets the flight mode that will be used if navigation accuracy is no longer adequate for position control in manual Position mode.

**Values:**

- `0`: Altitude mode
- `1`: Land mode (descend)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_POS_FS_EPH (`FLOAT`) {#COM_POS_FS_EPH}

Horizontal position error threshold.

This is the horizontal position error (EPH) threshold that will trigger a failsafe. The default is appropriate for a multicopter. Can be increased for a fixed-wing. If the previous position error was below this threshold, there is an additional factor of 2.5 applied (threshold for invalidation 2.5 times the one for validation). Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 400 |  | 5. | m 

### COM_POS_LOW_ACT (`INT32`) {#COM_POS_LOW_ACT}

Low position accuracy action.

Action the system takes when the estimated position has an accuracy below the specified threshold. See COM_POS_LOW_EPH to set the failsafe threshold. The failsafe action is only executed if the vehicle is in auto mission or auto loiter mode, otherwise it is only a warning.

**Values:**

- `0`: None
- `1`: Warning
- `2`: Hold
- `3`: Return
- `4`: Terminate
- `5`: Land


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 1 | 3 |  

### COM_POS_LOW_EPH (`FLOAT`) {#COM_POS_LOW_EPH}

Low position accuracy failsafe threshold.

This triggers the action specified in COM_POS_LOW_ACT if the estimated position accuracy is below this threshold. Local position has to be still declared valid, which requires some kind of velocity aiding or large dead-reckoning time (EKF2_NOAID_TOUT), and a high failsafe threshold (COM_POS_FS_EPH). Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 |  | -1.0 | m 

### COM_POWER_COUNT (`INT32`) {#COM_POWER_COUNT}

Required number of redundant power modules.

This configures a check to verify the expected number of 5V rail power supplies are present. By default only one is expected. Note: CBRK_SUPPLY_CHK disables all power checks including this one.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4 |  | 1 |  

### COM_PREARM_MODE (`INT32`) {#COM_PREARM_MODE}

Condition to enter prearmed mode.

Condition to enter the prearmed state, an intermediate state between disarmed and armed in which non-throttling actuators are active.

**Values:**

- `0`: Disabled
- `1`: Safety button
- `2`: Always


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_QC_ACT (`INT32`) {#COM_QC_ACT}

Set action after a quadchute.

**Values:**

- `-1`: Warning only
- `0`: Return mode
- `1`: Land mode
- `2`: Hold mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_RAM_MAX (`FLOAT`) {#COM_RAM_MAX}

Maximum allowed RAM usage to pass checks.

The check fails if the RAM usage is above this threshold. A negative value disables the check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 1 | 95.0 | % 

### COM_RCL_EXCEPT (`INT32`) {#COM_RCL_EXCEPT}

RC loss exceptions.

Specify modes in which RC loss is ignored and the failsafe action not triggered.

**Bitmask:**

- `0`: Mission
- `1`: Hold
- `2`: Offboard


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 31 |  | 0 |  

### COM_RC_ARM_HYST (`INT32`) {#COM_RC_ARM_HYST}

RC input arm/disarm command duration.

The default value of 1000 requires the stick to be held in the arm or disarm position for 1 second.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 100 | 1500 |  | 1000 | ms 

### COM_RC_IN_MODE (`INT32`) {#COM_RC_IN_MODE}

RC control input mode.

A value of 0 enables RC transmitter control (only). A valid RC transmitter calibration is required. A value of 1 allows joystick control only. RC input handling and the associated checks are disabled. A value of 2 allows either RC Transmitter or Joystick input. The first valid input is used, will fallback to other sources if the input stream becomes invalid. A value of 3 allows either input from RC or joystick. The first available source is selected and used until reboot. A value of 4 ignores any stick input.

**Values:**

- `0`: RC Transmitter only
- `1`: Joystick only
- `2`: RC and Joystick with fallback
- `3`: RC or Joystick keep first
- `4`: Stick input disabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4 |  | 3 |  

### COM_RC_LOSS_T (`FLOAT`) {#COM_RC_LOSS_T}

Manual control loss timeout.

The time in seconds without a new setpoint from RC or Joystick, after which the connection is considered lost. This must be kept short as the vehicle will use the last supplied setpoint until the timeout triggers.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 35 | 0.1 | 0.5 | s 

### COM_RC_OVERRIDE (`INT32`) {#COM_RC_OVERRIDE}

Enable RC stick override of auto and/or offboard modes.

When RC stick override is enabled, moving the RC sticks more than COM_RC_STICK_OV immediately gives control back to the pilot by switching to Position mode and if position is unavailable Altitude mode. Note: Only has an effect on multicopters, and VTOLs in multicopter mode.

**Bitmask:**

- `0`: Enable override during auto modes (except for in critical battery reaction)
- `1`: Enable override during offboard mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 1 |  

### COM_RC_STICK_OV (`FLOAT`) {#COM_RC_STICK_OV}

RC stick override threshold.

If COM_RC_OVERRIDE is enabled and the joystick input is moved more than this threshold the autopilot the pilot takes over control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 80 | 0.05 | 30.0 | % 

### COM_SPOOLUP_TIME (`FLOAT`) {#COM_SPOOLUP_TIME}

Enforced delay between arming and further navigation.

The minimal time from arming the motors until moving the vehicle is possible is COM_SPOOLUP_TIME seconds. Goal: - Motors and propellers spool up to idle speed before getting commanded to spin faster - Timeout for ESCs and smart batteries to successfulyy do failure checks e.g. for stuck rotors before the vehicle is off the ground

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 30 | 0.1 | 1.0 | s 

### COM_TAKEOFF_ACT (`INT32`) {#COM_TAKEOFF_ACT}

Action after TAKEOFF has been accepted.

The mode transition after TAKEOFF has completed successfully.

**Values:**

- `0`: Hold
- `1`: Mission (if valid)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### COM_THROW_EN (`INT32`) {#COM_THROW_EN}

Enable throw-start.

Allows to start the vehicle by throwing it into the air.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### COM_THROW_SPEED (`FLOAT`) {#COM_THROW_SPEED}

Minimum speed for the throw start.

When the throw launch is enabled, the drone will only allow motors to spin after this speed is exceeded before detecting the freefall. This is a safety feature to ensure the drone does not turn on after accidental drop or a rapid movement before the throw. Set to 0 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.1 | 5 | m/s 

### COM_VEL_FS_EVH (`FLOAT`) {#COM_VEL_FS_EVH}

Horizontal velocity error threshold.

This is the horizontal velocity error (EVH) threshold that will trigger a failsafe. The default is appropriate for a multicopter. Can be increased for a fixed-wing. If the previous velocity error was below this threshold, there is an additional factor of 2.5 applied (threshold for invalidation 2.5 times the one for validation).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 1. | m/s 

### COM_WIND_MAX (`FLOAT`) {#COM_WIND_MAX}

High wind speed failsafe threshold.

Wind speed threshold above which an automatic failsafe action is triggered. Failsafe action can be specified with COM_WIND_MAX_ACT.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 0.1 | -1. | m/s 

### COM_WIND_MAX_ACT (`INT32`) {#COM_WIND_MAX_ACT}

High wind failsafe mode.

Action the system takes when a wind speed above the specified threshold is detected. See COM_WIND_MAX to set the failsafe threshold. If enabled, it is not possible to resume the mission or switch to any auto mode other than RTL or Land if this threshold is exceeded. Taking over in any manual mode is still possible.

**Values:**

- `0`: None
- `1`: Warning
- `2`: Hold
- `3`: Return
- `4`: Terminate
- `5`: Land


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 1 | 0 |  

### COM_WIND_WARN (`FLOAT`) {#COM_WIND_WARN}

Wind speed warning threshold.

A warning is triggered if the currently estimated wind speed is above this value. Warning is sent periodically (every 1 minute). Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 0.1 | -1. | m/s 

### NAV_DLL_ACT (`INT32`) {#NAV_DLL_ACT}

Set GCS connection loss failsafe mode.

The GCS connection loss failsafe will only be entered after a timeout, set by COM_DL_LOSS_T in seconds. Once the timeout occurs the selected action will be executed.

**Values:**

- `0`: Disabled
- `1`: Hold mode
- `2`: Return mode
- `3`: Land mode
- `5`: Terminate
- `6`: Disarm


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 6 |  | 0 |  

### NAV_RCL_ACT (`INT32`) {#NAV_RCL_ACT}

Set RC loss failsafe mode.

The RC loss failsafe will only be entered after a timeout, set by COM_RC_LOSS_T in seconds. If RC input checks have been disabled by setting the COM_RC_IN_MODE param it will not be triggered.

**Values:**

- `1`: Hold mode
- `2`: Return mode
- `3`: Land mode
- `5`: Terminate
- `6`: Disarm


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 6 |  | 2 |  

## Cyphal

### CYPHAL_BAUD (`INT32`) {#CYPHAL_BAUD}

UAVCAN/CAN v1 bus bitrate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 20000 | 1000000 |  | 1000000 | bit/s 

### CYPHAL_ENABLE (`INT32`) {#CYPHAL_ENABLE}

Cyphal.

0 - Cyphal disabled. 1 - Enables Cyphal

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### CYPHAL_ID (`INT32`) {#CYPHAL_ID}

Cyphal Node ID.

Read the specs at http://uavcan.org to learn more about Node ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1 | 125 |  | 1 |  

### UCAN1_ACTR_PUB (`INT32`) {#UCAN1_ACTR_PUB}

actuator_outputs uORB over Cyphal publication port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_BMS_BP_SUB (`INT32`) {#UCAN1_BMS_BP_SUB}

UDRAL battery parameters subscription  port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_BMS_BS_SUB (`INT32`) {#UCAN1_BMS_BS_SUB}

UDRAL battery status subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_BMS_ES_SUB (`INT32`) {#UCAN1_BMS_ES_SUB}

UDRAL battery energy source subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_ESC0_SUB (`INT32`) {#UCAN1_ESC0_SUB}

ESC 0 subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_ESC_PUB (`INT32`) {#UCAN1_ESC_PUB}

Cyphal ESC publication port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB0_SUB (`INT32`) {#UCAN1_FB0_SUB}

Cyphal ESC 0 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB1_SUB (`INT32`) {#UCAN1_FB1_SUB}

Cyphal ESC 1 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB2_SUB (`INT32`) {#UCAN1_FB2_SUB}

Cyphal ESC 2 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB3_SUB (`INT32`) {#UCAN1_FB3_SUB}

Cyphal ESC 3 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB4_SUB (`INT32`) {#UCAN1_FB4_SUB}

Cyphal ESC 4 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB5_SUB (`INT32`) {#UCAN1_FB5_SUB}

Cyphal ESC 5 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB6_SUB (`INT32`) {#UCAN1_FB6_SUB}

Cyphal ESC 6 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_FB7_SUB (`INT32`) {#UCAN1_FB7_SUB}

Cyphal ESC 7 zubax feedback port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_GPS0_SUB (`INT32`) {#UCAN1_GPS0_SUB}

GPS 0 subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_GPS1_SUB (`INT32`) {#UCAN1_GPS1_SUB}

GPS 1 subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_GPS_PUB (`INT32`) {#UCAN1_GPS_PUB}

Cyphal GPS publication port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_LG_BMS_SUB (`INT32`) {#UCAN1_LG_BMS_SUB}

Cyphal legacy battery port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_READ_PUB (`INT32`) {#UCAN1_READ_PUB}

Cyphal ESC readiness port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_SERVO_PUB (`INT32`) {#UCAN1_SERVO_PUB}

Cyphal Servo publication port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_UORB_GPS (`INT32`) {#UCAN1_UORB_GPS}

sensor_gps uORB over Cyphal subscription port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

### UCAN1_UORB_GPS_P (`INT32`) {#UCAN1_UORB_GPS_P}

sensor_gps uORB over Cyphal publication port ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 6143 |  | -1 |  

## DShot

### DSHOT_3D_DEAD_H (`INT32`) {#DSHOT_3D_DEAD_H}

DSHOT 3D deadband high.

When the actuator_output is between DSHOT_3D_DEAD_L and DSHOT_3D_DEAD_H, motor will not spin. This value is with respect to the mixer_module range (0-1999), not the DSHOT values.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1000 | 1999 |  | 1000 |  

### DSHOT_3D_DEAD_L (`INT32`) {#DSHOT_3D_DEAD_L}

DSHOT 3D deadband low.

When the actuator_output is between DSHOT_3D_DEAD_L and DSHOT_3D_DEAD_H, motor will not spin. This value is with respect to the mixer_module range (0-1999), not the DSHOT values.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 |  | 1000 |  

### DSHOT_3D_ENABLE (`INT32`) {#DSHOT_3D_ENABLE}

Allows for 3d mode when using DShot and suitable mixer.

WARNING: ESC must be configured for 3D mode, and DSHOT_MIN set to 0. This splits the throttle ranges in two. Direction 1) 48 is the slowest, 1047 is the fastest. Direction 2) 1049 is the slowest, 2047 is the fastest. When mixer outputs 1000 or value inside DSHOT 3D deadband, DShot 0 is sent.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### DSHOT_BIDIR_EN (`INT32`) {#DSHOT_BIDIR_EN}

Enable bidirectional DShot.

This parameter enables bidirectional DShot which provides RPM feedback. Note that this requires ESCs that support bidirectional DSHot, e.g. BlHeli32. This is not the same as DShot telemetry which requires an additional serial connection.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### DSHOT_MIN (`FLOAT`) {#DSHOT_MIN}

Minimum DShot Motor Output.

Minimum Output Value for DShot in percent. The value depends on the ESC. Make sure to set this high enough so that the motors are always spinning while armed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.055 | % 

### DSHOT_TEL_CFG (`INT32`) {#DSHOT_TEL_CFG}

Serial Configuration for DShot Driver.

Configure on which serial port to run DShot Driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MOT_POLE_COUNT (`INT32`) {#MOT_POLE_COUNT}

Number of magnetic poles of the motors.

Specify the number of magnetic poles of the motors. It is required to compute the RPM value from the eRPM returned with the ESC telemetry. Either get the number from the motor spec sheet or count the magnets on the bell of the motor (not the stator magnets). Typical motors for 5 inch props have 14 poles.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 14 |  

## EKF2

### EKF2_ABIAS_INIT (`FLOAT`) {#EKF2_ABIAS_INIT}

1-sigma IMU accelerometer switch-on bias.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 0.5 |  | 0.2 | m/s^2 

### EKF2_ABL_ACCLIM (`FLOAT`) {#EKF2_ABL_ACCLIM}

Maximum IMU accel magnitude that allows IMU bias learning.

If the magnitude of the IMU accelerometer vector exceeds this value, the EKF accel bias state estimation will be inhibited. This reduces the adverse effect of high manoeuvre accelerations and IMU nonlinerity and scale factor errors on the accel bias estimates.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 20.0 | 200.0 |  | 25.0 | m/s^2 

### EKF2_ABL_GYRLIM (`FLOAT`) {#EKF2_ABL_GYRLIM}

Maximum IMU gyro angular rate magnitude that allows IMU bias learning.

If the magnitude of the IMU angular rate vector exceeds this value, the EKF accel bias state estimation will be inhibited. This reduces the adverse effect of rapid rotation rates and associated errors on the accel bias estimates.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2.0 | 20.0 |  | 3.0 | rad/s 

### EKF2_ABL_LIM (`FLOAT`) {#EKF2_ABL_LIM}

Accelerometer bias learning limit.

The ekf accel bias states will be limited to within a range equivalent to +- of this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.8 |  | 0.4 | m/s^2 

### EKF2_ABL_TAU (`FLOAT`) {#EKF2_ABL_TAU}

Accel bias learning inhibit time constant.

The vector magnitude of angular rate and acceleration used to check if learning should be inhibited has a peak hold filter applied to it with an exponential decay. This parameter controls the time constant of the decay.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 |  | 0.5 | s 

### EKF2_ACC_B_NOISE (`FLOAT`) {#EKF2_ACC_B_NOISE}

Process noise for IMU accelerometer bias prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.01 |  | 0.003 | m/s^3 

### EKF2_ACC_NOISE (`FLOAT`) {#EKF2_ACC_NOISE}

Accelerometer noise for covariance prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1.0 |  | 0.35 | m/s^2 

### EKF2_AGP_CTRL (`INT32`) {#EKF2_AGP_CTRL}

Aux global position (AGP) sensor aiding.

Set bits in the following positions to enable: 0 : Horizontal position fusion 1 : Vertical position fusion

**Bitmask:**

- `0`: Horizontal position
- `1`: Vertical position


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### EKF2_AGP_DELAY (`FLOAT`) {#EKF2_AGP_DELAY}

Aux global position estimator delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 0 | ms 

### EKF2_AGP_GATE (`FLOAT`) {#EKF2_AGP_GATE}

Gate size for aux global position fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 3.0 | SD 

### EKF2_AGP_NOISE (`FLOAT`) {#EKF2_AGP_NOISE}

Measurement noise for aux global position measurements.

Used to lower bound or replace the uncertainty included in the message

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 0.9 | m 

### EKF2_ANGERR_INIT (`FLOAT`) {#EKF2_ANGERR_INIT}

1-sigma tilt angle uncertainty after gravity vector alignment.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 0.5 |  | 0.1 | rad 

### EKF2_ARSP_THR (`FLOAT`) {#EKF2_ARSP_THR}

Airspeed fusion threshold.

Airspeed data is fused for wind estimation if above this threshold. Set to 0 to disable airspeed fusion. For reliable wind estimation both sideslip (see EKF2_FUSE_BETA) and airspeed fusion should be enabled. Only applies to fixed-wing vehicles (or VTOLs in fixed-wing mode).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  |  | 0.0 | m/s 

### EKF2_ASPD_MAX (`FLOAT`) {#EKF2_ASPD_MAX}

Maximum airspeed used for baro static pressure compensation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5.0 | 50.0 |  | 20.0 | m/s 

### EKF2_ASP_DELAY (`FLOAT`) {#EKF2_ASP_DELAY}

Airspeed measurement delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 100 | ms 

### EKF2_AVEL_DELAY (`FLOAT`) {#EKF2_AVEL_DELAY}

Auxiliary Velocity Estimate delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 5 | ms 

### EKF2_BARO_CTRL (`INT32`) {#EKF2_BARO_CTRL}

Barometric sensor height aiding.

If this parameter is enabled then the estimator will make use of the barometric height measurements to estimate its height in addition to other height sources (if activated).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### EKF2_BARO_DELAY (`FLOAT`) {#EKF2_BARO_DELAY}

Barometer measurement delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 0 | ms 

### EKF2_BARO_GATE (`FLOAT`) {#EKF2_BARO_GATE}

Gate size for barometric and GPS height fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_BARO_NOISE (`FLOAT`) {#EKF2_BARO_NOISE}

Measurement noise for barometric altitude.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 15.0 |  | 3.5 | m 

### EKF2_BCOEF_X (`FLOAT`) {#EKF2_BCOEF_X}

X-axis ballistic coefficient used for multi-rotor wind estimation.

This parameter controls the prediction of drag produced by bluff body drag along the forward/reverse axis when flying a multi-copter which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed squared. The predicted drag from the rotors is specified separately by the EKF2_MCOEF parameter. Set this parameter to zero to turn off the bluff body drag model for this axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 200.0 |  | 100.0 | kg/m^2 

### EKF2_BCOEF_Y (`FLOAT`) {#EKF2_BCOEF_Y}

Y-axis ballistic coefficient used for multi-rotor wind estimation.

This parameter controls the prediction of drag produced by bluff body drag along the right/left axis when flying a multi-copter, which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed squared. The predicted drag from the rotors is specified separately by the EKF2_MCOEF parameter. Set this parameter to zero to turn off the bluff body drag model for this axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 200.0 |  | 100.0 | kg/m^2 

### EKF2_BETA_GATE (`FLOAT`) {#EKF2_BETA_GATE}

Gate size for synthetic sideslip fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_BETA_NOISE (`FLOAT`) {#EKF2_BETA_NOISE}

Noise for synthetic sideslip fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 |  | 0.3 | m/s 

### EKF2_DECL_TYPE (`INT32`) {#EKF2_DECL_TYPE}

Integer bitmask controlling handling of magnetic declination.

Set bits in the following positions to enable functions. 0 : Set to true to use the declination from the geo_lookup library when the GPS position becomes available, set to false to always use the EKF2_MAG_DECL value. 1 : Set to true to save the EKF2_MAG_DECL parameter to the value returned by the EKF when the vehicle disarms.

**Bitmask:**

- `0`: use geo_lookup declination
- `1`: save EKF2_MAG_DECL on disarm


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 3 |  

### EKF2_DELAY_MAX (`FLOAT`) {#EKF2_DELAY_MAX}

Maximum delay of all the aiding sensors.

Defines the delay between the current time and the delayed-time horizon. This value should be at least as large as the largest EKF2_XXX_DELAY parameter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 200 | ms 

### EKF2_DRAG_CTRL (`INT32`) {#EKF2_DRAG_CTRL}

Multirotor wind estimation selection.

Activate wind speed estimation using specific-force measurements and a drag model defined by EKF2_BCOEF_[XY] and EKF2_MCOEF. Only use on vehicles that have their thrust aligned with the Z axis and no thrust in the XY plane.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### EKF2_DRAG_NOISE (`FLOAT`) {#EKF2_DRAG_NOISE}

Specific drag force observation noise variance.

Used by the multi-rotor specific drag force model. Increasing this makes the multi-rotor wind estimates adjust more slowly.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 10.0 |  | 2.5 | (m/s^2)^2 

### EKF2_EAS_NOISE (`FLOAT`) {#EKF2_EAS_NOISE}

Measurement noise for airspeed fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 5.0 |  | 1.4 | m/s 

### EKF2_EN (`INT32`) {#EKF2_EN}

EKF2 enable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### EKF2_EVA_NOISE (`FLOAT`) {#EKF2_EVA_NOISE}

Measurement noise for vision angle measurements.

Used to lower bound or replace the uncertainty included in the message

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 |  |  | 0.1 | rad 

### EKF2_EVP_GATE (`FLOAT`) {#EKF2_EVP_GATE}

Gate size for vision position fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_EVP_NOISE (`FLOAT`) {#EKF2_EVP_NOISE}

Measurement noise for vision position measurements.

Used to lower bound or replace the uncertainty included in the message

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 0.1 | m 

### EKF2_EVV_GATE (`FLOAT`) {#EKF2_EVV_GATE}

Gate size for vision velocity estimate fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 3.0 | SD 

### EKF2_EVV_NOISE (`FLOAT`) {#EKF2_EVV_NOISE}

Measurement noise for vision velocity measurements.

Used to lower bound or replace the uncertainty included in the message

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 0.1 | m/s 

### EKF2_EV_CTRL (`INT32`) {#EKF2_EV_CTRL}

External vision (EV) sensor aiding.

Set bits in the following positions to enable: 0 : Horizontal position fusion 1 : Vertical position fusion 2 : 3D velocity fusion 3 : Yaw

**Bitmask:**

- `0`: Horizontal position
- `1`: Vertical position
- `2`: 3D velocity
- `3`: Yaw


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 15 |  | 0 |  

### EKF2_EV_DELAY (`FLOAT`) {#EKF2_EV_DELAY}

Vision Position Estimator delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 0 | ms 

### EKF2_EV_NOISE_MD (`INT32`) {#EKF2_EV_NOISE_MD}

External vision (EV) noise mode.

If set to 0 (default) the measurement noise is taken from the vision message and the EV noise parameters are used as a lower bound. If set to 1 the observation noise is set from the parameters directly,

**Values:**

- `0`: EV reported variance (parameter lower bound)
- `1`: EV noise parameters


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### EKF2_EV_POS_X (`FLOAT`) {#EKF2_EV_POS_X}

X position of VI sensor focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_EV_POS_Y (`FLOAT`) {#EKF2_EV_POS_Y}

Y position of VI sensor focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_EV_POS_Z (`FLOAT`) {#EKF2_EV_POS_Z}

Z position of VI sensor focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_EV_QMIN (`INT32`) {#EKF2_EV_QMIN}

External vision (EV) minimum quality (optional).

External vision will only be started and fused if the quality metric is above this threshold. The quality metric is a completely optional field provided by some VIO systems.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 |  | 0 |  

### EKF2_FUSE_BETA (`INT32`) {#EKF2_FUSE_BETA}

Enable synthetic sideslip fusion.

For reliable wind estimation both sideslip and airspeed fusion (see EKF2_ARSP_THR) should be enabled. Only applies to vehicles in fixed-wing mode or with airspeed fusion active. Note: side slip fusion is currently not supported for tailsitters.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### EKF2_GBIAS_INIT (`FLOAT`) {#EKF2_GBIAS_INIT}

1-sigma IMU gyro switch-on bias.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 0.2 |  | 0.1 | rad/s 

### EKF2_GND_EFF_DZ (`FLOAT`) {#EKF2_GND_EFF_DZ}

Baro deadzone range for height fusion.

Sets the value of deadzone applied to negative baro innovations. Deadzone is enabled when EKF2_GND_EFF_DZ > 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 |  | 4.0 | m 

### EKF2_GND_MAX_HGT (`FLOAT`) {#EKF2_GND_MAX_HGT}

Height above ground level for ground effect zone.

Sets the maximum distance to the ground level where negative baro innovations are expected.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 5.0 |  | 0.5 | m 

### EKF2_GPS_CHECK (`INT32`) {#EKF2_GPS_CHECK}

Integer bitmask controlling GPS checks.

Each threshold value is defined by the parameter indicated next to the check. Drift and offset checks only run when the vehicle is on ground and stationary.

**Bitmask:**

- `0`: Sat count (EKF2_REQ_NSATS)
- `1`: PDOP (EKF2_REQ_PDOP)
- `2`: EPH (EKF2_REQ_EPH)
- `3`: EPV (EKF2_REQ_EPV)
- `4`: Speed accuracy (EKF2_REQ_SACC)
- `5`: Horizontal position drift (EKF2_REQ_HDRIFT)
- `6`: Vertical position drift (EKF2_REQ_VDRIFT)
- `7`: Horizontal speed offset (EKF2_REQ_HDRIFT)
- `8`: Vertical speed offset (EKF2_REQ_VDRIFT)
- `9`: Spoofing


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1023 |  | 1023 |  

### EKF2_GPS_CTRL (`INT32`) {#EKF2_GPS_CTRL}

GNSS sensor aiding.

Set bits in the following positions to enable: 0 : Longitude and latitude fusion 1 : Altitude fusion 2 : 3D velocity fusion 3 : Dual antenna heading fusion

**Bitmask:**

- `0`: Lon/lat
- `1`: Altitude
- `2`: 3D velocity
- `3`: Dual antenna heading


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 15 |  | 7 |  

### EKF2_GPS_DELAY (`FLOAT`) {#EKF2_GPS_DELAY}

GPS measurement delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 110 | ms 

### EKF2_GPS_POS_X (`FLOAT`) {#EKF2_GPS_POS_X}

X position of GPS antenna in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_GPS_POS_Y (`FLOAT`) {#EKF2_GPS_POS_Y}

Y position of GPS antenna in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_GPS_POS_Z (`FLOAT`) {#EKF2_GPS_POS_Z}

Z position of GPS antenna in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_GPS_P_GATE (`FLOAT`) {#EKF2_GPS_P_GATE}

Gate size for GNSS position fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_GPS_P_NOISE (`FLOAT`) {#EKF2_GPS_P_NOISE}

Measurement noise for GNSS position.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 10.0 |  | 0.5 | m 

### EKF2_GPS_V_GATE (`FLOAT`) {#EKF2_GPS_V_GATE}

Gate size for GNSS velocity fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_GPS_V_NOISE (`FLOAT`) {#EKF2_GPS_V_NOISE}

Measurement noise for GNSS velocity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 5.0 |  | 0.3 | m/s 

### EKF2_GPS_YAW_OFF (`FLOAT`) {#EKF2_GPS_YAW_OFF}

Heading/Yaw offset for dual antenna GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 360.0 |  | 0.0 | deg 

### EKF2_GRAV_NOISE (`FLOAT`) {#EKF2_GRAV_NOISE}

Accelerometer measurement noise for gravity based observations.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 10.0 |  | 1.0 | g0 

### EKF2_GSF_TAS (`FLOAT`) {#EKF2_GSF_TAS}

Default value of true airspeed used in EKF-GSF AHRS calculation.

If no airspeed measurements are available, the EKF-GSF AHRS calculation will assume this value of true airspeed when compensating for centripetal acceleration during turns. Set to zero to disable centripetal acceleration compensation during fixed wing flight modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 15.0 | m/s 

### EKF2_GYR_B_LIM (`FLOAT`) {#EKF2_GYR_B_LIM}

Gyro bias learning limit.

The ekf gyro bias states will be limited to within a range equivalent to +- of this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.4 |  | 0.15 | rad/s 

### EKF2_GYR_B_NOISE (`FLOAT`) {#EKF2_GYR_B_NOISE}

Process noise for IMU rate gyro bias prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.01 |  | 0.001 | rad/s^2 

### EKF2_GYR_NOISE (`FLOAT`) {#EKF2_GYR_NOISE}

Rate gyro noise for covariance prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0001 | 0.1 |  | 0.015 | rad/s 

### EKF2_HDG_GATE (`FLOAT`) {#EKF2_HDG_GATE}

Gate size for heading fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 2.6 | SD 

### EKF2_HEAD_NOISE (`FLOAT`) {#EKF2_HEAD_NOISE}

Measurement noise for magnetic heading fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1.0 |  | 0.3 | rad 

### EKF2_HGT_REF (`INT32`) {#EKF2_HGT_REF}

Determines the reference source of height data used by the EKF.

When multiple height sources are enabled at the same time, the height estimate will always converge towards the reference height source selected by this parameter. The range sensor and vision options should only be used when for operation over a flat surface as the local NED origin will move up and down with ground level. If GPS is set as reference but altitude fusion is disabled in EKF2_GPS_CTRL, the GPS altitude is still used to initiaize the bias of the other height sensors.

**Values:**

- `0`: Barometric pressure
- `1`: GPS
- `2`: Range sensor
- `3`: Vision


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### EKF2_IMU_CTRL (`INT32`) {#EKF2_IMU_CTRL}

IMU control.

**Bitmask:**

- `0`: Gyro Bias
- `1`: Accel Bias
- `2`: Gravity vector fusion


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 7 |  | 7 |  

### EKF2_IMU_POS_X (`FLOAT`) {#EKF2_IMU_POS_X}

X position of IMU in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_IMU_POS_Y (`FLOAT`) {#EKF2_IMU_POS_Y}

Y position of IMU in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_IMU_POS_Z (`FLOAT`) {#EKF2_IMU_POS_Z}

Z position of IMU in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_LOG_VERBOSE (`INT32`) {#EKF2_LOG_VERBOSE}

Verbose logging.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### EKF2_MAG_ACCLIM (`FLOAT`) {#EKF2_MAG_ACCLIM}

Horizontal acceleration threshold used for heading observability check.

The heading is assumed to be observable when the body acceleration is greater than this parameter when a global position/velocity aiding source is active.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 5.0 |  | 0.5 | m/s^2 

### EKF2_MAG_B_NOISE (`FLOAT`) {#EKF2_MAG_B_NOISE}

Process noise for body magnetic field prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.1 |  | 0.0001 | gauss/s 

### EKF2_MAG_CHECK (`INT32`) {#EKF2_MAG_CHECK}

Magnetic field strength test selection.

Bitmask to set which check is used to decide whether the magnetometer data is valid. If GNSS data is received, the magnetic field is compared to a World Magnetic Model (WMM), otherwise an average value is used. This check is useful to reject occasional hard iron disturbance. Set bits to 1 to enable checks. Checks enabled by the following bit positions 0 : Magnetic field strength. Set tolerance using EKF2_MAG_CHK_STR 1 : Magnetic field inclination. Set tolerance using EKF2_MAG_CHK_INC 2 : Wait for GNSS to find the theoretical strength and inclination using the WMM

**Bitmask:**

- `0`: Strength (EKF2_MAG_CHK_STR)
- `1`: Inclination (EKF2_MAG_CHK_INC)
- `2`: Wait for WMM


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 7 |  | 1 |  

### EKF2_MAG_CHK_INC (`FLOAT`) {#EKF2_MAG_CHK_INC}

Magnetic field inclination check tolerance.

Maximum allowed deviation from the expected magnetic field inclination to pass the check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 90.0 |  | 20.0 | deg 

### EKF2_MAG_CHK_STR (`FLOAT`) {#EKF2_MAG_CHK_STR}

Magnetic field strength check tolerance.

Maximum allowed deviation from the expected magnetic field strength to pass the check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 |  | 0.2 | gauss 

### EKF2_MAG_DECL (`FLOAT`) {#EKF2_MAG_DECL}

Magnetic declination.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 | deg 

### EKF2_MAG_DELAY (`FLOAT`) {#EKF2_MAG_DELAY}

Magnetometer measurement delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 0 | ms 

### EKF2_MAG_E_NOISE (`FLOAT`) {#EKF2_MAG_E_NOISE}

Process noise for earth magnetic field prediction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.1 |  | 0.001 | gauss/s 

### EKF2_MAG_GATE (`FLOAT`) {#EKF2_MAG_GATE}

Gate size for magnetometer XYZ component fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 3.0 | SD 

### EKF2_MAG_NOISE (`FLOAT`) {#EKF2_MAG_NOISE}

Measurement noise for magnetometer 3-axis fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 | 1.0 |  | 0.05 | gauss 

### EKF2_MAG_TYPE (`INT32`) {#EKF2_MAG_TYPE}

Type of magnetometer fusion.

Integer controlling the type of magnetometer fusion used - magnetic heading or 3-component vector. The fusion of magnetometer data as a three component vector enables vehicle body fixed hard iron errors to be learned, but requires a stable earth field. If set to 'Automatic' magnetic heading fusion is used when on-ground and 3-axis magnetic field fusion in-flight. If set to 'Magnetic heading' magnetic heading fusion is used at all times. If set to 'None' the magnetometer will not be used under any circumstance. If no external source of yaw is available, it is possible to use post-takeoff horizontal movement combined with GNSS velocity measurements to align the yaw angle. If set to 'Init' the magnetometer is only used to initalize the heading.

**Values:**

- `0`: Automatic
- `1`: Magnetic heading
- `5`: None
- `6`: Init


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### EKF2_MCOEF (`FLOAT`) {#EKF2_MCOEF}

Propeller momentum drag coefficient for multi-rotor wind estimation.

This parameter controls the prediction of drag produced by the propellers when flying a multi-copter, which enables estimation of wind drift when enabled by the EKF2_DRAG_CTRL parameter. The drag produced by this effect scales with speed not speed squared and is produced because some of the air velocity normal to the propeller axis of rotation is lost when passing through the rotor disc. This  changes the momentum of the flow which creates a drag reaction force. When comparing un-ducted propellers of the same diameter, the effect is roughly proportional to the area of the propeller blades when viewed side on and changes with propeller selection. Momentum drag is significantly higher for ducted rotors. To account for the drag produced by the body which scales with speed squared, see documentation for the EKF2_BCOEF_X and EKF2_BCOEF_Y parameters. Set this parameter to zero to turn off the momentum drag model for both axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1.0 |  | 0.15 | 1/s 

### EKF2_MIN_RNG (`FLOAT`) {#EKF2_MIN_RNG}

Expected range finder reading when on ground.

If the vehicle is on ground, is not moving as determined by the motion test and the range finder is returning invalid or no data, then an assumed range value of EKF2_MIN_RNG will be used by the terrain estimator so that a terrain height estimate is available at the start of flight in situations where the range finder may be inside its minimum measurements distance when on ground.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 0.1 | m 

### EKF2_MULTI_IMU (`INT32`) {#EKF2_MULTI_IMU}

Multi-EKF IMUs.

Maximum number of IMUs to use for Multi-EKF. Set 0 to disable. Requires SENS_IMU_MODE 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 4 |  | 0 |  

### EKF2_MULTI_MAG (`INT32`) {#EKF2_MULTI_MAG}

Multi-EKF Magnetometers.

Maximum number of magnetometers to use for Multi-EKF. Set 0 to disable. Requires SENS_MAG_MODE 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 4 |  | 0 |  

### EKF2_NOAID_NOISE (`FLOAT`) {#EKF2_NOAID_NOISE}

Measurement noise for non-aiding position hold.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 50.0 |  | 10.0 | m 

### EKF2_NOAID_TOUT (`INT32`) {#EKF2_NOAID_TOUT}

Maximum inertial dead-reckoning time.

Maximum lapsed time from last fusion of measurements that constrain velocity drift before the EKF will report the horizontal nav solution as invalid

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 500000 | 10000000 |  | 5000000 | us 

### EKF2_OF_CTRL (`INT32`) {#EKF2_OF_CTRL}

Optical flow aiding.

Enable optical flow fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### EKF2_OF_DELAY (`FLOAT`) {#EKF2_OF_DELAY}

Optical flow measurement delay relative to IMU measurements.

Assumes measurement is timestamped at trailing edge of integration period

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 20 | ms 

### EKF2_OF_GATE (`FLOAT`) {#EKF2_OF_GATE}

Gate size for optical flow fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 3.0 | SD 

### EKF2_OF_GYR_SRC (`INT32`) {#EKF2_OF_GYR_SRC}

Optical flow angular rate compensation source.

Auto: use gyro from optical flow message if available, internal gyro otherwise. Internal: always use internal gyro

**Values:**

- `0`: Auto
- `1`: Internal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### EKF2_OF_N_MAX (`FLOAT`) {#EKF2_OF_N_MAX}

Optical flow maximum noise.

Measurement noise for the optical flow sensor when it's reported quality metric is at the minimum

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 |  |  | 0.5 | rad/s 

### EKF2_OF_N_MIN (`FLOAT`) {#EKF2_OF_N_MIN}

Optical flow minimum noise.

Measurement noise for the optical flow sensor when it's reported quality metric is at the maximum

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 |  |  | 0.15 | rad/s 

### EKF2_OF_POS_X (`FLOAT`) {#EKF2_OF_POS_X}

X position of optical flow focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_OF_POS_Y (`FLOAT`) {#EKF2_OF_POS_Y}

Y position of optical flow focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_OF_POS_Z (`FLOAT`) {#EKF2_OF_POS_Z}

Z position of optical flow focal point in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_OF_QMIN (`INT32`) {#EKF2_OF_QMIN}

In air optical flow minimum quality.

Optical Flow data will only be used in air if the sensor reports a quality metric >= EKF2_OF_QMIN

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 1 |  

### EKF2_OF_QMIN_GND (`INT32`) {#EKF2_OF_QMIN_GND}

On ground optical flow minimum quality.

Optical Flow data will only be used on the ground if the sensor reports a quality metric >= EKF2_OF_QMIN_GND

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 0 |  

### EKF2_PCOEF_XN (`FLOAT`) {#EKF2_PCOEF_XN}

Static pressure position error coefficient for the negative X axis.

This is the ratio of static pressure error to dynamic pressure generated by a negative wind relative velocity along the X body axis. If the baro height estimate rises during backwards flight, then this will be a negative number.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 |  | 0.0 |  

### EKF2_PCOEF_XP (`FLOAT`) {#EKF2_PCOEF_XP}

Static pressure position error coefficient for the positive X axis.

This is the ratio of static pressure error to dynamic pressure generated by a positive wind relative velocity along the X body axis. If the baro height estimate rises during forward flight, then this will be a negative number.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 |  | 0.0 |  

### EKF2_PCOEF_YN (`FLOAT`) {#EKF2_PCOEF_YN}

Pressure position error coefficient for the negative Y axis.

This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the negative Y (LH) body axis. If the baro height estimate rises during sideways flight to the left, then this will be a negative number.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 |  | 0.0 |  

### EKF2_PCOEF_YP (`FLOAT`) {#EKF2_PCOEF_YP}

Pressure position error coefficient for the positive Y axis.

This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the positive Y (RH) body axis. If the baro height estimate rises during sideways flight to the right, then this will be a negative number.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 |  | 0.0 |  

### EKF2_PCOEF_Z (`FLOAT`) {#EKF2_PCOEF_Z}

Static pressure position error coefficient for the Z axis.

This is the ratio of static pressure error to dynamic pressure generated by a wind relative velocity along the Z body axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 |  | 0.0 |  

### EKF2_PREDICT_US (`INT32`) {#EKF2_PREDICT_US}

EKF prediction period.

EKF prediction period in microseconds. This should ideally be an integer multiple of the IMU time delta. Actual filter update will be an integer multiple of IMU update.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1000 | 20000 |  | 10000 | us 

### EKF2_REQ_EPH (`FLOAT`) {#EKF2_REQ_EPH}

Required EPH to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 100 |  | 3.0 | m 

### EKF2_REQ_EPV (`FLOAT`) {#EKF2_REQ_EPV}

Required EPV to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 100 |  | 5.0 | m 

### EKF2_REQ_GPS_H (`FLOAT`) {#EKF2_REQ_GPS_H}

Required GPS health time on startup.

Minimum continuous period without GPS failure required to mark a healthy GPS status. It can be reduced to speed up initialization, but it's recommended to keep this unchanged for a vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.1 |  |  | 10.0 | s 

### EKF2_REQ_HDRIFT (`FLOAT`) {#EKF2_REQ_HDRIFT}

Maximum horizontal drift speed to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 |  | 0.1 | m/s 

### EKF2_REQ_NSATS (`INT32`) {#EKF2_REQ_NSATS}

Required satellite count to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 4 | 12 |  | 6 |  

### EKF2_REQ_PDOP (`FLOAT`) {#EKF2_REQ_PDOP}

Maximum PDOP to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.5 | 5.0 |  | 2.5 |  

### EKF2_REQ_SACC (`FLOAT`) {#EKF2_REQ_SACC}

Required speed accuracy to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 5.0 |  | 0.5 | m/s 

### EKF2_REQ_VDRIFT (`FLOAT`) {#EKF2_REQ_VDRIFT}

Maximum vertical drift speed to use GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.5 |  | 0.2 | m/s 

### EKF2_RNG_A_HMAX (`FLOAT`) {#EKF2_RNG_A_HMAX}

Maximum height above ground allowed for conditional range aid mode.

If the vehicle absolute altitude exceeds this value then the estimator will not fuse range measurements to estimate its height. This only applies when conditional range aid mode is activated (EKF2_RNG_CTRL = 1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10.0 |  | 5.0 | m 

### EKF2_RNG_A_IGATE (`FLOAT`) {#EKF2_RNG_A_IGATE}

Gate size used for innovation consistency checks for range aid fusion.

A lower value means HAGL needs to be more stable in order to use range finder for height estimation in range aid mode

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 5.0 |  | 1.0 | SD 

### EKF2_RNG_A_VMAX (`FLOAT`) {#EKF2_RNG_A_VMAX}

Maximum horizontal velocity allowed for conditional range aid mode.

If the vehicle horizontal speed exceeds this value then the estimator will not fuse range measurements to estimate its height. This only applies when conditional range aid mode is activated (EKF2_RNG_CTRL = 1).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 2 |  | 1.0 | m/s 

### EKF2_RNG_CTRL (`INT32`) {#EKF2_RNG_CTRL}

Range sensor height aiding.

WARNING: Range finder measurements are less reliable and can experience unexpected errors. For these reasons, if accurate control of height relative to ground is required, it is recommended to use the MPC_ALT_MODE parameter instead, unless baro errors are severe enough to cause problems with landing and takeoff. If this parameter is enabled then the estimator will make use of the range finder measurements to estimate its height in addition to other height sources (if activated). Range sensor aiding can be enabled (i.e.: always use) or set in "conditional" mode. Conditional mode: This enables the range finder to be used during low speed (< EKF2_RNG_A_VMAX) and low altitude (< EKF2_RNG_A_HMAX) operation, eg takeoff and landing, where baro interference from rotor wash is excessive and can corrupt EKF state estimates. It is intended to be used where a vertical takeoff and landing is performed, and horizontal flight does not occur until above EKF2_RNG_A_HMAX.

**Values:**

- `0`: Disable range fusion
- `1`: Enabled (conditional mode)
- `2`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### EKF2_RNG_DELAY (`FLOAT`) {#EKF2_RNG_DELAY}

Range finder measurement delay relative to IMU measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 300 |  | 5 | ms 

### EKF2_RNG_FOG (`FLOAT`) {#EKF2_RNG_FOG}

Maximum distance at which the range finder could detect fog (m).

Limit for fog detection. If the range finder measures a distance greater than this value, the measurement is considered to not be blocked by fog or rain. If there's a jump from larger than RNG_FOG to smaller than EKF2_RNG_FOG, the measurement may gets rejected. 0 - disabled

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 20.0 |  | 3.0 | m 

### EKF2_RNG_GATE (`FLOAT`) {#EKF2_RNG_GATE}

Gate size for range finder fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_RNG_K_GATE (`FLOAT`) {#EKF2_RNG_K_GATE}

Gate size used for range finder kinematic consistency check.

To be used, the time derivative of the distance sensor measurements projected on the vertical axis needs to be statistically consistent with the estimated vertical velocity of the drone. Decrease this value to make the filter more robust against range finder faulty data (stuck, reflections, ...). Note: tune the range finder noise parameters (EKF2_RNG_NOISE and EKF2_RNG_SFE) before tuning this gate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 5.0 |  | 1.0 | SD 

### EKF2_RNG_NOISE (`FLOAT`) {#EKF2_RNG_NOISE}

Measurement noise for range finder fusion.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 0.1 | m 

### EKF2_RNG_PITCH (`FLOAT`) {#EKF2_RNG_PITCH}

Range sensor pitch offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.75 | 0.75 |  | 0.0 | rad 

### EKF2_RNG_POS_X (`FLOAT`) {#EKF2_RNG_POS_X}

X position of range finder origin in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_RNG_POS_Y (`FLOAT`) {#EKF2_RNG_POS_Y}

Y position of range finder origin in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_RNG_POS_Z (`FLOAT`) {#EKF2_RNG_POS_Z}

Z position of range finder origin in body frame.

Forward axis with origin relative to vehicle centre of gravity

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### EKF2_RNG_QLTY_T (`FLOAT`) {#EKF2_RNG_QLTY_T}

Minumum range validity period.

Minimum duration during which the reported range finder signal quality needs to be non-zero in order to be declared valid (s)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 5 |  | 1.0 | s 

### EKF2_RNG_SFE (`FLOAT`) {#EKF2_RNG_SFE}

Range finder range dependent noise scaler.

Specifies the increase in range finder noise with range.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.2 |  | 0.05 | m/m 

### EKF2_SEL_ERR_RED (`FLOAT`) {#EKF2_SEL_ERR_RED}

Selector error reduce threshold.

EKF2 instances have to be better than the selected by at least this amount before their relative score can be reduced.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.2 |  

### EKF2_SEL_IMU_ACC (`FLOAT`) {#EKF2_SEL_IMU_ACC}

Selector acceleration threshold.

EKF2 selector acceleration error threshold for comparing accelerometers. Acceleration vector differences larger than this will result in accumulated velocity error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1.0 | m/s^2 

### EKF2_SEL_IMU_ANG (`FLOAT`) {#EKF2_SEL_IMU_ANG}

Selector angular threshold.

EKF2 selector maximum accumulated angular error threshold for comparing gyros. Accumulated angular error larger than this will result in the sensor being declared faulty.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 15.0 | deg 

### EKF2_SEL_IMU_RAT (`FLOAT`) {#EKF2_SEL_IMU_RAT}

Selector angular rate threshold.

EKF2 selector angular rate error threshold for comparing gyros. Angular rate vector differences larger than this will result in accumulated angular error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 7.0 | deg/s 

### EKF2_SEL_IMU_VEL (`FLOAT`) {#EKF2_SEL_IMU_VEL}

Selector angular threshold.

EKF2 selector maximum accumulated velocity threshold for comparing accelerometers. Accumulated velocity error larger than this will result in the sensor being declared faulty.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2.0 | m/s 

### EKF2_SYNT_MAG_Z (`INT32`) {#EKF2_SYNT_MAG_Z}

Enable synthetic magnetometer Z component measurement.

Use for vehicles where the measured body Z magnetic field is subject to strong magnetic interference. For magnetic heading fusion the magnetometer Z measurement will be replaced by a synthetic value calculated using the knowledge of the 3D magnetic field vector at the location of the drone. Therefore, this parameter will only have an effect if the global position of the drone is known. For 3D mag fusion the magnetometer Z measurement will simply be ignored instead of fusing the synthetic value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### EKF2_TAS_GATE (`FLOAT`) {#EKF2_TAS_GATE}

Gate size for TAS fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 5.0 | SD 

### EKF2_TAU_POS (`FLOAT`) {#EKF2_TAU_POS}

Output predictor position time constant.

Controls how tightly the output track the EKF states

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 |  | 0.25 | s 

### EKF2_TAU_VEL (`FLOAT`) {#EKF2_TAU_VEL}

Time constant of the velocity output prediction and smoothing filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  | 1.0 |  | 0.25 | s 

### EKF2_TERR_GRAD (`FLOAT`) {#EKF2_TERR_GRAD}

Magnitude of terrain gradient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  |  | 0.5 | m/m 

### EKF2_TERR_NOISE (`FLOAT`) {#EKF2_TERR_NOISE}

Terrain altitude process noise.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  |  | 5.0 | m/s 

### EKF2_VEL_LIM (`FLOAT`) {#EKF2_VEL_LIM}

Velocity limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  | 299792458 |  | 100 | m/s 

### EKF2_WIND_NSD (`FLOAT`) {#EKF2_WIND_NSD}

Process noise spectral density for wind velocity prediction.

When unaided, the wind estimate uncertainty (1-sigma, in m/s) increases by this amount every second.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 |  | 0.05 | m/s^2/sqrt(Hz) 

## ESC

### ESC_BL_VER (`INT32`) {#ESC_BL_VER}

Required esc bootloader version.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### ESC_FW_VER (`INT32`) {#ESC_FW_VER}

Required esc firmware version.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

### ESC_HW_VER (`INT32`) {#ESC_HW_VER}

Required esc hardware version.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 |  | 0 |  

## Events

### EV_TSK_RC_LOSS (`INT32`) {#EV_TSK_RC_LOSS}

RC Loss Alarm.

Enable/disable event task for RC Loss. When enabled, an alarm tune will be played via buzzer or ESCs, if supported. The alarm will sound after a disarm, if the vehicle was previously armed and only if the vehicle had RC signal at some point. Particularly useful for locating crashed drones without a GPS sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### EV_TSK_STAT_DIS (`INT32`) {#EV_TSK_STAT_DIS}

Status Display.

Enable/disable event task for displaying the vehicle status using arm-mounted LEDs. When enabled and if the vehicle supports it, LEDs will flash indicating various vehicle status changes. Currently PX4 has not implemented any specific status events. -

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

## FW Attitude Control

### FW_MAN_P_MAX (`FLOAT`) {#FW_MAN_P_MAX}

Maximum manual pitch angle.

Applies to both directions in all manual modes with attitude stabilization but without altitude control

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 90.0 | 0.5 | 30.0 | deg 

### FW_MAN_R_MAX (`FLOAT`) {#FW_MAN_R_MAX}

Maximum manual roll angle.

Applies to both directions in all manual modes with attitude stabilization

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 90.0 | 0.5 | 45.0 | deg 

### FW_MAN_YR_MAX (`FLOAT`) {#FW_MAN_YR_MAX}

Maximum manually added yaw rate.

This is the maximally added yaw rate setpoint from the yaw stick in any attitude controlled flight mode. It is added to the yaw rate setpoint generated by the controller for turn coordination.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.5 | 30. | deg/s 

### FW_PSP_OFF (`FLOAT`) {#FW_PSP_OFF}

Pitch setpoint offset (pitch at level flight).

An airframe specific offset of the pitch setpoint in degrees, the value is added to the pitch setpoint and should correspond to the pitch at typical cruise speed of the airframe.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 | 0.5 | 0.0 | deg 

### FW_P_RMAX_NEG (`FLOAT`) {#FW_P_RMAX_NEG}

Maximum negative / down pitch rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 180 | 0.5 | 60.0 | deg/s 

### FW_P_RMAX_POS (`FLOAT`) {#FW_P_RMAX_POS}

Maximum positive / up pitch rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 180 | 0.5 | 60.0 | deg/s 

### FW_P_TC (`FLOAT`) {#FW_P_TC}

Attitude pitch time constant.

This defines the latency between a pitch step input and the achieved setpoint (inverse to a P gain). Smaller systems may require smaller values.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.2 | 1.0 | 0.05 | 0.4 | s 

### FW_R_RMAX (`FLOAT`) {#FW_R_RMAX}

Maximum roll rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 180 | 0.5 | 70.0 | deg/s 

### FW_R_TC (`FLOAT`) {#FW_R_TC}

Attitude Roll Time Constant.

This defines the latency between a roll step input and the achieved setpoint (inverse to a P gain). Smaller systems may require smaller values.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.2 | 1.0 | 0.05 | 0.4 | s 

### FW_SPOILERS_LND (`FLOAT`) {#FW_SPOILERS_LND}

Spoiler landing setting.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0. | norm 

### FW_WR_FF (`FLOAT`) {#FW_WR_FF}

Wheel steering rate feed forward.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.05 | 0.2 | %/rad/s 

### FW_WR_I (`FLOAT`) {#FW_WR_I}

Wheel steering rate integrator gain.

This gain defines how much control response will result out of a steady state error. It trims any constant error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.1 | %/rad 

### FW_WR_IMAX (`FLOAT`) {#FW_WR_IMAX}

Wheel steering rate integrator limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.05 | 0.4 |  

### FW_WR_P (`FLOAT`) {#FW_WR_P}

Wheel steering rate proportional gain.

This defines how much the wheel steering input will be commanded depending on the current body angular rate error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.5 | %/rad/s 

### FW_W_EN (`INT32`) {#FW_W_EN}

Enable wheel steering controller.

Only enabled during automatic runway takeoff and landing. In all manual modes the wheel is directly controlled with yaw stick.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_W_RMAX (`FLOAT`) {#FW_W_RMAX}

Maximum wheel steering rate.

This limits the maximum wheel steering rate the controller will output (in degrees per second).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 90.0 | 0.5 | 30.0 | deg/s 

### FW_Y_RMAX (`FLOAT`) {#FW_Y_RMAX}

Maximum yaw rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 180 | 0.5 | 50.0 | deg/s 

## FW Auto Landing

### FW_LND_ABORT (`INT32`) {#FW_LND_ABORT}

Bit mask to set the automatic landing abort conditions.

Terrain estimation: bit 0: Abort if terrain is not found bit 1: Abort if terrain times out (after a first successful measurement) The last estimate is always used as ground, whether the last valid measurement or the land waypoint, depending on the selected abort criteria, until an abort condition is entered. If FW_LND_USETER == 0, these bits are ignored. TODO: Extend automatic abort conditions e.g. glide slope tracking error (horizontal and vertical)

**Bitmask:**

- `0`: Abort if terrain is not found (only applies to mission landings)
- `1`: Abort if terrain times out (after a first successful measurement)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 3 |  

### FW_LND_AIRSPD (`FLOAT`) {#FW_LND_AIRSPD}

Landing airspeed.

The calibrated airspeed setpoint during landing. If set <= 0, landing airspeed = FW_AIRSPD_MIN by default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  | 0.1 | -1. | m/s 

### FW_LND_ANG (`FLOAT`) {#FW_LND_ANG}

Maximum landing slope angle.

Typically the desired landing slope angle when landing configuration (flaps, airspeed) is enabled. Set this value within the vehicle's performance limits.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 15.0 | 0.5 | 5.0 | deg 

### FW_LND_EARLYCFG (`INT32`) {#FW_LND_EARLYCFG}

Early landing configuration deployment.

Allows to deploy the landing configuration (flaps, landing airspeed, etc.) already in the loiter-down waypoint before the final approach. Otherwise is enabled only in the final approach.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_LND_FLALT (`FLOAT`) {#FW_LND_FLALT}

Landing flare altitude (relative to landing altitude).

NOTE: max(FW_LND_FLALT, FW_LND_FL_TIME * |z-velocity|) is taken as the flare altitude

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.5 | 0.5 | m 

### FW_LND_FL_PMAX (`FLOAT`) {#FW_LND_FL_PMAX}

Flare, maximum pitch.

Maximum pitch during landing flare.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 45.0 | 0.5 | 15.0 | deg 

### FW_LND_FL_PMIN (`FLOAT`) {#FW_LND_FL_PMIN}

Flare, minimum pitch.

Minimum pitch during landing flare.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -5 | 15.0 | 0.5 | 2.5 | deg 

### FW_LND_FL_SINK (`FLOAT`) {#FW_LND_FL_SINK}

Landing flare sink rate.

TECS will attempt to control the aircraft to this sink rate via pitch angle (throttle killed during flare)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2 | 0.1 | 0.25 | m/s 

### FW_LND_FL_TIME (`FLOAT`) {#FW_LND_FL_TIME}

Landing flare time.

Multiplied by the descent rate to calculate a dynamic altitude at which to trigger the flare. NOTE: max(FW_LND_FLALT, FW_LND_FL_TIME * descent rate) is taken as the flare altitude

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 5.0 | 0.1 | 1.0 | s 

### FW_LND_NUDGE (`INT32`) {#FW_LND_NUDGE}

Landing touchdown nudging option.

Approach angle nudging: shifts the touchdown point laterally while keeping the approach entrance point constant Approach path nudging: shifts the touchdown point laterally along with the entire approach path This is useful for manually adjusting the landing point in real time when map or GNSS errors cause an offset from the desired landing vector. Nudging is done with yaw stick, constrained to FW_LND_TD_OFF (in meters) and the direction is relative to the vehicle heading (stick deflection to the right = land point moves to the right as seen by the vehicle).

**Values:**

- `0`: Disable nudging
- `1`: Nudge approach angle
- `2`: Nudge approach path


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 2 |  

### FW_LND_TD_OFF (`FLOAT`) {#FW_LND_TD_OFF}

Maximum lateral position offset for the touchdown point.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 1 | 3.0 | m 

### FW_LND_TD_TIME (`FLOAT`) {#FW_LND_TD_TIME}

Landing touchdown time (since flare start).

This is the time after the start of flaring that we expect the vehicle to touch the runway. At this time, a 0.5s clamp down ramp will engage, constraining the pitch setpoint to RWTO_PSP. If enabled, ensure that RWTO_PSP is configured appropriately for full gear contact on ground roll. Set to -1.0 to disable touchdown clamping. E.g. it may not be desirable to clamp on belly landings. The touchdown time will be constrained to be greater than or equal to the flare time (FW_LND_FL_TIME).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 5.0 | 0.1 | -1.0 | s 

### FW_LND_THRTC_SC (`FLOAT`) {#FW_LND_THRTC_SC}

Altitude time constant factor for landing and low-height flight.

The TECS altitude time constant (FW_T_ALT_TC) is multiplied by this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.2 | 1.0 | 0.1 | 1.0 |  

### FW_LND_USETER (`INT32`) {#FW_LND_USETER}

Use terrain estimation during landing.

This is critical for detecting when to flare, and should be enabled if possible. If enabled and no measurement is found within a given timeout, the landing waypoint altitude will be used OR the landing will be aborted, depending on the criteria set in FW_LND_ABORT. If disabled, FW_LND_ABORT terrain based criteria are ignored.

**Values:**

- `0`: Disable the terrain estimate
- `1`: Use the terrain estimate to trigger the flare (only)
- `2`: Calculate landing glide slope relative to the terrain estimate


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 1 |  

## FW Geometry

### FW_WING_HEIGHT (`FLOAT`) {#FW_WING_HEIGHT}

Height (AGL) of the wings when the aircraft is on the ground.

This is used to constrain a minimum altitude below which we keep wings level to avoid wing tip strike. It's safer to give a slight margin here (> 0m)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 1 | 0.5 | m 

### FW_WING_SPAN (`FLOAT`) {#FW_WING_SPAN}

The aircraft's wing span (length from tip to tip).

This is used for limiting the roll setpoint near the ground. (if multiple wings, take the longest span)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | 3.0 | m 

## FW Launch detection

### FW_LAUN_AC_T (`FLOAT`) {#FW_LAUN_AC_T}

Trigger time.

Launch is detected when acceleration in body forward direction is above FW_LAUN_AC_THLD for FW_LAUN_AC_T seconds.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 5.0 | 0.05 | 0.05 | s 

### FW_LAUN_AC_THLD (`FLOAT`) {#FW_LAUN_AC_THLD}

Trigger acceleration threshold.

Launch is detected when acceleration in body forward direction is above FW_LAUN_AC_THLD for FW_LAUN_AC_T seconds.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.5 | 30.0 | m/s^2 

### FW_LAUN_DETCN_ON (`INT32`) {#FW_LAUN_DETCN_ON}

Fixed-wing launch detection.

Enables automatic launch detection based on measured acceleration. Use for hand- or catapult-launched vehicles. Not compatible with runway takeoff.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_LAUN_MOT_DEL (`FLOAT`) {#FW_LAUN_MOT_DEL}

Motor delay.

Start the motor(s) this amount of seconds after launch is detected.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.5 | 0.0 | s 

## FW NPFG Control

### NPFG_DAMPING (`FLOAT`) {#NPFG_DAMPING}

NPFG damping ratio.

Damping ratio of NPFG control law.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.10 | 1.00 | 0.01 | 0.7 |  

### NPFG_EN_MIN_GSP (`INT32`) {#NPFG_EN_MIN_GSP}

Enable minimum forward ground speed maintaining excess wind handling logic.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### NPFG_GSP_MAX_TK (`FLOAT`) {#NPFG_GSP_MAX_TK}

Maximum, minimum forward ground speed for track keeping in excess wind.

The maximum value of the minimum forward ground speed that may be commanded by the track keeping excess wind handling logic. Commanded in full at the normalized track error fraction of the track error boundary and reduced to zero on track.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.5 | 5.0 | m/s 

### NPFG_LB_PERIOD (`INT32`) {#NPFG_LB_PERIOD}

Enable automatic lower bound on the NPFG period.

Avoids limit cycling from a too aggressively tuned period/damping combination. If false, also disables upper bound NPFG_PERIOD_UB.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### NPFG_PERIOD (`FLOAT`) {#NPFG_PERIOD}

NPFG period.

Period of NPFG control law.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 100.0 | 0.1 | 10.0 | s 

### NPFG_PERIOD_SF (`FLOAT`) {#NPFG_PERIOD_SF}

Period safety factor.

Multiplied by period for conservative minimum period bounding (when period lower bounding is enabled). 1.0 bounds at marginal stability.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10.0 | 0.1 | 1.5 |  

### NPFG_ROLL_TC (`FLOAT`) {#NPFG_ROLL_TC}

Roll time constant.

Time constant of roll controller command / response, modeled as first order delay. Used to determine lower period bound. Setting zero disables automatic period bounding.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00 | 2.00 | 0.05 | 0.5 | s 

### NPFG_SW_DST_MLT (`FLOAT`) {#NPFG_SW_DST_MLT}

NPFG switch distance multiplier.

Multiplied by the track error boundary to determine when the aircraft switches to the next waypoint and/or path segment. Should be less than 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.0 | 0.01 | 0.32 |  

### NPFG_TRACK_KEEP (`INT32`) {#NPFG_TRACK_KEEP}

Enable track keeping excess wind handling logic.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### NPFG_UB_PERIOD (`INT32`) {#NPFG_UB_PERIOD}

Enable automatic upper bound on the NPFG period.

Adapts period to maintain track keeping in variable winds and path curvature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### NPFG_WIND_REG (`INT32`) {#NPFG_WIND_REG}

Enable wind excess regulation.

Disabling this parameter further disables all other airspeed incrementation options.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

## FW Path Control

### FW_PN_R_SLEW_MAX (`FLOAT`) {#FW_PN_R_SLEW_MAX}

Path navigation roll slew rate limit.

Maximum change in roll angle setpoint per second. Applied in all Auto modes, plus manual Position & Altitude modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 1 | 90.0 | deg/s 

### FW_POS_STK_CONF (`INT32`) {#FW_POS_STK_CONF}

Custom stick configuration.

Applies in manual Position and Altitude flight modes.

**Bitmask:**

- `0`: Alternative stick configuration (height rate on throttle stick, airspeed on pitch stick)
- `1`: Enable airspeed setpoint via sticks in altitude and position flight mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 2 |  

### FW_R_LIM (`FLOAT`) {#FW_R_LIM}

Maximum roll angle setpoint.

Applies in any altitude controlled flight mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 35.0 | 65.0 | 0.5 | 50.0 | deg 

### FW_TKO_PITCH_MIN (`FLOAT`) {#FW_TKO_PITCH_MIN}

Minimum pitch during takeoff.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -5.0 | 30.0 | 0.5 | 10.0 | deg 

## FW Performance

### FW_AIRSPD_MAX (`FLOAT`) {#FW_AIRSPD_MAX}

Maximum Airspeed (CAS).

The maximal airspeed (calibrated airspeed) the user is able to command.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  | 0.5 | 20.0 | m/s 

### FW_AIRSPD_MIN (`FLOAT`) {#FW_AIRSPD_MIN}

Minimum Airspeed (CAS).

The minimal airspeed (calibrated airspeed) the user is able to command. Further, if the airspeed falls below this value, the TECS controller will try to increase airspeed more aggressively. Has to be set according to the vehicle's stall speed (which should be set in FW_AIRSPD_STALL), with some margin between the stall speed and minimum airspeed. This value corresponds to the desired minimum speed with the default load factor (level flight, default weight), and is automatically adpated to the current load factor (calculated from roll setpoint and WEIGHT_GROSS/WEIGHT_BASE).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  | 0.5 | 10.0 | m/s 

### FW_AIRSPD_STALL (`FLOAT`) {#FW_AIRSPD_STALL}

Stall Airspeed (CAS).

The stall airspeed (calibrated airspeed) of the vehicle. It is used for airspeed sensor failure detection and for the control surface scaling airspeed limits.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  | 0.5 | 7.0 | m/s 

### FW_AIRSPD_TRIM (`FLOAT`) {#FW_AIRSPD_TRIM}

Trim (Cruise) Airspeed.

The trim CAS (calibrated airspeed) of the vehicle. If an airspeed controller is active, this is the default airspeed setpoint that the controller will try to achieve. This value corresponds to the trim airspeed with the default load factor (level flight, default weight).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  | 0.5 | 15.0 | m/s 

### FW_SERVICE_CEIL (`FLOAT`) {#FW_SERVICE_CEIL}

Service ceiling.

Altitude in standard atmosphere at which the vehicle in normal configuration (WEIGHT_BASE) is still able to achieve a maximum climb rate of 0.5m/s at maximum throttle (FW_THR_MAX). Used to compensate for air density in FW_T_CLMB_MAX. Set negative to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  | 1.0 | -1.0 | m 

### FW_THR_ASPD_MAX (`FLOAT`) {#FW_THR_ASPD_MAX}

Throttle at max airspeed.

Required throttle (at sea level, standard atmosphere) for level flight at maximum airspeed FW_AIRSPD_MAX Set to 0 to disable mapping of airspeed to trim throttle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0. |  

### FW_THR_ASPD_MIN (`FLOAT`) {#FW_THR_ASPD_MIN}

Throttle at min airspeed.

Required throttle (at sea level, standard atmosphere) for level flight at minimum airspeed FW_AIRSPD_MIN Set to 0 to disable mapping of airspeed to trim throttle below FW_AIRSPD_TRIM.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0. |  

### FW_THR_TRIM (`FLOAT`) {#FW_THR_TRIM}

Trim throttle.

Required throttle (at sea level, standard atmosphere) for level flight at FW_AIRSPD_TRIM

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.6 | norm 

### FW_T_CLMB_MAX (`FLOAT`) {#FW_T_CLMB_MAX}

Maximum climb rate.

This is the maximum calibrated climb rate that the aircraft can achieve with the throttle set to FW_THR_MAX and the airspeed set to the trim value. For electric aircraft make sure this number can be achieved towards the end of flight when the battery voltage has reduced.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 15.0 | 0.5 | 5.0 | m/s 

### FW_T_SINK_MIN (`FLOAT`) {#FW_T_SINK_MIN}

Minimum descent rate.

This is the minimum calibrated sink rate of the aircraft with the throttle set to THR_MIN and flown at the same airspeed as used to measure FW_T_CLMB_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 5.0 | 0.5 | 2.0 | m/s 

### WEIGHT_BASE (`FLOAT`) {#WEIGHT_BASE}

Vehicle base weight.

This is the weight of the vehicle at which it's performance limits were derived. A zero or negative value disables trim throttle and minimum airspeed compensation based on weight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.5 | -1.0 | kg 

### WEIGHT_GROSS (`FLOAT`) {#WEIGHT_GROSS}

Vehicle gross weight.

This is the actual weight of the vehicle at any time. This value will differ from WEIGHT_BASE in case weight was added or removed from the base weight. Examples are the addition of payloads or larger batteries. A zero or negative value disables trim throttle and minimum airspeed compensation based on weight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.1 | -1.0 | kg 

## FW Rate Control

### FW_ACRO_X_MAX (`FLOAT`) {#FW_ACRO_X_MAX}

Acro body roll max rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 720 |  | 90 | deg 

### FW_ACRO_YAW_EN (`INT32`) {#FW_ACRO_YAW_EN}

Enable yaw rate controller in Acro.

If this parameter is set to 1, the yaw rate controller is enabled in Fixed-wing Acro mode. Otherwise the pilot commands directly the yaw actuator. It is disabled by default because an active yaw rate controller will fight against the natural turn coordination of the plane.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_ACRO_Y_MAX (`FLOAT`) {#FW_ACRO_Y_MAX}

Acro body pitch max rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 720 |  | 90 | deg 

### FW_ACRO_Z_MAX (`FLOAT`) {#FW_ACRO_Z_MAX}

Acro body yaw max rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 720 |  | 45 | deg 

### FW_ARSP_SCALE_EN (`INT32`) {#FW_ARSP_SCALE_EN}

Enable airspeed scaling.

This enables a logic that automatically adjusts the output of the rate controller to take into account the real torque produced by an aerodynamic control surface given the current deviation from the trim airspeed (FW_AIRSPD_TRIM). Enable when using aerodynamic control surfaces (e.g.: plane) Disable when using rotor wings (e.g.: autogyro)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### FW_BAT_SCALE_EN (`INT32`) {#FW_BAT_SCALE_EN}

Enable throttle scale by battery level.

This compensates for voltage drop of the battery over time by attempting to normalize performance across the operating range of the battery.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### FW_DTRIM_P_VMAX (`FLOAT`) {#FW_DTRIM_P_VMAX}

Pitch trim increment at maximum airspeed.

This increment is added to TRIM_PITCH when airspeed is FW_AIRSPD_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_DTRIM_P_VMIN (`FLOAT`) {#FW_DTRIM_P_VMIN}

Pitch trim increment at minimum airspeed.

This increment is added to TRIM_PITCH when airspeed is FW_AIRSPD_MIN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_DTRIM_R_VMAX (`FLOAT`) {#FW_DTRIM_R_VMAX}

Roll trim increment at maximum airspeed.

This increment is added to TRIM_ROLL when airspeed is FW_AIRSPD_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_DTRIM_R_VMIN (`FLOAT`) {#FW_DTRIM_R_VMIN}

Roll trim increment at minimum airspeed.

This increment is added to TRIM_ROLL when airspeed is FW_AIRSPD_MIN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_DTRIM_Y_VMAX (`FLOAT`) {#FW_DTRIM_Y_VMAX}

Yaw trim increment at maximum airspeed.

This increment is added to TRIM_YAW when airspeed is FW_AIRSPD_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_DTRIM_Y_VMIN (`FLOAT`) {#FW_DTRIM_Y_VMIN}

Yaw trim increment at minimum airspeed.

This increment is added to TRIM_YAW when airspeed is FW_AIRSPD_MIN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### FW_FLAPS_LND_SCL (`FLOAT`) {#FW_FLAPS_LND_SCL}

Flaps setting during landing.

Sets a fraction of full flaps during landing. Also applies to flaperons if enabled in the mixer/allocation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 1.0 | norm 

### FW_FLAPS_TO_SCL (`FLOAT`) {#FW_FLAPS_TO_SCL}

Flaps setting during take-off.

Sets a fraction of full flaps during take-off. Also applies to flaperons if enabled in the mixer/allocation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.0 | norm 

### FW_MAN_P_SC (`FLOAT`) {#FW_MAN_P_SC}

Manual pitch scale.

Scale factor applied to the desired pitch actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 1.0 | norm 

### FW_MAN_R_SC (`FLOAT`) {#FW_MAN_R_SC}

Manual roll scale.

Scale factor applied to the desired roll actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 1.0 | norm 

### FW_MAN_Y_SC (`FLOAT`) {#FW_MAN_Y_SC}

Manual yaw scale.

Scale factor applied to the desired yaw actuator command in full manual mode. This parameter allows to adjust the throws of the control surfaces.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 1.0 | norm 

### FW_PR_D (`FLOAT`) {#FW_PR_D}

Pitch rate derivative gain.

Pitch rate differential gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0. | %/rad/s 

### FW_PR_FF (`FLOAT`) {#FW_PR_FF}

Pitch rate feed forward.

Direct feed forward from rate setpoint to control surface output

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.05 | 0.5 | %/rad/s 

### FW_PR_I (`FLOAT`) {#FW_PR_I}

Pitch rate integrator gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.1 | %/rad 

### FW_PR_IMAX (`FLOAT`) {#FW_PR_IMAX}

Pitch rate integrator limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.05 | 0.4 |  

### FW_PR_P (`FLOAT`) {#FW_PR_P}

Pitch rate proportional gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.08 | %/rad/s 

### FW_RLL_TO_YAW_FF (`FLOAT`) {#FW_RLL_TO_YAW_FF}

Roll control to yaw control feedforward gain.

This gain can be used to counteract the "adverse yaw" effect for fixed wings. When the plane enters a roll it will tend to yaw the nose out of the turn. This gain enables the use of a yaw actuator to counteract this effect.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.0 |  

### FW_RR_D (`FLOAT`) {#FW_RR_D}

Roll rate derivative gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.0 | %/rad/s 

### FW_RR_FF (`FLOAT`) {#FW_RR_FF}

Roll rate feed forward.

Direct feed forward from rate setpoint to control surface output.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.05 | 0.5 | %/rad/s 

### FW_RR_I (`FLOAT`) {#FW_RR_I}

Roll rate integrator gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.01 | 0.1 | %/rad 

### FW_RR_IMAX (`FLOAT`) {#FW_RR_IMAX}

Roll integrator limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.05 | 0.2 |  

### FW_RR_P (`FLOAT`) {#FW_RR_P}

Roll rate proportional gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.05 | %/rad/s 

### FW_SPOILERS_MAN (`INT32`) {#FW_SPOILERS_MAN}

Spoiler input in manual flight.

Chose source for manual setting of spoilers in manual flight modes.

**Values:**

- `0`: Disabled
- `1`: Flaps channel
- `2`: Aux1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### FW_USE_AIRSPD (`INT32`) {#FW_USE_AIRSPD}

Use airspeed for control.

If set to 1, the airspeed measurement data, if valid, is used in the following controllers: - Rate controller: output scaling - Attitude controller: coordinated turn controller - Position controller: airspeed setpoint tracking, takeoff logic - VTOL: transition logic

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### FW_YR_D (`FLOAT`) {#FW_YR_D}

Yaw rate derivative gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.0 | %/rad/s 

### FW_YR_FF (`FLOAT`) {#FW_YR_FF}

Yaw rate feed forward.

Direct feed forward from rate setpoint to control surface output

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.05 | 0.3 | %/rad/s 

### FW_YR_I (`FLOAT`) {#FW_YR_I}

Yaw rate integrator gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.5 | 0.1 | %/rad 

### FW_YR_IMAX (`FLOAT`) {#FW_YR_IMAX}

Yaw rate integrator limit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.05 | 0.2 |  

### FW_YR_P (`FLOAT`) {#FW_YR_P}

Yaw rate proportional gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.005 | 0.05 | %/rad/s 

## FW TECS

### FW_GND_SPD_MIN (`FLOAT`) {#FW_GND_SPD_MIN}

Minimum groundspeed.

The controller will increase the commanded airspeed to maintain this minimum groundspeed to the next waypoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 40 | 0.5 | 5.0 | m/s 

### FW_P_LIM_MAX (`FLOAT`) {#FW_P_LIM_MAX}

Maximum pitch angle setpoint.

Applies in any altitude controlled flight mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 60.0 | 0.5 | 30.0 | deg 

### FW_P_LIM_MIN (`FLOAT`) {#FW_P_LIM_MIN}

Minimum pitch angle setpoint.

Applies in any altitude controlled flight mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -60.0 | 0.0 | 0.5 | -30.0 | deg 

### FW_THR_IDLE (`FLOAT`) {#FW_THR_IDLE}

Idle throttle.

This is the minimum throttle while on the ground ("landed") in auto modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.4 | 0.01 | 0.0 | norm 

### FW_THR_MAX (`FLOAT`) {#FW_THR_MAX}

Throttle limit max.

Applies in any altitude controlled flight mode. Should be set accordingly to achieve FW_T_CLMB_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 1.0 | norm 

### FW_THR_MIN (`FLOAT`) {#FW_THR_MIN}

Throttle limit min.

Applies in any altitude controlled flight mode. Usually set to 0 but can be increased to prevent the motor from stopping when descending, which can increase achievable descent rates.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.0 | norm 

### FW_THR_SLEW_MAX (`FLOAT`) {#FW_THR_SLEW_MAX}

Throttle max slew rate.

Maximum slew rate for the commanded throttle

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.0 |  

### FW_TKO_AIRSPD (`FLOAT`) {#FW_TKO_AIRSPD}

Takeoff Airspeed.

The calibrated airspeed setpoint during the takeoff climbout. If set <= 0, FW_AIRSPD_MIN will be set by default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  | 0.1 | -1.0 | m/s 

### FW_T_ALT_TC (`FLOAT`) {#FW_T_ALT_TC}

Altitude error time constant.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2.0 |  | 0.5 | 5.0 |  

### FW_T_CLMB_R_SP (`FLOAT`) {#FW_T_CLMB_R_SP}

Default target climbrate.

In auto modes: default climb rate output by controller to achieve altitude setpoints. In manual modes: maximum climb rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 15 | 0.01 | 3.0 | m/s 

### FW_T_F_ALT_ERR (`FLOAT`) {#FW_T_F_ALT_ERR}

Fast descend: minimum altitude error.

Minimum altitude error needed to descend with max airspeed and minimal throttle. A negative value disables fast descend.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  |  | -1.0 |  

### FW_T_HRATE_FF (`FLOAT`) {#FW_T_HRATE_FF}

Height rate feed forward.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.05 | 0.3 |  

### FW_T_I_GAIN_PIT (`FLOAT`) {#FW_T_I_GAIN_PIT}

Integrator gain pitch.

Increase it to trim out speed and height offsets faster, with the downside of possible overshoots and oscillations.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2.0 | 0.05 | 0.1 |  

### FW_T_PTCH_DAMP (`FLOAT`) {#FW_T_PTCH_DAMP}

Pitch damping gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2.0 | 0.1 | 0.1 |  

### FW_T_RLL2THR (`FLOAT`) {#FW_T_RLL2THR}

Roll -> Throttle feedforward.

Is used to compensate for the additional drag created by turning. Increase this gain if the aircraft initially loses energy in turns and reduce if the aircraft initially gains energy in turns.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 20.0 | 0.5 | 15.0 |  

### FW_T_SEB_R_FF (`FLOAT`) {#FW_T_SEB_R_FF}

Specific total energy balance rate feedforward gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 3 | 0.01 | 1.0 |  

### FW_T_SINK_MAX (`FLOAT`) {#FW_T_SINK_MAX}

Maximum descent rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 15.0 | 0.5 | 5.0 | m/s 

### FW_T_SINK_R_SP (`FLOAT`) {#FW_T_SINK_R_SP}

Default target sinkrate.

In auto modes: default sink rate output by controller to achieve altitude setpoints. In manual modes: maximum sink rate setpoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 15 | 0.01 | 2.0 | m/s 

### FW_T_SPDWEIGHT (`FLOAT`) {#FW_T_SPDWEIGHT}

Speed <--> Altitude weight.

Adjusts the amount of weighting that the pitch control applies to speed vs height errors. 0 -> control height only 2 -> control speed only (gliders)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2.0 | 1.0 | 1.0 |  

### FW_T_SPD_DEV_STD (`FLOAT`) {#FW_T_SPD_DEV_STD}

Airspeed rate measurement standard deviation.

For the airspeed filter in TECS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 10.0 | 0.1 | 0.2 | m/s^2 

### FW_T_SPD_PRC_STD (`FLOAT`) {#FW_T_SPD_PRC_STD}

Process noise standard deviation for the airspeed rate.

This is defining the noise in the airspeed rate for the constant airspeed rate model of the TECS airspeed filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 10.0 | 0.1 | 0.2 | m/s^2 

### FW_T_SPD_STD (`FLOAT`) {#FW_T_SPD_STD}

Airspeed measurement standard deviation.

For the airspeed filter in TECS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 10.0 | 0.1 | 0.07 | m/s 

### FW_T_STE_R_TC (`FLOAT`) {#FW_T_STE_R_TC}

Specific total energy rate first order filter time constant.

This filter is applied to the specific total energy rate used for throttle damping.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2 | 0.01 | 0.4 |  

### FW_T_TAS_TC (`FLOAT`) {#FW_T_TAS_TC}

True airspeed error time constant.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2.0 |  | 0.5 | 5.0 |  

### FW_T_THR_DAMPING (`FLOAT`) {#FW_T_THR_DAMPING}

Throttle damping factor.

This is the damping gain for the throttle demand loop.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.05 |  

### FW_T_THR_INTEG (`FLOAT`) {#FW_T_THR_INTEG}

Integrator gain throttle.

Increase it to trim out speed and height offsets faster, with the downside of possible overshoots and oscillations.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.005 | 0.02 |  

### FW_T_THR_LOW_HGT (`FLOAT`) {#FW_T_THR_LOW_HGT}

Low-height threshold for tighter altitude tracking.

Height above ground threshold below which tighter altitude tracking gets enabled (see FW_LND_THRTC_SC). Below this height, TECS smoothly (1 sec / sec) transitions the altitude tracking time constant from FW_T_ALT_TC to FW_LND_THRTC_SC*FW_T_ALT_TC. -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 1 | -1. | m 

### FW_T_VERT_ACC (`FLOAT`) {#FW_T_VERT_ACC}

Maximum vertical acceleration.

This is the maximum vertical acceleration either up or down that the controller will use to correct speed or height errors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10.0 | 0.5 | 7.0 | m/s^2 

### FW_WIND_ARSP_SC (`FLOAT`) {#FW_WIND_ARSP_SC}

Wind-based airspeed scaling factor.

Multiplying this factor with the current absolute wind estimate gives the airspeed offset added to the minimum airspeed setpoint limit. This helps to make the system more robust against disturbances (turbulence) in high wind.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.01 | 0. |  

## Failure Detector

### FD_ACT_EN (`INT32`) {#FD_ACT_EN}

Enable Actuator Failure check.

If enabled, failure detector will verify that for motors, a minimum amount of ESC current per throttle level is being consumed. Otherwise this indicates an motor failure.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### FD_ACT_MOT_C2T (`FLOAT`) {#FD_ACT_MOT_C2T}

Motor Failure Current/Throttle Threshold.

Motor failure triggers only below this current value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 50.0 | 1 | 2.0 | A/% 

### FD_ACT_MOT_THR (`FLOAT`) {#FD_ACT_MOT_THR}

Motor Failure Throttle Threshold.

Motor failure triggers only above this throttle value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.2 | norm 

### FD_ACT_MOT_TOUT (`INT32`) {#FD_ACT_MOT_TOUT}

Motor Failure Time Threshold.

Motor failure triggers only if the throttle threshold and the current to throttle threshold are violated for this time.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 10000 | 100 | 100 | ms 

### FD_ESCS_EN (`INT32`) {#FD_ESCS_EN}

Enable checks on ESCs that report their arming state.

If enabled, failure detector will verify that all the ESCs have successfully armed when the vehicle has transitioned to the armed state. Timeout for receiving an acknowledgement from the ESCs is 0.3s, if no feedback is received the failure detector will auto disarm the vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### FD_EXT_ATS_EN (`INT32`) {#FD_EXT_ATS_EN}

Enable PWM input on for engaging failsafe from an external automatic trigger system (ATS).

Enabled on either AUX5 or MAIN5 depending on board. External ATS is required by ASTM F3322-18.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### FD_EXT_ATS_TRIG (`INT32`) {#FD_EXT_ATS_TRIG}

The PWM threshold from external automatic trigger system for engaging failsafe.

External ATS is required by ASTM F3322-18.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1900 | us 

### FD_FAIL_P (`INT32`) {#FD_FAIL_P}

FailureDetector Max Pitch.

Maximum pitch angle before FailureDetector triggers the attitude_failure flag. The flag triggers flight termination (if @CBRK_FLIGHTTERM = 0), which sets outputs to their failsafe values. On takeoff the flag triggers lockdown (irrespective of @CBRK_FLIGHTTERM), which disarms motors but does not set outputs to failsafe values. Setting this parameter to 0 disables the check

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 180 |  | 60 | deg 

### FD_FAIL_P_TTRI (`FLOAT`) {#FD_FAIL_P_TTRI}

Pitch failure trigger time.

Seconds (decimal) that pitch has to exceed FD_FAIL_P before being considered as a failure.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.02 | 5 |  | 0.3 | s 

### FD_FAIL_R (`INT32`) {#FD_FAIL_R}

FailureDetector Max Roll.

Maximum roll angle before FailureDetector triggers the attitude_failure flag. The flag triggers flight termination (if @CBRK_FLIGHTTERM = 0), which sets outputs to their failsafe values. On takeoff the flag triggers lockdown (irrespective of @CBRK_FLIGHTTERM), which disarms motors but does not set outputs to failsafe values. Setting this parameter to 0 disables the check

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 180 |  | 60 | deg 

### FD_FAIL_R_TTRI (`FLOAT`) {#FD_FAIL_R_TTRI}

Roll failure trigger time.

Seconds (decimal) that roll has to exceed FD_FAIL_R before being considered as a failure.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.02 | 5 |  | 0.3 | s 

### FD_IMB_PROP_THR (`INT32`) {#FD_IMB_PROP_THR}

Imbalanced propeller check threshold.

Value at which the imbalanced propeller metric (based on horizontal and vertical acceleration variance) triggers a failure Setting this value to 0 disables the feature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1000 | 1 | 30 |  

## Flight Task Orbit

### MC_ORBIT_RAD_MAX (`FLOAT`) {#MC_ORBIT_RAD_MAX}

Maximum radius of orbit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10000.0 | 0.5 | 1000.0 | m 

### MC_ORBIT_YAW_MOD (`INT32`) {#MC_ORBIT_YAW_MOD}

Yaw behaviour during orbit flight.

**Values:**

- `0`: Front to Circle Center
- `1`: Hold Initial Heading
- `2`: Uncontrolled
- `3`: Hold Front Tangent to Circle
- `4`: RC Controlled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

## Follow target

### FLW_TGT_ALT_M (`INT32`) {#FLW_TGT_ALT_M}

Altitude control mode.

Maintain altitude or track target's altitude. When maintaining the altitude, the drone can crash into terrain when the target moves uphill. When tracking the target's altitude, the follow altitude FLW_TGT_HT should be high enough to prevent terrain collisions due to GPS inaccuracies of the target.

**Values:**

- `0`: 2D Tracking: Maintain constant altitude relative to home and track XY position only
- `1`: 2D + Terrain: Maintain constant altitude relative to terrain below and track XY position
- `2`: 3D Tracking: Track target's altitude (be aware that GPS altitude bias usually makes this useless)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### FLW_TGT_DST (`FLOAT`) {#FLW_TGT_DST}

Distance to follow target from.

The distance in meters to follow the target at

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 8.0 | m 

### FLW_TGT_FA (`FLOAT`) {#FLW_TGT_FA}

Follow Angle setting in degrees.

Angle to follow the target from. 0.0 Equals straight in front of the target's course (direction of motion) and the angle increases in clockwise direction, meaning Right-side would be 90.0 degrees while Left-side is -90.0 degrees Note: When the user force sets the angle out of the min/max range, it will be wrapped (e.g. 480 -> 120) in the range to gracefully handle the out of range.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 180.0 |  

### FLW_TGT_HT (`FLOAT`) {#FLW_TGT_HT}

Follow target height.

Following height above the target

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 8.0 |  |  | 8.0 | m 

### FLW_TGT_MAX_VEL (`FLOAT`) {#FLW_TGT_MAX_VEL}

Maximum tangential velocity setting for generating the follow orbit trajectory.

This is the maximum tangential velocity the drone will circle around the target whenever an orbit angle setpoint changes. Higher value means more aggressive follow behavior.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 20.0 |  | 5.0 |  

### FLW_TGT_RS (`FLOAT`) {#FLW_TGT_RS}

Responsiveness to target movement in Target Estimator.

lower values increase the responsiveness to changing position, but also ignore less noise

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 |  | 0.1 |  

## GPS

### GPS_1_CONFIG (`INT32`) {#GPS_1_CONFIG}

Serial Configuration for Main GPS.

Configure on which serial port to run Main GPS.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 201 |  

### GPS_1_GNSS (`INT32`) {#GPS_1_GNSS}

GNSS Systems for Primary GPS (integer bitmask).

This integer bitmask controls the set of GNSS systems used by the receiver. Check your receiver's documentation on how many systems are supported to be used in parallel. Currently this functionality is just implemented for u-blox receivers. When no bits are set, the receiver's default configuration should be used. Set bits true to enable: 0 : Use GPS (with QZSS) 1 : Use SBAS (multiple GPS augmentation systems) 2 : Use Galileo 3 : Use BeiDou 4 : Use GLONASS 5 : Use NAVIC

**Bitmask:**

- `0`: GPS (with QZSS)
- `1`: SBAS
- `2`: Galileo
- `3`: BeiDou
- `4`: GLONASS
- `5`: NAVIC


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 63 |  | 0 |  

### GPS_1_PROTOCOL (`INT32`) {#GPS_1_PROTOCOL}

Protocol for Main GPS.

Select the GPS protocol over serial. Auto-detection will probe all protocols, and thus is a bit slower.

**Values:**

- `0`: Auto detect
- `1`: u-blox
- `2`: MTK
- `3`: Ashtech / Trimble
- `4`: Emlid Reach
- `5`: Femtomes
- `6`: NMEA (generic)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 1 |  

### GPS_2_CONFIG (`INT32`) {#GPS_2_CONFIG}

Serial Configuration for Secondary GPS.

Configure on which serial port to run Secondary GPS.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### GPS_2_GNSS (`INT32`) {#GPS_2_GNSS}

GNSS Systems for Secondary GPS (integer bitmask).

This integer bitmask controls the set of GNSS systems used by the receiver. Check your receiver's documentation on how many systems are supported to be used in parallel. Currently this functionality is just implemented for u-blox receivers. When no bits are set, the receiver's default configuration should be used. Set bits true to enable: 0 : Use GPS (with QZSS) 1 : Use SBAS (multiple GPS augmentation systems) 2 : Use Galileo 3 : Use BeiDou 4 : Use GLONASS 5 : Use NAVIC

**Bitmask:**

- `0`: GPS (with QZSS)
- `1`: SBAS
- `2`: Galileo
- `3`: BeiDou
- `4`: GLONASS
- `5`: NAVIC


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 63 |  | 0 |  

### GPS_2_PROTOCOL (`INT32`) {#GPS_2_PROTOCOL}

Protocol for Secondary GPS.

Select the GPS protocol over serial. Auto-detection will probe all protocols, and thus is a bit slower.

**Values:**

- `0`: Auto detect
- `1`: u-blox
- `2`: MTK
- `3`: Ashtech / Trimble
- `4`: Emlid Reach
- `5`: Femtomes
- `6`: NMEA (generic)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 6 |  | 1 |  

### GPS_DUMP_COMM (`INT32`) {#GPS_DUMP_COMM}

Log GPS communication data.

If this is set to 1, all GPS communication data will be published via uORB, and written to the log file as gps_dump message. If this is set to 2, the main GPS is configured to output RTCM data, which is then logged as gps_dump and can be used for PPK.

**Values:**

- `0`: Disable
- `1`: Full communication
- `2`: RTCM output (PPK)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 0 |  

### GPS_SAT_INFO (`INT32`) {#GPS_SAT_INFO}

Enable sat info (if available).

Enable publication of satellite info (ORB_ID(satellite_info)) if possible. Not available on MTK.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### GPS_UBX_BAUD2 (`INT32`) {#GPS_UBX_BAUD2}

u-blox F9P UART2 Baudrate.

Select a baudrate for the F9P's UART2 port. In GPS_UBX_MODE 1, 2, and 3, the F9P's UART2 port is configured to send/receive RTCM corrections. Set this to 57600 if you want to attach a telemetry radio on UART2.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 |  |  | 230400 | B/s 

### GPS_UBX_CFG_INTF (`INT32`) {#GPS_UBX_CFG_INTF}

u-blox protocol configuration for interfaces.

**Bitmask:**

- `0`: Enable I2C input protocol UBX
- `1`: Enable I2C input protocol NMEA
- `2`: Enable I2C input protocol RTCM3X
- `3`: Enable I2C output protocol UBX
- `4`: Enable I2C output protocol NMEA
- `5`: Enable I2C output protocol RTCM3X


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 32 |  | 0 |  

### GPS_UBX_DYNMODEL (`INT32`) {#GPS_UBX_DYNMODEL}

u-blox GPS dynamic platform model.

u-blox receivers support different dynamic platform models to adjust the navigation engine to the expected application environment.

**Values:**

- `2`: stationary
- `4`: automotive
- `6`: airborne with <1g acceleration
- `7`: airborne with <2g acceleration
- `8`: airborne with <4g acceleration


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 9 |  | 7 |  

### GPS_UBX_MODE (`INT32`) {#GPS_UBX_MODE}

u-blox GPS Mode.

Select the u-blox configuration setup. Most setups will use the default, including RTK and dual GPS without heading. If rover has RTCM corrections from a static base (or other static correction source) coming in on UART2, then select Mode 5. The Heading mode requires 2 F9P devices to be attached. The main GPS will act as rover and output heading information, whereas the secondary will act as moving base. Modes 1 and 2 require each F9P UART1 to be connected to the Autopilot. In addition, UART2 on the F9P units are connected to each other. Modes 3 and 4 only require UART1 on each F9P connected to the Autopilot or Can Node. UART RX DMA is required. RTK is still possible with this setup.

**Values:**

- `0`: Default
- `1`: Heading (Rover With Moving Base UART1 Connected To Autopilot, UART2 Connected To Moving Base)
- `2`: Moving Base (UART1 Connected To Autopilot, UART2 Connected To Rover)
- `3`: Heading (Rover With Moving Base UART1 Connected to Autopilot Or Can Node At 921600)
- `4`: Moving Base (Moving Base UART1 Connected to Autopilot Or Can Node At 921600)
- `5`: Rover with Static Base on UART2 (similar to Default, except coming in on UART2)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### GPS_YAW_OFFSET (`FLOAT`) {#GPS_YAW_OFFSET}

Heading/Yaw offset for dual antenna GPS.

Heading offset angle for dual antenna GPS setups that support heading estimation. Set this to 0 if the antennas are parallel to the forward-facing direction of the vehicle and the rover (or Unicore primary) antenna is in front. The offset angle increases clockwise. Set this to 90 if the rover (or Unicore primary, or Septentrio Mosaic Aux) antenna is placed on the right side of the vehicle and the moving base antenna is on the left side. (Note: the Unicore primary antenna is the one connected on the right as seen from the top).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 360 |  | 0. | deg 

### PPS_CAP_ENABLE (`INT32`) {#PPS_CAP_ENABLE}

PPS Capture Enable.

Enables the PPS capture module. This switches mode of FMU channel 7 to be the PPS input channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

## Geofence

### GF_ACTION (`INT32`) {#GF_ACTION}

Geofence violation action.

Note: Setting this value to 4 enables flight termination, which will kill the vehicle on violation of the fence.

**Values:**

- `0`: None
- `1`: Warning
- `2`: Hold mode
- `3`: Return mode
- `4`: Terminate
- `5`: Land mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 5 |  | 2 |  

### GF_MAX_HOR_DIST (`FLOAT`) {#GF_MAX_HOR_DIST}

Max horizontal distance from Home.

Maximum horizontal distance in meters the vehicle can be from Home before triggering a geofence action. Disabled if 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10000 | 1 | 0.0 | m 

### GF_MAX_VER_DIST (`FLOAT`) {#GF_MAX_VER_DIST}

Max vertical distance from Home.

Maximum vertical distance in meters the vehicle can be from Home before triggering a geofence action. Disabled if 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10000 | 1 | 0.0 | m 

### GF_PREDICT (`INT32`) {#GF_PREDICT}

[EXPERIMENTAL] Use Pre-emptive geofence triggering.

WARNING: This experimental feature may cause flyaways. Use at your own risk. Predict the motion of the vehicle and trigger the breach if it is determined that the current trajectory would result in a breach happening before the vehicle can make evasive maneuvers. The vehicle is then re-routed to a safe hold position (stop for multirotor, loiter for fixed wing).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### GF_SOURCE (`INT32`) {#GF_SOURCE}

Geofence source.

Select which position source should be used. Selecting GPS instead of global position makes sure that there is no dependence on the position estimator 0 = global position, 1 = GPS

**Values:**

- `0`: GPOS
- `1`: GPS


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

## Geometry

### CA_AIRFRAME (`INT32`) {#CA_AIRFRAME}

Airframe selection.

Defines which mixer implementation to use. Some are generic, while others are specifically fit to a certain vehicle with a fixed set of actuators. 'Custom' should only be used if noting else can be used.

**Values:**

- `0`: Multirotor
- `1`: Fixed-wing
- `2`: Standard VTOL
- `3`: Tiltrotor VTOL
- `4`: Tailsitter VTOL
- `5`: Rover (Ackermann)
- `6`: Rover (Differential)
- `7`: Motors (6DOF)
- `8`: Multirotor with Tilt
- `9`: Custom
- `10`: Helicopter (tail ESC)
- `11`: Helicopter (tail Servo)
- `12`: Helicopter (Coaxial)
- `13`: Rover (Mecanum)
- `14`: Spacecraft 2D
- `15`: Spacecraft 3D


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_FAILURE_MODE (`INT32`) {#CA_FAILURE_MODE}

Motor failure handling mode.

This is used to specify how to handle motor failures reported by failure detector.

**Values:**

- `0`: Ignore
- `1`: Remove first failed motor from effectiveness


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_HELI_PITCH_C0 (`FLOAT`) {#CA_HELI_PITCH_C0}

Collective pitch curve at position 0.

Defines the collective pitch at the interval position 0 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.1 | -0.05 |  

### CA_HELI_PITCH_C1 (`FLOAT`) {#CA_HELI_PITCH_C1}

Collective pitch curve at position 1.

Defines the collective pitch at the interval position 1 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.1 | 0.0725 |  

### CA_HELI_PITCH_C2 (`FLOAT`) {#CA_HELI_PITCH_C2}

Collective pitch curve at position 2.

Defines the collective pitch at the interval position 2 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.1 | 0.2 |  

### CA_HELI_PITCH_C3 (`FLOAT`) {#CA_HELI_PITCH_C3}

Collective pitch curve at position 3.

Defines the collective pitch at the interval position 3 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.1 | 0.325 |  

### CA_HELI_PITCH_C4 (`FLOAT`) {#CA_HELI_PITCH_C4}

Collective pitch curve at position 4.

Defines the collective pitch at the interval position 4 for a given thrust setpoint. Use negative values if the swash plate needs to move down to provide upwards thrust.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.1 | 0.45 |  

### CA_HELI_RPM_I (`FLOAT`) {#CA_HELI_RPM_I}

Integral gain for rpm control.

Same definition as the proportional gain but for integral.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 0.0 |  

### CA_HELI_RPM_P (`FLOAT`) {#CA_HELI_RPM_P}

Proportional gain for rpm control.

Ratio between rpm error devided by 1000 to how much normalized output gets added to correct for it. motor_command = throttle_curve + CA_HELI_RPM_P * (rpm_setpoint - rpm_measurement) / 1000

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 0.0 |  

### CA_HELI_RPM_SP (`FLOAT`) {#CA_HELI_RPM_SP}

Setpoint for main rotor rpm.

Requires rpm feedback for the controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 100 | 10000 | 1 | 1500 |  

### CA_HELI_THR_C0 (`FLOAT`) {#CA_HELI_THR_C0}

Throttle curve at position 0.

Defines the output throttle at the interval position 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.1 | 1 |  

### CA_HELI_THR_C1 (`FLOAT`) {#CA_HELI_THR_C1}

Throttle curve at position 1.

Defines the output throttle at the interval position 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.1 | 1 |  

### CA_HELI_THR_C2 (`FLOAT`) {#CA_HELI_THR_C2}

Throttle curve at position 2.

Defines the output throttle at the interval position 2.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.1 | 1 |  

### CA_HELI_THR_C3 (`FLOAT`) {#CA_HELI_THR_C3}

Throttle curve at position 3.

Defines the output throttle at the interval position 3.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.1 | 1 |  

### CA_HELI_THR_C4 (`FLOAT`) {#CA_HELI_THR_C4}

Throttle curve at position 4.

Defines the output throttle at the interval position 4.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.1 | 1 |  

### CA_HELI_YAW_CCW (`INT32`) {#CA_HELI_YAW_CCW}

Main rotor turns counter-clockwise.

Default configuration is for a clockwise turning main rotor and positive thrust of the tail rotor is expected to rotate the vehicle clockwise. Set this parameter to true if the tail rotor provides thrust in counter-clockwise direction which is mostly the case when the main rotor turns counter-clockwise.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### CA_HELI_YAW_CP_O (`FLOAT`) {#CA_HELI_YAW_CP_O}

Offset for yaw compensation based on collective pitch.

This allows to specify which collective pitch command results in the least amount of rotor drag. This is used to increase the accuracy of the yaw drag torque compensation based on collective pitch by aligning the lowest rotor drag with zero compensation. For symmetric profile blades this is the command that results in exactly 0° collective blade angle. For lift profile blades this is typically a command resulting in slightly negative collective blade angle. tail_output += CA_HELI_YAW_CP_S * abs(collective_pitch - CA_HELI_YAW_CP_O)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -2 | 2 | 0.1 | 0.0 |  

### CA_HELI_YAW_CP_S (`FLOAT`) {#CA_HELI_YAW_CP_S}

Scale for yaw compensation based on collective pitch.

This allows to add a proportional factor of the collective pitch command to the yaw command. A negative value is needed when positive thrust of the tail rotor rotates the vehicle opposite to the main rotor turn direction. tail_output += CA_HELI_YAW_CP_S * abs(collective_pitch - CA_HELI_YAW_CP_O)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -2 | 2 | 0.1 | 0.0 |  

### CA_HELI_YAW_TH_S (`FLOAT`) {#CA_HELI_YAW_TH_S}

Scale for yaw compensation based on throttle.

This allows to add a proportional factor of the throttle command to the yaw command. A negative value is needed when positive thrust of the tail rotor rotates the vehicle opposite to the main rotor turn direction. tail_output += CA_HELI_YAW_TH_S * throttle

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -2 | 2 | 0.1 | 0.0 |  

### CA_MAX_SVO_THROW (`FLOAT`) {#CA_MAX_SVO_THROW}

Throw angle of swashplate servo at maximum commands for linearization.

Used to linearize mechanical output of swashplate servos to avoid axis coupling and binding with 4 servo redundancy. This requires a symmetric setup where the servo horn is exactly centered with a 0 command. Setting to zero disables feature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 75 | 0.1 | 0.0 | deg 

### CA_METHOD (`INT32`) {#CA_METHOD}

Control allocation method.

Selects the algorithm and desaturation method. If set to Automtic, the selection is based on the airframe (CA_AIRFRAME).

**Values:**

- `0`: Pseudo-inverse with output clipping
- `1`: Pseudo-inverse with sequential desaturation technique
- `2`: Automatic


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### CA_R0_SLEW (`FLOAT`) {#CA_R0_SLEW}

Motor 0 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R10_SLEW (`FLOAT`) {#CA_R10_SLEW}

Motor 10 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R11_SLEW (`FLOAT`) {#CA_R11_SLEW}

Motor 11 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R1_SLEW (`FLOAT`) {#CA_R1_SLEW}

Motor 1 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R2_SLEW (`FLOAT`) {#CA_R2_SLEW}

Motor 2 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R3_SLEW (`FLOAT`) {#CA_R3_SLEW}

Motor 3 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R4_SLEW (`FLOAT`) {#CA_R4_SLEW}

Motor 4 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R5_SLEW (`FLOAT`) {#CA_R5_SLEW}

Motor 5 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R6_SLEW (`FLOAT`) {#CA_R6_SLEW}

Motor 6 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R7_SLEW (`FLOAT`) {#CA_R7_SLEW}

Motor 7 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R8_SLEW (`FLOAT`) {#CA_R8_SLEW}

Motor 8 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_R9_SLEW (`FLOAT`) {#CA_R9_SLEW}

Motor 9 slew rate limit.

Forces the motor output signal to take at least the configured time (in seconds) to traverse its full range (normally [0, 1], or if reversible [-1, 1]). Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.01 | 0.0 | s 

### CA_ROTOR0_AX (`FLOAT`) {#CA_ROTOR0_AX}

Axis of rotor 0 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR0_AY (`FLOAT`) {#CA_ROTOR0_AY}

Axis of rotor 0 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR0_AZ (`FLOAT`) {#CA_ROTOR0_AZ}

Axis of rotor 0 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR0_CT (`FLOAT`) {#CA_ROTOR0_CT}

Thrust coefficient of rotor 0.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR0_KM (`FLOAT`) {#CA_ROTOR0_KM}

Moment coefficient of rotor 0.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR0_PX (`FLOAT`) {#CA_ROTOR0_PX}

Position of rotor 0 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR0_PY (`FLOAT`) {#CA_ROTOR0_PY}

Position of rotor 0 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR0_PZ (`FLOAT`) {#CA_ROTOR0_PZ}

Position of rotor 0 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR0_TILT (`INT32`) {#CA_ROTOR0_TILT}

Rotor 0 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR10_AX (`FLOAT`) {#CA_ROTOR10_AX}

Axis of rotor 10 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR10_AY (`FLOAT`) {#CA_ROTOR10_AY}

Axis of rotor 10 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR10_AZ (`FLOAT`) {#CA_ROTOR10_AZ}

Axis of rotor 10 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR10_CT (`FLOAT`) {#CA_ROTOR10_CT}

Thrust coefficient of rotor 10.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR10_KM (`FLOAT`) {#CA_ROTOR10_KM}

Moment coefficient of rotor 10.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR10_PX (`FLOAT`) {#CA_ROTOR10_PX}

Position of rotor 10 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR10_PY (`FLOAT`) {#CA_ROTOR10_PY}

Position of rotor 10 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR10_PZ (`FLOAT`) {#CA_ROTOR10_PZ}

Position of rotor 10 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR10_TILT (`INT32`) {#CA_ROTOR10_TILT}

Rotor 10 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR11_AX (`FLOAT`) {#CA_ROTOR11_AX}

Axis of rotor 11 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR11_AY (`FLOAT`) {#CA_ROTOR11_AY}

Axis of rotor 11 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR11_AZ (`FLOAT`) {#CA_ROTOR11_AZ}

Axis of rotor 11 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR11_CT (`FLOAT`) {#CA_ROTOR11_CT}

Thrust coefficient of rotor 11.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR11_KM (`FLOAT`) {#CA_ROTOR11_KM}

Moment coefficient of rotor 11.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR11_PX (`FLOAT`) {#CA_ROTOR11_PX}

Position of rotor 11 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR11_PY (`FLOAT`) {#CA_ROTOR11_PY}

Position of rotor 11 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR11_PZ (`FLOAT`) {#CA_ROTOR11_PZ}

Position of rotor 11 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR11_TILT (`INT32`) {#CA_ROTOR11_TILT}

Rotor 11 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR1_AX (`FLOAT`) {#CA_ROTOR1_AX}

Axis of rotor 1 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR1_AY (`FLOAT`) {#CA_ROTOR1_AY}

Axis of rotor 1 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR1_AZ (`FLOAT`) {#CA_ROTOR1_AZ}

Axis of rotor 1 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR1_CT (`FLOAT`) {#CA_ROTOR1_CT}

Thrust coefficient of rotor 1.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR1_KM (`FLOAT`) {#CA_ROTOR1_KM}

Moment coefficient of rotor 1.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR1_PX (`FLOAT`) {#CA_ROTOR1_PX}

Position of rotor 1 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR1_PY (`FLOAT`) {#CA_ROTOR1_PY}

Position of rotor 1 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR1_PZ (`FLOAT`) {#CA_ROTOR1_PZ}

Position of rotor 1 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR1_TILT (`INT32`) {#CA_ROTOR1_TILT}

Rotor 1 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR2_AX (`FLOAT`) {#CA_ROTOR2_AX}

Axis of rotor 2 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR2_AY (`FLOAT`) {#CA_ROTOR2_AY}

Axis of rotor 2 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR2_AZ (`FLOAT`) {#CA_ROTOR2_AZ}

Axis of rotor 2 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR2_CT (`FLOAT`) {#CA_ROTOR2_CT}

Thrust coefficient of rotor 2.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR2_KM (`FLOAT`) {#CA_ROTOR2_KM}

Moment coefficient of rotor 2.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR2_PX (`FLOAT`) {#CA_ROTOR2_PX}

Position of rotor 2 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR2_PY (`FLOAT`) {#CA_ROTOR2_PY}

Position of rotor 2 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR2_PZ (`FLOAT`) {#CA_ROTOR2_PZ}

Position of rotor 2 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR2_TILT (`INT32`) {#CA_ROTOR2_TILT}

Rotor 2 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR3_AX (`FLOAT`) {#CA_ROTOR3_AX}

Axis of rotor 3 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR3_AY (`FLOAT`) {#CA_ROTOR3_AY}

Axis of rotor 3 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR3_AZ (`FLOAT`) {#CA_ROTOR3_AZ}

Axis of rotor 3 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR3_CT (`FLOAT`) {#CA_ROTOR3_CT}

Thrust coefficient of rotor 3.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR3_KM (`FLOAT`) {#CA_ROTOR3_KM}

Moment coefficient of rotor 3.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR3_PX (`FLOAT`) {#CA_ROTOR3_PX}

Position of rotor 3 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR3_PY (`FLOAT`) {#CA_ROTOR3_PY}

Position of rotor 3 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR3_PZ (`FLOAT`) {#CA_ROTOR3_PZ}

Position of rotor 3 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR3_TILT (`INT32`) {#CA_ROTOR3_TILT}

Rotor 3 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR4_AX (`FLOAT`) {#CA_ROTOR4_AX}

Axis of rotor 4 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR4_AY (`FLOAT`) {#CA_ROTOR4_AY}

Axis of rotor 4 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR4_AZ (`FLOAT`) {#CA_ROTOR4_AZ}

Axis of rotor 4 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR4_CT (`FLOAT`) {#CA_ROTOR4_CT}

Thrust coefficient of rotor 4.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR4_KM (`FLOAT`) {#CA_ROTOR4_KM}

Moment coefficient of rotor 4.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR4_PX (`FLOAT`) {#CA_ROTOR4_PX}

Position of rotor 4 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR4_PY (`FLOAT`) {#CA_ROTOR4_PY}

Position of rotor 4 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR4_PZ (`FLOAT`) {#CA_ROTOR4_PZ}

Position of rotor 4 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR4_TILT (`INT32`) {#CA_ROTOR4_TILT}

Rotor 4 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR5_AX (`FLOAT`) {#CA_ROTOR5_AX}

Axis of rotor 5 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR5_AY (`FLOAT`) {#CA_ROTOR5_AY}

Axis of rotor 5 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR5_AZ (`FLOAT`) {#CA_ROTOR5_AZ}

Axis of rotor 5 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR5_CT (`FLOAT`) {#CA_ROTOR5_CT}

Thrust coefficient of rotor 5.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR5_KM (`FLOAT`) {#CA_ROTOR5_KM}

Moment coefficient of rotor 5.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR5_PX (`FLOAT`) {#CA_ROTOR5_PX}

Position of rotor 5 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR5_PY (`FLOAT`) {#CA_ROTOR5_PY}

Position of rotor 5 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR5_PZ (`FLOAT`) {#CA_ROTOR5_PZ}

Position of rotor 5 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR5_TILT (`INT32`) {#CA_ROTOR5_TILT}

Rotor 5 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR6_AX (`FLOAT`) {#CA_ROTOR6_AX}

Axis of rotor 6 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR6_AY (`FLOAT`) {#CA_ROTOR6_AY}

Axis of rotor 6 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR6_AZ (`FLOAT`) {#CA_ROTOR6_AZ}

Axis of rotor 6 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR6_CT (`FLOAT`) {#CA_ROTOR6_CT}

Thrust coefficient of rotor 6.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR6_KM (`FLOAT`) {#CA_ROTOR6_KM}

Moment coefficient of rotor 6.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR6_PX (`FLOAT`) {#CA_ROTOR6_PX}

Position of rotor 6 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR6_PY (`FLOAT`) {#CA_ROTOR6_PY}

Position of rotor 6 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR6_PZ (`FLOAT`) {#CA_ROTOR6_PZ}

Position of rotor 6 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR6_TILT (`INT32`) {#CA_ROTOR6_TILT}

Rotor 6 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR7_AX (`FLOAT`) {#CA_ROTOR7_AX}

Axis of rotor 7 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR7_AY (`FLOAT`) {#CA_ROTOR7_AY}

Axis of rotor 7 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR7_AZ (`FLOAT`) {#CA_ROTOR7_AZ}

Axis of rotor 7 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR7_CT (`FLOAT`) {#CA_ROTOR7_CT}

Thrust coefficient of rotor 7.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR7_KM (`FLOAT`) {#CA_ROTOR7_KM}

Moment coefficient of rotor 7.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR7_PX (`FLOAT`) {#CA_ROTOR7_PX}

Position of rotor 7 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR7_PY (`FLOAT`) {#CA_ROTOR7_PY}

Position of rotor 7 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR7_PZ (`FLOAT`) {#CA_ROTOR7_PZ}

Position of rotor 7 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR7_TILT (`INT32`) {#CA_ROTOR7_TILT}

Rotor 7 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR8_AX (`FLOAT`) {#CA_ROTOR8_AX}

Axis of rotor 8 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR8_AY (`FLOAT`) {#CA_ROTOR8_AY}

Axis of rotor 8 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR8_AZ (`FLOAT`) {#CA_ROTOR8_AZ}

Axis of rotor 8 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR8_CT (`FLOAT`) {#CA_ROTOR8_CT}

Thrust coefficient of rotor 8.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR8_KM (`FLOAT`) {#CA_ROTOR8_KM}

Moment coefficient of rotor 8.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR8_PX (`FLOAT`) {#CA_ROTOR8_PX}

Position of rotor 8 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR8_PY (`FLOAT`) {#CA_ROTOR8_PY}

Position of rotor 8 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR8_PZ (`FLOAT`) {#CA_ROTOR8_PZ}

Position of rotor 8 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR8_TILT (`INT32`) {#CA_ROTOR8_TILT}

Rotor 8 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR9_AX (`FLOAT`) {#CA_ROTOR9_AX}

Axis of rotor 9 thrust vector, X body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR9_AY (`FLOAT`) {#CA_ROTOR9_AY}

Axis of rotor 9 thrust vector, Y body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 |  

### CA_ROTOR9_AZ (`FLOAT`) {#CA_ROTOR9_AZ}

Axis of rotor 9 thrust vector, Z body axis component.

Only the direction is considered (the vector is normalized).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | -1.0 |  

### CA_ROTOR9_CT (`FLOAT`) {#CA_ROTOR9_CT}

Thrust coefficient of rotor 9.

The thrust coefficient if defined as Thrust = CT * u^2, where u (with value between actuator minimum and maximum) is the output signal sent to the motor controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 1 | 6.5 |  

### CA_ROTOR9_KM (`FLOAT`) {#CA_ROTOR9_KM}

Moment coefficient of rotor 9.

The moment coefficient if defined as Torque = KM * Thrust. Use a positive value for a rotor with CCW rotation. Use a negative value for a rotor with CW rotation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.01 | 0.05 |  

### CA_ROTOR9_PX (`FLOAT`) {#CA_ROTOR9_PX}

Position of rotor 9 along X body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR9_PY (`FLOAT`) {#CA_ROTOR9_PY}

Position of rotor 9 along Y body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR9_PZ (`FLOAT`) {#CA_ROTOR9_PZ}

Position of rotor 9 along Z body axis relative to center of gravity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -100 | 100 | 0.1 | 0.0 | m 

### CA_ROTOR9_TILT (`INT32`) {#CA_ROTOR9_TILT}

Rotor 9 tilt assignment.

If not set to None, this motor is tilted by the configured tilt servo.

**Values:**

- `0`: None
- `1`: Tilt 1
- `2`: Tilt 2
- `3`: Tilt 3
- `4`: Tilt 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_ROTOR_COUNT (`INT32`) {#CA_ROTOR_COUNT}

Total number of rotors.

**Values:**

- `0`: 0
- `1`: 1
- `2`: 2
- `3`: 3
- `4`: 4
- `5`: 5
- `6`: 6
- `7`: 7
- `8`: 8
- `9`: 9
- `10`: 10
- `11`: 11
- `12`: 12


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_R_REV (`INT32`) {#CA_R_REV}

Bidirectional/Reversible motors.

Configure motors to be bidirectional/reversible. Note that the output driver needs to support this as well.

**Bitmask:**

- `0`: Motor 1
- `1`: Motor 2
- `2`: Motor 3
- `3`: Motor 4
- `4`: Motor 5
- `5`: Motor 6
- `6`: Motor 7
- `7`: Motor 8
- `8`: Motor 9
- `9`: Motor 10
- `10`: Motor 11
- `11`: Motor 12


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4095 |  | 0 |  

### CA_SP0_ANG0 (`FLOAT`) {#CA_SP0_ANG0}

Angle for swash plate servo 0.

The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 360 | 10 | 0 | deg 

### CA_SP0_ANG1 (`FLOAT`) {#CA_SP0_ANG1}

Angle for swash plate servo 1.

The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 360 | 10 | 140 | deg 

### CA_SP0_ANG2 (`FLOAT`) {#CA_SP0_ANG2}

Angle for swash plate servo 2.

The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 360 | 10 | 220 | deg 

### CA_SP0_ANG3 (`FLOAT`) {#CA_SP0_ANG3}

Angle for swash plate servo 3.

The angle is measured clockwise (as seen from top), with 0 pointing forwards (X axis).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 360 | 10 | 0 | deg 

### CA_SP0_ARM_L0 (`FLOAT`) {#CA_SP0_ARM_L0}

Arm length for swash plate servo 0.

This is relative to the other arm lengths.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 1.0 |  

### CA_SP0_ARM_L1 (`FLOAT`) {#CA_SP0_ARM_L1}

Arm length for swash plate servo 1.

This is relative to the other arm lengths.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 1.0 |  

### CA_SP0_ARM_L2 (`FLOAT`) {#CA_SP0_ARM_L2}

Arm length for swash plate servo 2.

This is relative to the other arm lengths.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 1.0 |  

### CA_SP0_ARM_L3 (`FLOAT`) {#CA_SP0_ARM_L3}

Arm length for swash plate servo 3.

This is relative to the other arm lengths.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 1.0 |  

### CA_SP0_COUNT (`INT32`) {#CA_SP0_COUNT}

Number of swash plates servos.

**Values:**

- `2`: 2
- `3`: 3
- `4`: 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 3 |  

### CA_SV0_SLEW (`FLOAT`) {#CA_SV0_SLEW}

Servo 0 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV1_SLEW (`FLOAT`) {#CA_SV1_SLEW}

Servo 1 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV2_SLEW (`FLOAT`) {#CA_SV2_SLEW}

Servo 2 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV3_SLEW (`FLOAT`) {#CA_SV3_SLEW}

Servo 3 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV4_SLEW (`FLOAT`) {#CA_SV4_SLEW}

Servo 4 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV5_SLEW (`FLOAT`) {#CA_SV5_SLEW}

Servo 5 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV6_SLEW (`FLOAT`) {#CA_SV6_SLEW}

Servo 6 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV7_SLEW (`FLOAT`) {#CA_SV7_SLEW}

Servo 7 slew rate limit.

Forces the servo output signal to take at least the configured time (in seconds) to traverse its full range [-100%, 100%]. Zero means that slew rate limiting is disabled.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.05 | 0.0 | s 

### CA_SV_CS0_FLAP (`FLOAT`) {#CA_SV_CS0_FLAP}

Control Surface 0 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS0_SPOIL (`FLOAT`) {#CA_SV_CS0_SPOIL}

Control Surface 0 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS0_TRIM (`FLOAT`) {#CA_SV_CS0_TRIM}

Control Surface 0 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS0_TRQ_P (`FLOAT`) {#CA_SV_CS0_TRQ_P}

Control Surface 0 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS0_TRQ_R (`FLOAT`) {#CA_SV_CS0_TRQ_R}

Control Surface 0 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS0_TRQ_Y (`FLOAT`) {#CA_SV_CS0_TRQ_Y}

Control Surface 0 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS0_TYPE (`INT32`) {#CA_SV_CS0_TYPE}

Control Surface 0 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS1_FLAP (`FLOAT`) {#CA_SV_CS1_FLAP}

Control Surface 1 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS1_SPOIL (`FLOAT`) {#CA_SV_CS1_SPOIL}

Control Surface 1 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS1_TRIM (`FLOAT`) {#CA_SV_CS1_TRIM}

Control Surface 1 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS1_TRQ_P (`FLOAT`) {#CA_SV_CS1_TRQ_P}

Control Surface 1 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS1_TRQ_R (`FLOAT`) {#CA_SV_CS1_TRQ_R}

Control Surface 1 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS1_TRQ_Y (`FLOAT`) {#CA_SV_CS1_TRQ_Y}

Control Surface 1 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS1_TYPE (`INT32`) {#CA_SV_CS1_TYPE}

Control Surface 1 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS2_FLAP (`FLOAT`) {#CA_SV_CS2_FLAP}

Control Surface 2 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS2_SPOIL (`FLOAT`) {#CA_SV_CS2_SPOIL}

Control Surface 2 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS2_TRIM (`FLOAT`) {#CA_SV_CS2_TRIM}

Control Surface 2 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS2_TRQ_P (`FLOAT`) {#CA_SV_CS2_TRQ_P}

Control Surface 2 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS2_TRQ_R (`FLOAT`) {#CA_SV_CS2_TRQ_R}

Control Surface 2 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS2_TRQ_Y (`FLOAT`) {#CA_SV_CS2_TRQ_Y}

Control Surface 2 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS2_TYPE (`INT32`) {#CA_SV_CS2_TYPE}

Control Surface 2 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS3_FLAP (`FLOAT`) {#CA_SV_CS3_FLAP}

Control Surface 3 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS3_SPOIL (`FLOAT`) {#CA_SV_CS3_SPOIL}

Control Surface 3 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS3_TRIM (`FLOAT`) {#CA_SV_CS3_TRIM}

Control Surface 3 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS3_TRQ_P (`FLOAT`) {#CA_SV_CS3_TRQ_P}

Control Surface 3 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS3_TRQ_R (`FLOAT`) {#CA_SV_CS3_TRQ_R}

Control Surface 3 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS3_TRQ_Y (`FLOAT`) {#CA_SV_CS3_TRQ_Y}

Control Surface 3 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS3_TYPE (`INT32`) {#CA_SV_CS3_TYPE}

Control Surface 3 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS4_FLAP (`FLOAT`) {#CA_SV_CS4_FLAP}

Control Surface 4 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS4_SPOIL (`FLOAT`) {#CA_SV_CS4_SPOIL}

Control Surface 4 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS4_TRIM (`FLOAT`) {#CA_SV_CS4_TRIM}

Control Surface 4 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS4_TRQ_P (`FLOAT`) {#CA_SV_CS4_TRQ_P}

Control Surface 4 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS4_TRQ_R (`FLOAT`) {#CA_SV_CS4_TRQ_R}

Control Surface 4 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS4_TRQ_Y (`FLOAT`) {#CA_SV_CS4_TRQ_Y}

Control Surface 4 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS4_TYPE (`INT32`) {#CA_SV_CS4_TYPE}

Control Surface 4 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS5_FLAP (`FLOAT`) {#CA_SV_CS5_FLAP}

Control Surface 5 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS5_SPOIL (`FLOAT`) {#CA_SV_CS5_SPOIL}

Control Surface 5 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS5_TRIM (`FLOAT`) {#CA_SV_CS5_TRIM}

Control Surface 5 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS5_TRQ_P (`FLOAT`) {#CA_SV_CS5_TRQ_P}

Control Surface 5 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS5_TRQ_R (`FLOAT`) {#CA_SV_CS5_TRQ_R}

Control Surface 5 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS5_TRQ_Y (`FLOAT`) {#CA_SV_CS5_TRQ_Y}

Control Surface 5 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS5_TYPE (`INT32`) {#CA_SV_CS5_TYPE}

Control Surface 5 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS6_FLAP (`FLOAT`) {#CA_SV_CS6_FLAP}

Control Surface 6 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS6_SPOIL (`FLOAT`) {#CA_SV_CS6_SPOIL}

Control Surface 6 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS6_TRIM (`FLOAT`) {#CA_SV_CS6_TRIM}

Control Surface 6 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS6_TRQ_P (`FLOAT`) {#CA_SV_CS6_TRQ_P}

Control Surface 6 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS6_TRQ_R (`FLOAT`) {#CA_SV_CS6_TRQ_R}

Control Surface 6 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS6_TRQ_Y (`FLOAT`) {#CA_SV_CS6_TRQ_Y}

Control Surface 6 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS6_TYPE (`INT32`) {#CA_SV_CS6_TYPE}

Control Surface 6 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS7_FLAP (`FLOAT`) {#CA_SV_CS7_FLAP}

Control Surface 7 configuration as flap.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS7_SPOIL (`FLOAT`) {#CA_SV_CS7_SPOIL}

Control Surface 7 configuration as spoiler.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0 |  

### CA_SV_CS7_TRIM (`FLOAT`) {#CA_SV_CS7_TRIM}

Control Surface 7 trim.

Can be used to add an offset to the servo control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 0.0 |  

### CA_SV_CS7_TRQ_P (`FLOAT`) {#CA_SV_CS7_TRQ_P}

Control Surface 7 pitch torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS7_TRQ_R (`FLOAT`) {#CA_SV_CS7_TRQ_R}

Control Surface 7 roll torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS7_TRQ_Y (`FLOAT`) {#CA_SV_CS7_TRQ_Y}

Control Surface 7 yaw torque scaling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CA_SV_CS7_TYPE (`INT32`) {#CA_SV_CS7_TYPE}

Control Surface 7 type.

**Values:**

- `0`: (Not set)
- `1`: Left Aileron
- `2`: Right Aileron
- `3`: Elevator
- `4`: Rudder
- `5`: Left Elevon
- `6`: Right Elevon
- `7`: Left V-Tail
- `8`: Right V-Tail
- `9`: Left Flap
- `10`: Right Flap
- `11`: Airbrake
- `12`: Custom
- `13`: Left A-tail
- `14`: Right A-tail
- `15`: Single Channel Aileron
- `16`: Steering Wheel
- `17`: Left Spoiler
- `18`: Right Spoiler


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_CS_COUNT (`INT32`) {#CA_SV_CS_COUNT}

Total number of Control Surfaces.

**Values:**

- `0`: 0
- `1`: 1
- `2`: 2
- `3`: 3
- `4`: 4
- `5`: 5
- `6`: 6
- `7`: 7
- `8`: 8


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CA_SV_TL0_CT (`INT32`) {#CA_SV_TL0_CT}

Tilt 0 is used for control.

Define if this servo is used for additional control.

**Values:**

- `0`: None
- `1`: Yaw
- `2`: Pitch
- `3`: Yaw and Pitch


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### CA_SV_TL0_MAXA (`FLOAT`) {#CA_SV_TL0_MAXA}

Tilt Servo 0 Tilt Angle at Maximum.

Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 90.0 | deg 

### CA_SV_TL0_MINA (`FLOAT`) {#CA_SV_TL0_MINA}

Tilt Servo 0 Tilt Angle at Minimum.

Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 0.0 | deg 

### CA_SV_TL0_TD (`INT32`) {#CA_SV_TL0_TD}

Tilt Servo 0 Tilt Direction.

Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction 'Towards Front', the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.

**Values:**

- `0`: Towards Front
- `90`: Towards Right


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 359 |  | 0 |  

### CA_SV_TL1_CT (`INT32`) {#CA_SV_TL1_CT}

Tilt 1 is used for control.

Define if this servo is used for additional control.

**Values:**

- `0`: None
- `1`: Yaw
- `2`: Pitch
- `3`: Yaw and Pitch


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### CA_SV_TL1_MAXA (`FLOAT`) {#CA_SV_TL1_MAXA}

Tilt Servo 1 Tilt Angle at Maximum.

Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 90.0 | deg 

### CA_SV_TL1_MINA (`FLOAT`) {#CA_SV_TL1_MINA}

Tilt Servo 1 Tilt Angle at Minimum.

Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 0.0 | deg 

### CA_SV_TL1_TD (`INT32`) {#CA_SV_TL1_TD}

Tilt Servo 1 Tilt Direction.

Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction 'Towards Front', the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.

**Values:**

- `0`: Towards Front
- `90`: Towards Right


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 359 |  | 0 |  

### CA_SV_TL2_CT (`INT32`) {#CA_SV_TL2_CT}

Tilt 2 is used for control.

Define if this servo is used for additional control.

**Values:**

- `0`: None
- `1`: Yaw
- `2`: Pitch
- `3`: Yaw and Pitch


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### CA_SV_TL2_MAXA (`FLOAT`) {#CA_SV_TL2_MAXA}

Tilt Servo 2 Tilt Angle at Maximum.

Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 90.0 | deg 

### CA_SV_TL2_MINA (`FLOAT`) {#CA_SV_TL2_MINA}

Tilt Servo 2 Tilt Angle at Minimum.

Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 0.0 | deg 

### CA_SV_TL2_TD (`INT32`) {#CA_SV_TL2_TD}

Tilt Servo 2 Tilt Direction.

Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction 'Towards Front', the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.

**Values:**

- `0`: Towards Front
- `90`: Towards Right


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 359 |  | 0 |  

### CA_SV_TL3_CT (`INT32`) {#CA_SV_TL3_CT}

Tilt 3 is used for control.

Define if this servo is used for additional control.

**Values:**

- `0`: None
- `1`: Yaw
- `2`: Pitch
- `3`: Yaw and Pitch


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### CA_SV_TL3_MAXA (`FLOAT`) {#CA_SV_TL3_MAXA}

Tilt Servo 3 Tilt Angle at Maximum.

Defines the tilt angle when the servo is at the maximum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 90.0 | deg 

### CA_SV_TL3_MINA (`FLOAT`) {#CA_SV_TL3_MINA}

Tilt Servo 3 Tilt Angle at Minimum.

Defines the tilt angle when the servo is at the minimum. An angle of zero means upwards.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 0.0 | deg 

### CA_SV_TL3_TD (`INT32`) {#CA_SV_TL3_TD}

Tilt Servo 3 Tilt Direction.

Defines the direction the servo tilts towards when moving towards the maximum tilt angle. For example if the minimum tilt angle is -90, the maximum 90, and the direction 'Towards Front', the motor axis aligns with the XZ-plane, points towards -X at the minimum and +X at the maximum tilt.

**Values:**

- `0`: Towards Front
- `90`: Towards Right


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 359 |  | 0 |  

### CA_SV_TL_COUNT (`INT32`) {#CA_SV_TL_COUNT}

Total number of Tilt Servos.

**Values:**

- `0`: 0
- `1`: 1
- `2`: 2
- `3`: 3
- `4`: 4


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SIM_GZ_SV_MAXA1 (`FLOAT`) {#SIM_GZ_SV_MAXA1}

Servo 1 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA2 (`FLOAT`) {#SIM_GZ_SV_MAXA2}

Servo 2 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA3 (`FLOAT`) {#SIM_GZ_SV_MAXA3}

Servo 3 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA4 (`FLOAT`) {#SIM_GZ_SV_MAXA4}

Servo 4 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA5 (`FLOAT`) {#SIM_GZ_SV_MAXA5}

Servo 5 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA6 (`FLOAT`) {#SIM_GZ_SV_MAXA6}

Servo 6 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA7 (`FLOAT`) {#SIM_GZ_SV_MAXA7}

Servo 7 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MAXA8 (`FLOAT`) {#SIM_GZ_SV_MAXA8}

Servo 8 Angle at Maximum.

Defines the angle when the servo is at the maximum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MAXA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | 45.0 | deg 

### SIM_GZ_SV_MINA1 (`FLOAT`) {#SIM_GZ_SV_MINA1}

Servo 1 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA2 (`FLOAT`) {#SIM_GZ_SV_MINA2}

Servo 2 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA3 (`FLOAT`) {#SIM_GZ_SV_MINA3}

Servo 3 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA4 (`FLOAT`) {#SIM_GZ_SV_MINA4}

Servo 4 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA5 (`FLOAT`) {#SIM_GZ_SV_MINA5}

Servo 5 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA6 (`FLOAT`) {#SIM_GZ_SV_MINA6}

Servo 6 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA7 (`FLOAT`) {#SIM_GZ_SV_MINA7}

Servo 7 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

### SIM_GZ_SV_MINA8 (`FLOAT`) {#SIM_GZ_SV_MINA8}

Servo 8 Angle at Minimum.

Defines the angle when the servo is at the minimum. Currently only supported in gz simulation and must be coherent with .sdf file and CA_SV_TL{n}_MINA.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180.0 | 180.0 |  | -45.0 | deg 

## Hover Thrust Estimator

### HTE_ACC_GATE (`FLOAT`) {#HTE_ACC_GATE}

Gate size for acceleration fusion.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10.0 |  | 3.0 | SD 

### HTE_HT_ERR_INIT (`FLOAT`) {#HTE_HT_ERR_INIT}

1-sigma initial hover thrust uncertainty.

Sets the number of standard deviations used by the innovation consistency test.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 |  | 0.1 | normalized_thrust 

### HTE_HT_NOISE (`FLOAT`) {#HTE_HT_NOISE}

Hover thrust process noise.

Reduce to make the hover thrust estimate more stable, increase if the real hover thrust is expected to change quickly over time.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0001 | 1.0 |  | 0.0036 | normalized_thrust/s 

### HTE_THR_RANGE (`FLOAT`) {#HTE_THR_RANGE}

Max deviation from MPC_THR_HOVER.

Defines the range of the hover thrust estimate around MPC_THR_HOVER. A value of 0.2 with MPC_THR_HOVER at 0.5 results in a range of [0.3, 0.7]. Set to a large value if the vehicle operates in varying physical conditions that affect the required hover thrust strongly (e.g. differently sized payloads).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 0.4 |  | 0.2 | normalized_thrust 

### HTE_VXY_THR (`FLOAT`) {#HTE_VXY_THR}

Horizontal velocity threshold for sensitivity reduction.

Above this speed, the measurement noise is linearly increased to reduce the sensitivity of the estimator from biased measurement. Set to a low value on vehicles with large lifting surfaces.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 20.0 |  | 10.0 | m/s 

### HTE_VZ_THR (`FLOAT`) {#HTE_VZ_THR}

Vertical velocity threshold for sensitivity reduction.

Above this speed, the measurement noise is linearly increased to reduce the sensitivity of the estimator from biased measurement. Set to a low value on vehicles affected by air drag when climbing or descending.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 10.0 |  | 2.0 | m/s 

## ICE

### ICE_CHOKE_ST_DUR (`FLOAT`) {#ICE_CHOKE_ST_DUR}

Duration of choking during startup.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 5 | s 

### ICE_EN (`INT32`) {#ICE_EN}

Enable internal combustion engine.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### ICE_IGN_DELAY (`FLOAT`) {#ICE_IGN_DELAY}

Cold-start delay after ignition before engaging starter.

In case that the ignition takes a moment to be up and running, this parameter can be set to account for that.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 0 | s 

### ICE_MIN_RUN_RPM (`FLOAT`) {#ICE_MIN_RUN_RPM}

Minimum RPM for engine to be declared running.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10000 | 1 | 2000 | rpm 

### ICE_ON_SOURCE (`INT32`) {#ICE_ON_SOURCE}

Engine start/stop input source.

**Values:**

- `0`: On arming - disarming
- `1`: Aux1
- `2`: Aux2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### ICE_RUN_FAULT_D (`INT32`) {#ICE_RUN_FAULT_D}

Fault detection if it stops in running state.

Enables restart if a fault is detected during the running state. Otherwise commands continues in running state until given an user request off.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### ICE_STOP_CHOKE (`INT32`) {#ICE_STOP_CHOKE}

Apply choke when stopping engine.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### ICE_STRT_ATTEMPT (`INT32`) {#ICE_STRT_ATTEMPT}

Number attempts for starting the engine.

Number of accepted attempts for starting the engine before declaring a fault.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 |  | 3 |  

### ICE_STRT_DUR (`FLOAT`) {#ICE_STRT_DUR}

Duration of single starting attempt (excl. choking).

Maximum expected time for startup before declaring timeout.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 | 0.1 | 5 | s 

### ICE_STRT_THR (`FLOAT`) {#ICE_STRT_THR}

Throttle value for starting engine.

During the choking and the starting phase, the throttle value is set to this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.1 | norm 

### ICE_THR_SLEW (`FLOAT`) {#ICE_THR_SLEW}

Throttle slew rate.

Maximum rate of change of throttle value per second.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.5 | 1/s 

## Iridium SBD

### ISBD_CONFIG (`INT32`) {#ISBD_CONFIG}

Serial Configuration for Iridium (with MAVLink).

Configure on which serial port to run Iridium (with MAVLink).

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### ISBD_READ_INT (`INT32`) {#ISBD_READ_INT}

Satellite radio read interval. Only required to be nonzero if data is not sent using a ring call.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 5000 |  | 0 | s 

### ISBD_SBD_TIMEOUT (`INT32`) {#ISBD_SBD_TIMEOUT}

Iridium SBD session timeout.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 300 |  | 60 | s 

### ISBD_STACK_TIME (`INT32`) {#ISBD_STACK_TIME}

Time the Iridium driver will wait for additional mavlink messages to combine them into one SBD message.

Value 0 turns the functionality off

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 500 |  | 0 | ms 

## Land Detector

### LNDFW_AIRSPD_MAX (`FLOAT`) {#LNDFW_AIRSPD_MAX}

Fixed-wing land detector: Max airspeed.

Maximum airspeed allowed in the landed state

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 20 |  | 6.00 | m/s 

### LNDFW_ROT_MAX (`FLOAT`) {#LNDFW_ROT_MAX}

Fixed-wing land detector: max rotational speed.

Maximum allowed norm of the angular velocity in the landed state.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.5 | deg/s 

### LNDFW_TRIG_TIME (`FLOAT`) {#LNDFW_TRIG_TIME}

Fixed-wing land detection trigger time.

Time the land conditions (speeds and acceleration) have to be satisfied to detect a landing.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.1 |  |  | 2. | s 

### LNDFW_VEL_XY_MAX (`FLOAT`) {#LNDFW_VEL_XY_MAX}

Fixed-wing land detector: Max horizontal velocity threshold.

Maximum horizontal velocity allowed in the landed state. A factor of 0.7 is applied in case of airspeed-less flying (either because no sensor is present or sensor data got invalid in flight).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 10 |  | 5.0 | m/s 

### LNDFW_VEL_Z_MAX (`FLOAT`) {#LNDFW_VEL_Z_MAX}

Fixed-wing land detector: Max vertiacal velocity threshold.

Maximum vertical velocity allowed in the landed state.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 20 |  | 1.0 | m/s 

### LNDFW_XYACC_MAX (`FLOAT`) {#LNDFW_XYACC_MAX}

Fixed-wing land detector: Max horizontal acceleration.

Maximum horizontal (x,y body axes) acceleration allowed in the landed state

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 |  | 8.0 | m/s^2 

### LNDMC_ALT_GND (`FLOAT`) {#LNDMC_ALT_GND}

Ground effect altitude for multicopters.

The height above ground below which ground effect creates barometric altitude errors. A negative value indicates no ground effect.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  |  | 2. | m 

### LNDMC_ROT_MAX (`FLOAT`) {#LNDMC_ROT_MAX}

Multicopter max rotational speed.

Maximum allowed norm of the angular velocity (roll, pitch) in the landed state.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 20.0 | deg/s 

### LNDMC_TRIG_TIME (`FLOAT`) {#LNDMC_TRIG_TIME}

Multicopter land detection trigger time.

Total time it takes to go through all three land detection stages: ground contact, maybe landed, landed when all necessary conditions are constantly met.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 10.0 |  | 1.0 | s 

### LNDMC_XY_VEL_MAX (`FLOAT`) {#LNDMC_XY_VEL_MAX}

Multicopter max horizontal velocity.

Maximum horizontal velocity allowed in the landed state

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1.5 | m/s 

### LNDMC_Z_VEL_MAX (`FLOAT`) {#LNDMC_Z_VEL_MAX}

Multicopter vertical velocity threshold.

Vertical velocity threshold to detect landing. Has to be set lower than the expected minimal speed for landing, which is either MPC_LAND_SPEED or MPC_LAND_CRWL. This is enforced by an automatic check.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 0.25 | m/s 

### LND_FLIGHT_T_HI (`INT32`) {#LND_FLIGHT_T_HI}

Total flight time in microseconds.

Total flight time of this autopilot. Higher 32 bits of the value. Flight time in microseconds = (LND_FLIGHT_T_HI << 32) | LND_FLIGHT_T_LO.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 0 |  

### LND_FLIGHT_T_LO (`INT32`) {#LND_FLIGHT_T_LO}

Total flight time in microseconds.

Total flight time of this autopilot. Lower 32 bits of the value. Flight time in microseconds = (LND_FLIGHT_T_HI << 32) | LND_FLIGHT_T_LO.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 0 |  

## Landing Target Estimator

### LTEST_ACC_UNC (`FLOAT`) {#LTEST_ACC_UNC}

Acceleration uncertainty.

Variance of acceleration measurement used for landing target position prediction. Higher values results in tighter following of the measurements and more lenient outlier rejection

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 10.0 | (m/s^2)^2 

### LTEST_MEAS_UNC (`FLOAT`) {#LTEST_MEAS_UNC}

Landing target measurement uncertainty.

Variance of the landing target measurement from the driver. Higher values result in less aggressive following of the measurement and a smoother output as well as fewer rejected measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.005 | tan(rad)^2 

### LTEST_MODE (`INT32`) {#LTEST_MODE}

Landing target mode.

Configure the mode of the landing target. Depending on the mode, the landing target observations are used differently to aid position estimation. Mode Moving:     The landing target may be moving around while in the field of view of the vehicle. Landing target measurements are not used to aid positioning. Mode Stationary: The landing target is stationary. Measured velocity w.r.t. the landing target is used to aid velocity estimation.

**Values:**

- `0`: Moving
- `1`: Stationary


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### LTEST_POS_UNC_IN (`FLOAT`) {#LTEST_POS_UNC_IN}

Initial landing target position uncertainty.

Initial variance of the relative landing target position in x and y direction

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 |  |  | 0.1 | m^2 

### LTEST_SCALE_X (`FLOAT`) {#LTEST_SCALE_X}

Scale factor for sensor measurements in sensor x axis.

Landing target x measurements are scaled by this factor before being used

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 1.0 |  

### LTEST_SCALE_Y (`FLOAT`) {#LTEST_SCALE_Y}

Scale factor for sensor measurements in sensor y axis.

Landing target y measurements are scaled by this factor before being used

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 |  |  | 1.0 |  

### LTEST_SENS_POS_X (`FLOAT`) {#LTEST_SENS_POS_X}

X Position of IRLOCK in body frame (forward).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0.0 | m 

### LTEST_SENS_POS_Y (`FLOAT`) {#LTEST_SENS_POS_Y}

Y Position of IRLOCK in body frame (right).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0.0 | m 

### LTEST_SENS_POS_Z (`FLOAT`) {#LTEST_SENS_POS_Z}

Z Position of IRLOCK in body frame (downward).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0.0 | m 

### LTEST_SENS_ROT (`INT32`) {#LTEST_SENS_ROT}

Rotation of IRLOCK sensor relative to airframe.

Default orientation of Yaw 90°

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1 | 40 |  | 2 |  

### LTEST_VEL_UNC_IN (`FLOAT`) {#LTEST_VEL_UNC_IN}

Initial landing target velocity uncertainty.

Initial variance of the relative landing target velocity in x and y directions

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 |  |  | 0.1 | (m/s)^2 

## Local Position Estimator

### LPE_ACC_XY (`FLOAT`) {#LPE_ACC_XY}

Accelerometer xy noise density.

Data sheet noise density = 150ug/sqrt(Hz) = 0.0015 m/s^2/sqrt(Hz) Larger than data sheet to account for tilt error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00001 | 2 |  | 0.012 | m/s^2/sqrt(Hz) 

### LPE_ACC_Z (`FLOAT`) {#LPE_ACC_Z}

Accelerometer z noise density.

Data sheet noise density = 150ug/sqrt(Hz) = 0.0015 m/s^2/sqrt(Hz)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00001 | 2 |  | 0.02 | m/s^2/sqrt(Hz) 

### LPE_BAR_Z (`FLOAT`) {#LPE_BAR_Z}

Barometric presssure altitude z standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 100 |  | 3.0 | m 

### LPE_EN (`INT32`) {#LPE_EN}

Local position estimator enable (unsupported).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### LPE_EPH_MAX (`FLOAT`) {#LPE_EPH_MAX}

Max EPH allowed for GPS initialization.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 5.0 |  | 3.0 | m 

### LPE_EPV_MAX (`FLOAT`) {#LPE_EPV_MAX}

Max EPV allowed for GPS initialization.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 5.0 |  | 5.0 | m 

### LPE_FAKE_ORIGIN (`INT32`) {#LPE_FAKE_ORIGIN}

Enable publishing of a fake global position (e.g for AUTO missions using Optical Flow).

By initializing the estimator to the LPE_LAT/LON parameters when global information is unavailable

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### LPE_FGYRO_HP (`FLOAT`) {#LPE_FGYRO_HP}

Flow gyro high pass filter cut off frequency.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 0.001 | Hz 

### LPE_FLW_OFF_Z (`FLOAT`) {#LPE_FLW_OFF_Z}

Optical flow z offset from center.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.0 | m 

### LPE_FLW_QMIN (`INT32`) {#LPE_FLW_QMIN}

Optical flow minimum quality threshold.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 150 |  

### LPE_FLW_R (`FLOAT`) {#LPE_FLW_R}

Optical flow rotation (roll/pitch) noise gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 10.0 |  | 7.0 | m/s/rad 

### LPE_FLW_RR (`FLOAT`) {#LPE_FLW_RR}

Optical flow angular velocity noise gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 |  | 7.0 | m/rad 

### LPE_FLW_SCALE (`FLOAT`) {#LPE_FLW_SCALE}

Optical flow scale.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 10.0 |  | 1.3 | m 

### LPE_FUSION (`INT32`) {#LPE_FUSION}

Integer bitmask controlling data fusion.

Set bits in the following positions to enable: 0 : Set to true to fuse GPS data if available, also requires GPS for altitude init 1 : Set to true to fuse optical flow data if available 2 : Set to true to fuse vision position 3 : Set to true to enable landing target 4 : Set to true to fuse land detector 5 : Set to true to publish AGL as local position down component 6 : Set to true to enable flow gyro compensation 7 : Set to true to enable baro fusion default (145 - GPS, baro, land detector)

**Bitmask:**

- `0`: fuse GPS, requires GPS for alt. init
- `1`: fuse optical flow
- `2`: fuse vision position
- `3`: fuse landing target
- `4`: fuse land detector
- `5`: pub agl as lpos down
- `6`: flow gyro compensation
- `7`: fuse baro


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 145 |  

### LPE_GPS_DELAY (`FLOAT`) {#LPE_GPS_DELAY}

GPS delay compensaton.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.4 |  | 0.29 | s 

### LPE_GPS_VXY (`FLOAT`) {#LPE_GPS_VXY}

GPS xy velocity standard deviation.

EPV used if greater than this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 2 |  | 0.25 | m/s 

### LPE_GPS_VZ (`FLOAT`) {#LPE_GPS_VZ}

GPS z velocity standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 2 |  | 0.25 | m/s 

### LPE_GPS_XY (`FLOAT`) {#LPE_GPS_XY}

Minimum GPS xy standard deviation, uses reported EPH if greater.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 5 |  | 1.0 | m 

### LPE_GPS_Z (`FLOAT`) {#LPE_GPS_Z}

Minimum GPS z standard deviation, uses reported EPV if greater.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 200 |  | 3.0 | m 

### LPE_LAND_VXY (`FLOAT`) {#LPE_LAND_VXY}

Land detector xy velocity standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 10.0 |  | 0.05 | m/s 

### LPE_LAND_Z (`FLOAT`) {#LPE_LAND_Z}

Land detector z standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 | 10.0 |  | 0.03 | m 

### LPE_LAT (`FLOAT`) {#LPE_LAT}

Local origin latitude for nav w/o GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90 | 90 |  | 47.397742 | deg 

### LPE_LDR_OFF_Z (`FLOAT`) {#LPE_LDR_OFF_Z}

Lidar z offset from center of vehicle +down.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.00 | m 

### LPE_LDR_Z (`FLOAT`) {#LPE_LDR_Z}

Lidar z standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1 |  | 0.03 | m 

### LPE_LON (`FLOAT`) {#LPE_LON}

Local origin longitude for nav w/o GPS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 8.545594 | deg 

### LPE_LT_COV (`FLOAT`) {#LPE_LT_COV}

Minimum landing target standard covariance, uses reported covariance if greater.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 |  | 0.0001 | m^2 

### LPE_PN_B (`FLOAT`) {#LPE_PN_B}

Accel bias propagation noise density.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1e-3 | m/s^3/sqrt(Hz) 

### LPE_PN_P (`FLOAT`) {#LPE_PN_P}

Position propagation noise density.

Increase to trust measurements more. Decrease to trust model more.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.1 | m/s/sqrt(Hz) 

### LPE_PN_T (`FLOAT`) {#LPE_PN_T}

Terrain random walk noise density, hilly/outdoor (0.1), flat/Indoor (0.001).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.001 | m/s/sqrt(Hz) 

### LPE_PN_V (`FLOAT`) {#LPE_PN_V}

Velocity propagation noise density.

Increase to trust measurements more. Decrease to trust model more.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.1 | m/s^2/sqrt(Hz) 

### LPE_SNR_OFF_Z (`FLOAT`) {#LPE_SNR_OFF_Z}

Sonar z offset from center of vehicle +down.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.00 | m 

### LPE_SNR_Z (`FLOAT`) {#LPE_SNR_Z}

Sonar z standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1 |  | 0.05 | m 

### LPE_T_MAX_GRADE (`FLOAT`) {#LPE_T_MAX_GRADE}

Terrain maximum percent grade, hilly/outdoor (100 = 45 deg), flat/Indoor (0 = 0 deg).

Used to calculate increased terrain random walk nosie due to movement.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 |  | 1.0 | % 

### LPE_VIC_P (`FLOAT`) {#LPE_VIC_P}

Vicon position standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0001 | 1 |  | 0.001 | m 

### LPE_VIS_DELAY (`FLOAT`) {#LPE_VIS_DELAY}

Vision delay compensation.

Set to zero to enable automatic compensation from measurement timestamps

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.1 |  | 0.1 | s 

### LPE_VIS_XY (`FLOAT`) {#LPE_VIS_XY}

Vision xy standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1 |  | 0.1 | m 

### LPE_VIS_Z (`FLOAT`) {#LPE_VIS_Z}

Vision z standard deviation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 100 |  | 0.5 | m 

### LPE_VXY_PUB (`FLOAT`) {#LPE_VXY_PUB}

Required velocity xy standard deviation to publish position.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 1.0 |  | 0.3 | m/s 

### LPE_X_LP (`FLOAT`) {#LPE_X_LP}

Cut frequency for state publication.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 1000 |  | 5.0 | Hz 

### LPE_Z_PUB (`FLOAT`) {#LPE_Z_PUB}

Required z standard deviation to publish altitude/ terrain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.3 | 5.0 |  | 1.0 | m 

## MAVLink

### MAV_0_BROADCAST (`INT32`) {#MAV_0_BROADCAST}

Broadcast heartbeats on local network for MAVLink instance 0.

This allows a ground control station to automatically find the drone on the local network.

**Values:**

- `0`: Never broadcast
- `1`: Always broadcast
- `2`: Only multicast


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### MAV_0_CONFIG (`INT32`) {#MAV_0_CONFIG}

Serial Configuration for MAVLink (instance 0).

Configure on which serial port to run MAVLink.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2
- `1000`: Ethernet


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 101 |  

### MAV_0_FLOW_CTRL (`INT32`) {#MAV_0_FLOW_CTRL}

Enable serial flow control for instance 0.

This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.

**Values:**

- `0`: Force off
- `1`: Force on
- `2`: Auto-detected


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

### MAV_0_FORWARD (`INT32`) {#MAV_0_FORWARD}

Enable MAVLink Message forwarding for instance 0.

If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### MAV_0_HL_FREQ (`FLOAT`) {#MAV_0_HL_FREQ}

Configures the frequency of HIGH_LATENCY2 stream for instance 0.

Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 0, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 50.0 | 0.001 | 0.015 | Hz 

### MAV_0_MODE (`INT32`) {#MAV_0_MODE}

MAVLink Mode for instance 0.

The MAVLink Mode defines the set of streamed messages (for example the vehicle's attitude) and their sending rates.

**Values:**

- `0`: Normal
- `1`: Custom
- `2`: Onboard
- `3`: OSD
- `4`: Magic
- `5`: Config
- `7`: Minimal
- `8`: External Vision
- `10`: Gimbal
- `11`: Onboard Low Bandwidth
- `12`: uAvionix


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_0_RADIO_CTL (`INT32`) {#MAV_0_RADIO_CTL}

Enable software throttling of mavlink on instance 0.

If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### MAV_0_RATE (`INT32`) {#MAV_0_RATE}

Maximum MAVLink sending rate for instance 0.

Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 |  |  | 1200 | B/s 

### MAV_0_REMOTE_PRT (`INT32`) {#MAV_0_REMOTE_PRT}

MAVLink Remote Port for instance 0.

If ethernet enabled and selected as configuration for MAVLink instance 0, selected remote port will be set and used in MAVLink instance 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 14550 |  

### MAV_0_UDP_PRT (`INT32`) {#MAV_0_UDP_PRT}

MAVLink Network Port for instance 0.

If ethernet enabled and selected as configuration for MAVLink instance 0, selected udp port will be set and used in MAVLink instance 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 14556 |  

### MAV_1_BROADCAST (`INT32`) {#MAV_1_BROADCAST}

Broadcast heartbeats on local network for MAVLink instance 1.

This allows a ground control station to automatically find the drone on the local network.

**Values:**

- `0`: Never broadcast
- `1`: Always broadcast
- `2`: Only multicast


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MAV_1_CONFIG (`INT32`) {#MAV_1_CONFIG}

Serial Configuration for MAVLink (instance 1).

Configure on which serial port to run MAVLink.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2
- `1000`: Ethernet


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_1_FLOW_CTRL (`INT32`) {#MAV_1_FLOW_CTRL}

Enable serial flow control for instance 1.

This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.

**Values:**

- `0`: Force off
- `1`: Force on
- `2`: Auto-detected


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

### MAV_1_FORWARD (`INT32`) {#MAV_1_FORWARD}

Enable MAVLink Message forwarding for instance 1.

If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### MAV_1_HL_FREQ (`FLOAT`) {#MAV_1_HL_FREQ}

Configures the frequency of HIGH_LATENCY2 stream for instance 1.

Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 1, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 50.0 | 0.001 | 0.015 | Hz 

### MAV_1_MODE (`INT32`) {#MAV_1_MODE}

MAVLink Mode for instance 1.

The MAVLink Mode defines the set of streamed messages (for example the vehicle's attitude) and their sending rates.

**Values:**

- `0`: Normal
- `1`: Custom
- `2`: Onboard
- `3`: OSD
- `4`: Magic
- `5`: Config
- `7`: Minimal
- `8`: External Vision
- `10`: Gimbal
- `11`: Onboard Low Bandwidth
- `12`: uAvionix


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

### MAV_1_RADIO_CTL (`INT32`) {#MAV_1_RADIO_CTL}

Enable software throttling of mavlink on instance 1.

If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### MAV_1_RATE (`INT32`) {#MAV_1_RATE}

Maximum MAVLink sending rate for instance 1.

Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 |  |  | 0 | B/s 

### MAV_1_REMOTE_PRT (`INT32`) {#MAV_1_REMOTE_PRT}

MAVLink Remote Port for instance 1.

If ethernet enabled and selected as configuration for MAVLink instance 1, selected remote port will be set and used in MAVLink instance 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_1_UDP_PRT (`INT32`) {#MAV_1_UDP_PRT}

MAVLink Network Port for instance 1.

If ethernet enabled and selected as configuration for MAVLink instance 1, selected udp port will be set and used in MAVLink instance 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_2_BROADCAST (`INT32`) {#MAV_2_BROADCAST}

Broadcast heartbeats on local network for MAVLink instance 2.

This allows a ground control station to automatically find the drone on the local network.

**Values:**

- `0`: Never broadcast
- `1`: Always broadcast
- `2`: Only multicast


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MAV_2_CONFIG (`INT32`) {#MAV_2_CONFIG}

Serial Configuration for MAVLink (instance 2).

Configure on which serial port to run MAVLink.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2
- `1000`: Ethernet


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_2_FLOW_CTRL (`INT32`) {#MAV_2_FLOW_CTRL}

Enable serial flow control for instance 2.

This is used to force flow control on or off for the the mavlink instance. By default it is auto detected. Use when auto detection fails.

**Values:**

- `0`: Force off
- `1`: Force on
- `2`: Auto-detected


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 2 |  

### MAV_2_FORWARD (`INT32`) {#MAV_2_FORWARD}

Enable MAVLink Message forwarding for instance 2.

If enabled, forward incoming MAVLink messages to other MAVLink ports if the message is either broadcast or the target is not the autopilot. This allows for example a GCS to talk to a camera that is connected to the autopilot via MAVLink (on a different link than the GCS).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### MAV_2_HL_FREQ (`FLOAT`) {#MAV_2_HL_FREQ}

Configures the frequency of HIGH_LATENCY2 stream for instance 2.

Positive real value that configures the transmission frequency of the HIGH_LATENCY2 stream for instance 2, configured in iridium mode. This parameter has no effect if the instance mode is different from iridium.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 50.0 | 0.001 | 0.015 | Hz 

### MAV_2_MODE (`INT32`) {#MAV_2_MODE}

MAVLink Mode for instance 2.

The MAVLink Mode defines the set of streamed messages (for example the vehicle's attitude) and their sending rates.

**Values:**

- `0`: Normal
- `1`: Custom
- `2`: Onboard
- `3`: OSD
- `4`: Magic
- `5`: Config
- `7`: Minimal
- `8`: External Vision
- `10`: Gimbal
- `11`: Onboard Low Bandwidth
- `12`: uAvionix


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_2_RADIO_CTL (`INT32`) {#MAV_2_RADIO_CTL}

Enable software throttling of mavlink on instance 2.

If enabled, MAVLink messages will be throttled according to `txbuf` field reported by radio_status. Requires a radio to send the mavlink message RADIO_STATUS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### MAV_2_RATE (`INT32`) {#MAV_2_RATE}

Maximum MAVLink sending rate for instance 2.

Configure the maximum sending rate for the MAVLink streams in Bytes/sec. If the configured streams exceed the maximum rate, the sending rate of each stream is automatically decreased. If this is set to 0 a value of half of the theoretical maximum bandwidth is used. This corresponds to baudrate/20 Bytes/s (baudrate/10 = maximum data rate on 8N1-configured links).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 |  |  | 0 | B/s 

### MAV_2_REMOTE_PRT (`INT32`) {#MAV_2_REMOTE_PRT}

MAVLink Remote Port for instance 2.

If ethernet enabled and selected as configuration for MAVLink instance 2, selected remote port will be set and used in MAVLink instance 2.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_2_UDP_PRT (`INT32`) {#MAV_2_UDP_PRT}

MAVLink Network Port for instance 2.

If ethernet enabled and selected as configuration for MAVLink instance 2, selected udp port will be set and used in MAVLink instance 2.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MAV_COMP_ID (`INT32`) {#MAV_COMP_ID}

MAVLink component ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 250 |  | 1 |  

### MAV_FWDEXTSP (`INT32`) {#MAV_FWDEXTSP}

Forward external setpoint messages.

If set to 1 incoming external setpoint messages will be directly forwarded to the controllers if in offboard control mode

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MAV_HASH_CHK_EN (`INT32`) {#MAV_HASH_CHK_EN}

Parameter hash check.

Disabling the parameter hash check functionality will make the mavlink instance stream parameters continuously.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MAV_HB_FORW_EN (`INT32`) {#MAV_HB_FORW_EN}

Heartbeat message forwarding.

The mavlink heartbeat message will not be forwarded if this parameter is set to 'disabled'. The main reason for disabling heartbeats to be forwarded is because they confuse dronekit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MAV_PROTO_VER (`INT32`) {#MAV_PROTO_VER}

MAVLink protocol version.

**Values:**

- `0`: Default to 1, switch to 2 if GCS sends version 2
- `1`: Always use version 1
- `2`: Always use version 2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MAV_RADIO_TOUT (`INT32`) {#MAV_RADIO_TOUT}

Timeout in seconds for the RADIO_STATUS reports coming in.

If the connected radio stops reporting RADIO_STATUS for a certain time, a warning is triggered and, if MAV_X_RADIO_CTL is enabled, the software-flow control is reset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 250 |  | 5 | s 

### MAV_SIK_RADIO_ID (`INT32`) {#MAV_SIK_RADIO_ID}

MAVLink SiK Radio ID.

When non-zero the MAVLink app will attempt to configure the SiK radio to this ID and re-set the parameter to 0. If the value is negative it will reset the complete radio config to factory defaults. Only applies if this mavlink instance is going through a SiK radio

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 240 |  | 0 |  

### MAV_SYS_ID (`INT32`) {#MAV_SYS_ID}

MAVLink system ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 250 |  | 1 |  

### MAV_TYPE (`INT32`) {#MAV_TYPE}

MAVLink airframe type.

**Values:**

- `0`: Generic micro air vehicle
- `1`: Fixed wing aircraft
- `2`: Quadrotor
- `3`: Coaxial helicopter
- `4`: Normal helicopter with tail rotor
- `7`: Airship, controlled
- `8`: Free balloon, uncontrolled
- `10`: Ground rover
- `11`: Surface vessel, boat, ship
- `12`: Submarine
- `13`: Hexarotor
- `14`: Octorotor
- `15`: Tricopter
- `19`: VTOL Two-rotor Tailsitter
- `20`: VTOL Quad-rotor Tailsitter
- `21`: VTOL Tiltrotor
- `22`: VTOL Standard (separate fixed rotors for hover and cruise flight)
- `23`: VTOL Tailsitter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 22 |  | 0 |  

### MAV_USEHILGPS (`INT32`) {#MAV_USEHILGPS}

Use/Accept HIL GPS message even if not in HIL mode.

If set to 1 incoming HIL GPS messages are parsed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

## Magnetometer

### BMM350_AVG (`INT32`) {#BMM350_AVG}

BMM350 data averaging.

Defines which averaging mode to use during data polling.

**Values:**

- `0`: No averaging
- `1`: 2 sample averaging
- `2`: 4 sample averaging
- `3`: 8 sample averaging


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### BMM350_DRIVE (`INT32`) {#BMM350_DRIVE}

BMM350 pad drive strength setting.

This setting helps avoid signal problems like overshoot or undershoot.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 7 |  | 7 |  

### BMM350_ODR (`INT32`) {#BMM350_ODR}

BMM350 ODR rate.

Defines which ODR rate to use during data polling.

**Values:**

- `0`: 400 Hz
- `1`: 200 Hz
- `2`: 100 Hz
- `3`: 50 Hz
- `4`: 25 Hz
- `5`: 12.5 Hz
- `6`: 6.25 Hz
- `7`: 3.125 Hz
- `8`: 1.5625 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 3 |  

## Magnetometer Bias Estimator

### MBE_ENABLE (`INT32`) {#MBE_ENABLE}

Enable online mag bias calibration.

This enables continuous calibration of the magnetometers before takeoff using gyro data.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### MBE_LEARN_GAIN (`FLOAT`) {#MBE_LEARN_GAIN}

Mag bias estimator learning gain.

Increase to make the estimator more responsive Decrease to make the estimator more robust to noise

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 100 | 0.1 | 18. |  

## Manual Control

### MAN_ARM_GESTURE (`INT32`) {#MAN_ARM_GESTURE}

Enable arm/disarm stick gesture.

This determines if moving the left stick to the lower right arms and to the lower left disarms the vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MAN_KILL_GEST_T (`FLOAT`) {#MAN_KILL_GEST_T}

Trigger time for kill stick gesture.

The timeout for holding the left stick to the lower left and the right stick to the lower right at the same time until the gesture kills the actuators one-way. A negative value disables the feature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 15 |  | -1. | s 

## Mission

### FW_GPSF_LT (`INT32`) {#FW_GPSF_LT}

GPS failure loiter time.

The time the system should do open loop loiter and wait for GPS recovery before it starts descending. Set to 0 to disable. Roll angle is set to FW_GPSF_R. Does only apply for fixed-wing vehicles or VTOLs with NAV_FORCE_VT set to 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3600 |  | 30 | s 

### FW_GPSF_R (`FLOAT`) {#FW_GPSF_R}

GPS failure fixed roll angle.

Roll angle in GPS failure loiter mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 30.0 | 0.5 | 15.0 | deg 

### MIS_COMMAND_TOUT (`FLOAT`) {#MIS_COMMAND_TOUT}

Timeout to allow the payload to execute the mission command.

Ensure: gripper: NAV_CMD_DO_GRIPPER has released before continuing mission. winch: CMD_DO_WINCH has delivered before continuing mission. gimbal: CMD_DO_GIMBAL_MANAGER_PITCHYAW has reached the commanded orientation before beginning to take pictures.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 0. | s 

### MIS_DIST_1WP (`FLOAT`) {#MIS_DIST_1WP}

Maximal horizontal distance from Home to first waypoint.

There will be a warning message if the current waypoint is more distant than MIS_DIST_1WP from Home. Has no effect on mission validity. Set a value of zero or less to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100000 | 100 | 10000 | m 

### MIS_LND_ABRT_ALT (`INT32`) {#MIS_LND_ABRT_ALT}

Landing abort min altitude.

Minimum altitude above landing point that the vehicle will climb to after an aborted landing. Then vehicle will loiter in this altitude until further command is received. Only applies to fixed-wing vehicles.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 30 | m 

### MIS_MNT_YAW_CTL (`INT32`) {#MIS_MNT_YAW_CTL}

Enable yaw control of the mount. (Only affects multicopters and ROI mission items).

If enabled, yaw commands will be sent to the mount and the vehicle will follow its heading towards the flight direction. If disabled, the vehicle will yaw towards the ROI.

**Values:**

- `0`: Disable
- `1`: Enable


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### MIS_TAKEOFF_ALT (`FLOAT`) {#MIS_TAKEOFF_ALT}

Default take-off altitude.

This is the relative altitude the system will take off to if not otherwise specified.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.5 | 2.5 | m 

### MIS_TKO_LAND_REQ (`INT32`) {#MIS_TKO_LAND_REQ}

Mission takeoff/landing required.

Specifies if a mission has to contain a takeoff and/or mission landing. Validity of configured takeoffs/landings is checked independently of the setting here.

**Values:**

- `0`: No requirements
- `1`: Require a takeoff
- `2`: Require a landing
- `3`: Require a takeoff and a landing
- `4`: Require both a takeoff and a landing, or neither
- `5`: Same as previous when landed, in-air require landing only if no valid VTOL approach is present


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MIS_YAW_ERR (`FLOAT`) {#MIS_YAW_ERR}

Max yaw error in degrees needed for waypoint heading acceptance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 90 | 1 | 12.0 | deg 

### MIS_YAW_TMT (`FLOAT`) {#MIS_YAW_TMT}

Time in seconds we wait on reaching target heading at a waypoint if it is forced.

If set > 0 it will ignore the target heading for normal waypoint acceptance. If the waypoint forces the heading the timeout will matter. For example on VTOL forwards transition. Mainly useful for VTOLs that have less yaw authority and might not reach target yaw in wind. Disabled by default.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 20 | 1 | -1.0 | s 

### MPC_YAW_MODE (`INT32`) {#MPC_YAW_MODE}

Heading behavior in autonomous modes.

**Values:**

- `0`: towards waypoint
- `1`: towards home
- `2`: away from home
- `3`: along trajectory
- `4`: towards waypoint (yaw first)
- `5`: yaw fixed


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4 |  | 0 |  

### NAV_ACC_RAD (`FLOAT`) {#NAV_ACC_RAD}

Acceptance Radius.

Default acceptance radius, overridden by acceptance radius of waypoint if set. For fixed wing the npfg switch distance is used for horizontal acceptance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 200.0 | 0.5 | 10.0 | m 

### NAV_FORCE_VT (`INT32`) {#NAV_FORCE_VT}

Force VTOL mode takeoff and land.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### NAV_FW_ALTL_RAD (`FLOAT`) {#NAV_FW_ALTL_RAD}

FW Altitude Acceptance Radius before a landing.

Altitude acceptance used for the last waypoint before a fixed-wing landing. This is usually smaller than the standard vertical acceptance because close to the ground higher accuracy is required.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 200.0 |  | 5.0 | m 

### NAV_FW_ALT_RAD (`FLOAT`) {#NAV_FW_ALT_RAD}

FW Altitude Acceptance Radius.

Acceptance radius for fixedwing altitude.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 200.0 | 0.5 | 10.0 | m 

### NAV_LOITER_RAD (`FLOAT`) {#NAV_LOITER_RAD}

Loiter radius (FW only).

Default value of loiter radius in FW mode (e.g. for Loiter mode).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 25 | 1000 | 0.5 | 80.0 | m 

### NAV_MC_ALT_RAD (`FLOAT`) {#NAV_MC_ALT_RAD}

MC Altitude Acceptance Radius.

Acceptance radius for multicopter altitude.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 200.0 | 0.5 | 0.8 | m 

### NAV_MIN_GND_DIST (`FLOAT`) {#NAV_MIN_GND_DIST}

Minimum height above ground during Mission and RTL.

Minimum height above ground the vehicle is allowed to descend to during Mission and RTL, excluding landing commands. Requires a distance sensor to be set up. Note: only prevents the vehicle from descending further, but does not force it to climb. Set to a negative value to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 1 | -1. | m 

### NAV_MIN_LTR_ALT (`FLOAT`) {#NAV_MIN_LTR_ALT}

Minimum Loiter altitude.

This is the minimum altitude above Home the system will always obey in Loiter (Hold) mode if switched into this mode without specifying an altitude (e.g. through Loiter switch on RC). Doesn't affect Loiters that are part of Missions or that are entered through a reposition setpoint ("Go to"). Set to a negative value to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 0.5 | -1. | m 

### NAV_TRAFF_AVOID (`INT32`) {#NAV_TRAFF_AVOID}

Set traffic avoidance mode.

Enabling this will allow the system to respond to transponder data from e.g. ADSB transponders

**Values:**

- `0`: Disabled
- `1`: Warn only
- `2`: Return mode
- `3`: Land mode
- `4`: Position Hold mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### NAV_TRAFF_A_HOR (`FLOAT`) {#NAV_TRAFF_A_HOR}

Set NAV TRAFFIC AVOID horizontal distance.

Defines a crosstrack horizontal distance

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 500 |  |  | 500 | m 

### NAV_TRAFF_A_VER (`FLOAT`) {#NAV_TRAFF_A_VER}

Set NAV TRAFFIC AVOID vertical distance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 | 500 |  | 500 | m 

### NAV_TRAFF_COLL_T (`INT32`) {#NAV_TRAFF_COLL_T}

Estimated time until collision.

Minimum acceptable time until collsion. Assumes constant speed over 3d distance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 900000000 |  | 60 | s 

## Mixer Output

### MC_AIRMODE (`INT32`) {#MC_AIRMODE}

Multicopter air-mode.

The air-mode enables the mixer to increase the total thrust of the multirotor in order to keep attitude and rate control even at low and high throttle. This function should be disabled during tuning as it will help the controller to diverge if the closed-loop is unstable (i.e. the vehicle is not tuned yet). Enabling air-mode for yaw requires the use of an arming switch.

**Values:**

- `0`: Disabled
- `1`: Roll/Pitch
- `2`: Roll/Pitch/Yaw


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

## ModalAI Custom Configuration

### MODALAI_CONFIG (`INT32`) {#MODALAI_CONFIG}

Custom configuration for ModalAI drones.

This can be set to indicate that drone behavior needs to be changed to match a custom setting

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

## Mount

### MNT_DO_STAB (`INT32`) {#MNT_DO_STAB}

Stabilize the mount.

Set to true for servo gimbal, false for passthrough. This is required for a gimbal which is not capable of stabilizing itself and relies on the IMU's attitude estimation.

**Values:**

- `0`: Disable
- `1`: Stabilize all axis
- `2`: Stabilize yaw for absolute/lock mode.


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 0 |  

### MNT_LND_P_MAX (`FLOAT`) {#MNT_LND_P_MAX}

Pitch maximum when landed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | 90.0 | deg 

### MNT_LND_P_MIN (`FLOAT`) {#MNT_LND_P_MIN}

Pitch minimum when landed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90.0 | 90.0 |  | -90.0 | deg 

### MNT_MAN_PITCH (`INT32`) {#MNT_MAN_PITCH}

Auxiliary channel to control pitch (in AUX input or manual mode).

**Values:**

- `0`: Disable
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 6 |  | 0 |  

### MNT_MAN_ROLL (`INT32`) {#MNT_MAN_ROLL}

Auxiliary channel to control roll (in AUX input or manual mode).

**Values:**

- `0`: Disable
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 6 |  | 0 |  

### MNT_MAN_YAW (`INT32`) {#MNT_MAN_YAW}

Auxiliary channel to control yaw (in AUX input or manual mode).

**Values:**

- `0`: Disable
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 6 |  | 0 |  

### MNT_MAV_COMPID (`INT32`) {#MNT_MAV_COMPID}

Mavlink Component ID of the mount.

If MNT_MODE_OUT is MAVLink protocol v2, mount configure/control commands will be sent with this component ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 154 |  

### MNT_MAV_SYSID (`INT32`) {#MNT_MAV_SYSID}

Mavlink System ID of the mount.

If MNT_MODE_OUT is MAVLink gimbal protocol v1, mount configure/control commands will be sent with this target ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1 |  

### MNT_MODE_IN (`INT32`) {#MNT_MODE_IN}

Mount input mode.

This is the protocol used between the ground station and the autopilot. Recommended is Auto, RC only or MAVLink gimbal protocol v2. The rest will be deprecated.

**Values:**

- `-1`: DISABLED
- `0`: Auto (RC and MAVLink gimbal protocol v2)
- `1`: RC
- `2`: MAVLINK_ROI (protocol v1, to be deprecated)
- `3`: MAVLINK_DO_MOUNT (protocol v1, to be deprecated)
- `4`: MAVlink gimbal protocol v2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1 | 4 |  | -1 |  

### MNT_MODE_OUT (`INT32`) {#MNT_MODE_OUT}

Mount output mode.

This is the protocol used between the autopilot and a connected gimbal. Recommended is the MAVLink gimbal protocol v2 if the gimbal supports it.

**Values:**

- `0`: AUX
- `1`: MAVLink gimbal protocol v1
- `2`: MAVLink gimbal protocol v2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 0 |  

### MNT_OFF_PITCH (`FLOAT`) {#MNT_OFF_PITCH}

Offset for pitch channel output in degrees.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -360.0 | 360.0 |  | 0.0 | deg 

### MNT_OFF_ROLL (`FLOAT`) {#MNT_OFF_ROLL}

Offset for roll channel output in degrees.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -360.0 | 360.0 |  | 0.0 | deg 

### MNT_OFF_YAW (`FLOAT`) {#MNT_OFF_YAW}

Offset for yaw channel output in degrees.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -360.0 | 360.0 |  | 0.0 | deg 

### MNT_RANGE_PITCH (`FLOAT`) {#MNT_RANGE_PITCH}

Range of pitch channel output in degrees (only in AUX output mode).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 720.0 |  | 90.0 | deg 

### MNT_RANGE_ROLL (`FLOAT`) {#MNT_RANGE_ROLL}

Range of roll channel output in degrees (only in AUX output mode).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 720.0 |  | 90.0 | deg 

### MNT_RANGE_YAW (`FLOAT`) {#MNT_RANGE_YAW}

Range of yaw channel output in degrees (only in AUX output mode).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 720.0 |  | 360.0 | deg 

### MNT_RATE_PITCH (`FLOAT`) {#MNT_RATE_PITCH}

Angular pitch rate for manual input in degrees/second.

Full stick input [-1..1] translats to [-pitch rate..pitch rate].

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 90.0 |  | 30.0 | deg/s 

### MNT_RATE_YAW (`FLOAT`) {#MNT_RATE_YAW}

Angular yaw rate for manual input in degrees/second.

Full stick input [-1..1] translats to [-yaw rate..yaw rate].

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 90.0 |  | 30.0 | deg/s 

### MNT_RC_IN_MODE (`INT32`) {#MNT_RC_IN_MODE}

Input mode for RC gimbal input.

**Values:**

- `0`: Angle
- `1`: Angular rate


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1 |  

## Multicopter Acro Mode

### MC_ACRO_EXPO (`FLOAT`) {#MC_ACRO_EXPO}

Acro mode roll, pitch expo factor.

Exponential factor for tuning the input curve shape. 0 Purely linear input curve 1 Purely cubic input curve

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0. |  

### MC_ACRO_EXPO_Y (`FLOAT`) {#MC_ACRO_EXPO_Y}

Acro mode yaw expo factor.

Exponential factor for tuning the input curve shape. 0 Purely linear input curve 1 Purely cubic input curve

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0. |  

### MC_ACRO_P_MAX (`FLOAT`) {#MC_ACRO_P_MAX}

Acro mode maximum pitch rate.

Full stick deflection leads to this rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 100. | deg/s 

### MC_ACRO_R_MAX (`FLOAT`) {#MC_ACRO_R_MAX}

Acro mode maximum roll rate.

Full stick deflection leads to this rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 100. | deg/s 

### MC_ACRO_SUPEXPO (`FLOAT`) {#MC_ACRO_SUPEXPO}

Acro mode roll, pitch super expo factor.

"Superexponential" factor for refining the input curve shape tuned using MC_ACRO_EXPO. 0 Pure Expo function 0.7 reasonable shape enhancement for intuitive stick feel 0.95 very strong bent input curve only near maxima have effect

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.95 |  | 0. |  

### MC_ACRO_SUPEXPOY (`FLOAT`) {#MC_ACRO_SUPEXPOY}

Acro mode yaw super expo factor.

"Superexponential" factor for refining the input curve shape tuned using MC_ACRO_EXPO_Y. 0 Pure Expo function 0.7 reasonable shape enhancement for intuitive stick feel 0.95 very strong bent input curve only near maxima have effect

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.95 |  | 0. |  

### MC_ACRO_Y_MAX (`FLOAT`) {#MC_ACRO_Y_MAX}

Acro mode maximum yaw rate.

Full stick deflection leads to this rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 100. | deg/s 

## Multicopter Attitude Control

### MC_PITCHRATE_MAX (`FLOAT`) {#MC_PITCHRATE_MAX}

Max pitch rate.

Limit for pitch rate in manual and auto modes (except acro). Has effect for large rotations in autonomous mode, to avoid large control output and mixer saturation. This is not only limited by the vehicle's properties, but also by the maximum measurement rate of the gyro.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 220.0 | deg/s 

### MC_PITCH_P (`FLOAT`) {#MC_PITCH_P}

Pitch P gain.

Pitch proportional gain, i.e. desired angular speed in rad/s for error 1 rad.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 12 | 0.1 | 6.5 |  

### MC_ROLLRATE_MAX (`FLOAT`) {#MC_ROLLRATE_MAX}

Max roll rate.

Limit for roll rate in manual and auto modes (except acro). Has effect for large rotations in autonomous mode, to avoid large control output and mixer saturation. This is not only limited by the vehicle's properties, but also by the maximum measurement rate of the gyro.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 220.0 | deg/s 

### MC_ROLL_P (`FLOAT`) {#MC_ROLL_P}

Roll P gain.

Roll proportional gain, i.e. desired angular speed in rad/s for error 1 rad.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 12 | 0.1 | 6.5 |  

### MC_YAWRATE_MAX (`FLOAT`) {#MC_YAWRATE_MAX}

Max yaw rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1800.0 | 5 | 200.0 | deg/s 

### MC_YAW_P (`FLOAT`) {#MC_YAW_P}

Yaw P gain.

Yaw proportional gain, i.e. desired angular speed in rad/s for error 1 rad.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 5 | 0.1 | 2.8 |  

### MC_YAW_WEIGHT (`FLOAT`) {#MC_YAW_WEIGHT}

Yaw weight.

A fraction [0,1] deprioritizing yaw compared to roll and pitch in non-linear attitude control. Deprioritizing yaw is necessary because multicopters have much less control authority in yaw compared to the other axes and it makes sense because yaw is not critical for stable hovering or 3D navigation. For yaw control tuning use MC_YAW_P. This ratio has no impact on the yaw gain.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.1 | 0.4 |  

### MPC_YAWRAUTO_ACC (`FLOAT`) {#MPC_YAWRAUTO_ACC}

Maximum yaw acceleration in autonomous modes.

Limits the acceleration of the yaw setpoint to avoid large control output and mixer saturation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 360 | 5 | 60. | deg/s^2 

### MPC_YAWRAUTO_MAX (`FLOAT`) {#MPC_YAWRAUTO_MAX}

Maximum yaw rate in autonomous modes.

Limits the rate of change of the yaw setpoint to avoid large control output and mixer saturation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 360 | 5 | 45. | deg/s 

## Multicopter Position Control

### CP_DELAY (`FLOAT`) {#CP_DELAY}

Average delay of the range sensor message plus the tracking delay of the position controller in seconds.

Only used in Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0.4 | s 

### CP_DIST (`FLOAT`) {#CP_DIST}

Minimum distance the vehicle should keep to all obstacles.

Only used in Position mode. Collision avoidance is disabled by setting this parameter to a negative value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 15 |  | -1.0 | m 

### CP_GO_NO_DATA (`INT32`) {#CP_GO_NO_DATA}

Boolean to allow moving into directions where there is no sensor data (outside FOV).

Only used in Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### CP_GUIDE_ANG (`FLOAT`) {#CP_GUIDE_ANG}

Angle left/right from the commanded setpoint by which the collision prevention algorithm can choose to change the setpoint direction.

Only used in Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 90 |  | 30. | deg 

### MC_MAN_TILT_TAU (`FLOAT`) {#MC_MAN_TILT_TAU}

Manual tilt input filter time constant.

Setting this parameter to 0 disables the filter

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 2.0 |  | 0.0 | s 

### MPC_ACC_DECOUPLE (`INT32`) {#MPC_ACC_DECOUPLE}

Acceleration to tilt coupling.

Set to decouple tilt from vertical acceleration. This provides smoother flight but slightly worse tracking in position and auto modes. Unset if accurate position tracking during dynamic maneuvers is more important than a smooth flight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MPC_ACC_DOWN_MAX (`FLOAT`) {#MPC_ACC_DOWN_MAX}

Maximum downwards acceleration in climb rate controlled modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 | 1 | 3. | m/s^2 

### MPC_ACC_HOR (`FLOAT`) {#MPC_ACC_HOR}

Acceleration for autonomous and for manual modes.

When piloting manually, this parameter is only used in MPC_POS_MODE Acceleration based.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 | 1 | 3. | m/s^2 

### MPC_ACC_HOR_MAX (`FLOAT`) {#MPC_ACC_HOR_MAX}

Maximum horizontal acceleration.

MPC_POS_MODE 1 just deceleration 4 not used, use MPC_ACC_HOR instead

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 | 1 | 5. | m/s^2 

### MPC_ACC_UP_MAX (`FLOAT`) {#MPC_ACC_UP_MAX}

Maximum upwards acceleration in climb rate controlled modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 | 1 | 4. | m/s^2 

### MPC_ALT_MODE (`INT32`) {#MPC_ALT_MODE}

Altitude reference mode.

Control height 0: relative earth frame origin which may drift due to sensors 1: relative to ground (requires distance sensor) which changes with terrain variation. It will revert to relative earth frame if the distance to ground estimate becomes invalid. 2: relative to ground (requires distance sensor) when stationary and relative to earth frame when moving horizontally. The speed threshold is MPC_HOLD_MAX_XY

**Values:**

- `0`: Altitude following
- `1`: Terrain following
- `2`: Terrain hold


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 |  | 2 |  

### MPC_HOLD_DZ (`FLOAT`) {#MPC_HOLD_DZ}

Deadzone for sticks in manual piloted modes.

Does not apply to manual throttle and direct attitude piloting by stick.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.1 |  

### MPC_HOLD_MAX_XY (`FLOAT`) {#MPC_HOLD_MAX_XY}

Maximum horizontal velocity for which position hold is enabled (use 0 to disable check).

Only used with MPC_POS_MODE Direct velocity or MPC_ALT_MODE 2

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0.8 | m/s 

### MPC_HOLD_MAX_Z (`FLOAT`) {#MPC_HOLD_MAX_Z}

Maximum vertical velocity for which position hold is enabled (use 0 to disable check).

Only used with MPC_ALT_MODE 1

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0.6 | m/s 

### MPC_JERK_AUTO (`FLOAT`) {#MPC_JERK_AUTO}

Jerk limit in autonomous modes.

Limit the maximum jerk of the vehicle (how fast the acceleration can change). A lower value leads to smoother vehicle motions but also limited agility.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 80 | 1 | 4. | m/s^3 

### MPC_JERK_MAX (`FLOAT`) {#MPC_JERK_MAX}

Maximum horizontal and vertical jerk in Position/Altitude mode.

Limit the maximum jerk (acceleration change) of the vehicle. A lower value leads to smoother motions but limits agility. Setting this to the maximum value essentially disables the limit. Only used with MPC_POS_MODE Acceleration based.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 500 | 1 | 8. | m/s^3 

### MPC_LAND_ALT1 (`FLOAT`) {#MPC_LAND_ALT1}

Altitude for 1. step of slow landing (descend).

Below this altitude descending velocity gets limited to a value between "MPC_Z_VEL_MAX_DN" (or "MPC_Z_V_AUTO_DN") and "MPC_LAND_SPEED" Value needs to be higher than "MPC_LAND_ALT2"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 122 |  | 10. | m 

### MPC_LAND_ALT2 (`FLOAT`) {#MPC_LAND_ALT2}

Altitude for 2. step of slow landing (landing).

Below this altitude descending velocity gets limited to "MPC_LAND_SPEED" Value needs to be lower than "MPC_LAND_ALT1"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 122 |  | 5. | m 

### MPC_LAND_ALT3 (`FLOAT`) {#MPC_LAND_ALT3}

Altitude for 3. step of slow landing.

Below this altitude descending velocity gets limited to "MPC_LAND_CRWL", if LIDAR available. No effect if LIDAR not available

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 122 |  | 1. | m 

### MPC_LAND_CRWL (`FLOAT`) {#MPC_LAND_CRWL}

Land crawl descend rate.

Used below MPC_LAND_ALT3 if distance sensor data is availabe.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  |  | 0.3 | m/s 

### MPC_LAND_RADIUS (`FLOAT`) {#MPC_LAND_RADIUS}

User assisted landing radius.

When nudging is enabled (see MPC_LAND_RC_HELP), this controls the maximum allowed horizontal displacement from the original landing point.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 1 | 1000. | m 

### MPC_LAND_RC_HELP (`INT32`) {#MPC_LAND_RC_HELP}

Enable nudging based on user input during autonomous land routine.

Using stick input the vehicle can be moved horizontally and yawed. The descend speed is amended: stick full up - 0 stick centered - MPC_LAND_SPEED stick full down - 2 * MPC_LAND_SPEED Manual override during auto modes has to be disabled to use this feature (see COM_RC_OVERRIDE).

**Values:**

- `0`: Nudging disabled
- `1`: Nudging enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### MPC_LAND_SPEED (`FLOAT`) {#MPC_LAND_SPEED}

Landing descend rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.6 |  |  | 0.7 | m/s 

### MPC_MANTHR_MIN (`FLOAT`) {#MPC_MANTHR_MIN}

Minimum collective thrust in Stabilized mode.

The value is mapped to the lowest throttle stick position in Stabilized mode. Too low collective thrust leads to loss of roll/pitch/yaw torque control authority. Airmode is used to keep torque authority with zero thrust (see MC_AIRMODE).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.08 | norm 

### MPC_MAN_TILT_MAX (`FLOAT`) {#MPC_MAN_TILT_MAX}

Maximal tilt angle in Stabilized or Altitude mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 70 | 1 | 35. | deg 

### MPC_MAN_Y_MAX (`FLOAT`) {#MPC_MAN_Y_MAX}

Max manual yaw rate for Stabilized, Altitude, Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 400 | 10 | 150. | deg/s 

### MPC_MAN_Y_TAU (`FLOAT`) {#MPC_MAN_Y_TAU}

Manual yaw rate input filter time constant.

Not used in Stabilized mode Setting this parameter to 0 disables the filter

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 5 | 0.01 | 0.08 | s 

### MPC_POS_MODE (`INT32`) {#MPC_POS_MODE}

Position/Altitude mode variant.

The supported sub-modes are: Direct velocity: Sticks directly map to velocity setpoints without smoothing. Also applies to vertical direction and Altitude mode. Useful for velocity control tuning. Acceleration based: Sticks map to acceleration and there's a virtual brake drag

**Values:**

- `0`: Direct velocity
- `4`: Acceleration based


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 4 |  

### MPC_THR_CURVE (`INT32`) {#MPC_THR_CURVE}

Thrust curve mapping in Stabilized Mode.

Defines how the throttle stick is mapped to collective thrust in Stabilized mode. Rescale to hover thrust estimate: Stick input is linearly rescaled, such that a centered throttle stick corresponds to the hover thrust estimator's output. No rescale: Directly map the stick 1:1 to the output. Can be useful with very low hover thrust which leads to much distortion and the upper half getting sensitive. Rescale to hover thrust parameter: Similar to rescaling to the hover thrust estimate, but it uses the hover thrust parameter value (see MPC_THR_HOVER) instead of estimated value. With MPC_THR_HOVER 0.5 it's equivalent to No rescale.

**Values:**

- `0`: Rescale to estimate
- `1`: No rescale
- `2`: Rescale to parameter


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MPC_THR_HOVER (`FLOAT`) {#MPC_THR_HOVER}

Vertical thrust required to hover.

Mapped to center throttle stick in Stabilized mode (see MPC_THR_CURVE). Used for initialization of the hover thrust estimator (see MPC_USE_HTE). The estimated hover thrust is used as base for zero vertical acceleration in altitude control. The hover thrust is important for land detection to work correctly.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 0.8 | 0.01 | 0.5 | norm 

### MPC_THR_MAX (`FLOAT`) {#MPC_THR_MAX}

Maximum collective thrust in climb rate controlled modes.

Limit allowed thrust e.g. for indoor test of overpowered vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.05 | 1. | norm 

### MPC_THR_MIN (`FLOAT`) {#MPC_THR_MIN}

Minimum collective thrust in climb rate controlled modes.

Too low thrust leads to loss of roll/pitch/yaw torque control authority. With airmode enabled this parameters can be set to 0 while still keeping torque authority (see MC_AIRMODE).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.05 | 0.5 | 0.01 | 0.12 | norm 

### MPC_THR_XY_MARG (`FLOAT`) {#MPC_THR_XY_MARG}

Horizontal thrust margin.

Margin that is kept for horizontal control when higher priority vertical thrust is saturated. To avoid completely starving horizontal control with high vertical error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 0.5 | 0.01 | 0.3 | norm 

### MPC_TILTMAX_AIR (`FLOAT`) {#MPC_TILTMAX_AIR}

Maximum tilt angle in air.

Absolute maximum for all velocity or acceleration controlled modes. Any higher value is truncated.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 20 | 89 | 1 | 45. | deg 

### MPC_TILTMAX_LND (`FLOAT`) {#MPC_TILTMAX_LND}

Maximum tilt during inital takeoff ramp.

Tighter tilt limit during takeoff to avoid tip over.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 89 | 1 | 12. | deg 

### MPC_TKO_RAMP_T (`FLOAT`) {#MPC_TKO_RAMP_T}

Smooth takeoff ramp time constant.

Increasing this value will make climb rate controlled takeoff slower. If it's too slow the drone might scratch the ground and tip over. A time constant of 0 disables the ramp

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 5 |  | 3. | s 

### MPC_TKO_SPEED (`FLOAT`) {#MPC_TKO_SPEED}

Takeoff climb rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 5 |  | 1.5 | m/s 

### MPC_USE_HTE (`INT32`) {#MPC_USE_HTE}

Hover thrust estimator.

Disable to use the fixed parameter MPC_THR_HOVER. Enable to use the hover thrust estimator. This parameter does not influence Stabilized mode throttle curve (see MPC_THR_CURVE).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### MPC_VELD_LP (`FLOAT`) {#MPC_VELD_LP}

Velocity derivative low pass cutoff frequency.

A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 50 | 0.5 | 5.0 | Hz 

### MPC_VEL_LP (`FLOAT`) {#MPC_VEL_LP}

Velocity low pass cutoff frequency.

A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 50 | 0.5 | 0.0 | Hz 

### MPC_VEL_MANUAL (`FLOAT`) {#MPC_VEL_MANUAL}

Maximum horizontal velocity setpoint in Position mode.

Must be smaller than MPC_XY_VEL_MAX. The maximum sideways and backward speed can be set differently using MPC_VEL_MAN_SIDE and MPC_VEL_MAN_BACK, respectively.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 3 | 20 | 1 | 10. | m/s 

### MPC_VEL_MAN_BACK (`FLOAT`) {#MPC_VEL_MAN_BACK}

Maximum backward velocity in Position mode.

If set to a negative value or larger than MPC_VEL_MANUAL then MPC_VEL_MANUAL is used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 20 | 1 | -1. | m/s 

### MPC_VEL_MAN_SIDE (`FLOAT`) {#MPC_VEL_MAN_SIDE}

Maximum sideways velocity in Position mode.

If set to a negative value or larger than MPC_VEL_MANUAL then MPC_VEL_MANUAL is used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 20 | 1 | -1. | m/s 

### MPC_VEL_NF_BW (`FLOAT`) {#MPC_VEL_NF_BW}

Velocity notch filter bandwidth.

A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 50 | 0.5 | 5.0 | Hz 

### MPC_VEL_NF_FRQ (`FLOAT`) {#MPC_VEL_NF_FRQ}

Velocity notch filter frequency.

The center frequency for the 2nd order notch filter on the velocity. A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 50 | 0.5 | 0.0 | Hz 

### MPC_XY_CRUISE (`FLOAT`) {#MPC_XY_CRUISE}

Default horizontal velocity in autonomous modes.

e.g. in Missions, RTL, Goto if the waypoint does not specify differently

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 3 | 20 | 1 | 5. | m/s 

### MPC_XY_ERR_MAX (`FLOAT`) {#MPC_XY_ERR_MAX}

Maximum horizontal error allowed by the trajectory generator.

The integration speed of the trajectory setpoint is linearly reduced with the horizontal position tracking error. When the error is above this parameter, the integration of the trajectory is stopped to wait for the drone. This value can be adjusted depending on the tracking capabilities of the vehicle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 10 | 1 | 2. |  

### MPC_XY_MAN_EXPO (`FLOAT`) {#MPC_XY_MAN_EXPO}

Manual position control stick exponential curve sensitivity.

The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.6 |  

### MPC_XY_P (`FLOAT`) {#MPC_XY_P}

Proportional gain for horizontal position error.

Defined as corrective velocity in m/s per m position error

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 | 0.1 | 0.95 |  

### MPC_XY_TRAJ_P (`FLOAT`) {#MPC_XY_TRAJ_P}

Proportional gain for horizontal trajectory position error.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1 | 0.1 | 0.5 |  

### MPC_XY_VEL_ALL (`FLOAT`) {#MPC_XY_VEL_ALL}

Overall Horizontal Velocity Limit.

If set to a value greater than zero, other parameters are automatically set (such as MPC_XY_VEL_MAX or MPC_VEL_MANUAL). If set to a negative value, the existing individual parameters are used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -20 | 20 | 1 | -10. |  

### MPC_XY_VEL_D_ACC (`FLOAT`) {#MPC_XY_VEL_D_ACC}

Differential gain for horizontal velocity error.

Defined as corrective acceleration in m/s^2 per m/s^2 velocity derivative

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 2 | 0.02 | 0.2 |  

### MPC_XY_VEL_I_ACC (`FLOAT`) {#MPC_XY_VEL_I_ACC}

Integral gain for horizontal velocity error.

Defined as correction acceleration in m/s^2 per m velocity integral Allows to eliminate steady state errors in disturbances like wind.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 60 | 0.02 | 0.4 |  

### MPC_XY_VEL_MAX (`FLOAT`) {#MPC_XY_VEL_MAX}

Maximum horizontal velocity.

Absolute maximum for all velocity controlled modes. Any higher value is truncated.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 20 | 1 | 12. | m/s 

### MPC_XY_VEL_P_ACC (`FLOAT`) {#MPC_XY_VEL_P_ACC}

Proportional gain for horizontal velocity error.

Defined as corrective acceleration in m/s^2 per m/s velocity error

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.2 | 5 | 0.1 | 1.8 |  

### MPC_YAW_EXPO (`FLOAT`) {#MPC_YAW_EXPO}

Manual control stick yaw rotation exponential curve.

The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.6 |  

### MPC_Z_MAN_EXPO (`FLOAT`) {#MPC_Z_MAN_EXPO}

Manual control stick vertical exponential curve.

The higher the value the less sensitivity the stick has around zero while still reaching the maximum value with full stick deflection. 0 Purely linear input curve 1 Purely cubic input curve

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.6 |  

### MPC_Z_P (`FLOAT`) {#MPC_Z_P}

Proportional gain for vertical position error.

Defined as corrective velocity in m/s per m position error

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 1.5 | 0.1 | 1. |  

### MPC_Z_VEL_ALL (`FLOAT`) {#MPC_Z_VEL_ALL}

Overall Vertical Velocity Limit.

If set to a value greater than zero, other parameters are automatically set (such as MPC_Z_VEL_MAX_UP or MPC_LAND_SPEED). If set to a negative value, the existing individual parameters are used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -3 | 8 | 0.5 | -3. |  

### MPC_Z_VEL_D_ACC (`FLOAT`) {#MPC_Z_VEL_D_ACC}

Differential gain for vertical velocity error.

Defined as corrective acceleration in m/s^2 per m/s^2 velocity derivative

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2 | 0.02 | 0. |  

### MPC_Z_VEL_I_ACC (`FLOAT`) {#MPC_Z_VEL_I_ACC}

Integral gain for vertical velocity error.

Defined as corrective acceleration in m/s^2 per m velocity integral

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.2 | 3 | 0.1 | 2. |  

### MPC_Z_VEL_MAX_DN (`FLOAT`) {#MPC_Z_VEL_MAX_DN}

Maximum descent velocity.

Absolute maximum for all climb rate controlled modes. In manually piloted modes full stick deflection commands this velocity. For default autonomous velocity see MPC_Z_V_AUTO_UP

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 4 | 0.1 | 1.5 | m/s 

### MPC_Z_VEL_MAX_UP (`FLOAT`) {#MPC_Z_VEL_MAX_UP}

Maximum ascent velocity.

Absolute maximum for all climb rate controlled modes. In manually piloted modes full stick deflection commands this velocity. For default autonomous velocity see MPC_Z_V_AUTO_UP

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 8 | 0.1 | 3. | m/s 

### MPC_Z_VEL_P_ACC (`FLOAT`) {#MPC_Z_VEL_P_ACC}

Proportional gain for vertical velocity error.

Defined as corrective acceleration in m/s^2 per m/s velocity error

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 2 | 15 | 0.1 | 4. |  

### MPC_Z_V_AUTO_DN (`FLOAT`) {#MPC_Z_V_AUTO_DN}

Descent velocity in autonomous modes.

For manual modes and offboard, see MPC_Z_VEL_MAX_DN

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 4 | 0.5 | 1.5 | m/s 

### MPC_Z_V_AUTO_UP (`FLOAT`) {#MPC_Z_V_AUTO_UP}

Ascent velocity in autonomous modes.

For manually controlled modes and offboard see MPC_Z_VEL_MAX_UP

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 8 | 0.5 | 3. | m/s 

### SYS_VEHICLE_RESP (`FLOAT`) {#SYS_VEHICLE_RESP}

Responsiveness.

Changes the overall responsiveness of the vehicle. The higher the value, the faster the vehicle will react. If set to a value greater than zero, other parameters are automatically set (such as the acceleration or jerk limits). If set to a negative value, the existing individual parameters are used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 | 0.05 | -0.4 |  

### WV_EN (`INT32`) {#WV_EN}

Enable weathervane.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### WV_ROLL_MIN (`FLOAT`) {#WV_ROLL_MIN}

Minimum roll angle setpoint for weathervane controller to demand a yaw-rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 5 |  | 1.0 | deg 

### WV_YRATE_MAX (`FLOAT`) {#WV_YRATE_MAX}

Maximum yawrate the weathervane controller is allowed to demand.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 120 |  | 90.0 | deg/s 

## Multicopter Position Slow Mode

### MC_SLOW_DEF_HVEL (`FLOAT`) {#MC_SLOW_DEF_HVEL}

Default horizontal velocity limit.

This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | 3. | m/s 

### MC_SLOW_DEF_VVEL (`FLOAT`) {#MC_SLOW_DEF_VVEL}

Default vertical velocity limit.

This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | 1. | m/s 

### MC_SLOW_DEF_YAWR (`FLOAT`) {#MC_SLOW_DEF_YAWR}

Default yaw rate limit.

This value is used in slow mode if no aux channel is mapped and no limit is commanded through MAVLink.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 |  | 0.1 | 45. | deg/s 

### MC_SLOW_MAP_HVEL (`INT32`) {#MC_SLOW_MAP_HVEL}

Manual input mapped to scale horizontal velocity in position slow mode.

**Values:**

- `0`: No rescaling
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MC_SLOW_MAP_PTCH (`INT32`) {#MC_SLOW_MAP_PTCH}

RC_MAP_AUX{N} to allow for gimbal pitch rate control in position slow mode.

**Values:**

- `0`: No pitch rate input
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MC_SLOW_MAP_VVEL (`INT32`) {#MC_SLOW_MAP_VVEL}

Manual input mapped to scale vertical velocity in position slow mode.

**Values:**

- `0`: No rescaling
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MC_SLOW_MAP_YAWR (`INT32`) {#MC_SLOW_MAP_YAWR}

Manual input mapped to scale yaw rate in position slow mode.

**Values:**

- `0`: No rescaling
- `1`: AUX1
- `2`: AUX2
- `3`: AUX3
- `4`: AUX4
- `5`: AUX5
- `6`: AUX6


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### MC_SLOW_MIN_HVEL (`FLOAT`) {#MC_SLOW_MIN_HVEL}

Horizontal velocity lower limit.

The lowest input maps and is clamped to this velocity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | .3 | m/s 

### MC_SLOW_MIN_VVEL (`FLOAT`) {#MC_SLOW_MIN_VVEL}

Vertical velocity lower limit.

The lowest input maps and is clamped to this velocity.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | .3 | m/s 

### MC_SLOW_MIN_YAWR (`FLOAT`) {#MC_SLOW_MIN_YAWR}

Yaw rate lower limit.

The lowest input maps and is clamped to this rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 |  | 0.1 | 3. | deg/s 

## Multicopter Rate Control

### MC_BAT_SCALE_EN (`INT32`) {#MC_BAT_SCALE_EN}

Battery power level scaler.

This compensates for voltage drop of the battery over time by attempting to normalize performance across the operating range of the battery. The copter should constantly behave as if it was fully charged with reduced max acceleration at lower battery percentages. i.e. if hover is at 0.5 throttle at 100% battery, it will still be 0.5 at 60% battery.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### MC_PITCHRATE_D (`FLOAT`) {#MC_PITCHRATE_D}

Pitch rate D gain.

Pitch rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.0005 | 0.003 |  

### MC_PITCHRATE_FF (`FLOAT`) {#MC_PITCHRATE_FF}

Pitch rate feedforward.

Improves tracking performance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  |  | 0.0 |  

### MC_PITCHRATE_I (`FLOAT`) {#MC_PITCHRATE_I}

Pitch rate I gain.

Pitch rate integral gain. Can be set to compensate static thrust difference or gravity center offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.2 |  

### MC_PITCHRATE_K (`FLOAT`) {#MC_PITCHRATE_K}

Pitch rate controller gain.

Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_PITCHRATE_K * (MC_PITCHRATE_P * error + MC_PITCHRATE_I * error_integral + MC_PITCHRATE_D * error_derivative) Set MC_PITCHRATE_P=1 to implement a PID in the ideal form. Set MC_PITCHRATE_K=1 to implement a PID in the parallel form.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 5.0 | 0.0005 | 1.0 |  

### MC_PITCHRATE_P (`FLOAT`) {#MC_PITCHRATE_P}

Pitch rate P gain.

Pitch rate proportional gain, i.e. control output for angular speed error 1 rad/s.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 0.6 | 0.01 | 0.15 |  

### MC_PR_INT_LIM (`FLOAT`) {#MC_PR_INT_LIM}

Pitch rate integrator limit.

Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large pitch moment trim changes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.30 |  

### MC_ROLLRATE_D (`FLOAT`) {#MC_ROLLRATE_D}

Roll rate D gain.

Roll rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.01 | 0.0005 | 0.003 |  

### MC_ROLLRATE_FF (`FLOAT`) {#MC_ROLLRATE_FF}

Roll rate feedforward.

Improves tracking performance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  |  | 0.0 |  

### MC_ROLLRATE_I (`FLOAT`) {#MC_ROLLRATE_I}

Roll rate I gain.

Roll rate integral gain. Can be set to compensate static thrust difference or gravity center offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.2 |  

### MC_ROLLRATE_K (`FLOAT`) {#MC_ROLLRATE_K}

Roll rate controller gain.

Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_ROLLRATE_K * (MC_ROLLRATE_P * error + MC_ROLLRATE_I * error_integral + MC_ROLLRATE_D * error_derivative) Set MC_ROLLRATE_P=1 to implement a PID in the ideal form. Set MC_ROLLRATE_K=1 to implement a PID in the parallel form.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 5.0 | 0.0005 | 1.0 |  

### MC_ROLLRATE_P (`FLOAT`) {#MC_ROLLRATE_P}

Roll rate P gain.

Roll rate proportional gain, i.e. control output for angular speed error 1 rad/s.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 0.5 | 0.01 | 0.15 |  

### MC_RR_INT_LIM (`FLOAT`) {#MC_RR_INT_LIM}

Roll rate integrator limit.

Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large roll moment trim changes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.30 |  

### MC_YAWRATE_D (`FLOAT`) {#MC_YAWRATE_D}

Yaw rate D gain.

Yaw rate differential gain. Small values help reduce fast oscillations. If value is too big oscillations will appear again.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.0 |  

### MC_YAWRATE_FF (`FLOAT`) {#MC_YAWRATE_FF}

Yaw rate feedforward.

Improves tracking performance.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.0 |  

### MC_YAWRATE_I (`FLOAT`) {#MC_YAWRATE_I}

Yaw rate I gain.

Yaw rate integral gain. Can be set to compensate static thrust difference or gravity center offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.1 |  

### MC_YAWRATE_K (`FLOAT`) {#MC_YAWRATE_K}

Yaw rate controller gain.

Global gain of the controller. This gain scales the P, I and D terms of the controller: output = MC_YAWRATE_K * (MC_YAWRATE_P * error + MC_YAWRATE_I * error_integral + MC_YAWRATE_D * error_derivative) Set MC_YAWRATE_P=1 to implement a PID in the ideal form. Set MC_YAWRATE_K=1 to implement a PID in the parallel form.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 5.0 | 0.0005 | 1.0 |  

### MC_YAWRATE_P (`FLOAT`) {#MC_YAWRATE_P}

Yaw rate P gain.

Yaw rate proportional gain, i.e. control output for angular speed error 1 rad/s.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 0.6 | 0.01 | 0.2 |  

### MC_YAW_TQ_CUTOFF (`FLOAT`) {#MC_YAW_TQ_CUTOFF}

Low pass filter cutoff frequency for yaw torque setpoint.

Reduces vibrations by lowering high frequency torque caused by rotor acceleration. 0 disables the filter

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10 |  | 2. | Hz 

### MC_YR_INT_LIM (`FLOAT`) {#MC_YR_INT_LIM}

Yaw rate integrator limit.

Can be set to increase the amount of integrator available to counteract disturbances or reduced to improve settling time after large yaw moment trim changes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.30 |  

## OSD

### MSP_OSD_CONFIG (`INT32`) {#MSP_OSD_CONFIG}

Serial Configuration for MSP OSD.

Configure on which serial port to run MSP OSD.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### OSD_ATXXXX_CFG (`INT32`) {#OSD_ATXXXX_CFG}

Enable/Disable the ATXXX OSD Chip.

Configure the ATXXXX OSD Chip (mounted on the OmnibusF4SD board) and select the transmission standard.

**Values:**

- `0`: Disabled
- `1`: NTSC
- `2`: PAL


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### OSD_CH_HEIGHT (`INT32`) {#OSD_CH_HEIGHT}

OSD Crosshairs Height.

Controls the vertical position of the crosshair display. Resolution is limited by OSD to 15 discrete values. Negative values will display the crosshairs below the horizon

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -8 | 8 |  | 0 |  

### OSD_DWELL_TIME (`INT32`) {#OSD_DWELL_TIME}

OSD Dwell Time (ms).

Amount of time in milliseconds to dwell at the beginning of the display, when scrolling.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 100 | 10000 |  | 500 |  

### OSD_LOG_LEVEL (`INT32`) {#OSD_LOG_LEVEL}

OSD Warning Level.

Minimum security of log level to display on the OSD.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 3 |  

### OSD_SCROLL_RATE (`INT32`) {#OSD_SCROLL_RATE}

OSD Scroll Rate (ms).

Scroll rate in milliseconds for OSD messages longer than available character width. This is lower-bounded by the nominal loop rate of this module.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 100 | 1000 |  | 125 |  

### OSD_SYMBOLS (`INT32`) {#OSD_SYMBOLS}

OSD Symbol Selection.

Configure / toggle support display options.

**Bitmask:**

- `0`: CRAFT_NAME
- `1`: DISARMED
- `2`: GPS_LAT
- `3`: GPS_LON
- `4`: GPS_SATS
- `5`: GPS_SPEED
- `6`: HOME_DIST
- `7`: HOME_DIR
- `8`: MAIN_BATT_VOLTAGE
- `9`: CURRENT_DRAW
- `10`: MAH_DRAWN
- `11`: RSSI_VALUE
- `12`: ALTITUDE
- `13`: NUMERICAL_VARIO
- `14`: (unused) FLYMODE
- `15`: (unused) ESC_TMP
- `16`: (unused) PITCH_ANGLE
- `17`: (unused) ROLL_ANGLE
- `18`: CROSSHAIRS
- `19`: AVG_CELL_VOLTAGE
- `20`: (unused) HORIZON_SIDEBARS
- `21`: POWER


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4194303 |  | 16383 |  

## PWM Outputs

### PWM_SBUS_MODE (`INT32`) {#PWM_SBUS_MODE}

S.BUS out.

Set to 1 to enable S.BUS version 1 output instead of RSSI.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### THR_MDL_FAC (`FLOAT`) {#THR_MDL_FAC}

Thrust to motor control signal model parameter.

Parameter used to model the nonlinear relationship between motor control signal (e.g. PWM) and static thrust. The model is: rel_thrust = factor * rel_signal^2 + (1-factor) * rel_signal, where rel_thrust is the normalized thrust between 0 and 1, and rel_signal is the relative motor control signal between 0 and 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.1 | 0.0 |  

## Payload Deliverer

### PD_GRIPPER_EN (`INT32`) {#PD_GRIPPER_EN}

Enable Gripper actuation in Payload Deliverer.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### PD_GRIPPER_TO (`FLOAT`) {#PD_GRIPPER_TO}

Timeout for successful gripper actuation acknowledgement.

Maximum time Gripper will wait while the successful griper actuation isn't recognised. If the gripper has no feedback sensor, it will simply wait for this time before considering gripper actuation successful and publish a 'VehicleCommandAck' signaling successful gripper action

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 3 | s 

### PD_GRIPPER_TYPE (`INT32`) {#PD_GRIPPER_TYPE}

Type of Gripper (Servo, etc.).

**Values:**

- `-1`: Undefined
- `0`: Servo


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 0 |  | 0 |  

## Precision Land

### PLD_BTOUT (`FLOAT`) {#PLD_BTOUT}

Landing Target Timeout.

Time after which the landing target is considered lost without any new measurements.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 50 | 0.5 | 5.0 | s 

### PLD_FAPPR_ALT (`FLOAT`) {#PLD_FAPPR_ALT}

Final approach altitude.

Allow final approach (without horizontal positioning) if losing landing target closer than this to the ground.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.1 | 0.1 | m 

### PLD_HACC_RAD (`FLOAT`) {#PLD_HACC_RAD}

Horizontal acceptance radius.

Start descending if closer above landing target than this.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10 | 0.1 | 0.2 | m 

### PLD_MAX_SRCH (`INT32`) {#PLD_MAX_SRCH}

Maximum number of search attempts.

Maximum number of times to search for the landing target if it is lost during the precision landing.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 |  | 3 |  

### PLD_SRCH_ALT (`FLOAT`) {#PLD_SRCH_ALT}

Search altitude.

Altitude above home to which to climb when searching for the landing target.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100 | 0.1 | 10.0 | m 

### PLD_SRCH_TOUT (`FLOAT`) {#PLD_SRCH_TOUT}

Search timeout.

Time allowed to search for the landing target before falling back to normal landing.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100 | 0.1 | 10.0 | s 

## Pure Pursuit

### PP_LOOKAHD_GAIN (`FLOAT`) {#PP_LOOKAHD_GAIN}

Tuning parameter for the pure pursuit controller.

Lower value -> More aggressive controller (beware overshoot/oscillations)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 100 | 0.01 | 1.0 |  

### PP_LOOKAHD_MAX (`FLOAT`) {#PP_LOOKAHD_MAX}

Maximum lookahead distance for the pure pursuit controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 100 | 0.01 | 10.0 | m 

### PP_LOOKAHD_MIN (`FLOAT`) {#PP_LOOKAHD_MIN}

Minimum lookahead distance for the pure pursuit controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 100 | 0.01 | 1.0 | m 

## RC

### RC_CRSF_TEL_EN (`INT32`) {#RC_CRSF_TEL_EN}

Crossfire RC telemetry enable.

Crossfire telemetry enable

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### RC_GHST_TEL_EN (`INT32`) {#RC_GHST_TEL_EN}

Ghost RC telemetry enable.

Ghost telemetry enable

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

## RC Input

### RC_INPUT_PROTO (`INT32`) {#RC_INPUT_PROTO}

RC input protocol.

Select your RC input protocol or auto to scan.

**Values:**

- `-1`: Auto
- `0`: None
- `1`: PPM
- `2`: SBUS
- `3`: DSM
- `4`: ST24
- `5`: SUMD
- `6`: CRSF
- `7`: GHST


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 7 |  | -1 |  

## Radio Calibration

### RC10_DZ (`FLOAT`) {#RC10_DZ}

RC channel 10 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC10_MAX (`FLOAT`) {#RC10_MAX}

RC channel 10 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC10_MIN (`FLOAT`) {#RC10_MIN}

RC channel 10 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC10_REV (`FLOAT`) {#RC10_REV}

RC channel 10 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC10_TRIM (`FLOAT`) {#RC10_TRIM}

RC channel 10 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC11_DZ (`FLOAT`) {#RC11_DZ}

RC channel 11 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC11_MAX (`FLOAT`) {#RC11_MAX}

RC channel 11 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC11_MIN (`FLOAT`) {#RC11_MIN}

RC channel 11 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC11_REV (`FLOAT`) {#RC11_REV}

RC channel 11 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC11_TRIM (`FLOAT`) {#RC11_TRIM}

RC channel 11 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC12_DZ (`FLOAT`) {#RC12_DZ}

RC channel 12 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC12_MAX (`FLOAT`) {#RC12_MAX}

RC channel 12 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC12_MIN (`FLOAT`) {#RC12_MIN}

RC channel 12 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC12_REV (`FLOAT`) {#RC12_REV}

RC channel 12 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC12_TRIM (`FLOAT`) {#RC12_TRIM}

RC channel 12 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC13_DZ (`FLOAT`) {#RC13_DZ}

RC channel 13 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC13_MAX (`FLOAT`) {#RC13_MAX}

RC channel 13 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC13_MIN (`FLOAT`) {#RC13_MIN}

RC channel 13 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC13_REV (`FLOAT`) {#RC13_REV}

RC channel 13 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC13_TRIM (`FLOAT`) {#RC13_TRIM}

RC channel 13 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC14_DZ (`FLOAT`) {#RC14_DZ}

RC channel 14 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC14_MAX (`FLOAT`) {#RC14_MAX}

RC channel 14 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC14_MIN (`FLOAT`) {#RC14_MIN}

RC channel 14 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC14_REV (`FLOAT`) {#RC14_REV}

RC channel 14 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC14_TRIM (`FLOAT`) {#RC14_TRIM}

RC channel 14 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC15_DZ (`FLOAT`) {#RC15_DZ}

RC channel 15 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC15_MAX (`FLOAT`) {#RC15_MAX}

RC channel 15 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC15_MIN (`FLOAT`) {#RC15_MIN}

RC channel 15 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC15_REV (`FLOAT`) {#RC15_REV}

RC channel 15 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC15_TRIM (`FLOAT`) {#RC15_TRIM}

RC channel 15 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC16_DZ (`FLOAT`) {#RC16_DZ}

RC channel 16 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC16_MAX (`FLOAT`) {#RC16_MAX}

RC channel 16 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC16_MIN (`FLOAT`) {#RC16_MIN}

RC channel 16 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC16_REV (`FLOAT`) {#RC16_REV}

RC channel 16 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC16_TRIM (`FLOAT`) {#RC16_TRIM}

RC channel 16 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC17_DZ (`FLOAT`) {#RC17_DZ}

RC channel 17 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC17_MAX (`FLOAT`) {#RC17_MAX}

RC channel 17 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC17_MIN (`FLOAT`) {#RC17_MIN}

RC channel 17 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC17_REV (`FLOAT`) {#RC17_REV}

RC channel 17 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC17_TRIM (`FLOAT`) {#RC17_TRIM}

RC channel 17 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC18_DZ (`FLOAT`) {#RC18_DZ}

RC channel 18 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC18_MAX (`FLOAT`) {#RC18_MAX}

RC channel 18 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC18_MIN (`FLOAT`) {#RC18_MIN}

RC channel 18 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC18_REV (`FLOAT`) {#RC18_REV}

RC channel 18 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC18_TRIM (`FLOAT`) {#RC18_TRIM}

RC channel 18 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC1_DZ (`FLOAT`) {#RC1_DZ}

RC channel 1 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 | us 

### RC1_MAX (`FLOAT`) {#RC1_MAX}

RC channel 1 maximum.

Maximum value for RC channel 1

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000.0 | us 

### RC1_MIN (`FLOAT`) {#RC1_MIN}

RC channel 1 minimum.

Minimum value for RC channel 1

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000.0 | us 

### RC1_REV (`FLOAT`) {#RC1_REV}

RC channel 1 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC1_TRIM (`FLOAT`) {#RC1_TRIM}

RC channel 1 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500.0 | us 

### RC2_DZ (`FLOAT`) {#RC2_DZ}

RC channel 2 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 | us 

### RC2_MAX (`FLOAT`) {#RC2_MAX}

RC channel 2 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000.0 | us 

### RC2_MIN (`FLOAT`) {#RC2_MIN}

RC channel 2 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000.0 | us 

### RC2_REV (`FLOAT`) {#RC2_REV}

RC channel 2 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC2_TRIM (`FLOAT`) {#RC2_TRIM}

RC channel 2 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500.0 | us 

### RC3_DZ (`FLOAT`) {#RC3_DZ}

RC channel 3 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 | us 

### RC3_MAX (`FLOAT`) {#RC3_MAX}

RC channel 3 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC3_MIN (`FLOAT`) {#RC3_MIN}

RC channel 3 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC3_REV (`FLOAT`) {#RC3_REV}

RC channel 3 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC3_TRIM (`FLOAT`) {#RC3_TRIM}

RC channel 3 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC4_DZ (`FLOAT`) {#RC4_DZ}

RC channel 4 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 | us 

### RC4_MAX (`FLOAT`) {#RC4_MAX}

RC channel 4 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC4_MIN (`FLOAT`) {#RC4_MIN}

RC channel 4 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC4_REV (`FLOAT`) {#RC4_REV}

RC channel 4 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC4_TRIM (`FLOAT`) {#RC4_TRIM}

RC channel 4 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC5_DZ (`FLOAT`) {#RC5_DZ}

RC channel 5 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 |  

### RC5_MAX (`FLOAT`) {#RC5_MAX}

RC channel 5 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC5_MIN (`FLOAT`) {#RC5_MIN}

RC channel 5 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC5_REV (`FLOAT`) {#RC5_REV}

RC channel 5 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC5_TRIM (`FLOAT`) {#RC5_TRIM}

RC channel 5 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC6_DZ (`FLOAT`) {#RC6_DZ}

RC channel 6 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 |  

### RC6_MAX (`FLOAT`) {#RC6_MAX}

RC channel 6 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC6_MIN (`FLOAT`) {#RC6_MIN}

RC channel 6 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC6_REV (`FLOAT`) {#RC6_REV}

RC channel 6 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC6_TRIM (`FLOAT`) {#RC6_TRIM}

RC channel 6 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC7_DZ (`FLOAT`) {#RC7_DZ}

RC channel 7 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 |  

### RC7_MAX (`FLOAT`) {#RC7_MAX}

RC channel 7 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC7_MIN (`FLOAT`) {#RC7_MIN}

RC channel 7 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC7_REV (`FLOAT`) {#RC7_REV}

RC channel 7 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC7_TRIM (`FLOAT`) {#RC7_TRIM}

RC channel 7 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC8_DZ (`FLOAT`) {#RC8_DZ}

RC channel 8 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 10.0 |  

### RC8_MAX (`FLOAT`) {#RC8_MAX}

RC channel 8 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC8_MIN (`FLOAT`) {#RC8_MIN}

RC channel 8 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC8_REV (`FLOAT`) {#RC8_REV}

RC channel 8 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC8_TRIM (`FLOAT`) {#RC8_TRIM}

RC channel 8 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC9_DZ (`FLOAT`) {#RC9_DZ}

RC channel 9 dead zone.

The +- range of this value around the trim value will be considered as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 100.0 |  | 0.0 |  

### RC9_MAX (`FLOAT`) {#RC9_MAX}

RC channel 9 maximum.

Maximum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1500.0 | 2200.0 |  | 2000 | us 

### RC9_MIN (`FLOAT`) {#RC9_MIN}

RC channel 9 minimum.

Minimum value for this channel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 1500.0 |  | 1000 | us 

### RC9_REV (`FLOAT`) {#RC9_REV}

RC channel 9 reverse.

Set to -1 to reverse channel.

**Values:**

- `-1.0`: Reverse
- `1.0`: Normal


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 | 1.0 |  | 1.0 |  

### RC9_TRIM (`FLOAT`) {#RC9_TRIM}

RC channel 9 trim.

Mid point value

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 800.0 | 2200.0 |  | 1500 | us 

### RC_CHAN_CNT (`INT32`) {#RC_CHAN_CNT}

RC channel count.

This parameter is used by Ground Station software to save the number of channels which were used during RC calibration. It is only meant for ground station use.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_FAILS_THR (`INT32`) {#RC_FAILS_THR}

Failsafe channel PWM threshold.

Use RC_MAP_FAILSAFE to specify which channel is used to indicate RC loss via this threshold. By default this is the throttle channel. Set to a PWM value slightly above the PWM value for the channel (e.g. throttle) in a failsafe event, but below the minimum PWM value for the channel during normal operation. Note: The default value of 0 disables the feature (it is below the expected range).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2200 |  | 0 | us 

### RC_MAP_AUX1 (`INT32`) {#RC_MAP_AUX1}

AUX1 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_AUX2 (`INT32`) {#RC_MAP_AUX2}

AUX2 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_AUX3 (`INT32`) {#RC_MAP_AUX3}

AUX3 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_AUX4 (`INT32`) {#RC_MAP_AUX4}

AUX4 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_AUX5 (`INT32`) {#RC_MAP_AUX5}

AUX5 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_AUX6 (`INT32`) {#RC_MAP_AUX6}

AUX6 Passthrough RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_ENG_MOT (`INT32`) {#RC_MAP_ENG_MOT}

RC channel to engage the main motor (for helicopters).

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_FAILSAFE (`INT32`) {#RC_MAP_FAILSAFE}

Failsafe channel mapping.

Configures which RC channel is used by the receiver to indicate the signal was lost (on receivers that use output a fixed signal value to report lost signal). If set to 0, the channel mapped to throttle is used. Use RC_FAILS_THR to set the threshold indicating lost signal. By default it's below the expected range and hence disabled.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_PARAM1 (`INT32`) {#RC_MAP_PARAM1}

PARAM1 tuning channel.

Can be used for parameter tuning with the RC. This one is further referenced as the 1st parameter channel. Set to 0 to deactivate *

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_PARAM2 (`INT32`) {#RC_MAP_PARAM2}

PARAM2 tuning channel.

Can be used for parameter tuning with the RC. This one is further referenced as the 2nd parameter channel. Set to 0 to deactivate *

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_PARAM3 (`INT32`) {#RC_MAP_PARAM3}

PARAM3 tuning channel.

Can be used for parameter tuning with the RC. This one is further referenced as the 3th parameter channel. Set to 0 to deactivate *

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_PITCH (`INT32`) {#RC_MAP_PITCH}

Pitch control channel mapping.

The channel index (starting from 1 for channel 1) indicates which channel should be used for reading pitch inputs from. A value of zero indicates the switch is not assigned.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_ROLL (`INT32`) {#RC_MAP_ROLL}

Roll control channel mapping.

The channel index (starting from 1 for channel 1) indicates which channel should be used for reading roll inputs from. A value of zero indicates the switch is not assigned.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_THROTTLE (`INT32`) {#RC_MAP_THROTTLE}

Throttle control channel mapping.

The channel index (starting from 1 for channel 1) indicates which channel should be used for reading throttle inputs from. A value of zero indicates the switch is not assigned.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_YAW (`INT32`) {#RC_MAP_YAW}

Yaw control channel mapping.

The channel index (starting from 1 for channel 1) indicates which channel should be used for reading yaw inputs from. A value of zero indicates the switch is not assigned.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_RSSI_PWM_CHAN (`INT32`) {#RC_RSSI_PWM_CHAN}

PWM input channel that provides RSSI.

0: do not read RSSI from input channel 1-18: read RSSI from specified input channel Specify the range for RSSI input with RC_RSSI_PWM_MIN and RC_RSSI_PWM_MAX parameters.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_RSSI_PWM_MAX (`INT32`) {#RC_RSSI_PWM_MAX}

Max input value for RSSI reading.

Only used if RC_RSSI_PWM_CHAN > 0

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2000 |  | 2000 |  

### RC_RSSI_PWM_MIN (`INT32`) {#RC_RSSI_PWM_MIN}

Min input value for RSSI reading.

Only used if RC_RSSI_PWM_CHAN > 0

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2000 |  | 1000 |  

### TRIM_PITCH (`FLOAT`) {#TRIM_PITCH}

Pitch trim.

The trim value is the actuator control value the system needs for straight and level flight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### TRIM_ROLL (`FLOAT`) {#TRIM_ROLL}

Roll trim.

The trim value is the actuator control value the system needs for straight and level flight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

### TRIM_YAW (`FLOAT`) {#TRIM_YAW}

Yaw trim.

The trim value is the actuator control value the system needs for straight and level flight.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -0.5 | 0.5 | 0.01 | 0.0 |  

## Radio Switches

### RC_ARMSWITCH_TH (`FLOAT`) {#RC_ARMSWITCH_TH}

Threshold for the arm switch.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_ENG_MOT_TH (`FLOAT`) {#RC_ENG_MOT_TH}

Threshold for selecting main motor engage.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_GEAR_TH (`FLOAT`) {#RC_GEAR_TH}

Threshold for the landing gear switch.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_KILLSWITCH_TH (`FLOAT`) {#RC_KILLSWITCH_TH}

Threshold for the kill switch.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_LOITER_TH (`FLOAT`) {#RC_LOITER_TH}

Threshold for selecting loiter mode.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_MAP_ARM_SW (`INT32`) {#RC_MAP_ARM_SW}

Arm switch channel.

Use it to arm/disarm via switch instead of default throttle stick. If this is assigned, arming and disarming via stick is disabled.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_FLAPS (`INT32`) {#RC_MAP_FLAPS}

Flaps channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_FLTMODE (`INT32`) {#RC_MAP_FLTMODE}

Single channel flight mode selection.

If this parameter is non-zero, flight modes are only selected by this channel and are assigned to six slots.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_FLTM_BTN (`INT32`) {#RC_MAP_FLTM_BTN}

Button flight mode selection.

This bitmask allows to specify multiple channels for changing flight modes using momentary buttons. Each channel is assigned to a mode slot ((lowest channel = slot 1). The resulting modes for each slot X is defined by the COM_FLTMODEX parameters. The functionality can be used only if RC_MAP_FLTMODE is disabled. The maximum number of available slots and hence bits set in the mask is 6.

**Bitmask:**

- `0`: Mask Channel 1 as a mode button
- `1`: Mask Channel 2 as a mode button
- `2`: Mask Channel 3 as a mode button
- `3`: Mask Channel 4 as a mode button
- `4`: Mask Channel 5 as a mode button
- `5`: Mask Channel 6 as a mode button
- `6`: Mask Channel 7 as a mode button
- `7`: Mask Channel 8 as a mode button
- `8`: Mask Channel 9 as a mode button
- `9`: Mask Channel 10 as a mode button
- `10`: Mask Channel 11 as a mode button
- `11`: Mask Channel 12 as a mode button
- `12`: Mask Channel 13 as a mode button
- `13`: Mask Channel 14 as a mode button
- `14`: Mask Channel 15 as a mode button
- `15`: Mask Channel 16 as a mode button
- `16`: Mask Channel 17 as a mode button
- `17`: Mask Channel 18 as a mode button


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 258048 |  | 0 |  

### RC_MAP_GEAR_SW (`INT32`) {#RC_MAP_GEAR_SW}

Landing gear switch channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_KILL_SW (`INT32`) {#RC_MAP_KILL_SW}

Emergency Kill switch channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_LOITER_SW (`INT32`) {#RC_MAP_LOITER_SW}

Loiter switch channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_MODE_SW (`INT32`) {#RC_MAP_MODE_SW}

Mode switch channel mapping (deprecated).

This is the main flight mode selector. The channel index (starting from 1 for channel 1) indicates which channel should be used for deciding about the main mode. A value of zero indicates the switch is not assigned.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_OFFB_SW (`INT32`) {#RC_MAP_OFFB_SW}

Offboard switch channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_PAY_SW (`INT32`) {#RC_MAP_PAY_SW}

Payload Power Switch RC channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_RETURN_SW (`INT32`) {#RC_MAP_RETURN_SW}

Return switch channel.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_MAP_TRANS_SW (`INT32`) {#RC_MAP_TRANS_SW}

VTOL transition switch channel mapping.

**Values:**

- `0`: Unassigned
- `1`: Channel 1
- `2`: Channel 2
- `3`: Channel 3
- `4`: Channel 4
- `5`: Channel 5
- `6`: Channel 6
- `7`: Channel 7
- `8`: Channel 8
- `9`: Channel 9
- `10`: Channel 10
- `11`: Channel 11
- `12`: Channel 12
- `13`: Channel 13
- `14`: Channel 14
- `15`: Channel 15
- `16`: Channel 16
- `17`: Channel 17
- `18`: Channel 18


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 18 |  | 0 |  

### RC_OFFB_TH (`FLOAT`) {#RC_OFFB_TH}

Threshold for selecting offboard mode.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_PAYLOAD_TH (`FLOAT`) {#RC_PAYLOAD_TH}

Threshold for selecting payload power switch.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_RETURN_TH (`FLOAT`) {#RC_RETURN_TH}

Threshold for selecting return to launch mode.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

### RC_TRANS_TH (`FLOAT`) {#RC_TRANS_TH}

Threshold for the VTOL transition switch.

0-1 indicate where in the full channel range the threshold sits 0 : min 1 : max sign indicates polarity of comparison positive : true when channel>th negative : true when channel<th

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0.75 |  

## Return Mode

### RTL_CONE_ANG (`INT32`) {#RTL_CONE_ANG}

Half-angle of the return mode altitude cone.

Defines the half-angle of a cone centered around the destination position that affects the altitude at which the vehicle returns.

**Values:**

- `0`: No cone, always climb to RTL_RETURN_ALT above destination.
- `25`: 25 degrees half cone angle.
- `45`: 45 degrees half cone angle.
- `65`: 65 degrees half cone angle.
- `80`: 80 degrees half cone angle.
- `90`: Only climb to at least RTL_DESCEND_ALT above destination.


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 90 |  | 45 | deg 

### RTL_DESCEND_ALT (`FLOAT`) {#RTL_DESCEND_ALT}

Return mode loiter altitude.

Descend to this altitude (above destination position) after return, and wait for time defined in RTL_LAND_DELAY. Land (i.e. slowly descend) from this altitude if autolanding allowed. VTOLs do transition to hover in this altitdue above the landing point.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.5 | 30. | m 

### RTL_LAND_DELAY (`FLOAT`) {#RTL_LAND_DELAY}

Return mode delay.

Delay before landing (after initial descent) in Return mode. If set to -1 the system will not land but loiter at RTL_DESCEND_ALT.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 |  | 0.5 | 0.0 | s 

### RTL_LOITER_RAD (`FLOAT`) {#RTL_LOITER_RAD}

Loiter radius for rtl descend.

Set the radius for loitering to a safe altitude for VTOL transition.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 25 |  | 0.5 | 80.0 | m 

### RTL_MIN_DIST (`FLOAT`) {#RTL_MIN_DIST}

Horizontal radius from return point within which special rules for return mode apply.

The return altitude will be calculated based on RTL_CONE_ANG parameter. The yaw setpoint will switch to the one defined by corresponding waypoint.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 |  | 0.5 | 10.0 | m 

### RTL_PLD_MD (`INT32`) {#RTL_PLD_MD}

RTL precision land mode.

Use precision landing when doing an RTL landing phase. This setting does not apply for RTL destinations planned as part of a mission.

**Values:**

- `0`: No precision landing
- `1`: Opportunistic precision landing
- `2`: Required precision landing


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### RTL_RETURN_ALT (`FLOAT`) {#RTL_RETURN_ALT}

Return mode return altitude.

Default minimum altitude above destination (e.g. home, safe point, landing pattern) for return flight. The vehicle will climb to this altitude when Return mode is enganged, unless it currently is flying higher already. This is affected by RTL_MIN_DIST and RTL_CONE_ANG.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  | 0.5 | 60. | m 

### RTL_TYPE (`INT32`) {#RTL_TYPE}

Return type.

Return mode destination and flight path (home location, rally point, mission landing pattern, reverse mission)

**Values:**

- `0`: Return to closest safe point (home or rally point) via direct path.
- `1`: Return to closest safe point other than home (mission landing pattern or rally point), via direct path. If no mission landing or rally points are defined return home via direct path. Always chose closest safe landing point if vehicle is a VTOL in hover mode.
- `2`: Return to a planned mission landing, if available, using the mission path, else return to home via the reverse mission path. Do not consider rally points.
- `3`: Return via direct path to closest destination: home, start of mission landing pattern or safe point. If the destination is a mission landing pattern, follow the pattern to land.


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

## Return To Land

### RTL_APPR_FORCE (`INT32`) {#RTL_APPR_FORCE}

RTL force approach landing.

Only consider RTL point, if it has an approach defined.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### RTL_TIME_FACTOR (`FLOAT`) {#RTL_TIME_FACTOR}

RTL time estimate safety margin factor.

Safety factor that is used to scale the actual RTL time estimate. Time with margin = RTL_TIME_FACTOR * time + RTL_TIME_MARGIN

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 2.0 | 0.1 | 1.1 |  

### RTL_TIME_MARGIN (`INT32`) {#RTL_TIME_MARGIN}

RTL time estimate safety margin offset.

Margin that is added to the time estimate, after it has already been scaled Time with margin = RTL_TIME_FACTOR * time + RTL_TIME_MARGIN

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3600 | 1 | 100 | s 

## Roboclaw

### RBCLW_SER_CFG (`INT32`) {#RBCLW_SER_CFG}

Serial Configuration for Roboclaw Driver.

Configure on which serial port to run Roboclaw Driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

## Roboclaw Driver

### RBCLW_ADDRESS (`INT32`) {#RBCLW_ADDRESS}

Address of the ESC on the bus.

The ESC has to be configured to have an address from 0x80 to 0x87. This parameter needs to match the configured value.

**Values:**

- `128`: 0x80
- `129`: 0x81
- `130`: 0x82
- `131`: 0x83
- `132`: 0x84
- `133`: 0x85
- `134`: 0x86
- `135`: 0x87


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 128 | 135 |  | 128 |  

### RBCLW_COUNTS_REV (`INT32`) {#RBCLW_COUNTS_REV}

Number of encoder counts for one wheel revolution.

The default value of 1200 corresponds to the default configuration of the Aion R1 rover.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 |  |  | 1200 |  

## Rover Ackermann

### RA_ACC_RAD_GAIN (`FLOAT`) {#RA_ACC_RAD_GAIN}

Tuning parameter for corner cutting.

The geometric ideal acceptance radius is multiplied by this factor to account for kinematic and dynamic effects. Higher value -> The rover starts to cut the corner earlier.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 100 | 0.01 | 1 |  

### RA_ACC_RAD_MAX (`FLOAT`) {#RA_ACC_RAD_MAX}

Maximum acceptance radius for the waypoints.

The controller scales the acceptance radius based on the angle between the previous, current and next waypoint. Higher value -> smoother trajectory at the cost of how close the rover gets to the waypoint (Set to -1 to disable corner cutting).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1 | m 

### RA_MAX_STR_ANG (`FLOAT`) {#RA_MAX_STR_ANG}

Maximum steering angle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1.5708 | 0.01 | 0 | rad 

### RA_STR_RATE_LIM (`FLOAT`) {#RA_STR_RATE_LIM}

Steering rate limit.

Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1000 | 0.01 | -1 | deg/s 

### RA_WHEEL_BASE (`FLOAT`) {#RA_WHEEL_BASE}

Wheel base.

Distance from the front to the rear axle.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.001 | 0 | m 

## Rover Attitude Control

### RO_YAW_P (`FLOAT`) {#RO_YAW_P}

Proportional gain for closed loop yaw controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0. |  

## Rover Differential

### RD_MAX_THR_YAW_R (`FLOAT`) {#RD_MAX_THR_YAW_R}

Yaw rate turning left/right wheels at max speed in opposite directions.

This parameter is used to calculate the feedforward term of the closed loop yaw rate control. The controller first calculates the required speed difference between the left and right motor to achieve the desired yaw rate. This desired speed difference is then linearly mapped to normalized motor commands. A good starting point is half the speed the rover drives at maximum throttle (RD_MAX_THR_SPD)). Increase this parameter if the rover turns faster than the setpoint, and decrease if the rover turns slower.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0 | m/s 

### RD_MISS_SPD_GAIN (`FLOAT`) {#RD_MISS_SPD_GAIN}

Tuning parameter for the speed reduction during waypoint transition.

The waypoint transition speed is calculated as: Transition_speed = Maximum_speed * (1 - normalized_transition_angle * RM_MISS_VEL_GAIN) The normalized transition angle is the angle between the line segment from prev-curr WP and curr-next WP interpolated from [0, 180] -> [0, 1]. Higher value -> More speed reduction during waypoint transitions. Set to -1 to disable any speed reduction during waypoint transition.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1 |  

### RD_TRANS_DRV_TRN (`FLOAT`) {#RD_TRANS_DRV_TRN}

Yaw error threshhold to switch from driving to spot turning.

This threshold is used for the state machine to switch from driving to turning based on the error between the desired and actual yaw. It is also used as the threshold whether the rover should come to a smooth stop at the next waypoint. This slow down effect is active if the angle between the line segments from prevWP-currWP and currWP-nextWP is smaller then 180 - RD_TRANS_DRV_TRN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 | 3.14159 | 0.01 | 0.174533 | rad 

### RD_TRANS_TRN_DRV (`FLOAT`) {#RD_TRANS_TRN_DRV}

Yaw error threshhold to switch from spot turning to driving.

This threshold is used for the state machine to switch from turning to driving based on the error between the desired and actual yaw.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.001 | 3.14159 | 0.01 | 0.0872665 | rad 

### RD_WHEEL_TRACK (`FLOAT`) {#RD_WHEEL_TRACK}

Wheel track.

Distance from the center of the right wheel to the center of the left wheel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.001 | 0 | m 

## Rover Mecanum

### RM_COURSE_CTL_TH (`FLOAT`) {#RM_COURSE_CTL_TH}

Threshold to update course control in manual position mode.

Threshold for the angle between the active cruise direction and the cruise direction given by the stick inputs. This can be understood as a deadzone for the combined stick inputs for forward/backwards and lateral speed which defines a course direction.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3.14 | 0.01 | 0.17 | rad 

### RM_MAX_THR_YAW_R (`FLOAT`) {#RM_MAX_THR_YAW_R}

Yaw rate turning left/right wheels at max speed in opposite directions.

This parameter is used to calculate the feedforward term of the closed loop yaw rate control. The controller first calculates the required speed difference between the left and right motor to achieve the desired yaw rate. This desired speed difference is then linearly mapped to normalized motor commands. A good starting point is half the speed the rover drives at maximum throttle (RD_MAX_THR_SPD)). Increase this parameter if the rover turns faster than the setpoint, and decrease if the rover turns slower.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0 | m/s 

### RM_MISS_SPD_GAIN (`FLOAT`) {#RM_MISS_SPD_GAIN}

Tuning parameter for the speed reduction during waypoint transition.

The waypoint transition speed is calculated as: Transition_speed = Maximum_speed * (1 - normalized_transition_angle * RM_MISS_VEL_GAIN) The normalized transition angle is the angle between the line segment from prev-curr waypoint and curr-next waypoint interpolated from [0, 180] -> [0, 1]. Higher value -> More speed reduction during waypoint transitions. Set to -1 to disable any speed reduction during waypoint transition.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1 |  

### RM_WHEEL_TRACK (`FLOAT`) {#RM_WHEEL_TRACK}

Wheel track.

Distance from the center of the right wheel to the center of the left wheel.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.001 | 0 | m 

## Rover Position Control (Deprecated)

### GND_L1_DAMPING (`FLOAT`) {#GND_L1_DAMPING}

L1 damping.

Damping factor for L1 control.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.6 | 0.9 | 0.05 | 0.75 |  

### GND_L1_DIST (`FLOAT`) {#GND_L1_DIST}

L1 distance.

This is the distance at which the next waypoint is activated. This should be set to about 2-4x of GND_WHEEL_BASE and not smaller than one meter (due to GPS accuracy).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 50.0 | 0.1 | 1.0 | m 

### GND_L1_PERIOD (`FLOAT`) {#GND_L1_PERIOD}

L1 period.

This is the L1 distance and defines the tracking point ahead of the rover it's following. Use values around 2-5m for a 0.3m wheel base. Tuning instructions: Shorten slowly during tuning until response is sharp without oscillation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 50.0 | 0.5 | 5.0 | m 

### GND_MAN_Y_MAX (`FLOAT`) {#GND_MAN_Y_MAX}

Max manual yaw rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 400 |  | 150.0 | deg/s 

### GND_MAX_ANG (`FLOAT`) {#GND_MAX_ANG}

Maximum turn angle for Ackerman steering.

At a control output of 0, the steering wheels are at 0 radians. At a control output of 1, the steering wheels are at GND_MAX_ANG radians.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 3.14159 | 0.01 | 0.7854 | rad 

### GND_SPEED_D (`FLOAT`) {#GND_SPEED_D}

Speed proportional gain.

This is the derivative gain for the speed closed loop controller

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00 | 50.0 | 0.005 | 0.001 | %m/s 

### GND_SPEED_I (`FLOAT`) {#GND_SPEED_I}

Speed Integral gain.

This is the integral gain for the speed closed loop controller

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.00 | 50.0 | 0.005 | 3.0 | %m/s 

### GND_SPEED_IMAX (`FLOAT`) {#GND_SPEED_IMAX}

Speed integral maximum value.

This is the maxim value the integral can reach to prevent wind-up.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.005 | 50.0 | 0.005 | 1.0 | %m/s 

### GND_SPEED_MAX (`FLOAT`) {#GND_SPEED_MAX}

Maximum ground speed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 40 | 0.5 | 10.0 | m/s 

### GND_SPEED_P (`FLOAT`) {#GND_SPEED_P}

Speed proportional gain.

This is the proportional gain for the speed closed loop controller

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.005 | 50.0 | 0.005 | 2.0 | %m/s 

### GND_SPEED_THR_SC (`FLOAT`) {#GND_SPEED_THR_SC}

Speed to throttle scaler.

This is a gain to map the speed control output to the throttle linearly.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.005 | 50.0 | 0.005 | 1.0 | %m/s 

### GND_SPEED_TRIM (`FLOAT`) {#GND_SPEED_TRIM}

Trim ground speed.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 40 | 0.5 | 3.0 | m/s 

### GND_SP_CTRL_MODE (`INT32`) {#GND_SP_CTRL_MODE}

Control mode for speed.

This allows the user to choose between closed loop gps speed or open loop cruise throttle speed

**Values:**

- `0`: open loop control
- `1`: close the loop with gps speed


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 1 |  

### GND_THR_CRUISE (`FLOAT`) {#GND_THR_CRUISE}

Cruise throttle.

This is the throttle setting required to achieve the desired cruise speed. 10% is ok for a traxxas stampede vxl with ESC set to training mode

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.1 | norm 

### GND_THR_MAX (`FLOAT`) {#GND_THR_MAX}

Throttle limit max.

This is the maximum throttle % that can be used by the controller. For a Traxxas stampede vxl with the ESC set to training, 30 % is enough

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.3 | norm 

### GND_THR_MIN (`FLOAT`) {#GND_THR_MIN}

Throttle limit min.

This is the minimum throttle % that can be used by the controller. Set to 0 for rover

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 0.0 | norm 

### GND_WHEEL_BASE (`FLOAT`) {#GND_WHEEL_BASE}

Distance from front axle to rear axle.

A value of 0.31 is typical for 1/10 RC cars.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.01 | 0.31 | m 

## Rover Rate Control

### RO_YAW_ACCEL_LIM (`FLOAT`) {#RO_YAW_ACCEL_LIM}

Yaw acceleration limit.

Used to cap how quickly the magnitude of yaw rate setpoints can increase. Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 10000 | 0.01 | -1. | deg/s^2 

### RO_YAW_DECEL_LIM (`FLOAT`) {#RO_YAW_DECEL_LIM}

Yaw deceleration limit.

Used to cap how quickly the magnitude of yaw rate setpoints can decrease. Set to -1 to disable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 10000 | 0.01 | -1. | deg/s^2 

### RO_YAW_RATE_I (`FLOAT`) {#RO_YAW_RATE_I}

Integral gain for closed loop yaw rate controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0. |  

### RO_YAW_RATE_LIM (`FLOAT`) {#RO_YAW_RATE_LIM}

Yaw rate limit.

Used to cap yaw rate setpoints and map controller inputs to yaw rate setpoints in Acro, Stabilized and Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 10000 | 0.01 | 0. | deg/s 

### RO_YAW_RATE_P (`FLOAT`) {#RO_YAW_RATE_P}

Proportional gain for closed loop yaw rate controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0. |  

### RO_YAW_RATE_TH (`FLOAT`) {#RO_YAW_RATE_TH}

Yaw rate measurement threshold.

The minimum threshold for the yaw rate measurement not to be interpreted as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 3. | deg/s 

### RO_YAW_STICK_DZ (`FLOAT`) {#RO_YAW_STICK_DZ}

Yaw stick deadzone.

Percentage of stick input range that will be interpreted as zero around the stick centered value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 | 0.01 | 0.1 |  

## Rover Velocity Control

### RO_ACCEL_LIM (`FLOAT`) {#RO_ACCEL_LIM}

Acceleration limit.

Set to -1 to disable. For mecanum rovers this limit is used for longitudinal and lateral acceleration.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1. | m/s^2 

### RO_DECEL_LIM (`FLOAT`) {#RO_DECEL_LIM}

Deceleration limit.

Set to -1 to disable. Note that if it is disabled the rover will not slow down when approaching waypoints in auto modes. For mecanum rovers this limit is used for longitudinal and lateral deceleration.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1. | m/s^2 

### RO_JERK_LIM (`FLOAT`) {#RO_JERK_LIM}

Jerk limit.

Set to -1 to disable. Note that if it is disabled the rover will not slow down when approaching waypoints in auto modes. For mecanum rovers this limit is used for longitudinal and lateral jerk.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1. | m/s^3 

### RO_MAX_THR_SPEED (`FLOAT`) {#RO_MAX_THR_SPEED}

Speed the rover drives at maximum throttle.

Used to linearly map speeds [m/s] to throttle values [-1. 1].

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0. | m/s 

### RO_SPEED_I (`FLOAT`) {#RO_SPEED_I}

Integral gain for ground speed controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.001 | 0. |  

### RO_SPEED_LIM (`FLOAT`) {#RO_SPEED_LIM}

Speed limit.

Used to cap speed setpoints and map controller inputs to speed setpoints in Position mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 | 0.01 | -1. | m/s 

### RO_SPEED_P (`FLOAT`) {#RO_SPEED_P}

Proportional gain for ground speed controller.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0. |  

### RO_SPEED_TH (`FLOAT`) {#RO_SPEED_TH}

Speed measurement threshold.

Set to -1 to disable. The minimum threshold for the speed measurement not to be interpreted as zero.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.01 | 0.1 | m/s 

## Runway Takeoff

### RWTO_HDG (`INT32`) {#RWTO_HDG}

Specifies which heading should be held during the runway takeoff ground roll.

0: airframe heading when takeoff is initiated 1: position control along runway direction (bearing defined from vehicle position on takeoff initiation to MAV_CMD_TAKEOFF position defined by operator)

**Values:**

- `0`: Airframe
- `1`: Runway


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### RWTO_MAX_THR (`FLOAT`) {#RWTO_MAX_THR}

Max throttle during runway takeoff.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.01 | 1.0 | norm 

### RWTO_NPFG_PERIOD (`FLOAT`) {#RWTO_NPFG_PERIOD}

NPFG period while steering on runway.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 100.0 | 0.1 | 5.0 | s 

### RWTO_NUDGE (`INT32`) {#RWTO_NUDGE}

Enable use of yaw stick for nudging the wheel during runway ground roll.

This is useful when map, GNSS, or yaw errors on ground are misaligned with what the operator intends for takeoff course. Particularly useful for skinny runways or if the wheel servo is a bit off trim.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### RWTO_PSP (`FLOAT`) {#RWTO_PSP}

Pitch setpoint during taxi / before takeoff rotation airspeed is reached.

A taildragger with steerable wheel might need to pitch up a little to keep its wheel on the ground before airspeed to takeoff is reached.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -10.0 | 20.0 | 0.5 | 0.0 | deg 

### RWTO_RAMP_TIME (`FLOAT`) {#RWTO_RAMP_TIME}

Throttle ramp up time for runway takeoff.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 15.0 | 0.1 | 2.0 | s 

### RWTO_ROT_AIRSPD (`FLOAT`) {#RWTO_ROT_AIRSPD}

Takeoff rotation airspeed.

The calibrated airspeed threshold during the takeoff ground roll when the plane should start rotating (pitching up). Must be less than the takeoff airspeed, will otherwise be capped at the takeoff airpeed (see FW_TKO_AIRSPD). If set <= 0.0, defaults to 0.9 * takeoff airspeed (see FW_TKO_AIRSPD)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1.0 |  | 0.1 | -1.0 | m/s 

### RWTO_ROT_TIME (`FLOAT`) {#RWTO_ROT_TIME}

Takeoff rotation time.

This is the time desired to linearly ramp in takeoff pitch constraints during the takeoff rotation

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 |  | 0.1 | 1.0 | s 

### RWTO_TKOFF (`INT32`) {#RWTO_TKOFF}

Runway takeoff with landing gear.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

## SD Logging

### SDLOG_ALGORITHM (`INT32`) {#SDLOG_ALGORITHM}

Logfile Encryption algorithm.

Selects the algorithm used for logfile encryption

**Values:**

- `0`: Disabled
- `2`: XChaCha20


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### SDLOG_BOOT_BAT (`INT32`) {#SDLOG_BOOT_BAT}

Battery-only Logging.

When enabled, logging will not start from boot if battery power is not detected (e.g. powered via USB on a test bench). This prevents extraneous flight logs from being created during bench testing. Note that this only applies to log-from-boot modes. This has no effect on arm-based modes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### SDLOG_DIRS_MAX (`INT32`) {#SDLOG_DIRS_MAX}

Maximum number of log directories to keep.

If there are more log directories than this value, the system will delete the oldest directories during startup. In addition, the system will delete old logs if there is not enough free space left. The minimum amount is 300 MB. If this is set to 0, old directories will only be removed if the free space falls below the minimum. Note: this does not apply to mission log files.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 0 |  

### SDLOG_EXCH_KEY (`INT32`) {#SDLOG_EXCH_KEY}

Logfile Encryption key exchange key.

If the logfile is encrypted using a symmetric key algorithm, the used encryption key is generated at logging start and stored on the sdcard RSA2048 encrypted using this key.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 1 |  

### SDLOG_KEY (`INT32`) {#SDLOG_KEY}

Logfile Encryption key index.

Selects the key in keystore, used for encrypting the log. When using a symmetric encryption algorithm, the key is generated at logging start and kept stored in this index. For symmetric algorithms, the key is volatile and valid only for the duration of logging. The key is stored in encrypted format on the sdcard alongside the logfile, using an RSA2048 key defined by the SDLOG_EXCHANGE_KEY

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 255 |  | 2 |  

### SDLOG_MISSION (`INT32`) {#SDLOG_MISSION}

Mission Log.

If enabled, a small additional "mission" log file will be written to the SD card. The log contains just those messages that are useful for tasks like generating flight statistics and geotagging. The different modes can be used to further reduce the logged data (and thus the log file size). For example, choose geotagging mode to only log data required for geotagging. Note that the normal/full log is still created, and contains all the data in the mission log (and more).

**Values:**

- `0`: Disabled
- `1`: All mission messages
- `2`: Geotagging messages


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SDLOG_MODE (`INT32`) {#SDLOG_MODE}

Logging Mode.

Determines when to start and stop logging. By default, logging is started when arming the system, and stopped when disarming.

**Values:**

- `-1`: disabled
- `0`: when armed until disarm (default)
- `1`: from boot until disarm
- `2`: from boot until shutdown
- `3`: while manual input AUX1 >30%
- `4`: from 1st armed until shutdown


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SDLOG_PROFILE (`INT32`) {#SDLOG_PROFILE}

Logging topic profile (integer bitmask).

This integer bitmask controls the set and rates of logged topics. The default allows for general log analysis while keeping the log file size reasonably small. Enabling multiple sets leads to higher bandwidth requirements and larger log files. Set bits true to enable: 0 : Default set (used for general log analysis) 1 : Full rate estimator (EKF2) replay topics 2 : Topics for thermal calibration (high rate raw IMU and Baro sensor data) 3 : Topics for system identification (high rate actuator control and IMU data) 4 : Full rates for analysis of fast maneuvers (RC, attitude, rates and actuators) 5 : Debugging topics (debug_*.msg topics, for custom code) 6 : Topics for sensor comparison (low rate raw IMU, Baro and magnetometer data) 7 : Topics for computer vision and collision prevention 8 : Raw FIFO high-rate IMU (Gyro) 9 : Raw FIFO high-rate IMU (Accel) 10: Logging of mavlink tunnel message (useful for payload communication debugging)

**Bitmask:**

- `0`: Default set (general log analysis)
- `1`: Estimator replay (EKF2)
- `2`: Thermal calibration
- `3`: System identification
- `4`: High rate
- `5`: Debug
- `6`: Sensor comparison
- `7`: Computer Vision and Avoidance
- `8`: Raw FIFO high-rate IMU (Gyro)
- `9`: Raw FIFO high-rate IMU (Accel)
- `10`: Mavlink tunnel message logging


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2047 |  | 1 |  

### SDLOG_UTC_OFFSET (`INT32`) {#SDLOG_UTC_OFFSET}

UTC offset (unit: min).

the difference in hours and minutes from Coordinated Universal Time (UTC) for a your place and date. for example, In case of South Korea(UTC+09:00), UTC offset is 540 min (9*60) refer to https://en.wikipedia.org/wiki/List_of_UTC_time_offsets

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1000 | 1000 |  | 0 | min 

### SDLOG_UUID (`INT32`) {#SDLOG_UUID}

Log UUID.

If set to 1, add an ID to the log, which uniquely identifies the vehicle

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

## SITL

### SIM_BAT_DRAIN (`FLOAT`) {#SIM_BAT_DRAIN}

Simulator Battery drain interval.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 86400 | 1 | 60 | s 

### SIM_BAT_ENABLE (`INT32`) {#SIM_BAT_ENABLE}

Simulator Battery enabled.

Enable or disable the internal battery simulation. This is useful when the battery is simulated externally and interfaced with PX4 through MAVLink for example.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SIM_BAT_MIN_PCT (`FLOAT`) {#SIM_BAT_MIN_PCT}

Simulator Battery minimal percentage.

Can be used to alter the battery level during SITL- or HITL-simulation on the fly. Particularly useful for testing different low-battery behaviour.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 100 | 0.1 | 50.0 | % 

## Sensor Calibration

### CAL_ACC0_ID (`INT32`) {#CAL_ACC0_ID}

Accelerometer 0 calibration device ID.

Device ID of the accelerometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_ACC0_PRIO (`INT32`) {#CAL_ACC0_PRIO}

Accelerometer 0 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_ACC0_ROT (`INT32`) {#CAL_ACC0_ROT}

Accelerometer 0 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_ACC0_XOFF (`FLOAT`) {#CAL_ACC0_XOFF}

Accelerometer 0 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC0_XSCALE (`FLOAT`) {#CAL_ACC0_XSCALE}

Accelerometer 0 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC0_YOFF (`FLOAT`) {#CAL_ACC0_YOFF}

Accelerometer 0 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC0_YSCALE (`FLOAT`) {#CAL_ACC0_YSCALE}

Accelerometer 0 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC0_ZOFF (`FLOAT`) {#CAL_ACC0_ZOFF}

Accelerometer 0 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC0_ZSCALE (`FLOAT`) {#CAL_ACC0_ZSCALE}

Accelerometer 0 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC1_ID (`INT32`) {#CAL_ACC1_ID}

Accelerometer 1 calibration device ID.

Device ID of the accelerometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_ACC1_PRIO (`INT32`) {#CAL_ACC1_PRIO}

Accelerometer 1 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_ACC1_ROT (`INT32`) {#CAL_ACC1_ROT}

Accelerometer 1 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_ACC1_XOFF (`FLOAT`) {#CAL_ACC1_XOFF}

Accelerometer 1 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC1_XSCALE (`FLOAT`) {#CAL_ACC1_XSCALE}

Accelerometer 1 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC1_YOFF (`FLOAT`) {#CAL_ACC1_YOFF}

Accelerometer 1 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC1_YSCALE (`FLOAT`) {#CAL_ACC1_YSCALE}

Accelerometer 1 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC1_ZOFF (`FLOAT`) {#CAL_ACC1_ZOFF}

Accelerometer 1 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC1_ZSCALE (`FLOAT`) {#CAL_ACC1_ZSCALE}

Accelerometer 1 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC2_ID (`INT32`) {#CAL_ACC2_ID}

Accelerometer 2 calibration device ID.

Device ID of the accelerometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_ACC2_PRIO (`INT32`) {#CAL_ACC2_PRIO}

Accelerometer 2 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_ACC2_ROT (`INT32`) {#CAL_ACC2_ROT}

Accelerometer 2 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_ACC2_XOFF (`FLOAT`) {#CAL_ACC2_XOFF}

Accelerometer 2 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC2_XSCALE (`FLOAT`) {#CAL_ACC2_XSCALE}

Accelerometer 2 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC2_YOFF (`FLOAT`) {#CAL_ACC2_YOFF}

Accelerometer 2 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC2_YSCALE (`FLOAT`) {#CAL_ACC2_YSCALE}

Accelerometer 2 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC2_ZOFF (`FLOAT`) {#CAL_ACC2_ZOFF}

Accelerometer 2 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC2_ZSCALE (`FLOAT`) {#CAL_ACC2_ZSCALE}

Accelerometer 2 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC3_ID (`INT32`) {#CAL_ACC3_ID}

Accelerometer 3 calibration device ID.

Device ID of the accelerometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_ACC3_PRIO (`INT32`) {#CAL_ACC3_PRIO}

Accelerometer 3 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_ACC3_ROT (`INT32`) {#CAL_ACC3_ROT}

Accelerometer 3 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_ACC3_XOFF (`FLOAT`) {#CAL_ACC3_XOFF}

Accelerometer 3 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC3_XSCALE (`FLOAT`) {#CAL_ACC3_XSCALE}

Accelerometer 3 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC3_YOFF (`FLOAT`) {#CAL_ACC3_YOFF}

Accelerometer 3 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC3_YSCALE (`FLOAT`) {#CAL_ACC3_YSCALE}

Accelerometer 3 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_ACC3_ZOFF (`FLOAT`) {#CAL_ACC3_ZOFF}

Accelerometer 3 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m/s^2 

### CAL_ACC3_ZSCALE (`FLOAT`) {#CAL_ACC3_ZSCALE}

Accelerometer 3 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_BARO0_ID (`INT32`) {#CAL_BARO0_ID}

Barometer 0 calibration device ID.

Device ID of the barometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_BARO0_OFF (`FLOAT`) {#CAL_BARO0_OFF}

Barometer 0 offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_BARO0_PRIO (`INT32`) {#CAL_BARO0_PRIO}

Barometer 0 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_BARO1_ID (`INT32`) {#CAL_BARO1_ID}

Barometer 1 calibration device ID.

Device ID of the barometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_BARO1_OFF (`FLOAT`) {#CAL_BARO1_OFF}

Barometer 1 offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_BARO1_PRIO (`INT32`) {#CAL_BARO1_PRIO}

Barometer 1 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_BARO2_ID (`INT32`) {#CAL_BARO2_ID}

Barometer 2 calibration device ID.

Device ID of the barometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_BARO2_OFF (`FLOAT`) {#CAL_BARO2_OFF}

Barometer 2 offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_BARO2_PRIO (`INT32`) {#CAL_BARO2_PRIO}

Barometer 2 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_BARO3_ID (`INT32`) {#CAL_BARO3_ID}

Barometer 3 calibration device ID.

Device ID of the barometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_BARO3_OFF (`FLOAT`) {#CAL_BARO3_OFF}

Barometer 3 offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_BARO3_PRIO (`INT32`) {#CAL_BARO3_PRIO}

Barometer 3 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_GYRO0_ID (`INT32`) {#CAL_GYRO0_ID}

Gyroscope 0 calibration device ID.

Device ID of the gyroscope this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_GYRO0_PRIO (`INT32`) {#CAL_GYRO0_PRIO}

Gyroscope 0 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_GYRO0_ROT (`INT32`) {#CAL_GYRO0_ROT}

Gyroscope 0 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_GYRO0_XOFF (`FLOAT`) {#CAL_GYRO0_XOFF}

Gyroscope 0 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO0_YOFF (`FLOAT`) {#CAL_GYRO0_YOFF}

Gyroscope 0 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO0_ZOFF (`FLOAT`) {#CAL_GYRO0_ZOFF}

Gyroscope 0 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO1_ID (`INT32`) {#CAL_GYRO1_ID}

Gyroscope 1 calibration device ID.

Device ID of the gyroscope this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_GYRO1_PRIO (`INT32`) {#CAL_GYRO1_PRIO}

Gyroscope 1 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_GYRO1_ROT (`INT32`) {#CAL_GYRO1_ROT}

Gyroscope 1 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_GYRO1_XOFF (`FLOAT`) {#CAL_GYRO1_XOFF}

Gyroscope 1 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO1_YOFF (`FLOAT`) {#CAL_GYRO1_YOFF}

Gyroscope 1 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO1_ZOFF (`FLOAT`) {#CAL_GYRO1_ZOFF}

Gyroscope 1 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO2_ID (`INT32`) {#CAL_GYRO2_ID}

Gyroscope 2 calibration device ID.

Device ID of the gyroscope this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_GYRO2_PRIO (`INT32`) {#CAL_GYRO2_PRIO}

Gyroscope 2 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_GYRO2_ROT (`INT32`) {#CAL_GYRO2_ROT}

Gyroscope 2 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_GYRO2_XOFF (`FLOAT`) {#CAL_GYRO2_XOFF}

Gyroscope 2 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO2_YOFF (`FLOAT`) {#CAL_GYRO2_YOFF}

Gyroscope 2 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO2_ZOFF (`FLOAT`) {#CAL_GYRO2_ZOFF}

Gyroscope 2 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO3_ID (`INT32`) {#CAL_GYRO3_ID}

Gyroscope 3 calibration device ID.

Device ID of the gyroscope this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_GYRO3_PRIO (`INT32`) {#CAL_GYRO3_PRIO}

Gyroscope 3 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_GYRO3_ROT (`INT32`) {#CAL_GYRO3_ROT}

Gyroscope 3 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 40 |  | -1 |  

### CAL_GYRO3_XOFF (`FLOAT`) {#CAL_GYRO3_XOFF}

Gyroscope 3 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO3_YOFF (`FLOAT`) {#CAL_GYRO3_YOFF}

Gyroscope 3 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_GYRO3_ZOFF (`FLOAT`) {#CAL_GYRO3_ZOFF}

Gyroscope 3 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | rad/s 

### CAL_MAG0_ID (`INT32`) {#CAL_MAG0_ID}

Magnetometer 0 calibration device ID.

Device ID of the magnetometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_MAG0_PITCH (`FLOAT`) {#CAL_MAG0_PITCH}

Magnetometer 0 Custom Euler Pitch Angle.

Setting this parameter changes CAL_MAG0_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG0_PRIO (`INT32`) {#CAL_MAG0_PRIO}

Magnetometer 0 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_MAG0_ROLL (`FLOAT`) {#CAL_MAG0_ROLL}

Magnetometer 0 Custom Euler Roll Angle.

Setting this parameter changes CAL_MAG0_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG0_ROT (`INT32`) {#CAL_MAG0_ROT}

Magnetometer 0 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to "Custom Euler Angle" to define the rotation using CAL_MAG0_ROLL, CAL_MAG0_PITCH and CAL_MAG0_YAW.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°
- `100`: Custom Euler Angle


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 |  | -1 |  

### CAL_MAG0_XCOMP (`FLOAT`) {#CAL_MAG0_XCOMP}

Magnetometer 0 X Axis throttle compensation.

Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_XODIAG (`FLOAT`) {#CAL_MAG0_XODIAG}

Magnetometer 0 X-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_XOFF (`FLOAT`) {#CAL_MAG0_XOFF}

Magnetometer 0 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG0_XSCALE (`FLOAT`) {#CAL_MAG0_XSCALE}

Magnetometer 0 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG0_YAW (`FLOAT`) {#CAL_MAG0_YAW}

Magnetometer 0 Custom Euler Yaw Angle.

Setting this parameter changes CAL_MAG0_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG0_YCOMP (`FLOAT`) {#CAL_MAG0_YCOMP}

Magnetometer 0 Y Axis throttle compensation.

Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_YODIAG (`FLOAT`) {#CAL_MAG0_YODIAG}

Magnetometer 0 Y-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_YOFF (`FLOAT`) {#CAL_MAG0_YOFF}

Magnetometer 0 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG0_YSCALE (`FLOAT`) {#CAL_MAG0_YSCALE}

Magnetometer 0 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG0_ZCOMP (`FLOAT`) {#CAL_MAG0_ZCOMP}

Magnetometer 0 Z Axis throttle compensation.

Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_ZODIAG (`FLOAT`) {#CAL_MAG0_ZODIAG}

Magnetometer 0 Z-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG0_ZOFF (`FLOAT`) {#CAL_MAG0_ZOFF}

Magnetometer 0 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG0_ZSCALE (`FLOAT`) {#CAL_MAG0_ZSCALE}

Magnetometer 0 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG1_ID (`INT32`) {#CAL_MAG1_ID}

Magnetometer 1 calibration device ID.

Device ID of the magnetometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_MAG1_PITCH (`FLOAT`) {#CAL_MAG1_PITCH}

Magnetometer 1 Custom Euler Pitch Angle.

Setting this parameter changes CAL_MAG1_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG1_PRIO (`INT32`) {#CAL_MAG1_PRIO}

Magnetometer 1 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_MAG1_ROLL (`FLOAT`) {#CAL_MAG1_ROLL}

Magnetometer 1 Custom Euler Roll Angle.

Setting this parameter changes CAL_MAG1_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG1_ROT (`INT32`) {#CAL_MAG1_ROT}

Magnetometer 1 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to "Custom Euler Angle" to define the rotation using CAL_MAG1_ROLL, CAL_MAG1_PITCH and CAL_MAG1_YAW.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°
- `100`: Custom Euler Angle


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 |  | -1 |  

### CAL_MAG1_XCOMP (`FLOAT`) {#CAL_MAG1_XCOMP}

Magnetometer 1 X Axis throttle compensation.

Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_XODIAG (`FLOAT`) {#CAL_MAG1_XODIAG}

Magnetometer 1 X-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_XOFF (`FLOAT`) {#CAL_MAG1_XOFF}

Magnetometer 1 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG1_XSCALE (`FLOAT`) {#CAL_MAG1_XSCALE}

Magnetometer 1 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG1_YAW (`FLOAT`) {#CAL_MAG1_YAW}

Magnetometer 1 Custom Euler Yaw Angle.

Setting this parameter changes CAL_MAG1_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG1_YCOMP (`FLOAT`) {#CAL_MAG1_YCOMP}

Magnetometer 1 Y Axis throttle compensation.

Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_YODIAG (`FLOAT`) {#CAL_MAG1_YODIAG}

Magnetometer 1 Y-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_YOFF (`FLOAT`) {#CAL_MAG1_YOFF}

Magnetometer 1 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG1_YSCALE (`FLOAT`) {#CAL_MAG1_YSCALE}

Magnetometer 1 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG1_ZCOMP (`FLOAT`) {#CAL_MAG1_ZCOMP}

Magnetometer 1 Z Axis throttle compensation.

Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_ZODIAG (`FLOAT`) {#CAL_MAG1_ZODIAG}

Magnetometer 1 Z-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG1_ZOFF (`FLOAT`) {#CAL_MAG1_ZOFF}

Magnetometer 1 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG1_ZSCALE (`FLOAT`) {#CAL_MAG1_ZSCALE}

Magnetometer 1 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG2_ID (`INT32`) {#CAL_MAG2_ID}

Magnetometer 2 calibration device ID.

Device ID of the magnetometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_MAG2_PITCH (`FLOAT`) {#CAL_MAG2_PITCH}

Magnetometer 2 Custom Euler Pitch Angle.

Setting this parameter changes CAL_MAG2_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG2_PRIO (`INT32`) {#CAL_MAG2_PRIO}

Magnetometer 2 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_MAG2_ROLL (`FLOAT`) {#CAL_MAG2_ROLL}

Magnetometer 2 Custom Euler Roll Angle.

Setting this parameter changes CAL_MAG2_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG2_ROT (`INT32`) {#CAL_MAG2_ROT}

Magnetometer 2 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to "Custom Euler Angle" to define the rotation using CAL_MAG2_ROLL, CAL_MAG2_PITCH and CAL_MAG2_YAW.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°
- `100`: Custom Euler Angle


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 |  | -1 |  

### CAL_MAG2_XCOMP (`FLOAT`) {#CAL_MAG2_XCOMP}

Magnetometer 2 X Axis throttle compensation.

Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_XODIAG (`FLOAT`) {#CAL_MAG2_XODIAG}

Magnetometer 2 X-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_XOFF (`FLOAT`) {#CAL_MAG2_XOFF}

Magnetometer 2 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG2_XSCALE (`FLOAT`) {#CAL_MAG2_XSCALE}

Magnetometer 2 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG2_YAW (`FLOAT`) {#CAL_MAG2_YAW}

Magnetometer 2 Custom Euler Yaw Angle.

Setting this parameter changes CAL_MAG2_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG2_YCOMP (`FLOAT`) {#CAL_MAG2_YCOMP}

Magnetometer 2 Y Axis throttle compensation.

Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_YODIAG (`FLOAT`) {#CAL_MAG2_YODIAG}

Magnetometer 2 Y-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_YOFF (`FLOAT`) {#CAL_MAG2_YOFF}

Magnetometer 2 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG2_YSCALE (`FLOAT`) {#CAL_MAG2_YSCALE}

Magnetometer 2 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG2_ZCOMP (`FLOAT`) {#CAL_MAG2_ZCOMP}

Magnetometer 2 Z Axis throttle compensation.

Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_ZODIAG (`FLOAT`) {#CAL_MAG2_ZODIAG}

Magnetometer 2 Z-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG2_ZOFF (`FLOAT`) {#CAL_MAG2_ZOFF}

Magnetometer 2 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG2_ZSCALE (`FLOAT`) {#CAL_MAG2_ZSCALE}

Magnetometer 2 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG3_ID (`INT32`) {#CAL_MAG3_ID}

Magnetometer 3 calibration device ID.

Device ID of the magnetometer this calibration applies to.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_MAG3_PITCH (`FLOAT`) {#CAL_MAG3_PITCH}

Magnetometer 3 Custom Euler Pitch Angle.

Setting this parameter changes CAL_MAG3_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG3_PRIO (`INT32`) {#CAL_MAG3_PRIO}

Magnetometer 3 priority.

**Values:**

- `-1`: Uninitialized
- `0`: Disabled
- `1`: Min
- `25`: Low
- `50`: Medium (Default)
- `75`: High
- `100`: Max


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### CAL_MAG3_ROLL (`FLOAT`) {#CAL_MAG3_ROLL}

Magnetometer 3 Custom Euler Roll Angle.

Setting this parameter changes CAL_MAG3_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG3_ROT (`INT32`) {#CAL_MAG3_ROT}

Magnetometer 3 rotation relative to airframe.

An internal sensor will force a value of -1, so a GCS should only attempt to configure the rotation if the value is greater than or equal to zero. Set to "Custom Euler Angle" to define the rotation using CAL_MAG3_ROLL, CAL_MAG3_PITCH and CAL_MAG3_YAW.

**Values:**

- `-1`: Internal
- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°
- `100`: Custom Euler Angle


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 100 |  | -1 |  

### CAL_MAG3_XCOMP (`FLOAT`) {#CAL_MAG3_XCOMP}

Magnetometer 3 X Axis throttle compensation.

Coefficient describing linear relationship between X component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_XODIAG (`FLOAT`) {#CAL_MAG3_XODIAG}

Magnetometer 3 X-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_XOFF (`FLOAT`) {#CAL_MAG3_XOFF}

Magnetometer 3 X-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG3_XSCALE (`FLOAT`) {#CAL_MAG3_XSCALE}

Magnetometer 3 X-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG3_YAW (`FLOAT`) {#CAL_MAG3_YAW}

Magnetometer 3 Custom Euler Yaw Angle.

Setting this parameter changes CAL_MAG3_ROT to "Custom Euler Angle"

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 0.0 | deg 

### CAL_MAG3_YCOMP (`FLOAT`) {#CAL_MAG3_YCOMP}

Magnetometer 3 Y Axis throttle compensation.

Coefficient describing linear relationship between Y component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_YODIAG (`FLOAT`) {#CAL_MAG3_YODIAG}

Magnetometer 3 Y-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_YOFF (`FLOAT`) {#CAL_MAG3_YOFF}

Magnetometer 3 Y-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG3_YSCALE (`FLOAT`) {#CAL_MAG3_YSCALE}

Magnetometer 3 Y-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG3_ZCOMP (`FLOAT`) {#CAL_MAG3_ZCOMP}

Magnetometer 3 Z Axis throttle compensation.

Coefficient describing linear relationship between Z component of magnetometer in body frame axis and either current or throttle depending on value of CAL_MAG_COMP_TYP. Unit for throttle-based compensation is [G] and for current-based compensation [G/kA]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_ZODIAG (`FLOAT`) {#CAL_MAG3_ZODIAG}

Magnetometer 3 Z-axis off diagonal scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### CAL_MAG3_ZOFF (`FLOAT`) {#CAL_MAG3_ZOFF}

Magnetometer 3 Z-axis offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### CAL_MAG3_ZSCALE (`FLOAT`) {#CAL_MAG3_ZSCALE}

Magnetometer 3 Z-axis scaling factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 3.0 |  | 1.0 |  

### CAL_MAG_COMP_TYP (`INT32`) {#CAL_MAG_COMP_TYP}

Type of magnetometer compensation.

**Values:**

- `0`: Disabled
- `1`: Throttle-based compensation
- `2`: Current-based compensation (battery_status instance 0)
- `3`: Current-based compensation (battery_status instance 1)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SENS_DPRES_ANSC (`FLOAT`) {#SENS_DPRES_ANSC}

Differential pressure sensor analog scaling.

Pick the appropriate scaling from the datasheet. this number defines the (linear) conversion from voltage to Pascal (pa). For the MPXV7002DP this is 1000. NOTE: If the sensor always registers zero, try switching the static and dynamic tubes.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SENS_DPRES_OFF (`FLOAT`) {#SENS_DPRES_OFF}

Differential pressure sensor offset.

The offset (zero-reading) in Pascal

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### SENS_FLOW_MAXHGT (`FLOAT`) {#SENS_FLOW_MAXHGT}

Maximum height above ground when reliant on optical flow.

This parameter defines the maximum distance from ground at which the optical flow sensor operates reliably. The height setpoint will be limited to be no greater than this value when the navigation system is completely reliant on optical flow data and the height above ground estimate is valid. The sensor may be usable above this height, but accuracy will progressively degrade.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 100.0 | 0.1 | 100. | m 

### SENS_FLOW_MAXR (`FLOAT`) {#SENS_FLOW_MAXR}

Magnitude of maximum angular flow rate reliably measurable by the optical flow sensor.

Optical flow data will not fused by the estimators if the magnitude of the flow rate exceeds this value and control loops will be instructed to limit ground speed such that the flow rate produced by movement over ground is less than 50% of this value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 |  |  | 8. | rad/s 

### SENS_FLOW_MINHGT (`FLOAT`) {#SENS_FLOW_MINHGT}

Minimum height above ground when reliant on optical flow.

This parameter defines the minimum distance from ground at which the optical flow sensor operates reliably. The sensor may be usable below this height, but accuracy will progressively reduce to loss of focus.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1.0 | 0.1 | 0.08 | m 

## Sensors

### ADC_ADS1115_EN (`INT32`) {#ADC_ADS1115_EN}

Enable external ADS1115 ADC.

If enabled, the internal ADC is not used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### BAT1_C_MULT (`FLOAT`) {#BAT1_C_MULT}

Capacity/current multiplier for high-current capable SMBUS battery.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1.0 |  

### BAT1_SMBUS_MODEL (`INT32`) {#BAT1_SMBUS_MODEL}

Battery device model.

**Values:**

- `0`: AutoDetect
- `1`: BQ40Z50 based
- `2`: BQ40Z80 based


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 0 |  

### BATMON_ADDR_DFLT (`INT32`) {#BATMON_ADDR_DFLT}

I2C address for BatMon battery 1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 11 |  

### BATMON_DRIVER_EN (`INT32`) {#BATMON_DRIVER_EN}

Parameter to enable BatMon module.

**Values:**

- `0`: Disabled
- `1`: Start on default I2C addr(BATMON_ADDR_DFLT)
- `2`: Autodetect I2C address (TODO)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 0 |  

### CAL_AIR_CMODEL (`INT32`) {#CAL_AIR_CMODEL}

Airspeed sensor compensation model for the SDP3x.

Model with Pitot CAL_AIR_TUBED_MM: Not used, 1.5 mm tubes assumed. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor. Model without Pitot (1.5 mm tubes) CAL_AIR_TUBED_MM: Not used, 1.5 mm tubes assumed. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor. Tube Pressure Drop CAL_AIR_TUBED_MM: Diameter in mm of the pitot and tubes, must have the same diameter. CAL_AIR_TUBELEN: Length of the tubes connecting the pitot to the sensor and the static + dynamic port length of the pitot.

**Values:**

- `0`: Model with Pitot
- `1`: Model without Pitot (1.5 mm tubes)
- `2`: Tube Pressure Drop


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### CAL_AIR_TUBED_MM (`FLOAT`) {#CAL_AIR_TUBED_MM}

Airspeed sensor tube diameter. Only used for the Tube Pressure Drop Compensation.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.5 | 100 |  | 1.5 | mm 

### CAL_AIR_TUBELEN (`FLOAT`) {#CAL_AIR_TUBELEN}

Airspeed sensor tube length.

See the CAL_AIR_CMODEL explanation on how this parameter should be set.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.01 | 2.00 |  | 0.2 | m 

### CAL_MAG_SIDES (`INT32`) {#CAL_MAG_SIDES}

For legacy QGC support only.

Use SENS_MAG_SIDES instead

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 63 |  

### IMU_ACCEL_CUTOFF (`FLOAT`) {#IMU_ACCEL_CUTOFF}

Low pass filter cutoff frequency for accel.

The cutoff frequency for the 2nd order butterworth filter on the primary accelerometer. This only affects the signal sent to the controllers, not the estimators. 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 30.0 | Hz 

### IMU_DGYRO_CUTOFF (`FLOAT`) {#IMU_DGYRO_CUTOFF}

Cutoff frequency for angular acceleration (D-Term filter).

The cutoff frequency for the 2nd order butterworth filter used on the time derivative of the measured angular velocity, also known as the D-term filter in the rate controller. The D-term uses the derivative of the rate and thus is the most susceptible to noise. Therefore, using a D-term filter allows to increase IMU_GYRO_CUTOFF, which leads to reduced control latency and permits to increase the P gains. A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 30.0 | Hz 

### IMU_GYRO_CAL_EN (`INT32`) {#IMU_GYRO_CAL_EN}

IMU gyro auto calibration enable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### IMU_GYRO_CUTOFF (`FLOAT`) {#IMU_GYRO_CUTOFF}

Low pass filter cutoff frequency for gyro.

The cutoff frequency for the 2nd order butterworth filter on the primary gyro. This only affects the angular velocity sent to the controllers, not the estimators. It applies also to the angular acceleration (D-Term filter), see IMU_DGYRO_CUTOFF. A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 40.0 | Hz 

### IMU_GYRO_DNF_BW (`FLOAT`) {#IMU_GYRO_DNF_BW}

IMU gyro ESC notch filter bandwidth.

Bandwidth per notch filter when using dynamic notch filtering with ESC RPM.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 5 | 30 |  | 15. | Hz 

### IMU_GYRO_DNF_EN (`INT32`) {#IMU_GYRO_DNF_EN}

IMU gyro dynamic notch filtering.

Enable bank of dynamically updating notch filters. Requires ESC RPM feedback or onboard FFT (IMU_GYRO_FFT_EN).

**Bitmask:**

- `0`: ESC RPM
- `1`: FFT


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### IMU_GYRO_DNF_HMC (`INT32`) {#IMU_GYRO_DNF_HMC}

IMU gyro dynamic notch filter harmonics.

ESC RPM number of harmonics (multiples of RPM) for ESC RPM dynamic notch filtering.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 7 |  | 3 |  

### IMU_GYRO_DNF_MIN (`FLOAT`) {#IMU_GYRO_DNF_MIN}

IMU gyro dynamic notch filter minimum frequency.

Minimum notch filter frequency in Hz.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25. | Hz 

### IMU_GYRO_FFT_EN (`INT32`) {#IMU_GYRO_FFT_EN}

IMU gyro FFT enable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### IMU_GYRO_FFT_LEN (`INT32`) {#IMU_GYRO_FFT_LEN}

IMU gyro FFT length.

**Values:**

- `256`: 256
- `512`: 512
- `1024`: 1024
- `4096`: 4096


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 512 | Hz 

### IMU_GYRO_FFT_MAX (`FLOAT`) {#IMU_GYRO_FFT_MAX}

IMU gyro FFT maximum frequency.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 1000 |  | 150. | Hz 

### IMU_GYRO_FFT_MIN (`FLOAT`) {#IMU_GYRO_FFT_MIN}

IMU gyro FFT minimum frequency.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 1000 |  | 30. | Hz 

### IMU_GYRO_FFT_SNR (`FLOAT`) {#IMU_GYRO_FFT_SNR}

IMU gyro FFT SNR.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 30 |  | 10. |  

### IMU_GYRO_NF0_BW (`FLOAT`) {#IMU_GYRO_NF0_BW}

Notch filter bandwidth for gyro.

The frequency width of the stop band for the 2nd order notch filter on the primary gyro. See "IMU_GYRO_NF0_FRQ" to activate the filter and to set the notch frequency. Applies to both angular velocity and angular acceleration sent to the controllers.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 100 |  | 20.0 | Hz 

### IMU_GYRO_NF0_FRQ (`FLOAT`) {#IMU_GYRO_NF0_FRQ}

Notch filter frequency for gyro.

The center frequency for the 2nd order notch filter on the primary gyro. This filter can be enabled to avoid feedback amplification of structural resonances at a specific frequency. This only affects the signal sent to the controllers, not the estimators. Applies to both angular velocity and angular acceleration sent to the controllers. See "IMU_GYRO_NF0_BW" to set the bandwidth of the filter. A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 0.0 | Hz 

### IMU_GYRO_NF1_BW (`FLOAT`) {#IMU_GYRO_NF1_BW}

Notch filter 1 bandwidth for gyro.

The frequency width of the stop band for the 2nd order notch filter on the primary gyro. See "IMU_GYRO_NF1_FRQ" to activate the filter and to set the notch frequency. Applies to both angular velocity and angular acceleration sent to the controllers.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 100 |  | 20.0 | Hz 

### IMU_GYRO_NF1_FRQ (`FLOAT`) {#IMU_GYRO_NF1_FRQ}

Notch filter 2 frequency for gyro.

The center frequency for the 2nd order notch filter on the primary gyro. This filter can be enabled to avoid feedback amplification of structural resonances at a specific frequency. This only affects the signal sent to the controllers, not the estimators. Applies to both angular velocity and angular acceleration sent to the controllers. See "IMU_GYRO_NF1_BW" to set the bandwidth of the filter. A value of 0 disables the filter.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1000 |  | 0.0 | Hz 

### IMU_GYRO_RATEMAX (`INT32`) {#IMU_GYRO_RATEMAX}

Gyro control data maximum publication rate (inner loop rate).

The maximum rate the gyro control data (vehicle_angular_velocity) will be allowed to publish at. This is the loop rate for the rate controller and outputs. Note: sensor data is always read and filtered at the full raw rate (eg commonly 8 kHz) regardless of this setting.

**Values:**

- `100`: 100 Hz
- `250`: 250 Hz
- `400`: 400 Hz
- `800`: 800 Hz
- `1000`: 1000 Hz
- `2000`: 2000 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 100 | 2000 |  | 400 | Hz 

### IMU_INTEG_RATE (`INT32`) {#IMU_INTEG_RATE}

IMU integration rate.

The rate at which raw IMU data is integrated to produce delta angles and delta velocities. Recommended to set this to a multiple of the estimator update period (currently 10 ms for ekf2).

**Values:**

- `100`: 100 Hz
- `200`: 200 Hz
- `250`: 250 Hz
- `400`: 400 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 100 | 1000 |  | 200 | Hz 

### INA220_CONFIG (`INT32`) {#INA220_CONFIG}

INA220 Power Monitor Config.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 | 1 | 8607 |  

### INA220_CUR_BAT (`FLOAT`) {#INA220_CUR_BAT}

INA220 Power Monitor Battery Max Current.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 500.0 | 0.1 | 164.0 |  

### INA220_CUR_REG (`FLOAT`) {#INA220_CUR_REG}

INA220 Power Monitor Regulator Max Current.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 500.0 | 0.1 | 164.0 |  

### INA220_SHUNT_BAT (`FLOAT`) {#INA220_SHUNT_BAT}

INA220 Power Monitor Battery Shunt.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.000000001 | 0.1 | .000000001 | 0.0005 |  

### INA220_SHUNT_REG (`FLOAT`) {#INA220_SHUNT_REG}

INA220 Power Monitor Regulator Shunt.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.000000001 | 0.1 | .000000001 | 0.0005 |  

### INA226_CONFIG (`INT32`) {#INA226_CONFIG}

INA226 Power Monitor Config.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 | 1 | 18139 |  

### INA226_CURRENT (`FLOAT`) {#INA226_CURRENT}

INA226 Power Monitor Max Current.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 200.0 | 0.1 | 164.0 |  

### INA226_SHUNT (`FLOAT`) {#INA226_SHUNT}

INA226 Power Monitor Shunt.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.000000001 | 0.1 | .000000001 | 0.0005 |  

### INA228_CONFIG (`INT32`) {#INA228_CONFIG}

INA228 Power Monitor Config.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 65535 | 1 | 63779 |  

### INA228_CURRENT (`FLOAT`) {#INA228_CURRENT}

INA228 Power Monitor Max Current.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 327.68 | 0.1 | 327.68 |  

### INA228_SHUNT (`FLOAT`) {#INA228_SHUNT}

INA228 Power Monitor Shunt.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.000000001 | 0.1 | .000000001 | 0.0005 |  

### INA238_CURRENT (`FLOAT`) {#INA238_CURRENT}

INA238 Power Monitor Max Current.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.1 | 327.68 | 0.1 | 327.68 |  

### INA238_SHUNT (`FLOAT`) {#INA238_SHUNT}

INA238 Power Monitor Shunt.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.000000001 | 0.1 | .000000001 | 0.0003 |  

### PCF8583_MAGNET (`INT32`) {#PCF8583_MAGNET}

PCF8583 rotorfreq (i2c) pulse count.

Nmumber of signals per rotation of actuator

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 |  |  | 2 |  

### PCF8583_POOL (`INT32`) {#PCF8583_POOL}

PCF8583 rotorfreq (i2c) pool interval.

Determines how often the sensor is read out.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1000000 | us 

### PCF8583_RESET (`INT32`) {#PCF8583_RESET}

PCF8583 rotorfreq (i2c) pulse reset value.

Internal device counter is reset to 0 when overrun this value, counter is able to store up to 6 digits reset of counter takes some time - measurement with reset has worse accuracy. 0 means reset counter after every measurement.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 500000 |  

### SENS_AFBR_HYSTER (`INT32`) {#SENS_AFBR_HYSTER}

AFBR Rangefinder Short/Long Range Threshold Hysteresis.

This parameter defines the hysteresis for switching between short and long range mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 10 |  | 1 | m 

### SENS_AFBR_L_RATE (`INT32`) {#SENS_AFBR_L_RATE}

AFBR Rangefinder Long Range Rate.

This parameter defines measurement rate of the AFBR Rangefinder in long range mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 100 |  | 25 |  

### SENS_AFBR_MODE (`INT32`) {#SENS_AFBR_MODE}

AFBR Rangefinder Mode.

This parameter defines the mode of the AFBR Rangefinder.

**Values:**

- `0`: Short Range Mode
- `1`: Long Range Mode
- `2`: High Speed Short Range Mode
- `3`: High Speed Long Range Mode


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 0 |  

### SENS_AFBR_S_RATE (`INT32`) {#SENS_AFBR_S_RATE}

AFBR Rangefinder Short Range Rate.

This parameter defines measurement rate of the AFBR Rangefinder in short range mode.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 100 |  | 50 |  

### SENS_AFBR_THRESH (`INT32`) {#SENS_AFBR_THRESH}

AFBR Rangefinder Short/Long Range Threshold.

This parameter defines the threshold for switching between short and long range mode. The mode will switch from short to long range when the distance is greater than the threshold plus the hysteresis. The mode will switch from long to short range when the distance is less than the threshold minus the hysteresis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 50 |  | 4 | m 

### SENS_BARO_QNH (`FLOAT`) {#SENS_BARO_QNH}

QNH for barometer.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 500 | 1500 |  | 1013.25 | hPa 

### SENS_BARO_RATE (`FLOAT`) {#SENS_BARO_RATE}

Baro max rate.

Barometric air data maximum publication rate. This is an upper bound, actual barometric data rate is still dependent on the sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1 | 200 |  | 20.0 | Hz 

### SENS_BOARD_ROT (`INT32`) {#SENS_BOARD_ROT}

Board rotation.

This parameter defines the rotation of the FMU board relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°
- `8`: Roll 180°
- `9`: Roll 180°, Yaw 45°
- `10`: Roll 180°, Yaw 90°
- `11`: Roll 180°, Yaw 135°
- `12`: Pitch 180°
- `13`: Roll 180°, Yaw 225°
- `14`: Roll 180°, Yaw 270°
- `15`: Roll 180°, Yaw 315°
- `16`: Roll 90°
- `17`: Roll 90°, Yaw 45°
- `18`: Roll 90°, Yaw 90°
- `19`: Roll 90°, Yaw 135°
- `20`: Roll 270°
- `21`: Roll 270°, Yaw 45°
- `22`: Roll 270°, Yaw 90°
- `23`: Roll 270°, Yaw 135°
- `24`: Pitch 90°
- `25`: Pitch 270°
- `26`: Pitch 180°, Yaw 90°
- `27`: Pitch 180°, Yaw 270°
- `28`: Roll 90°, Pitch 90°
- `29`: Roll 180°, Pitch 90°
- `30`: Roll 270°, Pitch 90°
- `31`: Roll 90°, Pitch 180°
- `32`: Roll 270°, Pitch 180°
- `33`: Roll 90°, Pitch 270°
- `34`: Roll 180°, Pitch 270°
- `35`: Roll 270°, Pitch 270°
- `36`: Roll 90°, Pitch 180°, Yaw 90°
- `37`: Roll 90°, Yaw 270°
- `38`: Roll 90°, Pitch 68°, Yaw 293°
- `39`: Pitch 315°
- `40`: Roll 90°, Pitch 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -1 | 40 |  | 0 |  

### SENS_BOARD_X_OFF (`FLOAT`) {#SENS_BOARD_X_OFF}

Board rotation X (Roll) offset.

This parameter defines a rotational offset in degrees around the X (Roll) axis It allows the user to fine tune the board offset in the event of misalignment.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | deg 

### SENS_BOARD_Y_OFF (`FLOAT`) {#SENS_BOARD_Y_OFF}

Board rotation Y (Pitch) offset.

This parameter defines a rotational offset in degrees around the Y (Pitch) axis. It allows the user to fine tune the board offset in the event of misalignment.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | deg 

### SENS_BOARD_Z_OFF (`FLOAT`) {#SENS_BOARD_Z_OFF}

Board rotation Z (YAW) offset.

This parameter defines a rotational offset in degrees around the Z (Yaw) axis. It allows the user to fine tune the board offset in the event of misalignment.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | deg 

### SENS_CM8JL65_CFG (`INT32`) {#SENS_CM8JL65_CFG}

Serial Configuration for Lanbao PSK-CM8JL65-CC5.

Configure on which serial port to run Lanbao PSK-CM8JL65-CC5.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_CM8JL65_R_0 (`INT32`) {#SENS_CM8JL65_R_0}

Distance Sensor Rotation.

Distance Sensor Rotation as MAV_SENSOR_ORIENTATION enum

**Values:**

- `0`: ROTATION_FORWARD_FACING
- `2`: ROTATION_RIGHT_FACING
- `4`: ROTATION_BACKWARD_FACING
- `6`: ROTATION_LEFT_FACING
- `24`: ROTATION_UPWARD_FACING
- `25`: ROTATION_DOWNWARD_FACING


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 25 |  

### SENS_EN_ADIS164X (`INT32`) {#SENS_EN_ADIS164X}

Analog Devices ADIS16448 IMU (external SPI).

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_ADIS165X (`INT32`) {#SENS_EN_ADIS165X}

Analog Devices ADIS16507 IMU (external SPI).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_AGPSIM (`INT32`) {#SENS_EN_AGPSIM}

Simulate Aux Global Position (AGP).

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_ARSPDSIM (`INT32`) {#SENS_EN_ARSPDSIM}

Enable simulated airspeed sensor instance.

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_ASP5033 (`INT32`) {#SENS_EN_ASP5033}

ASP5033 differential pressure sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_AUAVX (`INT32`) {#SENS_EN_AUAVX}

Amphenol AUAV differential / absolute pressure sensor (external I2C).

**Values:**

- `0`: Sensor disabled, when explicitly started treated as AUAV L05D
- `1`: AUAV L05D
- `2`: AUAV L10D
- `3`: AUAV L30D


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_EN_BAROSIM (`INT32`) {#SENS_EN_BAROSIM}

Enable simulated barometer sensor instance.

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_BATT (`INT32`) {#SENS_EN_BATT}

SMBUS Smart battery driver BQ40Z50 and BQ40Z80.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_ETSASPD (`INT32`) {#SENS_EN_ETSASPD}

Eagle Tree airspeed sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_GPSSIM (`INT32`) {#SENS_EN_GPSSIM}

Enable simulated GPS sinstance.

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_INA220 (`INT32`) {#SENS_EN_INA220}

Enable INA220 Power Monitor.

For systems a INA220 Power Monitor, this should be set to true

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_INA226 (`INT32`) {#SENS_EN_INA226}

Enable INA226 Power Monitor.

For systems a INA226 Power Monitor, this should be set to true

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_INA228 (`INT32`) {#SENS_EN_INA228}

Enable INA228 Power Monitor.

For systems a INA228 Power Monitor, this should be set to true

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_INA238 (`INT32`) {#SENS_EN_INA238}

Enable INA238 Power Monitor.

For systems a INA238 Power Monitor, this should be set to true

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_IRLOCK (`INT32`) {#SENS_EN_IRLOCK}

IR-LOCK Sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_LL40LS (`INT32`) {#SENS_EN_LL40LS}

Lidar-Lite (LL40LS).

**Values:**

- `0`: Disabled
- `1`: PWM
- `2`: I2C


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 0 |  

### SENS_EN_MAGSIM (`INT32`) {#SENS_EN_MAGSIM}

Enable simulated magnetometer sensor instance.

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_MB12XX (`INT32`) {#SENS_EN_MB12XX}

Maxbotix Sonar (mb12xx).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_MPDT (`INT32`) {#SENS_EN_MPDT}

Enable Mappydot rangefinder (i2c).

**Values:**

- `0`: Disabled
- `1`: Autodetect


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_MS4515 (`INT32`) {#SENS_EN_MS4515}

TE MS4515 differential pressure sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_MS4525DO (`INT32`) {#SENS_EN_MS4525DO}

TE MS4525DO differential pressure sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_MS5525DS (`INT32`) {#SENS_EN_MS5525DS}

TE MS5525DSO differential pressure sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_PAA3905 (`INT32`) {#SENS_EN_PAA3905}

PAA3905 Optical Flow.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_PAW3902 (`INT32`) {#SENS_EN_PAW3902}

PAW3902/PAW3903 Optical Flow.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_PCF8583 (`INT32`) {#SENS_EN_PCF8583}

PCF8583 eneable driver.

Run PCF8583 driver automatically

**Values:**

- `0`: Disabled
- `1`: Eneabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_PGA460 (`INT32`) {#SENS_EN_PGA460}

PGA460 Ultrasonic driver (PGA460).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_PMW3901 (`INT32`) {#SENS_EN_PMW3901}

PMW3901 Optical Flow.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_PX4FLOW (`INT32`) {#SENS_EN_PX4FLOW}

PX4 Flow Optical Flow.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_SCH16T (`INT32`) {#SENS_EN_SCH16T}

Murata SCH16T IMU (external SPI).

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SENS_EN_SDP3X (`INT32`) {#SENS_EN_SDP3X}

Sensirion SDP3X differential pressure sensor (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_SF0X (`INT32`) {#SENS_EN_SF0X}

Lightware Laser Rangefinder hardware model (serial).

**Values:**

- `1`: SF02
- `2`: SF10/a
- `3`: SF10/b
- `4`: SF10/c
- `5`: SF11/c
- `6`: SF30/b
- `7`: SF30/c
- `8`: LW20/c


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### SENS_EN_SF1XX (`INT32`) {#SENS_EN_SF1XX}

Lightware SF1xx/SF20/LW20 laser rangefinder (i2c).

**Values:**

- `0`: Disabled
- `1`: SF10/a
- `2`: SF10/b
- `3`: SF10/c
- `4`: SF11/c
- `5`: SF/LW20/b
- `6`: SF/LW20/c
- `7`: SF/LW30/d


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 6 |  | 0 |  

### SENS_EN_SF45_CFG (`INT32`) {#SENS_EN_SF45_CFG}

Serial Configuration for Lightware SF45 Rangefinder (serial).

Configure on which serial port to run Lightware SF45 Rangefinder (serial).

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 102 |  

### SENS_EN_SHT3X (`INT32`) {#SENS_EN_SHT3X}

SHT3x temperature and hygrometer.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_SPA06 (`INT32`) {#SENS_EN_SPA06}

Goertek SPA06 Barometer (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_SPL06 (`INT32`) {#SENS_EN_SPL06}

Goertek SPL06 Barometer (external I2C).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_SR05 (`INT32`) {#SENS_EN_SR05}

HY-SRF05 / HC-SR05.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_TF02PRO (`INT32`) {#SENS_EN_TF02PRO}

TF02 Pro Distance Sensor (i2c).

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_THERMAL (`INT32`) {#SENS_EN_THERMAL}

Thermal control of sensor temperature.

**Values:**

- `-1`: Thermal control unavailable
- `0`: Thermal control off
- `1`: Thermal control enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1 |  

### SENS_EN_TRANGER (`INT32`) {#SENS_EN_TRANGER}

TeraRanger Rangefinder (i2c).

**Values:**

- `0`: Disabled
- `1`: Autodetect
- `2`: TROne
- `3`: TREvo60m
- `4`: TREvo600Hz
- `5`: TREvo3m


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 0 |  

### SENS_EN_VL53L0X (`INT32`) {#SENS_EN_VL53L0X}

VL53L0X Distance Sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EN_VL53L1X (`INT32`) {#SENS_EN_VL53L1X}

VL53L1X Distance Sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SENS_EXT_I2C_PRB (`INT32`) {#SENS_EXT_I2C_PRB}

External I2C probe.

Probe for optional external I2C devices.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SENS_FLOW_RATE (`FLOAT`) {#SENS_FLOW_RATE}

Optical flow max rate.

Optical flow data maximum publication rate. This is an upper bound, actual optical flow data rate is still dependent on the sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 200 |  | 70.0 | Hz 

### SENS_FLOW_ROT (`INT32`) {#SENS_FLOW_ROT}

Optical flow rotation.

This parameter defines the yaw rotation of the optical flow relative to the vehicle body frame. Zero rotation is defined as X on flow board pointing towards front of vehicle.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SENS_FLOW_SCALE (`FLOAT`) {#SENS_FLOW_SCALE}

Optical flow scale factor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.5 | 1.5 |  | 1. |  

### SENS_FTX_CFG (`INT32`) {#SENS_FTX_CFG}

Serial Configuration for FT Technologies Digital Wind Sensor (serial).

Configure on which serial port to run FT Technologies Digital Wind Sensor (serial).

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_GPS_MASK (`INT32`) {#SENS_GPS_MASK}

Multi GPS Blending Control Mask.

Set bits in the following positions to set which GPS accuracy metrics will be used to calculate the blending weight. Set to zero to disable and always used first GPS instance. 0 : Set to true to use speed accuracy 1 : Set to true to use horizontal position accuracy 2 : Set to true to use vertical position accuracy

**Bitmask:**

- `0`: use speed accuracy
- `1`: use hpos accuracy
- `2`: use vpos accuracy


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 7 |  | 7 |  

### SENS_GPS_PRIME (`INT32`) {#SENS_GPS_PRIME}

Multi GPS primary instance.

When no blending is active, this defines the preferred GPS receiver instance. The GPS selection logic waits until the primary receiver is available to send data to the EKF even if a secondary instance is already available. The secondary instance is then only used if the primary one times out. To have an equal priority of all the instances, set this parameter to -1 and the best receiver will be used. This parameter has no effect if blending is active.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -1 | 1 |  | 0 |  

### SENS_GPS_TAU (`FLOAT`) {#SENS_GPS_TAU}

Multi GPS Blending Time Constant.

Sets the longest time constant that will be applied to the calculation of GPS position and height offsets used to correct data from multiple GPS data for steady state position differences.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 1.0 | 100.0 |  | 10.0 | s 

### SENS_IMU_AUTOCAL (`INT32`) {#SENS_IMU_AUTOCAL}

IMU auto calibration.

Automatically initialize IMU (accel/gyro) calibration from bias estimates if available.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SENS_IMU_CLPNOTI (`INT32`) {#SENS_IMU_CLPNOTI}

IMU notify clipping.

Notify the user if the IMU is clipping

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SENS_IMU_MODE (`INT32`) {#SENS_IMU_MODE}

Sensors hub IMU mode.

**Values:**

- `0`: Disabled
- `1`: Publish primary IMU selection


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### SENS_IMU_TEMP (`FLOAT`) {#SENS_IMU_TEMP}

Target IMU temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 85.0 |  | 55.0 | celcius 

### SENS_IMU_TEMP_FF (`FLOAT`) {#SENS_IMU_TEMP_FF}

IMU heater controller feedforward value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1.0 |  | 0.05 | % 

### SENS_IMU_TEMP_I (`FLOAT`) {#SENS_IMU_TEMP_I}

IMU heater controller integrator gain value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1.0 |  | 0.025 | us/C 

### SENS_IMU_TEMP_P (`FLOAT`) {#SENS_IMU_TEMP_P}

IMU heater controller proportional gain value.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 2.0 |  | 1.0 | us/C 

### SENS_INT_BARO_EN (`INT32`) {#SENS_INT_BARO_EN}

Enable internal barometers.

For systems with an external barometer, this should be set to false to make sure that the external is used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### SENS_LEDDAR1_CFG (`INT32`) {#SENS_LEDDAR1_CFG}

Serial Configuration for LeddarOne Rangefinder.

Configure on which serial port to run LeddarOne Rangefinder.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_MAG_AUTOCAL (`INT32`) {#SENS_MAG_AUTOCAL}

Magnetometer auto calibration.

Automatically initialize magnetometer calibration from bias estimate if available.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SENS_MAG_AUTOROT (`INT32`) {#SENS_MAG_AUTOROT}

Automatically set external rotations.

During calibration attempt to automatically determine the rotation of external magnetometers.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

### SENS_MAG_MODE (`INT32`) {#SENS_MAG_MODE}

Sensors hub mag mode.

**Values:**

- `0`: Publish all magnetometers
- `1`: Publish primary magnetometer


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### SENS_MAG_RATE (`FLOAT`) {#SENS_MAG_RATE}

Magnetometer max rate.

Magnetometer data maximum publication rate. This is an upper bound, actual magnetometer data rate is still dependent on the sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 200 |  | 15.0 | Hz 

### SENS_MAG_SIDES (`INT32`) {#SENS_MAG_SIDES}

Bitfield selecting mag sides for calibration.

If set to two side calibration, only the offsets are estimated, the scale calibration is left unchanged. Thus an initial six side calibration is recommended. Bits: ORIENTATION_TAIL_DOWN = 1 ORIENTATION_NOSE_DOWN = 2 ORIENTATION_LEFT = 4 ORIENTATION_RIGHT = 8 ORIENTATION_UPSIDE_DOWN = 16 ORIENTATION_RIGHTSIDE_UP = 32

**Values:**

- `34`: Two side calibration
- `38`: Three side calibration
- `63`: Six side calibration


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 34 | 63 |  | 63 |  

### SENS_MB12_0_ROT (`INT32`) {#SENS_MB12_0_ROT}

MaxBotix MB12XX Sensor 0 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_10_ROT (`INT32`) {#SENS_MB12_10_ROT}

MaxBotix MB12XX Sensor 10 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_11_ROT (`INT32`) {#SENS_MB12_11_ROT}

MaxBotix MB12XX Sensor 12 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_1_ROT (`INT32`) {#SENS_MB12_1_ROT}

MaxBotix MB12XX Sensor 1 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_2_ROT (`INT32`) {#SENS_MB12_2_ROT}

MaxBotix MB12XX Sensor 2 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_3_ROT (`INT32`) {#SENS_MB12_3_ROT}

MaxBotix MB12XX Sensor 3 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_4_ROT (`INT32`) {#SENS_MB12_4_ROT}

MaxBotix MB12XX Sensor 4 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_5_ROT (`INT32`) {#SENS_MB12_5_ROT}

MaxBotix MB12XX Sensor 5 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_6_ROT (`INT32`) {#SENS_MB12_6_ROT}

MaxBotix MB12XX Sensor 6 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_7_ROT (`INT32`) {#SENS_MB12_7_ROT}

MaxBotix MB12XX Sensor 7 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_8_ROT (`INT32`) {#SENS_MB12_8_ROT}

MaxBotix MB12XX Sensor 8 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MB12_9_ROT (`INT32`) {#SENS_MB12_9_ROT}

MaxBotix MB12XX Sensor 9 Rotation.

This parameter defines the rotation of the sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT0_ROT (`INT32`) {#SENS_MPDT0_ROT}

MappyDot Sensor 0 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT10_ROT (`INT32`) {#SENS_MPDT10_ROT}

MappyDot Sensor 10 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT11_ROT (`INT32`) {#SENS_MPDT11_ROT}

MappyDot Sensor 12 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT1_ROT (`INT32`) {#SENS_MPDT1_ROT}

MappyDot Sensor 1 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT2_ROT (`INT32`) {#SENS_MPDT2_ROT}

MappyDot Sensor 2 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT3_ROT (`INT32`) {#SENS_MPDT3_ROT}

MappyDot Sensor 3 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT4_ROT (`INT32`) {#SENS_MPDT4_ROT}

MappyDot Sensor 4 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT5_ROT (`INT32`) {#SENS_MPDT5_ROT}

MappyDot Sensor 5 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT6_ROT (`INT32`) {#SENS_MPDT6_ROT}

MappyDot Sensor 6 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT7_ROT (`INT32`) {#SENS_MPDT7_ROT}

MappyDot Sensor 7 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT8_ROT (`INT32`) {#SENS_MPDT8_ROT}

MappyDot Sensor 8 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_MPDT9_ROT (`INT32`) {#SENS_MPDT9_ROT}

MappyDot Sensor 9 Rotation.

This parameter defines the rotation of the Mappydot sensor relative to the platform.

**Values:**

- `0`: No rotation
- `1`: Yaw 45°
- `2`: Yaw 90°
- `3`: Yaw 135°
- `4`: Yaw 180°
- `5`: Yaw 225°
- `6`: Yaw 270°
- `7`: Yaw 315°


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 7 |  | 0 |  

### SENS_OR_ADIS164X (`INT32`) {#SENS_OR_ADIS164X}

Analog Devices ADIS16448 IMU Orientation(external SPI).

**Values:**

- `0`: ROTATION_NONE
- `4`: ROTATION_YAW_180


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 101 |  | 0 |  

### SENS_SF0X_CFG (`INT32`) {#SENS_SF0X_CFG}

Serial Configuration for Lightware Laser Rangefinder (serial).

Configure on which serial port to run Lightware Laser Rangefinder (serial).

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_TEMP_ID (`INT32`) {#SENS_TEMP_ID}

Target IMU device ID to regulate temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SENS_TFLOW_CFG (`INT32`) {#SENS_TFLOW_CFG}

Serial Configuration for ThoneFlow-3901U optical flow sensor.

Configure on which serial port to run ThoneFlow-3901U optical flow sensor.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_TFMINI_CFG (`INT32`) {#SENS_TFMINI_CFG}

Serial Configuration for Benewake TFmini Rangefinder.

Configure on which serial port to run Benewake TFmini Rangefinder.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_ULAND_CFG (`INT32`) {#SENS_ULAND_CFG}

Serial Configuration for uLanding Radar.

Configure on which serial port to run uLanding Radar.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SENS_VN_CFG (`INT32`) {#SENS_VN_CFG}

Serial Configuration for VectorNav (VN-100, VN-200, VN-300).

Configure on which serial port to run VectorNav (VN-100, VN-200, VN-300).

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SF45_ORIENT_CFG (`INT32`) {#SF45_ORIENT_CFG}

Orientation upright or facing downward.

The SF45 mounted facing upward or downward on the frame

**Values:**

- `24`: Rotation upward
- `25`: Rotation downward


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 24 |  

### SF45_UPDATE_CFG (`INT32`) {#SF45_UPDATE_CFG}

Update rate in Hz.

The SF45 sets the update rate in Hz to allow greater resolution

**Values:**

- `1`: 50hz
- `2`: 100hz
- `3`: 200hz
- `4`: 400hz
- `5`: 500hz
- `6`: 625hz
- `7`: 1000hz
- `8`: 1250hz
- `9`: 1538hz
- `10`: 2000hz
- `11`: 2500hz
- `12`: 5000hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 5 |  

### SF45_YAW_CFG (`INT32`) {#SF45_YAW_CFG}

Sensor facing forward or backward.

The usb port on the sensor indicates 180deg, opposite usb is forward facing

**Values:**

- `0`: Rotation forward
- `2`: Rotation right
- `4`: Rotation backward
- `6`: Rotation left


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SIM_ARSPD_FAIL (`INT32`) {#SIM_ARSPD_FAIL}

Dynamically simulate failure of airspeed sensor instance.

**Values:**

- `0`: Disabled
- `1`: Enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### VN_MODE (`INT32`) {#VN_MODE}

VectorNav driver mode.

INS or sensors

**Values:**

- `0`: Sensors Only (default)
- `1`: INS


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### VOXLPM_SHUNT_BAT (`FLOAT`) {#VOXLPM_SHUNT_BAT}

VOXL Power Monitor Shunt, Battery.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.000000001 | 0.1 | .000000001 | 0.00063 |  

### VOXLPM_SHUNT_REG (`FLOAT`) {#VOXLPM_SHUNT_REG}

VOXL Power Monitor Shunt, Regulator.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.000000001 | 0.1 | .000000001 | 0.0056 |  

## Septentrio

### SEP_AUTO_CONFIG (`INT32`) {#SEP_AUTO_CONFIG}

Toggle automatic receiver configuration.

By default, the receiver is automatically configured. Sometimes it may be used for multiple purposes. If the offered parameters aren't sufficient, this parameter can be disabled to have full control of the receiver configuration. A good way to use this is to enable automatic configuration, let the receiver be configured, and then disable it to make manual adjustments.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### SEP_CONST_USAGE (`INT32`) {#SEP_CONST_USAGE}

Usage of different constellations.

Choice of which constellations the receiver should use for PVT computation. When this is 0, the constellation usage isn't changed.

**Bitmask:**

- `0`: GPS
- `1`: GLONASS
- `2`: Galileo
- `3`: SBAS
- `4`: BeiDou


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 63 |  | 0 |  

### SEP_DUMP_COMM (`INT32`) {#SEP_DUMP_COMM}

Log GPS communication data.

Log raw communication between the driver and connected receivers. For example, "To receiver" will log all commands and corrections sent by the driver to the receiver.

**Values:**

- `0`: Disabled
- `1`: From receiver
- `2`: To receiver
- `3`: Both


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### SEP_HARDW_SETUP (`INT32`) {#SEP_HARDW_SETUP}

Setup and expected use of the hardware.

- Default: Use two receivers as completely separate instances. - Moving base: Use two receivers in a rover & moving base setup for heading.

**Values:**

- `0`: Default
- `1`: Moving base


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 1 |  | 0 |  

### SEP_LOG_FORCE (`INT32`) {#SEP_LOG_FORCE}

Whether to overwrite or add to existing logging.

When the receiver is already set up to log data, this decides whether extra logged data should be added or overwrite existing data.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SEP_LOG_HZ (`INT32`) {#SEP_LOG_HZ}

Logging frequency for the receiver.

Select the frequency at which the connected receiver should log data to its internal storage.

**Values:**

- `0`: Disabled
- `1`: 0.1 Hz
- `2`: 0.2 Hz
- `3`: 0.5 Hz
- `4`: 1 Hz
- `5`: 2 Hz
- `6`: 5 Hz
- `7`: 10 Hz
- `8`: 20 Hz
- `9`: 25 Hz
- `10`: 50 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 10 |  | 0 |  

### SEP_LOG_LEVEL (`INT32`) {#SEP_LOG_LEVEL}

Logging level for the receiver.

Select the level of detail that needs to be logged by the receiver.

**Values:**

- `0`: Lite
- `1`: Basic
- `2`: Default
- `3`: Full


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 2 |  

### SEP_OUTP_HZ (`INT32`) {#SEP_OUTP_HZ}

Output frequency of main SBF blocks.

The output frequency of the main SBF blocks needed for PVT information.

**Values:**

- `0`: 5 Hz
- `1`: 10 Hz
- `2`: 20 Hz
- `3`: 25 Hz


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 1 |  

### SEP_PITCH_OFFS (`FLOAT`) {#SEP_PITCH_OFFS}

Pitch offset for dual antenna GPS.

Vertical offsets can be compensated for by adjusting the Pitch offset. Note that this can be interpreted as the "roll" angle in case the antennas are aligned along the perpendicular axis. This occurs in situations where the two antenna ARPs may not be exactly at the same height in the vehicle reference frame. Since pitch is defined as the right-handed rotation about the vehicle Y axis, a situation where the main antenna is mounted lower than the aux antenna (assuming the default antenna setup) will result in a positive pitch.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -90 | 90 |  | 0 | deg 

### SEP_PORT1_CFG (`INT32`) {#SEP_PORT1_CFG}

Serial Configuration for GPS Port.

Configure on which serial port to run GPS Port.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SEP_PORT2_CFG (`INT32`) {#SEP_PORT2_CFG}

Serial Configuration for Secondary GPS port.

Configure on which serial port to run Secondary GPS port.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SEP_SAT_INFO (`INT32`) {#SEP_SAT_INFO}

Enable sat info.

Enable publication of satellite info (ORB_ID(satellite_info)) if possible.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SEP_STREAM_LOG (`INT32`) {#SEP_STREAM_LOG}

Logging stream used during automatic configuration.

The stream the autopilot sets up on the receiver to output the logging data. Set this to another value if the default stream is already used for another purpose.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 10 |  | 2 |  

### SEP_STREAM_MAIN (`INT32`) {#SEP_STREAM_MAIN}

Main stream used during automatic configuration.

The stream the autopilot sets up on the receiver to output the main data. Set this to another value if the default stream is already used for another purpose.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 10 |  | 1 |  

### SEP_YAW_OFFS (`FLOAT`) {#SEP_YAW_OFFS}

Heading/Yaw offset for dual antenna GPS.

Heading offset angle for dual antenna GPS setups that support heading estimation. Set this to 0 if the antennas are parallel to the forward-facing direction of the vehicle and the rover antenna is in front. The offset angle increases clockwise. Set this to 90 if the rover antenna is placed on the right side of the vehicle and the moving base antenna is on the left side.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | -360 | 360 |  | 0 | deg 

## Serial

### RC_CRSF_PRT_CFG (`INT32`) {#RC_CRSF_PRT_CFG}

Serial Configuration for CRSF RC Input Driver.

Configure on which serial port to run CRSF RC Input Driver. Crossfire RC (CRSF) driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### RC_DSM_PRT_CFG (`INT32`) {#RC_DSM_PRT_CFG}

Serial Configuration for DSM RC Input Driver.

Configure on which serial port to run DSM RC Input Driver. DSM RC (Spektrum) driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### RC_GHST_PRT_CFG (`INT32`) {#RC_GHST_PRT_CFG}

Serial Configuration for GHST RC Input Driver.

Configure on which serial port to run GHST RC Input Driver. Ghost (GHST) RC driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### RC_PORT_CONFIG (`INT32`) {#RC_PORT_CONFIG}

Serial Configuration for RC Input Driver.

Configure on which serial port to run RC Input Driver. Setting this to 'Disabled' will use a board-specific default port for RC input.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 300 |  

### RC_SBUS_PRT_CFG (`INT32`) {#RC_SBUS_PRT_CFG}

Serial Configuration for SBUS RC Input Driver.

Configure on which serial port to run SBUS RC Input Driver. SBUS RC driver.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 300 |  

### SER_EXT2_BAUD (`INT32`) {#SER_EXT2_BAUD}

Baudrate for the EXT2 Serial Port.

Configure the Baudrate for the EXT2 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 57600 |  

### SER_GPS1_BAUD (`INT32`) {#SER_GPS1_BAUD}

Baudrate for the GPS 1 Serial Port.

Configure the Baudrate for the GPS 1 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SER_GPS2_BAUD (`INT32`) {#SER_GPS2_BAUD}

Baudrate for the GPS 2 Serial Port.

Configure the Baudrate for the GPS 2 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SER_GPS3_BAUD (`INT32`) {#SER_GPS3_BAUD}

Baudrate for the GPS 3 Serial Port.

Configure the Baudrate for the GPS 3 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SER_MXS_BAUD (`INT32`) {#SER_MXS_BAUD}

MXS Serial Communication Baud rate.

Baudrate for the Serial Port connected to the MXS Transponder

**Values:**

- `0`: 38400
- `1`: 600
- `2`: 4800
- `3`: 9600
- `4`: RESERVED
- `5`: 57600
- `6`: 115200
- `7`: 230400
- `8`: 19200
- `9`: 460800
- `10`: 921600


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 10 |  | 5 |  

### SER_RC_BAUD (`INT32`) {#SER_RC_BAUD}

Baudrate for the Radio Controller Serial Port.

Configure the Baudrate for the Radio Controller Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SER_TEL1_BAUD (`INT32`) {#SER_TEL1_BAUD}

Baudrate for the TELEM 1 Serial Port.

Configure the Baudrate for the TELEM 1 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 57600 |  

### SER_TEL2_BAUD (`INT32`) {#SER_TEL2_BAUD}

Baudrate for the TELEM 2 Serial Port.

Configure the Baudrate for the TELEM 2 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 921600 |  

### SER_TEL3_BAUD (`INT32`) {#SER_TEL3_BAUD}

Baudrate for the TELEM 3 Serial Port.

Configure the Baudrate for the TELEM 3 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 57600 |  

### SER_TEL4_BAUD (`INT32`) {#SER_TEL4_BAUD}

Baudrate for the TELEM/SERIAL 4 Serial Port.

Configure the Baudrate for the TELEM/SERIAL 4 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 57600 |  

### SER_URT6_BAUD (`INT32`) {#SER_URT6_BAUD}

Baudrate for the UART 6 Serial Port.

Configure the Baudrate for the UART 6 Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 57600 |  

### SER_WIFI_BAUD (`INT32`) {#SER_WIFI_BAUD}

Baudrate for the Wifi Port Serial Port.

Configure the Baudrate for the Wifi Port Serial Port. Note: certain drivers such as the GPS can determine the Baudrate automatically.

**Values:**

- `0`: Auto
- `50`: 50 8N1
- `75`: 75 8N1
- `110`: 110 8N1
- `134`: 134 8N1
- `150`: 150 8N1
- `200`: 200 8N1
- `300`: 300 8N1
- `600`: 600 8N1
- `1200`: 1200 8N1
- `1800`: 1800 8N1
- `2400`: 2400 8N1
- `4800`: 4800 8N1
- `9600`: 9600 8N1
- `19200`: 19200 8N1
- `38400`: 38400 8N1
- `57600`: 57600 8N1
- `115200`: 115200 8N1
- `230400`: 230400 8N1
- `460800`: 460800 8N1
- `500000`: 500000 8N1
- `921600`: 921600 8N1
- `1000000`: 1000000 8N1
- `1500000`: 1500000 8N1
- `2000000`: 2000000 8N1
- `3000000`: 3000000 8N1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

## Simulation In Hardware

### SIH_DISTSNSR_MAX (`FLOAT`) {#SIH_DISTSNSR_MAX}

distance sensor maximum range.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 1000.0 | 0.01 | 100.0 | m 

### SIH_DISTSNSR_MIN (`FLOAT`) {#SIH_DISTSNSR_MIN}

distance sensor minimum range.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 | 10.0 | 0.01 | 0.0 | m 

### SIH_DISTSNSR_OVR (`FLOAT`) {#SIH_DISTSNSR_OVR}

if >= 0 the distance sensor measures will be overridden by this value.

Absolute value superior to 10000 will disable distance sensor

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1.0 | m 

### SIH_IXX (`FLOAT`) {#SIH_IXX}

Vehicle inertia about X axis.

The inertia is a 3 by 3 symmetric matrix. It represents the difficulty of the vehicle to modify its angular rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.005 | 0.025 | kg m^2 

### SIH_IXY (`FLOAT`) {#SIH_IXY}

Vehicle cross term inertia xy.

The inertia is a 3 by 3 symmetric matrix. This value can be set to 0 for a quad symmetric about its center of mass.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.005 | 0.0 | kg m^2 

### SIH_IXZ (`FLOAT`) {#SIH_IXZ}

Vehicle cross term inertia xz.

The inertia is a 3 by 3 symmetric matrix. This value can be set to 0 for a quad symmetric about its center of mass.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.005 | 0.0 | kg m^2 

### SIH_IYY (`FLOAT`) {#SIH_IYY}

Vehicle inertia about Y axis.

The inertia is a 3 by 3 symmetric matrix. It represents the difficulty of the vehicle to modify its angular rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.005 | 0.025 | kg m^2 

### SIH_IYZ (`FLOAT`) {#SIH_IYZ}

Vehicle cross term inertia yz.

The inertia is a 3 by 3 symmetric matrix. This value can be set to 0 for a quad symmetric about its center of mass.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  | 0.005 | 0.0 | kg m^2 

### SIH_IZZ (`FLOAT`) {#SIH_IZZ}

Vehicle inertia about Z axis.

The inertia is a 3 by 3 symmetric matrix. It represents the difficulty of the vehicle to modify its angular rate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.005 | 0.030 | kg m^2 

### SIH_KDV (`FLOAT`) {#SIH_KDV}

First order drag coefficient.

Physical coefficient representing the friction with air particules. The greater this value, the slower the quad will move. Drag force function of velocity: D=-KDV*V. The maximum freefall velocity can be computed as V=10*MASS/KDV [m/s]

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.05 | 1.0 | N/(m/s) 

### SIH_KDW (`FLOAT`) {#SIH_KDW}

First order angular damper coefficient.

Physical coefficient representing the friction with air particules during rotations. The greater this value, the slower the quad will rotate. Aerodynamic moment function of body rate: Ma=-KDW*W_B. This value can be set to 0 if unknown.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.005 | 0.025 | Nm/(rad/s) 

### SIH_LOC_H0 (`FLOAT`) {#SIH_LOC_H0}

Initial AMSL ground altitude.

This value represents the Above Mean Sea Level (AMSL) altitude where the simulation begins. If using FlightGear as a visual animation, this value can be tweaked such that the vehicle lies on the ground at takeoff. LAT0, LON0, H0, MU_X, MU_Y, and MU_Z should ideally be consistent among each others to represent a physical ground location on Earth.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -420.0 | 8848.0 | 0.01 | 489.4 | m 

### SIH_LOC_LAT0 (`FLOAT`) {#SIH_LOC_LAT0}

Initial geodetic latitude.

This value represents the North-South location on Earth where the simulation begins. LAT0, LON0, H0, MU_X, MU_Y, and MU_Z should ideally be consistent among each others to represent a physical ground location on Earth.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -90 | 90 |  | 47.397742 | deg 

### SIH_LOC_LON0 (`FLOAT`) {#SIH_LOC_LON0}

Initial geodetic longitude.

This value represents the East-West location on Earth where the simulation begins. LAT0, LON0, H0, MU_X, MU_Y, and MU_Z should ideally be consistent among each others to represent a physical ground location on Earth.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | -180 | 180 |  | 8.545594 | deg 

### SIH_L_PITCH (`FLOAT`) {#SIH_L_PITCH}

Pitch arm length.

This is the arm length generating the pitching moment This value can be measured with a ruler. This corresponds to half the distance between the front and rear motors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.05 | 0.2 | m 

### SIH_L_ROLL (`FLOAT`) {#SIH_L_ROLL}

Roll arm length.

This is the arm length generating the rolling moment This value can be measured with a ruler. This corresponds to half the distance between the left and right motors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.05 | 0.2 | m 

### SIH_MASS (`FLOAT`) {#SIH_MASS}

Vehicle mass.

This value can be measured by weighting the quad on a scale.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.1 | 1.0 | kg 

### SIH_Q_MAX (`FLOAT`) {#SIH_Q_MAX}

Max propeller torque.

This is the maximum torque delivered by one propeller when the motor is running at full speed. This value is usually about few percent of the maximum thrust force.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.05 | 0.1 | Nm 

### SIH_T_MAX (`FLOAT`) {#SIH_T_MAX}

Max propeller thrust force.

This is the maximum force delivered by one propeller when the motor is running at full speed. This value is usually about 5 times the mass of the quadrotor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0.0 |  | 0.5 | 5.0 | N 

### SIH_T_TAU (`FLOAT`) {#SIH_T_TAU}

thruster time constant tau.

the time taken for the thruster to step from 0 to 100% should be about 4 times tau

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.05 | s 

### SIH_VEHICLE_TYPE (`INT32`) {#SIH_VEHICLE_TYPE}

Vehicle type.

**Values:**

- `0`: Multicopter
- `1`: Fixed-Wing
- `2`: Tailsitter
- `3`: Standard VTOL


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

## Simulator

### SIM_AGP_FAIL (`INT32`) {#SIM_AGP_FAIL}

AGP failure mode.

Stuck: freeze the measurement to the current location Drift: add a linearly growing bias to the sensor data

**Bitmask:**

- `0`: Stuck
- `1`: Drift


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 3 |  | 0 |  

### SIM_BARO_OFF_P (`FLOAT`) {#SIM_BARO_OFF_P}

simulated barometer pressure offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### SIM_BARO_OFF_T (`FLOAT`) {#SIM_BARO_OFF_T}

simulated barometer temperature offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | celcius 

### SIM_GPS_USED (`INT32`) {#SIM_GPS_USED}

simulated GPS number of satellites used.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 50 |  | 10 |  

### SIM_MAG_OFFSET_X (`FLOAT`) {#SIM_MAG_OFFSET_X}

simulated magnetometer X offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### SIM_MAG_OFFSET_Y (`FLOAT`) {#SIM_MAG_OFFSET_Y}

simulated magnetometer Y offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

### SIM_MAG_OFFSET_Z (`FLOAT`) {#SIM_MAG_OFFSET_Z}

simulated magnetometer Z offset.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | gauss 

## System

### RPM_CAP_ENABLE (`INT32`) {#RPM_CAP_ENABLE}

RPM capture enable.

Enables the RPM capture module to estimate RPM from pulses detected on a PWM pin configured as "RPM Input".

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### RPM_PULS_PER_REV (`INT32`) {#RPM_PULS_PER_REV}

Voltage pulses per revolution.

Number of voltage pulses per one rotor revolution on the capturing pin.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 50 |  | 1 |  

### SYS_AUTOCONFIG (`INT32`) {#SYS_AUTOCONFIG}

Automatically configure default values.

Set to 1 to reset parameters on next system startup (setting defaults). Platform-specific values are used if available. RC* parameters are preserved.

**Values:**

- `0`: Keep parameters
- `1`: Reset parameters to airframe defaults


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SYS_AUTOSTART (`INT32`) {#SYS_AUTOSTART}

Auto-start script index.

CHANGING THIS VALUE REQUIRES A RESTART. Defines the auto-start script used to bootstrap the system.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 9999999 |  | 0 |  

### SYS_BL_UPDATE (`INT32`) {#SYS_BL_UPDATE}

Bootloader update.

If enabled, update the bootloader on the next boot. WARNING: do not cut the power during an update process, otherwise you will have to recover using some alternative method (e.g. JTAG). Instructions: - Insert an SD card - Enable this parameter - Reboot the board (plug the power or send a reboot command) - Wait until the board comes back up (or at least 2 minutes) - If it does not come back, check the file bootlog.txt on the SD card

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SYS_CAL_ACCEL (`INT32`) {#SYS_CAL_ACCEL}

Enable auto start of accelerometer thermal calibration at the next power up.

0 : Set to 0 to do nothing 1 : Set to 1 to start a calibration at next boot This parameter is reset to zero when the temperature calibration starts. default (0, no calibration)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### SYS_CAL_BARO (`INT32`) {#SYS_CAL_BARO}

Enable auto start of barometer thermal calibration at the next power up.

0 : Set to 0 to do nothing 1 : Set to 1 to start a calibration at next boot This parameter is reset to zero when the temperature calibration starts. default (0, no calibration)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### SYS_CAL_GYRO (`INT32`) {#SYS_CAL_GYRO}

Enable auto start of rate gyro thermal calibration at the next power up.

0 : Set to 0 to do nothing 1 : Set to 1 to start a calibration at next boot This parameter is reset to zero when the temperature calibration starts. default (0, no calibration)

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### SYS_CAL_TDEL (`INT32`) {#SYS_CAL_TDEL}

Required temperature rise during thermal calibration.

A temperature increase greater than this value is required during calibration. Calibration will complete for each sensor when the temperature increase above the starting temperature exceeds the value set by SYS_CAL_TDEL. If the temperature rise is insufficient, the calibration will continue indefinitely and the board will need to be repowered to exit.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 10 |  |  | 24 | celcius 

### SYS_CAL_TMAX (`INT32`) {#SYS_CAL_TMAX}

Maximum starting temperature for thermal calibration.

Temperature calibration will not start if the temperature of any sensor is higher than the value set by SYS_CAL_TMAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 10 | celcius 

### SYS_CAL_TMIN (`INT32`) {#SYS_CAL_TMIN}

Minimum starting temperature for thermal calibration.

Temperature calibration for each sensor will ignore data if the temperature is lower than the value set by SYS_CAL_TMIN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5 | celcius 

### SYS_DM_BACKEND (`INT32`) {#SYS_DM_BACKEND}

Dataman storage backend.

**Values:**

- `-1`: Disabled
- `0`: default (SD card)
- `1`: RAM (not persistent)


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### SYS_FAC_CAL_MODE (`INT32`) {#SYS_FAC_CAL_MODE}

Enable factory calibration mode.

If enabled, future sensor calibrations will be stored to /fs/mtd_caldata. Note: this is only supported on boards with a separate calibration storage /fs/mtd_caldata.

**Values:**

- `0`: Disabled
- `1`: All sensors
- `2`: All sensors except mag


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### SYS_FAILURE_EN (`INT32`) {#SYS_FAILURE_EN}

Enable failure injection.

If enabled allows MAVLink INJECT_FAILURE commands. WARNING: the failures can easily cause crashes and are to be used with caution!

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Disabled (0) |  

### SYS_HAS_BARO (`INT32`) {#SYS_HAS_BARO}

Control if the vehicle has a barometer.

Disable this if the board has no barometer, such as some of the Omnibus F4 SD variants. If disabled, the preflight checks will not check for the presence of a barometer.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### SYS_HAS_GPS (`INT32`) {#SYS_HAS_GPS}

Control if the vehicle has a GPS.

Disable this if the system has no GPS. If disabled, the sensors hub will not process sensor_gps, and GPS will not be available for the rest of the system.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Enabled (1) |  

### SYS_HAS_MAG (`INT32`) {#SYS_HAS_MAG}

Control if and how many magnetometers are expected.

0: System has no magnetometer, preflight checks should pass without one. 1-N: Require the presence of N magnetometer sensors for check to pass.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 1 |  

### SYS_HAS_NUM_ASPD (`INT32`) {#SYS_HAS_NUM_ASPD}

Control if the vehicle has an airspeed sensor.

Set this to 0 if the board has no airspeed sensor. If set to 0, the preflight checks will not check for the presence of an airspeed sensor.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### SYS_HAS_NUM_DIST (`INT32`) {#SYS_HAS_NUM_DIST}

Number of distance sensors to check being available.

The preflight check will fail if fewer than this number of distance sensors with valid data is present. Disable the check with 0.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 4 |  | 0 |  

### SYS_HAS_NUM_OF (`INT32`) {#SYS_HAS_NUM_OF}

Number of optical flow sensors required to be available.

The preflight check will fail if fewer than this number of optical flow sensors with valid data are present.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 | 1 |  | 0 |  

### SYS_HITL (`INT32`) {#SYS_HITL}

Enable HITL/SIH mode on next boot.

While enabled the system will boot in Hardware-In-The-Loop (HITL) or Simulation-In-Hardware (SIH) mode and not enable all sensors and checks. When disabled the same vehicle can be flown normally. Set to 'external HITL', if the system should perform as if it were a real vehicle (the only difference to a real system is then only the parameter value, which can be used for log analysis).

**Values:**

- `-1`: external HITL
- `0`: HITL and SIH disabled
- `1`: HITL enabled
- `2`: SIH enabled


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### SYS_PARAM_VER (`INT32`) {#SYS_PARAM_VER}

Parameter version.

This is used internally only: an airframe configuration might set an expected parameter version value via PARAM_DEFAULTS_VER. This is checked on bootup against SYS_PARAM_VER, and if they do not match, parameters are reset and reloaded from the airframe configuration.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 0 |  |  | 1 |  

### SYS_RGB_MAXBRT (`FLOAT`) {#SYS_RGB_MAXBRT}

RGB Led brightness limit.

Set to 0 to disable, 1 for maximum brightness

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1. | % 

### SYS_STCK_EN (`INT32`) {#SYS_STCK_EN}

Enable stack checking.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | Enabled (1) |  

## Telemetry

### TEL_BST_EN (`INT32`) {#TEL_BST_EN}

Blacksheep telemetry Enable.

If true, the FMU will try to connect to Blacksheep telemetry on start up

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### TEL_FRSKY_CONFIG (`INT32`) {#TEL_FRSKY_CONFIG}

Serial Configuration for FrSky Telemetry.

Configure on which serial port to run FrSky Telemetry.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### TEL_HOTT_CONFIG (`INT32`) {#TEL_HOTT_CONFIG}

Serial Configuration for HoTT Telemetry.

Configure on which serial port to run HoTT Telemetry.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

## Testing

### TEST_1 (`INT32`) {#TEST_1}

TEST_1.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2 |  

### TEST_2 (`INT32`) {#TEST_2}

TEST_2.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 4 |  

### TEST_3 (`FLOAT`) {#TEST_3}

TEST_3.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5.0 |  

### TEST_D (`FLOAT`) {#TEST_D}

TEST_D.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.01 |  

### TEST_DEV (`FLOAT`) {#TEST_DEV}

TEST_DEV.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 2.0 |  

### TEST_D_LP (`FLOAT`) {#TEST_D_LP}

TEST_D_LP.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 10.0 |  

### TEST_HP (`FLOAT`) {#TEST_HP}

TEST_HP.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 10.0 |  

### TEST_I (`FLOAT`) {#TEST_I}

TEST_I.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.1 |  

### TEST_I_MAX (`FLOAT`) {#TEST_I_MAX}

TEST_I_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1.0 |  

### TEST_LP (`FLOAT`) {#TEST_LP}

TEST_LP.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 10.0 |  

### TEST_MAX (`FLOAT`) {#TEST_MAX}

TEST_MAX.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1.0 |  

### TEST_MEAN (`FLOAT`) {#TEST_MEAN}

TEST_MEAN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 1.0 |  

### TEST_MIN (`FLOAT`) {#TEST_MIN}

TEST_MIN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | -1.0 |  

### TEST_P (`FLOAT`) {#TEST_P}

TEST_P.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.2 |  

### TEST_PARAMS (`INT32`) {#TEST_PARAMS}

TEST_PARAMS.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 12345678 |  

### TEST_RC2_X (`INT32`) {#TEST_RC2_X}

TEST_RC2_X.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 16 |  

### TEST_RC_X (`INT32`) {#TEST_RC_X}

TEST_RC_X.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 8 |  

### TEST_TRIM (`FLOAT`) {#TEST_TRIM}

TEST_TRIM.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.5 |  

## Thermal Compensation

### TC_A0_ID (`INT32`) {#TC_A0_ID}

ID of Accelerometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_A0_TMAX (`FLOAT`) {#TC_A0_TMAX}

Accelerometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_A0_TMIN (`FLOAT`) {#TC_A0_TMIN}

Accelerometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_TREF (`FLOAT`) {#TC_A0_TREF}

Accelerometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_A0_X0_0 (`FLOAT`) {#TC_A0_X0_0}

Accelerometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X0_1 (`FLOAT`) {#TC_A0_X0_1}

Accelerometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X0_2 (`FLOAT`) {#TC_A0_X0_2}

Accelerometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X1_0 (`FLOAT`) {#TC_A0_X1_0}

Accelerometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X1_1 (`FLOAT`) {#TC_A0_X1_1}

Accelerometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X1_2 (`FLOAT`) {#TC_A0_X1_2}

Accelerometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X2_0 (`FLOAT`) {#TC_A0_X2_0}

Accelerometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X2_1 (`FLOAT`) {#TC_A0_X2_1}

Accelerometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X2_2 (`FLOAT`) {#TC_A0_X2_2}

Accelerometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X3_0 (`FLOAT`) {#TC_A0_X3_0}

Accelerometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X3_1 (`FLOAT`) {#TC_A0_X3_1}

Accelerometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A0_X3_2 (`FLOAT`) {#TC_A0_X3_2}

Accelerometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_ID (`INT32`) {#TC_A1_ID}

ID of Accelerometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_A1_TMAX (`FLOAT`) {#TC_A1_TMAX}

Accelerometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_A1_TMIN (`FLOAT`) {#TC_A1_TMIN}

Accelerometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_TREF (`FLOAT`) {#TC_A1_TREF}

Accelerometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_A1_X0_0 (`FLOAT`) {#TC_A1_X0_0}

Accelerometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X0_1 (`FLOAT`) {#TC_A1_X0_1}

Accelerometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X0_2 (`FLOAT`) {#TC_A1_X0_2}

Accelerometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X1_0 (`FLOAT`) {#TC_A1_X1_0}

Accelerometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X1_1 (`FLOAT`) {#TC_A1_X1_1}

Accelerometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X1_2 (`FLOAT`) {#TC_A1_X1_2}

Accelerometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X2_0 (`FLOAT`) {#TC_A1_X2_0}

Accelerometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X2_1 (`FLOAT`) {#TC_A1_X2_1}

Accelerometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X2_2 (`FLOAT`) {#TC_A1_X2_2}

Accelerometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X3_0 (`FLOAT`) {#TC_A1_X3_0}

Accelerometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X3_1 (`FLOAT`) {#TC_A1_X3_1}

Accelerometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A1_X3_2 (`FLOAT`) {#TC_A1_X3_2}

Accelerometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_ID (`INT32`) {#TC_A2_ID}

ID of Accelerometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_A2_TMAX (`FLOAT`) {#TC_A2_TMAX}

Accelerometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_A2_TMIN (`FLOAT`) {#TC_A2_TMIN}

Accelerometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_TREF (`FLOAT`) {#TC_A2_TREF}

Accelerometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_A2_X0_0 (`FLOAT`) {#TC_A2_X0_0}

Accelerometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X0_1 (`FLOAT`) {#TC_A2_X0_1}

Accelerometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X0_2 (`FLOAT`) {#TC_A2_X0_2}

Accelerometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X1_0 (`FLOAT`) {#TC_A2_X1_0}

Accelerometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X1_1 (`FLOAT`) {#TC_A2_X1_1}

Accelerometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X1_2 (`FLOAT`) {#TC_A2_X1_2}

Accelerometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X2_0 (`FLOAT`) {#TC_A2_X2_0}

Accelerometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X2_1 (`FLOAT`) {#TC_A2_X2_1}

Accelerometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X2_2 (`FLOAT`) {#TC_A2_X2_2}

Accelerometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X3_0 (`FLOAT`) {#TC_A2_X3_0}

Accelerometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X3_1 (`FLOAT`) {#TC_A2_X3_1}

Accelerometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A2_X3_2 (`FLOAT`) {#TC_A2_X3_2}

Accelerometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_ID (`INT32`) {#TC_A3_ID}

ID of Accelerometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_A3_TMAX (`FLOAT`) {#TC_A3_TMAX}

Accelerometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_A3_TMIN (`FLOAT`) {#TC_A3_TMIN}

Accelerometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_TREF (`FLOAT`) {#TC_A3_TREF}

Accelerometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_A3_X0_0 (`FLOAT`) {#TC_A3_X0_0}

Accelerometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X0_1 (`FLOAT`) {#TC_A3_X0_1}

Accelerometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X0_2 (`FLOAT`) {#TC_A3_X0_2}

Accelerometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X1_0 (`FLOAT`) {#TC_A3_X1_0}

Accelerometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X1_1 (`FLOAT`) {#TC_A3_X1_1}

Accelerometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X1_2 (`FLOAT`) {#TC_A3_X1_2}

Accelerometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X2_0 (`FLOAT`) {#TC_A3_X2_0}

Accelerometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X2_1 (`FLOAT`) {#TC_A3_X2_1}

Accelerometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X2_2 (`FLOAT`) {#TC_A3_X2_2}

Accelerometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X3_0 (`FLOAT`) {#TC_A3_X3_0}

Accelerometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X3_1 (`FLOAT`) {#TC_A3_X3_1}

Accelerometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A3_X3_2 (`FLOAT`) {#TC_A3_X3_2}

Accelerometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_A_ENABLE (`INT32`) {#TC_A_ENABLE}

Thermal compensation for accelerometer sensors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### TC_B0_ID (`INT32`) {#TC_B0_ID}

ID of Barometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_B0_TMAX (`FLOAT`) {#TC_B0_TMAX}

Barometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 75.0 |  

### TC_B0_TMIN (`FLOAT`) {#TC_B0_TMIN}

Barometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5.0 |  

### TC_B0_TREF (`FLOAT`) {#TC_B0_TREF}

Barometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 40.0 |  

### TC_B0_X0 (`FLOAT`) {#TC_B0_X0}

Barometer offset temperature ^0 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B0_X1 (`FLOAT`) {#TC_B0_X1}

Barometer offset temperature ^1 polynomial coefficients.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B0_X2 (`FLOAT`) {#TC_B0_X2}

Barometer offset temperature ^2 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B0_X3 (`FLOAT`) {#TC_B0_X3}

Barometer offset temperature ^3 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B0_X4 (`FLOAT`) {#TC_B0_X4}

Barometer offset temperature ^4 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B0_X5 (`FLOAT`) {#TC_B0_X5}

Barometer offset temperature ^5 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_ID (`INT32`) {#TC_B1_ID}

ID of Barometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_B1_TMAX (`FLOAT`) {#TC_B1_TMAX}

Barometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 75.0 |  

### TC_B1_TMIN (`FLOAT`) {#TC_B1_TMIN}

Barometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5.0 |  

### TC_B1_TREF (`FLOAT`) {#TC_B1_TREF}

Barometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 40.0 |  

### TC_B1_X0 (`FLOAT`) {#TC_B1_X0}

Barometer offset temperature ^0 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_X1 (`FLOAT`) {#TC_B1_X1}

Barometer offset temperature ^1 polynomial coefficients.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_X2 (`FLOAT`) {#TC_B1_X2}

Barometer offset temperature ^2 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_X3 (`FLOAT`) {#TC_B1_X3}

Barometer offset temperature ^3 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_X4 (`FLOAT`) {#TC_B1_X4}

Barometer offset temperature ^4 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B1_X5 (`FLOAT`) {#TC_B1_X5}

Barometer offset temperature ^5 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_ID (`INT32`) {#TC_B2_ID}

ID of Barometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_B2_TMAX (`FLOAT`) {#TC_B2_TMAX}

Barometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 75.0 |  

### TC_B2_TMIN (`FLOAT`) {#TC_B2_TMIN}

Barometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5.0 |  

### TC_B2_TREF (`FLOAT`) {#TC_B2_TREF}

Barometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 40.0 |  

### TC_B2_X0 (`FLOAT`) {#TC_B2_X0}

Barometer offset temperature ^0 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_X1 (`FLOAT`) {#TC_B2_X1}

Barometer offset temperature ^1 polynomial coefficients.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_X2 (`FLOAT`) {#TC_B2_X2}

Barometer offset temperature ^2 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_X3 (`FLOAT`) {#TC_B2_X3}

Barometer offset temperature ^3 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_X4 (`FLOAT`) {#TC_B2_X4}

Barometer offset temperature ^4 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B2_X5 (`FLOAT`) {#TC_B2_X5}

Barometer offset temperature ^5 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_ID (`INT32`) {#TC_B3_ID}

ID of Barometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_B3_TMAX (`FLOAT`) {#TC_B3_TMAX}

Barometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 75.0 |  

### TC_B3_TMIN (`FLOAT`) {#TC_B3_TMIN}

Barometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 5.0 |  

### TC_B3_TREF (`FLOAT`) {#TC_B3_TREF}

Barometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 40.0 |  

### TC_B3_X0 (`FLOAT`) {#TC_B3_X0}

Barometer offset temperature ^0 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_X1 (`FLOAT`) {#TC_B3_X1}

Barometer offset temperature ^1 polynomial coefficients.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_X2 (`FLOAT`) {#TC_B3_X2}

Barometer offset temperature ^2 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_X3 (`FLOAT`) {#TC_B3_X3}

Barometer offset temperature ^3 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_X4 (`FLOAT`) {#TC_B3_X4}

Barometer offset temperature ^4 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B3_X5 (`FLOAT`) {#TC_B3_X5}

Barometer offset temperature ^5 polynomial coefficient.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_B_ENABLE (`INT32`) {#TC_B_ENABLE}

Thermal compensation for barometric pressure sensors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### TC_G0_ID (`INT32`) {#TC_G0_ID}

ID of Gyro that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_G0_TMAX (`FLOAT`) {#TC_G0_TMAX}

Gyro calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_G0_TMIN (`FLOAT`) {#TC_G0_TMIN}

Gyro calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_TREF (`FLOAT`) {#TC_G0_TREF}

Gyro calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_G0_X0_0 (`FLOAT`) {#TC_G0_X0_0}

Gyro rate offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X0_1 (`FLOAT`) {#TC_G0_X0_1}

Gyro rate offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X0_2 (`FLOAT`) {#TC_G0_X0_2}

Gyro rate offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X1_0 (`FLOAT`) {#TC_G0_X1_0}

Gyro rate offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X1_1 (`FLOAT`) {#TC_G0_X1_1}

Gyro rate offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X1_2 (`FLOAT`) {#TC_G0_X1_2}

Gyro rate offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X2_0 (`FLOAT`) {#TC_G0_X2_0}

Gyro rate offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X2_1 (`FLOAT`) {#TC_G0_X2_1}

Gyro rate offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X2_2 (`FLOAT`) {#TC_G0_X2_2}

Gyro rate offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X3_0 (`FLOAT`) {#TC_G0_X3_0}

Gyro rate offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X3_1 (`FLOAT`) {#TC_G0_X3_1}

Gyro rate offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G0_X3_2 (`FLOAT`) {#TC_G0_X3_2}

Gyro rate offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_ID (`INT32`) {#TC_G1_ID}

ID of Gyro that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_G1_TMAX (`FLOAT`) {#TC_G1_TMAX}

Gyro calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_G1_TMIN (`FLOAT`) {#TC_G1_TMIN}

Gyro calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_TREF (`FLOAT`) {#TC_G1_TREF}

Gyro calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_G1_X0_0 (`FLOAT`) {#TC_G1_X0_0}

Gyro rate offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X0_1 (`FLOAT`) {#TC_G1_X0_1}

Gyro rate offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X0_2 (`FLOAT`) {#TC_G1_X0_2}

Gyro rate offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X1_0 (`FLOAT`) {#TC_G1_X1_0}

Gyro rate offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X1_1 (`FLOAT`) {#TC_G1_X1_1}

Gyro rate offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X1_2 (`FLOAT`) {#TC_G1_X1_2}

Gyro rate offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X2_0 (`FLOAT`) {#TC_G1_X2_0}

Gyro rate offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X2_1 (`FLOAT`) {#TC_G1_X2_1}

Gyro rate offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X2_2 (`FLOAT`) {#TC_G1_X2_2}

Gyro rate offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X3_0 (`FLOAT`) {#TC_G1_X3_0}

Gyro rate offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X3_1 (`FLOAT`) {#TC_G1_X3_1}

Gyro rate offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G1_X3_2 (`FLOAT`) {#TC_G1_X3_2}

Gyro rate offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_ID (`INT32`) {#TC_G2_ID}

ID of Gyro that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_G2_TMAX (`FLOAT`) {#TC_G2_TMAX}

Gyro calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_G2_TMIN (`FLOAT`) {#TC_G2_TMIN}

Gyro calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_TREF (`FLOAT`) {#TC_G2_TREF}

Gyro calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_G2_X0_0 (`FLOAT`) {#TC_G2_X0_0}

Gyro rate offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X0_1 (`FLOAT`) {#TC_G2_X0_1}

Gyro rate offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X0_2 (`FLOAT`) {#TC_G2_X0_2}

Gyro rate offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X1_0 (`FLOAT`) {#TC_G2_X1_0}

Gyro rate offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X1_1 (`FLOAT`) {#TC_G2_X1_1}

Gyro rate offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X1_2 (`FLOAT`) {#TC_G2_X1_2}

Gyro rate offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X2_0 (`FLOAT`) {#TC_G2_X2_0}

Gyro rate offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X2_1 (`FLOAT`) {#TC_G2_X2_1}

Gyro rate offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X2_2 (`FLOAT`) {#TC_G2_X2_2}

Gyro rate offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X3_0 (`FLOAT`) {#TC_G2_X3_0}

Gyro rate offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X3_1 (`FLOAT`) {#TC_G2_X3_1}

Gyro rate offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G2_X3_2 (`FLOAT`) {#TC_G2_X3_2}

Gyro rate offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_ID (`INT32`) {#TC_G3_ID}

ID of Gyro that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_G3_TMAX (`FLOAT`) {#TC_G3_TMAX}

Gyro calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_G3_TMIN (`FLOAT`) {#TC_G3_TMIN}

Gyro calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_TREF (`FLOAT`) {#TC_G3_TREF}

Gyro calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_G3_X0_0 (`FLOAT`) {#TC_G3_X0_0}

Gyro rate offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X0_1 (`FLOAT`) {#TC_G3_X0_1}

Gyro rate offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X0_2 (`FLOAT`) {#TC_G3_X0_2}

Gyro rate offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X1_0 (`FLOAT`) {#TC_G3_X1_0}

Gyro rate offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X1_1 (`FLOAT`) {#TC_G3_X1_1}

Gyro rate offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X1_2 (`FLOAT`) {#TC_G3_X1_2}

Gyro rate offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X2_0 (`FLOAT`) {#TC_G3_X2_0}

Gyro rate offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X2_1 (`FLOAT`) {#TC_G3_X2_1}

Gyro rate offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X2_2 (`FLOAT`) {#TC_G3_X2_2}

Gyro rate offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X3_0 (`FLOAT`) {#TC_G3_X3_0}

Gyro rate offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X3_1 (`FLOAT`) {#TC_G3_X3_1}

Gyro rate offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G3_X3_2 (`FLOAT`) {#TC_G3_X3_2}

Gyro rate offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_G_ENABLE (`INT32`) {#TC_G_ENABLE}

Thermal compensation for rate gyro sensors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### TC_M0_ID (`INT32`) {#TC_M0_ID}

ID of Magnetometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_M0_TMAX (`FLOAT`) {#TC_M0_TMAX}

Magnetometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_M0_TMIN (`FLOAT`) {#TC_M0_TMIN}

Magnetometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_TREF (`FLOAT`) {#TC_M0_TREF}

Magnetometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_M0_X0_0 (`FLOAT`) {#TC_M0_X0_0}

Magnetometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X0_1 (`FLOAT`) {#TC_M0_X0_1}

Magnetometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X0_2 (`FLOAT`) {#TC_M0_X0_2}

Magnetometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X1_0 (`FLOAT`) {#TC_M0_X1_0}

Magnetometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X1_1 (`FLOAT`) {#TC_M0_X1_1}

Magnetometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X1_2 (`FLOAT`) {#TC_M0_X1_2}

Magnetometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X2_0 (`FLOAT`) {#TC_M0_X2_0}

Magnetometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X2_1 (`FLOAT`) {#TC_M0_X2_1}

Magnetometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X2_2 (`FLOAT`) {#TC_M0_X2_2}

Magnetometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X3_0 (`FLOAT`) {#TC_M0_X3_0}

Magnetometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X3_1 (`FLOAT`) {#TC_M0_X3_1}

Magnetometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M0_X3_2 (`FLOAT`) {#TC_M0_X3_2}

Magnetometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_ID (`INT32`) {#TC_M1_ID}

ID of Magnetometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_M1_TMAX (`FLOAT`) {#TC_M1_TMAX}

Magnetometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_M1_TMIN (`FLOAT`) {#TC_M1_TMIN}

Magnetometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_TREF (`FLOAT`) {#TC_M1_TREF}

Magnetometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_M1_X0_0 (`FLOAT`) {#TC_M1_X0_0}

Magnetometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X0_1 (`FLOAT`) {#TC_M1_X0_1}

Magnetometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X0_2 (`FLOAT`) {#TC_M1_X0_2}

Magnetometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X1_0 (`FLOAT`) {#TC_M1_X1_0}

Magnetometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X1_1 (`FLOAT`) {#TC_M1_X1_1}

Magnetometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X1_2 (`FLOAT`) {#TC_M1_X1_2}

Magnetometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X2_0 (`FLOAT`) {#TC_M1_X2_0}

Magnetometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X2_1 (`FLOAT`) {#TC_M1_X2_1}

Magnetometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X2_2 (`FLOAT`) {#TC_M1_X2_2}

Magnetometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X3_0 (`FLOAT`) {#TC_M1_X3_0}

Magnetometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X3_1 (`FLOAT`) {#TC_M1_X3_1}

Magnetometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M1_X3_2 (`FLOAT`) {#TC_M1_X3_2}

Magnetometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_ID (`INT32`) {#TC_M2_ID}

ID of Magnetometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_M2_TMAX (`FLOAT`) {#TC_M2_TMAX}

Magnetometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_M2_TMIN (`FLOAT`) {#TC_M2_TMIN}

Magnetometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_TREF (`FLOAT`) {#TC_M2_TREF}

Magnetometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_M2_X0_0 (`FLOAT`) {#TC_M2_X0_0}

Magnetometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X0_1 (`FLOAT`) {#TC_M2_X0_1}

Magnetometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X0_2 (`FLOAT`) {#TC_M2_X0_2}

Magnetometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X1_0 (`FLOAT`) {#TC_M2_X1_0}

Magnetometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X1_1 (`FLOAT`) {#TC_M2_X1_1}

Magnetometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X1_2 (`FLOAT`) {#TC_M2_X1_2}

Magnetometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X2_0 (`FLOAT`) {#TC_M2_X2_0}

Magnetometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X2_1 (`FLOAT`) {#TC_M2_X2_1}

Magnetometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X2_2 (`FLOAT`) {#TC_M2_X2_2}

Magnetometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X3_0 (`FLOAT`) {#TC_M2_X3_0}

Magnetometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X3_1 (`FLOAT`) {#TC_M2_X3_1}

Magnetometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M2_X3_2 (`FLOAT`) {#TC_M2_X3_2}

Magnetometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_ID (`INT32`) {#TC_M3_ID}

ID of Magnetometer that the calibration is for.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0 |  

### TC_M3_TMAX (`FLOAT`) {#TC_M3_TMAX}

Magnetometer calibration maximum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 100.0 |  

### TC_M3_TMIN (`FLOAT`) {#TC_M3_TMIN}

Magnetometer calibration minimum temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_TREF (`FLOAT`) {#TC_M3_TREF}

Magnetometer calibration reference temperature.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 25.0 |  

### TC_M3_X0_0 (`FLOAT`) {#TC_M3_X0_0}

Magnetometer offset temperature ^0 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X0_1 (`FLOAT`) {#TC_M3_X0_1}

Magnetometer offset temperature ^0 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X0_2 (`FLOAT`) {#TC_M3_X0_2}

Magnetometer offset temperature ^0 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X1_0 (`FLOAT`) {#TC_M3_X1_0}

Magnetometer offset temperature ^1 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X1_1 (`FLOAT`) {#TC_M3_X1_1}

Magnetometer offset temperature ^1 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X1_2 (`FLOAT`) {#TC_M3_X1_2}

Magnetometer offset temperature ^1 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X2_0 (`FLOAT`) {#TC_M3_X2_0}

Magnetometer offset temperature ^2 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X2_1 (`FLOAT`) {#TC_M3_X2_1}

Magnetometer offset temperature ^2 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X2_2 (`FLOAT`) {#TC_M3_X2_2}

Magnetometer offset temperature ^2 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X3_0 (`FLOAT`) {#TC_M3_X3_0}

Magnetometer offset temperature ^3 polynomial coefficient - X axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X3_1 (`FLOAT`) {#TC_M3_X3_1}

Magnetometer offset temperature ^3 polynomial coefficient - Y axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M3_X3_2 (`FLOAT`) {#TC_M3_X3_2}

Magnetometer offset temperature ^3 polynomial coefficient - Z axis.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 |  

### TC_M_ENABLE (`INT32`) {#TC_M_ENABLE}

Thermal compensation for magnetometer sensors.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

## Transponder

### MXS_EXT_CFG (`INT32`) {#MXS_EXT_CFG}

Sagetech External Configuration Mode.

Disables auto-configuration mode enabling MXS config through external software.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### MXS_OP_MODE (`INT32`) {#MXS_OP_MODE}

Sagetech MXS mode configuration.

This parameter defines the operating mode of the MXS

**Values:**

- `0`: Off
- `1`: On
- `2`: Standby
- `3`: Alt


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 0 |  

### MXS_SER_CFG (`INT32`) {#MXS_SER_CFG}

Serial Configuration for Sagetech MXS Serial Port.

Configure on which serial port to run Sagetech MXS Serial Port.

**Values:**

- `0`: Disabled
- `6`: UART 6
- `101`: TELEM 1
- `102`: TELEM 2
- `103`: TELEM 3
- `104`: TELEM/SERIAL 4
- `201`: GPS 1
- `202`: GPS 2
- `203`: GPS 3
- `300`: Radio Controller
- `301`: Wifi Port
- `401`: EXT2


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | 0 |  

### MXS_TARG_PORT (`INT32`) {#MXS_TARG_PORT}

Sagetech MXS Participant Configuration.

The MXS communication port to receive Target data from

**Values:**

- `0`: Auto
- `1`: COM0
- `2`: COM1


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 1 |  

## UAVCAN

### CANNODE_BITRATE (`INT32`) {#CANNODE_BITRATE}

UAVCAN CAN bus bitrate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; | 20000 | 1000000 |  | 1000000 |  

### CANNODE_PUB_MBD (`INT32`) {#CANNODE_PUB_MBD}

Enable MovingBaselineData publication.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### CANNODE_SUB_MBD (`INT32`) {#CANNODE_SUB_MBD}

Enable MovingBaselineData subscription.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  | 1 |  | Disabled (0) |  

### CANNODE_SUB_RTCM (`INT32`) {#CANNODE_SUB_RTCM}

Enable RTCM subscription.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### CANNODE_TERM (`INT32`) {#CANNODE_TERM}

CAN built-in bus termination.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  | 1 |  | Disabled (0) |  

### SIM_GZ_EN (`INT32`) {#SIM_GZ_EN}

Simulator Gazebo bridge enable.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_BITRATE (`INT32`) {#UAVCAN_BITRATE}

UAVCAN CAN bus bitrate.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 20000 | 1000000 |  | 1000000 | bit/s 

### UAVCAN_ECU_FUELT (`INT32`) {#UAVCAN_ECU_FUELT}

UAVCAN fuel tank fuel type.

This parameter defines the type of fuel used in the vehicle's fuel tank. 0: Unknown 1: Liquid (e.g., gasoline, diesel) 2: Gas (e.g., hydrogen, methane, propane)

**Values:**

- `0`: Unknown
- `1`: Liquid
- `2`: Gas


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 1 |  

### UAVCAN_ECU_MAXF (`FLOAT`) {#UAVCAN_ECU_MAXF}

UAVCAN fuel tank maximum capacity.

This parameter defines the maximum fuel capacity of the vehicle's fuel tank.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0.0 | 100000.0 | 0.1 | 15.0 | liters 

### UAVCAN_ENABLE (`INT32`) {#UAVCAN_ENABLE}

UAVCAN mode.

0 - UAVCAN disabled. 1 - Enables support for UAVCAN sensors without dynamic node ID allocation and firmware update. 2 - Enables support for UAVCAN sensors with dynamic node ID allocation and firmware update. 3 - Enables support for UAVCAN sensors and actuators with dynamic node ID allocation and firmware update. Also sets the motor control outputs to UAVCAN.

**Values:**

- `0`: Disabled
- `1`: Sensors Manual Config
- `2`: Sensors Automatic Config
- `3`: Sensors and Actuators (ESCs) Automatic Config


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 0 |  

### UAVCAN_LGT_ANTCL (`INT32`) {#UAVCAN_LGT_ANTCL}

UAVCAN ANTI_COLLISION light operating mode.

This parameter defines the minimum condition under which the system will command the ANTI_COLLISION lights on 0 - Always off 1 - When autopilot is armed 2 - When autopilot is prearmed 3 - Always on

**Values:**

- `0`: Always off
- `1`: When autopilot is armed
- `2`: When autopilot is prearmed
- `3`: Always on


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 2 |  

### UAVCAN_LGT_LAND (`INT32`) {#UAVCAN_LGT_LAND}

UAVCAN LIGHT_ID_LANDING light operating mode.

This parameter defines the minimum condition under which the system will command the LIGHT_ID_LANDING lights on 0 - Always off 1 - When autopilot is armed 2 - When autopilot is prearmed 3 - Always on

**Values:**

- `0`: Always off
- `1`: When autopilot is armed
- `2`: When autopilot is prearmed
- `3`: Always on


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 0 |  

### UAVCAN_LGT_NAV (`INT32`) {#UAVCAN_LGT_NAV}

UAVCAN RIGHT_OF_WAY light operating mode.

This parameter defines the minimum condition under which the system will command the RIGHT_OF_WAY lights on 0 - Always off 1 - When autopilot is armed 2 - When autopilot is prearmed 3 - Always on

**Values:**

- `0`: Always off
- `1`: When autopilot is armed
- `2`: When autopilot is prearmed
- `3`: Always on


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 3 |  

### UAVCAN_LGT_STROB (`INT32`) {#UAVCAN_LGT_STROB}

UAVCAN STROBE light operating mode.

This parameter defines the minimum condition under which the system will command the STROBE lights on 0 - Always off 1 - When autopilot is armed 2 - When autopilot is prearmed 3 - Always on

**Values:**

- `0`: Always off
- `1`: When autopilot is armed
- `2`: When autopilot is prearmed
- `3`: Always on


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 3 |  | 1 |  

### UAVCAN_NODE_ID (`INT32`) {#UAVCAN_NODE_ID}

UAVCAN Node ID.

Read the specs at http://uavcan.org to learn more about Node ID.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 1 | 125 |  | 1 |  

### UAVCAN_PUB_ARM (`INT32`) {#UAVCAN_PUB_ARM}

publish Arming Status stream.

Enable UAVCAN Arming Status stream publication uavcan::equipment::safety::ArmingStatus

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_PUB_MBD (`INT32`) {#UAVCAN_PUB_MBD}

publish moving baseline data RTCM stream.

Enable UAVCAN RTCM stream publication ardupilot::gnss::MovingBaselineData

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_PUB_RTCM (`INT32`) {#UAVCAN_PUB_RTCM}

publish RTCM stream.

Enable UAVCAN RTCM stream publication uavcan::equipment::gnss::RTCMStream

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_RNG_MAX (`FLOAT`) {#UAVCAN_RNG_MAX}

UAVCAN rangefinder maximum range.

This parameter defines the maximum valid range for a rangefinder connected via UAVCAN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 999.0 | m 

### UAVCAN_RNG_MIN (`FLOAT`) {#UAVCAN_RNG_MIN}

UAVCAN rangefinder minimum range.

This parameter defines the minimum valid range for a rangefinder connected via UAVCAN.

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&nbsp; |  |  |  | 0.0 | m 

### UAVCAN_SUB_ASPD (`INT32`) {#UAVCAN_SUB_ASPD}

subscription airspeed.

Enable UAVCAN airspeed subscriptions. uavcan::equipment::air_data::IndicatedAirspeed uavcan::equipment::air_data::TrueAirspeed uavcan::equipment::air_data::StaticTemperature

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_SUB_BARO (`INT32`) {#UAVCAN_SUB_BARO}

subscription barometer.

Enable UAVCAN barometer subscription. uavcan::equipment::air_data::StaticPressure uavcan::equipment::air_data::StaticTemperature

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; |  |  |  | Disabled (0) |  

### UAVCAN_SUB_BAT (`INT32`) {#UAVCAN_SUB_BAT}

subscription battery.

Enable UAVCAN battery subscription. uavcan::equipment::power::BatteryInfo ardupilot::equipment::power::BatteryInfoAux 0 - Disable 1 - Use raw data. Recommended for Smart battery 2 - Filter the data with internal battery library

**Values:**

- `0`: Disable
- `1`: Raw data
- `2`: Filter data


Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 0 | 2 |  | 0 |  

### UAVCAN_SUB_BTN (`INT32`) {#UAVCAN_SUB_BTN}

subscription button.

Enable UAVCAN button subscription. ardupilot::indication::Button

Reboot | minValue | maxValue | increment | default | unit
--- | --- | --- | --- | --- | ---
&check; | 