# Advanced Configuration

This topic lists configuration topics that are not particularly vehicle specific, for features that are more rarely modified, or that are specific only to manufacturers/OEMs.

## Parameters

- [Finding/Updating Parameters](../advanced_config/parameters.md)
- [Full Parameter Reference](../advanced_config/parameter_reference.md)

## Feature configuration

- [Using PX4's Navigation Filter (EKF2)](../advanced_config/tuning_the_ecl_ekf.md)
- [Flight Termination Configuration](../advanced_config/flight_termination.md)
- [Land Detector Configuration](../advanced_config/land_detector.md)
- [Prearm/Arm/Disarm Configuration](../advanced_config/prearm_arm_disarm.md)

## OEM/Factory Calibration

- [IMU Factory Calibration](../advanced_config/imu_factory_calibration.md)
- [Sensor Thermal Compensation](../advanced_config/sensor_thermal_calibration.md)
- [Compass Power Compensation](../advanced_config/compass_power_compensation.md)
- [Advanced Controller Orientation](../advanced_config/advanced_flight_controller_orientation_leveling.md)
- [Static Pressure Buildup](../advanced_config/static_pressure_buildup.md)

## Serial port/Ethernet configuration

- [Serial Port Configuration](../peripherals/serial_configuration.md)
- [MAVLink Telemetry (OSD/GCS)](../peripherals/mavlink_peripherals.md)
- [PX4 Ethernet Setup](../advanced_config/ethernet_setup.md)

## Miscellaneous

- [Bootloader Update](../advanced_config/bootloader_update.md)
  - [Bootloader Update FMUv6X-RT via USB](../advanced_config/bootloader_update_v6xrt.md)

## See Also

- [Standard Configuration](../config/index.md) - Setup essential sensors/features needed for most PX4 vehicles.
- [Flight Controller Peripherals](../peripherals/index.md) - Setup specific sensors, optional sensors, actuators, and so on.
- Vehicle Config/Tuning:
  - [Multicopter Config/Tuning](../config_mc/index.md)
  - [Helicopter Config/Tuning](../config_heli/index.md)
  - [Fixed-wing Config/Tuning](../config_fw/index.md)
  - [VTOL Config/Tuning](../config_vtol/index.md)
