# bridge2ai-redcap

REDCap Data Dictionary and Metadata for the Bridge2AI project.

[![GitHub](https://img.shields.io/badge/github-3.24.0-green?style=flat&logo=github)](https://github.com/eipm/bridge2ai-redcap) [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT) [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.12760724.svg)](https://zenodo.org/doi/10.5281/zenodo.12760724)

| Version | Date YYYY-mm-dd | Data Dictionary | Metadata | Instrument PDF's |
| :---: | :---: | :---: | :---: | :---: |
| v3.24.0 | 2024-04-28 | [Data Dictionary](data/bridge2ai_voice_project_data_dictionary.csv) | [Metadata](data/bridge2ai_voice_project_metadata.xml) | [Files](data/instrument_pdfs/) |

## 🤝 License
See [LICENSE](./LICENSE)

## 📚 How to Cite
> Bensoussan, Y., Ghosh, S. S., Rameau, A., Boyer, M., Bahr, R., Watts, S., Rudzicz, F., Bolser, D., Lerner-Ellis, J., Awan, S., Powell, M. E., Belisle-Pipon, J.-C., Ravitsky, V., Johnson, A., Zisimopoulos, P., Tang, J., Sigaras, A., Elemento, O., Dorr, D., … Bridge2AI-Voice. (2024). eipm/bridge2ai-redcap. Zenodo. [https://zenodo.org/doi/10.5281/zenodo.12760724](https://zenodo.org/doi/10.5281/zenodo.12760724)

## Protocol Overview

- [Adult Protocols](#adult-protocols)
  - [Part A | Generic Protocol](#part-a--generic-protocol)
  - [Part B | Disease Specific Protocols](#part-b--disease-specific-protocols)
  - [Part A & B | Total Metrics per Protocol](#part-a--b--total-metrics-per-protocol)
  - [Task Overview](#task-overview)
  - [🎤 Acoustic Tasks | YouTube Playlist](#-acoustic-tasks--youtube-playlist)
  - [📕 Questionnaires](#-questionnaires)
  - [Clinically Validated Diagnoses Forms](#clinically-validated-diagnoses-forms)
- [Pediatric Protocols](#pediatric-protocols)
  - [Age Specific Protocols](#age-specific-protocols)
  - [Task Overview](#task-overview-1)
  - [🎤 Acoustic Tasks | YouTube Playlist](#-acoustic-tasks--youtube-playlist-1)
  - [📕 Questionnaires](#-questionnaires-1)

---

### Adult Protocols

#### Part A | Generic Protocol

| # | Protocol 📓 | # of Questionnaires 📕 | # of Acoustic Tasks 🎤 | # of Recordings 🔊 | Estimated time to complete (mm:ss) ⏳ |
| :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Generic Protocol | 6 | 10 | 28 | 37:00 |

#### Part B | Disease Specific Protocols

| # | Protocol 📓 | # of Questionnaires 📕 | # of Acoustic Tasks 🎤 | # of Recordings 🔊 | Estimated time to complete (mm:ss) ⏳ |
| :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Voice Disorders Protocol | 1 | 3 | 8 | 04:00 | 
| 2 | Mood and Psychiatric Disorders Protocol | 6 | 2 | 2 | 20:30 |
| 3 | Respiratory Disorders | 2 | 2 | 2 | 06:30 |
| 4 | Neurological and Neurodegenerative Disorders | 1 | 4 | 9 | 12:00 |

#### Part A & B | Total Metrics per Protocol

| # | Protocol 📓 | Total # of Questionnaires 📕 | Total # of Acoustic Tasks 🎤 | Total # of Recordings 🔊 | Estimated time to complete (mm:ss) ⏳ |
| :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Generic Protocol | 6 | 10 | 28 | 37:00 |
| 1 | Voice Disorders Protocol | 7 | 13 | 36 | 41:00 | 
| 2 | Mood and Psychiatric Disorders Protocol | 12 | 12 | 30 | 57:30 |
| 3 | Respiratory Disorders | 8 | 12 | 30 | 43:30 |
| 4 | Neurological and Neurodegenerative Disorders | 7 | 14 | 37 | 49:00 |

#### Task Overview

| # | Task Name | Type | Estimated Time to Complete (mm:ss) ⏳ | Protocol 📓 | Total # of Recordings 🔊 (if Acoustic Task) | Questionnaire Form PDF Link / Acoustic Task Description Youtube Link | 
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Demographics | Questionnaire 📕 | 03:00 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20Generic%20Demographics.pdf) |
| 2 | Confounders | Questionnaire 📕 | 12:00 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20Generic%20Confounders.pdf) |
| 3 | Voice Perception | Questionnaire 📕 | 00:30 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20Generic%20Voice%20Perception.pdf) |
| 4 | VHI-10 | Questionnaire 📕 | 01:00 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20Generic%20Voice%20Handicap%20Index%20Vhi10.pdf) |
| 5 | Patient Health Questionnaire-9 | Questionnaire 📕 | 01:30 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20Generic%20Patient%20Health%20Questionnaire9.pdf) |
| 6 | GAD-7 Anxiety | Questionnaire 📕 | 01:30 | Generic Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Generic%20-%20Gad7%20Anxiety.pdf) |
| 7 | Prolonged Vowel | Acoustic Task 🎤 | 01:00 | Generic Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=ZanjPvWkB3M) |
| 8 | Maximum Phonation Time | Acoustic Task 🎤 | 02:00 | Generic Protocol | 3 | [YouTube Link](https://www.youtube.com/watch?v=1limRFPAtPE) |
| 9 | Rainbow Passage | Acoustic Task 🎤 | 01:30 | Generic Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=Syq_ryCNQKQ) |
| 10 | Glides | Acoustic Task 🎤 | 01:00 | Generic Protocol | 2 | [YouTube Link](https://www.youtube.com/watch?v=xKBYdkwEOvU)|
| 11 | Loudness | Acoustic Task 🎤 | 01:00 | Generic Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=5ssCSqZPb7Y) |
| 12 | Diadochokinesis | Acoustic Task 🎤 | 01:00 | Generic Protocol | 5 | [YouTube Link](https://www.youtube.com/watch?v=RlY5KMXtZ4o) |
| 13 | Free Speech | Acoustic Task 🎤 | 02:00 | Generic Protocol | 10 | [YouTube Link](https://www.youtube.com/watch?v=FqK0WeGCAzg) |
| 14 | Respiration and cough | Acoustic Task 🎤 | 03:00 | Generic Protocol | 3 | [YouTube Link](https://www.youtube.com/watch?v=Yb4bMj18Iqg) |
| 15 | Picture Description | Acoustic Task 🎤 | 01:30 | Generic Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=abjWJEN6jf8) |
| 16 | Story Recall | Acoustic Task 🎤 | 03:30 | Generic Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=cfkU-N5tWe4) |
| 17 | Voice Problem Severity | Questionnaire 📕 | 00:30 | Voice Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Voice%20-%20Voice%20Problem%20Severity.pdf) |
| 18 | Caterpillar Passage | Acoustic Task 🎤 | 01:30 | Voice Disorders Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=jN7bGT-PFXY) |
| 19 | Cape V Sentences | Acoustic Task 🎤 | 01:00 | Voice Disorders Protocol | 6 | [YouTube Link](https://www.youtube.com/watch?v=1qbiCdWxuSY) |
| 20 | Free Speech | Acoustic Task 🎤 | 01:00 | Voice Disorders Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=5QMBSHNLRVI) |
| 21 | PANAS | Questionnaire 📕 | 01:00 | Mood and Psychiatric Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Mood%20-%20Panas.pdf) |
| 22 | Custom Affect Scale | Questionnaire 📕 | 01:30 | Mood and Psychiatric Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Mood%20-%20Custom%20Affect%20Scale.pdf) |
| 23 | DSM-5 Adult | Questionnaire 📕 | 06:00 | Mood and Psychiatric Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Mood%20-%20Dsm5%20Adult.pdf) |
| 24 | PTSD Adult | Questionnaire 📕 | 03:00 | Mood and Psychiatric Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Mood%20-%20Ptsd%20Adult.pdf) |
| 25 | ADHD Adult | Questionnaire 📕 | 03:00 | Mood and Psychiatric Disorders Protocol | - | [PDF](data/instrument_pdfs/Q%20-%20Mood%20-%20Adhd%20Adult.pdf) |
| 26 | Animal Fluency | Acoustic Task 🎤 | 01:30 | Mood and Psychiatric Disorders Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=4lkEAxDiEE8) |
| 27 | Participant History | Questionnaire 📕 | 02:00 | Mood and Psychiatric Disorders Protocol | 1 | [PDF](data/instrument_pdfs/Q%20Mood%20Participant%20History.pdf) |
| 28 | Open response questions | Acoustic Task 🎤 | 02:30 | Mood and Psychiatric Disorders Protocol | 1 | [YouTube Link](https://www.youtube.com/watch?v=THfOnGCaALA) |
| 29 | Dyspnea Index (DI) | Questionnaire 📕 | 01:00 | Respiratory Disorders | - | [PDF](data/instrument_pdfs/Q%20-%20Resp%20-%20Dyspnea%20Index%20Di.pdf) |
| 30 | Leicester Cough Questionnaire (LCQ) | Questionnaire 📕 | 03:00 | Respiratory Disorders | - | [PDF](data/instrument_pdfs/Q%20-%20Resp%20-%20Leicester%20Cough%20Questionnaire%20Lcq.pdf) |
| 31 | Breath Sounds | Acoustic Task 🎤 | 01:30 | Respiratory Disorders | 1 | [YouTube Link](https://www.youtube.com/watch?v=2rLMfMjS_R0) |
| 32 | Voluntary Cough | Acoustic Task 🎤 | 01:00 | Respiratory Disorders | 1 | [YouTube Link](https://www.youtube.com/watch?v=i7BhlwNMk28) |
| 33 | Winograd Questionnaire | Questionnaire 📕 | 01:00 | Neurological and Neurodegenerative Disorders | - | [PDF](data/instrument_pdfs/Q%20-%20Neuro%20Winograd%20Schemas.pdf) |
| 34 | Word-color Stroop | Acoustic Task 🎤 | 01:30 | Neurological and Neurodegenerative Disorders | 1 | [YouTube Link](https://www.youtube.com/watch?v=IzotHKbYh30)|
| 35 | Productive Vocabulary | Acoustic Task 🎤 | 05:00 | Neurological and Neurodegenerative Disorders | 6 | [YouTube Link](https://www.youtube.com/watch?v=TEshcUAlfPA) |
| 36 | Random Item Generation | Acoustic Task 🎤 | 02:30 | Neurological and Neurodegenerative Disorders | 1 | [YouTube Link](https://www.youtube.com/watch?v=ry__w1Mm2aE) |
| 37 | Cinderella Story | Acoustic Task 🎤 | 05:00 | Neurological and Neurodegenerative Disorders | 1 | [YouTube Link](https://www.youtube.com/watch?v=eHx-vetG8Fk) |

#### 🎤 Acoustic Tasks | YouTube Playlist

All our acoustic tasks are available via our [Acoustic Task YouTube Playlist](https://youtube.com/playlist?list=PL72MPaFiuoRY66W7QsZ1_IeBwNosOzeap&si=9nr51lsmEYUncRMN).

#### 📕 Questionnaires

All Questionnaires are available in .pdf under [data/instrument_pdfs](data/instrument_pdfs/) in this repository.

#### Clinically Validated Diagnoses Forms

| # | Protocol | Clinically Validated Diagnosis | Form PDF Link |
| :---: | :---: | :---: | :---: |
| 1 | Voice Disorders Protocol | Benign Lessions | [PDF](data/instrument_pdfs/D%20Voice%20Benign%20Lesions.pdf) |
| 2 | Voice Disorders Protocol | Voice Glottic Insufficiency / Presbyphonia | [PDF](data/instrument_pdfs/D%20Voice%20Glottic%20Insufficiency.pdf) |
| 3 | Voice Disorders Protocol | Laryngeal Cancer | [PDF](data/instrument_pdfs/D%20Voice%20Laryngeal%20Cancer.pdf) |
| 4 | Voice Disorders Protocol | Laryngitis | [PDF](data/instrument_pdfs/D%20Voice%20Laryngitis.pdf) |
| 5 | Voice Disorders Protocol | Muscle Tension Dysphonia | [PDF](data/instrument_pdfs/D%20Voice%20Muscle%20Tension%20Dysphonia%20Mtd.pdf) |
| 6 | Voice Disorders Protocol | Precancerous Lessions | [PDF](data/instrument_pdfs/D%20Voice%20Precancerous%20Lesions.pdf) |
| 7 | Voice Disorders Protocol | Laryngeal Dystonia | [PDF](data/instrument_pdfs/D%20Voice%20Laryngeal%20Dystonia.pdf) |
| 8 | Voice Disorders Protocol | Unilateral vocal fold paralysis | [PDF](data/instrument_pdfs/D%20Voice%20Unilateral%20Vocal%20Fold%20Paralysis.pdf) |
| 9 | Mood and Psychiatric Disorders Protocol | Anxiety Disorder | [PDF](data/instrument_pdfs/D%20Mood%20Anxiety%20Disorder.pdf) |
| 10 | Mood and Psychiatric Disorders Protocol | Bipolar Disorder | [PDF](data/instrument_pdfs/D%20Mood%20Bipolar%20Disorder.pdf) |
| 11 | Mood and Psychiatric Disorders Protocol | Depression or Major Depressive Disorder | [PDF](data/instrument_pdfs/D%20Mood%20Depression%20Or%20Major%20Depressive%20Disorder.pdf) |
| 12 | Respiratoty Disorders | Airway Stenosis | [PDF](data/instrument_pdfs/D%20Resp%20Airway%20Stenosis.pdf) |
| 13 |  Respiratoty Disorders | Unexplained Chronic Cough | [PDF](data/instrument_pdfs/D%20Resp%20-%20Unexplained%20Chronic%20Cough.pdf) |
| 14 | Neurological and Neurodegenerative Disorders | Alzheimer's, dementia, or mild cognitive impairment | [PDF](data/instrument_pdfs/D%20Neuro%20Alzheimers%20Disease%20Mild%20Cognitive%20Impairment.pdf) |
| 15 | Neurological and Neurodegenerative Disorders | Amyotrophic Lateral Sclerosis (ALS) | [PDF](data/instrument_pdfs/D%20Neuro%20Amyotrophic%20Lateral%20Sclerosis%20Als.pdf) |
| 16 | Neurological and Neurodegenerative Disorders | Huntington's Disease (HD) | [PDF](data/instrument_pdfs/D%20Neuro%20Huntingtons%20Disease.pdf) |
| 17 | Neurological and Neurodegenerative Disorders | Parkinson's Disease | [PDF](data/instrument_pdfs/D%20Neuro%20Parkinsons%20Disease.pdf) |
| 18 | Control | Control | [PDF](data/instrument_pdfs/D%20Control.pdf) |

---

### Pediatric Protocols

#### Age Specific Protocols

| # | Protocol 📓 | # of Questionnaires 📕 | # of Acoustic Tasks 🎤 | # of Recordings 🔊 | Estimated time to complete (mm:ss) ⏳ |
| :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Pediatric Disorders - Ages [2-4)] | 5 | 4 | 51 | NA |
| 2 | Pediatric Disorders - Ages [4-6)] | 5 | 7 | 63 | NA |
| 3 | Pediatric Disorders - Ages [6-10)]| 5 | 8 | 76 | NA |
| 4 | Pediatric Disorders - Ages 10+ | 5 | 8 | 67 | NA |

#### Task Overview

| # | Task Name | Type | Estimated Time to Complete (mm:ss) ⏳ | Pediatric Protocol Ages 📓 | Total # of Recordings 🔊 (if Acoustic Task) | Questionnaire Form PDF Link / Acoustic Task Description Youtube Link | 
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | Pediatric Demographics | Questionnaire 📕 | NA | All | - | [PDF](data/instrument_pdfs/Q%20Pediatric%20Demographics.pdf) |
| 2 | Pediatric VHI10 | Questionnaire 📕 | NA | All | - | [PDF](data/instrument_pdfs/Q%20Pediatric%20VHI10.pdf) |
| 3 | Pediatric Voice Outcome Survey | Questionnaire 📕 | NA | All | - | [PDF](data/instrument_pdfs/Q%20Pediatric%20Voice%20Outcome%20Survey.pdf) |
| 4 | Pediatric Voice Related QOL Survey | Questionnaire 📕 | NA | All | - | [PDF](data/instrument_pdfs/Q%20Pediatric%20Voice%20Related%20QOL%20Survey.pdf) |
| 5 | Pediatric PHQ-A | Questionnaire 📕 | NA | All | - | [PDF](data/instrument_pdfs/Q%20Pediatric%20PHQ-A.pdf) |
| 6 | Conversation (Simple) | Acoustic Task 🎤 | NA | [2 - 4), <br> [4 - 6) | 2 | NA |
| 7 | Abcs and 123s | Acoustic Task 🎤 | NA | [2 - 4) | 2 | NA |
| 8 | Noisy Sounds | Acoustic Task 🎤 | NA | [2 - 4), <br> [4 - 6), <br> [6 - 10) | 10 | NA |
| 9 | Identifying Pictures | Acoustic Task 🎤 | NA | [2 - 4), <br> [4 - 6), <br> [6 - 10), <br> 10+ | 37 | NA |
| 10 | Days and Number Naming | Acoustic Task 🎤 | NA | [4 - 6) | 3 | NA |
| 11 | Silly Sounds | Acoustic Task 🎤 | NA | [4 - 6), <br> [6 - 10), <br> 10+ | 4 | NA |
| 12 | Repeating Sentences | Acoustic Task 🎤 | NA | [4 - 6), <br> [6 - 10), <br> 10+ | 6 | NA |
| 13 | Picture Description | Acoustic Task 🎤 | NA | [4 - 6), <br> [6 - 10), <br> 10+ | 1 | NA |
| 14 | Conversation (Advanced) | Acoustic Task 🎤 | NA | [6 - 10), <br> 10+ | 4 | NA |
| 15 | Role naming tasks sounds | Acoustic Task 🎤 | NA | [6 - 10) | 3 | NA |
| 16 | Reading Passage | Acoustic Task 🎤 | NA | [6 - 10), <br> 10+ | 11 | NA |
| 17 | Generative Naming Task | Acoustic Task 🎤 | NA | 10+ | 2 | NA |
| 18 | Long Sounds | Acoustic Task 🎤 | NA | 10+ | 2 | NA |

#### 🎤 Acoustic Tasks | YouTube Playlist

The Acoustic Task Playlist for Pediatrics is currently under development.

#### 📕 Questionnaires

All Questionnaires are available in .pdf under [data/instrument_pdfs](data/instrument_pdfs/) in this repository.
