/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
parser grammar PlainTextParser;

options { tokenVocab=MasterLexer; }

plain_text_file : ( plain_text_fragment)+  EOF;

plain_text_fragment : (word |WS |punctuation)+ ;

word :  LETTER+  (PUNCTUATION LETTER+)* (homologous_form)? LETTER*  (PUNCTUATION LETTER+)* | homologous_form; 

homologous_form : OPEN_HOMOLOGOUS_FORM HOMOLOGOUS_LETTER* CLOSE_HOMOLOGOUS_FORM;

punctuation : PUNCTUATION ;

xml_tag  : (xml_tag_open (plain_text_fragment | xml_tag)* xml_tag_close) | 
	xml_tag_simple ;
xml_tag_open  : XML_MARKER tagName=Name  xml_attr* CLOSE;
xml_tag_simple : XML_MARKER tagName=Name xml_attr* SLASH_CLOSE;
xml_tag_close : XML_MARKER SLASH tagName=Name CLOSE ;
xml_attr : Name EQUALS STRING;

