/*
 * The LilacParser.
 */
parser grammar LilacParser;

options { tokenVocab=MasterLexer;}

import PlainTextParser;

lilac_document :  (empty_line|lilac_character_line|lilac_comment_line)* lilac_line (empty_line|lilac_line|lilac_comment_line)* EOF;

lilac_line :  lilac_lhs (plain_text_fragment | xml_tag_open|xml_tag_close|xml_tag_simple)* (LINE_BREAK)? ;

empty_line : WS* LINE_BREAK;

lilac_comment_line :  (ZERO|NON_ZERO_DIGIT|DELIMITER)* LILAC_COMMENT LINE_BREAK;

lilac_character_line :  lilac_character_lhs character_tag LINE_BREAK;

lilac_lhs : lilac_scene_numbers (DELIMITER)? speaker PIPE;

lilac_scene_numbers : non_zero_number DELIMITER non_zero_number (DELIMITER (non_zero_number|POSSIBLE_SPEAKER)+)*;

lilac_character_lhs : zero_number DELIMITER zero_number DELIMITER zero_number speaker PIPE;

zero_line : zero_number LINE_BREAK ;

non_zero_number :  ZERO* NON_ZERO_DIGIT+ (ZERO|NON_ZERO_DIGIT)* ;
zero_number : ZERO+;
speaker : OPEN_SPEAKER POSSIBLE_SPEAKER+ CLOSE_SPEAKER;

character_tag : WS* XML_MARKER character_assignment  (SLASH_CLOSE|CLOSE) WS*;
character_assignment :  character_id (X_COLON|EQUALS) (character_name|WS*);
character_id : WS* Name ;
character_name :  Name (Name | AllowedInSpeakerTag)* ;
