# [Contributing Guidelines](@id contributing)

Great that you want to contribute to the development of Tulipa! Please read these guidelines and our [Developer Documentation](@ref developer) to get you started.

## GitHub Rules of Engagement

- If you want to discuss something that isn't immediately actionable, post under Discussions. Convert it to an issue once it's actionable.
- All PR's should have an associated issue (unless it's a very minor fix).
- All issues should have 1 Type and 1+ Zone labels (unless Type: epic).
- Assign yourself to issues you want to address. Consider if you will be able to work on them in the near future (this week) — if not, leave them available for someone else.
- Set the issue Status to "In Progress" when you have started working on it.
- When finalizing a pull request, set the Status to "Ready for Review." If someone specific needs to review it, assign them as the reviewer (otherwise anyone can review).
- Issues addressed by merged PRs will automatically move to Done.
- If you want to discuss an issue at the next group meeting (or just get some attention), mark it with the "question" label.
- Issues without updates for 60 days (and PRs without updates in 30 days) will be labelled as "stale" and filtered out of view. There is a Stale project board to view and revive these.

## Contributing Workflow

Fork → Branch → Code → Push → Pull → Squash & Merge

1. Fork the repository
2. Create a new branch (in your fork)
3. Do fantastic coding
4. Push to your fork
5. Create a pull request from your fork to the main repository
6. (After review) Squash and merge

For a step-by-step guide to these steps, see our [Developer Documentation](@ref developer).

We use this workflow in our quest to achieve the [Utopic Git History](https://blog.esciencecenter.nl/the-utopic-git-history-d44b81c09593).
