#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Author: Anja Katzenberger, anja.katzenberger@pik-potsdam.de

# Creates figure with hysteresis from observations, the Monsoon Planet and a simple conceptual model

#%%
### IMPORT MODULES
#-----------------

import matplotlib.pyplot as plt

save_dir = 'C:/Users/anjaka/Nextcloud/PhD/03_MonsoonPlanet_Hysteresis/Figures/hysteresis/hysteresis_model_theory_reality'

#%%
### LOAD RELEVANT DATA
#----------------- 

### OBSERVATIONS
# INDIAN MONSOON
# observed precipitation data from GPCC (monthly 2001-2019, ymonmean)
# https://doi.org/10.5676/DWD_GPCC/FD_D_V2020_100
# observed shortwave down (top of atmosphere) data from CERES (monthly 2001-2019)
# https://doi.org/10.1175/JCLI-D-17-0208.1
pr_real26 = [ 0.30728261,  0.34644146,  0.51103205,  0.42182588,  0.5261395 , 5.07152486, 10.46477641,  9.0704515 ,  6.47192628,  1.43013852, 0.28781827,  0.11485303]
sw_real26 = [302.9352 , 347.8605 , 398.76846, 436.96152, 455.035  , 459.07535, 454.90115, 440.2444 , 409.37167, 362.411  , 313.64886, 287.9772 ]



### SIMULTIONS
# MONSOON PLANET; 10 - 20 N
# Baseline configuration with slab depth of 50m
pr_model = [3.42345654e-04, 7.55714059e-05, 5.07875556e-04, 1.13948025e-02, 1.53534445e-01, 1.44282669e+00, 3.47266347e+00, 6.31072456e+00, 9.71391329e+00, 6.19832293e+00, 2.04484746e-01, 7.55528843e-04]
sw_model = [341.87440258, 378.76189133, 416.72019871, 439.90280544,445.4843251 , 443.65720454, 442.3796803 , 438.27336431,421.69894286, 388.72020109, 350.10510208, 328.81892519]



### THEORY
# MOISTURE ADVECTION THEORY 
# based on the code MonsoonSeasonalCycle.py
pr_theory = [1.1348910175874727e-64, 3.893822440564047e-229, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 5.7200944e-317, 9.344911369840522, 9.35326410807322, 9.361064195035944, 9.368313370336198, 9.37501323717935, 9.381165265835167, 9.386770796780656, 9.391831043537405, 9.396347095217065, 9.400319918787227, 9.403750361068365, 9.406639150471305, 9.408986898483189, 9.410794100908932, 9.412061138873812, 9.41278827959175, 9.41297567690288, 9.412623371582756, 9.411731291424621, 9.410299251095156, 9.408326951763026, 9.405813980498516, 9.40275980944159, 9.399163794734529, 9.395025175214293, 9.3903430708586, 9.385116480978487, 9.379344282148983, 9.373025225868115, 9.366157935933122, 9.358740905521381, 9.350772493961772, 9.342250923180702, 9.333174273805087, 9.323540480902604, 9.313347329337457, 9.30259244871741, 9.291273307905358, 9.279387209065938, 9.26693128121446, 9.253902473232008, 9.240297546306955, 9.226113065758744, 9.211345392195186, 9.195990671949486, 9.180044826737182, 9.16350354246692, 9.146362257131786, 9.128616147699576, 9.110260115911563, 9.091288772888843, 9.071696422433849, 9.051477042901462, 9.030624267499325, 9.009131362859968, 8.986991205708225, 8.964196257425288, 8.94073853628572, 8.916609587114788, 8.891800448080264, 8.866301614294473, 8.840102997858205, 8.813193883926454, 8.785562882316254, 8.75719787410693, 8.728085952601432, 8.698213357921098, 8.667565404393086, 8.636126399755444, 8.603879555045506, 8.570806883847286, 8.536889089345788, 8.502105437362324, 8.46643361321374, 8.429849559836237, 8.392327294123449, 8.353838697825305, 8.314353278610021, 8.273837895966444, 8.23225644546782, 8.189569493462344, 8.145733852409807, 8.100702084724666, 8.05442191994593, 8.006835566102023, 7.957878890951547, 7.907480441902013, 7.85556026418571, 7.802028464356441, 7.746783448965975, 7.68970974428903, 7.630675268991694, 7.569527882697859, 7.5060909615657625, 7.440157644294002, 7.37148322672113, 7.2997749228309665, 7.224677787367927, 7.145754885432758, 7.062458554083933, 6.974087330966795, 6.879718735675406, 6.778099018056016, 6.667450627781618, 6.5451073896371925, 6.406741704254833, 6.244438126141641, 6.040421392805969, 5.73096816867646, 4.862966900860809e-41, 1.6684888110705852e-205, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317, 5.63472e-317]
pr_theory_delay = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002173278412562971, 0.29863033267394795, 1.6273867708650218, 3.4307220655986037, 5.056072164301781, 6.315271660054902, 7.233110492223487, 7.885359286197398, 8.344020019500231, 8.665244170742778, 8.88995371741347, 9.047171822090421, 9.15724632907725, 9.234371868233133, 9.288429257361143, 9.326290112745612, 9.352731367241057, 9.371073155310807, 9.383622821366586, 9.391983718065841, 9.397269896476445, 9.40025534543955, 9.401477723388956, 9.401310452518537, 9.400012819510403, 9.397764788425476, 9.394691187962597, 9.390878514358192, 9.38638660310426, 9.381256735582486, 9.375517268995205, 9.369187545861273, 9.362280608499997, 9.354805083491465, 9.346766489623912, 9.33816814539089, 9.329011798299089, 9.3192980608837, 9.309026712373605, 9.298196906932734, 9.286807316886268, 9.274856230653505, 9.262341619073606, 9.24926117962308, 9.235612365109786, 9.221392401409005, 9.20659829740101, 9.19122684929264, 9.175274640823678, 9.158738040388151, 9.141613195766014, 9.123896026930568, 9.105582217234105, 9.086667203156564, 9.067146162720858, 9.04701400261567, 9.02626534402264, 9.004894507109016, 8.982895494116987, 8.960261970957497, 8.936987247193983, 8.913064254277604, 8.888485521877438, 8.863243152122314, 8.837328791548774, 8.810733600520939, 8.783448219858295, 8.755462734372752, 8.726766632976387, 8.697348764976953, 8.667197292127305, 8.636299635932819, 8.604642419655658, 8.572211404371567, 8.538991418342734, 8.504966278861932, 8.470118705594915, 8.434430224297389, 8.397881059606808, 8.360450015398659, 8.32211434094699, 8.282849580832833, 8.242629406185792, 8.201425424416387, 8.159206964077974, 8.115940830868368, 8.07159103001331, 8.026118449334911, 7.979480496147721, 7.931630679690629, 7.8825181290116655, 7.832087033978535, 7.78027599425209, 7.727017257457148, 7.672235823168793, 7.615848383372297, 7.557762062299241, 7.497872908350644, 7.436064077305485, 7.372203627905285, 7.306141826373261, 7.2377078227901315, 7.166705515527386, 7.092908354125211, 7.016052736861504, 6.9358295223136714, 6.851872971292765, 6.763746128625186, 6.6709211794052425, 6.572752560668068, 6.468439378302543, 6.356971600995884, 6.237050860821047, 6.106970020166352, 5.9644228006452416, 5.8061883644438685, 5.627577222618778, 5.42138194866881, 5.17567949280107, 4.868513304450387, 4.451672491861376, 3.770381657264915, 2.368551987346916, 1.3739919937349114, 0.7855709805878862, 0.4453562226664135, 0.2512571704935649, 0.14136118190371677, 0.07940805351355437, 0.044567433925156434, 0.02500094596473508, 0.014020870381553023, 0.007861873059080737, 0.004407976129789116, 0.0024713327180591843, 0.0013855152322213514, 0.0007767561838665894, 0.00043546614222178076, 0.00024413046127469401, 0.00013686373066121334, 7.672804224528872e-05, 4.30149567752613e-05, 2.4114855140163877e-05, 1.3519159997912357e-05, 7.579048623406597e-06, 4.24893064494204e-06, 2.382015431235578e-06, 1.3353942059625276e-06, 7.486423620647999e-07, 4.1970032453589365e-07, 2.3529040102675932e-07, 1.319073858999942e-07, 7.394929140158007e-08, 4.145710004789425e-08, 2.3241482251098144e-08, 1.3029529235399372e-08, 7.304552706124441e-09, 4.095043594304774e-09, 2.2957438618295047e-09, 1.2870290041169748e-09, 7.215280785264319e-10, 4.044996394273671e-10, 2.2676866384783652e-10, 1.271299696978783e-10, 7.127099891634694e-11, 3.9955608410836126e-11, 2.2399723137782605e-11, 1.2557626240853687e-11, 7.039996692591475e-12, 3.946729459940215e-12, 2.212596697147799e-12, 1.2404154361022201e-12, 6.953958017310777e-13, 3.898494867048399e-13, 2.18555564910933e-13, 1.2252558123720638e-13, 6.868970855824759e-14, 3.850849768818893e-14, 2.1588450807645666e-14, 1.2102814605958711e-14, 6.785022357154553e-15, 3.803786960796821e-15, 2.1324609531862666e-15, 1.1954901164894656e-15, 6.702099827377932e-16, 3.757299326575832e-16, 2.106399276808499e-16, 1.1808795434413452e-16, 6.620190727709886e-17, 3.711379836721926e-17, 2.080656110823415e-17, 1.16644753217458e-17, 6.539282672607144e-18, 3.666021547710733e-18, 2.055227562585385e-18, 1.152191900412691e-18, 6.459363427895148e-19, 3.6212176008775065e-19, 2.03010978702249e-19, 1.1381104925497358e-19, 6.380420908918339e-20, 3.576961221380161e-20, 2.0052989860548853e-20, 1.1242011793242783e-20, 6.302443178712532e-21, 3.5332457171745125e-21, 1.9807914080206424e-21, 1.1104618574974163e-21, 6.225418446199899e-22, 3.490064478002674e-22, 1.9565833471083803e-22, 1.0968904495348227e-22, 6.149335064406298e-23]

sw_theory = [330.91844917898493, 331.92252277532816, 332.945680565866, 333.9875164115267, 335.0476167590471, 336.12556080513076, 337.22092066348466, 338.33326153466726, 339.4621418786806, 340.6071135902381, 341.7677221766386, 342.9435069381755, 344.13400115101035, 345.33873225243684, 346.5572220284634, 347.78898680363835, 349.0335376330434, 350.2903804963788, 351.55901649406286, 352.83894204526854, 354.12964908781817, 355.4306252798571, 356.7413542032261, 358.0613155684517, 359.38998542127337, 360.7268363506257, 362.0713376979921, 363.4229557680479, 364.78115404050953, 366.1453933831036, 367.5151322655744, 368.88982697464195, 370.26893182982764, 371.65189940005996, 373.0381807209756, 374.42722551282895, 375.81848239892383, 377.2113991244806, 378.60542277585193, 380.0, 381.39457722414807, 382.7886008755194, 384.18151760107617, 385.57277448717105, 386.9618192790244, 388.34810059994004, 389.73106817017236, 391.11017302535805, 392.4848677344256, 393.8546066168964, 395.21884595949047, 396.5770442319521, 397.9286623020079, 399.2731636493743, 400.61001457872663, 401.9386844315483, 403.2586457967739, 404.5693747201429, 405.87035091218183, 407.16105795473146, 408.44098350593714, 409.7096195036212, 410.9664623669566, 412.21101319636165, 413.4427779715366, 414.66126774756316, 415.86599884898965, 417.0564930618245, 418.2322778233614, 419.3928864097619, 420.5378581213194, 421.66673846533274, 422.77907933651534, 423.87443919486924, 424.9523832409529, 426.0124835884733, 427.054319434134, 428.07747722467184, 429.08155082101507, 430.0661416594993, 431.0308589100759, 431.9753196314506, 432.8991489230908, 433.80198007404124, 434.68345470848834, 435.5432229280167, 436.38094345049973, 437.1962837455708, 437.9889201666198, 438.7585380792637, 439.50483198623954, 440.2275056486706, 440.92627220365756, 441.6008542781475, 442.2509840990364, 442.87640359946073, 443.4768645212363, 444.05212851340326, 444.6019672268392, 445.126162404901, 445.62450597006153, 446.0968001065051, 446.54285733864987, 446.9625006055656, 447.35556333125743, 447.7218894907877, 448.06133367220946, 448.37376113428735, 448.65904785998254, 448.917080605681, 449.14775694614514, 449.3509853151712, 449.526685041936, 449.67478638301924, 449.7952305500876, 449.88796973323076, 449.9529671199394, 449.99019690971767, 449.9996443243247, 449.98130561364087, 449.9351880571561, 449.8613099610806, 449.7597006510782, 449.63040046062554, 449.47346071500186, 449.28894371091553, 449.07692269177585, 448.837481818619, 448.5707161367008, 448.2767315377688, 447.9556447180287, 447.6075831318225, 447.23268494103564, 446.8310989602543, 446.40298459769383, 445.9485117919222, 445.4678609444036, 444.9612228478883, 444.42879861067865, 443.8707995767994, 443.2874472421055, 442.67897316636015, 442.0456188813177, 441.38763579484885, 440.7052850911445, 439.9988376270403, 439.26857382450027, 438.5147835593046, 437.7377660459844, 436.93782971904943, 436.11529211055597, 435.27047972406365, 434.4037279050311, 433.51538070770107, 432.6057907585302, 431.6753191162142, 430.7243351283675, 429.7532162849114, 428.7623480682312, 427.7521238001598, 426.7229444858503, 425.6752186545981, 424.60936219767666, 423.5257982032507, 422.424956788433, 421.3072749285507, 420.17319628368944, 419.02317102258394, 417.85765564392494, 416.67711279515385, 415.4820110888161, 414.27282491654705, 413.0500342607639, 411.8141245041381, 410.5655862369245, 409.304915062223, 408.0326113992508, 406.7491802847024, 405.45513117227705, 404.15097773045295, 402.837237638588, 401.5144323814291, 400.18308704211, 398.84373009372166, 397.4968931895366, 396.1431109519708, 394.7829207603672, 393.4168625376845, 392.0454785361771, 390.66931312214933, 389.2889125598712, 387.90482479474093, 386.51759923577947, 385.12778653754447, 383.73593838155006, 382.3426072572784, 380.94834624287114, 379.5537087855865, 378.1592484821105, 376.7655188588087, 375.3730731520054, 373.9824640883788, 372.59424366555726, 371.2089629330066, 369.8271717732922, 368.44941868380516, 367.07625055903804, 365.7082124734969, 364.34584746533613, 362.98969632080065, 361.6402973595631, 360.2981862210394, 358.96389565176867, 357.6379552939411, 356.3208914751583, 355.01322699950924, 353.71548094004515, 352.428168432735, 351.15180047198396, 349.8868837077959, 348.63392024466066, 347.39340744224495, 346.1658377179672, 344.95169835153416, 343.75147129151696, 342.565632964043, 341.3946540836804, 340.2389994665891, 339.0991278460142, 337.9754916901927, 336.8685370227481, 335.7787032456428, 334.7064229647589, 333.6521218181766, 332.61621830721896, 331.5991236303286, 330.6012415198446, 329.6229680817417, 328.66469163839747, 327.72679257444923, 326.80964318580163, 325.9136075318447, 325.03904129094207, 324.18629161924554, 323.3556970128923, 322.5475871736405, 321.76228287799506, 321.00009584987606, 320.2613286368818, 319.5462744901928, 318.8552172481671, 318.18843122367156, 317.54618109519413, 316.9287218017808, 316.3362984418381, 315.7691461758424, 315.22749013299375, 314.7115453218512, 314.2215165449864, 313.75759831768755, 313.31997479074727, 312.9088196773647, 312.52429618419035, 312.16655694654213, 311.835743967817, 311.53198856312315, 311.2554113071552, 311.00612198633223, 310.78421955521844, 310.5897920972437, 310.4229167897387, 310.2836598733, 310.1720766254962, 310.08821133892513, 310.03209730363255, 310.00375679389754, 310.00320105939096, 310.0304303207097, 310.08543376928935, 310.1681895716945, 310.27866487828544, 310.4168158362578, 310.58258760704973, 310.7759143881097, 310.99671943901706, 311.2449151119434, 311.5204028864444, 311.823073408567, 312.1528065342571, 312.50947137705055, 312.8929263600279, 313.30301927201276, 313.7395873279919, 314.20245723373193, 314.69144525456795, 315.20635728833633, 315.746988942423, 316.3131256148966, 316.90454257969355, 317.5210050758227, 318.1622684005528, 318.8280780065464, 319.51816960290154, 320.2322692600613, 320.970093518549, 321.7313495014867, 322.5157350308516, 323.32293874742453, 324.15264023438306, 325.00451014449, 325.8782103308263, 326.7733939810178, 327.6897057549009, 328.6267819255739, 329.584250523777]
sw_theory_delay = [330.91844917898493, 331.92252277532816, 332.945680565866, 333.9875164115267, 335.0476167590471, 336.12556080513076, 337.22092066348466, 338.33326153466726, 339.4621418786806, 340.6071135902381, 341.7677221766386, 342.9435069381755, 344.13400115101035, 345.33873225243684, 346.5572220284634, 347.78898680363835, 349.0335376330434, 350.2903804963788, 351.55901649406286, 352.83894204526854, 354.12964908781817, 355.4306252798571, 356.7413542032261, 358.0613155684517, 359.38998542127337, 360.7268363506257, 362.0713376979921, 363.4229557680479, 364.78115404050953, 366.1453933831036, 367.5151322655744, 368.88982697464195, 370.26893182982764, 371.65189940005996, 373.0381807209756, 374.42722551282895, 375.81848239892383, 377.2113991244806, 378.60542277585193, 380.0, 381.39457722414807, 382.7886008755194, 384.18151760107617, 385.57277448717105, 386.9618192790244, 388.34810059994004, 389.73106817017236, 391.11017302535805, 392.4848677344256, 393.8546066168964, 395.21884595949047, 396.5770442319521, 397.9286623020079, 399.2731636493743, 400.61001457872663, 401.9386844315483, 403.2586457967739, 404.5693747201429, 405.87035091218183, 407.16105795473146, 408.44098350593714, 409.7096195036212, 410.9664623669566, 412.21101319636165, 413.4427779715366, 414.66126774756316, 415.86599884898965, 417.0564930618245, 418.2322778233614, 419.3928864097619, 420.5378581213194, 421.66673846533274, 422.77907933651534, 423.87443919486924, 424.9523832409529, 426.0124835884733, 427.054319434134, 428.07747722467184, 429.08155082101507, 430.0661416594993, 431.0308589100759, 431.9753196314506, 432.8991489230908, 433.80198007404124, 434.68345470848834, 435.5432229280167, 436.38094345049973, 437.1962837455708, 437.9889201666198, 438.7585380792637, 439.50483198623954, 440.2275056486706, 440.92627220365756, 441.6008542781475, 442.2509840990364, 442.87640359946073, 443.4768645212363, 444.05212851340326, 444.6019672268392, 445.126162404901, 445.62450597006153, 446.0968001065051, 446.54285733864987, 446.9625006055656, 447.35556333125743, 447.7218894907877, 448.06133367220946, 448.37376113428735, 448.65904785998254, 448.917080605681, 449.14775694614514, 449.3509853151712, 449.526685041936, 449.67478638301924, 449.7952305500876, 449.88796973323076, 449.9529671199394, 449.99019690971767, 449.9996443243247, 449.98130561364087, 449.9351880571561, 449.8613099610806, 449.7597006510782, 449.63040046062554, 449.47346071500186, 449.28894371091553, 449.07692269177585, 448.837481818619, 448.5707161367008, 448.2767315377688, 447.9556447180287, 447.6075831318225, 447.23268494103564, 446.8310989602543, 446.40298459769383, 445.9485117919222, 445.4678609444036, 444.9612228478883, 444.42879861067865, 443.8707995767994, 443.2874472421055, 442.67897316636015, 442.0456188813177, 441.38763579484885, 440.7052850911445, 439.9988376270403, 439.26857382450027, 438.5147835593046, 437.7377660459844, 436.93782971904943, 436.11529211055597, 435.27047972406365, 434.4037279050311, 433.51538070770107, 432.6057907585302, 431.6753191162142, 430.7243351283675, 429.7532162849114, 428.7623480682312, 427.7521238001598, 426.7229444858503, 425.6752186545981, 424.60936219767666, 423.5257982032507, 422.424956788433, 421.3072749285507, 420.17319628368944, 419.02317102258394, 417.85765564392494, 416.67711279515385, 415.4820110888161, 414.27282491654705, 413.0500342607639, 411.8141245041381, 410.5655862369245, 409.304915062223, 408.0326113992508, 406.7491802847024, 405.45513117227705, 404.15097773045295, 402.837237638588, 401.5144323814291, 400.18308704211, 398.84373009372166, 397.4968931895366, 396.1431109519708, 394.7829207603672, 393.4168625376845, 392.0454785361771, 390.66931312214933, 389.2889125598712, 387.90482479474093, 386.51759923577947, 385.12778653754447, 383.73593838155006, 382.3426072572784, 380.94834624287114, 379.5537087855865, 378.1592484821105, 376.7655188588087, 375.3730731520054, 373.9824640883788, 372.59424366555726, 371.2089629330066, 369.8271717732922, 368.44941868380516, 367.07625055903804, 365.7082124734969, 364.34584746533613, 362.98969632080065, 361.6402973595631, 360.2981862210394, 358.96389565176867, 357.6379552939411, 356.3208914751583, 355.01322699950924, 353.71548094004515, 352.428168432735, 351.15180047198396, 349.8868837077959, 348.63392024466066, 347.39340744224495, 346.1658377179672, 344.95169835153416, 343.75147129151696, 342.565632964043, 341.3946540836804, 340.2389994665891, 339.0991278460142, 337.9754916901927, 336.8685370227481, 335.7787032456428, 334.7064229647589, 333.6521218181766, 332.61621830721896, 331.5991236303286, 330.6012415198446, 329.6229680817417, 328.66469163839747, 327.72679257444923, 326.80964318580163, 325.9136075318447, 325.03904129094207, 324.18629161924554, 323.3556970128923, 322.5475871736405, 321.76228287799506, 321.00009584987606, 320.2613286368818, 319.5462744901928, 318.8552172481671, 318.18843122367156, 317.54618109519413, 316.9287218017808, 316.3362984418381, 315.7691461758424, 315.22749013299375, 314.7115453218512, 314.2215165449864, 313.75759831768755, 313.31997479074727, 312.9088196773647, 312.52429618419035, 312.16655694654213, 311.835743967817, 311.53198856312315, 311.2554113071552, 311.00612198633223, 310.78421955521844, 310.5897920972437, 310.4229167897387, 310.2836598733, 310.1720766254962, 310.08821133892513, 310.03209730363255, 310.00375679389754, 310.00320105939096, 310.0304303207097, 310.08543376928935, 310.1681895716945, 310.27866487828544, 310.4168158362578, 310.58258760704973, 310.7759143881097, 310.99671943901706, 311.2449151119434, 311.5204028864444, 311.823073408567, 312.1528065342571, 312.50947137705055, 312.8929263600279, 313.30301927201276, 313.7395873279919, 314.20245723373193, 314.69144525456795, 315.20635728833633, 315.746988942423, 316.3131256148966, 316.90454257969355, 317.5210050758227, 318.1622684005528, 318.8280780065464, 319.51816960290154, 320.2322692600613, 320.970093518549, 321.7313495014867, 322.5157350308516, 323.32293874742453, 324.15264023438306, 325.00451014449, 325.8782103308263, 326.7733939810178, 327.6897057549009, 328.6267819255739, 329.584250523777]




#%%
### MAIN PLOT
#---------------------
plt.rcParams.update({'font.size': 16})  

fig = plt.figure(figsize = (5,5))
ax = plt.subplot(111)
ax.plot(sw_real26,pr_real26, label = "Observations ",linewidth = 1.8, color = "black")
ax.plot([sw_real26[0],sw_real26[-1]], [pr_real26[0], pr_real26[-1]], label = "Model",linewidth = 1.8, color = "black")
ax.plot(sw_model,pr_model, label = "Model",linewidth = 1.8, color = "red")
ax.plot([sw_model[0],sw_model[-1]], [pr_model[0], pr_model[-1]], label = "Model",linewidth = 1.8, color = "red")
ax.plot(sw_model[6],pr_model[6], marker = ".", markersize = 10, color = "red")
ax.plot(sw_real26[6],pr_real26[6], marker = ".", markersize = 10, color = "black")
ax.plot(sw_model[0],pr_model[0], marker = ">", markersize = 10, color = "red")
ax.plot(sw_real26[0],pr_real26[0], marker = ">", markersize = 10, color = "black")


#ax.plot(sw_theory,pr_theory, label = "Theory",linewidth = 1.8)
#ax.plot(sw_theory_delay,pr_theory_delay, label = "Theory with delay")
#plt.legend(frameon = False, loc = 'center left')
plt.ylabel("Monsoon Rainfall (mm/day)")
plt.ylim([-0.2,10.7])
plt.xlabel("Solar Radiation ($W/m^2$)")

plt.savefig(save_dir + "/hysteresis_theory_model_observations_marker2_withdelay.pdf", bbox_inches = "tight", pad_inches = 0)


#%%
### 3 PANELS 1x3: MODEL - OBSERVATIONS - THEORY
#---------------------

fig, (ax1,ax2,ax3) = plt.subplots(1,3,figsize = (13,5))

ax2.plot(sw_model,pr_model, label = "Model (Monsoon Planet)", color = "#FF8000")
ax2.set_title( "Atmospheric Model")
ax1.plot(sw_real26,pr_real26, label = "Observations (Indian Monsoon) ", color = "darkblue")
ax1.set_title("Observations")
ax3.plot(sw_theory,pr_theory, label = "Theory (Moisture Advection Feedback)")
ax3.set_title("Theory")

ax1.set_ylim([0, 11])
ax2.set_ylim([0, 11])
ax3.set_ylim([0, 11])

ax1.set_xlim([280,470])
ax2.set_xlim([280,470])
ax3.set_xlim([280,470])

ax1.set_ylabel("Monsoon Rainfall (mm/day)")
ax2.set_xlabel("Solar Radiation ($W/m^2$)")

plt.savefig(save_dir + "/hysteresis_model_theory_reality/hysteresis_theory_model_observations_panel.pdf",bbox = "tight")



# %%
