# Artifact for "Usability Barriers for Liquid Types"

This artifact contains the materials for our qualitative study exploring developer experiences with LiquidHaskell. This README includes two guides: a [Getting Started Guide](#getting-started-guide)
 for a quick 30-minute overview, and comprehensive [Step-by-Step Instructions](#step-by-step-instructions)
 that connect our artifact to the paper's methodology and findings. Through these guides, you'll see how our recruitment materials, interview protocols, tutorial, and thematic analysis codebook directly support and validate the research presented in our paper.

## Getting Started Guide

### Overview
This guide provides instructions for accessing and exploring the qualitative study artifact for our research on developer experiences with LiquidHaskell. The artifact contains interview protocols, recruiting documents, a LiquidHaskell tutorial, and a thematic analysis codebook. This guide is designed to be completed within 30 minutes and will allow you to explore all components of the artifact.

### Setup Instructions

#### System Requirements
- PDF viewer (e.g., Adobe Reader, Preview, or browser-based PDF viewer)
- Web browser for accessing the online tutorial (e.g., Google Chrome)
- Microsoft Excel or compatible spreadsheet software for viewing the codebook


#### Installation Steps
1. Download and extract the artifact ZIP file from the provided link
2. Ensure you have the required software installed (PDF viewer, web browser, spreadsheet software)
3. No additional installation is required as the materials are primarily document-based

#### Access Information
- No special credentials required for accessing the artifact materials
- The tutorial website is publicly accessible at: https://catarinagamboa.github.io/liquidhaskell-short-tutorial/Tutorial_01_Introduction.html


### Basic Testing (30-minute exploration)

#### 1. Verify Artifact Structure (5 minutes)
Once the files are extracted, you should see the following components:
- `study_design/` - Contains recruitment materials, study protocols, and interview guides
- `study_results/` - Contains the codebook used for thematic analysis


Open each folder to explore the files inside.
Use the [Step-by-Step Instructions](#step-by-step-instructions) to analyze each component.

#### 2. Explore Recruitment and Study Design (5 minutes)
Navigate to the `study_design/` folder and open the file `RecruitingDocuments.pdf`. This document contains the recruitment messages and materials used to find participants for our study.

Explore the recruitment criteria and messaging as described in Section 3.2 of the paper.

#### 3. Examine Study Protocols (5 minutes)
Navigate to the `study_design/` folder and open `ResearchGuide.pdf`. 
This document contains the detailed protocols and interview guides for each of our three participant groups: New Users, Experienced Users - Current Users, and Experienced Users - Former Users.

Review the interview questions and observe how they relate to the methodology described in Section 3.1 of the paper.

#### 4. Try the LiquidHaskell Tutorial (10 minutes)
Navigate to the tutorial website (https://catarinagamboa.github.io/liquidhaskell-short-tutorial/Tutorial_01_Introduction.html) or open `study_design/tutorial.pdf`. This tutorial was used to introduce new participants to LiquidHaskell and observe their interactions.

Complete one of the simple exercises in the introduction section by reading the material and trying to understand how liquid types work. The tutorial provides answers after each exercise for immediate feedback.

#### 5. Review the Analysis Codebook (5 minutes)
Navigate to the `study_results/` folder and open `Codebook.xlsx`. This spreadsheet contains the codes used in our thematic analysis, their descriptions, and example quotes from participants.

Locate the major themes and review how specific codes are organized hierarchically. Notice how these codes correspond to the findings presented in Section 4 of the paper.


### Next Steps

After completing this Getting Started Guide, you should be able to:
1. Navigate the full artifact structure
2. Understand how participants were recruited and selected
3. Explore the interview protocols and study design
4. Try the LiquidHaskell tutorial that was used with new participants
5. Review the thematic analysis approach through the codebook

For a more detailed exploration, proceed to the Step-by-Step Instructions.


## Step-by-Step Instructions

This document provides detailed instructions for exploring the qualitative study artifact. These instructions are designed to help you understand how our materials support the methodology, findings, and claims presented in our paper.

### 1. Qualitative Study Design (Connection to Paper Section 3 - INTERVIEWS WITH DEVELOPERS)

**Objective:** Demonstrate how the artifact components comprehensively support and enable replication of the qualitative methodology described in Section 3 of the paper, providing all necessary materials to understand and reproduce the interview and observational studies.

#### Key components:
1. Recruitment documents.
2. Study protocols for our three target populations: New Users, Experienced Users - Current Users, Experienced Users - Former Users.
3. Interview guides for each of the target populations.
4. Short LiquidHaskell Tutorial.

#### Instructions:
##### Recruitment
1. Navigate to `[study_design/RecruitingDocuments.pdf]`
2. See the recruitment messages and documents used for the study.
4. Compare these with section *3.2. Recruitment* of the paper.

##### Study Protocols
1. Navigate to `[study_design/sign-up.pdf]`
2. See that the sign-up aligns with the process described at the start of section *3.1. Study Design*.
3. Navigate to `[study_design/ResearchGuide.pdf]`
4. See the protocols for each population and the interview guides with the questions we asked the participants.
5. Compare these protocols with the study design presented in the remainder of the section *3.1. Study Design*.

##### Tutorial
1. Navigate to the tutorial [website](https://catarinagamboa.github.io/liquidhaskell-short-tutorial/Tutorial_01_Introduction.html), or check the pdf version at `[study_design/tutorial.pdf]`.
2. This was the environment used by new participants to complete the tutorial presented in the paper, where the first sections were for the introduction of LiquidHaskell and the last one was a case study where we observed participants using liquid types. This tutorial is a forked version of the full tutorial which is available at [ucsd-progsys githb repo](https://github.com/ucsd-progsys/liquidhaskell-tutorial). Our tutorial is a shorter version to fit into the allocated time of the sessions, but we do not run our own installation as we use the default for the original tutorial that is available open source. Our [repository](https://github.com/CatarinaGamboa/liquidhaskell-short-tutorial) contains the changes made.
3. To test the exercises, you can go to the [website](https://catarinagamboa.github.io/liquidhaskell-short-tutorial/Tutorial_01_Introduction.html) and complete the exercises - there are answers available after each exercise.
4. Compare these exercises with the section of *New Users - Tutorial and Observation* of *3.1. Study Design*. The result section also mention these exercises.


### 2. Analysis of the Results (Connection to Paper Section 4 - RESULTS)

**Objective:** Understand how the thematic analysis codebook directly supports and validates the results presented in Section 4 of the paper, demonstrating the methodological rigor behind the findings.

#### Instructions:
1. Navigate to `[study_results/Codebook.xlsx]`, where you can find the codebook of the thematic analysis.
2. See that the codebook includes the codes from analysis with explanations for each code, and an example from a participant quote or a description of what happened during the observation.
3. Compare these codes with the categories of section *4. Results*.


### Summary of Connections to Paper

| Artifact Component | Paper Section | Key Aspects to Observe |
|-------------------|---------------|----------------------|
| Recruitment documents | Section 3.2 | The artifact presents the documents to recruit more participants to replicate the study |
| Protocols and Interview Guides| Section 3.1 | The artifact can be used to recreate the studies presented in the paper |
| Tutorial | Section 3.1 | The tutorial in the artifact can be used to introduce and test other participants using LiquidHaskell |
| Codebook | Section 4 | The codes used in the codebook represent the results that are described in the paper with similar examples to the ones in the paper. |

### Observations
Note that we are not sharing videos or anonymized transcripts for confidentiality and to protect the identity of our participants, according to data protection regulations.

By following these step-by-step instructions, you will gain a comprehensive understanding of how our artifacts support the methodology and findings presented in our paper. To replicate this study, researchers can similar documents to recruit participants, conduct the interviews, and analyze their results.
