class PriorityQueue:
    def __init__(self, priority_dictionary: dict):
        self.d = priority_dictionary
        # TODO: implement queue as (binary) tree, then insert/update may be faster
        self.queue = list(self.d.keys())
        self.queue.sort(key=self.d.get, reverse=True)

    def get_max(self):
        max_key = self.queue[0]
        return max_key, self.d[max_key]

    def update_value(self, key, priority):
        self.d[key] = priority
        self.queue.remove(key)
        if self.queue:
            idx = 0
            for k in self.queue:
                if self.d[k] < priority:
                    break
                idx += 1
            self.queue.insert(idx, key)
        else:
            self.queue.append(key)
