import subprocess
import os
import sys

num_repetitions = int(sys.argv[1]) if len(sys.argv) > 1 else 10

mdp_environments_property_smc_ablation = [
    (
        "consensus-2-2",
        "models/PRISM/consensus.2-2.prism",
        ["--property", "disagree", "--epsilon", "0.3"],
    ),
    (
        "csma-2-2",
        "models/PRISM/csma.2-2.prism",
        ["--property", "all_before_max", "--epsilon", "0.1"],
    ),
    (
        "firewire_dl-3-200",
        "models/PRISM/firewire_dl.3-200.prism",
        ["--property", "deadline", "--minimization", "--epsilon", "0.05"],
    ),
    (
        "pacman-5",
        "models/PRISM/pacman.5.prism",
        ["--property", "crash", "--minimization", "--epsilon", "0.1"],
    ),
    (
        "wlan-2",
        "models/PRISM/wlan.2.prism",
        ["--property", "collisions_max", "--epsilon", "0.7"],
    ),
    (
        "wlan_dl-0",
        "models/PRISM/wlan_dl.0.prism",
        ["--property", "deadline", "--minimization", "--epsilon", "0.9"],
    ),
    (
        "zeroconf-20-2-true",
        "models/PRISM/zeroconf.20-2-true.prism",
        ["--property", "correct_max", "--epsilon", "0.05"],
    ),
    (
        "zeroconf_dl-1000-1-true-10",
        "models/PRISM/zeroconf_dl.1000-1-true-10.prism",
        ["--property", "deadline_max", "--epsilon", "0.05"],
    ),
]

for env_name, env_path, env_conf in mdp_environments_property_smc_ablation:
    print("learning", env_name)
    for i in range(1, num_repetitions + 1):
        if not os.path.exists("logs/logs/ablation/" + env_name):
            os.makedirs("logs/logs/ablation/" + env_name)
        logfile = env_name + "/" + env_name + "_" + str(i) + ".dat"
        subprocess.run(
            [
                "python3",
                "learn.py",
                "MDP",
                "--mdpfile",
                env_path,
                *env_conf,
                "--logfile",
                logfile,
                "--full",
            ]
        )
    print()
