import os
from strategies.utils.UTMDP import DeltaDistribution, ConfidenceMethod

# Define the delta distribution and confidence methods
delta_methods = [method.name for method in DeltaDistribution]
delta_methods.remove("MINIMIZE_INTERVAL_SUM")
confidence_methods = [method.name for method in ConfidenceMethod]
confidence_methods.remove("WILSON_CORRECTED")

# Define lists of colors and styles
colors = ["blue", "red", "green!60!darkgray", "orange", "purple"]
styles = ["solid", "dashed", "dotted", "dashdotted"]

# Create dictionaries from lists
color_dict = {method: colors[i] for i, method in enumerate(delta_methods)}
style_dict = {method: styles[i] for i, method in enumerate(confidence_methods)}

# List of environments
environments = [
    "Bandit",
    "Bandit25-75",
    "BanditGauss",
    "BettingFav",
    "BettingUnfav",
    "Gridworld",
    "RacetrackTiny",
    "consensus",
    "pacman",
    "SnL20",
    "SnL100",
]

# Loop through each environment
for env in environments:
    # Create LaTeX file
    latex_file_name = f"logs/plots/{env}_plots.tex"
    with open(latex_file_name, "w") as latex_file:
        # First TikZpicture environment for "epsilon" plot
        latex_file.write("\\begin{tikzpicture}\n")
        latex_file.write("\\begin{axis}[\n")
        latex_file.write("    xlabel={Episode},\n")
        latex_file.write("    ylabel={Epsilon},\n")
        latex_file.write("    legend style={at={(0.5,-0.2)},anchor=north}\n")
        latex_file.write("]\n")

        # Loop through each delta distribution method
        for delta_method in delta_methods:
            # Loop through each confidence method
            for confidence_method in confidence_methods:
                # Create file name
                file_name = f"{env}_{delta_method}_{confidence_method}.dat"

                # Check if the data file exists
                if not os.path.exists("logs/logs/" + file_name):
                    print("Could not find file ", "logs/logs/" + file_name)
                    continue

                with open("logs/logs/" + file_name, "r") as data_file:
                    header = data_file.readline()
                    header = [title.strip() for title in header.split()]
                    episode_index = header.index("episode")
                    epsilon_index = header.index("epsilon")
                    data_lines = data_file.readlines()
                    data_lines = [
                        line.strip().split()
                        for line in data_lines
                        if line.strip() != ""
                    ]

                # Add plot with "epsilon" on the y-axis
                latex_file.write(
                    f"\\addplot[color={color_dict[delta_method]}, mark=none, style={style_dict[confidence_method]}] coordinates {{{' '.join(f'{float(dl[episode_index]), float(dl[epsilon_index])}' for dl in data_lines)}}};\n"
                )
                latex_file.write(
                    f"\\addlegendentry{{{delta_method.replace('_', '-')} - {confidence_method.replace('_', '-')}}}\n"
                )

        # End first TikZpicture environment
        latex_file.write("\\end{axis}\n")
        latex_file.write("\\end{tikzpicture}\n")

        latex_file.write("\\\\ \n")

        # Second TikZpicture environment for "upper" and "lower" plots
        latex_file.write("\\begin{tikzpicture}\n")
        latex_file.write("\\begin{axis}[\n")
        latex_file.write("    xlabel={Episode},\n")
        latex_file.write("    ylabel={Upper/Lower},\n")
        latex_file.write("    legend style={at={(0.5,-0.2)},anchor=north}\n")
        latex_file.write("]\n")

        # Loop through each delta distribution method
        for delta_method in delta_methods:
            # Loop through each confidence method
            for confidence_method in confidence_methods:
                # Create file name
                file_name = f"{env}_{delta_method}_{confidence_method}.dat"

                # Check if the data file exists
                if not os.path.exists("logs/logs/" + file_name):
                    print("Could not find file ", "logs/logs/" + file_name)
                    continue

                with open("logs/logs/" + file_name, "r") as data_file:
                    header = data_file.readline()
                    header = [title.strip() for title in header.split()]
                    episode_index = header.index("episode")
                    upper_index = header.index("upper")
                    c_lower_index = header.index("c_lower")
                    data_lines = data_file.readlines()
                    data_lines = [
                        line.strip().split()
                        for line in data_lines
                        if line.strip() != ""
                    ]

                # Add plot with "epsilon" on the y-axis
                latex_file.write(
                    f"\\addplot[color={color_dict[delta_method]}, mark=none, style={style_dict[confidence_method]}] coordinates {{{' '.join(f'{float(dl[episode_index]), float(dl[upper_index])}' for dl in data_lines)}}};\n"
                )
                latex_file.write(
                    f"\\addplot[color={color_dict[delta_method]}, mark=none, style={style_dict[confidence_method]}, forget plot] coordinates {{{' '.join(f'{float(dl[episode_index]), float(dl[c_lower_index])}' for dl in data_lines)}}};\n"
                )
                latex_file.write(
                    f"\\addlegendentry{{{delta_method.replace('_', '-')} - {confidence_method.replace('_', '-')}}}\n"
                )

        # End second TikZpicture environment
        latex_file.write("\\end{axis}\n")
        latex_file.write("\\end{tikzpicture}\n")

        latex_file.write("\\\\ \n")

        # Third TikZpicture environment for "time" plots
        latex_file.write("\\begin{tikzpicture}\n")
        latex_file.write("\\begin{axis}[\n")
        latex_file.write("    xlabel={Episode},\n")
        latex_file.write("    ylabel={Time},\n")
        latex_file.write("    legend style={at={(0.5,-0.2)},anchor=north}\n")
        latex_file.write("]\n")

        # Loop through each delta distribution method
        for delta_method in delta_methods:
            # Loop through each confidence method
            for confidence_method in confidence_methods:
                # Create file name
                file_name = f"{env}_{delta_method}_{confidence_method}.dat"

                # Check if the data file exists
                if not os.path.exists("logs/logs/" + file_name):
                    print("Could not find file ", "logs/logs/" + file_name)
                    continue

                with open("logs/logs/" + file_name, "r") as data_file:
                    header = data_file.readline()
                    header = [title.strip() for title in header.split()]
                    episode_index = header.index("episode")
                    time_index = header.index("time")
                    data_lines = data_file.readlines()
                    data_lines = [
                        line.strip().split()
                        for line in data_lines
                        if line.strip() != ""
                    ]

                # Add plot with "epsilon" on the y-axis
                latex_file.write(
                    f"\\addplot[color={color_dict[delta_method]}, mark=none, style={style_dict[confidence_method]}] coordinates {{{' '.join(f'{float(dl[episode_index]), float(dl[time_index])}' for dl in data_lines)}}};\n"
                )
                latex_file.write(
                    f"\\addlegendentry{{{delta_method.replace('_', '-')} - {confidence_method.replace('_', '-')}}}\n"
                )

        # End second TikZpicture environment
        latex_file.write("\\end{axis}\n")
        latex_file.write("\\end{tikzpicture}\n")

# Create a master LaTeX file
master_latex_file_name = "logs/master_plots.tex"
with open(master_latex_file_name, "w") as master_latex_file:
    master_latex_file.write("\\documentclass{scrartcl}\n")
    master_latex_file.write("\\usepackage{tikz}\n")
    master_latex_file.write("\\usepackage{pgfplots}\n")
    master_latex_file.write("\\pgfplotsset{compat=1.17}\n")
    master_latex_file.write("\\begin{document}\n")

    # Include individual LaTeX files for each environment
    for env in environments:
        master_latex_file.write(f"\\section{{{env}}}\n")
        master_latex_file.write(f"\\input{{plots/{env}_plots}}\n")
        master_latex_file.write("\\\\ \n")

    master_latex_file.write("\\end{document}\n")


print("LaTeX files generated successfully.")
