import matplotlib.pyplot as plt
import numpy as np
import os
from scipy.optimize import curve_fit


# Specify the directory containing your data files
data_directory = '.'


def func(x, a, b, c):
    return a / (x+b)**c


# Iterate over all files in the directory
for filename in os.listdir(data_directory):
    if filename.endswith('.dat'):
        # Construct the full path to the data file
        data_file_path = os.path.join(data_directory, filename)
        # Read data from file
        data = np.loadtxt(data_file_path)

        # Extract x, y, and color values from the data
        x_values = data[:, 0]
        y_values = data[:, 2]
        color_values = data[:, 1]

        # Map the color values to a colormap (red to blue)
        cmap = plt.cm.get_cmap('cool')
        colors = cmap(color_values)

        # Create a scatter plot
        plt.scatter(x_values, y_values, c=colors, marker='o')

        # Add colorbar to show the mapping of values to colors
        sm = plt.cm.ScalarMappable(cmap=cmap)
        cbar = plt.colorbar(sm)
        cbar.set_label('Sampling rate')

        # Set axis labels
        plt.xlabel('Number of samples')
        plt.ylabel('Delta')

        popt, pcov = curve_fit(func, x_values, y_values, p0=(1, 500, 1.1), bounds=(0, np.inf), maxfev=5000)
        print(filename)
        print("best fit for delta = a / (x+b)**c is (a, b, c) =", popt)
        x_values.sort()
        yHYP = func(x_values, *popt)
        plt.plot(x_values, yHYP)

        # Set plot title
        plt.title(filename)

        # Show the plot
        plt.show()
