import os
import csv


def read_data(file_path):
    """Reads data from a .dat file and returns the first and third columns."""
    first_col = []
    fourth_col = []

    try:
        with open(file_path, 'r') as file:
            reader = csv.reader(file, delimiter=',')
            for i, row in enumerate(reader):  # Skip heading
                if i == 0:
                    continue
                if len(row) >= 4:  # Ensure there are at least four columns
                    first_col.append(row[0])  # First column
                    try:
                        fourth_col.append(float(row[3]))  # Fourth column (convert to float)
                    except ValueError:
                        print(f"Warning: Invalid number in {file_path}: {row[3]}")
    except Exception as e:
        print(f"Error reading {file_path}: {e}")

    return first_col, fourth_col


def geometric_mean_of_data(columns):
    """Calculates the average of the third column data."""
    minimums = []
    averages = []
    maximums = []
    for i in range(len(columns[0])):
        minimums.append(min(r[i] for r in columns))
        prod = 1
        for r in columns:
            prod *= r[i]
        averages.append(prod ** (1 / len(columns)))
        maximums.append(max(r[i] for r in columns))
    return minimums, averages, maximums


if __name__ == "__main__":
    first_col = []
    all_fourth_cols = []

    first_line = None

    for filename in os.listdir("."):
        if filename.endswith('.dat') and filename != 'average.dat':
            file_path = os.path.join(".", filename)
            first_col, fourth_col = read_data(file_path)
            all_fourth_cols.append(fourth_col)

    # Calculate average of the third column
    mins, avgs, maxs = geometric_mean_of_data(all_fourth_cols)

    # Write results to average.dat
    with open('average.dat', 'w', newline='') as output_file:
        writer = csv.writer(output_file, delimiter=',')
        for i, impr in enumerate(first_col):
            writer.writerow([impr, mins[i], avgs[i], maxs[i]])
