var documenterSearchIndex = {"docs":
[{"location":"#FAIR*Implementation*ABM","page":"Home","title":"FAIRImplementationABM","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Welcome to the documentation for the FAIR_Implementation_ABM, a Julia-based agent-based model designed to simulate protein aggregation dynamics under intracellular-like conditions.","category":"page"},{"location":"","page":"Home","title":"Home","text":"This model investigates how different environmental and molecular parameters — such as macromolecular crowding and conformational changes — influence the transition from native monomers to pathological amyloid structures.","category":"page"},{"location":"#Key-Features","page":"Home","title":"Key Features","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Supports pathological aggregation scenarios\nIncludes states:  \nN: Native monomer  \nA: Amyloid monomer  \nO: Oligomer  \nF: Fibril  \nIntegrates probabilistic reactions, movement logic, and crowding effects\nBuilt with an emphasis on FAIR (Findable, Accessible, Interoperable, Reusable) model design","category":"page"},{"location":"#API-Reference","page":"Home","title":"API Reference","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"```@autodocs Modules = [FAIRImplementationABM]","category":"page"},{"location":"#Model-Parameters","page":"Home","title":"Model Parameters","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"This section summarizes the main parameters used to control your agent-based model of protein aggregation.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Parameter Description Example Value\nLattice_Size Size of the 3D FCC lattice 30\nMAX_NumberMovements Number of time steps 1000\nMax_NumberMonomers_Native Initial count of native monomers (N) 50\nMax_NumberMonomers_Amyloid Initial count of amyloid-prone monomers (A) 20\nNative_to_Amyloid Probability for N → A transition per timestep 0.1\nAmyloid_to_Native Probability for A → N transition per timestep 0.05\nOligomer_Formation Probability of A + A → O 0.5\nOligomer_Dissociation_rate Probability of O → A + A 0.1\nFibril_Formation Probability of O + A → F 0.8\nFibril_Growth Probability of F + A → F(n) (elongation) 0.9\nCrowder_Concentration_Spheres Volume fraction of crowders in lattice 0.4\nObstacle_Radius Radius of each spherical crowder 1","category":"page"},{"location":"","page":"Home","title":"Home","text":"","category":"page"},{"location":"#Reaction-Mechanisms","page":"Home","title":"Reaction Mechanisms","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"This model captures a simplified kinetic representation of protein aggregation pathways, driven by stochastic rules encoded in the agent-based framework.","category":"page"},{"location":"#1.-Conformational-Change","page":"Home","title":"1. Conformational Change","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Reaction: N ⇌ A   Native monomers can spontaneously convert into amyloid-prone conformations and vice versa, controlled by the probabilities Native_to_Amyloid and Amyloid_to_Native.","category":"page"},{"location":"#2.-Oligomerization","page":"Home","title":"2. Oligomerization","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Reaction: A + A ⇌ O   Two amyloid monomers can associate to form a small oligomer. Oligomers can also dissociate into monomers.","category":"page"},{"location":"#3.-Fibril-Nucleation","page":"Home","title":"3. Fibril Nucleation","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Reaction: O + A → F   Oligomers can convert into fibrils when interacting with an additional amyloid monomer, initiating fibril formation.","category":"page"},{"location":"#4.-Fibril-Elongation","page":"Home","title":"4. Fibril Elongation","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Reaction: F + A → F(n)   Fibrils grow through sequential addition of amyloid monomers, representing elongation.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Each of these reactions is probabilistic and depends on local lattice arrangement and spatial proximity of monomers.","category":"page"}]
}
