# Data Dictionary for Protein Aggregation Simulation Output

This document describes the columns present in the output data files generated by the protein aggregation simulation.

## 1. `Simulation_Results.csv`

This file contains the counts of oligomers and aggregates at each timestep of the simulation.

* **File Description:** `Simulation_Results.csv`
* **Data Type:** Comma-Separated Values (CSV)
* **Columns:**

    * `Timestep`
        * **Description:** The simulation timestep. This represents a discrete point in time within the simulation.
        * **Data Type:** Integer
        * **Units:** Timesteps (dimensionless)
        * **Example:** 1, 100, 5000

    * `Oligomers`
        * **Description:** The number of oligomers present in the simulation lattice at the given timestep. Oligomers are defined as aggregates of monomers in state 3.
        * **Data Type:** Integer
        * **Units:** Number of oligomers
        * **Example:** 0, 25, 120

    * `Aggregates`
        * **Description:** The number of larger aggregates (fibrils) present in the simulation lattice at the given timestep. Aggregates are defined as aggregates of monomers in state 4.
        * **Data Type:** Integer
        * **Units:** Number of aggregates
        * **Example:** 0, 5, 40

## 2. `Native_and_Amyloid_Count_Results.csv`

This file contains the counts of native and amyloid monomers at each timestep.

* **File Description:** `Native_and_Amyloid_Count_Results.csv`
* **Data Type:** Comma-Separated Values (CSV)
* **Columns:**

    * `Timestep`
        * **Description:** The simulation timestep.
        * **Data Type:** Integer
        * **Units:** Timesteps (dimensionless)
        * **Example:** 1, 100, 5000

    * `Native`
        * **Description:** The number of monomers in the native state (state 1) at the given timestep.
        * **Data Type:** Integer
        * **Units:** Number of monomers
        * **Example:** 450, 300, 100

    * `Amyloid`
        * **Description:** The number of monomers in the amyloid-prone state (state 2) at the given timestep.
        * **Data Type:** Integer
        * **Units:** Number of monomers
        * **Example:** 50, 200, 400

## 3. `MSD_Data.csv`

This file contains the Mean Squared Displacement (MSD) data for monomers and aggregates.

* **File Description:** `MSD_Data.csv`
* **Data Type:** Comma-Separated Values (CSV)
* **Columns:**

    * `Timestep`
        * **Description:** The simulation timestep.
        * **Data Type:** Integer
        * **Units:** Timesteps (dimensionless)
        * **Example:** 1, 100, 5000

    * `MSD_Monomer`
        * **Description:** The Mean Squared Displacement of individual monomers at the given timestep. This measures the average distance monomers have moved over time.
        * **Data Type:** Float64
        * **Units:** Lattice units squared
        * **Example:** 1.25, 5.78, 22.10

    * `MSD_Aggregate`
        * **Description:** The Mean Squared Displacement of aggregates (oligomers and fibrils) at the given timestep. This measures the average distance aggregates have moved over time.
        * **Data Type:** Float64
        * **Units:** Lattice units squared
        * **Example:** 0.50, 2.34, 10.55

## 4. `Fibril_Length_Count_Results.csv`

This file contains the counts of fibrils of different lengths over time.

* **File Description:** `Fibril_Length_Count_Results.csv`
* **Data Type:** Comma-Separated Values (CSV)
* **Columns:**

    * `Timesteps`
        * **Description:** The simulation timestep.
        * **Data Type:** Integer
        * **Units:** Timesteps (dimensionless)
        * **Example:** 1, 100, 5000

    * `1`, `2`, `3`, ..., `N` (where `N` is `max_fibril_size`)
        * **Description:** Columns representing the count of fibrils of each length. For example, column `5` contains the number of fibrils with a length of 5 monomers.
        * **Data Type:** Integer
        * **Units:** Number of fibrils
        * **Example:** 0, 10, 5 (for a given length)
