import os
import tkinter as tk
from tkinter import filedialog

def select_folder():
    root = tk.Tk()
    root.withdraw()  # Hide the main window
    folder_selected = filedialog.askdirectory()
    return folder_selected

def process_files(folder_path):
    for filename in os.listdir(folder_path):
        if filename.endswith("-exp.txt"):
            file_path = os.path.join(folder_path, filename)
            with open(file_path, 'r', encoding='utf-8') as f:
                content = f.read()
            
            # Replace dots with commas
            content = content.replace('.', ',')
            
            # Write the modified content back to the file
            with open(file_path, 'w', encoding='utf-8') as f:
                f.write(content)

if __name__ == "__main__":
    folder_path = select_folder()
    if folder_path:
        process_files(folder_path)
        print(f"Processed files in folder: {folder_path}")
    else:
        print("No folder selected.")
