import os
import tkinter as tk
from tkinter import filedialog
from script_c_extract import extract_c  # Assuming the file is named script_c_extract.py
from script_s_extract import extract_s  # Assuming the file is named script_s_extract.py

# Initialize Tkinter root window
root = tk.Tk()
root.withdraw()

# Open directory dialog
directory = filedialog.askdirectory(title="Select the directory containing the text files")

# Check if a directory was selected
if not directory:
    print("No directory selected. Exiting.")
    exit()

# Iterate through all files in the directory
for filename in os.listdir(directory):
    if filename.endswith(".txt"):
        # Skip output files to avoid an endless loop
        if filename.endswith(".s-exp.txt") or filename.endswith(".c-exp.txt"):
            continue

        # Full path to the file
        full_path = os.path.join(directory, filename)

        # Run both scripts if filename starts with "P-"
        if filename.startswith("P-"):
            extract_c(full_path, os.path.join(directory, filename.replace(".txt", ".c-exp.txt")))
            extract_s(full_path, os.path.join(directory, filename.replace(".txt", ".s-exp.txt")))
        else:
            # Otherwise, run only s-extract.py
            extract_s(full_path, os.path.join(directory, filename.replace(".txt", ".s-exp.txt")))

print("Processing complete.")
