This readme file was generated on 2023-10-27 by Dr Oliver Maor  

GENERAL INFORMATION
===================

Title of Data Package
---------------------
Persons Admitted to Swinger Events in Germany: Anonymous Data Harvested on the Web

Author/Principal Investigator Information  
Name: Dr Oliver Maor  
ORCID: 0009-0000-9759-2038 
Institution: FernUniversität in Hagen; Independent  
Email: oliver@maor.de

Date of Data Collection
-----------------------
2023-09-07 to 2023-10-15 

Geographic Location of Data Collection
--------------------------------------
Germany  

Information About Funding Sources That Supported the Collection of the Data
---------------------------------------------------------------------------
N/A  


SHARING/ACCESS INFORMATION
==========================

Licenses/Restrictions Placed on the Data
----------------------------------------
Data and text contained in this container are marked with CC0 1.0 Universal. To view a copy of this license, visit  
http://creativecommons.org/publicdomain/zero/1.0

Links to Publications That Cite or Use the Data
-----------------------------------------------
Preprint: https://doi.org/10.31235/osf.io/u24tz and later versions  

Links to Other Publicly Accessible Locations of the Data
--------------------------------------------------------
N/A

Links/Relationships to Ancillary Data Sets
------------------------------------------
Restricted datasets in a separate data package, only accessible for for the purpose of monitoring the quality of the scientific research.  
Reason for the restriction: Sui generis database rights under the laws of the European Union.  
For further details, refer to the file `LegalAndEthicalStatement.md`.  
The content of the separate data package is described herein, because it would otherwise not be possible to fully describe and comprehend the methods used for creating the files contained herein.

### Brief Description of the Corpus Files That Data in This Data Package Were Partly Calculated From ###
The corpus is not provided in this data package for legal reasons, see `LegalAndEthicalStatement.md` for details.
However, for explaining the steps of calculation of the aggregated data, the content of the corpus and its variables have to be explained.

The corpus consists of two datasets,
* `AdmissionsData restricted`, provided as `*.xmlx` and `*.sav` files in the respective formats, and  
* `SameGenderOrientedInJC`.

In the first dataset mentioned, each case (row) in these datasets represents a single profile in Joyclub, either of a woman, of a man, of a couple, or an accompanied solo (see below for the definition of *accompanied solo*).

These dataset contains the following variables which are not contained in the file containing aggregated data:

* AGEF: The age of the woman in the case. If no woman is involved, the value is missing.  
* AGEM: The age of the man in the case. If no man is involved, the value is missing. 
* AGEACC: The age of an accompanied solo in the case - If the case does not relate to an accompanied solo, the value is missing.
* COUPLE: 0 = Solo woman; 1 = Couple; 2 = Solo male; 3 = Accompanied solo.
* NUM_VISITORS: Number of visitors in the case.  
* AGEDIFF: The age difference in couple (positive means man is older, no data if not a couple).
* AGEGROUP_F: The age group woman (missing if no woman is in the case).
* AGEGROUP_M: The age group woman (missing if no woman is in the case).
* DIST: The distance between residence and event venue (no value means data not available).
* IFFAR: A boolean value if DIST is higher than 100 km.
* IFFAR_persons The number of persons in the case if DIST is higher than 100 km.
* IFCOUPLE: A boolean value expressing whether the case relates to a couple.
* IFSOLOF: A boolean value expressing whether the case relates to a solo woman.
* IFSOLOM: A boolean value expressing whether the case relates to a solo man.  
* IFACC: A boolean value expressing whether the case relates to an accompanied solo.

The dataset `SameGenderOrientedInJC` contains age data of persons (in whole Germany) who meet the selection criteria mentioned therein and who have stated 'homosexual', a possible selection in the Joyclub profile metadata, as the sole sexual orientation. The data contained in this dataset form the raw data of the results contained in the file `calc_CalculationSame-gender.md`.
 
Was Data Derived From Another Source?
-------------------------------------
Yes.

### Visitor-related data in the files AdmissionsData aggregated.xlsx and AdmissionsData aggregated.sav ###
Source data were retrieved from the webpages listed in the table `References` of the file `data_EventDataRaw.xlsx` and in the References section of the file `data_EventsAndClassification.pdf`.

### Event-related metadata in the files calc_AdmissionPricesEvents, data_EventDataRaw.xlsx, data_AdmissionsDataAggregated.xlsx, and data_AdmissionsDataAggregated.sav ###  

The data contained in the variables

* Screennameofvenue,  
* Screennameofdifferentorganizer,  
* Municipalitystate,  *(remark: the state code was added using general geographic knowledge, or an internet search)*  
* Verbaldescriptionofrestrictions,  
* Entrancefemale,  
* EntrancefemaleJoyclubpremium,  
* Entrancemale,  
* EntrancemaleJoyclubpremium,  
* Entrancecouple,  
* EntrancecoupleJoyclubpremium,  
* Codeforgenderrestriction,  
* Agerestrictionsingleperson, and  
* Agerestrictioncouplesumofages  

were generated from the event descriptions contained in the webpages listed in the table `References` of the file `data_EventDataRaw.xlsx` and in the References section of the file `data_EventsAndClassification.pdf`.

The data contained in the variables  
* Citationreference  
were generated based on the 7th edition of the Publication Manual of the American Psychological Association (APA, 2020), and reflects the webpages used as sources for the collected event data,  
* Eventclass  
were manually generated by an assessment of the respective event description, based on the criteria set out in the file `data_EventsAndClassification.pdf`.

Recommended Citation For This Data Package
------------------------------------------
*Will be provided*

DATA & FILE OVERVIEW
====================

File List
---------
* `calc_AdmissionPricesEvents`: Calculation of the average admission prices per solo woman, solo man, and couple, to the events, with and without factoring in Joyclub Premium discounts.
* `calc_CalculationSame-gender.md`: Method and results of a calculation of exclusively same-gender oriented profile owners on Joyclub in markdown format.  
* `data_AdmissionsDataAggregated.sav`: Data related to admitted persons to 76 swinger events in Germany on three weekends in September and October 2023, the events form a subset of the events in `data_EventDataRaw.xlsx`, in SPSS format.  
* `data_AdmissionsDataAggregated.xlsx`: The same data as in `data_AdmissionsDataAggregated.sav` in Excel format.  
* `data_EventDataRaw.xlsx`: Data related to 88 swinger events in Germany on three weekends in September and October 2023, setting out date, location, arrangement, admission restrictions, the prices for entrance, and the classification of each event based on its respective arrangement, in Excel format.  
* `data_EventsAndClassification.pdf`: The content of the file `EventDataRaw.xlsx` in a more human-readable format as a PDF file (PDF/A; PDF version 1.7).  
* `DataManagementPlan.pdf`: A data management plan related to this data package and the ancillary restricted data package.  
* Six files `script*.py`: Python 3.9 scripts which had been used to convert raw data harvested from Joyclub into a structured corpus. The script files and their functions are described in the file `script_readme.md`.
* `LegalAndEthicalStatement.md`: Legal and ethical considerations concerning the creation of this data package.  
* `readme.md`: The general readme file for this data package in markdown format (this file).  
* `script_testdata.zip`: Test files for testing the operation of the scripts, organized in a ZIP file.  

Are There Multiple Versions of the Data package?
------------------------------------------------
No.

METHODOLOGICAL INFORMATION
==========================

Description of Methods Used for Collection/Generation of Data
-------------------------------------------------------------

### Preliminary Remark on the Emphasis of Heterosexuality and on Genders ###
In the data and the calculations, heterosexual or bisexual couples have been considered. This is not an expression of heteronormative bias, but rather reflects the fact that Joyclub, and the events announced therein, appeal to a heterosexual and bisexual audience. This could be proven by use of the method reflected in the file `calc_CalculationSame-gender.md`. As a result, it can be shown that only 0.21% of the Joyclub members are exclusively same-gender oriented. Ignoring this portion of exclusively same-gender oriented profile owners leaves the research caluclations within the applied condidence interval of 95%.

The facts shown in the previos paragraph do not imply any discrimination of same-gender oriented individuals originating from Joyclub, which allows profiles to be marked accordingly, in the same way as 'diverse', or with labels like 'transsexual'.

The terms 'male' and 'female' relate to the self-declared social genders in Joyclub profiles. Joyclub also offers the gender choice 'diverse'. According profiles have not been considered.

### Preliminary Remark on the Use of the Term "solo" ###
Persons maintaining a Joyclub member profile as a man or a woman, but not as a couple, are termed "solo" herein. The alternative term "single" could lead to a confusion with the relationship status of the respective persons. However, the sort of a Joyclub profile as a man, a woman, or a couple, does not reflect that status. In contrast, members are free, and not obligated, to set out their relationship status in the profile itself. Because the privacy-friendly design of this survey did not involve an analysis of the profiles themselves, but only of the raw data reflected on results pages, the profile type, and not the relationship status, was assessed. A "solo" profile therefore is meant to be a profile of a man or a woman, regardless of the relationship status of the person.

### Preliminary Explanation of Joyclub Profiles and Relevant Functions ###
* Ordinary Profiles  
	* Profiles on the website Joyclub (www.joyclub.de) can be created by everyone, without requiring any invitation or admission, and free of charge.  
	* For users from the general group, there are profiles for men, for women, for persons with the gender 'diverse', and for couples.  
	* Based on a sliding scale, free or paid upgrades of membership status are possible.  
	* In a profile, which does not have to contain the plain name, pictures can be posted, sexual preferences named. Comprehensive texts may be integrated, also as so-called homepages on a larger scale. Functions such as an e-mail function, the possibility to connect with friends similar to other social media platforms, a forum, interest groups with their own sub-forums, a chat and a video streaming option form an edition to the service.  
	* The county or the city of residence is automatically part of the profile.  
	* The platform operates a rigorous policy against fake profiles, which is also referred to expressly on the member search page (Joyclub, n.d.-e). Based on video identification, for which an official identity card or passport is required, the profile is given a corresponding status as verified, which is expressed by a white check mark visible to other users. Alternatively, verification is also possible with recognized partners of the platform, especially clubs and event organizers. Couples who operate a couples profile must be present at the identification by video or with a partner together. The identification data will be deleted after a retention period. If at least five other verified members mark a verified profile as personally known, the color of the checkmark changes to green (Joyclub, n.d.-b).  
	* A member search enables filtering based on criteria.

* Profiles of Event organizers and Other Professional Profiles
	* For companies such as event organizers, clubs and pubs, Joyclub enables the creation of special profile types that require appropriate proof, such as proof of activity, a business registration or an extract from the commercial register. Companies must provide an imprint with, among other things, a street address and the plain names of the managing directors. Private and business interests are to be pursued with two different profiles (Joyclub, n.d.-f).
	* By default, professional profiles, as well as verified couple and women profiles, are managed as so-called "plus membership", with which most functions can be used.  

* Built-In Event Management System  
	* Organizers of events have access to a free comprehensive event management system. Among other things, the system enables them to promote events, view member registrations, and either approve or reject them, monitor prepayments for events, view statistics, and track presences. Joyclub does not integrate any payment platform.
	* In addition, organizers of events can embed a privacy-compliant white-label solution into their own website, allowing guests without a Joyclub profile to register. Upon a registration through such a registration template, the registration is then recorded in the Joyclub guest management system, while the guests do not see that the management is done through Joyclub (Joyclub, n.d.-c and Joyclub, n.d.-g).
	* Events are listed preferentially when organizers give Joyclub members with a paid premium profile at least a 10% discount over the usual price (Joyclub, n.d.-d). For event organizers, the platform thus offers the advantage of free advertising and free guest management, including the possibility to preview guests' profile information before activation and to receive statistical information about guests during the registration phase.

* Display of Events and Guest Lists
	* Joyclub profile holders who register to an event only get on the guest list that is displayed on Joyclub with respect to that event that if they are subsequently admitted by the event organizer. The event pages only show guests after they were admitted to the event.
	* The guest lists on Joyclub do not reflect if guests had actually shown up at the event. However, many organizers maintain a strict black list regime regarding persons who were admitted to an event and subsequently do not show up without de-registering. Examples are set out in the descriptions in the files `data_EventsDataRaw.xlsx` and `data_EventsAndClassification.pdf`.
	* Registrations made via the white-label solution provided by Joyclub, as well as registrations added manually by the organizer, are shown on the event listing page with "External" and the number and genders of persons (men, women, couples).
	* Because events are listed higher in the Joyclub event listing the more visitors they have (this is not the only criterion), there is an incentive for organizers to include external registrations.
	* Another incentive for including external registrations into the guest list is that this enables organizers to use of the free statistics functions. These functions allow organizers to decide, for example, how many participants of which gender they still allow.
	* Some organizers require registration via Joyclub from the outset in order to participate in events, so that they can decide on the basis of the profile whether to admit the interested person. Examples are set out in the descriptions in the files `data_EventsDataRaw.xlsx` and `data_EventsAndClassification.pdf`.

* Accompanied Solos
	* When registering to an event in Joyclub, also owners of single profiles can indicate that they appear as a couple. In this case, they were listed under the category "couples" on the event pages. Thus, due to the data protection compliant survey design, it could not be determined whether the person registering was male or female. An additional gender category "accompanied solo" was therefore used for this group of visitors.

* No Paid Advertising  
	* Advertising on Joyclub is allowed only in the forms specified by the operators of Joyclub, and never paid. Joyclub does not contain advertising banners. For example, organizers can enter events in the events calendar free of charge and thus advertise them. Joyclub does not collect money from advertisers for such permitted forms of advertising, and does not accept payments for any entries in listings. The sending of individual messages, so-called club mails, as advertising to customers is considered spam and thus not permitted. Instead, on their own accord, customers can join so-called groups that are created by companies and in this way receive messages from the respective company. Advertising for third parties, such as through agencies, is not permitted (Joyclub, n.d.-a).
	* Therefore, the retrieval of data could not have been biased by any effects of disclosed or undisclosed advertising.

### Selection of the Events for the Retrieval of Event Data ###
Visits to a total of 82 swingers' events on three Saturdays (2023-09-16, 2023-09-23, and 2023-10-05) in Germany were examined by harvesting the data in the Joyclub portal.

To ensure that no insignificant events or events that were not at least also geared towards swingers were recorded, the events were only selected if  
* open sex was permitted during the event,  
* at least 95 guests were registered, and  
* the venue or the organizer was quality-checked or otherwise recommended by the Joyclub platform.  
For the events in September, moreover, with at least four out of five "hearts", which are awarded according to guest satisfaction and facilities). 

The events and source pages are listed in the file `data_EventDataRaw.xlsx`. For transparency reasons, also events that data were first collected from, and which were later not included in the datasets because they did not fulfill the selection criteria, are included into that list.

### Collection of the Event Data ###
After the end of the respective event, the profile data of the profiles identified as admitted visitors in Joyclub were recorded separately for registered couples, individual men and individual women, as they are split up on the events pages on Joyclub. These raw data were anonymized and structured using the scripts in the `script_*.py` files, as described in the file `script_readme.md`. By means of automated geocoding, the information on the county of residence of persons was directly converted into a distance information, whereby for technical reasons incorrect calculations, which occurred during the geocoding of the towns of Hattingen and Marl, were eliminated without replacement.

By that, the age or, in case of couples, the ages, the distance between the event venue and the place of residence recorded in the respective Joyclub profile, and the status as solo woman, solo man, couple, or accompanied solo, were recorded as cases. 

Anonymous registrations were also recorded. They also provide the data mentioned above.

On the basis of the descriptions contained in the event pages listed in the file `data_EventDataRaw.xlsx`, metadata of the events were collected.

Data on the external admissions, recorded either through the white-label registration solution provided by Joyclub, or manually by the organizers, as explained above, were collected from the raw data using the script in `script_Findexternals.py`, using the method described in the file `script_readme.md`.

### Categorization of the Events ###
The events themselves were categorized based on the self-description in Joyclub, roughly following the typology presented by Venn (2015).
* *Category 0* captures swinger events without special features in the sense of the other categories.
* A special *category 1 ("Food / dance focused events")* was created for events that predominantly promoted dance facilities, a dignified ambience, a dress code with fine or fancy clothing, or exceptionally elaborate food and expensive drinks, thus focusing on exclusivity and a "see and be seen" approach. Mere customary dress codes or seasonal mottos, such as "Farewell to Summer" or "Oktoberfest," on the other hand, did not lead to the creation of a separate category. The background to this is that dancing and a food buffet, as well as drinks with and without alcohol, are among the normal features of swinger events and are usually included in the admission price, so that guests can leave their money in the locker during the events. Corresponding advertising such as the naming of DJs or references to the food available or other declarations of the quality of normal ancillary services was therefore not sufficient. The same applies if food matching a motto was announced, which is no more elaborate to produce than a normal buffet (such as pretzels at the "Oktoberfest").  
* A special *category 2 ("Sex focused events")* was created for events in which sex games were specially organized and moderated.  
* A *category 3* includes two events that combined characteristics of category 1 and category 2.  

### Subsequent Filtering ###
If the number of guests registered externally for an event exceeded 5% of the total number of guests, the boolean variable ISRELIABLE in the identical datasets `data_AdmissionsDataAggregated.xlsx` and `data_AdmissionsDataAggregated.xlsx` was set to `0`, otherwise to `1`.  

In the case of `ISRELIABLE = 1`, the sample of the age data provided by the Joyclub registrations would lie within a 95% confidence interval with regard to this specific event.

If an event fulfilled the filter criteria
* to have at least 95 admitted visitors, and  
* that less than 20% of the admitted visitors were registered externally,  
the boolean variable REPR_EVENT in the identical datasets `data_AdmissionsDataAggregated.xlsx` and `data_AdmissionsDataAggregated.xlsx` was set to `0`, otherwise to `1`.  

The age data available from all Joyclub registrations to the events within this sample would lie within the 95% confidence interval when this filter is applied.

Methods for Processing the Data
-------------------------------
The generation of the corpus (not provided in this data package for legal reasons, see `LegalAndEthicalStatement.md` for details) had been performed using the scripts in `script_*.py` files. See the `script_readme.md` file for details of the processing.

The calculations of the average admission prices take place within the Excel file `calc_AdmissionPricesEvents.xlsx`.

All other calculations had been performed using IBM SPSS, version 29.0.0.1.

From the data contained in the restricted data package, the following variables in the files
	* `data_AdmissionsDataAggregated.xlsx` and
	* `data_AdmissionsDataAggregated.sav`
* were calculated as medians, with the event code as break variable:  
	* AGEF_median from AGEF in the corpus,  
	* AGEM_median from AGEM in the corpus,  
	* AGEACC_median from AGEACC in the corpus, and  
	* MEDAGEDIFF from AGEDIFF in the corpus,  
* were calculated as standard deviations, with the event code as break variable:
	* AGEF_sd from AGEF in the corpus,
	* AGEM_sd from AGEM in the corpus, and
	* AGEACC_sd from AGEACC in the corpus.  
the corpus being reflected in the restricted files `AdmissionsData restricted.sav` and `AdmissionsData restricted.xlsx`.  

The other variables that are based on caluclations were calculated as follows.
* COUPLE: Calculated by the script `script_combine-event-data.py`, as described in the file `script_readme.md` *(variable not in aggregated data)*  
* NUM_VISITORS: Calculated by the script `script_combine-event-data.py`, as described in the file `script_readme.md` *(variable not in aggregated data)*  
* AGEDIFF: `AGEM - AGEF` *(variable not in aggregated data)*  
* AGEGROUP_F: `(AGEF > 34) + (AGEF > 49)` *(variable not in aggregated data)*  
* AGEGROUP_M: `(AGEF > 34) + (AGEF > 41)` *(variable not in aggregated data)*   
* DIST: Calculated by the script `script_c_extract.py` or the script `script_s_extract.py`, respectively, as described in the file `script_readme.md` *(variable not in aggregated data)*   
* IFFAR: `DIST > 100` *(variable not in aggregated data)*  
* IFFAR_persons: IFFAR * `(1 + ((COUPLE = 1) OR (COUPLE = 3)))` *(variable not in aggregated data)*  
* IFCOUPLE: `(COUPLE = 1)` *(variable not in aggregated data)*  
* IFSOLOF: `(COUPLE = 0)` *(variable not in aggregated data)*  
* IFSOLOM: `(COUPLE = 2)` *(variable not in aggregated data)*  
* IFACC: `(COUPLE = 3)` *(variable not in aggregated data)*  
* REPR_EVENT: `((VISITORSTOTAL_inclaccompanier > 94) AND (EXTERN_percent < 20))`  
* ISRELIABLE: `(EXTERN_percent < 5)`    
* EXTERN_percent: `Sumexternal * 100 / VISITORSTOTAL_inclaccompanier`  
* NUM_VISITORS_sum: `SUM(NUM_VISITORS)`, break variable: EVENTNO  
* IFFAR_persons_sum;  `SUM(IFFAR_persons)`, break variable: EVENTNO  
* IFSOLOF_sum: `SUM(IFSOLOF)`; break variable: EVENTNO *(variable IFSOLOF not in aggregated data)*  
* IFSOLOM_sum: `SUM(IFSOLOM)`; break variable: EVENTNO *(variable IFSOLOM not in aggregated data)*   
* IFACC_sum: `SUM(IFACC)`; break variable: EVENTNO *(variable IFACC not in aggregated data)*   
* IFCOUPLE_sum: `SUM(IFCOUPLE)`; break variable: EVENTNO *(variable IFCOUPLE not in aggregated data)*  
* IFCOUPLE_persons: `IFCOUPLE_sum * 2`
* SUMEXTERNAL: `ExternalF + ExternalM + (ExternalC * 2)`  
* SOLOM_visitorstotal: `IFSOLOM_sum + ExternalM`  
* SOLOF_visitorstotal: `IFSOLOF_sum + ExternalF`  
* COUPLE_visitorstotal: `IFCOUPLE_persons + (ExternalC * 2)`  
* MALE_visitorstotal: `IFCOUPLE_sum + ExternalC + IFACC_sum + SOLOM_visitorstotal`   
* FEMALE_visitorstotal: `IFCOUPLE_sum + ExternalC + IFACC_sum + SOLOF_visitorstotal`  
* COUPLEANDACC_visitorstotal: `COUPLE_visitorstotal + (IFACC_sum * 2)`  
* VISITORSTOTAL_inclaccompanier: `MALE_visitorstotal + FEMALE_visitorstotal`    
* FEMALE_ratio: `FEMALE_visitorstotal * 100 / VISITORSTOTAL_inclaccompanier`  
* MALE_ratio: `MALE_visitorstotal * 100 / VISITORSTOTAL_inclaccompanier`  
* COUPLE_ratio: `COUPLEANDACC_visitorstotal * 100 / VISITORSTOTAL_inclaccompanier`    
* SOLOF_ratio: `SOLOF_visitorstotal * 100 / VISITORSTOTAL_inclaccompanier`  
* SOLOM_ratio: `SOLOF_visitorstotal * 100 / VISITORSTOTAL_inclaccompanier` 
* SUMCOUPLES_JOY: `IFACC_sum + IFCOUPLE_sum`  
* SUMCOUPLES: `SUMCOUPLES_JOY + ExternalC`  
* JOY_PRICE_weight_C: `(SUMCOUPLES_JOY * EntrancecoupleJoyclubPremium) + (ExternalC * Entrancecouple)`  
* HIGH_PRICE_weight_C: `SUMCOUPLES * Entrancecouple`  
* Result_MinPrice_C: `sum[JOY_PRICE_weight_C] / sum[SUMCOUPLES]`  
* Result_HighPrice_C: `sum[HIGH_PRICE_weight_C] / sum[SUMCOUPLES]`  
* SUMPERS_JOY_M: `IFSOLOM_sum`  
* SUMPERS_M: `SUMPERS_JOY_M + ExternalM`  
* JOY_PRICE_weight_M: `(SUMPERS_JOY_M * EntrancemaleJoyclubPremium) + (ExternalM * Entrancemale)`  
* HIGH_PRICE_weight_M: `SUMPERS_M * Entrancemale`  
* Result_MinPrice_M: `sum[JOY_PRICE_weight_M] / sum[SUMPERS_M]`  
* Result_HighPrice_M: `sum[HIGH_PRICE_weight_M] / sum[SUMPERS_M]`  
* SUMPERS_JOY_F: `IFSOLOF_sum`  
* SUMPERS_F: `SUMPERS_JOY_F + ExternalF`  
* JOY_PRICE_weight_F: `(SUMPERS_JOY_F * EntrancefemaleJoyclubPremium) + (ExternalF * Entrancefemale)`  
* HIGH_PRICE_weight_F: `SUMPERS_F * Entrancefemale`  
* Result_MinPrice_F: `sum[JOY_PRICE_weight_F] / sum[SUMPERS_F]`  
* Result_HighPrice_F: `sum[HIGH_PRICE_weight_F] / sum[SUMPERS_F]`   

Legal and Ethical Considerations
--------------------------------
Reference is made to the information contained in the file `LegalAndEthicalStatement.md`. The document provides a comprehensive legal and ethical analysis regarding the scientific use of data from swinger websites, focused on the context in Germany.

From a legal point of view, the creation of the data package adheres to German database protection laws and the European Union General Data Protection Regulation (GDPR), building on immediate anonymization and a low likelihood of re-identification from streamlined data, the assumption of which is based on current research. Compliance with legal safeguards, database protections, GDPR classifications, notification of data subjects, special category data, and risk management strategies are discussed in the file `LegalAndEthicalStatement.md`, concluding that the data collection and processing are legally justified.

The ethical discourse in the file `LegalAndEthicalStatement.md` emphasizes how ethical considerations deeply influence the European and German laws regarding the usage of data, forming a legally binding framework for research ethics. A risk of group-based discrimination was examined. In Germany, swingers do not face group-related collective discrimination or disadvantages. Swinging is legally allowed in Germany, with certain general legal restrictions such as consent and minimum age for sexual acts. Swinger clubs are legally operational and are regarded similarly to restaurants. Participants in swinging activities do not risk legal disadvantages such as termination from employment. No cases were reported where participation in swinging led to disadvantages in family law contexts. Swinging and swingers clubs generally receive neutral or positive coverage in the German media, contrasting with the situation in some other countries. Swinger clubs operate openly; a clandestine nature to their operation as seen in some other places is not prevalent. References supporting these results are provided in the file `LegalAndEthicalStatement.md`. Due to the legal and social context, the creator chose a transparent approach in this research, mentioning the portals and venues involved explicitly.

Instrument- or Software-Specific Information Needed to Interpret the Data
-------------------------------------------------------------------------
* The `*.sav` files were generated by the software IBM SPSS Statistics, version 29.0.1.1 (International Business Machines Corporation [IBM], 2023). Other software products might have functionality to process the files.
* The `*.py` files were programmed to run with Python, version 3.9 (Python Software Foundation, 2020), and require the following software modules:
	* csv  
	* geopy (Geopy Contributors, 2023)  
	* os  
	* pickle  
	* re  
	* time  
	* tkinter
* All other files do not use proprietary formats or specific software to operate.

Environmental/Experimental Conditions
-------------------------------------
N/A

Describe any Quality-Assurance Procedures Performed on the Data
---------------------------------------------------------------
T-Tests were performed in IBM SPSS v 29.0.0.1 to verify the representativity of the counties selected for Germany. The results were affirmative.

Manual random comparisons between the raw data and the script generated corpus data were performed to assess the proper functioning of the scripts. In that course, it was revealed that the automatic distance calculation to the cities of Marl and Hattingen resulted in wrong results. For this reason, the wrong data were discarded, and the DIST variable was not filled with data with respect to events taking place in these two cities. Other mistakes were not found.

As far as possible, data were copied, and not manually typed, into datasets to avoid mistakes that can occur when copying data manually.

People Involved With Sample Collection, Processing, Analysis and/or Submission
------------------------------------------------------------------------------
*Author*

DATA-SPECIFIC INFORMATION FOR: calc_AdmissionPricesEvents.xlsx.xlsx
==================================================================

Table 1 - Couples Price Calculation
-----------------------------------
Number of variables: 10 (plus two results variables)  

Number of cases/rows: 74  

Variable List
* *Variable name*;  
	* *Description*;  
	* *Variable type*;  
	* *Unit*  
	
* EVENTNO;
	* Number of event;  
	* Nominal;  
	* nominal  
* IFACC_sum;  
	* Solo accompanied solo JC visitors;  
	* Scale;  
	* couples  
* IFCOUPLE_sum;  
	* Couples JC admitted (number of couples, not persons);  
	* Scale;  
	* couples  
* ExternalC;  
	* Sum external admissions (outside Joyclub) - couples;  
	* Scale;  
	* couples  
* SUMCOUPLES_JOY
    * Number of couples and solo accompanied solo JC visitors;  
	* Scale;  
	* couples  
* SUMCOUPLES
    * Number of couples and solo accompanied solo JC and external visitors;  
	* Scale;  
	* couples  
* Entrancecouple;  
	* Entrance couple in Euro;  
	* Scale;  
	* Euro  
* EntrancecoupleJoyclubpremium;  
	* Entrance for couples who are JC premium members, in Euro;  
	* Scale;  
	* Euro  
* JOY_PRICE_weight_C;  
    * Sum of the entrance fees paid by all couples to the event if the maximum possible JC Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* HIGH_PRICE_weight_C;  
    * Sum of the entrance fees paid by all couples to the event if the no JC Premium discount was utilized, in Euro;
	* Scale;  
	* Euro  
* Result_MinPrice_C;  
    * Resulting average entrance fees paid by couples to all events if the maximum possible JC Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* Result_HighPrice_C;  
    * Resulting average entrance fees paid by couples to all events if no JC Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  	

Table 2 - Solo Men Price Calculation
------------------------------------
Number of variables: 9 (plus two results variables)  

Number of cases/rows: 75  

Variable List
* *Variable name*;  
	* *Description*;  
	* *Variable type*;  
	* *Unit*  
	
* EVENTNO;
	* Number of event;  
	* Nominal;  
	* nominal  
* IFSOLOM_sum;  
	* Solo men JC admitted;  
	* Scale;  
	* persons  
* ExternalM;  
	* Sum external admissions (outside Joyclub) - solo men;  
	* Scale;  
	* persons  
* SUMPERS_JOY_M;  
    * Number of solo men JC visitors;  
	* Scale;  
	* persons  
* SUMPERS_M;  
    * Number of solo men JC and external visitors;  
	* Scale;  
	* persons  
* Entrancemale;  
	* Entrance solo men in Euro;  
	* Scale;  
	* Euro  
* EntrancemaleJoyclubpremium;  
	* Entrance solo men who are Joyclub premium members, in Euro;  
	* Scale;  
	* Euro  
* JOY_PRICE_weight_M;  
    * Sum of the entrance fees paid by all solo men to the event if the maximum possible Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* HIGH_PRICE_weight_M;  
    * Sum of the entrance fees paid by all solo men to the event if the no Joyclub Premium discount was utilized, in Euro;
	* Scale;  
	* Euro  
* Result_MinPrice_M;  
    * Resulting average entrance fees paid by solo men to all events if the maximum possible Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* Result_HighPrice_M;  
    * Resulting average entrance fees paid by solo men to all events if no Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  	

Table 3 - Solo Women Price Calculation
--------------------------------------
Number of variables: 9 (plus two results variables)  

Number of cases/rows: 72  

Variable List
* *Variable name*;  
	* *Description*;  
	* *Variable type*;  
	* *Unit*  
	
* EVENTNO;
	* Number of event;  
	* Nominal;  
	* nominal  
* IFSOLOM_sum;  
	* Solo men JC admitted;  
	* Scale;  
	* persons  
* ExternalM;  
	* Sum external admissions (outside Joyclub) - solo men;  
	* Scale;  
	* persons  
* SUMPERS_JOY_F;  
    * Number of solo women JC visitors;  
	* Scale;  
	* persons  
* SUMPERS_F;  
    * Number of solo women JC and external visitors;  
	* Scale;  
	* persons  
* Entrancefemale;  
	* Entrance solo women in Euro;  
	* Scale;  
	* Euro  
* EntrancefemaleJoyclubpremium;  
	* Entrance solo women who are Joyclub premium members, in Euro;  
	* Scale;  
	* Euro  
* JOY_PRICE_weight_F;  
    * Sum of the entrance fees paid by all solo women to the event if the maximum possible Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* HIGH_PRICE_weight_F;  
    * Sum of the entrance fees paid by all solo women to the event if the no Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* Result_MinPrice_F;  
    * Resulting average entrance fees paid by solo men to all events if the maximum possible Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  
* Result_HighPrice_F;  
    * Resulting average entrance fees paid by solo men to all events if no Joyclub Premium discount was utilized, in Euro;  
	* Scale;  
	* Euro  	

Information Applying to all Tables in the File
----------------------------------------------
Missing data codes:
* Empty fiels : Not applicable (gender not admitted to the specific event); the row was then ignored in the calculation
* Events where an entry price had not been charged for the specific group were not considered in this calculation.

Specialized formats or other abbreviations used:
* JC = Joyclub

DATA-SPECIFIC INFORMATION FOR: data_AdmissionsDataAggregated.xlsx
==================================================================

Number of variables: 53

Number of cases/rows: 76

Variable List
* *Variable name*;  
	* *Description*;
	* *Variable type*;
	* *Unit*[;  ]  
		* *Value label 1, if applicable*[;  ]  
		* *Value label 2, if applicable*[;  ]  
		* *Value label 3, if applicable*[;  ]  
		* *Value label 4, if applicable*
* EVENTNO;
	* Number of event;  
	* Nominal;  
	* nominal  
* Date;
	* Date of the event;  
	* Nominal;
	* YYYYMMDD  
* EVENT;  
	* Short name of event;  
	* Nominal;  
	* nominal;  
* REPR_EVENT;  
	* Part of the consolidated set (admitted persons > 94, number of external registrations < 20%);  
	* Nominal;  
	* boolean;  
		* 0 = no; 
		* 1 = yes
* ISRELIABLE;  
	* Whether the event had 95% JC registrations of all admitted guests;  
	* Nominal;  
	* boolean;  
		* 0 = no;  
		* 1 = yes
* EXTERN_percent;  
	* Percentage of admitted guests with external registrations;  
	* Scale;  
	* persons * 100 / persons  
* Citationreference;  
	* Citation reference of webpage related to the event;  
	* Nominal;  
	* nominal  
* Screennameofvenue;  
	* Screen name of venue;  
	* Nominal;  
	* nominal  
* Screennameofdifferentorganizer;  
	* Screen name of different organizer;  
	* Nominal;  
	* nominal  
* Municipalitystate;  
	* Municipality, state of venue;  
	* Nominal;  
	* nominal  
* Verbaldescriptionofrestrictions;  
	* Verbal description of restrictions applying for admission;  
	* Nominal;  
	* nominal  
* Eventclass;  
	* Event class;  
	* Nominal;  
	* nominal;  
		* 0 = Ordinary swinger event;  
		* 1 = Dance / food focused event;  
		* 2 = Sex focused event;  
		* 3 = Dance / food and sex focused event  
* Entrancefemale;  
	* Entrance solo female guest in Euro;  
	* Scale;  
	* Euro  
* EntrancefemaleJoyclubpremium;  
	* Entrance solo female guest, Joyclub premium member, in Euro;  
	* Scale;  
	* Euro  
* Entrancemale;  
	* Entrance solo male guest in Euro;  
	* Scale;  
	* Euro  
* EntrancemaleJoyclubpremium;  
	* Entrance solo male guest, Joyclub premium member, in Euro;  
	* Scale;  
	* Euro  
* Entrancecouple;  
	* Entrance couple in Euro;  
	* Scale;  
	* Euro  
* EntrancecoupleJoyclubpremium;  
	* Entrance couple, Joyclub premium members, in Euro;  
	* Scale;  
	* Euro  
* Codeforgenderrestriction;  
	* Code for gender restriction;  
	* Nominal;  
	* nominal;
		* 0 = Unrestricted;  
		* 1 = Couples and solo women only;  
		* 2 = Couples only  
* Agerestrictionsingleperson;  
	* Age restriction single person (maximum years of age) (no value means no restriction);  
	* Scale;  
	* Age  
* Agerestrictioncouplesumofages;  
	* Age restriction couple (maximum sum of ages) (no value means no restriction);  
	* Scale;  
	* Age  
* AGEF_median;  
	* Median age women;  
	* Scale;  
	* years  
* AGEF_sd;  
	* Std.D. Age women;  
	* Scale;  
	* years  
* AGEM_median;  
	* Median age men;  
	* Scale;  
	* years  
* AGEM_sd;  
	* Std.D. age men;  
	* Scale;  
	* years  
* AGEACC_median;  
	* Median age acc solo;  
	* Scale;  
	* years  
* AGEACC_sd;  
	* Std.D. age acc solo;  
	* Scale;  
	* years  
* MEDAGEDIFF;  
	* Median of Difference age difference in couples (positive means man is older);  
	* Scale;  
	* years  
* NUM_VISITORS_sum;  
	* Number of JC visitors;  
	* Scale;  
	* persons  
* IFFAR_persons_sum;  
	* Number of persons who are known to have a residence which is  > 100 km away from venue;  
	* Scale;  
	* persons  
* IFSOLOF_sum;  
	* Solo women JC visitors;  
	* Scale;  
	* persons  
* IFSOLOM_sum;  
	* Solo men JC visitors;  
	* Scale;  
	* persons  
* IFACC_sum;  
	* Solo accompanied solo JC visitors;  
	* Scale;  
	* persons  
* IFCOUPLE_sum;  
	* Couples JC admitted (number of couples, not persons);  
	* Scale;  
	* couples  
* IFCOUPLE_persons;  
	* Couples - JC admitted - Number of visitors (two persons per case);  
	* Scale;  
	* persons  
* Sumexternal;  
	* Sum external admissions (outside JC);  
	* Scale;  
	* persons  
* ExternalF;  
	* Sum external admissions (outside JC) - women;  
	* Scale;  
	* persons  
* ExternalM;  
	* Sum external admissions (outside JC) - men;  
	* Scale;  
	* persons  
* ExternalC;  
	* Sum external admissions (outside JC) - couples;  
	* Scale;  
	* couples  
* SOLOM_visitorstotal;  
	* Solo men - Number of visitors including externals;  
	* Scale;  
	* persons  
* SOLOF_visitorstotal;  
	* Solo women - Number of visitors including externals;  
	* Scale;  
	* persons  
* COUPLE_visitorstotal;  
	* Couples - Number of visitors including externals;  
	* Scale;  
	* persons  
* MALE_visitorstotal;  
	* Men - Number of visitors including externals and in couples;  
	* Scale;  
	* persons  
* FEMALE_visitorstotal;  
	* Women - Number of visitors including externals and in couples;  
	* Scale;  
	* persons  
* COUPLEANDACC_visitorstotal;  
	* Couples incl accompanied solos - Number of visitors;  
	* Scale;  
	* persons  
* VISITORSTOTAL_inclaccompanier;  
	* Total visitors including accompanying persons;  
	* Scale;  
	* persons  
* FEMALE_ratio;  
	* Proportion of female visitors;  
	* Scale;  
	* persons * 100 / persons  
* MALE_ratio;  
	* Proportion of male visitors;  
	* Scale;  
	* persons * 100 / persons  
* COUPLE_ratio;  
	* Proportion of visitors in couples;  
	* Scale;  
	* persons * 100 / persons  
* SOLOF_ratio;  
	* Proportion of solo women;  
	* Scale;  
	* persons * 100 / persons  
* SOLOM_ratio;  
	* Proportion of solo men;  
	* Scale;  
	* persons * 100 / persons  


Missing data codes:
* #NULL! : No applicable or data not available

Specialized formats or other abbreviations used:
* JC = Joyclub
* Std.D. = standard deviation

DATA-SPECIFIC INFORMATION FOR: data_AdmissionsDataAggregated.sav
================================================================
Identical to the Data-Specific Information for: `data_AdmissionsDataAggregated.xlsx`

DATA-SPECIFIC INFORMATION FOR: data_EventDataRaw.xlsx
=====================================================

Table 'General Data'
--------------------
Number of variables: 18

Number of cases/rows: 88

Variable List
* *Variable name*;  
	* *Description*;
	* *Variable type*;
	* *Unit*[;  ]  
		* *Value label 1, if applicable*[;  ]  
		* *Value label 2, if applicable*[;  ]  
		* *Value label 3, if applicable*[;  ]  
		* *Value label 4, if applicable*
* Event no;
	* Number of event;  
	* Nominal;  
	* nominal  
* Date;
	* Date of the event;  
	* Nominal;
	* YYYYMMDD  
* Screen name of venue;  
	* Screen name of venue;  
	* Nominal;  
	* nominal  
* Screen name of different organizer;  
	* Screen name of different organizer;  
	* Nominal;  
	* nominal  
* Municipality, state;  
	* Municipality, state of venue;  
	* Nominal;  
	* nominal  
* Verbal description of restrictions;  
	* Verbal description of restrictions applying for admission;  
	* Nominal;  
	* nominal  
* Verbal description of event
	* Verbal desciption of the event, drafted by the creator of this dataset;  
	* Nominal;
	* nominal
* Event class;  
	* Event class;  
	* Nominal;  
	* nominal;  
		* 0 = Ordinary swinger event;  
		* 1 = Dance / food focused event;  
		* 2 = Sex focused event;  
		* 3 = Dance / food and sex focused event  
* Entrance female;  
	* Entrance solo female guest in Euro;  
	* Scale;  
	* Euro  
* Entrance female Joyclub premium;  
	* Entrance solo female guest, Joyclub premium member, in Euro;  
	* Scale;  
	* Euro  
* Entrance male;  
	* Entrance solo male guest in Euro;  
	* Scale;  
	* Euro  
* Entrance male Joyclub premium;  
	* Entrance solo male guest, Joyclub premium member, in Euro;  
	* Scale;  
	* Euro  
* Entrance couple;  
	* Entrance couple in Euro;  
	* Scale;  
	* Euro  
* Entrance couple Joyclub premium;  
	* Entrance couple, Joyclub premium members, in Euro;  
	* Scale;  
	* Euro  
* Code for gender restriction;  
	* Code for gender restriction;  
	* Nominal;  
	* nominal;
		* 0 = Unrestricted;  
		* 1 = Couples and solo women only;  
		* 2 = Couples only  
* Age restriction single person;  
	* Age restriction single person (maximum years of age) (no value means no restriction);  
	* Scale;  
	* Age  
* Age restriction couple - sum of ages;  
	* Age restriction couple (maximum sum of ages) (no value means no restriction);  
	* Scale;  
	* Age  

Missing data codes:
* Empty cell : No applicable or data not available

Specialized formats or other abbreviations used: N/A

Table 'Explanation and remarks'
-------------------------------

Number of variables: 1

Number of cases/rows: 12

List of variables  
* Explanation and remarks  
	Verbal explanations regarding the contents of the table `General Data`

Missing data codes: N/A

Specialized formats or other abbreviations used: N/A

Table 'References'
-------------------------------

Number of variables: 1

Number of cases / rows: 88

List of variables  
* References  
	Webpages used as sources for the collected event data, in a format based on the 7th edition of the Publication Manual of the American Psychological Association (APA, 2020)  

Missing data codes: N/A

Specialized formats or other abbreviations used: N/A


REFERENCES
==========
* American Psychological Association. (2020). *Publication manual of the American Psychological Association* (7th ed.). https://doi.org/10.1037/0000165-000
American Psychological Association. Publication Manual (OFFICIAL) 7th Edition of the American Psychological Association: 7th Edition, 2020 Copyright (English Edition) (S.iv). American Psychological Association. Kindle-Version. 
* Geopy Contributors. (2023). GeoPy (2.4.0) [Software]. https://geopy.readthedocs.io/en/stable/  
* International Business Machines Corporation [IBM]. (2023). SPSS Statistics (29.0.0.1) [Software]. https://www.ibm.com/spss
* Joyclub. (n.d.-a). Advertising. Retrieved October 15, 2023, from https://support.joyclub.com/hc/en-gb/articles/4414426584338-Advertising
* Joyclub. (n.d.-b). FAQ: Frequently asked questions about authentication. Retrieved October 15, 2023, from https://support.joyclub.com/hc/en-gb/articles/4411486276754-FAQ-Frequently-asked-questions-about-authentication
* Joyclub. (n.d.-c). *Gästeverwaltung - Gesamtüberblick* [Guest management - general overview]. Retrieved October 15, 2023, from https://support.joyclub.com/hc/de/articles/12584639414290-Gesamt%C3%BCberblick
* Joyclub. (n.d.-d). *How do I get the JOYclub 10% discount?* Retrieved October 15, 2023, from https://support.joyclub.com/hc/en-gb/articles/4411698553106-How-do-I-get-the-JOYclub-10-discount-
* Joyclub. (n.d.-e). *Members*. Retrieved October 15, 2023, from https://www.joyclub.com/en/member/ Accessible after free registration.  
* Joyclub. (n.d.-f). *Registration and profile types / Change profile type*. Retrieved October 15, 2023, from https://support.joyclub.com/hc/en-gb/articles/360020584820-Registration-and-profile-types-Change-profile-type
* Joyclub. (n.d.-g). *What options do I have to manage my event?* Retrieved October 15, 2023, from https://support.joyclub.com/hc/en-gb/articles/4411692199186-What-options-do-I-have-to-manage-my-event-
* Python Software Foundation. (2020). Python (3.9.0) [Software]. https://www.python.org/downloads/release/python-390/  