Legal and Ethical Statement
===========================

Legality
--------

### Database Protection Laws ###
Applicable database protection laws are those of the Federal Republic of Germany. The author as well as the operator of the website Joyclub (https://www.joyclub.de) have their residence or legal seat, respectively, in Germany (Joyclub, n.d.-a).

German database protection laws expressly regulate data harvesting from databases that are accessible for reasearchers.  
* According to Section 87b of the German Copyright Act (Federal Republic of Germany [Federal Ministry of Justice] & Federal Office of Justice, n.d.-a), which regulates database protection, "the producer of a database has the exclusive right to reproduce and distribute the database as a whole or a qualitatively or quantitatively substantial part of the database and to make it available to the public." According to Section 87a of the German Copyright Act, a *database* is any data "arranged in a systematic or methodical way and individually accessible by electronic or other means and whose obtaining, verification or presentation requires a substantial qualitative or quantitative investment."  
* According to Section 60d of the German Copyright Act, text and data mining for purposes of non-commercial scientific research are expressly permitted, thus limiting the exclusive right of the database producer (Mandon, 2018). According to Section 60g(1) of the Copyright Act, a the database producer may not rely on conflicting contractual agreements, such as i.e. contained in its general terms and conditions.
* The contents of the databases collected in this way may also be transmitted to third parties for the purpose of checking the quality of scientific research, i.e., in particular for peer reviews (Section 60d(4)2 of the German Copyright Act). This applies only to the corpus of data, not to the source material, which may not be redistributed (Brettschneider, 2021); upon permitted sharing of the corpus, the sources must be stated (Mandon, 2018).
* The database right is not a right over the information stored in the database (Duisberg, 2017). Database protection exists independent of the content of the database (Kleinkopf, 2022, p. 162). Therefore, analysis in the context of text and data mining as such is permitted by copyright law even without a separate legal norm that would allow it (Kleinkopf, 2022, p. 170). Consequently, if database data are processed, in particular aggregated, and thus the specific arrangement of the data in the original database is not included in the new work thus created, it is not identical with the protected work. The producer of the original database then cannot claim any rights in the resulting new work.
* For this study, the consequences are as follows:
	* The requirements for the legality of the data collection, as provided for in the database protection laws, were fulfilled. The data for this study were collected with a properly set up Joyclub profile, which allows access to the respective data. Eventual contravening terms and conditions were not identified, but would anyway be legally irrelevant under German law.  
	* The statutory requirements for the legality of the production of a structured corpus from the data collected were fulfilled.  
	* The corpus itself may only be transmitted to third parties for the purpose of checking the quality of scientific research, i.e., in particular in peer reviews.  
	* The data in the original database do not enjoy any legal protection by themselves. The same applies to data derived from them. The database protection relates to the combination of, as the first element, the arrangement, and as the second element, the content of the database, and not to any of these two elements without the respective other element. Therefore, it does not relate to the data contained in the database alone, and not to any data deriving from them. Because the aggregated data (e.g. medians, standard deviations) do not reflect the structure of the original database, and are newly generated and not the original data, they are not subject to the database rights which rest with the original database, and can thus be shared. 
	* In addition, because they do not form a product of any human creativity, the original data retrieved are not subject to any copyright. This is even more true for derivative data.  
	* To avoid misunderstandings, it has to be emphasized that the collection of the metadata of the events had not been based on stuctured data (and, thus, a database), but retrieved from individual entries on the webpage produced by the organizers of the events.  

### Data Protection Laws ###
* Data protection law, in particular the European Union General Data Protection Regulation (GDPR) (European Union [Publications Office of the EU], 2015), which is directly applicable law in Germany, refers only to personal data. According to Article 4 of the GDPR, *personal data* are data relating to an identified or identifiable natural person (*data subject*). A data subject is a natural person who can be identified, directly or indirectly, in particular by reference to an identifier such as a name, an identification number, location data, an online identifier or to one or more factors specific to the physical, physiological, genetic, mental, economic, cultural or social identity of that natural person. As long as data are collected that allow individualization, they are personal data. In that case, the processing of the data is subject to the GDPR.
* Profile data in specific the form in which they can be retrieved in Joyclub, as the result of a member search or as registration data for an event, are therefore personal data, if a profile name is provided. A profile name chosen by individuals serves the purpose to pseudonymously or openly identify them. Therefore, it clearly serves the purpose of an identfier within the meaning of Article 4 of the GDPR.
* For the assessment of the legality of sharing the corpus under the GDPR, it is relevant if individuals can be re-identified from simple age and county data, as they are contained in the corpus. The corpus does not contain further identifiers, so the data would not have the status of personal data if they would not allow re-identification. Without that status, any restrictions imposed in the GDPR would not apply. In the other case, any use of the data would be subject to the limitations provided for by the GDPR.
* The admitted visitors could visit the respective events from whole of Germany, with more than 83 million inhabitants, or from abroad.  
* Sweeney (2000) has shown that it is nearly impossible to re-identify persons in populations of that size if only the age, in years, and the gender are known. Rocher et al. (2019) have demonstrated that the possibility of the re-identification of individuals rises with the increasing number of attributes known, but have confirmed the result that Sweeney had presented before relating to cases where only two or three attributes are known, and where the population of the relevant region is as high as 50,000. Therefore, the risk of re-identifying persons from the data collected for this study appears to be low. With respect to visitors of events, a re-identification of persons only on the basis of the age and gender of the visitor appears highly unlikely, because visitors travel longer distances to events, as the results have shown. In these cases, the population to which the individuals belong is too large for identification.
* To comply with highest ethical standards, data in the corpus, which contain data on the age, the gender, and the county of residence of persons are not published as open data. Also in line with the legal restrictions mandated with a view to database protection, see the Database Protection Laws section, the corpus will only be made accessible individually for the sole purpose of checking the quality of scientific research, i.e., in particular in peer reviews.
* In the light of the above, the GDPR rules might become relevant for this research as follows.
	* In a very short transitional phase, data from Joyclub profiles, without any profile pictures, were retrieved and stored as source data. These data were collected in the form of the textual data available to all members of Joyclub (https://www.joyclub.de), containing the profile data shown on the results pages as search results and of event registrations, respectively. In detail, they contained the profile pseudonym (nickname), any alternative texts to the profile pictures provided by the users, and shown on the results pages, each along with the age, gender, and residence county data. The detailed profile pages of members were not accessed.
	* These source data were immediately converted into a streamlined dataset, using the method described in the Scripts folder in here. That streamlined data set only contained information on the age or ages, county, and gender or genders; the plural applies to couple profiles.
	* The collected source data are *particularly protected data* within the meaning of Article 9 of the General Data Protection Regulation. Within the context of Joyclub, the data concern sex lifes of natural persons.
	* However, these data are exempt from the restrictions which are generally imposed on the use of particularly protected data by the General Data Protection Regulation, because they were each manifestly made public by the respective data subjects within the meaning of Article 9(2)(e) of the Regulation.
	* The European Court of Justice interpreted the exemption contained in Article 9(2)(e) in its decision *Meta Platforms and Others v Bundeskartellamt* of July 4, 2023 (European Court of Justice [ECJ], 2023) in some detail. According to the court, the decisive test for the application of the exemption rule is whether the data have been made available to an unlimited number of other individuals by the data controller on the basis of an informed decision. "Where, on the basis of individual settings selected with full knowledge of the facts, those users have clearly made the choice to have the data made accessible to an unlimited number of persons" (European Court of Justice [ECJ], 2023, para. 82), the conditions for the application of the exemption are fulfilled. "If no such individual settings are available, it must be held [...] that, where users voluntarily enter information into a website [...], they must, in order to be deemed to have manifestly made that data public, have explicitly consented, on the basis of express information provided by that site or app prior to any such entering or clicking or tapping, to the data being viewed by any person having access to that site." (European Court of Justice [ECJ], 2023, para. 83).
	* When registering for an event, users have the option to register anonymously, as is evident from every event page on Joyclub (https://www.joyclub.de). They will be informed of this option before registering and that anonymous registration prevents the possibility of newly made acquaintances contacting them afterwards. In the case of anonymous registration, the profile of the person registering is disclosed to the organizer. Only other guests see the profile only with an avatar, the writing "Anonymous" instead of the profile name and the age and gender of the registered visitor. The anonymously registered and the non-anonymous visitors are displayed on the page of the event after activation by the organizer. 
	* Due to the possibility to register anonymously for events, and because it is immediately obvious when calling up event pages that registrants will be listed on the event page after confirmation, non-anonymous event registrations are thus manifestly made public within the sense of the interpretation of the European Court of Justice. They are therefore subject to the exception in Article 9(2)(e).
	* The same applies to the profiles themselves, because they are created precisely for the purpose of serving as a presentation of the own person and preferences.
	* As Joyclub states a number of registered members on several of its webpages in the website, and since that number exceeds five million, and because, from their own registration, users know that everyone has the possibility to register to the website for free, it is also clear to users that they do not communicate to a small number of persons, but to a potentially unlimited audience.
	* In addition to the above, the exception in Article 9(2)(j) of the General Data Protection Regulation, which grants the Member States legislative competence to regulate data processing for scientific research purposes, applies. In Section 27(1) of the German Federal Data Protection Act (Federal Republic of Germany [Federal Ministry of Justice] & Federal Office of Justice, n.d.-a), the German federal legislature has provided a general provision for the use of particularly research purposes on condition that the interest of the processor clearly outweighs that of the data subject and that appropriate safeguards have been put in place. Because of the immediate anonymization, against the background that the Data Subjects themselves have made the data accessible to an unlimited number of persons, because the data are pseudonymous at the onset, as users mostly do not use real names as profile names, and against the background that the corpus would only be transferred for the limited purpose of the assessment of the quality of science, the interest of the processor clearly outweighs the interest of the data subjects. The immediate anonymization of the data provided for in Section 27 (3) of the Federal Data Protection Act has been carried out.
* In summary, the data retrieved are immediately anonymized and unlikely to allow re-identification of the data subjects, and likely not be considered as data which are related to an identifiable data subject, which excludes them from the scope of the European data protection regulations. Even if the data should be considered person-related, an exemption would apply to them, because the data subjects knowingly and manifestly made the data public. In addition, German federal legislation applies which allows the processing of data for scientific purposes, as the interest in processing clearly outweighs the interests of the data subjects for the reasons stated.

### Issue of the Notification of Data Subjects ###
Subsequent notification of the data subjects about the processing of their data is neither legally mandated nor reasonable under Section 27(2) of the German Federal Data Protection Act. In the design of this research project, priority had been given to immediate anonymization. A notification would not have added value for the data subjects. On the contrary, identifying information would have to be retained beyond the short period of time before the built-up of the corpus. In addition, it would not have been logistically feasible to notify the data subjects. As the only possibility for such communication would have been internal Joyclub messages, the manual creation of messages within Joyclub to the owners of the pseudonymous profiles would have been necessary.  

Ethical Considerations beyond legal questions
---------------------------------------------
The comprehensive considerations that the European and German legislators have made on individual issues of data use in terms of copyright and data protection law are obviously strongly guided by ethical considerations. The resulting laws form a legally binding framework for research ethics.  

### Possibility of Group-Based Discrimination ###
An ethical consideration that goes beyond purely legal considerations relates to address group-based discrimination against the individuals under investigation. Haywood (2022) had discussed that issue in connection with a study which involved harvesting swinger data in the United Kingdom. However, the situations of swingers in the United Kingdom on one hand and of swingers in Germany on the other hand are different. In Germany, swingers do not have to fear group-related collective discrimination or other disadvantages, as explained in further detail herebelow.

### Legality of Swinging in Germany ###
* From a legal point of view, swinging is allowed in Germany without any restrictions which are not contained in general laws, e.g. regarding consent and a minimum age for sexual acts. Swinger clubs are considered to be restaurants and require a permit if alcohol is served there. 
* In 2002, the highest German court responsible for administrative law (Bundesverwaltungsgericht, 2002) ruled on a complaint against the refusal of a restaurant permit for the operation of a swingers club. The court had to decide whether the competent authority must refuse the requested license. According to the laws, the respective authorities must not permit the operation of a restaurant if facts justify the assumption that the applicant holder does not possess the necessary reliability for the business operation, in particular encourages immorality. The court held that operating a swingers club does not constitute immorality within the meaning of the statute. According to the court, the concept of immorality must reflect the right of the individual to the free development of his or her personality, which also includes the right to freedom in the organization of the intimate sphere. The court explained that individuals enjoy a right to self-determination as to the form in which they organize their sexual lifes, insofar as this does not violate the constitutional order of values, normative requirements, or the rights of others. The court argued that the purpose of the immorality restriction contained in the restaurant law was not to promote morality as such or to educate to it. The generation of income from sex-related behavior of others could generally not be considered immoral, according to the court, since the legislature had also made it possible, for example, to create good working conditions for prostitutes in luxury brothels and sauna clubs. Finally, the human dignity of the visitors had not been seen violated by the court, because no objective role was imposed on the visitors that could be considered degrading, but they freely decide in which way they participate in the event. 
* In the past 20 years, there were no incidents reported where authorities or courts have seen any reason to intervene against swingers clubs, including on the basis of complaints from neighbors. In a recent case, the city administration of Koblenz, Rhineland-Palatinate, had issued a permit which expressly stated the operation of a swinger club as the type of operation of a restaurant. This happened in response to a complaint from a neighbor who had noticed that the earlier license of the already existing swinger club did not contain the appropriate mention. As a consequence to the reaction of the city administration, the neighbor filed a lawsuit that was directed against the updated permit and that, in addition, was aimed at obtaining a court order obliging the administration to intervene against the operation of the club. The neighbor did not state immorality, but purported nuisance by traffic and noise resulting from the operation as the reason for the complaint. The lawsuit was unsuccessful before the Higher Administrative Court (Rheinland-Pfalz, 2021), as it was in the subsequent final instance (Bundesverwaltungsgericht, 2022).
* As emphasized by Stühler (2006), municipalities are not allowed to define and implement a swingers club policy in the context of urban land use planning. They lack any own regulatory competence on these matters. 

### No Danger of Job Loss ### 
Individual guests of swingers clubs in Germany do not have to fear any legal disadvantages due to their activity. Employment contracts may not be terminated, and civil servants or soldiers must not be dismissed because of extramarital sexual relations (Mayer, 2013).

### No Disadvantages in Family Law ##
Disadvantages of a family law nature, such as the assumption of an unwritten public order as at least previously in Spain (Navarro, 2016), have not been reported in Germany.

### No Negative Press Coverage ###
Negative coverage of swingers clubs in the German public sphere cannot be identified. In contrast to reports on British media reactions to sex in public places (Hennelly, 2010), the German tabloid press portrays the clubs in a positive light, highlighting, for example, how visits increase guests' self-confidence (Witte, 2023) or how an older gentleman took over the management of a club in order to remain sprightly (Selig, 2023). The national press reported about Joyclub in a neutral manner, presenting the website to a larger audience (Ponath, 2022; Süddeutsche Zeitung, 2012).

### Clubs not Operating in Secrecy ###
Because of the neutral to friendly treatment of the topic in the media as well as by the administrative and judicial practice, a clandestine appearance of the scene is not required. The secrecy of the clubs described by Haywood (2022) with regard to the United Kingdom is not prevalent in Germany.  
* In contrast, in the city of Hattingen, as can also be seen from the bus network map for the city (Verkehrsgesellschaft Ennepe-Ruhr mbH & Verkehrsverbund Rhein-Ruhr AöR, 2020), a bus stop is named after the "Steinenhaus" swingers club next to which it is located.  
*  Even though the majority of the German population may not be inclined towards CNM relationships and does not engage in swinger activities, the topic has not caused any commotion for decades and has not led to attempts at containment by politicians or authorities. Individual court cases are rather due to neighbor disputes, which thematically dealt with noise and comparable problems (Rheinland-Pfalz, 2021).  

### Joyclub is not a Clandestine Niche Website ###
The portal Joyclub itself is not a clandestine operation, as well.
* The platform originated from a chat, which then turned into a forum for discussing erotic topics and was transformed into the Joyclub platform in 2005 (Ponath, 2022).  
* According to its own information on the member search page (Joyclub, n.d.-b), accessed October 15, 2023, it had 5,247,900 members at that time. The alleged membership figure could not be independently verified, nor does it appear in the audited financial statement documents of the operating company F&P GmbH, Selbitz (Ackermann & Noack, 2024).  
* The platform, which was already described as a market leader in the national press in 2012 (Süddeutsche Zeitung, 2012), employed four managing directors and 174 employees including mini-jobbers in 2022. In the fiscal year 2022, it was able to increase sales by 26.9% compared to the previous year. Against the background of an equity ratio of 80.5%, the coverage of all accruals liabilities by liquid funds and a return after taxes in relation to total output of 29.1%, the management described the situation in the last published annual financial statements (Ackermann & Noack, 2024) as very good and the sales and earnings development as pleasing.  

### Conclusion ###
For this reason, I decided, in the interest of the transparency of the research, to take a different approach than Haywood (2022), and to expressly mention the portal Joyclub as well as the venues where the different events which were researched took place.

STATEMENTS AND DECLARATIONS
===========================
No funds, grants, or other support was received. I certify that I have no affiliations with or involvement in any organization or entity with any financial interest or non-financial interest in the subject matter or materials in this data package.

Referral to an ethics committee is not provided for under German law for research without contact with data subjects, as is the case here. The author is not affiliated to any institution which maintains an ethics committee for research as performed in this study.

REFERENCES
==========
* Ackermann, I., & Noack, F. (2024). F & P GmbH Selbitz: Jahresabschluss zum Geschäftsjahr vom 01.01.2022 bis zum 31.12.2022 [F & P GmbH Selbitz: Annual financial statements for the financial year from January 1, 2022 to December 31, 2022]. *Unternehmensregister*. https://www.unternehmensregister.de/ureg/search1.1.html  
* Brettschneider, P. (2021). Text und Data-Mining – juristische Fallstricke und bibliothekarische Handlungsfelder [Text and data mining - legal pitfalls and library action areas]. *Bibliotheksdienst, 55*(2), 104–126. https://doi.org/10.1515/bd-2021-0020
* Bundesrepublik Deutschland [Bundesministerium der Justiz] & Bundesamt für Justiz (Eds.). (n.d.-a). *BDSG - Bundesdatenschutzgesetz* [Federal Data Protection Act]. gesetze-im-internet.de. Retrieved October 15, 2023, from https://www.gesetze-im-internet.de/bdsg_2018/BJNR209710017.html  
* Bundesrepublik Deutschland [Bundesministerium der Justiz] & Bundesamt für Justiz (Eds.). (n.d.-b). *Act on Copyright and Related Rights (Urheberrechtsgesetz – UrhG)* (U. Reusch, Trans.). gesetze-im-internet.de. Retrieved October 27, 2023, from https://www.gesetze-im-internet.de/englisch_urhg/englisch_urhg.html  
* Bundesverwaltungsgericht. (2002). BVerwG 6 C 16.02, Judgment of November 6, 2022, ECLI:DE:BVerwG:2002:061102U6C16.02.0. https://www.bverwg.de/de/061102U6C16.02.0  
* Duisberg, A. (2017). „Datenhoheit und Recht des Datenbankherstellers“ – Recht am Einzeldatum vs. Rechte an Datensammlungen ["Data sovereignty and the right of the database producer" – Right to the individual data vs. rights to data collections] [PDF]. In FZI Forschungszentrum Informatik [Smart-Data-Begleitforschung] (Ed.), *Daten als Wirtschaftsgut: Europäische Datenökonomie oder Rechte an Daten?* (pp. 16–27). https://www.digitale-technologien.de/DT/Redaktion/DE/Downloads/Publikation/2017-11-22_smartdata_daten_wirtschaftsgut.pdf?__blob=publicationFile&v=3  
* European Court of Justice [ECJ]. (2023, July 4). Judgment of July 4, 2023, Meta Platforms and Others v Bundeskartellamt, C-252/21, ECLI:EU:C:2023:537 [Press release]. https://curia.europa.eu/juris/document/document.jsf?text=&docid=275125&pageIndex=0&doclang=EN&mode=req&dir=&occ=first&part=1&cid=1628197
* European Union [Publications Office of the EU] (Ed.). (2015). REGULATION (EU) 2016/679 OF THE EUROPEAN PARLIAMENT AND OF THE COUNCIL of 27 April 2016 on the protection of natural persons with regard to the processing of personal data and on the free movement of such data, and repealing Directive 95/46/EC (General Data Protection Regulation). *Official Journal of the European Union*, L119, 1. https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32016R0679
* Haywood, C. (2022). Sex clubs in the UK: recreational sex, erotic diversity and Geographies of desire. *International Journal of the Sociology of Leisure, 5*(3), 297–320. https://doi.org/10.1007/s41978-022-00108-8  
* Hennelly, S. (2010). Public space, Public Morality: the media construction of sex in public places. *The Liverpool Law Review, 31*(1), 69–91. https://doi.org/10.1007/s10991-010-9073-x
* Joyclub. (n.d.-a). *Impressum* [Imprint]. JoyCLUB. Retrieved October 15, 2023, from https://www.joyclub.de/impressum/  
* Joyclub. (n.d.-b). *Members*. Retrieved October 15, 2023, from https://www.joyclub.com/en/member/ Accessible after free registration.
* Kleinkopf, F. L. (2022). *Text- und Data-Mining* [Text and data mining]. Nomos. https://doi.org/10.5771/9783748935360  
* Mandon, S. (2018, May). *7. Sonderfall: Text und Data Mining* [7. Special case: Text and data mining] (Universität Bremen, Ed.). Retrieved October 27, 2023, from https://www.uni-bremen.de/urheberrecht/wissensplattform/7-sonderfall-text-und-data-mining  
* Mayer, C. (2013). Ehebruch als Dienstvergehen? [Adultery as a service offence?]. *JuristenZeitung, 68*(7), 350–354. https://www.jstor.org/stable/23467599  
* Navarro, P. P. (2016). Beyond inclusion: non-monogamies and the borders of citizenship. *Sexuality and Culture, 21*(2), 441–458. https://doi.org/10.1007/s12119-016-9398-2  
* Ponath, N. (2022, February 19). ». . .sie wurden gewahr, dass sie alle nackt sind« [". . .they became aware that they were all naked"]. *DER SPIEGEL, Hamburg, Germany*. Retrieved October 9, 2023, from https://www.spiegel.de/partnerschaft/joyclub-wie-ein-erotikportal-zum-groessten-digitalen-swingerclub-wurde-a-48f1c59c-7033-4f15-a180-c6dd15f00c69
* Rheinland-Pfalz. (2021, January 12). *Nachbarklage gegen Swingerclub in Koblenz erfolglos* [Neighboring action against swinger club in Koblenz unsuccessful]. Retrieved October 15, 2023, from https://ovg.justiz.rlp.de//presse-aktuelles/pressemitteilungen/detail/nachbarklage-gegen-swingerclub-in-koblenz-erfolglos
* Rocher, L., Hendrickx, J. M., & De Montjoye, Y. (2019). Estimating the success of re-identifications in incomplete datasets using generative models. Nature Communications, 10(1). https://doi.org/10.1038/s41467-019-10933-3  
* Selig, F. (2023, June 5). Swingerclub: Chef mit 79, weil ihm sein Arzt dazu riet [Swinger club: Boss at 79 because his doctor advised him to do so] | Regional. *bild.de*. https://www.bild.de/regional/chemnitz/chemnitz-news/swingerclub-chef-mit-79-weil-ihm-sein-arzt-dazu-riet-84174602.bild.html  
* Stühler, H.-U. (2006). Swinger-Clubs in baurechtlicher Sicht [Swinger clubs from the point of view of zoning law]. *Gewerbearchiv*, 1, 20–26.  
? Süddeutsche Zeitung. (2012, October 13). Sex als Konsum [Sex as consumption]. *Süddeutsche.de*. Retrieved October 9, 2023, from https://www.sueddeutsche.de/leben/boom-von-swinger-clubs-bei-jungen-gaesten-alle-mal-anfassen-1.1386420-3  
* Sweeney, L. (2000). Simple Demographics Often Identify People Uniquely (Data Privacy Working Paper 3). dataprivacylab.org; Carnegie Mellon University. Retrieved October 27, 2023, from https://dataprivacylab.org/projects/identifiability/paper1.pdf  
* Verkehrsgesellschaft Ennepe-Ruhr mbH & Verkehrsverbund Rhein-Ruhr AöR (Eds.). (2020, December). Bus network map of the Ennepe-Ruhr district. https://www.vrr.de/fileadmin/user_upload/pdf/Stadtlinienplaene/Ennepe-Ruhr-Kreis_rs_2021-compressed.pdf  
* Witte, C. (2023, February 26). Witten: BILD im ältesten Swingerclub von NRW [Witten: BILD in the oldest swingers club of North Rhine-Westphalia] | Regional. *bild.de*. https://www.bild.de/bild-plus/regional/ruhrgebiet/ruhrgebiet-aktuell/witten-bild-im-aeltesten-swingerclub-von-nrw-83012484.bild.html  