# **A yearly resolved time-series of vegetation change in a canopy Gap in the Venacquaro valley**  

This repository contains the research data used in the analysis described in the paper:
"Using yearly resolved time-series to disentangle interannual variability, directional change and pseudoturnover in plant community composition" submitted to the *Journal of Vegetation Science*

## Description of the Data

- *flora_clean.csv*: Vascular plant composition of 9 permanent quadrats resurveyed between 2012-2024. Species x plot|year data, in long format.
- *header_data.csv*: Quadrat level data of site conditions, across years. 
- *checklist_elle_clean.csv*: Checklist of species, associated to growth\life form information and Ellenberg Indicator Values.

## File Structure

### flora_clean.csv 
```
VARIABLES               DATA_TYPE           UNIT            DESCRIPTION
Quadrat                 string              unitless        Quadrat identifier, coded based on the cardinal direction and distance from canopy gap center
Year                    integer             year            Year of sampling
Layer                   factor              unitless        Vegetation layer. O: Overstorey, S: shrub layer, U: Understorey
Species_original        string              unitless        Species name as originally recorded in the field
Species_resolved        string              unitless        Species name after data cleaning and taxonomic standardization
Cover                   double              percentage      Percentage cover of a species in a layer\quadrat\year
note                    string              unitless        Notes taken in the field
Treatment               factor              unitless        Position of the quadrat with respect to the canopy gap. Three levels. Interior: forest interior; Margin: at the margin of the gap; Gap: in the canopy gap
Series                  factor              unitless        Cardinal direction from the canopy gap center
```

### header_data.csv
```
VARIABLES               DATA_TYPE           UNIT            DESCRIPTION
Plot                    string              unitless        Plot name
Quadrat                 string              unitless        Quadrat identifier, coded based on the cardinal direction and distance from canopy gap centerDay
Day                     date                dd/mm/yyyy      Date of recording
Slope                   integer             degrees         Slope of the quadrat.    
Aspect                  string              unitless        Cardinal direction faced by the quadrat
Morphology              factor              unitless        Topographical description of the quadrat. V: Versante (=slope), P: Piano (=flat)
Position                factor              unitless        Topographical position if slope. C: Cresta (=ridge), L: Ladera (=mid-slope), V: Valle (=valley)
Rocks                   double              percentage      Percentage of quadrat surface covered by outcropping rocks
Stones                  double              percentage      Percentage of quadrat surface covered by stones
Litter_cover            double              percentage      Percentage of quadrat surface covered by litter
Litter_depth            double              cm              Depth of litter in quadrat (average of 4 readings)
Tree_cover              double              percentage      Percentage of quadrat surface covered by trees (h > 3m)
Tree_h                  double              m               Estimated average height of the tree layer
shrub_cover             double              percentage      Percentage of quadrat surface covered by shrubs (1.3m < h < 3m)
shrub_h                 double              m               Estimated average height of the shrub layer
herb_cover              double              percentage      Percentage of quadrat surface covered by herbs (h < 1.3m)
Moss_cover              double              percentage      Percentage of quadrat surface covered by mosses
deadwood_cover          double              percentage      Percentage of quadrat surface covered by deadwood
Disturbance_type        factor              unitless        Signs of disturbance. Four categories: Pas: Pascolo (=browsing), VS: Vicino strada (=trampling), Root: Rooting by wild boars, Cut: signs of logging
Disturbance_intens      ordinal             unitless        Estimated intensity of disturbance. 0: none, 1: low, 2: medium, 3: high
Develop_phase           factor              unitless        Developmental phase of forest stand. 1: canopy gap, 2: seedlings (mean dbh < 2.5cm), 3: saplings (dbh < 20cm), 4: early biostatic (dbh < 40 cm), 5: late biostatic (dbh >= 40cm)
Prism                   integer             unitless        Count of wedge prism (conversion factor 10) to estimate Basal area. Can be converted to m2/ha multiplying by 2.295681
N_Emis                  integer             unitless        Canopy openness as estimated with hemispherical densiometer facing North. From 0 to 96
E_Emis                  integer             unitless        Canopy openness as estimated with hemispherical densiometer facing East. From 0 to 96
S_Emis                  integer             unitless        Canopy openness as estimated with hemispherical densiometer facing South. From 0 to 96
W_Emis                  integer             unitless        Canopy openness as estimated with hemispherical densiometer facing West. From 0 to 96
```
Note: The fields Slope:Stones were only filled once at the beginning of the study period (year 2012).

### checklist_elle_clean.csv
```
VARIABLES               DATA_TYPE           UNIT            DESCRIPTION
Species_resolved        string              unitless        Species name after data cleaning and taxonomic standardization	
author	                string              unitless        Author citation of species name
Code_Pignatti           integer             unitless        Species code in Pignatti S. (2005). Valori di bioindicazione delle piante vascolari della Flora d’Italia. Braun-Blanquetia
GF                      string              unitless        Growth form. P: Phanerophyte, G: Geophyte, H: Hemicrypthophyte, T: Terophyte, Ch: Chamaeophyte, Np: Nanophanerophyte
LF                      string              unitless        Life form. Bulb: bulbose, Caesp: caespitose, Lian: Lianose, Np: Nanophanerophyte, Rept: Reptant, Rhiz: rhizomatous, Ros: Rosulate, Scap: Scapose, Suffr: Suffruticose.
Corotipo                string              unitless        Chorotype of the species
T                       ordinal             unitless        Ellenberg Indicator values for Temperature (from Pignatti 2005)
C                       ordinal             unitless        Ellenberg Indicator values for Continentality (from Pignatti 2005)
U                       ordinal             unitless        Ellenberg Indicator values for Humidity (from Pignatti 2005)
R                       ordinal             unitless        Ellenberg Indicator values for pH (from Pignatti 2005)
N                       ordinal             unitless        Ellenberg Indicator values for Nutrients (from Pignatti 2005)
S                       ordinal             unitless        Ellenberg Indicator values for Salinity (from Pignatti 2005)
Main_Coro               string              unitless        Simplified Chorotype
Spring_ephemeral        boolean             unitless        Spring ephemeral. TRUE/FALSE
```

## License

This work is licensed under the **Creative Commons Attribution 4.0 International (CC BY 4.0)** license.  
You are free to:
- Share — copy and redistribute the material in any medium or format.
- Adapt — remix, transform, and build upon the material for any purpose, even commercially.

Under the following terms:
- Attribution — You must give appropriate credit, provide a link to the license, and indicate if changes were made. You may do so in any reasonable manner, but not in any way that suggests the licensor endorses you or your use.

For more details, see [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).

## Citation

If you use this data, please cite it as follows:

Sabatini FM. (2025). A yearly resolved time-series of vegetation change in a canopy Gap in the Venacquaro valley. Zenodo. DOI: 10.5281/zenodo.15196194  
Sabatini FM, Di Musciano M, Chiarucci A. (under review). Using yearly resolved time-series to disentangle interannual variability, directional change and pseudoturnover in plant community composition. Submitted to Journal of Vegetation Science

## Contact

For questions or further information, please contact:  
Francesco Maria Sabatini
Alma Mater Studiorum - University of Bologna
francescomaria.sabatini@unibo.it