Contains output files from GLEANR analysis by Omdahl et al., "Sparse matrix factorization robust to sample sharing across GWAS reveals interpretable genetic components"
## PanUKBB_137_trait_analysis
Main sub-directories correspond to the methods of matrix factorization discussed in the paper.

Contains subdirectories for results from using GLEANR, flash, and SVD across 137 diverse traits from the UKBB. Each is organized as follows:
  -factorization
    - Contains the loading (U) and factor (V) matrices from the factorization.
  -S-LDSC_tissue_enrichment
    - Contains the output files from all S-LDSC tissue enrichment analysis across 489 tissue-specific chromatin markers available at https://github.com/bulik/ldsc/wiki/Cell-type-specific-analyses
  -enrichr_enrichments
    - Contains the scores for gene set enrichment test performed on the following gene libraries using the enrichr platform: GO Biological Process, GO Cellular Component, GO Molecular Function, DisGeNET, KEGG pathways, GWAS Catalog, and PanglaoDB.
    - File headers are: "Rank,Term name,P-value,Odds ratio,Combined score,Adjusted p-value,Genes,gene_library"
  -genetic_architecture
    - Contains tabular file containing estaimtes of S (coefficient indicating the MAF-effect size relationship) and Me (effective polygenicity), as described in the text.

## FinnGen_v_UKBB_analysis
This contains the `RData` output files from GLEANR for the comparative runs between FinnGen and the UKBB, with and without adjustment for sample sharing. The directory `unadjusted_for_sample_sharing` also includes the data from SVD analyses on these data.
