/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 80352:
/***/ ((module) => {

"use strict";
/**
 * DON'T EDIT THIS FILE
 * Module was generated automatically by ajv precompiler 
 * See '/tools/bundle/genValidators.js'
 */


module.exports = validate10;
module.exports["default"] = validate10;
const schema11 = {
  "$id": "settings.json",
  "type": "object",
  "properties": {
    "protocol-version": {
      "type": "string"
    },
    "general-settings": {
      "type": "object",
      "properties": {
        "app-language": {
          "type": "string"
        },
        "allow-acceptable-ads": {
          "type": "boolean"
        },
        "show-blocked-ads-count": {
          "type": "boolean"
        },
        "autodetect-filters": {
          "type": "boolean"
        },
        "safebrowsing-enabled": {
          "type": "boolean"
        },
        "filters-update-period": {
          "type": "integer"
        },
        "appearance-theme": {
          "type": "string"
        }
      },
      "required": ["allow-acceptable-ads", "show-blocked-ads-count", "autodetect-filters", "safebrowsing-enabled", "filters-update-period"]
    },
    "extension-specific-settings": {
      "type": "object",
      "properties": {
        "use-optimized-filters": {
          "type": "boolean"
        },
        "collect-hits-count": {
          "type": "boolean"
        },
        "show-context-menu": {
          "type": "boolean"
        },
        "show-info-about-adguard": {
          "type": "boolean"
        },
        "show-app-updated-info": {
          "type": "boolean"
        }
      },
      "required": ["use-optimized-filters", "collect-hits-count", "show-context-menu", "show-info-about-adguard", "show-app-updated-info"]
    },
    "filters": {
      "type": "object",
      "properties": {
        "enabled-groups": {
          "type": "array",
          "items": {
            "type": "integer"
          }
        },
        "enabled-filters": {
          "type": "array",
          "items": {
            "type": "integer"
          }
        },
        "custom-filters": {
          "type": "array",
          "items": {}
        },
        "user-filter": {
          "type": "object",
          "properties": {
            "rules": {
              "type": "string"
            },
            "disabled-rules": {
              "type": "string"
            },
            "enabled": {
              "type": "boolean"
            }
          },
          "required": ["rules", "disabled-rules"]
        },
        "whitelist": {
          "type": "object",
          "properties": {
            "inverted": {
              "type": "boolean"
            },
            "domains": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "inverted-domains": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "enabled": {
              "type": "boolean"
            }
          },
          "required": ["inverted", "domains", "inverted-domains"]
        }
      },
      "required": ["enabled-groups", "enabled-filters", "custom-filters", "user-filter", "whitelist"]
    },
    "stealth": {
      "type": "object",
      "properties": {
        "stealth_disable_stealth_mode": {
          "type": "boolean"
        },
        "stealth-hide-referrer": {
          "type": "boolean"
        },
        "stealth-hide-search-queries": {
          "type": "boolean"
        },
        "stealth-send-do-not-track": {
          "type": "boolean"
        },
        "stealth-block-webrtc": {
          "type": "boolean"
        },
        "stealth-block-third-party-cookies": {
          "type": "boolean"
        },
        "stealth-block-first-party-cookies": {
          "type": "boolean"
        },
        "block-known-trackers": {
          "type": "boolean"
        },
        "strip-tracking-parameters": {
          "type": "boolean"
        }
      },
      "required": ["stealth_disable_stealth_mode", "stealth-hide-referrer", "stealth-hide-search-queries", "stealth-send-do-not-track", "stealth-block-webrtc", "stealth-block-third-party-cookies", "stealth-block-first-party-cookies", "strip-tracking-parameters"]
    }
  },
  "required": ["protocol-version", "general-settings", "extension-specific-settings", "filters"]
};

function validate10(data, {
  instancePath = "",
  parentData,
  parentDataProperty,
  rootData = data
} = {}) {
  /*# sourceURL="settings.json" */
  ;
  let vErrors = null;
  let errors = 0;

  if (errors === 0) {
    if (data && typeof data == "object" && !Array.isArray(data)) {
      let missing0;

      if (data["protocol-version"] === undefined && (missing0 = "protocol-version") || data["general-settings"] === undefined && (missing0 = "general-settings") || data["extension-specific-settings"] === undefined && (missing0 = "extension-specific-settings") || data.filters === undefined && (missing0 = "filters")) {
        validate10.errors = [{
          instancePath,
          schemaPath: "#/required",
          keyword: "required",
          params: {
            missingProperty: missing0
          },
          message: "must have required property '" + missing0 + "'"
        }];
        return false;
      } else {
        if (data["protocol-version"] !== undefined) {
          const _errs1 = errors;

          if (typeof data["protocol-version"] !== "string") {
            validate10.errors = [{
              instancePath: instancePath + "/protocol-version",
              schemaPath: "#/properties/protocol-version/type",
              keyword: "type",
              params: {
                type: "string"
              },
              message: "must be string"
            }];
            return false;
          }

          var valid0 = _errs1 === errors;
        } else {
          var valid0 = true;
        }

        if (valid0) {
          if (data["general-settings"] !== undefined) {
            let data1 = data["general-settings"];
            const _errs3 = errors;

            if (errors === _errs3) {
              if (data1 && typeof data1 == "object" && !Array.isArray(data1)) {
                let missing1;

                if (data1["allow-acceptable-ads"] === undefined && (missing1 = "allow-acceptable-ads") || data1["show-blocked-ads-count"] === undefined && (missing1 = "show-blocked-ads-count") || data1["autodetect-filters"] === undefined && (missing1 = "autodetect-filters") || data1["safebrowsing-enabled"] === undefined && (missing1 = "safebrowsing-enabled") || data1["filters-update-period"] === undefined && (missing1 = "filters-update-period")) {
                  validate10.errors = [{
                    instancePath: instancePath + "/general-settings",
                    schemaPath: "#/properties/general-settings/required",
                    keyword: "required",
                    params: {
                      missingProperty: missing1
                    },
                    message: "must have required property '" + missing1 + "'"
                  }];
                  return false;
                } else {
                  if (data1["app-language"] !== undefined) {
                    const _errs5 = errors;

                    if (typeof data1["app-language"] !== "string") {
                      validate10.errors = [{
                        instancePath: instancePath + "/general-settings/app-language",
                        schemaPath: "#/properties/general-settings/properties/app-language/type",
                        keyword: "type",
                        params: {
                          type: "string"
                        },
                        message: "must be string"
                      }];
                      return false;
                    }

                    var valid1 = _errs5 === errors;
                  } else {
                    var valid1 = true;
                  }

                  if (valid1) {
                    if (data1["allow-acceptable-ads"] !== undefined) {
                      const _errs7 = errors;

                      if (typeof data1["allow-acceptable-ads"] !== "boolean") {
                        validate10.errors = [{
                          instancePath: instancePath + "/general-settings/allow-acceptable-ads",
                          schemaPath: "#/properties/general-settings/properties/allow-acceptable-ads/type",
                          keyword: "type",
                          params: {
                            type: "boolean"
                          },
                          message: "must be boolean"
                        }];
                        return false;
                      }

                      var valid1 = _errs7 === errors;
                    } else {
                      var valid1 = true;
                    }

                    if (valid1) {
                      if (data1["show-blocked-ads-count"] !== undefined) {
                        const _errs9 = errors;

                        if (typeof data1["show-blocked-ads-count"] !== "boolean") {
                          validate10.errors = [{
                            instancePath: instancePath + "/general-settings/show-blocked-ads-count",
                            schemaPath: "#/properties/general-settings/properties/show-blocked-ads-count/type",
                            keyword: "type",
                            params: {
                              type: "boolean"
                            },
                            message: "must be boolean"
                          }];
                          return false;
                        }

                        var valid1 = _errs9 === errors;
                      } else {
                        var valid1 = true;
                      }

                      if (valid1) {
                        if (data1["autodetect-filters"] !== undefined) {
                          const _errs11 = errors;

                          if (typeof data1["autodetect-filters"] !== "boolean") {
                            validate10.errors = [{
                              instancePath: instancePath + "/general-settings/autodetect-filters",
                              schemaPath: "#/properties/general-settings/properties/autodetect-filters/type",
                              keyword: "type",
                              params: {
                                type: "boolean"
                              },
                              message: "must be boolean"
                            }];
                            return false;
                          }

                          var valid1 = _errs11 === errors;
                        } else {
                          var valid1 = true;
                        }

                        if (valid1) {
                          if (data1["safebrowsing-enabled"] !== undefined) {
                            const _errs13 = errors;

                            if (typeof data1["safebrowsing-enabled"] !== "boolean") {
                              validate10.errors = [{
                                instancePath: instancePath + "/general-settings/safebrowsing-enabled",
                                schemaPath: "#/properties/general-settings/properties/safebrowsing-enabled/type",
                                keyword: "type",
                                params: {
                                  type: "boolean"
                                },
                                message: "must be boolean"
                              }];
                              return false;
                            }

                            var valid1 = _errs13 === errors;
                          } else {
                            var valid1 = true;
                          }

                          if (valid1) {
                            if (data1["filters-update-period"] !== undefined) {
                              let data7 = data1["filters-update-period"];
                              const _errs15 = errors;

                              if (!(typeof data7 == "number" && !(data7 % 1) && !isNaN(data7) && isFinite(data7))) {
                                validate10.errors = [{
                                  instancePath: instancePath + "/general-settings/filters-update-period",
                                  schemaPath: "#/properties/general-settings/properties/filters-update-period/type",
                                  keyword: "type",
                                  params: {
                                    type: "integer"
                                  },
                                  message: "must be integer"
                                }];
                                return false;
                              }

                              var valid1 = _errs15 === errors;
                            } else {
                              var valid1 = true;
                            }

                            if (valid1) {
                              if (data1["appearance-theme"] !== undefined) {
                                const _errs17 = errors;

                                if (typeof data1["appearance-theme"] !== "string") {
                                  validate10.errors = [{
                                    instancePath: instancePath + "/general-settings/appearance-theme",
                                    schemaPath: "#/properties/general-settings/properties/appearance-theme/type",
                                    keyword: "type",
                                    params: {
                                      type: "string"
                                    },
                                    message: "must be string"
                                  }];
                                  return false;
                                }

                                var valid1 = _errs17 === errors;
                              } else {
                                var valid1 = true;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              } else {
                validate10.errors = [{
                  instancePath: instancePath + "/general-settings",
                  schemaPath: "#/properties/general-settings/type",
                  keyword: "type",
                  params: {
                    type: "object"
                  },
                  message: "must be object"
                }];
                return false;
              }
            }

            var valid0 = _errs3 === errors;
          } else {
            var valid0 = true;
          }

          if (valid0) {
            if (data["extension-specific-settings"] !== undefined) {
              let data9 = data["extension-specific-settings"];
              const _errs19 = errors;

              if (errors === _errs19) {
                if (data9 && typeof data9 == "object" && !Array.isArray(data9)) {
                  let missing2;

                  if (data9["use-optimized-filters"] === undefined && (missing2 = "use-optimized-filters") || data9["collect-hits-count"] === undefined && (missing2 = "collect-hits-count") || data9["show-context-menu"] === undefined && (missing2 = "show-context-menu") || data9["show-info-about-adguard"] === undefined && (missing2 = "show-info-about-adguard") || data9["show-app-updated-info"] === undefined && (missing2 = "show-app-updated-info")) {
                    validate10.errors = [{
                      instancePath: instancePath + "/extension-specific-settings",
                      schemaPath: "#/properties/extension-specific-settings/required",
                      keyword: "required",
                      params: {
                        missingProperty: missing2
                      },
                      message: "must have required property '" + missing2 + "'"
                    }];
                    return false;
                  } else {
                    if (data9["use-optimized-filters"] !== undefined) {
                      const _errs21 = errors;

                      if (typeof data9["use-optimized-filters"] !== "boolean") {
                        validate10.errors = [{
                          instancePath: instancePath + "/extension-specific-settings/use-optimized-filters",
                          schemaPath: "#/properties/extension-specific-settings/properties/use-optimized-filters/type",
                          keyword: "type",
                          params: {
                            type: "boolean"
                          },
                          message: "must be boolean"
                        }];
                        return false;
                      }

                      var valid2 = _errs21 === errors;
                    } else {
                      var valid2 = true;
                    }

                    if (valid2) {
                      if (data9["collect-hits-count"] !== undefined) {
                        const _errs23 = errors;

                        if (typeof data9["collect-hits-count"] !== "boolean") {
                          validate10.errors = [{
                            instancePath: instancePath + "/extension-specific-settings/collect-hits-count",
                            schemaPath: "#/properties/extension-specific-settings/properties/collect-hits-count/type",
                            keyword: "type",
                            params: {
                              type: "boolean"
                            },
                            message: "must be boolean"
                          }];
                          return false;
                        }

                        var valid2 = _errs23 === errors;
                      } else {
                        var valid2 = true;
                      }

                      if (valid2) {
                        if (data9["show-context-menu"] !== undefined) {
                          const _errs25 = errors;

                          if (typeof data9["show-context-menu"] !== "boolean") {
                            validate10.errors = [{
                              instancePath: instancePath + "/extension-specific-settings/show-context-menu",
                              schemaPath: "#/properties/extension-specific-settings/properties/show-context-menu/type",
                              keyword: "type",
                              params: {
                                type: "boolean"
                              },
                              message: "must be boolean"
                            }];
                            return false;
                          }

                          var valid2 = _errs25 === errors;
                        } else {
                          var valid2 = true;
                        }

                        if (valid2) {
                          if (data9["show-info-about-adguard"] !== undefined) {
                            const _errs27 = errors;

                            if (typeof data9["show-info-about-adguard"] !== "boolean") {
                              validate10.errors = [{
                                instancePath: instancePath + "/extension-specific-settings/show-info-about-adguard",
                                schemaPath: "#/properties/extension-specific-settings/properties/show-info-about-adguard/type",
                                keyword: "type",
                                params: {
                                  type: "boolean"
                                },
                                message: "must be boolean"
                              }];
                              return false;
                            }

                            var valid2 = _errs27 === errors;
                          } else {
                            var valid2 = true;
                          }

                          if (valid2) {
                            if (data9["show-app-updated-info"] !== undefined) {
                              const _errs29 = errors;

                              if (typeof data9["show-app-updated-info"] !== "boolean") {
                                validate10.errors = [{
                                  instancePath: instancePath + "/extension-specific-settings/show-app-updated-info",
                                  schemaPath: "#/properties/extension-specific-settings/properties/show-app-updated-info/type",
                                  keyword: "type",
                                  params: {
                                    type: "boolean"
                                  },
                                  message: "must be boolean"
                                }];
                                return false;
                              }

                              var valid2 = _errs29 === errors;
                            } else {
                              var valid2 = true;
                            }
                          }
                        }
                      }
                    }
                  }
                } else {
                  validate10.errors = [{
                    instancePath: instancePath + "/extension-specific-settings",
                    schemaPath: "#/properties/extension-specific-settings/type",
                    keyword: "type",
                    params: {
                      type: "object"
                    },
                    message: "must be object"
                  }];
                  return false;
                }
              }

              var valid0 = _errs19 === errors;
            } else {
              var valid0 = true;
            }

            if (valid0) {
              if (data.filters !== undefined) {
                let data15 = data.filters;
                const _errs31 = errors;

                if (errors === _errs31) {
                  if (data15 && typeof data15 == "object" && !Array.isArray(data15)) {
                    let missing3;

                    if (data15["enabled-groups"] === undefined && (missing3 = "enabled-groups") || data15["enabled-filters"] === undefined && (missing3 = "enabled-filters") || data15["custom-filters"] === undefined && (missing3 = "custom-filters") || data15["user-filter"] === undefined && (missing3 = "user-filter") || data15.whitelist === undefined && (missing3 = "whitelist")) {
                      validate10.errors = [{
                        instancePath: instancePath + "/filters",
                        schemaPath: "#/properties/filters/required",
                        keyword: "required",
                        params: {
                          missingProperty: missing3
                        },
                        message: "must have required property '" + missing3 + "'"
                      }];
                      return false;
                    } else {
                      if (data15["enabled-groups"] !== undefined) {
                        let data16 = data15["enabled-groups"];
                        const _errs33 = errors;

                        if (errors === _errs33) {
                          if (Array.isArray(data16)) {
                            var valid4 = true;
                            const len0 = data16.length;

                            for (let i0 = 0; i0 < len0; i0++) {
                              let data17 = data16[i0];
                              const _errs35 = errors;

                              if (!(typeof data17 == "number" && !(data17 % 1) && !isNaN(data17) && isFinite(data17))) {
                                validate10.errors = [{
                                  instancePath: instancePath + "/filters/enabled-groups/" + i0,
                                  schemaPath: "#/properties/filters/properties/enabled-groups/items/type",
                                  keyword: "type",
                                  params: {
                                    type: "integer"
                                  },
                                  message: "must be integer"
                                }];
                                return false;
                              }

                              var valid4 = _errs35 === errors;

                              if (!valid4) {
                                break;
                              }
                            }
                          } else {
                            validate10.errors = [{
                              instancePath: instancePath + "/filters/enabled-groups",
                              schemaPath: "#/properties/filters/properties/enabled-groups/type",
                              keyword: "type",
                              params: {
                                type: "array"
                              },
                              message: "must be array"
                            }];
                            return false;
                          }
                        }

                        var valid3 = _errs33 === errors;
                      } else {
                        var valid3 = true;
                      }

                      if (valid3) {
                        if (data15["enabled-filters"] !== undefined) {
                          let data18 = data15["enabled-filters"];
                          const _errs37 = errors;

                          if (errors === _errs37) {
                            if (Array.isArray(data18)) {
                              var valid5 = true;
                              const len1 = data18.length;

                              for (let i1 = 0; i1 < len1; i1++) {
                                let data19 = data18[i1];
                                const _errs39 = errors;

                                if (!(typeof data19 == "number" && !(data19 % 1) && !isNaN(data19) && isFinite(data19))) {
                                  validate10.errors = [{
                                    instancePath: instancePath + "/filters/enabled-filters/" + i1,
                                    schemaPath: "#/properties/filters/properties/enabled-filters/items/type",
                                    keyword: "type",
                                    params: {
                                      type: "integer"
                                    },
                                    message: "must be integer"
                                  }];
                                  return false;
                                }

                                var valid5 = _errs39 === errors;

                                if (!valid5) {
                                  break;
                                }
                              }
                            } else {
                              validate10.errors = [{
                                instancePath: instancePath + "/filters/enabled-filters",
                                schemaPath: "#/properties/filters/properties/enabled-filters/type",
                                keyword: "type",
                                params: {
                                  type: "array"
                                },
                                message: "must be array"
                              }];
                              return false;
                            }
                          }

                          var valid3 = _errs37 === errors;
                        } else {
                          var valid3 = true;
                        }

                        if (valid3) {
                          if (data15["custom-filters"] !== undefined) {
                            const _errs41 = errors;

                            if (errors === _errs41) {
                              if (!Array.isArray(data15["custom-filters"])) {
                                validate10.errors = [{
                                  instancePath: instancePath + "/filters/custom-filters",
                                  schemaPath: "#/properties/filters/properties/custom-filters/type",
                                  keyword: "type",
                                  params: {
                                    type: "array"
                                  },
                                  message: "must be array"
                                }];
                                return false;
                              }
                            }

                            var valid3 = _errs41 === errors;
                          } else {
                            var valid3 = true;
                          }

                          if (valid3) {
                            if (data15["user-filter"] !== undefined) {
                              let data21 = data15["user-filter"];
                              const _errs43 = errors;

                              if (errors === _errs43) {
                                if (data21 && typeof data21 == "object" && !Array.isArray(data21)) {
                                  let missing4;

                                  if (data21.rules === undefined && (missing4 = "rules") || data21["disabled-rules"] === undefined && (missing4 = "disabled-rules")) {
                                    validate10.errors = [{
                                      instancePath: instancePath + "/filters/user-filter",
                                      schemaPath: "#/properties/filters/properties/user-filter/required",
                                      keyword: "required",
                                      params: {
                                        missingProperty: missing4
                                      },
                                      message: "must have required property '" + missing4 + "'"
                                    }];
                                    return false;
                                  } else {
                                    if (data21.rules !== undefined) {
                                      const _errs45 = errors;

                                      if (typeof data21.rules !== "string") {
                                        validate10.errors = [{
                                          instancePath: instancePath + "/filters/user-filter/rules",
                                          schemaPath: "#/properties/filters/properties/user-filter/properties/rules/type",
                                          keyword: "type",
                                          params: {
                                            type: "string"
                                          },
                                          message: "must be string"
                                        }];
                                        return false;
                                      }

                                      var valid6 = _errs45 === errors;
                                    } else {
                                      var valid6 = true;
                                    }

                                    if (valid6) {
                                      if (data21["disabled-rules"] !== undefined) {
                                        const _errs47 = errors;

                                        if (typeof data21["disabled-rules"] !== "string") {
                                          validate10.errors = [{
                                            instancePath: instancePath + "/filters/user-filter/disabled-rules",
                                            schemaPath: "#/properties/filters/properties/user-filter/properties/disabled-rules/type",
                                            keyword: "type",
                                            params: {
                                              type: "string"
                                            },
                                            message: "must be string"
                                          }];
                                          return false;
                                        }

                                        var valid6 = _errs47 === errors;
                                      } else {
                                        var valid6 = true;
                                      }

                                      if (valid6) {
                                        if (data21.enabled !== undefined) {
                                          const _errs49 = errors;

                                          if (typeof data21.enabled !== "boolean") {
                                            validate10.errors = [{
                                              instancePath: instancePath + "/filters/user-filter/enabled",
                                              schemaPath: "#/properties/filters/properties/user-filter/properties/enabled/type",
                                              keyword: "type",
                                              params: {
                                                type: "boolean"
                                              },
                                              message: "must be boolean"
                                            }];
                                            return false;
                                          }

                                          var valid6 = _errs49 === errors;
                                        } else {
                                          var valid6 = true;
                                        }
                                      }
                                    }
                                  }
                                } else {
                                  validate10.errors = [{
                                    instancePath: instancePath + "/filters/user-filter",
                                    schemaPath: "#/properties/filters/properties/user-filter/type",
                                    keyword: "type",
                                    params: {
                                      type: "object"
                                    },
                                    message: "must be object"
                                  }];
                                  return false;
                                }
                              }

                              var valid3 = _errs43 === errors;
                            } else {
                              var valid3 = true;
                            }

                            if (valid3) {
                              if (data15.whitelist !== undefined) {
                                let data25 = data15.whitelist;
                                const _errs51 = errors;

                                if (errors === _errs51) {
                                  if (data25 && typeof data25 == "object" && !Array.isArray(data25)) {
                                    let missing5;

                                    if (data25.inverted === undefined && (missing5 = "inverted") || data25.domains === undefined && (missing5 = "domains") || data25["inverted-domains"] === undefined && (missing5 = "inverted-domains")) {
                                      validate10.errors = [{
                                        instancePath: instancePath + "/filters/whitelist",
                                        schemaPath: "#/properties/filters/properties/whitelist/required",
                                        keyword: "required",
                                        params: {
                                          missingProperty: missing5
                                        },
                                        message: "must have required property '" + missing5 + "'"
                                      }];
                                      return false;
                                    } else {
                                      if (data25.inverted !== undefined) {
                                        const _errs53 = errors;

                                        if (typeof data25.inverted !== "boolean") {
                                          validate10.errors = [{
                                            instancePath: instancePath + "/filters/whitelist/inverted",
                                            schemaPath: "#/properties/filters/properties/whitelist/properties/inverted/type",
                                            keyword: "type",
                                            params: {
                                              type: "boolean"
                                            },
                                            message: "must be boolean"
                                          }];
                                          return false;
                                        }

                                        var valid7 = _errs53 === errors;
                                      } else {
                                        var valid7 = true;
                                      }

                                      if (valid7) {
                                        if (data25.domains !== undefined) {
                                          let data27 = data25.domains;
                                          const _errs55 = errors;

                                          if (errors === _errs55) {
                                            if (Array.isArray(data27)) {
                                              var valid8 = true;
                                              const len2 = data27.length;

                                              for (let i2 = 0; i2 < len2; i2++) {
                                                const _errs57 = errors;

                                                if (typeof data27[i2] !== "string") {
                                                  validate10.errors = [{
                                                    instancePath: instancePath + "/filters/whitelist/domains/" + i2,
                                                    schemaPath: "#/properties/filters/properties/whitelist/properties/domains/items/type",
                                                    keyword: "type",
                                                    params: {
                                                      type: "string"
                                                    },
                                                    message: "must be string"
                                                  }];
                                                  return false;
                                                }

                                                var valid8 = _errs57 === errors;

                                                if (!valid8) {
                                                  break;
                                                }
                                              }
                                            } else {
                                              validate10.errors = [{
                                                instancePath: instancePath + "/filters/whitelist/domains",
                                                schemaPath: "#/properties/filters/properties/whitelist/properties/domains/type",
                                                keyword: "type",
                                                params: {
                                                  type: "array"
                                                },
                                                message: "must be array"
                                              }];
                                              return false;
                                            }
                                          }

                                          var valid7 = _errs55 === errors;
                                        } else {
                                          var valid7 = true;
                                        }

                                        if (valid7) {
                                          if (data25["inverted-domains"] !== undefined) {
                                            let data29 = data25["inverted-domains"];
                                            const _errs59 = errors;

                                            if (errors === _errs59) {
                                              if (Array.isArray(data29)) {
                                                var valid9 = true;
                                                const len3 = data29.length;

                                                for (let i3 = 0; i3 < len3; i3++) {
                                                  const _errs61 = errors;

                                                  if (typeof data29[i3] !== "string") {
                                                    validate10.errors = [{
                                                      instancePath: instancePath + "/filters/whitelist/inverted-domains/" + i3,
                                                      schemaPath: "#/properties/filters/properties/whitelist/properties/inverted-domains/items/type",
                                                      keyword: "type",
                                                      params: {
                                                        type: "string"
                                                      },
                                                      message: "must be string"
                                                    }];
                                                    return false;
                                                  }

                                                  var valid9 = _errs61 === errors;

                                                  if (!valid9) {
                                                    break;
                                                  }
                                                }
                                              } else {
                                                validate10.errors = [{
                                                  instancePath: instancePath + "/filters/whitelist/inverted-domains",
                                                  schemaPath: "#/properties/filters/properties/whitelist/properties/inverted-domains/type",
                                                  keyword: "type",
                                                  params: {
                                                    type: "array"
                                                  },
                                                  message: "must be array"
                                                }];
                                                return false;
                                              }
                                            }

                                            var valid7 = _errs59 === errors;
                                          } else {
                                            var valid7 = true;
                                          }

                                          if (valid7) {
                                            if (data25.enabled !== undefined) {
                                              const _errs63 = errors;

                                              if (typeof data25.enabled !== "boolean") {
                                                validate10.errors = [{
                                                  instancePath: instancePath + "/filters/whitelist/enabled",
                                                  schemaPath: "#/properties/filters/properties/whitelist/properties/enabled/type",
                                                  keyword: "type",
                                                  params: {
                                                    type: "boolean"
                                                  },
                                                  message: "must be boolean"
                                                }];
                                                return false;
                                              }

                                              var valid7 = _errs63 === errors;
                                            } else {
                                              var valid7 = true;
                                            }
                                          }
                                        }
                                      }
                                    }
                                  } else {
                                    validate10.errors = [{
                                      instancePath: instancePath + "/filters/whitelist",
                                      schemaPath: "#/properties/filters/properties/whitelist/type",
                                      keyword: "type",
                                      params: {
                                        type: "object"
                                      },
                                      message: "must be object"
                                    }];
                                    return false;
                                  }
                                }

                                var valid3 = _errs51 === errors;
                              } else {
                                var valid3 = true;
                              }
                            }
                          }
                        }
                      }
                    }
                  } else {
                    validate10.errors = [{
                      instancePath: instancePath + "/filters",
                      schemaPath: "#/properties/filters/type",
                      keyword: "type",
                      params: {
                        type: "object"
                      },
                      message: "must be object"
                    }];
                    return false;
                  }
                }

                var valid0 = _errs31 === errors;
              } else {
                var valid0 = true;
              }

              if (valid0) {
                if (data.stealth !== undefined) {
                  let data32 = data.stealth;
                  const _errs65 = errors;

                  if (errors === _errs65) {
                    if (data32 && typeof data32 == "object" && !Array.isArray(data32)) {
                      let missing6;

                      if (data32.stealth_disable_stealth_mode === undefined && (missing6 = "stealth_disable_stealth_mode") || data32["stealth-hide-referrer"] === undefined && (missing6 = "stealth-hide-referrer") || data32["stealth-hide-search-queries"] === undefined && (missing6 = "stealth-hide-search-queries") || data32["stealth-send-do-not-track"] === undefined && (missing6 = "stealth-send-do-not-track") || data32["stealth-block-webrtc"] === undefined && (missing6 = "stealth-block-webrtc") || data32["stealth-block-third-party-cookies"] === undefined && (missing6 = "stealth-block-third-party-cookies") || data32["stealth-block-first-party-cookies"] === undefined && (missing6 = "stealth-block-first-party-cookies") || data32["strip-tracking-parameters"] === undefined && (missing6 = "strip-tracking-parameters")) {
                        validate10.errors = [{
                          instancePath: instancePath + "/stealth",
                          schemaPath: "#/properties/stealth/required",
                          keyword: "required",
                          params: {
                            missingProperty: missing6
                          },
                          message: "must have required property '" + missing6 + "'"
                        }];
                        return false;
                      } else {
                        if (data32.stealth_disable_stealth_mode !== undefined) {
                          const _errs67 = errors;

                          if (typeof data32.stealth_disable_stealth_mode !== "boolean") {
                            validate10.errors = [{
                              instancePath: instancePath + "/stealth/stealth_disable_stealth_mode",
                              schemaPath: "#/properties/stealth/properties/stealth_disable_stealth_mode/type",
                              keyword: "type",
                              params: {
                                type: "boolean"
                              },
                              message: "must be boolean"
                            }];
                            return false;
                          }

                          var valid10 = _errs67 === errors;
                        } else {
                          var valid10 = true;
                        }

                        if (valid10) {
                          if (data32["stealth-hide-referrer"] !== undefined) {
                            const _errs69 = errors;

                            if (typeof data32["stealth-hide-referrer"] !== "boolean") {
                              validate10.errors = [{
                                instancePath: instancePath + "/stealth/stealth-hide-referrer",
                                schemaPath: "#/properties/stealth/properties/stealth-hide-referrer/type",
                                keyword: "type",
                                params: {
                                  type: "boolean"
                                },
                                message: "must be boolean"
                              }];
                              return false;
                            }

                            var valid10 = _errs69 === errors;
                          } else {
                            var valid10 = true;
                          }

                          if (valid10) {
                            if (data32["stealth-hide-search-queries"] !== undefined) {
                              const _errs71 = errors;

                              if (typeof data32["stealth-hide-search-queries"] !== "boolean") {
                                validate10.errors = [{
                                  instancePath: instancePath + "/stealth/stealth-hide-search-queries",
                                  schemaPath: "#/properties/stealth/properties/stealth-hide-search-queries/type",
                                  keyword: "type",
                                  params: {
                                    type: "boolean"
                                  },
                                  message: "must be boolean"
                                }];
                                return false;
                              }

                              var valid10 = _errs71 === errors;
                            } else {
                              var valid10 = true;
                            }

                            if (valid10) {
                              if (data32["stealth-send-do-not-track"] !== undefined) {
                                const _errs73 = errors;

                                if (typeof data32["stealth-send-do-not-track"] !== "boolean") {
                                  validate10.errors = [{
                                    instancePath: instancePath + "/stealth/stealth-send-do-not-track",
                                    schemaPath: "#/properties/stealth/properties/stealth-send-do-not-track/type",
                                    keyword: "type",
                                    params: {
                                      type: "boolean"
                                    },
                                    message: "must be boolean"
                                  }];
                                  return false;
                                }

                                var valid10 = _errs73 === errors;
                              } else {
                                var valid10 = true;
                              }

                              if (valid10) {
                                if (data32["stealth-block-webrtc"] !== undefined) {
                                  const _errs75 = errors;

                                  if (typeof data32["stealth-block-webrtc"] !== "boolean") {
                                    validate10.errors = [{
                                      instancePath: instancePath + "/stealth/stealth-block-webrtc",
                                      schemaPath: "#/properties/stealth/properties/stealth-block-webrtc/type",
                                      keyword: "type",
                                      params: {
                                        type: "boolean"
                                      },
                                      message: "must be boolean"
                                    }];
                                    return false;
                                  }

                                  var valid10 = _errs75 === errors;
                                } else {
                                  var valid10 = true;
                                }

                                if (valid10) {
                                  if (data32["stealth-block-third-party-cookies"] !== undefined) {
                                    const _errs77 = errors;

                                    if (typeof data32["stealth-block-third-party-cookies"] !== "boolean") {
                                      validate10.errors = [{
                                        instancePath: instancePath + "/stealth/stealth-block-third-party-cookies",
                                        schemaPath: "#/properties/stealth/properties/stealth-block-third-party-cookies/type",
                                        keyword: "type",
                                        params: {
                                          type: "boolean"
                                        },
                                        message: "must be boolean"
                                      }];
                                      return false;
                                    }

                                    var valid10 = _errs77 === errors;
                                  } else {
                                    var valid10 = true;
                                  }

                                  if (valid10) {
                                    if (data32["stealth-block-first-party-cookies"] !== undefined) {
                                      const _errs79 = errors;

                                      if (typeof data32["stealth-block-first-party-cookies"] !== "boolean") {
                                        validate10.errors = [{
                                          instancePath: instancePath + "/stealth/stealth-block-first-party-cookies",
                                          schemaPath: "#/properties/stealth/properties/stealth-block-first-party-cookies/type",
                                          keyword: "type",
                                          params: {
                                            type: "boolean"
                                          },
                                          message: "must be boolean"
                                        }];
                                        return false;
                                      }

                                      var valid10 = _errs79 === errors;
                                    } else {
                                      var valid10 = true;
                                    }

                                    if (valid10) {
                                      if (data32["block-known-trackers"] !== undefined) {
                                        const _errs81 = errors;

                                        if (typeof data32["block-known-trackers"] !== "boolean") {
                                          validate10.errors = [{
                                            instancePath: instancePath + "/stealth/block-known-trackers",
                                            schemaPath: "#/properties/stealth/properties/block-known-trackers/type",
                                            keyword: "type",
                                            params: {
                                              type: "boolean"
                                            },
                                            message: "must be boolean"
                                          }];
                                          return false;
                                        }

                                        var valid10 = _errs81 === errors;
                                      } else {
                                        var valid10 = true;
                                      }

                                      if (valid10) {
                                        if (data32["strip-tracking-parameters"] !== undefined) {
                                          const _errs83 = errors;

                                          if (typeof data32["strip-tracking-parameters"] !== "boolean") {
                                            validate10.errors = [{
                                              instancePath: instancePath + "/stealth/strip-tracking-parameters",
                                              schemaPath: "#/properties/stealth/properties/strip-tracking-parameters/type",
                                              keyword: "type",
                                              params: {
                                                type: "boolean"
                                              },
                                              message: "must be boolean"
                                            }];
                                            return false;
                                          }

                                          var valid10 = _errs83 === errors;
                                        } else {
                                          var valid10 = true;
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    } else {
                      validate10.errors = [{
                        instancePath: instancePath + "/stealth",
                        schemaPath: "#/properties/stealth/type",
                        keyword: "type",
                        params: {
                          type: "object"
                        },
                        message: "must be object"
                      }];
                      return false;
                    }
                  }

                  var valid0 = _errs65 === errors;
                } else {
                  var valid0 = true;
                }
              }
            }
          }
        }
      }
    } else {
      validate10.errors = [{
        instancePath,
        schemaPath: "#/type",
        keyword: "type",
        params: {
          type: "object"
        },
        message: "must be object"
      }];
      return false;
    }
  }

  validate10.errors = vErrors;
  return errors === 0;
}

/***/ }),

/***/ 73800:
/***/ ((module) => {

/**
 * This file is part of Adguard Browser Extension (https://github.com/AdguardTeam/AdguardBrowserExtension).
 *
 * Adguard Browser Extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Adguard Browser Extension is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Adguard Browser Extension.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * As it is not possible to use one library in node and browser environments,
 * we have to implementation of simple file download interface.
 * The one for node uses axios, the one for browser XMLHttpRequest.
 *
 * @type {{getLocalFile, getExternalFile}}
 */
module.exports = (() => {
    'use strict';

    /**
     * If url protocol is not http or https return true, else false
     * @param url
     * @returns {boolean}
     */
    const isLocal = (url) => {
        const parsedUrl = new URL(url);
        const protocols = ['http:', 'https:'];
        return !protocols.includes(parsedUrl.protocol);
    };

    /**
     * Executes async request via fetch
     * fetch doesn't allow to download urls with file:// scheme
     *
     * @param url Url
     * @param contentType Content type
     * @returns {Promise}
     */
    const executeRequestAsyncFetch = async (url, contentType) => {
        const response = await fetch(url, {
            cache: 'no-cache',
            headers: {
                Pragma: 'no-cache',
                'Content-Type': contentType,
            }
        });

        if (response.status !== 200 && response.status !== 0) {
            throw new Error(`Response status for url ${url} is invalid: ${response.status}`);
        }

        // Don't check response headers if url is local,
        // because edge extension doesn't provide headers for such url
        if (!isLocal(response.url)) {
            const responseContentType = response.headers.get('Content-Type');
            if (!responseContentType || !responseContentType.includes(contentType)) {
                throw new Error(`Response content type should be: "${contentType}"`);
            }
        }

        const responseText = await response.text();

        return responseText.trim().split(/[\r\n]+/);
    };

    /**
     * Executes async request via XMLHttpRequest
     * XMLHttpRequest is undefined in the service worker
     *
     * @param {string} url Url
     * @param {string} contentType Content type
     * @returns {Promise}
     */
    const executeRequestAsyncXhr = (url, contentType) => {
        return new Promise((resolve, reject) => {
            const onRequestLoad = (response) => {
                if (response.status !== 200 && response.status !== 0) {
                    reject(new Error(`Response status for url ${url} is invalid: ${response.status}`));
                }

                const responseText = response.responseText ? response.responseText : response.data;

                // Don't check response headers if url is local,
                // because edge extension doesn't provide headers for such url
                if (!isLocal(response.responseURL)) {
                    const responseContentType = response.getResponseHeader('Content-Type');
                    if (!responseContentType || !responseContentType.includes(contentType)) {
                        reject(new Error(`Response content type should be: "${contentType}"`));
                    }
                }
                const lines = responseText.trim().split(/[\r\n]+/);
                resolve(lines);
            };

            const request = new XMLHttpRequest();

            try {
                request.open('GET', url);
                request.setRequestHeader('Pragma', 'no-cache');
                request.overrideMimeType(contentType);
                request.mozBackgroundRequest = true;
                request.onload = function () {
                    onRequestLoad(request);
                };
                request.onerror = () => reject(new Error(`Request error happened: ${request.statusText || 'status text empty'}`));
                request.onabort = () => reject(new Error(`Request was aborted with status text: ${request.statusText}`));
                request.ontimeout = () => reject(new Error(`Request timed out with status text: ${request.statusText}`));

                request.send(null);
            } catch (ex) {
                reject(ex);
            }
        });
    };

    /**
     * Downloads filter rules from external url
     *
     * @param {string} url Filter file absolute URL or relative path
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const getExternalFile = (url) => {
        return executeRequestAsyncFetch(url, 'text/plain');
    };

    /**
     * Get filter rules from local path
     *
     * @param {string} url local path
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const getLocalFile = (url) => {
        if (typeof XMLHttpRequest !== 'undefined') {
            return executeRequestAsyncXhr(url, 'text/plain');
        }
        if (typeof fetch !== 'undefined') {
            return executeRequestAsyncFetch(url, 'text/plain');
        }
        throw new Error('XMLHttpRequest or fetch are undefined, getting local files inside service worker is not working');
    };

    return {
        getLocalFile: getLocalFile,
        getExternalFile: getExternalFile,
    };
})();


/***/ }),

/***/ 70652:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * This file is part of Adguard Browser Extension (https://github.com/AdguardTeam/AdguardBrowserExtension).
 *
 * Adguard Browser Extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Adguard Browser Extension is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Adguard Browser Extension.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * The utility tool resolves preprocessor directives in filter content.
 *
 * Directives syntax:
 * !#if, !#endif - filters maintainers can use these conditions to supply different rules depending on the ad blocker type.
 * condition - just like in some popular programming languages, pre-processor conditions are based on constants declared by ad blockers. Ad blocker authors define on their own what exact constants do they declare.
 * !#include - this directive allows to include contents of a specified file into the filter.
 *
 * Condition constants should be declared in FilterCompilerConditionsConstants
 *
 * More details:
 * https://github.com/AdguardTeam/AdguardBrowserExtension/issues/917
 */
const FiltersDownloaderCreator = (FileDownloadWrapper) => {
    "use strict";

    const CONDITION_DIRECTIVE_START = "!#if";
    const CONDITION_DIRECTIVE_END = "!#endif";

    const CONDITION_OPERATOR_NOT = "!";
    const CONDITION_OPERATOR_AND = "&&";
    const CONDITION_OPERATOR_OR = "||";
    const CONDITION_BRACKET_OPEN_CHAR = "(";
    const CONDITION_BRACKET_CLOSE_CHAR = ")";

    const INCLUDE_DIRECTIVE = "!#include";

    const REGEXP_ABSOLUTE_URL = /^([a-z]+:\/\/|\/\/)/i;
    const REGEXP_EXTERNAL_ABSOLUTE_URL = /^((?!file)[a-z]+:\/\/|\/\/)/i;

    /**
     * Checks brackets in string
     *
     * @param str
     */
    const checkBracketsBalance = (str) => {
        let depth = 0;
        for (let i in str) {
            if (str[i] === CONDITION_BRACKET_OPEN_CHAR) {
                // if the char is an opening parenthesis then we increase the depth
                depth++;
            } else if (str[i] === CONDITION_BRACKET_CLOSE_CHAR) {
                // if the char is an closing parenthesis then we decrease the depth
                depth--;
            }
            //  if the depth is negative we have a closing parenthesis
            //  before any matching opening parenthesis
            if (depth < 0) {
                return false;
            }
        }
        // If the depth is not null then a closing parenthesis is missing
        if (depth > 0) {
            return false;
        }

        return true;
    };

    /**
     * Finds end of condition block started with startIndex
     *
     * @param rules
     * @param startIndex
     */
    const findConditionEnd = (rules, startIndex) => {
        const stack = [];
        for (let j = startIndex; j < rules.length; j++) {
            let internalRule = rules[j];

            if (internalRule.startsWith(CONDITION_DIRECTIVE_START)) {
                stack.push(CONDITION_DIRECTIVE_START);

            } else if (internalRule.startsWith(CONDITION_DIRECTIVE_END)) {
                if (stack.length > 0) {
                    stack.pop();
                } else {
                    return j;
                }
            }
        }

        return -1;
    };

    /**
     * Resolves constant expression
     *
     * @param expression
     * @param definedProperties
     */
    const resolveConditionConstant = (expression, definedProperties) => {
        if (!expression) {
            throw new Error('Invalid directives: Empty condition');
        }

        let trim = expression.trim();
        return trim === "true" || definedProperties[trim];
    };

    /**
     * Calculates conditional expression
     *
     * @param expression
     * @param definedProperties
     */
    const resolveExpression = (expression, definedProperties) => {
        if (!expression) {
            throw new Error('Invalid directives: Empty condition');
        }

        expression = expression.trim();

        if (!checkBracketsBalance(expression)) {
            throw new Error('Invalid directives: Incorrect brackets: ' + expression);
        }

        //Replace bracketed expressions
        const openBracketIndex = expression.lastIndexOf(CONDITION_BRACKET_OPEN_CHAR);
        if (openBracketIndex !== -1) {
            const endBracketIndex = expression.indexOf(CONDITION_BRACKET_CLOSE_CHAR, openBracketIndex);
            const innerExpression = expression.substring(openBracketIndex + 1, endBracketIndex);
            const innerResult = resolveExpression(innerExpression, definedProperties);
            const resolvedInner = expression.substring(0, openBracketIndex) +
                innerResult + expression.substring(endBracketIndex + 1);

            return resolveExpression(resolvedInner, definedProperties);
        }

        let result;

        // Resolve logical operators
        const indexOfAndOperator = expression.indexOf(CONDITION_OPERATOR_AND);
        const indexOfOrOperator = expression.indexOf(CONDITION_OPERATOR_OR);
        const indexOfNotOperator = expression.indexOf(CONDITION_OPERATOR_NOT);

        if (indexOfOrOperator !== -1) {
            result = resolveExpression(expression.substring(0, indexOfOrOperator - 1), definedProperties) ||
                resolveExpression(expression.substring(indexOfOrOperator + CONDITION_OPERATOR_OR.length, expression.length), definedProperties);
        } else if (indexOfAndOperator !== -1) {
            result = resolveExpression(expression.substring(0, indexOfAndOperator - 1), definedProperties) &&
                resolveExpression(expression.substring(indexOfAndOperator + CONDITION_OPERATOR_AND.length, expression.length), definedProperties);
        } else if (indexOfNotOperator === 0) {
            result = !resolveExpression(expression.substring(CONDITION_OPERATOR_NOT.length), definedProperties);
        } else {
            result = resolveConditionConstant(expression, definedProperties);
        }

        return result;
    };

    /**
     * Validates and resolves condition directive
     *
     * @param directive
     * @param definedProperties
     */
    const resolveCondition = (directive, definedProperties) => {
        const expression = directive.substring(CONDITION_DIRECTIVE_START.length).trim();

        return resolveExpression(expression, definedProperties);
    };

    /**
     * Resolves conditions directives
     *
     * @param rules
     * @param definedProperties
     */
    const resolveConditions = (rules, definedProperties) => {
        if (!definedProperties) {
            return rules;
        }

        let result = [];

        for (let i = 0; i < rules.length; i++) {
            let rule = rules[i];

            if (rule.indexOf(CONDITION_DIRECTIVE_START) === 0) {
                let endLineIndex = findConditionEnd(rules, i + 1);
                if (endLineIndex === -1) {
                    throw new Error('Invalid directives: Condition end not found: ' + rule);
                }

                let conditionValue = resolveCondition(rule, definedProperties);
                if (conditionValue) {
                    let rulesUnderCondition = rules.slice(i + 1, endLineIndex);
                    // Resolve inner conditions in recursion
                    result = result.concat(resolveConditions(rulesUnderCondition, definedProperties));
                }

                // Skip to the end of block
                i = endLineIndex;
            } else if (rule.indexOf(CONDITION_DIRECTIVE_END) === 0) {
                // Found condition end without start
                throw new Error('Invalid directives: Found unexpected condition end: ' + rule);
            } else {
                result.push(rule);
            }
        }

        return result;
    };

    /**
     * Validates url to be the same origin with original filterUrl
     *
     * @param url
     * @param filterUrlOrigin
     */
    const validateUrl = function (url, filterUrlOrigin) {
        if (filterUrlOrigin) {
            if (REGEXP_ABSOLUTE_URL.test(url)) {

                // Include url is absolute
                const urlOrigin = parseURL(url).origin;
                const filterOrigin = parseURL(filterUrlOrigin).origin;
                if (urlOrigin !== filterOrigin) {
                    throw new Error('Include url is rejected with origin: ' + urlOrigin);
                }
            }
        }
    };

    /**
     * Validates and resolves include directive
     *
     * @param {string} line
     * @param {?string} filterOrigin Filter file URL origin or null
     * @param {?object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const resolveInclude = function (line, filterOrigin, definedProperties) {
        if (line.indexOf(INCLUDE_DIRECTIVE) !== 0) {
            return Promise.resolve(line);
        } else {
            const url = line.substring(INCLUDE_DIRECTIVE.length).trim();
            validateUrl(url, filterOrigin);
            return downloadFilterRules(url, filterOrigin, definedProperties);
        }
    };

    /**
     * Resolves include directives
     *
     * @param {Array} rules   array of rules
     * @param {?string} filterOrigin Filter file URL origin or null
     * @param {?object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const resolveIncludes = (rules, filterOrigin, definedProperties) => {
        const dfds = [];

        for (let rule of rules) {
            dfds.push(resolveInclude(rule, filterOrigin, definedProperties));
        }

        return Promise.all(dfds).then((values) => {
            let result = [];

            values.forEach(function (v) {
                if (Array.isArray(v)) {
                    result = result.concat(v);
                } else {
                    result.push(v);
                }
            });

            return result;
        });
    };

    /**
     * Compiles filter content
     *
     * @param {Array} rules Array of strings
     * @param {?string} filterUrlOrigin Filter file URL origin or null
     * @param {?object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const compile = (rules, filterOrigin, definedProperties) => {
        try {
            // Resolve 'if' conditions
            const resolvedConditionsResult = resolveConditions(rules, definedProperties);

            // Resolve 'includes' directives
            return resolveIncludes(resolvedConditionsResult, filterOrigin, definedProperties);
        } catch (ex) {
            return Promise.reject(ex);
        }
    };

    /**
     * Downloads filter rules from url
     *
     * @param {string} url Filter file URL
     * @param {?string} filterUrlOrigin Filter file URL origin or null
     * @param {?object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const downloadFilterRules = (url, filterUrlOrigin, definedProperties) => {
        if (REGEXP_EXTERNAL_ABSOLUTE_URL.test(url) || REGEXP_EXTERNAL_ABSOLUTE_URL.test(filterUrlOrigin)) {
            return externalDownload(url, filterUrlOrigin, definedProperties);
        } else {
            return getLocalFile(url, filterUrlOrigin, definedProperties);
        }
    };

    /**
     * Downloads filter rules from external url
     *
     * @param {string} url Filter file absolute URL or relative path
     * @param {?string} filterUrlOrigin Filter file URL origin or null
     * @param {?object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const externalDownload = (url, filterUrlOrigin, definedProperties) => {

        // getting absolute url for external file with relative url
        if (!REGEXP_ABSOLUTE_URL.test(url) && REGEXP_ABSOLUTE_URL.test(filterUrlOrigin)) {
            url = `${filterUrlOrigin}/${url}`;
        }

        return FileDownloadWrapper.getExternalFile(url, filterUrlOrigin, definedProperties).then((lines) => {
            // Filter origin could change in case url contains subdirectories
            // https://github.com/AdguardTeam/FiltersRegistry/pull/256
            filterUrlOrigin = getFilterUrlOrigin(url, null);

            // Resolve 'if' conditions and 'includes' directives
            const resolvedConditionsResult = resolveConditions(lines, definedProperties);
            return resolveIncludes(resolvedConditionsResult, filterUrlOrigin, definedProperties);
        });
    };

    /**
     * Get filter rules from local path
     *
     * @param {string} url local path
     * @param {?string} filterUrlOrigin origin path
     * @param {?object} definedProperties An object with the defined properties
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const getLocalFile = (url, filterUrlOrigin, definedProperties) => {
        if (filterUrlOrigin) {
            url = `${filterUrlOrigin}/${url}`;
        }

        filterUrlOrigin = getFilterUrlOrigin(url, filterUrlOrigin);

        return FileDownloadWrapper.getLocalFile(url, filterUrlOrigin, definedProperties).then((lines) => {
            filterUrlOrigin = getFilterUrlOrigin(url, null);

            // Resolve 'if' conditions and 'includes' directives
            const resolvedConditionsResult = resolveConditions(lines, definedProperties);
            return resolveIncludes(resolvedConditionsResult, filterUrlOrigin, definedProperties);
        });
    };

    /**
     * Get the `filterUrlOrigin` from url for relative path resolve
     *
     * @param {string} url Filter file URL
     * @param {string|null} filterUrlOrigin  existing origin url
     * @returns {string} valid origin url
     */
    const getFilterUrlOrigin = (url, filterUrlOrigin) => {
        if (filterUrlOrigin) {
            return filterUrlOrigin;
        } else {
            return url.substring(0, url.lastIndexOf('/'));
        }
    };

    /**
     * Downloads a specified filter and interpretes all the pre-processor directives from there.
     *
     * @param {string} url Filter file URL
     * @param {Object} definedProperties An object with the defined properties. These properties might be used in pre-processor directives (`#if`, etc)
     * @returns {Promise} A promise that returns {string} with rules when if resolved and {Error} if rejected.
     */
    const download = async (url, definedProperties) => {
        try {
            let filterUrlOrigin;
            if (url && REGEXP_EXTERNAL_ABSOLUTE_URL.test(url)) {
                filterUrlOrigin = getFilterUrlOrigin(url)
            }

            const response = await downloadFilterRules(url, filterUrlOrigin, definedProperties);

            // only included filters can be empty
            if (response && response.join().trim() == '') {
                throw new Error("Response is empty");
            }

            return response;
        } catch (ex) {
            return Promise.reject(ex);
        }
    };

    /**
     * Parse url
     *
     * @param {string} url
     * @returns {object}  parsed url data
     */
    const parseURL = (url) => {
        if (typeof URL !== 'undefined') {
            return new URL(url);
        } else {
            let URL = (__webpack_require__(83548).URL);
            return new URL(url);
        }
    };

    return {
        compile: compile,
        download: download,
        resolveConditions: resolveConditions,
        resolveIncludes: resolveIncludes,
        getFilterUrlOrigin: getFilterUrlOrigin
    };
};

module.exports = FiltersDownloaderCreator;


/***/ }),

/***/ 39317:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// This file replaces `index.js` in bundlers like webpack or Rollup,
// according to `browser` config in `package.json`.

const filtersDownloaderCreator = __webpack_require__(70652);
const FileDownloadWrapper = __webpack_require__(73800);

const FiltersDownloader = filtersDownloaderCreator(FileDownloadWrapper);

module.exports = FiltersDownloader;


/***/ }),

/***/ 68782:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;
/**
 * AdGuard Scriptlets
 * Version 1.6.55
 */

(function (factory) {
     true ? !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) :
    0;
})((function () {
    /**
     * Concat dependencies to scriptlet code
     * @param {string} scriptlet string view of scriptlet
     */
    function attachDependencies(scriptlet) {
      var _scriptlet$injections = scriptlet.injections,
          injections = _scriptlet$injections === void 0 ? [] : _scriptlet$injections;
      return injections.reduce(function (accum, dep) {
        return "".concat(accum, "\n").concat(dep.toString());
      }, scriptlet.toString());
    }
    /**
     * Add scriptlet call to existing code
     * @param {Function} scriptlet
     * @param {string} code
     */

    function addCall(scriptlet, code) {
      return "".concat(code, "\n    const updatedArgs = args ? [].concat(source).concat(args) : [source];\n    try {\n        ").concat(scriptlet.name, ".apply(this, updatedArgs);\n    } catch (e) {\n        console.log(e);\n    }");
    }
    /**
     * Wrap function into IIFE (Immediately invoked function expression)
     *
     * @param {Source} source - object with scriptlet properties
     * @param {string} code - scriptlet source code with dependencies
     *
     * @param redirect
     * @returns {string} full scriptlet code
     *
     * @example
     * const source = {
     *      args: ["aaa", "bbb"],
     *      name: 'noeval',
     * };
     * const code = "function noeval(source, args) { alert(source); } noeval.apply(this, args);"
     * const result = wrapInIIFE(source, code);
     *
     * // result
     * `(function(source, args) {
     *      function noeval(source) { alert(source); }
     *      noeval.apply(this, args);
     * )({"args": ["aaa", "bbb"], "name":"noeval"}, ["aaa", "bbb"])`
     */

    function passSourceAndProps(source, code) {
      var redirect = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      if (source.hit) {
        source.hit = source.hit.toString();
      }

      var sourceString = JSON.stringify(source);
      var argsString = source.args ? "[".concat(source.args.map(JSON.stringify), "]") : undefined;
      var params = argsString ? "".concat(sourceString, ", ").concat(argsString) : sourceString;

      if (redirect) {
        return "(function(source, args){\n".concat(code, "\n})(").concat(params, ");");
      }

      return "(".concat(code, ")(").concat(params, ");");
    }
    /**
     * Wrap code in no name function
     * @param {string} code which must be wrapped
     */

    function wrapInNonameFunc(code) {
      return "function(source, args){\n".concat(code, "\n}");
    }

    /**
     * Determines whether the passed value is NaN
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isNaN
     * @param {*} num
     * @returns {boolean}
     */
    var nativeIsNaN = function nativeIsNaN(num) {
      // eslint-disable-next-line no-restricted-properties
      var native = Number.isNaN || window.isNaN;
      return native(num);
    };
    /**
     * Determines whether the passed value is a finite number
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isFinite
     * @param {*} num
     * @returns {boolean}
     */

    var nativeIsFinite = function nativeIsFinite(num) {
      // eslint-disable-next-line no-restricted-properties
      var native = Number.isFinite || window.isFinite;
      return native(num);
    };
    /**
     * Parses string for a number, if possible, otherwise returns null.
     * @param {*} rawString
     * @returns {number|null}
     */

    var getNumberFromString = function getNumberFromString(rawString) {
      var parsedDelay = parseInt(rawString, 10);
      var validDelay = nativeIsNaN(parsedDelay) ? null : parsedDelay;
      return validDelay;
    };

    /**
     * Converts object to array of pairs.
     * Object.entries() polyfill because it is not supported by IE
     * https://caniuse.com/?search=Object.entries
     * @param {Object} object
     * @returns {Array} array of pairs
     */
    var getObjectEntries = function getObjectEntries(object) {
      var keys = Object.keys(object);
      var entries = [];
      keys.forEach(function (key) {
        return entries.push([key, object[key]]);
      });
      return entries;
    };
    /**
     * Converts array of pairs to object.
     * Object.fromEntries() polyfill because it is not supported by IE
     * https://caniuse.com/?search=Object.fromEntries
     * @param {Array} entries - array of pairs
     * @returns {Object}
     */

    var getObjectFromEntries = function getObjectFromEntries(entries) {
      var output = entries.reduce(function (acc, el) {
        var key = el[0];
        var value = el[1];
        acc[key] = value;
        return acc;
      }, {});
      return output;
    };
    /**
     * Checks whether the obj is an empty object
     * @param {Object} obj
     * @returns {boolean}
     */

    var isEmptyObject = function isEmptyObject(obj) {
      return Object.keys(obj).length === 0;
    };
    /**
     * Checks whether the obj is an empty object
     * @param {Object} obj
     * @param {string} prop
     * @returns {Object|null}
     */

    var safeGetDescriptor = function safeGetDescriptor(obj, prop) {
      var descriptor = Object.getOwnPropertyDescriptor(obj, prop);

      if (descriptor && descriptor.configurable) {
        return descriptor;
      }

      return null;
    };

    /**
     * String.prototype.replaceAll polyfill
     * @param {string} input input string
     * @param {string} substr to look for
     * @param {string} newSubstr replacement
     * @returns {string}
     */

    var replaceAll = function replaceAll(input, substr, newSubstr) {
      return input.split(substr).join(newSubstr);
    };
    /**
     * Escapes special chars in string
     * @param {string} str
     * @returns {string}
     */

    var escapeRegExp = function escapeRegExp(str) {
      return str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    };
    /**
     * A literal string or regexp pattern wrapped in forward slashes.
     * For example, 'simpleStr' or '/adblock|_0x/'.
     * @typedef {string} RawStrPattern
     */

    /**
     * Converts string to the regexp
     * TODO think about nested dependencies, but be careful with dependency loops
     * @param {RawStrPattern} [input=''] literal string or regexp pattern; defaults to '' (empty string)
     * @returns {RegExp} regular expression; defaults to /.?/
     * @throws {SyntaxError} Throw an error for invalid regex pattern
     */

    var toRegExp = function toRegExp() {
      var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var DEFAULT_VALUE = '.?';
      var FORWARD_SLASH = '/';

      if (input === '') {
        return new RegExp(DEFAULT_VALUE);
      }

      if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
        return new RegExp(input.slice(1, -1));
      }

      var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
      return new RegExp(escaped);
    };
    /**
     * Checks whether the input string can be converted to regexp
     * @param {RawStrPattern} input literal string or regexp pattern
     * @returns {boolean}
     */

    var isValidStrPattern = function isValidStrPattern(input) {
      var FORWARD_SLASH = '/';
      var str = escapeRegExp(input);

      if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
        str = input.slice(1, -1);
      }

      var isValid;

      try {
        isValid = new RegExp(str);
        isValid = true;
      } catch (e) {
        isValid = false;
      }

      return isValid;
    };
    /**
     * Get string before regexp first match
     * @param {string} str
     * @param {RegExp} rx
     */

    var getBeforeRegExp = function getBeforeRegExp(str, rx) {
      var index = str.search(rx);
      return str.substring(0, index);
    };
    /**
     * Checks whether the string starts with the substring
     * @param {string} str full string
     * @param {string} prefix substring
     * @returns {boolean}
     */

    var startsWith = function startsWith(str, prefix) {
      // if str === '', (str && false) will return ''
      // that's why it has to be !!str
      return !!str && str.indexOf(prefix) === 0;
    };
    /**
     * Checks whether the string ends with the substring
     * @param {string} str full string
     * @param {string} ending substring
     * @returns {boolean}
     */

    var endsWith = function endsWith(str, ending) {
      // if str === '', (str && false) will return ''
      // that's why it has to be !!str
      return !!str && str.indexOf(ending) === str.length - ending.length;
    };
    var substringAfter$1 = function substringAfter(str, separator) {
      if (!str) {
        return str;
      }

      var index = str.indexOf(separator);
      return index < 0 ? '' : str.substring(index + separator.length);
    };
    var substringBefore = function substringBefore(str, separator) {
      if (!str || !separator) {
        return str;
      }

      var index = str.indexOf(separator);
      return index < 0 ? str : str.substring(0, index);
    };
    /**
     * Wrap str in single quotes and replaces single quotes to double one
     * @param {string} str
     */

    var wrapInSingleQuotes = function wrapInSingleQuotes(str) {
      if (str[0] === '\'' && str[str.length - 1] === '\'' || str[0] === '"' && str[str.length - 1] === '"') {
        str = str.substring(1, str.length - 1);
      } // eslint-disable-next-line no-useless-escape


      str = str.replace(/\'/g, '"');
      return "'".concat(str, "'");
    };
    /**
     * Returns substring enclosed in the widest braces
     * @param {string} str
     */

    var getStringInBraces = function getStringInBraces(str) {
      var firstIndex = str.indexOf('(');
      var lastIndex = str.lastIndexOf(')');
      return str.substring(firstIndex + 1, lastIndex);
    };
    /**
     * Prepares RTCPeerConnection config as string for proper logging
     * @param {*} config
     * @returns {string} stringified config
    */

    var convertRtcConfigToString = function convertRtcConfigToString(config) {
      var UNDEF_STR = 'undefined';
      var str = UNDEF_STR;

      if (config === null) {
        str = 'null';
      } else if (config instanceof Object) {
        var SERVERS_PROP_NAME = 'iceServers';
        var URLS_PROP_NAME = 'urls';
        /*
            const exampleConfig = {
                'iceServers': [
                    'urls': ['stun:35.66.206.188:443'],
                ],
            };
        */

        if (Object.prototype.hasOwnProperty.call(config, SERVERS_PROP_NAME) && Object.prototype.hasOwnProperty.call(config[SERVERS_PROP_NAME][0], URLS_PROP_NAME) && !!config[SERVERS_PROP_NAME][0][URLS_PROP_NAME]) {
          str = config[SERVERS_PROP_NAME][0][URLS_PROP_NAME].toString();
        }
      }

      return str;
    };
    /**
     * Checks whether the match input string can be converted to regexp,
     * used for match inputs with possible negation
     * @param {string} match literal string or regexp pattern
     * @returns {boolean}
     */

    var isValidMatchStr = function isValidMatchStr(match) {
      var INVERT_MARKER = '!';
      var str = match;

      if (startsWith(match, INVERT_MARKER)) {
        str = match.slice(1);
      }

      return isValidStrPattern(str);
    };
    /**
     * Validates the match input number,
     * used for match inputs with possible negation
     * @param {string} match string of match number
     * @returns {boolean}
     */

    var isValidMatchNumber = function isValidMatchNumber(match) {
      var INVERT_MARKER = '!';
      var str = match;

      if (startsWith(match, INVERT_MARKER)) {
        str = match.slice(1);
      }

      var num = parseFloat(str);
      return !nativeIsNaN(num) && nativeIsFinite(num);
    };
    /**
     * @typedef {Object} MatchData
     * @property {boolean} isInvertedMatch
     * @property {RegExp} matchRegexp
     */

    /**
     * Parses match arg with possible negation for no matching.
     * Needed for prevent-setTimeout, prevent-setInterval,
     * prevent-requestAnimationFrame and prevent-window-open
     * @param {string} match
     * @returns {MatchData}
     */

    var parseMatchArg = function parseMatchArg(match) {
      var INVERT_MARKER = '!';
      var isInvertedMatch = startsWith(match, INVERT_MARKER);
      var matchValue = isInvertedMatch ? match.slice(1) : match;
      var matchRegexp = toRegExp(matchValue);
      return {
        isInvertedMatch: isInvertedMatch,
        matchRegexp: matchRegexp
      };
    };
    /**
     * @typedef {Object} DelayData
     * @property {boolean} isInvertedDelayMatch
     * @property {number|null} delayMatch
     */

    /**
     * Parses delay arg with possible negation for no matching.
     * Needed for prevent-setTimeout and prevent-setInterval
     * @param {string} delay
     * @returns {DelayData} `{ isInvertedDelayMatch, delayMatch }` where:
     * `isInvertedDelayMatch` is boolean,
     * `delayMatch` is number OR null for invalid `delay`
     */

    var parseDelayArg = function parseDelayArg(delay) {
      var INVERT_MARKER = '!';
      var isInvertedDelayMatch = startsWith(delay, INVERT_MARKER);
      var delayValue = isInvertedDelayMatch ? delay.slice(1) : delay;
      delayValue = parseInt(delayValue, 10);
      var delayMatch = nativeIsNaN(delayValue) ? null : delayValue;
      return {
        isInvertedDelayMatch: isInvertedDelayMatch,
        delayMatch: delayMatch
      };
    };
    /**
     * Converts object to string for logging
     * @param {Object} obj data object
     * @returns {string}
     */

    var objectToString = function objectToString(obj) {
      return isEmptyObject(obj) ? '{}' : getObjectEntries(obj).map(function (pair) {
        var key = pair[0];
        var value = pair[1];
        var recordValueStr = value;

        if (value instanceof Object) {
          recordValueStr = "{ ".concat(objectToString(value), " }");
        }

        return "".concat(key, ":\"").concat(recordValueStr, "\"");
      }).join(' ');
    };
    /**
     * Converts types into a string
     * @param {*} value
     * @returns {string}
     */

    var convertTypeToString = function convertTypeToString(value) {
      var output;

      if (typeof value === 'undefined') {
        output = 'undefined';
      } else if (typeof value === 'object') {
        if (value === null) {
          output = 'null';
        } else {
          output = objectToString(value);
        }
      } else {
        output = value.toString();
      }

      return output;
    };

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, {
          value: value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key] = value;
      }

      return obj;
    }

    var defineProperty = _defineProperty;

    /**
     * Iterate over iterable argument and evaluate current state with transitions
     * @param {string} init first transition name
     * @param {Array|Collection|string} iterable
     * @param {Object} transitions transtion functions
     * @param {any} args arguments which should be passed to transition functions
     */
    function iterateWithTransitions(iterable, transitions, init, args) {
      var state = init || Object.keys(transitions)[0];

      for (var i = 0; i < iterable.length; i += 1) {
        state = transitions[state](iterable, i, args);
      }

      return state;
    }
    /**
     * AdGuard scriptlet rule mask
     */


    var ADG_SCRIPTLET_MASK = '#//scriptlet';
    /**
     * Helper to accumulate an array of strings char by char
     */

    var wordSaver = function wordSaver() {
      var str = '';
      var strs = [];

      var saveSymb = function saveSymb(s) {
        str += s;
        return str;
      };

      var saveStr = function saveStr() {
        strs.push(str);
        str = '';
      };

      var getAll = function getAll() {
        return [].concat(strs);
      };

      return {
        saveSymb: saveSymb,
        saveStr: saveStr,
        getAll: getAll
      };
    };

    var substringAfter = function substringAfter(str, separator) {
      if (!str) {
        return str;
      }

      var index = str.indexOf(separator);
      return index < 0 ? '' : str.substring(index + separator.length);
    };
    /**
     * Parse and validate scriptlet rule
     * @param {*} ruleText
     * @returns {{name: string, args: Array<string>}}
     */


    var parseRule = function parseRule(ruleText) {
      var _transitions;

      ruleText = substringAfter(ruleText, ADG_SCRIPTLET_MASK);
      /**
       * Transition names
       */

      var TRANSITION = {
        OPENED: 'opened',
        PARAM: 'param',
        CLOSED: 'closed'
      };
      /**
       * Transition function: the current index position in start, end or between params
       * @param {string} rule
       * @param {number} index
       * @param {Object} Object
       * @property {Object} Object.sep contains prop symb with current separator char
       */

      var opened = function opened(rule, index, _ref) {
        var sep = _ref.sep;
        var char = rule[index];
        var transition;

        switch (char) {
          case ' ':
          case '(':
          case ',':
            {
              transition = TRANSITION.OPENED;
              break;
            }

          case '\'':
          case '"':
            {
              sep.symb = char;
              transition = TRANSITION.PARAM;
              break;
            }

          case ')':
            {
              transition = index === rule.length - 1 ? TRANSITION.CLOSED : TRANSITION.OPENED;
              break;
            }

          default:
            {
              throw new Error('The rule is not a scriptlet');
            }
        }

        return transition;
      };
      /**
       * Transition function: the current index position inside param
       * @param {string} rule
       * @param {number} index
       * @param {Object} Object
       * @property {Object} Object.sep contains prop `symb` with current separator char
       * @property {Object} Object.saver helper which allow to save strings by car by char
       */


      var param = function param(rule, index, _ref2) {
        var saver = _ref2.saver,
            sep = _ref2.sep;
        var char = rule[index];

        switch (char) {
          case '\'':
          case '"':
            {
              var preIndex = index - 1;
              var before = rule[preIndex];

              if (char === sep.symb && before !== '\\') {
                sep.symb = null;
                saver.saveStr();
                return TRANSITION.OPENED;
              }
            }
          // eslint-disable-next-line no-fallthrough

          default:
            {
              saver.saveSymb(char);
              return TRANSITION.PARAM;
            }
        }
      };

      var transitions = (_transitions = {}, defineProperty(_transitions, TRANSITION.OPENED, opened), defineProperty(_transitions, TRANSITION.PARAM, param), defineProperty(_transitions, TRANSITION.CLOSED, function () {}), _transitions);
      var sep = {
        symb: null
      };
      var saver = wordSaver();
      var state = iterateWithTransitions(ruleText, transitions, TRANSITION.OPENED, {
        sep: sep,
        saver: saver
      });

      if (state !== 'closed') {
        throw new Error("Invalid scriptlet rule ".concat(ruleText));
      }

      var args = saver.getAll();
      return {
        name: args[0],
        args: args.slice(1)
      };
    };

    /**
     * Returns wildcard symbol
     * @returns {string} '*'
     */
    var getWildcardSymbol = function getWildcardSymbol() {
      return '*';
    };

    /**
     * Generate random six symbols id
     */
    function randomId() {
      return Math.random().toString(36).substr(2, 9);
    }

    /**
     * Set getter and setter to property if it's configurable
     * @param {Object} object target object with property
     * @param {string} property property name
     * @param {Object} descriptor contains getter and setter functions
     * @returns {boolean} is operation successful
     */
    function setPropertyAccess(object, property, descriptor) {
      var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

      if (currentDescriptor && !currentDescriptor.configurable) {
        return false;
      }

      Object.defineProperty(object, property, descriptor);
      return true;
    }

    /**
     * @typedef Chain
     * @property {Object} base
     * @property {string} prop
     * @property {string} [chain]
     */

    /**
     * Check if the property exists in the base object (recursively)
     *
     * If property doesn't exist in base object,
     * defines this property as 'undefined'
     * and returns base, property name and remaining part of property chain
     *
     * @param {Object} base
     * @param {string} chain
     * @returns {Chain}
     */
    function getPropertyInChain(base, chain) {
      var pos = chain.indexOf('.');

      if (pos === -1) {
        return {
          base: base,
          prop: chain
        };
      }

      var prop = chain.slice(0, pos); // https://github.com/AdguardTeam/Scriptlets/issues/128

      if (base === null) {
        // if base is null, return 'null' as base.
        // it's needed for triggering the reason logging while debugging
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      var nextBase = base[prop];
      chain = chain.slice(pos + 1);

      if (nextBase !== undefined) {
        return getPropertyInChain(nextBase, chain);
      }

      Object.defineProperty(base, prop, {
        configurable: true
      });
      return {
        base: base,
        prop: prop,
        chain: chain
      };
    }

    /**
     * @typedef Chain
     * @property {Object} base
     * @property {string} prop
     * @property {string} [chain]
     */

    /**
     * Check if the property exists in the base object (recursively).
     * Similar to getPropertyInChain but upgraded for json-prune:
     * handle wildcard properties and does not define nonexistent base property as 'undefined'
     *
     * @param {Object} base
     * @param {string} chain
     * @param {boolean} [lookThrough=false]
     * should the method look through it's props in order to wildcard
     * @param {Array} [output=[]] result acc
     * @returns {Chain[]} array of objects
     */

    function getWildcardPropertyInChain(base, chain) {
      var lookThrough = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var output = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
      var pos = chain.indexOf('.');

      if (pos === -1) {
        // for paths like 'a.b.*' every final nested prop should be processed
        if (chain === getWildcardSymbol() || chain === '[]') {
          // eslint-disable-next-line no-restricted-syntax
          for (var key in base) {
            // to process each key in base except inherited ones
            if (Object.prototype.hasOwnProperty.call(base, key)) {
              output.push({
                base: base,
                prop: key
              });
            }
          }
        } else {
          output.push({
            base: base,
            prop: chain
          });
        }

        return output;
      }

      var prop = chain.slice(0, pos);
      var shouldLookThrough = prop === '[]' && Array.isArray(base) || prop === getWildcardSymbol() && base instanceof Object;

      if (shouldLookThrough) {
        var nextProp = chain.slice(pos + 1);
        var baseKeys = Object.keys(base); // if there is a wildcard prop in input chain (e.g. 'ad.*.src' for 'ad.0.src ad.1.src'),
        // each one of base keys should be considered as a potential chain prop in final path

        baseKeys.forEach(function (key) {
          var item = base[key];
          getWildcardPropertyInChain(item, nextProp, lookThrough, output);
        });
      }

      var nextBase = base[prop];
      chain = chain.slice(pos + 1);

      if (nextBase !== undefined) {
        getWildcardPropertyInChain(nextBase, chain, lookThrough, output);
      }

      return output;
    }

    /**
     * Generates function which silents global errors on page generated by scriptlet
     * If error doesn't belong to our error we transfer it to the native onError handler
     * @param {string} rid - unique identifier of scriptlet
     * @return {onError}
     */
    function createOnErrorHandler(rid) {
      // eslint-disable-next-line consistent-return
      var nativeOnError = window.onerror;
      return function onError(error) {
        if (typeof error === 'string' && error.indexOf(rid) !== -1) {
          return true;
        }

        if (nativeOnError instanceof Function) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          return nativeOnError.apply(this, [error].concat(args));
        }

        return false;
      };
    }

    /**
     * Noop function
     * @return {undefined} undefined
     */
    var noopFunc = function noopFunc() {};
    /**
     * Function returns null
     * @return {null} null
     */

    var noopNull = function noopNull() {
      return null;
    };
    /**
     * Function returns true
     * @return {boolean} true
     */

    var trueFunc = function trueFunc() {
      return true;
    };
    /**
     * Function returns false
     * @return {boolean} false
     */

    var falseFunc = function falseFunc() {
      return false;
    };
    /**
     * Function returns this
     */

    function noopThis() {
      return this;
    }
    /**
     * Function returns empty string
     * @return {string} empty string
     */

    var noopStr = function noopStr() {
      return '';
    };
    /**
     * Function returns empty array
     * @return {Array} empty array
     */

    var noopArray = function noopArray() {
      return [];
    };
    /**
     * Function returns empty object
     * @return {Object} empty object
     */

    var noopObject = function noopObject() {
      return {};
    };
    /**
     * Function returns Promise.reject()
     */

    var noopPromiseReject = function noopPromiseReject() {
      return Promise.reject();
    }; // eslint-disable-line compat/compat

    /**
     * Returns Promise object that is resolved with a response
     * @param {string} [responseBody='{}'] value of response body
     */

    var noopPromiseResolve = function noopPromiseResolve() {
      var responseBody = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '{}';

      if (typeof Response === 'undefined') {
        return;
      } // eslint-disable-next-line compat/compat


      var response = new Response(responseBody, {
        status: 200,
        statusText: 'OK'
      }); // eslint-disable-next-line compat/compat, consistent-return

      return Promise.resolve(response);
    };

    /* eslint-disable no-console, no-underscore-dangle */

    /**
     * Hit used only for debug purposes now
     * @param {Source} source
     * @param {string} [message] - optional message;
     * use LOG_MARKER = 'log: ' at the start of a message
     * for logging scriptlets
     */
    var hit = function hit(source, message) {
      if (source.verbose !== true) {
        return;
      }

      try {
        var log = console.log.bind(console);
        var trace = console.trace.bind(console); // eslint-disable-line compat/compat

        var prefix = source.ruleText || '';

        if (source.domainName) {
          var AG_SCRIPTLET_MARKER = '#%#//';
          var UBO_SCRIPTLET_MARKER = '##+js';
          var ruleStartIndex;

          if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
            ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
          } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
            ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
          } // delete all domains from ruleText and leave just rule part


          var rulePart = source.ruleText.slice(ruleStartIndex); // prepare applied scriptlet rule for specific domain

          prefix = "".concat(source.domainName).concat(rulePart);
        } // Used to check if scriptlet uses 'hit' function for logging


        var LOG_MARKER = 'log: ';

        if (message) {
          if (message.indexOf(LOG_MARKER) === -1) {
            log("".concat(prefix, " message:\n").concat(message));
          } else {
            log(message.slice(LOG_MARKER.length));
          }
        }

        log("".concat(prefix, " trace start"));

        if (trace) {
          trace();
        }

        log("".concat(prefix, " trace end"));
      } catch (e) {// try catch for Edge 15
        // In according to this issue https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/14495220/
        // console.log throws an error
      } // This is necessary for unit-tests only!


      if (typeof window.__debug === 'function') {
        window.__debug(source);
      }
    };

    /**
     * DOM tree changes observer. Used for 'remove-attr' and 'remove-class' scriptlets
     * @param {Function} callback
     * @param {Boolean} observeAttrs - optional parameter - should observer check attributes changes
     */
    var observeDOMChanges = function observeDOMChanges(callback) {
      var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

      /**
       * Returns a wrapper, passing the call to 'method' at maximum once per 'delay' milliseconds.
       * Those calls that fall into the "cooldown" period, are ignored
       * @param {Function} method
       * @param {Number} delay - milliseconds
       */
      var throttle = function throttle(method, delay) {
        var wait = false;
        var savedArgs;

        var wrapper = function wrapper() {
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          if (wait) {
            savedArgs = args;
            return;
          }

          method.apply(void 0, args);
          wait = true;
          setTimeout(function () {
            wait = false;

            if (savedArgs) {
              wrapper(savedArgs);
              savedArgs = null;
            }
          }, delay);
        };

        return wrapper;
      };
      /**
       * 'delay' in milliseconds for 'throttle' method
       */


      var THROTTLE_DELAY_MS = 20;
      /**
       * Used for remove-class
       */
      // eslint-disable-next-line no-use-before-define, compat/compat

      var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

      var connect = function connect() {
        if (attrsToObserve.length > 0) {
          observer.observe(document.documentElement, {
            childList: true,
            subtree: true,
            attributes: observeAttrs,
            attributeFilter: attrsToObserve
          });
        } else {
          observer.observe(document.documentElement, {
            childList: true,
            subtree: true,
            attributes: observeAttrs
          });
        }
      };

      var disconnect = function disconnect() {
        observer.disconnect();
      };

      function callbackWrapper() {
        disconnect();
        callback();
        connect();
      }

      connect();
    };

    var getNativeRegexpTest = function getNativeRegexpTest() {
      return Object.getOwnPropertyDescriptor(RegExp.prototype, 'test').value;
    };

    /**
     * Checks if the stackTrace contains stackRegexp
     * https://github.com/AdguardTeam/Scriptlets/issues/82
     * @param {string|undefined} stackMatch - input stack value to match
     * @param {string} stackTrace - script error stack trace
     * @returns {boolean}
     */

    var matchStackTrace = function matchStackTrace(stackMatch, stackTrace) {
      if (!stackMatch || stackMatch === '') {
        return true;
      }

      var stackRegexp = toRegExp(stackMatch);
      var refinedStackTrace = stackTrace.split('\n').slice(2) // get rid of our own functions in the stack trace
      .map(function (line) {
        return line.trim();
      }) // trim the lines
      .join('\n');
      return getNativeRegexpTest().call(stackRegexp, refinedStackTrace);
    };

    /**
     * Some browsers do not support Array.prototype.flat()
     * for example, Opera 42 which is used for browserstack tests
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flat
     * @param {Array} input
     */
    var flatten = function flatten(input) {
      var stack = [];
      input.forEach(function (el) {
        return stack.push(el);
      });
      var res = [];

      while (stack.length) {
        // pop value from stack
        var next = stack.pop();

        if (Array.isArray(next)) {
          // push back array items, won't modify the original input
          next.forEach(function (el) {
            return stack.push(el);
          });
        } else {
          res.push(next);
        }
      } // reverse to restore input order


      return res.reverse();
    };
    /**
     * Predicate method to check if the array item exists
     * @param {any} item
     * @returns {boolean}
     */

    var isExisting = function isExisting(item) {
      return !!item;
    };

    /**
     * Finds shadow-dom host (elements with shadowRoot property) in DOM of rootElement.
     * @param {HTMLElement} rootElement
     * @returns {HTMLElement[]} shadow-dom hosts
     */

    var findHostElements = function findHostElements(rootElement) {
      var hosts = []; // Element.querySelectorAll() returns list of elements
      // which are defined in DOM of Element.
      // Meanwhile, inner DOM of the element with shadowRoot property
      // is absolutely another DOM and which can not be reached by querySelectorAll('*')

      var domElems = rootElement.querySelectorAll('*');
      domElems.forEach(function (el) {
        if (el.shadowRoot) {
          hosts.push(el);
        }
      });
      return hosts;
    };
    /**
     * A collection of nodes.
     *
     * @external NodeList
     * @see {@link https://developer.mozilla.org/en-US/docs/Web/API/NodeList NodeList}
     */

    /**
     * @typedef {Object} PierceData
     * @property {HTMLElement[]} targets found elements that match the specified selector
     * @property {HTMLElement[]} innerHosts inner shadow-dom hosts
     */

    /**
     * Pierces open shadow-dom in order to find:
     * - elements by 'selector' matching
     * - inner shadow-dom hosts
     * @param {string} selector
     * @param {HTMLElement[]|external:NodeList} hostElements
     * @returns {PierceData}
     */

    var pierceShadowDom = function pierceShadowDom(selector, hostElements) {
      var targets = [];
      var innerHostsAcc = []; // it's possible to get a few hostElements found by baseSelector on the page

      hostElements.forEach(function (host) {
        // check presence of selector element inside base element if it's not in shadow-dom
        var simpleElems = host.querySelectorAll(selector);
        targets = targets.concat([].slice.call(simpleElems));
        var shadowRootElem = host.shadowRoot;
        var shadowChildren = shadowRootElem.querySelectorAll(selector);
        targets = targets.concat([].slice.call(shadowChildren)); // find inner shadow-dom hosts inside processing shadow-dom

        innerHostsAcc.push(findHostElements(shadowRootElem));
      }); // if there were more than one host element,
      // innerHostsAcc is an array of arrays and should be flatten

      var innerHosts = flatten(innerHostsAcc);
      return {
        targets: targets,
        innerHosts: innerHosts
      };
    };

    /**
     * Prepares cookie string if given parameters are ok
     * @param {string} name cookie name to set
     * @param {string} value cookie value to set
     * @returns {string|null} cookie string if ok OR null if not
     */

    var prepareCookie = function prepareCookie(name, value) {
      if (!name || !value) {
        return null;
      }

      var valueToSet;

      if (value === 'true') {
        valueToSet = 'true';
      } else if (value === 'True') {
        valueToSet = 'True';
      } else if (value === 'false') {
        valueToSet = 'false';
      } else if (value === 'False') {
        valueToSet = 'False';
      } else if (value === 'yes') {
        valueToSet = 'yes';
      } else if (value === 'Yes') {
        valueToSet = 'Yes';
      } else if (value === 'Y') {
        valueToSet = 'Y';
      } else if (value === 'no') {
        valueToSet = 'no';
      } else if (value === 'ok') {
        valueToSet = 'ok';
      } else if (value === 'OK') {
        valueToSet = 'OK';
      } else if (/^\d+$/.test(value)) {
        valueToSet = parseFloat(value);

        if (nativeIsNaN(valueToSet)) {
          return null;
        }

        if (Math.abs(valueToSet) < 0 || Math.abs(valueToSet) > 15) {
          return null;
        }
      } else {
        return null;
      }

      var pathToSet = 'path=/;'; // eslint-disable-next-line max-len

      var cookieData = "".concat(encodeURIComponent(name), "=").concat(encodeURIComponent(valueToSet), "; ").concat(pathToSet);
      return cookieData;
    };

    var shouldMatchAnyDelay = function shouldMatchAnyDelay(delay) {
      return delay === getWildcardSymbol();
    };
    /**
     * Handles input delay value
     * @param {*} delay
     * @returns {number} proper number delay value
     */

    var getMatchDelay = function getMatchDelay(delay) {
      var DEFAULT_DELAY = 1000;
      var parsedDelay = parseInt(delay, 10);
      var delayMatch = nativeIsNaN(parsedDelay) ? DEFAULT_DELAY // default scriptlet value
      : parsedDelay;
      return delayMatch;
    };
    /**
     * Checks delay match condition
     * @param {*} inputDelay
     * @param {number} realDelay
     * @returns {boolean}
     */

    var isDelayMatched = function isDelayMatched(inputDelay, realDelay) {
      return shouldMatchAnyDelay(inputDelay) || realDelay === getMatchDelay(inputDelay);
    };
    /**
     * Handles input boost value
     * @param {*} boost
     * @returns {number} proper number boost multiplier value
     */

    var getBoostMultiplier = function getBoostMultiplier(boost) {
      var DEFAULT_MULTIPLIER = 0.05;
      var MIN_MULTIPLIER = 0.02;
      var MAX_MULTIPLIER = 50;
      var parsedBoost = parseFloat(boost);
      var boostMultiplier = nativeIsNaN(parsedBoost) || !nativeIsFinite(parsedBoost) ? DEFAULT_MULTIPLIER // default scriptlet value
      : parsedBoost;

      if (boostMultiplier < MIN_MULTIPLIER) {
        boostMultiplier = MIN_MULTIPLIER;
      }

      if (boostMultiplier > MAX_MULTIPLIER) {
        boostMultiplier = MAX_MULTIPLIER;
      }

      return boostMultiplier;
    };

    /**
     * Collects Request options to object
     * @param {Request} request
     * @returns {Object} data object
     */

    var getRequestData = function getRequestData(request) {
      var REQUEST_INIT_OPTIONS = ['url', 'method', 'headers', 'body', 'mode', 'credentials', 'cache', 'redirect', 'referrer', 'integrity'];
      var entries = REQUEST_INIT_OPTIONS.map(function (key) {
        // if request has no such option, value will be undefined
        var value = request[key];
        return [key, value];
      });
      return getObjectFromEntries(entries);
    };
    /**
     * Collects fetch args to object
     * @param {*} args fetch args
     * @returns {Object} data object
     */

    var getFetchData = function getFetchData(args) {
      var fetchPropsObj = {};
      var fetchUrl;
      var fetchInit;

      if (args[0] instanceof Request) {
        // if Request passed to fetch, it will be in array
        var requestData = getRequestData(args[0]);
        fetchUrl = requestData.url;
        fetchInit = requestData;
      } else {
        fetchUrl = args[0]; // eslint-disable-line prefer-destructuring

        fetchInit = args[1]; // eslint-disable-line prefer-destructuring
      }

      fetchPropsObj.url = fetchUrl;

      if (fetchInit instanceof Object) {
        Object.keys(fetchInit).forEach(function (prop) {
          fetchPropsObj[prop] = fetchInit[prop];
        });
      }

      return fetchPropsObj;
    };
    /**
     * Parse propsToMatch input string into object;
     * used for prevent-fetch and prevent-xhr
     * @param {string} propsToMatchStr
     * @returns {Object} object where 'key' is prop name and 'value' is prop value
     */

    var parseMatchProps = function parseMatchProps(propsToMatchStr) {
      var PROPS_DIVIDER = ' ';
      var PAIRS_MARKER = ':';
      var propsObj = {};
      var props = propsToMatchStr.split(PROPS_DIVIDER);
      props.forEach(function (prop) {
        var dividerInd = prop.indexOf(PAIRS_MARKER);

        if (dividerInd === -1) {
          propsObj.url = prop;
        } else {
          var key = prop.slice(0, dividerInd);
          var value = prop.slice(dividerInd + 1);
          propsObj[key] = value;
        }
      });
      return propsObj;
    };
    /**
     * Validates parsed data values
     * @param {Object} data
     * @returns {boolean}
     */

    var validateParsedData = function validateParsedData(data) {
      return Object.values(data).every(function (value) {
        return isValidStrPattern(value);
      });
    };
    /**
     * Converts valid parsed data to data obj for further matching
     * @param {Object} data
     * @returns {Object}
     */

    var getMatchPropsData = function getMatchPropsData(data) {
      var matchData = {};
      Object.keys(data).forEach(function (key) {
        matchData[key] = toRegExp(data[key]);
      });
      return matchData;
    };

    var handleOldReplacement = function handleOldReplacement(replacement) {
      var result; // defaults to return noopFunc instead of window.open

      if (!replacement) {
        result = noopFunc;
      } else if (replacement === 'trueFunc') {
        result = trueFunc;
      } else if (replacement.indexOf('=') > -1) {
        // We should return noopFunc instead of window.open
        // but with some property if website checks it (examples 5, 6)
        // https://github.com/AdguardTeam/Scriptlets/issues/71
        var isProp = startsWith(replacement, '{') && endsWith(replacement, '}');

        if (isProp) {
          var propertyPart = replacement.slice(1, -1);
          var propertyName = substringBefore(propertyPart, '=');
          var propertyValue = substringAfter$1(propertyPart, '=');

          if (propertyValue === 'noopFunc') {
            result = {};
            result[propertyName] = noopFunc;
          }
        }
      }

      return result;
    };
    var createDecoy = function createDecoy(args) {
      var OBJECT_TAG_NAME = 'object';
      var OBJECT_URL_PROP_NAME = 'data';
      var IFRAME_TAG_NAME = 'iframe';
      var IFRAME_URL_PROP_NAME = 'src';
      var replacement = args.replacement,
          url = args.url,
          delay = args.delay;
      var tag;
      var urlProp;

      if (replacement === 'obj') {
        tag = OBJECT_TAG_NAME;
        urlProp = OBJECT_URL_PROP_NAME;
      } else {
        tag = IFRAME_TAG_NAME;
        urlProp = IFRAME_URL_PROP_NAME;
      }

      var decoy = document.createElement(tag);
      decoy[urlProp] = url;
      decoy.style.setProperty('height', '1px', 'important');
      decoy.style.setProperty('position', 'fixed', 'important');
      decoy.style.setProperty('top', '-1px', 'important');
      decoy.style.setProperty('width', '1px', 'important');
      document.body.appendChild(decoy);
      setTimeout(function () {
        return decoy.remove();
      }, delay * 1000);
      return decoy;
    };
    var getPreventGetter = function getPreventGetter(nativeGetter) {
      var preventGetter = function preventGetter(target, prop) {
        if (prop && prop === 'closed') {
          return false;
        }

        if (typeof nativeGetter === 'function') {
          return noopFunc;
        }

        return prop && target[prop];
      };

      return preventGetter;
    };

    /**
     * Validates event type
     * @param {*} type
     * @returns {boolean}
     */
    var validateType = function validateType(type) {
      // https://github.com/AdguardTeam/Scriptlets/issues/125
      return typeof type !== 'undefined';
    };
    /**
     * Validates event listener
     * @param {*} listener
     * @returns {boolean}
     */

    var validateListener = function validateListener(listener) {
      // https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#parameters
      return typeof listener !== 'undefined' && (typeof listener === 'function' || typeof listener === 'object' // https://github.com/AdguardTeam/Scriptlets/issues/76
      && listener !== null && typeof listener.handleEvent === 'function');
    };
    /**
     * Serialize valid event listener
     * https://developer.mozilla.org/en-US/docs/Web/API/EventListener
     * @param {EventListener} listener valid listener
     * @returns {string}
     */

    var listenerToString = function listenerToString(listener) {
      return typeof listener === 'function' ? listener.toString() : listener.handleEvent.toString();
    };

    /**
     * Checks whether the passed arg is proper callback
     * @param {*} callback
     * @returns {boolean}
     */

    var isValidCallback = function isValidCallback(callback) {
      return callback instanceof Function // passing string as 'code' arg is not recommended
      // but it is possible and not restricted
      // https://developer.mozilla.org/en-US/docs/Web/API/setTimeout#parameters
      || typeof callback === 'string';
    };
    /**
     * Checks whether 'callback' and 'delay' are matching
     * by given parameters 'matchCallback' and 'matchDelay'.
     * Used for prevent-setTimeout and prevent-setInterval.
     * @param {Object} { callback, delay, matchCallback, matchDelay }
     * @returns {boolean}
     */

    var isPreventionNeeded = function isPreventionNeeded(_ref) {
      var callback = _ref.callback,
          delay = _ref.delay,
          matchCallback = _ref.matchCallback,
          matchDelay = _ref.matchDelay;

      // if callback is has not valid type
      // scriptlet can not prevent it
      // so no need for more checking and do not call hit() later
      if (!isValidCallback(callback)) {
        return false;
      }

      if (!isValidMatchStr(matchCallback) || matchDelay && !isValidMatchNumber(matchDelay)) {
        return false;
      }

      var _parseMatchArg = parseMatchArg(matchCallback),
          isInvertedMatch = _parseMatchArg.isInvertedMatch,
          matchRegexp = _parseMatchArg.matchRegexp;

      var _parseDelayArg = parseDelayArg(matchDelay),
          isInvertedDelayMatch = _parseDelayArg.isInvertedDelayMatch,
          delayMatch = _parseDelayArg.delayMatch;

      var shouldPrevent = false; // https://github.com/AdguardTeam/Scriptlets/issues/105

      var callbackStr = String(callback);

      if (delayMatch === null) {
        shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch;
      } else if (!matchCallback) {
        shouldPrevent = delay === delayMatch !== isInvertedDelayMatch;
      } else {
        shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch && delay === delayMatch !== isInvertedDelayMatch;
      }

      return shouldPrevent;
    };

    /**
     * Generate a random integer between two values, inclusive
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random#getting_a_random_integer_between_two_values_inclusive
     * @param {number} min
     * @param {number} max
     * @returns {number}
     */

    function getRandomIntInclusive(min, max) {
      min = Math.ceil(min);
      max = Math.floor(max);
      return Math.floor(Math.random() * (max - min + 1) + min);
    }
    /**
     * Generate a random string, a length of the string is provided as an argument
     * @param {number} length
     * @returns {string}
     */

    function getRandomStrByLength(length) {
      var result = '';
      var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+=~';
      var charactersLength = characters.length;

      for (var i = 0; i < length; i += 1) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
      }

      return result;
    }
    /**
     * Generate a random string
     * @param {string} customResponseText
     * @returns {string|null} random string or null if passed argument is invalid
     */

    function generateRandomResponse(customResponseText) {
      var customResponse = customResponseText;

      if (customResponse === 'true') {
        // Generate random alphanumeric string of 10 symbols
        customResponse = Math.random().toString(36).slice(-10);
        return customResponse;
      }

      customResponse = customResponse.replace('length:', '');
      var rangeRegex = /^\d+-\d+$/; // Return empty string if range is invalid

      if (!rangeRegex.test(customResponse)) {
        return null;
      }

      var rangeMin = getNumberFromString(customResponse.split('-')[0]);
      var rangeMax = getNumberFromString(customResponse.split('-')[1]);

      if (!nativeIsFinite(rangeMin) || !nativeIsFinite(rangeMax)) {
        return null;
      } // If rangeMin > rangeMax, swap variables


      if (rangeMin > rangeMax) {
        var temp = rangeMin;
        rangeMin = rangeMax;
        rangeMax = temp;
      }

      var LENGTH_RANGE_LIMIT = 500 * 1000;

      if (rangeMax > LENGTH_RANGE_LIMIT) {
        return null;
      }

      var length = getRandomIntInclusive(rangeMin, rangeMax);
      customResponse = getRandomStrByLength(length);
      return customResponse;
    }

    /**
     * Prevent infinite loops when trapping props that could be used by scriptlet's own helpers
     * Example: window.RegExp, that is used by matchStackTrace > toRegExp
     *
     * https://github.com/AdguardTeam/Scriptlets/issues/226
     * https://github.com/AdguardTeam/Scriptlets/issues/232
     *
     * @return {Object}
     */
    function getDescriptorAddon() {
      return {
        isAbortingSuspended: false,
        isolateCallback: function isolateCallback(cb) {
          this.isAbortingSuspended = true;

          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          var result = cb.apply(void 0, args);
          this.isAbortingSuspended = false;
          return result;
        }
      };
    }

    /**
     * Behaviour flags string parser
     * @param {string} flags required, 'applying' argument string
     * @return {Object}
     */
    var parseFlags = function parseFlags(flags) {
      var FLAGS_DIVIDER = ' ';
      var ASAP_FLAG = 'asap';
      var COMPLETE_FLAG = 'complete';
      var STAY_FLAG = 'stay';
      var VALID_FLAGS = [STAY_FLAG, ASAP_FLAG, COMPLETE_FLAG];
      var passedFlags = flags.trim().split(FLAGS_DIVIDER).filter(function (f) {
        return VALID_FLAGS.indexOf(f) !== -1;
      });
      return {
        ASAP: ASAP_FLAG,
        COMPLETE: COMPLETE_FLAG,
        STAY: STAY_FLAG,
        hasFlag: function hasFlag(flag) {
          return passedFlags.indexOf(flag) !== -1;
        }
      };
    };

    /* eslint-disable max-len */

    /**
     * @scriptlet abort-on-property-read
     *
     * @description
     * Aborts a script when it attempts to **read** the specified property.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#abort-on-property-readjs-
     *
     * Related ABP source:
     * https://github.com/adblockplus/adblockpluscore/blob/6b2a309054cc23432102b85d13f12559639ef495/lib/content/snippets.js#L864
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('abort-on-property-read', property)
     * ```
     *
     * - `property` - required, path to a property (joined with `.` if needed). The property must be attached to `window`
     *
     * **Examples**
     * ```
     * ! Aborts script when it tries to access `window.alert`
     * example.org#%#//scriptlet('abort-on-property-read', 'alert')
     *
     * ! Aborts script when it tries to access `navigator.language`
     * example.org#%#//scriptlet('abort-on-property-read', 'navigator.language')
     * ```
     */

    /* eslint-enable max-len */

    function abortOnPropertyRead$1(source, property) {
      if (!property) {
        return;
      }

      var rid = randomId();

      var abort = function abort() {
        hit(source);
        throw new ReferenceError(rid);
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        setPropertyAccess(base, prop, {
          get: abort,
          set: function set() {}
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    abortOnPropertyRead$1.names = ['abort-on-property-read', // aliases are needed for matching the related scriptlet converted into our syntax
    'abort-on-property-read.js', 'ubo-abort-on-property-read.js', 'aopr.js', 'ubo-aopr.js', 'ubo-abort-on-property-read', 'ubo-aopr', 'abp-abort-on-property-read'];
    abortOnPropertyRead$1.injections = [randomId, setPropertyAccess, getPropertyInChain, createOnErrorHandler, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet abort-on-property-write
     *
     * @description
     * Aborts a script when it attempts to **write** the specified property.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#abort-on-property-writejs-
     *
     * Related ABP source:
     * https://github.com/adblockplus/adblockpluscore/blob/6b2a309054cc23432102b85d13f12559639ef495/lib/content/snippets.js#L896
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('abort-on-property-write', property)
     * ```
     *
     * - `property` - required, path to a property (joined with `.` if needed). The property must be attached to `window`
     *
     * **Examples**
     * ```
     * ! Aborts script when it tries to set `window.adblock` value
     * example.org#%#//scriptlet('abort-on-property-write', 'adblock')
     * ```
     */

    /* eslint-enable max-len */

    function abortOnPropertyWrite$1(source, property) {
      if (!property) {
        return;
      }

      var rid = randomId();

      var abort = function abort() {
        hit(source);
        throw new ReferenceError(rid);
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        setPropertyAccess(base, prop, {
          set: abort
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    abortOnPropertyWrite$1.names = ['abort-on-property-write', // aliases are needed for matching the related scriptlet converted into our syntax
    'abort-on-property-write.js', 'ubo-abort-on-property-write.js', 'aopw.js', 'ubo-aopw.js', 'ubo-abort-on-property-write', 'ubo-aopw', 'abp-abort-on-property-write'];
    abortOnPropertyWrite$1.injections = [randomId, setPropertyAccess, getPropertyInChain, createOnErrorHandler, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-setTimeout
     *
     * @description
     * Prevents a `setTimeout` call if:
     * 1) the text of the callback is matching the specified `matchCallback` string/regexp which does not start with `!`;
     * otherwise mismatched calls should be defused;
     * 2) the delay is matching the specified `matchDelay`; otherwise mismatched calls should be defused.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#no-settimeout-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-setTimeout'[, matchCallback[, matchDelay]])
     * ```
     *
     * Call with no arguments will log calls to setTimeout while debugging (`log-setTimeout` superseding),
     * so production filter lists' rules definitely require at least one of the parameters:
     * - `matchCallback` - optional, string or regular expression; invalid regular expression will be skipped and all callbacks will be matched.
     * If starts with `!`, scriptlet will not match the stringified callback but all other will be defused.
     * If do not start with `!`, the stringified callback will be matched.
     * If not set, prevents all `setTimeout` calls due to specified `matchDelay`.
     * - `matchDelay` - optional, must be an integer.
     * If starts with `!`, scriptlet will not match the delay but all other will be defused.
     * If do not start with `!`, the delay passed to the `setTimeout` call will be matched.
     *
     * > If `prevent-setTimeout` log looks like `setTimeout(undefined, 1000)`,
     * it means that no callback was passed to setTimeout() and that's not scriptlet issue
     * and obviously it can not be matched by `matchCallback`.
     *
     * **Examples**
     * 1. Prevents `setTimeout` calls if the callback matches `/\.test/` regardless of the delay.
     *     ```bash
     *     example.org#%#//scriptlet('prevent-setTimeout', '/\.test/')
     *     ```
     *
     *     For instance, the following call will be prevented:
     *     ```javascript
     *     setTimeout(function () {
     *         window.test = "value";
     *     }, 100);
     *     ```
     *
     * 2. Prevents `setTimeout` calls if the callback does not contain `value`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setTimeout', '!value')
     *     ```
     *
     *     For instance, only the first of the following calls will be prevented:
     *     ```javascript
     *     setTimeout(function () {
     *         window.test = "test -- prevented";
     *     }, 300);
     *     setTimeout(function () {
     *         window.test = "value -- executed";
     *     }, 400);
     *     setTimeout(function () {
     *         window.value = "test -- executed";
     *     }, 500);
     *     ```
     *
     * 3. Prevents `setTimeout` calls if the callback contains `value` and the delay is not set to `300`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setTimeout', 'value', '!300')
     *     ```
     *
     *     For instance, only the first of the following calls will not be prevented:
     *     ```javascript
     *     setTimeout(function () {
     *         window.test = "value 1 -- executed";
     *     }, 300);
     *     setTimeout(function () {
     *         window.test = "value 2 -- prevented";
     *     }, 400);
     *     setTimeout(function () {
     *         window.test = "value 3 -- prevented";
     *     }, 500);
     *     ```
     *
     * 4. Prevents `setTimeout` calls if the callback does not contain `value` and the delay is not set to `300`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setTimeout', '!value', '!300')
     *     ```
     *
     *     For instance, only the second of the following calls will be prevented:
     *     ```javascript
     *     setTimeout(function () {
     *         window.test = "test -- executed";
     *     }, 300);
     *     setTimeout(function () {
     *         window.test = "test -- prevented";
     *     }, 400);
     *     setTimeout(function () {
     *         window.test = "value -- executed";
     *     }, 400);
     *     setTimeout(function () {
     *         window.value = "test -- executed";
     *     }, 500);
     *     ```
     */

    /* eslint-enable max-len */

    function preventSetTimeout$1(source, matchCallback, matchDelay) {
      // if browser does not support Proxy (e.g. Internet Explorer),
      // we use none-proxy "legacy" wrapper for preventing
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy
      var isProxySupported = typeof Proxy !== 'undefined';
      var nativeTimeout = window.setTimeout;
      var log = console.log.bind(console); // eslint-disable-line no-console
      // logs setTimeouts to console if no arguments have been specified

      var shouldLog = typeof matchCallback === 'undefined' && typeof matchDelay === 'undefined';

      var legacyTimeoutWrapper = function legacyTimeoutWrapper(callback, delay) {
        var shouldPrevent = false;

        if (shouldLog) {
          hit(source); // https://github.com/AdguardTeam/Scriptlets/issues/105

          log("setTimeout(".concat(String(callback), ", ").concat(delay, ")"));
        } else {
          shouldPrevent = isPreventionNeeded({
            callback: callback,
            delay: delay,
            matchCallback: matchCallback,
            matchDelay: matchDelay
          });
        }

        if (shouldPrevent) {
          hit(source);
          return nativeTimeout(noopFunc, delay);
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeTimeout.apply(window, [callback, delay].concat(args));
      };

      var handlerWrapper = function handlerWrapper(target, thisArg, args) {
        var callback = args[0];
        var delay = args[1];
        var shouldPrevent = false;

        if (shouldLog) {
          hit(source); // https://github.com/AdguardTeam/Scriptlets/issues/105

          log("setTimeout(".concat(String(callback), ", ").concat(delay, ")"));
        } else {
          shouldPrevent = isPreventionNeeded({
            callback: callback,
            delay: delay,
            matchCallback: matchCallback,
            matchDelay: matchDelay
          });
        }

        if (shouldPrevent) {
          hit(source);
          args[0] = noopFunc;
        }

        return target.apply(thisArg, args);
      };

      var setTimeoutHandler = {
        apply: handlerWrapper
      };
      window.setTimeout = isProxySupported ? new Proxy(window.setTimeout, setTimeoutHandler) : legacyTimeoutWrapper;
    }
    preventSetTimeout$1.names = ['prevent-setTimeout', // aliases are needed for matching the related scriptlet converted into our syntax
    'no-setTimeout-if.js', // new implementation of setTimeout-defuser.js
    'ubo-no-setTimeout-if.js', 'nostif.js', // new short name of no-setTimeout-if
    'ubo-nostif.js', 'ubo-no-setTimeout-if', 'ubo-nostif', // old scriptlet names which should be supported as well.
    // should be removed eventually.
    // do not remove until other filter lists maintainers use them
    'setTimeout-defuser.js', 'ubo-setTimeout-defuser.js', 'ubo-setTimeout-defuser', 'std.js', 'ubo-std.js', 'ubo-std'];
    preventSetTimeout$1.injections = [hit, noopFunc, isPreventionNeeded, // following helpers should be injected as helpers above use them
    parseMatchArg, parseDelayArg, toRegExp, startsWith, nativeIsNaN, isValidCallback, isValidMatchStr, escapeRegExp, isValidStrPattern, nativeIsFinite, isValidMatchNumber];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-setInterval
     *
     * @description
     * Prevents a `setInterval` call if:
     * 1) the text of the callback is matching the specified `matchCallback` string/regexp which does not start with `!`;
     * otherwise mismatched calls should be defused;
     * 2) the delay is matching the specified `matchDelay`; otherwise mismatched calls should be defused.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#no-setinterval-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-setInterval'[, matchCallback[, matchDelay]])
     * ```
     *
     * Call with no arguments will log calls to setInterval while debugging (`log-setInterval` superseding),
     * so production filter lists' rules definitely require at least one of the parameters:
     * - `matchCallback` - optional, string or regular expression; invalid regular expression will be skipped and all callbacks will be matched.
     * If starts with `!`, scriptlet will not match the stringified callback but all other will be defused.
     * If do not start with `!`, the stringified callback will be matched.
     * If not set, prevents all `setInterval` calls due to specified `matchDelay`.
     * - `matchDelay` - optional, must be an integer.
     * If starts with `!`, scriptlet will not match the delay but all other will be defused.
     * If do not start with `!`, the delay passed to the `setInterval` call will be matched.
     *
     * > If `prevent-setInterval` log looks like `setInterval(undefined, 1000)`,
     * it means that no callback was passed to setInterval() and that's not scriptlet issue
     * and obviously it can not be matched by `matchCallback`.
     *
     *  **Examples**
     * 1. Prevents `setInterval` calls if the callback matches `/\.test/` regardless of the delay.
     *     ```bash
     *     example.org#%#//scriptlet('prevent-setInterval', '/\.test/')
     *     ```
     *
     *     For instance, the following call will be prevented:
     *     ```javascript
     *     setInterval(function () {
     *         window.test = "value";
     *     }, 100);
     *     ```
     *
     * 2. Prevents `setInterval` calls if the callback does not contain `value`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setInterval', '!value')
     *     ```
     *
     *     For instance, only the first of the following calls will be prevented:
     *     ```javascript
     *     setInterval(function () {
     *         window.test = "test -- prevented";
     *     }, 300);
     *     setInterval(function () {
     *         window.test = "value -- executed";
     *     }, 400);
     *     setInterval(function () {
     *         window.value = "test -- executed";
     *     }, 500);
     *     ```
     *
     * 3. Prevents `setInterval` calls if the callback contains `value` and the delay is not set to `300`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setInterval', 'value', '!300')
     *     ```
     *
     *     For instance, only the first of the following calls will not be prevented:
     *     ```javascript
     *     setInterval(function () {
     *         window.test = "value 1 -- executed";
     *     }, 300);
     *     setInterval(function () {
     *         window.test = "value 2 -- prevented";
     *     }, 400);
     *     setInterval(function () {
     *         window.test = "value 3 -- prevented";
     *     }, 500);
     *     ```
     *
     * 4. Prevents `setInterval` calls if the callback does not contain `value` and the delay is not set to `300`.
     *     ```
     *     example.org#%#//scriptlet('prevent-setInterval', '!value', '!300')
     *     ```
     *
     *     For instance, only the second of the following calls will be prevented:
     *     ```javascript
     *     setInterval(function () {
     *         window.test = "test -- executed";
     *     }, 300);
     *     setInterval(function () {
     *         window.test = "test -- prevented";
     *     }, 400);
     *     setInterval(function () {
     *         window.test = "value -- executed";
     *     }, 400);
     *     setInterval(function () {
     *         window.value = "test -- executed";
     *     }, 500);
     *     ```
     */

    /* eslint-enable max-len */

    function preventSetInterval$1(source, matchCallback, matchDelay) {
      // if browser does not support Proxy (e.g. Internet Explorer),
      // we use none-proxy "legacy" wrapper for preventing
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy
      var isProxySupported = typeof Proxy !== 'undefined';
      var nativeInterval = window.setInterval;
      var log = console.log.bind(console); // eslint-disable-line no-console
      // logs setIntervals to console if no arguments have been specified

      var shouldLog = typeof matchCallback === 'undefined' && typeof matchDelay === 'undefined';

      var legacyIntervalWrapper = function legacyIntervalWrapper(callback, delay) {
        var shouldPrevent = false;

        if (shouldLog) {
          hit(source); // https://github.com/AdguardTeam/Scriptlets/issues/105

          log("setInterval(".concat(String(callback), ", ").concat(delay, ")"));
        } else {
          shouldPrevent = isPreventionNeeded({
            callback: callback,
            delay: delay,
            matchCallback: matchCallback,
            matchDelay: matchDelay
          });
        }

        if (shouldPrevent) {
          hit(source);
          return nativeInterval(noopFunc, delay);
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeInterval.apply(window, [callback, delay].concat(args));
      };

      var handlerWrapper = function handlerWrapper(target, thisArg, args) {
        var callback = args[0];
        var delay = args[1];
        var shouldPrevent = false;

        if (shouldLog) {
          hit(source); // https://github.com/AdguardTeam/Scriptlets/issues/105

          log("setInterval(".concat(String(callback), ", ").concat(delay, ")"));
        } else {
          shouldPrevent = isPreventionNeeded({
            callback: callback,
            delay: delay,
            matchCallback: matchCallback,
            matchDelay: matchDelay
          });
        }

        if (shouldPrevent) {
          hit(source);
          args[0] = noopFunc;
        }

        return target.apply(thisArg, args);
      };

      var setIntervalHandler = {
        apply: handlerWrapper
      };
      window.setInterval = isProxySupported ? new Proxy(window.setInterval, setIntervalHandler) : legacyIntervalWrapper;
    }
    preventSetInterval$1.names = ['prevent-setInterval', // aliases are needed for matching the related scriptlet converted into our syntax
    'no-setInterval-if.js', // new implementation of setInterval-defuser.js
    'ubo-no-setInterval-if.js', 'setInterval-defuser.js', // old name should be supported as well
    'ubo-setInterval-defuser.js', 'nosiif.js', // new short name of no-setInterval-if
    'ubo-nosiif.js', 'sid.js', // old short scriptlet name
    'ubo-sid.js', 'ubo-no-setInterval-if', 'ubo-setInterval-defuser', 'ubo-nosiif', 'ubo-sid'];
    preventSetInterval$1.injections = [hit, noopFunc, isPreventionNeeded, // following helpers should be injected as helpers above use them
    toRegExp, startsWith, nativeIsNaN, parseMatchArg, parseDelayArg, isValidCallback, isValidMatchStr, isValidStrPattern, escapeRegExp, nativeIsFinite, isValidMatchNumber];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-window-open
     *
     * @description
     * Prevents `window.open` calls when URL either matches or not matches the specified string/regexp. Using it without parameters prevents all `window.open` calls.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#windowopen-defuserjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-window-open'[, match[, delay[, replacement]]])
     * ```
     *
     * - `match` - optional, string or regular expression. If not set or regular expression is invalid, all window.open calls will be matched.
     * If starts with `!`, scriptlet will not match the stringified callback but all other will be defused.
     * If do not start with `!`, the stringified callback will be matched.
     * - `delay` - optional, number of seconds. If not set, scriptlet will return `null`,
     * otherwise valid sham window object as injected `iframe` will be returned
     * for accessing its methods (blur(), focus() etc.) and will be removed after the delay.
     * - `replacement` - optional, string; one of the predefined constants:
     *     - `obj` - for returning an object instead of default iframe;
     *        for cases when the page requires a valid `window` instance to be returned
     *     - `log` - for logging window.open calls; permitted for production filter lists.
     *
     * **Examples**
     * 1. Prevent all `window.open` calls:
     * ```
     *     example.org#%#//scriptlet('prevent-window-open')
     * ```
     *
     * 2. Prevent `window.open` for all URLs containing `example`:
     * ```
     *     example.org#%#//scriptlet('prevent-window-open', 'example')
     * ```
     *
     * 3. Prevent `window.open` for all URLs matching RegExp `/example\./`:
     * ```
     *     example.org#%#//scriptlet('prevent-window-open', '/example\./')
     * ```
     *
     * 4. Prevent `window.open` for all URLs **NOT** containing `example`:
     * ```
     *     example.org#%#//scriptlet('prevent-window-open', '!example')
     * ```
     *
     * Old syntax of prevent-window-open parameters:
     * - `match` - optional, defaults to "matching", any positive number or nothing for "matching", 0 or empty string for "not matching"
     * - `search` - optional, string or regexp for matching the URL passed to `window.open` call; defaults to search all `window.open` call
     * - `replacement` - optional, string to return prop value or property instead of window.open; defaults to return noopFunc.
     * **Examples**
     * ```
     *     example.org#%#//scriptlet('prevent-window-open', '1', '/example\./')
     *     example.org#%#//scriptlet('prevent-window-open', '0', 'example')
     *     example.org#%#//scriptlet('prevent-window-open', '', '', 'trueFunc')
     *     example.org#%#//scriptlet('prevent-window-open', '1', '', '{propName=noopFunc}')
     * ```
     *
     * > For better compatibility with uBO, old syntax is not recommended to use.
     */

    /* eslint-enable max-len */

    function preventWindowOpen$1(source) {
      var match = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : getWildcardSymbol();
      var delay = arguments.length > 2 ? arguments[2] : undefined;
      var replacement = arguments.length > 3 ? arguments[3] : undefined;
      // default match value is needed for preventing all window.open calls
      // if scriptlet runs without args
      var nativeOpen = window.open;
      var isNewSyntax = match !== '0' && match !== '1';

      var oldOpenWrapper = function oldOpenWrapper(str) {
        match = Number(match) > 0; // 'delay' was 'search' prop for matching in old syntax

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        if (!isValidStrPattern(delay)) {
          // eslint-disable-next-line no-console
          console.log("Invalid parameter: ".concat(delay));
          return nativeOpen.apply(window, [str].concat(args));
        }

        var searchRegexp = toRegExp(delay);

        if (match !== searchRegexp.test(str)) {
          return nativeOpen.apply(window, [str].concat(args));
        }

        hit(source);
        return handleOldReplacement(replacement);
      };

      var newOpenWrapper = function newOpenWrapper(url) {
        var shouldLog = replacement && replacement.indexOf('log') > -1;

        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        if (shouldLog) {
          var argsStr = args && args.length > 0 ? ", ".concat(args.join(', ')) : '';
          var logMessage = "log: window-open: ".concat(url).concat(argsStr);
          hit(source, logMessage);
        }

        var shouldPrevent = false;

        if (match === getWildcardSymbol()) {
          shouldPrevent = true;
        } else if (isValidMatchStr(match)) {
          var _parseMatchArg = parseMatchArg(match),
              isInvertedMatch = _parseMatchArg.isInvertedMatch,
              matchRegexp = _parseMatchArg.matchRegexp;

          shouldPrevent = matchRegexp.test(url) !== isInvertedMatch;
        } else {
          // eslint-disable-next-line no-console
          console.log("Invalid parameter: ".concat(match));
          shouldPrevent = false;
        }

        if (shouldPrevent) {
          var parsedDelay = parseInt(delay, 10);
          var result;

          if (nativeIsNaN(parsedDelay)) {
            result = noopNull();
          } else {
            var decoyArgs = {
              replacement: replacement,
              url: url,
              delay: parsedDelay
            };
            var decoy = createDecoy(decoyArgs);
            var popup = decoy.contentWindow;

            if (typeof popup === 'object' && popup !== null) {
              Object.defineProperty(popup, 'closed', {
                value: false
              });
              Object.defineProperty(popup, 'opener', {
                value: window
              });
              Object.defineProperty(popup, 'frameElement', {
                value: null
              });
            } else {
              var nativeGetter = decoy.contentWindow && decoy.contentWindow.get;
              Object.defineProperty(decoy, 'contentWindow', {
                get: getPreventGetter(nativeGetter)
              });
              popup = decoy.contentWindow;
            }

            result = popup;
          }

          hit(source);
          return result;
        }

        return nativeOpen.apply(window, [url].concat(args));
      };

      window.open = isNewSyntax ? newOpenWrapper : oldOpenWrapper; // Protect window.open from native code check

      window.open.toString = nativeOpen.toString.bind(nativeOpen);
    }
    preventWindowOpen$1.names = ['prevent-window-open', // aliases are needed for matching the related scriptlet converted into our syntax
    'window.open-defuser.js', 'ubo-window.open-defuser.js', 'ubo-window.open-defuser', 'nowoif.js', 'ubo-nowoif.js', 'ubo-nowoif'];
    preventWindowOpen$1.injections = [hit, isValidStrPattern, escapeRegExp, isValidMatchStr, toRegExp, nativeIsNaN, parseMatchArg, handleOldReplacement, createDecoy, getPreventGetter, noopNull, getWildcardSymbol, noopFunc, trueFunc, startsWith, endsWith, substringBefore, substringAfter$1];

    /* eslint-disable max-len */

    /**
     * @scriptlet abort-current-inline-script
     *
     * @description
     * Aborts an inline script when it attempts to **read** or **write to** the specified property
     * AND when the contents of the `<script>` element contains the specified
     * text or matches the regular expression.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#abort-current-inline-scriptjs-
     *
     * Related ABP source:
     * https://github.com/adblockplus/adblockpluscore/blob/6b2a309054cc23432102b85d13f12559639ef495/lib/content/snippets.js#L928
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('abort-current-inline-script', property[, search])
     * ```
     *
     * - `property` - required, path to a property (joined with `.` if needed). The property must be attached to `window`
     * - `search` - optional, string or regular expression that must match the inline script content.
     * Defaults to abort all scripts which are trying to access the specified property.
     * Invalid regular expression will cause exit and rule will not work.
     *
     * > Note please that for inline script with addEventListener in it
     * `property` should be set as `EventTarget.prototype.addEventListener`,
     * not just `addEventListener`.
     *
     * **Examples**
     * 1. Aborts all inline scripts trying to access `window.alert`
     *     ```
     *     example.org#%#//scriptlet('abort-current-inline-script', 'alert')
     *     ```
     *
     * 2. Aborts inline scripts which are trying to access `window.alert` and contain `Hello, world`.
     *     ```
     *     example.org#%#//scriptlet('abort-current-inline-script', 'alert', 'Hello, world')
     *     ```
     *
     *     For instance, the following script will be aborted
     *     ```html
     *     <script>alert("Hello, world");</script>
     *     ```
     *
     * 3. Aborts inline scripts which are trying to access `window.alert` and match this regexp: `/Hello.+world/`.
     *     ```
     *     example.org#%#//scriptlet('abort-current-inline-script', 'alert', '/Hello.+world/')
     *     ```
     *
     *     For instance, the following scripts will be aborted:
     *     ```html
     *     <script>alert("Hello, big world");</script>
     *     ```
     *     ```html
     *     <script>alert("Hello, little world");</script>
     *     ```
     *
     *     This script will not be aborted:
     *     ```html
     *     <script>alert("Hi, little world");</script>
     *     ```
     */

    /* eslint-enable max-len */

    function abortCurrentInlineScript$1(source, property, search) {
      var searchRegexp = toRegExp(search);
      var rid = randomId();
      var SRC_DATA_MARKER = 'data:text/javascript;base64,';

      var getCurrentScript = function getCurrentScript() {
        if ('currentScript' in document) {
          return document.currentScript; // eslint-disable-line compat/compat
        }

        var scripts = document.getElementsByTagName('script');
        return scripts[scripts.length - 1];
      };

      var ourScript = getCurrentScript();

      var abort = function abort() {
        var scriptEl = getCurrentScript();

        if (!scriptEl) {
          return;
        }

        var content = scriptEl.textContent; // We are using Node.prototype.textContent property descriptor
        // to get the real script content
        // even when document.currentScript.textContent is replaced.
        // https://github.com/AdguardTeam/Scriptlets/issues/57#issuecomment-593638991

        try {
          var textContentGetter = Object.getOwnPropertyDescriptor(Node.prototype, 'textContent').get;
          content = textContentGetter.call(scriptEl);
        } catch (e) {} // eslint-disable-line no-empty
        // https://github.com/AdguardTeam/Scriptlets/issues/130


        if (content.length === 0 && typeof scriptEl.src !== 'undefined' && startsWith(scriptEl.src, SRC_DATA_MARKER)) {
          var encodedContent = scriptEl.src.slice(SRC_DATA_MARKER.length);
          content = window.atob(encodedContent);
        }

        if (scriptEl instanceof HTMLScriptElement && content.length > 0 && scriptEl !== ourScript && searchRegexp.test(content)) {
          hit(source);
          throw new ReferenceError(rid);
        }
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain; // The scriptlet might be executed before the chain property has been created
        // (for instance, document.body before the HTML body was loaded).
        // In this case we're checking whether the base element exists or not
        // and if not, we simply exit without overriding anything.
        // e.g. https://github.com/AdguardTeam/Scriptlets/issues/57#issuecomment-575841092

        if (base instanceof Object === false && base === null) {
          var props = property.split('.');
          var propIndex = props.indexOf(prop);
          var baseName = props[propIndex - 1];
          console.log("The scriptlet had been executed before the ".concat(baseName, " was loaded.")); // eslint-disable-line no-console, max-len

          return;
        }

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        var currentValue = base[prop];
        var origDescriptor = Object.getOwnPropertyDescriptor(base, prop);

        if (origDescriptor instanceof Object === false || origDescriptor.get instanceof Function === false) {
          currentValue = base[prop];
          origDescriptor = undefined;
        }

        var descriptorWrapper = Object.assign(getDescriptorAddon(), {
          currentValue: currentValue,
          get: function get() {
            if (!this.isAbortingSuspended) {
              this.isolateCallback(abort);
            }

            if (origDescriptor instanceof Object) {
              return origDescriptor.get.call(base);
            }

            return this.currentValue;
          },
          set: function set(newValue) {
            if (!this.isAbortingSuspended) {
              this.isolateCallback(abort);
            }

            if (origDescriptor instanceof Object) {
              origDescriptor.set.call(base, newValue);
            } else {
              this.currentValue = newValue;
            }
          }
        });
        setPropertyAccess(base, prop, {
          // Call wrapped getter and setter to keep isAbortingSuspended & isolateCallback values
          get: function get() {
            return descriptorWrapper.get.call(descriptorWrapper);
          },
          set: function set(newValue) {
            descriptorWrapper.set.call(descriptorWrapper, newValue);
          }
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    abortCurrentInlineScript$1.names = ['abort-current-inline-script', // aliases are needed for matching the related scriptlet converted into our syntax
    'abort-current-script.js', 'ubo-abort-current-script.js', 'acs.js', 'ubo-acs.js', // "ubo"-aliases with no "js"-ending
    'ubo-abort-current-script', 'ubo-acs', // obsolete but supported aliases
    'abort-current-inline-script.js', 'ubo-abort-current-inline-script.js', 'acis.js', 'ubo-acis.js', 'ubo-abort-current-inline-script', 'ubo-acis', 'abp-abort-current-inline-script'];
    abortCurrentInlineScript$1.injections = [randomId, setPropertyAccess, getPropertyInChain, toRegExp, startsWith, createOnErrorHandler, hit, getDescriptorAddon];

    /* eslint-disable max-len */

    /**
     * @scriptlet set-constant
     *
     * @description
     * Creates a constant property and assigns it one of the values from the predefined list.
     *
     * > Actually, it's not a constant. Please note, that it can be rewritten with a value of a different type.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#set-constantjs-
     *
     * Related ABP snippet:
     * https://github.com/adblockplus/adblockpluscore/blob/adblockpluschrome-3.9.4/lib/content/snippets.js#L1361
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('set-constant', property, value[, stack])
     * ```
     *
     * - `property` - required, path to a property (joined with `.` if needed). The property must be attached to `window`.
     * - `value` - required. Possible values:
     *     - positive decimal integer `<= 32767`
     *     - one of the predefined constants:
     *         - `undefined`
     *         - `false`
     *         - `true`
     *         - `null`
     *         - `emptyObj` - empty object
     *         - `emptyArr` - empty array
     *         - `noopFunc` - function with empty body
     *         - `trueFunc` - function returning true
     *         - `falseFunc` - function returning false
     *         - `noopPromiseResolve` - function returning Promise object that is resolved with an empty response
     *         - `noopPromiseReject` - function returning Promise.reject()
     *         - `''` - empty string
     *         - `-1` - number value `-1`
     *         - `yes`
     *         - `no`
     * - `stack` - optional, string or regular expression that must match the current function call stack trace;
     * if regular expression is invalid it will be skipped
     *
     * **Examples**
     * ```
     * ! Any access to `window.first` will return `false`
     * example.org#%#//scriptlet('set-constant', 'first', 'false')
     *
     * ✔ window.first === false
     * ```
     *
     * ```
     * ! Any call to `window.second()` will return `true`
     * example.org#%#//scriptlet('set-constant', 'second', 'trueFunc')
     *
     * ✔ window.second() === true
     * ✔ window.second.toString() === "function trueFunc() {return true;}"
     * ```
     *
     * ```
     * ! Any call to `document.third()` will return `true` if the method is related to `checking.js`
     * example.org#%#//scriptlet('set-constant', 'document.third', 'trueFunc', 'checking.js')
     *
     * ✔ document.third() === true  // if the condition described above is met
     * ```
     */

    /* eslint-enable max-len */

    function setConstant$1(source, property, value, stack) {
      if (!property || !matchStackTrace(stack, new Error().stack)) {
        return;
      } // eslint-disable-next-line no-console


      var log = console.log.bind(console);
      var emptyArr = noopArray();
      var emptyObj = noopObject();
      var constantValue;

      if (value === 'undefined') {
        constantValue = undefined;
      } else if (value === 'false') {
        constantValue = false;
      } else if (value === 'true') {
        constantValue = true;
      } else if (value === 'null') {
        constantValue = null;
      } else if (value === 'emptyArr') {
        constantValue = emptyArr;
      } else if (value === 'emptyObj') {
        constantValue = emptyObj;
      } else if (value === 'noopFunc') {
        constantValue = noopFunc;
      } else if (value === 'trueFunc') {
        constantValue = trueFunc;
      } else if (value === 'falseFunc') {
        constantValue = falseFunc;
      } else if (value === 'noopPromiseResolve') {
        constantValue = noopPromiseResolve;
      } else if (value === 'noopPromiseReject') {
        constantValue = noopPromiseReject;
      } else if (/^\d+$/.test(value)) {
        constantValue = parseFloat(value);

        if (nativeIsNaN(constantValue)) {
          return;
        }

        if (Math.abs(constantValue) > 0x7FFF) {
          return;
        }
      } else if (value === '-1') {
        constantValue = -1;
      } else if (value === '') {
        constantValue = '';
      } else if (value === 'yes') {
        constantValue = 'yes';
      } else if (value === 'no') {
        constantValue = 'no';
      } else {
        return;
      }

      var canceled = false;

      var mustCancel = function mustCancel(value) {
        if (canceled) {
          return canceled;
        }

        canceled = value !== undefined && constantValue !== undefined && typeof value !== typeof constantValue;
        return canceled;
      };

      var trapProp = function trapProp(base, prop, configurable, handler) {
        if (!handler.init(base[prop])) {
          return false;
        }

        var origDescriptor = Object.getOwnPropertyDescriptor(base, prop);
        var prevSetter; // This is required to prevent scriptlets overwrite each over

        if (origDescriptor instanceof Object) {
          // This check is required to avoid defining non-configurable props
          if (!origDescriptor.configurable) {
            if (source.verbose) {
              log("set-constant: property '".concat(prop, "' is not configurable"));
            }

            return false;
          }

          base[prop] = constantValue;

          if (origDescriptor.set instanceof Function) {
            prevSetter = origDescriptor.set;
          }
        }

        Object.defineProperty(base, prop, {
          configurable: configurable,
          get: function get() {
            return handler.get();
          },
          set: function set(a) {
            if (prevSetter !== undefined) {
              prevSetter(a);
            }

            handler.set(a);
          }
        });
        return true;
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain; // Handler method init is used to keep track of factual value
        // and apply mustCancel() check only on end prop

        var undefPropHandler = {
          factValue: undefined,
          init: function init(a) {
            this.factValue = a;
            return true;
          },
          get: function get() {
            return this.factValue;
          },
          set: function set(a) {
            // Prevent breakage due to loop assignments like win.obj = win.obj
            if (this.factValue === a) {
              return;
            }

            this.factValue = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          }
        };
        var endPropHandler = {
          init: function init(a) {
            if (mustCancel(a)) {
              return false;
            }

            return true;
          },
          get: function get() {
            return constantValue;
          },
          set: function set(a) {
            if (!mustCancel(a)) {
              return;
            }

            constantValue = a;
          }
        }; // End prop case

        if (!chain) {
          var isTrapped = trapProp(base, prop, false, endPropHandler);

          if (isTrapped) {
            hit(source);
          }

          return;
        } // Defined prop in chain


        var propValue = owner[prop];

        if (propValue instanceof Object || typeof propValue === 'object' && propValue !== null) {
          setChainPropAccess(propValue, chain);
        } // Undefined prop in chain


        trapProp(base, prop, true, undefPropHandler);
      };

      setChainPropAccess(window, property);
    }
    setConstant$1.names = ['set-constant', // aliases are needed for matching the related scriptlet converted into our syntax
    'set-constant.js', 'ubo-set-constant.js', 'set.js', 'ubo-set.js', 'ubo-set-constant', 'ubo-set', 'abp-override-property-read'];
    setConstant$1.injections = [hit, noopArray, noopObject, noopFunc, trueFunc, falseFunc, noopPromiseReject, noopPromiseResolve, getPropertyInChain, setPropertyAccess, toRegExp, matchStackTrace, nativeIsNaN, getNativeRegexpTest];

    /* eslint-disable max-len */

    /**
     * @scriptlet remove-cookie
     *
     * @description
     * Removes current page cookies by passed string matching with name. For current domain and subdomains. Runs on load and before unload.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#cookie-removerjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('remove-cookie'[, match])
     * ```
     *
     * - `match` - optional, string or regex matching the cookie name. If not specified all accessible cookies will be removed.
     *
     * **Examples**
     * 1. Removes all cookies:
     * ```
     *     example.org#%#//scriptlet('remove-cookie')
     * ```
     *
     * 2. Removes cookies which name contains `example` string.
     * ```
     *     example.org#%#//scriptlet('remove-cookie', 'example')
     * ```
     *
     *     For instance this cookie will be removed
     *     ```javascript
     *     document.cookie = '__example=randomValue';
     *     ```
     */

    /* eslint-enable max-len */

    function removeCookie$1(source, match) {
      var matchRegexp = toRegExp(match);

      var removeCookieFromHost = function removeCookieFromHost(cookieName, hostName) {
        var cookieSpec = "".concat(cookieName, "=");
        var domain1 = "; domain=".concat(hostName);
        var domain2 = "; domain=.".concat(hostName);
        var path = '; path=/';
        var expiration = '; expires=Thu, 01 Jan 1970 00:00:00 GMT';
        document.cookie = cookieSpec + expiration;
        document.cookie = cookieSpec + domain1 + expiration;
        document.cookie = cookieSpec + domain2 + expiration;
        document.cookie = cookieSpec + path + expiration;
        document.cookie = cookieSpec + domain1 + path + expiration;
        document.cookie = cookieSpec + domain2 + path + expiration;
        hit(source);
      };

      var rmCookie = function rmCookie() {
        document.cookie.split(';').forEach(function (cookieStr) {
          var pos = cookieStr.indexOf('=');

          if (pos === -1) {
            return;
          }

          var cookieName = cookieStr.slice(0, pos).trim();

          if (!matchRegexp.test(cookieName)) {
            return;
          }

          var hostParts = document.location.hostname.split('.');

          for (var i = 0; i <= hostParts.length - 1; i += 1) {
            var hostName = hostParts.slice(i).join('.');

            if (hostName) {
              removeCookieFromHost(cookieName, hostName);
            }
          }
        });
      };

      rmCookie();
      window.addEventListener('beforeunload', rmCookie);
    }
    removeCookie$1.names = ['remove-cookie', // aliases are needed for matching the related scriptlet converted into our syntax
    'cookie-remover.js', 'ubo-cookie-remover.js', 'ubo-cookie-remover'];
    removeCookie$1.injections = [toRegExp, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-addEventListener
     *
     * @description
     * Prevents adding event listeners for the specified events and callbacks.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#addeventlistener-defuserjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-addEventListener'[, typeSearch[, listenerSearch]])
     * ```
     *
     * - `typeSearch` - optional, string or regular expression matching the type (event name);
     * defaults to match all types; invalid regular expression will cause exit and rule will not work
     * - `listenerSearch` - optional, string or regular expression matching the listener function body;
     * defaults to match all listeners; invalid regular expression will cause exit and rule will not work
     *
     * **Examples**
     * 1. Prevent all `click` listeners:
     * ```
     *     example.org#%#//scriptlet('prevent-addEventListener', 'click')
     * ```

    2. Prevent 'click' listeners with the callback body containing `searchString`.
     * ```
     *     example.org#%#//scriptlet('prevent-addEventListener', 'click', 'searchString')
     * ```
     *
     *     For instance, this listener will not be called:
     * ```javascript
     *     el.addEventListener('click', () => {
     *         window.test = 'searchString';
     *     });
     * ```
     */

    /* eslint-enable max-len */

    function preventAddEventListener$1(source, typeSearch, listenerSearch) {
      var typeSearchRegexp = toRegExp(typeSearch);
      var listenerSearchRegexp = toRegExp(listenerSearch);
      var nativeAddEventListener = window.EventTarget.prototype.addEventListener;

      function addEventListenerWrapper(type, listener) {
        var shouldPrevent = false;

        if (validateType(type) && validateListener(listener)) {
          shouldPrevent = typeSearchRegexp.test(type.toString()) && listenerSearchRegexp.test(listenerToString(listener));
        }

        if (shouldPrevent) {
          hit(source);
          return undefined;
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeAddEventListener.apply(this, [type, listener].concat(args));
      }

      window.EventTarget.prototype.addEventListener = addEventListenerWrapper; // https://github.com/AdguardTeam/Scriptlets/issues/143

      window.addEventListener = addEventListenerWrapper;
      document.addEventListener = addEventListenerWrapper;
    }
    preventAddEventListener$1.names = ['prevent-addEventListener', // aliases are needed for matching the related scriptlet converted into our syntax
    'addEventListener-defuser.js', 'ubo-addEventListener-defuser.js', 'aeld.js', 'ubo-aeld.js', 'ubo-addEventListener-defuser', 'ubo-aeld'];
    preventAddEventListener$1.injections = [hit, toRegExp, validateType, validateListener, listenerToString];

    /* eslint-disable consistent-return, no-eval */
    /**
     * @scriptlet prevent-bab
     *
     * @description
     * Prevents BlockAdblock script from detecting an ad blocker.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#bab-defuserjs-
     *
     * It also can be used as `$redirect` sometimes.
     * See [redirect description](../wiki/about-redirects.md#prevent-bab).
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-bab')
     * ```
     */

    function preventBab$1(source) {
      var nativeSetTimeout = window.setTimeout;
      var babRegex = /\.bab_elementid.$/;

      var timeoutWrapper = function timeoutWrapper(callback) {
        if (typeof callback !== 'string' || !babRegex.test(callback)) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          return nativeSetTimeout.apply(window, [callback].concat(args));
        }

        hit(source);
      };

      window.setTimeout = timeoutWrapper;
      var signatures = [['blockadblock'], ['babasbm'], [/getItem\('babn'\)/], ['getElementById', 'String.fromCharCode', 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', 'charAt', 'DOMContentLoaded', 'AdBlock', 'addEventListener', 'doScroll', 'fromCharCode', '<<2|r>>4', 'sessionStorage', 'clientWidth', 'localStorage', 'Math', 'random']];

      var check = function check(str) {
        if (typeof str !== 'string') {
          return false;
        }

        for (var i = 0; i < signatures.length; i += 1) {
          var tokens = signatures[i];
          var match = 0;

          for (var j = 0; j < tokens.length; j += 1) {
            var token = tokens[j];
            var found = token instanceof RegExp ? token.test(str) : str.indexOf(token) > -1;

            if (found) {
              match += 1;
            }
          }

          if (match / tokens.length >= 0.8) {
            return true;
          }
        }

        return false;
      };

      var nativeEval = window.eval;

      var evalWrapper = function evalWrapper(str) {
        if (!check(str)) {
          return nativeEval(str);
        }

        hit(source);
        var bodyEl = document.body;

        if (bodyEl) {
          bodyEl.style.removeProperty('visibility');
        }

        var el = document.getElementById('babasbmsgx');

        if (el) {
          el.parentNode.removeChild(el);
        }
      };

      window.eval = evalWrapper.bind(window);
    }
    preventBab$1.names = ['prevent-bab', // aliases are needed for matching the related scriptlet converted into our syntax
    'nobab.js', 'ubo-nobab.js', 'bab-defuser.js', 'ubo-bab-defuser.js', 'ubo-nobab', 'ubo-bab-defuser'];
    preventBab$1.injections = [hit];

    /* eslint-disable no-unused-vars, no-extra-bind, func-names */
    /* eslint-disable max-len */

    /**
     * @scriptlet nowebrtc
     *
     * @description
     * Disables WebRTC by overriding `RTCPeerConnection`. The overridden function will log every attempt to create a new connection.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#nowebrtcjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('nowebrtc')
     * ```
     */

    /* eslint-enable max-len */

    function nowebrtc$1(source) {
      var propertyName = '';

      if (window.RTCPeerConnection) {
        propertyName = 'RTCPeerConnection';
      } else if (window.webkitRTCPeerConnection) {
        propertyName = 'webkitRTCPeerConnection';
      }

      if (propertyName === '') {
        return;
      }

      var rtcReplacement = function rtcReplacement(config) {
        // eslint-disable-next-line max-len
        hit(source, "Document tried to create an RTCPeerConnection: ".concat(convertRtcConfigToString(config)));
      };

      rtcReplacement.prototype = {
        close: noopFunc,
        createDataChannel: noopFunc,
        createOffer: noopFunc,
        setRemoteDescription: noopFunc
      };
      var rtc = window[propertyName];
      window[propertyName] = rtcReplacement;

      if (rtc.prototype) {
        rtc.prototype.createDataChannel = function (a, b) {
          return {
            close: noopFunc,
            send: noopFunc
          };
        }.bind(null);
      }
    }
    nowebrtc$1.names = ['nowebrtc', // aliases are needed for matching the related scriptlet converted into our syntax
    'nowebrtc.js', 'ubo-nowebrtc.js', 'ubo-nowebrtc'];
    nowebrtc$1.injections = [hit, noopFunc, convertRtcConfigToString];

    /**
     * @scriptlet log-addEventListener
     *
     * @description
     * Logs all addEventListener calls to the console.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#addeventlistener-loggerjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('log-addEventListener')
     * ```
     */

    function logAddEventListener$1(source) {
      // eslint-disable-next-line no-console
      var log = console.log.bind(console);
      var nativeAddEventListener = window.EventTarget.prototype.addEventListener;

      function addEventListenerWrapper(type, listener) {
        if (validateType(type) && validateListener(listener)) {
          var logMessage = "addEventListener(\"".concat(type, "\", ").concat(listenerToString(listener), ")");
          log(logMessage);
          hit(source);
        } else if (source.verbose) {
          // logging while debugging
          var _logMessage = "Invalid event type or listener passed to addEventListener:\ntype: ".concat(convertTypeToString(type), "\nlistener: ").concat(convertTypeToString(listener));

          log(_logMessage);
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeAddEventListener.apply(this, [type, listener].concat(args));
      }

      window.EventTarget.prototype.addEventListener = addEventListenerWrapper;
    }
    logAddEventListener$1.names = ['log-addEventListener', // aliases are needed for matching the related scriptlet converted into our syntax
    'addEventListener-logger.js', 'ubo-addEventListener-logger.js', 'aell.js', 'ubo-aell.js', 'ubo-addEventListener-logger', 'ubo-aell'];
    logAddEventListener$1.injections = [hit, validateType, validateListener, listenerToString, convertTypeToString, objectToString, isEmptyObject, getObjectEntries];

    /* eslint-disable no-console, no-eval */
    /**
     * @scriptlet log-eval
     *
     * @description
     * Logs all `eval()` or `new Function()` calls to the console.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('log-eval')
     * ```
     */

    function logEval$1(source) {
      var log = console.log.bind(console); // wrap eval function

      var nativeEval = window.eval;

      function evalWrapper(str) {
        hit(source);
        log("eval(\"".concat(str, "\")"));
        return nativeEval(str);
      }

      window.eval = evalWrapper; // wrap new Function

      var nativeFunction = window.Function;

      function FunctionWrapper() {
        hit(source);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        log("new Function(".concat(args.join(', '), ")"));
        return nativeFunction.apply(this, [].concat(args));
      }

      FunctionWrapper.prototype = Object.create(nativeFunction.prototype);
      FunctionWrapper.prototype.constructor = FunctionWrapper;
      window.Function = FunctionWrapper;
    }
    logEval$1.names = ['log-eval'];
    logEval$1.injections = [hit];

    /**
     * @scriptlet log
     *
     * @description
     * A simple scriptlet which only purpose is to print arguments to console.
     * This scriptlet can be helpful for debugging and troubleshooting other scriptlets.
     *
     * **Example**
     * ```
     * example.org#%#//scriptlet('log', 'arg1', 'arg2')
     * ```
     */
    function log$1() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      console.log(args); // eslint-disable-line no-console
    }
    log$1.names = ['log'];

    /* eslint-disable no-eval, no-extra-bind */
    /**
     * @scriptlet noeval
     *
     * @description
     * Prevents page to use eval.
     * Notifies about attempts in the console
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#noevaljs-
     *
     * It also can be used as `$redirect` rules sometimes.
     * See [redirect description](../wiki/about-redirects.md#noeval).
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('noeval')
     * ```
     */

    function noeval$1(source) {
      window.eval = function evalWrapper(s) {
        hit(source, "AdGuard has prevented eval:\n".concat(s));
      }.bind();
    }
    noeval$1.names = ['noeval', // aliases are needed for matching the related scriptlet converted into our syntax
    'noeval.js', 'silent-noeval.js', 'ubo-noeval.js', 'ubo-silent-noeval.js', 'ubo-noeval', 'ubo-silent-noeval'];
    noeval$1.injections = [hit];

    /* eslint-disable no-eval, no-extra-bind, func-names */
    /**
     * @scriptlet prevent-eval-if
     *
     * @description
     * Prevents page to use eval matching payload.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#noeval-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-eval-if'[, search])
     * ```
     *
     * - `search` - optional, string or regular expression matching the stringified eval payload;
     * defaults to match all stringified eval payloads;
     * invalid regular expression will cause exit and rule will not work
     *
     * **Examples**
     * ```
     * ! Prevents eval if it matches 'test'
     * example.org#%#//scriptlet('prevent-eval-if', 'test')
     * ```
     */

    function preventEvalIf$1(source, search) {
      var searchRegexp = toRegExp(search);
      var nativeEval = window.eval;

      window.eval = function (payload) {
        if (!searchRegexp.test(payload.toString())) {
          return nativeEval.call(window, payload);
        }

        hit(source, payload);
        return undefined;
      }.bind(window);
    }
    preventEvalIf$1.names = ['prevent-eval-if', // aliases are needed for matching the related scriptlet converted into our syntax
    'noeval-if.js', 'ubo-noeval-if.js', 'ubo-noeval-if'];
    preventEvalIf$1.injections = [toRegExp, hit];

    /* eslint-disable no-console, func-names, no-multi-assign */
    /**
     * @scriptlet prevent-fab-3.2.0
     *
     * @description
     * Prevents execution of the FAB script v3.2.0.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#fuckadblockjs-320-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-fab-3.2.0')
     * ```
     */

    function preventFab$1(source) {
      hit(source); // redefines Fab function for adblock detection

      var Fab = function Fab() {};

      Fab.prototype.check = noopFunc;
      Fab.prototype.clearEvent = noopFunc;
      Fab.prototype.emitEvent = noopFunc;

      Fab.prototype.on = function (a, b) {
        if (!a) {
          b();
        }

        return this;
      };

      Fab.prototype.onDetected = noopThis;

      Fab.prototype.onNotDetected = function (a) {
        a();
        return this;
      };

      Fab.prototype.setOption = noopFunc;
      Fab.prototype.options = {
        set: noopFunc,
        get: noopFunc
      };
      var fab = new Fab();
      var getSetFab = {
        get: function get() {
          return Fab;
        },
        set: function set() {}
      };
      var getsetfab = {
        get: function get() {
          return fab;
        },
        set: function set() {}
      }; // redefined Fab data properties which if 'FuckAdBlock' variable exists

      if (Object.prototype.hasOwnProperty.call(window, 'FuckAdBlock')) {
        window.FuckAdBlock = Fab;
      } else {
        // or redefined Fab accessor properties
        Object.defineProperty(window, 'FuckAdBlock', getSetFab);
      }

      if (Object.prototype.hasOwnProperty.call(window, 'BlockAdBlock')) {
        window.BlockAdBlock = Fab;
      } else {
        Object.defineProperty(window, 'BlockAdBlock', getSetFab);
      }

      if (Object.prototype.hasOwnProperty.call(window, 'SniffAdBlock')) {
        window.SniffAdBlock = Fab;
      } else {
        Object.defineProperty(window, 'SniffAdBlock', getSetFab);
      }

      if (Object.prototype.hasOwnProperty.call(window, 'fuckAdBlock')) {
        window.fuckAdBlock = fab;
      } else {
        Object.defineProperty(window, 'fuckAdBlock', getsetfab);
      }

      if (Object.prototype.hasOwnProperty.call(window, 'blockAdBlock')) {
        window.blockAdBlock = fab;
      } else {
        Object.defineProperty(window, 'blockAdBlock', getsetfab);
      }

      if (Object.prototype.hasOwnProperty.call(window, 'sniffAdBlock')) {
        window.sniffAdBlock = fab;
      } else {
        Object.defineProperty(window, 'sniffAdBlock', getsetfab);
      }
    }
    preventFab$1.names = ['prevent-fab-3.2.0', // aliases are needed for matching the related scriptlet converted into our syntax
    'nofab.js', 'ubo-nofab.js', 'fuckadblock.js-3.2.0', 'ubo-fuckadblock.js-3.2.0', 'ubo-nofab'];
    preventFab$1.injections = [hit, noopFunc, noopThis];

    /* eslint-disable no-console, func-names, no-multi-assign */
    /**
     * @scriptlet set-popads-dummy
     *
     * @description
     * Sets static properties PopAds and popns.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#popads-dummyjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('set-popads-dummy')
     * ```
     */

    function setPopadsDummy$1(source) {
      delete window.PopAds;
      delete window.popns;
      Object.defineProperties(window, {
        PopAds: {
          get: function get() {
            hit(source);
            return {};
          }
        },
        popns: {
          get: function get() {
            hit(source);
            return {};
          }
        }
      });
    }
    setPopadsDummy$1.names = ['set-popads-dummy', // aliases are needed for matching the related scriptlet converted into our syntax
    'popads-dummy.js', 'ubo-popads-dummy.js', 'ubo-popads-dummy'];
    setPopadsDummy$1.injections = [hit];

    /**
     * @scriptlet prevent-popads-net
     *
     * @description
     * Aborts on property write (PopAds, popns), throws reference error with random id.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#popadsnetjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-popads-net')
     * ```
     */

    function preventPopadsNet$1(source) {
      var rid = randomId();

      var throwError = function throwError() {
        throw new ReferenceError(rid);
      };

      delete window.PopAds;
      delete window.popns;
      Object.defineProperties(window, {
        PopAds: {
          set: throwError
        },
        popns: {
          set: throwError
        }
      });
      window.onerror = createOnErrorHandler(rid).bind();
      hit(source);
    }
    preventPopadsNet$1.names = ['prevent-popads-net', // aliases are needed for matching the related scriptlet converted into our syntax
    'popads.net.js', 'ubo-popads.net.js', 'ubo-popads.net'];
    preventPopadsNet$1.injections = [createOnErrorHandler, randomId, hit];

    /* eslint-disable func-names */
    /**
     * @scriptlet prevent-adfly
     *
     * @description
     * Prevents anti-adblock scripts on adfly short links.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#adfly-defuserjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-adfly')
     * ```
     */

    function preventAdfly$1(source) {
      var isDigit = function isDigit(data) {
        return /^\d$/.test(data);
      };

      var handler = function handler(encodedURL) {
        var evenChars = '';
        var oddChars = '';

        for (var i = 0; i < encodedURL.length; i += 1) {
          if (i % 2 === 0) {
            evenChars += encodedURL.charAt(i);
          } else {
            oddChars = encodedURL.charAt(i) + oddChars;
          }
        }

        var data = (evenChars + oddChars).split('');

        for (var _i = 0; _i < data.length; _i += 1) {
          if (isDigit(data[_i])) {
            for (var ii = _i + 1; ii < data.length; ii += 1) {
              if (isDigit(data[ii])) {
                // eslint-disable-next-line no-bitwise
                var temp = parseInt(data[_i], 10) ^ parseInt(data[ii], 10);

                if (temp < 10) {
                  data[_i] = temp.toString();
                }

                _i = ii;
                break;
              }
            }
          }
        }

        data = data.join('');
        var decodedURL = window.atob(data).slice(16, -16);
        /* eslint-disable compat/compat */

        if (window.stop) {
          window.stop();
        }
        /* eslint-enable compat/compat */


        window.onbeforeunload = null;
        window.location.href = decodedURL;
      };

      var val; // Do not apply handler more than one time

      var applyHandler = true;
      var result = setPropertyAccess(window, 'ysmm', {
        configurable: false,
        set: function set(value) {
          if (applyHandler) {
            applyHandler = false;

            try {
              if (typeof value === 'string') {
                handler(value);
              }
            } catch (err) {} // eslint-disable-line no-empty

          }

          val = value;
        },
        get: function get() {
          return val;
        }
      });

      if (result) {
        hit(source);
      } else {
        window.console.error('Failed to set up prevent-adfly scriptlet');
      }
    }
    preventAdfly$1.names = ['prevent-adfly', // aliases are needed for matching the related scriptlet converted into our syntax
    'adfly-defuser.js', 'ubo-adfly-defuser.js', 'ubo-adfly-defuser'];
    preventAdfly$1.injections = [setPropertyAccess, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet debug-on-property-read
     *
     * @description
     * This scriptlet is basically the same as [abort-on-property-read](#abort-on-property-read), but instead of aborting it starts the debugger.
     *
     * **It is not supposed to be used in production filter lists!**
     *
     * **Syntax**
     * ```
     * ! Debug script if it tries to access `window.alert`
     * example.org#%#//scriptlet('debug-on-property-read', 'alert')
     * ! of `window.open`
     * example.org#%#//scriptlet('debug-on-property-read', 'open')
     * ```
     */

    /* eslint-enable max-len */

    function debugOnPropertyRead$1(source, property) {
      if (!property) {
        return;
      }

      var rid = randomId();

      var abort = function abort() {
        hit(source);
        debugger; // eslint-disable-line no-debugger
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        setPropertyAccess(base, prop, {
          get: abort,
          set: noopFunc
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    debugOnPropertyRead$1.names = ['debug-on-property-read'];
    debugOnPropertyRead$1.injections = [randomId, setPropertyAccess, getPropertyInChain, createOnErrorHandler, hit, noopFunc];

    /* eslint-disable max-len */

    /**
     * @scriptlet debug-on-property-write
     *
     * @description
     * This scriptlet is basically the same as [abort-on-property-write](#abort-on-property-write), but instead of aborting it starts the debugger.
     *
     * **It is not supposed to be used in production filter lists!**
     *
     * **Syntax**
     * ```
     * ! Aborts script when it tries to write in property `window.test`
     * example.org#%#//scriptlet('debug-on-property-write', 'test')
     * ```
     */

    /* eslint-enable max-len */

    function debugOnPropertyWrite$1(source, property) {
      if (!property) {
        return;
      }

      var rid = randomId();

      var abort = function abort() {
        hit(source);
        debugger; // eslint-disable-line no-debugger
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        setPropertyAccess(base, prop, {
          set: abort
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    debugOnPropertyWrite$1.names = ['debug-on-property-write'];
    debugOnPropertyWrite$1.injections = [randomId, setPropertyAccess, getPropertyInChain, createOnErrorHandler, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet debug-current-inline-script
     *
     * @description
     * This scriptlet is basically the same as [abort-current-inline-script](#abort-current-inline-script), but instead of aborting it starts the debugger.
     *
     * **It is not supposed to be used in production filter lists!**
     *
     * **Syntax**
     *```
     * ! Aborts script when it tries to access `window.alert`
     * example.org#%#//scriptlet('debug-current-inline-script', 'alert')
     * ```
     */

    /* eslint-enable max-len */

    function debugCurrentInlineScript$1(source, property, search) {
      var searchRegexp = toRegExp(search);
      var rid = randomId();

      var getCurrentScript = function getCurrentScript() {
        if ('currentScript' in document) {
          return document.currentScript; // eslint-disable-line compat/compat
        }

        var scripts = document.getElementsByTagName('script');
        return scripts[scripts.length - 1];
      };

      var ourScript = getCurrentScript();

      var abort = function abort() {
        var scriptEl = getCurrentScript();

        if (!scriptEl) {
          return;
        }

        var content = scriptEl.textContent; // We are using Node.prototype.textContent property descriptor
        // to get the real script content
        // even when document.currentScript.textContent is replaced.
        // https://github.com/AdguardTeam/Scriptlets/issues/57#issuecomment-593638991

        try {
          var textContentGetter = Object.getOwnPropertyDescriptor(Node.prototype, 'textContent').get;
          content = textContentGetter.call(scriptEl);
        } catch (e) {} // eslint-disable-line no-empty


        if (scriptEl instanceof HTMLScriptElement && content.length > 0 && scriptEl !== ourScript && searchRegexp.test(content)) {
          hit(source);
          debugger; // eslint-disable-line no-debugger
        }
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain; // The scriptlet might be executed before the chain property has been created
        // (for instance, document.body before the HTML body was loaded).
        // In this case we're checking whether the base element exists or not
        // and if not, we simply exit without overriding anything.
        // e.g. https://github.com/AdguardTeam/Scriptlets/issues/57#issuecomment-575841092

        if (base instanceof Object === false && base === null) {
          var props = property.split('.');
          var propIndex = props.indexOf(prop);
          var baseName = props[propIndex - 1];
          console.log("The scriptlet had been executed before the ".concat(baseName, " was loaded.")); // eslint-disable-line no-console, max-len

          return;
        }

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        var currentValue = base[prop];
        setPropertyAccess(base, prop, {
          set: function set(value) {
            abort();
            currentValue = value;
          },
          get: function get() {
            abort();
            return currentValue;
          }
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    debugCurrentInlineScript$1.names = ['debug-current-inline-script'];
    debugCurrentInlineScript$1.injections = [randomId, setPropertyAccess, getPropertyInChain, toRegExp, createOnErrorHandler, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet remove-attr
     *
     * @description
     * Removes the specified attributes from DOM nodes. This scriptlet runs once when the page loads
     * and after that periodically in order to DOM tree changes by default,
     * or as specified by applying argument.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#remove-attrjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('remove-attr', attrs[, selector, applying])
     * ```
     *
     * - `attrs` — required, attribute or list of attributes joined by '|'
     * - `selector` — optional, CSS selector, specifies DOM nodes from which the attributes will be removed
     * - `applying` — optional, one or more space-separated flags that describe the way scriptlet apply, defaults to 'asap stay'; possible flags:
     *     - `asap` — runs as fast as possible **once**
     *     - `complete` — runs **once** after the whole page has been loaded
     *     - `stay` — as fast as possible **and** stays on the page observing possible DOM changes
     *
     * **Examples**
     * 1.  Removes by attribute
     *     ```
     *     example.org#%#//scriptlet('remove-attr', 'example|test')
     *     ```
     *
     *     ```html
     *     <!-- before  -->
     *     <div example="true" test="true">Some text</div>
     *
     *     <!-- after -->
     *     <div>Some text</div>
     *     ```
     *
     * 2. Removes with specified selector
     *     ```
     *     example.org#%#//scriptlet('remove-attr', 'example', 'div[class="inner"]')
     *     ```
     *
     *     ```html
     *     <!-- before -->
     *     <div class="wrapper" example="true">
     *         <div class="inner" example="true">Some text</div>
     *     </div>
     *
     *     <!-- after -->
     *     <div class="wrapper" example="true">
     *         <div class="inner">Some text</div>
     *     </div>
     *     ```
     *
     *  3. Using flags
     *     ```
     *     example.org#%#//scriptlet('remove-attr', 'example', 'html', 'asap complete')
     *     ```
     */

    /* eslint-enable max-len */

    function removeAttr$1(source, attrs, selector) {
      var applying = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'asap stay';

      if (!attrs) {
        return;
      }

      attrs = attrs.split(/\s*\|\s*/);

      if (!selector) {
        selector = "[".concat(attrs.join('],['), "]");
      }

      var rmattr = function rmattr() {
        var nodes = [];

        try {
          nodes = [].slice.call(document.querySelectorAll(selector));
        } catch (e) {
          // eslint-disable-next-line no-console
          console.log("Invalid remove-attr selector arg: '".concat(selector, "'"));
        }

        var removed = false;
        nodes.forEach(function (node) {
          attrs.forEach(function (attr) {
            node.removeAttribute(attr);
            removed = true;
          });
        });

        if (removed) {
          hit(source);
        }
      };

      var flags = parseFlags(applying);

      var run = function run() {
        rmattr();

        if (!flags.hasFlag(flags.STAY)) {
          return;
        } // 'true' for observing attributes


        observeDOMChanges(rmattr, true);
      };

      if (flags.hasFlag(flags.ASAP)) {
        // https://github.com/AdguardTeam/Scriptlets/issues/245
        // Call rmattr on DOM content loaded
        // to ensure that target node is present on the page
        if (document.readyState === 'loading') {
          window.addEventListener('DOMContentLoaded', rmattr, {
            once: true
          });
        } else {
          rmattr();
        }
      }

      if (document.readyState !== 'complete' && flags.hasFlag(flags.COMPLETE)) {
        window.addEventListener('load', run, {
          once: true
        });
      } else if (flags.hasFlag(flags.STAY)) {
        // Only call rmattr for single 'stay' flag
        if (!applying.indexOf(' ') !== -1) {
          rmattr();
        } // 'true' for observing attributes


        observeDOMChanges(rmattr, true);
      }
    }
    removeAttr$1.names = ['remove-attr', // aliases are needed for matching the related scriptlet converted into our syntax
    'remove-attr.js', 'ubo-remove-attr.js', 'ra.js', 'ubo-ra.js', 'ubo-remove-attr', 'ubo-ra'];
    removeAttr$1.injections = [hit, observeDOMChanges, parseFlags];

    /* eslint-disable max-len */

    /**
     * @scriptlet set-attr
     *
     * @description
     * Sets the specified attribute on the specified elements. This scriptlet runs once when the page loads
     * and after that and after that on DOM tree changes.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('set-attr', selector, attr[, value])
     * ```
     *
     * - `selector` — required, CSS selector, specifies DOM nodes to set attributes on
     * - `attr` — required, attribute to be set
     * - `value` — the value to assign to the attribute, defaults to ''. Possible values:
     *     - `''` - empty string
     *     - positive decimal integer `<= 32767`
     *
     * **Examples**
     * 1.  Set attribute by selector
     *     ```
     *     example.org#%#//scriptlet('set-attr', 'div.class > a.class', 'test-attribute', '0')
     *     ```
     *
     *     ```html
     *     <!-- before  -->
     *     <a class="class">Some text</div>
     *
     *     <!-- after -->
     *     <a class="class" test-attribute="0">Some text</div>
     *     ```
     * 2.  Set attribute without value
     *     ```
     *     example.org#%#//scriptlet('set-attr', 'div.class > a.class', 'test-attribute')
     *     ```
     *
     *     ```html
     *     <!-- before  -->
     *     <a class="class">Some text</div>
     *
     *     <!-- after -->
     *     <a class="class" test-attribute>Some text</div>
     *     ```
     */

    /* eslint-enable max-len */

    function setAttr$1(source, selector, attr) {
      var value = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';

      if (!selector || !attr) {
        return;
      } // Drop strings that cant be parsed into number, negative numbers and numbers below 32767


      if (value.length !== 0 && (nativeIsNaN(parseInt(value, 10)) || parseInt(value, 10) < 0 || parseInt(value, 10) > 0x7FFF)) {
        return;
      }

      var setAttr = function setAttr() {
        var nodes = [].slice.call(document.querySelectorAll(selector));
        var set = false;
        nodes.forEach(function (node) {
          node.setAttribute(attr, value);
          set = true;
        });

        if (set) {
          hit(source);
        }
      };

      setAttr();
      observeDOMChanges(setAttr, true);
    }
    setAttr$1.names = ['set-attr'];
    setAttr$1.injections = [hit, observeDOMChanges, nativeIsNaN];

    /* eslint-disable max-len */

    /**
     * @scriptlet remove-class
     *
     * @description
     * Removes the specified classes from DOM nodes. This scriptlet runs once after the page loads
     * and after that periodically in order to DOM tree changes.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#remove-classjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('remove-class', classes[, selector, applying])
     * ```
     *
     * - `classes` — required, class or list of classes separated by '|'
     * - `selector` — optional, CSS selector, specifies DOM nodes from which the classes will be removed.
     * If there is no `selector`, each class of `classes` independently will be removed from all nodes which has one
     * - `applying` — optional, one or more space-separated flags that describe the way scriptlet apply, defaults to 'asap stay'; possible flags:
     *     - `asap` — runs as fast as possible **once**
     *     - `complete` — runs **once** after the whole page has been loaded
     *     - `stay` — as fast as possible **and** stays on the page observing possible DOM changes
     *
     * **Examples**
     * 1.  Removes by classes
     *     ```
     *     example.org#%#//scriptlet('remove-class', 'example|test')
     *     ```
     *
     *     ```html
     *     <!-- before  -->
     *     <div id="first" class="nice test">Some text</div>
     *     <div id="second" class="rare example for test">Some text</div>
     *     <div id="third" class="testing better example">Some text</div>
     *
     *     <!-- after -->
     *     <div id="first" class="nice">Some text</div>
     *     <div id="second" class="rare for">Some text</div>
     *     <div id="third" class="testing better">Some text</div>
     *     ```
     *
     * 2. Removes with specified selector
     *     ```
     *     example.org#%#//scriptlet('remove-class', 'branding', 'div[class^="inner"]')
     *     ```
     *
     *     ```html
     *     <!-- before -->
     *     <div class="wrapper true branding">
     *         <div class="inner bad branding">Some text</div>
     *     </div>
     *
     *     <!-- after -->
     *     <div class="wrapper true branding">
     *         <div class="inner bad">Some text</div>
     *     </div>
     *     ```
     *
     *  3. Using flags
     *     ```
     *     example.org#%#//scriptlet('remove-class', 'branding', 'div[class^="inner"]', 'asap complete')
     *     ```
     */

    /* eslint-enable max-len */

    function removeClass$1(source, classNames, selector) {
      var applying = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'asap stay';

      if (!classNames) {
        return;
      }

      classNames = classNames.split(/\s*\|\s*/);
      var selectors = [];

      if (!selector) {
        selectors = classNames.map(function (className) {
          return ".".concat(className);
        });
      }

      var removeClassHandler = function removeClassHandler() {
        var nodes = new Set();

        if (selector) {
          var foundNodes = [];

          try {
            foundNodes = [].slice.call(document.querySelectorAll(selector));
          } catch (e) {
            // eslint-disable-next-line no-console
            console.log("Invalid remove-class selector arg: '".concat(selector, "'"));
          }

          foundNodes.forEach(function (n) {
            return nodes.add(n);
          });
        } else if (selectors.length > 0) {
          selectors.forEach(function (s) {
            var elements = document.querySelectorAll(s);

            for (var i = 0; i < elements.length; i += 1) {
              var element = elements[i];
              nodes.add(element);
            }
          });
        }

        var removed = false;
        nodes.forEach(function (node) {
          classNames.forEach(function (className) {
            if (node.classList.contains(className)) {
              node.classList.remove(className);
              removed = true;
            }
          });
        });

        if (removed) {
          hit(source);
        }
      };

      var CLASS_ATTR_NAME = ['class'];
      var flags = parseFlags(applying);

      var run = function run() {
        removeClassHandler();

        if (!flags.hasFlag(flags.STAY)) {
          return;
        } // 'true' for observing attributes
        // 'class' for observing only classes


        observeDOMChanges(removeClassHandler, true, CLASS_ATTR_NAME);
      };

      if (flags.hasFlag(flags.ASAP)) {
        // https://github.com/AdguardTeam/Scriptlets/issues/245
        // Call removeClassHandler on DOM content loaded
        // to ensure that target node is present on the page
        if (document.readyState === 'loading') {
          window.addEventListener('DOMContentLoaded', removeClassHandler, {
            once: true
          });
        } else {
          removeClassHandler();
        }
      }

      if (document.readyState !== 'complete' && flags.hasFlag(flags.COMPLETE)) {
        window.addEventListener('load', run, {
          once: true
        });
      } else if (flags.hasFlag(flags.STAY)) {
        // Only call removeClassHandler for single 'stay' flag
        if (!applying.indexOf(' ') !== -1) {
          removeClassHandler();
        }

        observeDOMChanges(removeClassHandler, true, CLASS_ATTR_NAME);
      }
    }
    removeClass$1.names = ['remove-class', // aliases are needed for matching the related scriptlet converted into our syntax
    'remove-class.js', 'ubo-remove-class.js', 'rc.js', 'ubo-rc.js', 'ubo-remove-class', 'ubo-rc'];
    removeClass$1.injections = [hit, observeDOMChanges, parseFlags];

    /**
     * @scriptlet disable-newtab-links
     *
     * @description
     * Prevents opening new tabs and windows if there is `target` attribute in element.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#disable-newtab-linksjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('disable-newtab-links')
     * ```
     */

    function disableNewtabLinks$1(source) {
      document.addEventListener('click', function (ev) {
        var target = ev.target;

        while (target !== null) {
          if (target.localName === 'a' && target.hasAttribute('target')) {
            ev.stopPropagation();
            ev.preventDefault();
            hit(source);
            break;
          }

          target = target.parentNode;
        }
      });
    }
    disableNewtabLinks$1.names = ['disable-newtab-links', // aliases are needed for matching the related scriptlet converted into our syntax
    'disable-newtab-links.js', 'ubo-disable-newtab-links.js', 'ubo-disable-newtab-links'];
    disableNewtabLinks$1.injections = [hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet adjust-setInterval
     *
     * @description
     * Adjusts delay for specified setInterval() callbacks.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#nano-setinterval-boosterjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('adjust-setInterval'[, matchCallback [, matchDelay[, boost]]])
     * ```
     *
     * - `matchCallback` - optional, string or regular expression for stringified callback matching;
     * defaults to match all callbacks; invalid regular expression will cause exit and rule will not work
     * - `matchDelay` - optional, defaults to 1000, matching setInterval delay; decimal integer OR '*' for any delay
     * - `boost` - optional, default to 0.05, float, capped at 50 times for up and down (0.02...50), setInterval delay multiplier
     *
     * **Examples**
     * 1. Adjust all setInterval() x20 times where delay equal 1000ms:
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval')
     *     ```
     *
     * 2. Adjust all setInterval() x20 times where callback matched with `example` and delay equal 1000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval', 'example')
     *     ```
     *
     * 3. Adjust all setInterval() x20 times where callback matched with `example` and delay equal 400ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval', 'example', '400')
     *     ```
     *
     * 4. Slow down setInterval() x2 times where callback matched with `example` and delay equal 1000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval', 'example', '', '2')
     *     ```
     * 5. Adjust all setInterval() x50 times where delay equal 2000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval', '', '2000', '0.02')
     *     ```
     * 6. Adjust all setInterval() x50 times where delay is randomized
     *     ```
     *     example.org#%#//scriptlet('adjust-setInterval', '', '*', '0.02')
     *     ```
     */

    /* eslint-enable max-len */

    function adjustSetInterval$1(source, matchCallback, matchDelay, boost) {
      var nativeSetInterval = window.setInterval;
      var matchRegexp = toRegExp(matchCallback);

      var intervalWrapper = function intervalWrapper(callback, delay) {
        // https://github.com/AdguardTeam/Scriptlets/issues/221
        if (!isValidCallback(callback)) {
          if (source.verbose) {
            // eslint-disable-next-line no-console, max-len
            console.log("Scriptlet adjust-setInterval can not be applied because of invalid callback: '".concat(String(callback), "'."));
          }
        } else if (matchRegexp.test(callback.toString()) && isDelayMatched(matchDelay, delay)) {
          delay *= getBoostMultiplier(boost);
          hit(source);
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeSetInterval.apply(window, [callback, delay].concat(args));
      };

      window.setInterval = intervalWrapper;
    }
    adjustSetInterval$1.names = ['adjust-setInterval', // aliases are needed for matching the related scriptlet converted into our syntax
    'nano-setInterval-booster.js', 'ubo-nano-setInterval-booster.js', 'nano-sib.js', 'ubo-nano-sib.js', 'ubo-nano-setInterval-booster', 'ubo-nano-sib'];
    adjustSetInterval$1.injections = [hit, isValidCallback, toRegExp, getBoostMultiplier, isDelayMatched, // following helpers should be injected as helpers above use them
    nativeIsNaN, nativeIsFinite, getMatchDelay, getWildcardSymbol, shouldMatchAnyDelay];

    /* eslint-disable max-len */

    /**
     * @scriptlet adjust-setTimeout
     *
     * @description
     * Adjusts delay for specified setTimeout() callbacks.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#nano-settimeout-boosterjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('adjust-setTimeout'[, matchCallback [, matchDelay[, boost]]])
     * ```
     *
     * - `matchCallback` - optional, string or regular expression for stringified callback matching;
     * defaults to match all callbacks; invalid regular expression will cause exit and rule will not work
     * - `matchDelay` - optional, defaults to 1000, matching setTimeout delay; decimal integer OR '*' for any delay
     * - `boost` - optional, default to 0.05, float, capped at 50 times for up and down (0.02...50), setTimeout delay multiplier
     *
     * **Examples**
     * 1. Adjust all setTimeout() x20 times where timeout equal 1000ms:
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout')
     *     ```
     *
     * 2. Adjust all setTimeout() x20 times where callback matched with `example` and timeout equal 1000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout', 'example')
     *     ```
     *
     * 3. Adjust all setTimeout() x20 times where callback matched with `example` and timeout equal 400ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout', 'example', '400')
     *     ```
     *
     * 4. Slow down setTimeout() x2 times where callback matched with `example` and timeout equal 1000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout', 'example', '', '2')
     *     ```
     * 5. Adjust all setTimeout() x50 times where timeout equal 2000ms
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout', '', '2000', '0.02')
     *     ```
     * 6. Adjust all setTimeout() x20 times where callback matched with `test` and timeout is randomized
     *     ```
     *     example.org#%#//scriptlet('adjust-setTimeout', 'test', '*')
     *     ```
     */

    /* eslint-enable max-len */

    function adjustSetTimeout$1(source, matchCallback, matchDelay, boost) {
      var nativeSetTimeout = window.setTimeout;
      var matchRegexp = toRegExp(matchCallback);

      var timeoutWrapper = function timeoutWrapper(callback, delay) {
        // https://github.com/AdguardTeam/Scriptlets/issues/221
        if (!isValidCallback(callback)) {
          if (source.verbose) {
            // eslint-disable-next-line no-console, max-len
            console.log("Scriptlet adjust-setTimeout can not be applied because of invalid callback: '".concat(String(callback), "'."));
          }
        } else if (matchRegexp.test(callback.toString()) && isDelayMatched(matchDelay, delay)) {
          delay *= getBoostMultiplier(boost);
          hit(source);
        }

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return nativeSetTimeout.apply(window, [callback, delay].concat(args));
      };

      window.setTimeout = timeoutWrapper;
    }
    adjustSetTimeout$1.names = ['adjust-setTimeout', // aliases are needed for matching the related scriptlet converted into our syntax
    'nano-setTimeout-booster.js', 'ubo-nano-setTimeout-booster.js', 'nano-stb.js', 'ubo-nano-stb.js', 'ubo-nano-setTimeout-booster', 'ubo-nano-stb'];
    adjustSetTimeout$1.injections = [hit, isValidCallback, toRegExp, getBoostMultiplier, isDelayMatched, // following helpers should be injected as helpers above use them
    nativeIsNaN, nativeIsFinite, getMatchDelay, getWildcardSymbol, shouldMatchAnyDelay];

    /* eslint-disable max-len */

    /**
     * @scriptlet dir-string
     *
     * @description
     * Wraps the `console.dir` API to call the `toString` method of the argument.
     * There are several adblock circumvention systems that detect browser devtools
     * and hide themselves. Therefore, if we force them to think
     * that devtools are open (using this scriptlet),
     * it will automatically disable the adblock circumvention script.
     *
     * Related ABP source:
     * https://github.com/adblockplus/adblockpluscore/blob/6b2a309054cc23432102b85d13f12559639ef495/lib/content/snippets.js#L766
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('dir-string'[, times])
     * ```
     * - `times` - optional, the number of times to call the `toString` method of the argument to `console.dir`
     *
     * **Example**
     * ```
     * ! Run 2 times
     * example.org#%#//scriptlet('dir-string', '2')
     * ```
     */

    /* eslint-enable max-len */

    function dirString$1(source, times) {
      var _console = console,
          dir = _console.dir;
      times = parseInt(times, 10);

      function dirWrapper(object) {
        // eslint-disable-next-line no-unused-vars
        var temp;

        for (var i = 0; i < times; i += 1) {
          // eslint-disable-next-line no-unused-expressions
          temp = "".concat(object);
        }

        if (typeof dir === 'function') {
          dir.call(this, object);
        }

        hit(source, temp);
      } // eslint-disable-next-line no-console


      console.dir = dirWrapper;
    }
    dirString$1.names = ['dir-string', 'abp-dir-string'];
    dirString$1.injections = [hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet json-prune
     *
     * @description
     * Removes specified properties from the result of calling JSON.parse and returns the caller
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#json-prunejs-
     *
     * Related ABP source:
     * https://github.com/adblockplus/adblockpluscore/blob/master/lib/content/snippets.js#L1285
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('json-prune'[, propsToRemove [, obligatoryProps [, stack]]])
     * ```
     *
     * - `propsToRemove` - optional, string of space-separated properties to remove
     * - `obligatoryProps` - optional, string of space-separated properties which must be all present for the pruning to occur
     * - `stack` - optional, string or regular expression that must match the current function call stack trace;
     * if regular expression is invalid it will be skipped
     *
     * > Note please that you can use wildcard `*` for chain property name.
     * e.g. 'ad.*.src' instead of 'ad.0.src ad.1.src ad.2.src ...'
     *
     * **Examples**
     * 1. Removes property `example` from the results of JSON.parse call
     *     ```
     *     example.org#%#//scriptlet('json-prune', 'example')
     *     ```
     *
     *     For instance, the following call will return `{ one: 1}`
     *
     *     ```html
     *     JSON.parse('{"one":1,"example":true}')
     *     ```
     *
     * 2. If there are no specified properties in the result of JSON.parse call, pruning will NOT occur
     *     ```
     *     example.org#%#//scriptlet('json-prune', 'one', 'obligatoryProp')
     *     ```
     *
     *     For instance, the following call will return `{ one: 1, two: 2}`
     *
     *     ```html
     *     JSON.parse('{"one":1,"two":2}')
     *     ```
     *
     * 3. A property in a list of properties can be a chain of properties
     *
     *     ```
     *     example.org#%#//scriptlet('json-prune', 'a.b', 'adpath.url.first')
     *     ```
     *
     * 4. Removes property `content.ad` from the results of JSON.parse call if its error stack trace contains `test.js`
     *     ```
     *     example.org#%#//scriptlet('json-prune', 'content.ad', '', 'test.js')
     *     ```
     *
     * 5. A property in a list of properties can be a chain of properties with wildcard in it
     *
     *     ```
     *     example.org#%#//scriptlet('json-prune', 'content.*.media.src', 'content.*.media.preroll')
     *     ```
     *
     * 6. Call with no arguments will log the current hostname and json payload at the console
     *     ```
     *     example.org#%#//scriptlet('json-prune')
     *     ```
     *
     * 7. Call with only second argument will log the current hostname and matched json payload at the console
     *     ```
     *     example.org#%#//scriptlet('json-prune', '', '"id":"117458"')
     *     ```
     */

    /* eslint-enable max-len */

    function jsonPrune$1(source, propsToRemove, requiredInitialProps, stack) {
      if (!!stack && !matchStackTrace(stack, new Error().stack)) {
        return;
      } // eslint-disable-next-line no-console


      var log = console.log.bind(console);
      var prunePaths = propsToRemove !== undefined && propsToRemove !== '' ? propsToRemove.split(/ +/) : [];
      var requiredPaths = requiredInitialProps !== undefined && requiredInitialProps !== '' ? requiredInitialProps.split(/ +/) : [];

      function isPruningNeeded(root) {
        if (!root) {
          return false;
        }

        var shouldProcess; // Only log hostname and matched JSON payload if only second argument is present

        if (prunePaths.length === 0 && requiredPaths.length > 0) {
          var rootString = JSON.stringify(root);
          var matchRegex = toRegExp(requiredPaths.join(''));
          var shouldLog = matchRegex.test(rootString);

          if (shouldLog) {
            log(window.location.hostname, root);
            shouldProcess = false;
            return shouldProcess;
          }
        }

        for (var i = 0; i < requiredPaths.length; i += 1) {
          var requiredPath = requiredPaths[i];
          var lastNestedPropName = requiredPath.split('.').pop();
          var hasWildcard = requiredPath.indexOf('.*.') > -1 || requiredPath.indexOf('*.') > -1 || requiredPath.indexOf('.*') > -1 || requiredPath.indexOf('.[].') > -1 || requiredPath.indexOf('[].') > -1 || requiredPath.indexOf('.[]') > -1; // if the path has wildcard, getPropertyInChain should 'look through' chain props

          var details = getWildcardPropertyInChain(root, requiredPath, hasWildcard); // start value of 'shouldProcess' due to checking below

          shouldProcess = !hasWildcard;

          for (var _i = 0; _i < details.length; _i += 1) {
            if (hasWildcard) {
              // if there is a wildcard,
              // at least one (||) of props chain should be present in object
              shouldProcess = !(details[_i].base[lastNestedPropName] === undefined) || shouldProcess;
            } else {
              // otherwise each one (&&) of them should be there
              shouldProcess = !(details[_i].base[lastNestedPropName] === undefined) && shouldProcess;
            }
          }
        }

        return shouldProcess;
      }
      /**
       * Prunes properties of 'root' object
       * @param {Object} root
       */


      var jsonPruner = function jsonPruner(root) {
        if (prunePaths.length === 0 && requiredPaths.length === 0) {
          log(window.location.hostname, root);
          return root;
        }

        try {
          if (isPruningNeeded(root) === false) {
            return root;
          } // if pruning is needed, we check every input pathToRemove
          // and delete it if root has it


          prunePaths.forEach(function (path) {
            var ownerObjArr = getWildcardPropertyInChain(root, path, true);
            ownerObjArr.forEach(function (ownerObj) {
              if (ownerObj !== undefined && ownerObj.base) {
                delete ownerObj.base[ownerObj.prop];
                hit(source);
              }
            });
          });
        } catch (e) {
          log(e.toString());
        }

        return root;
      };

      var nativeJSONParse = JSON.parse;

      var jsonParseWrapper = function jsonParseWrapper() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        // dealing with stringified json in args, which should be parsed.
        // so we call nativeJSONParse as JSON.parse which is bound to JSON object
        var root = nativeJSONParse.apply(JSON, args);
        return jsonPruner(root);
      }; // JSON.parse mocking


      jsonParseWrapper.toString = nativeJSONParse.toString.bind(nativeJSONParse);
      JSON.parse = jsonParseWrapper; // eslint-disable-next-line compat/compat

      var nativeResponseJson = Response.prototype.json; // eslint-disable-next-line func-names

      var responseJsonWrapper = function responseJsonWrapper() {
        var promise = nativeResponseJson.apply(this);
        return promise.then(function (obj) {
          return jsonPruner(obj);
        });
      }; // do nothing if browser does not support Response (e.g. Internet Explorer)
      // https://developer.mozilla.org/en-US/docs/Web/API/Response


      if (typeof Response === 'undefined') {
        return;
      } // eslint-disable-next-line compat/compat


      Response.prototype.json = responseJsonWrapper;
    }
    jsonPrune$1.names = ['json-prune', // aliases are needed for matching the related scriptlet converted into our syntax
    'json-prune.js', 'ubo-json-prune.js', 'ubo-json-prune', 'abp-json-prune'];
    jsonPrune$1.injections = [hit, matchStackTrace, getWildcardPropertyInChain, toRegExp, getWildcardSymbol, getNativeRegexpTest];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-requestAnimationFrame
     *
     * @description
     * Prevents a `requestAnimationFrame` call
     * if the text of the callback is matching the specified search string which does not start with `!`;
     * otherwise mismatched calls should be defused.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#no-requestanimationframe-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-requestAnimationFrame'[, search])
     * ```
     *
     * - `search` - optional, string or regular expression; invalid regular expression will be skipped and all callbacks will be matched.
     * If starts with `!`, scriptlet will not match the stringified callback but all other will be defused.
     * If do not start with `!`, the stringified callback will be matched.
     *
     * Call with no argument will log all requestAnimationFrame calls while debugging.
     * So do not use the scriptlet without any parameter in production filter lists.
     *
     * **Examples**
     * 1. Prevents `requestAnimationFrame` calls if the callback matches `/\.test/`.
     *     ```bash
     *     example.org#%#//scriptlet('prevent-requestAnimationFrame', '/\.test/')
     *     ```
     *
     *     For instance, the following call will be prevented:
     *     ```javascript
     *     var times = 0;
     *     requestAnimationFrame(function change() {
     *         window.test = 'new value';
     *         if (times < 2) {
     *             times += 1;
     *             requestAnimationFrame(change);
     *         }
     *     });
     *     ```
     * 2. Prevents `requestAnimationFrame` calls if **does not match** 'check'.
     *     ```bash
     *     example.org#%#//scriptlet('prevent-requestAnimationFrame', '!check')
     *     ```
     *
     *     For instance, only the first call will be prevented:
     *
     *     ```javascript
     *     var timesFirst = 0;
     *     requestAnimationFrame(function changeFirst() {
     *         window.check = 'should not be prevented';
     *         if (timesFirst < 2) {
     *             timesFirst += 1;
     *             requestAnimationFrame(changeFirst);
     *         }
     *     });
     *
     *     var timesSecond = 0;
     *     requestAnimationFrame(function changeSecond() {
     *         window.second = 'should be prevented';
     *         if (timesSecond < 2) {
     *             timesSecond += 1;
     *             requestAnimationFrame(changeSecond);
     *         }
     *     });
     *     ```
     */

    /* eslint-enable max-len */

    function preventRequestAnimationFrame$1(source, match) {
      var nativeRequestAnimationFrame = window.requestAnimationFrame;
      var log = console.log.bind(console); // eslint-disable-line no-console
      // logs requestAnimationFrame to console if no arguments have been specified

      var shouldLog = typeof match === 'undefined';

      var _parseMatchArg = parseMatchArg(match),
          isInvertedMatch = _parseMatchArg.isInvertedMatch,
          matchRegexp = _parseMatchArg.matchRegexp;

      var rafWrapper = function rafWrapper(callback) {
        var shouldPrevent = false;

        if (shouldLog) {
          hit(source);
          log("requestAnimationFrame(".concat(String(callback), ")"));
        } else if (isValidCallback(callback) && isValidStrPattern(match)) {
          shouldPrevent = matchRegexp.test(callback.toString()) !== isInvertedMatch;
        }

        if (shouldPrevent) {
          hit(source);
          return nativeRequestAnimationFrame(noopFunc);
        }

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        return nativeRequestAnimationFrame.apply(window, [callback].concat(args));
      };

      window.requestAnimationFrame = rafWrapper;
    }
    preventRequestAnimationFrame$1.names = ['prevent-requestAnimationFrame', // aliases are needed for matching the related scriptlet converted into our syntax
    'no-requestAnimationFrame-if.js', 'ubo-no-requestAnimationFrame-if.js', 'norafif.js', 'ubo-norafif.js', 'ubo-no-requestAnimationFrame-if', 'ubo-norafif'];
    preventRequestAnimationFrame$1.injections = [hit, noopFunc, parseMatchArg, isValidStrPattern, isValidCallback, // following helpers should be injected as helpers above use them
    escapeRegExp, toRegExp, startsWith];

    /* eslint-disable max-len */

    /**
     * @scriptlet set-cookie
     *
     * @description
     * Sets a cookie with the specified name and value. Cookie path defaults to root.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('set-cookie', name, value)
     * ```
     *
     * - `name` - required, cookie name to be set
     * - `value` - required, cookie value; possible values:
     *     - number `>= 0 && <= 15`
     *     - one of the predefined constants:
     *         - `true` / `True`
     *         - `false` / `False`
     *         - `yes` / `Yes` / `Y`
     *         - `no`
     *         - `ok` / `OK`
     *
     * **Examples**
     * ```
     * example.org#%#//scriptlet('set-cookie', 'ReadlyCookieConsent', '1')
     *
     * example.org#%#//scriptlet('set-cookie', 'gdpr-settings-cookie', 'true')
     * ```
     */

    /* eslint-enable max-len */

    function setCookie$1(source, name, value) {
      var cookieData = prepareCookie(name, value);

      if (cookieData) {
        hit(source);
        document.cookie = cookieData;
      }
    }
    setCookie$1.names = ['set-cookie'];
    setCookie$1.injections = [hit, nativeIsNaN, prepareCookie];

    /**
     * @scriptlet set-cookie-reload
     *
     * @description
     * Sets a cookie with the specified name and value, and then reloads the current page.
     * If reloading option is not needed, use [set-cookie](#set-cookie) scriptlet.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('set-cookie-reload', name, value)
     * ```
     *
     * - `name` - required, cookie name to be set
     * - `value` - required, cookie value; possible values:
     *     - number `>= 0 && <= 15`
     *     - one of the predefined constants:
     *         - `true` / `True`
     *         - `false` / `False`
     *         - `yes` / `Yes` / `Y`
     *         - `no`
     *         - `ok` / `OK`
     *
     * **Examples**
     * ```
     * example.org#%#//scriptlet('set-cookie-reload', 'checking', 'ok')
     *
     * example.org#%#//scriptlet('set-cookie-reload', 'gdpr-settings-cookie', '1')
     * ```
     */

    function setCookieReload$1(source, name, value) {
      var isCookieSetWithValue = function isCookieSetWithValue(name, value) {
        return document.cookie.split(';').some(function (cookieStr) {
          var pos = cookieStr.indexOf('=');

          if (pos === -1) {
            return false;
          }

          var cookieName = cookieStr.slice(0, pos).trim();
          var cookieValue = cookieStr.slice(pos + 1).trim();
          return name === cookieName && value === cookieValue;
        });
      };

      if (isCookieSetWithValue(name, value)) {
        return;
      }

      var cookieData = prepareCookie(name, value);

      if (cookieData) {
        document.cookie = cookieData;
        hit(source); // Only reload the page if cookie was set
        // https://github.com/AdguardTeam/Scriptlets/issues/212

        if (isCookieSetWithValue(name, value)) {
          window.location.reload();
        }
      }
    }
    setCookieReload$1.names = ['set-cookie-reload'];
    setCookieReload$1.injections = [hit, nativeIsNaN, prepareCookie];

    /**
     * @scriptlet hide-in-shadow-dom
     *
     * @description
     * Hides elements inside open shadow DOM elements.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('hide-in-shadow-dom', selector[, baseSelector])
     * ```
     *
     * - `selector` — required, CSS selector of element in shadow-dom to hide
     * - `baseSelector` — optional, selector of specific page DOM element,
     * narrows down the part of the page DOM where shadow-dom host supposed to be,
     * defaults to document.documentElement
     *
     * > `baseSelector` should match element of the page DOM, but not of shadow DOM
     *
     * **Examples**
     * ```
     * ! hides menu bar
     * virustotal.com#%#//scriptlet('hide-in-shadow-dom', 'iron-pages', 'vt-virustotal-app')
     *
     * ! hides floating element
     * virustotal.com#%#//scriptlet('hide-in-shadow-dom', 'vt-ui-contact-fab')
     * ```
     */

    function hideInShadowDom$1(source, selector, baseSelector) {
      // do nothing if browser does not support ShadowRoot
      // https://developer.mozilla.org/en-US/docs/Web/API/ShadowRoot
      if (!Element.prototype.attachShadow) {
        return;
      }

      var hideElement = function hideElement(targetElement) {
        var DISPLAY_NONE_CSS = 'display:none!important;';
        targetElement.style.cssText = DISPLAY_NONE_CSS;
      };
      /**
       * Handles shadow-dom piercing and hiding of found elements
       */


      var hideHandler = function hideHandler() {
        // start value of shadow-dom hosts for the page dom
        var hostElements = !baseSelector ? findHostElements(document.documentElement) : document.querySelectorAll(baseSelector); // if there is shadow-dom host, they should be explored

        while (hostElements.length !== 0) {
          var isHidden = false;

          var _pierceShadowDom = pierceShadowDom(selector, hostElements),
              targets = _pierceShadowDom.targets,
              innerHosts = _pierceShadowDom.innerHosts;

          targets.forEach(function (targetEl) {
            hideElement(targetEl);
            isHidden = true;
          });

          if (isHidden) {
            hit(source);
          } // continue to pierce for inner shadow-dom hosts
          // and search inside them while the next iteration


          hostElements = innerHosts;
        }
      };

      hideHandler();
      observeDOMChanges(hideHandler, true);
    }
    hideInShadowDom$1.names = ['hide-in-shadow-dom'];
    hideInShadowDom$1.injections = [hit, observeDOMChanges, flatten, findHostElements, pierceShadowDom];

    /**
     * @scriptlet remove-in-shadow-dom
     *
     * @description
     * Removes elements inside open shadow DOM elements.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('remove-in-shadow-dom', selector[, baseSelector])
     * ```
     *
     * - `selector` — required, CSS selector of element in shadow-dom to remove
     * - `baseSelector` — optional, selector of specific page DOM element,
     * narrows down the part of the page DOM where shadow-dom host supposed to be,
     * defaults to document.documentElement
     *
     * > `baseSelector` should match element of the page DOM, but not of shadow DOM
     *
     * **Examples**
     * ```
     * ! removes menu bar
     * virustotal.com#%#//scriptlet('remove-in-shadow-dom', 'iron-pages', 'vt-virustotal-app')
     *
     * ! removes floating element
     * virustotal.com#%#//scriptlet('remove-in-shadow-dom', 'vt-ui-contact-fab')
     * ```
     */

    function removeInShadowDom$1(source, selector, baseSelector) {
      // do nothing if browser does not support ShadowRoot
      // https://developer.mozilla.org/en-US/docs/Web/API/ShadowRoot
      if (!Element.prototype.attachShadow) {
        return;
      }

      var removeElement = function removeElement(targetElement) {
        targetElement.remove();
      };
      /**
       * Handles shadow-dom piercing and removing of found elements
       */


      var removeHandler = function removeHandler() {
        // start value of shadow-dom hosts for the page dom
        var hostElements = !baseSelector ? findHostElements(document.documentElement) : document.querySelectorAll(baseSelector); // if there is shadow-dom host, they should be explored

        while (hostElements.length !== 0) {
          var isRemoved = false;

          var _pierceShadowDom = pierceShadowDom(selector, hostElements),
              targets = _pierceShadowDom.targets,
              innerHosts = _pierceShadowDom.innerHosts;

          targets.forEach(function (targetEl) {
            removeElement(targetEl);
            isRemoved = true;
          });

          if (isRemoved) {
            hit(source);
          } // continue to pierce for inner shadow-dom hosts
          // and search inside them while the next iteration


          hostElements = innerHosts;
        }
      };

      removeHandler();
      observeDOMChanges(removeHandler, true);
    }
    removeInShadowDom$1.names = ['remove-in-shadow-dom'];
    removeInShadowDom$1.injections = [hit, observeDOMChanges, flatten, findHostElements, pierceShadowDom];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-fetch
     *
     * @description
     * Prevents `fetch` calls if **all** given parameters match
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#no-fetch-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-fetch'[, propsToMatch[, responseBody]])
     * ```
     *
     * - `propsToMatch` - optional, string of space-separated properties to match; possible props:
     *   - string or regular expression for matching the URL passed to fetch call; empty string, wildcard `*` or invalid regular expression will match all fetch calls
     *   - colon-separated pairs `name:value` where
     *     - `name` is [`init` option name](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/fetch#parameters)
     *     - `value` is string or regular expression for matching the value of the option passed to fetch call; invalid regular expression will cause any value matching
     * - responseBody - optional, string for defining response body value, defaults to `emptyObj`. Possible values:
     *    - `emptyObj` - empty object
     *    - `emptyArr` - empty array
     * > Usage with no arguments will log fetch calls to browser console;
     * which is useful for debugging but permitted for production filter lists.
     *
     * **Examples**
     * 1. Log all fetch calls
     *     ```
     *     example.org#%#//scriptlet('prevent-fetch')
     *     ```
     *
     * 2. Prevent all fetch calls
     *     ```
     *     example.org#%#//scriptlet('prevent-fetch', '*')
     *     OR
     *     example.org#%#//scriptlet('prevent-fetch', '')
     *     ```
     *
     * 3. Prevent fetch call for specific url
     *     ```
     *     example.org#%#//scriptlet('prevent-fetch', '/url\\.part/')
     *     ```
     *
     * 4. Prevent fetch call for specific request method
     *     ```
     *     example.org#%#//scriptlet('prevent-fetch', 'method:HEAD')
     *     ```
     *
     * 5. Prevent fetch call for specific url and request method
     *     ```
     *     example.org#%#//scriptlet('prevent-fetch', '/specified_url_part/ method:/HEAD|GET/')
     *     ```
     *
     * 6. Prevent fetch call and specify response body value
     *     ```
     *     ! Specify response body for fetch call to a specific url
     *     example.org#%#//scriptlet('prevent-fetch', '/specified_url_part/ method:/HEAD|GET/', 'emptyArr')
     *
     *     ! Specify response body for all fetch calls
     *     example.org#%#//scriptlet('prevent-fetch', '', 'emptyArr')
     *     ```
     */

    /* eslint-enable max-len */

    function preventFetch$1(source, propsToMatch) {
      var responseBody = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'emptyObj';

      // do nothing if browser does not support fetch or Proxy (e.g. Internet Explorer)
      // https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/fetch
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy
      if (typeof fetch === 'undefined' || typeof Proxy === 'undefined' || typeof Response === 'undefined') {
        return;
      }

      var strResponseBody;

      if (responseBody === 'emptyObj') {
        strResponseBody = '{}';
      } else if (responseBody === 'emptyArr') {
        strResponseBody = '[]';
      } else {
        return;
      }

      var handlerWrapper = function handlerWrapper(target, thisArg, args) {
        var shouldPrevent = false;
        var fetchData = getFetchData(args);

        if (typeof propsToMatch === 'undefined') {
          // log if no propsToMatch given
          var logMessage = "log: fetch( ".concat(objectToString(fetchData), " )");
          hit(source, logMessage);
        } else if (propsToMatch === '' || propsToMatch === getWildcardSymbol()) {
          // prevent all fetch calls
          shouldPrevent = true;
        } else {
          var parsedData = parseMatchProps(propsToMatch);

          if (!validateParsedData(parsedData)) {
            // eslint-disable-next-line no-console
            console.log("Invalid parameter: ".concat(propsToMatch));
            shouldPrevent = false;
          } else {
            var matchData = getMatchPropsData(parsedData); // prevent only if all props match

            shouldPrevent = Object.keys(matchData).every(function (matchKey) {
              var matchValue = matchData[matchKey];
              return Object.prototype.hasOwnProperty.call(fetchData, matchKey) && matchValue.test(fetchData[matchKey]);
            });
          }
        }

        if (shouldPrevent) {
          hit(source);
          return noopPromiseResolve(strResponseBody);
        }

        return Reflect.apply(target, thisArg, args);
      };

      var fetchHandler = {
        apply: handlerWrapper
      };
      fetch = new Proxy(fetch, fetchHandler); // eslint-disable-line no-global-assign
    }
    preventFetch$1.names = ['prevent-fetch', // aliases are needed for matching the related scriptlet converted into our syntax
    'no-fetch-if.js', 'ubo-no-fetch-if.js', 'ubo-no-fetch-if'];
    preventFetch$1.injections = [hit, getFetchData, objectToString, parseMatchProps, validateParsedData, getMatchPropsData, noopPromiseResolve, getWildcardSymbol, toRegExp, isValidStrPattern, escapeRegExp, isEmptyObject, getRequestData, getObjectEntries, getObjectFromEntries];

    /* eslint-disable max-len */

    /**
     * @scriptlet set-local-storage-item
     *
     * @description
     * Adds specified key and its value to localStorage object, or updates the value of the key if it already exists.
     *
     * **Syntax**
     * ```
     * example.com#%#//scriptlet('set-local-storage-item', 'key', 'value')
     * ```
     *
     * - `key` — required, key name to be set.
     * - `value` - required, key value; possible values:
     *     - positive decimal integer `<= 32767`
     *     - one of the predefined constants:
     *         - `undefined`
     *         - `false`
     *         - `true`
     *         - `null`
     *         - `emptyObj` - empty object
     *         - `emptyArr` - empty array
     *         - `''` - empty string
     *         - `yes`
     *         - `no`
     *
     * **Examples**
     * ```
     * example.org#%#//scriptlet('set-local-storage-item', 'player.live.current.mute', 'false')
     *
     * example.org#%#//scriptlet('set-local-storage-item', 'exit-intent-marketing', '1')
     * ```
     */

    /* eslint-enable max-len */

    function setLocalStorageItem$1(source, key, value) {
      if (!key || !value && value !== '') {
        return;
      }

      var keyValue;

      if (value === 'undefined') {
        keyValue = undefined;
      } else if (value === 'false') {
        keyValue = false;
      } else if (value === 'true') {
        keyValue = true;
      } else if (value === 'null') {
        keyValue = null;
      } else if (value === 'emptyArr') {
        keyValue = '[]';
      } else if (value === 'emptyObj') {
        keyValue = '{}';
      } else if (value === '') {
        keyValue = '';
      } else if (/^\d+$/.test(value)) {
        keyValue = parseFloat(value);

        if (nativeIsNaN(keyValue)) {
          return;
        }

        if (Math.abs(keyValue) > 0x7FFF) {
          return;
        }
      } else if (value === 'yes') {
        keyValue = 'yes';
      } else if (value === 'no') {
        keyValue = 'no';
      } else {
        return;
      }

      var setItem = function setItem(key, value) {
        var _window = window,
            localStorage = _window.localStorage; // setItem() may throw an exception if the storage is full.

        try {
          localStorage.setItem(key, value);
          hit(source);
        } catch (e) {
          if (source.verbose) {
            // eslint-disable-next-line no-console
            console.log("Was unable to set localStorage item due to: ".concat(e.message));
          }
        }
      };

      setItem(key, keyValue);
    }
    setLocalStorageItem$1.names = ['set-local-storage-item'];
    setLocalStorageItem$1.injections = [hit, nativeIsNaN];

    /* eslint-disable max-len */

    /**
     * @scriptlet set-session-storage-item
     *
     * @description
     * Adds specified key and its value to sessionStorage object, or updates the value of the key if it already exists.
     *
     * **Syntax**
     * ```
     * example.com#%#//scriptlet('set-session-storage-item', 'key', 'value')
     * ```
     *
     * - `key` — required, key name to be set.
     * - `value` - required, key value; possible values:
     *     - positive decimal integer `<= 32767`
     *     - one of the predefined constants:
     *         - `undefined`
     *         - `false`
     *         - `true`
     *         - `null`
     *         - `emptyObj` - empty object
     *         - `emptyArr` - empty array
     *         - `''` - empty string
     *         - `yes`
     *         - `no`
     *
     * **Examples**
     * ```
     * example.org#%#//scriptlet('set-session-storage-item', 'player.live.current.mute', 'false')
     *
     * example.org#%#//scriptlet('set-session-storage-item', 'exit-intent-marketing', '1')
     * ```
     */

    /* eslint-enable max-len */

    function setSessionStorageItem$1(source, key, value) {
      if (!key || !value && value !== '') {
        return;
      }

      var keyValue;

      if (value === 'undefined') {
        keyValue = undefined;
      } else if (value === 'false') {
        keyValue = false;
      } else if (value === 'true') {
        keyValue = true;
      } else if (value === 'null') {
        keyValue = null;
      } else if (value === 'emptyArr') {
        keyValue = '[]';
      } else if (value === 'emptyObj') {
        keyValue = '{}';
      } else if (value === '') {
        keyValue = '';
      } else if (/^\d+$/.test(value)) {
        keyValue = parseFloat(value);

        if (nativeIsNaN(keyValue)) {
          return;
        }

        if (Math.abs(keyValue) > 0x7FFF) {
          return;
        }
      } else if (value === 'yes') {
        keyValue = 'yes';
      } else if (value === 'no') {
        keyValue = 'no';
      } else {
        return;
      }

      var setItem = function setItem(key, value) {
        var _window = window,
            sessionStorage = _window.sessionStorage; // setItem() may throw an exception if the storage is full.

        try {
          sessionStorage.setItem(key, value);
          hit(source);
        } catch (e) {
          if (source.verbose) {
            // eslint-disable-next-line no-console
            console.log("Was unable to set sessionStorage item due to: ".concat(e.message));
          }
        }
      };

      setItem(key, keyValue);
    }
    setSessionStorageItem$1.names = ['set-session-storage-item'];
    setSessionStorageItem$1.injections = [hit, nativeIsNaN];

    /* eslint-disable max-len */

    /**
     * @scriptlet abort-on-stack-trace
     *
     * @description
     * Aborts a script when it attempts to utilize (read or write to) the specified property and it's error stack trace contains given value.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock-for-firefox-legacy/commit/7099186ae54e70b588d5e99554a05d783cabc8ff
     *
     * **Syntax**
     * ```
     * example.com#%#//scriptlet('abort-on-stack-trace', property, stack)
     * ```
     *
     * - `property` - required, path to a property. The property must be attached to window.
     * - `stack` - required, string that must match the current function call stack trace.
     *
     * **Examples**
     * ```
     * ! Aborts script when it tries to access `window.Ya` and it's error stack trace contains `test.js`
     * example.org#%#//scriptlet('abort-on-stack-trace', 'Ya', 'test.js')
     *
     * ! Aborts script when it tries to access `window.Ya.videoAd` and it's error stack trace contains `test.js`
     * example.org#%#//scriptlet('abort-on-stack-trace', 'Ya.videoAd', 'test.js')
     *
     * ! Aborts script when stack trace matches with any of these parameters
     * example.org#%#//scriptlet('abort-on-stack-trace', 'Ya', 'yandexFuncName')
     * example.org#%#//scriptlet('abort-on-stack-trace', 'Ya', 'yandexScriptName')
     * ```
     */

    /* eslint-enable max-len */

    function abortOnStackTrace$1(source, property, stack) {
      if (!property || !stack) {
        return;
      }

      var rid = randomId();

      var abort = function abort() {
        hit(source);
        throw new ReferenceError(rid);
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        if (!isValidStrPattern(stack)) {
          // eslint-disable-next-line no-console
          console.log("Invalid parameter: ".concat(stack));
          return;
        } // Prevent infinite loops when trapping prop used by helpers in getter/setter


        var descriptorWrapper = Object.assign(getDescriptorAddon(), {
          value: base[prop],
          get: function get() {
            if (!this.isAbortingSuspended && this.isolateCallback(matchStackTrace, stack, new Error().stack)) {
              abort();
            }

            return this.value;
          },
          set: function set(newValue) {
            if (!this.isAbortingSuspended && this.isolateCallback(matchStackTrace, stack, new Error().stack)) {
              abort();
            }

            this.value = newValue;
          }
        });
        setPropertyAccess(base, prop, {
          // Call wrapped getter and setter to keep isAbortingSuspended & isolateCallback values
          get: function get() {
            return descriptorWrapper.get.call(descriptorWrapper);
          },
          set: function set(newValue) {
            descriptorWrapper.set.call(descriptorWrapper, newValue);
          }
        });
      };

      setChainPropAccess(window, property);
      window.onerror = createOnErrorHandler(rid).bind();
    }
    abortOnStackTrace$1.names = ['abort-on-stack-trace', // aliases are needed for matching the related scriptlet converted into our syntax
    'abort-on-stack-trace.js', 'ubo-abort-on-stack-trace.js', 'aost.js', 'ubo-aost.js', 'ubo-abort-on-stack-trace', 'ubo-aost', 'abp-abort-on-stack-trace'];
    abortOnStackTrace$1.injections = [randomId, setPropertyAccess, getPropertyInChain, createOnErrorHandler, hit, isValidStrPattern, escapeRegExp, matchStackTrace, getDescriptorAddon, toRegExp, getNativeRegexpTest];

    /* eslint-disable max-len */

    /**
     * @scriptlet log-on-stack-trace
     *
     * @description
     * This scriptlet is basically the same as [abort-on-stack-trace](#abort-on-stack-trace), but instead of aborting it logs:
     * - function and source script names pairs that access the given property
     * - was that get or set attempt
     * - script being injected or inline
     *
     * **Syntax**
     * ```
     * example.com#%#//scriptlet('log-on-stack-trace', 'property')
     * ```
     *
     * - `property` - required, path to a property. The property must be attached to window.
     */

    /* eslint-enable max-len */

    function logOnStacktrace$1(source, property) {
      if (!property) {
        return;
      }

      var refineStackTrace = function refineStackTrace(stackString) {
        // Split stack trace string by lines and remove first two elements ('Error' and getter call)
        // Remove '    at ' at the start of each string
        var stackSteps = stackString.split('\n').slice(2).map(function (line) {
          return line.replace(/ {4}at /, '');
        }); // Trim each line extracting funcName : fullPath pair

        var logInfoArray = stackSteps.map(function (line) {
          var funcName;
          var funcFullPath;
          /* eslint-disable-next-line no-useless-escape */

          var reg = /\(([^\)]+)\)/;

          if (line.match(reg)) {
            funcName = line.split(' ').slice(0, -1).join(' ');
            /* eslint-disable-next-line prefer-destructuring, no-useless-escape */

            funcFullPath = line.match(reg)[1];
          } else {
            // For when func name is not available
            funcName = 'function name is not available';
            funcFullPath = line;
          }

          return [funcName, funcFullPath];
        }); // Convert array into object for better display using console.table

        var logInfoObject = {};
        logInfoArray.forEach(function (pair) {
          /* eslint-disable-next-line prefer-destructuring */
          logInfoObject[pair[0]] = pair[1];
        });
        return logInfoObject;
      };

      var setChainPropAccess = function setChainPropAccess(owner, property) {
        var chainInfo = getPropertyInChain(owner, property);
        var base = chainInfo.base;
        var prop = chainInfo.prop,
            chain = chainInfo.chain;

        if (chain) {
          var setter = function setter(a) {
            base = a;

            if (a instanceof Object) {
              setChainPropAccess(a, chain);
            }
          };

          Object.defineProperty(owner, prop, {
            get: function get() {
              return base;
            },
            set: setter
          });
          return;
        }

        var value = base[prop];
        /* eslint-disable no-console, compat/compat */

        setPropertyAccess(base, prop, {
          get: function get() {
            hit(source);
            console.log("%cGet %c".concat(prop), 'color:red;', 'color:green;');
            console.table(refineStackTrace(new Error().stack));
            return value;
          },
          set: function set(newValue) {
            hit(source);
            console.log("%cSet %c".concat(prop), 'color:red;', 'color:green;');
            console.table(refineStackTrace(new Error().stack));
            value = newValue;
          }
        });
        /* eslint-enable no-console, compat/compat */
      };

      setChainPropAccess(window, property);
    }
    logOnStacktrace$1.names = ['log-on-stack-trace'];
    logOnStacktrace$1.injections = [getPropertyInChain, setPropertyAccess, hit];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-xhr
     *
     * @description
     * Prevents `xhr` calls if **all** given parameters match.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#no-xhr-ifjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-xhr'[, propsToMatch[, randomize]])
     * ```
     *
     * - propsToMatch - optional, string of space-separated properties to match; possible props:
     *   - string or regular expression for matching the URL passed to `.open()` call; empty string or wildcard * for all `.open()` calls match
     *   - colon-separated pairs name:value where
     *     - name is XMLHttpRequest object property name
     *     - value is string or regular expression for matching the value of the option passed to `.open()` call
     * - randomize - defaults to `false` for empty responseText, optional argument to randomize responseText of matched XMLHttpRequest's response; possible values:
     *   - boolean 'true' to randomize responseText, random alphanumeric string of 10 symbols
     *   - string value to customize responseText data, colon-separated pairs name:value where
     *       - name — only `length` supported for now
     *       - value — range on numbers, for example `100-300`, limited to 500000 characters
     *
     * > Usage with no arguments will log XMLHttpRequest objects to browser console;
     * which is useful for debugging but permitted for production filter lists.
     *
     * **Examples**
     * 1. Log all XMLHttpRequests
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr')
     *     ```
     *
     * 2. Prevent all XMLHttpRequests
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr', '*')
     *     example.org#%#//scriptlet('prevent-xhr', '')
     *     ```
     *
     * 3. Prevent XMLHttpRequests for specific url
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr', 'example.org')
     *     ```
     *
     * 4. Prevent XMLHttpRequests for specific request method
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr', 'method:HEAD')
     *     ```
     *
     * 5. Prevent XMLHttpRequests for specific url and specified request methods
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr', 'example.org method:/HEAD|GET/')
     *     ```
     *
     * 6. Prevent XMLHttpRequests for specific url and randomize it's response text
     *     ```
     *     example.org#%#//scriptlet('prevent-xhr', 'example.org', 'true')
     *     ```
     *
     * 7. Prevent XMLHttpRequests for specific url and randomize it's response text with range
     *     ```
     *    example.org#%#//scriptlet('prevent-xhr', 'example.org', 'length:100-300')
     *     ```
     */

    /* eslint-enable max-len */

    function preventXHR$1(source, propsToMatch, customResponseText) {
      // do nothing if browser does not support Proxy (e.g. Internet Explorer)
      // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy
      if (typeof Proxy === 'undefined') {
        return;
      }

      var shouldPrevent = false;
      var response = '';
      var responseText = '';
      var responseUrl;

      var openWrapper = function openWrapper(target, thisArg, args) {
        // Get method and url from .open()
        var xhrData = {
          method: args[0],
          url: args[1]
        };
        responseUrl = xhrData.url;

        if (typeof propsToMatch === 'undefined') {
          // Log if no propsToMatch given
          var logMessage = "log: xhr( ".concat(objectToString(xhrData), " )");
          hit(source, logMessage);
        } else if (propsToMatch === '' || propsToMatch === getWildcardSymbol()) {
          // Prevent all fetch calls
          shouldPrevent = true;
        } else {
          var parsedData = parseMatchProps(propsToMatch);

          if (!validateParsedData(parsedData)) {
            // eslint-disable-next-line no-console
            console.log("Invalid parameter: ".concat(propsToMatch));
            shouldPrevent = false;
          } else {
            var matchData = getMatchPropsData(parsedData); // prevent only if all props match

            shouldPrevent = Object.keys(matchData).every(function (matchKey) {
              var matchValue = matchData[matchKey];
              return Object.prototype.hasOwnProperty.call(xhrData, matchKey) && matchValue.test(xhrData[matchKey]);
            });
          }
        }

        return Reflect.apply(target, thisArg, args);
      };

      var sendWrapper = function sendWrapper(target, thisArg, args) {
        if (!shouldPrevent) {
          return Reflect.apply(target, thisArg, args);
        }

        if (thisArg.responseType === 'blob') {
          response = new Blob();
        }

        if (thisArg.responseType === 'arraybuffer') {
          response = new ArrayBuffer();
        }

        if (customResponseText) {
          var randomText = generateRandomResponse(customResponseText);

          if (randomText) {
            responseText = randomText;
          } else {
            // eslint-disable-next-line no-console
            console.log("Invalid range: ".concat(customResponseText));
          }
        } // Mock response object


        Object.defineProperties(thisArg, {
          readyState: {
            value: 4,
            writable: false
          },
          response: {
            value: response,
            writable: false
          },
          responseText: {
            value: responseText,
            writable: false
          },
          responseURL: {
            value: responseUrl,
            writable: false
          },
          responseXML: {
            value: '',
            writable: false
          },
          status: {
            value: 200,
            writable: false
          },
          statusText: {
            value: 'OK',
            writable: false
          }
        }); // Mock events

        setTimeout(function () {
          var stateEvent = new Event('readystatechange');
          thisArg.dispatchEvent(stateEvent);
          var loadEvent = new Event('load');
          thisArg.dispatchEvent(loadEvent);
          var loadEndEvent = new Event('loadend');
          thisArg.dispatchEvent(loadEndEvent);
        }, 1);
        hit(source);
        return undefined;
      };

      var openHandler = {
        apply: openWrapper
      };
      var sendHandler = {
        apply: sendWrapper
      };
      XMLHttpRequest.prototype.open = new Proxy(XMLHttpRequest.prototype.open, openHandler);
      XMLHttpRequest.prototype.send = new Proxy(XMLHttpRequest.prototype.send, sendHandler);
    }
    preventXHR$1.names = ['prevent-xhr', // aliases are needed for matching the related scriptlet converted into our syntax
    'no-xhr-if.js', 'ubo-no-xhr-if.js', 'ubo-no-xhr-if'];
    preventXHR$1.injections = [hit, objectToString, getWildcardSymbol, parseMatchProps, validateParsedData, getMatchPropsData, getRandomIntInclusive, getRandomStrByLength, generateRandomResponse, toRegExp, isValidStrPattern, escapeRegExp, isEmptyObject, getObjectEntries, getNumberFromString, nativeIsFinite, nativeIsNaN];

    /**
     * @scriptlet close-window
     *
     * @description
     * Closes the browser tab immediately.
     *
     * > `window.close()` usage is restricted in Chrome. In this case
     * tab will only be closed if using AdGuard browser extension.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('close-window'[, path])
     * ```
     *
     * - `path` — optional, string or regular expression
     * matching the current location's path: `window.location.pathname` + `window.location.search`.
     * Defaults to execute on every page.
     *
     * **Examples**
     * ```
     * ! closes any example.org tab
     * example.org#%#//scriptlet('close-window')
     *
     * ! closes specific example.org tab
     * example.org#%#//scriptlet('close-window', '/example-page.html')
     * ```
     */

    function forceWindowClose$1(source) {
      var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      // eslint-disable-next-line no-console
      var log = console.log.bind(console); // https://github.com/AdguardTeam/Scriptlets/issues/158#issuecomment-993423036

      if (typeof window.close !== 'function') {
        if (source.verbose) {
          log('window.close() is not a function so \'close-window\' scriptlet is unavailable');
        }

        return;
      }

      var closeImmediately = function closeImmediately() {
        try {
          hit(source);
          window.close();
        } catch (e) {
          // log the error if window closing is impossible
          // https://developer.mozilla.org/en-US/docs/Web/API/Window/close
          log(e);
        }
      };

      var closeByExtension = function closeByExtension() {
        var extCall = function extCall() {
          dispatchEvent(new Event('adguard:scriptlet-close-window'));
        };

        window.addEventListener('adguard:subscribed-to-close-window', extCall, {
          once: true
        });
        setTimeout(function () {
          window.removeEventListener('adguard:subscribed-to-close-window', extCall, {
            once: true
          });
        }, 5000);
      };

      var shouldClose = function shouldClose() {
        if (path === '') {
          return true;
        }

        var pathRegexp = toRegExp(path);
        var currentPath = "".concat(window.location.pathname).concat(window.location.search);
        return pathRegexp.test(currentPath);
      };

      if (shouldClose()) {
        closeImmediately();

        if (navigator.userAgent.indexOf('Chrome') > -1) {
          closeByExtension();
        }
      }
    }
    forceWindowClose$1.names = ['close-window', 'window-close-if.js', 'ubo-window-close-if.js', 'ubo-window-close-if'];
    forceWindowClose$1.injections = [hit, toRegExp];

    /* eslint-disable max-len */

    /**
     * @scriptlet prevent-refresh
     *
     * @description
     * Prevents reloading of a document through a meta "refresh" tag.
     *
     * Related UBO scriptlet:
     * https://github.com/gorhill/uBlock/wiki/Resources-Library#refresh-defuserjs-
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-refresh'[, delay])
     * ```
     *
     * - `delay` - optional, number of seconds for delay that indicates when scriptlet should run. If not set, source tag value will be applied.
     *
     * **Examples**
     * 1. Prevent reloading of a document through a meta "refresh" tag.
     * ```
     *     enrt.eu#%#//scriptlet('prevent-refresh')
     * ```
     *
     * 2. Prevent reloading of a document with delay.
     * ```
     *     cryptodirectories.com#%#//scriptlet('prevent-refresh', 3)
     * ```
     */

    /* eslint-enable max-len */

    function preventRefresh$1(source, delaySec) {
      var getMetaElements = function getMetaElements() {
        var metaNodes = [];

        try {
          metaNodes = document.querySelectorAll('meta[http-equiv="refresh" i][content]');
        } catch (e) {
          // 'i' attribute flag is problematic in Edge 15
          try {
            metaNodes = document.querySelectorAll('meta[http-equiv="refresh"][content]');
          } catch (e) {
            if (source.verbose) {
              // eslint-disable-next-line no-console
              console.log(e);
            }
          }
        }

        return Array.from(metaNodes);
      };

      var getMetaContentDelay = function getMetaContentDelay(metaElements) {
        var delays = metaElements.map(function (meta) {
          var contentString = meta.getAttribute('content');

          if (contentString.length === 0) {
            return null;
          }

          var contentDelay; // https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-http-equiv

          var limiterIndex = contentString.indexOf(';');

          if (limiterIndex !== -1) {
            var delaySubstring = contentString.substring(0, limiterIndex);
            contentDelay = getNumberFromString(delaySubstring);
          } else {
            contentDelay = getNumberFromString(contentString);
          }

          return contentDelay;
        }).filter(function (delay) {
          return delay !== null;
        }); // Check if "delays" array is empty, may happens when meta's content is invalid
        // and reduce() method cannot be used with empty arrays without initial value

        if (!delays.length) {
          return null;
        } // Get smallest delay of all metas on the page


        var minDelay = delays.reduce(function (a, b) {
          return Math.min(a, b);
        }); // eslint-disable-next-line consistent-return

        return minDelay;
      };

      var stop = function stop() {
        var metaElements = getMetaElements();

        if (metaElements.length === 0) {
          return;
        }

        var secondsToRun = getNumberFromString(delaySec); // Check if argument is provided

        if (secondsToRun === null) {
          secondsToRun = getMetaContentDelay(metaElements);
        } // Check if meta tag has delay


        if (secondsToRun === null) {
          return;
        }

        var delayMs = secondsToRun * 1000;
        setTimeout(function () {
          window.stop();
          hit(source);
        }, delayMs);
      };

      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', stop, {
          once: true
        });
      } else {
        stop();
      }
    }
    preventRefresh$1.names = ['prevent-refresh', // Aliases are needed for matching the related scriptlet converted into our syntax
    // These are used by UBO rules syntax
    // https://github.com/gorhill/uBlock/wiki/Resources-Library#general-purpose-scriptlets
    'refresh-defuser.js', 'refresh-defuser', // Prefix 'ubo-' is required to run converted rules
    'ubo-refresh-defuser.js', 'ubo-refresh-defuser'];
    preventRefresh$1.injections = [hit, getNumberFromString, nativeIsNaN];

    /* eslint-disable max-len, consistent-return */

    /**
     * @scriptlet prevent-element-src-loading
     *
     * @description
     * Prevents target element source loading without triggering 'onerror' listeners and not breaking 'onload' ones.
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('prevent-element-src-loading', tagName, match)
     * ```
     *
     * - `tagName` - required, case-insensitive target element tagName which `src` property resource loading will be silently prevented; possible values:
     *     - `script`
     *     - `img`
     *     - `iframe`
     * - `match` - required, string or regular expression for matching the element's URL;
     *
     * **Examples**
     * 1. Prevent script source loading:
     * ```
     *     example.org#%#//scriptlet('prevent-element-src-loading', 'script' ,'adsbygoogle')
     * ```
     */

    /* eslint-enable max-len */

    function preventElementSrcLoading$1(source, tagName, match) {
      // do nothing if browser does not support Proxy or Reflect
      if (typeof Proxy === 'undefined' || typeof Reflect === 'undefined') {
        return;
      }

      var srcMockData = {
        // "KCk9Pnt9" = "()=>{}"
        script: 'data:text/javascript;base64,KCk9Pnt9',
        // Empty 1x1 image
        img: 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==',
        // Empty h1 tag
        iframe: 'data:text/html;base64, PGRpdj48L2Rpdj4='
      };
      var instance;

      if (tagName === 'script') {
        instance = HTMLScriptElement;
      } else if (tagName === 'img') {
        instance = HTMLImageElement;
      } else if (tagName === 'iframe') {
        instance = HTMLIFrameElement;
      } else {
        return;
      } // For websites that use Trusted Types
      // https://w3c.github.io/webappsec-trusted-types/dist/spec/


      var hasTrustedTypes = window.trustedTypes && typeof window.trustedTypes.createPolicy === 'function';
      var policy;

      if (hasTrustedTypes) {
        policy = window.trustedTypes.createPolicy('mock', {
          createScriptURL: function createScriptURL(arg) {
            return arg;
          }
        });
      }

      var SOURCE_PROPERTY_NAME = 'src';
      var searchRegexp = toRegExp(match);

      var setAttributeWrapper = function setAttributeWrapper(target, thisArg, args) {
        // Check if arguments are present
        if (!args[0] || !args[1]) {
          return Reflect.apply(target, thisArg, args);
        }

        var nodeName = thisArg.nodeName.toLowerCase();
        var attrName = args[0].toLowerCase();
        var attrValue = args[1];
        var isMatched = attrName === SOURCE_PROPERTY_NAME && tagName.toLowerCase() === nodeName && srcMockData[nodeName] && searchRegexp.test(attrValue);

        if (!isMatched) {
          return Reflect.apply(target, thisArg, args);
        }

        hit(source); // Forward the URI that corresponds with element's MIME type

        return Reflect.apply(target, thisArg, [attrName, srcMockData[nodeName]]);
      };

      var setAttributeHandler = {
        apply: setAttributeWrapper
      }; // eslint-disable-next-line max-len

      instance.prototype.setAttribute = new Proxy(Element.prototype.setAttribute, setAttributeHandler);
      var origDescriptor = safeGetDescriptor(instance.prototype, SOURCE_PROPERTY_NAME);

      if (!origDescriptor) {
        return;
      }

      Object.defineProperty(instance.prototype, SOURCE_PROPERTY_NAME, {
        enumerable: true,
        configurable: true,
        get: function get() {
          return origDescriptor.get.call(this);
        },
        set: function set(urlValue) {
          var nodeName = this.nodeName.toLowerCase();
          var isMatched = tagName.toLowerCase() === nodeName && srcMockData[nodeName] && searchRegexp.test(urlValue);

          if (!isMatched) {
            origDescriptor.set.call(this, urlValue);
            return;
          } // eslint-disable-next-line no-undef


          if (policy && urlValue instanceof TrustedScriptURL) {
            var trustedSrc = policy.createScriptURL(urlValue);
            origDescriptor.set.call(this, trustedSrc);
            hit(source);
            return;
          }

          origDescriptor.set.call(this, srcMockData[nodeName]);
          hit(source);
        }
      });
    }
    preventElementSrcLoading$1.names = ['prevent-element-src-loading'];
    preventElementSrcLoading$1.injections = [hit, toRegExp, safeGetDescriptor];

    /**
     * @scriptlet no-topics
     *
     * @description
     * Prevents using The Topics API
     * https://developer.chrome.com/docs/privacy-sandbox/topics/
     *
     * **Syntax**
     * ```
     * example.org#%#//scriptlet('no-topics')
     * ```
     */

    function noTopics$1(source) {
      var TOPICS_PROPERTY_NAME = 'browsingTopics';

      if (Document instanceof Object === false) {
        return;
      }

      if (!Object.prototype.hasOwnProperty.call(Document.prototype, TOPICS_PROPERTY_NAME) || Document.prototype[TOPICS_PROPERTY_NAME] instanceof Function === false) {
        return;
      } // document.browsingTopics() is async function so it's better to return noopPromiseResolve()
      // https://github.com/patcg-individual-drafts/topics#the-api-and-how-it-works


      Document.prototype[TOPICS_PROPERTY_NAME] = function () {
        return noopPromiseResolve('[]');
      };

      hit(source);
    }
    noTopics$1.names = ['no-topics'];
    noTopics$1.injections = [hit, noopPromiseResolve];

    /**
     * This file must export all scriptlets which should be accessible
     */

    var scriptletList = /*#__PURE__*/Object.freeze({
        __proto__: null,
        abortOnPropertyRead: abortOnPropertyRead$1,
        abortOnPropertyWrite: abortOnPropertyWrite$1,
        preventSetTimeout: preventSetTimeout$1,
        preventSetInterval: preventSetInterval$1,
        preventWindowOpen: preventWindowOpen$1,
        abortCurrentInlineScript: abortCurrentInlineScript$1,
        setConstant: setConstant$1,
        removeCookie: removeCookie$1,
        preventAddEventListener: preventAddEventListener$1,
        preventBab: preventBab$1,
        nowebrtc: nowebrtc$1,
        logAddEventListener: logAddEventListener$1,
        logEval: logEval$1,
        log: log$1,
        noeval: noeval$1,
        preventEvalIf: preventEvalIf$1,
        preventFab: preventFab$1,
        setPopadsDummy: setPopadsDummy$1,
        preventPopadsNet: preventPopadsNet$1,
        preventAdfly: preventAdfly$1,
        debugOnPropertyRead: debugOnPropertyRead$1,
        debugOnPropertyWrite: debugOnPropertyWrite$1,
        debugCurrentInlineScript: debugCurrentInlineScript$1,
        removeAttr: removeAttr$1,
        setAttr: setAttr$1,
        removeClass: removeClass$1,
        disableNewtabLinks: disableNewtabLinks$1,
        adjustSetInterval: adjustSetInterval$1,
        adjustSetTimeout: adjustSetTimeout$1,
        dirString: dirString$1,
        jsonPrune: jsonPrune$1,
        preventRequestAnimationFrame: preventRequestAnimationFrame$1,
        setCookie: setCookie$1,
        setCookieReload: setCookieReload$1,
        hideInShadowDom: hideInShadowDom$1,
        removeInShadowDom: removeInShadowDom$1,
        preventFetch: preventFetch$1,
        setLocalStorageItem: setLocalStorageItem$1,
        setSessionStorageItem: setSessionStorageItem$1,
        abortOnStackTrace: abortOnStackTrace$1,
        logOnStacktrace: logOnStacktrace$1,
        preventXHR: preventXHR$1,
        forceWindowClose: forceWindowClose$1,
        preventRefresh: preventRefresh$1,
        preventElementSrcLoading: preventElementSrcLoading$1,
        noTopics: noTopics$1
    });

    /**
     * Store of ADG redirects names and their analogs.
     * As it is not a compatibility table, no need to keep in redirects array third-party redirects.
     *
     * Needed only for conversion purposes.
     * e.g. googletagmanager-gtm is removed and should be removed from compatibility table as well
     * but now it works as alias for google-analytics so it should stay valid for compiler
     */
    var redirects$1 = [{
      adg: '1x1-transparent.gif',
      ubo: '1x1.gif',
      abp: '1x1-transparent-gif'
    }, {
      adg: '2x2-transparent.png',
      ubo: '2x2.png',
      abp: '2x2-transparent-png'
    }, {
      adg: '3x2-transparent.png',
      ubo: '3x2.png',
      abp: '3x2-transparent-png'
    }, {
      adg: '32x32-transparent.png',
      ubo: '32x32.png',
      abp: '32x32-transparent-png'
    }, {
      adg: 'amazon-apstag',
      ubo: 'amazon_apstag.js'
    }, {
      adg: 'ati-smarttag'
    }, {
      adg: 'didomi-loader'
    }, {
      adg: 'click2load.html',
      ubo: 'click2load.html'
    }, {
      adg: 'fingerprintjs2',
      ubo: 'fingerprint2.js'
    }, {
      adg: 'fingerprintjs3',
      ubo: 'fingerprint3.js'
    }, {
      adg: 'google-analytics',
      ubo: 'google-analytics_analytics.js'
    }, {
      adg: 'google-analytics-ga',
      ubo: 'google-analytics_ga.js'
    }, {
      adg: 'googlesyndication-adsbygoogle',
      ubo: 'googlesyndication_adsbygoogle.js'
    }, {
      // https://github.com/AdguardTeam/Scriptlets/issues/162
      adg: 'googlesyndication-adsbygoogle',
      ubo: 'googlesyndication.com/adsbygoogle.js'
    }, {
      // https://github.com/AdguardTeam/Scriptlets/issues/127
      adg: 'googletagmanager-gtm',
      ubo: 'google-analytics_ga.js'
    }, {
      adg: 'googletagservices-gpt',
      ubo: 'googletagservices_gpt.js'
    }, {
      adg: 'google-ima3'
    }, {
      adg: 'gemius'
    }, {
      adg: 'matomo'
    }, {
      adg: 'metrika-yandex-watch'
    }, {
      adg: 'metrika-yandex-tag'
    }, {
      adg: 'naver-wcslog'
    }, {
      adg: 'noeval',
      ubo: 'noeval-silent.js'
    }, {
      adg: 'noopcss',
      abp: 'blank-css'
    }, {
      adg: 'noopframe',
      ubo: 'noop.html',
      abp: 'blank-html'
    }, {
      adg: 'noopjs',
      ubo: 'noop.js',
      abp: 'blank-js'
    }, {
      adg: 'noopjson'
    }, {
      adg: 'nooptext',
      ubo: 'noop.txt',
      abp: 'blank-text'
    }, {
      adg: 'noopmp3-0.1s',
      ubo: 'noop-0.1s.mp3',
      abp: 'blank-mp3'
    }, {
      adg: 'noopmp4-1s',
      ubo: 'noop-1s.mp4',
      abp: 'blank-mp4'
    }, {
      adg: 'noopvmap-1.0',
      ubo: 'noop-vmap1.0.xml'
    }, {
      adg: 'noopvast-2.0'
    }, {
      adg: 'noopvast-3.0'
    }, {
      adg: 'noopvast-4.0'
    }, {
      adg: 'prebid'
    }, {
      adg: 'pardot-1.0'
    }, {
      adg: 'prevent-bab',
      ubo: 'nobab.js'
    }, {
      adg: 'prevent-bab2',
      ubo: 'nobab2.js'
    }, {
      adg: 'prevent-fab-3.2.0',
      ubo: 'nofab.js'
    }, {
      // AG-15917
      adg: 'prevent-fab-3.2.0',
      ubo: 'fuckadblock.js-3.2.0'
    }, {
      adg: 'prevent-popads-net',
      ubo: 'popads.js'
    }, {
      adg: 'scorecardresearch-beacon',
      ubo: 'scorecardresearch_beacon.js'
    }, {
      adg: 'set-popads-dummy',
      ubo: 'popads-dummy.js'
    }, {
      adg: 'empty',
      ubo: 'empty'
    }, {
      adg: 'prebid-ads',
      ubo: 'prebid-ads.js'
    }];

    var JS_RULE_MARKER = '#%#';
    var COMMENT_MARKER = '!';
    /**
     * Checks if rule text is comment e.g. !!example.org##+js(set-constant.js, test, false)
     * @param {string} rule
     * @return {boolean}
     */

    var isComment = function isComment(rule) {
      return startsWith(rule, COMMENT_MARKER);
    };
    /* ************************************************************************
     *
     * Scriptlets
     *
     ************************************************************************** */

    /**
     * uBlock scriptlet rule mask
     */


    var UBO_SCRIPTLET_MASK_REG = /#@?#script:inject|#@?#\s*\+js/;
    var UBO_SCRIPTLET_MASK_1 = '##+js';
    var UBO_SCRIPTLET_MASK_2 = '##script:inject';
    var UBO_SCRIPTLET_EXCEPTION_MASK_1 = '#@#+js';
    var UBO_SCRIPTLET_EXCEPTION_MASK_2 = '#@#script:inject';
    /**
     * AdBlock Plus snippet rule mask
     */

    var ABP_SCRIPTLET_MASK = '#$#';
    var ABP_SCRIPTLET_EXCEPTION_MASK = '#@$#';
    /**
     * AdGuard CSS rule mask
     */

    var ADG_CSS_MASK_REG = /#@?\$#.+?\s*\{.*\}\s*$/g;
    /**
     * Checks if the `rule` is AdGuard scriptlet rule
     * @param {string} rule - rule text
     */

    var isAdgScriptletRule = function isAdgScriptletRule(rule) {
      return !isComment(rule) && rule.indexOf(ADG_SCRIPTLET_MASK) > -1;
    };
    /**
     * Checks if the `rule` is uBO scriptlet rule
     * @param {string} rule rule text
     */


    var isUboScriptletRule = function isUboScriptletRule(rule) {
      return (rule.indexOf(UBO_SCRIPTLET_MASK_1) > -1 || rule.indexOf(UBO_SCRIPTLET_MASK_2) > -1 || rule.indexOf(UBO_SCRIPTLET_EXCEPTION_MASK_1) > -1 || rule.indexOf(UBO_SCRIPTLET_EXCEPTION_MASK_2) > -1) && UBO_SCRIPTLET_MASK_REG.test(rule) && !isComment(rule);
    };
    /**
     * Checks if the `rule` is AdBlock Plus snippet
     * @param {string} rule rule text
     */


    var isAbpSnippetRule = function isAbpSnippetRule(rule) {
      return (rule.indexOf(ABP_SCRIPTLET_MASK) > -1 || rule.indexOf(ABP_SCRIPTLET_EXCEPTION_MASK) > -1) && rule.search(ADG_CSS_MASK_REG) === -1 && !isComment(rule);
    };
    /**
     * Finds scriptlet by it's name
     * @param {string} name - scriptlet name
     */


    var getScriptletByName = function getScriptletByName(name) {
      var scriptlets = Object.keys(scriptletList).map(function (key) {
        return scriptletList[key];
      });
      return scriptlets.find(function (s) {
        return s.names // full match name checking
        && (s.names.indexOf(name) > -1 // or check ubo alias name without '.js' at the end
        || !endsWith(name, '.js') && s.names.indexOf("".concat(name, ".js")) > -1);
      });
    };
    /**
     * Checks if the scriptlet name is valid
     * @param {string} name - Scriptlet name
     */


    var isValidScriptletName = function isValidScriptletName(name) {
      if (!name) {
        return false;
      }

      var scriptlet = getScriptletByName(name);

      if (!scriptlet) {
        return false;
      }

      return true;
    };
    /* ************************************************************************
     *
     * Redirects
     *
     ************************************************************************** */

    /**
     * Redirect resources markers
     */


    var ADG_UBO_REDIRECT_MARKER = 'redirect=';
    var ADG_UBO_REDIRECT_RULE_MARKER = 'redirect-rule=';
    var ABP_REDIRECT_MARKER = 'rewrite=abp-resource:';
    var EMPTY_REDIRECT_MARKER = 'empty';
    var VALID_SOURCE_TYPES = ['image', 'media', 'subdocument', 'stylesheet', 'script', 'xmlhttprequest', 'other'];
    /**
     * Source types for redirect rules if there is no one of them.
     * Used for ADG -> UBO conversion.
     */

    var ABSENT_SOURCE_TYPE_REPLACEMENT = [{
      NAME: 'nooptext',
      TYPES: VALID_SOURCE_TYPES
    }, {
      NAME: 'noopjs',
      TYPES: ['script']
    }, {
      NAME: 'noopframe',
      TYPES: ['subdocument']
    }, {
      NAME: '1x1-transparent.gif',
      TYPES: ['image']
    }, {
      NAME: 'noopmp3-0.1s',
      TYPES: ['media']
    }, {
      NAME: 'noopmp4-1s',
      TYPES: ['media']
    }, {
      NAME: 'googlesyndication-adsbygoogle',
      TYPES: ['xmlhttprequest', 'script']
    }, {
      NAME: 'google-analytics',
      TYPES: ['script']
    }, {
      NAME: 'googletagservices-gpt',
      TYPES: ['script']
    }];
    var validAdgRedirects = redirects$1.filter(function (el) {
      return el.adg;
    });
    /**
     * Compatibility object where KEYS = UBO redirect names and VALUES = ADG redirect names
     * It's used for UBO -> ADG converting
     */

    var uboToAdgCompatibility = getObjectFromEntries(validAdgRedirects.filter(function (el) {
      return el.ubo;
    }).map(function (el) {
      return [el.ubo, el.adg];
    }));
    /**
     * Compatibility object where KEYS = ABP redirect names and VALUES = ADG redirect names
     * It's used for ABP -> ADG converting
     */

    var abpToAdgCompatibility = getObjectFromEntries(validAdgRedirects.filter(function (el) {
      return el.abp;
    }).map(function (el) {
      return [el.abp, el.adg];
    }));
    /**
     * Compatibility object where KEYS = UBO redirect names and VALUES = ADG redirect names
     * It's used for ADG -> UBO converting
     */

    var adgToUboCompatibility = getObjectFromEntries(validAdgRedirects.filter(function (el) {
      return el.ubo;
    }).map(function (el) {
      return [el.adg, el.ubo];
    }));
    /**
     * Needed for AdGuard redirect names validation where KEYS = **valid** AdGuard redirect names
     * 'adgToUboCompatibility' is still needed for ADG -> UBO converting
     */

    var validAdgCompatibility = getObjectFromEntries(validAdgRedirects.map(function (el) {
      return [el.adg, 'valid adg redirect'];
    }));
    var REDIRECT_RULE_TYPES = {
      VALID_ADG: {
        redirectMarker: ADG_UBO_REDIRECT_MARKER,
        redirectRuleMarker: ADG_UBO_REDIRECT_RULE_MARKER,
        compatibility: validAdgCompatibility
      },
      ADG: {
        redirectMarker: ADG_UBO_REDIRECT_MARKER,
        redirectRuleMarker: ADG_UBO_REDIRECT_RULE_MARKER,
        compatibility: adgToUboCompatibility
      },
      UBO: {
        redirectMarker: ADG_UBO_REDIRECT_MARKER,
        redirectRuleMarker: ADG_UBO_REDIRECT_RULE_MARKER,
        compatibility: uboToAdgCompatibility
      },
      ABP: {
        redirectMarker: ABP_REDIRECT_MARKER,
        compatibility: abpToAdgCompatibility
      }
    };
    /**
     * Parses redirect rule modifiers
     * @param {string} rule
     * @returns {Array}
     */

    var parseModifiers = function parseModifiers(rule) {
      return substringAfter$1(rule, '$').split(',');
    };
    /**
     * Gets redirect resource name
     * @param {string} rule
     * @param {string} marker - specific Adg/Ubo or Abp redirect resources marker
     * @returns {string} - redirect resource name
     */


    var getRedirectName = function getRedirectName(rule, marker) {
      var ruleModifiers = parseModifiers(rule);
      var redirectNamePart = ruleModifiers.find(function (el) {
        return el.indexOf(marker) > -1;
      });
      return substringAfter$1(redirectNamePart, marker);
    };
    /**
     * Checks if the `rule` is AdGuard redirect rule.
     * Discards comments and JS rules and checks if the `rule` has 'redirect' modifier.
     * @param {string} rule - rule text
     */


    var isAdgRedirectRule = function isAdgRedirectRule(rule) {
      var MARKER_IN_BASE_PART_MASK = '/((?!\\$|\\,).{1})redirect((-rule)?)=(.{0,}?)\\$(popup)?/';
      return !isComment(rule) && (rule.indexOf(REDIRECT_RULE_TYPES.ADG.redirectMarker) > -1 || rule.indexOf(REDIRECT_RULE_TYPES.ADG.redirectRuleMarker) > -1) // some js rules may have 'redirect=' in it, so we should get rid of them
      && rule.indexOf(JS_RULE_MARKER) === -1 // get rid of rules like '_redirect=*://look.$popup'
      && !toRegExp(MARKER_IN_BASE_PART_MASK).test(rule);
    }; // const getRedirectResourceMarkerData = ()

    /**
     * Checks if the `rule` satisfies the `type`
     * @param {string} rule - rule text
     * @param {'VALID_ADG'|'ADG'|'UBO'|'ABP'} type - type of a redirect rule
     */


    var isRedirectRuleByType = function isRedirectRuleByType(rule, type) {
      var _REDIRECT_RULE_TYPES$ = REDIRECT_RULE_TYPES[type],
          redirectMarker = _REDIRECT_RULE_TYPES$.redirectMarker,
          redirectRuleMarker = _REDIRECT_RULE_TYPES$.redirectRuleMarker,
          compatibility = _REDIRECT_RULE_TYPES$.compatibility;

      if (rule && !isComment(rule)) {
        var marker; // check if there is a $redirect-rule modifier in rule

        var markerIndex = redirectRuleMarker ? rule.indexOf(redirectRuleMarker) : -1;

        if (markerIndex > -1) {
          marker = redirectRuleMarker;
        } else {
          // check if there $redirect modifier in rule
          markerIndex = rule.indexOf(redirectMarker);

          if (markerIndex > -1) {
            marker = redirectMarker;
          } else {
            return false;
          }
        }

        var redirectName = getRedirectName(rule, marker);

        if (!redirectName) {
          return false;
        }

        return redirectName === Object.keys(compatibility).find(function (el) {
          return el === redirectName;
        });
      }

      return false;
    };
    /**
    * Checks if the `rule` is **valid** AdGuard redirect resource rule
    * @param {string} rule - rule text
    * @returns {boolean}
    */


    var isValidAdgRedirectRule = function isValidAdgRedirectRule(rule) {
      return isRedirectRuleByType(rule, 'VALID_ADG');
    };
    /**
    * Checks if the AdGuard redirect `rule` has Ubo analog. Needed for Adg->Ubo conversion
    * @param {string} rule - AdGuard rule text
    * @returns {boolean} - true if the rule can be converted to Ubo
    */


    var isAdgRedirectCompatibleWithUbo = function isAdgRedirectCompatibleWithUbo(rule) {
      return isAdgRedirectRule(rule) && isRedirectRuleByType(rule, 'ADG');
    };
    /**
    * Checks if the Ubo redirect `rule` has AdGuard analog. Needed for Ubo->Adg conversion
    * @param {string} rule - Ubo rule text
    * @returns {boolean} - true if the rule can be converted to AdGuard
    */


    var isUboRedirectCompatibleWithAdg = function isUboRedirectCompatibleWithAdg(rule) {
      return isRedirectRuleByType(rule, 'UBO');
    };
    /**
    * Checks if the Abp redirect `rule` has AdGuard analog. Needed for Abp->Adg conversion
    * @param {string} rule - Abp rule text
    * @returns {boolean} - true if the rule can be converted to AdGuard
    */


    var isAbpRedirectCompatibleWithAdg = function isAbpRedirectCompatibleWithAdg(rule) {
      return isRedirectRuleByType(rule, 'ABP');
    };
    /**
     * Checks if the rule has specified content type before Adg -> Ubo conversion.
     *
     * Used ONLY for Adg -> Ubo conversion
     * because Ubo redirect rules must contain content type, but Adg and Abp must not.
     *
     * Also source type can not be added automatically because of such valid rules:
     * ! Abp:
     * $rewrite=abp-resource:blank-js,xmlhttprequest
     * ! Adg:
     * $script,redirect=noopvast-2.0
     * $xmlhttprequest,redirect=noopvast-2.0
     *
     * @param {string} rule
     * @returns {boolean}
     */


    var hasValidContentType = function hasValidContentType(rule) {
      var ruleModifiers = parseModifiers(rule); // rule can have more than one source type modifier

      var sourceTypes = ruleModifiers.filter(function (el) {
        return VALID_SOURCE_TYPES.indexOf(el) > -1;
      });
      var isSourceTypeSpecified = sourceTypes.length > 0; // eslint-disable-next-line max-len

      var isEmptyRedirect = ruleModifiers.indexOf("".concat(ADG_UBO_REDIRECT_MARKER).concat(EMPTY_REDIRECT_MARKER)) > -1 || ruleModifiers.indexOf("".concat(ADG_UBO_REDIRECT_RULE_MARKER).concat(EMPTY_REDIRECT_MARKER)) > -1;

      if (isEmptyRedirect) {
        // no source type for 'empty' is allowed
        return true;
      }

      return isSourceTypeSpecified;
    };

    var validator = {
      UBO_SCRIPTLET_MASK_REG: UBO_SCRIPTLET_MASK_REG,
      ABP_SCRIPTLET_MASK: ABP_SCRIPTLET_MASK,
      ABP_SCRIPTLET_EXCEPTION_MASK: ABP_SCRIPTLET_EXCEPTION_MASK,
      isComment: isComment,
      isAdgScriptletRule: isAdgScriptletRule,
      isUboScriptletRule: isUboScriptletRule,
      isAbpSnippetRule: isAbpSnippetRule,
      getScriptletByName: getScriptletByName,
      isValidScriptletName: isValidScriptletName,
      ADG_UBO_REDIRECT_RULE_MARKER: ADG_UBO_REDIRECT_RULE_MARKER,
      REDIRECT_RULE_TYPES: REDIRECT_RULE_TYPES,
      ABSENT_SOURCE_TYPE_REPLACEMENT: ABSENT_SOURCE_TYPE_REPLACEMENT,
      isAdgRedirectRule: isAdgRedirectRule,
      isValidAdgRedirectRule: isValidAdgRedirectRule,
      isAdgRedirectCompatibleWithUbo: isAdgRedirectCompatibleWithUbo,
      isUboRedirectCompatibleWithAdg: isUboRedirectCompatibleWithAdg,
      isAbpRedirectCompatibleWithAdg: isAbpRedirectCompatibleWithAdg,
      parseModifiers: parseModifiers,
      getRedirectName: getRedirectName,
      hasValidContentType: hasValidContentType
    };

    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length) len = arr.length;

      for (var i = 0, arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }

    var arrayLikeToArray = _arrayLikeToArray;

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) return arrayLikeToArray(arr);
    }

    var arrayWithoutHoles = _arrayWithoutHoles;

    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
    }

    var iterableToArray = _iterableToArray;

    function _unsupportedIterableToArray(o, minLen) {
      if (!o) return;
      if (typeof o === "string") return arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor) n = o.constructor.name;
      if (n === "Map" || n === "Set") return Array.from(o);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
    }

    var unsupportedIterableToArray = _unsupportedIterableToArray;

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var nonIterableSpread = _nonIterableSpread;

    function _toConsumableArray(arr) {
      return arrayWithoutHoles(arr) || iterableToArray(arr) || unsupportedIterableToArray(arr) || nonIterableSpread();
    }

    var toConsumableArray = _toConsumableArray;

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var arrayWithHoles = _arrayWithHoles;

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var nonIterableRest = _nonIterableRest;

    function _toArray(arr) {
      return arrayWithHoles(arr) || iterableToArray(arr) || unsupportedIterableToArray(arr) || nonIterableRest();
    }

    var toArray$1 = _toArray;

    /**
     * AdGuard scriptlet rule
     */

    var ADGUARD_SCRIPTLET_MASK_REG = /#@?%#\/\/scriptlet\(.+\)/; // eslint-disable-next-line no-template-curly-in-string

    var ADGUARD_SCRIPTLET_TEMPLATE = '${domains}#%#//scriptlet(${args})'; // eslint-disable-next-line no-template-curly-in-string

    var ADGUARD_SCRIPTLET_EXCEPTION_TEMPLATE = '${domains}#@%#//scriptlet(${args})';
    /**
     * uBlock scriptlet rule mask
     */
    // eslint-disable-next-line no-template-curly-in-string

    var UBO_SCRIPTLET_TEMPLATE = '${domains}##+js(${args})'; // eslint-disable-next-line no-template-curly-in-string

    var UBO_SCRIPTLET_EXCEPTION_TEMPLATE = '${domains}#@#+js(${args})';
    var UBO_ALIAS_NAME_MARKER = 'ubo-';
    var UBO_SCRIPTLET_JS_ENDING = '.js'; // https://github.com/gorhill/uBlock/wiki/Static-filter-syntax#xhr

    var UBO_XHR_TYPE = 'xhr';
    var ADG_XHR_TYPE = 'xmlhttprequest';
    var ADG_SET_CONSTANT_NAME = 'set-constant';
    var ADG_SET_CONSTANT_EMPTY_STRING = '';
    var UBO_SET_CONSTANT_EMPTY_STRING = '\'\'';
    var ADG_PREVENT_FETCH_NAME = 'prevent-fetch';
    var ADG_PREVENT_FETCH_EMPTY_STRING = '';
    var ADG_PREVENT_FETCH_WILDCARD = getWildcardSymbol();
    var UBO_NO_FETCH_IF_WILDCARD = '/^/';
    var ESCAPED_COMMA_SEPARATOR = '\\,';
    var COMMA_SEPARATOR = ',';
    var REMOVE_ATTR_METHOD = 'removeAttr';
    var REMOVE_CLASS_METHOD = 'removeClass';
    var REMOVE_ATTR_ALIASES = scriptletList[REMOVE_ATTR_METHOD].names;
    var REMOVE_CLASS_ALIASES = scriptletList[REMOVE_CLASS_METHOD].names;
    var ADG_REMOVE_ATTR_NAME = REMOVE_ATTR_ALIASES[0];
    var ADG_REMOVE_CLASS_NAME = REMOVE_CLASS_ALIASES[0];
    var REMOVE_ATTR_CLASS_APPLYING = ['asap', 'stay', 'complete'];
    /**
     * Returns array of strings separated by space which not in quotes
     * @param {string} str
     */

    var getSentences = function getSentences(str) {
      var reg = /'.*?'|".*?"|\S+/g;
      return str.match(reg);
    };
    /**
     * Replaces string with data by placeholders
     * @param {string} str
     * @param {Object} data - where keys are placeholders names
     */


    var replacePlaceholders = function replacePlaceholders(str, data) {
      return Object.keys(data).reduce(function (acc, key) {
        var reg = new RegExp("\\$\\{".concat(key, "\\}"), 'g');
        acc = acc.replace(reg, data[key]);
        return acc;
      }, str);
    };

    var splitArgs = function splitArgs(str) {
      var args = [];
      var prevArgStart = 0;

      for (var i = 0; i < str.length; i += 1) {
        // do not split args by escaped comma
        // https://github.com/AdguardTeam/Scriptlets/issues/133
        if (str[i] === COMMA_SEPARATOR && str[i - 1] !== '\\') {
          args.push(str.slice(prevArgStart, i).trim());
          prevArgStart = i + 1;
        }
      } // collect arg after last comma


      args.push(str.slice(prevArgStart, str.length).trim());
      return args;
    };
    /**
     * Validates remove-attr/class scriptlet args
     * @param {string[]} parsedArgs
     * @returns {string[]|Error} valid args OR error for invalid selector
     */


    var validateRemoveAttrClassArgs = function validateRemoveAttrClassArgs(parsedArgs) {
      var _parsedArgs = toArray$1(parsedArgs),
          name = _parsedArgs[0],
          value = _parsedArgs[1],
          restArgs = _parsedArgs.slice(2); // no extra checking if there are only scriptlet name and value
      // https://github.com/AdguardTeam/Scriptlets/issues/235


      if (restArgs.length === 0) {
        return [name, value];
      } // remove-attr/class scriptlet might have multiple selectors separated by comma. so we should:
      // 1. check if last arg is 'applying' parameter
      // 2. join 'selector' into one arg
      // 3. combine all args
      // https://github.com/AdguardTeam/Scriptlets/issues/133


      var lastArg = restArgs.pop();
      var applying; // check the last parsed arg for matching possible 'applying' vale

      if (REMOVE_ATTR_CLASS_APPLYING.some(function (el) {
        return lastArg.indexOf(el) > -1;
      })) {
        applying = lastArg;
      } else {
        restArgs.push(lastArg);
      }

      var selector = replaceAll(restArgs.join(', '), ESCAPED_COMMA_SEPARATOR, COMMA_SEPARATOR);

      if (selector.length > 0 && typeof document !== 'undefined') {
        // empty selector is valid for these scriptlets as it applies to all elements,
        // all other selectors should be validated
        // e.g. #%#//scriptlet('ubo-remove-class.js', 'blur', ', html')
        document.querySelectorAll(selector);
      }

      var validArgs = applying ? [name, value, selector, applying] : [name, value, selector];
      return validArgs;
    };
    /**
     * Converts string of UBO scriptlet rule to AdGuard scriptlet rule
     * @param {string} rule - UBO scriptlet rule
     * @returns {string[]} - array with one AdGuard scriptlet rule
     */


    var convertUboScriptletToAdg = function convertUboScriptletToAdg(rule) {
      var domains = getBeforeRegExp(rule, validator.UBO_SCRIPTLET_MASK_REG);
      var mask = rule.match(validator.UBO_SCRIPTLET_MASK_REG)[0];
      var template;

      if (mask.indexOf('@') > -1) {
        template = ADGUARD_SCRIPTLET_EXCEPTION_TEMPLATE;
      } else {
        template = ADGUARD_SCRIPTLET_TEMPLATE;
      }

      var argsStr = getStringInBraces(rule);
      var parsedArgs = splitArgs(argsStr);
      var scriptletName = parsedArgs[0].indexOf(UBO_SCRIPTLET_JS_ENDING) > -1 ? "ubo-".concat(parsedArgs[0]) : "ubo-".concat(parsedArgs[0]).concat(UBO_SCRIPTLET_JS_ENDING);

      if (REMOVE_ATTR_ALIASES.indexOf(scriptletName) > -1 || REMOVE_CLASS_ALIASES.indexOf(scriptletName) > -1) {
        parsedArgs = validateRemoveAttrClassArgs(parsedArgs);
      }

      var args = parsedArgs.map(function (arg, index) {
        var outputArg = arg;

        if (index === 0) {
          outputArg = scriptletName;
        } // for example: example.org##+js(abort-current-inline-script, $, popup)


        if (arg === '$') {
          outputArg = '$$';
        }

        return outputArg;
      }).map(function (arg) {
        return wrapInSingleQuotes(arg);
      }).join("".concat(COMMA_SEPARATOR, " "));
      var adgRule = replacePlaceholders(template, {
        domains: domains,
        args: args
      });
      return [adgRule];
    };
    /**
     * Convert string of ABP snippet rule to AdGuard scriptlet rule
     * @param {string} rule - ABP snippet rule
     * @returns {Array} - array of AdGuard scriptlet rules -
     * one or few items depends on Abp-rule
     */

    var convertAbpSnippetToAdg = function convertAbpSnippetToAdg(rule) {
      var SEMICOLON_DIVIDER = /;(?=(?:(?:[^"]*"){2})*[^"]*$)/g;
      var mask = rule.indexOf(validator.ABP_SCRIPTLET_MASK) > -1 ? validator.ABP_SCRIPTLET_MASK : validator.ABP_SCRIPTLET_EXCEPTION_MASK;
      var template = mask === validator.ABP_SCRIPTLET_MASK ? ADGUARD_SCRIPTLET_TEMPLATE : ADGUARD_SCRIPTLET_EXCEPTION_TEMPLATE;
      var domains = substringBefore(rule, mask);
      var args = substringAfter$1(rule, mask);
      return args.split(SEMICOLON_DIVIDER) // abp-rule may have `;` at the end which makes last array item irrelevant
      // https://github.com/AdguardTeam/Scriptlets/issues/236
      .filter(isExisting).map(function (args) {
        return getSentences(args).map(function (arg, index) {
          return index === 0 ? "abp-".concat(arg) : arg;
        }).map(function (arg) {
          return wrapInSingleQuotes(arg);
        }).join("".concat(COMMA_SEPARATOR, " "));
      }).map(function (args) {
        return replacePlaceholders(template, {
          domains: domains,
          args: args
        });
      });
    };
    /**
     * Converts scriptlet rule to AdGuard one
     * @param {string} rule
     * @returns {Array} - array of AdGuard scriptlet rules -
     * one item for Adg and Ubo or few items for Abp
     */

    var convertScriptletToAdg = function convertScriptletToAdg(rule) {
      var result;

      if (validator.isUboScriptletRule(rule)) {
        result = convertUboScriptletToAdg(rule);
      } else if (validator.isAbpSnippetRule(rule)) {
        result = convertAbpSnippetToAdg(rule);
      } else if (validator.isAdgScriptletRule(rule) || validator.isComment(rule)) {
        result = [rule];
      }

      return result;
    };
    /**
     * Converts UBO scriptlet rule to AdGuard one
     * @param {string} rule - AdGuard scriptlet rule
     * @returns {string} - UBO scriptlet rule
     */

    var convertAdgScriptletToUbo = function convertAdgScriptletToUbo(rule) {
      var res;

      if (validator.isAdgScriptletRule(rule)) {
        var _parseRule = parseRule(rule),
            parsedName = _parseRule.name,
            parsedParams = _parseRule.args;

        var preparedParams; // https://github.com/AdguardTeam/FiltersCompiler/issues/102

        if (parsedName === ADG_SET_CONSTANT_NAME && parsedParams[1] === ADG_SET_CONSTANT_EMPTY_STRING) {
          preparedParams = [parsedParams[0], UBO_SET_CONSTANT_EMPTY_STRING];
        } else if (parsedName === ADG_PREVENT_FETCH_NAME // https://github.com/AdguardTeam/Scriptlets/issues/109
        && (parsedParams[0] === ADG_PREVENT_FETCH_WILDCARD || parsedParams[0] === ADG_PREVENT_FETCH_EMPTY_STRING)) {
          preparedParams = [UBO_NO_FETCH_IF_WILDCARD];
        } else if ((parsedName === ADG_REMOVE_ATTR_NAME || parsedName === ADG_REMOVE_CLASS_NAME) && parsedParams[1] && parsedParams[1].indexOf(COMMA_SEPARATOR) > -1) {
          preparedParams = [parsedParams[0], replaceAll(parsedParams[1], COMMA_SEPARATOR, ESCAPED_COMMA_SEPARATOR)];
        } else {
          preparedParams = parsedParams;
        } // object of name and aliases for the Adg-scriptlet


        var adgScriptletObject = Object.keys(scriptletList).map(function (el) {
          return scriptletList[el];
        }).map(function (s) {
          var _s$names = toArray$1(s.names),
              name = _s$names[0],
              aliases = _s$names.slice(1);

          return {
            name: name,
            aliases: aliases
          };
        }).find(function (el) {
          return el.name === parsedName || el.aliases.indexOf(parsedName) >= 0;
        });
        var aliases = adgScriptletObject.aliases;

        if (aliases.length > 0) {
          var uboAlias = adgScriptletObject.aliases // eslint-disable-next-line no-restricted-properties
          .find(function (alias) {
            return alias.includes(UBO_ALIAS_NAME_MARKER);
          });

          if (uboAlias) {
            var mask = rule.match(ADGUARD_SCRIPTLET_MASK_REG)[0];
            var template;

            if (mask.indexOf('@') > -1) {
              template = UBO_SCRIPTLET_EXCEPTION_TEMPLATE;
            } else {
              template = UBO_SCRIPTLET_TEMPLATE;
            }

            var domains = getBeforeRegExp(rule, ADGUARD_SCRIPTLET_MASK_REG);
            var uboName = uboAlias.replace(UBO_ALIAS_NAME_MARKER, '') // '.js' in the Ubo scriptlet name can be omitted
            // https://github.com/gorhill/uBlock/wiki/Resources-Library#general-purpose-scriptlets
            .replace(UBO_SCRIPTLET_JS_ENDING, '');
            var args = preparedParams.length > 0 ? "".concat(uboName, ", ").concat(preparedParams.join("".concat(COMMA_SEPARATOR, " "))) : uboName;
            var uboRule = replacePlaceholders(template, {
              domains: domains,
              args: args
            });
            res = uboRule;
          }
        }
      }

      return res;
    };
    /**
     * Checks whether the ADG scriptlet exists or UBO/ABP scriptlet is compatible to ADG
     * @param {string} input - can be ADG or UBO or ABP scriptlet rule
     * @returns {boolean}
     */

    var isValidScriptletRule = function isValidScriptletRule(input) {
      if (!input) {
        return false;
      } // ABP 'input' rule may contain more than one snippet


      var rulesArray = convertScriptletToAdg(input); // checking if each of parsed scriptlets is valid
      // if at least one of them is not valid - whole 'input' rule is not valid too

      var isValid = rulesArray.every(function (rule) {
        var parsedRule = parseRule(rule);
        return validator.isValidScriptletName(parsedRule.name);
      });
      return isValid;
    };
    /**
     * Gets index and redirect resource marker from UBO/ADG modifiers array
     * @param {string[]} modifiers
     * @param {Object} redirectsData validator.REDIRECT_RULE_TYPES.(UBO|ADG)
     * @param {string} rule
     * @returns {Object} { index, marker }
     */

    var getMarkerData = function getMarkerData(modifiers, redirectsData, rule) {
      var marker;
      var index = modifiers.findIndex(function (m) {
        return m.indexOf(redirectsData.redirectRuleMarker) > -1;
      });

      if (index > -1) {
        marker = redirectsData.redirectRuleMarker;
      } else {
        index = modifiers.findIndex(function (m) {
          return m.indexOf(redirectsData.redirectMarker) > -1;
        });

        if (index > -1) {
          marker = redirectsData.redirectMarker;
        } else {
          throw new Error("No redirect resource modifier found in rule: ".concat(rule));
        }
      }

      return {
        index: index,
        marker: marker
      };
    };
    /**
     * Converts Ubo redirect rule to Adg one
     * @param {string} rule
     * @returns {string}
     */


    var convertUboRedirectToAdg = function convertUboRedirectToAdg(rule) {
      var firstPartOfRule = substringBefore(rule, '$');
      var uboModifiers = validator.parseModifiers(rule);
      var uboMarkerData = getMarkerData(uboModifiers, validator.REDIRECT_RULE_TYPES.UBO, rule);
      var adgModifiers = uboModifiers.map(function (modifier, index) {
        if (index === uboMarkerData.index) {
          var uboName = substringAfter$1(modifier, uboMarkerData.marker);
          var adgName = validator.REDIRECT_RULE_TYPES.UBO.compatibility[uboName];
          var adgMarker = uboMarkerData.marker === validator.ADG_UBO_REDIRECT_RULE_MARKER ? validator.REDIRECT_RULE_TYPES.ADG.redirectRuleMarker : validator.REDIRECT_RULE_TYPES.ADG.redirectMarker;
          return "".concat(adgMarker).concat(adgName);
        }

        if (modifier === UBO_XHR_TYPE) {
          return ADG_XHR_TYPE;
        }

        return modifier;
      }).join(COMMA_SEPARATOR);
      return "".concat(firstPartOfRule, "$").concat(adgModifiers);
    };
    /**
     * Converts Abp redirect rule to Adg one
     * @param {string} rule
     * @returns {string}
     */

    var convertAbpRedirectToAdg = function convertAbpRedirectToAdg(rule) {
      var firstPartOfRule = substringBefore(rule, '$');
      var abpModifiers = validator.parseModifiers(rule);
      var adgModifiers = abpModifiers.map(function (modifier) {
        if (modifier.indexOf(validator.REDIRECT_RULE_TYPES.ABP.redirectMarker) > -1) {
          var abpName = substringAfter$1(modifier, validator.REDIRECT_RULE_TYPES.ABP.redirectMarker);
          var adgName = validator.REDIRECT_RULE_TYPES.ABP.compatibility[abpName];
          return "".concat(validator.REDIRECT_RULE_TYPES.ADG.redirectMarker).concat(adgName);
        }

        return modifier;
      }).join(COMMA_SEPARATOR);
      return "".concat(firstPartOfRule, "$").concat(adgModifiers);
    };
    /**
     * Converts redirect rule to AdGuard one
     * @param {string} rule
     * @returns {string}
     */

    var convertRedirectToAdg = function convertRedirectToAdg(rule) {
      var result;

      if (validator.isUboRedirectCompatibleWithAdg(rule)) {
        result = convertUboRedirectToAdg(rule);
      } else if (validator.isAbpRedirectCompatibleWithAdg(rule)) {
        result = convertAbpRedirectToAdg(rule);
      } else if (validator.isValidAdgRedirectRule(rule)) {
        result = rule;
      }

      return result;
    };
    /**
     * Converts Adg redirect rule to Ubo one
     * 1. Checks if there is Ubo analog for Adg rule
     * 2. Parses the rule and checks if there are any source type modifiers which are required by Ubo
     *    and if there are no one we add it manually to the end.
     *    Source types are chosen according to redirect name
     *    e.g. ||ad.com^$redirect=<name>,important  ->>  ||ad.com^$redirect=<name>,important,script
     * 3. Replaces Adg redirect name by Ubo analog
     * @param {string} rule
     * @returns {string}
     */

    var convertAdgRedirectToUbo = function convertAdgRedirectToUbo(rule) {
      if (!validator.isAdgRedirectCompatibleWithUbo(rule)) {
        throw new Error("Unable to convert for uBO - unsupported redirect in rule: ".concat(rule));
      }

      var basePart = substringBefore(rule, '$');
      var adgModifiers = validator.parseModifiers(rule);
      var adgMarkerData = getMarkerData(adgModifiers, validator.REDIRECT_RULE_TYPES.ADG, rule);
      var adgRedirectName = adgModifiers[adgMarkerData.index].slice(adgMarkerData.marker.length);

      if (!validator.hasValidContentType(rule)) {
        // add missed source types as content type modifiers
        var sourceTypesData = validator.ABSENT_SOURCE_TYPE_REPLACEMENT.find(function (el) {
          return el.NAME === adgRedirectName;
        });

        if (typeof sourceTypesData === 'undefined') {
          // eslint-disable-next-line max-len
          throw new Error("Unable to convert for uBO - no types to add for specific redirect in rule: ".concat(rule));
        }

        var additionModifiers = sourceTypesData.TYPES;
        adgModifiers.push.apply(adgModifiers, toConsumableArray(additionModifiers));
      }

      var uboModifiers = adgModifiers.map(function (el, index) {
        if (index === adgMarkerData.index) {
          var uboMarker = adgMarkerData.marker === validator.ADG_UBO_REDIRECT_RULE_MARKER ? validator.REDIRECT_RULE_TYPES.UBO.redirectRuleMarker : validator.REDIRECT_RULE_TYPES.UBO.redirectMarker; // eslint-disable-next-line max-len

          var uboRedirectName = validator.REDIRECT_RULE_TYPES.ADG.compatibility[adgRedirectName];
          return "".concat(uboMarker).concat(uboRedirectName);
        }

        return el;
      }).join(COMMA_SEPARATOR);
      return "".concat(basePart, "$").concat(uboModifiers);
    };

    /**
     * @redirect google-analytics
     *
     * @description
     * Mocks Google's Analytics and Tag Manager APIs.
     * [Covers obsolete googletagmanager-gtm redirect functionality](https://github.com/AdguardTeam/Scriptlets/issues/127).
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/8cd2a1d263a96421487b39040c1d23eb01169484/src/web_accessible_resources/google-analytics_analytics.js
     *
     * **Example**
     * ```
     * ||google-analytics.com/analytics.js$script,redirect=google-analytics
     * ||googletagmanager.com/gtm.js$script,redirect=googletagmanager-gtm
     * ```
     */

    function GoogleAnalytics(source) {
      // eslint-disable-next-line func-names
      var Tracker = function Tracker() {}; // constructor


      var proto = Tracker.prototype;
      proto.get = noopFunc;
      proto.set = noopFunc;
      proto.send = noopFunc;
      var googleAnalyticsName = window.GoogleAnalyticsObject || 'ga'; // a -- fake arg for 'ga.length < 1' antiadblock checking
      // eslint-disable-next-line no-unused-vars

      function ga(a) {
        var len = arguments.length;

        if (len === 0) {
          return;
        } // eslint-disable-next-line prefer-rest-params


        var lastArg = arguments[len - 1];
        var replacer;

        if (lastArg instanceof Object && lastArg !== null && typeof lastArg.hitCallback === 'function') {
          replacer = lastArg.hitCallback;
        } else if (typeof lastArg === 'function') {
          // https://github.com/AdguardTeam/Scriptlets/issues/98
          replacer = function replacer() {
            lastArg(ga.create());
          };
        }

        try {
          setTimeout(replacer, 1); // eslint-disable-next-line no-empty
        } catch (ex) {}
      }

      ga.create = function () {
        return new Tracker();
      }; // https://github.com/AdguardTeam/Scriptlets/issues/134


      ga.getByName = function () {
        return new Tracker();
      };

      ga.getAll = function () {
        return [new Tracker()];
      };

      ga.remove = noopFunc;
      ga.loaded = true;
      window[googleAnalyticsName] = ga;
      var _window = window,
          dataLayer = _window.dataLayer,
          google_optimize = _window.google_optimize; // eslint-disable-line camelcase

      if (dataLayer instanceof Object === false) {
        return;
      }

      if (dataLayer.hide instanceof Object && typeof dataLayer.hide.end === 'function') {
        dataLayer.hide.end();
      }
      /**
       * checks data object and delays callback
       * @param {Object|Array} data gtag payload
       * @param {string} funcName callback prop name
       * @returns
       */


      var handleCallback = function handleCallback(dataObj, funcName) {
        if (dataObj && typeof dataObj[funcName] === 'function') {
          setTimeout(dataObj[funcName]);
        }
      };

      if (typeof dataLayer.push === 'function') {
        dataLayer.push = function (data) {
          if (data instanceof Object) {
            handleCallback(data, 'eventCallback'); // eslint-disable-next-line no-restricted-syntax, guard-for-in

            for (var key in data) {
              handleCallback(data[key], 'event_callback');
            } // eslint-disable-next-line no-prototype-builtins


            if (!data.hasOwnProperty('eventCallback') && !data.hasOwnProperty('eventCallback')) {
              [].push.call(window.dataLayer, data);
            }
          }

          if (Array.isArray(data)) {
            data.forEach(function (arg) {
              handleCallback(arg, 'callback');
            });
          }

          return noopFunc;
        };
      } // https://github.com/AdguardTeam/Scriptlets/issues/81


      if (google_optimize instanceof Object && typeof google_optimize.get === 'function') {
        // eslint-disable-line camelcase
        var googleOptimizeWrapper = {
          get: noopFunc
        };
        window.google_optimize = googleOptimizeWrapper;
      }

      hit(source);
    }
    GoogleAnalytics.names = ['google-analytics', 'ubo-google-analytics_analytics.js', 'google-analytics_analytics.js', // https://github.com/AdguardTeam/Scriptlets/issues/127
    'googletagmanager-gtm', 'ubo-googletagmanager_gtm.js', 'googletagmanager_gtm.js'];
    GoogleAnalytics.injections = [hit, noopFunc, noopNull, noopArray];

    /* eslint-disable no-underscore-dangle */
    /**
     * @redirect google-analytics-ga
     *
     * @description
     * Mocks old Google Analytics API.
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/a94df7f3b27080ae2dcb3b914ace39c0c294d2f6/src/web_accessible_resources/google-analytics_ga.js
     *
     * **Example**
     * ```
     * ||google-analytics.com/ga.js$script,redirect=google-analytics-ga
     * ```
     */

    function GoogleAnalyticsGa(source) {
      // Gaq constructor
      function Gaq() {}

      Gaq.prototype.Na = noopFunc;
      Gaq.prototype.O = noopFunc;
      Gaq.prototype.Sa = noopFunc;
      Gaq.prototype.Ta = noopFunc;
      Gaq.prototype.Va = noopFunc;
      Gaq.prototype._createAsyncTracker = noopFunc;
      Gaq.prototype._getAsyncTracker = noopFunc;
      Gaq.prototype._getPlugin = noopFunc;

      Gaq.prototype.push = function (data) {
        if (typeof data === 'function') {
          data();
          return;
        }

        if (Array.isArray(data) === false) {
          return;
        } // https://developers.google.com/analytics/devguides/collection/gajs/methods/gaJSApiDomainDirectory#_gat.GA_Tracker_._link
        // https://github.com/uBlockOrigin/uBlock-issues/issues/1807


        if (typeof data[0] === 'string' && /(^|\.)_link$/.test(data[0]) && typeof data[1] === 'string') {
          window.location.assign(data[1]);
        } // https://github.com/gorhill/uBlock/issues/2162


        if (data[0] === '_set' && data[1] === 'hitCallback' && typeof data[2] === 'function') {
          data[2]();
        }
      };

      var gaq = new Gaq();
      var asyncTrackers = window._gaq || [];

      if (Array.isArray(asyncTrackers)) {
        while (asyncTrackers[0]) {
          gaq.push(asyncTrackers.shift());
        }
      } // eslint-disable-next-line no-multi-assign


      window._gaq = gaq.qf = gaq; // Gat constructor

      function Gat() {} // Mock tracker api


      var api = ['_addIgnoredOrganic', '_addIgnoredRef', '_addItem', '_addOrganic', '_addTrans', '_clearIgnoredOrganic', '_clearIgnoredRef', '_clearOrganic', '_cookiePathCopy', '_deleteCustomVar', '_getName', '_setAccount', '_getAccount', '_getClientInfo', '_getDetectFlash', '_getDetectTitle', '_getLinkerUrl', '_getLocalGifPath', '_getServiceMode', '_getVersion', '_getVisitorCustomVar', '_initData', '_link', '_linkByPost', '_setAllowAnchor', '_setAllowHash', '_setAllowLinker', '_setCampContentKey', '_setCampMediumKey', '_setCampNameKey', '_setCampNOKey', '_setCampSourceKey', '_setCampTermKey', '_setCampaignCookieTimeout', '_setCampaignTrack', '_setClientInfo', '_setCookiePath', '_setCookiePersistence', '_setCookieTimeout', '_setCustomVar', '_setDetectFlash', '_setDetectTitle', '_setDomainName', '_setLocalGifPath', '_setLocalRemoteServerMode', '_setLocalServerMode', '_setReferrerOverride', '_setRemoteServerMode', '_setSampleRate', '_setSessionTimeout', '_setSiteSpeedSampleRate', '_setSessionCookieTimeout', '_setVar', '_setVisitorCookieTimeout', '_trackEvent', '_trackPageLoadTime', '_trackPageview', '_trackSocial', '_trackTiming', '_trackTrans', '_visitCode'];
      var tracker = api.reduce(function (res, funcName) {
        res[funcName] = noopFunc;
        return res;
      }, {});

      tracker._getLinkerUrl = function (a) {
        return a;
      }; // https://github.com/AdguardTeam/Scriptlets/issues/154


      tracker._link = function (url) {
        if (typeof url !== 'string') {
          return;
        }

        try {
          window.location.assign(url);
        } catch (e) {
          // log the error only while debugging
          if (source.verbose) {
            // eslint-disable-next-line no-console
            console.log(e);
          }
        }
      };

      Gat.prototype._anonymizeIP = noopFunc;
      Gat.prototype._createTracker = noopFunc;
      Gat.prototype._forceSSL = noopFunc;
      Gat.prototype._getPlugin = noopFunc;

      Gat.prototype._getTracker = function () {
        return tracker;
      };

      Gat.prototype._getTrackerByName = function () {
        return tracker;
      };

      Gat.prototype._getTrackers = noopFunc;
      Gat.prototype.aa = noopFunc;
      Gat.prototype.ab = noopFunc;
      Gat.prototype.hb = noopFunc;
      Gat.prototype.la = noopFunc;
      Gat.prototype.oa = noopFunc;
      Gat.prototype.pa = noopFunc;
      Gat.prototype.u = noopFunc;
      var gat = new Gat();
      window._gat = gat;
      hit(source);
    }
    GoogleAnalyticsGa.names = ['google-analytics-ga', 'ubo-google-analytics_ga.js', 'google-analytics_ga.js'];
    GoogleAnalyticsGa.injections = [hit, noopFunc];

    /* eslint-disable max-len */

    /**
     * @redirect googlesyndication-adsbygoogle
     *
     * @description
     * Mocks Google AdSense API.
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/a94df7f3b27080ae2dcb3b914ace39c0c294d2f6/src/web_accessible_resources/googlesyndication_adsbygoogle.js
     *
     * **Example**
     * ```
     * ||pagead2.googlesyndication.com/pagead/js/adsbygoogle.js$script,redirect=googlesyndication-adsbygoogle
     * ```
     */

    /* eslint-enable max-len */

    function GoogleSyndicationAdsByGoogle(source) {
      window.adsbygoogle = {
        // https://github.com/AdguardTeam/Scriptlets/issues/113
        // length: 0,
        loaded: true,
        // https://github.com/AdguardTeam/Scriptlets/issues/184
        push: function push(arg) {
          if (typeof this.length === 'undefined') {
            this.length = 0;
            this.length += 1;
          }

          if (arg !== null && arg instanceof Object && arg.constructor.name === 'Object') {
            // eslint-disable-next-line no-restricted-syntax
            for (var _i = 0, _Object$keys = Object.keys(arg); _i < _Object$keys.length; _i++) {
              var key = _Object$keys[_i];

              if (typeof arg[key] === 'function') {
                try {
                  arg[key].call();
                } catch (_unused) {
                  /* empty */
                }
              }
            }
          }
        }
      };
      var adElems = document.querySelectorAll('.adsbygoogle');
      var css = 'height:1px!important;max-height:1px!important;max-width:1px!important;width:1px!important;';
      var statusAttrName = 'data-adsbygoogle-status';
      var ASWIFT_IFRAME_MARKER = 'aswift_';
      var GOOGLE_ADS_IFRAME_MARKER = 'google_ads_iframe_';
      var executed = false;

      for (var i = 0; i < adElems.length; i += 1) {
        var adElemChildNodes = adElems[i].childNodes;
        var childNodesQuantity = adElemChildNodes.length; // childNodes of .adsbygoogle can be defined if scriptlet was executed before
        // so we should check that childNodes are exactly defined by us
        // TODO: remake after scriptlets context developing in 1.3

        var areIframesDefined = false;

        if (childNodesQuantity > 0) {
          // it should be only 2 child iframes if scriptlet was executed
          areIframesDefined = childNodesQuantity === 2 // the first of child nodes should be aswift iframe
          && adElemChildNodes[0].nodeName.toLowerCase() === 'iframe' && adElemChildNodes[0].id.indexOf(ASWIFT_IFRAME_MARKER) > -1 // the second of child nodes should be google_ads iframe
          && adElemChildNodes[1].nodeName.toLowerCase() === 'iframe' && adElemChildNodes[1].id.indexOf(GOOGLE_ADS_IFRAME_MARKER) > -1;
        }

        if (!areIframesDefined) {
          // here we do the job if scriptlet has not been executed earlier
          adElems[i].setAttribute(statusAttrName, 'done');
          var aswiftIframe = document.createElement('iframe');
          aswiftIframe.id = "".concat(ASWIFT_IFRAME_MARKER).concat(i);
          aswiftIframe.style = css;
          adElems[i].appendChild(aswiftIframe);
          var innerAswiftIframe = document.createElement('iframe');
          aswiftIframe.contentWindow.document.body.appendChild(innerAswiftIframe);
          var googleadsIframe = document.createElement('iframe');
          googleadsIframe.id = "".concat(GOOGLE_ADS_IFRAME_MARKER).concat(i);
          googleadsIframe.style = css;
          adElems[i].appendChild(googleadsIframe);
          var innerGoogleadsIframe = document.createElement('iframe');
          googleadsIframe.contentWindow.document.body.appendChild(innerGoogleadsIframe);
          executed = true;
        }
      }

      if (executed) {
        hit(source);
      }
    }
    GoogleSyndicationAdsByGoogle.names = ['googlesyndication-adsbygoogle', 'ubo-googlesyndication_adsbygoogle.js', 'googlesyndication_adsbygoogle.js'];
    GoogleSyndicationAdsByGoogle.injections = [hit];

    /* eslint-disable func-names */
    /**
     * @redirect googletagservices-gpt
     *
     * @description
     * Mocks Google Publisher Tag API.
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/a94df7f3b27080ae2dcb3b914ace39c0c294d2f6/src/web_accessible_resources/googletagservices_gpt.js
     *
     * **Example**
     * ```
     * ||googletagservices.com/tag/js/gpt.js$script,redirect=googletagservices-gpt
     * ```
     */

    function GoogleTagServicesGpt(source) {
      var slots = new Map();
      var slotsById = new Map();
      var eventCallbacks = new Map();

      var addEventListener = function addEventListener(name, listener) {
        if (!eventCallbacks.has(name)) {
          eventCallbacks.set(name, new Set());
        }

        eventCallbacks.get(name).add(listener);
        return this;
      };

      var removeEventListener = function removeEventListener(name, listener) {
        if (eventCallbacks.has(name)) {
          return eventCallbacks.get(name).delete(listener);
        }

        return false;
      };

      var fireSlotEvent = function fireSlotEvent(name, slot) {
        // eslint-disable-next-line compat/compat
        return new Promise(function (resolve) {
          requestAnimationFrame(function () {
            var size = [0, 0];
            var callbacksSet = eventCallbacks.get(name) || [];
            var callbackArray = Array.from(callbacksSet);

            for (var i = 0; i < callbackArray.length; i += 1) {
              callbackArray[i]({
                isEmpty: true,
                size: size,
                slot: slot
              });
            }

            resolve();
          });
        });
      };

      var displaySlot = function displaySlot(slot) {
        if (!slot) {
          return;
        }

        var id = slot.getSlotElementId();

        if (!document.getElementById(id)) {
          return;
        }

        var parent = document.getElementById(id);

        if (parent) {
          parent.appendChild(document.createElement('div'));
        }

        fireSlotEvent('slotRenderEnded', slot);
        fireSlotEvent('slotRequested', slot);
        fireSlotEvent('slotResponseReceived', slot);
        fireSlotEvent('slotOnload', slot);
        fireSlotEvent('impressionViewable', slot);
      };

      var companionAdsService = {
        addEventListener: addEventListener,
        removeEventListener: removeEventListener,
        enableSyncLoading: noopFunc,
        setRefreshUnfilledSlots: noopFunc,
        getSlots: noopArray
      };
      var contentService = {
        addEventListener: addEventListener,
        removeEventListener: removeEventListener,
        setContent: noopFunc
      };

      function PassbackSlot() {} // constructor


      PassbackSlot.prototype.display = noopFunc;
      PassbackSlot.prototype.get = noopNull;
      PassbackSlot.prototype.set = noopThis;
      PassbackSlot.prototype.setClickUrl = noopThis;
      PassbackSlot.prototype.setTagForChildDirectedTreatment = noopThis;
      PassbackSlot.prototype.setTargeting = noopThis;
      PassbackSlot.prototype.updateTargetingFromMap = noopThis;

      function SizeMappingBuilder() {} // constructor


      SizeMappingBuilder.prototype.addSize = noopThis;
      SizeMappingBuilder.prototype.build = noopNull;

      function Slot(adUnitPath, creatives, optDiv) {
        this.adUnitPath = adUnitPath;
        this.creatives = creatives;
        this.optDiv = optDiv;

        if (slotsById.has(optDiv)) {
          var _document$getElementB;

          (_document$getElementB = document.getElementById(optDiv)) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.remove();
          return slotsById.get(optDiv);
        }

        slotsById.set(optDiv, this);
      } // constructor


      Slot.prototype.addService = noopThis;
      Slot.prototype.clearCategoryExclusions = noopThis;
      Slot.prototype.clearTargeting = noopThis;
      Slot.prototype.defineSizeMapping = noopThis;
      Slot.prototype.get = noopNull;

      Slot.prototype.getAdUnitPath = function () {
        return this.adUnitPath;
      };

      Slot.prototype.getAttributeKeys = noopArray;
      Slot.prototype.getCategoryExclusions = noopArray;

      Slot.prototype.getDomId = function () {
        return this.optDiv;
      };

      Slot.prototype.getSlotElementId = function () {
        return this.optDiv;
      };

      Slot.prototype.getSlotId = noopThis;
      Slot.prototype.getSizes = noopArray;
      Slot.prototype.getTargeting = noopArray;
      Slot.prototype.getTargetingKeys = noopArray;
      Slot.prototype.set = noopThis;
      Slot.prototype.setCategoryExclusion = noopThis;
      Slot.prototype.setClickUrl = noopThis;
      Slot.prototype.setCollapseEmptyDiv = noopThis;
      Slot.prototype.setTargeting = noopThis;
      var pubAdsService = {
        addEventListener: addEventListener,
        removeEventListener: removeEventListener,
        clear: noopFunc,
        clearCategoryExclusions: noopThis,
        clearTagForChildDirectedTreatment: noopThis,
        clearTargeting: noopThis,
        collapseEmptyDivs: noopFunc,
        defineOutOfPagePassback: function defineOutOfPagePassback() {
          return new PassbackSlot();
        },
        definePassback: function definePassback() {
          return new PassbackSlot();
        },
        disableInitialLoad: noopFunc,
        display: noopFunc,
        enableAsyncRendering: noopFunc,
        enableLazyLoad: noopFunc,
        enableSingleRequest: noopFunc,
        enableSyncRendering: noopFunc,
        enableVideoAds: noopFunc,
        get: noopNull,
        getAttributeKeys: noopArray,
        getTargeting: noopArray,
        getTargetingKeys: noopArray,
        getSlots: noopArray,
        isInitialLoadDisabled: trueFunc,
        refresh: noopFunc,
        set: noopThis,
        setCategoryExclusion: noopThis,
        setCentering: noopFunc,
        setCookieOptions: noopThis,
        setForceSafeFrame: noopThis,
        setLocation: noopThis,
        setPublisherProvidedId: noopThis,
        setRequestNonPersonalizedAds: noopThis,
        setSafeFrameConfig: noopThis,
        setTagForChildDirectedTreatment: noopThis,
        setTargeting: noopThis,
        setVideoContent: noopThis,
        updateCorrelator: noopFunc
      };

      var getNewSlot = function getNewSlot(adUnitPath, creatives, optDiv) {
        return new Slot(adUnitPath, creatives, optDiv);
      };

      var _window = window,
          _window$googletag = _window.googletag,
          googletag = _window$googletag === void 0 ? {} : _window$googletag;
      var _googletag$cmd = googletag.cmd,
          cmd = _googletag$cmd === void 0 ? [] : _googletag$cmd;
      googletag.apiReady = true;
      googletag.cmd = [];

      googletag.cmd.push = function (a) {
        try {
          a(); // eslint-disable-next-line no-empty
        } catch (ex) {}

        return 1;
      };

      googletag.companionAds = function () {
        return companionAdsService;
      };

      googletag.content = function () {
        return contentService;
      };

      googletag.defineOutOfPageSlot = getNewSlot;
      googletag.defineSlot = getNewSlot;

      googletag.destroySlots = function () {
        slots.clear();
        slotsById.clear();
      };

      googletag.disablePublisherConsole = noopFunc;

      googletag.display = function (arg) {
        var id;

        if (arg !== null && arg !== void 0 && arg.getSlotElementId) {
          id = arg.getSlotElementId();
        } else if (arg !== null && arg !== void 0 && arg.nodeType) {
          id = arg.id;
        } else {
          id = String(arg);
        }

        displaySlot(slotsById.get(id));
      };

      googletag.enableServices = noopFunc;
      googletag.getVersion = noopStr;

      googletag.pubads = function () {
        return pubAdsService;
      };

      googletag.pubadsReady = true;
      googletag.setAdIframeTitle = noopFunc;

      googletag.sizeMapping = function () {
        return new SizeMappingBuilder();
      };

      window.googletag = googletag;

      while (cmd.length !== 0) {
        googletag.cmd.push(cmd.shift());
      }

      hit(source);
    }
    GoogleTagServicesGpt.names = ['googletagservices-gpt', 'ubo-googletagservices_gpt.js', 'googletagservices_gpt.js'];
    GoogleTagServicesGpt.injections = [hit, noopFunc, noopThis, noopNull, noopArray, noopStr, trueFunc];

    /**
     * @redirect scorecardresearch-beacon
     *
     * @description
     * Mocks Scorecard Research API.
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/a94df7f3b27080ae2dcb3b914ace39c0c294d2f6/src/web_accessible_resources/scorecardresearch_beacon.js
     *
     * **Example**
     * ```
     * ||sb.scorecardresearch.com/beacon.js$script,redirect=scorecardresearch-beacon
     * ```
     */

    function ScoreCardResearchBeacon(source) {
      window.COMSCORE = {
        purge: function purge() {
          // eslint-disable-next-line no-underscore-dangle
          window._comscore = [];
        },
        beacon: function beacon() {}
      };
      hit(source);
    }
    ScoreCardResearchBeacon.names = ['scorecardresearch-beacon', 'ubo-scorecardresearch_beacon.js', 'scorecardresearch_beacon.js'];
    ScoreCardResearchBeacon.injections = [hit];

    /**
     * @redirect metrika-yandex-tag
     *
     * @description
     * Mocks Yandex Metrika API.
     * https://yandex.ru/support/metrica/objects/method-reference.html
     *
     * **Example**
     * ```
     * ||mc.yandex.ru/metrika/tag.js$script,redirect=metrika-yandex-tag
     * ```
     */

    function metrikaYandexTag(source) {
      var asyncCallbackFromOptions = function asyncCallbackFromOptions(id, param) {
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var callback = options.callback;
        var ctx = options.ctx;

        if (typeof callback === 'function') {
          callback = ctx !== undefined ? callback.bind(ctx) : callback;
          setTimeout(function () {
            return callback();
          });
        }
      };
      /**
       * https://yandex.ru/support/metrica/objects/addfileextension.html
       */


      var addFileExtension = noopFunc;
      /**
       * https://yandex.ru/support/metrica/objects/extlink.html
       */

      var extLink = asyncCallbackFromOptions;
      /**
       * https://yandex.ru/support/metrica/objects/file.html
       */

      var file = asyncCallbackFromOptions;
      /**
       * https://yandex.ru/support/metrica/objects/get-client-id.html
       * @param {Function} cb
       */

      var getClientID = function getClientID(id, cb) {
        if (!cb) {
          return;
        }

        setTimeout(cb(null));
      };
      /**
       * https://yandex.ru/support/metrica/objects/hit.html
       */


      var hitFunc = asyncCallbackFromOptions;
      /**
       * https://yandex.ru/support/metrica/objects/notbounce.html
       */

      var notBounce = asyncCallbackFromOptions;
      /**
       * https://yandex.ru/support/metrica/objects/params-method.html
       */

      var params = noopFunc;
      /**
       * https://yandex.ru/support/metrica/objects/reachgoal.html
       * @param {string} target
       * @param {Object} params
       * @param {Function} callback
       * @param {any} ctx
       */

      var reachGoal = function reachGoal(id, target, params, callback, ctx) {
        asyncCallbackFromOptions(null, null, {
          callback: callback,
          ctx: ctx
        });
      };
      /**
       * https://yandex.ru/support/metrica/objects/set-user-id.html
       */


      var setUserID = noopFunc;
      /**
       * https://yandex.ru/support/metrica/objects/user-params.html
       */

      var userParams = noopFunc; // https://github.com/AdguardTeam/Scriptlets/issues/198

      var destruct = noopFunc;
      var api = {
        addFileExtension: addFileExtension,
        extLink: extLink,
        file: file,
        getClientID: getClientID,
        hit: hitFunc,
        notBounce: notBounce,
        params: params,
        reachGoal: reachGoal,
        setUserID: setUserID,
        userParams: userParams,
        destruct: destruct
      };

      function ym(id, funcName) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        return api[funcName] && api[funcName].apply(api, [id].concat(args));
      }

      ym.a = [];

      function init(id) {
        // yaCounter object should provide api
        window["yaCounter".concat(id)] = api;
        document.dispatchEvent(new Event("yacounter".concat(id, "inited")));
      }

      if (typeof window.ym === 'undefined') {
        window.ym = ym;
      } else if (window.ym && window.ym.a) {
        // Get id for yaCounter object
        var counters = window.ym.a;
        window.ym = ym;
        counters.forEach(function (params) {
          var id = params[0];
          init(id);
        });
      }

      hit(source);
    }
    metrikaYandexTag.names = ['metrika-yandex-tag'];
    metrikaYandexTag.injections = [hit, noopFunc];

    /**
     * @redirect metrika-yandex-watch
     *
     * @description
     * Mocks the old Yandex Metrika API.
     * https://yandex.ru/support/metrica/objects/_method-reference.html
     *
     * **Example**
     * ```
     * ||mc.yandex.ru/metrika/watch.js$script,redirect=metrika-yandex-watch
     * ```
     */

    function metrikaYandexWatch(source) {
      var cbName = 'yandex_metrika_callbacks';
      /**
       * Gets callback and its context from options and call it in async way
       * @param {Object} options Yandex Metrika API options
       */

      var asyncCallbackFromOptions = function asyncCallbackFromOptions() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var callback = options.callback;
        var ctx = options.ctx;

        if (typeof callback === 'function') {
          callback = ctx !== undefined ? callback.bind(ctx) : callback;
          setTimeout(function () {
            return callback();
          });
        }
      };

      function Metrika() {} // constructor


      Metrika.counters = noopArray; // Methods without options

      Metrika.prototype.addFileExtension = noopFunc;
      Metrika.prototype.getClientID = noopFunc;
      Metrika.prototype.setUserID = noopFunc;
      Metrika.prototype.userParams = noopFunc;
      Metrika.prototype.params = noopFunc;
      Metrika.prototype.counters = noopArray; // Methods with options
      // The order of arguments should be kept in according to API

      Metrika.prototype.extLink = function (url, options) {
        asyncCallbackFromOptions(options);
      };

      Metrika.prototype.file = function (url, options) {
        asyncCallbackFromOptions(options);
      };

      Metrika.prototype.hit = function (url, options) {
        asyncCallbackFromOptions(options);
      };

      Metrika.prototype.reachGoal = function (target, params, cb, ctx) {
        asyncCallbackFromOptions({
          callback: cb,
          ctx: ctx
        });
      };

      Metrika.prototype.notBounce = asyncCallbackFromOptions;

      if (window.Ya) {
        window.Ya.Metrika = Metrika;
      } else {
        window.Ya = {
          Metrika: Metrika
        };
      }

      if (window[cbName] && Array.isArray(window[cbName])) {
        window[cbName].forEach(function (func) {
          if (typeof func === 'function') {
            func();
          }
        });
      }

      hit(source);
    }
    metrikaYandexWatch.names = ['metrika-yandex-watch'];
    metrikaYandexWatch.injections = [hit, noopFunc, noopArray];

    /* eslint-disable func-names */
    /**
     * @redirect pardot-1.0
     *
     * @description
     * Mocks the pd.js file of Salesforce
     * https://pi.pardot.com/pd.js
     * https://developer.salesforce.com/docs/marketing/pardot/overview
     * **Example**
     * ```
     * ||pi.pardot.com/pd.js$script,redirect=pardot
     * ||pacedg.com.au/pd.js$redirect=pardot
     * ```
     */

    function Pardot(source) {
      window.piVersion = '1.0.2';
      window.piScriptNum = 0;
      window.piScriptObj = [];
      window.checkNamespace = noopFunc;
      window.getPardotUrl = noopStr;
      window.piGetParameter = noopNull;
      window.piSetCookie = noopFunc;
      window.piGetCookie = noopStr;

      function piTracker() {
        window.pi = {
          tracker: {
            visitor_id: '',
            visitor_id_sign: '',
            pi_opt_in: '',
            campaign_id: ''
          }
        };
        window.piScriptNum += 1;
      }

      window.piResponse = noopFunc;
      window.piTracker = piTracker;
      piTracker();
      hit(source);
    }
    Pardot.names = ['pardot-1.0'];
    Pardot.injections = [hit, noopFunc, noopStr, noopNull];

    /**
     * @redirect amazon-apstag
     *
     * @description
     * Mocks Amazon's apstag.js
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/f842ab6d3c1cf0394f95d27092bf59627262da40/src/web_accessible_resources/amazon_apstag.js
     *
     * **Example**
     * ```
     * ||amazon-adsystem.com/aax2/apstag.js$script,redirect=amazon-apstag
     * ```
     */

    function AmazonApstag(source) {
      var apstagWrapper = {
        fetchBids: function fetchBids(a, b) {
          if (typeof b === 'function') {
            b([]);
          }
        },
        init: noopFunc,
        setDisplayBids: noopFunc,
        targetingKeys: noopFunc
      };
      window.apstag = apstagWrapper;
      hit(source);
    }
    AmazonApstag.names = ['amazon-apstag', 'ubo-amazon_apstag.js', 'amazon_apstag.js'];
    AmazonApstag.injections = [hit, noopFunc];

    /* eslint-disable func-names */
    /**
     * @redirect matomo
     *
     * @description
     * Mocks the piwik.js file of Matomo (formerly Piwik).
     *
     * **Example**
     * ```
     * ||example.org/piwik.js$script,redirect=matomo
     * ```
     */

    function Matomo(source) {
      var Tracker = function Tracker() {};

      Tracker.prototype.setDoNotTrack = noopFunc;
      Tracker.prototype.setDomains = noopFunc;
      Tracker.prototype.setCustomDimension = noopFunc;
      Tracker.prototype.trackPageView = noopFunc;

      var AsyncTracker = function AsyncTracker() {};

      AsyncTracker.prototype.addListener = noopFunc;
      var matomoWrapper = {
        getTracker: function getTracker() {
          return new Tracker();
        },
        getAsyncTracker: function getAsyncTracker() {
          return new AsyncTracker();
        }
      };
      window.Piwik = matomoWrapper;
      hit(source);
    }
    Matomo.names = ['matomo'];
    Matomo.injections = [hit, noopFunc];

    /* eslint-disable func-names */
    /**
     * @redirect fingerprintjs2
     *
     * @description
     * Mocks FingerprintJS v2
     * https://github.com/fingerprintjs
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/master/src/web_accessible_resources/fingerprint2.js
     *
     * **Example**
     * ```
     * ||the-japan-news.com/modules/js/lib/fgp/fingerprint2.js$script,redirect=fingerprintjs2
     * ```
     */

    function Fingerprintjs2(source) {
      var browserId = '';

      for (var i = 0; i < 8; i += 1) {
        browserId += (Math.random() * 0x10000 + 0x1000).toString(16).slice(-4);
      }

      var Fingerprint2 = function Fingerprint2() {};

      Fingerprint2.get = function (options, callback) {
        if (!callback) {
          callback = options;
        }

        setTimeout(function () {
          if (callback) {
            callback(browserId, []);
          }
        }, 1);
      };

      Fingerprint2.prototype = {
        get: Fingerprint2.get
      };
      window.Fingerprint2 = Fingerprint2;
      hit(source);
    }
    Fingerprintjs2.names = ['fingerprintjs2', // redirect aliases are needed for conversion:
    // prefixed for us
    'ubo-fingerprint2.js', // original ubo name
    'fingerprint2.js'];
    Fingerprintjs2.injections = [hit];

    /* eslint-disable func-names */
    /**
     * @redirect fingerprintjs3
     *
     * @description
     * Mocks FingerprintJS v3
     * https://github.com/fingerprintjs
     *
     * Related UBO redirect resource:
     * https://github.com/gorhill/uBlock/blob/master/src/web_accessible_resources/fingerprint3.js
     *
     * **Example**
     * ```
     * ||sephora.com/js/ufe/isomorphic/thirdparty/fp.min.js$script,redirect=fingerprintjs3
     * ```
     */

    function Fingerprintjs3(source) {
      var visitorId = function () {
        var id = '';

        for (var i = 0; i < 8; i += 1) {
          id += (Math.random() * 0x10000 + 0x1000).toString(16).slice(-4);
        }

        return id;
      }();

      var FingerprintJS = function FingerprintJS() {};

      FingerprintJS.prototype = {
        load: function load() {
          // eslint-disable-next-line compat/compat
          return Promise.resolve(new FingerprintJS());
        },
        get: function get() {
          // eslint-disable-next-line compat/compat
          return Promise.resolve({
            visitorId: visitorId
          });
        },
        hashComponents: noopStr
      };
      window.FingerprintJS = new FingerprintJS();
      hit(source);
    }
    Fingerprintjs3.names = ['fingerprintjs3', // redirect aliases are needed for conversion:
    // prefixed for us
    'ubo-fingerprint3.js', // original ubo name
    'fingerprint3.js'];
    Fingerprintjs3.injections = [hit, noopStr];

    /* eslint-disable func-names */
    /**
     * @redirect gemius
     *
     * @description
     * Mocks Gemius Analytics.
     * https://flowplayer.com/developers/plugins/gemius
     *
     * **Example**
     * ```
     * ||gapt.hit.gemius.pl/gplayer.js$script,redirect=gemius
     * ```
     */

    function Gemius(source) {
      var GemiusPlayer = function GemiusPlayer() {};

      GemiusPlayer.prototype = {
        setVideoObject: noopFunc,
        newProgram: noopFunc,
        programEvent: noopFunc,
        newAd: noopFunc,
        adEvent: noopFunc
      };
      window.GemiusPlayer = GemiusPlayer;
      hit(source);
    }
    Gemius.names = ['gemius'];
    Gemius.injections = [hit, noopFunc];

    /**
     * @redirect ati-smarttag
     *
     * @description
     * Mocks AT Internat SmartTag.
     * https://developers.atinternet-solutions.com/as2-tagging-en/javascript-en/getting-started-javascript-en/tracker-initialisation-javascript-en/
     *
     * **Example**
     * ```
     * ||bloctel.gouv.fr/assets/scripts/smarttag.js$script,redirect=ati-smarttag
     * ```
     */

    function ATInternetSmartTag(source) {
      var setNoopFuncWrapper = {
        set: noopFunc
      };
      var sendNoopFuncWrapper = {
        send: noopFunc
      };
      var ecommerceWrapper = {
        displayCart: {
          products: setNoopFuncWrapper,
          cart: setNoopFuncWrapper
        },
        updateCart: {
          cart: setNoopFuncWrapper
        },
        displayProduct: {
          products: setNoopFuncWrapper
        },
        displayPageProduct: {
          products: setNoopFuncWrapper
        },
        addProduct: {
          products: setNoopFuncWrapper
        },
        removeProduct: {
          products: setNoopFuncWrapper
        }
      }; // eslint-disable-next-line new-cap, func-names

      var tag = function tag() {};

      tag.prototype = {
        setConfig: noopFunc,
        setParam: noopFunc,
        dispatch: noopFunc,
        customVars: setNoopFuncWrapper,
        publisher: setNoopFuncWrapper,
        order: setNoopFuncWrapper,
        click: sendNoopFuncWrapper,
        clickListener: sendNoopFuncWrapper,
        internalSearch: {
          set: noopFunc,
          send: noopFunc
        },
        ecommerce: ecommerceWrapper,
        identifiedVisitor: {
          unset: noopFunc
        },
        page: {
          set: noopFunc,
          send: noopFunc
        },
        selfPromotion: {
          add: noopFunc,
          send: noopFunc
        },
        privacy: {
          setVisitorMode: noopFunc,
          getVisitorMode: noopFunc,
          hit: noopFunc
        },
        richMedia: {
          add: noopFunc,
          send: noopFunc,
          remove: noopFunc,
          removeAll: noopFunc
        }
      };
      var smartTagWrapper = {
        Tracker: {
          Tag: function Tag() {
            return new tag(); // eslint-disable-line new-cap
          }
        }
      };
      window.ATInternet = smartTagWrapper;
      hit(source);
    }
    ATInternetSmartTag.names = ['ati-smarttag'];
    ATInternetSmartTag.injections = [hit, noopFunc];

    /* eslint-disable consistent-return, no-eval */
    /**
     * @redirect prevent-bab2
     *
     * @description
     * Prevents BlockAdblock script from detecting an ad blocker.
     *
     * Related UBO redirect:
     * https://github.com/gorhill/uBlock/blob/master/src/web_accessible_resources/nobab2.js
     *
     * See [redirect description](../wiki/about-redirects.md#prevent-bab2).
     *
     * **Syntax**
     * ```
     * /blockadblock.$script,redirect=prevent-bab2
     * ```
     */

    function preventBab2(source) {
      // eslint-disable-next-line compat/compat
      var script = document.currentScript;

      if (script === null) {
        return;
      }

      var url = script.src;

      if (typeof url !== 'string') {
        return;
      }

      var domainsStr = ['adclixx\\.net', 'adnetasia\\.com', 'adtrackers\\.net', 'bannertrack\\.net'].join('|');
      var matchStr = "^https?://[\\w-]+\\.(".concat(domainsStr, ")/.");
      var domainsRegex = new RegExp(matchStr);

      if (domainsRegex.test(url) === false) {
        return;
      }

      window.nH7eXzOsG = 858;
      hit(source);
    }
    preventBab2.names = ['prevent-bab2', // aliases are needed for matching the related scriptlet converted into our syntax
    'nobab2.js'];
    preventBab2.injections = [hit];

    /* eslint-disable func-names, no-underscore-dangle */
    /**
     * @redirect google-ima3
     *
     * @description
     * Mocks the IMA SDK of Google.
     *
     * **Example**
     * ```
     * ||imasdk.googleapis.com/js/sdkloader/ima3.js$script,redirect=google-ima3
     * ```
     */

    function GoogleIma3(source) {
      var VERSION = '3.453.0';
      var ima = {};

      var AdDisplayContainer = function AdDisplayContainer() {};

      AdDisplayContainer.prototype.destroy = noopFunc;
      AdDisplayContainer.prototype.initialize = noopFunc;

      var ImaSdkSettings = function ImaSdkSettings() {};

      ImaSdkSettings.CompanionBackfillMode = {
        ALWAYS: 'always',
        ON_MASTER_AD: 'on_master_ad'
      };
      ImaSdkSettings.VpaidMode = {
        DISABLED: 0,
        ENABLED: 1,
        INSECURE: 2
      };
      ImaSdkSettings.prototype = {
        c: true,
        f: {},
        i: false,
        l: '',
        p: '',
        r: 0,
        t: '',
        v: '',
        getCompanionBackfill: noopFunc,
        getDisableCustomPlaybackForIOS10Plus: function getDisableCustomPlaybackForIOS10Plus() {
          return this.i;
        },
        getDisabledFlashAds: function getDisabledFlashAds() {
          return true;
        },
        getFeatureFlags: function getFeatureFlags() {
          return this.f;
        },
        getLocale: function getLocale() {
          return this.l;
        },
        getNumRedirects: function getNumRedirects() {
          return this.r;
        },
        getPlayerType: function getPlayerType() {
          return this.t;
        },
        getPlayerVersion: function getPlayerVersion() {
          return this.v;
        },
        getPpid: function getPpid() {
          return this.p;
        },
        getVpaidMode: function getVpaidMode() {
          return this.C;
        },
        isCookiesEnabled: function isCookiesEnabled() {
          return this.c;
        },
        isVpaidAdapter: function isVpaidAdapter() {
          return this.M;
        },
        setCompanionBackfill: noopFunc,
        setAutoPlayAdBreaks: function setAutoPlayAdBreaks(a) {
          this.K = a;
        },
        setCookiesEnabled: function setCookiesEnabled(c) {
          this.c = !!c;
        },
        setDisableCustomPlaybackForIOS10Plus: function setDisableCustomPlaybackForIOS10Plus(i) {
          this.i = !!i;
        },
        setDisableFlashAds: noopFunc,
        setFeatureFlags: function setFeatureFlags(f) {
          this.f = !!f;
        },
        setIsVpaidAdapter: function setIsVpaidAdapter(a) {
          this.M = a;
        },
        setLocale: function setLocale(l) {
          this.l = !!l;
        },
        setNumRedirects: function setNumRedirects(r) {
          this.r = !!r;
        },
        setPageCorrelator: function setPageCorrelator(a) {
          this.R = a;
        },
        setPlayerType: function setPlayerType(t) {
          this.t = !!t;
        },
        setPlayerVersion: function setPlayerVersion(v) {
          this.v = !!v;
        },
        setPpid: function setPpid(p) {
          this.p = !!p;
        },
        setVpaidMode: function setVpaidMode(a) {
          this.C = a;
        },
        setSessionId: noopFunc,
        setStreamCorrelator: noopFunc,
        setVpaidAllowed: noopFunc,
        CompanionBackfillMode: {
          ALWAYS: 'always',
          ON_MASTER_AD: 'on_master_ad'
        },
        VpaidMode: {
          DISABLED: 0,
          ENABLED: 1,
          INSECURE: 2
        }
      };
      var managerLoaded = false;

      var EventHandler = function EventHandler() {
        this.listeners = new Map();

        this._dispatch = function (e) {
          var listeners = this.listeners.get(e.type) || []; // eslint-disable-next-line no-restricted-syntax

          for (var _i = 0, _Array$from = Array.from(listeners); _i < _Array$from.length; _i++) {
            var listener = _Array$from[_i];

            try {
              listener(e);
            } catch (r) {
              // eslint-disable-next-line no-console
              console.error(r);
            }
          }
        };

        this.addEventListener = function (t, c) {
          if (!this.listeners.has(t)) {
            this.listeners.set(t, new Set());
          }

          this.listeners.get(t).add(c);
        };

        this.removeEventListener = function (t, c) {
          var _this$listeners$get;

          (_this$listeners$get = this.listeners.get(t)) === null || _this$listeners$get === void 0 ? void 0 : _this$listeners$get.delete(c);
        };
      };

      var AdsManager = new EventHandler();
      /* eslint-disable no-use-before-define */

      AdsManager.volume = 1;
      AdsManager.collapse = noopFunc;
      AdsManager.configureAdsManager = noopFunc;
      AdsManager.destroy = noopFunc;
      AdsManager.discardAdBreak = noopFunc;
      AdsManager.expand = noopFunc;
      AdsManager.focus = noopFunc;

      AdsManager.getAdSkippableState = function () {
        return false;
      };

      AdsManager.getCuePoints = function () {
        return [0];
      };

      AdsManager.getCurrentAd = function () {
        return currentAd;
      };

      AdsManager.getCurrentAdCuePoints = function () {
        return [];
      };

      AdsManager.getRemainingTime = function () {
        return 0;
      };

      AdsManager.getVolume = function () {
        return this.volume;
      };

      AdsManager.init = noopFunc;

      AdsManager.isCustomClickTrackingUsed = function () {
        return false;
      };

      AdsManager.isCustomPlaybackUsed = function () {
        return false;
      };

      AdsManager.pause = noopFunc;
      AdsManager.requestNextAdBreak = noopFunc;
      AdsManager.resize = noopFunc;
      AdsManager.resume = noopFunc;

      AdsManager.setVolume = function (v) {
        this.volume = v;
      };

      AdsManager.skip = noopFunc;

      AdsManager.start = function () {
        // eslint-disable-next-line no-restricted-syntax
        for (var _i2 = 0, _arr = [AdEvent.Type.ALL_ADS_COMPLETED, AdEvent.Type.CONTENT_RESUME_REQUESTED]; _i2 < _arr.length; _i2++) {
          var type = _arr[_i2];

          try {
            this._dispatch(new ima.AdEvent(type));
          } catch (e) {
            // eslint-disable-next-line no-console
            console.error(e);
          }
        }
      };

      AdsManager.stop = noopFunc;
      AdsManager.updateAdsRenderingSettings = noopFunc;
      /* eslint-enable no-use-before-define */

      var manager = Object.create(AdsManager);

      var AdsManagerLoadedEvent = function AdsManagerLoadedEvent(type, adsRequest, userRequestContext) {
        this.type = type;
        this.adsRequest = adsRequest;
        this.userRequestContext = userRequestContext;
      };

      AdsManagerLoadedEvent.prototype = {
        getAdsManager: function getAdsManager() {
          return manager;
        },
        getUserRequestContext: function getUserRequestContext() {
          if (this.userRequestContext) {
            return this.userRequestContext;
          }

          return {};
        }
      };
      AdsManagerLoadedEvent.Type = {
        ADS_MANAGER_LOADED: 'adsManagerLoaded'
      };
      var AdsLoader = EventHandler;
      AdsLoader.prototype.settings = new ImaSdkSettings();
      AdsLoader.prototype.contentComplete = noopFunc;
      AdsLoader.prototype.destroy = noopFunc;

      AdsLoader.prototype.getSettings = function () {
        return this.settings;
      };

      AdsLoader.prototype.getVersion = function () {
        return VERSION;
      };

      AdsLoader.prototype.requestAds = function (adsRequest, userRequestContext) {
        var _this = this;

        if (!managerLoaded) {
          managerLoaded = true;
          requestAnimationFrame(function () {
            var ADS_MANAGER_LOADED = AdsManagerLoadedEvent.Type.ADS_MANAGER_LOADED; // eslint-disable-next-line max-len

            _this._dispatch(new ima.AdsManagerLoadedEvent(ADS_MANAGER_LOADED, adsRequest, userRequestContext));
          });
          var e = new ima.AdError('adPlayError', 1205, 1205, 'The browser prevented playback initiated without user interaction.', adsRequest, userRequestContext);
          requestAnimationFrame(function () {
            _this._dispatch(new ima.AdErrorEvent(e));
          });
        }
      };

      var AdsRenderingSettings = noopFunc;

      var AdsRequest = function AdsRequest() {};

      AdsRequest.prototype = {
        setAdWillAutoPlay: noopFunc,
        setAdWillPlayMuted: noopFunc,
        setContinuousPlayback: noopFunc
      };

      var AdPodInfo = function AdPodInfo() {};

      AdPodInfo.prototype = {
        getAdPosition: function getAdPosition() {
          return 1;
        },
        getIsBumper: function getIsBumper() {
          return false;
        },
        getMaxDuration: function getMaxDuration() {
          return -1;
        },
        getPodIndex: function getPodIndex() {
          return 1;
        },
        getTimeOffset: function getTimeOffset() {
          return 0;
        },
        getTotalAds: function getTotalAds() {
          return 1;
        }
      };

      var Ad = function Ad() {};

      Ad.prototype = {
        pi: new AdPodInfo(),
        getAdId: function getAdId() {
          return '';
        },
        getAdPodInfo: function getAdPodInfo() {
          return this.pi;
        },
        getAdSystem: function getAdSystem() {
          return '';
        },
        getAdvertiserName: function getAdvertiserName() {
          return '';
        },
        getApiFramework: function getApiFramework() {
          return null;
        },
        getCompanionAds: function getCompanionAds() {
          return [];
        },
        getContentType: function getContentType() {
          return '';
        },
        getCreativeAdId: function getCreativeAdId() {
          return '';
        },
        getDealId: function getDealId() {
          return '';
        },
        getDescription: function getDescription() {
          return '';
        },
        getDuration: function getDuration() {
          return 8.5;
        },
        getHeight: function getHeight() {
          return 0;
        },
        getMediaUrl: function getMediaUrl() {
          return null;
        },
        getMinSuggestedDuration: function getMinSuggestedDuration() {
          return -2;
        },
        getSkipTimeOffset: function getSkipTimeOffset() {
          return -1;
        },
        getSurveyUrl: function getSurveyUrl() {
          return null;
        },
        getTitle: function getTitle() {
          return '';
        },
        getTraffickingParametersString: function getTraffickingParametersString() {
          return '';
        },
        getUiElements: function getUiElements() {
          return [''];
        },
        getUniversalAdIdRegistry: function getUniversalAdIdRegistry() {
          return 'unknown';
        },
        getUniversalAdIds: function getUniversalAdIds() {
          return [''];
        },
        getUniversalAdIdValue: function getUniversalAdIdValue() {
          return 'unknown';
        },
        getVastMediaBitrate: function getVastMediaBitrate() {
          return 0;
        },
        getVastMediaHeight: function getVastMediaHeight() {
          return 0;
        },
        getVastMediaWidth: function getVastMediaWidth() {
          return 0;
        },
        getWidth: function getWidth() {
          return 0;
        },
        getWrapperAdIds: function getWrapperAdIds() {
          return [''];
        },
        getWrapperAdSystems: function getWrapperAdSystems() {
          return [''];
        },
        getWrapperCreativeIds: function getWrapperCreativeIds() {
          return [''];
        },
        isLinear: function isLinear() {
          return true;
        },
        isSkippable: function isSkippable() {
          return true;
        }
      };

      var CompanionAd = function CompanionAd() {};

      CompanionAd.prototype = {
        getAdSlotId: function getAdSlotId() {
          return '';
        },
        getContent: function getContent() {
          return '';
        },
        getContentType: function getContentType() {
          return '';
        },
        getHeight: function getHeight() {
          return 1;
        },
        getWidth: function getWidth() {
          return 1;
        }
      };

      var AdError = function AdError(type, code, vast, message, adsRequest, userRequestContext) {
        this.errorCode = code;
        this.message = message;
        this.type = type;
        this.adsRequest = adsRequest;
        this.userRequestContext = userRequestContext;

        this.getErrorCode = function () {
          return this.errorCode;
        };

        this.getInnerError = function () {};

        this.getMessage = function () {
          return this.message;
        };

        this.getType = function () {
          return this.type;
        };

        this.getVastErrorCode = function () {
          return this.vastErrorCode;
        };

        this.toString = function () {
          return "AdError ".concat(this.errorCode, ": ").concat(this.message);
        };
      };

      AdError.ErrorCode = {};
      AdError.Type = {};

      var isEngadget = function isEngadget() {
        try {
          // eslint-disable-next-line no-restricted-syntax
          for (var _i3 = 0, _Object$values = Object.values(window.vidible._getContexts()); _i3 < _Object$values.length; _i3++) {
            var _ctx$getPlayer, _ctx$getPlayer$div;

            var ctx = _Object$values[_i3];

            // eslint-disable-next-line no-restricted-properties
            if ((_ctx$getPlayer = ctx.getPlayer()) !== null && _ctx$getPlayer !== void 0 && (_ctx$getPlayer$div = _ctx$getPlayer.div) !== null && _ctx$getPlayer$div !== void 0 && _ctx$getPlayer$div.innerHTML.includes('www.engadget.com')) {
              return true;
            }
          }
        } catch (e) {} // eslint-disable-line no-empty


        return false;
      };

      var currentAd = isEngadget() ? undefined : new Ad();

      var AdEvent = function AdEvent(type) {
        this.type = type;
      };

      AdEvent.prototype = {
        getAd: function getAd() {
          return currentAd;
        },
        getAdData: function getAdData() {}
      };
      AdEvent.Type = {
        AD_BREAK_READY: 'adBreakReady',
        AD_BUFFERING: 'adBuffering',
        AD_CAN_PLAY: 'adCanPlay',
        AD_METADATA: 'adMetadata',
        AD_PROGRESS: 'adProgress',
        ALL_ADS_COMPLETED: 'allAdsCompleted',
        CLICK: 'click',
        COMPLETE: 'complete',
        CONTENT_PAUSE_REQUESTED: 'contentPauseRequested',
        CONTENT_RESUME_REQUESTED: 'contentResumeRequested',
        DURATION_CHANGE: 'durationChange',
        EXPANDED_CHANGED: 'expandedChanged',
        FIRST_QUARTILE: 'firstQuartile',
        IMPRESSION: 'impression',
        INTERACTION: 'interaction',
        LINEAR_CHANGE: 'linearChange',
        LINEAR_CHANGED: 'linearChanged',
        LOADED: 'loaded',
        LOG: 'log',
        MIDPOINT: 'midpoint',
        PAUSED: 'pause',
        RESUMED: 'resume',
        SKIPPABLE_STATE_CHANGED: 'skippableStateChanged',
        SKIPPED: 'skip',
        STARTED: 'start',
        THIRD_QUARTILE: 'thirdQuartile',
        USER_CLOSE: 'userClose',
        VIDEO_CLICKED: 'videoClicked',
        VIDEO_ICON_CLICKED: 'videoIconClicked',
        VIEWABLE_IMPRESSION: 'viewable_impression',
        VOLUME_CHANGED: 'volumeChange',
        VOLUME_MUTED: 'mute'
      };

      var AdErrorEvent = function AdErrorEvent(error) {
        this.error = error;
        this.type = 'adError';

        this.getError = function () {
          return this.error;
        };

        this.getUserRequestContext = function () {
          var _this$error;

          if ((_this$error = this.error) !== null && _this$error !== void 0 && _this$error.userRequestContext) {
            return this.error.userRequestContext;
          }

          return {};
        };
      };

      AdErrorEvent.Type = {
        AD_ERROR: 'adError'
      };

      var CustomContentLoadedEvent = function CustomContentLoadedEvent() {};

      CustomContentLoadedEvent.Type = {
        CUSTOM_CONTENT_LOADED: 'deprecated-event'
      };

      var CompanionAdSelectionSettings = function CompanionAdSelectionSettings() {};

      CompanionAdSelectionSettings.CreativeType = {
        ALL: 'All',
        FLASH: 'Flash',
        IMAGE: 'Image'
      };
      CompanionAdSelectionSettings.ResourceType = {
        ALL: 'All',
        HTML: 'Html',
        IFRAME: 'IFrame',
        STATIC: 'Static'
      };
      CompanionAdSelectionSettings.SizeCriteria = {
        IGNORE: 'IgnoreSize',
        SELECT_EXACT_MATCH: 'SelectExactMatch',
        SELECT_NEAR_MATCH: 'SelectNearMatch'
      };

      var AdCuePoints = function AdCuePoints() {};

      AdCuePoints.prototype = {
        getCuePoints: function getCuePoints() {
          return [];
        },
        getAdIdRegistry: function getAdIdRegistry() {
          return '';
        },
        getAdIsValue: function getAdIsValue() {
          return '';
        }
      };
      var AdProgressData = noopFunc;

      var UniversalAdIdInfo = function UniversalAdIdInfo() {};

      Object.assign(ima, {
        AdCuePoints: AdCuePoints,
        AdDisplayContainer: AdDisplayContainer,
        AdError: AdError,
        AdErrorEvent: AdErrorEvent,
        AdEvent: AdEvent,
        AdPodInfo: AdPodInfo,
        AdProgressData: AdProgressData,
        AdsLoader: AdsLoader,
        AdsManager: manager,
        AdsManagerLoadedEvent: AdsManagerLoadedEvent,
        AdsRenderingSettings: AdsRenderingSettings,
        AdsRequest: AdsRequest,
        CompanionAd: CompanionAd,
        CompanionAdSelectionSettings: CompanionAdSelectionSettings,
        CustomContentLoadedEvent: CustomContentLoadedEvent,
        gptProxyInstance: {},
        ImaSdkSettings: ImaSdkSettings,
        OmidAccessMode: {
          DOMAIN: 'domain',
          FULL: 'full',
          LIMITED: 'limited'
        },
        settings: new ImaSdkSettings(),
        UiElements: {
          AD_ATTRIBUTION: 'adAttribution',
          COUNTDOWN: 'countdown'
        },
        UniversalAdIdInfo: UniversalAdIdInfo,
        VERSION: VERSION,
        ViewMode: {
          FULLSCREEN: 'fullscreen',
          NORMAL: 'normal'
        }
      });

      if (!window.google) {
        window.google = {};
      }

      window.google.ima = ima;
      hit(source);
    }
    GoogleIma3.names = ['google-ima3'];
    GoogleIma3.injections = [hit, noopFunc];

    /* eslint-disable func-names, no-underscore-dangle */
    /**
     * @redirect didomi-loader
     *
     * @description
     * Mocks Didomi's CMP loader script.
     * https://developers.didomi.io/
     *
     * **Example**
     * ```
     * ||sdk.privacy-center.org/fbf86806f86e/loader.js$script,redirect=didomi-loader
     * ```
     */

    function DidomiLoader(source) {
      function UserConsentStatusForVendorSubscribe() {}

      UserConsentStatusForVendorSubscribe.prototype.filter = function () {
        return new UserConsentStatusForVendorSubscribe();
      };

      UserConsentStatusForVendorSubscribe.prototype.subscribe = noopFunc;

      function UserConsentStatusForVendor() {}

      UserConsentStatusForVendor.prototype.first = function () {
        return new UserConsentStatusForVendorSubscribe();
      };

      UserConsentStatusForVendor.prototype.filter = function () {
        return new UserConsentStatusForVendorSubscribe();
      };

      UserConsentStatusForVendor.prototype.subscribe = noopFunc;
      var DidomiWrapper = {
        isConsentRequired: falseFunc,
        getUserConsentStatusForPurpose: trueFunc,
        getUserConsentStatus: trueFunc,
        getUserStatus: noopFunc,
        getRequiredPurposes: noopArray,
        getUserConsentStatusForVendor: trueFunc,
        Purposes: {
          Cookies: 'cookies'
        },
        notice: {
          configure: noopFunc,
          hide: noopFunc,
          isVisible: falseFunc,
          show: noopFunc,
          showDataProcessing: trueFunc
        },
        isUserConsentStatusPartial: falseFunc,
        on: function on() {
          return {
            actions: {},
            emitter: {},
            services: {},
            store: {}
          };
        },
        shouldConsentBeCollected: falseFunc,
        getUserConsentStatusForAll: noopFunc,
        getObservableOnUserConsentStatusForVendor: function getObservableOnUserConsentStatusForVendor() {
          return new UserConsentStatusForVendor();
        }
      };
      window.Didomi = DidomiWrapper;
      var didomiStateWrapper = {
        didomiExperimentId: '',
        didomiExperimentUserGroup: '',
        didomiGDPRApplies: 1,
        didomiIABConsent: '',
        didomiPurposesConsent: '',
        didomiPurposesConsentDenied: '',
        didomiPurposesConsentUnknown: '',
        didomiVendorsConsent: '',
        didomiVendorsConsentDenied: '',
        didomiVendorsConsentUnknown: '',
        didomiVendorsRawConsent: '',
        didomiVendorsRawConsentDenied: '',
        didomiVendorsRawConsentUnknown: ''
      };
      window.didomiState = didomiStateWrapper;
      var tcData = {
        eventStatus: 'tcloaded',
        gdprApplies: false,
        listenerId: noopFunc,
        vendor: {
          consents: []
        },
        purpose: {
          consents: []
        }
      }; // https://github.com/InteractiveAdvertisingBureau/GDPR-Transparency-and-Consent-Framework/blob/master/TCFv2/IAB%20Tech%20Lab%20-%20CMP%20API%20v2.md#how-does-the-cmp-provide-the-api

      var __tcfapiWrapper = function __tcfapiWrapper(command, version, callback) {
        if (typeof callback !== 'function' || command === 'removeEventListener') {
          return;
        }

        callback(tcData, true);
      };

      window.__tcfapi = __tcfapiWrapper;
      var didomiEventListenersWrapper = {
        stub: true,
        push: noopFunc
      };
      window.didomiEventListeners = didomiEventListenersWrapper;
      var didomiOnReadyWrapper = {
        stub: true,
        push: function push(arg) {
          if (typeof arg !== 'function') {
            return;
          }

          if (document.readyState !== 'complete') {
            window.addEventListener('load', function () {
              setTimeout(arg(window.Didomi));
            });
          } else {
            setTimeout(arg(window.Didomi));
          }
        }
      };
      window.didomiOnReady = window.didomiOnReady || didomiOnReadyWrapper;

      if (Array.isArray(window.didomiOnReady)) {
        window.didomiOnReady.forEach(function (arg) {
          if (typeof arg === 'function') {
            try {
              setTimeout(arg(window.Didomi));
            } catch (e) {
              /* empty */
            }
          }
        });
      }

      hit(source);
    }
    DidomiLoader.names = ['didomi-loader'];
    DidomiLoader.injections = [hit, noopFunc, noopArray, trueFunc, falseFunc];

    /* eslint-disable func-names */
    /**
     * @redirect prebid
     *
     * @description
     * Mocks the prebid.js header bidding suit.
     * https://docs.prebid.org/
     *
     * **Example**
     * ```
     * ||tmgrup.com.tr/bd/hb/prebid.js$script,redirect=prebid
     * ```
     */

    function Prebid(source) {
      var pushFunction = function pushFunction(arg) {
        if (typeof arg === 'function') {
          try {
            arg.call();
          } catch (ex) {
            /* empty */
          }
        }
      };

      var pbjsWrapper = {
        addAdUnits: function addAdUnits() {},
        adServers: {
          dfp: {
            // https://docs.prebid.org/dev-docs/publisher-api-reference/adServers.dfp.buildVideoUrl.html
            // returns ad URL
            buildVideoUrl: noopStr
          }
        },
        adUnits: [],
        aliasBidder: function aliasBidder() {},
        cmd: [],
        enableAnalytics: function enableAnalytics() {},
        getHighestCpmBids: noopArray,
        libLoaded: true,
        que: [],
        requestBids: function requestBids(arg) {
          if (arg instanceof Object && arg.bidsBackHandler) {
            try {
              arg.bidsBackHandler.call(); // https://docs.prebid.org/dev-docs/publisher-api-reference/requestBids.html
            } catch (ex) {
              /* empty */
            }
          }
        },
        removeAdUnit: function removeAdUnit() {},
        setBidderConfig: function setBidderConfig() {},
        setConfig: function setConfig() {},
        setTargetingForGPTAsync: function setTargetingForGPTAsync() {}
      };
      pbjsWrapper.cmd.push = pushFunction;
      pbjsWrapper.que.push = pushFunction;
      window.pbjs = pbjsWrapper;
      hit(source);
    }
    Prebid.names = ['prebid'];
    Prebid.injections = [hit, noopFunc, noopStr, noopArray];

    /* eslint-disable func-names */
    /**
     * @redirect prebid-ads
     *
     * @description
     * Sets predefined constants on a page:
     * - `canRunAds`: `true`
     * - `isAdBlockActive`: `false`
     *
     * **Example**
     * ```
     * ||playerdrive.me/assets/js/prebid-ads.js$script,redirect=prebid-ads
     * ```
     */

    function prebidAds(source) {
      window.canRunAds = true;
      window.isAdBlockActive = false;
      hit(source);
    }
    prebidAds.names = ['prebid-ads', 'ubo-prebid-ads.js', 'prebid-ads.js'];
    prebidAds.injections = [hit];

    /* eslint-disable func-names */
    /**
     * @redirect naver-wcslog
     *
     * @description
     * Mocks wcslog.js of Naver Analytics.
     *
     * **Example**
     * ```
     * ||wcs.naver.net/wcslog.js$script,redirect=naver-wcslog
     * ```
     */

    function NaverWcslog(source) {
      window.wcs_add = {};
      window.wcs_do = noopFunc;
      window.wcs = {
        inflow: noopFunc
      };
      hit(source);
    }
    NaverWcslog.names = ['naver-wcslog'];
    NaverWcslog.injections = [hit, noopFunc];

    var redirectsList = /*#__PURE__*/Object.freeze({
        __proto__: null,
        noeval: noeval$1,
        GoogleAnalytics: GoogleAnalytics,
        GoogleAnalyticsGa: GoogleAnalyticsGa,
        GoogleSyndicationAdsByGoogle: GoogleSyndicationAdsByGoogle,
        GoogleTagServicesGpt: GoogleTagServicesGpt,
        ScoreCardResearchBeacon: ScoreCardResearchBeacon,
        metrikaYandexTag: metrikaYandexTag,
        metrikaYandexWatch: metrikaYandexWatch,
        Pardot: Pardot,
        preventFab: preventFab$1,
        preventBab: preventBab$1,
        setPopadsDummy: setPopadsDummy$1,
        preventPopadsNet: preventPopadsNet$1,
        AmazonApstag: AmazonApstag,
        Matomo: Matomo,
        Fingerprintjs2: Fingerprintjs2,
        Fingerprintjs3: Fingerprintjs3,
        Gemius: Gemius,
        ATInternetSmartTag: ATInternetSmartTag,
        preventBab2: preventBab2,
        GoogleIma3: GoogleIma3,
        DidomiLoader: DidomiLoader,
        Prebid: Prebid,
        prebidAds: prebidAds,
        NaverWcslog: NaverWcslog
    });

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    var classCallCheck = _classCallCheck;

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);
      if (staticProps) _defineProperties(Constructor, staticProps);
      return Constructor;
    }

    var createClass = _createClass;

    function isNothing(subject) {
      return typeof subject === 'undefined' || subject === null;
    }

    function isObject(subject) {
      return typeof subject === 'object' && subject !== null;
    }

    function toArray(sequence) {
      if (Array.isArray(sequence)) return sequence;else if (isNothing(sequence)) return [];
      return [sequence];
    }

    function extend(target, source) {
      var index, length, key, sourceKeys;

      if (source) {
        sourceKeys = Object.keys(source);

        for (index = 0, length = sourceKeys.length; index < length; index += 1) {
          key = sourceKeys[index];
          target[key] = source[key];
        }
      }

      return target;
    }

    function repeat(string, count) {
      var result = '',
          cycle;

      for (cycle = 0; cycle < count; cycle += 1) {
        result += string;
      }

      return result;
    }

    function isNegativeZero(number) {
      return number === 0 && Number.NEGATIVE_INFINITY === 1 / number;
    }

    var isNothing_1 = isNothing;
    var isObject_1 = isObject;
    var toArray_1 = toArray;
    var repeat_1 = repeat;
    var isNegativeZero_1 = isNegativeZero;
    var extend_1 = extend;
    var common = {
      isNothing: isNothing_1,
      isObject: isObject_1,
      toArray: toArray_1,
      repeat: repeat_1,
      isNegativeZero: isNegativeZero_1,
      extend: extend_1
    };

    // YAML error class. http://stackoverflow.com/questions/8458984

    function YAMLException$1(reason, mark) {
      // Super constructor
      Error.call(this);
      this.name = 'YAMLException';
      this.reason = reason;
      this.mark = mark;
      this.message = (this.reason || '(unknown reason)') + (this.mark ? ' ' + this.mark.toString() : ''); // Include stack trace in error object

      if (Error.captureStackTrace) {
        // Chrome and NodeJS
        Error.captureStackTrace(this, this.constructor);
      } else {
        // FF, IE 10+ and Safari 6+. Fallback for others
        this.stack = new Error().stack || '';
      }
    } // Inherit from Error


    YAMLException$1.prototype = Object.create(Error.prototype);
    YAMLException$1.prototype.constructor = YAMLException$1;

    YAMLException$1.prototype.toString = function toString(compact) {
      var result = this.name + ': ';
      result += this.reason || '(unknown reason)';

      if (!compact && this.mark) {
        result += ' ' + this.mark.toString();
      }

      return result;
    };

    var exception = YAMLException$1;

    function Mark(name, buffer, position, line, column) {
      this.name = name;
      this.buffer = buffer;
      this.position = position;
      this.line = line;
      this.column = column;
    }

    Mark.prototype.getSnippet = function getSnippet(indent, maxLength) {
      var head, start, tail, end, snippet;
      if (!this.buffer) return null;
      indent = indent || 4;
      maxLength = maxLength || 75;
      head = '';
      start = this.position;

      while (start > 0 && "\0\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(start - 1)) === -1) {
        start -= 1;

        if (this.position - start > maxLength / 2 - 1) {
          head = ' ... ';
          start += 5;
          break;
        }
      }

      tail = '';
      end = this.position;

      while (end < this.buffer.length && "\0\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(end)) === -1) {
        end += 1;

        if (end - this.position > maxLength / 2 - 1) {
          tail = ' ... ';
          end -= 5;
          break;
        }
      }

      snippet = this.buffer.slice(start, end);
      return common.repeat(' ', indent) + head + snippet + tail + '\n' + common.repeat(' ', indent + this.position - start + head.length) + '^';
    };

    Mark.prototype.toString = function toString(compact) {
      var snippet,
          where = '';

      if (this.name) {
        where += 'in "' + this.name + '" ';
      }

      where += 'at line ' + (this.line + 1) + ', column ' + (this.column + 1);

      if (!compact) {
        snippet = this.getSnippet();

        if (snippet) {
          where += ':\n' + snippet;
        }
      }

      return where;
    };

    var mark = Mark;

    var TYPE_CONSTRUCTOR_OPTIONS = ['kind', 'resolve', 'construct', 'instanceOf', 'predicate', 'represent', 'defaultStyle', 'styleAliases'];
    var YAML_NODE_KINDS = ['scalar', 'sequence', 'mapping'];

    function compileStyleAliases(map) {
      var result = {};

      if (map !== null) {
        Object.keys(map).forEach(function (style) {
          map[style].forEach(function (alias) {
            result[String(alias)] = style;
          });
        });
      }

      return result;
    }

    function Type$1(tag, options) {
      options = options || {};
      Object.keys(options).forEach(function (name) {
        if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
          throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
        }
      }); // TODO: Add tag format check.

      this.tag = tag;
      this.kind = options['kind'] || null;

      this.resolve = options['resolve'] || function () {
        return true;
      };

      this.construct = options['construct'] || function (data) {
        return data;
      };

      this.instanceOf = options['instanceOf'] || null;
      this.predicate = options['predicate'] || null;
      this.represent = options['represent'] || null;
      this.defaultStyle = options['defaultStyle'] || null;
      this.styleAliases = compileStyleAliases(options['styleAliases'] || null);

      if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
        throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
      }
    }

    var type = Type$1;

    /*eslint-disable max-len*/


    function compileList(schema, name, result) {
      var exclude = [];
      schema.include.forEach(function (includedSchema) {
        result = compileList(includedSchema, name, result);
      });
      schema[name].forEach(function (currentType) {
        result.forEach(function (previousType, previousIndex) {
          if (previousType.tag === currentType.tag && previousType.kind === currentType.kind) {
            exclude.push(previousIndex);
          }
        });
        result.push(currentType);
      });
      return result.filter(function (type, index) {
        return exclude.indexOf(index) === -1;
      });
    }

    function compileMap()
    /* lists... */
    {
      var result = {
        scalar: {},
        sequence: {},
        mapping: {},
        fallback: {}
      },
          index,
          length;

      function collectType(type) {
        result[type.kind][type.tag] = result['fallback'][type.tag] = type;
      }

      for (index = 0, length = arguments.length; index < length; index += 1) {
        arguments[index].forEach(collectType);
      }

      return result;
    }

    function Schema$1(definition) {
      this.include = definition.include || [];
      this.implicit = definition.implicit || [];
      this.explicit = definition.explicit || [];
      this.implicit.forEach(function (type) {
        if (type.loadKind && type.loadKind !== 'scalar') {
          throw new exception('There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.');
        }
      });
      this.compiledImplicit = compileList(this, 'implicit', []);
      this.compiledExplicit = compileList(this, 'explicit', []);
      this.compiledTypeMap = compileMap(this.compiledImplicit, this.compiledExplicit);
    }

    Schema$1.DEFAULT = null;

    Schema$1.create = function createSchema() {
      var schemas, types;

      switch (arguments.length) {
        case 1:
          schemas = Schema$1.DEFAULT;
          types = arguments[0];
          break;

        case 2:
          schemas = arguments[0];
          types = arguments[1];
          break;

        default:
          throw new exception('Wrong number of arguments for Schema.create function');
      }

      schemas = common.toArray(schemas);
      types = common.toArray(types);

      if (!schemas.every(function (schema) {
        return schema instanceof Schema$1;
      })) {
        throw new exception('Specified list of super schemas (or a single Schema object) contains a non-Schema object.');
      }

      if (!types.every(function (type$1) {
        return type$1 instanceof type;
      })) {
        throw new exception('Specified list of YAML types (or a single Type object) contains a non-Type object.');
      }

      return new Schema$1({
        include: schemas,
        explicit: types
      });
    };

    var schema = Schema$1;

    var str = new type('tag:yaml.org,2002:str', {
      kind: 'scalar',
      construct: function construct(data) {
        return data !== null ? data : '';
      }
    });

    var seq = new type('tag:yaml.org,2002:seq', {
      kind: 'sequence',
      construct: function construct(data) {
        return data !== null ? data : [];
      }
    });

    var map = new type('tag:yaml.org,2002:map', {
      kind: 'mapping',
      construct: function construct(data) {
        return data !== null ? data : {};
      }
    });

    var failsafe = new schema({
      explicit: [str, seq, map]
    });

    function resolveYamlNull(data) {
      if (data === null) return true;
      var max = data.length;
      return max === 1 && data === '~' || max === 4 && (data === 'null' || data === 'Null' || data === 'NULL');
    }

    function constructYamlNull() {
      return null;
    }

    function isNull(object) {
      return object === null;
    }

    var _null = new type('tag:yaml.org,2002:null', {
      kind: 'scalar',
      resolve: resolveYamlNull,
      construct: constructYamlNull,
      predicate: isNull,
      represent: {
        canonical: function canonical() {
          return '~';
        },
        lowercase: function lowercase() {
          return 'null';
        },
        uppercase: function uppercase() {
          return 'NULL';
        },
        camelcase: function camelcase() {
          return 'Null';
        }
      },
      defaultStyle: 'lowercase'
    });

    function resolveYamlBoolean(data) {
      if (data === null) return false;
      var max = data.length;
      return max === 4 && (data === 'true' || data === 'True' || data === 'TRUE') || max === 5 && (data === 'false' || data === 'False' || data === 'FALSE');
    }

    function constructYamlBoolean(data) {
      return data === 'true' || data === 'True' || data === 'TRUE';
    }

    function isBoolean(object) {
      return Object.prototype.toString.call(object) === '[object Boolean]';
    }

    var bool = new type('tag:yaml.org,2002:bool', {
      kind: 'scalar',
      resolve: resolveYamlBoolean,
      construct: constructYamlBoolean,
      predicate: isBoolean,
      represent: {
        lowercase: function lowercase(object) {
          return object ? 'true' : 'false';
        },
        uppercase: function uppercase(object) {
          return object ? 'TRUE' : 'FALSE';
        },
        camelcase: function camelcase(object) {
          return object ? 'True' : 'False';
        }
      },
      defaultStyle: 'lowercase'
    });

    function isHexCode(c) {
      return 0x30
      /* 0 */
      <= c && c <= 0x39
      /* 9 */
      || 0x41
      /* A */
      <= c && c <= 0x46
      /* F */
      || 0x61
      /* a */
      <= c && c <= 0x66
      /* f */
      ;
    }

    function isOctCode(c) {
      return 0x30
      /* 0 */
      <= c && c <= 0x37
      /* 7 */
      ;
    }

    function isDecCode(c) {
      return 0x30
      /* 0 */
      <= c && c <= 0x39
      /* 9 */
      ;
    }

    function resolveYamlInteger(data) {
      if (data === null) return false;
      var max = data.length,
          index = 0,
          hasDigits = false,
          ch;
      if (!max) return false;
      ch = data[index]; // sign

      if (ch === '-' || ch === '+') {
        ch = data[++index];
      }

      if (ch === '0') {
        // 0
        if (index + 1 === max) return true;
        ch = data[++index]; // base 2, base 8, base 16

        if (ch === 'b') {
          // base 2
          index++;

          for (; index < max; index++) {
            ch = data[index];
            if (ch === '_') continue;
            if (ch !== '0' && ch !== '1') return false;
            hasDigits = true;
          }

          return hasDigits && ch !== '_';
        }

        if (ch === 'x') {
          // base 16
          index++;

          for (; index < max; index++) {
            ch = data[index];
            if (ch === '_') continue;
            if (!isHexCode(data.charCodeAt(index))) return false;
            hasDigits = true;
          }

          return hasDigits && ch !== '_';
        } // base 8


        for (; index < max; index++) {
          ch = data[index];
          if (ch === '_') continue;
          if (!isOctCode(data.charCodeAt(index))) return false;
          hasDigits = true;
        }

        return hasDigits && ch !== '_';
      } // base 10 (except 0) or base 60
      // value should not start with `_`;


      if (ch === '_') return false;

      for (; index < max; index++) {
        ch = data[index];
        if (ch === '_') continue;
        if (ch === ':') break;

        if (!isDecCode(data.charCodeAt(index))) {
          return false;
        }

        hasDigits = true;
      } // Should have digits and should not end with `_`


      if (!hasDigits || ch === '_') return false; // if !base60 - done;

      if (ch !== ':') return true; // base60 almost not used, no needs to optimize

      return /^(:[0-5]?[0-9])+$/.test(data.slice(index));
    }

    function constructYamlInteger(data) {
      var value = data,
          sign = 1,
          ch,
          base,
          digits = [];

      if (value.indexOf('_') !== -1) {
        value = value.replace(/_/g, '');
      }

      ch = value[0];

      if (ch === '-' || ch === '+') {
        if (ch === '-') sign = -1;
        value = value.slice(1);
        ch = value[0];
      }

      if (value === '0') return 0;

      if (ch === '0') {
        if (value[1] === 'b') return sign * parseInt(value.slice(2), 2);
        if (value[1] === 'x') return sign * parseInt(value, 16);
        return sign * parseInt(value, 8);
      }

      if (value.indexOf(':') !== -1) {
        value.split(':').forEach(function (v) {
          digits.unshift(parseInt(v, 10));
        });
        value = 0;
        base = 1;
        digits.forEach(function (d) {
          value += d * base;
          base *= 60;
        });
        return sign * value;
      }

      return sign * parseInt(value, 10);
    }

    function isInteger(object) {
      return Object.prototype.toString.call(object) === '[object Number]' && object % 1 === 0 && !common.isNegativeZero(object);
    }

    var int = new type('tag:yaml.org,2002:int', {
      kind: 'scalar',
      resolve: resolveYamlInteger,
      construct: constructYamlInteger,
      predicate: isInteger,
      represent: {
        binary: function binary(obj) {
          return obj >= 0 ? '0b' + obj.toString(2) : '-0b' + obj.toString(2).slice(1);
        },
        octal: function octal(obj) {
          return obj >= 0 ? '0' + obj.toString(8) : '-0' + obj.toString(8).slice(1);
        },
        decimal: function decimal(obj) {
          return obj.toString(10);
        },

        /* eslint-disable max-len */
        hexadecimal: function hexadecimal(obj) {
          return obj >= 0 ? '0x' + obj.toString(16).toUpperCase() : '-0x' + obj.toString(16).toUpperCase().slice(1);
        }
      },
      defaultStyle: 'decimal',
      styleAliases: {
        binary: [2, 'bin'],
        octal: [8, 'oct'],
        decimal: [10, 'dec'],
        hexadecimal: [16, 'hex']
      }
    });

    var YAML_FLOAT_PATTERN = new RegExp( // 2.5e4, 2.5 and integers
    '^(?:[-+]?(?:0|[1-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?' + // .2e4, .2
    // special case, seems not from spec
    '|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?' + // 20:59
    '|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*' + // .inf
    '|[-+]?\\.(?:inf|Inf|INF)' + // .nan
    '|\\.(?:nan|NaN|NAN))$');

    function resolveYamlFloat(data) {
      if (data === null) return false;

      if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
      // Probably should update regexp & check speed
      data[data.length - 1] === '_') {
        return false;
      }

      return true;
    }

    function constructYamlFloat(data) {
      var value, sign, base, digits;
      value = data.replace(/_/g, '').toLowerCase();
      sign = value[0] === '-' ? -1 : 1;
      digits = [];

      if ('+-'.indexOf(value[0]) >= 0) {
        value = value.slice(1);
      }

      if (value === '.inf') {
        return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
      } else if (value === '.nan') {
        return NaN;
      } else if (value.indexOf(':') >= 0) {
        value.split(':').forEach(function (v) {
          digits.unshift(parseFloat(v, 10));
        });
        value = 0.0;
        base = 1;
        digits.forEach(function (d) {
          value += d * base;
          base *= 60;
        });
        return sign * value;
      }

      return sign * parseFloat(value, 10);
    }

    var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;

    function representYamlFloat(object, style) {
      var res;

      if (isNaN(object)) {
        switch (style) {
          case 'lowercase':
            return '.nan';

          case 'uppercase':
            return '.NAN';

          case 'camelcase':
            return '.NaN';
        }
      } else if (Number.POSITIVE_INFINITY === object) {
        switch (style) {
          case 'lowercase':
            return '.inf';

          case 'uppercase':
            return '.INF';

          case 'camelcase':
            return '.Inf';
        }
      } else if (Number.NEGATIVE_INFINITY === object) {
        switch (style) {
          case 'lowercase':
            return '-.inf';

          case 'uppercase':
            return '-.INF';

          case 'camelcase':
            return '-.Inf';
        }
      } else if (common.isNegativeZero(object)) {
        return '-0.0';
      }

      res = object.toString(10); // JS stringifier can build scientific format without dots: 5e-100,
      // while YAML requres dot: 5.e-100. Fix it with simple hack

      return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace('e', '.e') : res;
    }

    function isFloat(object) {
      return Object.prototype.toString.call(object) === '[object Number]' && (object % 1 !== 0 || common.isNegativeZero(object));
    }

    var float = new type('tag:yaml.org,2002:float', {
      kind: 'scalar',
      resolve: resolveYamlFloat,
      construct: constructYamlFloat,
      predicate: isFloat,
      represent: representYamlFloat,
      defaultStyle: 'lowercase'
    });

    var json = new schema({
      include: [failsafe],
      implicit: [_null, bool, int, float]
    });

    var core = new schema({
      include: [json]
    });

    var YAML_DATE_REGEXP = new RegExp('^([0-9][0-9][0-9][0-9])' + // [1] year
    '-([0-9][0-9])' + // [2] month
    '-([0-9][0-9])$'); // [3] day

    var YAML_TIMESTAMP_REGEXP = new RegExp('^([0-9][0-9][0-9][0-9])' + // [1] year
    '-([0-9][0-9]?)' + // [2] month
    '-([0-9][0-9]?)' + // [3] day
    '(?:[Tt]|[ \\t]+)' + // ...
    '([0-9][0-9]?)' + // [4] hour
    ':([0-9][0-9])' + // [5] minute
    ':([0-9][0-9])' + // [6] second
    '(?:\\.([0-9]*))?' + // [7] fraction
    '(?:[ \\t]*(Z|([-+])([0-9][0-9]?)' + // [8] tz [9] tz_sign [10] tz_hour
    '(?::([0-9][0-9]))?))?$'); // [11] tz_minute

    function resolveYamlTimestamp(data) {
      if (data === null) return false;
      if (YAML_DATE_REGEXP.exec(data) !== null) return true;
      if (YAML_TIMESTAMP_REGEXP.exec(data) !== null) return true;
      return false;
    }

    function constructYamlTimestamp(data) {
      var match,
          year,
          month,
          day,
          hour,
          minute,
          second,
          fraction = 0,
          delta = null,
          tz_hour,
          tz_minute,
          date;
      match = YAML_DATE_REGEXP.exec(data);
      if (match === null) match = YAML_TIMESTAMP_REGEXP.exec(data);
      if (match === null) throw new Error('Date resolve error'); // match: [1] year [2] month [3] day

      year = +match[1];
      month = +match[2] - 1; // JS month starts with 0

      day = +match[3];

      if (!match[4]) {
        // no hour
        return new Date(Date.UTC(year, month, day));
      } // match: [4] hour [5] minute [6] second [7] fraction


      hour = +match[4];
      minute = +match[5];
      second = +match[6];

      if (match[7]) {
        fraction = match[7].slice(0, 3);

        while (fraction.length < 3) {
          // milli-seconds
          fraction += '0';
        }

        fraction = +fraction;
      } // match: [8] tz [9] tz_sign [10] tz_hour [11] tz_minute


      if (match[9]) {
        tz_hour = +match[10];
        tz_minute = +(match[11] || 0);
        delta = (tz_hour * 60 + tz_minute) * 60000; // delta in mili-seconds

        if (match[9] === '-') delta = -delta;
      }

      date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
      if (delta) date.setTime(date.getTime() - delta);
      return date;
    }

    function representYamlTimestamp(object
    /*, style*/
    ) {
      return object.toISOString();
    }

    var timestamp = new type('tag:yaml.org,2002:timestamp', {
      kind: 'scalar',
      resolve: resolveYamlTimestamp,
      construct: constructYamlTimestamp,
      instanceOf: Date,
      represent: representYamlTimestamp
    });

    function resolveYamlMerge(data) {
      return data === '<<' || data === null;
    }

    var merge = new type('tag:yaml.org,2002:merge', {
      kind: 'scalar',
      resolve: resolveYamlMerge
    });

    function commonjsRequire (target) {
    	throw new Error('Could not dynamically require "' + target + '". Please configure the dynamicRequireTargets option of @rollup/plugin-commonjs appropriately for this require call to behave properly.');
    }

    /*eslint-disable no-bitwise*/


    var NodeBuffer;

    try {
      // A trick for browserified version, to not include `Buffer` shim
      var _require$1 = commonjsRequire;
      NodeBuffer = _require$1('buffer').Buffer;
    } catch (__) {} // [ 64, 65, 66 ] -> [ padding, CR, LF ]


    var BASE64_MAP = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r';

    function resolveYamlBinary(data) {
      if (data === null) return false;
      var code,
          idx,
          bitlen = 0,
          max = data.length,
          map = BASE64_MAP; // Convert one by one.

      for (idx = 0; idx < max; idx++) {
        code = map.indexOf(data.charAt(idx)); // Skip CR/LF

        if (code > 64) continue; // Fail on illegal characters

        if (code < 0) return false;
        bitlen += 6;
      } // If there are any bits left, source was corrupted


      return bitlen % 8 === 0;
    }

    function constructYamlBinary(data) {
      var idx,
          tailbits,
          input = data.replace(/[\r\n=]/g, ''),
          // remove CR/LF & padding to simplify scan
      max = input.length,
          map = BASE64_MAP,
          bits = 0,
          result = []; // Collect by 6*4 bits (3 bytes)

      for (idx = 0; idx < max; idx++) {
        if (idx % 4 === 0 && idx) {
          result.push(bits >> 16 & 0xFF);
          result.push(bits >> 8 & 0xFF);
          result.push(bits & 0xFF);
        }

        bits = bits << 6 | map.indexOf(input.charAt(idx));
      } // Dump tail


      tailbits = max % 4 * 6;

      if (tailbits === 0) {
        result.push(bits >> 16 & 0xFF);
        result.push(bits >> 8 & 0xFF);
        result.push(bits & 0xFF);
      } else if (tailbits === 18) {
        result.push(bits >> 10 & 0xFF);
        result.push(bits >> 2 & 0xFF);
      } else if (tailbits === 12) {
        result.push(bits >> 4 & 0xFF);
      } // Wrap into Buffer for NodeJS and leave Array for browser


      if (NodeBuffer) {
        // Support node 6.+ Buffer API when available
        return NodeBuffer.from ? NodeBuffer.from(result) : new NodeBuffer(result);
      }

      return result;
    }

    function representYamlBinary(object
    /*, style*/
    ) {
      var result = '',
          bits = 0,
          idx,
          tail,
          max = object.length,
          map = BASE64_MAP; // Convert every three bytes to 4 ASCII characters.

      for (idx = 0; idx < max; idx++) {
        if (idx % 3 === 0 && idx) {
          result += map[bits >> 18 & 0x3F];
          result += map[bits >> 12 & 0x3F];
          result += map[bits >> 6 & 0x3F];
          result += map[bits & 0x3F];
        }

        bits = (bits << 8) + object[idx];
      } // Dump tail


      tail = max % 3;

      if (tail === 0) {
        result += map[bits >> 18 & 0x3F];
        result += map[bits >> 12 & 0x3F];
        result += map[bits >> 6 & 0x3F];
        result += map[bits & 0x3F];
      } else if (tail === 2) {
        result += map[bits >> 10 & 0x3F];
        result += map[bits >> 4 & 0x3F];
        result += map[bits << 2 & 0x3F];
        result += map[64];
      } else if (tail === 1) {
        result += map[bits >> 2 & 0x3F];
        result += map[bits << 4 & 0x3F];
        result += map[64];
        result += map[64];
      }

      return result;
    }

    function isBinary(object) {
      return NodeBuffer && NodeBuffer.isBuffer(object);
    }

    var binary = new type('tag:yaml.org,2002:binary', {
      kind: 'scalar',
      resolve: resolveYamlBinary,
      construct: constructYamlBinary,
      predicate: isBinary,
      represent: representYamlBinary
    });

    var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
    var _toString$2 = Object.prototype.toString;

    function resolveYamlOmap(data) {
      if (data === null) return true;
      var objectKeys = [],
          index,
          length,
          pair,
          pairKey,
          pairHasKey,
          object = data;

      for (index = 0, length = object.length; index < length; index += 1) {
        pair = object[index];
        pairHasKey = false;
        if (_toString$2.call(pair) !== '[object Object]') return false;

        for (pairKey in pair) {
          if (_hasOwnProperty$3.call(pair, pairKey)) {
            if (!pairHasKey) pairHasKey = true;else return false;
          }
        }

        if (!pairHasKey) return false;
        if (objectKeys.indexOf(pairKey) === -1) objectKeys.push(pairKey);else return false;
      }

      return true;
    }

    function constructYamlOmap(data) {
      return data !== null ? data : [];
    }

    var omap = new type('tag:yaml.org,2002:omap', {
      kind: 'sequence',
      resolve: resolveYamlOmap,
      construct: constructYamlOmap
    });

    var _toString$1 = Object.prototype.toString;

    function resolveYamlPairs(data) {
      if (data === null) return true;
      var index,
          length,
          pair,
          keys,
          result,
          object = data;
      result = new Array(object.length);

      for (index = 0, length = object.length; index < length; index += 1) {
        pair = object[index];
        if (_toString$1.call(pair) !== '[object Object]') return false;
        keys = Object.keys(pair);
        if (keys.length !== 1) return false;
        result[index] = [keys[0], pair[keys[0]]];
      }

      return true;
    }

    function constructYamlPairs(data) {
      if (data === null) return [];
      var index,
          length,
          pair,
          keys,
          result,
          object = data;
      result = new Array(object.length);

      for (index = 0, length = object.length; index < length; index += 1) {
        pair = object[index];
        keys = Object.keys(pair);
        result[index] = [keys[0], pair[keys[0]]];
      }

      return result;
    }

    var pairs = new type('tag:yaml.org,2002:pairs', {
      kind: 'sequence',
      resolve: resolveYamlPairs,
      construct: constructYamlPairs
    });

    var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;

    function resolveYamlSet(data) {
      if (data === null) return true;
      var key,
          object = data;

      for (key in object) {
        if (_hasOwnProperty$2.call(object, key)) {
          if (object[key] !== null) return false;
        }
      }

      return true;
    }

    function constructYamlSet(data) {
      return data !== null ? data : {};
    }

    var set = new type('tag:yaml.org,2002:set', {
      kind: 'mapping',
      resolve: resolveYamlSet,
      construct: constructYamlSet
    });

    var default_safe = new schema({
      include: [core],
      implicit: [timestamp, merge],
      explicit: [binary, omap, pairs, set]
    });

    function resolveJavascriptUndefined() {
      return true;
    }

    function constructJavascriptUndefined() {
      /*eslint-disable no-undefined*/
      return undefined;
    }

    function representJavascriptUndefined() {
      return '';
    }

    function isUndefined(object) {
      return typeof object === 'undefined';
    }

    var _undefined = new type('tag:yaml.org,2002:js/undefined', {
      kind: 'scalar',
      resolve: resolveJavascriptUndefined,
      construct: constructJavascriptUndefined,
      predicate: isUndefined,
      represent: representJavascriptUndefined
    });

    function resolveJavascriptRegExp(data) {
      if (data === null) return false;
      if (data.length === 0) return false;
      var regexp = data,
          tail = /\/([gim]*)$/.exec(data),
          modifiers = ''; // if regexp starts with '/' it can have modifiers and must be properly closed
      // `/foo/gim` - modifiers tail can be maximum 3 chars

      if (regexp[0] === '/') {
        if (tail) modifiers = tail[1];
        if (modifiers.length > 3) return false; // if expression starts with /, is should be properly terminated

        if (regexp[regexp.length - modifiers.length - 1] !== '/') return false;
      }

      return true;
    }

    function constructJavascriptRegExp(data) {
      var regexp = data,
          tail = /\/([gim]*)$/.exec(data),
          modifiers = ''; // `/foo/gim` - tail can be maximum 4 chars

      if (regexp[0] === '/') {
        if (tail) modifiers = tail[1];
        regexp = regexp.slice(1, regexp.length - modifiers.length - 1);
      }

      return new RegExp(regexp, modifiers);
    }

    function representJavascriptRegExp(object
    /*, style*/
    ) {
      var result = '/' + object.source + '/';
      if (object.global) result += 'g';
      if (object.multiline) result += 'm';
      if (object.ignoreCase) result += 'i';
      return result;
    }

    function isRegExp(object) {
      return Object.prototype.toString.call(object) === '[object RegExp]';
    }

    var regexp = new type('tag:yaml.org,2002:js/regexp', {
      kind: 'scalar',
      resolve: resolveJavascriptRegExp,
      construct: constructJavascriptRegExp,
      predicate: isRegExp,
      represent: representJavascriptRegExp
    });

    var esprima; // Browserified version does not have esprima
    //
    // 1. For node.js just require module as deps
    // 2. For browser try to require mudule via external AMD system.
    //    If not found - try to fallback to window.esprima. If not
    //    found too - then fail to parse.
    //

    try {
      // workaround to exclude package from browserify list.
      var _require = commonjsRequire;
      esprima = _require('esprima');
    } catch (_) {
      /* eslint-disable no-redeclare */

      /* global window */
      if (typeof window !== 'undefined') esprima = window.esprima;
    }

    function resolveJavascriptFunction(data) {
      if (data === null) return false;

      try {
        var source = '(' + data + ')',
            ast = esprima.parse(source, {
          range: true
        });

        if (ast.type !== 'Program' || ast.body.length !== 1 || ast.body[0].type !== 'ExpressionStatement' || ast.body[0].expression.type !== 'ArrowFunctionExpression' && ast.body[0].expression.type !== 'FunctionExpression') {
          return false;
        }

        return true;
      } catch (err) {
        return false;
      }
    }

    function constructJavascriptFunction(data) {
      /*jslint evil:true*/
      var source = '(' + data + ')',
          ast = esprima.parse(source, {
        range: true
      }),
          params = [],
          body;

      if (ast.type !== 'Program' || ast.body.length !== 1 || ast.body[0].type !== 'ExpressionStatement' || ast.body[0].expression.type !== 'ArrowFunctionExpression' && ast.body[0].expression.type !== 'FunctionExpression') {
        throw new Error('Failed to resolve function');
      }

      ast.body[0].expression.params.forEach(function (param) {
        params.push(param.name);
      });
      body = ast.body[0].expression.body.range; // Esprima's ranges include the first '{' and the last '}' characters on
      // function expressions. So cut them out.

      if (ast.body[0].expression.body.type === 'BlockStatement') {
        /*eslint-disable no-new-func*/
        return new Function(params, source.slice(body[0] + 1, body[1] - 1));
      } // ES6 arrow functions can omit the BlockStatement. In that case, just return
      // the body.

      /*eslint-disable no-new-func*/


      return new Function(params, 'return ' + source.slice(body[0], body[1]));
    }

    function representJavascriptFunction(object
    /*, style*/
    ) {
      return object.toString();
    }

    function isFunction(object) {
      return Object.prototype.toString.call(object) === '[object Function]';
    }

    var _function = new type('tag:yaml.org,2002:js/function', {
      kind: 'scalar',
      resolve: resolveJavascriptFunction,
      construct: constructJavascriptFunction,
      predicate: isFunction,
      represent: representJavascriptFunction
    });

    var default_full = schema.DEFAULT = new schema({
      include: [default_safe],
      explicit: [_undefined, regexp, _function]
    });

    /*eslint-disable max-len,no-use-before-define*/


    var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
    var CONTEXT_FLOW_IN = 1;
    var CONTEXT_FLOW_OUT = 2;
    var CONTEXT_BLOCK_IN = 3;
    var CONTEXT_BLOCK_OUT = 4;
    var CHOMPING_CLIP = 1;
    var CHOMPING_STRIP = 2;
    var CHOMPING_KEEP = 3;
    var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
    var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
    var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
    var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
    var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;

    function _class(obj) {
      return Object.prototype.toString.call(obj);
    }

    function is_EOL(c) {
      return c === 0x0A
      /* LF */
      || c === 0x0D
      /* CR */
      ;
    }

    function is_WHITE_SPACE(c) {
      return c === 0x09
      /* Tab */
      || c === 0x20
      /* Space */
      ;
    }

    function is_WS_OR_EOL(c) {
      return c === 0x09
      /* Tab */
      || c === 0x20
      /* Space */
      || c === 0x0A
      /* LF */
      || c === 0x0D
      /* CR */
      ;
    }

    function is_FLOW_INDICATOR(c) {
      return c === 0x2C
      /* , */
      || c === 0x5B
      /* [ */
      || c === 0x5D
      /* ] */
      || c === 0x7B
      /* { */
      || c === 0x7D
      /* } */
      ;
    }

    function fromHexCode(c) {
      var lc;

      if (0x30
      /* 0 */
      <= c && c <= 0x39
      /* 9 */
      ) {
        return c - 0x30;
      }
      /*eslint-disable no-bitwise*/


      lc = c | 0x20;

      if (0x61
      /* a */
      <= lc && lc <= 0x66
      /* f */
      ) {
        return lc - 0x61 + 10;
      }

      return -1;
    }

    function escapedHexLen(c) {
      if (c === 0x78
      /* x */
      ) {
          return 2;
        }

      if (c === 0x75
      /* u */
      ) {
          return 4;
        }

      if (c === 0x55
      /* U */
      ) {
          return 8;
        }

      return 0;
    }

    function fromDecimalCode(c) {
      if (0x30
      /* 0 */
      <= c && c <= 0x39
      /* 9 */
      ) {
        return c - 0x30;
      }

      return -1;
    }

    function simpleEscapeSequence(c) {
      /* eslint-disable indent */
      return c === 0x30
      /* 0 */
      ? '\x00' : c === 0x61
      /* a */
      ? '\x07' : c === 0x62
      /* b */
      ? '\x08' : c === 0x74
      /* t */
      ? '\x09' : c === 0x09
      /* Tab */
      ? '\x09' : c === 0x6E
      /* n */
      ? '\x0A' : c === 0x76
      /* v */
      ? '\x0B' : c === 0x66
      /* f */
      ? '\x0C' : c === 0x72
      /* r */
      ? '\x0D' : c === 0x65
      /* e */
      ? '\x1B' : c === 0x20
      /* Space */
      ? ' ' : c === 0x22
      /* " */
      ? '\x22' : c === 0x2F
      /* / */
      ? '/' : c === 0x5C
      /* \ */
      ? '\x5C' : c === 0x4E
      /* N */
      ? '\x85' : c === 0x5F
      /* _ */
      ? '\xA0' : c === 0x4C
      /* L */
      ? "\u2028" : c === 0x50
      /* P */
      ? "\u2029" : '';
    }

    function charFromCodepoint(c) {
      if (c <= 0xFFFF) {
        return String.fromCharCode(c);
      } // Encode UTF-16 surrogate pair
      // https://en.wikipedia.org/wiki/UTF-16#Code_points_U.2B010000_to_U.2B10FFFF


      return String.fromCharCode((c - 0x010000 >> 10) + 0xD800, (c - 0x010000 & 0x03FF) + 0xDC00);
    }

    var simpleEscapeCheck = new Array(256); // integer, for fast access

    var simpleEscapeMap = new Array(256);

    for (var i = 0; i < 256; i++) {
      simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
      simpleEscapeMap[i] = simpleEscapeSequence(i);
    }

    function State$1(input, options) {
      this.input = input;
      this.filename = options['filename'] || null;
      this.schema = options['schema'] || default_full;
      this.onWarning = options['onWarning'] || null;
      this.legacy = options['legacy'] || false;
      this.json = options['json'] || false;
      this.listener = options['listener'] || null;
      this.implicitTypes = this.schema.compiledImplicit;
      this.typeMap = this.schema.compiledTypeMap;
      this.length = input.length;
      this.position = 0;
      this.line = 0;
      this.lineStart = 0;
      this.lineIndent = 0;
      this.documents = [];
      /*
      this.version;
      this.checkLineBreaks;
      this.tagMap;
      this.anchorMap;
      this.tag;
      this.anchor;
      this.kind;
      this.result;*/
    }

    function generateError(state, message) {
      return new exception(message, new mark(state.filename, state.input, state.position, state.line, state.position - state.lineStart));
    }

    function throwError(state, message) {
      throw generateError(state, message);
    }

    function throwWarning(state, message) {
      if (state.onWarning) {
        state.onWarning.call(null, generateError(state, message));
      }
    }

    var directiveHandlers = {
      YAML: function handleYamlDirective(state, name, args) {
        var match, major, minor;

        if (state.version !== null) {
          throwError(state, 'duplication of %YAML directive');
        }

        if (args.length !== 1) {
          throwError(state, 'YAML directive accepts exactly one argument');
        }

        match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);

        if (match === null) {
          throwError(state, 'ill-formed argument of the YAML directive');
        }

        major = parseInt(match[1], 10);
        minor = parseInt(match[2], 10);

        if (major !== 1) {
          throwError(state, 'unacceptable YAML version of the document');
        }

        state.version = args[0];
        state.checkLineBreaks = minor < 2;

        if (minor !== 1 && minor !== 2) {
          throwWarning(state, 'unsupported YAML version of the document');
        }
      },
      TAG: function handleTagDirective(state, name, args) {
        var handle, prefix;

        if (args.length !== 2) {
          throwError(state, 'TAG directive accepts exactly two arguments');
        }

        handle = args[0];
        prefix = args[1];

        if (!PATTERN_TAG_HANDLE.test(handle)) {
          throwError(state, 'ill-formed tag handle (first argument) of the TAG directive');
        }

        if (_hasOwnProperty$1.call(state.tagMap, handle)) {
          throwError(state, 'there is a previously declared suffix for "' + handle + '" tag handle');
        }

        if (!PATTERN_TAG_URI.test(prefix)) {
          throwError(state, 'ill-formed tag prefix (second argument) of the TAG directive');
        }

        state.tagMap[handle] = prefix;
      }
    };

    function captureSegment(state, start, end, checkJson) {
      var _position, _length, _character, _result;

      if (start < end) {
        _result = state.input.slice(start, end);

        if (checkJson) {
          for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
            _character = _result.charCodeAt(_position);

            if (!(_character === 0x09 || 0x20 <= _character && _character <= 0x10FFFF)) {
              throwError(state, 'expected valid JSON character');
            }
          }
        } else if (PATTERN_NON_PRINTABLE.test(_result)) {
          throwError(state, 'the stream contains non-printable characters');
        }

        state.result += _result;
      }
    }

    function mergeMappings(state, destination, source, overridableKeys) {
      var sourceKeys, key, index, quantity;

      if (!common.isObject(source)) {
        throwError(state, 'cannot merge mappings; the provided source object is unacceptable');
      }

      sourceKeys = Object.keys(source);

      for (index = 0, quantity = sourceKeys.length; index < quantity; index += 1) {
        key = sourceKeys[index];

        if (!_hasOwnProperty$1.call(destination, key)) {
          destination[key] = source[key];
          overridableKeys[key] = true;
        }
      }
    }

    function storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startPos) {
      var index, quantity; // The output is a plain object here, so keys can only be strings.
      // We need to convert keyNode to a string, but doing so can hang the process
      // (deeply nested arrays that explode exponentially using aliases).

      if (Array.isArray(keyNode)) {
        keyNode = Array.prototype.slice.call(keyNode);

        for (index = 0, quantity = keyNode.length; index < quantity; index += 1) {
          if (Array.isArray(keyNode[index])) {
            throwError(state, 'nested arrays are not supported inside keys');
          }

          if (typeof keyNode === 'object' && _class(keyNode[index]) === '[object Object]') {
            keyNode[index] = '[object Object]';
          }
        }
      } // Avoid code execution in load() via toString property
      // (still use its own toString for arrays, timestamps,
      // and whatever user schema extensions happen to have @@toStringTag)


      if (typeof keyNode === 'object' && _class(keyNode) === '[object Object]') {
        keyNode = '[object Object]';
      }

      keyNode = String(keyNode);

      if (_result === null) {
        _result = {};
      }

      if (keyTag === 'tag:yaml.org,2002:merge') {
        if (Array.isArray(valueNode)) {
          for (index = 0, quantity = valueNode.length; index < quantity; index += 1) {
            mergeMappings(state, _result, valueNode[index], overridableKeys);
          }
        } else {
          mergeMappings(state, _result, valueNode, overridableKeys);
        }
      } else {
        if (!state.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
          state.line = startLine || state.line;
          state.position = startPos || state.position;
          throwError(state, 'duplicated mapping key');
        }

        _result[keyNode] = valueNode;
        delete overridableKeys[keyNode];
      }

      return _result;
    }

    function readLineBreak(state) {
      var ch;
      ch = state.input.charCodeAt(state.position);

      if (ch === 0x0A
      /* LF */
      ) {
          state.position++;
        } else if (ch === 0x0D
      /* CR */
      ) {
          state.position++;

          if (state.input.charCodeAt(state.position) === 0x0A
          /* LF */
          ) {
              state.position++;
            }
        } else {
        throwError(state, 'a line break is expected');
      }

      state.line += 1;
      state.lineStart = state.position;
    }

    function skipSeparationSpace(state, allowComments, checkIndent) {
      var lineBreaks = 0,
          ch = state.input.charCodeAt(state.position);

      while (ch !== 0) {
        while (is_WHITE_SPACE(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }

        if (allowComments && ch === 0x23
        /* # */
        ) {
            do {
              ch = state.input.charCodeAt(++state.position);
            } while (ch !== 0x0A
            /* LF */
            && ch !== 0x0D
            /* CR */
            && ch !== 0);
          }

        if (is_EOL(ch)) {
          readLineBreak(state);
          ch = state.input.charCodeAt(state.position);
          lineBreaks++;
          state.lineIndent = 0;

          while (ch === 0x20
          /* Space */
          ) {
            state.lineIndent++;
            ch = state.input.charCodeAt(++state.position);
          }
        } else {
          break;
        }
      }

      if (checkIndent !== -1 && lineBreaks !== 0 && state.lineIndent < checkIndent) {
        throwWarning(state, 'deficient indentation');
      }

      return lineBreaks;
    }

    function testDocumentSeparator(state) {
      var _position = state.position,
          ch;
      ch = state.input.charCodeAt(_position); // Condition state.position === state.lineStart is tested
      // in parent on each call, for efficiency. No needs to test here again.

      if ((ch === 0x2D
      /* - */
      || ch === 0x2E
      /* . */
      ) && ch === state.input.charCodeAt(_position + 1) && ch === state.input.charCodeAt(_position + 2)) {
        _position += 3;
        ch = state.input.charCodeAt(_position);

        if (ch === 0 || is_WS_OR_EOL(ch)) {
          return true;
        }
      }

      return false;
    }

    function writeFoldedLines(state, count) {
      if (count === 1) {
        state.result += ' ';
      } else if (count > 1) {
        state.result += common.repeat('\n', count - 1);
      }
    }

    function readPlainScalar(state, nodeIndent, withinFlowCollection) {
      var preceding,
          following,
          captureStart,
          captureEnd,
          hasPendingContent,
          _line,
          _lineStart,
          _lineIndent,
          _kind = state.kind,
          _result = state.result,
          ch;

      ch = state.input.charCodeAt(state.position);

      if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 0x23
      /* # */
      || ch === 0x26
      /* & */
      || ch === 0x2A
      /* * */
      || ch === 0x21
      /* ! */
      || ch === 0x7C
      /* | */
      || ch === 0x3E
      /* > */
      || ch === 0x27
      /* ' */
      || ch === 0x22
      /* " */
      || ch === 0x25
      /* % */
      || ch === 0x40
      /* @ */
      || ch === 0x60
      /* ` */
      ) {
          return false;
        }

      if (ch === 0x3F
      /* ? */
      || ch === 0x2D
      /* - */
      ) {
          following = state.input.charCodeAt(state.position + 1);

          if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
            return false;
          }
        }

      state.kind = 'scalar';
      state.result = '';
      captureStart = captureEnd = state.position;
      hasPendingContent = false;

      while (ch !== 0) {
        if (ch === 0x3A
        /* : */
        ) {
            following = state.input.charCodeAt(state.position + 1);

            if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
              break;
            }
          } else if (ch === 0x23
        /* # */
        ) {
            preceding = state.input.charCodeAt(state.position - 1);

            if (is_WS_OR_EOL(preceding)) {
              break;
            }
          } else if (state.position === state.lineStart && testDocumentSeparator(state) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
          break;
        } else if (is_EOL(ch)) {
          _line = state.line;
          _lineStart = state.lineStart;
          _lineIndent = state.lineIndent;
          skipSeparationSpace(state, false, -1);

          if (state.lineIndent >= nodeIndent) {
            hasPendingContent = true;
            ch = state.input.charCodeAt(state.position);
            continue;
          } else {
            state.position = captureEnd;
            state.line = _line;
            state.lineStart = _lineStart;
            state.lineIndent = _lineIndent;
            break;
          }
        }

        if (hasPendingContent) {
          captureSegment(state, captureStart, captureEnd, false);
          writeFoldedLines(state, state.line - _line);
          captureStart = captureEnd = state.position;
          hasPendingContent = false;
        }

        if (!is_WHITE_SPACE(ch)) {
          captureEnd = state.position + 1;
        }

        ch = state.input.charCodeAt(++state.position);
      }

      captureSegment(state, captureStart, captureEnd, false);

      if (state.result) {
        return true;
      }

      state.kind = _kind;
      state.result = _result;
      return false;
    }

    function readSingleQuotedScalar(state, nodeIndent) {
      var ch, captureStart, captureEnd;
      ch = state.input.charCodeAt(state.position);

      if (ch !== 0x27
      /* ' */
      ) {
          return false;
        }

      state.kind = 'scalar';
      state.result = '';
      state.position++;
      captureStart = captureEnd = state.position;

      while ((ch = state.input.charCodeAt(state.position)) !== 0) {
        if (ch === 0x27
        /* ' */
        ) {
            captureSegment(state, captureStart, state.position, true);
            ch = state.input.charCodeAt(++state.position);

            if (ch === 0x27
            /* ' */
            ) {
                captureStart = state.position;
                state.position++;
                captureEnd = state.position;
              } else {
              return true;
            }
          } else if (is_EOL(ch)) {
          captureSegment(state, captureStart, captureEnd, true);
          writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
          captureStart = captureEnd = state.position;
        } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
          throwError(state, 'unexpected end of the document within a single quoted scalar');
        } else {
          state.position++;
          captureEnd = state.position;
        }
      }

      throwError(state, 'unexpected end of the stream within a single quoted scalar');
    }

    function readDoubleQuotedScalar(state, nodeIndent) {
      var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
      ch = state.input.charCodeAt(state.position);

      if (ch !== 0x22
      /* " */
      ) {
          return false;
        }

      state.kind = 'scalar';
      state.result = '';
      state.position++;
      captureStart = captureEnd = state.position;

      while ((ch = state.input.charCodeAt(state.position)) !== 0) {
        if (ch === 0x22
        /* " */
        ) {
            captureSegment(state, captureStart, state.position, true);
            state.position++;
            return true;
          } else if (ch === 0x5C
        /* \ */
        ) {
            captureSegment(state, captureStart, state.position, true);
            ch = state.input.charCodeAt(++state.position);

            if (is_EOL(ch)) {
              skipSeparationSpace(state, false, nodeIndent); // TODO: rework to inline fn with no type cast?
            } else if (ch < 256 && simpleEscapeCheck[ch]) {
              state.result += simpleEscapeMap[ch];
              state.position++;
            } else if ((tmp = escapedHexLen(ch)) > 0) {
              hexLength = tmp;
              hexResult = 0;

              for (; hexLength > 0; hexLength--) {
                ch = state.input.charCodeAt(++state.position);

                if ((tmp = fromHexCode(ch)) >= 0) {
                  hexResult = (hexResult << 4) + tmp;
                } else {
                  throwError(state, 'expected hexadecimal character');
                }
              }

              state.result += charFromCodepoint(hexResult);
              state.position++;
            } else {
              throwError(state, 'unknown escape sequence');
            }

            captureStart = captureEnd = state.position;
          } else if (is_EOL(ch)) {
          captureSegment(state, captureStart, captureEnd, true);
          writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
          captureStart = captureEnd = state.position;
        } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
          throwError(state, 'unexpected end of the document within a double quoted scalar');
        } else {
          state.position++;
          captureEnd = state.position;
        }
      }

      throwError(state, 'unexpected end of the stream within a double quoted scalar');
    }

    function readFlowCollection(state, nodeIndent) {
      var readNext = true,
          _line,
          _tag = state.tag,
          _result,
          _anchor = state.anchor,
          following,
          terminator,
          isPair,
          isExplicitPair,
          isMapping,
          overridableKeys = {},
          keyNode,
          keyTag,
          valueNode,
          ch;

      ch = state.input.charCodeAt(state.position);

      if (ch === 0x5B
      /* [ */
      ) {
          terminator = 0x5D;
          /* ] */

          isMapping = false;
          _result = [];
        } else if (ch === 0x7B
      /* { */
      ) {
          terminator = 0x7D;
          /* } */

          isMapping = true;
          _result = {};
        } else {
        return false;
      }

      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = _result;
      }

      ch = state.input.charCodeAt(++state.position);

      while (ch !== 0) {
        skipSeparationSpace(state, true, nodeIndent);
        ch = state.input.charCodeAt(state.position);

        if (ch === terminator) {
          state.position++;
          state.tag = _tag;
          state.anchor = _anchor;
          state.kind = isMapping ? 'mapping' : 'sequence';
          state.result = _result;
          return true;
        } else if (!readNext) {
          throwError(state, 'missed comma between flow collection entries');
        }

        keyTag = keyNode = valueNode = null;
        isPair = isExplicitPair = false;

        if (ch === 0x3F
        /* ? */
        ) {
            following = state.input.charCodeAt(state.position + 1);

            if (is_WS_OR_EOL(following)) {
              isPair = isExplicitPair = true;
              state.position++;
              skipSeparationSpace(state, true, nodeIndent);
            }
          }

        _line = state.line;
        composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
        keyTag = state.tag;
        keyNode = state.result;
        skipSeparationSpace(state, true, nodeIndent);
        ch = state.input.charCodeAt(state.position);

        if ((isExplicitPair || state.line === _line) && ch === 0x3A
        /* : */
        ) {
            isPair = true;
            ch = state.input.charCodeAt(++state.position);
            skipSeparationSpace(state, true, nodeIndent);
            composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
            valueNode = state.result;
          }

        if (isMapping) {
          storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode);
        } else if (isPair) {
          _result.push(storeMappingPair(state, null, overridableKeys, keyTag, keyNode, valueNode));
        } else {
          _result.push(keyNode);
        }

        skipSeparationSpace(state, true, nodeIndent);
        ch = state.input.charCodeAt(state.position);

        if (ch === 0x2C
        /* , */
        ) {
            readNext = true;
            ch = state.input.charCodeAt(++state.position);
          } else {
          readNext = false;
        }
      }

      throwError(state, 'unexpected end of the stream within a flow collection');
    }

    function readBlockScalar(state, nodeIndent) {
      var captureStart,
          folding,
          chomping = CHOMPING_CLIP,
          didReadContent = false,
          detectedIndent = false,
          textIndent = nodeIndent,
          emptyLines = 0,
          atMoreIndented = false,
          tmp,
          ch;
      ch = state.input.charCodeAt(state.position);

      if (ch === 0x7C
      /* | */
      ) {
          folding = false;
        } else if (ch === 0x3E
      /* > */
      ) {
          folding = true;
        } else {
        return false;
      }

      state.kind = 'scalar';
      state.result = '';

      while (ch !== 0) {
        ch = state.input.charCodeAt(++state.position);

        if (ch === 0x2B
        /* + */
        || ch === 0x2D
        /* - */
        ) {
            if (CHOMPING_CLIP === chomping) {
              chomping = ch === 0x2B
              /* + */
              ? CHOMPING_KEEP : CHOMPING_STRIP;
            } else {
              throwError(state, 'repeat of a chomping mode identifier');
            }
          } else if ((tmp = fromDecimalCode(ch)) >= 0) {
          if (tmp === 0) {
            throwError(state, 'bad explicit indentation width of a block scalar; it cannot be less than one');
          } else if (!detectedIndent) {
            textIndent = nodeIndent + tmp - 1;
            detectedIndent = true;
          } else {
            throwError(state, 'repeat of an indentation width identifier');
          }
        } else {
          break;
        }
      }

      if (is_WHITE_SPACE(ch)) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (is_WHITE_SPACE(ch));

        if (ch === 0x23
        /* # */
        ) {
            do {
              ch = state.input.charCodeAt(++state.position);
            } while (!is_EOL(ch) && ch !== 0);
          }
      }

      while (ch !== 0) {
        readLineBreak(state);
        state.lineIndent = 0;
        ch = state.input.charCodeAt(state.position);

        while ((!detectedIndent || state.lineIndent < textIndent) && ch === 0x20
        /* Space */
        ) {
          state.lineIndent++;
          ch = state.input.charCodeAt(++state.position);
        }

        if (!detectedIndent && state.lineIndent > textIndent) {
          textIndent = state.lineIndent;
        }

        if (is_EOL(ch)) {
          emptyLines++;
          continue;
        } // End of the scalar.


        if (state.lineIndent < textIndent) {
          // Perform the chomping.
          if (chomping === CHOMPING_KEEP) {
            state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines);
          } else if (chomping === CHOMPING_CLIP) {
            if (didReadContent) {
              // i.e. only if the scalar is not empty.
              state.result += '\n';
            }
          } // Break this `while` cycle and go to the funciton's epilogue.


          break;
        } // Folded style: use fancy rules to handle line breaks.


        if (folding) {
          // Lines starting with white space characters (more-indented lines) are not folded.
          if (is_WHITE_SPACE(ch)) {
            atMoreIndented = true; // except for the first content line (cf. Example 8.1)

            state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines); // End of more-indented block.
          } else if (atMoreIndented) {
            atMoreIndented = false;
            state.result += common.repeat('\n', emptyLines + 1); // Just one line break - perceive as the same line.
          } else if (emptyLines === 0) {
            if (didReadContent) {
              // i.e. only if we have already read some scalar content.
              state.result += ' ';
            } // Several line breaks - perceive as different lines.

          } else {
            state.result += common.repeat('\n', emptyLines);
          } // Literal style: just add exact number of line breaks between content lines.

        } else {
          // Keep all line breaks except the header line break.
          state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines);
        }

        didReadContent = true;
        detectedIndent = true;
        emptyLines = 0;
        captureStart = state.position;

        while (!is_EOL(ch) && ch !== 0) {
          ch = state.input.charCodeAt(++state.position);
        }

        captureSegment(state, captureStart, state.position, false);
      }

      return true;
    }

    function readBlockSequence(state, nodeIndent) {
      var _line,
          _tag = state.tag,
          _anchor = state.anchor,
          _result = [],
          following,
          detected = false,
          ch;

      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = _result;
      }

      ch = state.input.charCodeAt(state.position);

      while (ch !== 0) {
        if (ch !== 0x2D
        /* - */
        ) {
            break;
          }

        following = state.input.charCodeAt(state.position + 1);

        if (!is_WS_OR_EOL(following)) {
          break;
        }

        detected = true;
        state.position++;

        if (skipSeparationSpace(state, true, -1)) {
          if (state.lineIndent <= nodeIndent) {
            _result.push(null);

            ch = state.input.charCodeAt(state.position);
            continue;
          }
        }

        _line = state.line;
        composeNode(state, nodeIndent, CONTEXT_BLOCK_IN, false, true);

        _result.push(state.result);

        skipSeparationSpace(state, true, -1);
        ch = state.input.charCodeAt(state.position);

        if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
          throwError(state, 'bad indentation of a sequence entry');
        } else if (state.lineIndent < nodeIndent) {
          break;
        }
      }

      if (detected) {
        state.tag = _tag;
        state.anchor = _anchor;
        state.kind = 'sequence';
        state.result = _result;
        return true;
      }

      return false;
    }

    function readBlockMapping(state, nodeIndent, flowIndent) {
      var following,
          allowCompact,
          _line,
          _pos,
          _tag = state.tag,
          _anchor = state.anchor,
          _result = {},
          overridableKeys = {},
          keyTag = null,
          keyNode = null,
          valueNode = null,
          atExplicitKey = false,
          detected = false,
          ch;

      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = _result;
      }

      ch = state.input.charCodeAt(state.position);

      while (ch !== 0) {
        following = state.input.charCodeAt(state.position + 1);
        _line = state.line; // Save the current line.

        _pos = state.position; //
        // Explicit notation case. There are two separate blocks:
        // first for the key (denoted by "?") and second for the value (denoted by ":")
        //

        if ((ch === 0x3F
        /* ? */
        || ch === 0x3A
        /* : */
        ) && is_WS_OR_EOL(following)) {
          if (ch === 0x3F
          /* ? */
          ) {
              if (atExplicitKey) {
                storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null);
                keyTag = keyNode = valueNode = null;
              }

              detected = true;
              atExplicitKey = true;
              allowCompact = true;
            } else if (atExplicitKey) {
            // i.e. 0x3A/* : */ === character after the explicit key.
            atExplicitKey = false;
            allowCompact = true;
          } else {
            throwError(state, 'incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line');
          }

          state.position += 1;
          ch = following; //
          // Implicit notation case. Flow-style node as the key first, then ":", and the value.
          //
        } else if (composeNode(state, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
          if (state.line === _line) {
            ch = state.input.charCodeAt(state.position);

            while (is_WHITE_SPACE(ch)) {
              ch = state.input.charCodeAt(++state.position);
            }

            if (ch === 0x3A
            /* : */
            ) {
                ch = state.input.charCodeAt(++state.position);

                if (!is_WS_OR_EOL(ch)) {
                  throwError(state, 'a whitespace character is expected after the key-value separator within a block mapping');
                }

                if (atExplicitKey) {
                  storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null);
                  keyTag = keyNode = valueNode = null;
                }

                detected = true;
                atExplicitKey = false;
                allowCompact = false;
                keyTag = state.tag;
                keyNode = state.result;
              } else if (detected) {
              throwError(state, 'can not read an implicit mapping pair; a colon is missed');
            } else {
              state.tag = _tag;
              state.anchor = _anchor;
              return true; // Keep the result of `composeNode`.
            }
          } else if (detected) {
            throwError(state, 'can not read a block mapping entry; a multiline key may not be an implicit key');
          } else {
            state.tag = _tag;
            state.anchor = _anchor;
            return true; // Keep the result of `composeNode`.
          }
        } else {
            break; // Reading is done. Go to the epilogue.
          } //
        // Common reading code for both explicit and implicit notations.
        //


        if (state.line === _line || state.lineIndent > nodeIndent) {
          if (composeNode(state, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
            if (atExplicitKey) {
              keyNode = state.result;
            } else {
              valueNode = state.result;
            }
          }

          if (!atExplicitKey) {
            storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _pos);
            keyTag = keyNode = valueNode = null;
          }

          skipSeparationSpace(state, true, -1);
          ch = state.input.charCodeAt(state.position);
        }

        if (state.lineIndent > nodeIndent && ch !== 0) {
          throwError(state, 'bad indentation of a mapping entry');
        } else if (state.lineIndent < nodeIndent) {
          break;
        }
      } //
      // Epilogue.
      //
      // Special case: last mapping's node contains only the key in explicit notation.


      if (atExplicitKey) {
        storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null);
      } // Expose the resulting mapping.


      if (detected) {
        state.tag = _tag;
        state.anchor = _anchor;
        state.kind = 'mapping';
        state.result = _result;
      }

      return detected;
    }

    function readTagProperty(state) {
      var _position,
          isVerbatim = false,
          isNamed = false,
          tagHandle,
          tagName,
          ch;

      ch = state.input.charCodeAt(state.position);
      if (ch !== 0x21
      /* ! */
      ) return false;

      if (state.tag !== null) {
        throwError(state, 'duplication of a tag property');
      }

      ch = state.input.charCodeAt(++state.position);

      if (ch === 0x3C
      /* < */
      ) {
          isVerbatim = true;
          ch = state.input.charCodeAt(++state.position);
        } else if (ch === 0x21
      /* ! */
      ) {
          isNamed = true;
          tagHandle = '!!';
          ch = state.input.charCodeAt(++state.position);
        } else {
        tagHandle = '!';
      }

      _position = state.position;

      if (isVerbatim) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (ch !== 0 && ch !== 0x3E
        /* > */
        );

        if (state.position < state.length) {
          tagName = state.input.slice(_position, state.position);
          ch = state.input.charCodeAt(++state.position);
        } else {
          throwError(state, 'unexpected end of the stream within a verbatim tag');
        }
      } else {
        while (ch !== 0 && !is_WS_OR_EOL(ch)) {
          if (ch === 0x21
          /* ! */
          ) {
              if (!isNamed) {
                tagHandle = state.input.slice(_position - 1, state.position + 1);

                if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
                  throwError(state, 'named tag handle cannot contain such characters');
                }

                isNamed = true;
                _position = state.position + 1;
              } else {
                throwError(state, 'tag suffix cannot contain exclamation marks');
              }
            }

          ch = state.input.charCodeAt(++state.position);
        }

        tagName = state.input.slice(_position, state.position);

        if (PATTERN_FLOW_INDICATORS.test(tagName)) {
          throwError(state, 'tag suffix cannot contain flow indicator characters');
        }
      }

      if (tagName && !PATTERN_TAG_URI.test(tagName)) {
        throwError(state, 'tag name cannot contain such characters: ' + tagName);
      }

      if (isVerbatim) {
        state.tag = tagName;
      } else if (_hasOwnProperty$1.call(state.tagMap, tagHandle)) {
        state.tag = state.tagMap[tagHandle] + tagName;
      } else if (tagHandle === '!') {
        state.tag = '!' + tagName;
      } else if (tagHandle === '!!') {
        state.tag = 'tag:yaml.org,2002:' + tagName;
      } else {
        throwError(state, 'undeclared tag handle "' + tagHandle + '"');
      }

      return true;
    }

    function readAnchorProperty(state) {
      var _position, ch;

      ch = state.input.charCodeAt(state.position);
      if (ch !== 0x26
      /* & */
      ) return false;

      if (state.anchor !== null) {
        throwError(state, 'duplication of an anchor property');
      }

      ch = state.input.charCodeAt(++state.position);
      _position = state.position;

      while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }

      if (state.position === _position) {
        throwError(state, 'name of an anchor node must contain at least one character');
      }

      state.anchor = state.input.slice(_position, state.position);
      return true;
    }

    function readAlias(state) {
      var _position, alias, ch;

      ch = state.input.charCodeAt(state.position);
      if (ch !== 0x2A
      /* * */
      ) return false;
      ch = state.input.charCodeAt(++state.position);
      _position = state.position;

      while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }

      if (state.position === _position) {
        throwError(state, 'name of an alias node must contain at least one character');
      }

      alias = state.input.slice(_position, state.position);

      if (!_hasOwnProperty$1.call(state.anchorMap, alias)) {
        throwError(state, 'unidentified alias "' + alias + '"');
      }

      state.result = state.anchorMap[alias];
      skipSeparationSpace(state, true, -1);
      return true;
    }

    function composeNode(state, parentIndent, nodeContext, allowToSeek, allowCompact) {
      var allowBlockStyles,
          allowBlockScalars,
          allowBlockCollections,
          indentStatus = 1,
          // 1: this>parent, 0: this=parent, -1: this<parent
      atNewLine = false,
          hasContent = false,
          typeIndex,
          typeQuantity,
          type,
          flowIndent,
          blockIndent;

      if (state.listener !== null) {
        state.listener('open', state);
      }

      state.tag = null;
      state.anchor = null;
      state.kind = null;
      state.result = null;
      allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;

      if (allowToSeek) {
        if (skipSeparationSpace(state, true, -1)) {
          atNewLine = true;

          if (state.lineIndent > parentIndent) {
            indentStatus = 1;
          } else if (state.lineIndent === parentIndent) {
            indentStatus = 0;
          } else if (state.lineIndent < parentIndent) {
            indentStatus = -1;
          }
        }
      }

      if (indentStatus === 1) {
        while (readTagProperty(state) || readAnchorProperty(state)) {
          if (skipSeparationSpace(state, true, -1)) {
            atNewLine = true;
            allowBlockCollections = allowBlockStyles;

            if (state.lineIndent > parentIndent) {
              indentStatus = 1;
            } else if (state.lineIndent === parentIndent) {
              indentStatus = 0;
            } else if (state.lineIndent < parentIndent) {
              indentStatus = -1;
            }
          } else {
            allowBlockCollections = false;
          }
        }
      }

      if (allowBlockCollections) {
        allowBlockCollections = atNewLine || allowCompact;
      }

      if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
        if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
          flowIndent = parentIndent;
        } else {
          flowIndent = parentIndent + 1;
        }

        blockIndent = state.position - state.lineStart;

        if (indentStatus === 1) {
          if (allowBlockCollections && (readBlockSequence(state, blockIndent) || readBlockMapping(state, blockIndent, flowIndent)) || readFlowCollection(state, flowIndent)) {
            hasContent = true;
          } else {
            if (allowBlockScalars && readBlockScalar(state, flowIndent) || readSingleQuotedScalar(state, flowIndent) || readDoubleQuotedScalar(state, flowIndent)) {
              hasContent = true;
            } else if (readAlias(state)) {
              hasContent = true;

              if (state.tag !== null || state.anchor !== null) {
                throwError(state, 'alias node should not have any properties');
              }
            } else if (readPlainScalar(state, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
              hasContent = true;

              if (state.tag === null) {
                state.tag = '?';
              }
            }

            if (state.anchor !== null) {
              state.anchorMap[state.anchor] = state.result;
            }
          }
        } else if (indentStatus === 0) {
          // Special case: block sequences are allowed to have same indentation level as the parent.
          // http://www.yaml.org/spec/1.2/spec.html#id2799784
          hasContent = allowBlockCollections && readBlockSequence(state, blockIndent);
        }
      }

      if (state.tag !== null && state.tag !== '!') {
        if (state.tag === '?') {
          // Implicit resolving is not allowed for non-scalar types, and '?'
          // non-specific tag is only automatically assigned to plain scalars.
          //
          // We only need to check kind conformity in case user explicitly assigns '?'
          // tag, for example like this: "!<?> [0]"
          //
          if (state.result !== null && state.kind !== 'scalar') {
            throwError(state, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state.kind + '"');
          }

          for (typeIndex = 0, typeQuantity = state.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
            type = state.implicitTypes[typeIndex];

            if (type.resolve(state.result)) {
              // `state.result` updated in resolver if matched
              state.result = type.construct(state.result);
              state.tag = type.tag;

              if (state.anchor !== null) {
                state.anchorMap[state.anchor] = state.result;
              }

              break;
            }
          }
        } else if (_hasOwnProperty$1.call(state.typeMap[state.kind || 'fallback'], state.tag)) {
          type = state.typeMap[state.kind || 'fallback'][state.tag];

          if (state.result !== null && type.kind !== state.kind) {
            throwError(state, 'unacceptable node kind for !<' + state.tag + '> tag; it should be "' + type.kind + '", not "' + state.kind + '"');
          }

          if (!type.resolve(state.result)) {
            // `state.result` updated in resolver if matched
            throwError(state, 'cannot resolve a node with !<' + state.tag + '> explicit tag');
          } else {
            state.result = type.construct(state.result);

            if (state.anchor !== null) {
              state.anchorMap[state.anchor] = state.result;
            }
          }
        } else {
          throwError(state, 'unknown tag !<' + state.tag + '>');
        }
      }

      if (state.listener !== null) {
        state.listener('close', state);
      }

      return state.tag !== null || state.anchor !== null || hasContent;
    }

    function readDocument(state) {
      var documentStart = state.position,
          _position,
          directiveName,
          directiveArgs,
          hasDirectives = false,
          ch;

      state.version = null;
      state.checkLineBreaks = state.legacy;
      state.tagMap = {};
      state.anchorMap = {};

      while ((ch = state.input.charCodeAt(state.position)) !== 0) {
        skipSeparationSpace(state, true, -1);
        ch = state.input.charCodeAt(state.position);

        if (state.lineIndent > 0 || ch !== 0x25
        /* % */
        ) {
            break;
          }

        hasDirectives = true;
        ch = state.input.charCodeAt(++state.position);
        _position = state.position;

        while (ch !== 0 && !is_WS_OR_EOL(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }

        directiveName = state.input.slice(_position, state.position);
        directiveArgs = [];

        if (directiveName.length < 1) {
          throwError(state, 'directive name must not be less than one character in length');
        }

        while (ch !== 0) {
          while (is_WHITE_SPACE(ch)) {
            ch = state.input.charCodeAt(++state.position);
          }

          if (ch === 0x23
          /* # */
          ) {
              do {
                ch = state.input.charCodeAt(++state.position);
              } while (ch !== 0 && !is_EOL(ch));

              break;
            }

          if (is_EOL(ch)) break;
          _position = state.position;

          while (ch !== 0 && !is_WS_OR_EOL(ch)) {
            ch = state.input.charCodeAt(++state.position);
          }

          directiveArgs.push(state.input.slice(_position, state.position));
        }

        if (ch !== 0) readLineBreak(state);

        if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
          directiveHandlers[directiveName](state, directiveName, directiveArgs);
        } else {
          throwWarning(state, 'unknown document directive "' + directiveName + '"');
        }
      }

      skipSeparationSpace(state, true, -1);

      if (state.lineIndent === 0 && state.input.charCodeAt(state.position) === 0x2D
      /* - */
      && state.input.charCodeAt(state.position + 1) === 0x2D
      /* - */
      && state.input.charCodeAt(state.position + 2) === 0x2D
      /* - */
      ) {
          state.position += 3;
          skipSeparationSpace(state, true, -1);
        } else if (hasDirectives) {
        throwError(state, 'directives end mark is expected');
      }

      composeNode(state, state.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
      skipSeparationSpace(state, true, -1);

      if (state.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart, state.position))) {
        throwWarning(state, 'non-ASCII line breaks are interpreted as content');
      }

      state.documents.push(state.result);

      if (state.position === state.lineStart && testDocumentSeparator(state)) {
        if (state.input.charCodeAt(state.position) === 0x2E
        /* . */
        ) {
            state.position += 3;
            skipSeparationSpace(state, true, -1);
          }

        return;
      }

      if (state.position < state.length - 1) {
        throwError(state, 'end of the stream or a document separator is expected');
      } else {
        return;
      }
    }

    function loadDocuments(input, options) {
      input = String(input);
      options = options || {};

      if (input.length !== 0) {
        // Add tailing `\n` if not exists
        if (input.charCodeAt(input.length - 1) !== 0x0A
        /* LF */
        && input.charCodeAt(input.length - 1) !== 0x0D
        /* CR */
        ) {
            input += '\n';
          } // Strip BOM


        if (input.charCodeAt(0) === 0xFEFF) {
          input = input.slice(1);
        }
      }

      var state = new State$1(input, options);
      var nullpos = input.indexOf('\0');

      if (nullpos !== -1) {
        state.position = nullpos;
        throwError(state, 'null byte is not allowed in input');
      } // Use 0 as string terminator. That significantly simplifies bounds check.


      state.input += '\0';

      while (state.input.charCodeAt(state.position) === 0x20
      /* Space */
      ) {
        state.lineIndent += 1;
        state.position += 1;
      }

      while (state.position < state.length - 1) {
        readDocument(state);
      }

      return state.documents;
    }

    function loadAll$1(input, iterator, options) {
      if (iterator !== null && typeof iterator === 'object' && typeof options === 'undefined') {
        options = iterator;
        iterator = null;
      }

      var documents = loadDocuments(input, options);

      if (typeof iterator !== 'function') {
        return documents;
      }

      for (var index = 0, length = documents.length; index < length; index += 1) {
        iterator(documents[index]);
      }
    }

    function load$1(input, options) {
      var documents = loadDocuments(input, options);

      if (documents.length === 0) {
        /*eslint-disable no-undefined*/
        return undefined;
      } else if (documents.length === 1) {
        return documents[0];
      }

      throw new exception('expected a single document in the stream, but found more');
    }

    function safeLoadAll$1(input, iterator, options) {
      if (typeof iterator === 'object' && iterator !== null && typeof options === 'undefined') {
        options = iterator;
        iterator = null;
      }

      return loadAll$1(input, iterator, common.extend({
        schema: default_safe
      }, options));
    }

    function safeLoad$1(input, options) {
      return load$1(input, common.extend({
        schema: default_safe
      }, options));
    }

    var loadAll_1 = loadAll$1;
    var load_1 = load$1;
    var safeLoadAll_1 = safeLoadAll$1;
    var safeLoad_1 = safeLoad$1;
    var loader = {
      loadAll: loadAll_1,
      load: load_1,
      safeLoadAll: safeLoadAll_1,
      safeLoad: safeLoad_1
    };

    /*eslint-disable no-use-before-define*/


    var _toString = Object.prototype.toString;
    var _hasOwnProperty = Object.prototype.hasOwnProperty;
    var CHAR_TAB = 0x09;
    /* Tab */

    var CHAR_LINE_FEED = 0x0A;
    /* LF */

    var CHAR_CARRIAGE_RETURN = 0x0D;
    /* CR */

    var CHAR_SPACE = 0x20;
    /* Space */

    var CHAR_EXCLAMATION = 0x21;
    /* ! */

    var CHAR_DOUBLE_QUOTE = 0x22;
    /* " */

    var CHAR_SHARP = 0x23;
    /* # */

    var CHAR_PERCENT = 0x25;
    /* % */

    var CHAR_AMPERSAND = 0x26;
    /* & */

    var CHAR_SINGLE_QUOTE = 0x27;
    /* ' */

    var CHAR_ASTERISK = 0x2A;
    /* * */

    var CHAR_COMMA = 0x2C;
    /* , */

    var CHAR_MINUS = 0x2D;
    /* - */

    var CHAR_COLON = 0x3A;
    /* : */

    var CHAR_EQUALS = 0x3D;
    /* = */

    var CHAR_GREATER_THAN = 0x3E;
    /* > */

    var CHAR_QUESTION = 0x3F;
    /* ? */

    var CHAR_COMMERCIAL_AT = 0x40;
    /* @ */

    var CHAR_LEFT_SQUARE_BRACKET = 0x5B;
    /* [ */

    var CHAR_RIGHT_SQUARE_BRACKET = 0x5D;
    /* ] */

    var CHAR_GRAVE_ACCENT = 0x60;
    /* ` */

    var CHAR_LEFT_CURLY_BRACKET = 0x7B;
    /* { */

    var CHAR_VERTICAL_LINE = 0x7C;
    /* | */

    var CHAR_RIGHT_CURLY_BRACKET = 0x7D;
    /* } */

    var ESCAPE_SEQUENCES = {};
    ESCAPE_SEQUENCES[0x00] = '\\0';
    ESCAPE_SEQUENCES[0x07] = '\\a';
    ESCAPE_SEQUENCES[0x08] = '\\b';
    ESCAPE_SEQUENCES[0x09] = '\\t';
    ESCAPE_SEQUENCES[0x0A] = '\\n';
    ESCAPE_SEQUENCES[0x0B] = '\\v';
    ESCAPE_SEQUENCES[0x0C] = '\\f';
    ESCAPE_SEQUENCES[0x0D] = '\\r';
    ESCAPE_SEQUENCES[0x1B] = '\\e';
    ESCAPE_SEQUENCES[0x22] = '\\"';
    ESCAPE_SEQUENCES[0x5C] = '\\\\';
    ESCAPE_SEQUENCES[0x85] = '\\N';
    ESCAPE_SEQUENCES[0xA0] = '\\_';
    ESCAPE_SEQUENCES[0x2028] = '\\L';
    ESCAPE_SEQUENCES[0x2029] = '\\P';
    var DEPRECATED_BOOLEANS_SYNTAX = ['y', 'Y', 'yes', 'Yes', 'YES', 'on', 'On', 'ON', 'n', 'N', 'no', 'No', 'NO', 'off', 'Off', 'OFF'];

    function compileStyleMap(schema, map) {
      var result, keys, index, length, tag, style, type;
      if (map === null) return {};
      result = {};
      keys = Object.keys(map);

      for (index = 0, length = keys.length; index < length; index += 1) {
        tag = keys[index];
        style = String(map[tag]);

        if (tag.slice(0, 2) === '!!') {
          tag = 'tag:yaml.org,2002:' + tag.slice(2);
        }

        type = schema.compiledTypeMap['fallback'][tag];

        if (type && _hasOwnProperty.call(type.styleAliases, style)) {
          style = type.styleAliases[style];
        }

        result[tag] = style;
      }

      return result;
    }

    function encodeHex(character) {
      var string, handle, length;
      string = character.toString(16).toUpperCase();

      if (character <= 0xFF) {
        handle = 'x';
        length = 2;
      } else if (character <= 0xFFFF) {
        handle = 'u';
        length = 4;
      } else if (character <= 0xFFFFFFFF) {
        handle = 'U';
        length = 8;
      } else {
        throw new exception('code point within a string may not be greater than 0xFFFFFFFF');
      }

      return '\\' + handle + common.repeat('0', length - string.length) + string;
    }

    function State(options) {
      this.schema = options['schema'] || default_full;
      this.indent = Math.max(1, options['indent'] || 2);
      this.noArrayIndent = options['noArrayIndent'] || false;
      this.skipInvalid = options['skipInvalid'] || false;
      this.flowLevel = common.isNothing(options['flowLevel']) ? -1 : options['flowLevel'];
      this.styleMap = compileStyleMap(this.schema, options['styles'] || null);
      this.sortKeys = options['sortKeys'] || false;
      this.lineWidth = options['lineWidth'] || 80;
      this.noRefs = options['noRefs'] || false;
      this.noCompatMode = options['noCompatMode'] || false;
      this.condenseFlow = options['condenseFlow'] || false;
      this.implicitTypes = this.schema.compiledImplicit;
      this.explicitTypes = this.schema.compiledExplicit;
      this.tag = null;
      this.result = '';
      this.duplicates = [];
      this.usedDuplicates = null;
    } // Indents every line in a string. Empty lines (\n only) are not indented.


    function indentString(string, spaces) {
      var ind = common.repeat(' ', spaces),
          position = 0,
          next = -1,
          result = '',
          line,
          length = string.length;

      while (position < length) {
        next = string.indexOf('\n', position);

        if (next === -1) {
          line = string.slice(position);
          position = length;
        } else {
          line = string.slice(position, next + 1);
          position = next + 1;
        }

        if (line.length && line !== '\n') result += ind;
        result += line;
      }

      return result;
    }

    function generateNextLine(state, level) {
      return '\n' + common.repeat(' ', state.indent * level);
    }

    function testImplicitResolving(state, str) {
      var index, length, type;

      for (index = 0, length = state.implicitTypes.length; index < length; index += 1) {
        type = state.implicitTypes[index];

        if (type.resolve(str)) {
          return true;
        }
      }

      return false;
    } // [33] s-white ::= s-space | s-tab


    function isWhitespace(c) {
      return c === CHAR_SPACE || c === CHAR_TAB;
    } // Returns true if the character can be printed without escaping.
    // From YAML 1.2: "any allowed characters known to be non-printable
    // should also be escaped. [However,] This isn’t mandatory"
    // Derived from nb-char - \t - #x85 - #xA0 - #x2028 - #x2029.


    function isPrintable(c) {
      return 0x00020 <= c && c <= 0x00007E || 0x000A1 <= c && c <= 0x00D7FF && c !== 0x2028 && c !== 0x2029 || 0x0E000 <= c && c <= 0x00FFFD && c !== 0xFEFF
      /* BOM */
      || 0x10000 <= c && c <= 0x10FFFF;
    } // [34] ns-char ::= nb-char - s-white
    // [27] nb-char ::= c-printable - b-char - c-byte-order-mark
    // [26] b-char  ::= b-line-feed | b-carriage-return
    // [24] b-line-feed       ::=     #xA    /* LF */
    // [25] b-carriage-return ::=     #xD    /* CR */
    // [3]  c-byte-order-mark ::=     #xFEFF


    function isNsChar(c) {
      return isPrintable(c) && !isWhitespace(c) // byte-order-mark
      && c !== 0xFEFF // b-char
      && c !== CHAR_CARRIAGE_RETURN && c !== CHAR_LINE_FEED;
    } // Simplified test for values allowed after the first character in plain style.


    function isPlainSafe(c, prev) {
      // Uses a subset of nb-char - c-flow-indicator - ":" - "#"
      // where nb-char ::= c-printable - b-char - c-byte-order-mark.
      return isPrintable(c) && c !== 0xFEFF // - c-flow-indicator
      && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET // - ":" - "#"
      // /* An ns-char preceding */ "#"
      && c !== CHAR_COLON && (c !== CHAR_SHARP || prev && isNsChar(prev));
    } // Simplified test for values allowed as the first character in plain style.


    function isPlainSafeFirst(c) {
      // Uses a subset of ns-char - c-indicator
      // where ns-char = nb-char - s-white.
      return isPrintable(c) && c !== 0xFEFF && !isWhitespace(c) // - s-white
      // - (c-indicator ::=
      // “-” | “?” | “:” | “,” | “[” | “]” | “{” | “}”
      && c !== CHAR_MINUS && c !== CHAR_QUESTION && c !== CHAR_COLON && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET // | “#” | “&” | “*” | “!” | “|” | “=” | “>” | “'” | “"”
      && c !== CHAR_SHARP && c !== CHAR_AMPERSAND && c !== CHAR_ASTERISK && c !== CHAR_EXCLAMATION && c !== CHAR_VERTICAL_LINE && c !== CHAR_EQUALS && c !== CHAR_GREATER_THAN && c !== CHAR_SINGLE_QUOTE && c !== CHAR_DOUBLE_QUOTE // | “%” | “@” | “`”)
      && c !== CHAR_PERCENT && c !== CHAR_COMMERCIAL_AT && c !== CHAR_GRAVE_ACCENT;
    } // Determines whether block indentation indicator is required.


    function needIndentIndicator(string) {
      var leadingSpaceRe = /^\n* /;
      return leadingSpaceRe.test(string);
    }

    var STYLE_PLAIN = 1,
        STYLE_SINGLE = 2,
        STYLE_LITERAL = 3,
        STYLE_FOLDED = 4,
        STYLE_DOUBLE = 5; // Determines which scalar styles are possible and returns the preferred style.
    // lineWidth = -1 => no limit.
    // Pre-conditions: str.length > 0.
    // Post-conditions:
    //    STYLE_PLAIN or STYLE_SINGLE => no \n are in the string.
    //    STYLE_LITERAL => no lines are suitable for folding (or lineWidth is -1).
    //    STYLE_FOLDED => a line > lineWidth and can be folded (and lineWidth != -1).

    function chooseScalarStyle(string, singleLineOnly, indentPerLevel, lineWidth, testAmbiguousType) {
      var i;
      var char, prev_char;
      var hasLineBreak = false;
      var hasFoldableLine = false; // only checked if shouldTrackWidth

      var shouldTrackWidth = lineWidth !== -1;
      var previousLineBreak = -1; // count the first line correctly

      var plain = isPlainSafeFirst(string.charCodeAt(0)) && !isWhitespace(string.charCodeAt(string.length - 1));

      if (singleLineOnly) {
        // Case: no block styles.
        // Check for disallowed characters to rule out plain and single.
        for (i = 0; i < string.length; i++) {
          char = string.charCodeAt(i);

          if (!isPrintable(char)) {
            return STYLE_DOUBLE;
          }

          prev_char = i > 0 ? string.charCodeAt(i - 1) : null;
          plain = plain && isPlainSafe(char, prev_char);
        }
      } else {
        // Case: block styles permitted.
        for (i = 0; i < string.length; i++) {
          char = string.charCodeAt(i);

          if (char === CHAR_LINE_FEED) {
            hasLineBreak = true; // Check if any line can be folded.

            if (shouldTrackWidth) {
              hasFoldableLine = hasFoldableLine || // Foldable line = too long, and not more-indented.
              i - previousLineBreak - 1 > lineWidth && string[previousLineBreak + 1] !== ' ';
              previousLineBreak = i;
            }
          } else if (!isPrintable(char)) {
            return STYLE_DOUBLE;
          }

          prev_char = i > 0 ? string.charCodeAt(i - 1) : null;
          plain = plain && isPlainSafe(char, prev_char);
        } // in case the end is missing a \n


        hasFoldableLine = hasFoldableLine || shouldTrackWidth && i - previousLineBreak - 1 > lineWidth && string[previousLineBreak + 1] !== ' ';
      } // Although every style can represent \n without escaping, prefer block styles
      // for multiline, since they're more readable and they don't add empty lines.
      // Also prefer folding a super-long line.


      if (!hasLineBreak && !hasFoldableLine) {
        // Strings interpretable as another type have to be quoted;
        // e.g. the string 'true' vs. the boolean true.
        return plain && !testAmbiguousType(string) ? STYLE_PLAIN : STYLE_SINGLE;
      } // Edge case: block indentation indicator can only have one digit.


      if (indentPerLevel > 9 && needIndentIndicator(string)) {
        return STYLE_DOUBLE;
      } // At this point we know block styles are valid.
      // Prefer literal style unless we want to fold.


      return hasFoldableLine ? STYLE_FOLDED : STYLE_LITERAL;
    } // Note: line breaking/folding is implemented for only the folded style.
    // NB. We drop the last trailing newline (if any) of a returned block scalar
    //  since the dumper adds its own newline. This always works:
    //    • No ending newline => unaffected; already using strip "-" chomping.
    //    • Ending newline    => removed then restored.
    //  Importantly, this keeps the "+" chomp indicator from gaining an extra line.


    function writeScalar(state, string, level, iskey) {
      state.dump = function () {
        if (string.length === 0) {
          return "''";
        }

        if (!state.noCompatMode && DEPRECATED_BOOLEANS_SYNTAX.indexOf(string) !== -1) {
          return "'" + string + "'";
        }

        var indent = state.indent * Math.max(1, level); // no 0-indent scalars
        // As indentation gets deeper, let the width decrease monotonically
        // to the lower bound min(state.lineWidth, 40).
        // Note that this implies
        //  state.lineWidth ≤ 40 + state.indent: width is fixed at the lower bound.
        //  state.lineWidth > 40 + state.indent: width decreases until the lower bound.
        // This behaves better than a constant minimum width which disallows narrower options,
        // or an indent threshold which causes the width to suddenly increase.

        var lineWidth = state.lineWidth === -1 ? -1 : Math.max(Math.min(state.lineWidth, 40), state.lineWidth - indent); // Without knowing if keys are implicit/explicit, assume implicit for safety.

        var singleLineOnly = iskey // No block styles in flow mode.
        || state.flowLevel > -1 && level >= state.flowLevel;

        function testAmbiguity(string) {
          return testImplicitResolving(state, string);
        }

        switch (chooseScalarStyle(string, singleLineOnly, state.indent, lineWidth, testAmbiguity)) {
          case STYLE_PLAIN:
            return string;

          case STYLE_SINGLE:
            return "'" + string.replace(/'/g, "''") + "'";

          case STYLE_LITERAL:
            return '|' + blockHeader(string, state.indent) + dropEndingNewline(indentString(string, indent));

          case STYLE_FOLDED:
            return '>' + blockHeader(string, state.indent) + dropEndingNewline(indentString(foldString(string, lineWidth), indent));

          case STYLE_DOUBLE:
            return '"' + escapeString(string) + '"';

          default:
            throw new exception('impossible error: invalid scalar style');
        }
      }();
    } // Pre-conditions: string is valid for a block scalar, 1 <= indentPerLevel <= 9.


    function blockHeader(string, indentPerLevel) {
      var indentIndicator = needIndentIndicator(string) ? String(indentPerLevel) : ''; // note the special case: the string '\n' counts as a "trailing" empty line.

      var clip = string[string.length - 1] === '\n';
      var keep = clip && (string[string.length - 2] === '\n' || string === '\n');
      var chomp = keep ? '+' : clip ? '' : '-';
      return indentIndicator + chomp + '\n';
    } // (See the note for writeScalar.)


    function dropEndingNewline(string) {
      return string[string.length - 1] === '\n' ? string.slice(0, -1) : string;
    } // Note: a long line without a suitable break point will exceed the width limit.
    // Pre-conditions: every char in str isPrintable, str.length > 0, width > 0.


    function foldString(string, width) {
      // In folded style, $k$ consecutive newlines output as $k+1$ newlines—
      // unless they're before or after a more-indented line, or at the very
      // beginning or end, in which case $k$ maps to $k$.
      // Therefore, parse each chunk as newline(s) followed by a content line.
      var lineRe = /(\n+)([^\n]*)/g; // first line (possibly an empty line)

      var result = function () {
        var nextLF = string.indexOf('\n');
        nextLF = nextLF !== -1 ? nextLF : string.length;
        lineRe.lastIndex = nextLF;
        return foldLine(string.slice(0, nextLF), width);
      }(); // If we haven't reached the first content line yet, don't add an extra \n.


      var prevMoreIndented = string[0] === '\n' || string[0] === ' ';
      var moreIndented; // rest of the lines

      var match;

      while (match = lineRe.exec(string)) {
        var prefix = match[1],
            line = match[2];
        moreIndented = line[0] === ' ';
        result += prefix + (!prevMoreIndented && !moreIndented && line !== '' ? '\n' : '') + foldLine(line, width);
        prevMoreIndented = moreIndented;
      }

      return result;
    } // Greedy line breaking.
    // Picks the longest line under the limit each time,
    // otherwise settles for the shortest line over the limit.
    // NB. More-indented lines *cannot* be folded, as that would add an extra \n.


    function foldLine(line, width) {
      if (line === '' || line[0] === ' ') return line; // Since a more-indented line adds a \n, breaks can't be followed by a space.

      var breakRe = / [^ ]/g; // note: the match index will always be <= length-2.

      var match; // start is an inclusive index. end, curr, and next are exclusive.

      var start = 0,
          end,
          curr = 0,
          next = 0;
      var result = ''; // Invariants: 0 <= start <= length-1.
      //   0 <= curr <= next <= max(0, length-2). curr - start <= width.
      // Inside the loop:
      //   A match implies length >= 2, so curr and next are <= length-2.

      while (match = breakRe.exec(line)) {
        next = match.index; // maintain invariant: curr - start <= width

        if (next - start > width) {
          end = curr > start ? curr : next; // derive end <= length-2

          result += '\n' + line.slice(start, end); // skip the space that was output as \n

          start = end + 1; // derive start <= length-1
        }

        curr = next;
      } // By the invariants, start <= length-1, so there is something left over.
      // It is either the whole string or a part starting from non-whitespace.


      result += '\n'; // Insert a break if the remainder is too long and there is a break available.

      if (line.length - start > width && curr > start) {
        result += line.slice(start, curr) + '\n' + line.slice(curr + 1);
      } else {
        result += line.slice(start);
      }

      return result.slice(1); // drop extra \n joiner
    } // Escapes a double-quoted string.


    function escapeString(string) {
      var result = '';
      var char, nextChar;
      var escapeSeq;

      for (var i = 0; i < string.length; i++) {
        char = string.charCodeAt(i); // Check for surrogate pairs (reference Unicode 3.0 section "3.7 Surrogates").

        if (char >= 0xD800 && char <= 0xDBFF
        /* high surrogate */
        ) {
            nextChar = string.charCodeAt(i + 1);

            if (nextChar >= 0xDC00 && nextChar <= 0xDFFF
            /* low surrogate */
            ) {
                // Combine the surrogate pair and store it escaped.
                result += encodeHex((char - 0xD800) * 0x400 + nextChar - 0xDC00 + 0x10000); // Advance index one extra since we already used that char here.

                i++;
                continue;
              }
          }

        escapeSeq = ESCAPE_SEQUENCES[char];
        result += !escapeSeq && isPrintable(char) ? string[i] : escapeSeq || encodeHex(char);
      }

      return result;
    }

    function writeFlowSequence(state, level, object) {
      var _result = '',
          _tag = state.tag,
          index,
          length;

      for (index = 0, length = object.length; index < length; index += 1) {
        // Write only valid elements.
        if (writeNode(state, level, object[index], false, false)) {
          if (index !== 0) _result += ',' + (!state.condenseFlow ? ' ' : '');
          _result += state.dump;
        }
      }

      state.tag = _tag;
      state.dump = '[' + _result + ']';
    }

    function writeBlockSequence(state, level, object, compact) {
      var _result = '',
          _tag = state.tag,
          index,
          length;

      for (index = 0, length = object.length; index < length; index += 1) {
        // Write only valid elements.
        if (writeNode(state, level + 1, object[index], true, true)) {
          if (!compact || index !== 0) {
            _result += generateNextLine(state, level);
          }

          if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
            _result += '-';
          } else {
            _result += '- ';
          }

          _result += state.dump;
        }
      }

      state.tag = _tag;
      state.dump = _result || '[]'; // Empty sequence if no valid values.
    }

    function writeFlowMapping(state, level, object) {
      var _result = '',
          _tag = state.tag,
          objectKeyList = Object.keys(object),
          index,
          length,
          objectKey,
          objectValue,
          pairBuffer;

      for (index = 0, length = objectKeyList.length; index < length; index += 1) {
        pairBuffer = '';
        if (index !== 0) pairBuffer += ', ';
        if (state.condenseFlow) pairBuffer += '"';
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];

        if (!writeNode(state, level, objectKey, false, false)) {
          continue; // Skip this pair because of invalid key;
        }

        if (state.dump.length > 1024) pairBuffer += '? ';
        pairBuffer += state.dump + (state.condenseFlow ? '"' : '') + ':' + (state.condenseFlow ? '' : ' ');

        if (!writeNode(state, level, objectValue, false, false)) {
          continue; // Skip this pair because of invalid value.
        }

        pairBuffer += state.dump; // Both key and value are valid.

        _result += pairBuffer;
      }

      state.tag = _tag;
      state.dump = '{' + _result + '}';
    }

    function writeBlockMapping(state, level, object, compact) {
      var _result = '',
          _tag = state.tag,
          objectKeyList = Object.keys(object),
          index,
          length,
          objectKey,
          objectValue,
          explicitPair,
          pairBuffer; // Allow sorting keys so that the output file is deterministic

      if (state.sortKeys === true) {
        // Default sorting
        objectKeyList.sort();
      } else if (typeof state.sortKeys === 'function') {
        // Custom sort function
        objectKeyList.sort(state.sortKeys);
      } else if (state.sortKeys) {
        // Something is wrong
        throw new exception('sortKeys must be a boolean or a function');
      }

      for (index = 0, length = objectKeyList.length; index < length; index += 1) {
        pairBuffer = '';

        if (!compact || index !== 0) {
          pairBuffer += generateNextLine(state, level);
        }

        objectKey = objectKeyList[index];
        objectValue = object[objectKey];

        if (!writeNode(state, level + 1, objectKey, true, true, true)) {
          continue; // Skip this pair because of invalid key.
        }

        explicitPair = state.tag !== null && state.tag !== '?' || state.dump && state.dump.length > 1024;

        if (explicitPair) {
          if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
            pairBuffer += '?';
          } else {
            pairBuffer += '? ';
          }
        }

        pairBuffer += state.dump;

        if (explicitPair) {
          pairBuffer += generateNextLine(state, level);
        }

        if (!writeNode(state, level + 1, objectValue, true, explicitPair)) {
          continue; // Skip this pair because of invalid value.
        }

        if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
          pairBuffer += ':';
        } else {
          pairBuffer += ': ';
        }

        pairBuffer += state.dump; // Both key and value are valid.

        _result += pairBuffer;
      }

      state.tag = _tag;
      state.dump = _result || '{}'; // Empty mapping if no valid pairs.
    }

    function detectType(state, object, explicit) {
      var _result, typeList, index, length, type, style;

      typeList = explicit ? state.explicitTypes : state.implicitTypes;

      for (index = 0, length = typeList.length; index < length; index += 1) {
        type = typeList[index];

        if ((type.instanceOf || type.predicate) && (!type.instanceOf || typeof object === 'object' && object instanceof type.instanceOf) && (!type.predicate || type.predicate(object))) {
          state.tag = explicit ? type.tag : '?';

          if (type.represent) {
            style = state.styleMap[type.tag] || type.defaultStyle;

            if (_toString.call(type.represent) === '[object Function]') {
              _result = type.represent(object, style);
            } else if (_hasOwnProperty.call(type.represent, style)) {
              _result = type.represent[style](object, style);
            } else {
              throw new exception('!<' + type.tag + '> tag resolver accepts not "' + style + '" style');
            }

            state.dump = _result;
          }

          return true;
        }
      }

      return false;
    } // Serializes `object` and writes it to global `result`.
    // Returns true on success, or false on invalid object.
    //


    function writeNode(state, level, object, block, compact, iskey) {
      state.tag = null;
      state.dump = object;

      if (!detectType(state, object, false)) {
        detectType(state, object, true);
      }

      var type = _toString.call(state.dump);

      if (block) {
        block = state.flowLevel < 0 || state.flowLevel > level;
      }

      var objectOrArray = type === '[object Object]' || type === '[object Array]',
          duplicateIndex,
          duplicate;

      if (objectOrArray) {
        duplicateIndex = state.duplicates.indexOf(object);
        duplicate = duplicateIndex !== -1;
      }

      if (state.tag !== null && state.tag !== '?' || duplicate || state.indent !== 2 && level > 0) {
        compact = false;
      }

      if (duplicate && state.usedDuplicates[duplicateIndex]) {
        state.dump = '*ref_' + duplicateIndex;
      } else {
        if (objectOrArray && duplicate && !state.usedDuplicates[duplicateIndex]) {
          state.usedDuplicates[duplicateIndex] = true;
        }

        if (type === '[object Object]') {
          if (block && Object.keys(state.dump).length !== 0) {
            writeBlockMapping(state, level, state.dump, compact);

            if (duplicate) {
              state.dump = '&ref_' + duplicateIndex + state.dump;
            }
          } else {
            writeFlowMapping(state, level, state.dump);

            if (duplicate) {
              state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
            }
          }
        } else if (type === '[object Array]') {
          var arrayLevel = state.noArrayIndent && level > 0 ? level - 1 : level;

          if (block && state.dump.length !== 0) {
            writeBlockSequence(state, arrayLevel, state.dump, compact);

            if (duplicate) {
              state.dump = '&ref_' + duplicateIndex + state.dump;
            }
          } else {
            writeFlowSequence(state, arrayLevel, state.dump);

            if (duplicate) {
              state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
            }
          }
        } else if (type === '[object String]') {
          if (state.tag !== '?') {
            writeScalar(state, state.dump, level, iskey);
          }
        } else {
          if (state.skipInvalid) return false;
          throw new exception('unacceptable kind of an object to dump ' + type);
        }

        if (state.tag !== null && state.tag !== '?') {
          state.dump = '!<' + state.tag + '> ' + state.dump;
        }
      }

      return true;
    }

    function getDuplicateReferences(object, state) {
      var objects = [],
          duplicatesIndexes = [],
          index,
          length;
      inspectNode(object, objects, duplicatesIndexes);

      for (index = 0, length = duplicatesIndexes.length; index < length; index += 1) {
        state.duplicates.push(objects[duplicatesIndexes[index]]);
      }

      state.usedDuplicates = new Array(length);
    }

    function inspectNode(object, objects, duplicatesIndexes) {
      var objectKeyList, index, length;

      if (object !== null && typeof object === 'object') {
        index = objects.indexOf(object);

        if (index !== -1) {
          if (duplicatesIndexes.indexOf(index) === -1) {
            duplicatesIndexes.push(index);
          }
        } else {
          objects.push(object);

          if (Array.isArray(object)) {
            for (index = 0, length = object.length; index < length; index += 1) {
              inspectNode(object[index], objects, duplicatesIndexes);
            }
          } else {
            objectKeyList = Object.keys(object);

            for (index = 0, length = objectKeyList.length; index < length; index += 1) {
              inspectNode(object[objectKeyList[index]], objects, duplicatesIndexes);
            }
          }
        }
      }
    }

    function dump$1(input, options) {
      options = options || {};
      var state = new State(options);
      if (!state.noRefs) getDuplicateReferences(input, state);
      if (writeNode(state, 0, input, true, true)) return state.dump + '\n';
      return '';
    }

    function safeDump$1(input, options) {
      return dump$1(input, common.extend({
        schema: default_safe
      }, options));
    }

    var dump_1 = dump$1;
    var safeDump_1 = safeDump$1;
    var dumper = {
      dump: dump_1,
      safeDump: safeDump_1
    };

    function deprecated(name) {
      return function () {
        throw new Error('Function ' + name + ' is deprecated and cannot be used.');
      };
    }

    var Type = type;
    var Schema = schema;
    var FAILSAFE_SCHEMA = failsafe;
    var JSON_SCHEMA = json;
    var CORE_SCHEMA = core;
    var DEFAULT_SAFE_SCHEMA = default_safe;
    var DEFAULT_FULL_SCHEMA = default_full;
    var load = loader.load;
    var loadAll = loader.loadAll;
    var safeLoad = loader.safeLoad;
    var safeLoadAll = loader.safeLoadAll;
    var dump = dumper.dump;
    var safeDump = dumper.safeDump;
    var YAMLException = exception; // Deprecated schema names from JS-YAML 2.0.x

    var MINIMAL_SCHEMA = failsafe;
    var SAFE_SCHEMA = default_safe;
    var DEFAULT_SCHEMA = default_full; // Deprecated functions from JS-YAML 1.x.x

    var scan = deprecated('scan');
    var parse = deprecated('parse');
    var compose = deprecated('compose');
    var addConstructor = deprecated('addConstructor');
    var jsYaml$1 = {
      Type: Type,
      Schema: Schema,
      FAILSAFE_SCHEMA: FAILSAFE_SCHEMA,
      JSON_SCHEMA: JSON_SCHEMA,
      CORE_SCHEMA: CORE_SCHEMA,
      DEFAULT_SAFE_SCHEMA: DEFAULT_SAFE_SCHEMA,
      DEFAULT_FULL_SCHEMA: DEFAULT_FULL_SCHEMA,
      load: load,
      loadAll: loadAll,
      safeLoad: safeLoad,
      safeLoadAll: safeLoadAll,
      dump: dump,
      safeDump: safeDump,
      YAMLException: YAMLException,
      MINIMAL_SCHEMA: MINIMAL_SCHEMA,
      SAFE_SCHEMA: SAFE_SCHEMA,
      DEFAULT_SCHEMA: DEFAULT_SCHEMA,
      scan: scan,
      parse: parse,
      compose: compose,
      addConstructor: addConstructor
    };

    var jsYaml = jsYaml$1;

    function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

    function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
    /**
     * Redirect - object used to redirect some requests
     * e.g.
     * {
     *      title: 1x1-transparent.gif
     *      comment: http://probablyprogramming.com/2009/03/15/the-tiniest-gif-ever
     *      contentType: image/gif;base64
     *      content: R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==
     * }
     * @typedef {Object} Redirect
     * @property {string} title
     * @property {string} comment
     * @property {string} content
     * @property {string} contentType
     * @property {boolean} [isBlocking]
     * @property {string} [sha]
     */

    var Redirects = /*#__PURE__*/function () {
      /**
       * Converts rawYaml into JS object with sources titles used as keys
       * @param rawYaml
       * @returns {Object<Redirect>} - return object with titles in the keys and RedirectSources
       * in the values
       */
      function Redirects(rawYaml) {
        classCallCheck(this, Redirects);

        try {
          var arrOfRedirects = jsYaml.safeLoad(rawYaml);
          this.redirects = arrOfRedirects.reduce(function (acc, redirect) {
            return _objectSpread(_objectSpread({}, acc), {}, defineProperty({}, redirect.title, redirect));
          }, {});
        } catch (e) {
          // eslint-disable-next-line no-console
          console.log("Was unable to load YAML into JS due to: ".concat(e.message));
          throw e;
        }
      }
      /**
       * Returns redirect source object
       * @param {string} title
       * @return {Redirect}
       */


      createClass(Redirects, [{
        key: "getRedirect",
        value: function getRedirect(title) {
          var _this = this;

          if (Object.prototype.hasOwnProperty.call(this.redirects, title)) {
            return this.redirects[title];
          } // look title among aliases


          var values = Object.keys(this.redirects).map(function (key) {
            return _this.redirects[key];
          });
          return values.find(function (redirect) {
            var aliases = redirect.aliases;

            if (!aliases) {
              return false;
            }

            return aliases.indexOf(title) > -1;
          });
        }
      }]);

      return Redirects;
    }();

    var redirectsMap = {
      "1x1-transparent.gif": "1x1-transparent.gif",
      "1x1.gif": "1x1-transparent.gif",
      "1x1-transparent-gif": "1x1-transparent.gif",
      "2x2-transparent.png": "2x2-transparent.png",
      "2x2.png": "2x2-transparent.png",
      "2x2-transparent-png": "2x2-transparent.png",
      "3x2-transparent.png": "3x2-transparent.png",
      "3x2.png": "3x2-transparent.png",
      "3x2-transparent-png": "3x2-transparent.png",
      "32x32-transparent.png": "32x32-transparent.png",
      "32x32.png": "32x32-transparent.png",
      "32x32-transparent-png": "32x32-transparent.png",
      noopframe: "noopframe.html",
      "noop.html": "noopframe.html",
      "blank-html": "noopframe.html",
      noopcss: "noopcss.css",
      "blank-css": "noopcss.css",
      noopjs: "noopjs.js",
      "noop.js": "noopjs.js",
      "blank-js": "noopjs.js",
      noopjson: "noopjson.json",
      nooptext: "nooptext.js",
      "noop.txt": "nooptext.js",
      "blank-text": "nooptext.js",
      empty: "nooptext.js",
      "noopvmap-1.0": "noopvmap01.xml",
      "noop-vmap1.0.xml": "noopvmap01.xml",
      "noopvast-2.0": "noopvast02.xml",
      "noopvast-3.0": "noopvast03.xml",
      "noopvast-4.0": "noopvast04.xml",
      "noopmp3-0.1s": "noopmp3.mp3",
      "blank-mp3": "noopmp3.mp3",
      "noopmp4-1s": "noopmp4.mp4",
      "noop-1s.mp4": "noopmp4.mp4",
      "blank-mp4": "noopmp4.mp4",
      "click2load.html": "click2load.html",
      "ubo-click2load.html": "click2load.html",
      "amazon-apstag": "amazon-apstag.js",
      "ubo-amazon_apstag.js": "amazon-apstag.js",
      "amazon_apstag.js": "amazon-apstag.js",
      "ati-smarttag": "ati-smarttag.js",
      "didomi-loader": "didomi-loader.js",
      fingerprintjs2: "fingerprintjs2.js",
      "ubo-fingerprint2.js": "fingerprintjs2.js",
      "fingerprint2.js": "fingerprintjs2.js",
      fingerprintjs3: "fingerprintjs3.js",
      "ubo-fingerprint3.js": "fingerprintjs3.js",
      "fingerprint3.js": "fingerprintjs3.js",
      gemius: "gemius.js",
      "google-analytics-ga": "google-analytics-ga.js",
      "ubo-google-analytics_ga.js": "google-analytics-ga.js",
      "google-analytics_ga.js": "google-analytics-ga.js",
      "google-analytics": "google-analytics.js",
      "ubo-google-analytics_analytics.js": "google-analytics.js",
      "google-analytics_analytics.js": "google-analytics.js",
      "googletagmanager-gtm": "google-analytics.js",
      "ubo-googletagmanager_gtm.js": "google-analytics.js",
      "googletagmanager_gtm.js": "google-analytics.js",
      "google-ima3": "google-ima3.js",
      "googlesyndication-adsbygoogle": "googlesyndication-adsbygoogle.js",
      "ubo-googlesyndication_adsbygoogle.js": "googlesyndication-adsbygoogle.js",
      "googlesyndication_adsbygoogle.js": "googlesyndication-adsbygoogle.js",
      "googletagservices-gpt": "googletagservices-gpt.js",
      "ubo-googletagservices_gpt.js": "googletagservices-gpt.js",
      "googletagservices_gpt.js": "googletagservices-gpt.js",
      matomo: "matomo.js",
      "metrika-yandex-tag": "metrika-yandex-tag.js",
      "metrika-yandex-watch": "metrika-yandex-watch.js",
      "naver-wcslog": "naver-wcslog.js",
      noeval: "noeval.js",
      "noeval.js": "noeval.js",
      "silent-noeval.js": "noeval.js",
      "ubo-noeval.js": "noeval.js",
      "ubo-silent-noeval.js": "noeval.js",
      "ubo-noeval": "noeval.js",
      "ubo-silent-noeval": "noeval.js",
      "pardot-1.0": "pardot-1.0.js",
      "prebid-ads": "prebid-ads.js",
      "ubo-prebid-ads.js": "prebid-ads.js",
      "prebid-ads.js": "prebid-ads.js",
      prebid: "prebid.js",
      "prevent-bab": "prevent-bab.js",
      "nobab.js": "prevent-bab.js",
      "ubo-nobab.js": "prevent-bab.js",
      "bab-defuser.js": "prevent-bab.js",
      "ubo-bab-defuser.js": "prevent-bab.js",
      "ubo-nobab": "prevent-bab.js",
      "ubo-bab-defuser": "prevent-bab.js",
      "prevent-bab2": "prevent-bab2.js",
      "nobab2.js": "prevent-bab2.js",
      "prevent-fab-3.2.0": "prevent-fab-3.2.0.js",
      "nofab.js": "prevent-fab-3.2.0.js",
      "ubo-nofab.js": "prevent-fab-3.2.0.js",
      "fuckadblock.js-3.2.0": "prevent-fab-3.2.0.js",
      "ubo-fuckadblock.js-3.2.0": "prevent-fab-3.2.0.js",
      "ubo-nofab": "prevent-fab-3.2.0.js",
      "prevent-popads-net": "prevent-popads-net.js",
      "popads.net.js": "prevent-popads-net.js",
      "ubo-popads.net.js": "prevent-popads-net.js",
      "ubo-popads.net": "prevent-popads-net.js",
      "scorecardresearch-beacon": "scorecardresearch-beacon.js",
      "ubo-scorecardresearch_beacon.js": "scorecardresearch-beacon.js",
      "scorecardresearch_beacon.js": "scorecardresearch-beacon.js",
      "set-popads-dummy": "set-popads-dummy.js",
      "popads-dummy.js": "set-popads-dummy.js",
      "ubo-popads-dummy.js": "set-popads-dummy.js",
      "ubo-popads-dummy": "set-popads-dummy.js"
    };

    /**
     * Finds redirect resource by it's name
     * @param {string} name - redirect name
     */

    var getRedirectByName = function getRedirectByName(name) {
      var redirects = Object.keys(redirectsList).map(function (key) {
        return redirectsList[key];
      });
      return redirects.find(function (r) {
        return r.names && r.names.indexOf(name) > -1;
      });
    };
    /**
     * @typedef {Object} Source - redirect properties
     * @property {string} name redirect name
     * @property {Array<string>} args Arguments for redirect function
     * @property {'extension'|'test'} [engine] -
     * Defines the final form of redirect string presentation
     * @property {boolean} [verbose] flag to enable printing to console debug information
     */

    /**
     * Returns redirect code by param
     * @param {Source} source
     * @returns {string} redirect code
     */


    var getRedirectCode = function getRedirectCode(source) {
      var redirect = getRedirectByName(source.name);
      var result = attachDependencies(redirect);
      result = addCall(redirect, result); // redirect code for different sources is checked in tests
      // so it should be just a code without any source and props passed

      result = source.engine === 'test' ? wrapInNonameFunc(result) : passSourceAndProps(source, result, true);
      return result;
    };

    var getRedirectFilename = function getRedirectFilename(name) {
      return redirectsMap[name];
    };

    var redirects = {
      Redirects: Redirects,
      getRedirectFilename: getRedirectFilename,
      getCode: getRedirectCode,
      isAdgRedirectRule: validator.isAdgRedirectRule,
      isValidAdgRedirectRule: validator.isValidAdgRedirectRule,
      isAdgRedirectCompatibleWithUbo: validator.isAdgRedirectCompatibleWithUbo,
      isUboRedirectCompatibleWithAdg: validator.isUboRedirectCompatibleWithAdg,
      isAbpRedirectCompatibleWithAdg: validator.isAbpRedirectCompatibleWithAdg,
      convertUboRedirectToAdg: convertUboRedirectToAdg,
      convertAbpRedirectToAdg: convertAbpRedirectToAdg,
      convertRedirectToAdg: convertRedirectToAdg,
      convertAdgRedirectToUbo: convertAdgRedirectToUbo
    };

    function abortCurrentInlineScript(source, args) {
      function abortCurrentInlineScript(source, property, search) {
        var searchRegexp = toRegExp(search);
        var rid = randomId();
        var SRC_DATA_MARKER = "data:text/javascript;base64,";

        var getCurrentScript = function getCurrentScript() {
          if ("currentScript" in document) {
            return document.currentScript;
          }

          var scripts = document.getElementsByTagName("script");
          return scripts[scripts.length - 1];
        };

        var ourScript = getCurrentScript();

        var abort = function abort() {
          var scriptEl = getCurrentScript();

          if (!scriptEl) {
            return;
          }

          var content = scriptEl.textContent;

          try {
            var textContentGetter = Object.getOwnPropertyDescriptor(Node.prototype, "textContent").get;
            content = textContentGetter.call(scriptEl);
          } catch (e) {}

          if (content.length === 0 && typeof scriptEl.src !== "undefined" && startsWith(scriptEl.src, SRC_DATA_MARKER)) {
            var encodedContent = scriptEl.src.slice(SRC_DATA_MARKER.length);
            content = window.atob(encodedContent);
          }

          if (scriptEl instanceof HTMLScriptElement && content.length > 0 && scriptEl !== ourScript && searchRegexp.test(content)) {
            hit(source);
            throw new ReferenceError(rid);
          }
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (base instanceof Object === false && base === null) {
            var props = property.split(".");
            var propIndex = props.indexOf(prop);
            var baseName = props[propIndex - 1];
            console.log("The scriptlet had been executed before the ".concat(baseName, " was loaded."));
            return;
          }

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          var currentValue = base[prop];
          var origDescriptor = Object.getOwnPropertyDescriptor(base, prop);

          if (origDescriptor instanceof Object === false || origDescriptor.get instanceof Function === false) {
            currentValue = base[prop];
            origDescriptor = undefined;
          }

          var descriptorWrapper = Object.assign(getDescriptorAddon(), {
            currentValue: currentValue,
            get: function get() {
              if (!this.isAbortingSuspended) {
                this.isolateCallback(abort);
              }

              if (origDescriptor instanceof Object) {
                return origDescriptor.get.call(base);
              }

              return this.currentValue;
            },
            set: function set(newValue) {
              if (!this.isAbortingSuspended) {
                this.isolateCallback(abort);
              }

              if (origDescriptor instanceof Object) {
                origDescriptor.set.call(base, newValue);
              } else {
                this.currentValue = newValue;
              }
            }
          });
          setPropertyAccess(base, prop, {
            get: function get() {
              return descriptorWrapper.get.call(descriptorWrapper);
            },
            set: function set(newValue) {
              descriptorWrapper.set.call(descriptorWrapper, newValue);
            }
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function startsWith(str, prefix) {
        return !!str && str.indexOf(prefix) === 0;
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function getDescriptorAddon() {
        return {
          isAbortingSuspended: false,
          isolateCallback: function isolateCallback(cb) {
            this.isAbortingSuspended = true;

            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            var result = cb.apply(void 0, args);
            this.isAbortingSuspended = false;
            return result;
          }
        };
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        abortCurrentInlineScript.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function abortOnPropertyRead(source, args) {
      function abortOnPropertyRead(source, property) {
        if (!property) {
          return;
        }

        var rid = randomId();

        var abort = function abort() {
          hit(source);
          throw new ReferenceError(rid);
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          setPropertyAccess(base, prop, {
            get: abort,
            set: function set() {}
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        abortOnPropertyRead.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function abortOnPropertyWrite(source, args) {
      function abortOnPropertyWrite(source, property) {
        if (!property) {
          return;
        }

        var rid = randomId();

        var abort = function abort() {
          hit(source);
          throw new ReferenceError(rid);
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          setPropertyAccess(base, prop, {
            set: abort
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        abortOnPropertyWrite.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function abortOnStackTrace(source, args) {
      function abortOnStackTrace(source, property, stack) {
        if (!property || !stack) {
          return;
        }

        var rid = randomId();

        var abort = function abort() {
          hit(source);
          throw new ReferenceError(rid);
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          if (!isValidStrPattern(stack)) {
            console.log("Invalid parameter: ".concat(stack));
            return;
          }

          var descriptorWrapper = Object.assign(getDescriptorAddon(), {
            value: base[prop],
            get: function get() {
              if (!this.isAbortingSuspended && this.isolateCallback(matchStackTrace, stack, new Error().stack)) {
                abort();
              }

              return this.value;
            },
            set: function set(newValue) {
              if (!this.isAbortingSuspended && this.isolateCallback(matchStackTrace, stack, new Error().stack)) {
                abort();
              }

              this.value = newValue;
            }
          });
          setPropertyAccess(base, prop, {
            get: function get() {
              return descriptorWrapper.get.call(descriptorWrapper);
            },
            set: function set(newValue) {
              descriptorWrapper.set.call(descriptorWrapper, newValue);
            }
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function matchStackTrace(stackMatch, stackTrace) {
        if (!stackMatch || stackMatch === "") {
          return true;
        }

        var stackRegexp = toRegExp(stackMatch);
        var refinedStackTrace = stackTrace.split("\n").slice(2).map(function (line) {
          return line.trim();
        }).join("\n");
        return getNativeRegexpTest().call(stackRegexp, refinedStackTrace);
      }

      function getDescriptorAddon() {
        return {
          isAbortingSuspended: false,
          isolateCallback: function isolateCallback(cb) {
            this.isAbortingSuspended = true;

            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            var result = cb.apply(void 0, args);
            this.isAbortingSuspended = false;
            return result;
          }
        };
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function getNativeRegexpTest() {
        return Object.getOwnPropertyDescriptor(RegExp.prototype, "test").value;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        abortOnStackTrace.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function adjustSetInterval(source, args) {
      function adjustSetInterval(source, matchCallback, matchDelay, boost) {
        var nativeSetInterval = window.setInterval;
        var matchRegexp = toRegExp(matchCallback);

        var intervalWrapper = function intervalWrapper(callback, delay) {
          if (!isValidCallback(callback)) {
            if (source.verbose) {
              console.log("Scriptlet adjust-setInterval can not be applied because of invalid callback: '".concat(String(callback), "'."));
            }
          } else if (matchRegexp.test(callback.toString()) && isDelayMatched(matchDelay, delay)) {
            delay *= getBoostMultiplier(boost);
            hit(source);
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeSetInterval.apply(window, [callback, delay].concat(args));
        };

        window.setInterval = intervalWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function isValidCallback(callback) {
        return callback instanceof Function || typeof callback === "string";
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function getBoostMultiplier(boost) {
        var DEFAULT_MULTIPLIER = .05;
        var MIN_MULTIPLIER = .02;
        var MAX_MULTIPLIER = 50;
        var parsedBoost = parseFloat(boost);
        var boostMultiplier = nativeIsNaN(parsedBoost) || !nativeIsFinite(parsedBoost) ? DEFAULT_MULTIPLIER : parsedBoost;

        if (boostMultiplier < MIN_MULTIPLIER) {
          boostMultiplier = MIN_MULTIPLIER;
        }

        if (boostMultiplier > MAX_MULTIPLIER) {
          boostMultiplier = MAX_MULTIPLIER;
        }

        return boostMultiplier;
      }

      function isDelayMatched(inputDelay, realDelay) {
        return shouldMatchAnyDelay(inputDelay) || realDelay === getMatchDelay(inputDelay);
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function nativeIsFinite(num) {
        var native = Number.isFinite || window.isFinite;
        return native(num);
      }

      function getMatchDelay(delay) {
        var DEFAULT_DELAY = 1e3;
        var parsedDelay = parseInt(delay, 10);
        var delayMatch = nativeIsNaN(parsedDelay) ? DEFAULT_DELAY : parsedDelay;
        return delayMatch;
      }

      function getWildcardSymbol() {
        return "*";
      }

      function shouldMatchAnyDelay(delay) {
        return delay === getWildcardSymbol();
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        adjustSetInterval.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function adjustSetTimeout(source, args) {
      function adjustSetTimeout(source, matchCallback, matchDelay, boost) {
        var nativeSetTimeout = window.setTimeout;
        var matchRegexp = toRegExp(matchCallback);

        var timeoutWrapper = function timeoutWrapper(callback, delay) {
          if (!isValidCallback(callback)) {
            if (source.verbose) {
              console.log("Scriptlet adjust-setTimeout can not be applied because of invalid callback: '".concat(String(callback), "'."));
            }
          } else if (matchRegexp.test(callback.toString()) && isDelayMatched(matchDelay, delay)) {
            delay *= getBoostMultiplier(boost);
            hit(source);
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeSetTimeout.apply(window, [callback, delay].concat(args));
        };

        window.setTimeout = timeoutWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function isValidCallback(callback) {
        return callback instanceof Function || typeof callback === "string";
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function getBoostMultiplier(boost) {
        var DEFAULT_MULTIPLIER = .05;
        var MIN_MULTIPLIER = .02;
        var MAX_MULTIPLIER = 50;
        var parsedBoost = parseFloat(boost);
        var boostMultiplier = nativeIsNaN(parsedBoost) || !nativeIsFinite(parsedBoost) ? DEFAULT_MULTIPLIER : parsedBoost;

        if (boostMultiplier < MIN_MULTIPLIER) {
          boostMultiplier = MIN_MULTIPLIER;
        }

        if (boostMultiplier > MAX_MULTIPLIER) {
          boostMultiplier = MAX_MULTIPLIER;
        }

        return boostMultiplier;
      }

      function isDelayMatched(inputDelay, realDelay) {
        return shouldMatchAnyDelay(inputDelay) || realDelay === getMatchDelay(inputDelay);
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function nativeIsFinite(num) {
        var native = Number.isFinite || window.isFinite;
        return native(num);
      }

      function getMatchDelay(delay) {
        var DEFAULT_DELAY = 1e3;
        var parsedDelay = parseInt(delay, 10);
        var delayMatch = nativeIsNaN(parsedDelay) ? DEFAULT_DELAY : parsedDelay;
        return delayMatch;
      }

      function getWildcardSymbol() {
        return "*";
      }

      function shouldMatchAnyDelay(delay) {
        return delay === getWildcardSymbol();
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        adjustSetTimeout.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function debugCurrentInlineScript(source, args) {
      function debugCurrentInlineScript(source, property, search) {
        var searchRegexp = toRegExp(search);
        var rid = randomId();

        var getCurrentScript = function getCurrentScript() {
          if ("currentScript" in document) {
            return document.currentScript;
          }

          var scripts = document.getElementsByTagName("script");
          return scripts[scripts.length - 1];
        };

        var ourScript = getCurrentScript();

        var abort = function abort() {
          var scriptEl = getCurrentScript();

          if (!scriptEl) {
            return;
          }

          var content = scriptEl.textContent;

          try {
            var textContentGetter = Object.getOwnPropertyDescriptor(Node.prototype, "textContent").get;
            content = textContentGetter.call(scriptEl);
          } catch (e) {}

          if (scriptEl instanceof HTMLScriptElement && content.length > 0 && scriptEl !== ourScript && searchRegexp.test(content)) {
            hit(source);
            debugger;
          }
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (base instanceof Object === false && base === null) {
            var props = property.split(".");
            var propIndex = props.indexOf(prop);
            var baseName = props[propIndex - 1];
            console.log("The scriptlet had been executed before the ".concat(baseName, " was loaded."));
            return;
          }

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          var currentValue = base[prop];
          setPropertyAccess(base, prop, {
            set: function set(value) {
              abort();
              currentValue = value;
            },
            get: function get() {
              abort();
              return currentValue;
            }
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        debugCurrentInlineScript.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function debugOnPropertyRead(source, args) {
      function debugOnPropertyRead(source, property) {
        if (!property) {
          return;
        }

        var rid = randomId();

        var abort = function abort() {
          hit(source);
          debugger;
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          setPropertyAccess(base, prop, {
            get: abort,
            set: noopFunc
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        debugOnPropertyRead.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function debugOnPropertyWrite(source, args) {
      function debugOnPropertyWrite(source, property) {
        if (!property) {
          return;
        }

        var rid = randomId();

        var abort = function abort() {
          hit(source);
          debugger;
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          setPropertyAccess(base, prop, {
            set: abort
          });
        };

        setChainPropAccess(window, property);
        window.onerror = createOnErrorHandler(rid).bind();
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        debugOnPropertyWrite.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function dirString(source, args) {
      function dirString(source, times) {
        var _console = console,
            dir = _console.dir;
        times = parseInt(times, 10);

        function dirWrapper(object) {
          var temp;

          for (var i = 0; i < times; i += 1) {
            temp = "".concat(object);
          }

          if (typeof dir === "function") {
            dir.call(this, object);
          }

          hit(source, temp);
        }

        console.dir = dirWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        dirString.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function disableNewtabLinks(source, args) {
      function disableNewtabLinks(source) {
        document.addEventListener("click", function (ev) {
          var target = ev.target;

          while (target !== null) {
            if (target.localName === "a" && target.hasAttribute("target")) {
              ev.stopPropagation();
              ev.preventDefault();
              hit(source);
              break;
            }

            target = target.parentNode;
          }
        });
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        disableNewtabLinks.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function forceWindowClose(source, args) {
      function forceWindowClose(source) {
        var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
        var log = console.log.bind(console);

        if (typeof window.close !== "function") {
          if (source.verbose) {
            log("window.close() is not a function so 'close-window' scriptlet is unavailable");
          }

          return;
        }

        var closeImmediately = function closeImmediately() {
          try {
            hit(source);
            window.close();
          } catch (e) {
            log(e);
          }
        };

        var closeByExtension = function closeByExtension() {
          var extCall = function extCall() {
            dispatchEvent(new Event("adguard:scriptlet-close-window"));
          };

          window.addEventListener("adguard:subscribed-to-close-window", extCall, {
            once: true
          });
          setTimeout(function () {
            window.removeEventListener("adguard:subscribed-to-close-window", extCall, {
              once: true
            });
          }, 5e3);
        };

        var shouldClose = function shouldClose() {
          if (path === "") {
            return true;
          }

          var pathRegexp = toRegExp(path);
          var currentPath = "".concat(window.location.pathname).concat(window.location.search);
          return pathRegexp.test(currentPath);
        };

        if (shouldClose()) {
          closeImmediately();

          if (navigator.userAgent.indexOf("Chrome") > -1) {
            closeByExtension();
          }
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        forceWindowClose.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function hideInShadowDom(source, args) {
      function hideInShadowDom(source, selector, baseSelector) {
        if (!Element.prototype.attachShadow) {
          return;
        }

        var hideElement = function hideElement(targetElement) {
          var DISPLAY_NONE_CSS = "display:none!important;";
          targetElement.style.cssText = DISPLAY_NONE_CSS;
        };

        var hideHandler = function hideHandler() {
          var hostElements = !baseSelector ? findHostElements(document.documentElement) : document.querySelectorAll(baseSelector);

          while (hostElements.length !== 0) {
            var isHidden = false;

            var _pierceShadowDom = pierceShadowDom(selector, hostElements),
                targets = _pierceShadowDom.targets,
                innerHosts = _pierceShadowDom.innerHosts;

            targets.forEach(function (targetEl) {
              hideElement(targetEl);
              isHidden = true;
            });

            if (isHidden) {
              hit(source);
            }

            hostElements = innerHosts;
          }
        };

        hideHandler();
        observeDOMChanges(hideHandler, true);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function observeDOMChanges(callback) {
        var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var throttle = function throttle(method, delay) {
          var wait = false;
          var savedArgs;

          var wrapper = function wrapper() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            if (wait) {
              savedArgs = args;
              return;
            }

            method.apply(void 0, args);
            wait = true;
            setTimeout(function () {
              wait = false;

              if (savedArgs) {
                wrapper(savedArgs);
                savedArgs = null;
              }
            }, delay);
          };

          return wrapper;
        };

        var THROTTLE_DELAY_MS = 20;
        var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

        var connect = function connect() {
          if (attrsToObserve.length > 0) {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs,
              attributeFilter: attrsToObserve
            });
          } else {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs
            });
          }
        };

        var disconnect = function disconnect() {
          observer.disconnect();
        };

        function callbackWrapper() {
          disconnect();
          callback();
          connect();
        }

        connect();
      }

      function flatten(input) {
        var stack = [];
        input.forEach(function (el) {
          return stack.push(el);
        });
        var res = [];

        while (stack.length) {
          var next = stack.pop();

          if (Array.isArray(next)) {
            next.forEach(function (el) {
              return stack.push(el);
            });
          } else {
            res.push(next);
          }
        }

        return res.reverse();
      }

      function findHostElements(rootElement) {
        var hosts = [];
        var domElems = rootElement.querySelectorAll("*");
        domElems.forEach(function (el) {
          if (el.shadowRoot) {
            hosts.push(el);
          }
        });
        return hosts;
      }

      function pierceShadowDom(selector, hostElements) {
        var targets = [];
        var innerHostsAcc = [];
        hostElements.forEach(function (host) {
          var simpleElems = host.querySelectorAll(selector);
          targets = targets.concat([].slice.call(simpleElems));
          var shadowRootElem = host.shadowRoot;
          var shadowChildren = shadowRootElem.querySelectorAll(selector);
          targets = targets.concat([].slice.call(shadowChildren));
          innerHostsAcc.push(findHostElements(shadowRootElem));
        });
        var innerHosts = flatten(innerHostsAcc);
        return {
          targets: targets,
          innerHosts: innerHosts
        };
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        hideInShadowDom.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function jsonPrune(source, args) {
      function jsonPrune(source, propsToRemove, requiredInitialProps, stack) {
        if (!!stack && !matchStackTrace(stack, new Error().stack)) {
          return;
        }

        var log = console.log.bind(console);
        var prunePaths = propsToRemove !== undefined && propsToRemove !== "" ? propsToRemove.split(/ +/) : [];
        var requiredPaths = requiredInitialProps !== undefined && requiredInitialProps !== "" ? requiredInitialProps.split(/ +/) : [];

        function isPruningNeeded(root) {
          if (!root) {
            return false;
          }

          var shouldProcess;

          if (prunePaths.length === 0 && requiredPaths.length > 0) {
            var rootString = JSON.stringify(root);
            var matchRegex = toRegExp(requiredPaths.join(""));
            var shouldLog = matchRegex.test(rootString);

            if (shouldLog) {
              log(window.location.hostname, root);
              shouldProcess = false;
              return shouldProcess;
            }
          }

          for (var i = 0; i < requiredPaths.length; i += 1) {
            var requiredPath = requiredPaths[i];
            var lastNestedPropName = requiredPath.split(".").pop();
            var hasWildcard = requiredPath.indexOf(".*.") > -1 || requiredPath.indexOf("*.") > -1 || requiredPath.indexOf(".*") > -1 || requiredPath.indexOf(".[].") > -1 || requiredPath.indexOf("[].") > -1 || requiredPath.indexOf(".[]") > -1;
            var details = getWildcardPropertyInChain(root, requiredPath, hasWildcard);
            shouldProcess = !hasWildcard;

            for (var _i = 0; _i < details.length; _i += 1) {
              if (hasWildcard) {
                shouldProcess = !(details[_i].base[lastNestedPropName] === undefined) || shouldProcess;
              } else {
                shouldProcess = !(details[_i].base[lastNestedPropName] === undefined) && shouldProcess;
              }
            }
          }

          return shouldProcess;
        }

        var jsonPruner = function jsonPruner(root) {
          if (prunePaths.length === 0 && requiredPaths.length === 0) {
            log(window.location.hostname, root);
            return root;
          }

          try {
            if (isPruningNeeded(root) === false) {
              return root;
            }

            prunePaths.forEach(function (path) {
              var ownerObjArr = getWildcardPropertyInChain(root, path, true);
              ownerObjArr.forEach(function (ownerObj) {
                if (ownerObj !== undefined && ownerObj.base) {
                  delete ownerObj.base[ownerObj.prop];
                  hit(source);
                }
              });
            });
          } catch (e) {
            log(e.toString());
          }

          return root;
        };

        var nativeJSONParse = JSON.parse;

        var jsonParseWrapper = function jsonParseWrapper() {
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          var root = nativeJSONParse.apply(JSON, args);
          return jsonPruner(root);
        };

        jsonParseWrapper.toString = nativeJSONParse.toString.bind(nativeJSONParse);
        JSON.parse = jsonParseWrapper;
        var nativeResponseJson = Response.prototype.json;

        var responseJsonWrapper = function responseJsonWrapper() {
          var promise = nativeResponseJson.apply(this);
          return promise.then(function (obj) {
            return jsonPruner(obj);
          });
        };

        if (typeof Response === "undefined") {
          return;
        }

        Response.prototype.json = responseJsonWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function matchStackTrace(stackMatch, stackTrace) {
        if (!stackMatch || stackMatch === "") {
          return true;
        }

        var stackRegexp = toRegExp(stackMatch);
        var refinedStackTrace = stackTrace.split("\n").slice(2).map(function (line) {
          return line.trim();
        }).join("\n");
        return getNativeRegexpTest().call(stackRegexp, refinedStackTrace);
      }

      function getWildcardPropertyInChain(base, chain) {
        var lookThrough = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        var output = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
        var pos = chain.indexOf(".");

        if (pos === -1) {
          if (chain === getWildcardSymbol() || chain === "[]") {
            for (var key in base) {
              if (Object.prototype.hasOwnProperty.call(base, key)) {
                output.push({
                  base: base,
                  prop: key
                });
              }
            }
          } else {
            output.push({
              base: base,
              prop: chain
            });
          }

          return output;
        }

        var prop = chain.slice(0, pos);
        var shouldLookThrough = prop === "[]" && Array.isArray(base) || prop === getWildcardSymbol() && base instanceof Object;

        if (shouldLookThrough) {
          var nextProp = chain.slice(pos + 1);
          var baseKeys = Object.keys(base);
          baseKeys.forEach(function (key) {
            var item = base[key];
            getWildcardPropertyInChain(item, nextProp, lookThrough, output);
          });
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          getWildcardPropertyInChain(nextBase, chain, lookThrough, output);
        }

        return output;
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function getWildcardSymbol() {
        return "*";
      }

      function getNativeRegexpTest() {
        return Object.getOwnPropertyDescriptor(RegExp.prototype, "test").value;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        jsonPrune.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function log(source, args) {
      function log() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        console.log(args);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        log.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function logAddEventListener(source, args) {
      function logAddEventListener(source) {
        var log = console.log.bind(console);
        var nativeAddEventListener = window.EventTarget.prototype.addEventListener;

        function addEventListenerWrapper(type, listener) {
          if (validateType(type) && validateListener(listener)) {
            var logMessage = 'addEventListener("'.concat(type, '", ').concat(listenerToString(listener), ")");
            log(logMessage);
            hit(source);
          } else if (source.verbose) {
            var _logMessage = "Invalid event type or listener passed to addEventListener:\ntype: ".concat(convertTypeToString(type), "\nlistener: ").concat(convertTypeToString(listener));

            log(_logMessage);
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeAddEventListener.apply(this, [type, listener].concat(args));
        }

        window.EventTarget.prototype.addEventListener = addEventListenerWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function validateType(type) {
        return typeof type !== "undefined";
      }

      function validateListener(listener) {
        return typeof listener !== "undefined" && (typeof listener === "function" || typeof listener === "object" && listener !== null && typeof listener.handleEvent === "function");
      }

      function listenerToString(listener) {
        return typeof listener === "function" ? listener.toString() : listener.handleEvent.toString();
      }

      function convertTypeToString(value) {
        var output;

        if (typeof value === "undefined") {
          output = "undefined";
        } else if (typeof value === "object") {
          if (value === null) {
            output = "null";
          } else {
            output = objectToString(value);
          }
        } else {
          output = value.toString();
        }

        return output;
      }

      function objectToString(obj) {
        return isEmptyObject(obj) ? "{}" : getObjectEntries(obj).map(function (pair) {
          var key = pair[0];
          var value = pair[1];
          var recordValueStr = value;

          if (value instanceof Object) {
            recordValueStr = "{ ".concat(objectToString(value), " }");
          }

          return "".concat(key, ':"').concat(recordValueStr, '"');
        }).join(" ");
      }

      function isEmptyObject(obj) {
        return Object.keys(obj).length === 0;
      }

      function getObjectEntries(object) {
        var keys = Object.keys(object);
        var entries = [];
        keys.forEach(function (key) {
          return entries.push([key, object[key]]);
        });
        return entries;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        logAddEventListener.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function logEval(source, args) {
      function logEval(source) {
        var log = console.log.bind(console);
        var nativeEval = window.eval;

        function evalWrapper(str) {
          hit(source);
          log('eval("'.concat(str, '")'));
          return nativeEval(str);
        }

        window.eval = evalWrapper;
        var nativeFunction = window.Function;

        function FunctionWrapper() {
          hit(source);

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          log("new Function(".concat(args.join(", "), ")"));
          return nativeFunction.apply(this, [].concat(args));
        }

        FunctionWrapper.prototype = Object.create(nativeFunction.prototype);
        FunctionWrapper.prototype.constructor = FunctionWrapper;
        window.Function = FunctionWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        logEval.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function logOnStacktrace(source, args) {
      function logOnStacktrace(source, property) {
        if (!property) {
          return;
        }

        var refineStackTrace = function refineStackTrace(stackString) {
          var stackSteps = stackString.split("\n").slice(2).map(function (line) {
            return line.replace(/ {4}at /, "");
          });
          var logInfoArray = stackSteps.map(function (line) {
            var funcName;
            var funcFullPath;
            var reg = /\(([^\)]+)\)/;

            if (line.match(reg)) {
              funcName = line.split(" ").slice(0, -1).join(" ");
              funcFullPath = line.match(reg)[1];
            } else {
              funcName = "function name is not available";
              funcFullPath = line;
            }

            return [funcName, funcFullPath];
          });
          var logInfoObject = {};
          logInfoArray.forEach(function (pair) {
            logInfoObject[pair[0]] = pair[1];
          });
          return logInfoObject;
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;

          if (chain) {
            var setter = function setter(a) {
              base = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            };

            Object.defineProperty(owner, prop, {
              get: function get() {
                return base;
              },
              set: setter
            });
            return;
          }

          var value = base[prop];
          setPropertyAccess(base, prop, {
            get: function get() {
              hit(source);
              console.log("%cGet %c".concat(prop), "color:red;", "color:green;");
              console.table(refineStackTrace(new Error().stack));
              return value;
            },
            set: function set(newValue) {
              hit(source);
              console.log("%cSet %c".concat(prop), "color:red;", "color:green;");
              console.table(refineStackTrace(new Error().stack));
              value = newValue;
            }
          });
        };

        setChainPropAccess(window, property);
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        logOnStacktrace.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function noTopics(source, args) {
      function noTopics(source) {
        var TOPICS_PROPERTY_NAME = "browsingTopics";

        if (Document instanceof Object === false) {
          return;
        }

        if (!Object.prototype.hasOwnProperty.call(Document.prototype, TOPICS_PROPERTY_NAME) || Document.prototype[TOPICS_PROPERTY_NAME] instanceof Function === false) {
          return;
        }

        Document.prototype[TOPICS_PROPERTY_NAME] = function () {
          return noopPromiseResolve("[]");
        };

        hit(source);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopPromiseResolve() {
        var responseBody = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "{}";

        if (typeof Response === "undefined") {
          return;
        }

        var response = new Response(responseBody, {
          status: 200,
          statusText: "OK"
        });
        return Promise.resolve(response);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        noTopics.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function noeval(source, args) {
      function noeval(source) {
        window.eval = function evalWrapper(s) {
          hit(source, "AdGuard has prevented eval:\n".concat(s));
        }.bind();
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        noeval.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function nowebrtc(source, args) {
      function nowebrtc(source) {
        var propertyName = "";

        if (window.RTCPeerConnection) {
          propertyName = "RTCPeerConnection";
        } else if (window.webkitRTCPeerConnection) {
          propertyName = "webkitRTCPeerConnection";
        }

        if (propertyName === "") {
          return;
        }

        var rtcReplacement = function rtcReplacement(config) {
          hit(source, "Document tried to create an RTCPeerConnection: ".concat(convertRtcConfigToString(config)));
        };

        rtcReplacement.prototype = {
          close: noopFunc,
          createDataChannel: noopFunc,
          createOffer: noopFunc,
          setRemoteDescription: noopFunc
        };
        var rtc = window[propertyName];
        window[propertyName] = rtcReplacement;

        if (rtc.prototype) {
          rtc.prototype.createDataChannel = function (a, b) {
            return {
              close: noopFunc,
              send: noopFunc
            };
          }.bind(null);
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      function convertRtcConfigToString(config) {
        var UNDEF_STR = "undefined";
        var str = UNDEF_STR;

        if (config === null) {
          str = "null";
        } else if (config instanceof Object) {
          var SERVERS_PROP_NAME = "iceServers";
          var URLS_PROP_NAME = "urls";

          if (Object.prototype.hasOwnProperty.call(config, SERVERS_PROP_NAME) && Object.prototype.hasOwnProperty.call(config[SERVERS_PROP_NAME][0], URLS_PROP_NAME) && !!config[SERVERS_PROP_NAME][0][URLS_PROP_NAME]) {
            str = config[SERVERS_PROP_NAME][0][URLS_PROP_NAME].toString();
          }
        }

        return str;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        nowebrtc.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventAddEventListener(source, args) {
      function preventAddEventListener(source, typeSearch, listenerSearch) {
        var typeSearchRegexp = toRegExp(typeSearch);
        var listenerSearchRegexp = toRegExp(listenerSearch);
        var nativeAddEventListener = window.EventTarget.prototype.addEventListener;

        function addEventListenerWrapper(type, listener) {
          var shouldPrevent = false;

          if (validateType(type) && validateListener(listener)) {
            shouldPrevent = typeSearchRegexp.test(type.toString()) && listenerSearchRegexp.test(listenerToString(listener));
          }

          if (shouldPrevent) {
            hit(source);
            return undefined;
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeAddEventListener.apply(this, [type, listener].concat(args));
        }

        window.EventTarget.prototype.addEventListener = addEventListenerWrapper;
        window.addEventListener = addEventListenerWrapper;
        document.addEventListener = addEventListenerWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function validateType(type) {
        return typeof type !== "undefined";
      }

      function validateListener(listener) {
        return typeof listener !== "undefined" && (typeof listener === "function" || typeof listener === "object" && listener !== null && typeof listener.handleEvent === "function");
      }

      function listenerToString(listener) {
        return typeof listener === "function" ? listener.toString() : listener.handleEvent.toString();
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventAddEventListener.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventAdfly(source, args) {
      function preventAdfly(source) {
        var isDigit = function isDigit(data) {
          return /^\d$/.test(data);
        };

        var handler = function handler(encodedURL) {
          var evenChars = "";
          var oddChars = "";

          for (var i = 0; i < encodedURL.length; i += 1) {
            if (i % 2 === 0) {
              evenChars += encodedURL.charAt(i);
            } else {
              oddChars = encodedURL.charAt(i) + oddChars;
            }
          }

          var data = (evenChars + oddChars).split("");

          for (var _i = 0; _i < data.length; _i += 1) {
            if (isDigit(data[_i])) {
              for (var ii = _i + 1; ii < data.length; ii += 1) {
                if (isDigit(data[ii])) {
                  var temp = parseInt(data[_i], 10) ^ parseInt(data[ii], 10);

                  if (temp < 10) {
                    data[_i] = temp.toString();
                  }

                  _i = ii;
                  break;
                }
              }
            }
          }

          data = data.join("");
          var decodedURL = window.atob(data).slice(16, -16);

          if (window.stop) {
            window.stop();
          }

          window.onbeforeunload = null;
          window.location.href = decodedURL;
        };

        var val;
        var applyHandler = true;
        var result = setPropertyAccess(window, "ysmm", {
          configurable: false,
          set: function set(value) {
            if (applyHandler) {
              applyHandler = false;

              try {
                if (typeof value === "string") {
                  handler(value);
                }
              } catch (err) {}
            }

            val = value;
          },
          get: function get() {
            return val;
          }
        });

        if (result) {
          hit(source);
        } else {
          window.console.error("Failed to set up prevent-adfly scriptlet");
        }
      }

      function setPropertyAccess(object, property, descriptor) {
        var currentDescriptor = Object.getOwnPropertyDescriptor(object, property);

        if (currentDescriptor && !currentDescriptor.configurable) {
          return false;
        }

        Object.defineProperty(object, property, descriptor);
        return true;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventAdfly.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventBab(source, args) {
      function preventBab(source) {
        var nativeSetTimeout = window.setTimeout;
        var babRegex = /\.bab_elementid.$/;

        var timeoutWrapper = function timeoutWrapper(callback) {
          if (typeof callback !== "string" || !babRegex.test(callback)) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeSetTimeout.apply(window, [callback].concat(args));
          }

          hit(source);
        };

        window.setTimeout = timeoutWrapper;
        var signatures = [["blockadblock"], ["babasbm"], [/getItem\('babn'\)/], ["getElementById", "String.fromCharCode", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "charAt", "DOMContentLoaded", "AdBlock", "addEventListener", "doScroll", "fromCharCode", "<<2|r>>4", "sessionStorage", "clientWidth", "localStorage", "Math", "random"]];

        var check = function check(str) {
          if (typeof str !== "string") {
            return false;
          }

          for (var i = 0; i < signatures.length; i += 1) {
            var tokens = signatures[i];
            var match = 0;

            for (var j = 0; j < tokens.length; j += 1) {
              var token = tokens[j];
              var found = token instanceof RegExp ? token.test(str) : str.indexOf(token) > -1;

              if (found) {
                match += 1;
              }
            }

            if (match / tokens.length >= .8) {
              return true;
            }
          }

          return false;
        };

        var nativeEval = window.eval;

        var evalWrapper = function evalWrapper(str) {
          if (!check(str)) {
            return nativeEval(str);
          }

          hit(source);
          var bodyEl = document.body;

          if (bodyEl) {
            bodyEl.style.removeProperty("visibility");
          }

          var el = document.getElementById("babasbmsgx");

          if (el) {
            el.parentNode.removeChild(el);
          }
        };

        window.eval = evalWrapper.bind(window);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventBab.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventElementSrcLoading(source, args) {
      function preventElementSrcLoading(source, tagName, match) {
        if (typeof Proxy === "undefined" || typeof Reflect === "undefined") {
          return;
        }

        var srcMockData = {
          script: "data:text/javascript;base64,KCk9Pnt9",
          img: "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",
          iframe: "data:text/html;base64, PGRpdj48L2Rpdj4="
        };
        var instance;

        if (tagName === "script") {
          instance = HTMLScriptElement;
        } else if (tagName === "img") {
          instance = HTMLImageElement;
        } else if (tagName === "iframe") {
          instance = HTMLIFrameElement;
        } else {
          return;
        }

        var hasTrustedTypes = window.trustedTypes && typeof window.trustedTypes.createPolicy === "function";
        var policy;

        if (hasTrustedTypes) {
          policy = window.trustedTypes.createPolicy("mock", {
            createScriptURL: function createScriptURL(arg) {
              return arg;
            }
          });
        }

        var SOURCE_PROPERTY_NAME = "src";
        var searchRegexp = toRegExp(match);

        var setAttributeWrapper = function setAttributeWrapper(target, thisArg, args) {
          if (!args[0] || !args[1]) {
            return Reflect.apply(target, thisArg, args);
          }

          var nodeName = thisArg.nodeName.toLowerCase();
          var attrName = args[0].toLowerCase();
          var attrValue = args[1];
          var isMatched = attrName === SOURCE_PROPERTY_NAME && tagName.toLowerCase() === nodeName && srcMockData[nodeName] && searchRegexp.test(attrValue);

          if (!isMatched) {
            return Reflect.apply(target, thisArg, args);
          }

          hit(source);
          return Reflect.apply(target, thisArg, [attrName, srcMockData[nodeName]]);
        };

        var setAttributeHandler = {
          apply: setAttributeWrapper
        };
        instance.prototype.setAttribute = new Proxy(Element.prototype.setAttribute, setAttributeHandler);
        var origDescriptor = safeGetDescriptor(instance.prototype, SOURCE_PROPERTY_NAME);

        if (!origDescriptor) {
          return;
        }

        Object.defineProperty(instance.prototype, SOURCE_PROPERTY_NAME, {
          enumerable: true,
          configurable: true,
          get: function get() {
            return origDescriptor.get.call(this);
          },
          set: function set(urlValue) {
            var nodeName = this.nodeName.toLowerCase();
            var isMatched = tagName.toLowerCase() === nodeName && srcMockData[nodeName] && searchRegexp.test(urlValue);

            if (!isMatched) {
              origDescriptor.set.call(this, urlValue);
              return;
            }

            if (policy && urlValue instanceof TrustedScriptURL) {
              var trustedSrc = policy.createScriptURL(urlValue);
              origDescriptor.set.call(this, trustedSrc);
              hit(source);
              return;
            }

            origDescriptor.set.call(this, srcMockData[nodeName]);
            hit(source);
          }
        });
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function safeGetDescriptor(obj, prop) {
        var descriptor = Object.getOwnPropertyDescriptor(obj, prop);

        if (descriptor && descriptor.configurable) {
          return descriptor;
        }

        return null;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventElementSrcLoading.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventEvalIf(source, args) {
      function preventEvalIf(source, search) {
        var searchRegexp = toRegExp(search);
        var nativeEval = window.eval;

        window.eval = function (payload) {
          if (!searchRegexp.test(payload.toString())) {
            return nativeEval.call(window, payload);
          }

          hit(source, payload);
          return undefined;
        }.bind(window);
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventEvalIf.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventFab(source, args) {
      function preventFab(source) {
        hit(source);

        var Fab = function Fab() {};

        Fab.prototype.check = noopFunc;
        Fab.prototype.clearEvent = noopFunc;
        Fab.prototype.emitEvent = noopFunc;

        Fab.prototype.on = function (a, b) {
          if (!a) {
            b();
          }

          return this;
        };

        Fab.prototype.onDetected = noopThis;

        Fab.prototype.onNotDetected = function (a) {
          a();
          return this;
        };

        Fab.prototype.setOption = noopFunc;
        Fab.prototype.options = {
          set: noopFunc,
          get: noopFunc
        };
        var fab = new Fab();
        var getSetFab = {
          get: function get() {
            return Fab;
          },
          set: function set() {}
        };
        var getsetfab = {
          get: function get() {
            return fab;
          },
          set: function set() {}
        };

        if (Object.prototype.hasOwnProperty.call(window, "FuckAdBlock")) {
          window.FuckAdBlock = Fab;
        } else {
          Object.defineProperty(window, "FuckAdBlock", getSetFab);
        }

        if (Object.prototype.hasOwnProperty.call(window, "BlockAdBlock")) {
          window.BlockAdBlock = Fab;
        } else {
          Object.defineProperty(window, "BlockAdBlock", getSetFab);
        }

        if (Object.prototype.hasOwnProperty.call(window, "SniffAdBlock")) {
          window.SniffAdBlock = Fab;
        } else {
          Object.defineProperty(window, "SniffAdBlock", getSetFab);
        }

        if (Object.prototype.hasOwnProperty.call(window, "fuckAdBlock")) {
          window.fuckAdBlock = fab;
        } else {
          Object.defineProperty(window, "fuckAdBlock", getsetfab);
        }

        if (Object.prototype.hasOwnProperty.call(window, "blockAdBlock")) {
          window.blockAdBlock = fab;
        } else {
          Object.defineProperty(window, "blockAdBlock", getsetfab);
        }

        if (Object.prototype.hasOwnProperty.call(window, "sniffAdBlock")) {
          window.sniffAdBlock = fab;
        } else {
          Object.defineProperty(window, "sniffAdBlock", getsetfab);
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      function noopThis() {
        return this;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventFab.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventFetch(source, args) {
      function preventFetch(source, propsToMatch) {
        var responseBody = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "emptyObj";

        if (typeof fetch === "undefined" || typeof Proxy === "undefined" || typeof Response === "undefined") {
          return;
        }

        var strResponseBody;

        if (responseBody === "emptyObj") {
          strResponseBody = "{}";
        } else if (responseBody === "emptyArr") {
          strResponseBody = "[]";
        } else {
          return;
        }

        var handlerWrapper = function handlerWrapper(target, thisArg, args) {
          var shouldPrevent = false;
          var fetchData = getFetchData(args);

          if (typeof propsToMatch === "undefined") {
            var logMessage = "log: fetch( ".concat(objectToString(fetchData), " )");
            hit(source, logMessage);
          } else if (propsToMatch === "" || propsToMatch === getWildcardSymbol()) {
            shouldPrevent = true;
          } else {
            var parsedData = parseMatchProps(propsToMatch);

            if (!validateParsedData(parsedData)) {
              console.log("Invalid parameter: ".concat(propsToMatch));
              shouldPrevent = false;
            } else {
              var matchData = getMatchPropsData(parsedData);
              shouldPrevent = Object.keys(matchData).every(function (matchKey) {
                var matchValue = matchData[matchKey];
                return Object.prototype.hasOwnProperty.call(fetchData, matchKey) && matchValue.test(fetchData[matchKey]);
              });
            }
          }

          if (shouldPrevent) {
            hit(source);
            return noopPromiseResolve(strResponseBody);
          }

          return Reflect.apply(target, thisArg, args);
        };

        var fetchHandler = {
          apply: handlerWrapper
        };
        fetch = new Proxy(fetch, fetchHandler);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function getFetchData(args) {
        var fetchPropsObj = {};
        var fetchUrl;
        var fetchInit;

        if (args[0] instanceof Request) {
          var requestData = getRequestData(args[0]);
          fetchUrl = requestData.url;
          fetchInit = requestData;
        } else {
          fetchUrl = args[0];
          fetchInit = args[1];
        }

        fetchPropsObj.url = fetchUrl;

        if (fetchInit instanceof Object) {
          Object.keys(fetchInit).forEach(function (prop) {
            fetchPropsObj[prop] = fetchInit[prop];
          });
        }

        return fetchPropsObj;
      }

      function objectToString(obj) {
        return isEmptyObject(obj) ? "{}" : getObjectEntries(obj).map(function (pair) {
          var key = pair[0];
          var value = pair[1];
          var recordValueStr = value;

          if (value instanceof Object) {
            recordValueStr = "{ ".concat(objectToString(value), " }");
          }

          return "".concat(key, ':"').concat(recordValueStr, '"');
        }).join(" ");
      }

      function parseMatchProps(propsToMatchStr) {
        var PROPS_DIVIDER = " ";
        var PAIRS_MARKER = ":";
        var propsObj = {};
        var props = propsToMatchStr.split(PROPS_DIVIDER);
        props.forEach(function (prop) {
          var dividerInd = prop.indexOf(PAIRS_MARKER);

          if (dividerInd === -1) {
            propsObj.url = prop;
          } else {
            var key = prop.slice(0, dividerInd);
            var value = prop.slice(dividerInd + 1);
            propsObj[key] = value;
          }
        });
        return propsObj;
      }

      function validateParsedData(data) {
        return Object.values(data).every(function (value) {
          return isValidStrPattern(value);
        });
      }

      function getMatchPropsData(data) {
        var matchData = {};
        Object.keys(data).forEach(function (key) {
          matchData[key] = toRegExp(data[key]);
        });
        return matchData;
      }

      function noopPromiseResolve() {
        var responseBody = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "{}";

        if (typeof Response === "undefined") {
          return;
        }

        var response = new Response(responseBody, {
          status: 200,
          statusText: "OK"
        });
        return Promise.resolve(response);
      }

      function getWildcardSymbol() {
        return "*";
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function isEmptyObject(obj) {
        return Object.keys(obj).length === 0;
      }

      function getRequestData(request) {
        var REQUEST_INIT_OPTIONS = ["url", "method", "headers", "body", "mode", "credentials", "cache", "redirect", "referrer", "integrity"];
        var entries = REQUEST_INIT_OPTIONS.map(function (key) {
          var value = request[key];
          return [key, value];
        });
        return getObjectFromEntries(entries);
      }

      function getObjectEntries(object) {
        var keys = Object.keys(object);
        var entries = [];
        keys.forEach(function (key) {
          return entries.push([key, object[key]]);
        });
        return entries;
      }

      function getObjectFromEntries(entries) {
        var output = entries.reduce(function (acc, el) {
          var key = el[0];
          var value = el[1];
          acc[key] = value;
          return acc;
        }, {});
        return output;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventFetch.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventPopadsNet(source, args) {
      function preventPopadsNet(source) {
        var rid = randomId();

        var throwError = function throwError() {
          throw new ReferenceError(rid);
        };

        delete window.PopAds;
        delete window.popns;
        Object.defineProperties(window, {
          PopAds: {
            set: throwError
          },
          popns: {
            set: throwError
          }
        });
        window.onerror = createOnErrorHandler(rid).bind();
        hit(source);
      }

      function createOnErrorHandler(rid) {
        var nativeOnError = window.onerror;
        return function onError(error) {
          if (typeof error === "string" && error.indexOf(rid) !== -1) {
            return true;
          }

          if (nativeOnError instanceof Function) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            return nativeOnError.apply(this, [error].concat(args));
          }

          return false;
        };
      }

      function randomId() {
        return Math.random().toString(36).substr(2, 9);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventPopadsNet.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventRefresh(source, args) {
      function preventRefresh(source, delaySec) {
        var getMetaElements = function getMetaElements() {
          var metaNodes = [];

          try {
            metaNodes = document.querySelectorAll('meta[http-equiv="refresh" i][content]');
          } catch (e) {
            try {
              metaNodes = document.querySelectorAll('meta[http-equiv="refresh"][content]');
            } catch (e) {
              if (source.verbose) {
                console.log(e);
              }
            }
          }

          return Array.from(metaNodes);
        };

        var getMetaContentDelay = function getMetaContentDelay(metaElements) {
          var delays = metaElements.map(function (meta) {
            var contentString = meta.getAttribute("content");

            if (contentString.length === 0) {
              return null;
            }

            var contentDelay;
            var limiterIndex = contentString.indexOf(";");

            if (limiterIndex !== -1) {
              var delaySubstring = contentString.substring(0, limiterIndex);
              contentDelay = getNumberFromString(delaySubstring);
            } else {
              contentDelay = getNumberFromString(contentString);
            }

            return contentDelay;
          }).filter(function (delay) {
            return delay !== null;
          });

          if (!delays.length) {
            return null;
          }

          var minDelay = delays.reduce(function (a, b) {
            return Math.min(a, b);
          });
          return minDelay;
        };

        var stop = function stop() {
          var metaElements = getMetaElements();

          if (metaElements.length === 0) {
            return;
          }

          var secondsToRun = getNumberFromString(delaySec);

          if (secondsToRun === null) {
            secondsToRun = getMetaContentDelay(metaElements);
          }

          if (secondsToRun === null) {
            return;
          }

          var delayMs = secondsToRun * 1e3;
          setTimeout(function () {
            window.stop();
            hit(source);
          }, delayMs);
        };

        if (document.readyState === "loading") {
          document.addEventListener("DOMContentLoaded", stop, {
            once: true
          });
        } else {
          stop();
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function getNumberFromString(rawString) {
        var parsedDelay = parseInt(rawString, 10);
        var validDelay = nativeIsNaN(parsedDelay) ? null : parsedDelay;
        return validDelay;
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventRefresh.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventRequestAnimationFrame(source, args) {
      function preventRequestAnimationFrame(source, match) {
        var nativeRequestAnimationFrame = window.requestAnimationFrame;
        var log = console.log.bind(console);
        var shouldLog = typeof match === "undefined";

        var _parseMatchArg = parseMatchArg(match),
            isInvertedMatch = _parseMatchArg.isInvertedMatch,
            matchRegexp = _parseMatchArg.matchRegexp;

        var rafWrapper = function rafWrapper(callback) {
          var shouldPrevent = false;

          if (shouldLog) {
            hit(source);
            log("requestAnimationFrame(".concat(String(callback), ")"));
          } else if (isValidCallback(callback) && isValidStrPattern(match)) {
            shouldPrevent = matchRegexp.test(callback.toString()) !== isInvertedMatch;
          }

          if (shouldPrevent) {
            hit(source);
            return nativeRequestAnimationFrame(noopFunc);
          }

          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          return nativeRequestAnimationFrame.apply(window, [callback].concat(args));
        };

        window.requestAnimationFrame = rafWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      function parseMatchArg(match) {
        var INVERT_MARKER = "!";
        var isInvertedMatch = startsWith(match, INVERT_MARKER);
        var matchValue = isInvertedMatch ? match.slice(1) : match;
        var matchRegexp = toRegExp(matchValue);
        return {
          isInvertedMatch: isInvertedMatch,
          matchRegexp: matchRegexp
        };
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function isValidCallback(callback) {
        return callback instanceof Function || typeof callback === "string";
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function startsWith(str, prefix) {
        return !!str && str.indexOf(prefix) === 0;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventRequestAnimationFrame.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventSetInterval(source, args) {
      function preventSetInterval(source, matchCallback, matchDelay) {
        var isProxySupported = typeof Proxy !== "undefined";
        var nativeInterval = window.setInterval;
        var log = console.log.bind(console);
        var shouldLog = typeof matchCallback === "undefined" && typeof matchDelay === "undefined";

        var legacyIntervalWrapper = function legacyIntervalWrapper(callback, delay) {
          var shouldPrevent = false;

          if (shouldLog) {
            hit(source);
            log("setInterval(".concat(String(callback), ", ").concat(delay, ")"));
          } else {
            shouldPrevent = isPreventionNeeded({
              callback: callback,
              delay: delay,
              matchCallback: matchCallback,
              matchDelay: matchDelay
            });
          }

          if (shouldPrevent) {
            hit(source);
            return nativeInterval(noopFunc, delay);
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeInterval.apply(window, [callback, delay].concat(args));
        };

        var handlerWrapper = function handlerWrapper(target, thisArg, args) {
          var callback = args[0];
          var delay = args[1];
          var shouldPrevent = false;

          if (shouldLog) {
            hit(source);
            log("setInterval(".concat(String(callback), ", ").concat(delay, ")"));
          } else {
            shouldPrevent = isPreventionNeeded({
              callback: callback,
              delay: delay,
              matchCallback: matchCallback,
              matchDelay: matchDelay
            });
          }

          if (shouldPrevent) {
            hit(source);
            args[0] = noopFunc;
          }

          return target.apply(thisArg, args);
        };

        var setIntervalHandler = {
          apply: handlerWrapper
        };
        window.setInterval = isProxySupported ? new Proxy(window.setInterval, setIntervalHandler) : legacyIntervalWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      function isPreventionNeeded(_ref) {
        var callback = _ref.callback,
            delay = _ref.delay,
            matchCallback = _ref.matchCallback,
            matchDelay = _ref.matchDelay;

        if (!isValidCallback(callback)) {
          return false;
        }

        if (!isValidMatchStr(matchCallback) || matchDelay && !isValidMatchNumber(matchDelay)) {
          return false;
        }

        var _parseMatchArg = parseMatchArg(matchCallback),
            isInvertedMatch = _parseMatchArg.isInvertedMatch,
            matchRegexp = _parseMatchArg.matchRegexp;

        var _parseDelayArg = parseDelayArg(matchDelay),
            isInvertedDelayMatch = _parseDelayArg.isInvertedDelayMatch,
            delayMatch = _parseDelayArg.delayMatch;

        var shouldPrevent = false;
        var callbackStr = String(callback);

        if (delayMatch === null) {
          shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch;
        } else if (!matchCallback) {
          shouldPrevent = delay === delayMatch !== isInvertedDelayMatch;
        } else {
          shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch && delay === delayMatch !== isInvertedDelayMatch;
        }

        return shouldPrevent;
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function startsWith(str, prefix) {
        return !!str && str.indexOf(prefix) === 0;
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function parseMatchArg(match) {
        var INVERT_MARKER = "!";
        var isInvertedMatch = startsWith(match, INVERT_MARKER);
        var matchValue = isInvertedMatch ? match.slice(1) : match;
        var matchRegexp = toRegExp(matchValue);
        return {
          isInvertedMatch: isInvertedMatch,
          matchRegexp: matchRegexp
        };
      }

      function parseDelayArg(delay) {
        var INVERT_MARKER = "!";
        var isInvertedDelayMatch = startsWith(delay, INVERT_MARKER);
        var delayValue = isInvertedDelayMatch ? delay.slice(1) : delay;
        delayValue = parseInt(delayValue, 10);
        var delayMatch = nativeIsNaN(delayValue) ? null : delayValue;
        return {
          isInvertedDelayMatch: isInvertedDelayMatch,
          delayMatch: delayMatch
        };
      }

      function isValidCallback(callback) {
        return callback instanceof Function || typeof callback === "string";
      }

      function isValidMatchStr(match) {
        var INVERT_MARKER = "!";
        var str = match;

        if (startsWith(match, INVERT_MARKER)) {
          str = match.slice(1);
        }

        return isValidStrPattern(str);
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function nativeIsFinite(num) {
        var native = Number.isFinite || window.isFinite;
        return native(num);
      }

      function isValidMatchNumber(match) {
        var INVERT_MARKER = "!";
        var str = match;

        if (startsWith(match, INVERT_MARKER)) {
          str = match.slice(1);
        }

        var num = parseFloat(str);
        return !nativeIsNaN(num) && nativeIsFinite(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventSetInterval.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventSetTimeout(source, args) {
      function preventSetTimeout(source, matchCallback, matchDelay) {
        var isProxySupported = typeof Proxy !== "undefined";
        var nativeTimeout = window.setTimeout;
        var log = console.log.bind(console);
        var shouldLog = typeof matchCallback === "undefined" && typeof matchDelay === "undefined";

        var legacyTimeoutWrapper = function legacyTimeoutWrapper(callback, delay) {
          var shouldPrevent = false;

          if (shouldLog) {
            hit(source);
            log("setTimeout(".concat(String(callback), ", ").concat(delay, ")"));
          } else {
            shouldPrevent = isPreventionNeeded({
              callback: callback,
              delay: delay,
              matchCallback: matchCallback,
              matchDelay: matchDelay
            });
          }

          if (shouldPrevent) {
            hit(source);
            return nativeTimeout(noopFunc, delay);
          }

          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }

          return nativeTimeout.apply(window, [callback, delay].concat(args));
        };

        var handlerWrapper = function handlerWrapper(target, thisArg, args) {
          var callback = args[0];
          var delay = args[1];
          var shouldPrevent = false;

          if (shouldLog) {
            hit(source);
            log("setTimeout(".concat(String(callback), ", ").concat(delay, ")"));
          } else {
            shouldPrevent = isPreventionNeeded({
              callback: callback,
              delay: delay,
              matchCallback: matchCallback,
              matchDelay: matchDelay
            });
          }

          if (shouldPrevent) {
            hit(source);
            args[0] = noopFunc;
          }

          return target.apply(thisArg, args);
        };

        var setTimeoutHandler = {
          apply: handlerWrapper
        };
        window.setTimeout = isProxySupported ? new Proxy(window.setTimeout, setTimeoutHandler) : legacyTimeoutWrapper;
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopFunc() {}

      function isPreventionNeeded(_ref) {
        var callback = _ref.callback,
            delay = _ref.delay,
            matchCallback = _ref.matchCallback,
            matchDelay = _ref.matchDelay;

        if (!isValidCallback(callback)) {
          return false;
        }

        if (!isValidMatchStr(matchCallback) || matchDelay && !isValidMatchNumber(matchDelay)) {
          return false;
        }

        var _parseMatchArg = parseMatchArg(matchCallback),
            isInvertedMatch = _parseMatchArg.isInvertedMatch,
            matchRegexp = _parseMatchArg.matchRegexp;

        var _parseDelayArg = parseDelayArg(matchDelay),
            isInvertedDelayMatch = _parseDelayArg.isInvertedDelayMatch,
            delayMatch = _parseDelayArg.delayMatch;

        var shouldPrevent = false;
        var callbackStr = String(callback);

        if (delayMatch === null) {
          shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch;
        } else if (!matchCallback) {
          shouldPrevent = delay === delayMatch !== isInvertedDelayMatch;
        } else {
          shouldPrevent = matchRegexp.test(callbackStr) !== isInvertedMatch && delay === delayMatch !== isInvertedDelayMatch;
        }

        return shouldPrevent;
      }

      function parseMatchArg(match) {
        var INVERT_MARKER = "!";
        var isInvertedMatch = startsWith(match, INVERT_MARKER);
        var matchValue = isInvertedMatch ? match.slice(1) : match;
        var matchRegexp = toRegExp(matchValue);
        return {
          isInvertedMatch: isInvertedMatch,
          matchRegexp: matchRegexp
        };
      }

      function parseDelayArg(delay) {
        var INVERT_MARKER = "!";
        var isInvertedDelayMatch = startsWith(delay, INVERT_MARKER);
        var delayValue = isInvertedDelayMatch ? delay.slice(1) : delay;
        delayValue = parseInt(delayValue, 10);
        var delayMatch = nativeIsNaN(delayValue) ? null : delayValue;
        return {
          isInvertedDelayMatch: isInvertedDelayMatch,
          delayMatch: delayMatch
        };
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function startsWith(str, prefix) {
        return !!str && str.indexOf(prefix) === 0;
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function isValidCallback(callback) {
        return callback instanceof Function || typeof callback === "string";
      }

      function isValidMatchStr(match) {
        var INVERT_MARKER = "!";
        var str = match;

        if (startsWith(match, INVERT_MARKER)) {
          str = match.slice(1);
        }

        return isValidStrPattern(str);
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function nativeIsFinite(num) {
        var native = Number.isFinite || window.isFinite;
        return native(num);
      }

      function isValidMatchNumber(match) {
        var INVERT_MARKER = "!";
        var str = match;

        if (startsWith(match, INVERT_MARKER)) {
          str = match.slice(1);
        }

        var num = parseFloat(str);
        return !nativeIsNaN(num) && nativeIsFinite(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventSetTimeout.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventWindowOpen(source, args) {
      function preventWindowOpen(source) {
        var match = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : getWildcardSymbol();
        var delay = arguments.length > 2 ? arguments[2] : undefined;
        var replacement = arguments.length > 3 ? arguments[3] : undefined;
        var nativeOpen = window.open;
        var isNewSyntax = match !== "0" && match !== "1";

        var oldOpenWrapper = function oldOpenWrapper(str) {
          match = Number(match) > 0;

          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          if (!isValidStrPattern(delay)) {
            console.log("Invalid parameter: ".concat(delay));
            return nativeOpen.apply(window, [str].concat(args));
          }

          var searchRegexp = toRegExp(delay);

          if (match !== searchRegexp.test(str)) {
            return nativeOpen.apply(window, [str].concat(args));
          }

          hit(source);
          return handleOldReplacement(replacement);
        };

        var newOpenWrapper = function newOpenWrapper(url) {
          var shouldLog = replacement && replacement.indexOf("log") > -1;

          for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
            args[_key2 - 1] = arguments[_key2];
          }

          if (shouldLog) {
            var argsStr = args && args.length > 0 ? ", ".concat(args.join(", ")) : "";
            var logMessage = "log: window-open: ".concat(url).concat(argsStr);
            hit(source, logMessage);
          }

          var shouldPrevent = false;

          if (match === getWildcardSymbol()) {
            shouldPrevent = true;
          } else if (isValidMatchStr(match)) {
            var _parseMatchArg = parseMatchArg(match),
                isInvertedMatch = _parseMatchArg.isInvertedMatch,
                matchRegexp = _parseMatchArg.matchRegexp;

            shouldPrevent = matchRegexp.test(url) !== isInvertedMatch;
          } else {
            console.log("Invalid parameter: ".concat(match));
            shouldPrevent = false;
          }

          if (shouldPrevent) {
            var parsedDelay = parseInt(delay, 10);
            var result;

            if (nativeIsNaN(parsedDelay)) {
              result = noopNull();
            } else {
              var decoyArgs = {
                replacement: replacement,
                url: url,
                delay: parsedDelay
              };
              var decoy = createDecoy(decoyArgs);
              var popup = decoy.contentWindow;

              if (typeof popup === "object" && popup !== null) {
                Object.defineProperty(popup, "closed", {
                  value: false
                });
                Object.defineProperty(popup, "opener", {
                  value: window
                });
                Object.defineProperty(popup, "frameElement", {
                  value: null
                });
              } else {
                var nativeGetter = decoy.contentWindow && decoy.contentWindow.get;
                Object.defineProperty(decoy, "contentWindow", {
                  get: getPreventGetter(nativeGetter)
                });
                popup = decoy.contentWindow;
              }

              result = popup;
            }

            hit(source);
            return result;
          }

          return nativeOpen.apply(window, [url].concat(args));
        };

        window.open = isNewSyntax ? newOpenWrapper : oldOpenWrapper;
        window.open.toString = nativeOpen.toString.bind(nativeOpen);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function isValidMatchStr(match) {
        var INVERT_MARKER = "!";
        var str = match;

        if (startsWith(match, INVERT_MARKER)) {
          str = match.slice(1);
        }

        return isValidStrPattern(str);
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function parseMatchArg(match) {
        var INVERT_MARKER = "!";
        var isInvertedMatch = startsWith(match, INVERT_MARKER);
        var matchValue = isInvertedMatch ? match.slice(1) : match;
        var matchRegexp = toRegExp(matchValue);
        return {
          isInvertedMatch: isInvertedMatch,
          matchRegexp: matchRegexp
        };
      }

      function handleOldReplacement(replacement) {
        var result;

        if (!replacement) {
          result = noopFunc;
        } else if (replacement === "trueFunc") {
          result = trueFunc;
        } else if (replacement.indexOf("=") > -1) {
          var isProp = startsWith(replacement, "{") && endsWith(replacement, "}");

          if (isProp) {
            var propertyPart = replacement.slice(1, -1);
            var propertyName = substringBefore(propertyPart, "=");
            var propertyValue = substringAfter(propertyPart, "=");

            if (propertyValue === "noopFunc") {
              result = {};
              result[propertyName] = noopFunc;
            }
          }
        }

        return result;
      }

      function createDecoy(args) {
        var OBJECT_TAG_NAME = "object";
        var OBJECT_URL_PROP_NAME = "data";
        var IFRAME_TAG_NAME = "iframe";
        var IFRAME_URL_PROP_NAME = "src";
        var replacement = args.replacement,
            url = args.url,
            delay = args.delay;
        var tag;
        var urlProp;

        if (replacement === "obj") {
          tag = OBJECT_TAG_NAME;
          urlProp = OBJECT_URL_PROP_NAME;
        } else {
          tag = IFRAME_TAG_NAME;
          urlProp = IFRAME_URL_PROP_NAME;
        }

        var decoy = document.createElement(tag);
        decoy[urlProp] = url;
        decoy.style.setProperty("height", "1px", "important");
        decoy.style.setProperty("position", "fixed", "important");
        decoy.style.setProperty("top", "-1px", "important");
        decoy.style.setProperty("width", "1px", "important");
        document.body.appendChild(decoy);
        setTimeout(function () {
          return decoy.remove();
        }, delay * 1e3);
        return decoy;
      }

      function getPreventGetter(nativeGetter) {
        var preventGetter = function preventGetter(target, prop) {
          if (prop && prop === "closed") {
            return false;
          }

          if (typeof nativeGetter === "function") {
            return noopFunc;
          }

          return prop && target[prop];
        };

        return preventGetter;
      }

      function noopNull() {
        return null;
      }

      function getWildcardSymbol() {
        return "*";
      }

      function noopFunc() {}

      function trueFunc() {
        return true;
      }

      function startsWith(str, prefix) {
        return !!str && str.indexOf(prefix) === 0;
      }

      function endsWith(str, ending) {
        return !!str && str.indexOf(ending) === str.length - ending.length;
      }

      function substringBefore(str, separator) {
        if (!str || !separator) {
          return str;
        }

        var index = str.indexOf(separator);
        return index < 0 ? str : str.substring(0, index);
      }

      function substringAfter(str, separator) {
        if (!str) {
          return str;
        }

        var index = str.indexOf(separator);
        return index < 0 ? "" : str.substring(index + separator.length);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventWindowOpen.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function preventXHR(source, args) {
      function preventXHR(source, propsToMatch, customResponseText) {
        if (typeof Proxy === "undefined") {
          return;
        }

        var shouldPrevent = false;
        var response = "";
        var responseText = "";
        var responseUrl;

        var openWrapper = function openWrapper(target, thisArg, args) {
          var xhrData = {
            method: args[0],
            url: args[1]
          };
          responseUrl = xhrData.url;

          if (typeof propsToMatch === "undefined") {
            var logMessage = "log: xhr( ".concat(objectToString(xhrData), " )");
            hit(source, logMessage);
          } else if (propsToMatch === "" || propsToMatch === getWildcardSymbol()) {
            shouldPrevent = true;
          } else {
            var parsedData = parseMatchProps(propsToMatch);

            if (!validateParsedData(parsedData)) {
              console.log("Invalid parameter: ".concat(propsToMatch));
              shouldPrevent = false;
            } else {
              var matchData = getMatchPropsData(parsedData);
              shouldPrevent = Object.keys(matchData).every(function (matchKey) {
                var matchValue = matchData[matchKey];
                return Object.prototype.hasOwnProperty.call(xhrData, matchKey) && matchValue.test(xhrData[matchKey]);
              });
            }
          }

          return Reflect.apply(target, thisArg, args);
        };

        var sendWrapper = function sendWrapper(target, thisArg, args) {
          if (!shouldPrevent) {
            return Reflect.apply(target, thisArg, args);
          }

          if (thisArg.responseType === "blob") {
            response = new Blob();
          }

          if (thisArg.responseType === "arraybuffer") {
            response = new ArrayBuffer();
          }

          if (customResponseText) {
            var randomText = generateRandomResponse(customResponseText);

            if (randomText) {
              responseText = randomText;
            } else {
              console.log("Invalid range: ".concat(customResponseText));
            }
          }

          Object.defineProperties(thisArg, {
            readyState: {
              value: 4,
              writable: false
            },
            response: {
              value: response,
              writable: false
            },
            responseText: {
              value: responseText,
              writable: false
            },
            responseURL: {
              value: responseUrl,
              writable: false
            },
            responseXML: {
              value: "",
              writable: false
            },
            status: {
              value: 200,
              writable: false
            },
            statusText: {
              value: "OK",
              writable: false
            }
          });
          setTimeout(function () {
            var stateEvent = new Event("readystatechange");
            thisArg.dispatchEvent(stateEvent);
            var loadEvent = new Event("load");
            thisArg.dispatchEvent(loadEvent);
            var loadEndEvent = new Event("loadend");
            thisArg.dispatchEvent(loadEndEvent);
          }, 1);
          hit(source);
          return undefined;
        };

        var openHandler = {
          apply: openWrapper
        };
        var sendHandler = {
          apply: sendWrapper
        };
        XMLHttpRequest.prototype.open = new Proxy(XMLHttpRequest.prototype.open, openHandler);
        XMLHttpRequest.prototype.send = new Proxy(XMLHttpRequest.prototype.send, sendHandler);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function objectToString(obj) {
        return isEmptyObject(obj) ? "{}" : getObjectEntries(obj).map(function (pair) {
          var key = pair[0];
          var value = pair[1];
          var recordValueStr = value;

          if (value instanceof Object) {
            recordValueStr = "{ ".concat(objectToString(value), " }");
          }

          return "".concat(key, ':"').concat(recordValueStr, '"');
        }).join(" ");
      }

      function getWildcardSymbol() {
        return "*";
      }

      function parseMatchProps(propsToMatchStr) {
        var PROPS_DIVIDER = " ";
        var PAIRS_MARKER = ":";
        var propsObj = {};
        var props = propsToMatchStr.split(PROPS_DIVIDER);
        props.forEach(function (prop) {
          var dividerInd = prop.indexOf(PAIRS_MARKER);

          if (dividerInd === -1) {
            propsObj.url = prop;
          } else {
            var key = prop.slice(0, dividerInd);
            var value = prop.slice(dividerInd + 1);
            propsObj[key] = value;
          }
        });
        return propsObj;
      }

      function validateParsedData(data) {
        return Object.values(data).every(function (value) {
          return isValidStrPattern(value);
        });
      }

      function getMatchPropsData(data) {
        var matchData = {};
        Object.keys(data).forEach(function (key) {
          matchData[key] = toRegExp(data[key]);
        });
        return matchData;
      }

      function getRandomIntInclusive(min, max) {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min + 1) + min);
      }

      function getRandomStrByLength(length) {
        var result = "";
        var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+=~";
        var charactersLength = characters.length;

        for (var i = 0; i < length; i += 1) {
          result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
      }

      function generateRandomResponse(customResponseText) {
        var customResponse = customResponseText;

        if (customResponse === "true") {
          customResponse = Math.random().toString(36).slice(-10);
          return customResponse;
        }

        customResponse = customResponse.replace("length:", "");
        var rangeRegex = /^\d+-\d+$/;

        if (!rangeRegex.test(customResponse)) {
          return null;
        }

        var rangeMin = getNumberFromString(customResponse.split("-")[0]);
        var rangeMax = getNumberFromString(customResponse.split("-")[1]);

        if (!nativeIsFinite(rangeMin) || !nativeIsFinite(rangeMax)) {
          return null;
        }

        if (rangeMin > rangeMax) {
          var temp = rangeMin;
          rangeMin = rangeMax;
          rangeMax = temp;
        }

        var LENGTH_RANGE_LIMIT = 500 * 1e3;

        if (rangeMax > LENGTH_RANGE_LIMIT) {
          return null;
        }

        var length = getRandomIntInclusive(rangeMin, rangeMax);
        customResponse = getRandomStrByLength(length);
        return customResponse;
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function isValidStrPattern(input) {
        var FORWARD_SLASH = "/";
        var str = escapeRegExp(input);

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          str = input.slice(1, -1);
        }

        var isValid;

        try {
          isValid = new RegExp(str);
          isValid = true;
        } catch (e) {
          isValid = false;
        }

        return isValid;
      }

      function escapeRegExp(str) {
        return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      }

      function isEmptyObject(obj) {
        return Object.keys(obj).length === 0;
      }

      function getObjectEntries(object) {
        var keys = Object.keys(object);
        var entries = [];
        keys.forEach(function (key) {
          return entries.push([key, object[key]]);
        });
        return entries;
      }

      function getNumberFromString(rawString) {
        var parsedDelay = parseInt(rawString, 10);
        var validDelay = nativeIsNaN(parsedDelay) ? null : parsedDelay;
        return validDelay;
      }

      function nativeIsFinite(num) {
        var native = Number.isFinite || window.isFinite;
        return native(num);
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        preventXHR.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function removeAttr(source, args) {
      function removeAttr(source, attrs, selector) {
        var applying = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "asap stay";

        if (!attrs) {
          return;
        }

        attrs = attrs.split(/\s*\|\s*/);

        if (!selector) {
          selector = "[".concat(attrs.join("],["), "]");
        }

        var rmattr = function rmattr() {
          var nodes = [];

          try {
            nodes = [].slice.call(document.querySelectorAll(selector));
          } catch (e) {
            console.log("Invalid remove-attr selector arg: '".concat(selector, "'"));
          }

          var removed = false;
          nodes.forEach(function (node) {
            attrs.forEach(function (attr) {
              node.removeAttribute(attr);
              removed = true;
            });
          });

          if (removed) {
            hit(source);
          }
        };

        var flags = parseFlags(applying);

        var run = function run() {
          rmattr();

          if (!flags.hasFlag(flags.STAY)) {
            return;
          }

          observeDOMChanges(rmattr, true);
        };

        if (flags.hasFlag(flags.ASAP)) {
          if (document.readyState === "loading") {
            window.addEventListener("DOMContentLoaded", rmattr, {
              once: true
            });
          } else {
            rmattr();
          }
        }

        if (document.readyState !== "complete" && flags.hasFlag(flags.COMPLETE)) {
          window.addEventListener("load", run, {
            once: true
          });
        } else if (flags.hasFlag(flags.STAY)) {
          if (!applying.indexOf(" ") !== -1) {
            rmattr();
          }

          observeDOMChanges(rmattr, true);
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function observeDOMChanges(callback) {
        var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var throttle = function throttle(method, delay) {
          var wait = false;
          var savedArgs;

          var wrapper = function wrapper() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            if (wait) {
              savedArgs = args;
              return;
            }

            method.apply(void 0, args);
            wait = true;
            setTimeout(function () {
              wait = false;

              if (savedArgs) {
                wrapper(savedArgs);
                savedArgs = null;
              }
            }, delay);
          };

          return wrapper;
        };

        var THROTTLE_DELAY_MS = 20;
        var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

        var connect = function connect() {
          if (attrsToObserve.length > 0) {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs,
              attributeFilter: attrsToObserve
            });
          } else {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs
            });
          }
        };

        var disconnect = function disconnect() {
          observer.disconnect();
        };

        function callbackWrapper() {
          disconnect();
          callback();
          connect();
        }

        connect();
      }

      function parseFlags(flags) {
        var FLAGS_DIVIDER = " ";
        var ASAP_FLAG = "asap";
        var COMPLETE_FLAG = "complete";
        var STAY_FLAG = "stay";
        var VALID_FLAGS = [STAY_FLAG, ASAP_FLAG, COMPLETE_FLAG];
        var passedFlags = flags.trim().split(FLAGS_DIVIDER).filter(function (f) {
          return VALID_FLAGS.indexOf(f) !== -1;
        });
        return {
          ASAP: ASAP_FLAG,
          COMPLETE: COMPLETE_FLAG,
          STAY: STAY_FLAG,
          hasFlag: function hasFlag(flag) {
            return passedFlags.indexOf(flag) !== -1;
          }
        };
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        removeAttr.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function removeClass(source, args) {
      function removeClass(source, classNames, selector) {
        var applying = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "asap stay";

        if (!classNames) {
          return;
        }

        classNames = classNames.split(/\s*\|\s*/);
        var selectors = [];

        if (!selector) {
          selectors = classNames.map(function (className) {
            return ".".concat(className);
          });
        }

        var removeClassHandler = function removeClassHandler() {
          var nodes = new Set();

          if (selector) {
            var foundNodes = [];

            try {
              foundNodes = [].slice.call(document.querySelectorAll(selector));
            } catch (e) {
              console.log("Invalid remove-class selector arg: '".concat(selector, "'"));
            }

            foundNodes.forEach(function (n) {
              return nodes.add(n);
            });
          } else if (selectors.length > 0) {
            selectors.forEach(function (s) {
              var elements = document.querySelectorAll(s);

              for (var i = 0; i < elements.length; i += 1) {
                var element = elements[i];
                nodes.add(element);
              }
            });
          }

          var removed = false;
          nodes.forEach(function (node) {
            classNames.forEach(function (className) {
              if (node.classList.contains(className)) {
                node.classList.remove(className);
                removed = true;
              }
            });
          });

          if (removed) {
            hit(source);
          }
        };

        var CLASS_ATTR_NAME = ["class"];
        var flags = parseFlags(applying);

        var run = function run() {
          removeClassHandler();

          if (!flags.hasFlag(flags.STAY)) {
            return;
          }

          observeDOMChanges(removeClassHandler, true, CLASS_ATTR_NAME);
        };

        if (flags.hasFlag(flags.ASAP)) {
          if (document.readyState === "loading") {
            window.addEventListener("DOMContentLoaded", removeClassHandler, {
              once: true
            });
          } else {
            removeClassHandler();
          }
        }

        if (document.readyState !== "complete" && flags.hasFlag(flags.COMPLETE)) {
          window.addEventListener("load", run, {
            once: true
          });
        } else if (flags.hasFlag(flags.STAY)) {
          if (!applying.indexOf(" ") !== -1) {
            removeClassHandler();
          }

          observeDOMChanges(removeClassHandler, true, CLASS_ATTR_NAME);
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function observeDOMChanges(callback) {
        var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var throttle = function throttle(method, delay) {
          var wait = false;
          var savedArgs;

          var wrapper = function wrapper() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            if (wait) {
              savedArgs = args;
              return;
            }

            method.apply(void 0, args);
            wait = true;
            setTimeout(function () {
              wait = false;

              if (savedArgs) {
                wrapper(savedArgs);
                savedArgs = null;
              }
            }, delay);
          };

          return wrapper;
        };

        var THROTTLE_DELAY_MS = 20;
        var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

        var connect = function connect() {
          if (attrsToObserve.length > 0) {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs,
              attributeFilter: attrsToObserve
            });
          } else {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs
            });
          }
        };

        var disconnect = function disconnect() {
          observer.disconnect();
        };

        function callbackWrapper() {
          disconnect();
          callback();
          connect();
        }

        connect();
      }

      function parseFlags(flags) {
        var FLAGS_DIVIDER = " ";
        var ASAP_FLAG = "asap";
        var COMPLETE_FLAG = "complete";
        var STAY_FLAG = "stay";
        var VALID_FLAGS = [STAY_FLAG, ASAP_FLAG, COMPLETE_FLAG];
        var passedFlags = flags.trim().split(FLAGS_DIVIDER).filter(function (f) {
          return VALID_FLAGS.indexOf(f) !== -1;
        });
        return {
          ASAP: ASAP_FLAG,
          COMPLETE: COMPLETE_FLAG,
          STAY: STAY_FLAG,
          hasFlag: function hasFlag(flag) {
            return passedFlags.indexOf(flag) !== -1;
          }
        };
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        removeClass.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function removeCookie(source, args) {
      function removeCookie(source, match) {
        var matchRegexp = toRegExp(match);

        var removeCookieFromHost = function removeCookieFromHost(cookieName, hostName) {
          var cookieSpec = "".concat(cookieName, "=");
          var domain1 = "; domain=".concat(hostName);
          var domain2 = "; domain=.".concat(hostName);
          var path = "; path=/";
          var expiration = "; expires=Thu, 01 Jan 1970 00:00:00 GMT";
          document.cookie = cookieSpec + expiration;
          document.cookie = cookieSpec + domain1 + expiration;
          document.cookie = cookieSpec + domain2 + expiration;
          document.cookie = cookieSpec + path + expiration;
          document.cookie = cookieSpec + domain1 + path + expiration;
          document.cookie = cookieSpec + domain2 + path + expiration;
          hit(source);
        };

        var rmCookie = function rmCookie() {
          document.cookie.split(";").forEach(function (cookieStr) {
            var pos = cookieStr.indexOf("=");

            if (pos === -1) {
              return;
            }

            var cookieName = cookieStr.slice(0, pos).trim();

            if (!matchRegexp.test(cookieName)) {
              return;
            }

            var hostParts = document.location.hostname.split(".");

            for (var i = 0; i <= hostParts.length - 1; i += 1) {
              var hostName = hostParts.slice(i).join(".");

              if (hostName) {
                removeCookieFromHost(cookieName, hostName);
              }
            }
          });
        };

        rmCookie();
        window.addEventListener("beforeunload", rmCookie);
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        removeCookie.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function removeInShadowDom(source, args) {
      function removeInShadowDom(source, selector, baseSelector) {
        if (!Element.prototype.attachShadow) {
          return;
        }

        var removeElement = function removeElement(targetElement) {
          targetElement.remove();
        };

        var removeHandler = function removeHandler() {
          var hostElements = !baseSelector ? findHostElements(document.documentElement) : document.querySelectorAll(baseSelector);

          while (hostElements.length !== 0) {
            var isRemoved = false;

            var _pierceShadowDom = pierceShadowDom(selector, hostElements),
                targets = _pierceShadowDom.targets,
                innerHosts = _pierceShadowDom.innerHosts;

            targets.forEach(function (targetEl) {
              removeElement(targetEl);
              isRemoved = true;
            });

            if (isRemoved) {
              hit(source);
            }

            hostElements = innerHosts;
          }
        };

        removeHandler();
        observeDOMChanges(removeHandler, true);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function observeDOMChanges(callback) {
        var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var throttle = function throttle(method, delay) {
          var wait = false;
          var savedArgs;

          var wrapper = function wrapper() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            if (wait) {
              savedArgs = args;
              return;
            }

            method.apply(void 0, args);
            wait = true;
            setTimeout(function () {
              wait = false;

              if (savedArgs) {
                wrapper(savedArgs);
                savedArgs = null;
              }
            }, delay);
          };

          return wrapper;
        };

        var THROTTLE_DELAY_MS = 20;
        var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

        var connect = function connect() {
          if (attrsToObserve.length > 0) {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs,
              attributeFilter: attrsToObserve
            });
          } else {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs
            });
          }
        };

        var disconnect = function disconnect() {
          observer.disconnect();
        };

        function callbackWrapper() {
          disconnect();
          callback();
          connect();
        }

        connect();
      }

      function flatten(input) {
        var stack = [];
        input.forEach(function (el) {
          return stack.push(el);
        });
        var res = [];

        while (stack.length) {
          var next = stack.pop();

          if (Array.isArray(next)) {
            next.forEach(function (el) {
              return stack.push(el);
            });
          } else {
            res.push(next);
          }
        }

        return res.reverse();
      }

      function findHostElements(rootElement) {
        var hosts = [];
        var domElems = rootElement.querySelectorAll("*");
        domElems.forEach(function (el) {
          if (el.shadowRoot) {
            hosts.push(el);
          }
        });
        return hosts;
      }

      function pierceShadowDom(selector, hostElements) {
        var targets = [];
        var innerHostsAcc = [];
        hostElements.forEach(function (host) {
          var simpleElems = host.querySelectorAll(selector);
          targets = targets.concat([].slice.call(simpleElems));
          var shadowRootElem = host.shadowRoot;
          var shadowChildren = shadowRootElem.querySelectorAll(selector);
          targets = targets.concat([].slice.call(shadowChildren));
          innerHostsAcc.push(findHostElements(shadowRootElem));
        });
        var innerHosts = flatten(innerHostsAcc);
        return {
          targets: targets,
          innerHosts: innerHosts
        };
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        removeInShadowDom.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setAttr(source, args) {
      function setAttr(source, selector, attr) {
        var value = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "";

        if (!selector || !attr) {
          return;
        }

        if (value.length !== 0 && (nativeIsNaN(parseInt(value, 10)) || parseInt(value, 10) < 0 || parseInt(value, 10) > 32767)) {
          return;
        }

        var setAttr = function setAttr() {
          var nodes = [].slice.call(document.querySelectorAll(selector));
          var set = false;
          nodes.forEach(function (node) {
            node.setAttribute(attr, value);
            set = true;
          });

          if (set) {
            hit(source);
          }
        };

        setAttr();
        observeDOMChanges(setAttr, true);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function observeDOMChanges(callback) {
        var observeAttrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        var attrsToObserve = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

        var throttle = function throttle(method, delay) {
          var wait = false;
          var savedArgs;

          var wrapper = function wrapper() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            if (wait) {
              savedArgs = args;
              return;
            }

            method.apply(void 0, args);
            wait = true;
            setTimeout(function () {
              wait = false;

              if (savedArgs) {
                wrapper(savedArgs);
                savedArgs = null;
              }
            }, delay);
          };

          return wrapper;
        };

        var THROTTLE_DELAY_MS = 20;
        var observer = new MutationObserver(throttle(callbackWrapper, THROTTLE_DELAY_MS));

        var connect = function connect() {
          if (attrsToObserve.length > 0) {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs,
              attributeFilter: attrsToObserve
            });
          } else {
            observer.observe(document.documentElement, {
              childList: true,
              subtree: true,
              attributes: observeAttrs
            });
          }
        };

        var disconnect = function disconnect() {
          observer.disconnect();
        };

        function callbackWrapper() {
          disconnect();
          callback();
          connect();
        }

        connect();
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setAttr.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setConstant(source, args) {
      function setConstant(source, property, value, stack) {
        if (!property || !matchStackTrace(stack, new Error().stack)) {
          return;
        }

        var log = console.log.bind(console);
        var emptyArr = noopArray();
        var emptyObj = noopObject();
        var constantValue;

        if (value === "undefined") {
          constantValue = undefined;
        } else if (value === "false") {
          constantValue = false;
        } else if (value === "true") {
          constantValue = true;
        } else if (value === "null") {
          constantValue = null;
        } else if (value === "emptyArr") {
          constantValue = emptyArr;
        } else if (value === "emptyObj") {
          constantValue = emptyObj;
        } else if (value === "noopFunc") {
          constantValue = noopFunc;
        } else if (value === "trueFunc") {
          constantValue = trueFunc;
        } else if (value === "falseFunc") {
          constantValue = falseFunc;
        } else if (value === "noopPromiseResolve") {
          constantValue = noopPromiseResolve;
        } else if (value === "noopPromiseReject") {
          constantValue = noopPromiseReject;
        } else if (/^\d+$/.test(value)) {
          constantValue = parseFloat(value);

          if (nativeIsNaN(constantValue)) {
            return;
          }

          if (Math.abs(constantValue) > 32767) {
            return;
          }
        } else if (value === "-1") {
          constantValue = -1;
        } else if (value === "") {
          constantValue = "";
        } else if (value === "yes") {
          constantValue = "yes";
        } else if (value === "no") {
          constantValue = "no";
        } else {
          return;
        }

        var canceled = false;

        var mustCancel = function mustCancel(value) {
          if (canceled) {
            return canceled;
          }

          canceled = value !== undefined && constantValue !== undefined && typeof value !== typeof constantValue;
          return canceled;
        };

        var trapProp = function trapProp(base, prop, configurable, handler) {
          if (!handler.init(base[prop])) {
            return false;
          }

          var origDescriptor = Object.getOwnPropertyDescriptor(base, prop);
          var prevSetter;

          if (origDescriptor instanceof Object) {
            if (!origDescriptor.configurable) {
              if (source.verbose) {
                log("set-constant: property '".concat(prop, "' is not configurable"));
              }

              return false;
            }

            base[prop] = constantValue;

            if (origDescriptor.set instanceof Function) {
              prevSetter = origDescriptor.set;
            }
          }

          Object.defineProperty(base, prop, {
            configurable: configurable,
            get: function get() {
              return handler.get();
            },
            set: function set(a) {
              if (prevSetter !== undefined) {
                prevSetter(a);
              }

              handler.set(a);
            }
          });
          return true;
        };

        var setChainPropAccess = function setChainPropAccess(owner, property) {
          var chainInfo = getPropertyInChain(owner, property);
          var base = chainInfo.base;
          var prop = chainInfo.prop,
              chain = chainInfo.chain;
          var undefPropHandler = {
            factValue: undefined,
            init: function init(a) {
              this.factValue = a;
              return true;
            },
            get: function get() {
              return this.factValue;
            },
            set: function set(a) {
              if (this.factValue === a) {
                return;
              }

              this.factValue = a;

              if (a instanceof Object) {
                setChainPropAccess(a, chain);
              }
            }
          };
          var endPropHandler = {
            init: function init(a) {
              if (mustCancel(a)) {
                return false;
              }

              return true;
            },
            get: function get() {
              return constantValue;
            },
            set: function set(a) {
              if (!mustCancel(a)) {
                return;
              }

              constantValue = a;
            }
          };

          if (!chain) {
            var isTrapped = trapProp(base, prop, false, endPropHandler);

            if (isTrapped) {
              hit(source);
            }

            return;
          }

          var propValue = owner[prop];

          if (propValue instanceof Object || typeof propValue === "object" && propValue !== null) {
            setChainPropAccess(propValue, chain);
          }

          trapProp(base, prop, true, undefPropHandler);
        };

        setChainPropAccess(window, property);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function noopArray() {
        return [];
      }

      function noopObject() {
        return {};
      }

      function noopFunc() {}

      function trueFunc() {
        return true;
      }

      function falseFunc() {
        return false;
      }

      function noopPromiseReject() {
        return Promise.reject();
      }

      function noopPromiseResolve() {
        var responseBody = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "{}";

        if (typeof Response === "undefined") {
          return;
        }

        var response = new Response(responseBody, {
          status: 200,
          statusText: "OK"
        });
        return Promise.resolve(response);
      }

      function getPropertyInChain(base, chain) {
        var pos = chain.indexOf(".");

        if (pos === -1) {
          return {
            base: base,
            prop: chain
          };
        }

        var prop = chain.slice(0, pos);

        if (base === null) {
          return {
            base: base,
            prop: prop,
            chain: chain
          };
        }

        var nextBase = base[prop];
        chain = chain.slice(pos + 1);

        if (nextBase !== undefined) {
          return getPropertyInChain(nextBase, chain);
        }

        Object.defineProperty(base, prop, {
          configurable: true
        });
        return {
          base: base,
          prop: prop,
          chain: chain
        };
      }

      function toRegExp() {
        var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
        var DEFAULT_VALUE = ".?";
        var FORWARD_SLASH = "/";

        if (input === "") {
          return new RegExp(DEFAULT_VALUE);
        }

        if (input[0] === FORWARD_SLASH && input[input.length - 1] === FORWARD_SLASH) {
          return new RegExp(input.slice(1, -1));
        }

        var escaped = input.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        return new RegExp(escaped);
      }

      function matchStackTrace(stackMatch, stackTrace) {
        if (!stackMatch || stackMatch === "") {
          return true;
        }

        var stackRegexp = toRegExp(stackMatch);
        var refinedStackTrace = stackTrace.split("\n").slice(2).map(function (line) {
          return line.trim();
        }).join("\n");
        return getNativeRegexpTest().call(stackRegexp, refinedStackTrace);
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function getNativeRegexpTest() {
        return Object.getOwnPropertyDescriptor(RegExp.prototype, "test").value;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setConstant.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setCookie(source, args) {
      function setCookie(source, name, value) {
        var cookieData = prepareCookie(name, value);

        if (cookieData) {
          hit(source);
          document.cookie = cookieData;
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function prepareCookie(name, value) {
        if (!name || !value) {
          return null;
        }

        var valueToSet;

        if (value === "true") {
          valueToSet = "true";
        } else if (value === "True") {
          valueToSet = "True";
        } else if (value === "false") {
          valueToSet = "false";
        } else if (value === "False") {
          valueToSet = "False";
        } else if (value === "yes") {
          valueToSet = "yes";
        } else if (value === "Yes") {
          valueToSet = "Yes";
        } else if (value === "Y") {
          valueToSet = "Y";
        } else if (value === "no") {
          valueToSet = "no";
        } else if (value === "ok") {
          valueToSet = "ok";
        } else if (value === "OK") {
          valueToSet = "OK";
        } else if (/^\d+$/.test(value)) {
          valueToSet = parseFloat(value);

          if (nativeIsNaN(valueToSet)) {
            return null;
          }

          if (Math.abs(valueToSet) < 0 || Math.abs(valueToSet) > 15) {
            return null;
          }
        } else {
          return null;
        }

        var pathToSet = "path=/;";
        var cookieData = "".concat(encodeURIComponent(name), "=").concat(encodeURIComponent(valueToSet), "; ").concat(pathToSet);
        return cookieData;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setCookie.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setCookieReload(source, args) {
      function setCookieReload(source, name, value) {
        var isCookieSetWithValue = function isCookieSetWithValue(name, value) {
          return document.cookie.split(";").some(function (cookieStr) {
            var pos = cookieStr.indexOf("=");

            if (pos === -1) {
              return false;
            }

            var cookieName = cookieStr.slice(0, pos).trim();
            var cookieValue = cookieStr.slice(pos + 1).trim();
            return name === cookieName && value === cookieValue;
          });
        };

        if (isCookieSetWithValue(name, value)) {
          return;
        }

        var cookieData = prepareCookie(name, value);

        if (cookieData) {
          document.cookie = cookieData;
          hit(source);

          if (isCookieSetWithValue(name, value)) {
            window.location.reload();
          }
        }
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      function prepareCookie(name, value) {
        if (!name || !value) {
          return null;
        }

        var valueToSet;

        if (value === "true") {
          valueToSet = "true";
        } else if (value === "True") {
          valueToSet = "True";
        } else if (value === "false") {
          valueToSet = "false";
        } else if (value === "False") {
          valueToSet = "False";
        } else if (value === "yes") {
          valueToSet = "yes";
        } else if (value === "Yes") {
          valueToSet = "Yes";
        } else if (value === "Y") {
          valueToSet = "Y";
        } else if (value === "no") {
          valueToSet = "no";
        } else if (value === "ok") {
          valueToSet = "ok";
        } else if (value === "OK") {
          valueToSet = "OK";
        } else if (/^\d+$/.test(value)) {
          valueToSet = parseFloat(value);

          if (nativeIsNaN(valueToSet)) {
            return null;
          }

          if (Math.abs(valueToSet) < 0 || Math.abs(valueToSet) > 15) {
            return null;
          }
        } else {
          return null;
        }

        var pathToSet = "path=/;";
        var cookieData = "".concat(encodeURIComponent(name), "=").concat(encodeURIComponent(valueToSet), "; ").concat(pathToSet);
        return cookieData;
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setCookieReload.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setLocalStorageItem(source, args) {
      function setLocalStorageItem(source, key, value) {
        if (!key || !value && value !== "") {
          return;
        }

        var keyValue;

        if (value === "undefined") {
          keyValue = undefined;
        } else if (value === "false") {
          keyValue = false;
        } else if (value === "true") {
          keyValue = true;
        } else if (value === "null") {
          keyValue = null;
        } else if (value === "emptyArr") {
          keyValue = "[]";
        } else if (value === "emptyObj") {
          keyValue = "{}";
        } else if (value === "") {
          keyValue = "";
        } else if (/^\d+$/.test(value)) {
          keyValue = parseFloat(value);

          if (nativeIsNaN(keyValue)) {
            return;
          }

          if (Math.abs(keyValue) > 32767) {
            return;
          }
        } else if (value === "yes") {
          keyValue = "yes";
        } else if (value === "no") {
          keyValue = "no";
        } else {
          return;
        }

        var setItem = function setItem(key, value) {
          var _window = window,
              localStorage = _window.localStorage;

          try {
            localStorage.setItem(key, value);
            hit(source);
          } catch (e) {
            if (source.verbose) {
              console.log("Was unable to set localStorage item due to: ".concat(e.message));
            }
          }
        };

        setItem(key, keyValue);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setLocalStorageItem.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setPopadsDummy(source, args) {
      function setPopadsDummy(source) {
        delete window.PopAds;
        delete window.popns;
        Object.defineProperties(window, {
          PopAds: {
            get: function get() {
              hit(source);
              return {};
            }
          },
          popns: {
            get: function get() {
              hit(source);
              return {};
            }
          }
        });
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setPopadsDummy.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    function setSessionStorageItem(source, args) {
      function setSessionStorageItem(source, key, value) {
        if (!key || !value && value !== "") {
          return;
        }

        var keyValue;

        if (value === "undefined") {
          keyValue = undefined;
        } else if (value === "false") {
          keyValue = false;
        } else if (value === "true") {
          keyValue = true;
        } else if (value === "null") {
          keyValue = null;
        } else if (value === "emptyArr") {
          keyValue = "[]";
        } else if (value === "emptyObj") {
          keyValue = "{}";
        } else if (value === "") {
          keyValue = "";
        } else if (/^\d+$/.test(value)) {
          keyValue = parseFloat(value);

          if (nativeIsNaN(keyValue)) {
            return;
          }

          if (Math.abs(keyValue) > 32767) {
            return;
          }
        } else if (value === "yes") {
          keyValue = "yes";
        } else if (value === "no") {
          keyValue = "no";
        } else {
          return;
        }

        var setItem = function setItem(key, value) {
          var _window = window,
              sessionStorage = _window.sessionStorage;

          try {
            sessionStorage.setItem(key, value);
            hit(source);
          } catch (e) {
            if (source.verbose) {
              console.log("Was unable to set sessionStorage item due to: ".concat(e.message));
            }
          }
        };

        setItem(key, keyValue);
      }

      function hit(source, message) {
        if (source.verbose !== true) {
          return;
        }

        try {
          var log = console.log.bind(console);
          var trace = console.trace.bind(console);
          var prefix = source.ruleText || "";

          if (source.domainName) {
            var AG_SCRIPTLET_MARKER = "#%#//";
            var UBO_SCRIPTLET_MARKER = "##+js";
            var ruleStartIndex;

            if (source.ruleText.indexOf(AG_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(AG_SCRIPTLET_MARKER);
            } else if (source.ruleText.indexOf(UBO_SCRIPTLET_MARKER) > -1) {
              ruleStartIndex = source.ruleText.indexOf(UBO_SCRIPTLET_MARKER);
            }

            var rulePart = source.ruleText.slice(ruleStartIndex);
            prefix = "".concat(source.domainName).concat(rulePart);
          }

          var LOG_MARKER = "log: ";

          if (message) {
            if (message.indexOf(LOG_MARKER) === -1) {
              log("".concat(prefix, " message:\n").concat(message));
            } else {
              log(message.slice(LOG_MARKER.length));
            }
          }

          log("".concat(prefix, " trace start"));

          if (trace) {
            trace();
          }

          log("".concat(prefix, " trace end"));
        } catch (e) {}

        if (typeof window.__debug === "function") {
          window.__debug(source);
        }
      }

      function nativeIsNaN(num) {
        var native = Number.isNaN || window.isNaN;
        return native(num);
      }

      var updatedArgs = args ? [].concat(source).concat(args) : [source];

      try {
        setSessionStorageItem.apply(this, updatedArgs);
      } catch (e) {
        console.log(e);
      }
    }

    var scriptletsMap = {
      "abort-current-inline-script": abortCurrentInlineScript,
      "abort-current-script.js": abortCurrentInlineScript,
      "ubo-abort-current-script.js": abortCurrentInlineScript,
      "acs.js": abortCurrentInlineScript,
      "ubo-acs.js": abortCurrentInlineScript,
      "ubo-abort-current-script": abortCurrentInlineScript,
      "ubo-acs": abortCurrentInlineScript,
      "abort-current-inline-script.js": abortCurrentInlineScript,
      "ubo-abort-current-inline-script.js": abortCurrentInlineScript,
      "acis.js": abortCurrentInlineScript,
      "ubo-acis.js": abortCurrentInlineScript,
      "ubo-abort-current-inline-script": abortCurrentInlineScript,
      "ubo-acis": abortCurrentInlineScript,
      "abp-abort-current-inline-script": abortCurrentInlineScript,
      "abort-on-property-read": abortOnPropertyRead,
      "abort-on-property-read.js": abortOnPropertyRead,
      "ubo-abort-on-property-read.js": abortOnPropertyRead,
      "aopr.js": abortOnPropertyRead,
      "ubo-aopr.js": abortOnPropertyRead,
      "ubo-abort-on-property-read": abortOnPropertyRead,
      "ubo-aopr": abortOnPropertyRead,
      "abp-abort-on-property-read": abortOnPropertyRead,
      "abort-on-property-write": abortOnPropertyWrite,
      "abort-on-property-write.js": abortOnPropertyWrite,
      "ubo-abort-on-property-write.js": abortOnPropertyWrite,
      "aopw.js": abortOnPropertyWrite,
      "ubo-aopw.js": abortOnPropertyWrite,
      "ubo-abort-on-property-write": abortOnPropertyWrite,
      "ubo-aopw": abortOnPropertyWrite,
      "abp-abort-on-property-write": abortOnPropertyWrite,
      "abort-on-stack-trace": abortOnStackTrace,
      "abort-on-stack-trace.js": abortOnStackTrace,
      "ubo-abort-on-stack-trace.js": abortOnStackTrace,
      "aost.js": abortOnStackTrace,
      "ubo-aost.js": abortOnStackTrace,
      "ubo-abort-on-stack-trace": abortOnStackTrace,
      "ubo-aost": abortOnStackTrace,
      "abp-abort-on-stack-trace": abortOnStackTrace,
      "adjust-setInterval": adjustSetInterval,
      "nano-setInterval-booster.js": adjustSetInterval,
      "ubo-nano-setInterval-booster.js": adjustSetInterval,
      "nano-sib.js": adjustSetInterval,
      "ubo-nano-sib.js": adjustSetInterval,
      "ubo-nano-setInterval-booster": adjustSetInterval,
      "ubo-nano-sib": adjustSetInterval,
      "adjust-setTimeout": adjustSetTimeout,
      "nano-setTimeout-booster.js": adjustSetTimeout,
      "ubo-nano-setTimeout-booster.js": adjustSetTimeout,
      "nano-stb.js": adjustSetTimeout,
      "ubo-nano-stb.js": adjustSetTimeout,
      "ubo-nano-setTimeout-booster": adjustSetTimeout,
      "ubo-nano-stb": adjustSetTimeout,
      "debug-current-inline-script": debugCurrentInlineScript,
      "debug-on-property-read": debugOnPropertyRead,
      "debug-on-property-write": debugOnPropertyWrite,
      "dir-string": dirString,
      "abp-dir-string": dirString,
      "disable-newtab-links": disableNewtabLinks,
      "disable-newtab-links.js": disableNewtabLinks,
      "ubo-disable-newtab-links.js": disableNewtabLinks,
      "ubo-disable-newtab-links": disableNewtabLinks,
      "close-window": forceWindowClose,
      "window-close-if.js": forceWindowClose,
      "ubo-window-close-if.js": forceWindowClose,
      "ubo-window-close-if": forceWindowClose,
      "hide-in-shadow-dom": hideInShadowDom,
      "json-prune": jsonPrune,
      "json-prune.js": jsonPrune,
      "ubo-json-prune.js": jsonPrune,
      "ubo-json-prune": jsonPrune,
      "abp-json-prune": jsonPrune,
      log: log,
      "log-addEventListener": logAddEventListener,
      "addEventListener-logger.js": logAddEventListener,
      "ubo-addEventListener-logger.js": logAddEventListener,
      "aell.js": logAddEventListener,
      "ubo-aell.js": logAddEventListener,
      "ubo-addEventListener-logger": logAddEventListener,
      "ubo-aell": logAddEventListener,
      "log-eval": logEval,
      "log-on-stack-trace": logOnStacktrace,
      "no-topics": noTopics,
      noeval: noeval,
      "noeval.js": noeval,
      "silent-noeval.js": noeval,
      "ubo-noeval.js": noeval,
      "ubo-silent-noeval.js": noeval,
      "ubo-noeval": noeval,
      "ubo-silent-noeval": noeval,
      nowebrtc: nowebrtc,
      "nowebrtc.js": nowebrtc,
      "ubo-nowebrtc.js": nowebrtc,
      "ubo-nowebrtc": nowebrtc,
      "prevent-addEventListener": preventAddEventListener,
      "addEventListener-defuser.js": preventAddEventListener,
      "ubo-addEventListener-defuser.js": preventAddEventListener,
      "aeld.js": preventAddEventListener,
      "ubo-aeld.js": preventAddEventListener,
      "ubo-addEventListener-defuser": preventAddEventListener,
      "ubo-aeld": preventAddEventListener,
      "prevent-adfly": preventAdfly,
      "adfly-defuser.js": preventAdfly,
      "ubo-adfly-defuser.js": preventAdfly,
      "ubo-adfly-defuser": preventAdfly,
      "prevent-bab": preventBab,
      "nobab.js": preventBab,
      "ubo-nobab.js": preventBab,
      "bab-defuser.js": preventBab,
      "ubo-bab-defuser.js": preventBab,
      "ubo-nobab": preventBab,
      "ubo-bab-defuser": preventBab,
      "prevent-element-src-loading": preventElementSrcLoading,
      "prevent-eval-if": preventEvalIf,
      "noeval-if.js": preventEvalIf,
      "ubo-noeval-if.js": preventEvalIf,
      "ubo-noeval-if": preventEvalIf,
      "prevent-fab-3.2.0": preventFab,
      "nofab.js": preventFab,
      "ubo-nofab.js": preventFab,
      "fuckadblock.js-3.2.0": preventFab,
      "ubo-fuckadblock.js-3.2.0": preventFab,
      "ubo-nofab": preventFab,
      "prevent-fetch": preventFetch,
      "no-fetch-if.js": preventFetch,
      "ubo-no-fetch-if.js": preventFetch,
      "ubo-no-fetch-if": preventFetch,
      "prevent-popads-net": preventPopadsNet,
      "popads.net.js": preventPopadsNet,
      "ubo-popads.net.js": preventPopadsNet,
      "ubo-popads.net": preventPopadsNet,
      "prevent-refresh": preventRefresh,
      "refresh-defuser.js": preventRefresh,
      "refresh-defuser": preventRefresh,
      "ubo-refresh-defuser.js": preventRefresh,
      "ubo-refresh-defuser": preventRefresh,
      "prevent-requestAnimationFrame": preventRequestAnimationFrame,
      "no-requestAnimationFrame-if.js": preventRequestAnimationFrame,
      "ubo-no-requestAnimationFrame-if.js": preventRequestAnimationFrame,
      "norafif.js": preventRequestAnimationFrame,
      "ubo-norafif.js": preventRequestAnimationFrame,
      "ubo-no-requestAnimationFrame-if": preventRequestAnimationFrame,
      "ubo-norafif": preventRequestAnimationFrame,
      "prevent-setInterval": preventSetInterval,
      "no-setInterval-if.js": preventSetInterval,
      "ubo-no-setInterval-if.js": preventSetInterval,
      "setInterval-defuser.js": preventSetInterval,
      "ubo-setInterval-defuser.js": preventSetInterval,
      "nosiif.js": preventSetInterval,
      "ubo-nosiif.js": preventSetInterval,
      "sid.js": preventSetInterval,
      "ubo-sid.js": preventSetInterval,
      "ubo-no-setInterval-if": preventSetInterval,
      "ubo-setInterval-defuser": preventSetInterval,
      "ubo-nosiif": preventSetInterval,
      "ubo-sid": preventSetInterval,
      "prevent-setTimeout": preventSetTimeout,
      "no-setTimeout-if.js": preventSetTimeout,
      "ubo-no-setTimeout-if.js": preventSetTimeout,
      "nostif.js": preventSetTimeout,
      "ubo-nostif.js": preventSetTimeout,
      "ubo-no-setTimeout-if": preventSetTimeout,
      "ubo-nostif": preventSetTimeout,
      "setTimeout-defuser.js": preventSetTimeout,
      "ubo-setTimeout-defuser.js": preventSetTimeout,
      "ubo-setTimeout-defuser": preventSetTimeout,
      "std.js": preventSetTimeout,
      "ubo-std.js": preventSetTimeout,
      "ubo-std": preventSetTimeout,
      "prevent-window-open": preventWindowOpen,
      "window.open-defuser.js": preventWindowOpen,
      "ubo-window.open-defuser.js": preventWindowOpen,
      "ubo-window.open-defuser": preventWindowOpen,
      "nowoif.js": preventWindowOpen,
      "ubo-nowoif.js": preventWindowOpen,
      "ubo-nowoif": preventWindowOpen,
      "prevent-xhr": preventXHR,
      "no-xhr-if.js": preventXHR,
      "ubo-no-xhr-if.js": preventXHR,
      "ubo-no-xhr-if": preventXHR,
      "remove-attr": removeAttr,
      "remove-attr.js": removeAttr,
      "ubo-remove-attr.js": removeAttr,
      "ra.js": removeAttr,
      "ubo-ra.js": removeAttr,
      "ubo-remove-attr": removeAttr,
      "ubo-ra": removeAttr,
      "remove-class": removeClass,
      "remove-class.js": removeClass,
      "ubo-remove-class.js": removeClass,
      "rc.js": removeClass,
      "ubo-rc.js": removeClass,
      "ubo-remove-class": removeClass,
      "ubo-rc": removeClass,
      "remove-cookie": removeCookie,
      "cookie-remover.js": removeCookie,
      "ubo-cookie-remover.js": removeCookie,
      "ubo-cookie-remover": removeCookie,
      "remove-in-shadow-dom": removeInShadowDom,
      "set-attr": setAttr,
      "set-constant": setConstant,
      "set-constant.js": setConstant,
      "ubo-set-constant.js": setConstant,
      "set.js": setConstant,
      "ubo-set.js": setConstant,
      "ubo-set-constant": setConstant,
      "ubo-set": setConstant,
      "abp-override-property-read": setConstant,
      "set-cookie": setCookie,
      "set-cookie-reload": setCookieReload,
      "set-local-storage-item": setLocalStorageItem,
      "set-popads-dummy": setPopadsDummy,
      "popads-dummy.js": setPopadsDummy,
      "ubo-popads-dummy.js": setPopadsDummy,
      "ubo-popads-dummy": setPopadsDummy,
      "set-session-storage-item": setSessionStorageItem
    };

    var getScriptletFunction = function getScriptletFunction(name) {
      return scriptletsMap[name];
    };

    /**
     * @typedef {Object} Source - scriptlet properties
     * @property {string} name Scriptlet name
     * @property {Array<string>} args Arguments for scriptlet function
     * @property {'extension'|'corelibs'|'test'} engine -
     * Defines the final form of scriptlet string presentation
     * @property {string} [version]
     * @property {boolean} [verbose] flag to enable printing to console debug information
     * @property {string} [ruleText] Source rule text is used for debugging purposes
     * @property {string} [domainName] domain name where scriptlet is applied; for debugging purposes
     */

    /**
     * Returns scriptlet code by param
     * @param {Source} source
     * @returns {string|null} scriptlet code
     */

    function getScriptletCode(source) {
      if (!validator.isValidScriptletName(source.name)) {
        return null;
      }

      var scriptletFunction = getScriptletFunction(source.name).toString();
      var result = source.engine === 'corelibs' || source.engine === 'test' ? wrapInNonameFunc(scriptletFunction) : passSourceAndProps(source, scriptletFunction);
      return result;
    }
    /**
     * Scriptlets variable
     *
     * @returns {Object} object with methods:
     * `invoke` method receives one argument with `Source` type
     * `validate` method receives one argument with `String` type
     */


    var scriptletsObject = function () {
      return {
        invoke: getScriptletCode,
        getScriptletFunction: getScriptletFunction,
        isValidScriptletName: validator.isValidScriptletName,
        isValidScriptletRule: isValidScriptletRule,
        isAdgScriptletRule: validator.isAdgScriptletRule,
        isUboScriptletRule: validator.isUboScriptletRule,
        isAbpSnippetRule: validator.isAbpSnippetRule,
        convertUboToAdg: convertUboScriptletToAdg,
        convertAbpToAdg: convertAbpSnippetToAdg,
        convertScriptletToAdg: convertScriptletToAdg,
        convertAdgToUbo: convertAdgScriptletToUbo,
        redirects: redirects
      };
    }();

    /**
     * Add module exports to be used as node package
     */

    module.exports = scriptletsObject;

}));

/**
 * -------------------------------------------
 * |                                         |
 * |  If you want to add your own scriptlet  |
 * |  please put your code below             |
 * |                                         |
 * -------------------------------------------
 */


/***/ }),

/***/ 84346:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
                if (!ar) ar = Array.prototype.slice.call(from, 0, i);
                ar[i] = from[i];
            }
        }
        return to.concat(ar || Array.prototype.slice.call(from));
    }

    /**
     * Compatibility types are used to configure engine for better support of different libraries
     * For example:
     *  extension doesn't support $app modifier. So if we set in configuration CompatibilityTypes.extension,
     *  engine would ignore rules with $app modifier
     */
    exports.CompatibilityTypes = void 0;
    (function (CompatibilityTypes) {
        CompatibilityTypes[CompatibilityTypes["extension"] = 1] = "extension";
        CompatibilityTypes[CompatibilityTypes["corelibs"] = 2] = "corelibs";
        CompatibilityTypes[CompatibilityTypes["dns"] = 4] = "dns";
    })(exports.CompatibilityTypes || (exports.CompatibilityTypes = {}));
    /**
     * Application configuration class
     */
    var Configuration = /** @class */ (function () {
        function Configuration(inputConfig) {
            this.defaultConfig = {
                engine: null,
                version: null,
                verbose: false,
                compatibility: null,
            };
            /**
             * {'extension'|'corelibs'} engine application type
             */
            this.engine = null;
            /**
             * {string} version
             */
            this.version = null;
            /**
             * {boolean} verbose flag
             */
            this.verbose = false;
            /**
             * compatibility flag
             */
            this.compatibility = exports.CompatibilityTypes.extension;
            var config = __assign(__assign({}, this.defaultConfig), inputConfig);
            this.engine = config.engine;
            this.version = config.version;
            this.verbose = config.verbose;
            this.compatibility = config.compatibility;
        }
        return Configuration;
    }());
    exports.config = new Configuration();
    /**
     * Checks config is compatible with input level
     * @param compatibilityLevel
     * @private
     */
    function isCompatibleWith(compatibilityLevel) {
        if (exports.config.compatibility === null) {
            return false;
        }
        return (exports.config.compatibility & compatibilityLevel) === compatibilityLevel;
    }
    var setConfiguration = function (outerConfig) {
        exports.config = new Configuration(outerConfig);
    };

    var DEFAULT_CHARSET = 'utf-8';
    var LATIN_1 = 'iso-8859-1';
    var WIN_1251 = 'windows-1251';
    var WIN_1252 = 'windows-1252';
    /**
     * Supported charsets array
     */
    var SUPPORTED_CHARSETS = [DEFAULT_CHARSET, WIN_1251, WIN_1252, LATIN_1];
    /**
     * Parses charset from content-type header
     *
     * @param contentType
     * @returns {*}
     */
    function parseCharsetFromHeader(contentType) {
        if (!contentType) {
            return null;
        }
        var match = /charset="?(.*?)"?$/.exec(contentType.toLowerCase());
        if (match && match.length > 1) {
            return match[1].toLowerCase();
        }
        return null;
    }
    /**
     * Parses charset from html, looking for:
     * <meta charset="utf-8" />
     * <meta charset=utf-8 />
     * <meta charset=utf-8>
     * <meta http-equiv="content-type" content="text/html; charset=utf-8" />
     * <meta content="text/html; charset=utf-8" http-equiv="content-type" />
     *
     * @param text
     */
    function parseCharsetFromHtml(text) {
        var match = /<meta\s*charset\s*=\s*['"]?(.*?)['"]?\s*\/?>/.exec(text.toLowerCase());
        if (match && match.length > 1) {
            return match[1].trim().toLowerCase();
        }
        // eslint-disable-next-line max-len
        match = /<meta\s*http-equiv\s*=\s*['"]?content-type['"]?\s*content\s*=\s*[\\]?['"]text\/html;\s*charset=(.*?)[\\]?['"]/.exec(text.toLowerCase());
        if (match && match.length > 1) {
            return match[1].trim().toLowerCase();
        }
        // eslint-disable-next-line max-len
        match = /<meta\s*content\s*=\s*[\\]?['"]text\/html;\s*charset=(.*?)[\\]?['"]\s*http-equiv\s*=\s*['"]?content-type['"]?/.exec(text.toLowerCase());
        if (match && match.length > 1) {
            return match[1].trim().toLowerCase();
        }
        return null;
    }
    /**
     * Parses charset from css
     *
     * @param text
     */
    function parseCharsetFromCss(text) {
        var match = /^@charset\s*['"](.*?)['"]/.exec(text.toLowerCase());
        if (match && match.length > 1) {
            return match[1].trim().toLowerCase();
        }
        return null;
    }

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : typeof self !== 'undefined' ? self : {};

    function getAugmentedNamespace(n) {
    	if (n.__esModule) return n;
    	var a = Object.defineProperty({}, '__esModule', {value: true});
    	Object.keys(n).forEach(function (k) {
    		var d = Object.getOwnPropertyDescriptor(n, k);
    		Object.defineProperty(a, k, d.get ? d : {
    			enumerable: true,
    			get: function () {
    				return n[k];
    			}
    		});
    	});
    	return a;
    }

    var encoding$1 = {exports: {}};

    var encodingIndexes = {exports: {}};

    (function (module) {
    (function(global) {
      if (module.exports) {
        module.exports = global;
      }
      global["encoding-indexes"] =
    {
      "big5":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17392,19506,17923,17830,17784,160359,19831,17843,162993,19682,163013,15253,18230,18244,19527,19520,148159,144919,160594,159371,159954,19543,172881,18255,17882,19589,162924,19719,19108,18081,158499,29221,154196,137827,146950,147297,26189,22267,null,32149,22813,166841,15860,38708,162799,23515,138590,23204,13861,171696,23249,23479,23804,26478,34195,170309,29793,29853,14453,138579,145054,155681,16108,153822,15093,31484,40855,147809,166157,143850,133770,143966,17162,33924,40854,37935,18736,34323,22678,38730,37400,31184,31282,26208,27177,34973,29772,31685,26498,31276,21071,36934,13542,29636,155065,29894,40903,22451,18735,21580,16689,145038,22552,31346,162661,35727,18094,159368,16769,155033,31662,140476,40904,140481,140489,140492,40905,34052,144827,16564,40906,17633,175615,25281,28782,40907,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12736,12737,12738,12739,12740,131340,12741,131281,131277,12742,12743,131275,139240,12744,131274,12745,12746,12747,12748,131342,12749,12750,256,193,461,192,274,201,282,200,332,211,465,210,null,7870,null,7872,202,257,225,462,224,593,275,233,283,232,299,237,464,236,333,243,466,242,363,250,468,249,470,472,474,476,252,null,7871,null,7873,234,609,9178,9179,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,172969,135493,null,25866,null,null,20029,28381,40270,37343,null,null,161589,25745,20250,20264,20392,20822,20852,20892,20964,21153,21160,21307,21326,21457,21464,22242,22768,22788,22791,22834,22836,23398,23454,23455,23706,24198,24635,25993,26622,26628,26725,27982,28860,30005,32420,32428,32442,32455,32463,32479,32518,32567,33402,33487,33647,35270,35774,35810,36710,36711,36718,29713,31996,32205,26950,31433,21031,null,null,null,null,37260,30904,37214,32956,null,36107,33014,133607,null,null,32927,40647,19661,40393,40460,19518,171510,159758,40458,172339,13761,null,28314,33342,29977,null,18705,39532,39567,40857,31111,164972,138698,132560,142054,20004,20097,20096,20103,20159,20203,20279,13388,20413,15944,20483,20616,13437,13459,13477,20870,22789,20955,20988,20997,20105,21113,21136,21287,13767,21417,13649,21424,13651,21442,21539,13677,13682,13953,21651,21667,21684,21689,21712,21743,21784,21795,21800,13720,21823,13733,13759,21975,13765,163204,21797,null,134210,134421,151851,21904,142534,14828,131905,36422,150968,169189,16467,164030,30586,142392,14900,18389,164189,158194,151018,25821,134524,135092,134357,135412,25741,36478,134806,134155,135012,142505,164438,148691,null,134470,170573,164073,18420,151207,142530,39602,14951,169460,16365,13574,152263,169940,161992,142660,40302,38933,null,17369,155813,25780,21731,142668,142282,135287,14843,135279,157402,157462,162208,25834,151634,134211,36456,139681,166732,132913,null,18443,131497,16378,22643,142733,null,148936,132348,155799,134988,134550,21881,16571,17338,null,19124,141926,135325,33194,39157,134556,25465,14846,141173,36288,22177,25724,15939,null,173569,134665,142031,142537,null,135368,145858,14738,14854,164507,13688,155209,139463,22098,134961,142514,169760,13500,27709,151099,null,null,161140,142987,139784,173659,167117,134778,134196,157724,32659,135375,141315,141625,13819,152035,134796,135053,134826,16275,134960,134471,135503,134732,null,134827,134057,134472,135360,135485,16377,140950,25650,135085,144372,161337,142286,134526,134527,142417,142421,14872,134808,135367,134958,173618,158544,167122,167321,167114,38314,21708,33476,21945,null,171715,39974,39606,161630,142830,28992,33133,33004,23580,157042,33076,14231,21343,164029,37302,134906,134671,134775,134907,13789,151019,13833,134358,22191,141237,135369,134672,134776,135288,135496,164359,136277,134777,151120,142756,23124,135197,135198,135413,135414,22428,134673,161428,164557,135093,134779,151934,14083,135094,135552,152280,172733,149978,137274,147831,164476,22681,21096,13850,153405,31666,23400,18432,19244,40743,18919,39967,39821,154484,143677,22011,13810,22153,20008,22786,138177,194680,38737,131206,20059,20155,13630,23587,24401,24516,14586,25164,25909,27514,27701,27706,28780,29227,20012,29357,149737,32594,31035,31993,32595,156266,13505,null,156491,32770,32896,157202,158033,21341,34916,35265,161970,35744,36125,38021,38264,38271,38376,167439,38886,39029,39118,39134,39267,170000,40060,40479,40644,27503,63751,20023,131207,38429,25143,38050,null,20539,28158,171123,40870,15817,34959,147790,28791,23797,19232,152013,13657,154928,24866,166450,36775,37366,29073,26393,29626,144001,172295,15499,137600,19216,30948,29698,20910,165647,16393,27235,172730,16931,34319,133743,31274,170311,166634,38741,28749,21284,139390,37876,30425,166371,40871,30685,20131,20464,20668,20015,20247,40872,21556,32139,22674,22736,138678,24210,24217,24514,141074,25995,144377,26905,27203,146531,27903,null,29184,148741,29580,16091,150035,23317,29881,35715,154788,153237,31379,31724,31939,32364,33528,34199,40873,34960,40874,36537,40875,36815,34143,39392,37409,40876,167353,136255,16497,17058,23066,null,null,null,39016,26475,17014,22333,null,34262,149883,33471,160013,19585,159092,23931,158485,159678,40877,40878,23446,40879,26343,32347,28247,31178,15752,17603,143958,141206,17306,17718,null,23765,146202,35577,23672,15634,144721,23928,40882,29015,17752,147692,138787,19575,14712,13386,131492,158785,35532,20404,131641,22975,33132,38998,170234,24379,134047,null,139713,166253,16642,18107,168057,16135,40883,172469,16632,14294,18167,158790,16764,165554,160767,17773,14548,152730,17761,17691,19849,19579,19830,17898,16328,150287,13921,17630,17597,16877,23870,23880,23894,15868,14351,23972,23993,14368,14392,24130,24253,24357,24451,14600,14612,14655,14669,24791,24893,23781,14729,25015,25017,25039,14776,25132,25232,25317,25368,14840,22193,14851,25570,25595,25607,25690,14923,25792,23829,22049,40863,14999,25990,15037,26111,26195,15090,26258,15138,26390,15170,26532,26624,15192,26698,26756,15218,15217,15227,26889,26947,29276,26980,27039,27013,15292,27094,15325,27237,27252,27249,27266,15340,27289,15346,27307,27317,27348,27382,27521,27585,27626,27765,27818,15563,27906,27910,27942,28033,15599,28068,28081,28181,28184,28201,28294,166336,28347,28386,28378,40831,28392,28393,28452,28468,15686,147265,28545,28606,15722,15733,29111,23705,15754,28716,15761,28752,28756,28783,28799,28809,131877,17345,13809,134872,147159,22462,159443,28990,153568,13902,27042,166889,23412,31305,153825,169177,31333,31357,154028,31419,31408,31426,31427,29137,156813,16842,31450,31453,31466,16879,21682,154625,31499,31573,31529,152334,154878,31650,31599,33692,154548,158847,31696,33825,31634,31672,154912,15789,154725,33938,31738,31750,31797,154817,31812,31875,149634,31910,26237,148856,31945,31943,31974,31860,31987,31989,31950,32359,17693,159300,32093,159446,29837,32137,32171,28981,32179,32210,147543,155689,32228,15635,32245,137209,32229,164717,32285,155937,155994,32366,32402,17195,37996,32295,32576,32577,32583,31030,156368,39393,32663,156497,32675,136801,131176,17756,145254,17667,164666,32762,156809,32773,32776,32797,32808,32815,172167,158915,32827,32828,32865,141076,18825,157222,146915,157416,26405,32935,166472,33031,33050,22704,141046,27775,156824,151480,25831,136330,33304,137310,27219,150117,150165,17530,33321,133901,158290,146814,20473,136445,34018,33634,158474,149927,144688,137075,146936,33450,26907,194964,16859,34123,33488,33562,134678,137140,14017,143741,144730,33403,33506,33560,147083,159139,158469,158615,144846,15807,33565,21996,33669,17675,159141,33708,33729,33747,13438,159444,27223,34138,13462,159298,143087,33880,154596,33905,15827,17636,27303,33866,146613,31064,33960,158614,159351,159299,34014,33807,33681,17568,33939,34020,154769,16960,154816,17731,34100,23282,159385,17703,34163,17686,26559,34326,165413,165435,34241,159880,34306,136578,159949,194994,17770,34344,13896,137378,21495,160666,34430,34673,172280,34798,142375,34737,34778,34831,22113,34412,26710,17935,34885,34886,161248,146873,161252,34910,34972,18011,34996,34997,25537,35013,30583,161551,35207,35210,35238,35241,35239,35260,166437,35303,162084,162493,35484,30611,37374,35472,162393,31465,162618,147343,18195,162616,29052,35596,35615,152624,152933,35647,35660,35661,35497,150138,35728,35739,35503,136927,17941,34895,35995,163156,163215,195028,14117,163155,36054,163224,163261,36114,36099,137488,36059,28764,36113,150729,16080,36215,36265,163842,135188,149898,15228,164284,160012,31463,36525,36534,36547,37588,36633,36653,164709,164882,36773,37635,172703,133712,36787,18730,166366,165181,146875,24312,143970,36857,172052,165564,165121,140069,14720,159447,36919,165180,162494,36961,165228,165387,37032,165651,37060,165606,37038,37117,37223,15088,37289,37316,31916,166195,138889,37390,27807,37441,37474,153017,37561,166598,146587,166668,153051,134449,37676,37739,166625,166891,28815,23235,166626,166629,18789,37444,166892,166969,166911,37747,37979,36540,38277,38310,37926,38304,28662,17081,140922,165592,135804,146990,18911,27676,38523,38550,16748,38563,159445,25050,38582,30965,166624,38589,21452,18849,158904,131700,156688,168111,168165,150225,137493,144138,38705,34370,38710,18959,17725,17797,150249,28789,23361,38683,38748,168405,38743,23370,168427,38751,37925,20688,143543,143548,38793,38815,38833,38846,38848,38866,38880,152684,38894,29724,169011,38911,38901,168989,162170,19153,38964,38963,38987,39014,15118,160117,15697,132656,147804,153350,39114,39095,39112,39111,19199,159015,136915,21936,39137,39142,39148,37752,39225,150057,19314,170071,170245,39413,39436,39483,39440,39512,153381,14020,168113,170965,39648,39650,170757,39668,19470,39700,39725,165376,20532,39732,158120,14531,143485,39760,39744,171326,23109,137315,39822,148043,39938,39935,39948,171624,40404,171959,172434,172459,172257,172323,172511,40318,40323,172340,40462,26760,40388,139611,172435,172576,137531,172595,40249,172217,172724,40592,40597,40606,40610,19764,40618,40623,148324,40641,15200,14821,15645,20274,14270,166955,40706,40712,19350,37924,159138,40727,40726,40761,22175,22154,40773,39352,168075,38898,33919,40802,40809,31452,40846,29206,19390,149877,149947,29047,150008,148296,150097,29598,166874,137466,31135,166270,167478,37737,37875,166468,37612,37761,37835,166252,148665,29207,16107,30578,31299,28880,148595,148472,29054,137199,28835,137406,144793,16071,137349,152623,137208,14114,136955,137273,14049,137076,137425,155467,14115,136896,22363,150053,136190,135848,136134,136374,34051,145062,34051,33877,149908,160101,146993,152924,147195,159826,17652,145134,170397,159526,26617,14131,15381,15847,22636,137506,26640,16471,145215,147681,147595,147727,158753,21707,22174,157361,22162,135135,134056,134669,37830,166675,37788,20216,20779,14361,148534,20156,132197,131967,20299,20362,153169,23144,131499,132043,14745,131850,132116,13365,20265,131776,167603,131701,35546,131596,20120,20685,20749,20386,20227,150030,147082,20290,20526,20588,20609,20428,20453,20568,20732,20825,20827,20829,20830,28278,144789,147001,147135,28018,137348,147081,20904,20931,132576,17629,132259,132242,132241,36218,166556,132878,21081,21156,133235,21217,37742,18042,29068,148364,134176,149932,135396,27089,134685,29817,16094,29849,29716,29782,29592,19342,150204,147597,21456,13700,29199,147657,21940,131909,21709,134086,22301,37469,38644,37734,22493,22413,22399,13886,22731,23193,166470,136954,137071,136976,23084,22968,37519,23166,23247,23058,153926,137715,137313,148117,14069,27909,29763,23073,155267,23169,166871,132115,37856,29836,135939,28933,18802,37896,166395,37821,14240,23582,23710,24158,24136,137622,137596,146158,24269,23375,137475,137476,14081,137376,14045,136958,14035,33066,166471,138682,144498,166312,24332,24334,137511,137131,23147,137019,23364,34324,161277,34912,24702,141408,140843,24539,16056,140719,140734,168072,159603,25024,131134,131142,140827,24985,24984,24693,142491,142599,149204,168269,25713,149093,142186,14889,142114,144464,170218,142968,25399,173147,25782,25393,25553,149987,142695,25252,142497,25659,25963,26994,15348,143502,144045,149897,144043,21773,144096,137433,169023,26318,144009,143795,15072,16784,152964,166690,152975,136956,152923,152613,30958,143619,137258,143924,13412,143887,143746,148169,26254,159012,26219,19347,26160,161904,138731,26211,144082,144097,26142,153714,14545,145466,145340,15257,145314,144382,29904,15254,26511,149034,26806,26654,15300,27326,14435,145365,148615,27187,27218,27337,27397,137490,25873,26776,27212,15319,27258,27479,147392,146586,37792,37618,166890,166603,37513,163870,166364,37991,28069,28427,149996,28007,147327,15759,28164,147516,23101,28170,22599,27940,30786,28987,148250,148086,28913,29264,29319,29332,149391,149285,20857,150180,132587,29818,147192,144991,150090,149783,155617,16134,16049,150239,166947,147253,24743,16115,29900,29756,37767,29751,17567,159210,17745,30083,16227,150745,150790,16216,30037,30323,173510,15129,29800,166604,149931,149902,15099,15821,150094,16127,149957,149747,37370,22322,37698,166627,137316,20703,152097,152039,30584,143922,30478,30479,30587,149143,145281,14942,149744,29752,29851,16063,150202,150215,16584,150166,156078,37639,152961,30750,30861,30856,30930,29648,31065,161601,153315,16654,31131,33942,31141,27181,147194,31290,31220,16750,136934,16690,37429,31217,134476,149900,131737,146874,137070,13719,21867,13680,13994,131540,134157,31458,23129,141045,154287,154268,23053,131675,30960,23082,154566,31486,16889,31837,31853,16913,154547,155324,155302,31949,150009,137136,31886,31868,31918,27314,32220,32263,32211,32590,156257,155996,162632,32151,155266,17002,158581,133398,26582,131150,144847,22468,156690,156664,149858,32733,31527,133164,154345,154947,31500,155150,39398,34373,39523,27164,144447,14818,150007,157101,39455,157088,33920,160039,158929,17642,33079,17410,32966,33033,33090,157620,39107,158274,33378,33381,158289,33875,159143,34320,160283,23174,16767,137280,23339,137377,23268,137432,34464,195004,146831,34861,160802,23042,34926,20293,34951,35007,35046,35173,35149,153219,35156,161669,161668,166901,166873,166812,166393,16045,33955,18165,18127,14322,35389,35356,169032,24397,37419,148100,26068,28969,28868,137285,40301,35999,36073,163292,22938,30659,23024,17262,14036,36394,36519,150537,36656,36682,17140,27736,28603,140065,18587,28537,28299,137178,39913,14005,149807,37051,37015,21873,18694,37307,37892,166475,16482,166652,37927,166941,166971,34021,35371,38297,38311,38295,38294,167220,29765,16066,149759,150082,148458,16103,143909,38543,167655,167526,167525,16076,149997,150136,147438,29714,29803,16124,38721,168112,26695,18973,168083,153567,38749,37736,166281,166950,166703,156606,37562,23313,35689,18748,29689,147995,38811,38769,39224,134950,24001,166853,150194,38943,169178,37622,169431,37349,17600,166736,150119,166756,39132,166469,16128,37418,18725,33812,39227,39245,162566,15869,39323,19311,39338,39516,166757,153800,27279,39457,23294,39471,170225,19344,170312,39356,19389,19351,37757,22642,135938,22562,149944,136424,30788,141087,146872,26821,15741,37976,14631,24912,141185,141675,24839,40015,40019,40059,39989,39952,39807,39887,171565,39839,172533,172286,40225,19630,147716,40472,19632,40204,172468,172269,172275,170287,40357,33981,159250,159711,158594,34300,17715,159140,159364,159216,33824,34286,159232,145367,155748,31202,144796,144960,18733,149982,15714,37851,37566,37704,131775,30905,37495,37965,20452,13376,36964,152925,30781,30804,30902,30795,137047,143817,149825,13978,20338,28634,28633,28702,28702,21524,147893,22459,22771,22410,40214,22487,28980,13487,147884,29163,158784,151447,23336,137141,166473,24844,23246,23051,17084,148616,14124,19323,166396,37819,37816,137430,134941,33906,158912,136211,148218,142374,148417,22932,146871,157505,32168,155995,155812,149945,149899,166394,37605,29666,16105,29876,166755,137375,16097,150195,27352,29683,29691,16086,150078,150164,137177,150118,132007,136228,149989,29768,149782,28837,149878,37508,29670,37727,132350,37681,166606,166422,37766,166887,153045,18741,166530,29035,149827,134399,22180,132634,134123,134328,21762,31172,137210,32254,136898,150096,137298,17710,37889,14090,166592,149933,22960,137407,137347,160900,23201,14050,146779,14000,37471,23161,166529,137314,37748,15565,133812,19094,14730,20724,15721,15692,136092,29045,17147,164376,28175,168164,17643,27991,163407,28775,27823,15574,147437,146989,28162,28428,15727,132085,30033,14012,13512,18048,16090,18545,22980,37486,18750,36673,166940,158656,22546,22472,14038,136274,28926,148322,150129,143331,135856,140221,26809,26983,136088,144613,162804,145119,166531,145366,144378,150687,27162,145069,158903,33854,17631,17614,159014,159057,158850,159710,28439,160009,33597,137018,33773,158848,159827,137179,22921,23170,137139,23137,23153,137477,147964,14125,23023,137020,14023,29070,37776,26266,148133,23150,23083,148115,27179,147193,161590,148571,148170,28957,148057,166369,20400,159016,23746,148686,163405,148413,27148,148054,135940,28838,28979,148457,15781,27871,194597,150095,32357,23019,23855,15859,24412,150109,137183,32164,33830,21637,146170,144128,131604,22398,133333,132633,16357,139166,172726,28675,168283,23920,29583,31955,166489,168992,20424,32743,29389,29456,162548,29496,29497,153334,29505,29512,16041,162584,36972,29173,149746,29665,33270,16074,30476,16081,27810,22269,29721,29726,29727,16098,16112,16116,16122,29907,16142,16211,30018,30061,30066,30093,16252,30152,30172,16320,30285,16343,30324,16348,30330,151388,29064,22051,35200,22633,16413,30531,16441,26465,16453,13787,30616,16490,16495,23646,30654,30667,22770,30744,28857,30748,16552,30777,30791,30801,30822,33864,152885,31027,26627,31026,16643,16649,31121,31129,36795,31238,36796,16743,31377,16818,31420,33401,16836,31439,31451,16847,20001,31586,31596,31611,31762,31771,16992,17018,31867,31900,17036,31928,17044,31981,36755,28864,134351,32207,32212,32208,32253,32686,32692,29343,17303,32800,32805,31545,32814,32817,32852,15820,22452,28832,32951,33001,17389,33036,29482,33038,33042,30048,33044,17409,15161,33110,33113,33114,17427,22586,33148,33156,17445,33171,17453,33189,22511,33217,33252,33364,17551,33446,33398,33482,33496,33535,17584,33623,38505,27018,33797,28917,33892,24803,33928,17668,33982,34017,34040,34064,34104,34130,17723,34159,34160,34272,17783,34418,34450,34482,34543,38469,34699,17926,17943,34990,35071,35108,35143,35217,162151,35369,35384,35476,35508,35921,36052,36082,36124,18328,22623,36291,18413,20206,36410,21976,22356,36465,22005,36528,18487,36558,36578,36580,36589,36594,36791,36801,36810,36812,36915,39364,18605,39136,37395,18718,37416,37464,37483,37553,37550,37567,37603,37611,37619,37620,37629,37699,37764,37805,18757,18769,40639,37911,21249,37917,37933,37950,18794,37972,38009,38189,38306,18855,38388,38451,18917,26528,18980,38720,18997,38834,38850,22100,19172,24808,39097,19225,39153,22596,39182,39193,20916,39196,39223,39234,39261,39266,19312,39365,19357,39484,39695,31363,39785,39809,39901,39921,39924,19565,39968,14191,138178,40265,39994,40702,22096,40339,40381,40384,40444,38134,36790,40571,40620,40625,40637,40646,38108,40674,40689,40696,31432,40772,131220,131767,132000,26906,38083,22956,132311,22592,38081,14265,132565,132629,132726,136890,22359,29043,133826,133837,134079,21610,194619,134091,21662,134139,134203,134227,134245,134268,24807,134285,22138,134325,134365,134381,134511,134578,134600,26965,39983,34725,134660,134670,134871,135056,134957,134771,23584,135100,24075,135260,135247,135286,26398,135291,135304,135318,13895,135359,135379,135471,135483,21348,33965,135907,136053,135990,35713,136567,136729,137155,137159,20088,28859,137261,137578,137773,137797,138282,138352,138412,138952,25283,138965,139029,29080,26709,139333,27113,14024,139900,140247,140282,141098,141425,141647,33533,141671,141715,142037,35237,142056,36768,142094,38840,142143,38983,39613,142412,null,142472,142519,154600,142600,142610,142775,142741,142914,143220,143308,143411,143462,144159,144350,24497,26184,26303,162425,144743,144883,29185,149946,30679,144922,145174,32391,131910,22709,26382,26904,146087,161367,155618,146961,147129,161278,139418,18640,19128,147737,166554,148206,148237,147515,148276,148374,150085,132554,20946,132625,22943,138920,15294,146687,148484,148694,22408,149108,14747,149295,165352,170441,14178,139715,35678,166734,39382,149522,149755,150037,29193,150208,134264,22885,151205,151430,132985,36570,151596,21135,22335,29041,152217,152601,147274,150183,21948,152646,152686,158546,37332,13427,152895,161330,152926,18200,152930,152934,153543,149823,153693,20582,13563,144332,24798,153859,18300,166216,154286,154505,154630,138640,22433,29009,28598,155906,162834,36950,156082,151450,35682,156674,156746,23899,158711,36662,156804,137500,35562,150006,156808,147439,156946,19392,157119,157365,141083,37989,153569,24981,23079,194765,20411,22201,148769,157436,20074,149812,38486,28047,158909,13848,35191,157593,157806,156689,157790,29151,157895,31554,168128,133649,157990,37124,158009,31301,40432,158202,39462,158253,13919,156777,131105,31107,158260,158555,23852,144665,33743,158621,18128,158884,30011,34917,159150,22710,14108,140685,159819,160205,15444,160384,160389,37505,139642,160395,37680,160486,149968,27705,38047,160848,134904,34855,35061,141606,164979,137137,28344,150058,137248,14756,14009,23568,31203,17727,26294,171181,170148,35139,161740,161880,22230,16607,136714,14753,145199,164072,136133,29101,33638,162269,168360,23143,19639,159919,166315,162301,162314,162571,163174,147834,31555,31102,163849,28597,172767,27139,164632,21410,159239,37823,26678,38749,164207,163875,158133,136173,143919,163912,23941,166960,163971,22293,38947,166217,23979,149896,26046,27093,21458,150181,147329,15377,26422,163984,164084,164142,139169,164175,164233,164271,164378,164614,164655,164746,13770,164968,165546,18682,25574,166230,30728,37461,166328,17394,166375,17375,166376,166726,166868,23032,166921,36619,167877,168172,31569,168208,168252,15863,168286,150218,36816,29327,22155,169191,169449,169392,169400,169778,170193,170313,170346,170435,170536,170766,171354,171419,32415,171768,171811,19620,38215,172691,29090,172799,19857,36882,173515,19868,134300,36798,21953,36794,140464,36793,150163,17673,32383,28502,27313,20202,13540,166700,161949,14138,36480,137205,163876,166764,166809,162366,157359,15851,161365,146615,153141,153942,20122,155265,156248,22207,134765,36366,23405,147080,150686,25566,25296,137206,137339,25904,22061,154698,21530,152337,15814,171416,19581,22050,22046,32585,155352,22901,146752,34672,19996,135146,134473,145082,33047,40286,36120,30267,40005,30286,30649,37701,21554,33096,33527,22053,33074,33816,32957,21994,31074,22083,21526,134813,13774,22021,22001,26353,164578,13869,30004,22000,21946,21655,21874,134209,134294,24272,151880,134774,142434,134818,40619,32090,21982,135285,25245,38765,21652,36045,29174,37238,25596,25529,25598,21865,142147,40050,143027,20890,13535,134567,20903,21581,21790,21779,30310,36397,157834,30129,32950,34820,34694,35015,33206,33820,135361,17644,29444,149254,23440,33547,157843,22139,141044,163119,147875,163187,159440,160438,37232,135641,37384,146684,173737,134828,134905,29286,138402,18254,151490,163833,135147,16634,40029,25887,142752,18675,149472,171388,135148,134666,24674,161187,135149,null,155720,135559,29091,32398,40272,19994,19972,13687,23309,27826,21351,13996,14812,21373,13989,149016,22682,150382,33325,21579,22442,154261,133497,null,14930,140389,29556,171692,19721,39917,146686,171824,19547,151465,169374,171998,33884,146870,160434,157619,145184,25390,32037,147191,146988,14890,36872,21196,15988,13946,17897,132238,30272,23280,134838,30842,163630,22695,16575,22140,39819,23924,30292,173108,40581,19681,30201,14331,24857,143578,148466,null,22109,135849,22439,149859,171526,21044,159918,13741,27722,40316,31830,39737,22494,137068,23635,25811,169168,156469,160100,34477,134440,159010,150242,134513,null,20990,139023,23950,38659,138705,40577,36940,31519,39682,23761,31651,25192,25397,39679,31695,39722,31870,39726,31810,31878,39957,31740,39689,40727,39963,149822,40794,21875,23491,20477,40600,20466,21088,15878,21201,22375,20566,22967,24082,38856,40363,36700,21609,38836,39232,38842,21292,24880,26924,21466,39946,40194,19515,38465,27008,20646,30022,137069,39386,21107,null,37209,38529,37212,null,37201,167575,25471,159011,27338,22033,37262,30074,25221,132092,29519,31856,154657,146685,null,149785,30422,39837,20010,134356,33726,34882,null,23626,27072,20717,22394,21023,24053,20174,27697,131570,20281,21660,21722,21146,36226,13822,24332,13811,null,27474,37244,40869,39831,38958,39092,39610,40616,40580,29050,31508,null,27642,34840,32632,null,22048,173642,36471,40787,null,36308,36431,40476,36353,25218,164733,36392,36469,31443,150135,31294,30936,27882,35431,30215,166490,40742,27854,34774,30147,172722,30803,194624,36108,29410,29553,35629,29442,29937,36075,150203,34351,24506,34976,17591,null,137275,159237,null,35454,140571,null,24829,30311,39639,40260,37742,39823,34805,null,34831,36087,29484,38689,39856,13782,29362,19463,31825,39242,155993,24921,19460,40598,24957,null,22367,24943,25254,25145,25294,14940,25058,21418,144373,25444,26626,13778,23895,166850,36826,167481,null,20697,138566,30982,21298,38456,134971,16485,null,30718,null,31938,155418,31962,31277,32870,32867,32077,29957,29938,35220,33306,26380,32866,160902,32859,29936,33027,30500,35209,157644,30035,159441,34729,34766,33224,34700,35401,36013,35651,30507,29944,34010,13877,27058,36262,null,35241,29800,28089,34753,147473,29927,15835,29046,24740,24988,15569,29026,24695,null,32625,166701,29264,24809,19326,21024,15384,146631,155351,161366,152881,137540,135934,170243,159196,159917,23745,156077,166415,145015,131310,157766,151310,17762,23327,156492,40784,40614,156267,12288,65292,12289,12290,65294,8231,65307,65306,65311,65281,65072,8230,8229,65104,65105,65106,183,65108,65109,65110,65111,65372,8211,65073,8212,65075,9588,65076,65103,65288,65289,65077,65078,65371,65373,65079,65080,12308,12309,65081,65082,12304,12305,65083,65084,12298,12299,65085,65086,12296,12297,65087,65088,12300,12301,65089,65090,12302,12303,65091,65092,65113,65114,65115,65116,65117,65118,8216,8217,8220,8221,12317,12318,8245,8242,65283,65286,65290,8251,167,12291,9675,9679,9651,9650,9678,9734,9733,9671,9670,9633,9632,9661,9660,12963,8453,175,65507,65343,717,65097,65098,65101,65102,65099,65100,65119,65120,65121,65291,65293,215,247,177,8730,65308,65310,65309,8806,8807,8800,8734,8786,8801,65122,65123,65124,65125,65126,65374,8745,8746,8869,8736,8735,8895,13266,13265,8747,8750,8757,8756,9792,9794,8853,8857,8593,8595,8592,8594,8598,8599,8601,8600,8741,8739,65295,65340,8725,65128,65284,65509,12306,65504,65505,65285,65312,8451,8457,65129,65130,65131,13269,13212,13213,13214,13262,13217,13198,13199,13252,176,20825,20827,20830,20829,20833,20835,21991,29929,31950,9601,9602,9603,9604,9605,9606,9607,9608,9615,9614,9613,9612,9611,9610,9609,9532,9524,9516,9508,9500,9620,9472,9474,9621,9484,9488,9492,9496,9581,9582,9584,9583,9552,9566,9578,9569,9698,9699,9701,9700,9585,9586,9587,65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,8544,8545,8546,8547,8548,8549,8550,8551,8552,8553,12321,12322,12323,12324,12325,12326,12327,12328,12329,21313,21316,21317,65313,65314,65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,934,935,936,937,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,12549,12550,12551,12552,12553,12554,12555,12556,12557,12558,12559,12560,12561,12562,12563,12564,12565,12566,12567,12568,12569,12570,12571,12572,12573,12574,12575,12576,12577,12578,12579,12580,12581,12582,12583,12584,12585,729,713,714,711,715,9216,9217,9218,9219,9220,9221,9222,9223,9224,9225,9226,9227,9228,9229,9230,9231,9232,9233,9234,9235,9236,9237,9238,9239,9240,9241,9242,9243,9244,9245,9246,9247,9249,8364,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19968,20057,19969,19971,20035,20061,20102,20108,20154,20799,20837,20843,20960,20992,20993,21147,21269,21313,21340,21448,19977,19979,19976,19978,20011,20024,20961,20037,20040,20063,20062,20110,20129,20800,20995,21242,21315,21449,21475,22303,22763,22805,22823,22899,23376,23377,23379,23544,23567,23586,23608,23665,24029,24037,24049,24050,24051,24062,24178,24318,24331,24339,25165,19985,19984,19981,20013,20016,20025,20043,23609,20104,20113,20117,20114,20116,20130,20161,20160,20163,20166,20167,20173,20170,20171,20164,20803,20801,20839,20845,20846,20844,20887,20982,20998,20999,21000,21243,21246,21247,21270,21305,21320,21319,21317,21342,21380,21451,21450,21453,22764,22825,22827,22826,22829,23380,23569,23588,23610,23663,24052,24187,24319,24340,24341,24515,25096,25142,25163,25166,25903,25991,26007,26020,26041,26085,26352,26376,26408,27424,27490,27513,27595,27604,27611,27663,27700,28779,29226,29238,29243,29255,29273,29275,29356,29579,19993,19990,19989,19988,19992,20027,20045,20047,20046,20197,20184,20180,20181,20182,20183,20195,20196,20185,20190,20805,20804,20873,20874,20908,20985,20986,20984,21002,21152,21151,21253,21254,21271,21277,20191,21322,21321,21345,21344,21359,21358,21435,21487,21476,21491,21484,21486,21481,21480,21500,21496,21493,21483,21478,21482,21490,21489,21488,21477,21485,21499,22235,22234,22806,22830,22833,22900,22902,23381,23427,23612,24040,24039,24038,24066,24067,24179,24188,24321,24344,24343,24517,25098,25171,25172,25170,25169,26021,26086,26414,26412,26410,26411,26413,27491,27597,27665,27664,27704,27713,27712,27710,29359,29572,29577,29916,29926,29976,29983,29992,29993,30000,30001,30002,30003,30091,30333,30382,30399,30446,30683,30690,30707,31034,31166,31348,31435,19998,19999,20050,20051,20073,20121,20132,20134,20133,20223,20233,20249,20234,20245,20237,20240,20241,20239,20210,20214,20219,20208,20211,20221,20225,20235,20809,20807,20806,20808,20840,20849,20877,20912,21015,21009,21010,21006,21014,21155,21256,21281,21280,21360,21361,21513,21519,21516,21514,21520,21505,21515,21508,21521,21517,21512,21507,21518,21510,21522,22240,22238,22237,22323,22320,22312,22317,22316,22319,22313,22809,22810,22839,22840,22916,22904,22915,22909,22905,22914,22913,23383,23384,23431,23432,23429,23433,23546,23574,23673,24030,24070,24182,24180,24335,24347,24537,24534,25102,25100,25101,25104,25187,25179,25176,25910,26089,26088,26092,26093,26354,26355,26377,26429,26420,26417,26421,27425,27492,27515,27670,27741,27735,27737,27743,27744,27728,27733,27745,27739,27725,27726,28784,29279,29277,30334,31481,31859,31992,32566,32650,32701,32769,32771,32780,32786,32819,32895,32905,32907,32908,33251,33258,33267,33276,33292,33307,33311,33390,33394,33406,34411,34880,34892,34915,35199,38433,20018,20136,20301,20303,20295,20311,20318,20276,20315,20309,20272,20304,20305,20285,20282,20280,20291,20308,20284,20294,20323,20316,20320,20271,20302,20278,20313,20317,20296,20314,20812,20811,20813,20853,20918,20919,21029,21028,21033,21034,21032,21163,21161,21162,21164,21283,21363,21365,21533,21549,21534,21566,21542,21582,21543,21574,21571,21555,21576,21570,21531,21545,21578,21561,21563,21560,21550,21557,21558,21536,21564,21568,21553,21547,21535,21548,22250,22256,22244,22251,22346,22353,22336,22349,22343,22350,22334,22352,22351,22331,22767,22846,22941,22930,22952,22942,22947,22937,22934,22925,22948,22931,22922,22949,23389,23388,23386,23387,23436,23435,23439,23596,23616,23617,23615,23614,23696,23697,23700,23692,24043,24076,24207,24199,24202,24311,24324,24351,24420,24418,24439,24441,24536,24524,24535,24525,24561,24555,24568,24554,25106,25105,25220,25239,25238,25216,25206,25225,25197,25226,25212,25214,25209,25203,25234,25199,25240,25198,25237,25235,25233,25222,25913,25915,25912,26097,26356,26463,26446,26447,26448,26449,26460,26454,26462,26441,26438,26464,26451,26455,27493,27599,27714,27742,27801,27777,27784,27785,27781,27803,27754,27770,27792,27760,27788,27752,27798,27794,27773,27779,27762,27774,27764,27782,27766,27789,27796,27800,27778,28790,28796,28797,28792,29282,29281,29280,29380,29378,29590,29996,29995,30007,30008,30338,30447,30691,31169,31168,31167,31350,31995,32597,32918,32915,32925,32920,32923,32922,32946,33391,33426,33419,33421,35211,35282,35328,35895,35910,35925,35997,36196,36208,36275,36523,36554,36763,36784,36802,36806,36805,36804,24033,37009,37026,37034,37030,37027,37193,37318,37324,38450,38446,38449,38442,38444,20006,20054,20083,20107,20123,20126,20139,20140,20335,20381,20365,20339,20351,20332,20379,20363,20358,20355,20336,20341,20360,20329,20347,20374,20350,20367,20369,20346,20820,20818,20821,20841,20855,20854,20856,20925,20989,21051,21048,21047,21050,21040,21038,21046,21057,21182,21179,21330,21332,21331,21329,21350,21367,21368,21369,21462,21460,21463,21619,21621,21654,21624,21653,21632,21627,21623,21636,21650,21638,21628,21648,21617,21622,21644,21658,21602,21608,21643,21629,21646,22266,22403,22391,22378,22377,22369,22374,22372,22396,22812,22857,22855,22856,22852,22868,22974,22971,22996,22969,22958,22993,22982,22992,22989,22987,22995,22986,22959,22963,22994,22981,23391,23396,23395,23447,23450,23448,23452,23449,23451,23578,23624,23621,23622,23735,23713,23736,23721,23723,23729,23731,24088,24090,24086,24085,24091,24081,24184,24218,24215,24220,24213,24214,24310,24358,24359,24361,24448,24449,24447,24444,24541,24544,24573,24565,24575,24591,24596,24623,24629,24598,24618,24597,24609,24615,24617,24619,24603,25110,25109,25151,25150,25152,25215,25289,25292,25284,25279,25282,25273,25298,25307,25259,25299,25300,25291,25288,25256,25277,25276,25296,25305,25287,25293,25269,25306,25265,25304,25302,25303,25286,25260,25294,25918,26023,26044,26106,26132,26131,26124,26118,26114,26126,26112,26127,26133,26122,26119,26381,26379,26477,26507,26517,26481,26524,26483,26487,26503,26525,26519,26479,26480,26495,26505,26494,26512,26485,26522,26515,26492,26474,26482,27427,27494,27495,27519,27667,27675,27875,27880,27891,27825,27852,27877,27827,27837,27838,27836,27874,27819,27861,27859,27832,27844,27833,27841,27822,27863,27845,27889,27839,27835,27873,27867,27850,27820,27887,27868,27862,27872,28821,28814,28818,28810,28825,29228,29229,29240,29256,29287,29289,29376,29390,29401,29399,29392,29609,29608,29599,29611,29605,30013,30109,30105,30106,30340,30402,30450,30452,30693,30717,31038,31040,31041,31177,31176,31354,31353,31482,31998,32596,32652,32651,32773,32954,32933,32930,32945,32929,32939,32937,32948,32938,32943,33253,33278,33293,33459,33437,33433,33453,33469,33439,33465,33457,33452,33445,33455,33464,33443,33456,33470,33463,34382,34417,21021,34920,36555,36814,36820,36817,37045,37048,37041,37046,37319,37329,38263,38272,38428,38464,38463,38459,38468,38466,38585,38632,38738,38750,20127,20141,20142,20449,20405,20399,20415,20448,20433,20431,20445,20419,20406,20440,20447,20426,20439,20398,20432,20420,20418,20442,20430,20446,20407,20823,20882,20881,20896,21070,21059,21066,21069,21068,21067,21063,21191,21193,21187,21185,21261,21335,21371,21402,21467,21676,21696,21672,21710,21705,21688,21670,21683,21703,21698,21693,21674,21697,21700,21704,21679,21675,21681,21691,21673,21671,21695,22271,22402,22411,22432,22435,22434,22478,22446,22419,22869,22865,22863,22862,22864,23004,23000,23039,23011,23016,23043,23013,23018,23002,23014,23041,23035,23401,23459,23462,23460,23458,23461,23553,23630,23631,23629,23627,23769,23762,24055,24093,24101,24095,24189,24224,24230,24314,24328,24365,24421,24456,24453,24458,24459,24455,24460,24457,24594,24605,24608,24613,24590,24616,24653,24688,24680,24674,24646,24643,24684,24683,24682,24676,25153,25308,25366,25353,25340,25325,25345,25326,25341,25351,25329,25335,25327,25324,25342,25332,25361,25346,25919,25925,26027,26045,26082,26149,26157,26144,26151,26159,26143,26152,26161,26148,26359,26623,26579,26609,26580,26576,26604,26550,26543,26613,26601,26607,26564,26577,26548,26586,26597,26552,26575,26590,26611,26544,26585,26594,26589,26578,27498,27523,27526,27573,27602,27607,27679,27849,27915,27954,27946,27969,27941,27916,27953,27934,27927,27963,27965,27966,27958,27931,27893,27961,27943,27960,27945,27950,27957,27918,27947,28843,28858,28851,28844,28847,28845,28856,28846,28836,29232,29298,29295,29300,29417,29408,29409,29623,29642,29627,29618,29645,29632,29619,29978,29997,30031,30028,30030,30027,30123,30116,30117,30114,30115,30328,30342,30343,30344,30408,30406,30403,30405,30465,30457,30456,30473,30475,30462,30460,30471,30684,30722,30740,30732,30733,31046,31049,31048,31047,31161,31162,31185,31186,31179,31359,31361,31487,31485,31869,32002,32005,32000,32009,32007,32004,32006,32568,32654,32703,32772,32784,32781,32785,32822,32982,32997,32986,32963,32964,32972,32993,32987,32974,32990,32996,32989,33268,33314,33511,33539,33541,33507,33499,33510,33540,33509,33538,33545,33490,33495,33521,33537,33500,33492,33489,33502,33491,33503,33519,33542,34384,34425,34427,34426,34893,34923,35201,35284,35336,35330,35331,35998,36000,36212,36211,36276,36557,36556,36848,36838,36834,36842,36837,36845,36843,36836,36840,37066,37070,37057,37059,37195,37194,37325,38274,38480,38475,38476,38477,38754,38761,38859,38893,38899,38913,39080,39131,39135,39318,39321,20056,20147,20492,20493,20515,20463,20518,20517,20472,20521,20502,20486,20540,20511,20506,20498,20497,20474,20480,20500,20520,20465,20513,20491,20505,20504,20467,20462,20525,20522,20478,20523,20489,20860,20900,20901,20898,20941,20940,20934,20939,21078,21084,21076,21083,21085,21290,21375,21407,21405,21471,21736,21776,21761,21815,21756,21733,21746,21766,21754,21780,21737,21741,21729,21769,21742,21738,21734,21799,21767,21757,21775,22275,22276,22466,22484,22475,22467,22537,22799,22871,22872,22874,23057,23064,23068,23071,23067,23059,23020,23072,23075,23081,23077,23052,23049,23403,23640,23472,23475,23478,23476,23470,23477,23481,23480,23556,23633,23637,23632,23789,23805,23803,23786,23784,23792,23798,23809,23796,24046,24109,24107,24235,24237,24231,24369,24466,24465,24464,24665,24675,24677,24656,24661,24685,24681,24687,24708,24735,24730,24717,24724,24716,24709,24726,25159,25331,25352,25343,25422,25406,25391,25429,25410,25414,25423,25417,25402,25424,25405,25386,25387,25384,25421,25420,25928,25929,26009,26049,26053,26178,26185,26191,26179,26194,26188,26181,26177,26360,26388,26389,26391,26657,26680,26696,26694,26707,26681,26690,26708,26665,26803,26647,26700,26705,26685,26612,26704,26688,26684,26691,26666,26693,26643,26648,26689,27530,27529,27575,27683,27687,27688,27686,27684,27888,28010,28053,28040,28039,28006,28024,28023,27993,28051,28012,28041,28014,27994,28020,28009,28044,28042,28025,28037,28005,28052,28874,28888,28900,28889,28872,28879,29241,29305,29436,29433,29437,29432,29431,29574,29677,29705,29678,29664,29674,29662,30036,30045,30044,30042,30041,30142,30149,30151,30130,30131,30141,30140,30137,30146,30136,30347,30384,30410,30413,30414,30505,30495,30496,30504,30697,30768,30759,30776,30749,30772,30775,30757,30765,30752,30751,30770,31061,31056,31072,31071,31062,31070,31069,31063,31066,31204,31203,31207,31199,31206,31209,31192,31364,31368,31449,31494,31505,31881,32033,32023,32011,32010,32032,32034,32020,32016,32021,32026,32028,32013,32025,32027,32570,32607,32660,32709,32705,32774,32792,32789,32793,32791,32829,32831,33009,33026,33008,33029,33005,33012,33030,33016,33011,33032,33021,33034,33020,33007,33261,33260,33280,33296,33322,33323,33320,33324,33467,33579,33618,33620,33610,33592,33616,33609,33589,33588,33615,33586,33593,33590,33559,33600,33585,33576,33603,34388,34442,34474,34451,34468,34473,34444,34467,34460,34928,34935,34945,34946,34941,34937,35352,35344,35342,35340,35349,35338,35351,35347,35350,35343,35345,35912,35962,35961,36001,36002,36215,36524,36562,36564,36559,36785,36865,36870,36855,36864,36858,36852,36867,36861,36869,36856,37013,37089,37085,37090,37202,37197,37196,37336,37341,37335,37340,37337,38275,38498,38499,38497,38491,38493,38500,38488,38494,38587,39138,39340,39592,39640,39717,39730,39740,20094,20602,20605,20572,20551,20547,20556,20570,20553,20581,20598,20558,20565,20597,20596,20599,20559,20495,20591,20589,20828,20885,20976,21098,21103,21202,21209,21208,21205,21264,21263,21273,21311,21312,21310,21443,26364,21830,21866,21862,21828,21854,21857,21827,21834,21809,21846,21839,21845,21807,21860,21816,21806,21852,21804,21859,21811,21825,21847,22280,22283,22281,22495,22533,22538,22534,22496,22500,22522,22530,22581,22519,22521,22816,22882,23094,23105,23113,23142,23146,23104,23100,23138,23130,23110,23114,23408,23495,23493,23492,23490,23487,23494,23561,23560,23559,23648,23644,23645,23815,23814,23822,23835,23830,23842,23825,23849,23828,23833,23844,23847,23831,24034,24120,24118,24115,24119,24247,24248,24246,24245,24254,24373,24375,24407,24428,24425,24427,24471,24473,24478,24472,24481,24480,24476,24703,24739,24713,24736,24744,24779,24756,24806,24765,24773,24763,24757,24796,24764,24792,24789,24774,24799,24760,24794,24775,25114,25115,25160,25504,25511,25458,25494,25506,25509,25463,25447,25496,25514,25457,25513,25481,25475,25499,25451,25512,25476,25480,25497,25505,25516,25490,25487,25472,25467,25449,25448,25466,25949,25942,25937,25945,25943,21855,25935,25944,25941,25940,26012,26011,26028,26063,26059,26060,26062,26205,26202,26212,26216,26214,26206,26361,21207,26395,26753,26799,26786,26771,26805,26751,26742,26801,26791,26775,26800,26755,26820,26797,26758,26757,26772,26781,26792,26783,26785,26754,27442,27578,27627,27628,27691,28046,28092,28147,28121,28082,28129,28108,28132,28155,28154,28165,28103,28107,28079,28113,28078,28126,28153,28088,28151,28149,28101,28114,28186,28085,28122,28139,28120,28138,28145,28142,28136,28102,28100,28074,28140,28095,28134,28921,28937,28938,28925,28911,29245,29309,29313,29468,29467,29462,29459,29465,29575,29701,29706,29699,29702,29694,29709,29920,29942,29943,29980,29986,30053,30054,30050,30064,30095,30164,30165,30133,30154,30157,30350,30420,30418,30427,30519,30526,30524,30518,30520,30522,30827,30787,30798,31077,31080,31085,31227,31378,31381,31520,31528,31515,31532,31526,31513,31518,31534,31890,31895,31893,32070,32067,32113,32046,32057,32060,32064,32048,32051,32068,32047,32066,32050,32049,32573,32670,32666,32716,32718,32722,32796,32842,32838,33071,33046,33059,33067,33065,33072,33060,33282,33333,33335,33334,33337,33678,33694,33688,33656,33698,33686,33725,33707,33682,33674,33683,33673,33696,33655,33659,33660,33670,33703,34389,24426,34503,34496,34486,34500,34485,34502,34507,34481,34479,34505,34899,34974,34952,34987,34962,34966,34957,34955,35219,35215,35370,35357,35363,35365,35377,35373,35359,35355,35362,35913,35930,36009,36012,36011,36008,36010,36007,36199,36198,36286,36282,36571,36575,36889,36877,36890,36887,36899,36895,36893,36880,36885,36894,36896,36879,36898,36886,36891,36884,37096,37101,37117,37207,37326,37365,37350,37347,37351,37357,37353,38281,38506,38517,38515,38520,38512,38516,38518,38519,38508,38592,38634,38633,31456,31455,38914,38915,39770,40165,40565,40575,40613,40635,20642,20621,20613,20633,20625,20608,20630,20632,20634,26368,20977,21106,21108,21109,21097,21214,21213,21211,21338,21413,21883,21888,21927,21884,21898,21917,21912,21890,21916,21930,21908,21895,21899,21891,21939,21934,21919,21822,21938,21914,21947,21932,21937,21886,21897,21931,21913,22285,22575,22570,22580,22564,22576,22577,22561,22557,22560,22777,22778,22880,23159,23194,23167,23186,23195,23207,23411,23409,23506,23500,23507,23504,23562,23563,23601,23884,23888,23860,23879,24061,24133,24125,24128,24131,24190,24266,24257,24258,24260,24380,24429,24489,24490,24488,24785,24801,24754,24758,24800,24860,24867,24826,24853,24816,24827,24820,24936,24817,24846,24822,24841,24832,24850,25119,25161,25507,25484,25551,25536,25577,25545,25542,25549,25554,25571,25552,25569,25558,25581,25582,25462,25588,25578,25563,25682,25562,25593,25950,25958,25954,25955,26001,26000,26031,26222,26224,26228,26230,26223,26257,26234,26238,26231,26366,26367,26399,26397,26874,26837,26848,26840,26839,26885,26847,26869,26862,26855,26873,26834,26866,26851,26827,26829,26893,26898,26894,26825,26842,26990,26875,27454,27450,27453,27544,27542,27580,27631,27694,27695,27692,28207,28216,28244,28193,28210,28263,28234,28192,28197,28195,28187,28251,28248,28196,28246,28270,28205,28198,28271,28212,28237,28218,28204,28227,28189,28222,28363,28297,28185,28238,28259,28228,28274,28265,28255,28953,28954,28966,28976,28961,28982,29038,28956,29260,29316,29312,29494,29477,29492,29481,29754,29738,29747,29730,29733,29749,29750,29748,29743,29723,29734,29736,29989,29990,30059,30058,30178,30171,30179,30169,30168,30174,30176,30331,30332,30358,30355,30388,30428,30543,30701,30813,30828,30831,31245,31240,31243,31237,31232,31384,31383,31382,31461,31459,31561,31574,31558,31568,31570,31572,31565,31563,31567,31569,31903,31909,32094,32080,32104,32085,32043,32110,32114,32097,32102,32098,32112,32115,21892,32724,32725,32779,32850,32901,33109,33108,33099,33105,33102,33081,33094,33086,33100,33107,33140,33298,33308,33769,33795,33784,33805,33760,33733,33803,33729,33775,33777,33780,33879,33802,33776,33804,33740,33789,33778,33738,33848,33806,33796,33756,33799,33748,33759,34395,34527,34521,34541,34516,34523,34532,34512,34526,34903,35009,35010,34993,35203,35222,35387,35424,35413,35422,35388,35393,35412,35419,35408,35398,35380,35386,35382,35414,35937,35970,36015,36028,36019,36029,36033,36027,36032,36020,36023,36022,36031,36024,36234,36229,36225,36302,36317,36299,36314,36305,36300,36315,36294,36603,36600,36604,36764,36910,36917,36913,36920,36914,36918,37122,37109,37129,37118,37219,37221,37327,37396,37397,37411,37385,37406,37389,37392,37383,37393,38292,38287,38283,38289,38291,38290,38286,38538,38542,38539,38525,38533,38534,38541,38514,38532,38593,38597,38596,38598,38599,38639,38642,38860,38917,38918,38920,39143,39146,39151,39145,39154,39149,39342,39341,40643,40653,40657,20098,20653,20661,20658,20659,20677,20670,20652,20663,20667,20655,20679,21119,21111,21117,21215,21222,21220,21218,21219,21295,21983,21992,21971,21990,21966,21980,21959,21969,21987,21988,21999,21978,21985,21957,21958,21989,21961,22290,22291,22622,22609,22616,22615,22618,22612,22635,22604,22637,22602,22626,22610,22603,22887,23233,23241,23244,23230,23229,23228,23219,23234,23218,23913,23919,24140,24185,24265,24264,24338,24409,24492,24494,24858,24847,24904,24863,24819,24859,24825,24833,24840,24910,24908,24900,24909,24894,24884,24871,24845,24838,24887,25121,25122,25619,25662,25630,25642,25645,25661,25644,25615,25628,25620,25613,25654,25622,25623,25606,25964,26015,26032,26263,26249,26247,26248,26262,26244,26264,26253,26371,27028,26989,26970,26999,26976,26964,26997,26928,27010,26954,26984,26987,26974,26963,27001,27014,26973,26979,26971,27463,27506,27584,27583,27603,27645,28322,28335,28371,28342,28354,28304,28317,28359,28357,28325,28312,28348,28346,28331,28369,28310,28316,28356,28372,28330,28327,28340,29006,29017,29033,29028,29001,29031,29020,29036,29030,29004,29029,29022,28998,29032,29014,29242,29266,29495,29509,29503,29502,29807,29786,29781,29791,29790,29761,29759,29785,29787,29788,30070,30072,30208,30192,30209,30194,30193,30202,30207,30196,30195,30430,30431,30555,30571,30566,30558,30563,30585,30570,30572,30556,30565,30568,30562,30702,30862,30896,30871,30872,30860,30857,30844,30865,30867,30847,31098,31103,31105,33836,31165,31260,31258,31264,31252,31263,31262,31391,31392,31607,31680,31584,31598,31591,31921,31923,31925,32147,32121,32145,32129,32143,32091,32622,32617,32618,32626,32681,32680,32676,32854,32856,32902,32900,33137,33136,33144,33125,33134,33139,33131,33145,33146,33126,33285,33351,33922,33911,33853,33841,33909,33894,33899,33865,33900,33883,33852,33845,33889,33891,33897,33901,33862,34398,34396,34399,34553,34579,34568,34567,34560,34558,34555,34562,34563,34566,34570,34905,35039,35028,35033,35036,35032,35037,35041,35018,35029,35026,35228,35299,35435,35442,35443,35430,35433,35440,35463,35452,35427,35488,35441,35461,35437,35426,35438,35436,35449,35451,35390,35432,35938,35978,35977,36042,36039,36040,36036,36018,36035,36034,36037,36321,36319,36328,36335,36339,36346,36330,36324,36326,36530,36611,36617,36606,36618,36767,36786,36939,36938,36947,36930,36948,36924,36949,36944,36935,36943,36942,36941,36945,36926,36929,37138,37143,37228,37226,37225,37321,37431,37463,37432,37437,37440,37438,37467,37451,37476,37457,37428,37449,37453,37445,37433,37439,37466,38296,38552,38548,38549,38605,38603,38601,38602,38647,38651,38649,38646,38742,38772,38774,38928,38929,38931,38922,38930,38924,39164,39156,39165,39166,39347,39345,39348,39649,40169,40578,40718,40723,40736,20711,20718,20709,20694,20717,20698,20693,20687,20689,20721,20686,20713,20834,20979,21123,21122,21297,21421,22014,22016,22043,22039,22013,22036,22022,22025,22029,22030,22007,22038,22047,22024,22032,22006,22296,22294,22645,22654,22659,22675,22666,22649,22661,22653,22781,22821,22818,22820,22890,22889,23265,23270,23273,23255,23254,23256,23267,23413,23518,23527,23521,23525,23526,23528,23522,23524,23519,23565,23650,23940,23943,24155,24163,24149,24151,24148,24275,24278,24330,24390,24432,24505,24903,24895,24907,24951,24930,24931,24927,24922,24920,24949,25130,25735,25688,25684,25764,25720,25695,25722,25681,25703,25652,25709,25723,25970,26017,26071,26070,26274,26280,26269,27036,27048,27029,27073,27054,27091,27083,27035,27063,27067,27051,27060,27088,27085,27053,27084,27046,27075,27043,27465,27468,27699,28467,28436,28414,28435,28404,28457,28478,28448,28460,28431,28418,28450,28415,28399,28422,28465,28472,28466,28451,28437,28459,28463,28552,28458,28396,28417,28402,28364,28407,29076,29081,29053,29066,29060,29074,29246,29330,29334,29508,29520,29796,29795,29802,29808,29805,29956,30097,30247,30221,30219,30217,30227,30433,30435,30596,30589,30591,30561,30913,30879,30887,30899,30889,30883,31118,31119,31117,31278,31281,31402,31401,31469,31471,31649,31637,31627,31605,31639,31645,31636,31631,31672,31623,31620,31929,31933,31934,32187,32176,32156,32189,32190,32160,32202,32180,32178,32177,32186,32162,32191,32181,32184,32173,32210,32199,32172,32624,32736,32737,32735,32862,32858,32903,33104,33152,33167,33160,33162,33151,33154,33255,33274,33287,33300,33310,33355,33993,33983,33990,33988,33945,33950,33970,33948,33995,33976,33984,34003,33936,33980,34001,33994,34623,34588,34619,34594,34597,34612,34584,34645,34615,34601,35059,35074,35060,35065,35064,35069,35048,35098,35055,35494,35468,35486,35491,35469,35489,35475,35492,35498,35493,35496,35480,35473,35482,35495,35946,35981,35980,36051,36049,36050,36203,36249,36245,36348,36628,36626,36629,36627,36771,36960,36952,36956,36963,36953,36958,36962,36957,36955,37145,37144,37150,37237,37240,37239,37236,37496,37504,37509,37528,37526,37499,37523,37532,37544,37500,37521,38305,38312,38313,38307,38309,38308,38553,38556,38555,38604,38610,38656,38780,38789,38902,38935,38936,39087,39089,39171,39173,39180,39177,39361,39599,39600,39654,39745,39746,40180,40182,40179,40636,40763,40778,20740,20736,20731,20725,20729,20738,20744,20745,20741,20956,21127,21128,21129,21133,21130,21232,21426,22062,22075,22073,22066,22079,22068,22057,22099,22094,22103,22132,22070,22063,22064,22656,22687,22686,22707,22684,22702,22697,22694,22893,23305,23291,23307,23285,23308,23304,23534,23532,23529,23531,23652,23653,23965,23956,24162,24159,24161,24290,24282,24287,24285,24291,24288,24392,24433,24503,24501,24950,24935,24942,24925,24917,24962,24956,24944,24939,24958,24999,24976,25003,24974,25004,24986,24996,24980,25006,25134,25705,25711,25721,25758,25778,25736,25744,25776,25765,25747,25749,25769,25746,25774,25773,25771,25754,25772,25753,25762,25779,25973,25975,25976,26286,26283,26292,26289,27171,27167,27112,27137,27166,27161,27133,27169,27155,27146,27123,27138,27141,27117,27153,27472,27470,27556,27589,27590,28479,28540,28548,28497,28518,28500,28550,28525,28507,28536,28526,28558,28538,28528,28516,28567,28504,28373,28527,28512,28511,29087,29100,29105,29096,29270,29339,29518,29527,29801,29835,29827,29822,29824,30079,30240,30249,30239,30244,30246,30241,30242,30362,30394,30436,30606,30599,30604,30609,30603,30923,30917,30906,30922,30910,30933,30908,30928,31295,31292,31296,31293,31287,31291,31407,31406,31661,31665,31684,31668,31686,31687,31681,31648,31692,31946,32224,32244,32239,32251,32216,32236,32221,32232,32227,32218,32222,32233,32158,32217,32242,32249,32629,32631,32687,32745,32806,33179,33180,33181,33184,33178,33176,34071,34109,34074,34030,34092,34093,34067,34065,34083,34081,34068,34028,34085,34047,34054,34690,34676,34678,34656,34662,34680,34664,34649,34647,34636,34643,34907,34909,35088,35079,35090,35091,35093,35082,35516,35538,35527,35524,35477,35531,35576,35506,35529,35522,35519,35504,35542,35533,35510,35513,35547,35916,35918,35948,36064,36062,36070,36068,36076,36077,36066,36067,36060,36074,36065,36205,36255,36259,36395,36368,36381,36386,36367,36393,36383,36385,36382,36538,36637,36635,36639,36649,36646,36650,36636,36638,36645,36969,36974,36968,36973,36983,37168,37165,37159,37169,37255,37257,37259,37251,37573,37563,37559,37610,37548,37604,37569,37555,37564,37586,37575,37616,37554,38317,38321,38660,38662,38663,38665,38752,38797,38795,38799,38945,38955,38940,39091,39178,39187,39186,39192,39389,39376,39391,39387,39377,39381,39378,39385,39607,39662,39663,39719,39749,39748,39799,39791,40198,40201,40195,40617,40638,40654,22696,40786,20754,20760,20756,20752,20757,20864,20906,20957,21137,21139,21235,22105,22123,22137,22121,22116,22136,22122,22120,22117,22129,22127,22124,22114,22134,22721,22718,22727,22725,22894,23325,23348,23416,23536,23566,24394,25010,24977,25001,24970,25037,25014,25022,25034,25032,25136,25797,25793,25803,25787,25788,25818,25796,25799,25794,25805,25791,25810,25812,25790,25972,26310,26313,26297,26308,26311,26296,27197,27192,27194,27225,27243,27224,27193,27204,27234,27233,27211,27207,27189,27231,27208,27481,27511,27653,28610,28593,28577,28611,28580,28609,28583,28595,28608,28601,28598,28582,28576,28596,29118,29129,29136,29138,29128,29141,29113,29134,29145,29148,29123,29124,29544,29852,29859,29848,29855,29854,29922,29964,29965,30260,30264,30266,30439,30437,30624,30622,30623,30629,30952,30938,30956,30951,31142,31309,31310,31302,31308,31307,31418,31705,31761,31689,31716,31707,31713,31721,31718,31957,31958,32266,32273,32264,32283,32291,32286,32285,32265,32272,32633,32690,32752,32753,32750,32808,33203,33193,33192,33275,33288,33368,33369,34122,34137,34120,34152,34153,34115,34121,34157,34154,34142,34691,34719,34718,34722,34701,34913,35114,35122,35109,35115,35105,35242,35238,35558,35578,35563,35569,35584,35548,35559,35566,35582,35585,35586,35575,35565,35571,35574,35580,35947,35949,35987,36084,36420,36401,36404,36418,36409,36405,36667,36655,36664,36659,36776,36774,36981,36980,36984,36978,36988,36986,37172,37266,37664,37686,37624,37683,37679,37666,37628,37675,37636,37658,37648,37670,37665,37653,37678,37657,38331,38567,38568,38570,38613,38670,38673,38678,38669,38675,38671,38747,38748,38758,38808,38960,38968,38971,38967,38957,38969,38948,39184,39208,39198,39195,39201,39194,39405,39394,39409,39608,39612,39675,39661,39720,39825,40213,40227,40230,40232,40210,40219,40664,40660,40845,40860,20778,20767,20769,20786,21237,22158,22144,22160,22149,22151,22159,22741,22739,22737,22734,23344,23338,23332,23418,23607,23656,23996,23994,23997,23992,24171,24396,24509,25033,25026,25031,25062,25035,25138,25140,25806,25802,25816,25824,25840,25830,25836,25841,25826,25837,25986,25987,26329,26326,27264,27284,27268,27298,27292,27355,27299,27262,27287,27280,27296,27484,27566,27610,27656,28632,28657,28639,28640,28635,28644,28651,28655,28544,28652,28641,28649,28629,28654,28656,29159,29151,29166,29158,29157,29165,29164,29172,29152,29237,29254,29552,29554,29865,29872,29862,29864,30278,30274,30284,30442,30643,30634,30640,30636,30631,30637,30703,30967,30970,30964,30959,30977,31143,31146,31319,31423,31751,31757,31742,31735,31756,31712,31968,31964,31966,31970,31967,31961,31965,32302,32318,32326,32311,32306,32323,32299,32317,32305,32325,32321,32308,32313,32328,32309,32319,32303,32580,32755,32764,32881,32882,32880,32879,32883,33222,33219,33210,33218,33216,33215,33213,33225,33214,33256,33289,33393,34218,34180,34174,34204,34193,34196,34223,34203,34183,34216,34186,34407,34752,34769,34739,34770,34758,34731,34747,34746,34760,34763,35131,35126,35140,35128,35133,35244,35598,35607,35609,35611,35594,35616,35613,35588,35600,35905,35903,35955,36090,36093,36092,36088,36091,36264,36425,36427,36424,36426,36676,36670,36674,36677,36671,36991,36989,36996,36993,36994,36992,37177,37283,37278,37276,37709,37762,37672,37749,37706,37733,37707,37656,37758,37740,37723,37744,37722,37716,38346,38347,38348,38344,38342,38577,38584,38614,38684,38686,38816,38867,38982,39094,39221,39425,39423,39854,39851,39850,39853,40251,40255,40587,40655,40670,40668,40669,40667,40766,40779,21474,22165,22190,22745,22744,23352,24413,25059,25139,25844,25842,25854,25862,25850,25851,25847,26039,26332,26406,27315,27308,27331,27323,27320,27330,27310,27311,27487,27512,27567,28681,28683,28670,28678,28666,28689,28687,29179,29180,29182,29176,29559,29557,29863,29887,29973,30294,30296,30290,30653,30655,30651,30652,30990,31150,31329,31330,31328,31428,31429,31787,31783,31786,31774,31779,31777,31975,32340,32341,32350,32346,32353,32338,32345,32584,32761,32763,32887,32886,33229,33231,33290,34255,34217,34253,34256,34249,34224,34234,34233,34214,34799,34796,34802,34784,35206,35250,35316,35624,35641,35628,35627,35920,36101,36441,36451,36454,36452,36447,36437,36544,36681,36685,36999,36995,37000,37291,37292,37328,37780,37770,37782,37794,37811,37806,37804,37808,37784,37786,37783,38356,38358,38352,38357,38626,38620,38617,38619,38622,38692,38819,38822,38829,38905,38989,38991,38988,38990,38995,39098,39230,39231,39229,39214,39333,39438,39617,39683,39686,39759,39758,39757,39882,39881,39933,39880,39872,40273,40285,40288,40672,40725,40748,20787,22181,22750,22751,22754,23541,40848,24300,25074,25079,25078,25077,25856,25871,26336,26333,27365,27357,27354,27347,28699,28703,28712,28698,28701,28693,28696,29190,29197,29272,29346,29560,29562,29885,29898,29923,30087,30086,30303,30305,30663,31001,31153,31339,31337,31806,31807,31800,31805,31799,31808,32363,32365,32377,32361,32362,32645,32371,32694,32697,32696,33240,34281,34269,34282,34261,34276,34277,34295,34811,34821,34829,34809,34814,35168,35167,35158,35166,35649,35676,35672,35657,35674,35662,35663,35654,35673,36104,36106,36476,36466,36487,36470,36460,36474,36468,36692,36686,36781,37002,37003,37297,37294,37857,37841,37855,37827,37832,37852,37853,37846,37858,37837,37848,37860,37847,37864,38364,38580,38627,38698,38695,38753,38876,38907,39006,39000,39003,39100,39237,39241,39446,39449,39693,39912,39911,39894,39899,40329,40289,40306,40298,40300,40594,40599,40595,40628,21240,22184,22199,22198,22196,22204,22756,23360,23363,23421,23542,24009,25080,25082,25880,25876,25881,26342,26407,27372,28734,28720,28722,29200,29563,29903,30306,30309,31014,31018,31020,31019,31431,31478,31820,31811,31821,31983,31984,36782,32381,32380,32386,32588,32768,33242,33382,34299,34297,34321,34298,34310,34315,34311,34314,34836,34837,35172,35258,35320,35696,35692,35686,35695,35679,35691,36111,36109,36489,36481,36485,36482,37300,37323,37912,37891,37885,38369,38704,39108,39250,39249,39336,39467,39472,39479,39477,39955,39949,40569,40629,40680,40751,40799,40803,40801,20791,20792,22209,22208,22210,22804,23660,24013,25084,25086,25885,25884,26005,26345,27387,27396,27386,27570,28748,29211,29351,29910,29908,30313,30675,31824,32399,32396,32700,34327,34349,34330,34851,34850,34849,34847,35178,35180,35261,35700,35703,35709,36115,36490,36493,36491,36703,36783,37306,37934,37939,37941,37946,37944,37938,37931,38370,38712,38713,38706,38911,39015,39013,39255,39493,39491,39488,39486,39631,39764,39761,39981,39973,40367,40372,40386,40376,40605,40687,40729,40796,40806,40807,20796,20795,22216,22218,22217,23423,24020,24018,24398,25087,25892,27402,27489,28753,28760,29568,29924,30090,30318,30316,31155,31840,31839,32894,32893,33247,35186,35183,35324,35712,36118,36119,36497,36499,36705,37192,37956,37969,37970,38717,38718,38851,38849,39019,39253,39509,39501,39634,39706,40009,39985,39998,39995,40403,40407,40756,40812,40810,40852,22220,24022,25088,25891,25899,25898,26348,27408,29914,31434,31844,31843,31845,32403,32406,32404,33250,34360,34367,34865,35722,37008,37007,37987,37984,37988,38760,39023,39260,39514,39515,39511,39635,39636,39633,40020,40023,40022,40421,40607,40692,22225,22761,25900,28766,30321,30322,30679,32592,32648,34870,34873,34914,35731,35730,35734,33399,36123,37312,37994,38722,38728,38724,38854,39024,39519,39714,39768,40031,40441,40442,40572,40573,40711,40823,40818,24307,27414,28771,31852,31854,34875,35264,36513,37313,38002,38000,39025,39262,39638,39715,40652,28772,30682,35738,38007,38857,39522,39525,32412,35740,36522,37317,38013,38014,38012,40055,40056,40695,35924,38015,40474,29224,39530,39729,40475,40478,31858,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,9332,9333,9334,9335,9336,9337,9338,9339,9340,9341,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,20022,20031,20101,20128,20866,20886,20907,21241,21304,21353,21430,22794,23424,24027,12083,24191,24308,24400,24417,25908,26080,30098,30326,36789,38582,168,710,12541,12542,12445,12446,12291,20189,12293,12294,12295,12540,65339,65341,10045,12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,12449,12450,12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,12534,1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,8679,8632,8633,12751,131276,20058,131210,20994,17553,40880,20872,40881,161287,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65506,65508,65287,65282,12849,8470,8481,12443,12444,11904,11908,11910,11911,11912,11914,11916,11917,11925,11932,11933,11941,11943,11946,11948,11950,11958,11964,11966,11974,11978,11980,11981,11983,11990,11991,11998,12003,null,null,null,643,592,603,596,629,339,248,331,650,618,20034,20060,20981,21274,21378,19975,19980,20039,20109,22231,64012,23662,24435,19983,20871,19982,20014,20115,20162,20169,20168,20888,21244,21356,21433,22304,22787,22828,23568,24063,26081,27571,27596,27668,29247,20017,20028,20200,20188,20201,20193,20189,20186,21004,21276,21324,22306,22307,22807,22831,23425,23428,23570,23611,23668,23667,24068,24192,24194,24521,25097,25168,27669,27702,27715,27711,27707,29358,29360,29578,31160,32906,38430,20238,20248,20268,20213,20244,20209,20224,20215,20232,20253,20226,20229,20258,20243,20228,20212,20242,20913,21011,21001,21008,21158,21282,21279,21325,21386,21511,22241,22239,22318,22314,22324,22844,22912,22908,22917,22907,22910,22903,22911,23382,23573,23589,23676,23674,23675,23678,24031,24181,24196,24322,24346,24436,24533,24532,24527,25180,25182,25188,25185,25190,25186,25177,25184,25178,25189,26095,26094,26430,26425,26424,26427,26426,26431,26428,26419,27672,27718,27730,27740,27727,27722,27732,27723,27724,28785,29278,29364,29365,29582,29994,30335,31349,32593,33400,33404,33408,33405,33407,34381,35198,37017,37015,37016,37019,37012,38434,38436,38432,38435,20310,20283,20322,20297,20307,20324,20286,20327,20306,20319,20289,20312,20269,20275,20287,20321,20879,20921,21020,21022,21025,21165,21166,21257,21347,21362,21390,21391,21552,21559,21546,21588,21573,21529,21532,21541,21528,21565,21583,21569,21544,21540,21575,22254,22247,22245,22337,22341,22348,22345,22347,22354,22790,22848,22950,22936,22944,22935,22926,22946,22928,22927,22951,22945,23438,23442,23592,23594,23693,23695,23688,23691,23689,23698,23690,23686,23699,23701,24032,24074,24078,24203,24201,24204,24200,24205,24325,24349,24440,24438,24530,24529,24528,24557,24552,24558,24563,24545,24548,24547,24570,24559,24567,24571,24576,24564,25146,25219,25228,25230,25231,25236,25223,25201,25211,25210,25200,25217,25224,25207,25213,25202,25204,25911,26096,26100,26099,26098,26101,26437,26439,26457,26453,26444,26440,26461,26445,26458,26443,27600,27673,27674,27768,27751,27755,27780,27787,27791,27761,27759,27753,27802,27757,27783,27797,27804,27750,27763,27749,27771,27790,28788,28794,29283,29375,29373,29379,29382,29377,29370,29381,29589,29591,29587,29588,29586,30010,30009,30100,30101,30337,31037,32820,32917,32921,32912,32914,32924,33424,33423,33413,33422,33425,33427,33418,33411,33412,35960,36809,36799,37023,37025,37029,37022,37031,37024,38448,38440,38447,38445,20019,20376,20348,20357,20349,20352,20359,20342,20340,20361,20356,20343,20300,20375,20330,20378,20345,20353,20344,20368,20380,20372,20382,20370,20354,20373,20331,20334,20894,20924,20926,21045,21042,21043,21062,21041,21180,21258,21259,21308,21394,21396,21639,21631,21633,21649,21634,21640,21611,21626,21630,21605,21612,21620,21606,21645,21615,21601,21600,21656,21603,21607,21604,22263,22265,22383,22386,22381,22379,22385,22384,22390,22400,22389,22395,22387,22388,22370,22376,22397,22796,22853,22965,22970,22991,22990,22962,22988,22977,22966,22972,22979,22998,22961,22973,22976,22984,22964,22983,23394,23397,23443,23445,23620,23623,23726,23716,23712,23733,23727,23720,23724,23711,23715,23725,23714,23722,23719,23709,23717,23734,23728,23718,24087,24084,24089,24360,24354,24355,24356,24404,24450,24446,24445,24542,24549,24621,24614,24601,24626,24587,24628,24586,24599,24627,24602,24606,24620,24610,24589,24592,24622,24595,24593,24588,24585,24604,25108,25149,25261,25268,25297,25278,25258,25270,25290,25262,25267,25263,25275,25257,25264,25272,25917,26024,26043,26121,26108,26116,26130,26120,26107,26115,26123,26125,26117,26109,26129,26128,26358,26378,26501,26476,26510,26514,26486,26491,26520,26502,26500,26484,26509,26508,26490,26527,26513,26521,26499,26493,26497,26488,26489,26516,27429,27520,27518,27614,27677,27795,27884,27883,27886,27865,27830,27860,27821,27879,27831,27856,27842,27834,27843,27846,27885,27890,27858,27869,27828,27786,27805,27776,27870,27840,27952,27853,27847,27824,27897,27855,27881,27857,28820,28824,28805,28819,28806,28804,28817,28822,28802,28826,28803,29290,29398,29387,29400,29385,29404,29394,29396,29402,29388,29393,29604,29601,29613,29606,29602,29600,29612,29597,29917,29928,30015,30016,30014,30092,30104,30383,30451,30449,30448,30453,30712,30716,30713,30715,30714,30711,31042,31039,31173,31352,31355,31483,31861,31997,32821,32911,32942,32931,32952,32949,32941,33312,33440,33472,33451,33434,33432,33435,33461,33447,33454,33468,33438,33466,33460,33448,33441,33449,33474,33444,33475,33462,33442,34416,34415,34413,34414,35926,36818,36811,36819,36813,36822,36821,36823,37042,37044,37039,37043,37040,38457,38461,38460,38458,38467,20429,20421,20435,20402,20425,20427,20417,20436,20444,20441,20411,20403,20443,20423,20438,20410,20416,20409,20460,21060,21065,21184,21186,21309,21372,21399,21398,21401,21400,21690,21665,21677,21669,21711,21699,33549,21687,21678,21718,21686,21701,21702,21664,21616,21692,21666,21694,21618,21726,21680,22453,22430,22431,22436,22412,22423,22429,22427,22420,22424,22415,22425,22437,22426,22421,22772,22797,22867,23009,23006,23022,23040,23025,23005,23034,23037,23036,23030,23012,23026,23031,23003,23017,23027,23029,23008,23038,23028,23021,23464,23628,23760,23768,23756,23767,23755,23771,23774,23770,23753,23751,23754,23766,23763,23764,23759,23752,23750,23758,23775,23800,24057,24097,24098,24099,24096,24100,24240,24228,24226,24219,24227,24229,24327,24366,24406,24454,24631,24633,24660,24690,24670,24645,24659,24647,24649,24667,24652,24640,24642,24671,24612,24644,24664,24678,24686,25154,25155,25295,25357,25355,25333,25358,25347,25323,25337,25359,25356,25336,25334,25344,25363,25364,25338,25365,25339,25328,25921,25923,26026,26047,26166,26145,26162,26165,26140,26150,26146,26163,26155,26170,26141,26164,26169,26158,26383,26384,26561,26610,26568,26554,26588,26555,26616,26584,26560,26551,26565,26603,26596,26591,26549,26573,26547,26615,26614,26606,26595,26562,26553,26574,26599,26608,26546,26620,26566,26605,26572,26542,26598,26587,26618,26569,26570,26563,26602,26571,27432,27522,27524,27574,27606,27608,27616,27680,27681,27944,27956,27949,27935,27964,27967,27922,27914,27866,27955,27908,27929,27962,27930,27921,27904,27933,27970,27905,27928,27959,27907,27919,27968,27911,27936,27948,27912,27938,27913,27920,28855,28831,28862,28849,28848,28833,28852,28853,28841,29249,29257,29258,29292,29296,29299,29294,29386,29412,29416,29419,29407,29418,29414,29411,29573,29644,29634,29640,29637,29625,29622,29621,29620,29675,29631,29639,29630,29635,29638,29624,29643,29932,29934,29998,30023,30024,30119,30122,30329,30404,30472,30467,30468,30469,30474,30455,30459,30458,30695,30696,30726,30737,30738,30725,30736,30735,30734,30729,30723,30739,31050,31052,31051,31045,31044,31189,31181,31183,31190,31182,31360,31358,31441,31488,31489,31866,31864,31865,31871,31872,31873,32003,32008,32001,32600,32657,32653,32702,32775,32782,32783,32788,32823,32984,32967,32992,32977,32968,32962,32976,32965,32995,32985,32988,32970,32981,32969,32975,32983,32998,32973,33279,33313,33428,33497,33534,33529,33543,33512,33536,33493,33594,33515,33494,33524,33516,33505,33522,33525,33548,33531,33526,33520,33514,33508,33504,33530,33523,33517,34423,34420,34428,34419,34881,34894,34919,34922,34921,35283,35332,35335,36210,36835,36833,36846,36832,37105,37053,37055,37077,37061,37054,37063,37067,37064,37332,37331,38484,38479,38481,38483,38474,38478,20510,20485,20487,20499,20514,20528,20507,20469,20468,20531,20535,20524,20470,20471,20503,20508,20512,20519,20533,20527,20529,20494,20826,20884,20883,20938,20932,20933,20936,20942,21089,21082,21074,21086,21087,21077,21090,21197,21262,21406,21798,21730,21783,21778,21735,21747,21732,21786,21759,21764,21768,21739,21777,21765,21745,21770,21755,21751,21752,21728,21774,21763,21771,22273,22274,22476,22578,22485,22482,22458,22470,22461,22460,22456,22454,22463,22471,22480,22457,22465,22798,22858,23065,23062,23085,23086,23061,23055,23063,23050,23070,23091,23404,23463,23469,23468,23555,23638,23636,23788,23807,23790,23793,23799,23808,23801,24105,24104,24232,24238,24234,24236,24371,24368,24423,24669,24666,24679,24641,24738,24712,24704,24722,24705,24733,24707,24725,24731,24727,24711,24732,24718,25113,25158,25330,25360,25430,25388,25412,25413,25398,25411,25572,25401,25419,25418,25404,25385,25409,25396,25432,25428,25433,25389,25415,25395,25434,25425,25400,25431,25408,25416,25930,25926,26054,26051,26052,26050,26186,26207,26183,26193,26386,26387,26655,26650,26697,26674,26675,26683,26699,26703,26646,26673,26652,26677,26667,26669,26671,26702,26692,26676,26653,26642,26644,26662,26664,26670,26701,26682,26661,26656,27436,27439,27437,27441,27444,27501,32898,27528,27622,27620,27624,27619,27618,27623,27685,28026,28003,28004,28022,27917,28001,28050,27992,28002,28013,28015,28049,28045,28143,28031,28038,27998,28007,28000,28055,28016,28028,27999,28034,28056,27951,28008,28043,28030,28032,28036,27926,28035,28027,28029,28021,28048,28892,28883,28881,28893,28875,32569,28898,28887,28882,28894,28896,28884,28877,28869,28870,28871,28890,28878,28897,29250,29304,29303,29302,29440,29434,29428,29438,29430,29427,29435,29441,29651,29657,29669,29654,29628,29671,29667,29673,29660,29650,29659,29652,29661,29658,29655,29656,29672,29918,29919,29940,29941,29985,30043,30047,30128,30145,30139,30148,30144,30143,30134,30138,30346,30409,30493,30491,30480,30483,30482,30499,30481,30485,30489,30490,30498,30503,30755,30764,30754,30773,30767,30760,30766,30763,30753,30761,30771,30762,30769,31060,31067,31055,31068,31059,31058,31057,31211,31212,31200,31214,31213,31210,31196,31198,31197,31366,31369,31365,31371,31372,31370,31367,31448,31504,31492,31507,31493,31503,31496,31498,31502,31497,31506,31876,31889,31882,31884,31880,31885,31877,32030,32029,32017,32014,32024,32022,32019,32031,32018,32015,32012,32604,32609,32606,32608,32605,32603,32662,32658,32707,32706,32704,32790,32830,32825,33018,33010,33017,33013,33025,33019,33024,33281,33327,33317,33587,33581,33604,33561,33617,33573,33622,33599,33601,33574,33564,33570,33602,33614,33563,33578,33544,33596,33613,33558,33572,33568,33591,33583,33577,33607,33605,33612,33619,33566,33580,33611,33575,33608,34387,34386,34466,34472,34454,34445,34449,34462,34439,34455,34438,34443,34458,34437,34469,34457,34465,34471,34453,34456,34446,34461,34448,34452,34883,34884,34925,34933,34934,34930,34944,34929,34943,34927,34947,34942,34932,34940,35346,35911,35927,35963,36004,36003,36214,36216,36277,36279,36278,36561,36563,36862,36853,36866,36863,36859,36868,36860,36854,37078,37088,37081,37082,37091,37087,37093,37080,37083,37079,37084,37092,37200,37198,37199,37333,37346,37338,38492,38495,38588,39139,39647,39727,20095,20592,20586,20577,20574,20576,20563,20555,20573,20594,20552,20557,20545,20571,20554,20578,20501,20549,20575,20585,20587,20579,20580,20550,20544,20590,20595,20567,20561,20944,21099,21101,21100,21102,21206,21203,21293,21404,21877,21878,21820,21837,21840,21812,21802,21841,21858,21814,21813,21808,21842,21829,21772,21810,21861,21838,21817,21832,21805,21819,21824,21835,22282,22279,22523,22548,22498,22518,22492,22516,22528,22509,22525,22536,22520,22539,22515,22479,22535,22510,22499,22514,22501,22508,22497,22542,22524,22544,22503,22529,22540,22513,22505,22512,22541,22532,22876,23136,23128,23125,23143,23134,23096,23093,23149,23120,23135,23141,23148,23123,23140,23127,23107,23133,23122,23108,23131,23112,23182,23102,23117,23097,23116,23152,23145,23111,23121,23126,23106,23132,23410,23406,23489,23488,23641,23838,23819,23837,23834,23840,23820,23848,23821,23846,23845,23823,23856,23826,23843,23839,23854,24126,24116,24241,24244,24249,24242,24243,24374,24376,24475,24470,24479,24714,24720,24710,24766,24752,24762,24787,24788,24783,24804,24793,24797,24776,24753,24795,24759,24778,24767,24771,24781,24768,25394,25445,25482,25474,25469,25533,25502,25517,25501,25495,25515,25486,25455,25479,25488,25454,25519,25461,25500,25453,25518,25468,25508,25403,25503,25464,25477,25473,25489,25485,25456,25939,26061,26213,26209,26203,26201,26204,26210,26392,26745,26759,26768,26780,26733,26734,26798,26795,26966,26735,26787,26796,26793,26741,26740,26802,26767,26743,26770,26748,26731,26738,26794,26752,26737,26750,26779,26774,26763,26784,26761,26788,26744,26747,26769,26764,26762,26749,27446,27443,27447,27448,27537,27535,27533,27534,27532,27690,28096,28075,28084,28083,28276,28076,28137,28130,28087,28150,28116,28160,28104,28128,28127,28118,28094,28133,28124,28125,28123,28148,28106,28093,28141,28144,28090,28117,28098,28111,28105,28112,28146,28115,28157,28119,28109,28131,28091,28922,28941,28919,28951,28916,28940,28912,28932,28915,28944,28924,28927,28934,28947,28928,28920,28918,28939,28930,28942,29310,29307,29308,29311,29469,29463,29447,29457,29464,29450,29448,29439,29455,29470,29576,29686,29688,29685,29700,29697,29693,29703,29696,29690,29692,29695,29708,29707,29684,29704,30052,30051,30158,30162,30159,30155,30156,30161,30160,30351,30345,30419,30521,30511,30509,30513,30514,30516,30515,30525,30501,30523,30517,30792,30802,30793,30797,30794,30796,30758,30789,30800,31076,31079,31081,31082,31075,31083,31073,31163,31226,31224,31222,31223,31375,31380,31376,31541,31559,31540,31525,31536,31522,31524,31539,31512,31530,31517,31537,31531,31533,31535,31538,31544,31514,31523,31892,31896,31894,31907,32053,32061,32056,32054,32058,32069,32044,32041,32065,32071,32062,32063,32074,32059,32040,32611,32661,32668,32669,32667,32714,32715,32717,32720,32721,32711,32719,32713,32799,32798,32795,32839,32835,32840,33048,33061,33049,33051,33069,33055,33068,33054,33057,33045,33063,33053,33058,33297,33336,33331,33338,33332,33330,33396,33680,33699,33704,33677,33658,33651,33700,33652,33679,33665,33685,33689,33653,33684,33705,33661,33667,33676,33693,33691,33706,33675,33662,33701,33711,33672,33687,33712,33663,33702,33671,33710,33654,33690,34393,34390,34495,34487,34498,34497,34501,34490,34480,34504,34489,34483,34488,34508,34484,34491,34492,34499,34493,34494,34898,34953,34965,34984,34978,34986,34970,34961,34977,34975,34968,34983,34969,34971,34967,34980,34988,34956,34963,34958,35202,35286,35289,35285,35376,35367,35372,35358,35897,35899,35932,35933,35965,36005,36221,36219,36217,36284,36290,36281,36287,36289,36568,36574,36573,36572,36567,36576,36577,36900,36875,36881,36892,36876,36897,37103,37098,37104,37108,37106,37107,37076,37099,37100,37097,37206,37208,37210,37203,37205,37356,37364,37361,37363,37368,37348,37369,37354,37355,37367,37352,37358,38266,38278,38280,38524,38509,38507,38513,38511,38591,38762,38916,39141,39319,20635,20629,20628,20638,20619,20643,20611,20620,20622,20637,20584,20636,20626,20610,20615,20831,20948,21266,21265,21412,21415,21905,21928,21925,21933,21879,22085,21922,21907,21896,21903,21941,21889,21923,21906,21924,21885,21900,21926,21887,21909,21921,21902,22284,22569,22583,22553,22558,22567,22563,22568,22517,22600,22565,22556,22555,22579,22591,22582,22574,22585,22584,22573,22572,22587,22881,23215,23188,23199,23162,23202,23198,23160,23206,23164,23205,23212,23189,23214,23095,23172,23178,23191,23171,23179,23209,23163,23165,23180,23196,23183,23187,23197,23530,23501,23499,23508,23505,23498,23502,23564,23600,23863,23875,23915,23873,23883,23871,23861,23889,23886,23893,23859,23866,23890,23869,23857,23897,23874,23865,23881,23864,23868,23858,23862,23872,23877,24132,24129,24408,24486,24485,24491,24777,24761,24780,24802,24782,24772,24852,24818,24842,24854,24837,24821,24851,24824,24828,24830,24769,24835,24856,24861,24848,24831,24836,24843,25162,25492,25521,25520,25550,25573,25576,25583,25539,25757,25587,25546,25568,25590,25557,25586,25589,25697,25567,25534,25565,25564,25540,25560,25555,25538,25543,25548,25547,25544,25584,25559,25561,25906,25959,25962,25956,25948,25960,25957,25996,26013,26014,26030,26064,26066,26236,26220,26235,26240,26225,26233,26218,26226,26369,26892,26835,26884,26844,26922,26860,26858,26865,26895,26838,26871,26859,26852,26870,26899,26896,26867,26849,26887,26828,26888,26992,26804,26897,26863,26822,26900,26872,26832,26877,26876,26856,26891,26890,26903,26830,26824,26845,26846,26854,26868,26833,26886,26836,26857,26901,26917,26823,27449,27451,27455,27452,27540,27543,27545,27541,27581,27632,27634,27635,27696,28156,28230,28231,28191,28233,28296,28220,28221,28229,28258,28203,28223,28225,28253,28275,28188,28211,28235,28224,28241,28219,28163,28206,28254,28264,28252,28257,28209,28200,28256,28273,28267,28217,28194,28208,28243,28261,28199,28280,28260,28279,28245,28281,28242,28262,28213,28214,28250,28960,28958,28975,28923,28974,28977,28963,28965,28962,28978,28959,28968,28986,28955,29259,29274,29320,29321,29318,29317,29323,29458,29451,29488,29474,29489,29491,29479,29490,29485,29478,29475,29493,29452,29742,29740,29744,29739,29718,29722,29729,29741,29745,29732,29731,29725,29737,29728,29746,29947,29999,30063,30060,30183,30170,30177,30182,30173,30175,30180,30167,30357,30354,30426,30534,30535,30532,30541,30533,30538,30542,30539,30540,30686,30700,30816,30820,30821,30812,30829,30833,30826,30830,30832,30825,30824,30814,30818,31092,31091,31090,31088,31234,31242,31235,31244,31236,31385,31462,31460,31562,31547,31556,31560,31564,31566,31552,31576,31557,31906,31902,31912,31905,32088,32111,32099,32083,32086,32103,32106,32079,32109,32092,32107,32082,32084,32105,32081,32095,32078,32574,32575,32613,32614,32674,32672,32673,32727,32849,32847,32848,33022,32980,33091,33098,33106,33103,33095,33085,33101,33082,33254,33262,33271,33272,33273,33284,33340,33341,33343,33397,33595,33743,33785,33827,33728,33768,33810,33767,33764,33788,33782,33808,33734,33736,33771,33763,33727,33793,33757,33765,33752,33791,33761,33739,33742,33750,33781,33737,33801,33807,33758,33809,33798,33730,33779,33749,33786,33735,33745,33770,33811,33731,33772,33774,33732,33787,33751,33762,33819,33755,33790,34520,34530,34534,34515,34531,34522,34538,34525,34539,34524,34540,34537,34519,34536,34513,34888,34902,34901,35002,35031,35001,35000,35008,35006,34998,35004,34999,35005,34994,35073,35017,35221,35224,35223,35293,35290,35291,35406,35405,35385,35417,35392,35415,35416,35396,35397,35410,35400,35409,35402,35404,35407,35935,35969,35968,36026,36030,36016,36025,36021,36228,36224,36233,36312,36307,36301,36295,36310,36316,36303,36309,36313,36296,36311,36293,36591,36599,36602,36601,36582,36590,36581,36597,36583,36584,36598,36587,36593,36588,36596,36585,36909,36916,36911,37126,37164,37124,37119,37116,37128,37113,37115,37121,37120,37127,37125,37123,37217,37220,37215,37218,37216,37377,37386,37413,37379,37402,37414,37391,37388,37376,37394,37375,37373,37382,37380,37415,37378,37404,37412,37401,37399,37381,37398,38267,38285,38284,38288,38535,38526,38536,38537,38531,38528,38594,38600,38595,38641,38640,38764,38768,38766,38919,39081,39147,40166,40697,20099,20100,20150,20669,20671,20678,20654,20676,20682,20660,20680,20674,20656,20673,20666,20657,20683,20681,20662,20664,20951,21114,21112,21115,21116,21955,21979,21964,21968,21963,21962,21981,21952,21972,21956,21993,21951,21970,21901,21967,21973,21986,21974,21960,22002,21965,21977,21954,22292,22611,22632,22628,22607,22605,22601,22639,22613,22606,22621,22617,22629,22619,22589,22627,22641,22780,23239,23236,23243,23226,23224,23217,23221,23216,23231,23240,23227,23238,23223,23232,23242,23220,23222,23245,23225,23184,23510,23512,23513,23583,23603,23921,23907,23882,23909,23922,23916,23902,23912,23911,23906,24048,24143,24142,24138,24141,24139,24261,24268,24262,24267,24263,24384,24495,24493,24823,24905,24906,24875,24901,24886,24882,24878,24902,24879,24911,24873,24896,25120,37224,25123,25125,25124,25541,25585,25579,25616,25618,25609,25632,25636,25651,25667,25631,25621,25624,25657,25655,25634,25635,25612,25638,25648,25640,25665,25653,25647,25610,25626,25664,25637,25639,25611,25575,25627,25646,25633,25614,25967,26002,26067,26246,26252,26261,26256,26251,26250,26265,26260,26232,26400,26982,26975,26936,26958,26978,26993,26943,26949,26986,26937,26946,26967,26969,27002,26952,26953,26933,26988,26931,26941,26981,26864,27000,26932,26985,26944,26991,26948,26998,26968,26945,26996,26956,26939,26955,26935,26972,26959,26961,26930,26962,26927,27003,26940,27462,27461,27459,27458,27464,27457,27547,64013,27643,27644,27641,27639,27640,28315,28374,28360,28303,28352,28319,28307,28308,28320,28337,28345,28358,28370,28349,28353,28318,28361,28343,28336,28365,28326,28367,28338,28350,28355,28380,28376,28313,28306,28302,28301,28324,28321,28351,28339,28368,28362,28311,28334,28323,28999,29012,29010,29027,29024,28993,29021,29026,29042,29048,29034,29025,28994,29016,28995,29003,29040,29023,29008,29011,28996,29005,29018,29263,29325,29324,29329,29328,29326,29500,29506,29499,29498,29504,29514,29513,29764,29770,29771,29778,29777,29783,29760,29775,29776,29774,29762,29766,29773,29780,29921,29951,29950,29949,29981,30073,30071,27011,30191,30223,30211,30199,30206,30204,30201,30200,30224,30203,30198,30189,30197,30205,30361,30389,30429,30549,30559,30560,30546,30550,30554,30569,30567,30548,30553,30573,30688,30855,30874,30868,30863,30852,30869,30853,30854,30881,30851,30841,30873,30848,30870,30843,31100,31106,31101,31097,31249,31256,31257,31250,31255,31253,31266,31251,31259,31248,31395,31394,31390,31467,31590,31588,31597,31604,31593,31602,31589,31603,31601,31600,31585,31608,31606,31587,31922,31924,31919,32136,32134,32128,32141,32127,32133,32122,32142,32123,32131,32124,32140,32148,32132,32125,32146,32621,32619,32615,32616,32620,32678,32677,32679,32731,32732,32801,33124,33120,33143,33116,33129,33115,33122,33138,26401,33118,33142,33127,33135,33092,33121,33309,33353,33348,33344,33346,33349,34033,33855,33878,33910,33913,33935,33933,33893,33873,33856,33926,33895,33840,33869,33917,33882,33881,33908,33907,33885,34055,33886,33847,33850,33844,33914,33859,33912,33842,33861,33833,33753,33867,33839,33858,33837,33887,33904,33849,33870,33868,33874,33903,33989,33934,33851,33863,33846,33843,33896,33918,33860,33835,33888,33876,33902,33872,34571,34564,34551,34572,34554,34518,34549,34637,34552,34574,34569,34561,34550,34573,34565,35030,35019,35021,35022,35038,35035,35034,35020,35024,35205,35227,35295,35301,35300,35297,35296,35298,35292,35302,35446,35462,35455,35425,35391,35447,35458,35460,35445,35459,35457,35444,35450,35900,35915,35914,35941,35940,35942,35974,35972,35973,36044,36200,36201,36241,36236,36238,36239,36237,36243,36244,36240,36242,36336,36320,36332,36337,36334,36304,36329,36323,36322,36327,36338,36331,36340,36614,36607,36609,36608,36613,36615,36616,36610,36619,36946,36927,36932,36937,36925,37136,37133,37135,37137,37142,37140,37131,37134,37230,37231,37448,37458,37424,37434,37478,37427,37477,37470,37507,37422,37450,37446,37485,37484,37455,37472,37479,37487,37430,37473,37488,37425,37460,37475,37456,37490,37454,37459,37452,37462,37426,38303,38300,38302,38299,38546,38547,38545,38551,38606,38650,38653,38648,38645,38771,38775,38776,38770,38927,38925,38926,39084,39158,39161,39343,39346,39344,39349,39597,39595,39771,40170,40173,40167,40576,40701,20710,20692,20695,20712,20723,20699,20714,20701,20708,20691,20716,20720,20719,20707,20704,20952,21120,21121,21225,21227,21296,21420,22055,22037,22028,22034,22012,22031,22044,22017,22035,22018,22010,22045,22020,22015,22009,22665,22652,22672,22680,22662,22657,22655,22644,22667,22650,22663,22673,22670,22646,22658,22664,22651,22676,22671,22782,22891,23260,23278,23269,23253,23274,23258,23277,23275,23283,23266,23264,23259,23276,23262,23261,23257,23272,23263,23415,23520,23523,23651,23938,23936,23933,23942,23930,23937,23927,23946,23945,23944,23934,23932,23949,23929,23935,24152,24153,24147,24280,24273,24279,24270,24284,24277,24281,24274,24276,24388,24387,24431,24502,24876,24872,24897,24926,24945,24947,24914,24915,24946,24940,24960,24948,24916,24954,24923,24933,24891,24938,24929,24918,25129,25127,25131,25643,25677,25691,25693,25716,25718,25714,25715,25725,25717,25702,25766,25678,25730,25694,25692,25675,25683,25696,25680,25727,25663,25708,25707,25689,25701,25719,25971,26016,26273,26272,26271,26373,26372,26402,27057,27062,27081,27040,27086,27030,27056,27052,27068,27025,27033,27022,27047,27021,27049,27070,27055,27071,27076,27069,27044,27092,27065,27082,27034,27087,27059,27027,27050,27041,27038,27097,27031,27024,27074,27061,27045,27078,27466,27469,27467,27550,27551,27552,27587,27588,27646,28366,28405,28401,28419,28453,28408,28471,28411,28462,28425,28494,28441,28442,28455,28440,28475,28434,28397,28426,28470,28531,28409,28398,28461,28480,28464,28476,28469,28395,28423,28430,28483,28421,28413,28406,28473,28444,28412,28474,28447,28429,28446,28424,28449,29063,29072,29065,29056,29061,29058,29071,29051,29062,29057,29079,29252,29267,29335,29333,29331,29507,29517,29521,29516,29794,29811,29809,29813,29810,29799,29806,29952,29954,29955,30077,30096,30230,30216,30220,30229,30225,30218,30228,30392,30593,30588,30597,30594,30574,30592,30575,30590,30595,30898,30890,30900,30893,30888,30846,30891,30878,30885,30880,30892,30882,30884,31128,31114,31115,31126,31125,31124,31123,31127,31112,31122,31120,31275,31306,31280,31279,31272,31270,31400,31403,31404,31470,31624,31644,31626,31633,31632,31638,31629,31628,31643,31630,31621,31640,21124,31641,31652,31618,31931,31935,31932,31930,32167,32183,32194,32163,32170,32193,32192,32197,32157,32206,32196,32198,32203,32204,32175,32185,32150,32188,32159,32166,32174,32169,32161,32201,32627,32738,32739,32741,32734,32804,32861,32860,33161,33158,33155,33159,33165,33164,33163,33301,33943,33956,33953,33951,33978,33998,33986,33964,33966,33963,33977,33972,33985,33997,33962,33946,33969,34000,33949,33959,33979,33954,33940,33991,33996,33947,33961,33967,33960,34006,33944,33974,33999,33952,34007,34004,34002,34011,33968,33937,34401,34611,34595,34600,34667,34624,34606,34590,34593,34585,34587,34627,34604,34625,34622,34630,34592,34610,34602,34605,34620,34578,34618,34609,34613,34626,34598,34599,34616,34596,34586,34608,34577,35063,35047,35057,35058,35066,35070,35054,35068,35062,35067,35056,35052,35051,35229,35233,35231,35230,35305,35307,35304,35499,35481,35467,35474,35471,35478,35901,35944,35945,36053,36047,36055,36246,36361,36354,36351,36365,36349,36362,36355,36359,36358,36357,36350,36352,36356,36624,36625,36622,36621,37155,37148,37152,37154,37151,37149,37146,37156,37153,37147,37242,37234,37241,37235,37541,37540,37494,37531,37498,37536,37524,37546,37517,37542,37530,37547,37497,37527,37503,37539,37614,37518,37506,37525,37538,37501,37512,37537,37514,37510,37516,37529,37543,37502,37511,37545,37533,37515,37421,38558,38561,38655,38744,38781,38778,38782,38787,38784,38786,38779,38788,38785,38783,38862,38861,38934,39085,39086,39170,39168,39175,39325,39324,39363,39353,39355,39354,39362,39357,39367,39601,39651,39655,39742,39743,39776,39777,39775,40177,40178,40181,40615,20735,20739,20784,20728,20742,20743,20726,20734,20747,20748,20733,20746,21131,21132,21233,21231,22088,22082,22092,22069,22081,22090,22089,22086,22104,22106,22080,22067,22077,22060,22078,22072,22058,22074,22298,22699,22685,22705,22688,22691,22703,22700,22693,22689,22783,23295,23284,23293,23287,23286,23299,23288,23298,23289,23297,23303,23301,23311,23655,23961,23959,23967,23954,23970,23955,23957,23968,23964,23969,23962,23966,24169,24157,24160,24156,32243,24283,24286,24289,24393,24498,24971,24963,24953,25009,25008,24994,24969,24987,24979,25007,25005,24991,24978,25002,24993,24973,24934,25011,25133,25710,25712,25750,25760,25733,25751,25756,25743,25739,25738,25740,25763,25759,25704,25777,25752,25974,25978,25977,25979,26034,26035,26293,26288,26281,26290,26295,26282,26287,27136,27142,27159,27109,27128,27157,27121,27108,27168,27135,27116,27106,27163,27165,27134,27175,27122,27118,27156,27127,27111,27200,27144,27110,27131,27149,27132,27115,27145,27140,27160,27173,27151,27126,27174,27143,27124,27158,27473,27557,27555,27554,27558,27649,27648,27647,27650,28481,28454,28542,28551,28614,28562,28557,28553,28556,28514,28495,28549,28506,28566,28534,28524,28546,28501,28530,28498,28496,28503,28564,28563,28509,28416,28513,28523,28541,28519,28560,28499,28555,28521,28543,28565,28515,28535,28522,28539,29106,29103,29083,29104,29088,29082,29097,29109,29085,29093,29086,29092,29089,29098,29084,29095,29107,29336,29338,29528,29522,29534,29535,29536,29533,29531,29537,29530,29529,29538,29831,29833,29834,29830,29825,29821,29829,29832,29820,29817,29960,29959,30078,30245,30238,30233,30237,30236,30243,30234,30248,30235,30364,30365,30366,30363,30605,30607,30601,30600,30925,30907,30927,30924,30929,30926,30932,30920,30915,30916,30921,31130,31137,31136,31132,31138,31131,27510,31289,31410,31412,31411,31671,31691,31678,31660,31694,31663,31673,31690,31669,31941,31944,31948,31947,32247,32219,32234,32231,32215,32225,32259,32250,32230,32246,32241,32240,32238,32223,32630,32684,32688,32685,32749,32747,32746,32748,32742,32744,32868,32871,33187,33183,33182,33173,33186,33177,33175,33302,33359,33363,33362,33360,33358,33361,34084,34107,34063,34048,34089,34062,34057,34061,34079,34058,34087,34076,34043,34091,34042,34056,34060,34036,34090,34034,34069,34039,34027,34035,34044,34066,34026,34025,34070,34046,34088,34077,34094,34050,34045,34078,34038,34097,34086,34023,34024,34032,34031,34041,34072,34080,34096,34059,34073,34095,34402,34646,34659,34660,34679,34785,34675,34648,34644,34651,34642,34657,34650,34641,34654,34669,34666,34640,34638,34655,34653,34671,34668,34682,34670,34652,34661,34639,34683,34677,34658,34663,34665,34906,35077,35084,35092,35083,35095,35096,35097,35078,35094,35089,35086,35081,35234,35236,35235,35309,35312,35308,35535,35526,35512,35539,35537,35540,35541,35515,35543,35518,35520,35525,35544,35523,35514,35517,35545,35902,35917,35983,36069,36063,36057,36072,36058,36061,36071,36256,36252,36257,36251,36384,36387,36389,36388,36398,36373,36379,36374,36369,36377,36390,36391,36372,36370,36376,36371,36380,36375,36378,36652,36644,36632,36634,36640,36643,36630,36631,36979,36976,36975,36967,36971,37167,37163,37161,37162,37170,37158,37166,37253,37254,37258,37249,37250,37252,37248,37584,37571,37572,37568,37593,37558,37583,37617,37599,37592,37609,37591,37597,37580,37615,37570,37608,37578,37576,37582,37606,37581,37589,37577,37600,37598,37607,37585,37587,37557,37601,37574,37556,38268,38316,38315,38318,38320,38564,38562,38611,38661,38664,38658,38746,38794,38798,38792,38864,38863,38942,38941,38950,38953,38952,38944,38939,38951,39090,39176,39162,39185,39188,39190,39191,39189,39388,39373,39375,39379,39380,39374,39369,39382,39384,39371,39383,39372,39603,39660,39659,39667,39666,39665,39750,39747,39783,39796,39793,39782,39798,39797,39792,39784,39780,39788,40188,40186,40189,40191,40183,40199,40192,40185,40187,40200,40197,40196,40579,40659,40719,40720,20764,20755,20759,20762,20753,20958,21300,21473,22128,22112,22126,22131,22118,22115,22125,22130,22110,22135,22300,22299,22728,22717,22729,22719,22714,22722,22716,22726,23319,23321,23323,23329,23316,23315,23312,23318,23336,23322,23328,23326,23535,23980,23985,23977,23975,23989,23984,23982,23978,23976,23986,23981,23983,23988,24167,24168,24166,24175,24297,24295,24294,24296,24293,24395,24508,24989,25000,24982,25029,25012,25030,25025,25036,25018,25023,25016,24972,25815,25814,25808,25807,25801,25789,25737,25795,25819,25843,25817,25907,25983,25980,26018,26312,26302,26304,26314,26315,26319,26301,26299,26298,26316,26403,27188,27238,27209,27239,27186,27240,27198,27229,27245,27254,27227,27217,27176,27226,27195,27199,27201,27242,27236,27216,27215,27220,27247,27241,27232,27196,27230,27222,27221,27213,27214,27206,27477,27476,27478,27559,27562,27563,27592,27591,27652,27651,27654,28589,28619,28579,28615,28604,28622,28616,28510,28612,28605,28574,28618,28584,28676,28581,28590,28602,28588,28586,28623,28607,28600,28578,28617,28587,28621,28591,28594,28592,29125,29122,29119,29112,29142,29120,29121,29131,29140,29130,29127,29135,29117,29144,29116,29126,29146,29147,29341,29342,29545,29542,29543,29548,29541,29547,29546,29823,29850,29856,29844,29842,29845,29857,29963,30080,30255,30253,30257,30269,30259,30268,30261,30258,30256,30395,30438,30618,30621,30625,30620,30619,30626,30627,30613,30617,30615,30941,30953,30949,30954,30942,30947,30939,30945,30946,30957,30943,30944,31140,31300,31304,31303,31414,31416,31413,31409,31415,31710,31715,31719,31709,31701,31717,31706,31720,31737,31700,31722,31714,31708,31723,31704,31711,31954,31956,31959,31952,31953,32274,32289,32279,32268,32287,32288,32275,32270,32284,32277,32282,32290,32267,32271,32278,32269,32276,32293,32292,32579,32635,32636,32634,32689,32751,32810,32809,32876,33201,33190,33198,33209,33205,33195,33200,33196,33204,33202,33207,33191,33266,33365,33366,33367,34134,34117,34155,34125,34131,34145,34136,34112,34118,34148,34113,34146,34116,34129,34119,34147,34110,34139,34161,34126,34158,34165,34133,34151,34144,34188,34150,34141,34132,34149,34156,34403,34405,34404,34715,34703,34711,34707,34706,34696,34689,34710,34712,34681,34695,34723,34693,34704,34705,34717,34692,34708,34716,34714,34697,35102,35110,35120,35117,35118,35111,35121,35106,35113,35107,35119,35116,35103,35313,35552,35554,35570,35572,35573,35549,35604,35556,35551,35568,35528,35550,35553,35560,35583,35567,35579,35985,35986,35984,36085,36078,36081,36080,36083,36204,36206,36261,36263,36403,36414,36408,36416,36421,36406,36412,36413,36417,36400,36415,36541,36662,36654,36661,36658,36665,36663,36660,36982,36985,36987,36998,37114,37171,37173,37174,37267,37264,37265,37261,37263,37671,37662,37640,37663,37638,37647,37754,37688,37692,37659,37667,37650,37633,37702,37677,37646,37645,37579,37661,37626,37669,37651,37625,37623,37684,37634,37668,37631,37673,37689,37685,37674,37652,37644,37643,37630,37641,37632,37627,37654,38332,38349,38334,38329,38330,38326,38335,38325,38333,38569,38612,38667,38674,38672,38809,38807,38804,38896,38904,38965,38959,38962,39204,39199,39207,39209,39326,39406,39404,39397,39396,39408,39395,39402,39401,39399,39609,39615,39604,39611,39670,39674,39673,39671,39731,39808,39813,39815,39804,39806,39803,39810,39827,39826,39824,39802,39829,39805,39816,40229,40215,40224,40222,40212,40233,40221,40216,40226,40208,40217,40223,40584,40582,40583,40622,40621,40661,40662,40698,40722,40765,20774,20773,20770,20772,20768,20777,21236,22163,22156,22157,22150,22148,22147,22142,22146,22143,22145,22742,22740,22735,22738,23341,23333,23346,23331,23340,23335,23334,23343,23342,23419,23537,23538,23991,24172,24170,24510,24507,25027,25013,25020,25063,25056,25061,25060,25064,25054,25839,25833,25827,25835,25828,25832,25985,25984,26038,26074,26322,27277,27286,27265,27301,27273,27295,27291,27297,27294,27271,27283,27278,27285,27267,27304,27300,27281,27263,27302,27290,27269,27276,27282,27483,27565,27657,28620,28585,28660,28628,28643,28636,28653,28647,28646,28638,28658,28637,28642,28648,29153,29169,29160,29170,29156,29168,29154,29555,29550,29551,29847,29874,29867,29840,29866,29869,29873,29861,29871,29968,29969,29970,29967,30084,30275,30280,30281,30279,30372,30441,30645,30635,30642,30647,30646,30644,30641,30632,30704,30963,30973,30978,30971,30972,30962,30981,30969,30974,30980,31147,31144,31324,31323,31318,31320,31316,31322,31422,31424,31425,31749,31759,31730,31744,31743,31739,31758,31732,31755,31731,31746,31753,31747,31745,31736,31741,31750,31728,31729,31760,31754,31976,32301,32316,32322,32307,38984,32312,32298,32329,32320,32327,32297,32332,32304,32315,32310,32324,32314,32581,32639,32638,32637,32756,32754,32812,33211,33220,33228,33226,33221,33223,33212,33257,33371,33370,33372,34179,34176,34191,34215,34197,34208,34187,34211,34171,34212,34202,34206,34167,34172,34185,34209,34170,34168,34135,34190,34198,34182,34189,34201,34205,34177,34210,34178,34184,34181,34169,34166,34200,34192,34207,34408,34750,34730,34733,34757,34736,34732,34745,34741,34748,34734,34761,34755,34754,34764,34743,34735,34756,34762,34740,34742,34751,34744,34749,34782,34738,35125,35123,35132,35134,35137,35154,35127,35138,35245,35247,35246,35314,35315,35614,35608,35606,35601,35589,35595,35618,35599,35602,35605,35591,35597,35592,35590,35612,35603,35610,35919,35952,35954,35953,35951,35989,35988,36089,36207,36430,36429,36435,36432,36428,36423,36675,36672,36997,36990,37176,37274,37282,37275,37273,37279,37281,37277,37280,37793,37763,37807,37732,37718,37703,37756,37720,37724,37750,37705,37712,37713,37728,37741,37775,37708,37738,37753,37719,37717,37714,37711,37745,37751,37755,37729,37726,37731,37735,37760,37710,37721,38343,38336,38345,38339,38341,38327,38574,38576,38572,38688,38687,38680,38685,38681,38810,38817,38812,38814,38813,38869,38868,38897,38977,38980,38986,38985,38981,38979,39205,39211,39212,39210,39219,39218,39215,39213,39217,39216,39320,39331,39329,39426,39418,39412,39415,39417,39416,39414,39419,39421,39422,39420,39427,39614,39678,39677,39681,39676,39752,39834,39848,39838,39835,39846,39841,39845,39844,39814,39842,39840,39855,40243,40257,40295,40246,40238,40239,40241,40248,40240,40261,40258,40259,40254,40247,40256,40253,32757,40237,40586,40585,40589,40624,40648,40666,40699,40703,40740,40739,40738,40788,40864,20785,20781,20782,22168,22172,22167,22170,22173,22169,22896,23356,23657,23658,24000,24173,24174,25048,25055,25069,25070,25073,25066,25072,25067,25046,25065,25855,25860,25853,25848,25857,25859,25852,26004,26075,26330,26331,26328,27333,27321,27325,27361,27334,27322,27318,27319,27335,27316,27309,27486,27593,27659,28679,28684,28685,28673,28677,28692,28686,28671,28672,28667,28710,28668,28663,28682,29185,29183,29177,29187,29181,29558,29880,29888,29877,29889,29886,29878,29883,29890,29972,29971,30300,30308,30297,30288,30291,30295,30298,30374,30397,30444,30658,30650,30975,30988,30995,30996,30985,30992,30994,30993,31149,31148,31327,31772,31785,31769,31776,31775,31789,31773,31782,31784,31778,31781,31792,32348,32336,32342,32355,32344,32354,32351,32337,32352,32343,32339,32693,32691,32759,32760,32885,33233,33234,33232,33375,33374,34228,34246,34240,34243,34242,34227,34229,34237,34247,34244,34239,34251,34254,34248,34245,34225,34230,34258,34340,34232,34231,34238,34409,34791,34790,34786,34779,34795,34794,34789,34783,34803,34788,34772,34780,34771,34797,34776,34787,34724,34775,34777,34817,34804,34792,34781,35155,35147,35151,35148,35142,35152,35153,35145,35626,35623,35619,35635,35632,35637,35655,35631,35644,35646,35633,35621,35639,35622,35638,35630,35620,35643,35645,35642,35906,35957,35993,35992,35991,36094,36100,36098,36096,36444,36450,36448,36439,36438,36446,36453,36455,36443,36442,36449,36445,36457,36436,36678,36679,36680,36683,37160,37178,37179,37182,37288,37285,37287,37295,37290,37813,37772,37778,37815,37787,37789,37769,37799,37774,37802,37790,37798,37781,37768,37785,37791,37773,37809,37777,37810,37796,37800,37812,37795,37797,38354,38355,38353,38579,38615,38618,24002,38623,38616,38621,38691,38690,38693,38828,38830,38824,38827,38820,38826,38818,38821,38871,38873,38870,38872,38906,38992,38993,38994,39096,39233,39228,39226,39439,39435,39433,39437,39428,39441,39434,39429,39431,39430,39616,39644,39688,39684,39685,39721,39733,39754,39756,39755,39879,39878,39875,39871,39873,39861,39864,39891,39862,39876,39865,39869,40284,40275,40271,40266,40283,40267,40281,40278,40268,40279,40274,40276,40287,40280,40282,40590,40588,40671,40705,40704,40726,40741,40747,40746,40745,40744,40780,40789,20788,20789,21142,21239,21428,22187,22189,22182,22183,22186,22188,22746,22749,22747,22802,23357,23358,23359,24003,24176,24511,25083,25863,25872,25869,25865,25868,25870,25988,26078,26077,26334,27367,27360,27340,27345,27353,27339,27359,27356,27344,27371,27343,27341,27358,27488,27568,27660,28697,28711,28704,28694,28715,28705,28706,28707,28713,28695,28708,28700,28714,29196,29194,29191,29186,29189,29349,29350,29348,29347,29345,29899,29893,29879,29891,29974,30304,30665,30666,30660,30705,31005,31003,31009,31004,30999,31006,31152,31335,31336,31795,31804,31801,31788,31803,31980,31978,32374,32373,32376,32368,32375,32367,32378,32370,32372,32360,32587,32586,32643,32646,32695,32765,32766,32888,33239,33237,33380,33377,33379,34283,34289,34285,34265,34273,34280,34266,34263,34284,34290,34296,34264,34271,34275,34268,34257,34288,34278,34287,34270,34274,34816,34810,34819,34806,34807,34825,34828,34827,34822,34812,34824,34815,34826,34818,35170,35162,35163,35159,35169,35164,35160,35165,35161,35208,35255,35254,35318,35664,35656,35658,35648,35667,35670,35668,35659,35669,35665,35650,35666,35671,35907,35959,35958,35994,36102,36103,36105,36268,36266,36269,36267,36461,36472,36467,36458,36463,36475,36546,36690,36689,36687,36688,36691,36788,37184,37183,37296,37293,37854,37831,37839,37826,37850,37840,37881,37868,37836,37849,37801,37862,37834,37844,37870,37859,37845,37828,37838,37824,37842,37863,38269,38362,38363,38625,38697,38699,38700,38696,38694,38835,38839,38838,38877,38878,38879,39004,39001,39005,38999,39103,39101,39099,39102,39240,39239,39235,39334,39335,39450,39445,39461,39453,39460,39451,39458,39456,39463,39459,39454,39452,39444,39618,39691,39690,39694,39692,39735,39914,39915,39904,39902,39908,39910,39906,39920,39892,39895,39916,39900,39897,39909,39893,39905,39898,40311,40321,40330,40324,40328,40305,40320,40312,40326,40331,40332,40317,40299,40308,40309,40304,40297,40325,40307,40315,40322,40303,40313,40319,40327,40296,40596,40593,40640,40700,40749,40768,40769,40781,40790,40791,40792,21303,22194,22197,22195,22755,23365,24006,24007,24302,24303,24512,24513,25081,25879,25878,25877,25875,26079,26344,26339,26340,27379,27376,27370,27368,27385,27377,27374,27375,28732,28725,28719,28727,28724,28721,28738,28728,28735,28730,28729,28736,28731,28723,28737,29203,29204,29352,29565,29564,29882,30379,30378,30398,30445,30668,30670,30671,30669,30706,31013,31011,31015,31016,31012,31017,31154,31342,31340,31341,31479,31817,31816,31818,31815,31813,31982,32379,32382,32385,32384,32698,32767,32889,33243,33241,33291,33384,33385,34338,34303,34305,34302,34331,34304,34294,34308,34313,34309,34316,34301,34841,34832,34833,34839,34835,34838,35171,35174,35257,35319,35680,35690,35677,35688,35683,35685,35687,35693,36270,36486,36488,36484,36697,36694,36695,36693,36696,36698,37005,37187,37185,37303,37301,37298,37299,37899,37907,37883,37920,37903,37908,37886,37909,37904,37928,37913,37901,37877,37888,37879,37895,37902,37910,37906,37882,37897,37880,37898,37887,37884,37900,37878,37905,37894,38366,38368,38367,38702,38703,38841,38843,38909,38910,39008,39010,39011,39007,39105,39106,39248,39246,39257,39244,39243,39251,39474,39476,39473,39468,39466,39478,39465,39470,39480,39469,39623,39626,39622,39696,39698,39697,39947,39944,39927,39941,39954,39928,40000,39943,39950,39942,39959,39956,39945,40351,40345,40356,40349,40338,40344,40336,40347,40352,40340,40348,40362,40343,40353,40346,40354,40360,40350,40355,40383,40361,40342,40358,40359,40601,40603,40602,40677,40676,40679,40678,40752,40750,40795,40800,40798,40797,40793,40849,20794,20793,21144,21143,22211,22205,22206,23368,23367,24011,24015,24305,25085,25883,27394,27388,27395,27384,27392,28739,28740,28746,28744,28745,28741,28742,29213,29210,29209,29566,29975,30314,30672,31021,31025,31023,31828,31827,31986,32394,32391,32392,32395,32390,32397,32589,32699,32816,33245,34328,34346,34342,34335,34339,34332,34329,34343,34350,34337,34336,34345,34334,34341,34857,34845,34843,34848,34852,34844,34859,34890,35181,35177,35182,35179,35322,35705,35704,35653,35706,35707,36112,36116,36271,36494,36492,36702,36699,36701,37190,37188,37189,37305,37951,37947,37942,37929,37949,37948,37936,37945,37930,37943,37932,37952,37937,38373,38372,38371,38709,38714,38847,38881,39012,39113,39110,39104,39256,39254,39481,39485,39494,39492,39490,39489,39482,39487,39629,39701,39703,39704,39702,39738,39762,39979,39965,39964,39980,39971,39976,39977,39972,39969,40375,40374,40380,40385,40391,40394,40399,40382,40389,40387,40379,40373,40398,40377,40378,40364,40392,40369,40365,40396,40371,40397,40370,40570,40604,40683,40686,40685,40731,40728,40730,40753,40782,40805,40804,40850,20153,22214,22213,22219,22897,23371,23372,24021,24017,24306,25889,25888,25894,25890,27403,27400,27401,27661,28757,28758,28759,28754,29214,29215,29353,29567,29912,29909,29913,29911,30317,30381,31029,31156,31344,31345,31831,31836,31833,31835,31834,31988,31985,32401,32591,32647,33246,33387,34356,34357,34355,34348,34354,34358,34860,34856,34854,34858,34853,35185,35263,35262,35323,35710,35716,35714,35718,35717,35711,36117,36501,36500,36506,36498,36496,36502,36503,36704,36706,37191,37964,37968,37962,37963,37967,37959,37957,37960,37961,37958,38719,38883,39018,39017,39115,39252,39259,39502,39507,39508,39500,39503,39496,39498,39497,39506,39504,39632,39705,39723,39739,39766,39765,40006,40008,39999,40004,39993,39987,40001,39996,39991,39988,39986,39997,39990,40411,40402,40414,40410,40395,40400,40412,40401,40415,40425,40409,40408,40406,40437,40405,40413,40630,40688,40757,40755,40754,40770,40811,40853,40866,20797,21145,22760,22759,22898,23373,24024,34863,24399,25089,25091,25092,25897,25893,26006,26347,27409,27410,27407,27594,28763,28762,29218,29570,29569,29571,30320,30676,31847,31846,32405,33388,34362,34368,34361,34364,34353,34363,34366,34864,34866,34862,34867,35190,35188,35187,35326,35724,35726,35723,35720,35909,36121,36504,36708,36707,37308,37986,37973,37981,37975,37982,38852,38853,38912,39510,39513,39710,39711,39712,40018,40024,40016,40010,40013,40011,40021,40025,40012,40014,40443,40439,40431,40419,40427,40440,40420,40438,40417,40430,40422,40434,40432,40418,40428,40436,40435,40424,40429,40642,40656,40690,40691,40710,40732,40760,40759,40758,40771,40783,40817,40816,40814,40815,22227,22221,23374,23661,25901,26349,26350,27411,28767,28769,28765,28768,29219,29915,29925,30677,31032,31159,31158,31850,32407,32649,33389,34371,34872,34871,34869,34891,35732,35733,36510,36511,36512,36509,37310,37309,37314,37995,37992,37993,38629,38726,38723,38727,38855,38885,39518,39637,39769,40035,40039,40038,40034,40030,40032,40450,40446,40455,40451,40454,40453,40448,40449,40457,40447,40445,40452,40608,40734,40774,40820,40821,40822,22228,25902,26040,27416,27417,27415,27418,28770,29222,29354,30680,30681,31033,31849,31851,31990,32410,32408,32411,32409,33248,33249,34374,34375,34376,35193,35194,35196,35195,35327,35736,35737,36517,36516,36515,37998,37997,37999,38001,38003,38729,39026,39263,40040,40046,40045,40459,40461,40464,40463,40466,40465,40609,40693,40713,40775,40824,40827,40826,40825,22302,28774,31855,34876,36274,36518,37315,38004,38008,38006,38005,39520,40052,40051,40049,40053,40468,40467,40694,40714,40868,28776,28773,31991,34410,34878,34877,34879,35742,35996,36521,36553,38731,39027,39028,39116,39265,39339,39524,39526,39527,39716,40469,40471,40776,25095,27422,29223,34380,36520,38018,38016,38017,39529,39528,39726,40473,29225,34379,35743,38019,40057,40631,30325,39531,40058,40477,28777,28778,40612,40830,40777,40856,30849,37561,35023,22715,24658,31911,23290,9556,9574,9559,9568,9580,9571,9562,9577,9565,9554,9572,9557,9566,9578,9569,9560,9575,9563,9555,9573,9558,9567,9579,9570,9561,9576,9564,9553,9552,9581,9582,9584,9583,65517,132423,37595,132575,147397,34124,17077,29679,20917,13897,149826,166372,37700,137691,33518,146632,30780,26436,25311,149811,166314,131744,158643,135941,20395,140525,20488,159017,162436,144896,150193,140563,20521,131966,24484,131968,131911,28379,132127,20605,20737,13434,20750,39020,14147,33814,149924,132231,20832,144308,20842,134143,139516,131813,140592,132494,143923,137603,23426,34685,132531,146585,20914,20920,40244,20937,20943,20945,15580,20947,150182,20915,20962,21314,20973,33741,26942,145197,24443,21003,21030,21052,21173,21079,21140,21177,21189,31765,34114,21216,34317,158483,21253,166622,21833,28377,147328,133460,147436,21299,21316,134114,27851,136998,26651,29653,24650,16042,14540,136936,29149,17570,21357,21364,165547,21374,21375,136598,136723,30694,21395,166555,21408,21419,21422,29607,153458,16217,29596,21441,21445,27721,20041,22526,21465,15019,134031,21472,147435,142755,21494,134263,21523,28793,21803,26199,27995,21613,158547,134516,21853,21647,21668,18342,136973,134877,15796,134477,166332,140952,21831,19693,21551,29719,21894,21929,22021,137431,147514,17746,148533,26291,135348,22071,26317,144010,26276,26285,22093,22095,30961,22257,38791,21502,22272,22255,22253,166758,13859,135759,22342,147877,27758,28811,22338,14001,158846,22502,136214,22531,136276,148323,22566,150517,22620,22698,13665,22752,22748,135740,22779,23551,22339,172368,148088,37843,13729,22815,26790,14019,28249,136766,23076,21843,136850,34053,22985,134478,158849,159018,137180,23001,137211,137138,159142,28017,137256,136917,23033,159301,23211,23139,14054,149929,23159,14088,23190,29797,23251,159649,140628,15749,137489,14130,136888,24195,21200,23414,25992,23420,162318,16388,18525,131588,23509,24928,137780,154060,132517,23539,23453,19728,23557,138052,23571,29646,23572,138405,158504,23625,18653,23685,23785,23791,23947,138745,138807,23824,23832,23878,138916,23738,24023,33532,14381,149761,139337,139635,33415,14390,15298,24110,27274,24181,24186,148668,134355,21414,20151,24272,21416,137073,24073,24308,164994,24313,24315,14496,24316,26686,37915,24333,131521,194708,15070,18606,135994,24378,157832,140240,24408,140401,24419,38845,159342,24434,37696,166454,24487,23990,15711,152144,139114,159992,140904,37334,131742,166441,24625,26245,137335,14691,15815,13881,22416,141236,31089,15936,24734,24740,24755,149890,149903,162387,29860,20705,23200,24932,33828,24898,194726,159442,24961,20980,132694,24967,23466,147383,141407,25043,166813,170333,25040,14642,141696,141505,24611,24924,25886,25483,131352,25285,137072,25301,142861,25452,149983,14871,25656,25592,136078,137212,25744,28554,142902,38932,147596,153373,25825,25829,38011,14950,25658,14935,25933,28438,150056,150051,25989,25965,25951,143486,26037,149824,19255,26065,16600,137257,26080,26083,24543,144384,26136,143863,143864,26180,143780,143781,26187,134773,26215,152038,26227,26228,138813,143921,165364,143816,152339,30661,141559,39332,26370,148380,150049,15147,27130,145346,26462,26471,26466,147917,168173,26583,17641,26658,28240,37436,26625,144358,159136,26717,144495,27105,27147,166623,26995,26819,144845,26881,26880,15666,14849,144956,15232,26540,26977,166474,17148,26934,27032,15265,132041,33635,20624,27129,144985,139562,27205,145155,27293,15347,26545,27336,168348,15373,27421,133411,24798,27445,27508,141261,28341,146139,132021,137560,14144,21537,146266,27617,147196,27612,27703,140427,149745,158545,27738,33318,27769,146876,17605,146877,147876,149772,149760,146633,14053,15595,134450,39811,143865,140433,32655,26679,159013,159137,159211,28054,27996,28284,28420,149887,147589,159346,34099,159604,20935,27804,28189,33838,166689,28207,146991,29779,147330,31180,28239,23185,143435,28664,14093,28573,146992,28410,136343,147517,17749,37872,28484,28508,15694,28532,168304,15675,28575,147780,28627,147601,147797,147513,147440,147380,147775,20959,147798,147799,147776,156125,28747,28798,28839,28801,28876,28885,28886,28895,16644,15848,29108,29078,148087,28971,28997,23176,29002,29038,23708,148325,29007,37730,148161,28972,148570,150055,150050,29114,166888,28861,29198,37954,29205,22801,37955,29220,37697,153093,29230,29248,149876,26813,29269,29271,15957,143428,26637,28477,29314,29482,29483,149539,165931,18669,165892,29480,29486,29647,29610,134202,158254,29641,29769,147938,136935,150052,26147,14021,149943,149901,150011,29687,29717,26883,150054,29753,132547,16087,29788,141485,29792,167602,29767,29668,29814,33721,29804,14128,29812,37873,27180,29826,18771,150156,147807,150137,166799,23366,166915,137374,29896,137608,29966,29929,29982,167641,137803,23511,167596,37765,30029,30026,30055,30062,151426,16132,150803,30094,29789,30110,30132,30210,30252,30289,30287,30319,30326,156661,30352,33263,14328,157969,157966,30369,30373,30391,30412,159647,33890,151709,151933,138780,30494,30502,30528,25775,152096,30552,144044,30639,166244,166248,136897,30708,30729,136054,150034,26826,30895,30919,30931,38565,31022,153056,30935,31028,30897,161292,36792,34948,166699,155779,140828,31110,35072,26882,31104,153687,31133,162617,31036,31145,28202,160038,16040,31174,168205,31188],
      "euc-kr":[44034,44035,44037,44038,44043,44044,44045,44046,44047,44056,44062,44063,44065,44066,44067,44069,44070,44071,44072,44073,44074,44075,44078,44082,44083,44084,null,null,null,null,null,null,44085,44086,44087,44090,44091,44093,44094,44095,44097,44098,44099,44100,44101,44102,44103,44104,44105,44106,44108,44110,44111,44112,44113,44114,44115,44117,null,null,null,null,null,null,44118,44119,44121,44122,44123,44125,44126,44127,44128,44129,44130,44131,44132,44133,44134,44135,44136,44137,44138,44139,44140,44141,44142,44143,44146,44147,44149,44150,44153,44155,44156,44157,44158,44159,44162,44167,44168,44173,44174,44175,44177,44178,44179,44181,44182,44183,44184,44185,44186,44187,44190,44194,44195,44196,44197,44198,44199,44203,44205,44206,44209,44210,44211,44212,44213,44214,44215,44218,44222,44223,44224,44226,44227,44229,44230,44231,44233,44234,44235,44237,44238,44239,44240,44241,44242,44243,44244,44246,44248,44249,44250,44251,44252,44253,44254,44255,44258,44259,44261,44262,44265,44267,44269,44270,44274,44276,44279,44280,44281,44282,44283,44286,44287,44289,44290,44291,44293,44295,44296,44297,44298,44299,44302,44304,44306,44307,44308,44309,44310,44311,44313,44314,44315,44317,44318,44319,44321,44322,44323,44324,44325,44326,44327,44328,44330,44331,44334,44335,44336,44337,44338,44339,null,null,null,null,null,null,44342,44343,44345,44346,44347,44349,44350,44351,44352,44353,44354,44355,44358,44360,44362,44363,44364,44365,44366,44367,44369,44370,44371,44373,44374,44375,null,null,null,null,null,null,44377,44378,44379,44380,44381,44382,44383,44384,44386,44388,44389,44390,44391,44392,44393,44394,44395,44398,44399,44401,44402,44407,44408,44409,44410,44414,44416,44419,44420,44421,44422,44423,44426,44427,44429,44430,44431,44433,44434,44435,44436,44437,44438,44439,44440,44441,44442,44443,44446,44447,44448,44449,44450,44451,44453,44454,44455,44456,44457,44458,44459,44460,44461,44462,44463,44464,44465,44466,44467,44468,44469,44470,44472,44473,44474,44475,44476,44477,44478,44479,44482,44483,44485,44486,44487,44489,44490,44491,44492,44493,44494,44495,44498,44500,44501,44502,44503,44504,44505,44506,44507,44509,44510,44511,44513,44514,44515,44517,44518,44519,44520,44521,44522,44523,44524,44525,44526,44527,44528,44529,44530,44531,44532,44533,44534,44535,44538,44539,44541,44542,44546,44547,44548,44549,44550,44551,44554,44556,44558,44559,44560,44561,44562,44563,44565,44566,44567,44568,44569,44570,44571,44572,null,null,null,null,null,null,44573,44574,44575,44576,44577,44578,44579,44580,44581,44582,44583,44584,44585,44586,44587,44588,44589,44590,44591,44594,44595,44597,44598,44601,44603,44604,null,null,null,null,null,null,44605,44606,44607,44610,44612,44615,44616,44617,44619,44623,44625,44626,44627,44629,44631,44632,44633,44634,44635,44638,44642,44643,44644,44646,44647,44650,44651,44653,44654,44655,44657,44658,44659,44660,44661,44662,44663,44666,44670,44671,44672,44673,44674,44675,44678,44679,44680,44681,44682,44683,44685,44686,44687,44688,44689,44690,44691,44692,44693,44694,44695,44696,44697,44698,44699,44700,44701,44702,44703,44704,44705,44706,44707,44708,44709,44710,44711,44712,44713,44714,44715,44716,44717,44718,44719,44720,44721,44722,44723,44724,44725,44726,44727,44728,44729,44730,44731,44735,44737,44738,44739,44741,44742,44743,44744,44745,44746,44747,44750,44754,44755,44756,44757,44758,44759,44762,44763,44765,44766,44767,44768,44769,44770,44771,44772,44773,44774,44775,44777,44778,44780,44782,44783,44784,44785,44786,44787,44789,44790,44791,44793,44794,44795,44797,44798,44799,44800,44801,44802,44803,44804,44805,null,null,null,null,null,null,44806,44809,44810,44811,44812,44814,44815,44817,44818,44819,44820,44821,44822,44823,44824,44825,44826,44827,44828,44829,44830,44831,44832,44833,44834,44835,null,null,null,null,null,null,44836,44837,44838,44839,44840,44841,44842,44843,44846,44847,44849,44851,44853,44854,44855,44856,44857,44858,44859,44862,44864,44868,44869,44870,44871,44874,44875,44876,44877,44878,44879,44881,44882,44883,44884,44885,44886,44887,44888,44889,44890,44891,44894,44895,44896,44897,44898,44899,44902,44903,44904,44905,44906,44907,44908,44909,44910,44911,44912,44913,44914,44915,44916,44917,44918,44919,44920,44922,44923,44924,44925,44926,44927,44929,44930,44931,44933,44934,44935,44937,44938,44939,44940,44941,44942,44943,44946,44947,44948,44950,44951,44952,44953,44954,44955,44957,44958,44959,44960,44961,44962,44963,44964,44965,44966,44967,44968,44969,44970,44971,44972,44973,44974,44975,44976,44977,44978,44979,44980,44981,44982,44983,44986,44987,44989,44990,44991,44993,44994,44995,44996,44997,44998,45002,45004,45007,45008,45009,45010,45011,45013,45014,45015,45016,45017,45018,45019,45021,45022,45023,45024,45025,null,null,null,null,null,null,45026,45027,45028,45029,45030,45031,45034,45035,45036,45037,45038,45039,45042,45043,45045,45046,45047,45049,45050,45051,45052,45053,45054,45055,45058,45059,null,null,null,null,null,null,45061,45062,45063,45064,45065,45066,45067,45069,45070,45071,45073,45074,45075,45077,45078,45079,45080,45081,45082,45083,45086,45087,45088,45089,45090,45091,45092,45093,45094,45095,45097,45098,45099,45100,45101,45102,45103,45104,45105,45106,45107,45108,45109,45110,45111,45112,45113,45114,45115,45116,45117,45118,45119,45120,45121,45122,45123,45126,45127,45129,45131,45133,45135,45136,45137,45138,45142,45144,45146,45147,45148,45150,45151,45152,45153,45154,45155,45156,45157,45158,45159,45160,45161,45162,45163,45164,45165,45166,45167,45168,45169,45170,45171,45172,45173,45174,45175,45176,45177,45178,45179,45182,45183,45185,45186,45187,45189,45190,45191,45192,45193,45194,45195,45198,45200,45202,45203,45204,45205,45206,45207,45211,45213,45214,45219,45220,45221,45222,45223,45226,45232,45234,45238,45239,45241,45242,45243,45245,45246,45247,45248,45249,45250,45251,45254,45258,45259,45260,45261,45262,45263,45266,null,null,null,null,null,null,45267,45269,45270,45271,45273,45274,45275,45276,45277,45278,45279,45281,45282,45283,45284,45286,45287,45288,45289,45290,45291,45292,45293,45294,45295,45296,null,null,null,null,null,null,45297,45298,45299,45300,45301,45302,45303,45304,45305,45306,45307,45308,45309,45310,45311,45312,45313,45314,45315,45316,45317,45318,45319,45322,45325,45326,45327,45329,45332,45333,45334,45335,45338,45342,45343,45344,45345,45346,45350,45351,45353,45354,45355,45357,45358,45359,45360,45361,45362,45363,45366,45370,45371,45372,45373,45374,45375,45378,45379,45381,45382,45383,45385,45386,45387,45388,45389,45390,45391,45394,45395,45398,45399,45401,45402,45403,45405,45406,45407,45409,45410,45411,45412,45413,45414,45415,45416,45417,45418,45419,45420,45421,45422,45423,45424,45425,45426,45427,45428,45429,45430,45431,45434,45435,45437,45438,45439,45441,45443,45444,45445,45446,45447,45450,45452,45454,45455,45456,45457,45461,45462,45463,45465,45466,45467,45469,45470,45471,45472,45473,45474,45475,45476,45477,45478,45479,45481,45482,45483,45484,45485,45486,45487,45488,45489,45490,45491,45492,45493,45494,45495,45496,null,null,null,null,null,null,45497,45498,45499,45500,45501,45502,45503,45504,45505,45506,45507,45508,45509,45510,45511,45512,45513,45514,45515,45517,45518,45519,45521,45522,45523,45525,null,null,null,null,null,null,45526,45527,45528,45529,45530,45531,45534,45536,45537,45538,45539,45540,45541,45542,45543,45546,45547,45549,45550,45551,45553,45554,45555,45556,45557,45558,45559,45560,45562,45564,45566,45567,45568,45569,45570,45571,45574,45575,45577,45578,45581,45582,45583,45584,45585,45586,45587,45590,45592,45594,45595,45596,45597,45598,45599,45601,45602,45603,45604,45605,45606,45607,45608,45609,45610,45611,45612,45613,45614,45615,45616,45617,45618,45619,45621,45622,45623,45624,45625,45626,45627,45629,45630,45631,45632,45633,45634,45635,45636,45637,45638,45639,45640,45641,45642,45643,45644,45645,45646,45647,45648,45649,45650,45651,45652,45653,45654,45655,45657,45658,45659,45661,45662,45663,45665,45666,45667,45668,45669,45670,45671,45674,45675,45676,45677,45678,45679,45680,45681,45682,45683,45686,45687,45688,45689,45690,45691,45693,45694,45695,45696,45697,45698,45699,45702,45703,45704,45706,45707,45708,45709,45710,null,null,null,null,null,null,45711,45714,45715,45717,45718,45719,45723,45724,45725,45726,45727,45730,45732,45735,45736,45737,45739,45741,45742,45743,45745,45746,45747,45749,45750,45751,null,null,null,null,null,null,45752,45753,45754,45755,45756,45757,45758,45759,45760,45761,45762,45763,45764,45765,45766,45767,45770,45771,45773,45774,45775,45777,45779,45780,45781,45782,45783,45786,45788,45790,45791,45792,45793,45795,45799,45801,45802,45808,45809,45810,45814,45820,45821,45822,45826,45827,45829,45830,45831,45833,45834,45835,45836,45837,45838,45839,45842,45846,45847,45848,45849,45850,45851,45853,45854,45855,45856,45857,45858,45859,45860,45861,45862,45863,45864,45865,45866,45867,45868,45869,45870,45871,45872,45873,45874,45875,45876,45877,45878,45879,45880,45881,45882,45883,45884,45885,45886,45887,45888,45889,45890,45891,45892,45893,45894,45895,45896,45897,45898,45899,45900,45901,45902,45903,45904,45905,45906,45907,45911,45913,45914,45917,45920,45921,45922,45923,45926,45928,45930,45932,45933,45935,45938,45939,45941,45942,45943,45945,45946,45947,45948,45949,45950,45951,45954,45958,45959,45960,45961,45962,45963,45965,null,null,null,null,null,null,45966,45967,45969,45970,45971,45973,45974,45975,45976,45977,45978,45979,45980,45981,45982,45983,45986,45987,45988,45989,45990,45991,45993,45994,45995,45997,null,null,null,null,null,null,45998,45999,46000,46001,46002,46003,46004,46005,46006,46007,46008,46009,46010,46011,46012,46013,46014,46015,46016,46017,46018,46019,46022,46023,46025,46026,46029,46031,46033,46034,46035,46038,46040,46042,46044,46046,46047,46049,46050,46051,46053,46054,46055,46057,46058,46059,46060,46061,46062,46063,46064,46065,46066,46067,46068,46069,46070,46071,46072,46073,46074,46075,46077,46078,46079,46080,46081,46082,46083,46084,46085,46086,46087,46088,46089,46090,46091,46092,46093,46094,46095,46097,46098,46099,46100,46101,46102,46103,46105,46106,46107,46109,46110,46111,46113,46114,46115,46116,46117,46118,46119,46122,46124,46125,46126,46127,46128,46129,46130,46131,46133,46134,46135,46136,46137,46138,46139,46140,46141,46142,46143,46144,46145,46146,46147,46148,46149,46150,46151,46152,46153,46154,46155,46156,46157,46158,46159,46162,46163,46165,46166,46167,46169,46170,46171,46172,46173,46174,46175,46178,46180,46182,null,null,null,null,null,null,46183,46184,46185,46186,46187,46189,46190,46191,46192,46193,46194,46195,46196,46197,46198,46199,46200,46201,46202,46203,46204,46205,46206,46207,46209,46210,null,null,null,null,null,null,46211,46212,46213,46214,46215,46217,46218,46219,46220,46221,46222,46223,46224,46225,46226,46227,46228,46229,46230,46231,46232,46233,46234,46235,46236,46238,46239,46240,46241,46242,46243,46245,46246,46247,46249,46250,46251,46253,46254,46255,46256,46257,46258,46259,46260,46262,46264,46266,46267,46268,46269,46270,46271,46273,46274,46275,46277,46278,46279,46281,46282,46283,46284,46285,46286,46287,46289,46290,46291,46292,46294,46295,46296,46297,46298,46299,46302,46303,46305,46306,46309,46311,46312,46313,46314,46315,46318,46320,46322,46323,46324,46325,46326,46327,46329,46330,46331,46332,46333,46334,46335,46336,46337,46338,46339,46340,46341,46342,46343,46344,46345,46346,46347,46348,46349,46350,46351,46352,46353,46354,46355,46358,46359,46361,46362,46365,46366,46367,46368,46369,46370,46371,46374,46379,46380,46381,46382,46383,46386,46387,46389,46390,46391,46393,46394,46395,46396,46397,46398,46399,46402,46406,null,null,null,null,null,null,46407,46408,46409,46410,46414,46415,46417,46418,46419,46421,46422,46423,46424,46425,46426,46427,46430,46434,46435,46436,46437,46438,46439,46440,46441,46442,null,null,null,null,null,null,46443,46444,46445,46446,46447,46448,46449,46450,46451,46452,46453,46454,46455,46456,46457,46458,46459,46460,46461,46462,46463,46464,46465,46466,46467,46468,46469,46470,46471,46472,46473,46474,46475,46476,46477,46478,46479,46480,46481,46482,46483,46484,46485,46486,46487,46488,46489,46490,46491,46492,46493,46494,46495,46498,46499,46501,46502,46503,46505,46508,46509,46510,46511,46514,46518,46519,46520,46521,46522,46526,46527,46529,46530,46531,46533,46534,46535,46536,46537,46538,46539,46542,46546,46547,46548,46549,46550,46551,46553,46554,46555,46556,46557,46558,46559,46560,46561,46562,46563,46564,46565,46566,46567,46568,46569,46570,46571,46573,46574,46575,46576,46577,46578,46579,46580,46581,46582,46583,46584,46585,46586,46587,46588,46589,46590,46591,46592,46593,46594,46595,46596,46597,46598,46599,46600,46601,46602,46603,46604,46605,46606,46607,46610,46611,46613,46614,46615,46617,46618,46619,46620,46621,null,null,null,null,null,null,46622,46623,46624,46625,46626,46627,46628,46630,46631,46632,46633,46634,46635,46637,46638,46639,46640,46641,46642,46643,46645,46646,46647,46648,46649,46650,null,null,null,null,null,null,46651,46652,46653,46654,46655,46656,46657,46658,46659,46660,46661,46662,46663,46665,46666,46667,46668,46669,46670,46671,46672,46673,46674,46675,46676,46677,46678,46679,46680,46681,46682,46683,46684,46685,46686,46687,46688,46689,46690,46691,46693,46694,46695,46697,46698,46699,46700,46701,46702,46703,46704,46705,46706,46707,46708,46709,46710,46711,46712,46713,46714,46715,46716,46717,46718,46719,46720,46721,46722,46723,46724,46725,46726,46727,46728,46729,46730,46731,46732,46733,46734,46735,46736,46737,46738,46739,46740,46741,46742,46743,46744,46745,46746,46747,46750,46751,46753,46754,46755,46757,46758,46759,46760,46761,46762,46765,46766,46767,46768,46770,46771,46772,46773,46774,46775,46776,46777,46778,46779,46780,46781,46782,46783,46784,46785,46786,46787,46788,46789,46790,46791,46792,46793,46794,46795,46796,46797,46798,46799,46800,46801,46802,46803,46805,46806,46807,46808,46809,46810,46811,46812,46813,null,null,null,null,null,null,46814,46815,46816,46817,46818,46819,46820,46821,46822,46823,46824,46825,46826,46827,46828,46829,46830,46831,46833,46834,46835,46837,46838,46839,46841,46842,null,null,null,null,null,null,46843,46844,46845,46846,46847,46850,46851,46852,46854,46855,46856,46857,46858,46859,46860,46861,46862,46863,46864,46865,46866,46867,46868,46869,46870,46871,46872,46873,46874,46875,46876,46877,46878,46879,46880,46881,46882,46883,46884,46885,46886,46887,46890,46891,46893,46894,46897,46898,46899,46900,46901,46902,46903,46906,46908,46909,46910,46911,46912,46913,46914,46915,46917,46918,46919,46921,46922,46923,46925,46926,46927,46928,46929,46930,46931,46934,46935,46936,46937,46938,46939,46940,46941,46942,46943,46945,46946,46947,46949,46950,46951,46953,46954,46955,46956,46957,46958,46959,46962,46964,46966,46967,46968,46969,46970,46971,46974,46975,46977,46978,46979,46981,46982,46983,46984,46985,46986,46987,46990,46995,46996,46997,47002,47003,47005,47006,47007,47009,47010,47011,47012,47013,47014,47015,47018,47022,47023,47024,47025,47026,47027,47030,47031,47033,47034,47035,47036,47037,47038,47039,47040,47041,null,null,null,null,null,null,47042,47043,47044,47045,47046,47048,47050,47051,47052,47053,47054,47055,47056,47057,47058,47059,47060,47061,47062,47063,47064,47065,47066,47067,47068,47069,null,null,null,null,null,null,47070,47071,47072,47073,47074,47075,47076,47077,47078,47079,47080,47081,47082,47083,47086,47087,47089,47090,47091,47093,47094,47095,47096,47097,47098,47099,47102,47106,47107,47108,47109,47110,47114,47115,47117,47118,47119,47121,47122,47123,47124,47125,47126,47127,47130,47132,47134,47135,47136,47137,47138,47139,47142,47143,47145,47146,47147,47149,47150,47151,47152,47153,47154,47155,47158,47162,47163,47164,47165,47166,47167,47169,47170,47171,47173,47174,47175,47176,47177,47178,47179,47180,47181,47182,47183,47184,47186,47188,47189,47190,47191,47192,47193,47194,47195,47198,47199,47201,47202,47203,47205,47206,47207,47208,47209,47210,47211,47214,47216,47218,47219,47220,47221,47222,47223,47225,47226,47227,47229,47230,47231,47232,47233,47234,47235,47236,47237,47238,47239,47240,47241,47242,47243,47244,47246,47247,47248,47249,47250,47251,47252,47253,47254,47255,47256,47257,47258,47259,47260,47261,47262,47263,null,null,null,null,null,null,47264,47265,47266,47267,47268,47269,47270,47271,47273,47274,47275,47276,47277,47278,47279,47281,47282,47283,47285,47286,47287,47289,47290,47291,47292,47293,null,null,null,null,null,null,47294,47295,47298,47300,47302,47303,47304,47305,47306,47307,47309,47310,47311,47313,47314,47315,47317,47318,47319,47320,47321,47322,47323,47324,47326,47328,47330,47331,47332,47333,47334,47335,47338,47339,47341,47342,47343,47345,47346,47347,47348,47349,47350,47351,47354,47356,47358,47359,47360,47361,47362,47363,47365,47366,47367,47368,47369,47370,47371,47372,47373,47374,47375,47376,47377,47378,47379,47380,47381,47382,47383,47385,47386,47387,47388,47389,47390,47391,47393,47394,47395,47396,47397,47398,47399,47400,47401,47402,47403,47404,47405,47406,47407,47408,47409,47410,47411,47412,47413,47414,47415,47416,47417,47418,47419,47422,47423,47425,47426,47427,47429,47430,47431,47432,47433,47434,47435,47437,47438,47440,47442,47443,47444,47445,47446,47447,47450,47451,47453,47454,47455,47457,47458,47459,47460,47461,47462,47463,47466,47468,47470,47471,47472,47473,47474,47475,47478,47479,47481,47482,47483,47485,null,null,null,null,null,null,47486,47487,47488,47489,47490,47491,47494,47496,47499,47500,47503,47504,47505,47506,47507,47508,47509,47510,47511,47512,47513,47514,47515,47516,47517,47518,null,null,null,null,null,null,47519,47520,47521,47522,47523,47524,47525,47526,47527,47528,47529,47530,47531,47534,47535,47537,47538,47539,47541,47542,47543,47544,47545,47546,47547,47550,47552,47554,47555,47556,47557,47558,47559,47562,47563,47565,47571,47572,47573,47574,47575,47578,47580,47583,47584,47586,47590,47591,47593,47594,47595,47597,47598,47599,47600,47601,47602,47603,47606,47611,47612,47613,47614,47615,47618,47619,47620,47621,47622,47623,47625,47626,47627,47628,47629,47630,47631,47632,47633,47634,47635,47636,47638,47639,47640,47641,47642,47643,47644,47645,47646,47647,47648,47649,47650,47651,47652,47653,47654,47655,47656,47657,47658,47659,47660,47661,47662,47663,47664,47665,47666,47667,47668,47669,47670,47671,47674,47675,47677,47678,47679,47681,47683,47684,47685,47686,47687,47690,47692,47695,47696,47697,47698,47702,47703,47705,47706,47707,47709,47710,47711,47712,47713,47714,47715,47718,47722,47723,47724,47725,47726,47727,null,null,null,null,null,null,47730,47731,47733,47734,47735,47737,47738,47739,47740,47741,47742,47743,47744,47745,47746,47750,47752,47753,47754,47755,47757,47758,47759,47760,47761,47762,null,null,null,null,null,null,47763,47764,47765,47766,47767,47768,47769,47770,47771,47772,47773,47774,47775,47776,47777,47778,47779,47780,47781,47782,47783,47786,47789,47790,47791,47793,47795,47796,47797,47798,47799,47802,47804,47806,47807,47808,47809,47810,47811,47813,47814,47815,47817,47818,47819,47820,47821,47822,47823,47824,47825,47826,47827,47828,47829,47830,47831,47834,47835,47836,47837,47838,47839,47840,47841,47842,47843,47844,47845,47846,47847,47848,47849,47850,47851,47852,47853,47854,47855,47856,47857,47858,47859,47860,47861,47862,47863,47864,47865,47866,47867,47869,47870,47871,47873,47874,47875,47877,47878,47879,47880,47881,47882,47883,47884,47886,47888,47890,47891,47892,47893,47894,47895,47897,47898,47899,47901,47902,47903,47905,47906,47907,47908,47909,47910,47911,47912,47914,47916,47917,47918,47919,47920,47921,47922,47923,47927,47929,47930,47935,47936,47937,47938,47939,47942,47944,47946,47947,47948,47950,47953,47954,null,null,null,null,null,null,47955,47957,47958,47959,47961,47962,47963,47964,47965,47966,47967,47968,47970,47972,47973,47974,47975,47976,47977,47978,47979,47981,47982,47983,47984,47985,null,null,null,null,null,null,47986,47987,47988,47989,47990,47991,47992,47993,47994,47995,47996,47997,47998,47999,48000,48001,48002,48003,48004,48005,48006,48007,48009,48010,48011,48013,48014,48015,48017,48018,48019,48020,48021,48022,48023,48024,48025,48026,48027,48028,48029,48030,48031,48032,48033,48034,48035,48037,48038,48039,48041,48042,48043,48045,48046,48047,48048,48049,48050,48051,48053,48054,48056,48057,48058,48059,48060,48061,48062,48063,48065,48066,48067,48069,48070,48071,48073,48074,48075,48076,48077,48078,48079,48081,48082,48084,48085,48086,48087,48088,48089,48090,48091,48092,48093,48094,48095,48096,48097,48098,48099,48100,48101,48102,48103,48104,48105,48106,48107,48108,48109,48110,48111,48112,48113,48114,48115,48116,48117,48118,48119,48122,48123,48125,48126,48129,48131,48132,48133,48134,48135,48138,48142,48144,48146,48147,48153,48154,48160,48161,48162,48163,48166,48168,48170,48171,48172,48174,48175,48178,48179,48181,null,null,null,null,null,null,48182,48183,48185,48186,48187,48188,48189,48190,48191,48194,48198,48199,48200,48202,48203,48206,48207,48209,48210,48211,48212,48213,48214,48215,48216,48217,null,null,null,null,null,null,48218,48219,48220,48222,48223,48224,48225,48226,48227,48228,48229,48230,48231,48232,48233,48234,48235,48236,48237,48238,48239,48240,48241,48242,48243,48244,48245,48246,48247,48248,48249,48250,48251,48252,48253,48254,48255,48256,48257,48258,48259,48262,48263,48265,48266,48269,48271,48272,48273,48274,48275,48278,48280,48283,48284,48285,48286,48287,48290,48291,48293,48294,48297,48298,48299,48300,48301,48302,48303,48306,48310,48311,48312,48313,48314,48315,48318,48319,48321,48322,48323,48325,48326,48327,48328,48329,48330,48331,48332,48334,48338,48339,48340,48342,48343,48345,48346,48347,48349,48350,48351,48352,48353,48354,48355,48356,48357,48358,48359,48360,48361,48362,48363,48364,48365,48366,48367,48368,48369,48370,48371,48375,48377,48378,48379,48381,48382,48383,48384,48385,48386,48387,48390,48392,48394,48395,48396,48397,48398,48399,48401,48402,48403,48405,48406,48407,48408,48409,48410,48411,48412,48413,null,null,null,null,null,null,48414,48415,48416,48417,48418,48419,48421,48422,48423,48424,48425,48426,48427,48429,48430,48431,48432,48433,48434,48435,48436,48437,48438,48439,48440,48441,null,null,null,null,null,null,48442,48443,48444,48445,48446,48447,48449,48450,48451,48452,48453,48454,48455,48458,48459,48461,48462,48463,48465,48466,48467,48468,48469,48470,48471,48474,48475,48476,48477,48478,48479,48480,48481,48482,48483,48485,48486,48487,48489,48490,48491,48492,48493,48494,48495,48496,48497,48498,48499,48500,48501,48502,48503,48504,48505,48506,48507,48508,48509,48510,48511,48514,48515,48517,48518,48523,48524,48525,48526,48527,48530,48532,48534,48535,48536,48539,48541,48542,48543,48544,48545,48546,48547,48549,48550,48551,48552,48553,48554,48555,48556,48557,48558,48559,48561,48562,48563,48564,48565,48566,48567,48569,48570,48571,48572,48573,48574,48575,48576,48577,48578,48579,48580,48581,48582,48583,48584,48585,48586,48587,48588,48589,48590,48591,48592,48593,48594,48595,48598,48599,48601,48602,48603,48605,48606,48607,48608,48609,48610,48611,48612,48613,48614,48615,48616,48618,48619,48620,48621,48622,48623,48625,null,null,null,null,null,null,48626,48627,48629,48630,48631,48633,48634,48635,48636,48637,48638,48639,48641,48642,48644,48646,48647,48648,48649,48650,48651,48654,48655,48657,48658,48659,null,null,null,null,null,null,48661,48662,48663,48664,48665,48666,48667,48670,48672,48673,48674,48675,48676,48677,48678,48679,48680,48681,48682,48683,48684,48685,48686,48687,48688,48689,48690,48691,48692,48693,48694,48695,48696,48697,48698,48699,48700,48701,48702,48703,48704,48705,48706,48707,48710,48711,48713,48714,48715,48717,48719,48720,48721,48722,48723,48726,48728,48732,48733,48734,48735,48738,48739,48741,48742,48743,48745,48747,48748,48749,48750,48751,48754,48758,48759,48760,48761,48762,48766,48767,48769,48770,48771,48773,48774,48775,48776,48777,48778,48779,48782,48786,48787,48788,48789,48790,48791,48794,48795,48796,48797,48798,48799,48800,48801,48802,48803,48804,48805,48806,48807,48809,48810,48811,48812,48813,48814,48815,48816,48817,48818,48819,48820,48821,48822,48823,48824,48825,48826,48827,48828,48829,48830,48831,48832,48833,48834,48835,48836,48837,48838,48839,48840,48841,48842,48843,48844,48845,48846,48847,48850,48851,null,null,null,null,null,null,48853,48854,48857,48858,48859,48860,48861,48862,48863,48865,48866,48870,48871,48872,48873,48874,48875,48877,48878,48879,48880,48881,48882,48883,48884,48885,null,null,null,null,null,null,48886,48887,48888,48889,48890,48891,48892,48893,48894,48895,48896,48898,48899,48900,48901,48902,48903,48906,48907,48908,48909,48910,48911,48912,48913,48914,48915,48916,48917,48918,48919,48922,48926,48927,48928,48929,48930,48931,48932,48933,48934,48935,48936,48937,48938,48939,48940,48941,48942,48943,48944,48945,48946,48947,48948,48949,48950,48951,48952,48953,48954,48955,48956,48957,48958,48959,48962,48963,48965,48966,48967,48969,48970,48971,48972,48973,48974,48975,48978,48979,48980,48982,48983,48984,48985,48986,48987,48988,48989,48990,48991,48992,48993,48994,48995,48996,48997,48998,48999,49000,49001,49002,49003,49004,49005,49006,49007,49008,49009,49010,49011,49012,49013,49014,49015,49016,49017,49018,49019,49020,49021,49022,49023,49024,49025,49026,49027,49028,49029,49030,49031,49032,49033,49034,49035,49036,49037,49038,49039,49040,49041,49042,49043,49045,49046,49047,49048,49049,49050,49051,49052,49053,null,null,null,null,null,null,49054,49055,49056,49057,49058,49059,49060,49061,49062,49063,49064,49065,49066,49067,49068,49069,49070,49071,49073,49074,49075,49076,49077,49078,49079,49080,null,null,null,null,null,null,49081,49082,49083,49084,49085,49086,49087,49088,49089,49090,49091,49092,49094,49095,49096,49097,49098,49099,49102,49103,49105,49106,49107,49109,49110,49111,49112,49113,49114,49115,49117,49118,49120,49122,49123,49124,49125,49126,49127,49128,49129,49130,49131,49132,49133,49134,49135,49136,49137,49138,49139,49140,49141,49142,49143,49144,49145,49146,49147,49148,49149,49150,49151,49152,49153,49154,49155,49156,49157,49158,49159,49160,49161,49162,49163,49164,49165,49166,49167,49168,49169,49170,49171,49172,49173,49174,49175,49176,49177,49178,49179,49180,49181,49182,49183,49184,49185,49186,49187,49188,49189,49190,49191,49192,49193,49194,49195,49196,49197,49198,49199,49200,49201,49202,49203,49204,49205,49206,49207,49208,49209,49210,49211,49213,49214,49215,49216,49217,49218,49219,49220,49221,49222,49223,49224,49225,49226,49227,49228,49229,49230,49231,49232,49234,49235,49236,49237,49238,49239,49241,49242,49243,null,null,null,null,null,null,49245,49246,49247,49249,49250,49251,49252,49253,49254,49255,49258,49259,49260,49261,49262,49263,49264,49265,49266,49267,49268,49269,49270,49271,49272,49273,null,null,null,null,null,null,49274,49275,49276,49277,49278,49279,49280,49281,49282,49283,49284,49285,49286,49287,49288,49289,49290,49291,49292,49293,49294,49295,49298,49299,49301,49302,49303,49305,49306,49307,49308,49309,49310,49311,49314,49316,49318,49319,49320,49321,49322,49323,49326,49329,49330,49335,49336,49337,49338,49339,49342,49346,49347,49348,49350,49351,49354,49355,49357,49358,49359,49361,49362,49363,49364,49365,49366,49367,49370,49374,49375,49376,49377,49378,49379,49382,49383,49385,49386,49387,49389,49390,49391,49392,49393,49394,49395,49398,49400,49402,49403,49404,49405,49406,49407,49409,49410,49411,49413,49414,49415,49417,49418,49419,49420,49421,49422,49423,49425,49426,49427,49428,49430,49431,49432,49433,49434,49435,49441,49442,49445,49448,49449,49450,49451,49454,49458,49459,49460,49461,49463,49466,49467,49469,49470,49471,49473,49474,49475,49476,49477,49478,49479,49482,49486,49487,49488,49489,49490,49491,49494,49495,null,null,null,null,null,null,49497,49498,49499,49501,49502,49503,49504,49505,49506,49507,49510,49514,49515,49516,49517,49518,49519,49521,49522,49523,49525,49526,49527,49529,49530,49531,null,null,null,null,null,null,49532,49533,49534,49535,49536,49537,49538,49539,49540,49542,49543,49544,49545,49546,49547,49551,49553,49554,49555,49557,49559,49560,49561,49562,49563,49566,49568,49570,49571,49572,49574,49575,49578,49579,49581,49582,49583,49585,49586,49587,49588,49589,49590,49591,49592,49593,49594,49595,49596,49598,49599,49600,49601,49602,49603,49605,49606,49607,49609,49610,49611,49613,49614,49615,49616,49617,49618,49619,49621,49622,49625,49626,49627,49628,49629,49630,49631,49633,49634,49635,49637,49638,49639,49641,49642,49643,49644,49645,49646,49647,49650,49652,49653,49654,49655,49656,49657,49658,49659,49662,49663,49665,49666,49667,49669,49670,49671,49672,49673,49674,49675,49678,49680,49682,49683,49684,49685,49686,49687,49690,49691,49693,49694,49697,49698,49699,49700,49701,49702,49703,49706,49708,49710,49712,49715,49717,49718,49719,49720,49721,49722,49723,49724,49725,49726,49727,49728,49729,49730,49731,49732,49733,null,null,null,null,null,null,49734,49735,49737,49738,49739,49740,49741,49742,49743,49746,49747,49749,49750,49751,49753,49754,49755,49756,49757,49758,49759,49761,49762,49763,49764,49766,null,null,null,null,null,null,49767,49768,49769,49770,49771,49774,49775,49777,49778,49779,49781,49782,49783,49784,49785,49786,49787,49790,49792,49794,49795,49796,49797,49798,49799,49802,49803,49804,49805,49806,49807,49809,49810,49811,49812,49813,49814,49815,49817,49818,49820,49822,49823,49824,49825,49826,49827,49830,49831,49833,49834,49835,49838,49839,49840,49841,49842,49843,49846,49848,49850,49851,49852,49853,49854,49855,49856,49857,49858,49859,49860,49861,49862,49863,49864,49865,49866,49867,49868,49869,49870,49871,49872,49873,49874,49875,49876,49877,49878,49879,49880,49881,49882,49883,49886,49887,49889,49890,49893,49894,49895,49896,49897,49898,49902,49904,49906,49907,49908,49909,49911,49914,49917,49918,49919,49921,49922,49923,49924,49925,49926,49927,49930,49931,49934,49935,49936,49937,49938,49942,49943,49945,49946,49947,49949,49950,49951,49952,49953,49954,49955,49958,49959,49962,49963,49964,49965,49966,49967,49968,49969,49970,null,null,null,null,null,null,49971,49972,49973,49974,49975,49976,49977,49978,49979,49980,49981,49982,49983,49984,49985,49986,49987,49988,49990,49991,49992,49993,49994,49995,49996,49997,null,null,null,null,null,null,49998,49999,50000,50001,50002,50003,50004,50005,50006,50007,50008,50009,50010,50011,50012,50013,50014,50015,50016,50017,50018,50019,50020,50021,50022,50023,50026,50027,50029,50030,50031,50033,50035,50036,50037,50038,50039,50042,50043,50046,50047,50048,50049,50050,50051,50053,50054,50055,50057,50058,50059,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50087,50088,50089,50090,50091,50092,50093,50094,50095,50096,50097,50098,50099,50100,50101,50102,50103,50104,50105,50106,50107,50108,50109,50110,50111,50113,50114,50115,50116,50117,50118,50119,50120,50121,50122,50123,50124,50125,50126,50127,50128,50129,50130,50131,50132,50133,50134,50135,50138,50139,50141,50142,50145,50147,50148,50149,50150,50151,50154,50155,50156,50158,50159,50160,50161,50162,50163,50166,50167,50169,50170,50171,50172,50173,50174,null,null,null,null,null,null,50175,50176,50177,50178,50179,50180,50181,50182,50183,50185,50186,50187,50188,50189,50190,50191,50193,50194,50195,50196,50197,50198,50199,50200,50201,50202,null,null,null,null,null,null,50203,50204,50205,50206,50207,50208,50209,50210,50211,50213,50214,50215,50216,50217,50218,50219,50221,50222,50223,50225,50226,50227,50229,50230,50231,50232,50233,50234,50235,50238,50239,50240,50241,50242,50243,50244,50245,50246,50247,50249,50250,50251,50252,50253,50254,50255,50256,50257,50258,50259,50260,50261,50262,50263,50264,50265,50266,50267,50268,50269,50270,50271,50272,50273,50274,50275,50278,50279,50281,50282,50283,50285,50286,50287,50288,50289,50290,50291,50294,50295,50296,50298,50299,50300,50301,50302,50303,50305,50306,50307,50308,50309,50310,50311,50312,50313,50314,50315,50316,50317,50318,50319,50320,50321,50322,50323,50325,50326,50327,50328,50329,50330,50331,50333,50334,50335,50336,50337,50338,50339,50340,50341,50342,50343,50344,50345,50346,50347,50348,50349,50350,50351,50352,50353,50354,50355,50356,50357,50358,50359,50361,50362,50363,50365,50366,50367,50368,50369,50370,50371,50372,50373,null,null,null,null,null,null,50374,50375,50376,50377,50378,50379,50380,50381,50382,50383,50384,50385,50386,50387,50388,50389,50390,50391,50392,50393,50394,50395,50396,50397,50398,50399,null,null,null,null,null,null,50400,50401,50402,50403,50404,50405,50406,50407,50408,50410,50411,50412,50413,50414,50415,50418,50419,50421,50422,50423,50425,50427,50428,50429,50430,50434,50435,50436,50437,50438,50439,50440,50441,50442,50443,50445,50446,50447,50449,50450,50451,50453,50454,50455,50456,50457,50458,50459,50461,50462,50463,50464,50465,50466,50467,50468,50469,50470,50471,50474,50475,50477,50478,50479,50481,50482,50483,50484,50485,50486,50487,50490,50492,50494,50495,50496,50497,50498,50499,50502,50503,50507,50511,50512,50513,50514,50518,50522,50523,50524,50527,50530,50531,50533,50534,50535,50537,50538,50539,50540,50541,50542,50543,50546,50550,50551,50552,50553,50554,50555,50558,50559,50561,50562,50563,50565,50566,50568,50569,50570,50571,50574,50576,50578,50579,50580,50582,50585,50586,50587,50589,50590,50591,50593,50594,50595,50596,50597,50598,50599,50600,50602,50603,50604,50605,50606,50607,50608,50609,50610,50611,50614,null,null,null,null,null,null,50615,50618,50623,50624,50625,50626,50627,50635,50637,50639,50642,50643,50645,50646,50647,50649,50650,50651,50652,50653,50654,50655,50658,50660,50662,50663,null,null,null,null,null,null,50664,50665,50666,50667,50671,50673,50674,50675,50677,50680,50681,50682,50683,50690,50691,50692,50697,50698,50699,50701,50702,50703,50705,50706,50707,50708,50709,50710,50711,50714,50717,50718,50719,50720,50721,50722,50723,50726,50727,50729,50730,50731,50735,50737,50738,50742,50744,50746,50748,50749,50750,50751,50754,50755,50757,50758,50759,50761,50762,50763,50764,50765,50766,50767,50770,50774,50775,50776,50777,50778,50779,50782,50783,50785,50786,50787,50788,50789,50790,50791,50792,50793,50794,50795,50797,50798,50800,50802,50803,50804,50805,50806,50807,50810,50811,50813,50814,50815,50817,50818,50819,50820,50821,50822,50823,50826,50828,50830,50831,50832,50833,50834,50835,50838,50839,50841,50842,50843,50845,50846,50847,50848,50849,50850,50851,50854,50856,50858,50859,50860,50861,50862,50863,50866,50867,50869,50870,50871,50875,50876,50877,50878,50879,50882,50884,50886,50887,50888,50889,50890,50891,50894,null,null,null,null,null,null,50895,50897,50898,50899,50901,50902,50903,50904,50905,50906,50907,50910,50911,50914,50915,50916,50917,50918,50919,50922,50923,50925,50926,50927,50929,50930,null,null,null,null,null,null,50931,50932,50933,50934,50935,50938,50939,50940,50942,50943,50944,50945,50946,50947,50950,50951,50953,50954,50955,50957,50958,50959,50960,50961,50962,50963,50966,50968,50970,50971,50972,50973,50974,50975,50978,50979,50981,50982,50983,50985,50986,50987,50988,50989,50990,50991,50994,50996,50998,51000,51001,51002,51003,51006,51007,51009,51010,51011,51013,51014,51015,51016,51017,51019,51022,51024,51033,51034,51035,51037,51038,51039,51041,51042,51043,51044,51045,51046,51047,51049,51050,51052,51053,51054,51055,51056,51057,51058,51059,51062,51063,51065,51066,51067,51071,51072,51073,51074,51078,51083,51084,51085,51087,51090,51091,51093,51097,51099,51100,51101,51102,51103,51106,51111,51112,51113,51114,51115,51118,51119,51121,51122,51123,51125,51126,51127,51128,51129,51130,51131,51134,51138,51139,51140,51141,51142,51143,51146,51147,51149,51151,51153,51154,51155,51156,51157,51158,51159,51161,51162,51163,51164,null,null,null,null,null,null,51166,51167,51168,51169,51170,51171,51173,51174,51175,51177,51178,51179,51181,51182,51183,51184,51185,51186,51187,51188,51189,51190,51191,51192,51193,51194,null,null,null,null,null,null,51195,51196,51197,51198,51199,51202,51203,51205,51206,51207,51209,51211,51212,51213,51214,51215,51218,51220,51223,51224,51225,51226,51227,51230,51231,51233,51234,51235,51237,51238,51239,51240,51241,51242,51243,51246,51248,51250,51251,51252,51253,51254,51255,51257,51258,51259,51261,51262,51263,51265,51266,51267,51268,51269,51270,51271,51274,51275,51278,51279,51280,51281,51282,51283,51285,51286,51287,51288,51289,51290,51291,51292,51293,51294,51295,51296,51297,51298,51299,51300,51301,51302,51303,51304,51305,51306,51307,51308,51309,51310,51311,51314,51315,51317,51318,51319,51321,51323,51324,51325,51326,51327,51330,51332,51336,51337,51338,51342,51343,51344,51345,51346,51347,51349,51350,51351,51352,51353,51354,51355,51356,51358,51360,51362,51363,51364,51365,51366,51367,51369,51370,51371,51372,51373,51374,51375,51376,51377,51378,51379,51380,51381,51382,51383,51384,51385,51386,51387,51390,51391,51392,51393,null,null,null,null,null,null,51394,51395,51397,51398,51399,51401,51402,51403,51405,51406,51407,51408,51409,51410,51411,51414,51416,51418,51419,51420,51421,51422,51423,51426,51427,51429,null,null,null,null,null,null,51430,51431,51432,51433,51434,51435,51436,51437,51438,51439,51440,51441,51442,51443,51444,51446,51447,51448,51449,51450,51451,51454,51455,51457,51458,51459,51463,51464,51465,51466,51467,51470,12288,12289,12290,183,8229,8230,168,12291,173,8213,8741,65340,8764,8216,8217,8220,8221,12308,12309,12296,12297,12298,12299,12300,12301,12302,12303,12304,12305,177,215,247,8800,8804,8805,8734,8756,176,8242,8243,8451,8491,65504,65505,65509,9794,9792,8736,8869,8978,8706,8711,8801,8786,167,8251,9734,9733,9675,9679,9678,9671,9670,9633,9632,9651,9650,9661,9660,8594,8592,8593,8595,8596,12307,8810,8811,8730,8765,8733,8757,8747,8748,8712,8715,8838,8839,8834,8835,8746,8745,8743,8744,65506,51472,51474,51475,51476,51477,51478,51479,51481,51482,51483,51484,51485,51486,51487,51488,51489,51490,51491,51492,51493,51494,51495,51496,51497,51498,51499,null,null,null,null,null,null,51501,51502,51503,51504,51505,51506,51507,51509,51510,51511,51512,51513,51514,51515,51516,51517,51518,51519,51520,51521,51522,51523,51524,51525,51526,51527,null,null,null,null,null,null,51528,51529,51530,51531,51532,51533,51534,51535,51538,51539,51541,51542,51543,51545,51546,51547,51548,51549,51550,51551,51554,51556,51557,51558,51559,51560,51561,51562,51563,51565,51566,51567,8658,8660,8704,8707,180,65374,711,728,733,730,729,184,731,161,191,720,8750,8721,8719,164,8457,8240,9665,9664,9655,9654,9828,9824,9825,9829,9831,9827,8857,9672,9635,9680,9681,9618,9636,9637,9640,9639,9638,9641,9832,9743,9742,9756,9758,182,8224,8225,8597,8599,8601,8598,8600,9837,9833,9834,9836,12927,12828,8470,13255,8482,13250,13272,8481,8364,174,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,51569,51570,51571,51573,51574,51575,51576,51577,51578,51579,51581,51582,51583,51584,51585,51586,51587,51588,51589,51590,51591,51594,51595,51597,51598,51599,null,null,null,null,null,null,51601,51602,51603,51604,51605,51606,51607,51610,51612,51614,51615,51616,51617,51618,51619,51620,51621,51622,51623,51624,51625,51626,51627,51628,51629,51630,null,null,null,null,null,null,51631,51632,51633,51634,51635,51636,51637,51638,51639,51640,51641,51642,51643,51644,51645,51646,51647,51650,51651,51653,51654,51657,51659,51660,51661,51662,51663,51666,51668,51671,51672,51675,65281,65282,65283,65284,65285,65286,65287,65288,65289,65290,65291,65292,65293,65294,65295,65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,65306,65307,65308,65309,65310,65311,65312,65313,65314,65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,65339,65510,65341,65342,65343,65344,65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,65371,65372,65373,65507,51678,51679,51681,51683,51685,51686,51688,51689,51690,51691,51694,51698,51699,51700,51701,51702,51703,51706,51707,51709,51710,51711,51713,51714,51715,51716,null,null,null,null,null,null,51717,51718,51719,51722,51726,51727,51728,51729,51730,51731,51733,51734,51735,51737,51738,51739,51740,51741,51742,51743,51744,51745,51746,51747,51748,51749,null,null,null,null,null,null,51750,51751,51752,51754,51755,51756,51757,51758,51759,51760,51761,51762,51763,51764,51765,51766,51767,51768,51769,51770,51771,51772,51773,51774,51775,51776,51777,51778,51779,51780,51781,51782,12593,12594,12595,12596,12597,12598,12599,12600,12601,12602,12603,12604,12605,12606,12607,12608,12609,12610,12611,12612,12613,12614,12615,12616,12617,12618,12619,12620,12621,12622,12623,12624,12625,12626,12627,12628,12629,12630,12631,12632,12633,12634,12635,12636,12637,12638,12639,12640,12641,12642,12643,12644,12645,12646,12647,12648,12649,12650,12651,12652,12653,12654,12655,12656,12657,12658,12659,12660,12661,12662,12663,12664,12665,12666,12667,12668,12669,12670,12671,12672,12673,12674,12675,12676,12677,12678,12679,12680,12681,12682,12683,12684,12685,12686,51783,51784,51785,51786,51787,51790,51791,51793,51794,51795,51797,51798,51799,51800,51801,51802,51803,51806,51810,51811,51812,51813,51814,51815,51817,51818,null,null,null,null,null,null,51819,51820,51821,51822,51823,51824,51825,51826,51827,51828,51829,51830,51831,51832,51833,51834,51835,51836,51838,51839,51840,51841,51842,51843,51845,51846,null,null,null,null,null,null,51847,51848,51849,51850,51851,51852,51853,51854,51855,51856,51857,51858,51859,51860,51861,51862,51863,51865,51866,51867,51868,51869,51870,51871,51872,51873,51874,51875,51876,51877,51878,51879,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,null,null,null,null,null,8544,8545,8546,8547,8548,8549,8550,8551,8552,8553,null,null,null,null,null,null,null,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,934,935,936,937,null,null,null,null,null,null,null,null,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,null,null,null,null,null,null,51880,51881,51882,51883,51884,51885,51886,51887,51888,51889,51890,51891,51892,51893,51894,51895,51896,51897,51898,51899,51902,51903,51905,51906,51907,51909,null,null,null,null,null,null,51910,51911,51912,51913,51914,51915,51918,51920,51922,51924,51925,51926,51927,51930,51931,51932,51933,51934,51935,51937,51938,51939,51940,51941,51942,51943,null,null,null,null,null,null,51944,51945,51946,51947,51949,51950,51951,51952,51953,51954,51955,51957,51958,51959,51960,51961,51962,51963,51964,51965,51966,51967,51968,51969,51970,51971,51972,51973,51974,51975,51977,51978,9472,9474,9484,9488,9496,9492,9500,9516,9508,9524,9532,9473,9475,9487,9491,9499,9495,9507,9523,9515,9531,9547,9504,9519,9512,9527,9535,9501,9520,9509,9528,9538,9490,9489,9498,9497,9494,9493,9486,9485,9502,9503,9505,9506,9510,9511,9513,9514,9517,9518,9521,9522,9525,9526,9529,9530,9533,9534,9536,9537,9539,9540,9541,9542,9543,9544,9545,9546,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,51979,51980,51981,51982,51983,51985,51986,51987,51989,51990,51991,51993,51994,51995,51996,51997,51998,51999,52002,52003,52004,52005,52006,52007,52008,52009,null,null,null,null,null,null,52010,52011,52012,52013,52014,52015,52016,52017,52018,52019,52020,52021,52022,52023,52024,52025,52026,52027,52028,52029,52030,52031,52032,52034,52035,52036,null,null,null,null,null,null,52037,52038,52039,52042,52043,52045,52046,52047,52049,52050,52051,52052,52053,52054,52055,52058,52059,52060,52062,52063,52064,52065,52066,52067,52069,52070,52071,52072,52073,52074,52075,52076,13205,13206,13207,8467,13208,13252,13219,13220,13221,13222,13209,13210,13211,13212,13213,13214,13215,13216,13217,13218,13258,13197,13198,13199,13263,13192,13193,13256,13223,13224,13232,13233,13234,13235,13236,13237,13238,13239,13240,13241,13184,13185,13186,13187,13188,13242,13243,13244,13245,13246,13247,13200,13201,13202,13203,13204,8486,13248,13249,13194,13195,13196,13270,13253,13229,13230,13231,13275,13225,13226,13227,13228,13277,13264,13267,13251,13257,13276,13254,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52077,52078,52079,52080,52081,52082,52083,52084,52085,52086,52087,52090,52091,52092,52093,52094,52095,52096,52097,52098,52099,52100,52101,52102,52103,52104,null,null,null,null,null,null,52105,52106,52107,52108,52109,52110,52111,52112,52113,52114,52115,52116,52117,52118,52119,52120,52121,52122,52123,52125,52126,52127,52128,52129,52130,52131,null,null,null,null,null,null,52132,52133,52134,52135,52136,52137,52138,52139,52140,52141,52142,52143,52144,52145,52146,52147,52148,52149,52150,52151,52153,52154,52155,52156,52157,52158,52159,52160,52161,52162,52163,52164,198,208,170,294,null,306,null,319,321,216,338,186,222,358,330,null,12896,12897,12898,12899,12900,12901,12902,12903,12904,12905,12906,12907,12908,12909,12910,12911,12912,12913,12914,12915,12916,12917,12918,12919,12920,12921,12922,12923,9424,9425,9426,9427,9428,9429,9430,9431,9432,9433,9434,9435,9436,9437,9438,9439,9440,9441,9442,9443,9444,9445,9446,9447,9448,9449,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,9322,9323,9324,9325,9326,189,8531,8532,188,190,8539,8540,8541,8542,52165,52166,52167,52168,52169,52170,52171,52172,52173,52174,52175,52176,52177,52178,52179,52181,52182,52183,52184,52185,52186,52187,52188,52189,52190,52191,null,null,null,null,null,null,52192,52193,52194,52195,52197,52198,52200,52202,52203,52204,52205,52206,52207,52208,52209,52210,52211,52212,52213,52214,52215,52216,52217,52218,52219,52220,null,null,null,null,null,null,52221,52222,52223,52224,52225,52226,52227,52228,52229,52230,52231,52232,52233,52234,52235,52238,52239,52241,52242,52243,52245,52246,52247,52248,52249,52250,52251,52254,52255,52256,52259,52260,230,273,240,295,305,307,312,320,322,248,339,223,254,359,331,329,12800,12801,12802,12803,12804,12805,12806,12807,12808,12809,12810,12811,12812,12813,12814,12815,12816,12817,12818,12819,12820,12821,12822,12823,12824,12825,12826,12827,9372,9373,9374,9375,9376,9377,9378,9379,9380,9381,9382,9383,9384,9385,9386,9387,9388,9389,9390,9391,9392,9393,9394,9395,9396,9397,9332,9333,9334,9335,9336,9337,9338,9339,9340,9341,9342,9343,9344,9345,9346,185,178,179,8308,8319,8321,8322,8323,8324,52261,52262,52266,52267,52269,52271,52273,52274,52275,52276,52277,52278,52279,52282,52287,52288,52289,52290,52291,52294,52295,52297,52298,52299,52301,52302,null,null,null,null,null,null,52303,52304,52305,52306,52307,52310,52314,52315,52316,52317,52318,52319,52321,52322,52323,52325,52327,52329,52330,52331,52332,52333,52334,52335,52337,52338,null,null,null,null,null,null,52339,52340,52342,52343,52344,52345,52346,52347,52348,52349,52350,52351,52352,52353,52354,52355,52356,52357,52358,52359,52360,52361,52362,52363,52364,52365,52366,52367,52368,52369,52370,52371,12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,null,null,null,null,null,null,null,null,null,null,null,52372,52373,52374,52375,52378,52379,52381,52382,52383,52385,52386,52387,52388,52389,52390,52391,52394,52398,52399,52400,52401,52402,52403,52406,52407,52409,null,null,null,null,null,null,52410,52411,52413,52414,52415,52416,52417,52418,52419,52422,52424,52426,52427,52428,52429,52430,52431,52433,52434,52435,52437,52438,52439,52440,52441,52442,null,null,null,null,null,null,52443,52444,52445,52446,52447,52448,52449,52450,52451,52453,52454,52455,52456,52457,52458,52459,52461,52462,52463,52465,52466,52467,52468,52469,52470,52471,52472,52473,52474,52475,52476,52477,12449,12450,12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,12534,null,null,null,null,null,null,null,null,52478,52479,52480,52482,52483,52484,52485,52486,52487,52490,52491,52493,52494,52495,52497,52498,52499,52500,52501,52502,52503,52506,52508,52510,52511,52512,null,null,null,null,null,null,52513,52514,52515,52517,52518,52519,52521,52522,52523,52525,52526,52527,52528,52529,52530,52531,52532,52533,52534,52535,52536,52538,52539,52540,52541,52542,null,null,null,null,null,null,52543,52544,52545,52546,52547,52548,52549,52550,52551,52552,52553,52554,52555,52556,52557,52558,52559,52560,52561,52562,52563,52564,52565,52566,52567,52568,52569,52570,52571,52573,52574,52575,1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,null,null,null,null,null,null,null,null,null,null,null,null,null,52577,52578,52579,52581,52582,52583,52584,52585,52586,52587,52590,52592,52594,52595,52596,52597,52598,52599,52601,52602,52603,52604,52605,52606,52607,52608,null,null,null,null,null,null,52609,52610,52611,52612,52613,52614,52615,52617,52618,52619,52620,52621,52622,52623,52624,52625,52626,52627,52630,52631,52633,52634,52635,52637,52638,52639,null,null,null,null,null,null,52640,52641,52642,52643,52646,52648,52650,52651,52652,52653,52654,52655,52657,52658,52659,52660,52661,52662,52663,52664,52665,52666,52667,52668,52669,52670,52671,52672,52673,52674,52675,52677,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52678,52679,52680,52681,52682,52683,52685,52686,52687,52689,52690,52691,52692,52693,52694,52695,52696,52697,52698,52699,52700,52701,52702,52703,52704,52705,null,null,null,null,null,null,52706,52707,52708,52709,52710,52711,52713,52714,52715,52717,52718,52719,52721,52722,52723,52724,52725,52726,52727,52730,52732,52734,52735,52736,52737,52738,null,null,null,null,null,null,52739,52741,52742,52743,52745,52746,52747,52749,52750,52751,52752,52753,52754,52755,52757,52758,52759,52760,52762,52763,52764,52765,52766,52767,52770,52771,52773,52774,52775,52777,52778,52779,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52780,52781,52782,52783,52786,52788,52790,52791,52792,52793,52794,52795,52796,52797,52798,52799,52800,52801,52802,52803,52804,52805,52806,52807,52808,52809,null,null,null,null,null,null,52810,52811,52812,52813,52814,52815,52816,52817,52818,52819,52820,52821,52822,52823,52826,52827,52829,52830,52834,52835,52836,52837,52838,52839,52842,52844,null,null,null,null,null,null,52846,52847,52848,52849,52850,52851,52854,52855,52857,52858,52859,52861,52862,52863,52864,52865,52866,52867,52870,52872,52874,52875,52876,52877,52878,52879,52882,52883,52885,52886,52887,52889,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52890,52891,52892,52893,52894,52895,52898,52902,52903,52904,52905,52906,52907,52910,52911,52912,52913,52914,52915,52916,52917,52918,52919,52920,52921,52922,null,null,null,null,null,null,52923,52924,52925,52926,52927,52928,52930,52931,52932,52933,52934,52935,52936,52937,52938,52939,52940,52941,52942,52943,52944,52945,52946,52947,52948,52949,null,null,null,null,null,null,52950,52951,52952,52953,52954,52955,52956,52957,52958,52959,52960,52961,52962,52963,52966,52967,52969,52970,52973,52974,52975,52976,52977,52978,52979,52982,52986,52987,52988,52989,52990,52991,44032,44033,44036,44039,44040,44041,44042,44048,44049,44050,44051,44052,44053,44054,44055,44057,44058,44059,44060,44061,44064,44068,44076,44077,44079,44080,44081,44088,44089,44092,44096,44107,44109,44116,44120,44124,44144,44145,44148,44151,44152,44154,44160,44161,44163,44164,44165,44166,44169,44170,44171,44172,44176,44180,44188,44189,44191,44192,44193,44200,44201,44202,44204,44207,44208,44216,44217,44219,44220,44221,44225,44228,44232,44236,44245,44247,44256,44257,44260,44263,44264,44266,44268,44271,44272,44273,44275,44277,44278,44284,44285,44288,44292,44294,52994,52995,52997,52998,52999,53001,53002,53003,53004,53005,53006,53007,53010,53012,53014,53015,53016,53017,53018,53019,53021,53022,53023,53025,53026,53027,null,null,null,null,null,null,53029,53030,53031,53032,53033,53034,53035,53038,53042,53043,53044,53045,53046,53047,53049,53050,53051,53052,53053,53054,53055,53056,53057,53058,53059,53060,null,null,null,null,null,null,53061,53062,53063,53064,53065,53066,53067,53068,53069,53070,53071,53072,53073,53074,53075,53078,53079,53081,53082,53083,53085,53086,53087,53088,53089,53090,53091,53094,53096,53098,53099,53100,44300,44301,44303,44305,44312,44316,44320,44329,44332,44333,44340,44341,44344,44348,44356,44357,44359,44361,44368,44372,44376,44385,44387,44396,44397,44400,44403,44404,44405,44406,44411,44412,44413,44415,44417,44418,44424,44425,44428,44432,44444,44445,44452,44471,44480,44481,44484,44488,44496,44497,44499,44508,44512,44516,44536,44537,44540,44543,44544,44545,44552,44553,44555,44557,44564,44592,44593,44596,44599,44600,44602,44608,44609,44611,44613,44614,44618,44620,44621,44622,44624,44628,44630,44636,44637,44639,44640,44641,44645,44648,44649,44652,44656,44664,53101,53102,53103,53106,53107,53109,53110,53111,53113,53114,53115,53116,53117,53118,53119,53121,53122,53123,53124,53126,53127,53128,53129,53130,53131,53133,null,null,null,null,null,null,53134,53135,53136,53137,53138,53139,53140,53141,53142,53143,53144,53145,53146,53147,53148,53149,53150,53151,53152,53154,53155,53156,53157,53158,53159,53161,null,null,null,null,null,null,53162,53163,53164,53165,53166,53167,53169,53170,53171,53172,53173,53174,53175,53176,53177,53178,53179,53180,53181,53182,53183,53184,53185,53186,53187,53189,53190,53191,53192,53193,53194,53195,44665,44667,44668,44669,44676,44677,44684,44732,44733,44734,44736,44740,44748,44749,44751,44752,44753,44760,44761,44764,44776,44779,44781,44788,44792,44796,44807,44808,44813,44816,44844,44845,44848,44850,44852,44860,44861,44863,44865,44866,44867,44872,44873,44880,44892,44893,44900,44901,44921,44928,44932,44936,44944,44945,44949,44956,44984,44985,44988,44992,44999,45000,45001,45003,45005,45006,45012,45020,45032,45033,45040,45041,45044,45048,45056,45057,45060,45068,45072,45076,45084,45085,45096,45124,45125,45128,45130,45132,45134,45139,45140,45141,45143,45145,53196,53197,53198,53199,53200,53201,53202,53203,53204,53205,53206,53207,53208,53209,53210,53211,53212,53213,53214,53215,53218,53219,53221,53222,53223,53225,null,null,null,null,null,null,53226,53227,53228,53229,53230,53231,53234,53236,53238,53239,53240,53241,53242,53243,53245,53246,53247,53249,53250,53251,53253,53254,53255,53256,53257,53258,null,null,null,null,null,null,53259,53260,53261,53262,53263,53264,53266,53267,53268,53269,53270,53271,53273,53274,53275,53276,53277,53278,53279,53280,53281,53282,53283,53284,53285,53286,53287,53288,53289,53290,53291,53292,45149,45180,45181,45184,45188,45196,45197,45199,45201,45208,45209,45210,45212,45215,45216,45217,45218,45224,45225,45227,45228,45229,45230,45231,45233,45235,45236,45237,45240,45244,45252,45253,45255,45256,45257,45264,45265,45268,45272,45280,45285,45320,45321,45323,45324,45328,45330,45331,45336,45337,45339,45340,45341,45347,45348,45349,45352,45356,45364,45365,45367,45368,45369,45376,45377,45380,45384,45392,45393,45396,45397,45400,45404,45408,45432,45433,45436,45440,45442,45448,45449,45451,45453,45458,45459,45460,45464,45468,45480,45516,45520,45524,45532,45533,53294,53295,53296,53297,53298,53299,53302,53303,53305,53306,53307,53309,53310,53311,53312,53313,53314,53315,53318,53320,53322,53323,53324,53325,53326,53327,null,null,null,null,null,null,53329,53330,53331,53333,53334,53335,53337,53338,53339,53340,53341,53342,53343,53345,53346,53347,53348,53349,53350,53351,53352,53353,53354,53355,53358,53359,null,null,null,null,null,null,53361,53362,53363,53365,53366,53367,53368,53369,53370,53371,53374,53375,53376,53378,53379,53380,53381,53382,53383,53384,53385,53386,53387,53388,53389,53390,53391,53392,53393,53394,53395,53396,45535,45544,45545,45548,45552,45561,45563,45565,45572,45573,45576,45579,45580,45588,45589,45591,45593,45600,45620,45628,45656,45660,45664,45672,45673,45684,45685,45692,45700,45701,45705,45712,45713,45716,45720,45721,45722,45728,45729,45731,45733,45734,45738,45740,45744,45748,45768,45769,45772,45776,45778,45784,45785,45787,45789,45794,45796,45797,45798,45800,45803,45804,45805,45806,45807,45811,45812,45813,45815,45816,45817,45818,45819,45823,45824,45825,45828,45832,45840,45841,45843,45844,45845,45852,45908,45909,45910,45912,45915,45916,45918,45919,45924,45925,53397,53398,53399,53400,53401,53402,53403,53404,53405,53406,53407,53408,53409,53410,53411,53414,53415,53417,53418,53419,53421,53422,53423,53424,53425,53426,null,null,null,null,null,null,53427,53430,53432,53434,53435,53436,53437,53438,53439,53442,53443,53445,53446,53447,53450,53451,53452,53453,53454,53455,53458,53462,53463,53464,53465,53466,null,null,null,null,null,null,53467,53470,53471,53473,53474,53475,53477,53478,53479,53480,53481,53482,53483,53486,53490,53491,53492,53493,53494,53495,53497,53498,53499,53500,53501,53502,53503,53504,53505,53506,53507,53508,45927,45929,45931,45934,45936,45937,45940,45944,45952,45953,45955,45956,45957,45964,45968,45972,45984,45985,45992,45996,46020,46021,46024,46027,46028,46030,46032,46036,46037,46039,46041,46043,46045,46048,46052,46056,46076,46096,46104,46108,46112,46120,46121,46123,46132,46160,46161,46164,46168,46176,46177,46179,46181,46188,46208,46216,46237,46244,46248,46252,46261,46263,46265,46272,46276,46280,46288,46293,46300,46301,46304,46307,46308,46310,46316,46317,46319,46321,46328,46356,46357,46360,46363,46364,46372,46373,46375,46376,46377,46378,46384,46385,46388,46392,53509,53510,53511,53512,53513,53514,53515,53516,53518,53519,53520,53521,53522,53523,53524,53525,53526,53527,53528,53529,53530,53531,53532,53533,53534,53535,null,null,null,null,null,null,53536,53537,53538,53539,53540,53541,53542,53543,53544,53545,53546,53547,53548,53549,53550,53551,53554,53555,53557,53558,53559,53561,53563,53564,53565,53566,null,null,null,null,null,null,53567,53570,53574,53575,53576,53577,53578,53579,53582,53583,53585,53586,53587,53589,53590,53591,53592,53593,53594,53595,53598,53600,53602,53603,53604,53605,53606,53607,53609,53610,53611,53613,46400,46401,46403,46404,46405,46411,46412,46413,46416,46420,46428,46429,46431,46432,46433,46496,46497,46500,46504,46506,46507,46512,46513,46515,46516,46517,46523,46524,46525,46528,46532,46540,46541,46543,46544,46545,46552,46572,46608,46609,46612,46616,46629,46636,46644,46664,46692,46696,46748,46749,46752,46756,46763,46764,46769,46804,46832,46836,46840,46848,46849,46853,46888,46889,46892,46895,46896,46904,46905,46907,46916,46920,46924,46932,46933,46944,46948,46952,46960,46961,46963,46965,46972,46973,46976,46980,46988,46989,46991,46992,46993,46994,46998,46999,53614,53615,53616,53617,53618,53619,53620,53621,53622,53623,53624,53625,53626,53627,53629,53630,53631,53632,53633,53634,53635,53637,53638,53639,53641,53642,null,null,null,null,null,null,53643,53644,53645,53646,53647,53648,53649,53650,53651,53652,53653,53654,53655,53656,53657,53658,53659,53660,53661,53662,53663,53666,53667,53669,53670,53671,null,null,null,null,null,null,53673,53674,53675,53676,53677,53678,53679,53682,53684,53686,53687,53688,53689,53691,53693,53694,53695,53697,53698,53699,53700,53701,53702,53703,53704,53705,53706,53707,53708,53709,53710,53711,47000,47001,47004,47008,47016,47017,47019,47020,47021,47028,47029,47032,47047,47049,47084,47085,47088,47092,47100,47101,47103,47104,47105,47111,47112,47113,47116,47120,47128,47129,47131,47133,47140,47141,47144,47148,47156,47157,47159,47160,47161,47168,47172,47185,47187,47196,47197,47200,47204,47212,47213,47215,47217,47224,47228,47245,47272,47280,47284,47288,47296,47297,47299,47301,47308,47312,47316,47325,47327,47329,47336,47337,47340,47344,47352,47353,47355,47357,47364,47384,47392,47420,47421,47424,47428,47436,47439,47441,47448,47449,47452,47456,47464,47465,53712,53713,53714,53715,53716,53717,53718,53719,53721,53722,53723,53724,53725,53726,53727,53728,53729,53730,53731,53732,53733,53734,53735,53736,53737,53738,null,null,null,null,null,null,53739,53740,53741,53742,53743,53744,53745,53746,53747,53749,53750,53751,53753,53754,53755,53756,53757,53758,53759,53760,53761,53762,53763,53764,53765,53766,null,null,null,null,null,null,53768,53770,53771,53772,53773,53774,53775,53777,53778,53779,53780,53781,53782,53783,53784,53785,53786,53787,53788,53789,53790,53791,53792,53793,53794,53795,53796,53797,53798,53799,53800,53801,47467,47469,47476,47477,47480,47484,47492,47493,47495,47497,47498,47501,47502,47532,47533,47536,47540,47548,47549,47551,47553,47560,47561,47564,47566,47567,47568,47569,47570,47576,47577,47579,47581,47582,47585,47587,47588,47589,47592,47596,47604,47605,47607,47608,47609,47610,47616,47617,47624,47637,47672,47673,47676,47680,47682,47688,47689,47691,47693,47694,47699,47700,47701,47704,47708,47716,47717,47719,47720,47721,47728,47729,47732,47736,47747,47748,47749,47751,47756,47784,47785,47787,47788,47792,47794,47800,47801,47803,47805,47812,47816,47832,47833,47868,53802,53803,53806,53807,53809,53810,53811,53813,53814,53815,53816,53817,53818,53819,53822,53824,53826,53827,53828,53829,53830,53831,53833,53834,53835,53836,null,null,null,null,null,null,53837,53838,53839,53840,53841,53842,53843,53844,53845,53846,53847,53848,53849,53850,53851,53853,53854,53855,53856,53857,53858,53859,53861,53862,53863,53864,null,null,null,null,null,null,53865,53866,53867,53868,53869,53870,53871,53872,53873,53874,53875,53876,53877,53878,53879,53880,53881,53882,53883,53884,53885,53886,53887,53890,53891,53893,53894,53895,53897,53898,53899,53900,47872,47876,47885,47887,47889,47896,47900,47904,47913,47915,47924,47925,47926,47928,47931,47932,47933,47934,47940,47941,47943,47945,47949,47951,47952,47956,47960,47969,47971,47980,48008,48012,48016,48036,48040,48044,48052,48055,48064,48068,48072,48080,48083,48120,48121,48124,48127,48128,48130,48136,48137,48139,48140,48141,48143,48145,48148,48149,48150,48151,48152,48155,48156,48157,48158,48159,48164,48165,48167,48169,48173,48176,48177,48180,48184,48192,48193,48195,48196,48197,48201,48204,48205,48208,48221,48260,48261,48264,48267,48268,48270,48276,48277,48279,53901,53902,53903,53906,53907,53908,53910,53911,53912,53913,53914,53915,53917,53918,53919,53921,53922,53923,53925,53926,53927,53928,53929,53930,53931,53933,null,null,null,null,null,null,53934,53935,53936,53938,53939,53940,53941,53942,53943,53946,53947,53949,53950,53953,53955,53956,53957,53958,53959,53962,53964,53965,53966,53967,53968,53969,null,null,null,null,null,null,53970,53971,53973,53974,53975,53977,53978,53979,53981,53982,53983,53984,53985,53986,53987,53990,53991,53992,53993,53994,53995,53996,53997,53998,53999,54002,54003,54005,54006,54007,54009,54010,48281,48282,48288,48289,48292,48295,48296,48304,48305,48307,48308,48309,48316,48317,48320,48324,48333,48335,48336,48337,48341,48344,48348,48372,48373,48374,48376,48380,48388,48389,48391,48393,48400,48404,48420,48428,48448,48456,48457,48460,48464,48472,48473,48484,48488,48512,48513,48516,48519,48520,48521,48522,48528,48529,48531,48533,48537,48538,48540,48548,48560,48568,48596,48597,48600,48604,48617,48624,48628,48632,48640,48643,48645,48652,48653,48656,48660,48668,48669,48671,48708,48709,48712,48716,48718,48724,48725,48727,48729,48730,48731,48736,48737,48740,54011,54012,54013,54014,54015,54018,54020,54022,54023,54024,54025,54026,54027,54031,54033,54034,54035,54037,54039,54040,54041,54042,54043,54046,54050,54051,null,null,null,null,null,null,54052,54054,54055,54058,54059,54061,54062,54063,54065,54066,54067,54068,54069,54070,54071,54074,54078,54079,54080,54081,54082,54083,54086,54087,54088,54089,null,null,null,null,null,null,54090,54091,54092,54093,54094,54095,54096,54097,54098,54099,54100,54101,54102,54103,54104,54105,54106,54107,54108,54109,54110,54111,54112,54113,54114,54115,54116,54117,54118,54119,54120,54121,48744,48746,48752,48753,48755,48756,48757,48763,48764,48765,48768,48772,48780,48781,48783,48784,48785,48792,48793,48808,48848,48849,48852,48855,48856,48864,48867,48868,48869,48876,48897,48904,48905,48920,48921,48923,48924,48925,48960,48961,48964,48968,48976,48977,48981,49044,49072,49093,49100,49101,49104,49108,49116,49119,49121,49212,49233,49240,49244,49248,49256,49257,49296,49297,49300,49304,49312,49313,49315,49317,49324,49325,49327,49328,49331,49332,49333,49334,49340,49341,49343,49344,49345,49349,49352,49353,49356,49360,49368,49369,49371,49372,49373,49380,54122,54123,54124,54125,54126,54127,54128,54129,54130,54131,54132,54133,54134,54135,54136,54137,54138,54139,54142,54143,54145,54146,54147,54149,54150,54151,null,null,null,null,null,null,54152,54153,54154,54155,54158,54162,54163,54164,54165,54166,54167,54170,54171,54173,54174,54175,54177,54178,54179,54180,54181,54182,54183,54186,54188,54190,null,null,null,null,null,null,54191,54192,54193,54194,54195,54197,54198,54199,54201,54202,54203,54205,54206,54207,54208,54209,54210,54211,54214,54215,54218,54219,54220,54221,54222,54223,54225,54226,54227,54228,54229,54230,49381,49384,49388,49396,49397,49399,49401,49408,49412,49416,49424,49429,49436,49437,49438,49439,49440,49443,49444,49446,49447,49452,49453,49455,49456,49457,49462,49464,49465,49468,49472,49480,49481,49483,49484,49485,49492,49493,49496,49500,49508,49509,49511,49512,49513,49520,49524,49528,49541,49548,49549,49550,49552,49556,49558,49564,49565,49567,49569,49573,49576,49577,49580,49584,49597,49604,49608,49612,49620,49623,49624,49632,49636,49640,49648,49649,49651,49660,49661,49664,49668,49676,49677,49679,49681,49688,49689,49692,49695,49696,49704,49705,49707,49709,54231,54233,54234,54235,54236,54237,54238,54239,54240,54242,54244,54245,54246,54247,54248,54249,54250,54251,54254,54255,54257,54258,54259,54261,54262,54263,null,null,null,null,null,null,54264,54265,54266,54267,54270,54272,54274,54275,54276,54277,54278,54279,54281,54282,54283,54284,54285,54286,54287,54288,54289,54290,54291,54292,54293,54294,null,null,null,null,null,null,54295,54296,54297,54298,54299,54300,54302,54303,54304,54305,54306,54307,54308,54309,54310,54311,54312,54313,54314,54315,54316,54317,54318,54319,54320,54321,54322,54323,54324,54325,54326,54327,49711,49713,49714,49716,49736,49744,49745,49748,49752,49760,49765,49772,49773,49776,49780,49788,49789,49791,49793,49800,49801,49808,49816,49819,49821,49828,49829,49832,49836,49837,49844,49845,49847,49849,49884,49885,49888,49891,49892,49899,49900,49901,49903,49905,49910,49912,49913,49915,49916,49920,49928,49929,49932,49933,49939,49940,49941,49944,49948,49956,49957,49960,49961,49989,50024,50025,50028,50032,50034,50040,50041,50044,50045,50052,50056,50060,50112,50136,50137,50140,50143,50144,50146,50152,50153,50157,50164,50165,50168,50184,50192,50212,50220,50224,54328,54329,54330,54331,54332,54333,54334,54335,54337,54338,54339,54341,54342,54343,54344,54345,54346,54347,54348,54349,54350,54351,54352,54353,54354,54355,null,null,null,null,null,null,54356,54357,54358,54359,54360,54361,54362,54363,54365,54366,54367,54369,54370,54371,54373,54374,54375,54376,54377,54378,54379,54380,54382,54384,54385,54386,null,null,null,null,null,null,54387,54388,54389,54390,54391,54394,54395,54397,54398,54401,54403,54404,54405,54406,54407,54410,54412,54414,54415,54416,54417,54418,54419,54421,54422,54423,54424,54425,54426,54427,54428,54429,50228,50236,50237,50248,50276,50277,50280,50284,50292,50293,50297,50304,50324,50332,50360,50364,50409,50416,50417,50420,50424,50426,50431,50432,50433,50444,50448,50452,50460,50472,50473,50476,50480,50488,50489,50491,50493,50500,50501,50504,50505,50506,50508,50509,50510,50515,50516,50517,50519,50520,50521,50525,50526,50528,50529,50532,50536,50544,50545,50547,50548,50549,50556,50557,50560,50564,50567,50572,50573,50575,50577,50581,50583,50584,50588,50592,50601,50612,50613,50616,50617,50619,50620,50621,50622,50628,50629,50630,50631,50632,50633,50634,50636,50638,54430,54431,54432,54433,54434,54435,54436,54437,54438,54439,54440,54442,54443,54444,54445,54446,54447,54448,54449,54450,54451,54452,54453,54454,54455,54456,null,null,null,null,null,null,54457,54458,54459,54460,54461,54462,54463,54464,54465,54466,54467,54468,54469,54470,54471,54472,54473,54474,54475,54477,54478,54479,54481,54482,54483,54485,null,null,null,null,null,null,54486,54487,54488,54489,54490,54491,54493,54494,54496,54497,54498,54499,54500,54501,54502,54503,54505,54506,54507,54509,54510,54511,54513,54514,54515,54516,54517,54518,54519,54521,54522,54524,50640,50641,50644,50648,50656,50657,50659,50661,50668,50669,50670,50672,50676,50678,50679,50684,50685,50686,50687,50688,50689,50693,50694,50695,50696,50700,50704,50712,50713,50715,50716,50724,50725,50728,50732,50733,50734,50736,50739,50740,50741,50743,50745,50747,50752,50753,50756,50760,50768,50769,50771,50772,50773,50780,50781,50784,50796,50799,50801,50808,50809,50812,50816,50824,50825,50827,50829,50836,50837,50840,50844,50852,50853,50855,50857,50864,50865,50868,50872,50873,50874,50880,50881,50883,50885,50892,50893,50896,50900,50908,50909,50912,50913,50920,54526,54527,54528,54529,54530,54531,54533,54534,54535,54537,54538,54539,54541,54542,54543,54544,54545,54546,54547,54550,54552,54553,54554,54555,54556,54557,null,null,null,null,null,null,54558,54559,54560,54561,54562,54563,54564,54565,54566,54567,54568,54569,54570,54571,54572,54573,54574,54575,54576,54577,54578,54579,54580,54581,54582,54583,null,null,null,null,null,null,54584,54585,54586,54587,54590,54591,54593,54594,54595,54597,54598,54599,54600,54601,54602,54603,54606,54608,54610,54611,54612,54613,54614,54615,54618,54619,54621,54622,54623,54625,54626,54627,50921,50924,50928,50936,50937,50941,50948,50949,50952,50956,50964,50965,50967,50969,50976,50977,50980,50984,50992,50993,50995,50997,50999,51004,51005,51008,51012,51018,51020,51021,51023,51025,51026,51027,51028,51029,51030,51031,51032,51036,51040,51048,51051,51060,51061,51064,51068,51069,51070,51075,51076,51077,51079,51080,51081,51082,51086,51088,51089,51092,51094,51095,51096,51098,51104,51105,51107,51108,51109,51110,51116,51117,51120,51124,51132,51133,51135,51136,51137,51144,51145,51148,51150,51152,51160,51165,51172,51176,51180,51200,51201,51204,51208,51210,54628,54630,54631,54634,54636,54638,54639,54640,54641,54642,54643,54646,54647,54649,54650,54651,54653,54654,54655,54656,54657,54658,54659,54662,54666,54667,null,null,null,null,null,null,54668,54669,54670,54671,54673,54674,54675,54676,54677,54678,54679,54680,54681,54682,54683,54684,54685,54686,54687,54688,54689,54690,54691,54692,54694,54695,null,null,null,null,null,null,54696,54697,54698,54699,54700,54701,54702,54703,54704,54705,54706,54707,54708,54709,54710,54711,54712,54713,54714,54715,54716,54717,54718,54719,54720,54721,54722,54723,54724,54725,54726,54727,51216,51217,51219,51221,51222,51228,51229,51232,51236,51244,51245,51247,51249,51256,51260,51264,51272,51273,51276,51277,51284,51312,51313,51316,51320,51322,51328,51329,51331,51333,51334,51335,51339,51340,51341,51348,51357,51359,51361,51368,51388,51389,51396,51400,51404,51412,51413,51415,51417,51424,51425,51428,51445,51452,51453,51456,51460,51461,51462,51468,51469,51471,51473,51480,51500,51508,51536,51537,51540,51544,51552,51553,51555,51564,51568,51572,51580,51592,51593,51596,51600,51608,51609,51611,51613,51648,51649,51652,51655,51656,51658,51664,51665,51667,54730,54731,54733,54734,54735,54737,54739,54740,54741,54742,54743,54746,54748,54750,54751,54752,54753,54754,54755,54758,54759,54761,54762,54763,54765,54766,null,null,null,null,null,null,54767,54768,54769,54770,54771,54774,54776,54778,54779,54780,54781,54782,54783,54786,54787,54789,54790,54791,54793,54794,54795,54796,54797,54798,54799,54802,null,null,null,null,null,null,54806,54807,54808,54809,54810,54811,54813,54814,54815,54817,54818,54819,54821,54822,54823,54824,54825,54826,54827,54828,54830,54831,54832,54833,54834,54835,54836,54837,54838,54839,54842,54843,51669,51670,51673,51674,51676,51677,51680,51682,51684,51687,51692,51693,51695,51696,51697,51704,51705,51708,51712,51720,51721,51723,51724,51725,51732,51736,51753,51788,51789,51792,51796,51804,51805,51807,51808,51809,51816,51837,51844,51864,51900,51901,51904,51908,51916,51917,51919,51921,51923,51928,51929,51936,51948,51956,51976,51984,51988,51992,52000,52001,52033,52040,52041,52044,52048,52056,52057,52061,52068,52088,52089,52124,52152,52180,52196,52199,52201,52236,52237,52240,52244,52252,52253,52257,52258,52263,52264,52265,52268,52270,52272,52280,52281,52283,54845,54846,54847,54849,54850,54851,54852,54854,54855,54858,54860,54862,54863,54864,54866,54867,54870,54871,54873,54874,54875,54877,54878,54879,54880,54881,null,null,null,null,null,null,54882,54883,54884,54885,54886,54888,54890,54891,54892,54893,54894,54895,54898,54899,54901,54902,54903,54904,54905,54906,54907,54908,54909,54910,54911,54912,null,null,null,null,null,null,54913,54914,54916,54918,54919,54920,54921,54922,54923,54926,54927,54929,54930,54931,54933,54934,54935,54936,54937,54938,54939,54940,54942,54944,54946,54947,54948,54949,54950,54951,54953,54954,52284,52285,52286,52292,52293,52296,52300,52308,52309,52311,52312,52313,52320,52324,52326,52328,52336,52341,52376,52377,52380,52384,52392,52393,52395,52396,52397,52404,52405,52408,52412,52420,52421,52423,52425,52432,52436,52452,52460,52464,52481,52488,52489,52492,52496,52504,52505,52507,52509,52516,52520,52524,52537,52572,52576,52580,52588,52589,52591,52593,52600,52616,52628,52629,52632,52636,52644,52645,52647,52649,52656,52676,52684,52688,52712,52716,52720,52728,52729,52731,52733,52740,52744,52748,52756,52761,52768,52769,52772,52776,52784,52785,52787,52789,54955,54957,54958,54959,54961,54962,54963,54964,54965,54966,54967,54968,54970,54972,54973,54974,54975,54976,54977,54978,54979,54982,54983,54985,54986,54987,null,null,null,null,null,null,54989,54990,54991,54992,54994,54995,54997,54998,55000,55002,55003,55004,55005,55006,55007,55009,55010,55011,55013,55014,55015,55017,55018,55019,55020,55021,null,null,null,null,null,null,55022,55023,55025,55026,55027,55028,55030,55031,55032,55033,55034,55035,55038,55039,55041,55042,55043,55045,55046,55047,55048,55049,55050,55051,55052,55053,55054,55055,55056,55058,55059,55060,52824,52825,52828,52831,52832,52833,52840,52841,52843,52845,52852,52853,52856,52860,52868,52869,52871,52873,52880,52881,52884,52888,52896,52897,52899,52900,52901,52908,52909,52929,52964,52965,52968,52971,52972,52980,52981,52983,52984,52985,52992,52993,52996,53000,53008,53009,53011,53013,53020,53024,53028,53036,53037,53039,53040,53041,53048,53076,53077,53080,53084,53092,53093,53095,53097,53104,53105,53108,53112,53120,53125,53132,53153,53160,53168,53188,53216,53217,53220,53224,53232,53233,53235,53237,53244,53248,53252,53265,53272,53293,53300,53301,53304,53308,55061,55062,55063,55066,55067,55069,55070,55071,55073,55074,55075,55076,55077,55078,55079,55082,55084,55086,55087,55088,55089,55090,55091,55094,55095,55097,null,null,null,null,null,null,55098,55099,55101,55102,55103,55104,55105,55106,55107,55109,55110,55112,55114,55115,55116,55117,55118,55119,55122,55123,55125,55130,55131,55132,55133,55134,null,null,null,null,null,null,55135,55138,55140,55142,55143,55144,55146,55147,55149,55150,55151,55153,55154,55155,55157,55158,55159,55160,55161,55162,55163,55166,55167,55168,55170,55171,55172,55173,55174,55175,55178,55179,53316,53317,53319,53321,53328,53332,53336,53344,53356,53357,53360,53364,53372,53373,53377,53412,53413,53416,53420,53428,53429,53431,53433,53440,53441,53444,53448,53449,53456,53457,53459,53460,53461,53468,53469,53472,53476,53484,53485,53487,53488,53489,53496,53517,53552,53553,53556,53560,53562,53568,53569,53571,53572,53573,53580,53581,53584,53588,53596,53597,53599,53601,53608,53612,53628,53636,53640,53664,53665,53668,53672,53680,53681,53683,53685,53690,53692,53696,53720,53748,53752,53767,53769,53776,53804,53805,53808,53812,53820,53821,53823,53825,53832,53852,55181,55182,55183,55185,55186,55187,55188,55189,55190,55191,55194,55196,55198,55199,55200,55201,55202,55203,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,53860,53888,53889,53892,53896,53904,53905,53909,53916,53920,53924,53932,53937,53944,53945,53948,53951,53952,53954,53960,53961,53963,53972,53976,53980,53988,53989,54000,54001,54004,54008,54016,54017,54019,54021,54028,54029,54030,54032,54036,54038,54044,54045,54047,54048,54049,54053,54056,54057,54060,54064,54072,54073,54075,54076,54077,54084,54085,54140,54141,54144,54148,54156,54157,54159,54160,54161,54168,54169,54172,54176,54184,54185,54187,54189,54196,54200,54204,54212,54213,54216,54217,54224,54232,54241,54243,54252,54253,54256,54260,54268,54269,54271,54273,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54280,54301,54336,54340,54364,54368,54372,54381,54383,54392,54393,54396,54399,54400,54402,54408,54409,54411,54413,54420,54441,54476,54480,54484,54492,54495,54504,54508,54512,54520,54523,54525,54532,54536,54540,54548,54549,54551,54588,54589,54592,54596,54604,54605,54607,54609,54616,54617,54620,54624,54629,54632,54633,54635,54637,54644,54645,54648,54652,54660,54661,54663,54664,54665,54672,54693,54728,54729,54732,54736,54738,54744,54745,54747,54749,54756,54757,54760,54764,54772,54773,54775,54777,54784,54785,54788,54792,54800,54801,54803,54804,54805,54812,54816,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54820,54829,54840,54841,54844,54848,54853,54856,54857,54859,54861,54865,54868,54869,54872,54876,54887,54889,54896,54897,54900,54915,54917,54924,54925,54928,54932,54941,54943,54945,54952,54956,54960,54969,54971,54980,54981,54984,54988,54993,54996,54999,55001,55008,55012,55016,55024,55029,55036,55037,55040,55044,55057,55064,55065,55068,55072,55080,55081,55083,55085,55092,55093,55096,55100,55108,55111,55113,55120,55121,55124,55126,55127,55128,55129,55136,55137,55139,55141,55145,55148,55152,55156,55164,55165,55169,55176,55177,55180,55184,55192,55193,55195,55197,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20285,20339,20551,20729,21152,21487,21621,21733,22025,23233,23478,26247,26550,26551,26607,27468,29634,30146,31292,33499,33540,34903,34952,35382,36040,36303,36603,36838,39381,21051,21364,21508,24682,24932,27580,29647,33050,35258,35282,38307,20355,21002,22718,22904,23014,24178,24185,25031,25536,26438,26604,26751,28567,30286,30475,30965,31240,31487,31777,32925,33390,33393,35563,38291,20075,21917,26359,28212,30883,31469,33883,35088,34638,38824,21208,22350,22570,23884,24863,25022,25121,25954,26577,27204,28187,29976,30131,30435,30640,32058,37039,37969,37970,40853,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21283,23724,30002,32987,37440,38296,21083,22536,23004,23713,23831,24247,24378,24394,24951,27743,30074,30086,31968,32115,32177,32652,33108,33313,34193,35137,35611,37628,38477,40007,20171,20215,20491,20977,22607,24887,24894,24936,25913,27114,28433,30117,30342,30422,31623,33445,33995,63744,37799,38283,21888,23458,22353,63745,31923,32697,37301,20520,21435,23621,24040,25298,25454,25818,25831,28192,28844,31067,36317,36382,63746,36989,37445,37624,20094,20214,20581,24062,24314,24838,26967,33137,34388,36423,37749,39467,20062,20625,26480,26688,20745,21133,21138,27298,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30652,37392,40660,21163,24623,36850,20552,25001,25581,25802,26684,27268,28608,33160,35233,38548,22533,29309,29356,29956,32121,32365,32937,35211,35700,36963,40273,25225,27770,28500,32080,32570,35363,20860,24906,31645,35609,37463,37772,20140,20435,20510,20670,20742,21185,21197,21375,22384,22659,24218,24465,24950,25004,25806,25964,26223,26299,26356,26775,28039,28805,28913,29855,29861,29898,30169,30828,30956,31455,31478,32069,32147,32789,32831,33051,33686,35686,36629,36885,37857,38915,38968,39514,39912,20418,21843,22586,22865,23395,23622,24760,25106,26690,26800,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26856,28330,30028,30328,30926,31293,31995,32363,32380,35336,35489,35903,38542,40388,21476,21481,21578,21617,22266,22993,23396,23611,24235,25335,25911,25925,25970,26272,26543,27073,27837,30204,30352,30590,31295,32660,32771,32929,33167,33510,33533,33776,34241,34865,34996,35493,63747,36764,37678,38599,39015,39640,40723,21741,26011,26354,26767,31296,35895,40288,22256,22372,23825,26118,26801,26829,28414,29736,34974,39908,27752,63748,39592,20379,20844,20849,21151,23380,24037,24656,24685,25329,25511,25915,29657,31354,34467,36002,38799,20018,23521,25096,26524,29916,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31185,33747,35463,35506,36328,36942,37707,38982,24275,27112,34303,37101,63749,20896,23448,23532,24931,26874,27454,28748,29743,29912,31649,32592,33733,35264,36011,38364,39208,21038,24669,25324,36866,20362,20809,21281,22745,24291,26336,27960,28826,29378,29654,31568,33009,37979,21350,25499,32619,20054,20608,22602,22750,24618,24871,25296,27088,39745,23439,32024,32945,36703,20132,20689,21676,21932,23308,23968,24039,25898,25934,26657,27211,29409,30350,30703,32094,32761,33184,34126,34527,36611,36686,37066,39171,39509,39851,19992,20037,20061,20167,20465,20855,21246,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21312,21475,21477,21646,22036,22389,22434,23495,23943,24272,25084,25304,25937,26552,26601,27083,27472,27590,27628,27714,28317,28792,29399,29590,29699,30655,30697,31350,32127,32777,33276,33285,33290,33503,34914,35635,36092,36544,36881,37041,37476,37558,39378,39493,40169,40407,40860,22283,23616,33738,38816,38827,40628,21531,31384,32676,35033,36557,37089,22528,23624,25496,31391,23470,24339,31353,31406,33422,36524,20518,21048,21240,21367,22280,25331,25458,27402,28099,30519,21413,29527,34152,36470,38357,26426,27331,28528,35437,36556,39243,63750,26231,27512,36020,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39740,63751,21483,22317,22862,25542,27131,29674,30789,31418,31429,31998,33909,35215,36211,36917,38312,21243,22343,30023,31584,33740,37406,63752,27224,20811,21067,21127,25119,26840,26997,38553,20677,21156,21220,25027,26020,26681,27135,29822,31563,33465,33771,35250,35641,36817,39241,63753,20170,22935,25810,26129,27278,29748,31105,31165,33449,34942,34943,35167,63754,37670,20235,21450,24613,25201,27762,32026,32102,20120,20834,30684,32943,20225,20238,20854,20864,21980,22120,22331,22522,22524,22804,22855,22931,23492,23696,23822,24049,24190,24524,25216,26071,26083,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26398,26399,26462,26827,26820,27231,27450,27683,27773,27778,28103,29592,29734,29738,29826,29859,30072,30079,30849,30959,31041,31047,31048,31098,31637,32000,32186,32648,32774,32813,32908,35352,35663,35912,36215,37665,37668,39138,39249,39438,39439,39525,40594,32202,20342,21513,25326,26708,37329,21931,20794,63755,63756,23068,25062,63757,25295,25343,63758,63759,63760,63761,63762,63763,37027,63764,63765,63766,63767,63768,35582,63769,63770,63771,63772,26262,63773,29014,63774,63775,38627,63776,25423,25466,21335,63777,26511,26976,28275,63778,30007,63779,63780,63781,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32013,63782,63783,34930,22218,23064,63784,63785,63786,63787,63788,20035,63789,20839,22856,26608,32784,63790,22899,24180,25754,31178,24565,24684,25288,25467,23527,23511,21162,63791,22900,24361,24594,63792,63793,63794,29785,63795,63796,63797,63798,63799,63800,39377,63801,63802,63803,63804,63805,63806,63807,63808,63809,63810,63811,28611,63812,63813,33215,36786,24817,63814,63815,33126,63816,63817,23615,63818,63819,63820,63821,63822,63823,63824,63825,23273,35365,26491,32016,63826,63827,63828,63829,63830,63831,33021,63832,63833,23612,27877,21311,28346,22810,33590,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20025,20150,20294,21934,22296,22727,24406,26039,26086,27264,27573,28237,30701,31471,31774,32222,34507,34962,37170,37723,25787,28606,29562,30136,36948,21846,22349,25018,25812,26311,28129,28251,28525,28601,30192,32835,33213,34113,35203,35527,35674,37663,27795,30035,31572,36367,36957,21776,22530,22616,24162,25095,25758,26848,30070,31958,34739,40680,20195,22408,22382,22823,23565,23729,24118,24453,25140,25825,29619,33274,34955,36024,38538,40667,23429,24503,24755,20498,20992,21040,22294,22581,22615,23566,23648,23798,23947,24230,24466,24764,25361,25481,25623,26691,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26873,27330,28120,28193,28372,28644,29182,30428,30585,31153,31291,33796,35241,36077,36339,36424,36867,36884,36947,37117,37709,38518,38876,27602,28678,29272,29346,29544,30563,31167,31716,32411,35712,22697,24775,25958,26109,26302,27788,28958,29129,35930,38931,20077,31361,20189,20908,20941,21205,21516,24999,26481,26704,26847,27934,28540,30140,30643,31461,33012,33891,37509,20828,26007,26460,26515,30168,31431,33651,63834,35910,36887,38957,23663,33216,33434,36929,36975,37389,24471,23965,27225,29128,30331,31561,34276,35588,37159,39472,21895,25078,63835,30313,32645,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34367,34746,35064,37007,63836,27931,28889,29662,32097,33853,63837,37226,39409,63838,20098,21365,27396,27410,28734,29211,34349,40478,21068,36771,23888,25829,25900,27414,28651,31811,32412,34253,35172,35261,25289,33240,34847,24266,26391,28010,29436,29701,29807,34690,37086,20358,23821,24480,33802,20919,25504,30053,20142,20486,20841,20937,26753,27153,31918,31921,31975,33391,35538,36635,37327,20406,20791,21237,21570,24300,24942,25150,26053,27354,28670,31018,34268,34851,38317,39522,39530,40599,40654,21147,26310,27511,28701,31019,36706,38722,24976,25088,25891,28451,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29001,29833,32244,32879,34030,36646,36899,37706,20925,21015,21155,27916,28872,35010,24265,25986,27566,28610,31806,29557,20196,20278,22265,63839,23738,23994,24604,29618,31533,32666,32718,32838,36894,37428,38646,38728,38936,40801,20363,28583,31150,37300,38583,21214,63840,25736,25796,27347,28510,28696,29200,30439,32769,34310,34396,36335,36613,38706,39791,40442,40565,30860,31103,32160,33737,37636,40575,40595,35542,22751,24324,26407,28711,29903,31840,32894,20769,28712,29282,30922,36034,36058,36084,38647,20102,20698,23534,24278,26009,29134,30274,30637,32842,34044,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36988,39719,40845,22744,23105,23650,27155,28122,28431,30267,32047,32311,34078,35128,37860,38475,21129,26066,26611,27060,27969,28316,28687,29705,29792,30041,30244,30827,35628,39006,20845,25134,38520,20374,20523,23833,28138,32184,36650,24459,24900,26647,63841,38534,21202,32907,20956,20940,26974,31260,32190,33777,38517,20442,21033,21400,21519,21774,23653,24743,26446,26792,28012,29313,29432,29702,29827,63842,30178,31852,32633,32696,33673,35023,35041,37324,37328,38626,39881,21533,28542,29136,29848,34298,36522,38563,40023,40607,26519,28107,29747,33256,38678,30764,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31435,31520,31890,25705,29802,30194,30908,30952,39340,39764,40635,23518,24149,28448,33180,33707,37000,19975,21325,23081,24018,24398,24930,25405,26217,26364,28415,28459,28771,30622,33836,34067,34875,36627,39237,39995,21788,25273,26411,27819,33545,35178,38778,20129,22916,24536,24537,26395,32178,32596,33426,33579,33725,36638,37017,22475,22969,23186,23504,26151,26522,26757,27599,29028,32629,36023,36067,36993,39749,33032,35978,38476,39488,40613,23391,27667,29467,30450,30431,33804,20906,35219,20813,20885,21193,26825,27796,30468,30496,32191,32236,38754,40629,28357,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34065,20901,21517,21629,26126,26269,26919,28319,30399,30609,33559,33986,34719,37225,37528,40180,34946,20398,20882,21215,22982,24125,24917,25720,25721,26286,26576,27169,27597,27611,29279,29281,29761,30520,30683,32791,33468,33541,35584,35624,35980,26408,27792,29287,30446,30566,31302,40361,27519,27794,22818,26406,33945,21359,22675,22937,24287,25551,26164,26483,28218,29483,31447,33495,37672,21209,24043,25006,25035,25098,25287,25771,26080,26969,27494,27595,28961,29687,30045,32326,33310,33538,34154,35491,36031,38695,40289,22696,40664,20497,21006,21563,21839,25991,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27766,32010,32011,32862,34442,38272,38639,21247,27797,29289,21619,23194,23614,23883,24396,24494,26410,26806,26979,28220,28228,30473,31859,32654,34183,35598,36855,38753,40692,23735,24758,24845,25003,25935,26107,26108,27665,27887,29599,29641,32225,38292,23494,34588,35600,21085,21338,25293,25615,25778,26420,27192,27850,29632,29854,31636,31893,32283,33162,33334,34180,36843,38649,39361,20276,21322,21453,21467,25292,25644,25856,26001,27075,27886,28504,29677,30036,30242,30436,30460,30928,30971,31020,32070,33324,34784,36820,38930,39151,21187,25300,25765,28196,28497,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30332,36299,37297,37474,39662,39747,20515,20621,22346,22952,23592,24135,24439,25151,25918,26041,26049,26121,26507,27036,28354,30917,32033,32938,33152,33323,33459,33953,34444,35370,35607,37030,38450,40848,20493,20467,63843,22521,24472,25308,25490,26479,28227,28953,30403,32972,32986,35060,35061,35097,36064,36649,37197,38506,20271,20336,24091,26575,26658,30333,30334,39748,24161,27146,29033,29140,30058,63844,32321,34115,34281,39132,20240,31567,32624,38309,20961,24070,26805,27710,27726,27867,29359,31684,33539,27861,29754,20731,21128,22721,25816,27287,29863,30294,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30887,34327,38370,38713,63845,21342,24321,35722,36776,36783,37002,21029,30629,40009,40712,19993,20482,20853,23643,24183,26142,26170,26564,26821,28851,29953,30149,31177,31453,36647,39200,39432,20445,22561,22577,23542,26222,27493,27921,28282,28541,29668,29995,33769,35036,35091,35676,36628,20239,20693,21264,21340,23443,24489,26381,31119,33145,33583,34068,35079,35206,36665,36667,39333,39954,26412,20086,20472,22857,23553,23791,23792,25447,26834,28925,29090,29739,32299,34028,34562,36898,37586,40179,19981,20184,20463,20613,21078,21103,21542,21648,22496,22827,23142,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23386,23413,23500,24220,63846,25206,25975,26023,28014,28325,29238,31526,31807,32566,33104,33105,33178,33344,33433,33705,35331,36000,36070,36091,36212,36282,37096,37340,38428,38468,39385,40167,21271,20998,21545,22132,22707,22868,22894,24575,24996,25198,26128,27774,28954,30406,31881,31966,32027,33452,36033,38640,63847,20315,24343,24447,25282,23849,26379,26842,30844,32323,40300,19989,20633,21269,21290,21329,22915,23138,24199,24754,24970,25161,25209,26000,26503,27047,27604,27606,27607,27608,27832,63848,29749,30202,30738,30865,31189,31192,31875,32203,32737,32933,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33086,33218,33778,34586,35048,35513,35692,36027,37145,38750,39131,40763,22188,23338,24428,25996,27315,27567,27996,28657,28693,29277,29613,36007,36051,38971,24977,27703,32856,39425,20045,20107,20123,20181,20282,20284,20351,20447,20735,21490,21496,21766,21987,22235,22763,22882,23057,23531,23546,23556,24051,24107,24473,24605,25448,26012,26031,26614,26619,26797,27515,27801,27863,28195,28681,29509,30722,31038,31040,31072,31169,31721,32023,32114,32902,33293,33678,34001,34503,35039,35408,35422,35613,36060,36198,36781,37034,39164,39391,40605,21066,63849,26388,63850,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20632,21034,23665,25955,27733,29642,29987,30109,31639,33948,37240,38704,20087,25746,27578,29022,34217,19977,63851,26441,26862,28183,33439,34072,34923,25591,28545,37394,39087,19978,20663,20687,20767,21830,21930,22039,23360,23577,23776,24120,24202,24224,24258,24819,26705,27233,28248,29245,29248,29376,30456,31077,31665,32724,35059,35316,35443,35937,36062,38684,22622,29885,36093,21959,63852,31329,32034,33394,29298,29983,29989,63853,31513,22661,22779,23996,24207,24246,24464,24661,25234,25471,25933,26257,26329,26360,26646,26866,29312,29790,31598,32110,32214,32626,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,n