
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
BUILDER_DIR=$DIR/builder
OUTPUT_DIR=$DIR/public
CMD="cd $BUILDER_DIR && python3 build.py"

# Run the command once
eval $CMD

# load a simple http server 
python3 -m http.server 8000 --directory $OUTPUT_DIR &
echo "Server running at http://localhost:8000"

echo "Watching $BUILDER_DIR for changes"
#  if macos use fswatch
if [ "$(uname)" == "Darwin" ]; then
    fswatch -0 $BUILDER_DIR | xargs -0 -n 1 -I {} sh -c "$CMD"
else
    inotifywait -m -r -e close_write $BUILDER_DIR | while read line; do
        $CMD
    done
fi

# kill the server
kill %1