""" Lazy loading attack page builder """

import common

### CONSTANTS
# ------------
# For firefox best distance is 700
LOADING_BOUNDARY_DIST = 1500
DETECTOR_WIDTH = 200
MAX_GROUPS_PER_ROW = 4


def get_network_img_groups(adblocker):
    """Get generic network groups with resource type image"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-network"
        ]
        if f.get("resource", False) == "image"
    ]


def get_iframe_groups(adblocker):
    """Get generic network groups with resource type iframe"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-network"
        ]
        if f.get("resource", False) == "iframe"
    ]


def get_css_class_group(adblocker):
    """Get the CSS class group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-cosmetic"
        ]
        if f.get("by", False) == "class"
    ]


def get_css_id_group(adblocker):
    """Get the CSS id group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-cosmetic"
        ]
        if f.get("by", False) == "id"
    ]


def split_to_chunks(groups: dict, k):

    out = []

    flat_pairs = [(k, v) for k in groups for v in groups[k]]

    for i in range(0, len(flat_pairs), k):

        end = i + k if i + k < len(flat_pairs) else len(flat_pairs)
        out.append(flat_pairs[i:end])

    for i, chunk in enumerate(out):

        _d = {
            "chunk_id": i,
        }

        for key, v in chunk:
            if key not in _d:
                _d[key] = []
            _d[key].append(v)

        out[i] = _d

    return out


def render(adblocker):
    """Render the attack page"""

    network_imgs = get_network_img_groups(adblocker)
    iframes = get_iframe_groups(adblocker)
    css_classes = get_css_class_group(adblocker)
    css_ids = get_css_id_group(adblocker)

    chunks = split_to_chunks(
        {
            "network_imgs": network_imgs,
            "iframes": iframes,
            "css_classes": css_classes,
            "css_ids": css_ids,
        },
        MAX_GROUPS_PER_ROW,
    )

    common.render_attack_template(
        f"lazy-loading-{adblocker}",
        "lazy-loading.html",
        service_worker="lazy-loading",
        # network_imgs=network_imgs,
        # iframes=iframes,
        # css_classes=css_classes,
        # css_ids=css_ids,
        chunks=chunks,
        loading_boundary_dist=LOADING_BOUNDARY_DIST,
        detector_width=DETECTOR_WIDTH,
        adblocker=adblocker,
    )
