""" This module is responsible for rendering the image-alt attack template. """

import common


def get_css_class_group(adblocker):
    """Get the CSS class group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-cosmetic"
        ]
        if f.get("by", False) == "class"
    ]


def get_css_id_group(adblocker):
    """Get the CSS id group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-cosmetic"
        ]
        if f.get("by", False) == "id"
    ]


def get_network_iframe_groups(adblocker):
    """Get generic network groups with resource type iframe"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-network"
        ]
        if f.get("resource", False) == "iframe"
    ]


def get_network_img_groups(adblocker):
    """Get generic network groups with resource type image"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]["lazy-image-and-animation"][
            "generic-network"
        ]
        if f.get("resource", None) == "image"
    ]


def render(adblocker):
    """Render the attack page"""

    css_classes = get_css_class_group(adblocker)
    css_ids = get_css_id_group(adblocker)
    network_iframes = get_network_iframe_groups(adblocker)
    network_imgs = get_network_img_groups(adblocker)

    common.render_attack_template(
        f"container-query-{adblocker}",
        "container-query.html",
        service_worker="container-query",
        css_classes=css_classes,
        css_ids=css_ids,
        network_iframes=network_iframes,
        network_imgs=network_imgs,
        adblocker=adblocker,
    )
