""" Common functions for building the pages """

import json
import os
from pathlib import Path
from typing import Optional
from jinja2 import Environment, PackageLoader, select_autoescape

__dir__ = Path(os.path.dirname(os.path.abspath(__file__)))

output_dir = __dir__ / "../public"

ADBLOCKER_DATA = {
    "adguard": json.loads(open(__dir__ / "data/adguard.json", encoding="utf-8").read()),
    "ublock": json.loads(open(__dir__ / "data/ublock.json", encoding="utf-8").read()),
}
env = Environment(loader=PackageLoader("common"), autoescape=select_autoescape())


def get_template(template_name):
    """Get the template object from a given name

    Args:
        template_name (str): The name of the template file

    Returns:
        jinja2.Template: The template object
    """

    return env.get_template(template_name)


def render_attack_template(
    attack_name, template_name, service_worker: Optional[str] = None, **kwargs
):
    """Render the attack template and save it to the output directory

    Args:
        attack_name (str): The name of the attack
        template (jinja2.Template): The template object
        service_worker (str): The name of the service worker to use
        **kwargs: The arguments to pass to the template
    """
    service_worker = service_worker or attack_name

    rendered = get_template(template_name).render(attack_name=attack_name, **kwargs)

    os.makedirs(output_dir / f"attacks/{attack_name}", exist_ok=True)

    with open(
        output_dir / f"attacks/{attack_name}/index.html", "w", encoding="utf-8"
    ) as f:
        f.write(rendered)

    # copy the service worker to the same directory
    os.system(
        f"cp {__dir__}/services/{service_worker}.js {output_dir}/attacks/{attack_name}/service-worker.js"
    )
