#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/kprobes.h>
#include <linux/version.h>
#include <linux/efi.h>
#include <asm/uaccess.h>
#include <linux/uaccess.h>

/* forward declarations */
void *lookup_kallsyms_lookup_name(void);
static ssize_t proc_read(struct file* filep, char* __user buffer, size_t len, loff_t* offset);
static ssize_t proc_write(struct file* filep, const char* __user u_buffer, size_t len, loff_t* offset);
static int proc_open(struct inode *inode, struct file *filep);
static long proc_ioctl(struct file *, unsigned int, unsigned long);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5,5,0)
static struct proc_ops fops = {
    .proc_open = proc_open,
    .proc_read = proc_read,
    .proc_write = proc_write,
    .proc_ioctl = proc_ioctl,
};
#else
static struct file_operations fops = {
    .owner = THIS_MODULE,
    .open = proc_open,
    .read = proc_read,
    .write = proc_write,
};
#endif


// https://nskernel.gitbook.io/kernel-play-guide/accessing-the-non-exported-in-modules
void *lookup_kallsyms_lookup_name(void)
{
    struct kprobe kp;
    unsigned long addr;    memset(&kp, 0, sizeof(struct kprobe));
    kp.symbol_name = "kallsyms_lookup_name";
    if (register_kprobe(&kp) < 0) {
        return 0;
    }
    addr = (unsigned long)kp.addr;
    unregister_kprobe(&kp);
    return (void*)addr;
}

static int proc_open(struct inode *inode, struct file *filep)
{
    pr_info("[%s]: open\n", THIS_MODULE->name);
    return 0;
}

static ssize_t proc_read(struct file* filep, char* __user buffer, size_t len, loff_t* offset)
{
    return 0;
}

static ssize_t proc_write(struct file* filep, const char* __user u_buffer, size_t len, loff_t* offset)
{
    return 0;
}

static ssize_t proc_ioctl(struct file* filep, unsigned int cmd, unsigned long arg)
{
    //pr_info("[%s]: ioctl\n", THIS_MODULE->name);
    switch (cmd) {
        case 1337: // gets physbase
            unsigned long (*lookup_name)(const char *name) = lookup_kallsyms_lookup_name();
            uint64_t *phys_base_sym = (uint64_t *)lookup_name("page_offset_base");
            uint64_t phys_base = *phys_base_sym;
            put_user(phys_base, (uint64_t __user *)arg);
            break;
        case 1338: // arbitrary read
            struct arb_read_req {
                __user uint64_t *src;
                __user uint64_t *dst;
            };
            struct arb_read_req req = {0};
            struct arb_read_req __user *user_req = (struct arb_read_req __user *)arg;
            get_user(req.src, &user_req->src);
            get_user(req.dst, &user_req->dst);
            put_user(*req.src, req.dst);
            break;
        case 1339: // arbitrary call
            void (*target)(void) = (void (*)(void))arg;
            target();
            break;
        case 1340: // get kernel gsbase
            uint64_t gsbase = rdgsbase();
            put_user(gsbase, (uint64_t __user *)arg);
            break;
    };

    return 0;
}

static int __init proc_init(void)
{
    struct proc_dir_entry *new;
    new = proc_create("dbg-mod", 0777, NULL, &fops);
    pr_info("[%s]: init\n", THIS_MODULE->name);
    return 0;
}

static void __exit proc_exit(void)
{
    remove_proc_entry("dbg-mod", NULL);
    pr_info("[%s]: exit\n", THIS_MODULE->name);
}

/* entry/exit points of the module */
module_init(proc_init);
module_exit(proc_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("zolutal");
MODULE_DESCRIPTION("does things");
MODULE_VERSION("0.1");
