#!/usr/bin/env python3
from time import sleep
import subprocess
import nclib
import sys
import os

QEMU_SERIAL_PORT=1337
QEMU_MONITOR_PORT=1338

def error(message, vm):
    os.killpg(os.getpgid(vm.pid), 9)
    print(message)
    exit(1)

def start_vm():
    args = f"""
        qemu-system-x86_64 \
        -snapshot \
        -m 4G \
        -nographic \
        -enable-kvm \
        -cpu kvm64,+fsgsbase,+smep,+smap,+avx,+avx2,+xsave,+topoext \
        -kernel ./images/vmlinuz \
        -smp sockets=1,cores=4,threads=2 \
        -drive file=./images/bookworm.img,format=raw \
        -append "nokaslr nopti nopml5 root=/dev/sda rw console=ttyS0 panic=0 quiet net.ifnames=0" \
        -serial tcp::{QEMU_SERIAL_PORT},server \
        -monitor tcp::{QEMU_MONITOR_PORT},server,nowait
    """
    vm = subprocess.Popen(
        args,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        preexec_fn=os.setsid,
        shell=True
    )
    return vm

def serial_login(serial):
    serial_out = serial.recvuntil(b'login:', timeout=30)
    print(serial_out.decode())
    serial.sendline(b"user")
    serial_out = serial.recvuntil(b':~$', timeout=30)
    print(serial_out.decode())
    print("LOGGED IN")

def serial_run_exploit(serial):
    serial.sendline("./exp")
    out = b""
    iterations = 0
    while iterations < 30:
        iterations += 1
        #serial_out = serial.recvuntil('flag{privesc_successful}', timeout=30)
        out += serial.recvall(timeout=1)
        if b"flag{privesc_successful}" in out:
            try:
                print("OUT\n", out.decode())
            except:
                pass
            print("SUCCESS")
            return True
        elif b"PANIC" in out or b"OOPS" in out or b"segfault" in out or b"BUG" in out:
            try:
                print("OUT\n", out.decode())
            except:
                pass
            print("FAILED")
            return False
    try:
        print("OUT\n", out.decode())
    except:
        pass
    return False

if __name__ == "__main__":
    dir = sys.argv[1]
    os.system(f"cd {dir}/exploit; gcc -static exploit.c -o exp")
    os.system(f"cd {dir}/mod; make")
    os.system(f"./addfile.sh ./{dir}/mod/dbg.ko")
    os.system(f"./addfile.sh ./{dir}/exploit/exp")

    os.system("pkill qemu-system-x86")

    vm = start_vm()
    serial = nclib.Netcat(('localhost', QEMU_SERIAL_PORT), retry=50)

    serial_login(serial)
    if serial_run_exploit(serial):
        os.killpg(os.getpgid(vm.pid), 9)
        exit(0)
    os.killpg(os.getpgid(vm.pid), 9)
    exit(1)
