#!/bin/bash

set -ex

./addfile.sh ./$1/mod/dbg.ko
./addfile.sh ./$1/exploit/exp

taskset -c 0-8 \
qemu-system-x86_64 \
    -snapshot \
    -gdb tcp::1234 \
    -enable-kvm \
    -cpu kvm64,+fsgsbase,+smep,+smap,+avx,+avx2,+xsave,+topoext \
    -smp sockets=1,cores=4,threads=2 \
    -m 4G \
    -kernel ./images/vmlinuz \
    -drive file=./images/bookworm.img,format=raw \
    -append "nokaslr nopti root=/dev/sda rw console=ttyS0 panic=0 quiet net.ifnames=0" \
    -nographic \
    -net user,host=10.0.2.10,hostfwd=tcp:127.0.0.1:10021-:22 \
    -net nic,model=virtio \
    -monitor /dev/null
    #-cpu qemu64,+fsgsbase,+smep,+smap \
    #-cpu host,+topoext \
