/**********************************
*
*  An intentionally vulnerable Linux kernel module
*
***********************************/

#include <linux/init.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/slab.h>
#include <linux/ioctl.h>

#include <asm/uaccess.h>

#define DEVICE_NAME "vuln"
#define DEVICE_CLASS_NAME "vuln_dev"

// define commands
#define IOCTL_BASE 'W'
#define	CMD_READ		_IO(IOCTL_BASE, 0)
#define	CMD_WRITE		_IO(IOCTL_BASE, 1)
#define	CMD_MTE_TEST	_IO(IOCTL_BASE, 2)

/***************************************
 *
 * structs and global variables
 *
 ***************************************/

/* global variables */
static struct class *vuln_class;
static int major_num;
static struct file_operations file_ops;

/***************************************
 *
 * device driver code
 *
 ***************************************/

typedef struct request {
	void*	ubuf;
	size_t	size;
} request_t;

static int vuln_open(struct inode *inode, struct file *file)
{
	printk(KERN_INFO "vulnerable device is opened\n");
	return 0;
}

static int vuln_release(struct inode *inode, struct file *file)
{
	printk(KERN_INFO "vulnerable device is closed\n");
	return 0;
}

static long vuln_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	char buf[0x10] = {0};
	request_t req;
	void *addr;

	printk(KERN_INFO "vuln_ioctl called with cmd: %d, arg: 0x%lx\n", cmd, arg);

	if (copy_from_user(&req, (void*)arg, sizeof(request_t)))
		return -EINVAL;

	switch(cmd) {
		case CMD_READ:
			return _copy_to_user(req.ubuf, buf, req.size);
		case CMD_WRITE:
			return _copy_from_user(buf, req.ubuf, req.size);
		case CMD_MTE_TEST:
			addr = kmalloc(0x10, GFP_KERNEL);
			printk(KERN_INFO "MTE_TEST! %llx\n", (u64)addr);
			memset(addr+0x10, 0, 1);
			return 0;
		default:
			return -EINVAL;
	}

	return -EINVAL;
}

static struct file_operations file_ops = { 
	.unlocked_ioctl = vuln_ioctl,
	.open = vuln_open,
	.release = vuln_release
};

/***************************************
 * 
 * kernel module related code
 *
 **************************************/
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("An intentionally vulnerable kernel module");
MODULE_VERSION("0.01");

static int __init vuln_init(void)
{
	printk(KERN_INFO "vulnerable module initialization\n");

	// this registers 0x100 minor numbers
	major_num = register_chrdev(0, DEVICE_NAME, &file_ops);
	if(major_num < 0) {
		printk(KERN_WARNING "Fail to get major number");
		return -EINVAL;
	}

	/* populate a device node */
	vuln_class = class_create(THIS_MODULE, DEVICE_CLASS_NAME);
	device_create(vuln_class, NULL, MKDEV(major_num, 0), NULL, DEVICE_NAME);

	return 0;
}

static void __exit vuln_exit(void)
{
	printk(KERN_INFO "vulneralbe module destruction\n");

	// destory the device node first
	device_destroy(vuln_class, MKDEV(major_num, 0));

	// destroy the device class
	class_destroy(vuln_class);

	// unregister chrdev
	unregister_chrdev(major_num, DEVICE_NAME);
}

module_init(vuln_init);
module_exit(vuln_exit);
