#!/bin/bash

if [ ! $# -eq 2 ]; then
    echo "Usage: $0 <exploit_name> <exploit_environment>"
    exit 1
fi

exploit_name=$1
exploit_environment=$2

if [ ! -d "exploits/$exploit_name/" ]; then
    echo "The exploit '$exploit_name' does not exist in 'exploits'."
    exit 1
fi

if [ ! -d "exploits/$exploit_name/exploit/$exploit_environment" ]; then
    echo "The exploit '$exploit_name1/exploit/$exploit_environment' does not exist in 'exploits'."
    exit 1
fi

RELEASE=$exploit_environment

if [ "$RELEASE" == "mitigation-6.1" ];
    then RELEASE="mitigation-6.1-v2";
fi

TAG="exploit-$exploit_name-$exploit_environment"
TAG="${TAG,,}" # docker wants lowercase tags


mkdir -p assets

pushd assets
    if [ ! -f "./$RELEASE/bzImage" ]; then
        mkdir -p ./$RELEASE
        wget -O ./$RELEASE/bzImage "https://storage.googleapis.com/kernelctf-build/releases/$RELEASE/bzImage"
    fi

    if [ ! -f "./rootfs.img" ]; then
        wget -O rootfs.img.gz https://storage.googleapis.com/kernelctf-build/files/rootfs_repro_v2.img.gz
        gzip -d ./rootfs.img.gz
    fi

    if [ ! -f "./init.sh" ]; then
        wget -O init.sh https://raw.githubusercontent.com/google/security-research/master/kernelctf/repro/init/init.sh
        chmod +x init.sh
    fi
popd


docker build \
    --build-arg exploit_name=$exploit_name \
    --build-arg exploit_environment=$exploit_environment \
    --build-arg kernelctf_release=$RELEASE \
    -t $TAG \
    -f docker/exploit-run.dockerfile .

docker run --privileged $TAG
