#!/bin/bash

EXPLOIT_TYPE=$1

if [[ -z "$EXPLOIT_TYPE" ]]; then
  echo "Error: Exploit Type is required."
  usage
elif [[ "$EXPLOIT_TYPE" != "modified" && "$EXPLOIT_TYPE" != "original" ]]; then
  echo "Error: Exploit Type must be 'modified' or 'original'."
  exit 1
fi

./build.sh $EXPLOIT_TYPE

declare -A CVE_LIST=(
  ["CVE-2024-26925_lts_cos"]="lts-6.1.81"
  ["CVE-2023-6817_lts_cos"]="lts-6.1.63"
  ["CVE-2024-1085_lts"]="lts-6.1.70"
  ["CVE-2023-6111_lts"]="lts-6.1.60"
  ["CVE-2023-4623_lts_cos"]="lts-6.1.36"
)

OUTPUT_FILE=$EXPLOIT_TYPE"_eval_results.log"

> "$OUTPUT_FILE"

# run each exploit 50 times and count successes
for CVE in "${!CVE_LIST[@]}"; do
  SUCCESS_COUNT=0

  for i in {1..50}; do
    echo "Running $CVE iteration $i..."
    ./run-one.sh "$CVE" "${CVE_LIST[$CVE]}"

    if [[ $? -eq 0 ]]; then
      ((SUCCESS_COUNT++))
    fi
  done

  echo "$CVE: $SUCCESS_COUNT/50" >> "$OUTPUT_FILE"
done

echo "Done. Results can be found in in $OUTPUT_FILE."
