#!/bin/bash

set -e

for EXPLOIT_DIR in exploits/*; do
    METADATA_FILE="$EXPLOIT_DIR/metadata.json"

    if [[ -f "$METADATA_FILE" ]]; then
        jq -r '.exploits[].environment' "$METADATA_FILE" | while read -r release_name; do
            echo "$release_name"
            ./run-one.sh $(basename ${EXPLOIT_DIR}) $release_name || true
        done
    else
        echo "No metadata.json found in $CVE_FOLDER"
    fi
done

